/*
By: John van Sickle

  This macro creates a box with all of its edges and corners rounded. It fills
the same space as box { Startcorner,EndCorner }, except that the edges and
corners are rounded. StartCorner and EndCorner are opposite corners of the box,
and Radius is the radius of the rounded edges.

The box is made up of three box objects, twelve cylinder objects, and eight
sphere objects. There is no merge or union declared around them, to leave the
choice up to the user; merge is better for applications with transparency,
union is better for others. Here is an example:

union {
  RoundedBox(<-10,0,0>,<10,40,20>,2)
  pigment { rgb .75 }
}

Although the example code uses vector literals for StartCorner and EndCorner,
you can use any vector expression, and scalars will be promoted to
full vectors.

*/



#macro RoundedBox(v_SP,v_EP,R)
  #local vSP=(v_SP)*<1,1,1>;
  #local vEP=(v_EP)*<1,1,1>;
#if (vSP.x > vEP.x)
  #local tSave=vSP.x;
  #local vSP=<vEP.x,vSP.y,vSP.z>;
  #local vEP=<tSave,vEP.y,vEP.z>;
#end
#if (vSP.y > vEP.y)
  #local tSave=vSP.y;
  #local vSP=<vSP.x,vEP.y,vSP.z>;
  #local vEP=<vEP.x,sSave,vEP.z>;
#end
#if (vSP.z > vEP.z)
  #local tSave=vSP.z;
  #local vSP=<vSP.x,vSP.y,vEP.z>;
  #local vEP=<vEP.x,vEP.y,tSave>;
#end

  box {<vSP.x,vSP.y+R,vSP.z+R>,<vEP.x,vEP.y-R,vEP.z-R>}
  box {<vSP.x+R,vSP.y,vSP.z+R>,<vEP.x-R,vEP.y,vEP.z-R>}
  box {<vSP.x+R,vSP.y+R,vSP.z>,<vEP.x-R,vEP.y-R,vEP.z>}

  #local vSP=vSP+R;
  #local vEP=vEP-R;

  sphere { <vSP.x,vSP.y,vSP.z>,R}
  sphere { <vEP.x,vSP.y,vSP.z>,R}
  sphere { <vSP.x,vEP.y,vSP.z>,R}
  sphere { <vEP.x,vEP.y,vSP.z>,R}
  sphere { <vSP.x,vSP.y,vEP.z>,R}
  sphere { <vEP.x,vSP.y,vEP.z>,R}
  sphere { <vSP.x,vEP.y,vEP.z>,R}
  sphere { <vEP.x,vEP.y,vEP.z>,R}

  cylinder { <vSP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vSP.z>,R }
  cylinder { <vSP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
  cylinder { <vSP.x,vSP.y,vEP.z>,<vEP.x,vSP.y,vEP.z>,R }
  cylinder { <vSP.x,vEP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
  cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vEP.y,vSP.z>,R }
  cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
  cylinder { <vSP.x,vSP.y,vEP.z>,<vSP.x,vEP.y,vEP.z>,R }
  cylinder { <vEP.x,vSP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
  cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vSP.y,vEP.z>,R }
  cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vEP.z>,R }
  cylinder { <vSP.x,vEP.y,vSP.z>,<vSP.x,vEP.y,vEP.z>,R }
  cylinder { <vEP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vEP.z>,R }
#end

#macro HalfRoundedBox(v_SP,v_EP,R)
  #local vSP=(v_SP)*<1,1,1>;
  #local vEP=(v_EP)*<1,1,1>;
#if (vSP.x > vEP.x)
  #local tSave=vSP.x;
  #local vSP=<vEP.x,vSP.y,vSP.z>;
  #local vEP=<tSave,vEP.y,vEP.z>;
#end
#if (vSP.y > vEP.y)
  #local tSave=vSP.y;
  #local vSP=<vSP.x,vEP.y,vSP.z>;
  #local vEP=<vEP.x,sSave,vEP.z>;
#end
#if (vSP.z > vEP.z)
  #local tSave=vSP.z;
  #local vSP=<vSP.x,vSP.y,vEP.z>;
  #local vEP=<vEP.x,vEP.y,tSave>;
#end

  box {<vSP.x,vSP.y,vSP.z+R>,<vEP.x,vEP.y-R,vEP.z-R>}
  box {<vSP.x+R,vSP.y,vSP.z+R>,<vEP.x-R,vEP.y,vEP.z-R>}
  box {<vSP.x+R,vSP.y,vSP.z>,<vEP.x-R,vEP.y-R,vEP.z>}

  #local vSP=vSP+<R,0,R>;
  #local vEP=vEP-R;

/*  sphere { <vSP.x,vSP.y,vSP.z>,R}
  sphere { <vEP.x,vSP.y,vSP.z>,R}*/
  sphere { <vSP.x,vEP.y,vSP.z>,R}
  sphere { <vEP.x,vEP.y,vSP.z>,R}
/*  sphere { <vSP.x,vSP.y,vEP.z>,R}
  sphere { <vEP.x,vSP.y,vEP.z>,R}*/
  sphere { <vSP.x,vEP.y,vEP.z>,R}
  sphere { <vEP.x,vEP.y,vEP.z>,R}

/*  cylinder { <vSP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vSP.z>,R }*/
  cylinder { <vSP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
/*  cylinder { <vSP.x,vSP.y,vEP.z>,<vEP.x,vSP.y,vEP.z>,R }*/
  cylinder { <vSP.x,vEP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
  cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vEP.y,vSP.z>,R }
  cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vEP.y,vSP.z>,R }
  cylinder { <vSP.x,vSP.y,vEP.z>,<vSP.x,vEP.y,vEP.z>,R }
  cylinder { <vEP.x,vSP.y,vEP.z>,<vEP.x,vEP.y,vEP.z>,R }
/*  cylinder { <vSP.x,vSP.y,vSP.z>,<vSP.x,vSP.y,vEP.z>,R }*/
/*  cylinder { <vEP.x,vSP.y,vSP.z>,<vEP.x,vSP.y,vEP.z>,R }*/
  cylinder { <vSP.x,vEP.y,vSP.z>,<vSP.x,vEP.y,vEP.z>,R }
  cylinder { <vEP.x,vEP.y,vSP.z>,<vEP.x,vEP.y,vEP.z>,R }
#end
