#version unofficial megapov 0.7;

#declare test_cintreloin_inc = off;


#declare Cintre1 = mesh {
	#include "cintre1.msh"
	texture {
		pigment {
			wood
			turbulence .05
			frequency 2
			rotate y*90 translate 10*y
			color_map {
				[.2 color rgb <0.867,0.773,0.514>]
				[.5 color rgb <0.796,0.486,0.000>]
				[.9 color rgb <0.796,0.663,0.459>]
			}
		}
	finish { phong 0.3 phong_size 5 }
	}
}

#declare Cintre2 = mesh {
	#include "cintre2.msh"
	texture {
		pigment { rgb .35 }
		finish { reflection .7 specular 5 roughness .01 }
	}
}

#declare Loin1 = mesh {
	#include "loin1.msh"
	texture {
		pigment {
			gradient -x+y
			frequency 3
			scale .6
			translate 10*x
			color_map {
				[0 color rgb <0.522,0.388,0.024>]
				[.5 color rgb <0.910,0.776,0.133>]
				[1 color rgb <0.522,0.388,0.024>]
			}
		}
		normal {
			average
			normal_map {
				[1 wrinkles 2 scale .2]
				[1 gradient -x+y frequency 3 scale .6 translate 10*x ]
			}
		}
	}
}

#declare Loin2 = mesh {
	#include "loin_s.msh"
	uv_mapping
}

#macro Loin(Col1, Col2, Col3, Rnd)

#local St = seed(Rnd);

union {
object { Cintre1 }
object { Cintre2 translate 4.8*y +.3*x }
object { Loin1 translate -.3*y}
object {
	Loin2
	#local P_Trans = pigment {
		gradient x*1.001
		translate -.0005*x
		pigment_map {
			#local i=0;
			#while (i<=1)
				[i planar turbulence <0,.1,0> scale <.07, 1,1> translate i*x*rand(St) color_map {[1-.8*pow(2*i-1, 2) rgb 1][1-.8*pow(2*i-1, 2) rgb 0]} ]
				#local i=i+.02;
			#end
		}
	}
	#local P_Pig = pigment {
		leopard
		scale 10
		warp {turbulence 5 lambda 9 }
		scale 0.05/10
		warp {turbulence .3 lambda 2 }
		scale .08*<.3, .5, .3>/.05
		color_map {
			[0.10 rgb Col1 ]
			[0.30 rgb Col2 ]
			[0.40 rgb Col2 ]
			[0.45 rgb Col3 ]
		}
		translate 5*rand(St)
	}
	texture {
		pigment {
			pigment_pattern { P_Trans }
			pigment_map {
				[0.5 rgbf 1 ]
				[0.5 P_Pig]
			}
		}
		normal { wrinkles .6 scale .1 }
	}
}
	scale 2.3
	translate -15.5*y-1.3*x
}
#end



#if (test_cintreloin_inc)


background { color rgb <0, 0, 0> }

camera {
	location <6.989, 3.298, -60.977>
	angle 40
	look_at <0.000, -18.573, -0.252>
//	rotate -y*75
}

light_source { < 0, 100, -200 >*10 color rgb <1, 1, 1> }
light_source { < 200, 10, 0 >*10 color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 >*10 color rgb <0.4, 0.25, 0.25> }

cylinder { -10*z, 10*z, 1 pigment { rgb .9 } }



#macro WriteClothFile(nomfile, n1, n2, nlng, ks, xo, yo, zo)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = .85*nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = xo -l1/2 + i*nlng*.85;
			#local tempy = yo -l2/2 + (j*nlng);
            #local tempz = zo;
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#write(file, 0*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 4*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 9*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 14*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 19*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 24*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 29*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 34*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 39*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 44*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 49*40+39, ", 0.0, 0.0, 0.0,\n")

	#fclose file
#end

/* save changes */
#macro ReWriteRideau(filename)

	#debug "\nRe-Writing .cth file\n"

	#fopen file filename write
	#write(file, 50, ",", 40, ",", 12/50, ",", 30, ",\n")

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = Points[i][j].x;
			#local tempy = Points[i][j].y;
            #local tempz = Points[i][j].z;
			#local vx = Vel[i][j].x;
			#local vy = Vel[i][j].y;
            #local vz = Vel[i][j].z;
			#write(file, tempx, ",", tempy, ",", tempz, ", ", vx, ",", vy, ",", vz, ",\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#write(file, 0*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 4*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 9*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 14*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 19*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 24*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 29*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 34*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 39*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 44*40+39, ", 0.0, 0.0, 0.0,\n")
	#write(file, 49*40+39, ", 0.0, 0.0, 0.0,\n")

	#fclose file
#end


#macro ReadAllClothFile(nomfile)

	#debug "Reading ALL cloth file...\n"

	#fopen file nomfile read
	#declare n1=0;
	#declare n2=0;
	#local temp=0;
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#read(file, n1, n2, temp, temp)

	#declare Points = array[n1][n2]
	#declare Vel = array[n1][n2]

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#read(file, tempx, tempy, tempz, vx, vy, vz)
			#declare Points[i][j] = <tempx, tempy, tempz>;
			#declare Vel[i][j] = <vx, vy, vz>;
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


//WriteClothFile("loin.cth", 50, 40, 12/50, 20, 0, -4.5, -1.2)

/*
  ReadAllClothFile("loin.cth")

  #declare Points[9][39] = Points[9][39]-.1*y;
  #declare Points[14][39] = Points[14][39]-.2*y;
  #declare Points[19][39] = Points[19][39]-.3*y;
  #declare Points[24][39] = Points[24][39]-.4*y;
  #declare Points[29][39] = Points[29][39]-.3*y;
  #declare Points[34][39] = Points[34][39]-.2*y;
  #declare Points[39][39] = Points[39][39]-.1*y;

  ReWriteRideau("loin.cth")
*/
/*
simcloth {
	gravity     -0.2*y

	neighbors   1
	internal_collision off
	damping     0.85
	intervals   0.07
	iterations  1000

	input       "loin.cth"
	output      "loin.cth"
	mesh_output "loin_s.msh"
	smooth_mesh on
	uv_mesh     on
}
*/



object {
	Loin(<0.855,0.796,0.506>, <0.99,0.98,0.97>, <0.494,0.416,0.294>, 1234)
	scale 2.3
	translate -15.5*y-1.3*x

}

#end

