/* title */
//comment (witticism)


#version Unofficial Megapov 0.7;


#declare boSideView = false; //render orthographic view of the dark side, for use in positioning lights.


#declare nMediaIntervals = 6;//8;//3; //8//20
#declare nMediaSamples = 4; //4//20

#declare fEarthRad = 15000;//50000;//

//camera positioning stuff that went a bit mad but I liked the result!
#declare gShiftx = -1 -2.0;//
#declare gShiftz = 2.5-2.0*sqrt(3);//1.7;//
#declare gRoty = 60;//45;

//sky colours:
//<0.1,0.3,1> - pretty good blue sky, v. yellow sunsets.
//<0.3,0.7,1> - nice hazy brown sunset. (density 7, clock 0.05)
//with polywave:
//<0.08,0.13,1> - nice blue, yellow sunsets again.
//<0.2,0.32,1> - blue blue blue

//#declare SkyColour = <0.2,0.32,1>;
//#declare fDensityFactor = 2;//5
//#declare fSkyHeight = 50000;//20000
#declare SkyColour = <0.2,0.32,1>;
#declare fDensityFactor = .7;//1//.7
#declare fSkyHeight = 100000;//80000//100000

#declare fStratusCloudHeight = 15000;//15000;
#declare fCumulusCloudHeight = 1000;//1500;
#declare boLowClouds = on;

#declare fWaterHeight = -500;//-50;
#declare fSkyCutBack = fSkyHeight;//2000; //if = fSkyHeight => not cut. 0 => cut to ground.

#declare nRidgeLOD = 5;//5//6 maybe too much

#declare bmod = 4;
#declare _clock = 0.8; //set to clock if animating
//#declare light_loc = <0,10*fEarthRad*sin(pi*_clock)-fEarthRad,10*fEarthRad*cos(pi*_clock)>;
#declare light_loc = <0,sin(pi*_clock),cos(pi*_clock)>;
#declare light_loc = <light_loc.y/sqrt(2),light_loc.y/sqrt(2),light_loc.z>;
#declare light_loc = <light_loc.x/sqrt(2)+light_loc.z/sqrt(2),light_loc.y,-light_loc.x/sqrt(2)+light_loc.z/sqrt(2)>;
#declare light_loc = 10*fEarthRad*light_loc - fEarthRad*y;


global_settings {
	assumed_gamma 1.0
	#if (!boSideView)
		ini_option "+QR"// mountain: +SC1068 +SR868 +EC1404 +ER1242" 
	#else
		ini_option "+QR +W256 +H256"
	#end
	radiosity
	{
		normal on
		media on
		//recursion_limit 2
/*
		pretrace_start 0.08 pretrace_end 0.01
		count 500 nearest_count 4
		error_bound 0.05 recursion_limit 1 //??? so low!
		low_error_factor 0.05 gray_threshold 0
		minimum_reuse 0.015 brightness 1
		max_sample 1 adc_bailout 0.01 normal off
*/
	}
	max_trace_level 5//20
	
	post_process {
/*	  curves {
	    all
	    spline {
	      linear_spline
	      0, 0
	      0.29698, 0.03529
	      0.70134, 0.97815
	      1, 1
	    }
	  }*/
	  focal_blur {
	  	12*fEarthRad/10, fEarthRad/5, 8, 1//640 => 6, 1
	  }
	  /*soft_glow {
	  	0.7, 3//640 => 6
	  }*/
	}
}


#include "cumulus.inc"


#default {
	finish {
		ambient 0
	}
}

#if (!boSideView)
	camera {
		right			x*image_width/image_height
		up				y
		direction	z*0.6
		
		location <0,1,-13>
		look_at <0,2,0>
	
		rotate <0,0,45>
		rotate <0,60,0>
		translate <-3300+10000*gShiftx,2,2300-200+10000*gShiftz>//<-0.14*fEarthRad,800,fEarthRad+700>
		rotate <0,gRoty,0>
	}
#else
	camera {
		orthographic
	
		right			-x*fEarthRad*2
		up				y*fEarthRad*2
		direction	-z
		
		location <0,-fEarthRad,fEarthRad*2>
	}
#end


#if (boSideView)
	light_source {
		fEarthRad*10*z
		rgb bmod
		shadowless
	}
#else
	light_source {
		light_loc
		rgb bmod*1.1//1.2//0.9//*0.8
		area_light x*fEarthRad/5,z*fEarthRad/5,3,3//16,16
		adaptive 0
		jitter
		orient
	}
	
	
/*	//I want a bit more detail in the shadows ...which is why I've put loads of town lights there and removed this!
	light_source {
		light_loc
		rgb bmod*0.3
		shadowless
	}
	
	
	light_source {
		-light_loc
		rgb bmod*0.005
		shadowless
	}*/
#end //#if (boSideView)


glow {
	type 1
	location light_loc
	size fEarthRad/10
	fade_power 2
	colour rgb bmod
}


#declare dtex =
	texture {
		pigment { rgb 1 }
		finish {
			diffuse 1/bmod
			ambient 0
		}
	}


#if (!boSideView)

	box {
		<-(fEarthRad+fSkyCutBack)/(fEarthRad+fSkyHeight),-1,-1>, <1,1,1>
		scale  fEarthRad+fSkyHeight
		hollow on
		material {
			texture {
				pigment {
					rgbt <1,1,1,1>
				}
				finish {
					ambient 0
					diffuse 1/bmod
				}
			}
			interior {
				media {
					scattering {
						1, rgb SkyColour
						extinction 1
					}

					method 3//2
					aa_level 4//2
					aa_threshold 0.2
					intervals nMediaIntervals
					samples 3,nMediaSamples
				  confidence 0.99
				  variance 1.0/256.0
				  
				  density {
	//			  	spherical
						boxed
	//					poly_wave 5
				  	density_map {
				  		[0 rgb 0.00000]
				  		[(fSkyHeight/(fEarthRad+fSkyHeight))
				  			rgb 0.00001*fDensityFactor]
	//			  		[1 rgb 0.0010*fDensityFactor]//.0015
				  	}
				  	scale fEarthRad+fSkyHeight
				  }
				}
			}
		}
	
		translate <0,-fEarthRad,0>
	}
	
#end //#if (!boSideView)


#declare esphere =
	sphere {
		<0,0,0>, fEarthRad
	}
	


#declare stdf =
	finish {
		diffuse 1/bmod
		ambient 0
	}
	
#declare grass_green = rgb <0.0,0.8,0>;
#declare bilious_green = rgb <0.4,0.9,0>;

//basic types of surface
#declare sludget		= texture { pigment { rgb <0.5,0.6,0.5> } finish { stdf } }
#declare wetlandt		= texture { pigment { rgb <0.0,0.3,0.0> } finish { stdf } }
#declare sandt			= texture { pigment { rgb <1.0,0.9,0.3> } finish { stdf } }
#declare rockt			= texture { pigment { rgb <0.5,0.45,0.6> } finish { stdf } }

#declare snowt			= //texture { pigment { rgb <1,1,1> } finish { stdf } }
  texture {
    pigment { rgb <0.8, 0.9, 1.0> }
    normal {
      bozo 0.1
      scale 0.0001
    }
    finish {
      ambient 0 //DOH! rgb <0.3, 0.4, 0.6>
      diffuse bmod
      specular 1.0
      roughness 0.3
    }
  }

#declare grasst =
	texture {
		pigment {
			//rgb <0,0.8,0>
			crackle
			solid
			scale 10/10000
			colour_map {
				[0.0 grass_green]
				[1.0 bilious_green]
			}
		}
		finish {
			diffuse 1/bmod
			ambient 0
			specular 1/bmod roughness 0.05
		}
		normal {
			facets coords 1.5//2
			scale 10/10000
		}
	}

//pigements for regions
#declare seabedt		= sludget
#declare beacht			=
	texture {
		bozo
		scale 6000 //I think I forgot to divide this by 10000!!!
		translate <-0.2,3,0>
		turbulence 0.18
		texture_map {
			[0.5 sandt]
			[0.7 wetlandt]
		}
	}
#declare plainst		= grasst
#declare mountaint	= rockt
#declare peakt			= snowt
/*#declare peakt			=
	texture {
		bozo
		scale 80/10000
		texture_map {
			[0.7 snowt]
			[0.7 mountaint]
		}
	}*/

#declare groundt =
	texture {
		bozo
		turbulence 0.4
		translate <0,4,0.7>
		scale 0.6*fEarthRad/10000
		warp {
			turbulence 0.5//0.8
			octaves 5
//			omega 0.6
		}
		scale 30
		warp {
			turbulence 2
			octaves 6
		}
		scale 1/30
		rotate <0,-20,0>
		rotate <-54,0,0>
//		rotate <0,180,0>
		warp { reset_children }
		texture_map {
			[0.00	seabedt]		//sea bed
			[0.45	beacht]			//beaches
			[0.52	plainst]		//grassy hills
			[0.59	plainst]		//grassy hills
			[0.60	mountaint]	//mountain
			[0.63	mountaint]	//mountain
			[0.64	peakt]			//mountain tops
		}
		translate <gShiftx,0,gShiftz>
		rotate <0,gRoty,0>
		/*
		// debug hot colours:
		pigment_map {
			[0.0	rgb <1,1,0>]
			[0.3	rgb <0,1,1>]
			[0.5	rgb <0,1,0>]
			[0.7	rgb <1,0,0>]
			[1.0	rgb <1,0,1>]
		}*/
	}

#declare boxf =
	function {
		max(max(abs(x),abs(y)),abs(z)) - fEarthRad/10000
		//sqrt(sqr(x)+sqr(y)+sqr(z)) - fEarthRad/10000
	}
	
#declare ridgef =
	function {
		"ridgedmf", <0.5,2.7,nRidgeLOD,1,1.5> //n.b. param 3 -can- be varied to give LOD :)  (was 5, max < 8)
	}
	
#declare elevationf =
	function {
		pigment {
			bozo
			turbulence 0.4
			translate <0,4,0.7>
			scale 0.6*fEarthRad/10000
			rotate <0,-20,0>
			rotate <-54,0,0>
//			rotate <0,180,0>
			colour_map {
				[0 rgb -1]
				[1 rgb 0.8]
			}
			translate <gShiftx,0,gShiftz>
			rotate <0,gRoty,0>
		}
	}

#declare eiso =
	isosurface {
		function {
			boxf - 0.2*elevationf(x,y,z)*ridgef((x/2-z*sqrt(3)/2)-gShiftx,y,(z/2+x*sqrt(3)/2)-gShiftz)
		}
		contained_by { box { <-1,-1,-1>*1.2*fEarthRad/10000, <1,1,1>*1.2*fEarthRad/10000 } }
		max_gradient 2.0
		//accuracy 0.01//nice: 0.0001

		texture {
			groundt
		}
		
		scale 10000//fEarthRad/10000
//		translate y*(fEarthRad-10000)
	}
	
#declare eisowsea =
	union {
		object {
			eiso
		}
		box {
			<-1,-1,-1>, <1,1,1>
			scale fEarthRad+fWaterHeight

/*			texture {
				pigment { rgb <0.2,1,0.5> }
				finish {
					diffuse 0.1/bmod
					ambient 0
					reflection_min 0.05
					reflection_max 0.9
				}
			}*/
			material {
				texture {
					#if (boSideView)
						pigment { rgb <0.00, 0.00, 1.00> }
					#else
						pigment { rgbt <0.00, 0.15, 0.10, 0.6> }//<0.00, 0.15, 0.10, 0.4> }
					#end
					finish {
						diffuse 0.7
						specular 0.8 roughness 0.001
//						reflection 0.4
						reflection_max 0.4
						reflection_min 0.2
						conserve_energy
					}
					normal {
						crackle 0.3//0.6*3
						scale 0.2
						poly_wave 1.5
					  warp
					  {
							turbulence 0.7
						}
						scale 20.0
					  warp
					  {
							turbulence 0.3
						}
						scale 0.25
						//scale is now 1
						scale 0.1
					}
				}
				interior {
					//ior 1.3
					fade_distance 800//200
					fade_power 2
				}
			}
		}
	}


	
#declare earth = eisowsea
	

object{
	earth
	
	texture { dtex }

	translate <0,-fEarthRad,0>
}



#if (!boSideView)
	//high clouds
	
	/*box {
		<-1,-1,-1>, <1,1,1>*/
	superellipsoid {
		<0.05,0.05> //0.1
		scale fEarthRad+fStratusCloudHeight
		translate -fEarthRad*y
	
		hollow on
		
		texture {
			pigment {
				bozo
				
	//			scale 1.3 //new
	
				scale <5,1,1>
				warp {
					turbulence 0.5
				}
				scale <1/5,1,1>
				rotate <45,45,0>
				scale 0.1
				warp {
					turbulence 0.5
					//octaves 6
					lambda 1.5
					//omega 0.8
				}
				scale 10
				
				scale 4000
				poly_wave 6
				pigment_map {
					[0.00 rgbt <1,1,1,0.35>]
					[0.01	rgbt 1] //0.007//0.01
				}
			}
			finish {
				diffuse 1/bmod
				ambient 0
			}
		}
	}
	
	
	
	#if ( boLowClouds )
		
		#declare nBlobs = 4000;//3000;
		#declare aBlobPos = array [nBlobs]
		#declare aBlobRad = array [nBlobs]
		#declare anFace = array [nBlobs]
		#declare brs = seed(17);//7//11
		
		#declare nLastNewBlob = -1;
		#declare nBlob = 0;
		#while ( nBlob < nBlobs )
		
			#if ( nBlob = 0 | ( rand(brs) < 0.2 & nBlob - nLastNewBlob > 3 ) )
				//create a new blob
		
				#declare anFace[nBlob] = int(6*rand(brs));
				#if ( anFace[nBlob] = 6 )
					#declare anFace[nBlob] = 3;
				#end
				#declare fPerp = 1;
				#switch ( anFace[nBlob] )
					#case (0)
						#declare fPerp = -1;
					#case (1)
						#declare aBlobPos[nBlob] = <fPerp,2*rand(brs)-1,2*rand(brs)-1>;
						#break
			
					#case (2)
						#declare fPerp = -1;
					#case (3)
						#declare aBlobPos[nBlob] = <2*rand(brs)-1,fPerp,2*rand(brs)-1>;
						#break
			
					#case (4)
						#declare fPerp = -1;
					#case (5)
						#declare aBlobPos[nBlob] = <2*rand(brs)-1,2*rand(brs)-1,fPerp>;
						#break
				#end //switch
		
				#declare aBlobPos[nBlob] = aBlobPos[nBlob]*(fEarthRad+fCumulusCloudHeight);
		
				#declare nLastNewBlob = nBlob;
						
			#else //if
				//continue blob
				#declare anFace[nBlob] = anFace[nBlob-1];
				
				#declare vPush = vturbulence(2, 0.5, 6, aBlobPos[nBlob-1]/2000 + <0.5,5.5,-0.2>);
		
				#switch ( anFace[nBlob] )
					#case (0)
					#case (1)
						#declare vPush = <vPush.x/20,vPush.y,vPush.z>;
						#break
			
					#case (2)
					#case (3)
						#declare vPush = <vPush.x,vPush.y/20,vPush.z>;
						#break
			
					#case (4)
					#case (5)
						#declare vPush = <vPush.x,vPush.y,vPush.z/20>;
						#break
				#end //switch
						
				#declare aBlobPos[nBlob] = aBlobPos[nBlob-1] + vPush*500;//800
				
			#end //if
			
			#declare aBlobRad[nBlob] = 300*(1+rand(brs))/2;
			
		/*	sphere {
				aBlobPos[nBlob]+240*y, aBlobRad[nBlob]
				texture {
					pigment { rgbt <1,1,1,0.1> }//<1,0,0> }
					finish {
						diffuse 1
						ambient 0
					}
				}
		
				translate -fEarthRad*y
			}*/
		
			#declare nBlob = nBlob + 1;
		#end
		
		object {
			CumulusCloudsMacro( aBlobPos, aBlobRad, anFace, nBlobs )

			translate -fEarthRad*y
		}
		
	#end //#if (boLowClouds)


#end //#if (!boSideView)



#if (!boSideView | true)


	//lights on the ground
	#macro ground_light(_pos,_col)
		//union {
			light_source {
				_pos,
				_col*bmod
				fade_power 2
				fade_distance 70//100//20
				media_interaction off
			}
			glow {
				type 1
				location _pos
				size 5 //10
				fade_power 2
				colour _col*bmod
			}
		//}
	#end
		
	#declare light_map =
		pigment {
			image_map {
				png "lightmap.png"
				once
			}
			translate <-0.5,-0.5,-0.5>
			scale fEarthRad*2
			rotate <0,180,0>
		}

	#declare lrs = seed(3901);
	#declare nLightsNum = 10000;

//	union {
		#declare nLight = 0;
		#while ( nLight < nLightsNum )
			
			//step 1: choose a random position on the face.
			#declare pos = fEarthRad * 2 * <rand(lrs) - .5, rand(lrs) - .5, 0>;
			
			//step 2: test the pigment to see if we can put a light here.
			#declare col = eval_pigment( light_map, pos );
			
			#if ( col.red > 0.01 )

				//step 3: trace the position onto the ground, then move up a bit.
				#declare norm = <0,0,0>;
				#declare pos2 = trace ( earth, pos+z*fEarthRad*2, -z, norm );

				#if ( vlength(norm.z) > 0 )

					#declare pos2 = pos2 - fEarthRad*y;				
					#declare pos2 = pos2 + 40*z;// + 10*z;
				
					//step 4: create the light.
					ground_light(pos2,col)
					
				#else
					#warning "trace failed\n"
				#end //norm.z >= 0
			
			#end //if col > 0
			
		
			#declare nLight = nLight + 1;
		#end //while
//	}


#end //#if (boSideView)
