#declare _ccrs = seed(31);

#macro cloud_media(_density)
	material {
		texture {
			pigment {
				rgbf <1,1,1,1>//<1,1,1,0>
			}
			finish {
				ambient 0
				diffuse 1/bmod
			}
		}
		interior {
			media {
				scattering {
					1, rgb <1,0.8,0.5>///2 + 1/2//<1,0.7,0.6>//1
					extinction 1
				}
				//emission rgb 0.04//0.1

				//method 3
				intervals 8//nMediaIntervals
				samples		1,4//nMediaSamples/4,nMediaSamples

				density {
//					rgb _density//0.03
					crackle
					turbulence 0.2
					scale 160
					form <1,0,0>
					cubic_wave
					colour_map {
						[0.2	rgb _density*2.0]
						[0.8	rgb _density*0.0]
					}
				}
			}
		}
	}
#end





#declare blob_strength = 1.2; //must be less than 2.

#declare func_blob_element =
	function {
//		sqrt(sqr(x)+sqr(y)+sqr(z))-1
		2-blob_strength-2/(sqrt(sqr(x)+sqr(y)+sqr(z))+1)
	}

#declare func_ytrim =
	function {
		1-sqrt(1-sqr(min(max(-y/10,0),1)))
	}
	
#declare func_wispy =
	function {
		pigment {	
			bozo
			turbulence 4
			scale 50
			colour_map {
				[0 rgb -1]
				[1 rgb 1]
			}
		}
	}



#macro CumulusCloudsMacro( laBlobPos, laBlobRad, lanMajorAxis, lnBlobs )

/*functions don't seem to let you do this, so we'll circumvent it.
	#declare func_blob =
		function {
			(
				#local lnBlob = 0;
				#while ( lnBlob < lnBlobs )
					#local lX = laBlobPos[lnBlob].x;
					#local lY = laBlobPos[lnBlob].y;
					#local lZ = laBlobPos[lnBlob].z;
					
					func_blob_element((x-lX)/300,(y-lY)/300,(z-lZ)/300) +
					
					#local lnBlob = lnBlob + 1;
				#end
			0 )/lnBlobs
		}*/

/*
	#declare func_blob =
		function { 0 }

	#local lnBlob = 0;
	#while ( lnBlob < lnBlobs )
		#local lX = laBlobPos[lnBlob].x;
		#local lY = laBlobPos[lnBlob].y;
		#local lZ = laBlobPos[lnBlob].z;
					
		#declare func_blob =
			function {
				func_blob_element((x-lX)/laBlobRad[lnBlob],(y-lY)/laBlobRad[lnBlob],(z-lZ)/laBlobRad[lnBlob]) + func_blob(x,y,z)
			}
					
		#local lnBlob = lnBlob + 1;
	#end

	#declare func_blob =
		function { func_blob(x,y,z)/lnBlobs }

	
	#declare cloud_iso2 =
		isosurface {
			function {
				func_wispy*0.09 +
				func_ytrim(0,y+20,0) +
				func_blob
			}
			max_gradient 0.4//1
			contained_by { box { <0,0,0>, fEarthRad*1.2 } }
			accuracy 0.01//0.001
		}*/
		
	#declare cloud_blob =
		blob {
			#local lnBlob = 0;
			#while ( lnBlob < lnBlobs )

/*
could do a combination of several elements, to get the bobbliness and flat bottom:
  _      _
 (_) -> dob
 
kinda thang. That would be cool!
(would need to pass nFace).
*/

				sphere { laBlobPos[lnBlob], laBlobRad[lnBlob], laBlobRad[lnBlob] }
				
				//small "skirt" blobs
				#local lvCPos = laBlobPos[lnBlob];
				#local lfSRad = laBlobRad[lnBlob]*0.5;
				#local lfCRad = laBlobRad[lnBlob]*0.8;
				#switch ( lanMajorAxis[lnBlob] )
					#case (0)
						#local lvCPos = lvCPos + lfCRad*x;
						#break

					#case (1)
						#local lvCPos = lvCPos - lfCRad*x;
						#break

					#case (2)
						#local lvCPos = lvCPos + lfCRad*y;
						#break

					#case (3)
						#local lvCPos = lvCPos - lfCRad*y;
						#break

					#case (4)
						#local lvCPos = lvCPos + lfCRad*z;
						#break

					#case (5)
						#local lvCPos = lvCPos - lfCRad*z;
						#break
				#end //switch
				
				#local lnSkirt = 0;
				#while ( lnSkirt < 8 )
					
					#local lfAngle = 2*pi*rand(_ccrs);
					
					#switch ( lanMajorAxis[lnBlob] )
						#case (0)
						#case (1)
							sphere { lvCPos + <0,sin(lfAngle),cos(lfAngle)>*lfCRad, lfSRad, lfSRad }
							#break
	
						#case (2)
						#case (3)
							sphere { lvCPos + <sin(lfAngle),0,cos(lfAngle)>*lfCRad, lfSRad, lfSRad }
							#break
	
						#case (4)
						#case (5)
							sphere { lvCPos + <sin(lfAngle),cos(lfAngle),0>*lfCRad, lfSRad, lfSRad }
							#break
					#end //switch
					
					#local lnSkirt = lnSkirt + 1;
				#end

				#local lnBlob = lnBlob + 1;
			#end

			sturm on
			hierarchy on
		} //blob


	// **idea: faking real cloud's refraction based glow: two coincedent medias, one which casts no shadow, but both have absorb!
//	union {
		object {
			cloud_blob
			hollow on
			cloud_media(0.002*bmod)//0.0013*bmod)//0.002*bmod)
		}
		/*object {
			cloud_blob
			hollow on
			no_shadow
			cloud_media(0.007)//0.01
		}
	}*/
#end //macro





