// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   IsoWood Include File version 0.2                            %
// %                                                               %
// %   IW_Tex.INC - pigments/color_maps for wood objects           %
// %                                                               %
// %   for use with megapov 0.6                                    %
// %   written August 2000 - November 2000                         %
// %   by Christoph Hormann <chris_hormann@gmx.de>                 %
// %   newest version can be found at                              %
// %   http://www.schunter.etc.tu-bs.de/~chris/iso_wood.html       %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   Feel free to use this file for your povray work, you are    %
// %   also allowed to modify and redistribute it as long as you   %
// %   leave these comments intact and highlight any changes you   %
// %   make.                                                       %
// %                                                               %
// %   I encourage you to contact me if you have ideas for         %
// %   improvements                                                %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// %                                                               %
// %   declarations in this file:                                  %
// %                                                               %
// %   Norm_W   standard normal (compatible with IsoWood 0.1)      %
// %   Fin_W    standard finish (compatible with IsoWood 0.1)      %
// %   Fin_W_01 alternative finish                                 %
// %   Fin_W_02 alternative finish                                 %
// %                                                               %
// %                                                               %
// %   P_IW_01 - P_IW_14:                                          %
// %            simple pigments (01-09 from IsoWood 0.1)           %
// %                                                               %
// %   CM_IW_01 - CM_IW_26                                         %
// %            mixed color_maps (01-02 from IsoWood 0.1)          %
// %                                                               %
// %   CM_IW_Maple_01 - CM_IW_Douglas_06                           %
// %            special color_maps for different types of wood     %
// %                                                               %
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
         
         
#version unofficial MegaPov 0.6;     

//------------------------------------------------------------------

#include "teak.map"
#include "orngwood.map"
#include "WhiteAsh.map"
#include "colors.inc"
#include "woods.inc"

#declare Norm_W =
   normal {
     bumps 0.0
   }

#declare Fin_W =
   finish {
     ambient 0.08
     diffuse 0.95
     brilliance 1.2
     specular 0.2
     roughness 0.2
   }

#declare Fin_W_01 =
   finish {
     ambient 0.08
     diffuse 0.95
     brilliance 1.6
     specular 0.3
     roughness 0.1
   }

#declare Fin_W_02 =
   finish {
     ambient 0.1
     diffuse 0.95
     brilliance 1.4
     specular 0.4
     roughness 0.02
   }

//------------------------------------------------------------------


#declare P_IW_01 =
   pigment {
     wood
     turbulence <0.05, 0.05, 0.4 >
     scale      <0.02, 0.02, 0.12>
   }

#declare P_IW_02 =
   pigment {
     wood
     turbulence <0.07, 0.07, 0.2 >
     scale      <0.03, 0.03, 0.07>
     translate  0.5*y
   }

#declare P_IW_03 =
  pigment {
    wood
    turbulence 0.2
    octaves 3
    scale <1/32, 5/100, 3/8>
  }


#declare P_IW_04 =
    pigment {
        wood
        octaves 4
        turbulence 0.08
        lambda 0.60
        scale  <0.06, 0.06, 0.9>
        rotate -1.000*x
    }

#declare P_IW_05 =
   pigment {
     wood
     omega 0.6
     turbulence <0.05, 0.05, 0.4>
     scale      <0.04, 0.04, 0.6>
   }

#declare P_IW_06 =
   pigment {
     wood
     turbulence <0.06, 0.06, 0.6>
     scale      <0.04, 0.04, 0.6>
   }


#declare P_IW_07 =
   pigment {
     wood
     octaves 4
     lambda 2.6
     turbulence <0.06, 0.06, 0.6>
     scale      <0.02, 0.02, 0.4>
   }

#declare P_IW_08 =
   pigment {
     wood
     octaves 4
     lambda 2.2
     turbulence <0.06, 0.06, 0.6>
     scale      <0.02, 0.02, 0.4>
   }

#declare P_IW_09 =
   pigment {
     wood
     octaves 3
     lambda 2.2
     omega 0.4
     turbulence <0.030, 0.030, 0.6>
     scale      <0.015, 0.015, 0.1>
   }

#declare P_IW_10 =
   pigment {
     wood
     octaves 6
     lambda 2.5
     turbulence <0.06, 0.06, 0.75>
     scale      <0.02, 0.02, 0.3>
   }

#declare P_IW_11 =
   pigment {
     wood
     octaves 6
     lambda 2.5
     turbulence <0.05, 0.05, 0.9>
     scale      <0.03, 0.03, 0.2>
   }

#declare P_IW_12 =
   pigment {
     wood
     octaves 5
     lambda 2.4
     omega 0.4
     turbulence <0.05, 0.05, 0.7>
     scale      <0.05, 0.05, 0.5>
   }

#declare P_IW_13 =
   pigment {
     wood
     lambda 2.2
     turbulence <0.05, 0.05, 0.4 >
     scale      <0.04, 0.04, 0.12>
   }

#declare P_IW_14 =
   pigment {
     wood
     octaves 4
     turbulence <0.07, 0.07, 0.4>
     lambda 0.80
     scale  <0.06, 0.06, 0.9>
   }

//------------------------------------------------------------------

#declare P_IW_A01 =
   pigment {
     gradient z
     //sine_wave
     triangle_wave

     pigment_map {
       [0.2 P_IW_01 color_map { [0 rgb 0.0][1 rgb 1.0] } ]
       [0.8 P_IW_01 color_map { [0 rgb 0.1][1 rgb 0.3] } ]
     }

     scale 5
   }

#declare P_IW_A02 =
   pigment {
     leopard

     turbulence 0.7
     lambda 2.2
     omega 0.52
     octaves 5

     pigment_map {
       [0.7 P_IW_07 color_map { [0 rgb 0.0][1 rgb 1.0] } ]
       [0.9 color rgb < 0.23, 0.2, 0.12 > ]
     }
   }



//------------------------------------------------------------------

#declare CM_IW_01 =
     color_map {
        [0.0 color rgb < 0.953, 0.878, 0.761 > ]
        [0.2 color rgb < 0.980, 0.851, 0.647 > ]
        [0.4 color rgb < 0.871, 0.776, 0.627 > ]
        [0.6 color rgb < 0.792, 0.698, 0.533 > ]
        [0.8 color rgb < 0.757, 0.580, 0.373 > ]
        [1.0 color rgb < 0.667, 0.459, 0.263 > ]
     }

#declare CM_IW_02 =
     color_map {
        [0.0 color rgb < 0.949, 0.792, 0.514 > ]
        [0.3 color rgb < 0.855, 0.651, 0.376 > ]
        [0.6 color rgb < 0.831, 0.596, 0.275 > ]
        [0.9 color rgb < 0.620, 0.447, 0.204 > ]
     }

//------------------------------------------------------------------


#declare CM_IW_03 = color_map {
     [ 0.0000  color rgb<0.6980, 0.5059, 0.2353> ]
     [ 0.0500  color rgb<0.6667, 0.4745, 0.2039> ]
     [ 0.1000  color rgb<0.6980, 0.5059, 0.2392> ]
     [ 0.1500  color rgb<0.7725, 0.5882, 0.3255> ]
     [ 0.2000  color rgb<0.8157, 0.6471, 0.3961> ]
     [ 0.2500  color rgb<0.8078, 0.6471, 0.4039> ]
     [ 0.3000  color rgb<0.7961, 0.6392, 0.4000> ]
     [ 0.3500  color rgb<0.7843, 0.6275, 0.3843> ]
     [ 0.4000  color rgb<0.7843, 0.6275, 0.3843> ]
     [ 0.4500  color rgb<0.7843, 0.6314, 0.3922> ]
     [ 0.5000  color rgb<0.8000, 0.6510, 0.4196> ]
     [ 0.5500  color rgb<0.8039, 0.6588, 0.4275> ]
     [ 0.6000  color rgb<0.8118, 0.6667, 0.4471> ]
     [ 0.6500  color rgb<0.8157, 0.6706, 0.4549> ]
     [ 0.7000  color rgb<0.8078, 0.6706, 0.4549> ]
     [ 0.7500  color rgb<0.8078, 0.6667, 0.4471> ]
     [ 0.8000  color rgb<0.8039, 0.6706, 0.4431> ]
     [ 0.8500  color rgb<0.8000, 0.6745, 0.4510> ]
     [ 0.9000  color rgb<0.7961, 0.6745, 0.4588> ]
     [ 0.9500  color rgb<0.8039, 0.6784, 0.4667> ]
     [ 1.0000  color rgb<0.8078, 0.6824, 0.4706> ]
   }

#declare CM_IW_04 = color_map {
     [ 0.0000  color rgb<0.2980, 0.2196, 0.1490> ]
     [ 0.2000  color rgb<0.3373, 0.2471, 0.1608> ]
     [ 0.4000  color rgb<0.4706, 0.3451, 0.2157> ]
     [ 0.6000  color rgb<0.5529, 0.3922, 0.2314> ]
     [ 0.8000  color rgb<0.6078, 0.4118, 0.2314> ]
     [ 1.0000  color rgb<0.5451, 0.3843, 0.2471> ]
   }

#declare CM_IW_05 = color_map {
     [ 0.0000  color rgb<0.2471, 0.1686, 0.1294> ]
     [ 0.2000  color rgb<0.2627, 0.1647, 0.1490> ]
     [ 0.4000  color rgb<0.3137, 0.2275, 0.1804> ]
     [ 0.6000  color rgb<0.3725, 0.2392, 0.1647> ]
     [ 0.8000  color rgb<0.4275, 0.2941, 0.2039> ]
     [ 1.0000  color rgb<0.4431, 0.3059, 0.1882> ]
   }

#declare CM_IW_06 = color_map {
     [ 0.0000  color rgb<0.3412, 0.2039, 0.1765> ]
     [ 0.2000  color rgb<0.3647, 0.2275, 0.1686> ]
     [ 0.4000  color rgb<0.4039, 0.2627, 0.1608> ]
     [ 0.6000  color rgb<0.5569, 0.4157, 0.2784> ]
     [ 0.8000  color rgb<0.6392, 0.4941, 0.3451> ]
     [ 1.0000  color rgb<0.6039, 0.4706, 0.3216> ]
   }

#declare CM_IW_07 = color_map {
     [ 0.0000  color rgb<0.3451, 0.2314, 0.1725> ]
     [ 0.2000  color rgb<0.3843, 0.1922, 0.1255> ]
     [ 0.4000  color rgb<0.4627, 0.2392, 0.1647> ]
     [ 0.6000  color rgb<0.4941, 0.2863, 0.2157> ]
     [ 0.8000  color rgb<0.5961, 0.3882, 0.3098> ]
     [ 1.0000  color rgb<0.6706, 0.4471, 0.3529> ]
   }

#declare CM_IW_08 = color_map {
     [ 0.0000  color rgb<0.4902, 0.2431, 0.0863> ]
     [ 0.2000  color rgb<0.5373, 0.2863, 0.1098> ]
     [ 0.4000  color rgb<0.6510, 0.3569, 0.1216> ]
     [ 0.6000  color rgb<0.7569, 0.4039, 0.0627> ]
     [ 0.8000  color rgb<0.8039, 0.4627, 0.1098> ]
     [ 1.0000  color rgb<0.8118, 0.4784, 0.1451> ]
   }

#declare CM_IW_09 = color_map {
     [ 0.0000  color rgb<0.2235, 0.0824, 0.0902> ]
     [ 0.1250  color rgb<0.2667, 0.0980, 0.0706> ]
     [ 0.2500  color rgb<0.4314, 0.2157, 0.1255> ]
     [ 0.3750  color rgb<0.5294, 0.2824, 0.1451> ]
     [ 0.5000  color rgb<0.6118, 0.2902, 0.1137> ]
     [ 0.6250  color rgb<0.5451, 0.2471, 0.0784> ]
     [ 0.7500  color rgb<0.5804, 0.2824, 0.0863> ]
     [ 0.8750  color rgb<0.6314, 0.3216, 0.1098> ]
     [ 1.0000  color rgb<0.6235, 0.3176, 0.1294> ]
   }

#declare CM_IW_10 = color_map {
     [ 0.0000  color rgb<0.5843, 0.2510, 0.2196> ]
     [ 0.2000  color rgb<0.5569, 0.2353, 0.2000> ]
     [ 0.4000  color rgb<0.5843, 0.2510, 0.2000> ]
     [ 0.6000  color rgb<0.6667, 0.2902, 0.2235> ]
     [ 0.8000  color rgb<0.7059, 0.3098, 0.2275> ]
     [ 1.0000  color rgb<0.7216, 0.3176, 0.2353> ]
   }

#declare CM_IW_11 = color_map {
     [ 0.0000  color rgb<0.5255, 0.2118, 0.1843> ]
     [ 0.2000  color rgb<0.4667, 0.1686, 0.1686> ]
     [ 0.4000  color rgb<0.5216, 0.1922, 0.1725> ]
     [ 0.6000  color rgb<0.6549, 0.2627, 0.2039> ]
     [ 0.8000  color rgb<0.6667, 0.2667, 0.2196> ]
     [ 1.0000  color rgb<0.6588, 0.2706, 0.2235> ]
   }

#declare CM_IW_12 = color_map {
     [ 0.0000  color rgb<0.7176, 0.4353, 0.1373> ]
     [ 0.2000  color rgb<0.7176, 0.4510, 0.1412> ]
     [ 0.4000  color rgb<0.7373, 0.4667, 0.1490> ]
     [ 0.6000  color rgb<0.7569, 0.4784, 0.1725> ]
     [ 0.8000  color rgb<0.8039, 0.5333, 0.2510> ]
     [ 1.0000  color rgb<0.7843, 0.5294, 0.2706> ]
   }

#declare CM_IW_13 = color_map {
     [ 0.0000  color rgb<0.7294, 0.4000, 0.1137> ]
     [ 0.1000  color rgb<0.7255, 0.4039, 0.0980> ]
     [ 0.2000  color rgb<0.7490, 0.4549, 0.1098> ]
     [ 0.3000  color rgb<0.7490, 0.4745, 0.1020> ]
     [ 0.4000  color rgb<0.8118, 0.5725, 0.1961> ]
     [ 0.5000  color rgb<0.8941, 0.6902, 0.3216> ]
     [ 0.6000  color rgb<0.9255, 0.7373, 0.3922> ]
     [ 0.7000  color rgb<0.9608, 0.7922, 0.4941> ]
     [ 0.8000  color rgb<0.9725, 0.8000, 0.5216> ]
     [ 0.9000  color rgb<0.9882, 0.8314, 0.5647> ]
     [ 1.0000  color rgb<0.9765, 0.8314, 0.5647> ]
   }

#declare CM_IW_14 = color_map {
     [ 0.0000  color rgb<0.8667, 0.7137, 0.4118> ]
     [ 0.2000  color rgb<0.8745, 0.7216, 0.4235> ]
     [ 0.4000  color rgb<0.9255, 0.7725, 0.4863> ]
     [ 0.6000  color rgb<0.9529, 0.7961, 0.5255> ]
     [ 0.8000  color rgb<0.9529, 0.8039, 0.5294> ]
     [ 1.0000  color rgb<0.9490, 0.8039, 0.5294> ]
   }

#declare CM_IW_15 = color_map {
     [ 0.0000  color rgb<0.8667, 0.7922, 0.7373> ]
     [ 0.2000  color rgb<0.8902, 0.8157, 0.7608> ]
     [ 0.4000  color rgb<0.9490, 0.8745, 0.8196> ]
     [ 0.6000  color rgb<0.9686, 0.8980, 0.8235> ]
     [ 0.8000  color rgb<0.9765, 0.9059, 0.8275> ]
     [ 1.0000  color rgb<0.9882, 0.9176, 0.8392> ]
   }

#declare CM_IW_16 = color_map {
     [ 0.0000  color rgb<0.6196, 0.3961, 0.0275> ]
     [ 0.2000  color rgb<0.5961, 0.3765, 0.0118> ]
     [ 0.4000  color rgb<0.6588, 0.4510, 0.0392> ]
     [ 0.6000  color rgb<0.6980, 0.4941, 0.0667> ]
     [ 0.8000  color rgb<0.7020, 0.5020, 0.0745> ]
     [ 1.0000  color rgb<0.6980, 0.5059, 0.0745> ]
   }

#declare CM_IW_17 = color_map {
     [ 0.0000  color rgb<0.8549, 0.5020, 0.0039> ]
     [ 0.2000  color rgb<0.8824, 0.5137, 0.0000> ]
     [ 0.4000  color rgb<0.8980, 0.5725, 0.0000> ]
     [ 0.6000  color rgb<0.9255, 0.6902, 0.0471> ]
     [ 0.8000  color rgb<0.9333, 0.7294, 0.0941> ]
     [ 1.0000  color rgb<0.9255, 0.7216, 0.1412> ]
   }

#declare CM_IW_18 = color_map {
     [ 0.0000  color rgb<0.7882, 0.3020, 0.0157> ]
     [ 0.1000  color rgb<0.8078, 0.3725, 0.0078> ]
     [ 0.2000  color rgb<0.8510, 0.4784, 0.0157> ]
     [ 0.3000  color rgb<0.8863, 0.5686, 0.0275> ]
     [ 0.4000  color rgb<0.8980, 0.6235, 0.0353> ]
     [ 0.5000  color rgb<0.8980, 0.6706, 0.0235> ]
     [ 0.6000  color rgb<0.8980, 0.6824, 0.0196> ]
     [ 0.7000  color rgb<0.8980, 0.6902, 0.0196> ]
     [ 0.8000  color rgb<0.9020, 0.6902, 0.0196> ]
     [ 0.9000  color rgb<0.9020, 0.6863, 0.0118> ]
     [ 1.0000  color rgb<0.9059, 0.6784, 0.0000> ]
   }

#declare CM_IW_19 = color_map {
     [ 0.0000  color rgb<0.6941, 0.4078, 0.1882> ]
     [ 0.2000  color rgb<0.7059, 0.4275, 0.2000> ]
     [ 0.4000  color rgb<0.7216, 0.4431, 0.2235> ]
     [ 0.6000  color rgb<0.7294, 0.4706, 0.2510> ]
     [ 0.8000  color rgb<0.7333, 0.5098, 0.2941> ]
     [ 1.0000  color rgb<0.7569, 0.5529, 0.3451> ]
   }

#declare CM_IW_20 = color_map {
     [ 0.0000  color rgb<0.5804, 0.4471, 0.3098> ]
     [ 0.2000  color rgb<0.5804, 0.4510, 0.3137> ]
     [ 0.4000  color rgb<0.5882, 0.4588, 0.3294> ]
     [ 0.6000  color rgb<0.6235, 0.5020, 0.3765> ]
     [ 0.8000  color rgb<0.6471, 0.5294, 0.4039> ]
     [ 1.0000  color rgb<0.6510, 0.5373, 0.4196> ]
   }

#declare CM_IW_21 = color_map {
     [ 0.0000  color rgb<0.3451, 0.2745, 0.2353> ]
     [ 0.2000  color rgb<0.3569, 0.2824, 0.2471> ]
     [ 0.4000  color rgb<0.3647, 0.2941, 0.2392> ]
     [ 0.6000  color rgb<0.4078, 0.3412, 0.2588> ]
     [ 0.8000  color rgb<0.4431, 0.3765, 0.2941> ]
     [ 1.0000  color rgb<0.4314, 0.3569, 0.2980> ]
   }

#declare CM_IW_22 = color_map {
     [ 0.0000  color rgb<0.6235, 0.5294, 0.3922> ]
     [ 0.2000  color rgb<0.6667, 0.5725, 0.4275> ]
     [ 0.4000  color rgb<0.6588, 0.5647, 0.4235> ]
     [ 0.6000  color rgb<0.6941, 0.6039, 0.4745> ]
     [ 0.8000  color rgb<0.7412, 0.6549, 0.5294> ]
     [ 1.0000  color rgb<0.6941, 0.6118, 0.4863> ]
   }

#declare CM_IW_23 = color_map {
     [ 0.0000  color rgb<0.7490, 0.2980, 0.1490> ]
     [ 0.2000  color rgb<0.7451, 0.2941, 0.1490> ]
     [ 0.4000  color rgb<0.7216, 0.2824, 0.1333> ]
     [ 0.6000  color rgb<0.8980, 0.4353, 0.2431> ]
     [ 0.8000  color rgb<0.9255, 0.5020, 0.2824> ]
     [ 1.0000  color rgb<0.9647, 0.5216, 0.2667> ]
   }

#declare CM_IW_24 = color_map {
     [ 0.0000  color rgb<0.5333, 0.1961, 0.1333> ]
     [ 0.2000  color rgb<0.5490, 0.2118, 0.1373> ]
     [ 0.4000  color rgb<0.6000, 0.2275, 0.1373> ]
     [ 0.6000  color rgb<0.6471, 0.2392, 0.1294> ]
     [ 0.8000  color rgb<0.6941, 0.2627, 0.1451> ]
     [ 1.0000  color rgb<0.7098, 0.2588, 0.1373> ]
   }

#declare CM_IW_25 = color_map {
     [ 0.0000  color rgb<0.3922, 0.1529, 0.1059> ]
     [ 0.2000  color rgb<0.3922, 0.1490, 0.1098> ]
     [ 0.4000  color rgb<0.4314, 0.1922, 0.1373> ]
     [ 0.6000  color rgb<0.5059, 0.2392, 0.1686> ]
     [ 0.8000  color rgb<0.6039, 0.2510, 0.1569> ]
     [ 1.0000  color rgb<0.6588, 0.2588, 0.1529> ]
   }

#declare CM_IW_26 = color_map {
     [ 0.0000  color rgb<0.2157, 0.1059, 0.0980> ]
     [ 0.2000  color rgb<0.2706, 0.1176, 0.1020> ]
     [ 0.4000  color rgb<0.3804, 0.1490, 0.1137> ]
     [ 0.6000  color rgb<0.4314, 0.1686, 0.1176> ]
     [ 0.8000  color rgb<0.4902, 0.1882, 0.1255> ]
     [ 1.0000  color rgb<0.5373, 0.1922, 0.1255> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Maple_01 =
     color_map {
        [0.0 color rgb <0.9922, 0.8941, 0.7647> ]
        [0.3 color rgb <0.9647, 0.8431, 0.6588> ]
        [0.6 color rgb <0.9255, 0.7725, 0.5569> ]
        [0.9 color rgb <0.8627, 0.7059, 0.5020> ]
     }

#declare CM_IW_Maple_02 = color_map {
     [ 0.0000  color rgb<0.8314, 0.6745, 0.4745> ]
     [ 0.0500  color rgb<0.8549, 0.6980, 0.4941> ]
     [ 0.1000  color rgb<0.8667, 0.7059, 0.5020> ]
     [ 0.1500  color rgb<0.8667, 0.6980, 0.4980> ]
     [ 0.2000  color rgb<0.8745, 0.7255, 0.5176> ]
     [ 0.2500  color rgb<0.9098, 0.7608, 0.5529> ]
     [ 0.3000  color rgb<0.9176, 0.7569, 0.5451> ]
     [ 0.3500  color rgb<0.9255, 0.7725, 0.5569> ]
     [ 0.4000  color rgb<0.9451, 0.7961, 0.5725> ]
     [ 0.4500  color rgb<0.9412, 0.8078, 0.5961> ]
     [ 0.5000  color rgb<0.9451, 0.8000, 0.5922> ]
     [ 0.5500  color rgb<0.9451, 0.8078, 0.6078> ]
     [ 0.6000  color rgb<0.9529, 0.8235, 0.6275> ]
     [ 0.6500  color rgb<0.9647, 0.8431, 0.6549> ]
     [ 0.7000  color rgb<0.9765, 0.8510, 0.6627> ]
     [ 0.7500  color rgb<0.9686, 0.8471, 0.6667> ]
     [ 0.8000  color rgb<0.9765, 0.8627, 0.6902> ]
     [ 0.8500  color rgb<0.9725, 0.8627, 0.6784> ]
     [ 0.9000  color rgb<0.9725, 0.8627, 0.6980> ]
     [ 0.9500  color rgb<0.9765, 0.8706, 0.7059> ]
     [ 1.0000  color rgb<0.9882, 0.8863, 0.7490> ]
   }

#declare CM_IW_Maple_03 = color_map {
     [ 0.0000  color rgb<0.8431, 0.5961, 0.3020> ]
     [ 0.1000  color rgb<0.8627, 0.6275, 0.3451> ]
     [ 0.2000  color rgb<0.8980, 0.6784, 0.4196> ]
     [ 0.3000  color rgb<0.8980, 0.6784, 0.4314> ]
     [ 0.4000  color rgb<0.8980, 0.6824, 0.4275> ]
     [ 0.5000  color rgb<0.8941, 0.6902, 0.4314> ]
     [ 0.6000  color rgb<0.9059, 0.7059, 0.4471> ]
     [ 0.7000  color rgb<0.8941, 0.7059, 0.4627> ]
     [ 0.8000  color rgb<0.9059, 0.7294, 0.4941> ]
     [ 0.9000  color rgb<0.8980, 0.7059, 0.4706> ]
     [ 1.0000  color rgb<0.9098, 0.7294, 0.4980> ]
   }

#declare CM_IW_Maple_04 =
     color_map {
        [0.00 color rgb <0.9961, 0.8941, 0.8039> ]
        [0.25 color rgb <0.9529, 0.8196, 0.6706> ]
        [0.50 color rgb <0.8902, 0.7333, 0.5451> ]
        [0.70 color rgb <0.8353, 0.6431, 0.4353> ]
        [0.95 color rgb <0.6588, 0.4275, 0.1961> ]
     }

#declare CM_IW_Maple_05 = color_map {
     [ 0.0000  color rgb<0.8784, 0.6353, 0.4392> ]
     [ 0.1000  color rgb<0.8824, 0.6549, 0.4706> ]
     [ 0.2000  color rgb<0.9098, 0.7333, 0.5412> ]
     [ 0.3000  color rgb<0.9098, 0.7373, 0.5608> ]
     [ 0.4000  color rgb<0.9176, 0.7490, 0.5804> ]
     [ 0.5000  color rgb<0.8980, 0.7333, 0.5686> ]
     [ 0.6000  color rgb<0.9216, 0.7608, 0.5961> ]
     [ 0.7000  color rgb<0.8980, 0.7451, 0.5765> ]
     [ 0.8000  color rgb<0.9176, 0.7569, 0.6157> ]
     [ 0.9000  color rgb<0.9020, 0.7490, 0.6078> ]
     [ 1.0000  color rgb<0.9176, 0.7725, 0.6235> ]
   }

#declare CM_IW_Maple_05a =
     color_map {
        [0.0 color rgb <0.8510, 0.5294, 0.3294> ]
        [0.0 color rgb <0.7137, 0.4275, 0.2588> ]
        [1.0 color rgb <0.5216, 0.3137, 0.1882> ]
     }


#declare CM_IW_Maple_06 =
     color_map {
        [0.0 color rgb <0.8824, 0.7843, 0.6667> ]
        [1.0 color rgb <0.8863, 0.7882, 0.6706> ]
     }

//------------------------------------------------------------------


#declare CM_IW_Apple_01 =
     color_map {
        [0.0 color rgb <0.8157, 0.6392, 0.4353> ]
        [0.5 color rgb <0.7843, 0.5569, 0.3333> ]
        [1.0 color rgb <0.6745, 0.4196, 0.2392> ]
     }

#declare CM_IW_Apple_02 =
     color_map {
        [0.0 color rgb <0.8471, 0.7020, 0.4745> ]
        [0.3 color rgb <0.8235, 0.6196, 0.3529> ]
        [0.7 color rgb <0.8000, 0.5686, 0.3294> ]
        [1.0 color rgb <0.7020, 0.4275, 0.2235> ]
     }

//------------------------------------------------------------------


#declare CM_IW_Sycamore_01 = color_map {
     [ 0.0000  color rgb<0.7020, 0.6235, 0.5294> ]
     [ 0.1000  color rgb<0.7059, 0.6431, 0.5529> ]
     [ 0.2000  color rgb<0.7216, 0.6510, 0.5569> ]
     [ 0.3000  color rgb<0.7333, 0.6627, 0.5686> ]
     [ 0.4000  color rgb<0.7529, 0.6863, 0.5843> ]
     [ 0.5000  color rgb<0.7608, 0.6902, 0.5961> ]
     [ 0.6000  color rgb<0.7843, 0.7137, 0.6196> ]
     [ 0.7000  color rgb<0.8118, 0.7451, 0.6353> ]
     [ 0.8000  color rgb<0.8118, 0.7490, 0.6431> ]
     [ 0.9000  color rgb<0.8157, 0.7608, 0.6510> ]
     [ 1.0000  color rgb<0.8353, 0.7725, 0.6706> ]
   }

#declare CM_IW_Sycamore_02 = color_map {
     [ 0.0000  color rgb<0.7059, 0.5490, 0.3255> ]
     [ 0.0500  color rgb<0.7216, 0.5451, 0.3137> ]
     [ 0.1000  color rgb<0.7647, 0.5843, 0.3490> ]
     [ 0.1500  color rgb<0.7529, 0.5922, 0.3490> ]
     [ 0.2000  color rgb<0.7765, 0.6157, 0.3725> ]
     [ 0.2500  color rgb<0.8000, 0.6196, 0.3490> ]
     [ 0.3000  color rgb<0.8157, 0.6471, 0.4000> ]
     [ 0.3500  color rgb<0.8275, 0.6627, 0.4157> ]
     [ 0.4000  color rgb<0.8471, 0.6745, 0.4314> ]
     [ 0.4500  color rgb<0.8627, 0.6863, 0.4196> ]
     [ 0.5000  color rgb<0.8863, 0.7255, 0.5647> ]
     [ 0.5500  color rgb<0.8824, 0.7412, 0.5216> ]
     [ 0.6000  color rgb<0.8863, 0.7333, 0.5020> ]
     [ 0.6500  color rgb<0.8824, 0.7373, 0.5333> ]
     [ 0.7000  color rgb<0.9098, 0.7765, 0.6118> ]
     [ 0.7500  color rgb<0.9059, 0.7765, 0.6157> ]
     [ 0.8000  color rgb<0.9216, 0.8039, 0.6510> ]
     [ 0.8500  color rgb<0.9294, 0.8000, 0.6471> ]
     [ 0.9000  color rgb<0.9176, 0.8118, 0.6824> ]
     [ 0.9500  color rgb<0.9333, 0.8275, 0.6980> ]
     [ 1.0000  color rgb<0.9686, 0.8471, 0.7098> ]
   }

#declare CM_IW_Sycamore_03 =
     color_map {
        [0.0 color rgb <1.0000, 0.9020, 0.7725> ]
        [0.3 color rgb <0.9922, 0.8431, 0.6706> ]
        [0.7 color rgb <0.9216, 0.7373, 0.5216> ]
        [1.0 color rgb <0.7529, 0.5490, 0.3255> ]
     }

#declare CM_IW_Sycamore_04 = color_map {
     [ 0.0000  color rgb<0.8863, 0.7569, 0.5804> ]
     [ 0.1000  color rgb<0.9020, 0.7608, 0.5725> ]
     [ 0.2000  color rgb<0.9059, 0.7765, 0.5922> ]
     [ 0.3000  color rgb<0.9137, 0.7882, 0.6235> ]
     [ 0.4000  color rgb<0.9333, 0.8000, 0.6549> ]
     [ 0.5000  color rgb<0.9451, 0.8235, 0.6784> ]
     [ 0.6000  color rgb<0.9412, 0.8314, 0.6745> ]
     [ 0.7000  color rgb<0.9608, 0.8431, 0.7020> ]
     [ 0.8000  color rgb<0.9765, 0.8784, 0.7647> ]
     [ 0.9000  color rgb<0.9804, 0.9098, 0.8078> ]
     [ 1.0000  color rgb<0.9922, 0.9490, 0.8745> ]
   }

#declare CM_IW_Sycamore_04a = color_map {
     [ 0.0000  color rgb<0.3529, 0.1804, 0.0667> ]
     [ 0.1000  color rgb<0.3765, 0.2078, 0.0510> ]
     [ 0.2000  color rgb<0.3765, 0.2078, 0.0510> ]
     [ 0.3000  color rgb<0.4039, 0.2275, 0.0667> ]
     [ 0.4000  color rgb<0.5373, 0.3686, 0.1294> ]
     [ 0.5000  color rgb<0.5843, 0.4118, 0.1647> ]
     [ 0.6000  color rgb<0.6235, 0.4471, 0.1686> ]
     [ 0.7000  color rgb<0.6353, 0.4588, 0.2000> ]
     [ 0.8000  color rgb<0.6706, 0.4824, 0.2039> ]
     [ 0.9000  color rgb<0.6863, 0.4824, 0.2118> ]
     [ 1.0000  color rgb<0.6863, 0.4824, 0.2118> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Birch_01 =
     color_map {
        [0.0 color rgb <0.8784, 0.7216, 0.6039> ]
        [0.5 color rgb <0.8471, 0.6039, 0.4118> ]
        [1.0 color rgb <0.7804, 0.5176, 0.3294> ]
     }

#declare CM_IW_Birch_01a =
     color_map {
        [0.0 color rgb <0.4353, 0.1922, 0.0627> ]
        [0.5 color rgb <0.4784, 0.2588, 0.1647> ]
        [1.0 color rgb <0.3686, 0.1569, 0.0353> ]
     }

#declare CM_IW_Birch_02 = color_map {
     [ 0.0000  color rgb<0.7608, 0.5176, 0.2941> ]
     [ 0.1000  color rgb<0.7098, 0.4667, 0.2431> ]
     [ 0.2000  color rgb<0.7451, 0.5216, 0.2902> ]
     [ 0.3000  color rgb<0.8118, 0.6118, 0.3765> ]
     [ 0.4000  color rgb<0.8549, 0.6863, 0.4392> ]
     [ 0.5000  color rgb<0.8510, 0.7020, 0.4510> ]
     [ 0.6000  color rgb<0.8627, 0.7137, 0.4588> ]
     [ 0.7000  color rgb<0.8627, 0.7137, 0.4588> ]
     [ 0.8000  color rgb<0.8627, 0.7255, 0.4745> ]
     [ 0.9000  color rgb<0.8627, 0.7373, 0.4980> ]
     [ 1.0000  color rgb<0.8627, 0.7451, 0.5098> ]
   }

#declare CM_IW_Birch_03 = color_map {
     [ 0.0000  color rgb<0.8392, 0.6549, 0.4706> ]
     [ 0.2000  color rgb<0.8510, 0.6745, 0.4824> ]
     [ 0.4000  color rgb<0.8196, 0.6314, 0.4353> ]
     [ 0.6000  color rgb<0.8275, 0.6431, 0.4588> ]
     [ 0.8000  color rgb<0.8314, 0.6588, 0.4824> ]
     [ 1.0000  color rgb<0.8314, 0.6588, 0.4863> ]
   }

#declare CM_IW_Birch_04 = color_map {
     [ 0.0000  color rgb<0.8588, 0.6235, 0.4510> ]
     [ 0.2000  color rgb<0.8549, 0.6275, 0.4627> ]
     [ 0.4000  color rgb<0.8980, 0.6745, 0.5176> ]
     [ 0.6000  color rgb<0.9176, 0.7020, 0.5451> ]
     [ 0.8000  color rgb<0.9333, 0.7294, 0.5843> ]
     [ 1.0000  color rgb<0.9412, 0.7373, 0.5922> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Beech_01 = color_map {
     [ 0.0000  color rgb<0.8275, 0.6196, 0.3608> ]
     [ 0.2000  color rgb<0.9098, 0.7020, 0.4706> ]
     [ 0.4000  color rgb<0.9059, 0.7176, 0.4941> ]
     [ 0.6000  color rgb<0.9569, 0.7922, 0.5725> ]
     [ 0.8000  color rgb<0.9529, 0.7922, 0.5882> ]
     [ 1.0000  color rgb<0.9647, 0.8039, 0.6078> ]
   }

#declare CM_IW_Beech_02 = color_map {
     [ 0.0000  color rgb<0.8549, 0.5961, 0.2863> ]
     [ 0.2000  color rgb<0.8627, 0.6275, 0.3412> ]
     [ 0.4000  color rgb<0.8667, 0.6431, 0.3765> ]
     [ 0.6000  color rgb<0.9020, 0.6627, 0.3961> ]
     [ 0.8000  color rgb<0.9176, 0.6941, 0.4353> ]
     [ 1.0000  color rgb<0.9451, 0.7529, 0.5176> ]
   }

#declare CM_IW_Beech_03 = color_map {
     [ 0.0000  color rgb<0.6784, 0.4039, 0.1373> ]
     [ 0.1000  color rgb<0.7725, 0.5176, 0.2275> ]
     [ 0.2000  color rgb<0.8196, 0.5686, 0.2667> ]
     [ 0.3000  color rgb<0.8510, 0.6118, 0.3216> ]
     [ 0.4000  color rgb<0.8275, 0.5725, 0.2745> ]
     [ 0.5000  color rgb<0.8471, 0.5961, 0.3176> ]
     [ 0.6000  color rgb<0.8588, 0.6118, 0.3333> ]
     [ 0.7000  color rgb<0.8941, 0.6667, 0.4000> ]
     [ 0.8000  color rgb<0.8941, 0.6863, 0.4314> ]
     [ 0.9000  color rgb<0.9529, 0.7686, 0.5490> ]
     [ 1.0000  color rgb<0.9412, 0.7647, 0.5529> ]
   }

#declare CM_IW_Beech_04 = color_map {
     [ 0.0000  color rgb<0.8706, 0.6196, 0.4118> ]
     [ 0.2000  color rgb<0.8431, 0.6000, 0.3961> ]
     [ 0.4000  color rgb<0.8431, 0.6039, 0.4078> ]
     [ 0.6000  color rgb<0.8902, 0.6863, 0.4902> ]
     [ 0.8000  color rgb<0.8902, 0.7020, 0.4824> ]
     [ 1.0000  color rgb<0.9255, 0.7373, 0.5412> ]
   }

#declare CM_IW_Beech_05 =
     color_map {
        [0.0 color rgb <0.9216, 0.7843, 0.5961> ]
        [0.3 color rgb <0.9098, 0.7176, 0.5294> ]
        [0.7 color rgb <0.8549, 0.6353, 0.4549> ]
        [1.0 color rgb <0.8118, 0.5255, 0.3569> ]
     }

#declare CM_IW_Beech_06 = color_map {
     [ 0.0000  color rgb<0.7765, 0.5804, 0.3490> ]
     [ 0.2000  color rgb<0.7686, 0.5765, 0.3451> ]
     [ 0.4000  color rgb<0.7882, 0.6039, 0.3647> ]
     [ 0.6000  color rgb<0.8196, 0.6627, 0.4000> ]
     [ 0.8000  color rgb<0.8353, 0.6706, 0.4118> ]
     [ 1.0000  color rgb<0.8431, 0.6706, 0.4157> ]
   }

#declare CM_IW_Beech_07 =
     color_map {
        [0.0 color rgb <0.9137, 0.8118, 0.5882> ]
        [0.3 color rgb <0.8627, 0.7098, 0.4706> ]
        [0.7 color rgb <0.8000, 0.6431, 0.4431> ]
        [1.0 color rgb <0.7294, 0.5333, 0.3255> ]
     }


#declare CM_IW_Beech_08 = color_map {
     [ 0.0000  color rgb<0.7843, 0.5529, 0.2784> ]
     [ 0.1000  color rgb<0.8039, 0.5608, 0.2706> ]
     [ 0.2000  color rgb<0.8196, 0.5765, 0.2863> ]
     [ 0.3000  color rgb<0.8471, 0.6118, 0.3176> ]
     [ 0.4000  color rgb<0.8549, 0.6196, 0.3255> ]
     [ 0.5000  color rgb<0.8667, 0.6392, 0.3490> ]
     [ 0.6000  color rgb<0.9020, 0.6745, 0.3843> ]
     [ 0.7000  color rgb<0.9020, 0.6824, 0.3882> ]
     [ 0.8000  color rgb<0.9529, 0.7255, 0.4706> ]
     [ 0.9000  color rgb<0.9451, 0.7294, 0.4784> ]
     [ 1.0000  color rgb<0.9725, 0.7569, 0.5059> ]
   }

#declare CM_IW_Beech_09 = color_map {
     [ 0.0000  color rgb<0.9255, 0.7686, 0.5725> ]
     [ 0.2000  color rgb<0.9294, 0.7843, 0.6000> ]
     [ 0.4000  color rgb<0.9412, 0.8157, 0.6039> ]
     [ 0.6000  color rgb<0.9529, 0.8431, 0.6706> ]
     [ 0.8000  color rgb<0.9961, 0.8745, 0.7412> ]
     [ 1.0000  color rgb<0.9765, 0.8510, 0.6980> ]
   }

#declare CM_IW_Beech_10 = color_map {
     [ 0.0000  color rgb<0.8706, 0.5490, 0.3608> ]
     [ 0.2000  color rgb<0.8588, 0.5373, 0.3490> ]
     [ 0.4000  color rgb<0.8627, 0.5255, 0.3412> ]
     [ 0.6000  color rgb<0.8784, 0.5882, 0.4000> ]
     [ 0.8000  color rgb<0.8784, 0.6078, 0.4314> ]
     [ 1.0000  color rgb<0.8941, 0.6157, 0.4471> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Oak_01 = color_map {
     [ 0.0000  color rgb<0.7725, 0.6196, 0.3882> ]
     [ 0.1000  color rgb<0.7294, 0.5765, 0.3490> ]
     [ 0.2000  color rgb<0.7490, 0.5961, 0.3725> ]
     [ 0.3000  color rgb<0.7490, 0.5961, 0.3686> ]
     [ 0.4000  color rgb<0.7569, 0.6039, 0.3725> ]
     [ 0.5000  color rgb<0.8471, 0.6980, 0.4549> ]
     [ 0.6000  color rgb<0.8667, 0.7176, 0.4745> ]
     [ 0.7000  color rgb<0.8118, 0.6627, 0.4196> ]
     [ 0.8000  color rgb<0.7569, 0.6078, 0.3647> ]
     [ 0.9000  color rgb<0.8000, 0.6510, 0.4078> ]
     [ 1.0000  color rgb<0.8078, 0.6588, 0.4157> ]
   }

#declare CM_IW_Oak_02 = color_map {
     [ 0.0000  color rgb<0.7216, 0.4941, 0.2353> ]
     [ 0.2000  color rgb<0.7020, 0.4784, 0.2157> ]
     [ 0.4000  color rgb<0.7725, 0.5490, 0.2863> ]
     [ 0.6000  color rgb<0.8549, 0.6353, 0.3725> ]
     [ 0.8000  color rgb<0.9098, 0.6941, 0.4275> ]
     [ 1.0000  color rgb<0.8902, 0.6784, 0.4118> ]
   }

#declare CM_IW_Oak_03 = color_map {
     [ 0.0000  color rgb<0.4941, 0.3059, 0.0863> ]
     [ 0.2000  color rgb<0.5804, 0.3843, 0.1608> ]
     [ 0.4000  color rgb<0.6784, 0.4431, 0.1961> ]
     [ 0.6000  color rgb<0.7412, 0.4745, 0.2039> ]
     [ 0.8000  color rgb<0.7176, 0.4667, 0.1882> ]
     [ 1.0000  color rgb<0.7490, 0.5098, 0.2235> ]
   }

#declare CM_IW_Oak_04 = color_map {
     [ 0.0000  color rgb<0.7647, 0.6078, 0.3804> ]
     [ 0.2000  color rgb<0.7608, 0.6039, 0.3608> ]
     [ 0.4000  color rgb<0.8510, 0.7020, 0.4549> ]
     [ 0.6000  color rgb<0.8784, 0.7294, 0.4824> ]
     [ 0.8000  color rgb<0.8706, 0.7137, 0.4706> ]
     [ 1.0000  color rgb<0.8941, 0.7373, 0.4941> ]
   }

#declare CM_IW_Oak_05 = color_map {
     [ 0.0000  color rgb<0.6118, 0.4549, 0.3373> ]
     [ 0.1000  color rgb<0.6118, 0.4549, 0.3333> ]
     [ 0.2000  color rgb<0.6078, 0.4510, 0.3176> ]
     [ 0.3000  color rgb<0.6157, 0.4588, 0.3059> ]
     [ 0.4000  color rgb<0.6314, 0.4863, 0.3137> ]
     [ 0.5000  color rgb<0.7255, 0.5686, 0.3961> ]
     [ 0.6000  color rgb<0.7451, 0.5922, 0.4078> ]
     [ 0.7000  color rgb<0.7608, 0.6039, 0.4078> ]
     [ 0.8000  color rgb<0.8039, 0.6392, 0.4392> ]
     [ 0.9000  color rgb<0.8078, 0.6392, 0.4353> ]
     [ 1.0000  color rgb<0.8196, 0.6471, 0.4314> ]
   }

#declare CM_IW_Oak_06 = color_map {
     [ 0.0000  color rgb<0.6275, 0.3216, 0.1294> ]
     [ 0.1000  color rgb<0.6235, 0.3176, 0.1255> ]
     [ 0.2000  color rgb<0.6392, 0.3333, 0.1451> ]
     [ 0.3000  color rgb<0.6471, 0.3412, 0.1529> ]
     [ 0.4000  color rgb<0.6941, 0.3922, 0.1882> ]
     [ 0.5000  color rgb<0.7569, 0.4588, 0.2353> ]
     [ 0.6000  color rgb<0.7922, 0.4941, 0.2667> ]
     [ 0.7000  color rgb<0.9020, 0.6078, 0.3608> ]
     [ 0.8000  color rgb<0.8824, 0.5961, 0.3373> ]
     [ 0.9000  color rgb<0.8784, 0.5922, 0.3255> ]
     [ 1.0000  color rgb<0.8706, 0.5843, 0.3137> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Alder_01 = color_map {
     [ 0.0000  color rgb<0.7412, 0.4902, 0.2784> ]
     [ 0.1000  color rgb<0.7451, 0.4902, 0.2863> ]
     [ 0.2000  color rgb<0.7255, 0.4706, 0.2824> ]
     [ 0.3000  color rgb<0.7255, 0.4706, 0.2980> ]
     [ 0.4000  color rgb<0.7843, 0.5255, 0.3216> ]
     [ 0.5000  color rgb<0.7725, 0.5804, 0.3843> ]
     [ 0.6000  color rgb<0.7725, 0.6078, 0.4078> ]
     [ 0.7000  color rgb<0.7765, 0.5961, 0.3922> ]
     [ 0.8000  color rgb<0.8196, 0.6235, 0.4275> ]
     [ 0.9000  color rgb<0.7725, 0.5725, 0.3765> ]
     [ 1.0000  color rgb<0.7529, 0.5608, 0.3569> ]
   }

#declare CM_IW_Alder_02 = color_map {
     [ 0.0000  color rgb<0.5765, 0.3137, 0.1608> ]
     [ 0.1000  color rgb<0.6627, 0.4039, 0.2549> ]
     [ 0.2000  color rgb<0.7216, 0.4784, 0.3059> ]
     [ 0.3000  color rgb<0.7922, 0.5725, 0.3490> ]
     [ 0.4000  color rgb<0.7765, 0.5608, 0.3255> ]
     [ 0.5000  color rgb<0.7686, 0.5608, 0.3529> ]
     [ 0.6000  color rgb<0.8118, 0.6078, 0.4078> ]
     [ 0.7000  color rgb<0.8078, 0.6078, 0.3922> ]
     [ 0.8000  color rgb<0.7961, 0.5961, 0.3843> ]
     [ 0.9000  color rgb<0.8392, 0.6627, 0.4314> ]
     [ 1.0000  color rgb<0.8118, 0.6314, 0.4000> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Ash_01 = color_map {
     [ 0.0000  color rgb<0.8353, 0.6039, 0.2627> ]
     [ 0.2000  color rgb<0.8784, 0.6392, 0.2941> ]
     [ 0.4000  color rgb<0.8824, 0.6745, 0.3529> ]
     [ 0.6000  color rgb<0.9608, 0.7686, 0.4980> ]
     [ 0.8000  color rgb<0.9882, 0.8471, 0.6235> ]
     [ 1.0000  color rgb<0.9647, 0.8353, 0.6157> ]
   }

#declare CM_IW_Ash_02 = color_map {
     [ 0.0000  color rgb<0.7373, 0.5020, 0.1961> ]
     [ 0.2000  color rgb<0.8392, 0.6078, 0.3216> ]
     [ 0.4000  color rgb<0.9412, 0.7373, 0.4627> ]
     [ 0.6000  color rgb<0.9490, 0.7608, 0.4941> ]
     [ 0.8000  color rgb<0.9922, 0.7961, 0.5098> ]
     [ 1.0000  color rgb<0.9843, 0.8039, 0.5137> ]
   }

#declare CM_IW_Ash_03 = color_map {
     [ 0.0000  color rgb<0.8549, 0.6000, 0.2784> ]
     [ 0.2000  color rgb<0.8157, 0.5647, 0.2510> ]
     [ 0.4000  color rgb<0.9098, 0.6902, 0.4353> ]
     [ 0.6000  color rgb<0.8863, 0.7020, 0.4275> ]
     [ 0.8000  color rgb<0.9765, 0.8275, 0.5608> ]
     [ 1.0000  color rgb<0.9529, 0.8235, 0.6000> ]
   }

#declare CM_IW_Ash_03a = color_map {
     [ 0.0000  color rgb<0.1765, 0.0667, 0.0353> ]
     [ 0.2000  color rgb<0.2902, 0.1333, 0.0745> ]
     [ 0.4000  color rgb<0.4784, 0.2824, 0.1451> ]
     [ 0.6000  color rgb<0.5451, 0.3098, 0.1569> ]
     [ 0.8000  color rgb<0.5961, 0.3490, 0.1333> ]
     [ 1.0000  color rgb<0.7137, 0.4588, 0.2000> ]
   }

#declare CM_IW_Ash_04 = color_map {
     [ 0.0000  color rgb<0.7412, 0.6549, 0.4392> ]
     [ 0.2000  color rgb<0.7412, 0.6549, 0.4392> ]
     [ 0.4000  color rgb<0.8000, 0.7137, 0.5059> ]
     [ 0.6000  color rgb<0.8196, 0.7294, 0.5412> ]
     [ 0.8000  color rgb<0.8196, 0.7294, 0.5569> ]
     [ 1.0000  color rgb<0.8118, 0.7216, 0.5569> ]
   }

#declare CM_IW_Ash_05 = color_map {
     [ 0.0000  color rgb<0.7098, 0.5882, 0.4078> ]
     [ 0.2000  color rgb<0.7647, 0.6431, 0.4627> ]
     [ 0.4000  color rgb<0.7922, 0.6745, 0.4824> ]
     [ 0.6000  color rgb<0.8667, 0.8000, 0.6314> ]
     [ 0.8000  color rgb<0.8706, 0.8078, 0.6118> ]
     [ 1.0000  color rgb<0.8431, 0.7804, 0.5765> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Cherry_01 = color_map {
     [ 0.0000  color rgb<0.8078, 0.5098, 0.2275> ]
     [ 0.1000  color rgb<0.8471, 0.5804, 0.2863> ]
     [ 0.2000  color rgb<0.8980, 0.6314, 0.3451> ]
     [ 0.3000  color rgb<0.9333, 0.6706, 0.3922> ]
     [ 0.4000  color rgb<0.9373, 0.6902, 0.4235> ]
     [ 0.5000  color rgb<0.9059, 0.6667, 0.4196> ]
     [ 0.6000  color rgb<0.9176, 0.6824, 0.4471> ]
     [ 0.7000  color rgb<0.9569, 0.7216, 0.4863> ]
     [ 0.8000  color rgb<0.9333, 0.7176, 0.5059> ]
     [ 0.9000  color rgb<0.9725, 0.7647, 0.5765> ]
     [ 1.0000  color rgb<0.9294, 0.7373, 0.5569> ]
   }

#declare CM_IW_Cherry_02 = color_map {
     [ 0.0000  color rgb<0.5176, 0.2667, 0.0706> ]
     [ 0.2000  color rgb<0.8157, 0.5686, 0.2667> ]
     [ 0.4000  color rgb<0.8745, 0.6157, 0.2941> ]
     [ 0.6000  color rgb<0.8431, 0.5961, 0.2863> ]
     [ 0.8000  color rgb<0.8941, 0.6510, 0.3490> ]
     [ 1.0000  color rgb<0.8941, 0.6471, 0.3412> ]
   }

#declare CM_IW_Cherry_03 = color_map {
     [ 0.0000  color rgb<0.8549, 0.5451, 0.2902> ]
     [ 0.2000  color rgb<0.7294, 0.4157, 0.1647> ]
     [ 0.4000  color rgb<0.8392, 0.5569, 0.2902> ]
     [ 0.6000  color rgb<0.8431, 0.6000, 0.3176> ]
     [ 0.8000  color rgb<0.8588, 0.5961, 0.3216> ]
     [ 1.0000  color rgb<0.8431, 0.5882, 0.3020> ]
   }

#declare CM_IW_Cherry_04 = color_map {
     [ 0.0000  color rgb<0.8157, 0.5020, 0.2627> ]
     [ 0.1000  color rgb<0.7765, 0.4392, 0.2000> ]
     [ 0.2000  color rgb<0.8078, 0.4706, 0.2353> ]
     [ 0.3000  color rgb<0.8314, 0.5216, 0.2784> ]
     [ 0.4000  color rgb<0.8157, 0.5059, 0.2588> ]
     [ 0.5000  color rgb<0.8627, 0.5529, 0.2941> ]
     [ 0.6000  color rgb<0.8941, 0.5961, 0.3294> ]
     [ 0.7000  color rgb<0.8902, 0.6039, 0.3333> ]
     [ 0.8000  color rgb<0.9098, 0.6627, 0.3882> ]
     [ 0.9000  color rgb<0.9294, 0.6863, 0.4275> ]
     [ 1.0000  color rgb<0.9490, 0.7020, 0.4588> ]
   }

#declare CM_IW_Cherry_05 = color_map {
     [ 0.0000  color rgb<0.7176, 0.3608, 0.2275> ]
     [ 0.2000  color rgb<0.6510, 0.2941, 0.1882> ]
     [ 0.4000  color rgb<0.6392, 0.2824, 0.1686> ]
     [ 0.6000  color rgb<0.6980, 0.3490, 0.1961> ]
     [ 0.8000  color rgb<0.7373, 0.3922, 0.2157> ]
     [ 1.0000  color rgb<0.7529, 0.4039, 0.2392> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Pine_01 = color_map {
     [ 0.0000  color rgb<0.8784, 0.6588, 0.4941> ]
     [ 0.2000  color rgb<0.8510, 0.6275, 0.4745> ]
     [ 0.4000  color rgb<0.8824, 0.7098, 0.5922> ]
     [ 0.6000  color rgb<0.9294, 0.8000, 0.6941> ]
     [ 0.8000  color rgb<0.9765, 0.8667, 0.7608> ]
     [ 1.0000  color rgb<0.9569, 0.8078, 0.6824> ]
   }

#declare CM_IW_Pine_02 = color_map {
     [ 0.0000  color rgb<0.6549, 0.4039, 0.2902> ]
     [ 0.2000  color rgb<0.7647, 0.5647, 0.4314> ]
     [ 0.4000  color rgb<0.9608, 0.8235, 0.6941> ]
     [ 0.6000  color rgb<0.9647, 0.8667, 0.7647> ]
     [ 0.8000  color rgb<0.9725, 0.8667, 0.7608> ]
     [ 1.0000  color rgb<0.9882, 0.8980, 0.7804> ]
   }

#declare CM_IW_Pine_03 = color_map {
     [ 0.0000  color rgb<0.8706, 0.6510, 0.3333> ]
     [ 0.2000  color rgb<0.8784, 0.6549, 0.3490> ]
     [ 0.4000  color rgb<0.9216, 0.6980, 0.4000> ]
     [ 0.6000  color rgb<0.9686, 0.7686, 0.4667> ]
     [ 0.8000  color rgb<0.9490, 0.7725, 0.4706> ]
     [ 1.0000  color rgb<0.9373, 0.7843, 0.4824> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Elm_01 = color_map {
     [ 0.0000  color rgb<0.6824, 0.4196, 0.2824> ]
     [ 0.2000  color rgb<0.7647, 0.4941, 0.3608> ]
     [ 0.4000  color rgb<0.8118, 0.5569, 0.4039> ]
     [ 0.6000  color rgb<0.8078, 0.5608, 0.3961> ]
     [ 0.8000  color rgb<0.8627, 0.6314, 0.4588> ]
     [ 1.0000  color rgb<0.8667, 0.6431, 0.4667> ]
   }

#declare CM_IW_Elm_02 = color_map {
     [ 0.0000  color rgb<0.5059, 0.2078, 0.1451> ]
     [ 0.2000  color rgb<0.5529, 0.2549, 0.1608> ]
     [ 0.4000  color rgb<0.6314, 0.3412, 0.2039> ]
     [ 0.6000  color rgb<0.6941, 0.4078, 0.2431> ]
     [ 0.8000  color rgb<0.7804, 0.4863, 0.2941> ]
     [ 1.0000  color rgb<0.9765, 0.6627, 0.4627> ]
   }

#declare CM_IW_Elm_03 = color_map {
     [ 0.0000  color rgb<0.7569, 0.4706, 0.2902> ]
     [ 0.3333  color rgb<0.8235, 0.5569, 0.3647> ]
     [ 0.6667  color rgb<0.9373, 0.6980, 0.4863> ]
     [ 1.0000  color rgb<0.9804, 0.7725, 0.5490> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Robinia_01 = color_map {
     [ 0.0000  color rgb<0.5804, 0.3333, 0.1569> ]
     [ 0.1000  color rgb<0.5843, 0.3333, 0.1490> ]
     [ 0.2000  color rgb<0.6000, 0.3529, 0.1569> ]
     [ 0.3000  color rgb<0.6706, 0.4196, 0.2118> ]
     [ 0.4000  color rgb<0.7294, 0.4745, 0.2549> ]
     [ 0.5000  color rgb<0.7059, 0.4549, 0.2118> ]
     [ 0.6000  color rgb<0.7137, 0.4627, 0.2235> ]
     [ 0.7000  color rgb<0.7608, 0.5137, 0.2549> ]
     [ 0.8000  color rgb<0.8431, 0.5922, 0.3333> ]
     [ 0.9000  color rgb<0.8431, 0.5961, 0.3294> ]
     [ 1.0000  color rgb<0.8392, 0.5922, 0.3176> ]
   }

#declare CM_IW_Robinia_02 = color_map {
     [ 0.0000  color rgb<0.2235, 0.0196, 0.0000> ]
     [ 0.2000  color rgb<0.2667, 0.0588, 0.0000> ]
     [ 0.4000  color rgb<0.4667, 0.2431, 0.1098> ]
     [ 0.6000  color rgb<0.5529, 0.3255, 0.1725> ]
     [ 0.8000  color rgb<0.6157, 0.3765, 0.2118> ]
     [ 1.0000  color rgb<0.7529, 0.5098, 0.3294> ]
   }

#declare CM_IW_Robinia_03 = color_map {
     [ 0.0000  color rgb<0.5294, 0.2706, 0.1333> ]
     [ 0.2000  color rgb<0.6078, 0.3529, 0.1882> ]
     [ 0.4000  color rgb<0.7020, 0.4549, 0.2627> ]
     [ 0.6000  color rgb<0.7608, 0.5176, 0.2941> ]
     [ 0.8000  color rgb<0.7569, 0.5137, 0.2784> ]
     [ 1.0000  color rgb<0.7647, 0.5255, 0.2784> ]
   }

#declare CM_IW_Robinia_04 = color_map {
     [ 0.0000  color rgb<0.6510, 0.3843, 0.0980> ]
     [ 0.1000  color rgb<0.6706, 0.4078, 0.1098> ]
     [ 0.2000  color rgb<0.6980, 0.4314, 0.1137> ]
     [ 0.3000  color rgb<0.7725, 0.5059, 0.1725> ]
     [ 0.4000  color rgb<0.8667, 0.6039, 0.2549> ]
     [ 0.5000  color rgb<0.9020, 0.6353, 0.2902> ]
     [ 0.6000  color rgb<0.9216, 0.6588, 0.3059> ]
     [ 0.7000  color rgb<0.9098, 0.6510, 0.2824> ]
     [ 0.8000  color rgb<0.9020, 0.6471, 0.2627> ]
     [ 0.9000  color rgb<0.9333, 0.6745, 0.2863> ]
     [ 1.0000  color rgb<0.9373, 0.6824, 0.2941> ]
   }

#declare CM_IW_Robinia_05 = color_map {
     [ 0.0000  color rgb<0.5961, 0.3333, 0.1294> ]
     [ 0.2000  color rgb<0.6118, 0.3569, 0.1451> ]
     [ 0.4000  color rgb<0.6980, 0.4431, 0.2157> ]
     [ 0.6000  color rgb<0.7725, 0.5216, 0.2824> ]
     [ 0.8000  color rgb<0.8196, 0.5686, 0.3255> ]
     [ 1.0000  color rgb<0.8431, 0.5922, 0.3451> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Larch_01 = color_map {
     [ 0.0000  color rgb<0.6863, 0.3373, 0.2039> ]
     [ 0.2000  color rgb<0.6941, 0.3451, 0.2039> ]
     [ 0.4000  color rgb<0.7294, 0.3843, 0.2314> ]
     [ 0.6000  color rgb<0.8039, 0.4588, 0.3020> ]
     [ 0.8000  color rgb<0.8510, 0.4980, 0.3373> ]
     [ 1.0000  color rgb<0.8431, 0.4745, 0.3255> ]
   }


#declare CM_IW_Larch_02 = color_map {
     [ 0.0000  color rgb<0.7961, 0.3882, 0.1412> ]
     [ 0.2000  color rgb<0.8745, 0.4667, 0.2196> ]
     [ 0.4000  color rgb<0.9294, 0.5098, 0.2471> ]
     [ 0.6000  color rgb<0.9569, 0.5255, 0.2471> ]
     [ 0.8000  color rgb<0.9804, 0.5569, 0.2706> ]
     [ 1.0000  color rgb<0.9922, 0.5882, 0.3020> ]
   }


//------------------------------------------------------------------


#declare CM_IW_Chestnut_01 = color_map {
     [ 0.0000  color rgb<0.5176, 0.3294, 0.1490> ]
     [ 0.2000  color rgb<0.5255, 0.3373, 0.1569> ]
     [ 0.4000  color rgb<0.6902, 0.5020, 0.3216> ]
     [ 0.6000  color rgb<0.7804, 0.5922, 0.4039> ]
     [ 0.8000  color rgb<0.7882, 0.6000, 0.4118> ]
     [ 1.0000  color rgb<0.8078, 0.6196, 0.4235> ]
   }

#declare CM_IW_Chestnut_02 = color_map {
     [ 0.0000  color rgb<0.6275, 0.3647, 0.2745> ]
     [ 0.3333  color rgb<0.6431, 0.3804, 0.2627> ]
     [ 0.6667  color rgb<0.7294, 0.4745, 0.3333> ]
     [ 1.0000  color rgb<0.7098, 0.4549, 0.3020> ]
   }

#declare CM_IW_Chestnut_03 =
     color_map {
        [0.0 color rgb <0.8039, 0.5137, 0.3373> ]
        [0.3 color rgb <0.7451, 0.4392, 0.2902> ]
        [0.7 color rgb <0.7020, 0.4157, 0.2745> ]
        [1.0 color rgb <0.4431, 0.2078, 0.1647> ]
     }

#declare CM_IW_Chestnut_04 = color_map {
     [ 0.0000  color rgb<0.4275, 0.2000, 0.1922> ]
     [ 0.1000  color rgb<0.4353, 0.2000, 0.1882> ]
     [ 0.2000  color rgb<0.3922, 0.1412, 0.0980> ]
     [ 0.3000  color rgb<0.6627, 0.3922, 0.3059> ]
     [ 0.4000  color rgb<0.7490, 0.4627, 0.3647> ]
     [ 0.5000  color rgb<0.7176, 0.4235, 0.2941> ]
     [ 0.6000  color rgb<0.7412, 0.4353, 0.2941> ]
     [ 0.7000  color rgb<0.7412, 0.4314, 0.2824> ]
     [ 0.8000  color rgb<0.7569, 0.4471, 0.2902> ]
     [ 0.9000  color rgb<0.7490, 0.4392, 0.2941> ]
     [ 1.0000  color rgb<0.7373, 0.4314, 0.2902> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Spruce_01 = color_map {
     [ 0.0000  color rgb<0.4745, 0.2667, 0.1686> ]
     [ 0.2000  color rgb<0.6510, 0.4353, 0.3373> ]
     [ 0.4000  color rgb<0.7451, 0.5333, 0.4314> ]
     [ 0.6000  color rgb<0.7373, 0.5255, 0.4235> ]
     [ 0.8000  color rgb<0.7882, 0.5843, 0.4824> ]
     [ 1.0000  color rgb<0.8039, 0.6039, 0.4980> ]
   }

#declare CM_IW_Spruce_02 = color_map {
     [ 0.0000  color rgb<0.7020, 0.4549, 0.2627> ]
     [ 0.2000  color rgb<0.7294, 0.5137, 0.3373> ]
     [ 0.4000  color rgb<0.8824, 0.6902, 0.5294> ]
     [ 0.6000  color rgb<0.9529, 0.7608, 0.6000> ]
     [ 0.8000  color rgb<0.9176, 0.7255, 0.5647> ]
     [ 1.0000  color rgb<0.9098, 0.7176, 0.5569> ]
   }

#declare CM_IW_Spruce_03 = color_map {
     [ 0.0000  color rgb<0.8039, 0.5725, 0.4157> ]
     [ 0.2000  color rgb<0.8118, 0.5804, 0.4235> ]
     [ 0.4000  color rgb<0.8431, 0.6118, 0.4549> ]
     [ 0.6000  color rgb<0.8431, 0.6118, 0.4549> ]
     [ 0.8000  color rgb<0.8431, 0.6118, 0.4549> ]
     [ 1.0000  color rgb<0.8549, 0.6196, 0.4706> ]
   }

//------------------------------------------------------------------


#declare CM_IW_Douglas_01 = color_map {
     [ 0.0000  color rgb<0.7216, 0.4235, 0.3294> ]
     [ 0.2000  color rgb<0.7216, 0.4235, 0.3294> ]
     [ 0.4000  color rgb<0.7020, 0.4039, 0.3020> ]
     [ 0.6000  color rgb<0.7765, 0.4784, 0.3686> ]
     [ 0.8000  color rgb<0.8392, 0.5451, 0.4235> ]
     [ 1.0000  color rgb<0.8196, 0.5216, 0.3843> ]
   }

#declare CM_IW_Douglas_02 = color_map {
     [ 0.0000  color rgb<0.8941, 0.5961, 0.3412> ]
     [ 0.2000  color rgb<0.8706, 0.6078, 0.3529> ]
     [ 0.4000  color rgb<0.8392, 0.6275, 0.3922> ]
     [ 0.6000  color rgb<0.8941, 0.7176, 0.4980> ]
     [ 0.8000  color rgb<0.9725, 0.8039, 0.5843> ]
     [ 1.0000  color rgb<0.9686, 0.8039, 0.5725> ]
   }

#declare CM_IW_Douglas_03 = color_map {
     [ 0.0000  color rgb<0.6039, 0.3373, 0.1882> ]
     [ 0.2000  color rgb<0.6471, 0.3804, 0.2275> ]
     [ 0.4000  color rgb<0.7569, 0.5098, 0.3412> ]
     [ 0.6000  color rgb<0.8157, 0.5765, 0.4039> ]
     [ 0.8000  color rgb<0.8275, 0.6000, 0.4314> ]
     [ 1.0000  color rgb<0.8157, 0.5961, 0.4471> ]
   }

#declare CM_IW_Douglas_04 = color_map {
     [ 0.0000  color rgb<0.6431, 0.3176, 0.0824> ]
     [ 0.1000  color rgb<0.6196, 0.2824, 0.0588> ]
     [ 0.2000  color rgb<0.7137, 0.3725, 0.1529> ]
     [ 0.3000  color rgb<0.7529, 0.4157, 0.1922> ]
     [ 0.4000  color rgb<0.8157, 0.4941, 0.2588> ]
     [ 0.5000  color rgb<0.7686, 0.4745, 0.2196> ]
     [ 0.6000  color rgb<0.8471, 0.5647, 0.2980> ]
     [ 0.7000  color rgb<0.8627, 0.5843, 0.3137> ]
     [ 0.8000  color rgb<0.8902, 0.6314, 0.3529> ]
     [ 0.9000  color rgb<0.8627, 0.6118, 0.3294> ]
     [ 1.0000  color rgb<0.8392, 0.5922, 0.3098> ]
   }

#declare CM_IW_Douglas_05 = color_map {
     [ 0.0000  color rgb<0.4431, 0.1647, 0.0157> ]
     [ 0.1000  color rgb<0.4353, 0.1490, 0.0157> ]
     [ 0.2000  color rgb<0.5569, 0.2824, 0.0980> ]
     [ 0.3000  color rgb<0.6863, 0.4275, 0.2196> ]
     [ 0.4000  color rgb<0.7137, 0.4627, 0.2353> ]
     [ 0.5000  color rgb<0.7765, 0.5216, 0.3059> ]
     [ 0.6000  color rgb<0.7882, 0.5255, 0.3216> ]
     [ 0.7000  color rgb<0.8078, 0.5412, 0.3373> ]
     [ 0.8000  color rgb<0.8157, 0.5569, 0.3255> ]
     [ 0.9000  color rgb<0.8431, 0.5922, 0.3451> ]
     [ 1.0000  color rgb<0.8588, 0.6118, 0.3529> ]
   }

#declare CM_IW_Douglas_06 = color_map {
     [ 0.0000  color rgb<0.8353, 0.5608, 0.2863> ]
     [ 0.2000  color rgb<0.8118, 0.5569, 0.2784> ]
     [ 0.4000  color rgb<0.8235, 0.5922, 0.3059> ]
     [ 0.6000  color rgb<0.8353, 0.6196, 0.3294> ]
     [ 0.8000  color rgb<0.8627, 0.6510, 0.3686> ]
     [ 1.0000  color rgb<0.9176, 0.7098, 0.4314> ]
   }

//------------------------------------------------------------------

