#version unofficial MegaPov 0.6;

#include "colors.inc"
#include "textures.inc"
#include "isowood2.inc"
#include "IW_TexA.inc"

                      
//Switch to determine whether wooden_house appears or not
#declare WoodenHouse_On = 1;
                      

//#declare Use_with_FireAndWater = 1;
#declare Use_with_Jetty = 1;
                      
//Include wooden_house
#if(WoodenHouse_On)
	#include "wooden_house.pov"            
#end	




#declare CH_Wood_Quality = 1;		//0 = Box, no texture
											//1 = Box, with texture
											//2 = Isosurface (take ages to calculate)

//If this file is not being used in conjunction with the Fire_and_Water main file then
//setup a background, camera and light       
#ifndef(Use_with_FireAndWater)

	background {White}
	
	  camera {
	    angle 25
	    location <5,200,-170>	//Looking straight on - slightly above
	    //location <50,15, 0>		//Looking from the right
	    //location <-50,15, 0>	//Looking from the left
	    //location <0, 150, 0>		//Looking from above
	    look_at <-20,5,40>
	  }         
	 
	light_source
	{
	  <0, 1000, -1000>
	  color rgb 1
	}
	     
	light_source
	{
	  <-1000, 1000, 0>
	  color rgb 1
	}
	     
	     
	light_source
	{
	  <0, 10, 500>
	  color rgb 1
	}  
#end	
	
  
/*
// create a box that extends between the 2 specified points
box
{
  <-100, -1, -100>  // one corner position <X1 Y1 Z1>
  < 100,  1,  100>  // other corner position <X2 Y2 Z2>
  pigment {Grey}
}
*/
 

//========================================================================
//Start of jetty_section

#declare jetty_section =
	union { 
	 
	#declare plank =
	object {      //===== distorted plank =====
	  Wood_Plank_02  (17, 0.3, 1.6, 25, 2, 0, 0.018, 0.0035, 0.005,
	    pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	
	  //rotate -100*x
	  rotate 90*z
	  //rotate 90*y
	  translate < 3.3, 3.8, 0.9>
	 // scale <3, 3, 3>
	}       
	
	#declare Count=0;
	#while (Count < 5)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 10, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     //rotate -100*x
	     //rotate 90*z
	     //rotate 90*y
	     //translate < 3.3, 3.8, 0.9>
	     //translate y*0.35*Count
	     //translate < 2.0, (0.5*Count)+3.8, -(Count*2.0)>
	     translate < 0, 0, (Count*2.1)>
	    // scale <3, 3, 3>
	   }        
	   #declare Count=Count+1;
	#end
	
	//========================================================================
	//Side planks
	
	#declare side_plank = 
	object {
	 			Wood_Plank_02  (17, 10, 0.3, 1.0, 2, 0, 0.018, 0.0035, 0.005,
	       	pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	       	rotate <90, 0, 0>
	       	//scale <10,10,10>
	       	translate <0, 0, 0>
			 }	
			 
	object {side_plank}
	object {
				side_plank
				rotate <0, 90, 0>
				translate <0, 0, 10>	
			 }		        
	object {
				side_plank
				rotate <0, -90, 0>
				translate <10, 0, 0>	
			 }			 
	
	//End of side planks
	//========================================================================		 
	
	//========================================================================		 
	//End posts		                                                           
	
	#local post_height = 10.0
	
	#declare End_Post =
	object {
			  Wood_Cyl_01 (15, 0.7, post_height, 0, 0, 5.0, pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
			  rotate <90, 0, 0>
			  translate <-0.4, 2, 0.7>
			 }
			 
	object {End_Post}
	object {
				End_Post
				translate <10.8, 0, 0>
			 }	

}                                                                         
//End of Jetty section
//========================================================================

#local Count = 0;				//Loop variable
#declare jetty_length = 10;
 
 
#declare jetty_1st_part = union
{
	#while (Count < jetty_length )
		object {
				  jetty_section
				  translate <0, 0,(10.5*Count)>
				 }
		#local Count=Count+1;  //increment loop counter				 
	#end				                   
}


#local Count = 0;				//Loop variable
#declare jetty_length = 15;

#declare jetty_2nd_part = union
{
	#while (Count < jetty_length )
		object {
				  jetty_section
				  translate <0, 0,(10.5*Count)>
				 }
		#local Count=Count+1;  //increment loop counter				 
	#end				                   
}


/*
union {
		object {
				  jetty_section
				  translate <0, 0, 0>
				 }                  
				 
		object {
					jetty_section
					translate <0, 0, 10.5>	
				 }
		object {
					jetty_section
					translate <0, 0, 10.5+10.5>	
				 } 
}
*/        

        
                     
//================================================================================================                     
//Main jetty + houses
#declare jetty2 = union
{
	object {jetty_1st_part}
	object {
				jetty_2nd_part
				rotate <0, -90, 0>
				translate <10*15/2, 5, 10.5*10>  		//10 is the jetty length of the first section
																	//15 is the jetty lenght of the second section
																	
	
				translate <-1, 0, 0>  						//Minor adjustment - shift jetty left slightly															
			 }
		 

	object {
			  wooden_house
			  translate <-70, 5, 116>
			  }

	object {
			  wooden_house
			  translate <-40, 5, 116>
			  }
	object {
			  wooden_house
			  translate <-10, 5, 116>
			  }

	object {
			  wooden_house
			  translate <20, 5, 116>
			  }
			  		 
		 
}

//End of jetty + houses
//==================================================================================================		 

#ifndef(Use_with_FireAndWater)
	object {jetty2}			  

#end

				        
				        
				        