#version unofficial MegaPov 0.6;

#include "colors.inc"
#include "textures.inc"
#include "isowood2.inc"
#include "IW_TexA.inc"

#declare CH_Wood_Quality = 1;		//0 = Box, no texture
											//1 = Box, with texture
											//2 = Isosurface (take ages to calculate)

//If this file is not being used in conjunction with the Fire_and_Water main file then
//setup a background, camera and light       
#ifndef(Use_with_FireAndWater)
	#ifndef(Use_with_Jetty)

		background {Black}
		
		  camera {
		    angle 40
		    //location <5,200,-170>	//Looking straight on - slightly above 
		    
		    location <15,10,-50>	//Looking straight on - slightly above
		    //location <80,10,-20>	//Looking from the right
		    
		    //location <-20,10,-20>	//Looking from the left		    
		    
		    //location <0,10,50>	//Looking from behind
		    
		    //location <-20,10,60>	//Looking from behind and to the right
		    
		    
		    //location <120,10,5>	//Looking straight on - slightly above
		    
		    //location <50,15, 0>		//Looking from the right
		    //location <-50,15, 0>	//Looking from the left
		    //location <0, 150, 0>		//Looking from above
		    look_at <15,5,0>
		  }         

/*		 
		light_source
		{
		  <0, 1000, -1000>
		  color rgb 1
		}
		     
		light_source
		{
		  <-1000, 1000, 0>
		  color rgb 1
		}
		     
		     
		light_source
		{
		  <0, 10, 500>
		  color rgb 1
		}  
		
		light_source
		{
		  <1000, -100, -500>
		  color rgb 1
		} 
*/		
	#end		
#end	

	     
  
/*
// create a box that extends between the 2 specified points
box
{
  <-100, -1, -100>  // one corner position <X1 Y1 Z1>
  < 100,  1,  100>  // other corner position <X2 Y2 Z2>
  pigment {Grey}
}
*/
 

//========================================================================
//Start of house


//=================================================================================
//Two boxes which will be used in CSG Difference to make the angled roof section
#declare two_boxes = union
{
				        
	// create a box that extends between the 2 specified points
	box
	{
	  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale <16, 6, 5>
	  translate <14, 15, 0>
	  rotate <45, 0, 0>
	  translate <0, 7, -10>
	}
	
	
	box
	{
	  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale <16, 6, 5>
	  translate <14, 15, 0>
	  rotate <-45, 0, 0>
	  translate <0, 7, 27>
	}
}
//End of two_boxes declaration
//=============================================================================



#local plank_gap = 1.65

#declare floor_section =
union {
	
	#declare Count=0;
	#while (Count < 17)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 17, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap)>
	    // scale <3, 3, 3>
	   }
	           
		#declare Count=Count+1;
	#end
}

#declare roof_section =
union {
	
	#declare Count=0;
	#while (Count < 19)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 10, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap)>
	    // scale <3, 3, 3>
	   }
	           
		#declare Count=Count+1;
	#end
}

#declare back_section =
union {
	
	#declare Count=0;
	#while (Count < 17)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 10, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap)>
	    // scale <3, 3, 3>
	   }
	           
		#declare Count=Count+1;
	#end
}

#declare wall_section =
union {
	
	#declare Count=0;
	#while (Count < 10)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 15, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap)>
	    // scale <3, 3, 3>
	   }
	           
		#declare Count=Count+1;
	#end
}



#declare front_section =
union {
	
	#declare Count=0;
	#while (Count < 2)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 10, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap)>
	    // scale <3, 3, 3>
	   }
	           
		#declare Count=Count+1;
	#end
	
	#local plank_offset = Count * plank_gap
	
	#declare Count=0;
	#while (Count < 3)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 6, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap) + plank_offset>
	    // scale <3, 3, 3>
	   }        
	   #declare Count=Count+1;
	#end	
   
	#local plank_offset = plank_offset + (Count * plank_gap)
   
	#declare Count=0;
	#while (Count < 2)
	   //object{plank translate y*0.35*Count}
	   object {      //===== distorted plank =====
	     Wood_Plank_02  (Count, 10, 0.3, 1.6, 2, 0, 0.018, 0.0035, 0.005,
	       pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
	   
	     translate < 0, 0, (Count*plank_gap) + plank_offset>
	    // scale <3, 3, 3>
	   }
	           
		#declare Count=Count+1;
	#end


	
}

//========================================================================================
// Declare supporting post

#local post_height = 10.0

#declare End_Post =
object {
		  Wood_Cyl_01 (15, 0.7, post_height, 0, 0, 5.0, pigment { P_IW_07 scale 1.6 } , Fin_W , Norm_W)
		  rotate <90, 0, 0>
		  translate <-0.4, 2, 0.7>
		 }

//========================================================================================


	
//Recalculate how far across the left section of the house is
#local plank_offset = plank_offset + (Count * plank_gap)

#local door_width = 3



#declare wooden_house =
	union
   {
		object {
				  front_section
				  rotate <0, 90, 0>
				  rotate <90, 0, 0>
				  }
				  
		object {
				  front_section
				  rotate <0, 90, 0>
				  rotate <90, 0, 0>
				  translate <plank_offset + door_width*plank_gap, 0, 0>
				  }
				  
		object {
				  floor_section
				  rotate <0, 90, 0>
				  translate <0, 0, 17>
				  }			  
				  
		difference
				  {
				   object {
				   			wall_section
							   rotate <0, 0, 90>
							   translate <0, 0, 0>
							  }
							  
					object {two_boxes}


				  }			  
				  
		difference
					{				  
						object {
								  wall_section
								  rotate <0, 0, 90>
								  translate <(plank_offset*2) + door_width*plank_gap, 0, 0>
								  }
								  
						object {two_boxes}						  
								  
					}
			
		object {
					roof_section
					rotate <0, 90, 0>
					rotate <-45, 0, 0>
					translate <-(plank_gap), 17, 7>
					}
					
		object {
					roof_section
					rotate <0, 90, 0>
					rotate <45, 0, 0>
					translate <-(plank_gap), 10, 17>
					}					
					
		object {
					back_section
				  rotate <0, 90, 0>
				  rotate <90, 0, 0>
				  translate <0, 0, 17>					
				 }
				 
		object {
				  End_Post
				 }
		object {
		        End_Post
		        translate <28, 0, 0>
		       }
		       
		object {
		        End_Post
		        translate <28, 0, 17>
		       }
		object {
		        End_Post
		        translate <0, 0, 17>
		       }
		       
		//==========================================================
		/* Put a yellow light inside the wooden house */	     
	     
		light_source
		{
		  <10, 5, 5>
		  color Yellow
		  fade_distance 20
		  fade_power 6
		}
		
		//========================================================== 
					  			  
	}		  



			 
	       


#ifndef(Use_with_FireAndWater)
	#ifndef(Use_with_Jetty)	
		object{
				 wooden_house
				 //rotate <0, 45, 0>
				 translate <0, 0, 0>
				 }
	#end
#end

				        
				        
/*				        
// create a box that extends between the 2 specified points
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  pigment {Green}
  scale <16, 6, 5>
  translate <14, 15, 0>
  rotate <45, 0, 0>
  translate <0, 5, -10>
}
*/

/*
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  pigment {Green}
  scale <16, 6, 5>
  translate <14, 15, 0>
  rotate <-45, 0, 0>
  translate <0, 5, 27>
}
*/				        

