#include "textures.inc"

#declare claw = union
{
        blob
        {
                cylinder
                {
                        <0, 0, 0 ><0, 0, 1 >,1,10
                        scale< 2, 2, 2 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, 4 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, 1 >,1,10
                        scale< 1.5, 1.5, 2 >
                }
                
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,10
                        scale< 1, 1, 2 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,10
                        scale< 1, 1, 2 >
                        rotate< 0, -45, 0 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,10
                        scale< 1, 1, 2 >
                        rotate< 0, 45, 0 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,10
                        scale< 0.75, 0.75, 1.5 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -3.5 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,10
                        scale< 0.75, 0.75, 1.5 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -3.5 >  
                        rotate< 0, -45, 0 >    
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,10
                        scale< 0.75, 0.75, 1.5 > 
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -3.5 >
                        rotate< 0, 45, 0 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,8
                        scale< 0.5, 0.5, 1 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -2 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -3.5 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,8
                        scale< 0.5, 0.5, 1 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -2 >  
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -3.5 >  
                        rotate< 0, -45, 0 >    
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,8
                        scale< 0.5, 0.5, 1 > 
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -2 >  
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -3.5 >  
                        rotate< 0, 45, 0 >
                }
                texture{ dragonskin }
        }
        blob
        {
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,2
                        scale< 0.4, 0.1, 1 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -2 >
                        rotate< -45, 0, 0 >
                        translate< 0, -1, -3.8 >
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,2
                        scale< 0.4, 0.1, 1 >
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -2 >  
                        rotate< -45, 0, 0 >
                        translate< 0, -1, -3.8 >  
                        rotate< 0, -45, 0 >    
                }
                cylinder
                {
                        <0, 0, 0 ><0, 0, -1 >,1,2
                        scale< 0.4, 0.1, 1 > 
                        rotate< -45, 0, 0 >
                        translate< 0, 0, -2 >  
                        rotate< -45, 0, 0 >
                        translate< 0, -1, -3.8 >  
                        rotate< 0, 45, 0 >
                }
                texture{ dragonclaw }
        }
}

#declare dragonbody = union
{
        blob
        {
                cylinder
                {
                        < 0, 0, 0 >< 0, 0, 1 >,1,5
                        scale< 3, 2.5, 10 >        
                        translate< 0, -7, 15 >
                        rotate< 20, 0, 0 >
                }
                cylinder
                {
                        < 0, 0, 0 >< 0, 0, 1 >,1,7
                        scale< 7, 4, 8 >        
                        translate< 0, 0, 3 >
                        rotate< 50, 0, 0 >
                }
                cylinder
                {
                        < 0, 0, 0 >< 0, 0, 1 >,1,10
                        scale< 4, 2.5, 5 >        
                        translate< 0, 0, -7 >
                        rotate< 80, 0, 0 >
                }
        }
        intersection
        {
                torus
                {
                        1, 0.4
                        scale< 5, 5, 5 >
                }
                box
                {
                        < -1, -1, -1 >< 1, 1, 1 >
                        scale< 5, 5, 5 >
                        translate< -5, 0, -5 >
                }
                rotate< 90, 90, 0 >
                translate< 0, 6, -6 >
        }
        texture{ dragonskin }
}

#declare eye = union
{
        sphere
        {
                < 0, 0, 0 >,1 
        }
        scale< 2, 1.75, 2 >
        texture{ dragoneye }
}

#declare dragonhead = union
{
        difference
        {
                blob
                {
                        #declare dcount = -100;
                        #while( dcount < 100 )
                        cylinder
                        {
                                < 0, 0, 0 >< 0, 0, 1 >,1,5
                                scale< 0.5, 0.5, 2 >
                                translate< 0, 0, 1 >
                                rotate< 0, dcount, 0 >
                                rotate< -30, 0, 0 >
                        }
                        #declare dcount = dcount + 15;
                        #end
                        cylinder
                        {
                                < 0, 0, 0 >< 0, 0, 1 >,1,10
                                scale< 1.25, 1.5, 2 >
                        }
                        cylinder
                        {
                                < 0, 0, 0 >< 0, 0, -1 >,1,5
                                scale< 2, 0.75, 2 >
                                translate< 0, 0, -1 >
                                rotate< 5, 0, 0 >
                        }
                        cylinder
                        {
                                < 0, 0, 0 >< 0, 0, -1 >,1,5
                                scale< 2, 1, 1.5 >       
                                translate< 0, 0, -1 >
                                rotate< -25, 0, 0 >
                        }
                        rotate< -15, 0, 0 >
                        scale< 2.5, 2.5, 2 >
                        texture{ dragonskin }
                }
                sphere
                {
                        < 0, 0, 0 >, 1
                        scale< 3.5, 2, 15 >
                        rotate< -33, 0, 0 >
                        translate< 0, -1, -1 >
                        texture{ dragonmouth }
                }
        }
        object
        {
                eye
                translate< -1, 0, -1.5 >
        }
        object
        {
                eye
                translate< 1, 0, -1.5 >
        }
}

#declare dragonwings = union
{
        difference
        {
                torus
                {
                        1, 0.1
                }
                box
                {
                        < -2, -2, -2 > < 2, 2, 0 >
                }

        }
        union
        {
                union
                {
                        sphere
                        {
                                < 0, 0, 0 >,1
                        }
                        difference
                        {
                                torus
                                {
                                        1, 0.07
                                }
                                union
                                {
                                        box
                                        {
                                                < 0.0, -2, -2 ><2, 2, 2 >
                                        }
                                        box
                                        {
                                                < -2, -2, 0.0 ><2, 2, 2 >
                                        }
                                }
                                translate< 0, 0, 1 >
                                scale< 10, 10, 10 >
                        }
                        translate< -10, 0, 0 >
                }
                union
                {
                        sphere
                        {
                                < 0, 0, 0 >,1
                        }
                        difference
                        {
                                torus
                                {
                                        1, 0.07
                                }
                                union
                                {
                                        box
                                        {
                                                < -2, -2, -2 ><0.0, 2, 2 >
                                        }
                                        box
                                        {
                                                < -2, -2, 0.0 ><2, 2, 2 >
                                        }
                                }
                                translate< 0, 0, 1 >
                                scale< 10, 10, 10 >
                        }
                        translate< 10, 0, 0 >
                }
                difference
                {
                        mesh
                        {
                                triangle{< -1, -1, -1 >< 1, -1, -1 >< 1, -1, 1 >}
                                triangle{< 1, -1, 1 >< -1, -1, 1 >< -1, -1, -1 >}
                                translate< 0, 1, 0 >
                                scale< 20, 10, 10 >
                        }
                        
                        union
                        {
                                union
                                {
                                        cylinder
                                        {
                                                <0, -1, 0 ><0, 1, 0 >,1
                                                scale< 1, 1, 0.5 >
                                        }
                                        cylinder
                                        {
                                                <0, -1, 0 ><0, 1, 0 >,1
                                                scale< 2.2, 1, 1 >
                                                translate< 0, 0, 1.5 >
                                        }
                                        scale< 10, 10, 10 >
                                }
                                difference
                                {
                                        box
                                        {
                                                < -2, -1, -1 >< 2, 0, 1 >
                                                scale< 10, 10, 10 >
                                        }
                                        union
                                        {
                                                cylinder
                                                {
                                                        <0, -2, 0 ><0, 2, 0 >,1
                                                        translate< 0, 0, 1 >
                                                        scale< 10, 10, 10 >
                                                        translate< -10, 0, 0 >
                                                }
                                                cylinder
                                                {
                                                        <0, -2, 0 ><0, 2, 0 >,1
                                                        translate< 0, 0, 1 >
                                                        scale< 10, 10, 10 >
                                                        translate< 10, 0, 0 >
                                                }
                
                                        }
                                }
                                translate< 0, 5, 0 >
                        }
                        texture{ wingskin }
                }
                scale< 0.1, 0.15, 0.2 >
        }
}


#declare dragon = union
{       
        object
        {
                dragonwings
                scale< 30, 20, 20 >
                rotate< 60, 0, 0 >
                translate< 0, 30, -10 >
                texture{ dragonskin }
        }
        object
        {
                dragonhead
                translate< 0, 19.5, -10 >
        }
        object
        {
                dragonbody
                translate< 0, 10, 0 >
        }
        object
        {
                claw
                translate< -5, 0, 0 >
        }
        object
        {
                claw
                translate< 5, 0, 0 >
        }
}
