#include "knight.inc"
#include "dragon.inc"
#include "arms.inc"

camera
{
        location< 0, 0, 0 >
        look_at< 0, 0, 1 >
        
        //translate< 0, 0, -100 >
        //rotate< 0, 90, 0 >
        translate< 0, 10, -25 >
        rotate< 0, 20, 0 >    
        //rotate< 0, 0, 0 >
        
        //Planet Surface
        translate< 0, 100000, 0 >
        rotate< -30, 0, 0 >
        rotate< 0, -40, 0 >
        
        //Solar Orbit
        translate< 0, 0, 1000000 >
}

//Sun Light (faked Area-Light)
#declare Angle = 0;
#while( Angle < 360 )
        light_source
        {
                <0, 0, 0 >
                color rgb< 0.1, 0.09, 0.08 >
                
                //translate< 0, 0, 0 >        
                translate< 0, 100000, 0 >
                rotate< 0, 0, Angle >
        }
        #declare Angle = Angle + 45;
#end

union
{       
        //Planet
        union
        {       
                sphere
                {
                        < 0, 0, 0 >,1   
                        scale< 100000, 100000, 100000 >
                        texture{ surface rotate< 90, 0, 0 >}
                }
                sphere
                {
                        < 0, 0, 0 >,1   
                        material{ Mist }
                        scale< 250, 50, 250 >
                        translate< 0, 100000, 0 >
                        hollow
                }
                sphere
                {
                        < 0, 0, 0 >,1   
                        material{ Atmosphere }
                        scale< 105000, 105000, 105000 >
                        hollow
                }
        }
        
        //Scene
        union
        {       
                //Ambient Light
                light_source
                {
                        <0, 0, 0 >
                        color rgb< 0.25, 0.25, 0.25 >
                        
                        translate< 0, 10, 0 >
                        
                        shadowless
                }
                
                //Dragonfire
                union
                {       
                        light_source
                        {
                                < 0, 17, 17 >
                                color rgb< 2, 1, 0 >
                                spotlight
                                radius 1
                                falloff 10
                                point_at< 0, 2, -5 >
                        }
                        
                        light_source
                        {
                                < 0, 17, 17 >
                                color rgb< 1, 0.5, 0 >
                                fade_power 2
                                fade_distance 10
                        }
                        sphere
                        {
                                < 0, 0, 0 >, 1
                                material{ Fire } 
                                scale< 3, 3, 15 >
                                rotate< -33, 0, 0 >
                                translate< 0, 10, 6 >
                                hollow
                        }                        
                        translate< 0, 5, 0 >
                }
                 
                union
                {       
                        object
                        {
                                knight 
                        }
                        object
                        {
                                sword 
                                scale< 0.1, 0.1, 0.1 >
                                //rotate< 0, 110, 0 >
                                rotate< 0, 0, -20 >
                                rotate< -30, 0, 0 >
                                translate< -2.7, 1.0, -0.6 >
                        }
                        object
                        {
                                shield
                                translate< 0, -1, 0 >
                                scale< 2, 2, 2 >
                                rotate< -45, 0, 0 >
                                rotate< 0, -30, 0 >
                                translate< 1, 3, 2.5 >
                
                        }
                        translate< 0, 5, -10 >
                } 
                
                object
                {
                        dragon
                        translate< 0, 5, 30 >
                }
                 
                height_field
                {
                        png "hf"
                        smooth on
                        texture{ rocks }
                        scale< 100, 5, 100 >
                        translate< -50, 0, -10 >
                }
                translate< 0, 100000, 0 >
        }
        rotate< -30, 0, 0 >
        rotate< 0, -40, 0 >
        translate< 0, 0, 1000000 >
}