#include "colors.inc"
#include "stones.inc"

#declare steel = texture
{
        pigment
        { 
                bozo
                color_map
                {
                        [0.0 color rgb< 0.45, 0.5, 0.6 > ]
                        [0.5 color rgb< 0.75, 0.8, 0.9 > ]
                        [1.0 color rgb< 0.85, 0.9, 1 > ]
                }
                lambda 0.5
                omega 0.8
        }
        normal
        {
                //dents
                agate
                bump_size 0.1
                scale< 0.8, 0.8, 0.8 >
        }
        finish
        {
                reflection 0.15
                phong 0.3
                ambient 0
        }
}

#declare polished_steel = texture
{
        pigment{ color rgb< 0.85, 0.9, 1 > }
        finish
        {
                reflection 1
                phong 1.0
                ambient 0
        }
}

#declare metal = texture
{
        pigment{ color rgb< 0.85, 0.9, 1 > }
        normal
        {
                bumps
                bump_size 0.5
                scale< 0.25, 0.25, 0.25 >
        }
        finish
        {
                phong 0.8
                reflection 0.1
                ambient 0
        }
}

#declare dragonskin = texture
{
        pigment
        {
                agate
                color_map
                {
                        [ 0.0 color rgb< 0.5, 0.8, 0.25 > ]
                        [ 1.0 color rgb< 0.75, 1, 0.5 > ]
                }
                scale 5
        }
        normal
        {
                crackle
                scale 0.5
        }
        finish
        {
                ambient 0
                phong 0.1
        }
        rotate< 0, 0, 45 >
}

#declare dragonclaw = texture
{
        pigment
        {
                color rgb< 1, 0.75, 0.25 >
        }
        normal
        {
                wood
                scale< 0.1, 1, 0.1 >
        }
        finish
        {
                ambient 0
        }
}

#declare dragoneye = texture
{
        pigment
        {
                color rgb< 1, 0.8, 0 > 
        }
        finish
        {
                ambient 0
                reflection 0.2
                phong 1
        }
}

#declare dragonmouth = texture
{
        pigment
        {
                color rgb< 1, 0.25, 0 >
        }
        normal
        {
                bumps
        }
        finish
        {
                ambient 0
                //reflection 0.1
                phong 0.5
        }
}

#declare wingskin = texture
{
        pigment
        {
                agate
                color_map
                {
                        [ 0.0 color rgbf< 0.5, 0.8, 0.25, 0.25 > ]
                        [ 1.0 color rgbf< 0.75, 1, 0.5, 0.5 > ]
                }
                scale 5
        }
        normal
        {
                agate
                scale 2
        }
        finish
        {
                ambient 0
        }
}

#declare gold = texture
{
        pigment
        {
                color rgb< 1, 0.8, 0 >
        }
        normal
        {
                onion
                bump_size 0.5
                scale< 0.5,0.5,0.5 >
        }
        finish
        {
                reflection 0.5
                phong 1.0
        }
}

#declare ruby = texture
{
        pigment{ color rgbt< 1, 0.2, 0, 0.2 > }
        finish
        {
                ambient 0
                phong 1.0
        }
}

#declare rocks = texture
{
        pigment
        { 
                //bozo
                slope y, y, <0.3, 1>, <0, 4>
        	color_map 
        	{ 
                        [ 0.2 color rgb< 5, 0.5, 0 > ]
                        [ 0.2 color rgb< 0.4, 0.4, 0.5 > ]
        	}
        	/*
                color_map
                {
                        //[ 0.2 color rgb< 0.2, 0.1, 0.15 > ]
                }*/
                turbulence 2
                lambda 0.5
        }
        normal
        {
                agate
                bump_size 2
                scale< 0.1, 0.1, 0.1 >
        }
        finish
        {
                ambient 0
        }
}

#declare surface = texture
{
        pigment
        {
                bozo
                color_map
                {
                        [ 0.0 rgbt< 0.2, 0.0, 0.0, 0.0 > ]
                        [ 0.2 rgbt< 0.4, 0.2, 0.0, 0.0 > ]
                        [ 0.4 rgbt< 0.6, 0.4, 0.0, 0.0 > ]
                        [ 0.6 rgbt< 0.8, 0.6, 0.0, 0.0 > ]
                        [ 0.8 rgbt< 1.0, 0.8, 0.0, 0.0 > ]
                }
                turbulence 0.5
                lambda 4.0
                omega 0.55
        }
        finish
        {
                ambient 0.0
        }
        scale< 100, 100, 100 >
}

#declare Fire = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }
        interior
        {
                media
                {
                        emission rgb < 12, 7, 3 >
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.4  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.7  rgb <0.01, 0.0, 0.01> ]
                                        [ 0.8  rgb <0.4, 0.01, 0.0> ]
                                        [ 0.9  rgb <0.6, 0.4, 0.01> ]
                                        [ 1.0  rgb <0.8, 0.6, 0.4> ]
                                }
                                turbulence 0.3
                                omega 0.8
                                triangle_wave
                        }
                }
        }
}
 
#declare Mist = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }
        interior
        {
                media
                {       
                        scattering
                        { 
                                    1
                                    rgb<1, 1, 1.2>
                                    extinction 0
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 500.0  rgb <1, 1, 1> ]
                                }
                                turbulence 1
                                omega 0.55
                                lambda 5.0
                                triangle_wave
                        }
                }
        }
}

#declare Atmosphere = material
{
        texture
        {
                pigment
                {
                        color rgbt <1.0,1.0,1.0,1.0>
                }
        }
        interior
        {
                media
                {       
                        scattering
                        { 
                                    1
                                    rgb<2, 3, 5>
                                    extinction 0
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 10000.0  rgb <1, 1, 1> ]
                                }
                        }
                }
        }
}