//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 43 materials and 540 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 08/30/2001    (30.08.2001)
//



/* // Scene Comment

This scene was created with Moray V3.3 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam1
  location  <     33.248,     -38.807,      39.452>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.40735,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         65.50000    // Vertical      49.125
  look_at   <     -5.177,      16.806,      34.455>
}

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  fade_distance  50.0
  fade_power 3.0
  scale 1.5
  translate  76.0*z
}



//
// ********  MATERIALS  *******
//

#include "js_game.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare RndCube002 = merge {
  sphere { <100.1250, 0.8750, 1.8750>, 0.1250 }
  sphere { <100.1250, -0.8750, 1.8750>, 0.1250 }
  sphere { <-100.1250, -0.8750, 1.8750>, 0.1250 }
  sphere { <-100.1250, 0.8750, 1.8750>, 0.1250 }
  sphere { <100.1250, 0.8750, -1.8750>, 0.1250 }
  sphere { <100.1250, -0.8750, -1.8750>, 0.1250 }
  sphere { <-100.1250, -0.8750, -1.8750>, 0.1250 }
  sphere { <-100.1250, 0.8750, -1.8750>, 0.1250 }
  cylinder { <100.1250, 0.8750, 1.8750>, <-100.1250, 0.8750, 1.8750>, 0.1250 }
  cylinder { <100.1250, -0.8750, 1.8750>, <-100.1250, -0.8750, 1.8750>, 0.1250 }
  cylinder { <100.1250, -0.8750, -1.8750>, <-100.1250, -0.8750, -1.8750>, 0.1250 }
  cylinder { <100.1250, 0.8750, -1.8750>, <-100.1250, 0.8750, -1.8750>, 0.1250 }
  cylinder { <100.1250, 0.8750, -1.8750>, <100.1250, 0.8750, 1.8750>, 0.1250 }
  cylinder { <100.1250, -0.8750, -1.8750>, <100.1250, -0.8750, 1.8750>, 0.1250 }
  cylinder { <-100.1250, -0.8750, -1.8750>, <-100.1250, -0.8750, 1.8750>, 0.1250 }
  cylinder { <-100.1250, 0.8750, -1.8750>, <-100.1250, 0.8750, 1.8750>, 0.1250 }
  cylinder { <100.1250, 0.8750, 1.8750>, <100.1250, -0.8750, 1.8750>, 0.1250 }
  cylinder { <100.1250, 0.8750, -1.8750>, <100.1250, -0.8750, -1.8750>, 0.1250 }
  cylinder { <-100.1250, 0.8750, -1.8750>, <-100.1250, -0.8750, -1.8750>, 0.1250 }
  cylinder { <-100.1250, 0.8750, 1.8750>, <-100.1250, -0.8750, 1.8750>, 0.1250 }
  box { <-100.1250, -0.8750, -2.0000> <100.1250, 0.8750, 2.0000> }
  box { <-100.1250, -1.0000, -1.8750> <100.1250, 1.0000, 1.8750> }
  box { <-100.2500, -0.8750, -1.8750> <100.2500, 0.8750, 1.8750> }
  material {
    WoodBoardTexture
    rotate -90.0*y
  }
  translate  <100.0, -1.0, 2.0>
}
#declare CSG015 = difference {
  object { RndCube002 }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.25, 2.25>
    translate  <-0.5, -1.0, 2.0>
  }
  translate  2.1*x
}
#declare RndCube003 = merge {
  sphere { <0.8750, 100.1250, 1.8750>, 0.1250 }
  sphere { <0.8750, -100.1250, 1.8750>, 0.1250 }
  sphere { <-0.8750, -100.1250, 1.8750>, 0.1250 }
  sphere { <-0.8750, 100.1250, 1.8750>, 0.1250 }
  sphere { <0.8750, 100.1250, -1.8750>, 0.1250 }
  sphere { <0.8750, -100.1250, -1.8750>, 0.1250 }
  sphere { <-0.8750, -100.1250, -1.8750>, 0.1250 }
  sphere { <-0.8750, 100.1250, -1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, 1.8750>, <-0.8750, 100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, -100.1250, 1.8750>, <-0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, -100.1250, -1.8750>, <-0.8750, -100.1250, -1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, -1.8750>, <-0.8750, 100.1250, -1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, -1.8750>, <0.8750, 100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, -100.1250, -1.8750>, <0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <-0.8750, -100.1250, -1.8750>, <-0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <-0.8750, 100.1250, -1.8750>, <-0.8750, 100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, 1.8750>, <0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, -1.8750>, <0.8750, -100.1250, -1.8750>, 0.1250 }
  cylinder { <-0.8750, 100.1250, -1.8750>, <-0.8750, -100.1250, -1.8750>, 0.1250 }
  cylinder { <-0.8750, 100.1250, 1.8750>, <-0.8750, -100.1250, 1.8750>, 0.1250 }
  box { <-0.8750, -100.1250, -2.0000> <0.8750, 100.1250, 2.0000> }
  box { <-0.8750, -100.2500, -1.8750> <0.8750, 100.2500, 1.8750> }
  box { <-1.0000, -100.1250, -1.8750> <1.0000, 100.1250, 1.8750> }
  material {
    WoodBoardTexture
    rotate <-90.0, -90.0, -180.0>
  }
  translate  <1.0, -100.0, 2.0>
}
#declare CSG016 = difference {
  object { RndCube003 }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 0.5, 2.25>
    translate  <1.0, 0.5, 2.0>
  }
  translate  <14.0, -2.1, 0.0>
}


#declare Cube065 = object {
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, -9.75, 0.995192>
    scale <0.5, 0.125, 2.125>
    rotate 2.855*x
  }
}




//
// ********  OBJECTS  *******
//



#declare RndDisc015 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0900, 0.0900, 0.2500> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1150, 0.1150, 0.2000> translate 0.0250*z }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.2250*z bounded_by { box { <-0.1155, -0.1155, 0.1995>, <0.1155, 0.1155, 0.2505> } } }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.0250*z bounded_by { box { <-0.1155, -0.1155, -0.0005>, <0.1155, 0.1155, 0.0505> } } }
  material {
    PencilEraserTexture
  }
  translate  6.475*z
}
#declare CSG061 = union {
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
    translate  0.45*z
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.1>
    translate  0.2*z
  }
  torus { // Torus016
    0.105104, 0.019896  rotate -x*90
    translate  0.07*z
  }
  torus { // Torus017
    0.105104, 0.019896  rotate -x*90
    translate  0.11*z
  }
  torus { // Torus018
    0.105104, 0.019896  rotate -x*90
    translate  0.15*z
  }
  torus { // Torus019
    0.105104, 0.019896  rotate -x*90
    translate  0.19*z
  }
  torus { // Torus020
    0.105104, 0.019896  rotate -x*90
    translate  0.32*z
  }
  torus { // Torus021
    0.105104, 0.019896  rotate -x*90
    translate  0.36*z
  }
  torus { // Torus022
    0.105104, 0.019896  rotate -x*90
    translate  0.4*z
  }
  torus { // Torus023
    0.105104, 0.019896  rotate -x*90
    translate  0.44*z
  }
  material {
    PencilCapTexture
  }
  translate  6.0*z
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.0625, -0.10825>,
  <0.0625, -0.10825>,
  <0.125, 0.0>,
  <0.0625, 0.10825>,
  <-0.0625, 0.10825>,
  <-0.125, 0.0>,
  <-0.0625, -0.10825>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
}
#declare CSG062 = difference {
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.1>
    translate  -0.15*z
  }
  cone { // Cone023
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilTipTexture
  }
}
#declare CSG063 = difference {
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.1, 0.05>
    rotate 90.0*x
    translate  <0.0, -0.105, 5.5>
  }
  text {   // TText065
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.125
    rotate 90.0*x
    translate  <-0.03, -0.05, 5.46>
  }

  material {
    PencilTextTexture
  }
}
#declare CSG064 = difference {
  object { TransSweep001 }
  object { CSG062 }
  object { CSG063 }
  material {
    PencilBodyTexture
  }
}
#declare CSG065 = intersection {
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    material {
      PencilLeadTexture
    }
    scale <0.125, 0.125, 0.25>
  }
  cone { // Cone024
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilLeadTexture
  }
}
#declare Pencil = union {
  object { RndDisc015 }
  object { CSG061 }
  object { CSG064 }
  object { CSG065 }
  rotate <-90.0, -0.0, -123.458176>
  translate  <16.875572, 6.641006, 0.108251>
}
#declare RndDisc016 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0900, 0.0900, 0.2500> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1150, 0.1150, 0.2000> translate 0.0250*z }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.2250*z bounded_by { box { <-0.1155, -0.1155, 0.1995>, <0.1155, 0.1155, 0.2505> } } }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.0250*z bounded_by { box { <-0.1155, -0.1155, -0.0005>, <0.1155, 0.1155, 0.0505> } } }
  material {
    PencilEraserTexture
  }
  translate  6.475*z
}
#declare CSG066 = union {
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
    translate  0.45*z
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.1>
    translate  0.2*z
  }
  torus { // Torus024
    0.105104, 0.019896  rotate -x*90
    translate  0.07*z
  }
  torus { // Torus025
    0.105104, 0.019896  rotate -x*90
    translate  0.11*z
  }
  torus { // Torus026
    0.105104, 0.019896  rotate -x*90
    translate  0.15*z
  }
  torus { // Torus027
    0.105104, 0.019896  rotate -x*90
    translate  0.19*z
  }
  torus { // Torus028
    0.105104, 0.019896  rotate -x*90
    translate  0.32*z
  }
  torus { // Torus029
    0.105104, 0.019896  rotate -x*90
    translate  0.36*z
  }
  torus { // Torus030
    0.105104, 0.019896  rotate -x*90
    translate  0.4*z
  }
  torus { // Torus031
    0.105104, 0.019896  rotate -x*90
    translate  0.44*z
  }
  material {
    PencilCapTexture
  }
  translate  6.0*z
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.0625, -0.10825>,
  <0.0625, -0.10825>,
  <0.125, 0.0>,
  <0.0625, 0.10825>,
  <-0.0625, 0.10825>,
  <-0.125, 0.0>,
  <-0.0625, -0.10825>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
}
#declare CSG067 = difference {
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.1>
    translate  -0.15*z
  }
  cone { // Cone025
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilTipTexture
  }
}
#declare CSG068 = difference {
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.1, 0.05>
    rotate 90.0*x
    translate  <0.0, -0.105, 5.5>
  }
  text {   // TText066
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.125
    rotate 90.0*x
    translate  <-0.03, -0.05, 5.46>
  }

  material {
    PencilTextTexture
  }
}
#declare CSG069 = difference {
  object { TransSweep002 }
  object { CSG067 }
  object { CSG068 }
  material {
    PencilBodyTexture
  }
}
#declare CSG070 = intersection {
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      PencilLeadTexture
    }
    scale <0.125, 0.125, 0.25>
  }
  cone { // Cone026
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilLeadTexture
  }
}
#declare Pencil1 = union {
  object { RndDisc016 }
  object { CSG066 }
  object { CSG069 }
  object { CSG070 }
  rotate <-90.0, -120.0, 160.819397>
  translate  <-0.016909, 16.551001, 0.108251>
}
#declare RndDisc017 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0900, 0.0900, 0.2500> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1150, 0.1150, 0.2000> translate 0.0250*z }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.2250*z bounded_by { box { <-0.1155, -0.1155, 0.1995>, <0.1155, 0.1155, 0.2505> } } }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.0250*z bounded_by { box { <-0.1155, -0.1155, -0.0005>, <0.1155, 0.1155, 0.0505> } } }
  material {
    PencilEraserTexture
  }
  translate  6.475*z
}
#declare CSG071 = union {
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
    translate  0.45*z
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.1>
    translate  0.2*z
  }
  torus { // Torus032
    0.105104, 0.019896  rotate -x*90
    translate  0.07*z
  }
  torus { // Torus033
    0.105104, 0.019896  rotate -x*90
    translate  0.11*z
  }
  torus { // Torus034
    0.105104, 0.019896  rotate -x*90
    translate  0.15*z
  }
  torus { // Torus035
    0.105104, 0.019896  rotate -x*90
    translate  0.19*z
  }
  torus { // Torus036
    0.105104, 0.019896  rotate -x*90
    translate  0.32*z
  }
  torus { // Torus037
    0.105104, 0.019896  rotate -x*90
    translate  0.36*z
  }
  torus { // Torus038
    0.105104, 0.019896  rotate -x*90
    translate  0.4*z
  }
  torus { // Torus039
    0.105104, 0.019896  rotate -x*90
    translate  0.44*z
  }
  material {
    PencilCapTexture
  }
  translate  6.0*z
}
#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.0625, -0.10825>,
  <0.0625, -0.10825>,
  <0.125, 0.0>,
  <0.0625, 0.10825>,
  <-0.0625, 0.10825>,
  <-0.125, 0.0>,
  <-0.0625, -0.10825>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
}
#declare CSG072 = difference {
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.1>
    translate  -0.15*z
  }
  cone { // Cone027
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilTipTexture
  }
}
#declare CSG073 = difference {
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.1, 0.05>
    rotate 90.0*x
    translate  <0.0, -0.105, 5.5>
  }
  text {   // TText067
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.125
    rotate 90.0*x
    translate  <-0.03, -0.05, 5.46>
  }

  material {
    PencilTextTexture
  }
}
#declare CSG074 = difference {
  object { TransSweep003 }
  object { CSG072 }
  object { CSG073 }
  material {
    PencilBodyTexture
  }
}
#declare CSG075 = intersection {
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    material {
      PencilLeadTexture
    }
    scale <0.125, 0.125, 0.25>
  }
  cone { // Cone028
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilLeadTexture
  }
}
#declare Pencil2 = union {
  object { RndDisc017 }
  object { CSG071 }
  object { CSG074 }
  object { CSG075 }
  rotate <-90.0, -60.0, 181.458664>
  translate  <8.094626, -10.054834, 0.108251>
}
#declare RndDisc018 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0900, 0.0900, 0.2500> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1150, 0.1150, 0.2000> translate 0.0250*z }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.2250*z bounded_by { box { <-0.1155, -0.1155, 0.1995>, <0.1155, 0.1155, 0.2505> } } }
  torus { 0.0900, 0.0250  rotate -x*90 translate  0.0250*z bounded_by { box { <-0.1155, -0.1155, -0.0005>, <0.1155, 0.1155, 0.0505> } } }
  material {
    PencilEraserTexture
  }
  translate  6.475*z
}
#declare CSG076 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.05>
    translate  0.45*z
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.1>
    translate  0.2*z
  }
  torus { // Torus040
    0.105104, 0.019896  rotate -x*90
    translate  0.07*z
  }
  torus { // Torus041
    0.105104, 0.019896  rotate -x*90
    translate  0.11*z
  }
  torus { // Torus042
    0.105104, 0.019896  rotate -x*90
    translate  0.15*z
  }
  torus { // Torus043
    0.105104, 0.019896  rotate -x*90
    translate  0.19*z
  }
  torus { // Torus044
    0.105104, 0.019896  rotate -x*90
    translate  0.32*z
  }
  torus { // Torus045
    0.105104, 0.019896  rotate -x*90
    translate  0.36*z
  }
  torus { // Torus046
    0.105104, 0.019896  rotate -x*90
    translate  0.4*z
  }
  torus { // Torus047
    0.105104, 0.019896  rotate -x*90
    translate  0.44*z
  }
  material {
    PencilCapTexture
  }
  translate  6.0*z
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.0625, -0.10825>,
  <0.0625, -0.10825>,
  <0.125, 0.0>,
  <0.0625, 0.10825>,
  <-0.0625, 0.10825>,
  <-0.125, 0.0>,
  <-0.0625, -0.10825>
  rotate -x*90
  scale <1.0, 1.0, 6.0>
}
#declare CSG077 = difference {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.1>
    translate  -0.15*z
  }
  cone { // Cone029
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilTipTexture
  }
}
#declare CSG078 = difference {
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.1, 0.05>
    rotate 90.0*x
    translate  <0.0, -0.105, 5.5>
  }
  text {   // TText068
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.125
    rotate 90.0*x
    translate  <-0.03, -0.05, 5.46>
  }

  material {
    PencilTextTexture
  }
}
#declare CSG079 = difference {
  object { TransSweep004 }
  object { CSG077 }
  object { CSG078 }
  material {
    PencilBodyTexture
  }
}
#declare CSG080 = intersection {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    material {
      PencilLeadTexture
    }
    scale <0.125, 0.125, 0.25>
  }
  cone { // Cone030
    <0,0,0>, 0.0, <0,0,1>, 0.15
  }
  material {
    PencilLeadTexture
  }
}
#declare Pencil3 = union {
  object { RndDisc018 }
  object { CSG076 }
  object { CSG079 }
  object { CSG080 }
  rotate <-90.0, 60.0, -42.592026>
  translate  <-18.056965, 10.381276, 0.85825>
}
union { // Pencils
  object { Pencil }
  object { Pencil1 }
  object { Pencil2 }
  object { Pencil3 }
  translate  29.55*z
}


#declare TableLegs = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*z
    scale <1.0, 1.0, 27.75>
    rotate <-3.0, 3.0, 0.0>
    translate  <-20.0, -14.0, 28.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*z
    scale <1.0, 1.0, 27.75>
    rotate <-3.0, -3.0, 0.0>
    translate  <20.0, -14.0, 28.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*z
    scale <1.0, 1.0, 27.75>
    rotate <3.0, -3.0, 0.0>
    translate  <20.0, 14.0, 28.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*z
    scale <1.0, 1.0, 27.75>
    rotate <3.0, 3.0, 0.0>
    translate  <-20.0, 14.0, 28.0>
  }
  cone { // Cone001
    <0,0,0>, 1.25, <0,0,1>, 1.05
    scale <1.0, 1.0, 0.5>
    translate  <-21.442586, -15.444564, 0.0>
  }
  cone { // Cone002
    <0,0,0>, 1.25, <0,0,1>, 1.05
    scale <1.0, 1.0, 0.5>
    translate  <21.44259, -15.444564, 0.0>
  }
  cone { // Cone003
    <0,0,0>, 1.25, <0,0,1>, 1.05
    scale <1.0, 1.0, 0.5>
    translate  <21.44259, 15.44456, 0.0>
  }
  cone { // Cone004
    <0,0,0>, 1.25, <0,0,1>, 1.05
    scale <1.0, 1.0, 0.5>
    translate  <-21.44259, 15.44456, 0.0>
  }
  material {
    ChromeTexture
  }
}
#declare CSG002 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <20.0, 14.0, 0.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 14.0, 0.125>
    translate  <20.0, 0.0, 0.125>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 14.0, 0.125>
    translate  <-20.0, 0.0, 0.125>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 18.0, 0.125>
    translate  0.125*z
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <-20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <-20.0, 14.0, 0.0>
  }
}
#declare CSG003 = union {
  torus { // Torus003
    3.75, 0.25  rotate -x*90
    translate  <-20.0, 14.0, 0.0>
  }
  torus { // Torus005
    3.75, 0.25  rotate -x*90
    translate  <-20.0, -14.0, 0.0>
  }
  torus { // Torus007
    3.75, 0.25  rotate -x*90
    translate  <20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 40.0>
    rotate -90.0*y
    translate  <20.0, 17.75, 0.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 28.0>
    rotate 90.0*x
    translate  <-23.75, 14.0, 0.0>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 28.0>
    rotate 90.0*x
    translate  <23.75, 14.0, 0.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 40.0>
    rotate -90.0*y
    translate  <20.0, -17.75, 0.0>
  }
  torus { // Torus001
    3.75, 0.25  rotate -x*90
    translate  <20.0, 14.0, 0.0>
  }
  translate  0.5*z
}
#declare CSG004 = union {
  torus { // Torus004
    3.75, 0.25  rotate -x*90
    translate  <-20.0, 14.0, 0.0>
  }
  torus { // Torus006
    3.75, 0.25  rotate -x*90
    translate  <-20.0, -14.0, 0.0>
  }
  torus { // Torus008
    3.75, 0.25  rotate -x*90
    translate  <20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 40.0>
    rotate -90.0*y
    translate  <20.0, 17.75, 0.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 28.0>
    rotate 90.0*x
    translate  <-23.75, 14.0, 0.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 28.0>
    rotate 90.0*x
    translate  <23.75, 14.0, 0.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 40.0>
    rotate -90.0*y
    translate  <20.0, -17.75, 0.0>
  }
  torus { // Torus002
    3.75, 0.25  rotate -x*90
    translate  <20.0, 14.0, 0.0>
  }
  translate  1.0*z
}
#declare CSG005 = union {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <20.0, 14.0, 0.0>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 14.0, 0.125>
    translate  <20.0, 0.0, 0.125>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 14.0, 0.125>
    translate  <-20.0, 0.0, 0.125>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 18.0, 0.125>
    translate  0.125*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <-20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.25>
    translate  <-20.0, 14.0, 0.0>
  }
  translate  1.25*z
}
#declare TableEdge = union {
  object { CSG002 }
  object { CSG003 }
  object { CSG004 }
  object { CSG005 }
  material {
    ChromeTexture
  }
  translate  28.0*z
}
#declare CSG001 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 18.0, 0.025>
    translate  0.025*z
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 0.15>
    translate  <24.0, 18.0, 0.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 0.15>
    translate  <-24.0, 18.0, 0.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 0.15>
    translate  <-24.0, -18.0, 0.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 4.0, 0.15>
    translate  <24.0, -18.0, 0.0>
  }
}
#declare TableTop = union {
  object { CSG001 }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.05>
    translate  <20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.05>
    translate  <-20.0, -14.0, 0.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.05>
    translate  <-20.0, 14.0, 0.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 0.05>
    translate  <20.0, 14.0, 0.0>
  }
  material {
    TableTopTexture
  }
  translate  29.5*z
}
#declare Table = union {
  object { TableLegs }
  object { TableEdge }
  object { TableTop }
}
#declare ChairBackTilt = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.5
    translate  4.25*x
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.5
    translate  -4.25*x
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  4.25*x
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  -4.25*x
  }
  superellipsoid { // Seat4
    <0.1, 0.412>
    scale <7.5, 1.0, 6.0>
    translate  <0.0, -1.0, 13.5>
    material {
      SeatTexture
      // Transform to world space
      translate  <0.0, -9.0, -15.5>
      rotate 5.0*x
      translate  <-1.671162, -20.053938, 0.0>
      rotate 11.199299*z
    }
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <-4.25, 0.0, 16.0>
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <4.25, 0.0, 16.0>
  }
  rotate -5.0*x
  translate  <0.0, 9.0, 15.5>
}
#declare ChairBack = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <-4.25, 9.0, 15.5>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <4.25, 9.0, 15.5>
  }
  sphere { // Sphere009
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <-4.25, 1.5, 15.5>
  }
  sphere { // Sphere010
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <4.25, 1.5, 15.5>
  }
  object { ChairBackTilt }
  material {
    ChromeTexture
  }
}
#declare ChairLegFoot001 = union {
  sphere { // Sphere011
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere015
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone005
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, -8.05, 0.0>
}
#declare ChairLegFoot002 = union {
  sphere { // Sphere012
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere016
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone006
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, -8.05, 0.0>
}
#declare ChairLegFoot003 = union {
  sphere { // Sphere013
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere017
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone007
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, 8.05, 0.0>
}
#declare ChairLegFoot004 = union {
  sphere { // Sphere014
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere018
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone008
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, 8.05, 0.0>
}
#declare ChairLegs = union {
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, 6.75, 15.5>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.5
    translate  <5.5, 6.75, 15.5>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.5
    translate  <5.5, -6.75, 15.5>
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, 5.0, 0.0>
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, -5.0, 0.0>
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, -5.0, 0.0>
    translate  <5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, 5.0, 0.0>
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <-6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 13.0>
    rotate -90.0*y
    translate  <6.5, 0.0, 4.0>
  }
  object { ChairLegFoot001 }
  object { ChairLegFoot002 }
  object { ChairLegFoot003 }
  object { ChairLegFoot004 }
  material {
    ChromeTexture
  }
}
#declare Chair = union {
  object { ChairBack }
  superellipsoid { // ChairSeat
    <0.1, 0.412>
    scale <7.5, 8.5, 1.0>
    translate  16.5*z
    material {
      SeatTexture
      // Transform to world space
      translate  <-1.671162, -20.053938, 0.0>
      rotate 11.199299*z
    }
  }
  object { ChairLegs }
  rotate -11.199299*z
  translate  <1.671162, 20.053938, 0.0>
}
#declare ChairBackTilt1 = union {
  sphere { // Sphere021
    <0,0,0>,1
    scale 0.5
    translate  4.25*x
  }
  sphere { // Sphere022
    <0,0,0>,1
    scale 0.5
    translate  -4.25*x
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  4.25*x
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  -4.25*x
  }
  superellipsoid { // Seat5
    <0.1, 0.412>
    scale <7.5, 1.0, 6.0>
    translate  <0.0, -1.0, 13.5>
    material {
      SeatTexture
      // Transform to world space
      translate  <0.0, -9.0, -15.5>
      rotate 5.0*x
      translate  -22.978471*x
      rotate 92.114937*z
    }
  }
  sphere { // Sphere023
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <-4.25, 0.0, 16.0>
  }
  sphere { // Sphere024
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <4.25, 0.0, 16.0>
  }
  rotate -5.0*x
  translate  <0.0, 9.0, 15.5>
}
#declare ChairBack1 = union {
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <-4.25, 9.0, 15.5>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <4.25, 9.0, 15.5>
  }
  sphere { // Sphere019
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <-4.25, 1.5, 15.5>
  }
  sphere { // Sphere020
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <4.25, 1.5, 15.5>
  }
  object { ChairBackTilt1 }
  material {
    ChromeTexture
  }
}
#declare ChairLegFoot005 = union {
  sphere { // Sphere029
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere030
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone009
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, -8.05, 0.0>
}
#declare ChairLegFoot006 = union {
  sphere { // Sphere031
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere032
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone010
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, -8.05, 0.0>
}
#declare ChairLegFoot007 = union {
  sphere { // Sphere033
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere034
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone011
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, 8.05, 0.0>
}
#declare ChairLegFoot008 = union {
  sphere { // Sphere035
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere036
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone012
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, 8.05, 0.0>
}
#declare ChairLegs1 = union {
  sphere { // Sphere025
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, 6.75, 15.5>
  }
  sphere { // Sphere026
    <0,0,0>,1
    scale 0.5
    translate  <5.5, 6.75, 15.5>
  }
  sphere { // Sphere027
    <0,0,0>,1
    scale 0.5
    translate  <5.5, -6.75, 15.5>
  }
  sphere { // Sphere028
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, 5.0, 0.0>
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, -5.0, 0.0>
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, -5.0, 0.0>
    translate  <5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, 5.0, 0.0>
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <-6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 13.0>
    rotate -90.0*y
    translate  <6.5, 0.0, 4.0>
  }
  object { ChairLegFoot005 }
  object { ChairLegFoot006 }
  object { ChairLegFoot007 }
  object { ChairLegFoot008 }
  material {
    ChromeTexture
  }
}
#declare Chair1 = union {
  object { ChairBack1 }
  superellipsoid { // ChairSeat1
    <0.1, 0.412>
    scale <7.5, 8.5, 1.0>
    translate  16.5*z
    material {
      SeatTexture
      // Transform to world space
      translate  -22.978471*x
      rotate 92.114937*z
    }
  }
  object { ChairLegs1 }
  rotate -92.114937*z
  translate  22.978471*x
}
#declare ChairLegFoot009 = union {
  sphere { // Sphere047
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere048
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone013
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, -8.05, 0.0>
}
#declare ChairLegFoot010 = union {
  sphere { // Sphere049
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere050
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone014
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, -8.05, 0.0>
}
#declare ChairLegFoot011 = union {
  sphere { // Sphere051
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere052
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone015
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, 8.05, 0.0>
}
#declare ChairLegFoot012 = union {
  sphere { // Sphere053
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere054
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone016
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, 8.05, 0.0>
}
#declare ChairLegs2 = union {
  sphere { // Sphere043
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, 6.75, 15.5>
  }
  sphere { // Sphere044
    <0,0,0>,1
    scale 0.5
    translate  <5.5, 6.75, 15.5>
  }
  sphere { // Sphere045
    <0,0,0>,1
    scale 0.5
    translate  <5.5, -6.75, 15.5>
  }
  sphere { // Sphere046
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, 5.0, 0.0>
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, -5.0, 0.0>
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, -5.0, 0.0>
    translate  <5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, 5.0, 0.0>
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <-6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 13.0>
    rotate -90.0*y
    translate  <6.5, 0.0, 4.0>
  }
  object { ChairLegFoot009 }
  object { ChairLegFoot010 }
  object { ChairLegFoot011 }
  object { ChairLegFoot012 }
  material {
    ChromeTexture
  }
}
#declare ChairBackTilt2 = union {
  sphere { // Sphere039
    <0,0,0>,1
    scale 0.5
    translate  4.25*x
  }
  sphere { // Sphere040
    <0,0,0>,1
    scale 0.5
    translate  -4.25*x
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  4.25*x
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  -4.25*x
  }
  superellipsoid { // Seat6
    <0.1, 0.412>
    scale <7.5, 1.0, 6.0>
    translate  <0.0, -1.0, 13.5>
    material {
      SeatTexture
      // Transform to world space
      translate  <0.0, -9.0, -15.5>
      rotate 5.0*x
      translate  29.046011*x
      rotate -92.601891*z
    }
  }
  sphere { // Sphere041
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <-4.25, 0.0, 16.0>
  }
  sphere { // Sphere042
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <4.25, 0.0, 16.0>
  }
  rotate -5.0*x
  translate  <0.0, 9.0, 15.5>
}
#declare ChairBack2 = union {
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <-4.25, 9.0, 15.5>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <4.25, 9.0, 15.5>
  }
  sphere { // Sphere037
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <-4.25, 1.5, 15.5>
  }
  sphere { // Sphere038
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <4.25, 1.5, 15.5>
  }
  object { ChairBackTilt2 }
  material {
    ChromeTexture
  }
}
#declare Chair2 = union {
  object { ChairLegs2 }
  object { ChairBack2 }
  superellipsoid { // ChairSeat2
    <0.1, 0.412>
    scale <7.5, 8.5, 1.0>
    translate  16.5*z
    material {
      SeatTexture
      // Transform to world space
      translate  29.046011*x
      rotate -92.601891*z
    }
  }
  rotate 92.601891*z
  translate  -29.046011*x
}
#declare ChairBackTilt3 = union {
  sphere { // Sphere067
    <0,0,0>,1
    scale 0.5
    translate  4.25*x
  }
  sphere { // Sphere068
    <0,0,0>,1
    scale 0.5
    translate  -4.25*x
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  4.25*x
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 16.0>
    translate  -4.25*x
  }
  superellipsoid { // Seat7
    <0.1, 0.412>
    scale <7.5, 1.0, 6.0>
    translate  <0.0, -1.0, 13.5>
    material {
      SeatTexture
      // Transform to world space
      translate  <0.0, -9.0, -15.5>
      rotate 5.0*x
      translate  <1.963767, 18.278036, 0.0>
      rotate -174.911697*z
    }
  }
  sphere { // Sphere069
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <-4.25, 0.0, 16.0>
  }
  sphere { // Sphere070
    <0,0,0>,1
    scale <0.5, 0.5, 0.125>
    translate  <4.25, 0.0, 16.0>
  }
  rotate -5.0*x
  translate  <0.0, 9.0, 15.5>
}
#declare ChairBack3 = union {
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <-4.25, 9.0, 15.5>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.5>
    rotate 90.0*x
    translate  <4.25, 9.0, 15.5>
  }
  sphere { // Sphere065
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <-4.25, 1.5, 15.5>
  }
  sphere { // Sphere066
    <0,0,0>,1
    scale <0.5, 0.125, 0.5>
    translate  <4.25, 1.5, 15.5>
  }
  object { ChairBackTilt3 }
  material {
    ChromeTexture
  }
}
#declare ChairLegFoot013 = union {
  sphere { // Sphere075
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere076
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone017
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, -8.05, 0.0>
}
#declare ChairLegFoot014 = union {
  sphere { // Sphere077
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere078
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone018
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, -8.05, 0.0>
}
#declare ChairLegFoot015 = union {
  sphere { // Sphere079
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere080
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone019
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <6.81, 8.05, 0.0>
}
#declare ChairLegFoot016 = union {
  sphere { // Sphere081
    <0,0,0>,1
    scale 0.375
    translate  0.55*z
  }
  sphere { // Sphere082
    <0,0,0>,1
    scale <0.625, 0.625, 0.125>
    translate  0.3*z
  }
  cone { // Cone020
    <0,0,0>, 0.7, <0,0,1>, 0.625
    scale <1.0, 1.0, 0.3>
  }
  translate  <-6.81, 8.05, 0.0>
}
#declare ChairLegs3 = union {
  sphere { // Sphere071
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, 6.75, 15.5>
  }
  sphere { // Sphere072
    <0,0,0>,1
    scale 0.5
    translate  <5.5, 6.75, 15.5>
  }
  sphere { // Sphere073
    <0,0,0>,1
    scale 0.5
    translate  <5.5, -6.75, 15.5>
  }
  sphere { // Sphere074
    <0,0,0>,1
    scale 0.5
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 13.5>
    rotate 90.0*x
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, 5.0, 0.0>
    translate  <-5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <5.0, -5.0, 0.0>
    translate  <5.5, 6.75, 15.5>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, -5.0, 0.0>
    translate  <5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  -1.0*z
    scale <0.5, 0.5, 15.0>
    rotate <-5.0, 5.0, 0.0>
    translate  <-5.5, -6.75, 15.5>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <-6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 15.5>
    rotate 90.0*x
    translate  <6.5, 7.75, 4.0>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 13.0>
    rotate -90.0*y
    translate  <6.5, 0.0, 4.0>
  }
  object { ChairLegFoot013 }
  object { ChairLegFoot014 }
  object { ChairLegFoot015 }
  object { ChairLegFoot016 }
  material {
    ChromeTexture
  }
}
#declare Chair3 = union {
  object { ChairBack3 }
  superellipsoid { // ChairSeat3
    <0.1, 0.412>
    scale <7.5, 8.5, 1.0>
    translate  16.5*z
    material {
      SeatTexture
      // Transform to world space
      translate  <1.963767, 18.278036, 0.0>
      rotate -174.911697*z
    }
  }
  object { ChairLegs3 }
  rotate 174.911697*z
  translate  <-1.963767, -18.278036, 0.0>
}
union { // TableWithChairs
  object { Table }
  object { Chair }
  object { Chair1 }
  object { Chair2 }
  object { Chair3 }
}


#declare CSG006 = difference {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.5, 22.0>
    translate  -0.5*y
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.5>
    rotate 90.0*x
    translate  <-5.0, 0.25, 22.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.5>
    rotate 90.0*x
    translate  <5.0, 0.25, 22.0>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.5>
    rotate 90.0*x
    translate  <5.0, 0.25, -22.0>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.5>
    rotate 90.0*x
    translate  <-5.0, 0.25, -22.0>
  }
}
#declare CSG007 = difference {
  torus { // Torus009
    2.0, 0.4  rotate -x*90
    rotate -90.0*x
    translate  <-5.0, -0.5, 22.0>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 1.5>
    translate  <-5.0, -0.5, 23.5>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.5, 3.0>
    translate  <-6.5, -0.5, 22.0>
  }
}
#declare CSG008 = difference {
  torus { // Torus010
    2.0, 0.4  rotate -x*90
    rotate -90.0*x
    translate  <5.0, -0.5, 22.0>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 1.5>
    translate  <5.0, -0.5, 23.5>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.5, 3.0>
    translate  <6.5, -0.5, 22.0>
  }
}
#declare CSG009 = difference {
  torus { // Torus011
    2.0, 0.4  rotate -x*90
    rotate -90.0*x
    translate  <5.0, -0.5, -22.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 1.5>
    translate  <5.0, -0.5, -23.5>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.5, 3.0>
    translate  <6.5, -0.5, -22.0>
  }
}
#declare CSG010 = difference {
  torus { // Torus012
    2.0, 0.4  rotate -x*90
    rotate -90.0*x
    translate  <-5.0, -0.5, -22.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.5, 1.5>
    translate  <-5.0, -0.5, -23.5>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.5, 3.0>
    translate  <-6.5, -0.5, -22.0>
  }
}
#declare CSG011 = union {
  object { CSG007 }
  object { CSG008 }
  object { CSG009 }
  object { CSG010 }
  sphere { // Sphere055
    <0,0,0>,1
    scale 0.4
    translate  <-3.0, -0.5, 22.0>
  }
  sphere { // Sphere056
    <0,0,0>,1
    scale 0.4
    translate  <3.0, -0.5, 22.0>
  }
  sphere { // Sphere057
    <0,0,0>,1
    scale 0.4
    translate  <3.0, -0.5, -22.0>
  }
  sphere { // Sphere058
    <0,0,0>,1
    scale 0.4
    translate  <-3.0, -0.5, -22.0>
  }
  sphere { // Sphere059
    <0,0,0>,1
    scale 0.4
    translate  <-5.0, -0.5, 20.0>
  }
  sphere { // Sphere060
    <0,0,0>,1
    scale 0.4
    translate  <5.0, -0.5, 20.0>
  }
  sphere { // Sphere061
    <0,0,0>,1
    scale 0.4
    translate  <5.0, -0.5, -20.0>
  }
  sphere { // Sphere062
    <0,0,0>,1
    scale 0.4
    translate  <-5.0, -0.5, -20.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 40.0>
    translate  <-5.0, -0.5, -20.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 6.0>
    rotate -90.0*y
    translate  <3.0, -0.5, -22.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 40.0>
    translate  <5.0, -0.5, -20.0>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 6.0>
    rotate -90.0*y
    translate  <3.0, -0.5, 22.0>
  }
}
#declare CSG012 = difference {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 0.25, 22.5>
    translate  -0.25*y
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <-3.5, -0.5, 22.5>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <-5.5, -0.5, 20.5>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <3.5, -0.5, 22.5>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <3.5, -0.5, -22.5>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <-3.5, -0.5, -22.5>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <5.5, -0.5, 20.5>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <5.5, -0.5, -20.5>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.5>
    translate  <-5.5, -0.5, -20.5>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale 1.5
    rotate 90.0*x
    translate  <-5.0, 0.25, 22.0>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale 1.5
    rotate 90.0*x
    translate  <5.0, 0.25, 22.0>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale 1.5
    rotate 90.0*x
    translate  <5.0, 0.25, -22.0>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale 1.5
    rotate 90.0*x
    translate  <-5.0, 0.25, -22.0>
  }
}
#declare CSG013 = union {
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <-3.0, 0.0, 22.0>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <3.0, 0.0, 22.0>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <3.0, 0.0, -22.0>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <-3.0, 0.0, -22.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <-5.0, 0.0, 20.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <5.0, 0.0, 20.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <5.0, 0.0, -20.0>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    rotate 90.0*x
    translate  <-5.0, 0.0, -20.0>
  }
}
#declare RndDisc001 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0625, 0.0625, 2.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1250, 0.1250, 1.8750> translate 0.0625*z }
  torus { 0.0625, 0.0625  rotate -x*90 translate  1.9375*z bounded_by { box { <-0.1263, -0.1263, 1.8738>, <0.1263, 0.1263, 2.0013> } } }
  torus { 0.0625, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.1263, -0.1263, -0.0013>, <0.1263, 0.1263, 0.1263> } } }
  rotate 90.0*x
  translate  <-1.3, -0.5, 11.0>
}
#declare RndDisc003 = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0625, 0.0625, 2.0000> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1250, 0.1250, 1.8750> translate 0.0625*z }
  torus { 0.0625, 0.0625  rotate -x*90 translate  1.9375*z bounded_by { box { <-0.1263, -0.1263, 1.8738>, <0.1263, 0.1263, 2.0013> } } }
  torus { 0.0625, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.1263, -0.1263, -0.0013>, <0.1263, 0.1263, 0.1263> } } }
  rotate 90.0*x
  translate  <1.3, -0.5, 11.0>
}
#declare SwordDisplayPegs = union {
  object { RndDisc001 }
  object { RndDisc003 }
  material {
    DisplayTexture
    rotate 90.0*x
  }
}
#declare DisplayStand = union {
  object { CSG006 }
  object { CSG011 }
  object { CSG012 }
  object { CSG013 }
  object { SwordDisplayPegs }
  material {
    DisplayTexture
    scale <2.5, 2.5, 5.0>
    translate <5.783573, -0.547292, 0.000000>
  }
}
#declare SwordCrossguard = difference {
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.625, 0.5>
  }
  torus { // Torus013
    1.125, 0.875  rotate -x*90
    scale <1.0, 1.0, 2.5>
    rotate <-0.0, -90.0, 0.0>
    translate  -3.25*x
  }
  torus { // Torus014
    1.125, 0.875  rotate -x*90
    scale <1.0, 1.0, 2.5>
    rotate <-0.0, -90.0, 0.0>
    translate  3.25*x
  }
}
#declare SwordPommelMain = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 1.0000> translate 0.1250*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.7500, 0.7500, 1.2750> translate -0.1125*z }
  }
  torus { 0.8750, 0.1250  rotate -x*90 translate  1.1250*z bounded_by { box { <-1.0025, -1.0025, 0.9975>, <1.0025, 1.0025, 1.2525> } } }
  torus { 0.8750, 0.1250  rotate -x*90 translate  0.1250*z bounded_by { box { <-1.0025, -1.0025, -0.0025>, <1.0025, 1.0025, 0.2525> } } }
  rotate 90.0*x
  translate  <0.0, 0.625, -6.25>
}
#declare SwordHiltGems = union {
  sphere { // Sphere063
    <0,0,0>,1
    scale <0.75, 0.1875, 0.75>
    translate  <0.0, 0.5, -6.25>
  }
  sphere { // Sphere064
    <0,0,0>,1
    scale <0.75, 0.1875, 0.75>
    translate  <0.0, -0.5, -6.25>
  }
  material {
    HiltGemTexture
  }
}
#declare SwordCrossguardRight = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.4375, 0.4375, 0.6260> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 0.5010> translate 0.0625*z }
  torus { 0.4375, 0.0625  rotate -x*90 translate  0.5635*z bounded_by { box { <-0.5012, -0.5012, 0.4998>, <0.5012, 0.5012, 0.6272> } } }
  torus { 0.4375, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.5012, -0.5012, -0.0013>, <0.5012, 0.5012, 0.1263> } } }
  rotate 90.0*x
  translate  <3.85, 0.313, 0.0>
}
#declare SwordCrossguardLeft = merge {
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.4375, 0.4375, 0.6260> }
  cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 0.5010> translate 0.0625*z }
  torus { 0.4375, 0.0625  rotate -x*90 translate  0.5635*z bounded_by { box { <-0.5012, -0.5012, 0.4998>, <0.5012, 0.5012, 0.6272> } } }
  torus { 0.4375, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.5012, -0.5012, -0.0013>, <0.5012, 0.5012, 0.1263> } } }
  rotate 90.0*x
  translate  <-3.85, 0.313, 0.0>
}
#declare SwordHilt = union {
  object { SwordCrossguard }
  cylinder { // SwordGripShaft
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 5.0>
    rotate 180.0*y
    translate  -0.5*z
  }
  object { SwordPommelMain }
  torus { // SwordHiltGrip
    0.4, 0.125  rotate -x*90
    material {
      GripTexture
      scale <1.0, 1.0, 0.0625>
      rotate -0.0*z
      translate <0.000000, 0.000000, -0.125000>
    }
    scale <1.0, 1.0, 18.5>
    translate  -2.875*z
  }
  object { SwordHiltGems }
  object { SwordCrossguardRight }
  object { SwordCrossguardLeft }
  material {
    HiltTexture
  }
}
#declare SwordBlade = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.000000, 29.700000>, <-0.350000, 0.000000, 29.300000>, <-0.500000, 0.000000, 29.000000>, 
      <0.150000, 0.000000, 29.700000>, <0.000000, 0.000000, 29.400000>, <-0.200000, 0.075000, 29.300000>, <-0.350000, 0.075000, 29.000000>, 
      <0.350000, 0.000000, 29.300000>, <0.200000, 0.075000, 29.300000>, <0.000000, 0.100000, 29.000000>, <-0.150000, 0.175000, 29.000000>, 
      <0.500000, 0.000000, 29.000000>, <0.350000, 0.075000, 29.000000>, <0.150000, 0.175000, 29.000000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.000000, 29.700000>, <-0.350000, 0.000000, 29.300000>, <-0.500000, 0.000000, 29.000000>, 
      <0.150000, 0.000000, 29.700000>, <0.000000, 0.000000, 29.400000>, <-0.200000, -0.075000, 29.300000>, <-0.350000, -0.075000, 29.000000>, 
      <0.350000, 0.000000, 29.300000>, <0.200000, -0.075000, 29.300000>, <0.000000, -0.100000, 29.000000>, <-0.150000, -0.175000, 29.000000>, 
      <0.500000, 0.000000, 29.000000>, <0.350000, -0.075000, 29.000000>, <0.150000, -0.175000, 29.000000>, <0.000000, -0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.000000, 29.700000>, <-0.350000, 0.000000, 29.300000>, <-0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.075000, 29.400000>, <-0.200000, 0.075000, 29.300000>, <-0.350000, 0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.075000, 29.400000>, <-0.150000, 0.100000, 29.300000>, <-0.150000, 0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.000000, 29.700000>, <0.350000, 0.000000, 29.300000>, <0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.075000, 29.400000>, <0.200000, 0.075000, 29.300000>, <0.350000, 0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.075000, 29.400000>, <0.150000, 0.100000, 29.300000>, <0.150000, 0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.000000, 29.700000>, <-0.350000, 0.000000, 29.300000>, <-0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.075000, 29.400000>, <-0.200000, 0.075000, 29.300000>, <-0.350000, 0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.075000, 29.400000>, <-0.150000, 0.100000, 29.300000>, <-0.150000, 0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.000000, 29.700000>, <0.350000, 0.000000, 29.300000>, <0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.075000, 29.400000>, <0.200000, 0.075000, 29.300000>, <0.350000, 0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.075000, 29.400000>, <0.150000, 0.100000, 29.300000>, <0.150000, 0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.000000, 29.700000>, <-0.350000, 0.000000, 29.300000>, <-0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, -0.075000, 29.400000>, <-0.200000, -0.075000, 29.300000>, <-0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, -0.075000, 29.400000>, <-0.150000, -0.100000, 29.300000>, <-0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>, 
      <0.000000, 0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <-0.150000, -0.100000, 29.300000>, <-0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.175000, 29.300000>, <-0.150000, 0.100000, 29.300000>, <-0.200000, 0.000000, 29.000000>, <-0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.250000, 29.000000>, <-0.150000, 0.175000, 29.000000>, <-0.350000, 0.075000, 29.000000>, <-0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>, 
      <0.000000, 0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <-0.150000, -0.100000, 29.300000>, <-0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.175000, 29.300000>, <-0.150000, 0.100000, 29.300000>, <-0.200000, 0.000000, 29.000000>, <-0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.250000, 29.000000>, <-0.150000, 0.175000, 29.000000>, <-0.350000, 0.075000, 29.000000>, <-0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.000000, 29.700000>, <0.350000, 0.000000, 29.300000>, <0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, -0.075000, 29.400000>, <0.200000, -0.075000, 29.300000>, <0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, -0.075000, 29.400000>, <0.150000, -0.100000, 29.300000>, <0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>, 
      <0.000000, -0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <0.150000, 0.100000, 29.300000>, <0.150000, 0.175000, 29.000000>, 
      <0.000000, -0.175000, 29.300000>, <0.150000, -0.100000, 29.300000>, <0.200000, 0.000000, 29.000000>, <0.350000, 0.075000, 29.000000>, 
      <0.000000, -0.250000, 29.000000>, <0.150000, -0.175000, 29.000000>, <0.350000, -0.075000, 29.000000>, <0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>, 
      <0.000000, -0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <0.150000, 0.100000, 29.300000>, <0.150000, 0.175000, 29.000000>, 
      <0.000000, -0.175000, 29.300000>, <0.150000, -0.100000, 29.300000>, <0.200000, 0.000000, 29.000000>, <0.350000, 0.075000, 29.000000>, 
      <0.000000, -0.250000, 29.000000>, <0.150000, -0.175000, 29.000000>, <0.350000, -0.075000, 29.000000>, <0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, -0.075000, 29.400000>, <-0.150000, -0.100000, 29.300000>, <-0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, -0.075000, 29.400000>, <-0.200000, -0.075000, 29.300000>, <-0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <-0.150000, 0.000000, 29.700000>, <-0.350000, 0.000000, 29.300000>, <-0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>, 
      <0.000000, 0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <-0.150000, -0.100000, 29.300000>, <-0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.175000, 29.300000>, <-0.150000, 0.100000, 29.300000>, <-0.200000, 0.000000, 29.000000>, <-0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.250000, 29.000000>, <-0.150000, 0.175000, 29.000000>, <-0.350000, 0.075000, 29.000000>, <-0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>, 
      <0.000000, 0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <-0.150000, -0.100000, 29.300000>, <-0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.175000, 29.300000>, <-0.150000, 0.100000, 29.300000>, <-0.200000, 0.000000, 29.000000>, <-0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.250000, 29.000000>, <-0.150000, 0.175000, 29.000000>, <-0.350000, 0.075000, 29.000000>, <-0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.150000, 0.000000, 29.700000>, <0.350000, 0.000000, 29.300000>, <0.500000, 0.000000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, -0.075000, 29.400000>, <0.200000, -0.075000, 29.300000>, <0.350000, -0.075000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.150000, -0.075000, 29.400000>, <0.150000, -0.100000, 29.300000>, <0.150000, -0.175000, 29.000000>, 
      <0.000000, 0.000000, 30.000000>, <0.000000, -0.075000, 29.700000>, <0.000000, -0.175000, 29.300000>, <0.000000, -0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>, 
      <0.000000, -0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <0.150000, 0.100000, 29.300000>, <0.150000, 0.175000, 29.000000>, 
      <0.000000, -0.175000, 29.300000>, <0.150000, -0.100000, 29.300000>, <0.200000, 0.000000, 29.000000>, <0.350000, 0.075000, 29.000000>, 
      <0.000000, -0.250000, 29.000000>, <0.150000, -0.175000, 29.000000>, <0.350000, -0.075000, 29.000000>, <0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 30.000000>, <0.000000, 0.075000, 29.700000>, <0.000000, 0.175000, 29.300000>, <0.000000, 0.250000, 29.000000>, 
      <0.000000, -0.075000, 29.700000>, <0.000000, 0.000000, 29.400000>, <0.150000, 0.100000, 29.300000>, <0.150000, 0.175000, 29.000000>, 
      <0.000000, -0.175000, 29.300000>, <0.150000, -0.100000, 29.300000>, <0.200000, 0.000000, 29.000000>, <0.350000, 0.075000, 29.000000>, 
      <0.000000, -0.250000, 29.000000>, <0.150000, -0.175000, 29.000000>, <0.350000, -0.075000, 29.000000>, <0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350000, 0.250000, 28.000000>, <0.245000, 0.250000, 28.300000>, <0.105000, 0.250000, 28.700000>, <0.000000, 0.250000, 29.000000>, 
      <0.350000, 0.250000, 28.000000>, <0.035000, 0.250000, 28.300000>, <0.000000, 0.250000, 28.400000>, <-0.105000, 0.250000, 28.700000>, 
      <0.350000, 0.250000, 28.000000>, <0.035000, 0.250000, 28.300000>, <-0.035000, 0.250000, 28.300000>, <-0.245000, 0.250000, 28.300000>, 
      <0.350000, 0.250000, 28.000000>, <0.140000, 0.250000, 28.000000>, <-0.140000, 0.250000, 28.000000>, <-0.350000, 0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.850000, 0.000000, 28.000000>, <0.745000, 0.000000, 28.300000>, <0.605000, 0.000000, 28.700000>, <0.500000, 0.000000, 29.000000>, 
      <0.700000, 0.075000, 28.000000>, <0.595000, 0.075000, 28.300000>, <0.455000, 0.075000, 28.700000>, <0.350000, 0.075000, 29.000000>, 
      <0.500000, 0.175000, 28.000000>, <0.395000, 0.175000, 28.300000>, <0.255000, 0.175000, 28.700000>, <0.150000, 0.175000, 29.000000>, 
      <0.350000, 0.250000, 28.000000>, <0.245000, 0.250000, 28.300000>, <0.105000, 0.250000, 28.700000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350000, -0.250000, 28.000000>, <0.245000, -0.250000, 28.300000>, <0.105000, -0.250000, 28.700000>, <0.000000, -0.250000, 29.000000>, 
      <0.500000, -0.175000, 28.000000>, <0.395000, -0.175000, 28.300000>, <0.255000, -0.175000, 28.700000>, <0.150000, -0.175000, 29.000000>, 
      <0.700000, -0.075000, 28.000000>, <0.595000, -0.075000, 28.300000>, <0.455000, -0.075000, 28.700000>, <0.350000, -0.075000, 29.000000>, 
      <0.850000, 0.000000, 28.000000>, <0.745000, 0.000000, 28.300000>, <0.605000, 0.000000, 28.700000>, <0.500000, 0.000000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350000, -0.250000, 28.000000>, <-0.245000, -0.250000, 28.300000>, <-0.105000, -0.250000, 28.700000>, <0.000000, -0.250000, 29.000000>, 
      <-0.350000, -0.250000, 28.000000>, <-0.035000, -0.250000, 28.300000>, <0.000000, -0.250000, 28.400000>, <0.105000, -0.250000, 28.700000>, 
      <-0.350000, -0.250000, 28.000000>, <-0.035000, -0.250000, 28.300000>, <0.035000, -0.250000, 28.300000>, <0.245000, -0.250000, 28.300000>, 
      <-0.350000, -0.250000, 28.000000>, <-0.140000, -0.250000, 28.000000>, <0.140000, -0.250000, 28.000000>, <0.350000, -0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.850000, 0.000000, 28.000000>, <-0.745000, 0.000000, 28.300000>, <-0.605000, 0.000000, 28.700000>, <-0.500000, 0.000000, 29.000000>, 
      <-0.700000, -0.075000, 28.000000>, <-0.595000, -0.075000, 28.300000>, <-0.455000, -0.075000, 28.700000>, <-0.350000, -0.075000, 29.000000>, 
      <-0.500000, -0.175000, 28.000000>, <-0.395000, -0.175000, 28.300000>, <-0.255000, -0.175000, 28.700000>, <-0.150000, -0.175000, 29.000000>, 
      <-0.350000, -0.250000, 28.000000>, <-0.245000, -0.250000, 28.300000>, <-0.105000, -0.250000, 28.700000>, <0.000000, -0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.850000, 0.000000, 28.000000>, <-0.700000, 0.075000, 28.000000>, <-0.500000, 0.175000, 28.000000>, <-0.350000, 0.250000, 28.000000>, 
      <-0.745000, 0.000000, 28.300000>, <-0.595000, 0.075000, 28.300000>, <-0.395000, 0.175000, 28.300000>, <-0.245000, 0.250000, 28.300000>, 
      <-0.605000, 0.000000, 28.700000>, <-0.455000, 0.075000, 28.700000>, <-0.255000, 0.175000, 28.700000>, <-0.105000, 0.250000, 28.700000>, 
      <-0.500000, 0.000000, 29.000000>, <-0.350000, 0.075000, 29.000000>, <-0.150000, 0.175000, 29.000000>, <0.000000, 0.250000, 29.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.250000, 27.000000>, <0.455000, 0.250000, 27.300000>, <0.395000, 0.250000, 27.700000>, <0.350000, 0.250000, 28.000000>, 
      <0.200000, 0.250000, 27.000000>, <0.155000, 0.250000, 27.300000>, <0.185000, 0.250000, 27.700000>, <0.140000, 0.250000, 28.000000>, 
      <-0.200000, 0.250000, 27.000000>, <-0.155000, 0.250000, 27.300000>, <-0.185000, 0.250000, 27.700000>, <-0.140000, 0.250000, 28.000000>, 
      <-0.500000, 0.250000, 27.000000>, <-0.455000, 0.250000, 27.300000>, <-0.395000, 0.250000, 27.700000>, <-0.350000, 0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 27.000000>, <0.955000, 0.000000, 27.300000>, <0.895000, 0.000000, 27.700000>, <0.850000, 0.000000, 28.000000>, 
      <0.850000, 0.075000, 27.000000>, <0.805000, 0.075000, 27.300000>, <0.745000, 0.075000, 27.700000>, <0.700000, 0.075000, 28.000000>, 
      <0.650000, 0.175000, 27.000000>, <0.605000, 0.175000, 27.300000>, <0.545000, 0.175000, 27.700000>, <0.500000, 0.175000, 28.000000>, 
      <0.500000, 0.250000, 27.000000>, <0.455000, 0.250000, 27.300000>, <0.395000, 0.250000, 27.700000>, <0.350000, 0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.250000, 27.000000>, <0.455000, -0.250000, 27.300000>, <0.395000, -0.250000, 27.700000>, <0.350000, -0.250000, 28.000000>, 
      <0.650000, -0.175000, 27.000000>, <0.605000, -0.175000, 27.300000>, <0.545000, -0.175000, 27.700000>, <0.500000, -0.175000, 28.000000>, 
      <0.850000, -0.075000, 27.000000>, <0.805000, -0.075000, 27.300000>, <0.745000, -0.075000, 27.700000>, <0.700000, -0.075000, 28.000000>, 
      <1.000000, 0.000000, 27.000000>, <0.955000, 0.000000, 27.300000>, <0.895000, 0.000000, 27.700000>, <0.850000, 0.000000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.250000, 27.000000>, <-0.455000, -0.250000, 27.300000>, <-0.395000, -0.250000, 27.700000>, <-0.350000, -0.250000, 28.000000>, 
      <-0.200000, -0.250000, 27.000000>, <-0.155000, -0.250000, 27.300000>, <-0.185000, -0.250000, 27.700000>, <-0.140000, -0.250000, 28.000000>, 
      <0.200000, -0.250000, 27.000000>, <0.155000, -0.250000, 27.300000>, <0.185000, -0.250000, 27.700000>, <0.140000, -0.250000, 28.000000>, 
      <0.500000, -0.250000, 27.000000>, <0.455000, -0.250000, 27.300000>, <0.395000, -0.250000, 27.700000>, <0.350000, -0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 27.000000>, <-0.955000, 0.000000, 27.300000>, <-0.895000, 0.000000, 27.700000>, <-0.850000, 0.000000, 28.000000>, 
      <-0.850000, -0.075000, 27.000000>, <-0.805000, -0.075000, 27.300000>, <-0.745000, -0.075000, 27.700000>, <-0.700000, -0.075000, 28.000000>, 
      <-0.650000, -0.175000, 27.000000>, <-0.605000, -0.175000, 27.300000>, <-0.545000, -0.175000, 27.700000>, <-0.500000, -0.175000, 28.000000>, 
      <-0.500000, -0.250000, 27.000000>, <-0.455000, -0.250000, 27.300000>, <-0.395000, -0.250000, 27.700000>, <-0.350000, -0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 27.000000>, <-0.850000, 0.075000, 27.000000>, <-0.650000, 0.175000, 27.000000>, <-0.500000, 0.250000, 27.000000>, 
      <-0.955000, 0.000000, 27.300000>, <-0.805000, 0.075000, 27.300000>, <-0.605000, 0.175000, 27.300000>, <-0.455000, 0.250000, 27.300000>, 
      <-0.895000, 0.000000, 27.700000>, <-0.745000, 0.075000, 27.700000>, <-0.545000, 0.175000, 27.700000>, <-0.395000, 0.250000, 27.700000>, 
      <-0.850000, 0.000000, 28.000000>, <-0.700000, 0.075000, 28.000000>, <-0.500000, 0.175000, 28.000000>, <-0.350000, 0.250000, 28.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.250000, 0.000000>, <0.500000, 0.250000, 8.100000>, <0.500000, 0.250000, 18.900000>, <0.500000, 0.250000, 27.000000>, 
      <0.200000, 0.250000, 0.000000>, <0.200000, 0.250000, 8.100000>, <0.200000, 0.250000, 18.900000>, <0.200000, 0.250000, 27.000000>, 
      <-0.200000, 0.250000, 0.000000>, <-0.200000, 0.250000, 8.100000>, <-0.200000, 0.250000, 18.900000>, <-0.200000, 0.250000, 27.000000>, 
      <-0.500000, 0.250000, 0.000000>, <-0.500000, 0.250000, 8.100000>, <-0.500000, 0.250000, 18.900000>, <-0.500000, 0.250000, 27.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 8.100000>, <1.000000, 0.000000, 18.900000>, <1.000000, 0.000000, 27.000000>, 
      <0.850000, 0.075000, 0.000000>, <0.850000, 0.075000, 8.100000>, <0.850000, 0.075000, 18.900000>, <0.850000, 0.075000, 27.000000>, 
      <0.650000, 0.175000, 0.000000>, <0.650000, 0.175000, 8.100000>, <0.650000, 0.175000, 18.900000>, <0.650000, 0.175000, 27.000000>, 
      <0.500000, 0.250000, 0.000000>, <0.500000, 0.250000, 8.100000>, <0.500000, 0.250000, 18.900000>, <0.500000, 0.250000, 27.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.250000, 0.000000>, <0.500000, -0.250000, 8.100000>, <0.500000, -0.250000, 18.900000>, <0.500000, -0.250000, 27.000000>, 
      <0.650000, -0.175000, 0.000000>, <0.650000, -0.175000, 8.100000>, <0.650000, -0.175000, 18.900000>, <0.650000, -0.175000, 27.000000>, 
      <0.850000, -0.075000, 0.000000>, <0.850000, -0.075000, 8.100000>, <0.850000, -0.075000, 18.900000>, <0.850000, -0.075000, 27.000000>, 
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 8.100000>, <1.000000, 0.000000, 18.900000>, <1.000000, 0.000000, 27.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.250000, 0.000000>, <-0.500000, -0.250000, 8.100000>, <-0.500000, -0.250000, 18.900000>, <-0.500000, -0.250000, 27.000000>, 
      <-0.200000, -0.250000, 0.000000>, <-0.200000, -0.250000, 8.100000>, <-0.200000, -0.250000, 18.900000>, <-0.200000, -0.250000, 27.000000>, 
      <0.200000, -0.250000, 0.000000>, <0.200000, -0.250000, 8.100000>, <0.200000, -0.250000, 18.900000>, <0.200000, -0.250000, 27.000000>, 
      <0.500000, -0.250000, 0.000000>, <0.500000, -0.250000, 8.100000>, <0.500000, -0.250000, 18.900000>, <0.500000, -0.250000, 27.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 8.100000>, <-1.000000, 0.000000, 18.900000>, <-1.000000, 0.000000, 27.000000>, 
      <-0.850000, -0.075000, 0.000000>, <-0.850000, -0.075000, 8.100000>, <-0.850000, -0.075000, 18.900000>, <-0.850000, -0.075000, 27.000000>, 
      <-0.650000, -0.175000, 0.000000>, <-0.650000, -0.175000, 8.100000>, <-0.650000, -0.175000, 18.900000>, <-0.650000, -0.175000, 27.000000>, 
      <-0.500000, -0.250000, 0.000000>, <-0.500000, -0.250000, 8.100000>, <-0.500000, -0.250000, 18.900000>, <-0.500000, -0.250000, 27.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-0.850000, 0.075000, 0.000000>, <-0.650000, 0.175000, 0.000000>, <-0.500000, 0.250000, 0.000000>, 
      <-1.000000, 0.000000, 8.100000>, <-0.850000, 0.075000, 8.100000>, <-0.650000, 0.175000, 8.100000>, <-0.500000, 0.250000, 8.100000>, 
      <-1.000000, 0.000000, 18.900000>, <-0.850000, 0.075000, 18.900000>, <-0.650000, 0.175000, 18.900000>, <-0.500000, 0.250000, 18.900000>, 
      <-1.000000, 0.000000, 27.000000>, <-0.850000, 0.075000, 27.000000>, <-0.650000, 0.175000, 27.000000>, <-0.500000, 0.250000, 27.000000>
    }
  }
  material {
    BladeTexture
  }
  translate  0.5*z
}
#declare SwordBladeEngraving = union {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.0005, 9.0>
    translate  <0.0, -0.2505, 9.0>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 3.0, 0.001>
    rotate 90.0*x
    translate  <0.0, -0.25, 18.0>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.0005, 9.0>
    translate  <0.0, 0.2505, 9.0>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 3.0, 0.001>
    rotate -90.0*x
    translate  <0.0, 0.25, 18.0>
  }
  material {
    EngravingTexture
  }
}
#declare Sword = union {
  object { SwordHilt }
  object { SwordBlade }
  object { SwordBladeEngraving }
  rotate -180.0*y
  translate  <0.0, -1.65, 11.625>
}
union { // SwordWithStand
  object { DisplayStand }
  object { Sword }
  translate  <-18.0, 54.0, 46.0>
}


#declare RndCube001 = merge {
  sphere { <0.8750, 100.1250, 1.8750>, 0.1250 }
  sphere { <0.8750, -100.1250, 1.8750>, 0.1250 }
  sphere { <-0.8750, -100.1250, 1.8750>, 0.1250 }
  sphere { <-0.8750, 100.1250, 1.8750>, 0.1250 }
  sphere { <0.8750, 100.1250, -1.8750>, 0.1250 }
  sphere { <0.8750, -100.1250, -1.8750>, 0.1250 }
  sphere { <-0.8750, -100.1250, -1.8750>, 0.1250 }
  sphere { <-0.8750, 100.1250, -1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, 1.8750>, <-0.8750, 100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, -100.1250, 1.8750>, <-0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, -100.1250, -1.8750>, <-0.8750, -100.1250, -1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, -1.8750>, <-0.8750, 100.1250, -1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, -1.8750>, <0.8750, 100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, -100.1250, -1.8750>, <0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <-0.8750, -100.1250, -1.8750>, <-0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <-0.8750, 100.1250, -1.8750>, <-0.8750, 100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, 1.8750>, <0.8750, -100.1250, 1.8750>, 0.1250 }
  cylinder { <0.8750, 100.1250, -1.8750>, <0.8750, -100.1250, -1.8750>, 0.1250 }
  cylinder { <-0.8750, 100.1250, -1.8750>, <-0.8750, -100.1250, -1.8750>, 0.1250 }
  cylinder { <-0.8750, 100.1250, 1.8750>, <-0.8750, -100.1250, 1.8750>, 0.1250 }
  box { <-0.8750, -100.1250, -2.0000> <0.8750, 100.1250, 2.0000> }
  box { <-0.8750, -100.2500, -1.8750> <0.8750, 100.2500, 1.8750> }
  box { <-1.0000, -100.1250, -1.8750> <1.0000, 100.1250, 1.8750> }
  material {
    WoodBoardTexture
    rotate <-90.0, -90.0, 180.0>
  }
  translate  <1.0, -100.0, 2.0>
}
#declare CSG014 = difference {
  object { RndCube001 }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 0.5, 2.25>
    translate  <1.0, 0.5, 2.0>
  }
}
#declare RoomCelingBoards = union {
  object { CSG014 }
  object { CSG015 }
  object { CSG016 }
  object { // CSG017 -> CSG016
    CSG016
    translate  14.0*x
  }
  object { // CSG018 -> CSG016
    CSG016
    translate  28.0*x
  }
  object { // CSG019 -> CSG016
    CSG016
    translate  42.0*x
  }
  object { // CSG020 -> CSG016
    CSG016
    translate  56.0*x
  }
  object { // CSG021 -> CSG016
    CSG016
    translate  70.0*x
  }
  object { // CSG022 -> CSG016
    CSG016
    translate  84.0*x
  }
  object { // CSG023 -> CSG016
    CSG016
    translate  98.0*x
  }
  object { // CSG024 -> CSG016
    CSG016
    translate  112.0*x
  }
  object { // CSG025 -> CSG016
    CSG016
    translate  126.0*x
  }
  object { // CSG026 -> CSG016
    CSG016
    translate  140.0*x
  }
  object { // CSG027 -> CSG016
    CSG016
    translate  154.0*x
  }
  object { // CSG028 -> CSG016
    CSG016
    translate  168.0*x
  }
  object { // CSG029 -> CSG016
    CSG016
    translate  182.0*x
  }
  object { // CSG030 -> CSG016
    CSG016
    translate  196.0*x
  }
  object { // CSG031 -> CSG015
    CSG015
    translate  -62.0*y
  }
  object { // CSG032 -> CSG015
    CSG015
    translate  -124.0*y
  }
  object { // CSG033 -> CSG015
    CSG015
    translate  -186.0*y
  }
  material {
    FakeWoodTexture
  }
  translate  <-60.0, 54.0, 81.0>
}
#declare RoomSideWallMortar = union {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 75.0, 1.0>
    translate  -1.0*z
  }
  material {
    MortarTexture
  }
  rotate <90.0, 0.0, 90.0>
  translate  <-60.125, 6.1, 23.0>
}
#declare RoomSideWallBrick = union {
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 75.0, 1.0>
    translate  -1.0*z
  }
  material {
    BrickTexture
  }
  rotate <90.0, 0.0, 90.0>
  translate  <-60.0, 6.1, 23.0>
}
#declare CSG034 = union {
  object { RoomSideWallMortar }
  object { RoomSideWallBrick }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      MortarTexture
    }
    hollow
    scale <2.0, 12.0, 6.0>
    translate  <-62.0, 25.0, 75.0>
  }
}
#declare RoomSideWall = difference {
  object { CSG034 }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      MortarTexture
    }
    hollow
    scale <5.0, 11.99, 5.99>
    translate  <-62.0, 25.0, 75.0>
  }
}
#declare RoomBackWallBrick = union {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 75.0, 1.0>
    translate  -1.0*z
  }
  material {
    BrickTexture
  }
  rotate 90.0*x
  translate  <0.5, 54.0, 23.0>
}
#declare RoomBackWallMortar = union {
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 75.0, 1.0>
    translate  -1.0*z
  }
  material {
    MortarTexture
  }
  rotate 90.0*x
  translate  <0.5, 54.125, 23.0>
}
#declare RoomBackWall = union {
  object { RoomBackWallBrick }
  object { RoomBackWallMortar }
}
#declare CSG035 = union {
  object { RoomSideWall }
  object { RoomBackWall }
}
#declare CSG036 = difference {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 0.0>
    scale <45.0, 55.0, 80.0>
    translate  <-59.99, 53.99, 23.0>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*y
    translate  <1.0, -1.0, 0.0>
    scale <1.5, 1.5, 81.0>
    translate  <-62.2, 56.2, 23.0>
  }
  material {
    MortarTexture
  }
}
#declare RoomWalls = difference {
  object { CSG035 }
  object { CSG036 }
}
#declare RoomCeling = union {
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 0.25>
    translate  <100.0, -100.0, 0.25>
  }
  material {
    FakeWoodTexture
  }
  translate  <-62.0, 56.0, 85.0>
}
#declare RndCube004 = merge {
  sphere { <11.7500, 0.2500, 0.0000>, 0.2500 }
  sphere { <11.7500, -0.2500, 0.0000>, 0.2500 }
  sphere { <-11.7500, -0.2500, 0.0000>, 0.2500 }
  sphere { <-11.7500, 0.2500, 0.0000>, 0.2500 }
  cylinder { <11.7500, 0.2500, 0.0000>, <-11.7500, 0.2500, 0.0000>, 0.2500 }
  cylinder { <11.7500, -0.2500, 0.0000>, <-11.7500, -0.2500, 0.0000>, 0.2500 }
  cylinder { <11.7500, 0.2500, 0.0000>, <11.7500, -0.2500, 0.0000>, 0.2500 }
  cylinder { <-11.7500, 0.2500, 0.0000>, <-11.7500, -0.2500, 0.0000>, 0.2500 }
  box { <-11.7500, -0.2500, -0.2500> <11.7500, 0.2500, 0.2500> }
  translate  -5.75*z
}
#declare RndCube005 = merge {
  sphere { <0.0000, 0.2500, 5.7500>, 0.2500 }
  sphere { <0.0000, -0.2500, 5.7500>, 0.2500 }
  sphere { <0.0000, 0.2500, -5.7500>, 0.2500 }
  sphere { <0.0000, -0.2500, -5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, -5.7500>, <0.0000, 0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, -0.2500, -5.7500>, <0.0000, -0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, 5.7500>, <0.0000, -0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, -5.7500>, <0.0000, -0.2500, -5.7500>, 0.2500 }
  box { <-0.2500, -0.2500, -5.7500> <0.2500, 0.2500, 5.7500> }
  translate  -11.75*x
}
#declare RndCube006 = merge {
  sphere { <0.0000, 0.2500, 5.7500>, 0.2500 }
  sphere { <0.0000, -0.2500, 5.7500>, 0.2500 }
  sphere { <0.0000, 0.2500, -5.7500>, 0.2500 }
  sphere { <0.0000, -0.2500, -5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, -5.7500>, <0.0000, 0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, -0.2500, -5.7500>, <0.0000, -0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, 5.7500>, <0.0000, -0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, -5.7500>, <0.0000, -0.2500, -5.7500>, 0.2500 }
  box { <-0.2500, -0.2500, -5.7500> <0.2500, 0.2500, 5.7500> }
  translate  11.75*x
}
#declare RndCube007 = merge {
  sphere { <11.7500, 0.2500, 0.0000>, 0.2500 }
  sphere { <11.7500, -0.2500, 0.0000>, 0.2500 }
  sphere { <-11.7500, -0.2500, 0.0000>, 0.2500 }
  sphere { <-11.7500, 0.2500, 0.0000>, 0.2500 }
  cylinder { <11.7500, 0.2500, 0.0000>, <-11.7500, 0.2500, 0.0000>, 0.2500 }
  cylinder { <11.7500, -0.2500, 0.0000>, <-11.7500, -0.2500, 0.0000>, 0.2500 }
  cylinder { <11.7500, 0.2500, 0.0000>, <11.7500, -0.2500, 0.0000>, 0.2500 }
  cylinder { <-11.7500, 0.2500, 0.0000>, <-11.7500, -0.2500, 0.0000>, 0.2500 }
  box { <-11.7500, -0.2500, -0.2500> <11.7500, 0.2500, 0.2500> }
  translate  5.75*z
}
#declare RndCube008 = merge {
  sphere { <0.0000, 0.2500, 5.7500>, 0.2500 }
  sphere { <0.0000, -0.2500, 5.7500>, 0.2500 }
  sphere { <0.0000, 0.2500, -5.7500>, 0.2500 }
  sphere { <0.0000, -0.2500, -5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, -5.7500>, <0.0000, 0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, -0.2500, -5.7500>, <0.0000, -0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, 5.7500>, <0.0000, -0.2500, 5.7500>, 0.2500 }
  cylinder { <0.0000, 0.2500, -5.7500>, <0.0000, -0.2500, -5.7500>, 0.2500 }
  box { <-0.2500, -0.2500, -5.7500> <0.2500, 0.2500, 5.7500> }
}
#declare WindowFrame = union {
  object { RndCube004 }
  object { RndCube005 }
  object { RndCube006 }
  object { RndCube007 }
  object { RndCube008 }
  material {
    WindowFrameTexture
  }
}
#declare Window = union {
  object { WindowFrame }
  box { // WindowPane
    <-1, -1, -1>, <1, 1, 1>
    material {
      WindowPaneTexture
    }
    scale <11.75, 0.25, 5.75>
  }
  rotate <-0.0, 0.0, 90.0>
  translate  <-62.0, 25.0, 75.0>
}
union { // Room
  object { RoomCelingBoards }
  object { RoomWalls }
  object { RoomCeling }
  object { Window }
  plane { // RoomFloor
    z,0
    material {
      RoomCarpet
    }
  }
}


#declare RndDisc007 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.5, 1.0, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG043 = difference {
  object { RndDisc007 }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 6.1, 0.5>
    translate  <-3.937, 0.0, 0.4>
  }
}
#declare RndCube009 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.6875*z
}
#declare RndCube010 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.0625*z
}
#declare CSG044 = union {
  object { CSG043 }
  object { RndCube009 }
  object { RndCube010 }
}
#declare Cover2 = difference {
  object { CSG044 }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, 0.85>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, -0.1>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.525>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.225>
  }
  material {
    BookGreenTexture
  }
}
#declare Writing2 = union {
  text {   // TText009
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.85, 0.85, 0.5>
    translate  <-4.0, 4.75, 0.0>
  }

  text {   // TText010
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Creature Catalog",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.9, 0.9, 0.5>
    translate  <-3.85, 3.0, 0.0>
  }

  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.05, 0.25>
    translate  <0.0, 4.25, 0.25>
  }
  material {
    BookTextTexture
  }
  scale <1.0, 1.0, 0.00001>
  translate  0.75001*z
}
#declare RndDisc008 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG045 = intersection {
  object { RndDisc008 }
  text {   // TText011
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 5.6, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare RndDisc009 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG046 = intersection {
  object { RndDisc009 }
  text {   // TText012
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Creature Catalog",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 0.8, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare CBook = union {
  object { Cover2 }
  box { // Pages2
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookPagesTexture
    }
    scale <4.375, 5.75, 0.25>
    translate  <-0.1, 0.0, 0.375>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookLabelTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.0, 4.0, 0.00001>
    translate  <0.0, -1.75, 0.75001>
  }
  object { Writing2 }
  object { CSG045 }
  object { CSG046 }
}
#declare RndDisc004 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.5, 1.0, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG047 = difference {
  object { RndDisc004 }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 6.1, 0.5>
    translate  <-3.937, 0.0, 0.4>
  }
}
#declare RndCube011 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.6875*z
}
#declare RndCube012 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.0625*z
}
#declare CSG048 = union {
  object { CSG047 }
  object { RndCube011 }
  object { RndCube012 }
}
#declare Cover1 = difference {
  object { CSG048 }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, 0.85>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, -0.1>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.525>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.225>
  }
  material {
    BookBlueTexture
  }
}
#declare Writing1 = union {
  text {   // TText005
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.85, 0.85, 0.5>
    translate  <-4.0, 4.75, 0.0>
  }

  text {   // TText006
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Master Manual",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <1.0, 1.0, 0.5>
    translate  <-3.5, 3.0, 0.0>
  }

  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.05, 0.25>
    translate  <0.0, 4.25, 0.25>
  }
  material {
    BookTextTexture
  }
  scale <1.0, 1.0, 0.00001>
  translate  0.75001*z
}
#declare RndDisc005 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG049 = intersection {
  object { RndDisc005 }
  text {   // TText007
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 5.6, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare RndDisc006 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG050 = intersection {
  object { RndDisc006 }
  text {   // TText008
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Master Manual",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 0.8, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare MBook = union {
  object { Cover1 }
  box { // Pages1
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookPagesTexture
    }
    scale <4.375, 5.75, 0.25>
    translate  <-0.1, 0.0, 0.375>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookLabelTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.0, 4.0, 0.00001>
    translate  <0.0, -1.75, 0.75001>
  }
  object { Writing1 }
  object { CSG049 }
  object { CSG050 }
  rotate <0.0, 0.0, -29.421362>
  translate  <-0.153614, -1.005035, 0.75>
}
#declare RndDisc002 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.5, 1.0, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG051 = difference {
  object { RndDisc002 }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 6.1, 0.5>
    translate  <-3.937, 0.0, 0.4>
  }
}
#declare RndCube013 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.6875*z
}
#declare RndCube014 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.0625*z
}
#declare CSG052 = union {
  object { CSG051 }
  object { RndCube013 }
  object { RndCube014 }
}
#declare Cover = difference {
  object { CSG052 }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, 0.85>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, -0.1>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.525>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.225>
  }
  material {
    BookRedTexture
  }
}
#declare Writing = union {
  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.85, 0.85, 0.5>
    translate  <-4.0, 4.75, 0.0>
  }

  text {   // TText004
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Player Manual",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <1.0, 1.0, 0.5>
    translate  <-3.5, 3.0, 0.0>
  }

  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.05, 0.25>
    translate  <0.0, 4.25, 0.25>
  }
  material {
    BookTextTexture
  }
  scale <1.0, 1.0, 0.00001>
  translate  0.75001*z
}
#declare RndDisc010 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG053 = intersection {
  object { RndDisc010 }
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 5.6, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare RndDisc011 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG054 = intersection {
  object { RndDisc011 }
  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Player Manual",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 0.8, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare PBook = union {
  object { Cover }
  box { // Pages
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookPagesTexture
    }
    scale <4.375, 5.75, 0.25>
    translate  <-0.1, 0.0, 0.375>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookLabelTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.0, 4.0, 0.00001>
    translate  <0.0, -1.75, 0.75001>
  }
  object { Writing }
  object { CSG053 }
  object { CSG054 }
  rotate <-0.0, 0.0, -39.359085>
  translate  <0.204212, -1.271972, 1.5>
}
#declare RndDisc012 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.5, 1.0, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG055 = difference {
  object { RndDisc012 }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 6.1, 0.5>
    translate  <-3.937, 0.0, 0.4>
  }
}
#declare RndCube015 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.6875*z
}
#declare RndCube016 = merge {
  sphere { <4.4375, 5.9375, 0.0000>, 0.0625 }
  sphere { <4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, -5.9375, 0.0000>, 0.0625 }
  sphere { <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <-4.4375, 5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, -5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <4.4375, 5.9375, 0.0000>, <4.4375, -5.9375, 0.0000>, 0.0625 }
  cylinder { <-4.4375, 5.9375, 0.0000>, <-4.4375, -5.9375, 0.0000>, 0.0625 }
  box { <-4.4375, -5.9375, -0.0625> <4.4375, 5.9375, 0.0625> }
  translate  0.0625*z
}
#declare CSG056 = union {
  object { CSG055 }
  object { RndCube015 }
  object { RndCube016 }
}
#declare Cover3 = difference {
  object { CSG056 }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, 0.85>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.437, -6.25, -0.1>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.525>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 12.5>
    rotate -90.0*x
    translate  <-4.375, -6.25, 0.225>
  }
  material {
    BookRedTexture
  }
}
#declare Writing3 = union {
  text {   // TText013
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.85, 0.85, 0.5>
    translate  <-4.0, 4.75, 0.0>
  }

  text {   // TText014
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Player Manual",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <1.0, 1.0, 0.5>
    translate  <-3.5, 3.0, 0.0>
  }

  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.05, 0.25>
    translate  <0.0, 4.25, 0.25>
  }
  material {
    BookTextTexture
  }
  scale <1.0, 1.0, 0.00001>
  translate  0.75001*z
}
#declare RndDisc013 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG057 = intersection {
  object { RndDisc013 }
  text {   // TText015
    ttf      "C:\WINDOWS\Fonts\Verdanab.ttf",
    "Swords & Staves",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 5.6, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare RndDisc014 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.3750, 0.3750, 11.8750> translate 0.0625*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2500, 0.2500, 12.2400> translate --0.0575*z }
  }
  torus { 0.3125, 0.0625  rotate -x*90 translate  11.9375*z bounded_by { box { <-0.3762, -0.3762, 11.8737>, <0.3762, 0.3762, 12.0013> } } }
  torus { 0.3125, 0.0625  rotate -x*90 translate  0.0625*z bounded_by { box { <-0.3762, -0.3762, -0.0013>, <0.3762, 0.3762, 0.1263> } } }
  scale <0.51, 1.01, 1.0>
  rotate -90.0*x
  translate  <-4.437, -6.0, 0.375>
}
#declare CSG058 = intersection {
  object { RndDisc014 }
  text {   // TText016
    ttf      "C:\WINDOWS\Fonts\Verdana.ttf",
    "Player Manual",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.25
    rotate <90.0, 0.0, -90.0>
    translate  <-4.5, 0.8, 0.28>
  }

  material {
    BookTextTexture
  }
}
#declare PBook1 = union {
  object { Cover3 }
  box { // Pages3
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookPagesTexture
    }
    scale <4.375, 5.75, 0.25>
    translate  <-0.1, 0.0, 0.375>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    material {
      BookLabelTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.0, 4.0, 0.00001>
    translate  <0.0, -1.75, 0.75001>
  }
  object { Writing3 }
  object { CSG057 }
  object { CSG058 }
  rotate <0.0, -0.0, 172.414825>
  translate  <33.739147, 21.536026, -0.0>
}
union { // Books
  object { CBook }
  object { MBook }
  object { PBook }
  object { PBook1 }
  rotate 110.0*z
  translate  <16.10471, -12.59846, 29.55>
}


#declare RndCube020 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieGreenTexture
  }
}
#declare DieGreen = difference {
  object { RndCube020 }
  text {   // TText035
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText036
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText037
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText038
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText039
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText040
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <90.0, 0.0, 165.533127>
  translate  <19.348516, 13.366073, 29.8>
}
#declare RndCube019 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieBlackTexture
  }
}
#declare DieBlack = difference {
  object { RndCube019 }
  text {   // TText029
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText030
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText031
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText032
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText033
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText034
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <2.268506, -90.0, 0.0>
  translate  <19.511754, 14.867372, 29.8>
}
#declare RndCube018 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieMarbleTexture
  }
}
#declare DieMarble = difference {
  object { RndCube018 }
  text {   // TText017
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText018
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText025
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText026
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText027
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText028
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate 36.833378*z
  translate  <20.53645, 13.901291, 29.8>
}
#declare RndCube017 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieSpecTexture
  }
}
#declare DieSpecs = difference {
  object { RndCube017 }
  text {   // TText019
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText020
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText021
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText022
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText023
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText024
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <-90.0, 0.0, -31.537542>
  translate  <16.077392, -9.00371, 32.05>
}
#declare RndCube024 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieGreenTexture
  }
}
#declare DieGreen1 = difference {
  object { RndCube024 }
  text {   // TText059
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText060
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText061
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText062
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText063
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText064
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <-0.0, -180.0, -171.702972>
  translate  <-18.825567, -13.65473, 29.8>
}
#declare RndCube023 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieBlackTexture
  }
}
#declare DieBlack1 = difference {
  object { RndCube023 }
  text {   // TText053
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText054
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText055
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText056
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText057
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText058
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieRedTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <15.0, 90.0, 0.0>
  translate  <-18.446879, -14.375357, 29.8>
}
#declare RndCube022 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieMarbleTexture
  }
}
#declare DieMarble1 = difference {
  object { RndCube022 }
  text {   // TText047
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText048
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText049
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText050
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText051
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText052
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <-90.0, 0.0, -28.209303>
  translate  <-7.824155, 14.444593, 29.8>
}
#declare RndCube021 = merge {
  sphere { <0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, 0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, 0.2250>, 0.0250 }
  sphere { <0.2250, 0.2250, -0.2250>, 0.0250 }
  sphere { <0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, -0.2250, -0.2250>, 0.0250 }
  sphere { <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, -0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, -0.2250, -0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, -0.2250, -0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, 0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, 0.2250>, <0.2250, -0.2250, 0.2250>, 0.0250 }
  cylinder { <0.2250, 0.2250, -0.2250>, <0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, -0.2250>, <-0.2250, -0.2250, -0.2250>, 0.0250 }
  cylinder { <-0.2250, 0.2250, 0.2250>, <-0.2250, -0.2250, 0.2250>, 0.0250 }
  box { <-0.2250, -0.2250, -0.2500> <0.2250, 0.2250, 0.2500> }
  box { <-0.2250, -0.2500, -0.2250> <0.2250, 0.2500, 0.2250> }
  box { <-0.2500, -0.2250, -0.2250> <0.2500, 0.2250, 0.2250> }
  material {
    DieSpecTexture
  }
}
#declare DieSpecs1 = difference {
  object { RndCube021 }
  text {   // TText041
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "1",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    translate  <-0.06, -0.135, 0.245>
  }

  text {   // TText042
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -90.0, 90.0>
    translate  <0.135, -0.245, -0.1>
  }

  text {   // TText043
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "6",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-0.0, -180.0, -90.0>
    translate  <-0.135, -0.1, -0.245>
  }

  text {   // TText044
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "5",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -180.0, 0.0>
    translate  <0.08, 0.245, -0.135>
  }

  text {   // TText045
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "4",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <0.0, -270.0, -180.0>
    translate  <-0.245, 0.135, 0.1>
  }

  text {   // TText046
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "3",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      DieWhiteTexture
    }
    scale <0.375, 0.375, 0.125>
    rotate <-90.0, -0.0, -90.0>
    translate  <0.245, 0.1, 0.135>
  }

  rotate <22.113737, -90.0, 0.0>
  translate  <-8.225393, 12.839638, 29.8>
}
union { // Dice
  object { DieGreen }
  object { DieBlack }
  object { DieMarble }
  object { DieSpecs }
  object { DieGreen1 }
  object { DieBlack1 }
  object { DieMarble1 }
  object { DieSpecs1 }
}


union { // Papers
  box { // PaperScratch
    <-1, -1, -1>, <1, 1, 1>
    material {
      ScratchTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.25, 2.75, 0.01>
    rotate -171.581726*z
    translate  <-4.505238, 14.138487, 0.0>
  }
  box { // PaperMap
    <-1, -1, -1>, <1, 1, 1>
    material {
      MapTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.25, 5.5, 0.01>
    rotate 84.472946*z
    translate  <17.167507, 10.119978, 0.0>
  }
  box { // PaperCharS
    <-1, -1, -1>, <1, 1, 1>
    material {
      CharacterSTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.25, 5.5, 0.01>
    translate  <100.0, 100.0, 100.0>
  }
  box { // PaperCharR
    <-1, -1, -1>, <1, 1, 1>
    material {
      CharacterRTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.25, 5.5, 0.01>
    rotate 171.445023*z
    translate  <4.238793, 10.558095, 0.0>
  }
  box { // PaperCharN
    <-1, -1, -1>, <1, 1, 1>
    material {
      CharacterNTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.25, 5.5, 0.01>
    rotate -84.223961*z
    translate  <-13.869856, 1.047386, 0.0>
  }
  box { // PaperCharD
    <-1, -1, -1>, <1, 1, 1>
    material {
      CharacterDTexture
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <4.25, 5.5, 0.01>
    rotate 97.915741*z
    translate  <16.72925, -0.259354, 0.0>
  }
  translate  29.55*z
}


#declare CSG059 = union {
  object { Cube065 }
  object { // Cube066 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -22.5>
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cube067 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -45.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cube068 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -67.5>
    translate  -0.0*z
  }
  object { // Cube069 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -90.0>
    translate  -0.0*z
  }
  object { // Cube070 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -112.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cube071 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -135.0>
    translate  -0.0*z
  }
  object { // Cube072 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -157.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cube073 -> Cube065
    Cube065
    rotate <-0.0, 0.0, -180.0>
    translate  -0.0*z
  }
  object { // Cube074 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 157.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cube075 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 135.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cube076 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 112.5>
    translate  -0.0*z
  }
  object { // Cube077 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 90.0>
    translate  -0.0*z
  }
  object { // Cube078 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 67.5>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cube079 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 45.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cube080 -> Cube065
    Cube065
    rotate <-0.0, 0.0, 22.5>
    translate  -0.0*z
  }
}
#declare CSG060 = difference {
  cone { // Cone021
    <0,0,0>, 1.125, <0,0,1>, 1.375
    scale <1.0, 1.0, 5.0>
  }
  cone { // Cone022
    <0,0,0>, 1.0625, <0,0,1>, 1.3125
    scale <1.0, 1.0, 5.0>
    translate  0.125*z
  }
  object { CSG059 }
}
union { // Cup
  object { CSG060 }
  torus { // Torus015
    1.34375, 0.03125  rotate -x*90
    scale <1.0, 1.0, 0.75>
    translate  5.0*z
  }
  material {
    DrinkCup
  }
  scale <1.4, 1.4, 1.2>
  translate  <-13.399209, -13.020197, 29.55>
}


#declare CSG037 = difference {
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 1.0>
    translate  1.0*z
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <5.875, 6.0, 1.0>
    translate  <0.0, 0.125, 1.125>
  }
  material {
    PizzaBoxTexture
  }
}
#declare CSG038 = union {
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <5.875, 0.5, 0.0625>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 11.75>
    rotate <-0.0, -90.0, -0.0>
    translate  5.875*x
  }
  rotate 50.0*x
  translate  11.75*y
}
#declare CSG039 = union {
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.875, 0.0625>
    translate  -0.5*x
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 11.75>
    rotate -90.0*x
    translate  -5.875*y
  }
  rotate 65.0*y
  translate  <-5.875, 5.875, 0.0>
}
#declare CSG040 = union {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.875, 0.0625>
    translate  0.5*x
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 11.75>
    rotate -90.0*x
    translate  -5.875*y
  }
  rotate -60.0*y
  translate  <5.875, 5.875, 0.0>
}
#declare CSG041 = union {
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <5.875, 5.875, 0.0625>
  }
  object { CSG038 }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 11.75>
    rotate <-0.0, -90.0, -0.0>
    translate  5.875*x
  }
  object { CSG039 }
  object { CSG040 }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    material {
      PizzaBoxLabelTexture
      scale <2.0, 2.0, 1.0>
      rotate <0.0, -180.0, -180.0>
      translate <-1.000000, 1.000000, 0.000000>
    }
    scale <5.75, 5.75, 0.00001>
    translate  <0.0, 5.8125, -0.06251>
  }
  rotate 95.0*x
  translate  2.0*y
}
#declare CSG042 = union {
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*y
    scale <5.875, 1.0, 0.0625>
  }
  object { CSG041 }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.0625, 0.0625, 11.75>
    rotate <-0.0, -90.0, -0.0>
    translate  5.875*x
  }
  rotate 58.999523*x
  translate  <0.0, 6.0, 0.0625>
}
union { // PizzaBox
  object { CSG037 }
  object { CSG042 }
  material {
    PizzaBoxTexture
  }
  scale <1.35, 1.35, 1.0>
  rotate <-0.0, -0.0, 170.0>
  translate  <-1.092272, -9.318621, 29.55>
}


