// Persistence of Vision Ray Tracer Scene Description File
// File: Lord of the Hunt.pov
// Date: 00/07/01
// Auth: Mick Hazelgrove

#version 3.5;

#declare Rad_on = 1;
 
#declare Water_on = 1;   
#declare Grass_on = 1;
#declare Fog_on = 1;
#declare Ground_on = 1;  
#declare Ground_Union_on = 1;
#declare Birds_on = 1;
#declare Mountain_on = 1; 
#declare BeachStones_on =1; 
#declare BigStones_on = 1; 
#declare Menhir_on = 1; 
#declare Path_on = 1; 
#declare Lord_of_the_Hunt_on = 1; 

#include "stone.inc" 
#include "Dolmen2.inc"
#include "Tmenhir.inc"
#include "colors.inc"
#include "function.inc"

global_settings{
  assumed_gamma 1.0 
 ambient_light rgb<3,3,3> 

	#if(Rad_on =1)  
	  radiosity{
		 pretrace_start 0.08
		 pretrace_end   0.01
		 count 20              
		 nearest_count 5      
		 error_bound 0.4   
		 recursion_limit 1    
		 low_error_factor 0.5  
		 gray_threshold 0  
		 minimum_reuse 0.015
		 brightness 3      
		 adc_bailout 0.006
		 normal on
		}
	#end	
}

// ------------------------------------------------

#macro mAlign(P1,P2)
#local yV1=vnormalize(P2-P1);
#local xV1=vnormalize(vcross(yV1,z));
#local zV1=vcross(xV1,yV1);
     matrix <xV1.x,xV1.y,xV1.z,yV1.x,yV1.y,yV1.z,zV1.x,zV1.y,zV1.z,P1.x,P1.y,P1.z>
#end 


#declare PigFun = function{pigment{bozo scale .05 translate <-10,0,-5>}}  
#declare PathFun = function{
	pigment{
		image_map
		{
		  sys "Path2.bmp" 
		  map_type 0 
		  interpolate 2 
		  once 
		} // image_map 
		rotate x*90
		translate <-.5,0,-.5>
        }
        }
#declare MenhFun = function{
	pigment{
		image_map
		{
		  sys "menhir3.bmp" 
		  map_type 0 
		  interpolate 2 
		  once 
		} // image_map 
		rotate x*90
		translate <-.5,0,-.5>
        }
        }
// ------------------------------------------------

#declare Image_Length = 750;
#declare Image_Height = 450;
                            
#declare CamPos = <0.0, 0, -25>;

camera
{
  location CamPos
  direction 1.5*z
  right Image_Length/Image_Height*x 
  look_at  <0,0,0> 
  angle 52
}

sky_sphere
{ 
  pigment
  {
    gradient y turbulence .8
    color_map { 
    	[0.0 color rgb <1,.9,.75>]
    	[0.075 color rgb <1,.9,1>/2]
    	[0.275 color rgb 1] 
    	[0.5 color rgb<.7,.8,1>]

    }
    rotate x*19
    rotate y*-10 
    scale .3
  }
}

light_source {<4500,1500,-5000>color rgb <0.9965, 0.475, 0.175>*3}
        
//------------------------------------

#if (Ground_on =1)

#declare SandTex = texture{
    pigment {bozo pigment_map{
	    [0 rgb<.4,.4,.2>]
	    [.33 rgb<.5,.5,.3>]
	    [.66 rgb.7]
	    [1 rgb<.3,.3,.125>]
	    }
	    turbulence .2 scale .005
	    }
	finish{ ambient 0 diffuse 0.15}
	normal{average normal_map{
		[crackle 1 ramp_wave scale .02 turbulence .3 frequency 4] 
		[crackle .5 ramp_wave scale .1 turbulence .3 frequency 2]
		[crackle .33 ramp_wave scale .0025 turbulence .3 frequency 3]
		}
		}
	}
#declare VegTex = texture{
	pigment {bozo pigment_map{
		[0 rgb<.5,.5,.4>*1.5]
		[.33 rgb<.325,.25,.175>*2]
		[.66 rgb<.125,.1,.075>*3]
		[1 rgb<.25,.1,.025>]
		}
		turbulence .2 scale .05  
		rotate x*-90
		}
	finish{ambient 0 diffuse 0.2}
	normal{average normal_map{
		[crackle 100 ramp_wave scale .02 turbulence .3 frequency 4] 
		[wrinkles 500 scale .015]
		[crackle 300 ramp_wave scale .125 turbulence .3 frequency 3]
		}
		}
	}
#declare RockTex = texture{
	pigment {agate pigment_map{[0 rgb <.8,.8,.5>][1 rgb<.4,.25,.15>]}turbulence .8 scale .025} 
	finish{ambient 0 diffuse .2 }
	normal{agate 10 scale .025 ramp_wave }
    }    	

#declare GMTex = 
texture{ gradient y
	 texture_map{
		[ 0.0 SandTex ]
		[ 0.28 SandTex ] 
		[ 0.3 VegTex ]
		[ 0.5 VegTex ]
		[ 0.75 RockTex ]
		[ 1.0 RockTex ]
		}
		turbulence .1
		scale .031 
		translate y*.0075
		}

#declare Mounds =

height_field{ 
  sys"ground.bmp"
		smooth 
			translate <-.5,0,-.5>
				scale <1,.0475,1>
				}

#end

//----------------------------------------------------------------

#if (Grass_on =1)

#include"Cinqfoil.inc"
#include"BarGMF.inc" 
#declare GR = seed(579);
#declare FR = seed(279); 
#declare Frot = seed(456);

#declare TracedObjGrass = union{
#declare Norm = <0,0,0>;
#declare Xpos = -.2;
#declare Zpos = -.4;
#declare MaxAngle = 67;
#declare Count = 0;  
 
#while (Xpos<.2)

   #while (Zpos<.2)
  
       #declare TestPos = <Xpos+(rand(GR)*.005),10,Zpos+(rand(GR)*.005)>;
       #declare Inter = trace (Mounds,TestPos,<0,-10,0>, Norm); 
       #declare CamDir = vnormalize(TestPos-CamPos);
       #if(vdot(CamDir.z,Norm.z)<cos(radians(MaxAngle)))
       #declare PCol = (PathFun(TestPos.x,TestPos.y,TestPos.z));
       
          #if (vlength(Norm)!=0)
           #if(Inter.y>.01725)
               #if (PCol.z<.5) 
               
                 #if (mod(Count,2)=0)
                  object{Flower  scale <.1,.0275,.1>    
                  	scale<.0001+(rand(FR)*.000125)/4,.000225+(rand(FR)*.00025),.0001+(rand(FR)*.0001)/5> // was/4
                  	rotate rand(Frot)*360
                  	rotate x*7 
                  	mAlign(Inter,Inter+Norm)
                  	}
                  #end 
                 
                  object{Grass 
          			 pigment{gradient y turbulence .3
				    	pigment_map{
				    		[0 rgb <.3+(rand(GR)/3), .6+(rand(GR)/4), 0>]
				    		[1 rgb <1, .25+(rand(GR)/2), .1>] 
				    		}
				    		scale 4
				          	}
						finish{specular .4 roughness .1 ambient 0 diffuse .05+(rand(GR)/5)}
							 scale<.0002+(rand(GR)*.000125),.00045+(rand(GR)*.00025),.0002 +(rand(GR)*.000125)>
							      mAlign(<Inter.x,Inter.y-.001,Inter.z>,Inter+Norm) 
								   } 
			 #end 
			 #end				   					   				   
           #end 
         #end
                      
    #declare Zpos = Zpos +.002; 
    #declare Count = Count + 1;
    #end           
    #declare Zpos = -.4; 
    #declare Count = 0;
  #declare Xpos = Xpos + .002; 
 #end 
}


  object{Grass  //foreground
	 pigment{gradient y turbulence .3
    	pigment_map{
    		[0 rgb <.3, .6, 0>]
    		[1 rgb <1, .25, .1>] 
    		}
    		scale 4
          	}
		finish{specular .4 roughness .1 ambient 0  diffuse .05+(rand(GR)/5)}           
			 scale .75
			 rotate z*-5
			      translate <-3.5,-15.1,28>
				   }
				   
object{Grass    //on hill
	 pigment{gradient y turbulence .3
    	pigment_map{
    		[0 rgb <.3, .6, 0>]
    		[1 rgb <1, .25, .1>] 
    		}
    		scale 4
          	}
		finish{specular .4 roughness .1 ambient 0  diffuse .125}           
			 rotate <-80,-45,0> 
			 scale <.75,.375,.75>  // scale after rotation
			      translate <-51,6.5,124>
				   }
#end

//----------------------------------------------------------------

#if (BeachStones_on =1)
#declare BR = seed(2363);


#declare TracedObjBeachStones = union{
#declare Norm = <0,0,0>;
#declare Xpos = -.05;
#declare Zpos = -.25; 
 
#while (Xpos<.05)

   #while (Zpos<.2)
 
       #declare TestPos = <Xpos+(rand(BR)*.005),10,Zpos+(rand(BR)*.005)>;
       #declare Inter = trace (Mounds,TestPos,<0,-10,0>, Norm); 
               

          #if (vlength(Norm)!=0)
           #if(Inter.y<.017 & Inter.y>.01)
            
                  object{Stone 
						pigment{rgb<.6 +(rand(BR)/10),.675+(rand(BR)/10),.65+(rand(BR)/10)>*1.2}
						normal{average normal_map{
						  	[bumps 5 scale .1 ramp_wave] 
						  	[agate 10 scale .5 ramp_wave]
							[granite 2 turbulence .8 scale 2] 
							[crackle 5 turbulence .8 scale 1]
							}
							}
                    	finish{ ambient 0 diffuse .15+(rand(BR)/50)specular .75 roughness .01}
						    rotate rand(BR)*360 
							#declare Scl =<.0015+((rand(BR)-.5)*.0005),(.000375*2)+((rand(BR)-.5)*.0005),.0015+((rand(BR)-.5)*.0005)>; 
							    scale Scl 
							      translate Inter 
								   }
 				   					   				   
           #end 
         #end
                      
    #declare Zpos = Zpos +.0075;
    #end           
    #declare Zpos = -.25;
  #declare Xpos = Xpos + .0075; 
 #end 
}

#end
//-----------------------------------------------------
 
#if(BigStones_on = 1)

#declare RR = seed(387);
#declare PR = seed(577); 
#declare SR = seed(123);                                                                                            

#declare TracedObjBigStones = union{
#declare Norm = <0,0,0>;
#declare Xpos = -.2;
#declare Zpos = -.3675; 
 
#while (Xpos<.2)

   #while (Zpos<.4)
        
        #declare TestPos = <Xpos+(rand(RR)*.005),10,Zpos+(rand(RR)*.005)>;
        #declare Inter = trace (Mounds,TestPos,<0,-10,0>, Norm);
        #declare Col = (PigFun(TestPos.x,TestPos.y,TestPos.z));
        #declare SCol = (PathFun(TestPos.x,TestPos.y,TestPos.z));
               
            #if (vlength(Norm)!=0) 
              #if (Col.z>.45)
              #if (SCol.z<.9)
              
				object{ 
				  Stone
					pigment{rgb<.6 +(rand(PR)/10),.675+(rand(PR)/10),.65+(rand(PR)/10)>*1.2}
						  normal{average normal_map{
						  	[bumps 5 scale .1 ramp_wave] 
						  	[agate 10 scale .5 ramp_wave]
							[granite 2 turbulence .8 scale 2] 
							[crackle 5 turbulence .8 scale 1]
							}
							}
                    	finish{ambient 0 diffuse .15+(rand(RR)/50)specular .75 roughness .01}
						    rotate rand(SR)*360    
								scale<.00275+((rand(RR)-.5)*.00125),.001325+((rand(RR)-.5)*.0005),.001+((rand(RR)-.5)*.001)>*(rand(RR)+.2)     
								     mAlign(Inter,Inter+Norm)
								     }
					#end
				#end			                 			     				     
            #end            
    #declare Zpos = Zpos +.0075;
    #end           
    #declare Zpos = -.3675;
  #declare Xpos = Xpos +.0075;
 #end 
}
				object{ 
				  Stone  //far left
					pigment{rgb<.6 +(rand(PR)/10),.675+(rand(PR)/10),.65+(rand(PR)/10)>*1.2} 
						  normal{average normal_map{
						  	[bumps 5 scale .1 ramp_wave] 
						  	[agate 10 scale .5 ramp_wave]
							[granite 2 turbulence .8 scale 2] 
							[crackle 5 turbulence .8 scale 1]
							}
							}
                    	finish{ambient 0 diffuse .15 specular .75 roughness .01} 
                    		scale<.3,.125,.1>*16
                    		  rotate x*65 rotate z*20 rotate x*150
                    		  rotate y*-15
                    			translate<-64,7.25,119>
                    			}

				object{ 
				  Stone //by deer
					pigment{rgb<.6 +(rand(PR)/10),.675+(rand(PR)/10),.65+(rand(PR)/10)>*1.2} 
						  normal{average normal_map{
						  	[bumps 5 scale .1 ramp_wave] 
						  	[agate 10 scale .5 ramp_wave]
							[granite 2 turbulence .8 scale 2] 
							[crackle 5 turbulence .8 scale 1]
							}
							}
                    	finish{ambient 0 diffuse .15 specular .75 roughness .01} 
                    		scale<.275,.125,.1>*16
                    		  rotate x*65 rotate z*-10 rotate x*180
                    			translate<23,-16.25,80>
                    			}                    			                    				
#end

//----------------------------------------------------------------
#if (Path_on =1)
#include"BarGMFtest.inc"
#declare PthR = seed (3124); 

#declare TracedObjPath = union{
#declare Norm = <0,0,0>;
#declare Xpos = -.05;
#declare Zpos = -.4; 
 
#while (Xpos<.05)

   #while (Zpos<.0)
  
       #declare TestPos = <Xpos+(rand(PthR)*.005),10,Zpos+(rand(PthR)*.005)>;
       #declare Inter = trace (Mounds,TestPos,<0,-10,0>, Norm); 
       #declare PCol = (PathFun(TestPos.x,TestPos.y,TestPos.z));
       
          #if (vlength(Norm)!=0)

               #if (PCol.z>.5)
               
               #declare TNum = (Zpos*1000)+320;
						    
               #if(mod(TNum,7)=0) 
                    object{Grass 
                      pigment{gradient y turbulence .3
				    	pigment_map{
				    		[0 rgb <.3+(rand(PthR)/3), .6+(rand(PthR)/4), 0>]
				    		[1 rgb <1, .25+(rand(PthR)/2), .1>] 
				    		}
				    		scale 3
				          	}
                      finish{ambient 0 diffuse .15}
                    	scale<.000325,.000225,.000325> translate Inter
                    	}
               #else
                    object{Stone 
						pigment{rgb<.6 +(rand(PthR)/10),.675+(rand(PthR)/10),.65+(rand(PthR)/10)>*1.2}
						normal{average normal_map{
						  	[bumps 5 scale .1 ramp_wave] 
						  	[agate 1 scale .5 ramp_wave]
							[granite 2 turbulence .8 scale 2] 
							[crackle 5 turbulence .8 scale 1]
							}
							}
                    	finish{ ambient 0 diffuse .15+(rand(PthR)/50)specular .75 roughness .01}
						    rotate rand(PthR)*360 
							#declare Scl =<.00075+((rand(PthR)-.5)*.00075),(.0003)+((rand(PthR)-.5)*.0005),.00075+((rand(PthR)-.5)*.00075)>/2; 
							    scale Scl 
							      mAlign(Inter,Inter+Norm) 
								   }
               //#end
			 #end				   					   				   
           #end 
         #end
                      
    #declare Zpos = Zpos +.001;
    #end           
    #declare Zpos = -.4;
  #declare Xpos = Xpos + .001; 
 #end 
}

#end

//----------------------------------------------------------------
 
#if(Menhir_on = 1)

#declare MR = seed(163);  // scale
#declare PgR = seed(557);  // pigment
#declare StR = seed(577);  // rotation
#declare SSR = seed (4539); // carved menhir                                                                                      

#declare TracedObjMenhir = union{
#declare Norm = <0,0,0>;
#declare Xpos = -.2;
#declare Zpos = -4; 
#declare C=0;
 
#while (Xpos<.2)

   #while (Zpos<.4)
        
        #declare TestPos = <Xpos,10,Zpos>;
        #declare Inter = trace (Mounds,TestPos,<0,-10,0>, Norm);
         #declare MCol = (MenhFun(TestPos.x,TestPos.y,TestPos.z));
               
            #if (vlength(Norm)!=0) 
              #if (MCol.z>.5)
                #if(mod(C,2)=0)
				object{ 
				  Dolmen
					pigment{rgb<.6 +(rand(PgR)/10),.675+(rand(PgR)/10),.65+(rand(PgR)/10)>*1.2}
						  normal{average normal_map{
						  	[bumps 5 scale .1 ramp_wave] 
						  	[agate 10 scale .5 ramp_wave]
							[granite 2 turbulence .8 scale 2] 
							[crackle 5 turbulence .8 scale 1]
							}
							scale <1,2,1>
							}
                    	finish{ambient 0 diffuse .15+(rand(MR)/50)specular .75 roughness .01}
						    rotate y*rand(StR)*360 
                                   scale <.00005+(rand(MR)*.00005),.0001+((rand(MR)-.5)*.00015),.000075+(rand(MR)*.00005)>*5  
								     mAlign(Inter,Inter+Norm)
								   }
				
				 #else
					 object{ 
					  Menhir
						pigment{rgb<.6 +(rand(PgR)/10),.675+(rand(PgR)/10),.65+(rand(PgR)/10)>*1.2}
							  normal{average normal_map{
							  	[bumps 5 scale .1 ramp_wave] 
							  	[agate 10 scale .5 ramp_wave]
								[granite 2 turbulence .8 scale 2] 
								[crackle 5 turbulence .8 scale 1]
								}
								scale <1,2,1>
								}
	                    	finish{ambient 0 diffuse .15+(rand(MR)/50)specular .75 roughness .01}
							    rotate y*rand(StR)*360 
	                                   scale <.0000875+(rand(MR)*.00005),.0001375+((rand(MR)-.5)*.00015),.0000875+(rand(MR)*.00005)>*5  
									     mAlign(Inter,Inter+Norm)
									   }
				
				 #end
			  #end			                 			     				     
            #end            
    #declare Zpos = Zpos +.004; 
    #declare C=C+1;
    #end           
    #declare Zpos = -4; 
    #declare C = 0;
  #declare Xpos = Xpos +.004;  
 #end 
}


#declare StandingStone = union{ 
	object{Dolmen scale<1,2,1.75>*.2 rotate y*90}
	height_field{
		gif"Rondel2.gif" 
			smooth  
			water_level.1
			translate<-.5,0,-.5> 
			rotate x*-90
			scale<1.75,1.75,.2>
			translate z*-.3 
			rotate x*3 translate <.15,3.5,.3325> rotate x*-2.675 rotate y*3.35
			} 
            }

object{StandingStone texture{
						pigment{rgb<.6 +(rand(SSR)/10),.55+(rand(SSR)/10),.6+(rand(SSR)/10)>*1.2}
							  normal{average normal_map{
							  	[bumps 5/2 scale .1 ramp_wave] 
							  	[agate 10/2 scale .5 ramp_wave]
								[granite 2/2 turbulence .8 scale 2] 
								[crackle 5/2 turbulence .8 scale 1]
								}
								scale <1,3,1>/4
								}
	                    	  finish{ambient 0 diffuse .155  +(rand(SSR)/50)specular .75 roughness .01}	
                           		}
                           			scale <3,3.5,3.5> rotate y*15
                           				translate <35,-16,80>
                           				}
                           		
#end                           		

//---------------------------------------------------------------- 

//Put together
#if(Ground_Union_on = 1) 

#declare Ground = union{
	object{Mounds 
		texture{GMTex}
		} 
		object{TracedObjGrass}
		object{TracedObjBeachStones}
		object{TracedObjBigStones} 
		object{TracedObjMenhir}
		object{TracedObjPath}
		}

object {Ground 
scale 2000 
translate <0,-50,590> 
rotate y*12
hollow
}
plane{y,-20.5 pigment{rgb<0,.175,0>}} 

#end  

//----------------------------------------------------------------

#if(Water_on =1)

plane{y,-18.375
	pigment{rgbt<0,8,.4,.9>} 
	   normal{bozo normal_map{ 
		[0 bumps .45 scale<.5,.125,.125>*10 ]
		[0.6 bumps 0]
		[1 bumps 0]
		}
		scale .5 
		}
		finish{
			reflection .375
			ambient 0.0  
			diffuse .01
			phong 100 phong_size 200
			specular 1 roughness 0.005  
      		metallic 0.875 
			}                                                                                   
		 	interior { ior 1.33 fade_distance .025 fade_power 500 fade_color rgb<0.05,1,0.125>*.25
		 		media{
		  			method 3
		  			absorption <.225,.25,.225>*3
		  			samples 2,2
		  			}
		 		}
		hollow			 		 
     }
     
     
#end
			
//-----------------------------------------------------------------

#if(Fog_on = 1)

fog
{
  fog_type   2
  distance   550 
  color      rgbt <.65,.55,.5,-1>
  fog_offset 5   
  fog_alt    60
  turbulence .01
}                                                                                                                                       
  
#end

// -------------------------------------------------------------------
#if(Mountain_on = 1)
  
#declare Tex2 = texture{   // Rock
   pigment { 
    bozo
    turbulence 0.3
    scale 0.05
    color_map {
      [0.25 rgb<.65,.325,.2>*1] 
      [0.5 rgb<.45,.325,.1>*1]
      [0.75 rgb<.65,.5,.3>*1]
   }
   scale .5
  }
   finish{ambient 0 diffuse .15}
   normal{bumps 5 frequency 3 scallop_wave  scale 0.01}  
}
 
#declare Tex3 = texture{  // Snow
   pigment { 
    wrinkles
    turbulence 0.3
    scale 0.01
    color_map {
     [0.25 rgb <.9,1,.9>] 
      [0.5 rgb <.1,.8,1>] 
     [0.75 rgb <.95,1,1>] 
   }
   rotate x*-90
   rotate z*90
   }
   finish{ ambient 0  diffuse .35 specular 1 reflection .5}
   normal{wrinkles 5 frequency 3 scallop_wave  scale 0.05}  
}
#declare Snow = texture{  // Snow
   pigment { 
    wrinkles
    turbulence 0.3
    scale 0.01
    color_map {
     [0.25 rgb <.9,1,.9>] 
      [0.5 rgb <.1,.8,1>] 
     [0.75 rgb <.95,1,1>] 
   }
   rotate x*-90
   rotate z*90
   }
   finish{ ambient 0  diffuse .35 specular 1 reflection .5}  
}           
#declare MountainTex = texture{
   slope{-y*3 0,0.5
  altitude <0,1,0>  .6, 1
   }
        texture_map{
            [0.65 Tex2]
            [0.625 Snow]
            }
            }
                        
height_field
{
  tga   
  "Mountain2.tga"
texture {MountainTex}
smooth 
translate -.5
scale <7000*4,1200*3,3000*4>
translate <-1200,0,3500*4>
}

height_field  //right
{
  tga   
  "Mountain2.tga"
texture {MountainTex}
smooth 
translate -.5
rotate y*-90
scale <4000*4,1400*3,3000*4>
translate <1850*4,0,2750*4>
}

height_field  //left
{
  tga   
  "cliffs.tga"
texture {Tex3}
smooth 
translate -.5 
scale <1000*4,1300*3,3000*4> 
translate <500*4,0,2750*4> 

}

#end

//--------------------------------------------------------- 

#if (Lord_of_the_Hunt_on = 1)

#declare StagTex=texture{
pigment
{
	image_map
	{
		 tga "StagTex.tga"
		 interpolate 2
	}
}
normal{
bump_map
{ 
  tga "StagTexBump.tga" 
  bump_size 15 
} 
}
}  

#declare HairTex=texture{
pigment
{
	image_map
	{
		 tga "hairmap.tga"
		 interpolate 2
	}
}
finish{ambient 0 diffuse .25  phong 100 phong_size 200}
}
//==========================

#declare RiderTex=texture{
pigment
{                                                    
	image_map
	{
		 tga "rider4.tga" 
		 interpolate 2
	}
}
normal{
bump_map
{ 
  tga "riderBump2.tga" 
  bump_size 15 
} 
}
}
#declare WR = seed(253);

#declare WolfTex=texture{
pigment
{
	image_map
	{
		 tga "wolfmap.tga"
		 interpolate 2
	}
}
normal{
bump_map
{ 
  tga "wolfmapbump.tga" 
  bump_size 15 
} 
}
finish{ambient 0 diffuse .15}
}

#declare BeardTex = texture{
	pigment{rgb <.75,.65,.4>}
	finish{ambient 0 diffuse .275 phong 100 phong_size 400}
	normal{wrinkles 1 scale .001}
	}                            

#declare ShieldTex=texture{
pigment
{
	image_map
	{
		 tga "ShieldF.tga"
		 interpolate 2
	}
}
normal{
bump_map
{ 
  tga "ShieldF.tga" 
  bump_size 15 
} 
}
finish{ambient 0 diffuse .15}
}

#declare FawnTex=texture{
pigment
{
	image_map
	{
		 tga "fawn.tga"
		 interpolate 2
	}
}
normal{
bump_map
{ 
  sys "fawnbump.bmp" 
  bump_size 15 
} 
}
finish{ambient 0 diffuse .15 }
}

#declare DoeTex=texture{
pigment
{
	image_map
	{
		 tga "doemap2.tga"
		 interpolate 2
	}
}
normal{
bump_map
{ 
  tga "doebump.tga" 
  bump_size 35 
} 
}
finish{ambient 0 diffuse .175 phong 100 phong_size 200}
}

#declare EagleTex=texture{
pigment
{
	image_map
	{
		 tga "eaglemap.tga"
		 interpolate 2
	}
}
finish{ambient 0 diffuse .15}
}

#declare HPTex = texture
	{
		pigment{rgb <.75,.65,.4>}
		finish{ambient 0 diffuse .275 phong 100 phong_size 400} 
		normal{wrinkles 1 scale .001}
	}
		
//================================
#include"rider3_o"
#include"Stag_o" 
#include"Beard_o" 
#include"Beard2_o" 
#include"ShieldF_o"
#include"hair_o" 
#include"Horn1"
#include"howlingwolf_o"
#include"runningwolf_o"  
#include"snarlingwolf_o"  
#include"turningwolf_o" 
#include"trackingwolf_o" 
#include"Doe_o"
#include"Fawn_o" 
#include"Eagle_o"
#include"stonespear_o" 
#include"hairpiece_o"

#declare Lord_of_the_Hunt = union{
	object{Rider}
	object{Stag}
	object{Beard}
	object{Beard2} 
	object{Hair}
	}
	
object{Lord_of_the_Hunt	
	scale 16*1.2 
		rotate y*-90
			scale<1,1,-1 >
				translate <19,-16.5,75.5>
				}
				
	object{Hairpiece 
		texture{HPTex}
		  scale <.02,.025,.02>
		  rotate<-90,0,22.5>
	     	translate<22.575,-1.75,73.325> 
		    }
		    
	object{Hairpiece 
		texture{HPTex}
		  scale <.02,.0175,.02>
		  rotate<-85,0,-22.5>
	     	translate<21.6,-1.775,73.375> 
		    }

object{Shield 
	scale 17.5 
	rotate y*170
	translate <21.75,-13.8,73.1> 
	}
	
object{Horn1 texture{
	pigment{rgb<1,.75,.5>}
	finish{ambient 0 diffuse .15 specular 1}
	normal{radial .2 rotate x*-90 rotate z*30 scallop_wave frequency 55}}
		scale 1.25
 			rotate x*-90
 			rotate z*-112
 			rotate y*-5 
 				translate <22,0.375,75.25> 
				}
				
object{Spear  scale 20	rotate z* 100 rotate y*-2.75 translate <27,-8.375,73.4>}				
	
// wolves

object{HowlingWolf 
     scale 12 
     rotate y*-90
		translate <29,-15,75.5>	
		}
object{RunningWolf 
     scale 12 
     rotate y*-90
		translate <38,-15,73>	
		}

object{TrackingWolf 
     scale 12 
     rotate y*-70
		translate <35,-15,55>	
		}
				
object{SnarlingWolf  
     scale 12 
     rotate y*-80
		translate <30,-15,63>	
		}		
		
object{TurningWolf 
     scale 12 
     rotate y*-90
     rotate z*10
		translate <17.9,-16,78>	
		}
		
object{TrackingWolf 
     scale 12 
     rotate y*-100
		translate <10.5,-17.75,75.5>	
		}				

#declare Deer = union{		
object{Doe	
	scale 13
	}
	
object{Fawn	
	scale 12				
	}
}
	
object{Deer
	scale<-1,1,1>
	rotate y*32.5 
	translate <-19.5,-15.1,32> 
	}
 
object{Eagle
	scale 13
	rotate z*-5
		translate<0,40,200>
		}
object{Eagle
	scale 10
	rotate z*-15 
	rotate x*-5
		translate<-10,43,250>
		}
object{Eagle
	scale 12 
	rotate x*7.5
		translate<8,42,225>
		}				

#declare OwlTex=texture{
pigment
{
	image_map
	{
		 sys "OwlTex2    .bmp"
		 interpolate 2
	}
}

finish{ambient 0.0 diffuse .15 specular 1 roughness .01}
} 

#include"Owl_o"
                
                
object{Owl scale .06 translate <34.25,5.25,80>}
				
#end 	