#version unofficial megapov .7;

#declare f_wrinkles=
function
{
	pigment
	{
		wrinkles
	}
}

#declare f_granite=
function
{
	pigment
	{
		granite
	}
} 

#declare tazpig=
pigment
{
	image_map
	{
		tga "tatzen.tga" interpolate 2 once
	}
	translate -.5
	scale 4 rotate x*90
	rotate y*180 
	translate <-2,0,-5>
}

#declare tazfunc2=function{pigment{tazpig}}
#declare tazfunc=
function
{       
	
	if
	(
		-(abs(x+2)-2),
		if
		(
			-(abs(z+5)-2),
			.02*tazfunc2,
			0
		),
		0
	)
}

#declare tazpig=pigment{function{tazfunc}}


#declare sand_land = isosurface
{       
	function
	{
		(sqrt(x*x+(y+100*1000)^2+z*z)-100*1000)
		-.2*f_wrinkles + tazfunc
	}
	contained_by { box {<-300,-100,-300>,<300,.2,300>}} 
        
        // max_gradient = 1 
	// method 2 
	eval
}

#declare land=isosurface
{ 
	#local Height = 5; //m
	#local Size = 5;
	#local iDist = 3;
	#local xd=-4;
	#local zd=-8.5;
	
	function
	{
		(sqrt(x*x+(y+100)^2+z*z)-100)-
		(1-2^(-(x*x+z*z)*iDist))*
		(Height*f_wrinkles(x/Size,0,z/Size)-Height/3)
	}                 

	contained_by { box {<-20,-1,-20>,<20,10,20>}}        

	// all_intersections
	// max_gradient 2 
	eval
	method 2
	normal on 
	// open 
	
	scale 1000
	
}  

#if(isoscape)
	union
	{
		object{sand_land}
		object
		{
			land
			// pigment{color rgb 1}
			light_group "!inside"
		}
		texture
	       	{
			slope y
			texture_map
			{
				[0.00 rock]  
				[0.60 rock]
				[0.82 rock]
				[0.95 iron]
				[1.00 sandtex]
			}
		}
	}
#else
	sphere{0,1000 translate -y*1000 texture{sandtex}}
#end


// stone clutter

#macro stone(sSize) 
	isosurface
	{
		function
		{
			(sqrt(x*x+y*y+z*z)-sSize)
			+.6*f_granite(x/4,y/4,z/4)
		}
		
		method 2
		max_gradient 2.5
		// eval
		
		contained_by
		{
			sphere{0,sSize+.6}
		}
	}
#end

#if(stones)
	#local i=0;
	#local imax=500;
	#local R=100;
	#local Ss = seed(1);
	#while(i<imax)
		#local cX=0;
		#local cZ=0;
		#while((cX<5) & (cX>-5) & (cZ<5) & (cZ>-5))
			#local cX=(rand(Ss)-.5)*2*R;
			#local cZ=(rand(Ss)-.5)*2*R;
		#end
	      
	      	#local norm = <0,0,0>;
		#local pos = trace(sand_land,<cX,100,cZ>,-y,norm);
		#local Size = rand(Ss)*.9+.1;
		
		/*debug str(X,0,3)
		#debug "|"
		#debug str(X,0,3)
		#debug "\n"*/
		
		object
		{
			stone(Size*Size)
			translate pos
			texture{rock2}
			light_group "!inside"
		}
		#local i=i+1;
	#end 
	
	
	object
	{
		stone(1)
		#local norm = <0,0,0>;
		translate trace(sand_land,<0,100,-6>,-y,norm)-y*.5
		texture{rock2}
		light_group "!inside"
	}
	
	object
	{
		stone(.75)
		#local norm = <0,0,0>;
		translate trace(sand_land,<-2,100,-6.6>,-y,norm)-y*.2
		texture{rock2}
		light_group "!inside"
	}
#end 

#macro cosw(X,L,H)
	#local out=<X*L,0,(1-cos(X*pi))*.5*H>;
	out
#end  

#macro coswrot(X,L,H)
	#local out = atan2( 1/(sin(X*pi)*H/L),1);
	(degrees(out)-90)
#end


#macro addPathPillars()
	#if(saeulen)
	// Wegrandsulen
	union
	{
		union
		{
			difference // zerbrochene Sule
			{
				object
				{
					saeule(250)
				}
				height_field
				{
					tga "foggy.tga"
					translate -.5
					scale <4,-.25,4>
					rotate x*10
					rotate -z*5
					translate y*.6
					rotate y*70
					texture
					{
						pigment{color rgb 1*.9}
						finish
						{
							brilliance .75
						}
					
						normal
						{
							granite -.1
							scale .1
						}
					}
				}
				
				bounded_by
				{
					cylinder
					{
						<0,0,0>,<0,.6+.25,0>,2
					}
				}
				
				rotate x*10
				rotate y*360*.3
			}        
		
			object
			{
				saeule(250)
				rotate x*80
				translate z*1
				rotate y*360*.3
				translate y*-.65
			}
	        	rotate y*120
			translate -x*2
		}
	
		object
		{
			saeule(250)
			rotate x*5
			rotate y*360*0.75
			translate x*2
		}
		texture{stdtex}
	
		translate -z*7
		rotate -y*90
		light_group "!inside"
	}
	
	#local wS = seed(13438); // 213
	union
	{       
		#local i=1;
		#local imax = 10;
		#while(i<imax)
			union
			{
				object{saeule(40) rotate x*rand(wS)*15 rotate y*rand(wS)*360 translate  z*2}
				object{saeule(40) rotate x*rand(wS)*15 rotate y*rand(wS)*360 translate -z*2}
	
				rotate y*coswrot(i/imax,100,60)
				#local norm=<0,0,0>;
				#local pos=trace(sand_land,cosw(i/imax,150,95)+y*100,-y,norm);
				#if(pos.y>20)
					#local pos=trace(land,cosw(i/imax,157,95)+y*100,-y,norm);
				#end
				
				translate pos 
			}
		#local i=i+1;
		#end
		translate x*7
		texture{stdtex}
		light_group "!inside"
	}
	
	union
	{       
		#local i=1;
		#local imax = 10;
		#while(i<imax)
			union
			{
				object{saeule(30) rotate x*rand(wS)*15 rotate y*rand(wS)*360 translate  z*2}
				object{saeule(30) rotate x*rand(wS)*15 rotate y*rand(wS)*360 translate -z*2}
	
				rotate y*coswrot(i/imax,100,60)
				#local norm=<0,0,0>;
				#local pos=trace(sand_land,cosw(i/imax,150,95)+y*100+x*157+z*95,-y,norm);
	
				#if(pos.y>20)
	
					#local pos=trace(land,cosw(i/imax,150,95)+y*100,-y,norm);
				#end
				
				translate pos 
		
			}
		#local i=i+1;
		#end
		translate x*7
		texture{stdtex}
		light_group "!inside"
	}
	#end
#end



