/*                                     
           
    <------:::***************************:::------>
           [     S T O N E   C I R C L E   ]                 
    <------:::***************************:::------>                        
                
                by Edward Dixon

*/

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"             
#include "skies.inc"             
#include "face.inc"             
#include "grass.inc"             
#include "monster.inc"
#include "monk.inc"

#declare DO_FAST_RENDER = 0

#declare USE_OUTER_VIEW = 0
                        
                        
#if (USE_OUTER_VIEW = 0)

camera{
	location < 6, -1.5, -22 >
	look_at < 0.000, 9, 0.000 >
	angle 80.000
}

#else

camera{
	location < 10, 20, -30 >
	look_at < 0.000, 3, 0.000 >
	angle 120.000
	normal { ripples 0.1 }
}

#end



#version unofficial MegaPov 0.7;


fog
{                
        color White
        fog_type 2
        distance 3
        turbulence 0.5
        omega 0.25
        fog_offset -3
        fog_alt 1
}

light_source
{
        <0,5,0>
        color White
        spotlight
        radius 50
        falloff 50
        tightness 5
        point_at <0,0,0>
}


light_source
{
        <0,10,0>
        color Orange
        spotlight
        radius 50
        falloff 50
        tightness 5
        point_at <0,0,0>
}


global_settings{                                      
        post_process { focal_blur { 15, 15, 3, 0.5} }
        
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	motion_blur 5,0.0500
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	} 
	
}
                                                    
#declare fire =
material {
   texture {
      pigment { color rgb 0 transmit 1 }
      finish { ambient 0 diffuse 0 }
   }
   interior {                  
      media {
         emission 0.75    
         intervals 10
        density {
           spherical   
           turbulence 0.5
           density_map {
              [ 0.00 color rgb 0 ] 
              [ 0.20 color rgb <0.6,0.3,0.15> ]
              [ 0.40 color rgb <0.7,0.5,0.3> ]
              [ 0.70 color rgb <1.0,1.0,0.8> ] 
           }
        }
      }
   }
}                


#declare Catherine =
material {
   texture {
      pigment { color rgb 0 transmit 1 }
      finish { ambient 0 diffuse 0 }
   }
   interior {                  
      media {
         emission 0.5    
         intervals 10
         density {
           spherical
           turbulence 0.25
           density_map 
           {
             //   [ 0.0 color rgbt <0,0,0, 1> ]  
                [ 0.05 color rgbt <0.1,0.0,0.3, 0> ]                
                [ 0.5 color rgbt <0.1, 0.0, 0.8, 0.5> ]                
                [ 1 color rgbt <0.4, 0.0, 0.8, 1> ]                                
      }    }
      }
   }
}                


#declare funnel =
object
{
        difference
        {
                box
                {
                  <-0.5, 0, -0.5>
                  <0.5, 0.45, 0.5>
                }
                                 
                torus
                {
                  1, 0.99 
                  scale <0.5,0.75,0.5>
                }                                 
        }  
}



                                                   
#declare Stone =
object {
union{
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.758, 0.000, -1.162> <-0.749, 0.350, -1.098> <-0.353, 0.500, -0.910> <0.000, 0.500, -0.955> 
		<-0.758, 0.000, -1.162> <-0.746, 0.350, -1.445> <-0.350, 0.500, -1.241> <0.003, 0.500, -1.286> 
		<-0.758, 0.000, -1.162> <-0.746, 0.350, -1.445> <-0.336, 0.325, -1.559> <0.008, 0.325, -1.603> 
		<-0.758, 0.000, -1.162> <-0.755, 0.000, -1.509> <-0.344, 0.000, -1.618> <0.000, 0.000, -1.662> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.758, 0.000, -1.162> <-0.749, 0.350, -1.098> <-0.353, 0.500, -0.910> <0.000, 0.500, -0.955> 
		<-0.758, 0.000, -1.162> <-0.758, 0.350, -0.211> <-0.360, 0.500, -0.123> <-0.008, 0.500, -0.169> 
		<-0.758, 0.000, -1.162> <-0.758, 0.350, -0.211> <-0.492, 0.419, 1.179> <-0.015, 0.419, 1.118> 
		<-0.758, 0.000, -1.162> <-0.767, 0.000, -0.275> <-0.503, 0.000, 1.103> <-0.026, 0.000, 1.042> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, 0.500, -0.955> <0.345, 0.500, -0.999> <0.664, 0.342, -1.280> <0.655, 0.000, -1.342> 
		<0.000, 0.500, -0.955> <0.337, 0.500, -0.213> <0.655, 0.342, -0.333> <0.646, 0.000, -0.395> 
		<0.000, 0.500, -0.955> <0.337, 0.500, -0.213> <0.494, 0.419, 1.053> <0.483, 0.000, 0.977> 
		<0.000, 0.500, -0.955> <-0.008, 0.500, -0.169> <-0.015, 0.419, 1.118> <-0.026, 0.000, 1.042> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.000, 0.500, -0.955> <0.345, 0.500, -0.999> <0.664, 0.342, -1.280> <0.655, 0.000, -1.342> 
		<0.000, 0.500, -0.955> <0.348, 0.500, -1.330> <0.666, 0.342, -1.559> <0.658, 0.000, -1.621> 
		<0.000, 0.500, -0.955> <0.348, 0.500, -1.330> <0.284, 0.325, -1.638> <0.276, 0.000, -1.697> 
		<0.000, 0.500, -0.955> <0.003, 0.500, -1.286> <0.008, 0.325, -1.603> <0.000, 0.000, -1.662> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.655, 0.000, -1.342> <0.646, -0.327, -1.401> <0.304, -0.500, -1.178> <-0.026, -0.500, -1.136> 
		<0.655, 0.000, -1.342> <0.637, -0.327, -0.454> <0.296, -0.500, -0.324> <-0.034, -0.500, -0.282> 
		<0.655, 0.000, -1.342> <0.637, -0.327, -0.454> <0.472, -0.455, 0.895> <-0.038, -0.455, 0.960> 
		<0.655, 0.000, -1.342> <0.646, 0.000, -0.395> <0.483, 0.000, 0.977> <-0.026, 0.000, 1.042> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<0.655, 0.000, -1.342> <0.646, -0.327, -1.401> <0.304, -0.500, -1.178> <-0.026, -0.500, -1.136> 
		<0.655, 0.000, -1.342> <0.649, -0.327, -1.680> <0.306, -0.500, -1.455> <-0.023, -0.500, -1.413> 
		<0.655, 0.000, -1.342> <0.649, -0.327, -1.680> <0.269, -0.273, -1.746> <-0.007, -0.273, -1.711> 
		<0.655, 0.000, -1.342> <0.658, 0.000, -1.621> <0.276, 0.000, -1.697> <0.000, 0.000, -1.662> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.026, -0.500, -1.136> <-0.362, -0.500, -1.093> <-0.767, -0.333, -1.222> <-0.758, 0.000, -1.162> 
		<-0.026, -0.500, -1.136> <-0.359, -0.500, -1.370> <-0.763, -0.333, -1.569> <-0.755, 0.000, -1.509> 
		<-0.026, -0.500, -1.136> <-0.359, -0.500, -1.370> <-0.351, -0.273, -1.667> <-0.344, 0.000, -1.618> 
		<-0.026, -0.500, -1.136> <-0.023, -0.500, -1.413> <-0.007, -0.273, -1.711> <0.000, 0.000, -1.662> 
	}
	bezier_patch {
		4,4
		accuracy 0.01
		<-0.026, -0.500, -1.136> <-0.362, -0.500, -1.093> <-0.767, -0.333, -1.222> <-0.758, 0.000, -1.162> 
		<-0.026, -0.500, -1.136> <-0.370, -0.500, -0.239> <-0.775, -0.333, -0.335> <-0.767, 0.000, -0.275> 
		<-0.026, -0.500, -1.136> <-0.370, -0.500, -0.239> <-0.514, -0.455, 1.021> <-0.503, 0.000, 1.103> 
		<-0.026, -0.500, -1.136> <-0.034, -0.500, -0.282> <-0.038, -0.455, 0.960> <-0.026, 0.000, 1.042> 
	}

}
}

        
#declare ecount = 1
 
 
#while (ecount <= 12)
        
object {                     
        Stone                
        //rotate <0, ecount * 2, 0>         
        scale <3,4,8>
        translate <20,0,0>                        
        rotate <-90,ecount * 30,0>
      
      	//pigment { color White }
      	pigment
         {granite
          turbulence 0.0
          color_map
           {[0.0, 0.3 color White color DimGray]
            [0.3, 0.4 color DimGray color DimGray]
            [0.4, 0.6 color DimGray color DimGray]
            [0.6, 1.0 color DimGray color DimGray]
           }
         }
	//finish{phong 1}
}
                        
#declare ecount = ecount + 1                        
#end                       

/* 
sphere
{
        <0,0,0>,70
        texture { T_Grnt19a scale 30}
} 
*/


#if (DO_FAST_RENDER != 1)

sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.003 color rgb <0.0, 0.0, 0.0>
                     color rgb <0.1, 0.0, 0.0>]
        [0.003 0.250 color rgb <0.1, 0.0, 0.0>
                     color rgb <0.0, 0.35, 0.35>]
      }
      scale 2
      translate -1
    } 
    
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgbt <0.85, 0.85, 0.85, 0.8>
                   color rgbt <0.75, 0.75, 0.75, 0.9>]
          [0.1 0.5 color rgbt <0.75, 0.75, 0.75, 0.7>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      //scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }
 
height_field 
{
    png "terrain2.png"
    translate <-0.5, 1, -0.5>
    scale <50,4,50>   
    translate <0,-8.5,0>
    pigment 
         {
          bozo
          turbulence 1
          color_map
           {[0.0, 0.3 color Green color rgb<0,0.25,0>]
            [0.3, 0.4 color rgb<0,0.25,0> color rgb<0,0.5,0>]
            [0.4, 0.6 color rgb<0,0.5,0> color Green]
            [0.6, 1.0 color Green color rgb<0,0.75,0>]
           }    
           
           scale 10
        }
    smooth
}


sphere {
   <0,0,0>,8
   material { Catherine }
   hollow
}

sphere {
   <0,0,0>,3
   material { fire }
   hollow   
   scale 3
}

sphere {
   <0,1,-3>,2   
   material { fire }
   hollow   
   scale 3    
   rotate y*90
}

#end

/*
object
{
       Face                
       scale 10
       rotate <-5, 160, 0>      
       translate <0,10,50>      
       pigment {color rgbt<0.1, 0, 0.1, 0.995>  }  
       //texture { NBglass }
       //finish { metallic 0.5 }
}
*/

light_source
{
  <0,13,-10>
  color rgbt<0.2, 0, 0.8, 0.5>  
}


object
{
   monk                          
   scale <2,2,2>   
   rotate <0, -20, 0>
   translate <3,-2,-4>
   pigment { color Black }
}

object
{
   monk                          
   scale <2,2,2>   
   rotate <0, 90, 0>
   translate <-6,-2,-1>
   pigment { color Black }
}


object
{
   monk                          
   scale <2,2.5,2>   
   rotate <0, -90, 0>
   translate <7,-2,0>
   pigment { color Black }
}

object
{
   Grass
   pigment { color rgb<0.3,0,0> }
   scale <2,2,2>
   translate <20,-4,45>
}

object
{
   Grass
   pigment { color rgb<0.3,0,0> }
   scale <2,2,2>
   translate <-20,-4,45>
}

object
{
   Monster            
   scale 3             
   rotate <-60,60,-45>
   translate <0,13,20>
}

/*
object {
       funnel            
       hollow
       material { Catherine }
       translate <0, -0.25, 0>
       scale 40               
       rotate z*180
       translate <0, 5, 0>
} 
*/