#version unofficial MegaPOV 0.5;

#default{finish{ambient 0}}

global_settings{
  radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 35             // CHANGE range from 20 to 150

    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    normal 0
    media 1
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object

  } 
}

#include "colors.inc"
#include "groundtex.inc"


#declare camloc=vrotate(< 10, 2, 2 >,20*y);
#declare camloc=<10,2,10>;


#render concat("<",str(camloc.x,0,3),",",str(camloc.y,0,3),",",str(camloc.x,0,3),">")

#version unofficial MegaPOV 0.5;


background{color SkyBlue}


#default{pigment{rgb 1} finish{diffuse 1}}


//light_source{<100,200,-50> rgb 1}
light_source{
  <200,200,200> 
  rgb .25
  area_light <160,0,0>,<0,0,160>, 10,10
  adaptive 1 
  jitter
  orient
  circular
}
//light_source{<200,-20,50> rgb .25}


#include "bmpeople.inc"
#include "wizardarray.txt"

#declare Hair=off; // Warning : Turning hair on increase parsing time !    


#declare BM_EyeLids=<.35,0,.35>
#declare BM_Jaw=.25;
#declare BM_Mouth=1;
#declare BM_MouthShape=1;

#include "wizard.cdf" // Name of Costume Definition File eg. "sample.cdf"     



#declare BM_HairStyle=2*Hair;
#declare BM_PoseNo=0;
Blob_Man(Male,1.8)
#declare man=object {BlobMan 
        transform BMO_Abdomen_L
        scale <1,1,-1>
        //rotate 150*y
        rotate 210*y
        translate vrotate(7*x,0*y)
        translate .2*y
}

object{man}


#declare Lightning = on; //turn lightning on/off

#declare _C_ = .33;//.33;//clock;// //can be used for separate clock driven components, if any

#declare _LC_ = .44;//.21;//clock;// //lightning bolt display variable [.44 still frame]


#declare anglediff=<0,0,-10>;

#declare LightningScale=.5*<1,1,1>;

//#declare LightningTrans=<-.75,12.7-10*LightningScale.x,-.5>+<0,cos(radians(anglediff.x))*10*LightningScale.x,-sin(radians(anglediff.x))*10*LightningScale.x>;
//#declare LightningTrans=<-.75,0,-.5>+<0,cos(radians(anglediff.x))*10*LightningScale.x,-sin(radians(anglediff.x))*10*LightningScale.x>;
//cylinder{vrotate(LightningTrans,-90*z),vrotate(LightningTrans+LightningScale*x,-90*z),1}
#declare LightningTrans=<-1.3,-.2,-.5>+<sin(radians(anglediff.z)),cos(radians(anglediff.z))*cos(radians(anglediff.x)),-sin(radians(anglediff.x))>*(6.5)/LightningScale.x;


#declare LX = LightningTrans.x;
#declare LY = LightningTrans.y;
#declare LZ = LightningTrans.z;
#declare LightningSeed = 4184;
#declare LSegments = 80;
#declare NegativeXShift = .45;
#declare PositiveXShift = .45;
#declare NegativeZShift = .45;
#declare PositiveZShift = .45;
#declare LengthOne = .23;      
#declare LengthTwo = .3;     
#declare WidthOne = .31;      
#declare WidthTwo = .42;       
#declare BranchAmount = .35;  
#declare WildCard = .1;       
//#declare FlashScale = 1;  //size of ground-strike glow
#declare LightningFlash=off;
#declare LightningRotation = <0,0,-90>+anglediff;
#declare LT=.5;
#declare Lightning=on;
#declare LightningWidth=.05;     


#include "lightning.inc"
   //light_source { <LX, LY-LY/50, LZ> color rgb 1.5*(1.5-(LT*1.5)) fade_power 1 fade_distance 5}

 #declare cam_loc = vrotate(< 10, 2, 2 >,20*y);   // use the x, y, and z of your camera
 //#declare cam_loc = vrotate(< 10, 4, 2 >,20*y);   // use the x, y, and z of your camera
 #declare light_loc = <6.65,.7,-.3>; // use the x, y, and z of the light
                                                     // you wish to flare
 #declare lookat = .5*y;      // the look_at vector of your camera
 //#declare lookat = <6,.5,0>;      // the look_at vector of your camera
 #declare sky_vect = 1*y;      // the sky vector of your camera
 #declare bright_background=false;
 #declare flare_brightness=.5;
 #declare flare_size=.2
 #declare disc_size=vlength(cam_loc-light_loc);
 #include "sparkle4.flr"      // or whatever pre-defined flare you like
 #include "nkflare.inc"       // create the lens flare

 
#declare anglediff=anglediff-10*x;
#declare LightningTrans=<-1.3,-.2,-.5>+<sin(radians(anglediff.z)),cos(radians(anglediff.z))*cos(radians(anglediff.x)),-sin(radians(anglediff.x))>*(7)/LightningScale.x;

#declare LightningTrans=LightningTrans+<0,-.7,.25>/LightningScale.x;//+<-acos(anglediff.z)*10*LightningScale.x,,0,-asin(anglediff.z)*10*LightningScale.x>;
#declare LightningRotation = <0,0,-90>+anglediff;
#declare LightningSeed=0;


#declare LX = LightningTrans.x;
#declare LY = LightningTrans.y;
#declare LZ = LightningTrans.z;


#include "lightning.inc"

 #declare light_loc = light_loc+<-.55,0,.55>; // use the x, y, and z of the light
 #declare disc_size=vlength(cam_loc-light_loc)*.9;
#include "nkflare.inc"

#declare LightningPos=<6,1.3,0>;//+<0,cos(radians(anglediff.x)),-sin(radians(anglediff.x))>*(6.5)/LightningScale.x;

#declare i=0;
#declare i_max=3;
#declare lightseed=seed(1);

#while(i<=i_max)
  light_source{
    LightningPos+<-5,0,rand(lightseed)-0>*i/i_max
    rgb 1/i_max
    fade_power 1 
    fade_distance 2
  } 
  #declare i=i+1;
#end



/*light_source {
  <0,0,0>
  rgb 1 
  fade_power 1 
  fade_distance 1
  area_light <50,0,0>,<0,0,2>,2,2
  //translate <-2.5,0,-.5>
  //adaptive 0
  //jitter
  //scale -5*x
  rotate (180)*y
  //translate LightningPos-1.59*y
}*/





//#declare dragontex=pigment{color rgb <0,1,0>}     
#include "dragon.tmap.pov"
#include "eye_macro.inc"
#declare BM_EyeCol=<.22,.69,.42>; 


union{#include "dragon.inc"}

//eyes
sphere {0,1
  eye(1.5,BM_EyeCol,1,0,1,0) 
  rotate x*93
  rotate y*-60
  scale 0.06175
  translate <3.69748,2.97237,-1.49145>
}
sphere {0,1
  eye(1.5,BM_EyeCol,1,0,1,0) 
  rotate x*93
  rotate y*0
  scale 0.06175
  translate <3.46301,2.97237,-1.64245>
}




fog{
  fog_type 1
  fog_alt 35
  distance 250
  color rgb .1
}

#declare clouds=
pigment{
  bozo
  color_map{
    [0 rgb .25]
    [1 rgb 1]
  }            
  turbulence 1
  scale 25
}


//plane{y,-0.62 pigment{Grass}}
//plane{y,-0.5 texture{Fire_etc} no_shadow}
plane{y,25 texture{pigment{clouds} finish{diffuse 1}} hollow no_shadow double_illuminate}
plane{y,-.62
  texture{grasstex}
  texture{Fire_etc}
}
#include "grass.inc"

#include "house.inc"

#declare i=1;
#declare numsphere=80;
#declare r1=seed(10);

blob{
  threshold .25
#while(i<=numsphere)
  sphere{
    0,rand(r1)*12,1 
    scale <2,rand(r1)*.6,1> 
    translate <-200+5*rand(r1),-.62,-80+160*i/numsphere-5+10*rand(r1)>
  }
  sphere{
    0,rand(r1)*6,1 
    scale <2,rand(r1)*.6,1> 
    translate <-190+5*rand(r1),-.62,-80+160*i/numsphere-5+10*rand(r1)>
  }
  #declare i=i+1;
#end 
pigment{Grass}
}

object{
  house
  rotate -20*y
  translate <-70,-.62,40>
}


/*#declare houserow=
union{
    #while(Z_cnt<4)
      object{townhouse translate <-7*X_cnt,0,7*Z_cnt>}
      #declare Z_cnt=Z_cnt+1;
    #end 
}*/


union{
#declare X_cnt=0;
  #while(X_cnt<4)
    //object{houserow translate -7*X_cnt*x}
    #declare Z_cnt=0;
    #while(Z_cnt<4)
      object{townhouse translate <-7*X_cnt,0,7*Z_cnt>}
      #declare Z_cnt=Z_cnt+1;
    #end 
    #declare X_cnt=X_cnt+1;
  #end
  rotate -20*y
  translate <-130,-.62,-13>
}

#include "field.inc"

camera{ //camera for render
	location cam_loc
	right 2/3*x
	look_at <0,0,.5>
	angle 40
}

/*camera{ //camera for scene testing
  location <6,4,-10>
  //location <5,12,0>
	//location vrotate(< 10, 4, 2 >,20*y)
  right 4/3*x
  look_at  <6,.5,0>
  look_at (<3.46301,2.97237,-1.64245>+<3.46301,2.97237,-1.64245>)/2
  angle 7
}*/


/*camera{ //camera for scene testing
  location 100*y
  right 4/3*x
  look_at <-130,-.62,-7>+vrotate(<-17.5,0,17.5>,0*y)
  angle 20
}*/