// ======================================
// Example of use of the Makegrass macro
// Gilles Tran - March 1999
// --------------------------------------
// Long grass, yellowish
// --------------------------------------
#version unofficial MegaPOV 0.5;

#include "colors.inc"
#include "mgrass.pov"
#include "housetex.inc"

#declare PdV=<0,55,-80>;
#declare PdA=<0,12,10>;

#declare Blanc1=rgb<0.90,0.81,0.81>;

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}

#declare txtGrass=texture {                  

    pigment {
      bozo 
      color_map {
        [0 rgb <.52, .5, .2>] 
        [1 rgb <.9, .9, .1>]
      } 
      scale .01
    }
    finish{ambient 0.01 diffuse 1 specular 0.2 roughness 0.015}
    scale <0.001,1,0.001>
 
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=10;               // size of patch
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare nBlade=20;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 4;            // number of blade segments
#declare lBlade = 1;             // length of blade
#declare wBlade = .1;              // width of blade at start
#declare wBladeEnd = 0.1;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,.3,1>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,0,1>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 10;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 40;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale;
#declare stdBend = 2;            // standard deviation of blade bending;
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "thatch.inc"     // name of the mesh file to create

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
#if (dofile=true) // if the patch is already created, turn off the next line
        //MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end

#declare roofobj=
union{
  object{objectPatch translate lPatch/2*z}
  polygon{
    4,
    <-lPatch/2,0,0>,<-lPatch/2,0,lPatch>,<lPatch/2,0,lPatch>,<lPatch/2,0,0>  
  }
  texture{txtGrass}
}

/*#declare Plaster=
pigment{
  granite
  color_map{
    [0 rgb <1,1,1>]
    [0.8 rgb <1,1,.7>]
    [1 rgb <1,.8,.5>]
  }
  ramp_wave
  scale <2,4,2>
}*/

#declare post=box{<-.1,0,-.1>,<.2,1,.2>}

#declare p_length=array[5]{
10-lPatch*sin(radians(20)),
10-lPatch/2*sin(radians(20)),
10,
10-lPatch*sin(radians(20))*1/4,
10-lPatch*sin(radians(20))*3/4,
}

#declare section_width=lPatch*cos(radians(20))-.5;

#declare far_left_end=
  union{
    object{post scale <1,p_length[0],1> translate <lPatch/2,0,section_width>}
    object{post scale <1,p_length[4],1> translate <lPatch/2,0,section_width*3/4>}
    object{
      post 
      scale <1,vlength(<0,p_length[1],section_width/2>),1>
      rotate -degrees(atan2(section_width/2,p_length[1]))*x 
      translate <lPatch/2,0,section_width>
    }    
    object{post scale <1,p_length[1],1> translate <lPatch/2,0,section_width/2>}
    object{
      post 
      scale <1,vlength(<0,p_length[2],section_width/2>),1>
      rotate -degrees(atan2(section_width/2,p_length[2]))*x 
      translate <lPatch/2,0,section_width/2>
    }    
    object{post scale <1,p_length[3],1> translate <lPatch/2,0,section_width*1/4>}
    object{post scale <1,p_length[2],1> translate <lPatch/2,0,0>}
    object{post scale <1,section_width,1> rotate -90*x translate <lPatch/2,5,0>}
  }

  
#declare side_wall=
union{
    object{
      post 
      scale <1,vlength(<0,p_length[0],lPatch/3>),1>
      rotate -degrees(atan2(lPatch/3,p_length[0]))*z 
      translate <-lPatch/2,0,-section_width>
    }    
  object{post scale <1,p_length[0],1> translate <lPatch/2-lPatch/3,0,-section_width>}
    object{
      post 
      scale <1,vlength(<0,p_length[0],lPatch/3>),1>
      rotate -degrees(atan2(lPatch/3,p_length[0]))*z 
      translate <lPatch/2-lPatch/3,0,-section_width>
    }    
  object{post scale <1,p_length[0],1> translate <-lPatch/2+lPatch/3,0,-section_width>}
    object{
      post 
      scale <1,vlength(<0,p_length[0],lPatch/3>),1>
      rotate -degrees(atan2(lPatch/3,p_length[0]))*z 
      translate <-lPatch/2+lPatch/3,0,-section_width>
    }
}

#declare house=
union{
  //object{roofobj rotate <20,0,0> translate 10*y}
  //object{roofobj rotate <20,180,0> translate 10*y}
  intersection{
    box{<-lPatch/2,0,-lPatch*cos(radians(20))+.5>,<lPatch/2,10,lPatch*cos(radians(20))-.5>}
    plane{y,0 rotate <20,0,0> translate 9.99*y}
    plane{y,0 rotate <20,180,0> translate 9.99*y}
    texture{burningwall}
    hollow
  }
  sphere{0,12 scale <1,2.5,1>
    pigment{rgbt 1}
    interior{media{house_flame}}
    translate 5*y
    hollow
  }
  union{
    object{side_wall}
    object{side_wall translate section_width*2*z}
    object{far_left_end}
    object{far_left_end scale -1*z}
    object{far_left_end translate -lPatch*x}
    object{far_left_end scale -1*z translate -lPatch*x}
    pigment{ash}
  }
}

#declare townhouse=
union{
  object{roofobj rotate <20,0,0> translate 10*y}
  object{roofobj rotate <20,180,0> translate 10*y}
  intersection{
    box{<-lPatch/2,0,-lPatch*cos(radians(20))+.5>,<lPatch/2,10,lPatch*cos(radians(20))-.5>}
    plane{y,0 rotate <20,0,0> translate 9.99*y}
    plane{y,0 rotate <20,180,0> translate 9.99*y}
    texture{Plaster}
    hollow
  }
  union{
    object{side_wall}
    object{side_wall translate section_width*2*z}
    object{far_left_end}
    object{far_left_end scale -1*z}
    object{far_left_end translate -lPatch*x}
    object{far_left_end scale -1*z translate -lPatch*x}
    pigment{Tan*.5}
  }
  scale .25
}

//object{house rotate -40*y}

//plane{x,0 texture{burningwall}}

/*camera{
  location <40,15,0>
  look_at 7*y
  angle 40
}   

light_source{<100,100,0> rgb 1}*/
