

         #include "colors.inc"
       
       #include "textures.inc"
       
        #include "Stones.inc"     
       
// PoV file
// File: Nessie.pov
// Vers: 3.1
// Desc: Curious Nessie investigating a remote island....
// Date: 31/8/'01
// Auth: ~Steve~


//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 2
}

// ----------------------------------------     



camera
{
  location  <0.0, 0.2, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0, -.1,  0.0>
}






// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 10> <10, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <0, 0, 0>   // <x y z> position of light
}





               // create a point "spotlight" (cylindrical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  cylinder                // this variation
  translate <0, -80, 0>    // <x y z> position of light
  point_at <100, 0, 100>      // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 2            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 4               // intensity falloff radius (outer, in degrees)
}


   // create a sphere shape
sphere
{
  <0, -4, 1.25> // center of sphere <X Y Z>
  4       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling   
  
  
  
  
   scale <3, .00002, 3> 


#declare sea = pigment{
 average 
 pigment_map{
  
  [4 marble 
     color_map{
      [.5 Blue]
      [.5 Black]
      
     }
     scale .08
     rotate y*50] 
     
       [2 marble 
     color_map{
      [.2 White]
      [.5 Black]
      
     }
     scale .5
     rotate z*50]
 }     
}

    texture  {
  
  pigment  { colour White  }
  
  normal  {  bumps 50 scale .2 }
  
  finish  { phong .1}
  
  

 pigment{sea turbulence 4}
 finish{
  ambient .2
  
  reflection  .025
 }
}

    
     
     
     
  

   
   



      
      
      
      

 ///////////////////////////////////////////////////////////////////////////////////////////////////
 
 
 ///////////////////////////////////////////////////////////////////////////////////////////////////
 
 




   
  
  
  
  
  /////////////////////////////////////////////////////////////////////////////////////////////////
  
  
  /////////////////////////////////////////////////////////////////////////////////////////////////
  
  
  
  
  
   
  ////////////////////////////////////////////////////////////////////////////////////////////////
  
  
 ////////////////////////////////////////////////////////////////////////////////////////////////
 
   
// create a 3-D slice of a 4-D julia fractal object
 }

julia_fractal
{ 
  <.090,  .6, -0.003, -.005> 
  quaternion // hypercomplex?
  cube // TYPE: sqr cube 
  max_iteration 8 
  precision 20 // 10...500? FIXME
  //  slice xx?
 

 
 
 
   pigment{
   
  colour Black
   
   }
   
   }
 
 
// flat circular FINITE (no CSG) shape, center hole cutout is optional


disc
{
  <0, 3, 15>  // center position
  z,         // normal vector
  3.65,       // outer radius
  



   
  
  
  texture{
  
 T_Stone15
 
  scale 38
   
     }
     
      }
  

  
   // create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color White  // light's color
  translate <0, 3, 10>
}

  
  

// create a box that extends between the 2 specified points
box
{
  <-.2, -.2, -.5>  // one corner position <X1 Y1 Z1>
  < -.02,  1.8,  .4>  // other corner position <X2 Y2 Z2>






pigment{

colour Black

}

}

  
// create a box that extends between the 2 specified points
box
{
  < .1, -1, -.5>  // one corner position <X1 Y1 Z1>
  < -.1,  1.6,  .4>  // other corner position <X2 Y2 Z2>






pigment{

colour Black

}

} 

// create a box that extends between the 2 specified points
box
{
  <.14, -.5, -.5>  // one corner position <X1 Y1 Z1>
  < .04,  1.7,  .4>  // other corner position <X2 Y2 Z2>




pigment{

colour Black

}

}    



// create a box that extends between the 2 specified points
box
{
  <.26, -.5, -.5>  // one corner position <X1 Y1 Z1>
  < .16,  1.4,  .4>  // other corner position <X2 Y2 Z2>



pigment{

colour Black

}

}    


// create a box that extends between the 2 specified points
box
{
  <.2, -.5, -.5>  // one corner position <X1 Y1 Z1>
  < .1,  1.3,  .4>  // other corner position <X2 Y2 Z2>



pigment{

colour Black

}

}  





         // create a box that extends between the 2 specified points
box
{
  <-.15, 1.552, -.5>  // one corner position <X1 Y1 Z1>
  < -.11,  1.50,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <0.7, 0.7, 0> }
   
   
  }
   
   
            // create a box that extends between the 2 specified points
box
{
  <-.07, 1.41, -.5>  // one corner position <X1 Y1 Z1>
  < -.11,  1.36,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <0.7, 0.7, 0> }
   
   
  } 
  
  
              // create a box that extends between the 2 specified points
box
{
  <.22, 1.27, -.5>  // one corner position <X1 Y1 Z1>
  < .181,  1.32,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <0.7, 0.7, 0> }
   
   
  }
  
   // create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color White  // light's color
  translate <0, 3, 10>
  
  
}


 
 
 
             // create a box that extends between the 2 specified points


box

  {
  
  <-.17, 1.8, -.5>  // one corner position <X1 Y1 Z1>
  < -.14,  1.77,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  }
  
  
              // create a box that extends between the 2 specified points
box
{
  <-.117, 1.8, -.5>  // one corner position <X1 Y1 Z1>
  < -.087,  1.77,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  }   
  
  
  
    
              // create a box that extends between the 2 specified points
box
{
  <-.065, 1.8, -.5>  // one corner position <X1 Y1 Z1>
  < -.035,  1.77,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  } 
  
      
              // create a box that extends between the 2 specified points
box
{
  <.122, 1.7, -.5>  // one corner position <X1 Y1 Z1>
  < .10,  1.672,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  }
  
                // create a box that extends between the 2 specified points
box
{
  <.08, 1.7, -.5>  // one corner position <X1 Y1 Z1>
  < .055,  1.672,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  }
  
    
                // create a box that extends between the 2 specified points
box
{
  <.18, 1.4, -.5>  // one corner position <X1 Y1 Z1>
  < .2,  1.37,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  } 
  
  
      
                // create a box that extends between the 2 specified points
box
{
  <.22, 1.4, -.5>  // one corner position <X1 Y1 Z1>
  < .24,  1.37,  -.51>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour White
   
   }
   
   


   finish { ambient rgb <1, 1, 1> }
   
   
  }
  
  
              // create a box that extends between the 2 specified points
box
{
  <-.045, 1.38, -.7>  // one corner position <X1 Y1 Z1>
  < -.035,  2.01,  -.7>  // other corner position <X2 Y2 Z2>


   pigment{
   
   colour Black
   
   }
    
  }

   // triangular FINITE (no CSG) shape (vertices are endpoints)
triangle
{
  <-.05,  2.1, .1>  // <Vertex1>
  < .05,  2., -.3>  // <Vertex2>
  < -.04,  2.2,  .3>  // <Vertex3>



  pigment{
  
  colour  Black

    }
      
   
  }



#declare R1 = seed(200000);                 //Any number
#declare R2 = seed(5000);                    //Any number
#declare R3 = seed(1100);
#declare R4 = seed(2192);
#declare Dis = 100000;                       // Distance

#declare Count=0;
#while (Count < 60000)                       //Number of stars
  #declare colorr3 = rand(R3);
  #declare r4 = 1 - (rand(R4) / 4);
  #declare r5 = 1 - (rand(R4) / 4);
  #declare Xzang= rand(R1)*360;
  #declare Yang= (rand(R2)*180)-90;          // For space
//#declare Yang= rand(R2)*90                // For a starry night
  #declare Adis= (cos(radians(Yang)))*Dis;
  #declare Tmpy= (sin(radians(Yang)))*Dis;
  #declare Tmpx= (cos(radians(Xzang)))*Adis;
  #declare Tmpz= (sin(radians(Xzang)))*Adis;

  sphere
  {
    <0, 1, 0>
    0.5
    scale 150    // Scale to what ever you want
    translate < Tmpx, Tmpy, Tmpz>
    pigment
    {
      color <r4, 1, r5> * colorr3
    }
    finish
    {
      ambient 1
      diffuse 0.0
    }
  }

  #declare Count=Count+1;
#end  




   
     
     // create a sphere shape
sphere
{
  <.5, 2.1, 0> // center of sphere <X Y Z>
  0.085       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  Black
   
   }
   
   }  
   
        // create a sphere shape
sphere
{
  <.6, 2.05, 0> // center of sphere <X Y Z>
  0.085       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  Black
   
   }
   
   } 
   
   
        
     // create a sphere shape
sphere
{
  <.475, 2.06, -0.1> // center of sphere <X Y Z>
  0.09       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  White }
   
      finish { ambient rgb <1, 1, 1> }
   
   }
   
     
   
        // create a sphere shape
sphere
{
  <.6, 2.0, -0.1> // center of sphere <X Y Z>
  0.09       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  White  }
    
   
      finish { ambient rgb <1, 1, 1> }
   
   }
   
  //////////////////////////////////////////////////////////////////////////////////////////// 
      

   
        
      
     
     // create a sphere shape
sphere
{
  <.5, 1.8, 0> // center of sphere <X Y Z>
  0.085       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  Black
   
   }
   
   }  
   
        // create a sphere shape
sphere
{
  <.6, 1.78, 0> // center of sphere <X Y Z>
  0.085       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  Black
   
   }
   
   } 
   
   
        
     // create a sphere shape
sphere
{
  <.475, 1.76, -0.1> // center of sphere <X Y Z>
  0.09       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  White }
   
      finish { ambient rgb <1, 1, 1> }
   
   }
   
     
   
        // create a sphere shape
sphere
{
  <.6, 1.74, -0.1> // center of sphere <X Y Z>
  0.09       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling




   pigment{
   
   colour  White  }
    
   
      finish { ambient rgb <1, 1, 1> }
   
   }
        

   

// Created by 3D Canvas
 
background { color rgb <0.00E+00, 0.00E+00, 0.00E+00> }
 

 
global_settings {
  assumed_gamma 2.2
  ambient_light rgb <9.803922E-01, 9.803922E-01, 9.803922E-01>
}
 
light_source { <8.058666E+01, 9.48366E+03, -3.170756E+03>, rgb <5.960785E-01, 5.960785E-01, 5.960785E-01> shadowless media_interaction off  }
 
light_source { <-6.780764E+03, -6.709442E+03, -3.000772E+03>, rgb <5.960785E-01, 5.960785E-01, 5.960785E-01> shadowless media_interaction off  }
 
light_source { <4.187484E+00, 3.0425E+00, -2.501965E-02>, rgb <3.921569E-01, 3.921569E-01, 3.921569E-01> media_interaction on  media_attenuation on  }
 
#declare Tex0 =
texture {
   pigment {rgbf <0.00E+00, 0.00E+00, 0.00E+00, 0.00E+00>}
   finish {ambient 0.00E+00 diffuse .5 brilliance .5}
}
 
// Sphere
object {
union {
   smooth_triangle {
      <3.003195E-02, 4.769385E-02, -5.521307E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <3.569874E-02, 4.769385E-02, -5.550171E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.569874E-02, 4.769385E-02, -5.550171E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <2.779185E-02, 4.769385E-02, -5.570257E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.779185E-02, 4.769385E-02, -5.570257E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <7.514707E-03, 4.769385E-02, -5.578506E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.514707E-03, 4.769385E-02, -5.578506E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-2.204581E-02, 4.769385E-02, -5.573663E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.204581E-02, 4.769385E-02, -5.573663E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-5.638909E-02, 4.769385E-02, -5.556465E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.638909E-02, 4.769385E-02, -5.556465E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-9.02868E-02, 4.769385E-02, -5.529531E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-9.02868E-02, 4.769385E-02, -5.529531E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-1.185785E-01, 4.769385E-02, -5.496959E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.185785E-01, 4.769385E-02, -5.496959E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-1.369567E-01, 4.769385E-02, -5.463711E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.369567E-01, 4.769385E-02, -5.463711E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-1.426235E-01, 4.769382E-02, -5.434847E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.426235E-01, 4.769382E-02, -5.434847E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-1.347166E-01, 4.769385E-02, -5.414761E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.347166E-01, 4.769385E-02, -5.414761E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-1.144394E-01, 4.769385E-02, -5.406511E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.144394E-01, 4.769385E-02, -5.406511E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-8.487891E-02, 4.769385E-02, -5.411355E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.487891E-02, 4.769385E-02, -5.411355E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-5.053563E-02, 4.769385E-02, -5.428553E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.053563E-02, 4.769385E-02, -5.428553E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-1.663796E-02, 4.769385E-02, -5.455487E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.663796E-02, 4.769385E-02, -5.455487E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <1.165371E-02, 4.769385E-02, -5.488059E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.165371E-02, 4.769385E-02, -5.488059E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <3.003195E-02, 4.769385E-02, -5.521307E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      <-5.346237E-02, 5.946743E-02, -5.492509E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.003195E-02, 4.769385E-02, -5.521307E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <1.067618E-01, 1.332685E-02, -5.547771E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <1.176368E-01, 1.332685E-02, -5.603162E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.003195E-02, 4.769385E-02, -5.521307E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <1.176368E-01, 1.332685E-02, -5.603162E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <3.569874E-02, 4.769385E-02, -5.550171E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.569874E-02, 4.769385E-02, -5.550171E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <1.176368E-01, 1.332685E-02, -5.603162E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <1.024634E-01, 1.332685E-02, -5.641706E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.569874E-02, 4.769385E-02, -5.550171E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <1.024634E-01, 1.332685E-02, -5.641706E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <2.779185E-02, 4.769385E-02, -5.570257E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.779185E-02, 4.769385E-02, -5.570257E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <1.024634E-01, 1.332685E-02, -5.641706E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <6.355162E-02, 1.332685E-02, -5.657537E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.779185E-02, 4.769385E-02, -5.570257E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <6.355162E-02, 1.332685E-02, -5.657537E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <7.514707E-03, 4.769385E-02, -5.578506E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.514707E-03, 4.769385E-02, -5.578506E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <6.355162E-02, 1.332685E-02, -5.657537E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <6.825636E-03, 1.332685E-02, -5.648243E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.514707E-03, 4.769385E-02, -5.578506E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <6.825636E-03, 1.332685E-02, -5.648243E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-2.204581E-02, 4.769385E-02, -5.573663E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.204581E-02, 4.769385E-02, -5.573663E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <6.825636E-03, 1.332685E-02, -5.648243E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-5.907876E-02, 1.332685E-02, -5.61524E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.204581E-02, 4.769385E-02, -5.573663E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-5.907876E-02, 1.332685E-02, -5.61524E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-5.638909E-02, 4.769385E-02, -5.556465E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.638909E-02, 4.769385E-02, -5.556465E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-5.907876E-02, 1.332685E-02, -5.61524E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-1.241279E-01, 1.332685E-02, -5.563553E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.638909E-02, 4.769385E-02, -5.556465E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-1.241279E-01, 1.332685E-02, -5.563553E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-9.02868E-02, 4.769385E-02, -5.529531E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-9.02868E-02, 4.769385E-02, -5.529531E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-1.241279E-01, 1.332685E-02, -5.563553E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-1.78419E-01, 1.332685E-02, -5.50105E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-9.02868E-02, 4.769385E-02, -5.529531E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-1.78419E-01, 1.332685E-02, -5.50105E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-1.185785E-01, 4.769385E-02, -5.496959E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.185785E-01, 4.769385E-02, -5.496959E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-1.78419E-01, 1.332685E-02, -5.50105E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-2.136866E-01, 1.332685E-02, -5.437246E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.185785E-01, 4.769385E-02, -5.496959E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-2.136866E-01, 1.332685E-02, -5.437246E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-1.369567E-01, 4.769385E-02, -5.463711E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.369567E-01, 4.769385E-02, -5.463711E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-2.136866E-01, 1.332685E-02, -5.437246E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-2.245615E-01, 1.332687E-02, -5.381856E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.369567E-01, 4.769385E-02, -5.463711E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-2.245615E-01, 1.332687E-02, -5.381856E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-1.426235E-01, 4.769382E-02, -5.434847E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.426235E-01, 4.769382E-02, -5.434847E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-2.245615E-01, 1.332687E-02, -5.381856E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-2.093881E-01, 1.332685E-02, -5.343311E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.426235E-01, 4.769382E-02, -5.434847E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-2.093881E-01, 1.332685E-02, -5.343311E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-1.347166E-01, 4.769385E-02, -5.414761E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.347166E-01, 4.769385E-02, -5.414761E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-2.093881E-01, 1.332685E-02, -5.343311E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-1.704764E-01, 1.332685E-02, -5.327481E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.347166E-01, 4.769385E-02, -5.414761E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-1.704764E-01, 1.332685E-02, -5.327481E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-1.144394E-01, 4.769385E-02, -5.406511E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.144394E-01, 4.769385E-02, -5.406511E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-1.704764E-01, 1.332685E-02, -5.327481E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-1.137503E-01, 1.332685E-02, -5.336774E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.144394E-01, 4.769385E-02, -5.406511E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-1.137503E-01, 1.332685E-02, -5.336774E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-8.487891E-02, 4.769385E-02, -5.411355E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.487891E-02, 4.769385E-02, -5.411355E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-1.137503E-01, 1.332685E-02, -5.336774E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-4.784594E-02, 1.332685E-02, -5.369778E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.487891E-02, 4.769385E-02, -5.411355E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-4.784594E-02, 1.332685E-02, -5.369778E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-5.053563E-02, 4.769385E-02, -5.428553E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.053563E-02, 4.769385E-02, -5.428553E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-4.784594E-02, 1.332685E-02, -5.369778E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <1.720315E-02, 1.332685E-02, -5.421464E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.053563E-02, 4.769385E-02, -5.428553E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <1.720315E-02, 1.332685E-02, -5.421464E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-1.663796E-02, 4.769385E-02, -5.455487E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.663796E-02, 4.769385E-02, -5.455487E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <1.720315E-02, 1.332685E-02, -5.421464E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <7.149435E-02, 1.332685E-02, -5.483968E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.663796E-02, 4.769385E-02, -5.455487E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <7.149435E-02, 1.332685E-02, -5.483968E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <1.165371E-02, 4.769385E-02, -5.488059E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.165371E-02, 4.769385E-02, -5.488059E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <7.149435E-02, 1.332685E-02, -5.483968E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <1.067618E-01, 1.332685E-02, -5.547771E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.165371E-02, 4.769385E-02, -5.488059E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <1.067618E-01, 1.332685E-02, -5.547771E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <3.003195E-02, 4.769385E-02, -5.521307E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.067618E-01, 1.332685E-02, -5.547771E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <1.705114E-01, -4.084925E-02, -5.569759E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <1.857133E-01, -4.084925E-02, -5.647188E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.067618E-01, 1.332685E-02, -5.547771E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <1.857133E-01, -4.084925E-02, -5.647188E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <1.176368E-01, 1.332685E-02, -5.603162E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.176368E-01, 1.332685E-02, -5.603162E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <1.857133E-01, -4.084925E-02, -5.647188E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <1.645027E-01, -4.084925E-02, -5.701069E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.176368E-01, 1.332685E-02, -5.603162E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <1.645027E-01, -4.084925E-02, -5.701069E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <1.024634E-01, 1.332685E-02, -5.641706E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.024634E-01, 1.332685E-02, -5.641706E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <1.645027E-01, -4.084925E-02, -5.701069E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <1.101089E-01, -4.084925E-02, -5.723197E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.024634E-01, 1.332685E-02, -5.641706E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <1.101089E-01, -4.084925E-02, -5.723197E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <6.355162E-02, 1.332685E-02, -5.657537E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.355162E-02, 1.332685E-02, -5.657537E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <1.101089E-01, -4.084925E-02, -5.723197E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <3.081287E-02, -4.084925E-02, -5.710207E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.355162E-02, 1.332685E-02, -5.657537E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <3.081287E-02, -4.084925E-02, -5.710207E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <6.825636E-03, 1.332685E-02, -5.648243E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.825636E-03, 1.332685E-02, -5.648243E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <3.081287E-02, -4.084925E-02, -5.710207E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-6.131329E-02, -4.084925E-02, -5.664073E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.825636E-03, 1.332685E-02, -5.648243E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-6.131329E-02, -4.084925E-02, -5.664073E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-5.907876E-02, 1.332685E-02, -5.61524E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.907876E-02, 1.332685E-02, -5.61524E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-6.131329E-02, -4.084925E-02, -5.664073E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-1.522443E-01, -4.084925E-02, -5.59182E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.907876E-02, 1.332685E-02, -5.61524E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-1.522443E-01, -4.084925E-02, -5.59182E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-1.241279E-01, 1.332685E-02, -5.563553E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.241279E-01, 1.332685E-02, -5.563553E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-1.522443E-01, -4.084925E-02, -5.59182E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-2.281364E-01, -4.084925E-02, -5.504448E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.241279E-01, 1.332685E-02, -5.563553E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-2.281364E-01, -4.084925E-02, -5.504448E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-1.78419E-01, 1.332685E-02, -5.50105E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.78419E-01, 1.332685E-02, -5.50105E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-2.281364E-01, -4.084925E-02, -5.504448E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-2.774362E-01, -4.084925E-02, -5.415258E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.78419E-01, 1.332685E-02, -5.50105E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-2.774362E-01, -4.084925E-02, -5.415258E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-2.136866E-01, 1.332685E-02, -5.437246E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.136866E-01, 1.332685E-02, -5.437246E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-2.774362E-01, -4.084925E-02, -5.415258E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-2.92638E-01, -4.084925E-02, -5.33783E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.136866E-01, 1.332685E-02, -5.437246E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-2.92638E-01, -4.084925E-02, -5.33783E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-2.245615E-01, 1.332687E-02, -5.381856E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.245615E-01, 1.332687E-02, -5.381856E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-2.92638E-01, -4.084925E-02, -5.33783E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-2.714274E-01, -4.084925E-02, -5.283949E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.245615E-01, 1.332687E-02, -5.381856E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-2.714274E-01, -4.084925E-02, -5.283949E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-2.093881E-01, 1.332685E-02, -5.343311E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.093881E-01, 1.332685E-02, -5.343311E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-2.714274E-01, -4.084925E-02, -5.283949E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-2.170335E-01, -4.084925E-02, -5.261821E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.093881E-01, 1.332685E-02, -5.343311E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-2.170335E-01, -4.084925E-02, -5.261821E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      <-1.704764E-01, 1.332685E-02, -5.327481E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.704764E-01, 1.332685E-02, -5.327481E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-2.170335E-01, -4.084925E-02, -5.261821E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      <-1.377376E-01, -4.084925E-02, -5.274811E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.704764E-01, 1.332685E-02, -5.327481E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-1.377376E-01, -4.084925E-02, -5.274811E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-1.137503E-01, 1.332685E-02, -5.336774E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.137503E-01, 1.332685E-02, -5.336774E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-1.377376E-01, -4.084925E-02, -5.274811E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-4.561136E-02, -4.084925E-02, -5.320945E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.137503E-01, 1.332685E-02, -5.336774E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-4.561136E-02, -4.084925E-02, -5.320945E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-4.784594E-02, 1.332685E-02, -5.369778E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.784594E-02, 1.332685E-02, -5.369778E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-4.561136E-02, -4.084925E-02, -5.320945E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <4.531952E-02, -4.084925E-02, -5.393198E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.784594E-02, 1.332685E-02, -5.369778E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <4.531952E-02, -4.084925E-02, -5.393198E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <1.720315E-02, 1.332685E-02, -5.421464E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.720315E-02, 1.332685E-02, -5.421464E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <4.531952E-02, -4.084925E-02, -5.393198E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <1.212116E-01, -4.084925E-02, -5.480569E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.720315E-02, 1.332685E-02, -5.421464E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <1.212116E-01, -4.084925E-02, -5.480569E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <7.149435E-02, 1.332685E-02, -5.483968E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.149435E-02, 1.332685E-02, -5.483968E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <1.212116E-01, -4.084925E-02, -5.480569E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <1.705114E-01, -4.084925E-02, -5.569759E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.149435E-02, 1.332685E-02, -5.483968E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <1.705114E-01, -4.084925E-02, -5.569759E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <1.067618E-01, 1.332685E-02, -5.547771E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.705114E-01, -4.084925E-02, -5.569759E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <2.161159E-01, -1.104455E-01, -5.585488E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <2.34413E-01, -1.104455E-01, -5.678683E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.705114E-01, -4.084925E-02, -5.569759E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <2.34413E-01, -1.104455E-01, -5.678683E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <1.857133E-01, -4.084925E-02, -5.647188E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.857133E-01, -4.084925E-02, -5.647188E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <2.34413E-01, -1.104455E-01, -5.678683E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <2.088837E-01, -1.104455E-01, -5.743535E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.857133E-01, -4.084925E-02, -5.647188E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <2.088837E-01, -1.104455E-01, -5.743535E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <1.645027E-01, -4.084925E-02, -5.701069E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.645027E-01, -4.084925E-02, -5.701069E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <2.088837E-01, -1.104455E-01, -5.743535E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <1.434145E-01, -1.104455E-01, -5.770169E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.645027E-01, -4.084925E-02, -5.701069E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <1.434145E-01, -1.104455E-01, -5.770169E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <1.101089E-01, -4.084925E-02, -5.723197E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.101089E-01, -4.084925E-02, -5.723197E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <1.434145E-01, -1.104455E-01, -5.770169E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <4.797262E-02, -1.104455E-01, -5.754533E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.101089E-01, -4.084925E-02, -5.723197E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <4.797262E-02, -1.104455E-01, -5.754533E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <3.081287E-02, -4.084925E-02, -5.710207E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.081287E-02, -4.084925E-02, -5.710207E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <4.797262E-02, -1.104455E-01, -5.754533E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-6.291191E-02, -1.104455E-01, -5.699006E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.081287E-02, -4.084925E-02, -5.710207E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-6.291191E-02, -1.104455E-01, -5.699006E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-6.131329E-02, -4.084925E-02, -5.664073E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.131329E-02, -4.084925E-02, -5.664073E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-6.291191E-02, -1.104455E-01, -5.699006E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-1.723578E-01, -1.104455E-01, -5.612041E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.131329E-02, -4.084925E-02, -5.664073E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-1.723578E-01, -1.104455E-01, -5.612041E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-1.522443E-01, -4.084925E-02, -5.59182E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.522443E-01, -4.084925E-02, -5.59182E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-1.723578E-01, -1.104455E-01, -5.612041E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-2.637028E-01, -1.104455E-01, -5.506879E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.522443E-01, -4.084925E-02, -5.59182E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-2.637028E-01, -1.104455E-01, -5.506879E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-2.281364E-01, -4.084925E-02, -5.504448E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.281364E-01, -4.084925E-02, -5.504448E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-2.637028E-01, -1.104455E-01, -5.506879E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-3.230407E-01, -1.104455E-01, -5.399529E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.281364E-01, -4.084925E-02, -5.504448E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-3.230407E-01, -1.104455E-01, -5.399529E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-2.774362E-01, -4.084925E-02, -5.415258E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.774362E-01, -4.084925E-02, -5.415258E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-3.230407E-01, -1.104455E-01, -5.399529E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-3.41338E-01, -1.104455E-01, -5.306334E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.774362E-01, -4.084925E-02, -5.415258E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-3.41338E-01, -1.104455E-01, -5.306334E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-2.92638E-01, -4.084925E-02, -5.33783E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.92638E-01, -4.084925E-02, -5.33783E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-3.41338E-01, -1.104455E-01, -5.306334E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-3.158084E-01, -1.104455E-01, -5.241483E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.92638E-01, -4.084925E-02, -5.33783E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-3.158084E-01, -1.104455E-01, -5.241483E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-2.714274E-01, -4.084925E-02, -5.283949E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.714274E-01, -4.084925E-02, -5.283949E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-3.158084E-01, -1.104455E-01, -5.241483E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-2.503392E-01, -1.104455E-01, -5.214849E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.714274E-01, -4.084925E-02, -5.283949E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-2.503392E-01, -1.104455E-01, -5.214849E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-2.170335E-01, -4.084925E-02, -5.261821E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.170335E-01, -4.084925E-02, -5.261821E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01> 
      <-2.503392E-01, -1.104455E-01, -5.214849E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-1.548972E-01, -1.104455E-01, -5.230485E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.170335E-01, -4.084925E-02, -5.261821E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01> 
      <-1.548972E-01, -1.104455E-01, -5.230485E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-1.377376E-01, -4.084925E-02, -5.274811E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.377376E-01, -4.084925E-02, -5.274811E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-1.548972E-01, -1.104455E-01, -5.230485E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-4.401275E-02, -1.104455E-01, -5.286012E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.377376E-01, -4.084925E-02, -5.274811E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-4.401275E-02, -1.104455E-01, -5.286012E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-4.561136E-02, -4.084925E-02, -5.320945E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.561136E-02, -4.084925E-02, -5.320945E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-4.401275E-02, -1.104455E-01, -5.286012E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <6.543301E-02, -1.104455E-01, -5.372977E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.561136E-02, -4.084925E-02, -5.320945E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <6.543301E-02, -1.104455E-01, -5.372977E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <4.531952E-02, -4.084925E-02, -5.393198E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.531952E-02, -4.084925E-02, -5.393198E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <6.543301E-02, -1.104455E-01, -5.372977E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <1.567782E-01, -1.104455E-01, -5.478139E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.531952E-02, -4.084925E-02, -5.393198E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <1.567782E-01, -1.104455E-01, -5.478139E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <1.212116E-01, -4.084925E-02, -5.480569E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.212116E-01, -4.084925E-02, -5.480569E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <1.567782E-01, -1.104455E-01, -5.478139E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <2.161159E-01, -1.104455E-01, -5.585488E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.212116E-01, -4.084925E-02, -5.480569E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <2.161159E-01, -1.104455E-01, -5.585488E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <1.705114E-01, -4.084925E-02, -5.569759E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.161159E-01, -1.104455E-01, -5.585488E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <2.398809E-01, -1.898236E-01, -5.593686E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <2.59791E-01, -1.898236E-01, -5.695096E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.161159E-01, -1.104455E-01, -5.585488E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <2.59791E-01, -1.898236E-01, -5.695096E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <2.34413E-01, -1.104455E-01, -5.678683E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.34413E-01, -1.104455E-01, -5.678683E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <2.59791E-01, -1.898236E-01, -5.695096E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <2.320111E-01, -1.898236E-01, -5.765664E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.34413E-01, -1.104455E-01, -5.678683E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <2.320111E-01, -1.898236E-01, -5.765664E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <2.088837E-01, -1.104455E-01, -5.743535E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.088837E-01, -1.104455E-01, -5.743535E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <2.320111E-01, -1.898236E-01, -5.765664E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <1.607703E-01, -1.898236E-01, -5.794647E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.088837E-01, -1.104455E-01, -5.743535E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <1.607703E-01, -1.898236E-01, -5.794647E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <1.434145E-01, -1.104455E-01, -5.770169E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.434145E-01, -1.104455E-01, -5.770169E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <1.607703E-01, -1.898236E-01, -5.794647E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <5.691462E-02, -1.898236E-01, -5.777632E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.434145E-01, -1.104455E-01, -5.770169E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <5.691462E-02, -1.898236E-01, -5.777632E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <4.797262E-02, -1.104455E-01, -5.754533E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.797262E-02, -1.104455E-01, -5.754533E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <5.691462E-02, -1.898236E-01, -5.777632E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-6.374492E-02, -1.898236E-01, -5.71721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.797262E-02, -1.104455E-01, -5.754533E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-6.374492E-02, -1.898236E-01, -5.71721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-6.291191E-02, -1.104455E-01, -5.699006E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.291191E-02, -1.104455E-01, -5.699006E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-6.374492E-02, -1.898236E-01, -5.71721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-1.82839E-01, -1.898236E-01, -5.622579E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.291191E-02, -1.104455E-01, -5.699006E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-1.82839E-01, -1.898236E-01, -5.622579E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-1.723578E-01, -1.104455E-01, -5.612041E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.723578E-01, -1.104455E-01, -5.612041E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-1.82839E-01, -1.898236E-01, -5.622579E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-2.822367E-01, -1.898236E-01, -5.508146E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.723578E-01, -1.104455E-01, -5.612041E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-2.822367E-01, -1.898236E-01, -5.508146E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-2.637028E-01, -1.104455E-01, -5.506879E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.637028E-01, -1.104455E-01, -5.506879E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-2.822367E-01, -1.898236E-01, -5.508146E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-3.468057E-01, -1.898236E-01, -5.391332E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.637028E-01, -1.104455E-01, -5.506879E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-3.468057E-01, -1.898236E-01, -5.391332E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-3.230407E-01, -1.104455E-01, -5.399529E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.230407E-01, -1.104455E-01, -5.399529E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-3.468057E-01, -1.898236E-01, -5.391332E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-3.667158E-01, -1.898236E-01, -5.289922E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.230407E-01, -1.104455E-01, -5.399529E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-3.667158E-01, -1.898236E-01, -5.289922E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-3.41338E-01, -1.104455E-01, -5.306334E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.41338E-01, -1.104455E-01, -5.306334E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-3.667158E-01, -1.898236E-01, -5.289922E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-3.389358E-01, -1.898236E-01, -5.219354E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.41338E-01, -1.104455E-01, -5.306334E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-3.389358E-01, -1.898236E-01, -5.219354E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-3.158084E-01, -1.104455E-01, -5.241483E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.158084E-01, -1.104455E-01, -5.241483E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-3.389358E-01, -1.898236E-01, -5.219354E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-2.676951E-01, -1.898236E-01, -5.190371E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.158084E-01, -1.104455E-01, -5.241483E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-2.676951E-01, -1.898236E-01, -5.190371E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-2.503392E-01, -1.104455E-01, -5.214849E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.503392E-01, -1.104455E-01, -5.214849E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-2.676951E-01, -1.898236E-01, -5.190371E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-1.638393E-01, -1.898236E-01, -5.207386E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.503392E-01, -1.104455E-01, -5.214849E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-1.638393E-01, -1.898236E-01, -5.207386E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-1.548972E-01, -1.104455E-01, -5.230485E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.548972E-01, -1.104455E-01, -5.230485E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-1.638393E-01, -1.898236E-01, -5.207386E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-4.317965E-02, -1.898236E-01, -5.267808E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.548972E-01, -1.104455E-01, -5.230485E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-4.317965E-02, -1.898236E-01, -5.267808E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-4.401275E-02, -1.104455E-01, -5.286012E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.401275E-02, -1.104455E-01, -5.286012E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-4.317965E-02, -1.898236E-01, -5.267808E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <7.59144E-02, -1.898236E-01, -5.362439E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.401275E-02, -1.104455E-01, -5.286012E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <7.59144E-02, -1.898236E-01, -5.362439E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <6.543301E-02, -1.104455E-01, -5.372977E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.543301E-02, -1.104455E-01, -5.372977E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <7.59144E-02, -1.898236E-01, -5.362439E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <1.753121E-01, -1.898236E-01, -5.476872E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.543301E-02, -1.104455E-01, -5.372977E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <1.753121E-01, -1.898236E-01, -5.476872E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <1.567782E-01, -1.104455E-01, -5.478139E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.567782E-01, -1.104455E-01, -5.478139E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <1.753121E-01, -1.898236E-01, -5.476872E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <2.398809E-01, -1.898236E-01, -5.593686E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.567782E-01, -1.104455E-01, -5.478139E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <2.398809E-01, -1.898236E-01, -5.593686E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <2.161159E-01, -1.104455E-01, -5.585488E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.398809E-01, -1.898236E-01, -5.593686E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <2.398809E-01, -2.725529E-01, -5.593686E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      <2.59791E-01, -2.725529E-01, -5.695096E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.398809E-01, -1.898236E-01, -5.593686E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <2.59791E-01, -2.725529E-01, -5.695096E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <2.59791E-01, -1.898236E-01, -5.695096E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.59791E-01, -1.898236E-01, -5.695096E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <2.59791E-01, -2.725529E-01, -5.695096E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <2.320111E-01, -2.725529E-01, -5.765664E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.59791E-01, -1.898236E-01, -5.695096E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <2.320111E-01, -2.725529E-01, -5.765664E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <2.320111E-01, -1.898236E-01, -5.765664E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.320111E-01, -1.898236E-01, -5.765664E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <2.320111E-01, -2.725529E-01, -5.765664E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <1.607703E-01, -2.725529E-01, -5.794647E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.320111E-01, -1.898236E-01, -5.765664E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <1.607703E-01, -2.725529E-01, -5.794647E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <1.607703E-01, -1.898236E-01, -5.794647E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.607703E-01, -1.898236E-01, -5.794647E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <1.607703E-01, -2.725529E-01, -5.794647E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <5.691462E-02, -2.725529E-01, -5.777632E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.607703E-01, -1.898236E-01, -5.794647E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <5.691462E-02, -2.725529E-01, -5.777632E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <5.691462E-02, -1.898236E-01, -5.777632E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.691462E-02, -1.898236E-01, -5.777632E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <5.691462E-02, -2.725529E-01, -5.777632E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-6.37449E-02, -2.725529E-01, -5.71721E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.691462E-02, -1.898236E-01, -5.777632E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-6.37449E-02, -2.725529E-01, -5.71721E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      <-6.374492E-02, -1.898236E-01, -5.71721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.374492E-02, -1.898236E-01, -5.71721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-6.37449E-02, -2.725529E-01, -5.71721E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      <-1.82839E-01, -2.725529E-01, -5.622579E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.374492E-02, -1.898236E-01, -5.71721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-1.82839E-01, -2.725529E-01, -5.622579E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-1.82839E-01, -1.898236E-01, -5.622579E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.82839E-01, -1.898236E-01, -5.622579E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-1.82839E-01, -2.725529E-01, -5.622579E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-2.822367E-01, -2.725529E-01, -5.508146E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.82839E-01, -1.898236E-01, -5.622579E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-2.822367E-01, -2.725529E-01, -5.508146E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-2.822367E-01, -1.898236E-01, -5.508146E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.822367E-01, -1.898236E-01, -5.508146E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-2.822367E-01, -2.725529E-01, -5.508146E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-3.468057E-01, -2.725529E-01, -5.391332E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.822367E-01, -1.898236E-01, -5.508146E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-3.468057E-01, -2.725529E-01, -5.391332E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-3.468057E-01, -1.898236E-01, -5.391332E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.468057E-01, -1.898236E-01, -5.391332E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-3.468057E-01, -2.725529E-01, -5.391332E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-3.667158E-01, -2.725529E-01, -5.289922E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.468057E-01, -1.898236E-01, -5.391332E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-3.667158E-01, -2.725529E-01, -5.289922E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-3.667158E-01, -1.898236E-01, -5.289922E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.667158E-01, -1.898236E-01, -5.289922E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-3.667158E-01, -2.725529E-01, -5.289922E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-3.389358E-01, -2.725529E-01, -5.219354E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.667158E-01, -1.898236E-01, -5.289922E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-3.389358E-01, -2.725529E-01, -5.219354E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-3.389358E-01, -1.898236E-01, -5.219354E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.389358E-01, -1.898236E-01, -5.219354E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-3.389358E-01, -2.725529E-01, -5.219354E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-2.676951E-01, -2.725529E-01, -5.190371E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.389358E-01, -1.898236E-01, -5.219354E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-2.676951E-01, -2.725529E-01, -5.190371E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-2.676951E-01, -1.898236E-01, -5.190371E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.676951E-01, -1.898236E-01, -5.190371E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-2.676951E-01, -2.725529E-01, -5.190371E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-1.638393E-01, -2.725529E-01, -5.207386E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.676951E-01, -1.898236E-01, -5.190371E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-1.638393E-01, -2.725529E-01, -5.207386E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-1.638393E-01, -1.898236E-01, -5.207386E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.638393E-01, -1.898236E-01, -5.207386E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-1.638393E-01, -2.725529E-01, -5.207386E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-4.317965E-02, -2.725529E-01, -5.267808E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.638393E-01, -1.898236E-01, -5.207386E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-4.317965E-02, -2.725529E-01, -5.267808E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-4.317965E-02, -1.898236E-01, -5.267808E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.317965E-02, -1.898236E-01, -5.267808E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-4.317965E-02, -2.725529E-01, -5.267808E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <7.59144E-02, -2.725529E-01, -5.362439E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.317965E-02, -1.898236E-01, -5.267808E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <7.59144E-02, -2.725529E-01, -5.362439E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <7.59144E-02, -1.898236E-01, -5.362439E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.59144E-02, -1.898236E-01, -5.362439E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <7.59144E-02, -2.725529E-01, -5.362439E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <1.753121E-01, -2.725529E-01, -5.476872E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.59144E-02, -1.898236E-01, -5.362439E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <1.753121E-01, -2.725529E-01, -5.476872E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <1.753121E-01, -1.898236E-01, -5.476872E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.753121E-01, -1.898236E-01, -5.476872E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <1.753121E-01, -2.725529E-01, -5.476872E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <2.398809E-01, -2.725529E-01, -5.593686E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.753121E-01, -1.898236E-01, -5.476872E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <2.398809E-01, -2.725529E-01, -5.593686E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      <2.398809E-01, -1.898236E-01, -5.593686E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.398809E-01, -2.725529E-01, -5.593686E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02> 
      <2.161159E-01, -3.51931E-01, -5.585488E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <2.34413E-01, -3.51931E-01, -5.678683E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.398809E-01, -2.725529E-01, -5.593686E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02> 
      <2.34413E-01, -3.51931E-01, -5.678683E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <2.59791E-01, -2.725529E-01, -5.695096E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.59791E-01, -2.725529E-01, -5.695096E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <2.34413E-01, -3.51931E-01, -5.678683E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <2.088837E-01, -3.51931E-01, -5.743535E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.59791E-01, -2.725529E-01, -5.695096E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <2.088837E-01, -3.51931E-01, -5.743535E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <2.320111E-01, -2.725529E-01, -5.765664E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.320111E-01, -2.725529E-01, -5.765664E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <2.088837E-01, -3.51931E-01, -5.743535E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <1.434145E-01, -3.51931E-01, -5.770169E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.320111E-01, -2.725529E-01, -5.765664E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <1.434145E-01, -3.51931E-01, -5.770169E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      <1.607703E-01, -2.725529E-01, -5.794647E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.607703E-01, -2.725529E-01, -5.794647E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <1.434145E-01, -3.51931E-01, -5.770169E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      <4.79725E-02, -3.51931E-01, -5.754533E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.607703E-01, -2.725529E-01, -5.794647E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <4.79725E-02, -3.51931E-01, -5.754533E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      <5.691462E-02, -2.725529E-01, -5.777632E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.691462E-02, -2.725529E-01, -5.777632E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <4.79725E-02, -3.51931E-01, -5.754533E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      <-6.291188E-02, -3.51931E-01, -5.699006E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.691462E-02, -2.725529E-01, -5.777632E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-6.291188E-02, -3.51931E-01, -5.699006E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-6.37449E-02, -2.725529E-01, -5.71721E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.37449E-02, -2.725529E-01, -5.71721E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01> 
      <-6.291188E-02, -3.51931E-01, -5.699006E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-1.723577E-01, -3.51931E-01, -5.612041E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.37449E-02, -2.725529E-01, -5.71721E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01> 
      <-1.723577E-01, -3.51931E-01, -5.612041E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-1.82839E-01, -2.725529E-01, -5.622579E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.82839E-01, -2.725529E-01, -5.622579E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-1.723577E-01, -3.51931E-01, -5.612041E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-2.637028E-01, -3.51931E-01, -5.506879E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.82839E-01, -2.725529E-01, -5.622579E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-2.637028E-01, -3.51931E-01, -5.506879E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-2.822367E-01, -2.725529E-01, -5.508146E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.822367E-01, -2.725529E-01, -5.508146E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-2.637028E-01, -3.51931E-01, -5.506879E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-3.230407E-01, -3.51931E-01, -5.399529E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.822367E-01, -2.725529E-01, -5.508146E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-3.230407E-01, -3.51931E-01, -5.399529E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-3.468057E-01, -2.725529E-01, -5.391332E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.468057E-01, -2.725529E-01, -5.391332E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-3.230407E-01, -3.51931E-01, -5.399529E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-3.413377E-01, -3.51931E-01, -5.306334E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.468057E-01, -2.725529E-01, -5.391332E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-3.413377E-01, -3.51931E-01, -5.306334E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-3.667158E-01, -2.725529E-01, -5.289922E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.667158E-01, -2.725529E-01, -5.289922E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-3.413377E-01, -3.51931E-01, -5.306334E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-3.158084E-01, -3.51931E-01, -5.241483E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.667158E-01, -2.725529E-01, -5.289922E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-3.158084E-01, -3.51931E-01, -5.241483E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-3.389358E-01, -2.725529E-01, -5.219354E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.389358E-01, -2.725529E-01, -5.219354E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-3.158084E-01, -3.51931E-01, -5.241483E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-2.503392E-01, -3.51931E-01, -5.214849E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.389358E-01, -2.725529E-01, -5.219354E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-2.503392E-01, -3.51931E-01, -5.214849E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      <-2.676951E-01, -2.725529E-01, -5.190371E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.676951E-01, -2.725529E-01, -5.190371E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-2.503392E-01, -3.51931E-01, -5.214849E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      <-1.548972E-01, -3.51931E-01, -5.230485E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.676951E-01, -2.725529E-01, -5.190371E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-1.548972E-01, -3.51931E-01, -5.230485E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      <-1.638393E-01, -2.725529E-01, -5.207386E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.638393E-01, -2.725529E-01, -5.207386E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-1.548972E-01, -3.51931E-01, -5.230485E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      <-4.40128E-02, -3.51931E-01, -5.286012E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.638393E-01, -2.725529E-01, -5.207386E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-4.40128E-02, -3.51931E-01, -5.286012E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      <-4.317965E-02, -2.725529E-01, -5.267808E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.317965E-02, -2.725529E-01, -5.267808E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-4.40128E-02, -3.51931E-01, -5.286012E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      <6.543298E-02, -3.51931E-01, -5.372977E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.317965E-02, -2.725529E-01, -5.267808E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <6.543298E-02, -3.51931E-01, -5.372977E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <7.59144E-02, -2.725529E-01, -5.362439E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.59144E-02, -2.725529E-01, -5.362439E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <6.543298E-02, -3.51931E-01, -5.372977E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <1.567782E-01, -3.51931E-01, -5.478139E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.59144E-02, -2.725529E-01, -5.362439E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <1.567782E-01, -3.51931E-01, -5.478139E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <1.753121E-01, -2.725529E-01, -5.476872E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.753121E-01, -2.725529E-01, -5.476872E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <1.567782E-01, -3.51931E-01, -5.478139E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <2.161159E-01, -3.51931E-01, -5.585488E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.753121E-01, -2.725529E-01, -5.476872E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <2.161159E-01, -3.51931E-01, -5.585488E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <2.398809E-01, -2.725529E-01, -5.593686E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.161159E-01, -3.51931E-01, -5.585488E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <1.705113E-01, -4.215272E-01, -5.569759E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <1.857132E-01, -4.215272E-01, -5.647188E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.161159E-01, -3.51931E-01, -5.585488E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <1.857132E-01, -4.215272E-01, -5.647188E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <2.34413E-01, -3.51931E-01, -5.678683E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.34413E-01, -3.51931E-01, -5.678683E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <1.857132E-01, -4.215272E-01, -5.647188E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <1.645027E-01, -4.215272E-01, -5.701069E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.34413E-01, -3.51931E-01, -5.678683E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <1.645027E-01, -4.215272E-01, -5.701069E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <2.088837E-01, -3.51931E-01, -5.743535E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.088837E-01, -3.51931E-01, -5.743535E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <1.645027E-01, -4.215272E-01, -5.701069E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <1.101087E-01, -4.215272E-01, -5.723197E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.088837E-01, -3.51931E-01, -5.743535E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <1.101087E-01, -4.215272E-01, -5.723197E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <1.434145E-01, -3.51931E-01, -5.770169E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.434145E-01, -3.51931E-01, -5.770169E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01> 
      <1.101087E-01, -4.215272E-01, -5.723197E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <3.081287E-02, -4.215272E-01, -5.710207E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.434145E-01, -3.51931E-01, -5.770169E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01> 
      <3.081287E-02, -4.215272E-01, -5.710207E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <4.79725E-02, -3.51931E-01, -5.754533E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.79725E-02, -3.51931E-01, -5.754533E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01> 
      <3.081287E-02, -4.215272E-01, -5.710207E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-6.131329E-02, -4.215272E-01, -5.664073E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.79725E-02, -3.51931E-01, -5.754533E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01> 
      <-6.131329E-02, -4.215272E-01, -5.664073E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-6.291188E-02, -3.51931E-01, -5.699006E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.291188E-02, -3.51931E-01, -5.699006E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-6.131329E-02, -4.215272E-01, -5.664073E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-1.522443E-01, -4.215272E-01, -5.59182E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.291188E-02, -3.51931E-01, -5.699006E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-1.522443E-01, -4.215272E-01, -5.59182E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-1.723577E-01, -3.51931E-01, -5.612041E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.723577E-01, -3.51931E-01, -5.612041E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-1.522443E-01, -4.215272E-01, -5.59182E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-2.281363E-01, -4.215272E-01, -5.504448E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.723577E-01, -3.51931E-01, -5.612041E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-2.281363E-01, -4.215272E-01, -5.504448E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-2.637028E-01, -3.51931E-01, -5.506879E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.637028E-01, -3.51931E-01, -5.506879E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-2.281363E-01, -4.215272E-01, -5.504448E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-2.774362E-01, -4.215272E-01, -5.415258E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.637028E-01, -3.51931E-01, -5.506879E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-2.774362E-01, -4.215272E-01, -5.415258E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-3.230407E-01, -3.51931E-01, -5.399529E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.230407E-01, -3.51931E-01, -5.399529E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-2.774362E-01, -4.215272E-01, -5.415258E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-2.92638E-01, -4.215272E-01, -5.33783E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.230407E-01, -3.51931E-01, -5.399529E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-2.92638E-01, -4.215272E-01, -5.33783E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-3.413377E-01, -3.51931E-01, -5.306334E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.413377E-01, -3.51931E-01, -5.306334E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-2.92638E-01, -4.215272E-01, -5.33783E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-2.714274E-01, -4.215272E-01, -5.283949E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.413377E-01, -3.51931E-01, -5.306334E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-2.714274E-01, -4.215272E-01, -5.283949E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-3.158084E-01, -3.51931E-01, -5.241483E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.158084E-01, -3.51931E-01, -5.241483E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-2.714274E-01, -4.215272E-01, -5.283949E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-2.170335E-01, -4.215272E-01, -5.261821E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.158084E-01, -3.51931E-01, -5.241483E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-2.170335E-01, -4.215272E-01, -5.261821E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-2.503392E-01, -3.51931E-01, -5.214849E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.503392E-01, -3.51931E-01, -5.214849E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01> 
      <-2.170335E-01, -4.215272E-01, -5.261821E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-1.377376E-01, -4.215272E-01, -5.274811E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.503392E-01, -3.51931E-01, -5.214849E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01> 
      <-1.377376E-01, -4.215272E-01, -5.274811E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-1.548972E-01, -3.51931E-01, -5.230485E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.548972E-01, -3.51931E-01, -5.230485E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01> 
      <-1.377376E-01, -4.215272E-01, -5.274811E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-4.561139E-02, -4.215272E-01, -5.320945E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.548972E-01, -3.51931E-01, -5.230485E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01> 
      <-4.561139E-02, -4.215272E-01, -5.320945E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-4.40128E-02, -3.51931E-01, -5.286012E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.40128E-02, -3.51931E-01, -5.286012E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01> 
      <-4.561139E-02, -4.215272E-01, -5.320945E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <4.531952E-02, -4.215272E-01, -5.393198E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.40128E-02, -3.51931E-01, -5.286012E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01> 
      <4.531952E-02, -4.215272E-01, -5.393198E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <6.543298E-02, -3.51931E-01, -5.372977E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.543298E-02, -3.51931E-01, -5.372977E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <4.531952E-02, -4.215272E-01, -5.393198E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <1.212116E-01, -4.215272E-01, -5.480569E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.543298E-02, -3.51931E-01, -5.372977E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <1.212116E-01, -4.215272E-01, -5.480569E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <1.567782E-01, -3.51931E-01, -5.478139E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.567782E-01, -3.51931E-01, -5.478139E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <1.212116E-01, -4.215272E-01, -5.480569E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <1.705113E-01, -4.215272E-01, -5.569759E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.567782E-01, -3.51931E-01, -5.478139E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <1.705113E-01, -4.215272E-01, -5.569759E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <2.161159E-01, -3.51931E-01, -5.585488E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.705113E-01, -4.215272E-01, -5.569759E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <1.067618E-01, -4.757033E-01, -5.547771E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <1.176366E-01, -4.757033E-01, -5.603161E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.705113E-01, -4.215272E-01, -5.569759E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <1.176366E-01, -4.757033E-01, -5.603161E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <1.857132E-01, -4.215272E-01, -5.647188E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.857132E-01, -4.215272E-01, -5.647188E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <1.176366E-01, -4.757033E-01, -5.603161E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <1.024633E-01, -4.757033E-01, -5.641706E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.857132E-01, -4.215272E-01, -5.647188E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <1.024633E-01, -4.757033E-01, -5.641706E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <1.645027E-01, -4.215272E-01, -5.701069E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.645027E-01, -4.215272E-01, -5.701069E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <1.024633E-01, -4.757033E-01, -5.641706E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <6.355147E-02, -4.757033E-01, -5.657536E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.645027E-01, -4.215272E-01, -5.701069E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <6.355147E-02, -4.757033E-01, -5.657536E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <1.101087E-01, -4.215272E-01, -5.723197E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.101087E-01, -4.215272E-01, -5.723197E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <6.355147E-02, -4.757033E-01, -5.657536E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <6.825621E-03, -4.757033E-01, -5.648243E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.101087E-01, -4.215272E-01, -5.723197E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <6.825621E-03, -4.757033E-01, -5.648243E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <3.081287E-02, -4.215272E-01, -5.710207E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.081287E-02, -4.215272E-01, -5.710207E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <6.825621E-03, -4.757033E-01, -5.648243E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-5.907875E-02, -4.757033E-01, -5.61524E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.081287E-02, -4.215272E-01, -5.710207E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-5.907875E-02, -4.757033E-01, -5.61524E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-6.131329E-02, -4.215272E-01, -5.664073E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.131329E-02, -4.215272E-01, -5.664073E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-5.907875E-02, -4.757033E-01, -5.61524E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-1.241278E-01, -4.757033E-01, -5.563553E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.131329E-02, -4.215272E-01, -5.664073E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-1.241278E-01, -4.757033E-01, -5.563553E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-1.522443E-01, -4.215272E-01, -5.59182E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.522443E-01, -4.215272E-01, -5.59182E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-1.241278E-01, -4.757033E-01, -5.563553E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-1.784189E-01, -4.757033E-01, -5.50105E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.522443E-01, -4.215272E-01, -5.59182E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-1.784189E-01, -4.757033E-01, -5.50105E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-2.281363E-01, -4.215272E-01, -5.504448E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.281363E-01, -4.215272E-01, -5.504448E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-1.784189E-01, -4.757033E-01, -5.50105E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-2.136866E-01, -4.757033E-01, -5.437246E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.281363E-01, -4.215272E-01, -5.504448E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-2.136866E-01, -4.757033E-01, -5.437246E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-2.774362E-01, -4.215272E-01, -5.415258E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.774362E-01, -4.215272E-01, -5.415258E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-2.136866E-01, -4.757033E-01, -5.437246E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-2.245614E-01, -4.757033E-01, -5.381856E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.774362E-01, -4.215272E-01, -5.415258E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-2.245614E-01, -4.757033E-01, -5.381856E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-2.92638E-01, -4.215272E-01, -5.33783E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.92638E-01, -4.215272E-01, -5.33783E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-2.245614E-01, -4.757033E-01, -5.381856E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-2.093881E-01, -4.757033E-01, -5.343311E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.92638E-01, -4.215272E-01, -5.33783E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-2.093881E-01, -4.757033E-01, -5.343311E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-2.714274E-01, -4.215272E-01, -5.283949E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.714274E-01, -4.215272E-01, -5.283949E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-2.093881E-01, -4.757033E-01, -5.343311E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-1.704763E-01, -4.757033E-01, -5.327481E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.714274E-01, -4.215272E-01, -5.283949E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-1.704763E-01, -4.757033E-01, -5.327481E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-2.170335E-01, -4.215272E-01, -5.261821E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.170335E-01, -4.215272E-01, -5.261821E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-1.704763E-01, -4.757033E-01, -5.327481E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-1.137503E-01, -4.757033E-01, -5.336774E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.170335E-01, -4.215272E-01, -5.261821E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-1.137503E-01, -4.757033E-01, -5.336774E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-1.377376E-01, -4.215272E-01, -5.274811E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.377376E-01, -4.215272E-01, -5.274811E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-1.137503E-01, -4.757033E-01, -5.336774E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-4.784594E-02, -4.757033E-01, -5.369778E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.377376E-01, -4.215272E-01, -5.274811E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-4.784594E-02, -4.757033E-01, -5.369778E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-4.561139E-02, -4.215272E-01, -5.320945E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.561139E-02, -4.215272E-01, -5.320945E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-4.784594E-02, -4.757033E-01, -5.369778E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <1.72031E-02, -4.757033E-01, -5.421464E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.561139E-02, -4.215272E-01, -5.320945E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <1.72031E-02, -4.757033E-01, -5.421464E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <4.531952E-02, -4.215272E-01, -5.393198E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.531952E-02, -4.215272E-01, -5.393198E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <1.72031E-02, -4.757033E-01, -5.421464E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <7.149429E-02, -4.757033E-01, -5.483968E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.531952E-02, -4.215272E-01, -5.393198E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <7.149429E-02, -4.757033E-01, -5.483968E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <1.212116E-01, -4.215272E-01, -5.480569E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.212116E-01, -4.215272E-01, -5.480569E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <7.149429E-02, -4.757033E-01, -5.483968E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <1.067618E-01, -4.757033E-01, -5.547771E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.212116E-01, -4.215272E-01, -5.480569E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <1.067618E-01, -4.757033E-01, -5.547771E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <1.705113E-01, -4.215272E-01, -5.569759E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.067618E-01, -4.757033E-01, -5.547771E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <3.003188E-02, -5.100703E-01, -5.521307E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <3.569869E-02, -5.100703E-01, -5.550171E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.067618E-01, -4.757033E-01, -5.547771E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <3.569869E-02, -5.100703E-01, -5.550171E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <1.176366E-01, -4.757033E-01, -5.603161E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.176366E-01, -4.757033E-01, -5.603161E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <3.569869E-02, -5.100703E-01, -5.550171E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <2.779181E-02, -5.100703E-01, -5.570257E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.176366E-01, -4.757033E-01, -5.603161E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <2.779181E-02, -5.100703E-01, -5.570257E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <1.024633E-01, -4.757033E-01, -5.641706E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.024633E-01, -4.757033E-01, -5.641706E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <2.779181E-02, -5.100703E-01, -5.570257E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <7.514677E-03, -5.100703E-01, -5.578506E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.024633E-01, -4.757033E-01, -5.641706E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <7.514677E-03, -5.100703E-01, -5.578506E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <6.355147E-02, -4.757033E-01, -5.657536E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.355147E-02, -4.757033E-01, -5.657536E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <7.514677E-03, -5.100703E-01, -5.578506E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-2.204583E-02, -5.100703E-01, -5.573663E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.355147E-02, -4.757033E-01, -5.657536E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-2.204583E-02, -5.100703E-01, -5.573663E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <6.825621E-03, -4.757033E-01, -5.648243E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.825621E-03, -4.757033E-01, -5.648243E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-2.204583E-02, -5.100703E-01, -5.573663E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-5.638908E-02, -5.100703E-01, -5.556465E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.825621E-03, -4.757033E-01, -5.648243E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-5.638908E-02, -5.100703E-01, -5.556465E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-5.907875E-02, -4.757033E-01, -5.61524E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.907875E-02, -4.757033E-01, -5.61524E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-5.638908E-02, -5.100703E-01, -5.556465E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-9.028676E-02, -5.100703E-01, -5.529531E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.907875E-02, -4.757033E-01, -5.61524E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-9.028676E-02, -5.100703E-01, -5.529531E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-1.241278E-01, -4.757033E-01, -5.563553E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.241278E-01, -4.757033E-01, -5.563553E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-9.028676E-02, -5.100703E-01, -5.529531E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-1.185784E-01, -5.100703E-01, -5.496959E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.241278E-01, -4.757033E-01, -5.563553E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-1.185784E-01, -5.100703E-01, -5.496959E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-1.784189E-01, -4.757033E-01, -5.50105E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.784189E-01, -4.757033E-01, -5.50105E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-1.185784E-01, -5.100703E-01, -5.496959E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-1.369566E-01, -5.100703E-01, -5.463711E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.784189E-01, -4.757033E-01, -5.50105E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-1.369566E-01, -5.100703E-01, -5.463711E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-2.136866E-01, -4.757033E-01, -5.437246E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.136866E-01, -4.757033E-01, -5.437246E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-1.369566E-01, -5.100703E-01, -5.463711E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-1.426234E-01, -5.100703E-01, -5.434847E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.136866E-01, -4.757033E-01, -5.437246E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-1.426234E-01, -5.100703E-01, -5.434847E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-2.245614E-01, -4.757033E-01, -5.381856E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.245614E-01, -4.757033E-01, -5.381856E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-1.426234E-01, -5.100703E-01, -5.434847E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-1.347166E-01, -5.100703E-01, -5.414761E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.245614E-01, -4.757033E-01, -5.381856E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-1.347166E-01, -5.100703E-01, -5.414761E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-2.093881E-01, -4.757033E-01, -5.343311E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.093881E-01, -4.757033E-01, -5.343311E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-1.347166E-01, -5.100703E-01, -5.414761E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-1.144394E-01, -5.100703E-01, -5.406511E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.093881E-01, -4.757033E-01, -5.343311E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-1.144394E-01, -5.100703E-01, -5.406511E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-1.704763E-01, -4.757033E-01, -5.327481E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.704763E-01, -4.757033E-01, -5.327481E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-1.144394E-01, -5.100703E-01, -5.406511E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-8.487889E-02, -5.100703E-01, -5.411355E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.704763E-01, -4.757033E-01, -5.327481E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-8.487889E-02, -5.100703E-01, -5.411355E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-1.137503E-01, -4.757033E-01, -5.336774E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.137503E-01, -4.757033E-01, -5.336774E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-8.487889E-02, -5.100703E-01, -5.411355E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-5.053564E-02, -5.100703E-01, -5.428553E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.137503E-01, -4.757033E-01, -5.336774E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-5.053564E-02, -5.100703E-01, -5.428553E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-4.784594E-02, -4.757033E-01, -5.369778E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.784594E-02, -4.757033E-01, -5.369778E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-5.053564E-02, -5.100703E-01, -5.428553E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-1.663798E-02, -5.100703E-01, -5.455487E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.784594E-02, -4.757033E-01, -5.369778E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-1.663798E-02, -5.100703E-01, -5.455487E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <1.72031E-02, -4.757033E-01, -5.421464E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.72031E-02, -4.757033E-01, -5.421464E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-1.663798E-02, -5.100703E-01, -5.455487E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <1.165369E-02, -5.100703E-01, -5.488059E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.72031E-02, -4.757033E-01, -5.421464E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <1.165369E-02, -5.100703E-01, -5.488059E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <7.149429E-02, -4.757033E-01, -5.483968E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.149429E-02, -4.757033E-01, -5.483968E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <1.165369E-02, -5.100703E-01, -5.488059E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <3.003188E-02, -5.100703E-01, -5.521307E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <7.149429E-02, -4.757033E-01, -5.483968E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <3.003188E-02, -5.100703E-01, -5.521307E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <1.067618E-01, -4.757033E-01, -5.547771E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.003188E-02, -5.100703E-01, -5.521307E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.569869E-02, -5.100703E-01, -5.550171E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.569869E-02, -5.100703E-01, -5.550171E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <2.779181E-02, -5.100703E-01, -5.570257E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.779181E-02, -5.100703E-01, -5.570257E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.514677E-03, -5.100703E-01, -5.578506E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.514677E-03, -5.100703E-01, -5.578506E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-2.204583E-02, -5.100703E-01, -5.573663E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-2.204583E-02, -5.100703E-01, -5.573663E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.638908E-02, -5.100703E-01, -5.556465E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.638908E-02, -5.100703E-01, -5.556465E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-9.028676E-02, -5.100703E-01, -5.529531E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-9.028676E-02, -5.100703E-01, -5.529531E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-1.185784E-01, -5.100703E-01, -5.496959E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.185784E-01, -5.100703E-01, -5.496959E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-1.369566E-01, -5.100703E-01, -5.463711E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.369566E-01, -5.100703E-01, -5.463711E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-1.426234E-01, -5.100703E-01, -5.434847E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.426234E-01, -5.100703E-01, -5.434847E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-1.347166E-01, -5.100703E-01, -5.414761E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.347166E-01, -5.100703E-01, -5.414761E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-1.144394E-01, -5.100703E-01, -5.406511E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.144394E-01, -5.100703E-01, -5.406511E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-8.487889E-02, -5.100703E-01, -5.411355E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.487889E-02, -5.100703E-01, -5.411355E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.053564E-02, -5.100703E-01, -5.428553E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.053564E-02, -5.100703E-01, -5.428553E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-1.663798E-02, -5.100703E-01, -5.455487E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-1.663798E-02, -5.100703E-01, -5.455487E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <1.165369E-02, -5.100703E-01, -5.488059E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.165369E-02, -5.100703E-01, -5.488059E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02> 
      <-5.346246E-02, -5.218439E-01, -5.492509E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.003188E-02, -5.100703E-01, -5.521307E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
}
}
 
// Sphere
object {
union {
   smooth_triangle {
      <4.838143E-01, 3.851642E-02, -5.774818E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <4.930952E-01, 3.851642E-02, -5.802221E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.930952E-01, 3.851642E-02, -5.802221E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <4.902472E-01, 3.851642E-02, -5.823792E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.902472E-01, 3.851642E-02, -5.823792E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <4.757037E-01, 3.851642E-02, -5.836247E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.757037E-01, 3.851642E-02, -5.836247E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <4.516789E-01, 3.851642E-02, -5.83769E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.516789E-01, 3.851642E-02, -5.83769E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <4.218304E-01, 3.851642E-02, -5.827901E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.218304E-01, 3.851642E-02, -5.827901E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <3.907023E-01, 3.851642E-02, -5.808371E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.907023E-01, 3.851642E-02, -5.808371E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <3.630335E-01, 3.851642E-02, -5.782073E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.630335E-01, 3.851642E-02, -5.782073E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <3.430366E-01, 3.851642E-02, -5.753011E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.430366E-01, 3.851642E-02, -5.753011E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <3.337556E-01, 3.851639E-02, -5.725608E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.337556E-01, 3.851639E-02, -5.725608E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <3.366037E-01, 3.851642E-02, -5.704037E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.366037E-01, 3.851642E-02, -5.704037E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <3.511472E-01, 3.851642E-02, -5.691582E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.511472E-01, 3.851642E-02, -5.691582E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <3.75172E-01, 3.851642E-02, -5.690139E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.75172E-01, 3.851642E-02, -5.690139E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <4.050205E-01, 3.851642E-02, -5.699928E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.050205E-01, 3.851642E-02, -5.699928E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <4.361486E-01, 3.851642E-02, -5.719458E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.361486E-01, 3.851642E-02, -5.719458E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <4.638173E-01, 3.851642E-02, -5.745756E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.638173E-01, 3.851642E-02, -5.745756E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <4.838143E-01, 3.851642E-02, -5.774818E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      <4.134254E-01, 5.029E-02, -5.763915E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.838143E-01, 3.851642E-02, -5.774818E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <5.485006E-01, 4.149422E-03, -5.784839E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <5.663106E-01, 4.149422E-03, -5.837424E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.838143E-01, 3.851642E-02, -5.774818E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <5.663106E-01, 4.149422E-03, -5.837424E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <4.930952E-01, 3.851642E-02, -5.802221E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.930952E-01, 3.851642E-02, -5.802221E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <5.663106E-01, 4.149422E-03, -5.837424E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <5.608453E-01, 4.149422E-03, -5.878818E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.930952E-01, 3.851642E-02, -5.802221E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <5.608453E-01, 4.149422E-03, -5.878818E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <4.902472E-01, 3.851642E-02, -5.823792E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.902472E-01, 3.851642E-02, -5.823792E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <5.608453E-01, 4.149422E-03, -5.878818E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <5.329365E-01, 4.149422E-03, -5.902719E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.902472E-01, 3.851642E-02, -5.823792E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <5.329365E-01, 4.149422E-03, -5.902719E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <4.757037E-01, 3.851642E-02, -5.836247E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.757037E-01, 3.851642E-02, -5.836247E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <5.329365E-01, 4.149422E-03, -5.902719E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <4.868333E-01, 4.149422E-03, -5.905488E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.757037E-01, 3.851642E-02, -5.836247E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <4.868333E-01, 4.149422E-03, -5.905488E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <4.516789E-01, 3.851642E-02, -5.83769E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.516789E-01, 3.851642E-02, -5.83769E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <4.868333E-01, 4.149422E-03, -5.905488E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <4.295544E-01, 4.149422E-03, -5.886704E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.516789E-01, 3.851642E-02, -5.83769E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <4.295544E-01, 4.149422E-03, -5.886704E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <4.218304E-01, 3.851642E-02, -5.827901E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.218304E-01, 3.851642E-02, -5.827901E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <4.295544E-01, 4.149422E-03, -5.886704E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <3.6982E-01, 4.149422E-03, -5.849226E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.218304E-01, 3.851642E-02, -5.827901E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <3.6982E-01, 4.149422E-03, -5.849226E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <3.907023E-01, 3.851642E-02, -5.808371E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.907023E-01, 3.851642E-02, -5.808371E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <3.6982E-01, 4.149422E-03, -5.849226E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <3.167242E-01, 4.149422E-03, -5.798761E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.907023E-01, 3.851642E-02, -5.808371E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <3.167242E-01, 4.149422E-03, -5.798761E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <3.630335E-01, 3.851642E-02, -5.782073E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.630335E-01, 3.851642E-02, -5.782073E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <3.167242E-01, 4.149422E-03, -5.798761E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <2.783502E-01, 4.149422E-03, -5.74299E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.630335E-01, 3.851642E-02, -5.782073E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <2.783502E-01, 4.149422E-03, -5.74299E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <3.430366E-01, 3.851642E-02, -5.753011E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.430366E-01, 3.851642E-02, -5.753011E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <2.783502E-01, 4.149422E-03, -5.74299E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <2.605402E-01, 4.149437E-03, -5.690405E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.430366E-01, 3.851642E-02, -5.753011E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <2.605402E-01, 4.149437E-03, -5.690405E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <3.337556E-01, 3.851639E-02, -5.725608E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.337556E-01, 3.851639E-02, -5.725608E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <2.605402E-01, 4.149437E-03, -5.690405E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <2.660056E-01, 4.149422E-03, -5.649011E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.337556E-01, 3.851639E-02, -5.725608E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <2.660056E-01, 4.149422E-03, -5.649011E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <3.366037E-01, 3.851642E-02, -5.704037E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.366037E-01, 3.851642E-02, -5.704037E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <2.660056E-01, 4.149422E-03, -5.649011E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <2.939143E-01, 4.149422E-03, -5.62511E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.366037E-01, 3.851642E-02, -5.704037E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <2.939143E-01, 4.149422E-03, -5.62511E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <3.511472E-01, 3.851642E-02, -5.691582E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.511472E-01, 3.851642E-02, -5.691582E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <2.939143E-01, 4.149422E-03, -5.62511E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <3.400176E-01, 4.149422E-03, -5.622341E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.511472E-01, 3.851642E-02, -5.691582E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <3.400176E-01, 4.149422E-03, -5.622341E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <3.75172E-01, 3.851642E-02, -5.690139E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.75172E-01, 3.851642E-02, -5.690139E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <3.400176E-01, 4.149422E-03, -5.622341E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <3.972965E-01, 4.149422E-03, -5.641125E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.75172E-01, 3.851642E-02, -5.690139E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <3.972965E-01, 4.149422E-03, -5.641125E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <4.050205E-01, 3.851642E-02, -5.699928E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.050205E-01, 3.851642E-02, -5.699928E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <3.972965E-01, 4.149422E-03, -5.641125E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <4.57031E-01, 4.149422E-03, -5.678603E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.050205E-01, 3.851642E-02, -5.699928E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <4.57031E-01, 4.149422E-03, -5.678603E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <4.361486E-01, 3.851642E-02, -5.719458E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.361486E-01, 3.851642E-02, -5.719458E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <4.57031E-01, 4.149422E-03, -5.678603E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <5.101268E-01, 4.149422E-03, -5.729068E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.361486E-01, 3.851642E-02, -5.719458E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <5.101268E-01, 4.149422E-03, -5.729068E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <4.638173E-01, 3.851642E-02, -5.745756E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.638173E-01, 3.851642E-02, -5.745756E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <5.101268E-01, 4.149422E-03, -5.729068E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <5.485006E-01, 4.149422E-03, -5.784839E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.638173E-01, 3.851642E-02, -5.745756E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <5.485006E-01, 4.149422E-03, -5.784839E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <4.838143E-01, 3.851642E-02, -5.774818E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.485006E-01, 4.149422E-03, -5.784839E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <6.02244E-01, -5.002668E-02, -5.793164E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <6.271402E-01, -5.002668E-02, -5.866672E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.485006E-01, 4.149422E-03, -5.784839E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <6.271402E-01, -5.002668E-02, -5.866672E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <5.663106E-01, 4.149422E-03, -5.837424E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.663106E-01, 4.149422E-03, -5.837424E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <6.271402E-01, -5.002668E-02, -5.866672E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <6.195002E-01, -5.002668E-02, -5.924535E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.663106E-01, 4.149422E-03, -5.837424E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <6.195002E-01, -5.002668E-02, -5.924535E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <5.608453E-01, 4.149422E-03, -5.878818E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.608453E-01, 4.149422E-03, -5.878818E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <6.195002E-01, -5.002668E-02, -5.924535E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <5.804873E-01, -5.002668E-02, -5.957946E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.608453E-01, 4.149422E-03, -5.878818E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <5.804873E-01, -5.002668E-02, -5.957946E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <5.329365E-01, 4.149422E-03, -5.902719E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.329365E-01, 4.149422E-03, -5.902719E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <5.804873E-01, -5.002668E-02, -5.957946E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <5.160406E-01, -5.002668E-02, -5.961817E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.329365E-01, 4.149422E-03, -5.902719E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <5.160406E-01, -5.002668E-02, -5.961817E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <4.868333E-01, 4.149422E-03, -5.905488E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.868333E-01, 4.149422E-03, -5.905488E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <5.160406E-01, -5.002668E-02, -5.961817E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <4.359717E-01, -5.002668E-02, -5.935559E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.868333E-01, 4.149422E-03, -5.905488E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <4.359717E-01, -5.002668E-02, -5.935559E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <4.295544E-01, 4.149422E-03, -5.886704E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.295544E-01, 4.149422E-03, -5.886704E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <4.359717E-01, -5.002668E-02, -5.935559E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <3.524704E-01, -5.002668E-02, -5.88317E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.295544E-01, 4.149422E-03, -5.886704E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <3.524704E-01, -5.002668E-02, -5.88317E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <3.6982E-01, 4.149422E-03, -5.849226E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.6982E-01, 4.149422E-03, -5.849226E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <3.524704E-01, -5.002668E-02, -5.88317E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <2.782489E-01, -5.002668E-02, -5.812625E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.6982E-01, 4.149422E-03, -5.849226E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <2.782489E-01, -5.002668E-02, -5.812625E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <3.167242E-01, 4.149422E-03, -5.798761E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.167242E-01, 4.149422E-03, -5.798761E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <2.782489E-01, -5.002668E-02, -5.812625E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <2.246068E-01, -5.002668E-02, -5.734665E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.167242E-01, 4.149422E-03, -5.798761E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <2.246068E-01, -5.002668E-02, -5.734665E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <2.783502E-01, 4.149422E-03, -5.74299E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.783502E-01, 4.149422E-03, -5.74299E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <2.246068E-01, -5.002668E-02, -5.734665E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <1.997105E-01, -5.002668E-02, -5.661157E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.783502E-01, 4.149422E-03, -5.74299E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <1.997105E-01, -5.002668E-02, -5.661157E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <2.605402E-01, 4.149437E-03, -5.690405E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.605402E-01, 4.149437E-03, -5.690405E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <1.997105E-01, -5.002668E-02, -5.661157E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <2.073506E-01, -5.002668E-02, -5.603294E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.605402E-01, 4.149437E-03, -5.690405E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <2.073506E-01, -5.002668E-02, -5.603294E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <2.660056E-01, 4.149422E-03, -5.649011E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.660056E-01, 4.149422E-03, -5.649011E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <2.073506E-01, -5.002668E-02, -5.603294E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <2.463635E-01, -5.002668E-02, -5.569883E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.660056E-01, 4.149422E-03, -5.649011E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <2.463635E-01, -5.002668E-02, -5.569883E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      <2.939143E-01, 4.149422E-03, -5.62511E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.939143E-01, 4.149422E-03, -5.62511E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <2.463635E-01, -5.002668E-02, -5.569883E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      <3.108103E-01, -5.002668E-02, -5.566012E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.939143E-01, 4.149422E-03, -5.62511E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <3.108103E-01, -5.002668E-02, -5.566012E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <3.400176E-01, 4.149422E-03, -5.622341E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.400176E-01, 4.149422E-03, -5.622341E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <3.108103E-01, -5.002668E-02, -5.566012E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <3.908792E-01, -5.002668E-02, -5.59227E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.400176E-01, 4.149422E-03, -5.622341E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <3.908792E-01, -5.002668E-02, -5.59227E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <3.972965E-01, 4.149422E-03, -5.641125E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.972965E-01, 4.149422E-03, -5.641125E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <3.908792E-01, -5.002668E-02, -5.59227E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <4.743805E-01, -5.002668E-02, -5.64466E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.972965E-01, 4.149422E-03, -5.641125E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <4.743805E-01, -5.002668E-02, -5.64466E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <4.57031E-01, 4.149422E-03, -5.678603E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.57031E-01, 4.149422E-03, -5.678603E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <4.743805E-01, -5.002668E-02, -5.64466E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <5.486019E-01, -5.002668E-02, -5.715204E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.57031E-01, 4.149422E-03, -5.678603E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <5.486019E-01, -5.002668E-02, -5.715204E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <5.101268E-01, 4.149422E-03, -5.729068E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.101268E-01, 4.149422E-03, -5.729068E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <5.486019E-01, -5.002668E-02, -5.715204E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <6.02244E-01, -5.002668E-02, -5.793164E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.101268E-01, 4.149422E-03, -5.729068E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <6.02244E-01, -5.002668E-02, -5.793164E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <5.485006E-01, 4.149422E-03, -5.784839E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.02244E-01, -5.002668E-02, -5.793164E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <6.406904E-01, -1.196229E-01, -5.79912E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <6.706558E-01, -1.196229E-01, -5.887595E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.02244E-01, -5.002668E-02, -5.793164E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <6.706558E-01, -1.196229E-01, -5.887595E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <6.271402E-01, -5.002668E-02, -5.866672E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.271402E-01, -5.002668E-02, -5.866672E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <6.706558E-01, -1.196229E-01, -5.887595E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <6.614602E-01, -1.196229E-01, -5.957241E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.271402E-01, -5.002668E-02, -5.866672E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <6.614602E-01, -1.196229E-01, -5.957241E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <6.195002E-01, -5.002668E-02, -5.924535E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.195002E-01, -5.002668E-02, -5.924535E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <6.614602E-01, -1.196229E-01, -5.957241E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <6.145037E-01, -1.196229E-01, -5.997454E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.195002E-01, -5.002668E-02, -5.924535E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <6.145037E-01, -1.196229E-01, -5.997454E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <5.804873E-01, -5.002668E-02, -5.957946E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.804873E-01, -5.002668E-02, -5.957946E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <6.145037E-01, -1.196229E-01, -5.997454E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <5.369347E-01, -1.196229E-01, -6.002113E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.804873E-01, -5.002668E-02, -5.957946E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <5.369347E-01, -1.196229E-01, -6.002113E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <5.160406E-01, -5.002668E-02, -5.961817E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.160406E-01, -5.002668E-02, -5.961817E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <5.369347E-01, -1.196229E-01, -6.002113E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <4.405625E-01, -1.196229E-01, -5.970509E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.160406E-01, -5.002668E-02, -5.961817E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <4.405625E-01, -1.196229E-01, -5.970509E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <4.359717E-01, -5.002668E-02, -5.935559E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.359717E-01, -5.002668E-02, -5.935559E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <4.405625E-01, -1.196229E-01, -5.970509E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <3.40059E-01, -1.196229E-01, -5.907453E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.359717E-01, -5.002668E-02, -5.935559E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <3.40059E-01, -1.196229E-01, -5.907453E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <3.524704E-01, -5.002668E-02, -5.88317E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.524704E-01, -5.002668E-02, -5.88317E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <3.40059E-01, -1.196229E-01, -5.907453E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <2.507249E-01, -1.196229E-01, -5.822544E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.524704E-01, -5.002668E-02, -5.88317E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <2.507249E-01, -1.196229E-01, -5.822544E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <2.782489E-01, -5.002668E-02, -5.812625E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.782489E-01, -5.002668E-02, -5.812625E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <2.507249E-01, -1.196229E-01, -5.822544E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <1.861604E-01, -1.196229E-01, -5.728709E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.782489E-01, -5.002668E-02, -5.812625E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <1.861604E-01, -1.196229E-01, -5.728709E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <2.246068E-01, -5.002668E-02, -5.734665E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.246068E-01, -5.002668E-02, -5.734665E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <1.861604E-01, -1.196229E-01, -5.728709E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <1.561949E-01, -1.196229E-01, -5.640234E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.246068E-01, -5.002668E-02, -5.734665E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <1.561949E-01, -1.196229E-01, -5.640234E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <1.997105E-01, -5.002668E-02, -5.661157E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.997105E-01, -5.002668E-02, -5.661157E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <1.561949E-01, -1.196229E-01, -5.640234E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <1.653905E-01, -1.196229E-01, -5.570589E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.997105E-01, -5.002668E-02, -5.661157E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <1.653905E-01, -1.196229E-01, -5.570589E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <2.073506E-01, -5.002668E-02, -5.603294E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.073506E-01, -5.002668E-02, -5.603294E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <1.653905E-01, -1.196229E-01, -5.570589E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <2.123472E-01, -1.196229E-01, -5.530375E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.073506E-01, -5.002668E-02, -5.603294E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <2.123472E-01, -1.196229E-01, -5.530375E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <2.463635E-01, -5.002668E-02, -5.569883E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.463635E-01, -5.002668E-02, -5.569883E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01> 
      <2.123472E-01, -1.196229E-01, -5.530375E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <2.899162E-01, -1.196229E-01, -5.525716E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.463635E-01, -5.002668E-02, -5.569883E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01> 
      <2.899162E-01, -1.196229E-01, -5.525716E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <3.108103E-01, -5.002668E-02, -5.566012E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.108103E-01, -5.002668E-02, -5.566012E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <2.899162E-01, -1.196229E-01, -5.525716E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <3.862884E-01, -1.196229E-01, -5.55732E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.108103E-01, -5.002668E-02, -5.566012E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <3.862884E-01, -1.196229E-01, -5.55732E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <3.908792E-01, -5.002668E-02, -5.59227E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.908792E-01, -5.002668E-02, -5.59227E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <3.862884E-01, -1.196229E-01, -5.55732E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <4.867918E-01, -1.196229E-01, -5.620377E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.908792E-01, -5.002668E-02, -5.59227E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <4.867918E-01, -1.196229E-01, -5.620377E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <4.743805E-01, -5.002668E-02, -5.64466E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.743805E-01, -5.002668E-02, -5.64466E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <4.867918E-01, -1.196229E-01, -5.620377E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <5.76126E-01, -1.196229E-01, -5.705286E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.743805E-01, -5.002668E-02, -5.64466E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <5.76126E-01, -1.196229E-01, -5.705286E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <5.486019E-01, -5.002668E-02, -5.715204E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.486019E-01, -5.002668E-02, -5.715204E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <5.76126E-01, -1.196229E-01, -5.705286E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <6.406904E-01, -1.196229E-01, -5.79912E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.486019E-01, -5.002668E-02, -5.715204E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <6.406904E-01, -1.196229E-01, -5.79912E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <6.02244E-01, -5.002668E-02, -5.793164E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.406904E-01, -1.196229E-01, -5.79912E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <6.607252E-01, -1.990011E-01, -5.802223E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <6.933323E-01, -1.990011E-01, -5.898498E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.406904E-01, -1.196229E-01, -5.79912E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <6.933323E-01, -1.990011E-01, -5.898498E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <6.706558E-01, -1.196229E-01, -5.887595E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.706558E-01, -1.196229E-01, -5.887595E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <6.933323E-01, -1.990011E-01, -5.898498E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <6.833259E-01, -1.990011E-01, -5.974283E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.706558E-01, -1.196229E-01, -5.887595E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <6.833259E-01, -1.990011E-01, -5.974283E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <6.614602E-01, -1.196229E-01, -5.957241E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.614602E-01, -1.196229E-01, -5.957241E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <6.833259E-01, -1.990011E-01, -5.974283E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <6.322299E-01, -1.990011E-01, -6.018042E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.614602E-01, -1.196229E-01, -5.957241E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <6.322299E-01, -1.990011E-01, -6.018042E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <6.145037E-01, -1.196229E-01, -5.997454E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.145037E-01, -1.196229E-01, -5.997454E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <6.322299E-01, -1.990011E-01, -6.018042E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <5.478227E-01, -1.990011E-01, -6.023111E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.145037E-01, -1.196229E-01, -5.997454E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <5.478227E-01, -1.990011E-01, -6.023111E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <5.369347E-01, -1.196229E-01, -6.002113E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.369347E-01, -1.196229E-01, -6.002113E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <5.478227E-01, -1.990011E-01, -6.023111E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <4.429548E-01, -1.990011E-01, -5.988721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.369347E-01, -1.196229E-01, -6.002113E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <4.429548E-01, -1.990011E-01, -5.988721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <4.405625E-01, -1.196229E-01, -5.970509E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.405625E-01, -1.196229E-01, -5.970509E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <4.429548E-01, -1.990011E-01, -5.988721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <3.335913E-01, -1.990011E-01, -5.920106E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.405625E-01, -1.196229E-01, -5.970509E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <3.335913E-01, -1.990011E-01, -5.920106E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <3.40059E-01, -1.196229E-01, -5.907453E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.40059E-01, -1.196229E-01, -5.907453E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <3.335913E-01, -1.990011E-01, -5.920106E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <2.363818E-01, -1.990011E-01, -5.827713E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.40059E-01, -1.196229E-01, -5.907453E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <2.363818E-01, -1.990011E-01, -5.827713E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <2.507249E-01, -1.196229E-01, -5.822544E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.507249E-01, -1.196229E-01, -5.822544E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <2.363818E-01, -1.990011E-01, -5.827713E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <1.661256E-01, -1.990011E-01, -5.725606E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.507249E-01, -1.196229E-01, -5.822544E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <1.661256E-01, -1.990011E-01, -5.725606E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <1.861604E-01, -1.196229E-01, -5.728709E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.861604E-01, -1.196229E-01, -5.728709E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <1.661256E-01, -1.990011E-01, -5.725606E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <1.335185E-01, -1.990011E-01, -5.629331E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.861604E-01, -1.196229E-01, -5.728709E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <1.335185E-01, -1.990011E-01, -5.629331E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <1.561949E-01, -1.196229E-01, -5.640234E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.561949E-01, -1.196229E-01, -5.640234E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <1.335185E-01, -1.990011E-01, -5.629331E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <1.435248E-01, -1.990011E-01, -5.553546E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.561949E-01, -1.196229E-01, -5.640234E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <1.435248E-01, -1.990011E-01, -5.553546E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <1.653905E-01, -1.196229E-01, -5.570589E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.653905E-01, -1.196229E-01, -5.570589E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <1.435248E-01, -1.990011E-01, -5.553546E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <1.946209E-01, -1.990011E-01, -5.509787E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.653905E-01, -1.196229E-01, -5.570589E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <1.946209E-01, -1.990011E-01, -5.509787E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <2.123472E-01, -1.196229E-01, -5.530375E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.123472E-01, -1.196229E-01, -5.530375E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <1.946209E-01, -1.990011E-01, -5.509787E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <2.790282E-01, -1.990011E-01, -5.504718E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.123472E-01, -1.196229E-01, -5.530375E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <2.790282E-01, -1.990011E-01, -5.504718E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <2.899162E-01, -1.196229E-01, -5.525716E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.899162E-01, -1.196229E-01, -5.525716E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <2.790282E-01, -1.990011E-01, -5.504718E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <3.838961E-01, -1.990011E-01, -5.539108E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.899162E-01, -1.196229E-01, -5.525716E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <3.838961E-01, -1.990011E-01, -5.539108E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <3.862884E-01, -1.196229E-01, -5.55732E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.862884E-01, -1.196229E-01, -5.55732E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <3.838961E-01, -1.990011E-01, -5.539108E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <4.932595E-01, -1.990011E-01, -5.607723E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.862884E-01, -1.196229E-01, -5.55732E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <4.932595E-01, -1.990011E-01, -5.607723E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <4.867918E-01, -1.196229E-01, -5.620377E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.867918E-01, -1.196229E-01, -5.620377E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <4.932595E-01, -1.990011E-01, -5.607723E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <5.904691E-01, -1.990011E-01, -5.700117E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.867918E-01, -1.196229E-01, -5.620377E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <5.904691E-01, -1.990011E-01, -5.700117E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <5.76126E-01, -1.196229E-01, -5.705286E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.76126E-01, -1.196229E-01, -5.705286E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <5.904691E-01, -1.990011E-01, -5.700117E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <6.607252E-01, -1.990011E-01, -5.802223E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.76126E-01, -1.196229E-01, -5.705286E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <6.607252E-01, -1.990011E-01, -5.802223E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <6.406904E-01, -1.196229E-01, -5.79912E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.607252E-01, -1.990011E-01, -5.802223E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <6.607252E-01, -2.817303E-01, -5.802223E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      <6.933323E-01, -2.817303E-01, -5.898498E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.607252E-01, -1.990011E-01, -5.802223E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <6.933323E-01, -2.817303E-01, -5.898498E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <6.933323E-01, -1.990011E-01, -5.898498E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.933323E-01, -1.990011E-01, -5.898498E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <6.933323E-01, -2.817303E-01, -5.898498E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <6.833259E-01, -2.817303E-01, -5.974283E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.933323E-01, -1.990011E-01, -5.898498E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <6.833259E-01, -2.817303E-01, -5.974283E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <6.833259E-01, -1.990011E-01, -5.974283E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.833259E-01, -1.990011E-01, -5.974283E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <6.833259E-01, -2.817303E-01, -5.974283E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <6.322299E-01, -2.817303E-01, -6.018042E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.833259E-01, -1.990011E-01, -5.974283E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <6.322299E-01, -2.817303E-01, -6.018042E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <6.322299E-01, -1.990011E-01, -6.018042E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.322299E-01, -1.990011E-01, -6.018042E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <6.322299E-01, -2.817303E-01, -6.018042E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <5.478227E-01, -2.817303E-01, -6.023111E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.322299E-01, -1.990011E-01, -6.018042E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <5.478227E-01, -2.817303E-01, -6.023111E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <5.478227E-01, -1.990011E-01, -6.023111E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.478227E-01, -1.990011E-01, -6.023111E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <5.478227E-01, -2.817303E-01, -6.023111E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <4.429548E-01, -2.817303E-01, -5.988721E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.478227E-01, -1.990011E-01, -6.023111E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <4.429548E-01, -2.817303E-01, -5.988721E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      <4.429548E-01, -1.990011E-01, -5.988721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.429548E-01, -1.990011E-01, -5.988721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <4.429548E-01, -2.817303E-01, -5.988721E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      <3.335913E-01, -2.817303E-01, -5.920106E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.429548E-01, -1.990011E-01, -5.988721E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <3.335913E-01, -2.817303E-01, -5.920106E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <3.335913E-01, -1.990011E-01, -5.920106E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.335913E-01, -1.990011E-01, -5.920106E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <3.335913E-01, -2.817303E-01, -5.920106E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <2.363818E-01, -2.817303E-01, -5.827713E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.335913E-01, -1.990011E-01, -5.920106E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <2.363818E-01, -2.817303E-01, -5.827713E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <2.363818E-01, -1.990011E-01, -5.827713E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.363818E-01, -1.990011E-01, -5.827713E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <2.363818E-01, -2.817303E-01, -5.827713E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <1.661256E-01, -2.817303E-01, -5.725606E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.363818E-01, -1.990011E-01, -5.827713E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <1.661256E-01, -2.817303E-01, -5.725606E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <1.661256E-01, -1.990011E-01, -5.725606E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.661256E-01, -1.990011E-01, -5.725606E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <1.661256E-01, -2.817303E-01, -5.725606E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <1.335185E-01, -2.817303E-01, -5.629331E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.661256E-01, -1.990011E-01, -5.725606E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <1.335185E-01, -2.817303E-01, -5.629331E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <1.335185E-01, -1.990011E-01, -5.629331E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.335185E-01, -1.990011E-01, -5.629331E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <1.335185E-01, -2.817303E-01, -5.629331E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <1.435248E-01, -2.817303E-01, -5.553546E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.335185E-01, -1.990011E-01, -5.629331E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <1.435248E-01, -2.817303E-01, -5.553546E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <1.435248E-01, -1.990011E-01, -5.553546E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.435248E-01, -1.990011E-01, -5.553546E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <1.435248E-01, -2.817303E-01, -5.553546E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <1.946209E-01, -2.817303E-01, -5.509787E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.435248E-01, -1.990011E-01, -5.553546E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <1.946209E-01, -2.817303E-01, -5.509787E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <1.946209E-01, -1.990011E-01, -5.509787E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.946209E-01, -1.990011E-01, -5.509787E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <1.946209E-01, -2.817303E-01, -5.509787E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <2.790282E-01, -2.817303E-01, -5.504718E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.946209E-01, -1.990011E-01, -5.509787E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <2.790282E-01, -2.817303E-01, -5.504718E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <2.790282E-01, -1.990011E-01, -5.504718E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.790282E-01, -1.990011E-01, -5.504718E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <2.790282E-01, -2.817303E-01, -5.504718E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <3.838961E-01, -2.817303E-01, -5.539108E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.790282E-01, -1.990011E-01, -5.504718E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <3.838961E-01, -2.817303E-01, -5.539108E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <3.838961E-01, -1.990011E-01, -5.539108E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.838961E-01, -1.990011E-01, -5.539108E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <3.838961E-01, -2.817303E-01, -5.539108E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <4.932595E-01, -2.817303E-01, -5.607723E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.838961E-01, -1.990011E-01, -5.539108E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <4.932595E-01, -2.817303E-01, -5.607723E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <4.932595E-01, -1.990011E-01, -5.607723E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.932595E-01, -1.990011E-01, -5.607723E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <4.932595E-01, -2.817303E-01, -5.607723E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <5.904691E-01, -2.817303E-01, -5.700117E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.932595E-01, -1.990011E-01, -5.607723E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <5.904691E-01, -2.817303E-01, -5.700117E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <5.904691E-01, -1.990011E-01, -5.700117E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.904691E-01, -1.990011E-01, -5.700117E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <5.904691E-01, -2.817303E-01, -5.700117E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <6.607252E-01, -2.817303E-01, -5.802223E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.904691E-01, -1.990011E-01, -5.700117E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <6.607252E-01, -2.817303E-01, -5.802223E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      <6.607252E-01, -1.990011E-01, -5.802223E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.607252E-01, -2.817303E-01, -5.802223E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02> 
      <6.406903E-01, -3.611084E-01, -5.79912E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <6.706558E-01, -3.611084E-01, -5.887595E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.607252E-01, -2.817303E-01, -5.802223E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02> 
      <6.706558E-01, -3.611084E-01, -5.887595E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <6.933323E-01, -2.817303E-01, -5.898498E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.933323E-01, -2.817303E-01, -5.898498E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <6.706558E-01, -3.611084E-01, -5.887595E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <6.614602E-01, -3.611084E-01, -5.957241E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.933323E-01, -2.817303E-01, -5.898498E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <6.614602E-01, -3.611084E-01, -5.957241E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <6.833259E-01, -2.817303E-01, -5.974283E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.833259E-01, -2.817303E-01, -5.974283E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <6.614602E-01, -3.611084E-01, -5.957241E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <6.145037E-01, -3.611084E-01, -5.997454E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.833259E-01, -2.817303E-01, -5.974283E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <6.145037E-01, -3.611084E-01, -5.997454E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      <6.322299E-01, -2.817303E-01, -6.018042E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.322299E-01, -2.817303E-01, -6.018042E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <6.145037E-01, -3.611084E-01, -5.997454E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      <5.369347E-01, -3.611084E-01, -6.002113E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.322299E-01, -2.817303E-01, -6.018042E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <5.369347E-01, -3.611084E-01, -6.002113E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      <5.478227E-01, -2.817303E-01, -6.023111E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.478227E-01, -2.817303E-01, -6.023111E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <5.369347E-01, -3.611084E-01, -6.002113E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      <4.405625E-01, -3.611084E-01, -5.970509E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.478227E-01, -2.817303E-01, -6.023111E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <4.405625E-01, -3.611084E-01, -5.970509E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <4.429548E-01, -2.817303E-01, -5.988721E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.429548E-01, -2.817303E-01, -5.988721E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01> 
      <4.405625E-01, -3.611084E-01, -5.970509E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <3.40059E-01, -3.611084E-01, -5.907453E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.429548E-01, -2.817303E-01, -5.988721E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01> 
      <3.40059E-01, -3.611084E-01, -5.907453E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <3.335913E-01, -2.817303E-01, -5.920106E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.335913E-01, -2.817303E-01, -5.920106E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <3.40059E-01, -3.611084E-01, -5.907453E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <2.507249E-01, -3.611084E-01, -5.822544E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.335913E-01, -2.817303E-01, -5.920106E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <2.507249E-01, -3.611084E-01, -5.822544E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <2.363818E-01, -2.817303E-01, -5.827713E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.363818E-01, -2.817303E-01, -5.827713E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <2.507249E-01, -3.611084E-01, -5.822544E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <1.861604E-01, -3.611084E-01, -5.728709E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.363818E-01, -2.817303E-01, -5.827713E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <1.861604E-01, -3.611084E-01, -5.728709E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <1.661256E-01, -2.817303E-01, -5.725606E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.661256E-01, -2.817303E-01, -5.725606E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <1.861604E-01, -3.611084E-01, -5.728709E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <1.56195E-01, -3.611084E-01, -5.640234E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.661256E-01, -2.817303E-01, -5.725606E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <1.56195E-01, -3.611084E-01, -5.640234E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <1.335185E-01, -2.817303E-01, -5.629331E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.335185E-01, -2.817303E-01, -5.629331E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <1.56195E-01, -3.611084E-01, -5.640234E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <1.653906E-01, -3.611084E-01, -5.570589E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.335185E-01, -2.817303E-01, -5.629331E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <1.653906E-01, -3.611084E-01, -5.570589E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <1.435248E-01, -2.817303E-01, -5.553546E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.435248E-01, -2.817303E-01, -5.553546E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <1.653906E-01, -3.611084E-01, -5.570589E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <2.123472E-01, -3.611084E-01, -5.530375E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.435248E-01, -2.817303E-01, -5.553546E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <2.123472E-01, -3.611084E-01, -5.530375E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      <1.946209E-01, -2.817303E-01, -5.509787E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.946209E-01, -2.817303E-01, -5.509787E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <2.123472E-01, -3.611084E-01, -5.530375E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      <2.899162E-01, -3.611084E-01, -5.525716E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.946209E-01, -2.817303E-01, -5.509787E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <2.899162E-01, -3.611084E-01, -5.525716E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      <2.790282E-01, -2.817303E-01, -5.504718E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.790282E-01, -2.817303E-01, -5.504718E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <2.899162E-01, -3.611084E-01, -5.525716E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      <3.862884E-01, -3.611084E-01, -5.55732E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.790282E-01, -2.817303E-01, -5.504718E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <3.862884E-01, -3.611084E-01, -5.55732E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      <3.838961E-01, -2.817303E-01, -5.539108E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.838961E-01, -2.817303E-01, -5.539108E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <3.862884E-01, -3.611084E-01, -5.55732E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      <4.867918E-01, -3.611084E-01, -5.620377E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.838961E-01, -2.817303E-01, -5.539108E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <4.867918E-01, -3.611084E-01, -5.620377E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <4.932595E-01, -2.817303E-01, -5.607723E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.932595E-01, -2.817303E-01, -5.607723E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <4.867918E-01, -3.611084E-01, -5.620377E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <5.76126E-01, -3.611084E-01, -5.705286E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.932595E-01, -2.817303E-01, -5.607723E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <5.76126E-01, -3.611084E-01, -5.705286E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <5.904691E-01, -2.817303E-01, -5.700117E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.904691E-01, -2.817303E-01, -5.700117E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <5.76126E-01, -3.611084E-01, -5.705286E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <6.406903E-01, -3.611084E-01, -5.79912E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.904691E-01, -2.817303E-01, -5.700117E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <6.406903E-01, -3.611084E-01, -5.79912E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <6.607252E-01, -2.817303E-01, -5.802223E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.406903E-01, -3.611084E-01, -5.79912E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <6.02244E-01, -4.307047E-01, -5.793164E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <6.271402E-01, -4.307047E-01, -5.866672E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.406903E-01, -3.611084E-01, -5.79912E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <6.271402E-01, -4.307047E-01, -5.866672E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <6.706558E-01, -3.611084E-01, -5.887595E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.706558E-01, -3.611084E-01, -5.887595E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <6.271402E-01, -4.307047E-01, -5.866672E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <6.195002E-01, -4.307047E-01, -5.924535E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.706558E-01, -3.611084E-01, -5.887595E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <6.195002E-01, -4.307047E-01, -5.924535E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <6.614602E-01, -3.611084E-01, -5.957241E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.614602E-01, -3.611084E-01, -5.957241E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <6.195002E-01, -4.307047E-01, -5.924535E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <5.804872E-01, -4.307047E-01, -5.957946E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.614602E-01, -3.611084E-01, -5.957241E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <5.804872E-01, -4.307047E-01, -5.957946E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <6.145037E-01, -3.611084E-01, -5.997454E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.145037E-01, -3.611084E-01, -5.997454E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01> 
      <5.804872E-01, -4.307047E-01, -5.957946E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <5.160406E-01, -4.307047E-01, -5.961817E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.145037E-01, -3.611084E-01, -5.997454E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01> 
      <5.160406E-01, -4.307047E-01, -5.961817E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <5.369347E-01, -3.611084E-01, -6.002113E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.369347E-01, -3.611084E-01, -6.002113E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01> 
      <5.160406E-01, -4.307047E-01, -5.961817E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <4.359717E-01, -4.307047E-01, -5.935559E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.369347E-01, -3.611084E-01, -6.002113E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01> 
      <4.359717E-01, -4.307047E-01, -5.935559E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <4.405625E-01, -3.611084E-01, -5.970509E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.405625E-01, -3.611084E-01, -5.970509E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <4.359717E-01, -4.307047E-01, -5.935559E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <3.524704E-01, -4.307047E-01, -5.88317E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.405625E-01, -3.611084E-01, -5.970509E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <3.524704E-01, -4.307047E-01, -5.88317E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <3.40059E-01, -3.611084E-01, -5.907453E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.40059E-01, -3.611084E-01, -5.907453E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <3.524704E-01, -4.307047E-01, -5.88317E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <2.78249E-01, -4.307047E-01, -5.812625E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.40059E-01, -3.611084E-01, -5.907453E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <2.78249E-01, -4.307047E-01, -5.812625E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <2.507249E-01, -3.611084E-01, -5.822544E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.507249E-01, -3.611084E-01, -5.822544E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <2.78249E-01, -4.307047E-01, -5.812625E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <2.246069E-01, -4.307047E-01, -5.734665E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.507249E-01, -3.611084E-01, -5.822544E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <2.246069E-01, -4.307047E-01, -5.734665E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <1.861604E-01, -3.611084E-01, -5.728709E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.861604E-01, -3.611084E-01, -5.728709E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <2.246069E-01, -4.307047E-01, -5.734665E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <1.997107E-01, -4.307047E-01, -5.661157E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.861604E-01, -3.611084E-01, -5.728709E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <1.997107E-01, -4.307047E-01, -5.661157E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <1.56195E-01, -3.611084E-01, -5.640234E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.56195E-01, -3.611084E-01, -5.640234E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <1.997107E-01, -4.307047E-01, -5.661157E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <2.073506E-01, -4.307047E-01, -5.603294E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.56195E-01, -3.611084E-01, -5.640234E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <2.073506E-01, -4.307047E-01, -5.603294E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <1.653906E-01, -3.611084E-01, -5.570589E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.653906E-01, -3.611084E-01, -5.570589E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <2.073506E-01, -4.307047E-01, -5.603294E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <2.463637E-01, -4.307047E-01, -5.569883E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.653906E-01, -3.611084E-01, -5.570589E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <2.463637E-01, -4.307047E-01, -5.569883E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <2.123472E-01, -3.611084E-01, -5.530375E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.123472E-01, -3.611084E-01, -5.530375E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01> 
      <2.463637E-01, -4.307047E-01, -5.569883E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <3.108103E-01, -4.307047E-01, -5.566012E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.123472E-01, -3.611084E-01, -5.530375E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01> 
      <3.108103E-01, -4.307047E-01, -5.566012E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <2.899162E-01, -3.611084E-01, -5.525716E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.899162E-01, -3.611084E-01, -5.525716E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01> 
      <3.108103E-01, -4.307047E-01, -5.566012E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <3.908792E-01, -4.307047E-01, -5.59227E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.899162E-01, -3.611084E-01, -5.525716E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01> 
      <3.908792E-01, -4.307047E-01, -5.59227E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <3.862884E-01, -3.611084E-01, -5.55732E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.862884E-01, -3.611084E-01, -5.55732E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01> 
      <3.908792E-01, -4.307047E-01, -5.59227E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <4.743805E-01, -4.307047E-01, -5.64466E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.862884E-01, -3.611084E-01, -5.55732E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01> 
      <4.743805E-01, -4.307047E-01, -5.64466E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <4.867918E-01, -3.611084E-01, -5.620377E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.867918E-01, -3.611084E-01, -5.620377E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <4.743805E-01, -4.307047E-01, -5.64466E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <5.486019E-01, -4.307047E-01, -5.715204E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.867918E-01, -3.611084E-01, -5.620377E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <5.486019E-01, -4.307047E-01, -5.715204E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <5.76126E-01, -3.611084E-01, -5.705286E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.76126E-01, -3.611084E-01, -5.705286E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <5.486019E-01, -4.307047E-01, -5.715204E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <6.02244E-01, -4.307047E-01, -5.793164E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.76126E-01, -3.611084E-01, -5.705286E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <6.02244E-01, -4.307047E-01, -5.793164E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <6.406903E-01, -3.611084E-01, -5.79912E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.02244E-01, -4.307047E-01, -5.793164E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <5.485006E-01, -4.848807E-01, -5.784839E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <5.663106E-01, -4.848807E-01, -5.837424E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.02244E-01, -4.307047E-01, -5.793164E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <5.663106E-01, -4.848807E-01, -5.837424E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <6.271402E-01, -4.307047E-01, -5.866672E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.271402E-01, -4.307047E-01, -5.866672E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <5.663106E-01, -4.848807E-01, -5.837424E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <5.608451E-01, -4.848807E-01, -5.878818E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.271402E-01, -4.307047E-01, -5.866672E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <5.608451E-01, -4.848807E-01, -5.878818E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <6.195002E-01, -4.307047E-01, -5.924535E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.195002E-01, -4.307047E-01, -5.924535E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <5.608451E-01, -4.848807E-01, -5.878818E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <5.329364E-01, -4.848807E-01, -5.902719E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.195002E-01, -4.307047E-01, -5.924535E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <5.329364E-01, -4.848807E-01, -5.902719E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <5.804872E-01, -4.307047E-01, -5.957946E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.804872E-01, -4.307047E-01, -5.957946E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <5.329364E-01, -4.848807E-01, -5.902719E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <4.868333E-01, -4.848807E-01, -5.905488E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.804872E-01, -4.307047E-01, -5.957946E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <4.868333E-01, -4.848807E-01, -5.905488E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <5.160406E-01, -4.307047E-01, -5.961817E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.160406E-01, -4.307047E-01, -5.961817E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <4.868333E-01, -4.848807E-01, -5.905488E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <4.295543E-01, -4.848807E-01, -5.886704E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.160406E-01, -4.307047E-01, -5.961817E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <4.295543E-01, -4.848807E-01, -5.886704E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <4.359717E-01, -4.307047E-01, -5.935559E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.359717E-01, -4.307047E-01, -5.935559E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <4.295543E-01, -4.848807E-01, -5.886704E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <3.6982E-01, -4.848807E-01, -5.849226E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.359717E-01, -4.307047E-01, -5.935559E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <3.6982E-01, -4.848807E-01, -5.849226E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <3.524704E-01, -4.307047E-01, -5.88317E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.524704E-01, -4.307047E-01, -5.88317E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <3.6982E-01, -4.848807E-01, -5.849226E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <3.167242E-01, -4.848807E-01, -5.798761E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.524704E-01, -4.307047E-01, -5.88317E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <3.167242E-01, -4.848807E-01, -5.798761E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <2.78249E-01, -4.307047E-01, -5.812625E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.78249E-01, -4.307047E-01, -5.812625E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <3.167242E-01, -4.848807E-01, -5.798761E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <2.783502E-01, -4.848807E-01, -5.74299E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.78249E-01, -4.307047E-01, -5.812625E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <2.783502E-01, -4.848807E-01, -5.74299E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <2.246069E-01, -4.307047E-01, -5.734665E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.246069E-01, -4.307047E-01, -5.734665E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <2.783502E-01, -4.848807E-01, -5.74299E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <2.605403E-01, -4.848807E-01, -5.690405E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.246069E-01, -4.307047E-01, -5.734665E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <2.605403E-01, -4.848807E-01, -5.690405E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <1.997107E-01, -4.307047E-01, -5.661157E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.997107E-01, -4.307047E-01, -5.661157E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <2.605403E-01, -4.848807E-01, -5.690405E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <2.660056E-01, -4.848807E-01, -5.649011E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.997107E-01, -4.307047E-01, -5.661157E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <2.660056E-01, -4.848807E-01, -5.649011E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <2.073506E-01, -4.307047E-01, -5.603294E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.073506E-01, -4.307047E-01, -5.603294E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <2.660056E-01, -4.848807E-01, -5.649011E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <2.939144E-01, -4.848807E-01, -5.62511E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.073506E-01, -4.307047E-01, -5.603294E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <2.939144E-01, -4.848807E-01, -5.62511E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <2.463637E-01, -4.307047E-01, -5.569883E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.463637E-01, -4.307047E-01, -5.569883E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <2.939144E-01, -4.848807E-01, -5.62511E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <3.400176E-01, -4.848807E-01, -5.622341E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.463637E-01, -4.307047E-01, -5.569883E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <3.400176E-01, -4.848807E-01, -5.622341E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <3.108103E-01, -4.307047E-01, -5.566012E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.108103E-01, -4.307047E-01, -5.566012E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <3.400176E-01, -4.848807E-01, -5.622341E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <3.972965E-01, -4.848807E-01, -5.641125E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.108103E-01, -4.307047E-01, -5.566012E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <3.972965E-01, -4.848807E-01, -5.641125E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <3.908792E-01, -4.307047E-01, -5.59227E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.908792E-01, -4.307047E-01, -5.59227E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <3.972965E-01, -4.848807E-01, -5.641125E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <4.570309E-01, -4.848807E-01, -5.678603E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.908792E-01, -4.307047E-01, -5.59227E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <4.570309E-01, -4.848807E-01, -5.678603E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <4.743805E-01, -4.307047E-01, -5.64466E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.743805E-01, -4.307047E-01, -5.64466E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <4.570309E-01, -4.848807E-01, -5.678603E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <5.101267E-01, -4.848807E-01, -5.729068E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.743805E-01, -4.307047E-01, -5.64466E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <5.101267E-01, -4.848807E-01, -5.729068E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <5.486019E-01, -4.307047E-01, -5.715204E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.486019E-01, -4.307047E-01, -5.715204E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <5.101267E-01, -4.848807E-01, -5.729068E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <5.485006E-01, -4.848807E-01, -5.784839E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.486019E-01, -4.307047E-01, -5.715204E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <5.485006E-01, -4.848807E-01, -5.784839E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <6.02244E-01, -4.307047E-01, -5.793164E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.485006E-01, -4.848807E-01, -5.784839E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <4.838142E-01, -5.192477E-01, -5.774818E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <4.930952E-01, -5.192477E-01, -5.802221E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.485006E-01, -4.848807E-01, -5.784839E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <4.930952E-01, -5.192477E-01, -5.802221E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <5.663106E-01, -4.848807E-01, -5.837424E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.663106E-01, -4.848807E-01, -5.837424E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <4.930952E-01, -5.192477E-01, -5.802221E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <4.902471E-01, -5.192477E-01, -5.823792E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.663106E-01, -4.848807E-01, -5.837424E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <4.902471E-01, -5.192477E-01, -5.823792E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <5.608451E-01, -4.848807E-01, -5.878818E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.608451E-01, -4.848807E-01, -5.878818E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <4.902471E-01, -5.192477E-01, -5.823792E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <4.757037E-01, -5.192477E-01, -5.836247E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.608451E-01, -4.848807E-01, -5.878818E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <4.757037E-01, -5.192477E-01, -5.836247E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <5.329364E-01, -4.848807E-01, -5.902719E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.329364E-01, -4.848807E-01, -5.902719E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <4.757037E-01, -5.192477E-01, -5.836247E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <4.516789E-01, -5.192477E-01, -5.83769E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.329364E-01, -4.848807E-01, -5.902719E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <4.516789E-01, -5.192477E-01, -5.83769E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <4.868333E-01, -4.848807E-01, -5.905488E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.868333E-01, -4.848807E-01, -5.905488E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <4.516789E-01, -5.192477E-01, -5.83769E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <4.218304E-01, -5.192477E-01, -5.827901E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.868333E-01, -4.848807E-01, -5.905488E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <4.218304E-01, -5.192477E-01, -5.827901E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <4.295543E-01, -4.848807E-01, -5.886704E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.295543E-01, -4.848807E-01, -5.886704E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <4.218304E-01, -5.192477E-01, -5.827901E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <3.907023E-01, -5.192477E-01, -5.808371E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.295543E-01, -4.848807E-01, -5.886704E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <3.907023E-01, -5.192477E-01, -5.808371E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <3.6982E-01, -4.848807E-01, -5.849226E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.6982E-01, -4.848807E-01, -5.849226E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <3.907023E-01, -5.192477E-01, -5.808371E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <3.630336E-01, -5.192477E-01, -5.782073E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.6982E-01, -4.848807E-01, -5.849226E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <3.630336E-01, -5.192477E-01, -5.782073E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <3.167242E-01, -4.848807E-01, -5.798761E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.167242E-01, -4.848807E-01, -5.798761E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <3.630336E-01, -5.192477E-01, -5.782073E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <3.430366E-01, -5.192477E-01, -5.753011E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <3.167242E-01, -4.848807E-01, -5.798761E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <3.430366E-01, -5.192477E-01, -5.753011E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <2.783502E-01, -4.848807E-01, -5.74299E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.783502E-01, -4.848807E-01, -5.74299E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <3.430366E-01, -5.192477E-01, -5.753011E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <3.337557E-01, -5.192477E-01, -5.725608E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <2.783502E-01, -4.848807E-01, -5.74299E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <3.337557E-01, -5.192477E-01, -5.725608E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <2.605403E-01, -4.848807E-01, -5.690405E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.605403E-01, -4.848807E-01, -5.690405E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <3.337557E-01, -5.192477E-01, -5.725608E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <3.366038E-01, -5.192477E-01, -5.704037E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.605403E-01, -4.848807E-01, -5.690405E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <3.366038E-01, -5.192477E-01, -5.704037E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <2.660056E-01, -4.848807E-01, -5.649011E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.660056E-01, -4.848807E-01, -5.649011E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <3.366038E-01, -5.192477E-01, -5.704037E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <3.511472E-01, -5.192477E-01, -5.691582E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.660056E-01, -4.848807E-01, -5.649011E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <3.511472E-01, -5.192477E-01, -5.691582E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <2.939144E-01, -4.848807E-01, -5.62511E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.939144E-01, -4.848807E-01, -5.62511E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <3.511472E-01, -5.192477E-01, -5.691582E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <3.75172E-01, -5.192477E-01, -5.69014E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <2.939144E-01, -4.848807E-01, -5.62511E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <3.75172E-01, -5.192477E-01, -5.69014E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <3.400176E-01, -4.848807E-01, -5.622341E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.400176E-01, -4.848807E-01, -5.622341E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <3.75172E-01, -5.192477E-01, -5.69014E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <4.050205E-01, -5.192477E-01, -5.699928E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.400176E-01, -4.848807E-01, -5.622341E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <4.050205E-01, -5.192477E-01, -5.699928E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <3.972965E-01, -4.848807E-01, -5.641125E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.972965E-01, -4.848807E-01, -5.641125E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <4.050205E-01, -5.192477E-01, -5.699928E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <4.361486E-01, -5.192477E-01, -5.719458E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.972965E-01, -4.848807E-01, -5.641125E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <4.361486E-01, -5.192477E-01, -5.719458E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <4.570309E-01, -4.848807E-01, -5.678603E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.570309E-01, -4.848807E-01, -5.678603E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <4.361486E-01, -5.192477E-01, -5.719458E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <4.638173E-01, -5.192477E-01, -5.745756E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.570309E-01, -4.848807E-01, -5.678603E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <4.638173E-01, -5.192477E-01, -5.745756E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <5.101267E-01, -4.848807E-01, -5.729068E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.101267E-01, -4.848807E-01, -5.729068E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <4.638173E-01, -5.192477E-01, -5.745756E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <4.838142E-01, -5.192477E-01, -5.774818E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <5.101267E-01, -4.848807E-01, -5.729068E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <4.838142E-01, -5.192477E-01, -5.774818E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <5.485006E-01, -4.848807E-01, -5.784839E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.838142E-01, -5.192477E-01, -5.774818E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.930952E-01, -5.192477E-01, -5.802221E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.930952E-01, -5.192477E-01, -5.802221E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.902471E-01, -5.192477E-01, -5.823792E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.902471E-01, -5.192477E-01, -5.823792E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.757037E-01, -5.192477E-01, -5.836247E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.757037E-01, -5.192477E-01, -5.836247E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.516789E-01, -5.192477E-01, -5.83769E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.516789E-01, -5.192477E-01, -5.83769E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.218304E-01, -5.192477E-01, -5.827901E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.218304E-01, -5.192477E-01, -5.827901E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.907023E-01, -5.192477E-01, -5.808371E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.907023E-01, -5.192477E-01, -5.808371E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.630336E-01, -5.192477E-01, -5.782073E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.630336E-01, -5.192477E-01, -5.782073E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.430366E-01, -5.192477E-01, -5.753011E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <3.430366E-01, -5.192477E-01, -5.753011E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.337557E-01, -5.192477E-01, -5.725608E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <3.337557E-01, -5.192477E-01, -5.725608E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.366038E-01, -5.192477E-01, -5.704037E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.366038E-01, -5.192477E-01, -5.704037E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.511472E-01, -5.192477E-01, -5.691582E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.511472E-01, -5.192477E-01, -5.691582E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <3.75172E-01, -5.192477E-01, -5.69014E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <3.75172E-01, -5.192477E-01, -5.69014E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.050205E-01, -5.192477E-01, -5.699928E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.050205E-01, -5.192477E-01, -5.699928E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.361486E-01, -5.192477E-01, -5.719458E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <4.361486E-01, -5.192477E-01, -5.719458E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.638173E-01, -5.192477E-01, -5.745756E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <4.638173E-01, -5.192477E-01, -5.745756E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02> 
      <4.134253E-01, -5.310213E-01, -5.763915E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <4.838142E-01, -5.192477E-01, -5.774818E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
}
}
 
// Sphere
object {
union {
   smooth_triangle {
      <8.898296E-01, 5.265899E-03, -6.069681E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <8.982112E-01, 3.607491E-03, -6.098403E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.982112E-01, 3.607491E-03, -6.098403E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <8.956391E-01, 4.116399E-03, -6.121013E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.956391E-01, 4.116399E-03, -6.121013E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <8.825051E-01, 6.715167E-03, -6.134067E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.825051E-01, 6.715167E-03, -6.134067E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <8.608088E-01, 1.100819E-02, -6.13558E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.608088E-01, 1.100819E-02, -6.13558E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <8.338532E-01, 1.634179E-02, -6.12532E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.338532E-01, 1.634179E-02, -6.12532E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <8.05742E-01, 2.19041E-02, -6.104849E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.05742E-01, 2.19041E-02, -6.104849E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <7.80755E-01, 2.684822E-02, -6.077285E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.80755E-01, 2.684822E-02, -6.077285E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <7.626962E-01, 3.04215E-02, -6.046823E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.626962E-01, 3.04215E-02, -6.046823E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <7.543148E-01, 3.207985E-02, -6.018101E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.543148E-01, 3.207985E-02, -6.018101E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <7.568868E-01, 3.157099E-02, -5.995491E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.568868E-01, 3.157099E-02, -5.995491E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <7.700208E-01, 2.897219E-02, -5.982437E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.700208E-01, 2.897219E-02, -5.982437E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <7.917171E-01, 2.467922E-02, -5.980924E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.917171E-01, 2.467922E-02, -5.980924E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <8.186727E-01, 1.934556E-02, -5.991184E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.186727E-01, 1.934556E-02, -5.991184E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <8.467838E-01, 1.378328E-02, -6.011654E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.467838E-01, 1.378328E-02, -6.011654E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <8.717709E-01, 8.839173E-03, -6.039218E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.717709E-01, 8.839173E-03, -6.039218E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <8.898296E-01, 5.265899E-03, -6.069681E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      <8.275007E-01, 2.949544E-02, -6.058252E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.898296E-01, 5.265899E-03, -6.069681E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <9.446335E-01, -4.030433E-02, -6.080184E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <9.607176E-01, -4.34868E-02, -6.135301E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.898296E-01, 5.265899E-03, -6.069681E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <9.607176E-01, -4.34868E-02, -6.135301E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <8.982112E-01, 3.607491E-03, -6.098403E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.982112E-01, 3.607491E-03, -6.098403E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <9.607176E-01, -4.34868E-02, -6.135301E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <9.557818E-01, -4.251017E-02, -6.178689E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.982112E-01, 3.607491E-03, -6.098403E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <9.557818E-01, -4.251017E-02, -6.178689E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <8.956391E-01, 4.116399E-03, -6.121013E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.956391E-01, 4.116399E-03, -6.121013E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <9.557818E-01, -4.251017E-02, -6.178689E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <9.305781E-01, -3.752316E-02, -6.203741E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.956391E-01, 4.116399E-03, -6.121013E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <9.305781E-01, -3.752316E-02, -6.203741E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <8.825051E-01, 6.715167E-03, -6.134067E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.825051E-01, 6.715167E-03, -6.134067E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <9.305781E-01, -3.752316E-02, -6.203741E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <8.889433E-01, -2.928498E-02, -6.206643E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.825051E-01, 6.715167E-03, -6.134067E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <8.889433E-01, -2.928498E-02, -6.206643E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <8.608088E-01, 1.100819E-02, -6.13558E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.608088E-01, 1.100819E-02, -6.13558E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <8.889433E-01, -2.928498E-02, -6.206643E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <8.372158E-01, -1.904981E-02, -6.186954E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.608088E-01, 1.100819E-02, -6.13558E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <8.372158E-01, -1.904981E-02, -6.186954E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <8.338532E-01, 1.634179E-02, -6.12532E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.338532E-01, 1.634179E-02, -6.12532E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <8.372158E-01, -1.904981E-02, -6.186954E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <7.832708E-01, -8.375849E-03, -6.147672E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.338532E-01, 1.634179E-02, -6.12532E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <7.832708E-01, -8.375849E-03, -6.147672E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <8.05742E-01, 2.19041E-02, -6.104849E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.05742E-01, 2.19041E-02, -6.104849E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <7.832708E-01, -8.375849E-03, -6.147672E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <7.35321E-01, 1.111838E-03, -6.094776E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.05742E-01, 2.19041E-02, -6.104849E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <7.35321E-01, 1.111838E-03, -6.094776E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <7.80755E-01, 2.684822E-02, -6.077285E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.80755E-01, 2.684822E-02, -6.077285E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <7.35321E-01, 1.111838E-03, -6.094776E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <7.006663E-01, 7.968887E-03, -6.03632E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.80755E-01, 2.684822E-02, -6.077285E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <7.006663E-01, 7.968887E-03, -6.03632E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <7.626962E-01, 3.04215E-02, -6.046823E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.626962E-01, 3.04215E-02, -6.046823E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <7.006663E-01, 7.968887E-03, -6.03632E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <6.845825E-01, 1.115138E-02, -5.981203E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.626962E-01, 3.04215E-02, -6.046823E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <6.845825E-01, 1.115138E-02, -5.981203E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <7.543148E-01, 3.207985E-02, -6.018101E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.543148E-01, 3.207985E-02, -6.018101E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <6.845825E-01, 1.115138E-02, -5.981203E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <6.895182E-01, 1.017475E-02, -5.937815E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.543148E-01, 3.207985E-02, -6.018101E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <6.895182E-01, 1.017475E-02, -5.937815E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <7.568868E-01, 3.157099E-02, -5.995491E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.568868E-01, 3.157099E-02, -5.995491E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <6.895182E-01, 1.017475E-02, -5.937815E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <7.147219E-01, 5.187735E-03, -5.912763E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.568868E-01, 3.157099E-02, -5.995491E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <7.147219E-01, 5.187735E-03, -5.912763E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <7.700208E-01, 2.897219E-02, -5.982437E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.700208E-01, 2.897219E-02, -5.982437E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <7.147219E-01, 5.187735E-03, -5.912763E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <7.56357E-01, -3.050464E-03, -5.909861E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.700208E-01, 2.897219E-02, -5.982437E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <7.56357E-01, -3.050464E-03, -5.909861E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <7.917171E-01, 2.467922E-02, -5.980924E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.917171E-01, 2.467922E-02, -5.980924E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <7.56357E-01, -3.050464E-03, -5.909861E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <8.080843E-01, -1.328564E-02, -5.929549E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.917171E-01, 2.467922E-02, -5.980924E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <8.080843E-01, -1.328564E-02, -5.929549E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <8.186727E-01, 1.934556E-02, -5.991184E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.186727E-01, 1.934556E-02, -5.991184E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <8.080843E-01, -1.328564E-02, -5.929549E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <8.620292E-01, -2.395956E-02, -5.968832E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.186727E-01, 1.934556E-02, -5.991184E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <8.620292E-01, -2.395956E-02, -5.968832E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <8.467838E-01, 1.378328E-02, -6.011654E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.467838E-01, 1.378328E-02, -6.011654E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <8.620292E-01, -2.395956E-02, -5.968832E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <9.099791E-01, -3.34473E-02, -6.021728E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.467838E-01, 1.378328E-02, -6.011654E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <9.099791E-01, -3.34473E-02, -6.021728E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <8.717709E-01, 8.839173E-03, -6.039218E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.717709E-01, 8.839173E-03, -6.039218E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <9.099791E-01, -3.34473E-02, -6.021728E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <9.446335E-01, -4.030433E-02, -6.080184E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.717709E-01, 8.839173E-03, -6.039218E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <9.446335E-01, -4.030433E-02, -6.080184E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <8.898296E-01, 5.265899E-03, -6.069681E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.446335E-01, -4.030433E-02, -6.080184E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <9.874728E-01, -1.035233E-01, -6.08891E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <1.009956E+00, -1.07972E-01, -6.165957E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.446335E-01, -4.030433E-02, -6.080184E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <1.009956E+00, -1.07972E-01, -6.165957E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <9.607176E-01, -4.34868E-02, -6.135301E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.607176E-01, -4.34868E-02, -6.135301E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <1.009956E+00, -1.07972E-01, -6.165957E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <1.003057E+00, -1.066068E-01, -6.226607E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.607176E-01, -4.34868E-02, -6.135301E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <1.003057E+00, -1.066068E-01, -6.226607E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <9.557818E-01, -4.251017E-02, -6.178689E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.557818E-01, -4.251017E-02, -6.178689E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <1.003057E+00, -1.066068E-01, -6.226607E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <9.678247E-01, -9.963559E-02, -6.261627E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.557818E-01, -4.251017E-02, -6.178689E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <9.678247E-01, -9.963559E-02, -6.261627E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <9.305781E-01, -3.752316E-02, -6.203741E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.305781E-01, -3.752316E-02, -6.203741E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <9.678247E-01, -9.963559E-02, -6.261627E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <9.096242E-01, -8.81196E-02, -6.265685E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.305781E-01, -3.752316E-02, -6.203741E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <9.096242E-01, -8.81196E-02, -6.265685E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <8.889433E-01, -2.928498E-02, -6.206643E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.889433E-01, -2.928498E-02, -6.206643E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <9.096242E-01, -8.81196E-02, -6.265685E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <8.373157E-01, -7.381209E-02, -6.238162E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.889433E-01, -2.928498E-02, -6.206643E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <8.373157E-01, -7.381209E-02, -6.238162E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <8.372158E-01, -1.904981E-02, -6.186954E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.372158E-01, -1.904981E-02, -6.186954E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <8.373157E-01, -7.381209E-02, -6.238162E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <7.619073E-01, -5.889123E-02, -6.18325E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.372158E-01, -1.904981E-02, -6.186954E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <7.619073E-01, -5.889123E-02, -6.18325E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <7.832708E-01, -8.375849E-03, -6.147672E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.832708E-01, -8.375849E-03, -6.147672E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <7.619073E-01, -5.889123E-02, -6.18325E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <6.948794E-01, -4.562857E-02, -6.109309E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.832708E-01, -8.375849E-03, -6.147672E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <6.948794E-01, -4.562857E-02, -6.109309E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <7.35321E-01, 1.111838E-03, -6.094776E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.35321E-01, 1.111838E-03, -6.094776E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <6.948794E-01, -4.562857E-02, -6.109309E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <6.464363E-01, -3.604324E-02, -6.027594E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.35321E-01, 1.111838E-03, -6.094776E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <6.464363E-01, -3.604324E-02, -6.027594E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <7.006663E-01, 7.968887E-03, -6.03632E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.006663E-01, 7.968887E-03, -6.03632E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <6.464363E-01, -3.604324E-02, -6.027594E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <6.23953E-01, -3.159454E-02, -5.950546E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.006663E-01, 7.968887E-03, -6.03632E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <6.23953E-01, -3.159454E-02, -5.950546E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <6.845825E-01, 1.115138E-02, -5.981203E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.845825E-01, 1.115138E-02, -5.981203E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <6.23953E-01, -3.159454E-02, -5.950546E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <6.308526E-01, -3.295974E-02, -5.889896E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.845825E-01, 1.115138E-02, -5.981203E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <6.308526E-01, -3.295974E-02, -5.889896E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <6.895182E-01, 1.017475E-02, -5.937815E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.895182E-01, 1.017475E-02, -5.937815E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <6.308526E-01, -3.295974E-02, -5.889896E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <6.660844E-01, -3.993099E-02, -5.854877E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.895182E-01, 1.017475E-02, -5.937815E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <6.660844E-01, -3.993099E-02, -5.854877E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      <7.147219E-01, 5.187735E-03, -5.912763E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.147219E-01, 5.187735E-03, -5.912763E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <6.660844E-01, -3.993099E-02, -5.854877E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      <7.242849E-01, -5.144696E-02, -5.850819E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.147219E-01, 5.187735E-03, -5.912763E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <7.242849E-01, -5.144696E-02, -5.850819E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <7.56357E-01, -3.050464E-03, -5.909861E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.56357E-01, -3.050464E-03, -5.909861E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <7.242849E-01, -5.144696E-02, -5.850819E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <7.965935E-01, -6.575451E-02, -5.878342E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.56357E-01, -3.050464E-03, -5.909861E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <7.965935E-01, -6.575451E-02, -5.878342E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <8.080843E-01, -1.328564E-02, -5.929549E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.080843E-01, -1.328564E-02, -5.929549E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <7.965935E-01, -6.575451E-02, -5.878342E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <8.720019E-01, -8.067536E-02, -5.933254E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.080843E-01, -1.328564E-02, -5.929549E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <8.720019E-01, -8.067536E-02, -5.933254E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <8.620292E-01, -2.395956E-02, -5.968832E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.620292E-01, -2.395956E-02, -5.968832E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <8.720019E-01, -8.067536E-02, -5.933254E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <9.390296E-01, -9.393799E-02, -6.007195E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.620292E-01, -2.395956E-02, -5.968832E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <9.390296E-01, -9.393799E-02, -6.007195E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <9.099791E-01, -3.34473E-02, -6.021728E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.099791E-01, -3.34473E-02, -6.021728E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <9.390296E-01, -9.393799E-02, -6.007195E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <9.874728E-01, -1.035233E-01, -6.08891E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.099791E-01, -3.34473E-02, -6.021728E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <9.874728E-01, -1.035233E-01, -6.08891E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <9.446335E-01, -4.030433E-02, -6.080184E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.874728E-01, -1.035233E-01, -6.08891E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <1.014876E+00, -1.792695E-01, -6.095153E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <1.041938E+00, -1.84624E-01, -6.187888E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.874728E-01, -1.035233E-01, -6.08891E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <1.041938E+00, -1.84624E-01, -6.187888E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <1.009956E+00, -1.07972E-01, -6.165957E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.009956E+00, -1.07972E-01, -6.165957E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <1.041938E+00, -1.84624E-01, -6.187888E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <1.033633E+00, -1.829808E-01, -6.260887E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.009956E+00, -1.07972E-01, -6.165957E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <1.033633E+00, -1.829808E-01, -6.260887E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <1.003057E+00, -1.066068E-01, -6.226607E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.003057E+00, -1.066068E-01, -6.226607E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <1.033633E+00, -1.829808E-01, -6.260887E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <9.912277E-01, -1.745901E-01, -6.303038E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.003057E+00, -1.066068E-01, -6.226607E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <9.912277E-01, -1.745901E-01, -6.303038E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <9.678247E-01, -9.963559E-02, -6.261627E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.678247E-01, -9.963559E-02, -6.261627E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <9.912277E-01, -1.745901E-01, -6.303038E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <9.211767E-01, -1.607293E-01, -6.307921E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.678247E-01, -9.963559E-02, -6.261627E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <9.211767E-01, -1.607293E-01, -6.307921E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <9.096242E-01, -8.81196E-02, -6.265685E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.096242E-01, -8.81196E-02, -6.265685E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <9.211767E-01, -1.607293E-01, -6.307921E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <8.341449E-01, -1.435086E-01, -6.274795E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.096242E-01, -8.81196E-02, -6.265685E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <8.341449E-01, -1.435086E-01, -6.274795E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <8.373157E-01, -7.381209E-02, -6.238162E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.373157E-01, -7.381209E-02, -6.238162E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <8.341449E-01, -1.435086E-01, -6.274795E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <7.433822E-01, -1.255496E-01, -6.208702E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.373157E-01, -7.381209E-02, -6.238162E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <7.433822E-01, -1.255496E-01, -6.208702E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <7.619073E-01, -5.889123E-02, -6.18325E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.619073E-01, -5.889123E-02, -6.18325E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <7.433822E-01, -1.255496E-01, -6.208702E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <6.627064E-01, -1.095865E-01, -6.119705E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.619073E-01, -5.889123E-02, -6.18325E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <6.627064E-01, -1.095865E-01, -6.119705E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <6.948794E-01, -4.562857E-02, -6.109309E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.948794E-01, -4.562857E-02, -6.109309E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <6.627064E-01, -1.095865E-01, -6.119705E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <6.043995E-01, -9.804942E-02, -6.021351E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.948794E-01, -4.562857E-02, -6.109309E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <6.043995E-01, -9.804942E-02, -6.021351E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <6.464363E-01, -3.604324E-02, -6.027594E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.464363E-01, -3.604324E-02, -6.027594E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <6.043995E-01, -9.804942E-02, -6.021351E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <5.773383E-01, -9.269487E-02, -5.928616E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.464363E-01, -3.604324E-02, -6.027594E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <5.773383E-01, -9.269487E-02, -5.928616E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <6.23953E-01, -3.159454E-02, -5.950546E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.23953E-01, -3.159454E-02, -5.950546E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <5.773383E-01, -9.269487E-02, -5.928616E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <5.856427E-01, -9.433804E-02, -5.855616E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.23953E-01, -3.159454E-02, -5.950546E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <5.856427E-01, -9.433804E-02, -5.855616E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <6.308526E-01, -3.295974E-02, -5.889896E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.308526E-01, -3.295974E-02, -5.889896E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <5.856427E-01, -9.433804E-02, -5.855616E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <6.280483E-01, -1.027287E-01, -5.813466E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.308526E-01, -3.295974E-02, -5.889896E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <6.280483E-01, -1.027287E-01, -5.813466E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <6.660844E-01, -3.993099E-02, -5.854877E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.660844E-01, -3.993099E-02, -5.854877E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01> 
      <6.280483E-01, -1.027287E-01, -5.813466E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <6.980994E-01, -1.165896E-01, -5.808582E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.660844E-01, -3.993099E-02, -5.854877E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01> 
      <6.980994E-01, -1.165896E-01, -5.808582E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <7.242849E-01, -5.144696E-02, -5.850819E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.242849E-01, -5.144696E-02, -5.850819E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <6.980994E-01, -1.165896E-01, -5.808582E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <7.85131E-01, -1.338103E-01, -5.841709E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.242849E-01, -5.144696E-02, -5.850819E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <7.85131E-01, -1.338103E-01, -5.841709E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <7.965935E-01, -6.575451E-02, -5.878342E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.965935E-01, -6.575451E-02, -5.878342E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <7.85131E-01, -1.338103E-01, -5.841709E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <8.758936E-01, -1.517693E-01, -5.907802E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.965935E-01, -6.575451E-02, -5.878342E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <8.758936E-01, -1.517693E-01, -5.907802E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <8.720019E-01, -8.067536E-02, -5.933254E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.720019E-01, -8.067536E-02, -5.933254E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <8.758936E-01, -1.517693E-01, -5.907802E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <9.565696E-01, -1.677324E-01, -5.996799E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.720019E-01, -8.067536E-02, -5.933254E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <9.565696E-01, -1.677324E-01, -5.996799E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <9.390296E-01, -9.393799E-02, -6.007195E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.390296E-01, -9.393799E-02, -6.007195E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <9.565696E-01, -1.677324E-01, -5.996799E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <1.014876E+00, -1.792695E-01, -6.095153E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.390296E-01, -9.393799E-02, -6.007195E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <1.014876E+00, -1.792695E-01, -6.095153E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <9.874728E-01, -1.035233E-01, -6.08891E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.014876E+00, -1.792695E-01, -6.095153E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <1.024624E+00, -2.614063E-01, -6.098405E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <1.054071E+00, -2.672328E-01, -6.199316E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.014876E+00, -1.792695E-01, -6.095153E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <1.054071E+00, -2.672328E-01, -6.199316E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <1.041938E+00, -1.84624E-01, -6.187888E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.041938E+00, -1.84624E-01, -6.187888E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <1.054071E+00, -2.672328E-01, -6.199316E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <1.045035E+00, -2.654448E-01, -6.278751E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.041938E+00, -1.84624E-01, -6.187888E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <1.045035E+00, -2.654448E-01, -6.278751E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <1.033633E+00, -1.829808E-01, -6.260887E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.033633E+00, -1.829808E-01, -6.260887E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <1.045035E+00, -2.654448E-01, -6.278751E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <9.98891E-01, -2.563145E-01, -6.324617E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.033633E+00, -1.829808E-01, -6.260887E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <9.98891E-01, -2.563145E-01, -6.324617E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <9.912277E-01, -1.745901E-01, -6.303038E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.912277E-01, -1.745901E-01, -6.303038E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <9.98891E-01, -2.563145E-01, -6.324617E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <9.226645E-01, -2.412317E-01, -6.329931E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.912277E-01, -1.745901E-01, -6.303038E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <9.226645E-01, -2.412317E-01, -6.329931E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <9.211767E-01, -1.607293E-01, -6.307921E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.211767E-01, -1.607293E-01, -6.307921E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <9.226645E-01, -2.412317E-01, -6.329931E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <8.279604E-01, -2.224928E-01, -6.293885E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.211767E-01, -1.607293E-01, -6.307921E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <8.279604E-01, -2.224928E-01, -6.293885E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <8.341449E-01, -1.435086E-01, -6.274795E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.341449E-01, -1.435086E-01, -6.274795E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <8.279604E-01, -2.224928E-01, -6.293885E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <7.291965E-01, -2.029507E-01, -6.221965E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.341449E-01, -1.435086E-01, -6.274795E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <7.291965E-01, -2.029507E-01, -6.221965E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <7.433822E-01, -1.255496E-01, -6.208702E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.433822E-01, -1.255496E-01, -6.208702E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <7.291965E-01, -2.029507E-01, -6.221965E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <6.414086E-01, -1.855803E-01, -6.125122E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.433822E-01, -1.255496E-01, -6.208702E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <6.414086E-01, -1.855803E-01, -6.125122E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <6.627064E-01, -1.095865E-01, -6.119705E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.627064E-01, -1.095865E-01, -6.119705E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <6.414086E-01, -1.855803E-01, -6.125122E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <5.779616E-01, -1.730262E-01, -6.018098E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.627064E-01, -1.095865E-01, -6.119705E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <5.779616E-01, -1.730262E-01, -6.018098E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <6.043995E-01, -9.804942E-02, -6.021351E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.043995E-01, -9.804942E-02, -6.021351E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <5.779616E-01, -1.730262E-01, -6.018098E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <5.485148E-01, -1.671997E-01, -5.917188E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.043995E-01, -9.804942E-02, -6.021351E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <5.485148E-01, -1.671997E-01, -5.917188E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <5.773383E-01, -9.269487E-02, -5.928616E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.773383E-01, -9.269487E-02, -5.928616E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <5.485148E-01, -1.671997E-01, -5.917188E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <5.575513E-01, -1.689877E-01, -5.837753E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.773383E-01, -9.269487E-02, -5.928616E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <5.575513E-01, -1.689877E-01, -5.837753E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <5.856427E-01, -9.433804E-02, -5.855616E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.856427E-01, -9.433804E-02, -5.855616E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <5.575513E-01, -1.689877E-01, -5.837753E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <6.036952E-01, -1.781181E-01, -5.791887E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.856427E-01, -9.433804E-02, -5.855616E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <6.036952E-01, -1.781181E-01, -5.791887E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <6.280483E-01, -1.027287E-01, -5.813466E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.280483E-01, -1.027287E-01, -5.813466E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <6.036952E-01, -1.781181E-01, -5.791887E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <6.799216E-01, -1.932008E-01, -5.786573E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.280483E-01, -1.027287E-01, -5.813466E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <6.799216E-01, -1.932008E-01, -5.786573E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <6.980994E-01, -1.165896E-01, -5.808582E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.980994E-01, -1.165896E-01, -5.808582E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <6.799216E-01, -1.932008E-01, -5.786573E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <7.746258E-01, -2.119396E-01, -5.822619E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.980994E-01, -1.165896E-01, -5.808582E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <7.746258E-01, -2.119396E-01, -5.822619E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <7.85131E-01, -1.338103E-01, -5.841709E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.85131E-01, -1.338103E-01, -5.841709E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <7.746258E-01, -2.119396E-01, -5.822619E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <8.733897E-01, -2.314818E-01, -5.894539E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.85131E-01, -1.338103E-01, -5.841709E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <8.733897E-01, -2.314818E-01, -5.894539E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <8.758936E-01, -1.517693E-01, -5.907802E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.758936E-01, -1.517693E-01, -5.907802E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <8.733897E-01, -2.314818E-01, -5.894539E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <9.611776E-01, -2.488522E-01, -5.991382E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.758936E-01, -1.517693E-01, -5.907802E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <9.611776E-01, -2.488522E-01, -5.991382E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <9.565696E-01, -1.677324E-01, -5.996799E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.565696E-01, -1.677324E-01, -5.996799E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <9.611776E-01, -2.488522E-01, -5.991382E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <1.024624E+00, -2.614063E-01, -6.098405E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.565696E-01, -1.677324E-01, -5.996799E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <1.024624E+00, -2.614063E-01, -6.098405E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <1.014876E+00, -1.792695E-01, -6.095153E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.024624E+00, -2.614063E-01, -6.098405E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <1.015927E+00, -3.432795E-01, -6.098405E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      <1.045374E+00, -3.491061E-01, -6.199316E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.024624E+00, -2.614063E-01, -6.098405E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <1.045374E+00, -3.491061E-01, -6.199316E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <1.054071E+00, -2.672328E-01, -6.199316E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.054071E+00, -2.672328E-01, -6.199316E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <1.045374E+00, -3.491061E-01, -6.199316E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <1.036338E+00, -3.473181E-01, -6.278751E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.054071E+00, -2.672328E-01, -6.199316E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <1.036338E+00, -3.473181E-01, -6.278751E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <1.045035E+00, -2.654448E-01, -6.278751E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.045035E+00, -2.654448E-01, -6.278751E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <1.036338E+00, -3.473181E-01, -6.278751E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <9.901937E-01, -3.381878E-01, -6.324617E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.045035E+00, -2.654448E-01, -6.278751E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <9.901937E-01, -3.381878E-01, -6.324617E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <9.98891E-01, -2.563145E-01, -6.324617E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.98891E-01, -2.563145E-01, -6.324617E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <9.901937E-01, -3.381878E-01, -6.324617E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <9.139673E-01, -3.23105E-01, -6.329931E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.98891E-01, -2.563145E-01, -6.324617E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <9.139673E-01, -3.23105E-01, -6.329931E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <9.226645E-01, -2.412317E-01, -6.329931E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.226645E-01, -2.412317E-01, -6.329931E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <9.139673E-01, -3.23105E-01, -6.329931E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <8.192632E-01, -3.043661E-01, -6.293885E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.226645E-01, -2.412317E-01, -6.329931E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <8.192632E-01, -3.043661E-01, -6.293885E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      <8.279604E-01, -2.224928E-01, -6.293885E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.279604E-01, -2.224928E-01, -6.293885E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <8.192632E-01, -3.043661E-01, -6.293885E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      <7.204992E-01, -2.84824E-01, -6.221965E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.279604E-01, -2.224928E-01, -6.293885E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <7.204992E-01, -2.84824E-01, -6.221965E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <7.291965E-01, -2.029507E-01, -6.221965E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.291965E-01, -2.029507E-01, -6.221965E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <7.204992E-01, -2.84824E-01, -6.221965E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <6.327114E-01, -2.674536E-01, -6.125122E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.291965E-01, -2.029507E-01, -6.221965E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <6.327114E-01, -2.674536E-01, -6.125122E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <6.414086E-01, -1.855803E-01, -6.125122E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.414086E-01, -1.855803E-01, -6.125122E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <6.327114E-01, -2.674536E-01, -6.125122E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <5.692644E-01, -2.548995E-01, -6.018098E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.414086E-01, -1.855803E-01, -6.125122E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <5.692644E-01, -2.548995E-01, -6.018098E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <5.779616E-01, -1.730262E-01, -6.018098E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.779616E-01, -1.730262E-01, -6.018098E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <5.692644E-01, -2.548995E-01, -6.018098E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <5.398176E-01, -2.490729E-01, -5.917188E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.779616E-01, -1.730262E-01, -6.018098E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <5.398176E-01, -2.490729E-01, -5.917188E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <5.485148E-01, -1.671997E-01, -5.917188E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.485148E-01, -1.671997E-01, -5.917188E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <5.398176E-01, -2.490729E-01, -5.917188E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <5.488541E-01, -2.50861E-01, -5.837753E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.485148E-01, -1.671997E-01, -5.917188E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <5.488541E-01, -2.50861E-01, -5.837753E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <5.575513E-01, -1.689877E-01, -5.837753E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.575513E-01, -1.689877E-01, -5.837753E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <5.488541E-01, -2.50861E-01, -5.837753E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <5.94998E-01, -2.599913E-01, -5.791887E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.575513E-01, -1.689877E-01, -5.837753E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <5.94998E-01, -2.599913E-01, -5.791887E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <6.036952E-01, -1.781181E-01, -5.791887E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.036952E-01, -1.781181E-01, -5.791887E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <5.94998E-01, -2.599913E-01, -5.791887E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <6.712244E-01, -2.750741E-01, -5.786573E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.036952E-01, -1.781181E-01, -5.791887E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <6.712244E-01, -2.750741E-01, -5.786573E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <6.799216E-01, -1.932008E-01, -5.786573E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.799216E-01, -1.932008E-01, -5.786573E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <6.712244E-01, -2.750741E-01, -5.786573E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <7.659285E-01, -2.938129E-01, -5.822619E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.799216E-01, -1.932008E-01, -5.786573E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <7.659285E-01, -2.938129E-01, -5.822619E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <7.746258E-01, -2.119396E-01, -5.822619E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.746258E-01, -2.119396E-01, -5.822619E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <7.659285E-01, -2.938129E-01, -5.822619E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <8.646924E-01, -3.133551E-01, -5.894539E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.746258E-01, -2.119396E-01, -5.822619E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <8.646924E-01, -3.133551E-01, -5.894539E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <8.733897E-01, -2.314818E-01, -5.894539E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.733897E-01, -2.314818E-01, -5.894539E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <8.646924E-01, -3.133551E-01, -5.894539E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <9.524804E-01, -3.307255E-01, -5.991382E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.733897E-01, -2.314818E-01, -5.894539E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <9.524804E-01, -3.307255E-01, -5.991382E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <9.611776E-01, -2.488522E-01, -5.991382E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.611776E-01, -2.488522E-01, -5.991382E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <9.524804E-01, -3.307255E-01, -5.991382E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <1.015927E+00, -3.432795E-01, -6.098405E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.611776E-01, -2.488522E-01, -5.991382E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <1.015927E+00, -3.432795E-01, -6.098405E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      <1.024624E+00, -2.614063E-01, -6.098405E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <1.015927E+00, -3.432795E-01, -6.098405E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02> 
      <9.894893E-01, -4.182563E-01, -6.095153E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <1.016551E+00, -4.236108E-01, -6.187888E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.015927E+00, -3.432795E-01, -6.098405E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02> 
      <1.016551E+00, -4.236108E-01, -6.187888E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <1.045374E+00, -3.491061E-01, -6.199316E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.045374E+00, -3.491061E-01, -6.199316E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <1.016551E+00, -4.236108E-01, -6.187888E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <1.008246E+00, -4.219677E-01, -6.260887E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.045374E+00, -3.491061E-01, -6.199316E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <1.008246E+00, -4.219677E-01, -6.260887E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <1.036338E+00, -3.473181E-01, -6.278751E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.036338E+00, -3.473181E-01, -6.278751E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <1.008246E+00, -4.219677E-01, -6.260887E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <9.658406E-01, -4.13577E-01, -6.303038E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.036338E+00, -3.473181E-01, -6.278751E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <9.658406E-01, -4.13577E-01, -6.303038E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      <9.901937E-01, -3.381878E-01, -6.324617E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.901937E-01, -3.381878E-01, -6.324617E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <9.658406E-01, -4.13577E-01, -6.303038E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      <8.957897E-01, -3.997162E-01, -6.307921E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.901937E-01, -3.381878E-01, -6.324617E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <8.957897E-01, -3.997162E-01, -6.307921E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      <9.139673E-01, -3.23105E-01, -6.329931E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.139673E-01, -3.23105E-01, -6.329931E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <8.957897E-01, -3.997162E-01, -6.307921E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      <8.087579E-01, -3.824954E-01, -6.274795E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.139673E-01, -3.23105E-01, -6.329931E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <8.087579E-01, -3.824954E-01, -6.274795E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <8.192632E-01, -3.043661E-01, -6.293885E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.192632E-01, -3.043661E-01, -6.293885E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01> 
      <8.087579E-01, -3.824954E-01, -6.274795E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <7.179952E-01, -3.645365E-01, -6.208702E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.192632E-01, -3.043661E-01, -6.293885E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01> 
      <7.179952E-01, -3.645365E-01, -6.208702E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <7.204992E-01, -2.84824E-01, -6.221965E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.204992E-01, -2.84824E-01, -6.221965E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <7.179952E-01, -3.645365E-01, -6.208702E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <6.373193E-01, -3.485733E-01, -6.119705E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.204992E-01, -2.84824E-01, -6.221965E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <6.373193E-01, -3.485733E-01, -6.119705E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <6.327114E-01, -2.674536E-01, -6.125122E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.327114E-01, -2.674536E-01, -6.125122E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <6.373193E-01, -3.485733E-01, -6.119705E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <5.790125E-01, -3.370363E-01, -6.021351E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.327114E-01, -2.674536E-01, -6.125122E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <5.790125E-01, -3.370363E-01, -6.021351E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <5.692644E-01, -2.548995E-01, -6.018098E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.692644E-01, -2.548995E-01, -6.018098E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <5.790125E-01, -3.370363E-01, -6.021351E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <5.519513E-01, -3.316818E-01, -5.928616E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.692644E-01, -2.548995E-01, -6.018098E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <5.519513E-01, -3.316818E-01, -5.928616E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <5.398176E-01, -2.490729E-01, -5.917188E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.398176E-01, -2.490729E-01, -5.917188E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <5.519513E-01, -3.316818E-01, -5.928616E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <5.602558E-01, -3.333249E-01, -5.855616E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.398176E-01, -2.490729E-01, -5.917188E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <5.602558E-01, -3.333249E-01, -5.855616E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <5.488541E-01, -2.50861E-01, -5.837753E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.488541E-01, -2.50861E-01, -5.837753E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <5.602558E-01, -3.333249E-01, -5.855616E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <6.026613E-01, -3.417156E-01, -5.813466E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.488541E-01, -2.50861E-01, -5.837753E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <6.026613E-01, -3.417156E-01, -5.813466E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      <5.94998E-01, -2.599913E-01, -5.791887E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.94998E-01, -2.599913E-01, -5.791887E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <6.026613E-01, -3.417156E-01, -5.813466E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      <6.727123E-01, -3.555765E-01, -5.808582E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.94998E-01, -2.599913E-01, -5.791887E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <6.727123E-01, -3.555765E-01, -5.808582E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      <6.712244E-01, -2.750741E-01, -5.786573E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.712244E-01, -2.750741E-01, -5.786573E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <6.727123E-01, -3.555765E-01, -5.808582E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      <7.59744E-01, -3.727972E-01, -5.841709E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.712244E-01, -2.750741E-01, -5.786573E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <7.59744E-01, -3.727972E-01, -5.841709E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      <7.659285E-01, -2.938129E-01, -5.822619E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.659285E-01, -2.938129E-01, -5.822619E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <7.59744E-01, -3.727972E-01, -5.841709E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      <8.505067E-01, -3.907562E-01, -5.907802E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.659285E-01, -2.938129E-01, -5.822619E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <8.505067E-01, -3.907562E-01, -5.907802E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <8.646924E-01, -3.133551E-01, -5.894539E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.646924E-01, -3.133551E-01, -5.894539E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <8.505067E-01, -3.907562E-01, -5.907802E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <9.311826E-01, -4.067193E-01, -5.996799E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.646924E-01, -3.133551E-01, -5.894539E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <9.311826E-01, -4.067193E-01, -5.996799E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <9.524804E-01, -3.307255E-01, -5.991382E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.524804E-01, -3.307255E-01, -5.991382E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <9.311826E-01, -4.067193E-01, -5.996799E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <9.894893E-01, -4.182563E-01, -6.095153E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.524804E-01, -3.307255E-01, -5.991382E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <9.894893E-01, -4.182563E-01, -6.095153E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <1.015927E+00, -3.432795E-01, -6.098405E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.894893E-01, -4.182563E-01, -6.095153E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <9.474525E-01, -4.802625E-01, -6.08891E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <9.699358E-01, -4.847112E-01, -6.165957E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.894893E-01, -4.182563E-01, -6.095153E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <9.699358E-01, -4.847112E-01, -6.165957E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <1.016551E+00, -4.236108E-01, -6.187888E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.016551E+00, -4.236108E-01, -6.187888E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <9.699358E-01, -4.847112E-01, -6.165957E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <9.630363E-01, -4.83346E-01, -6.226607E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.016551E+00, -4.236108E-01, -6.187888E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <9.630363E-01, -4.83346E-01, -6.226607E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <1.008246E+00, -4.219677E-01, -6.260887E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.008246E+00, -4.219677E-01, -6.260887E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <9.630363E-01, -4.83346E-01, -6.226607E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <9.278046E-01, -4.763747E-01, -6.261627E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <1.008246E+00, -4.219677E-01, -6.260887E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <9.278046E-01, -4.763747E-01, -6.261627E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <9.658406E-01, -4.13577E-01, -6.303038E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.658406E-01, -4.13577E-01, -6.303038E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01> 
      <9.278046E-01, -4.763747E-01, -6.261627E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <8.696041E-01, -4.648588E-01, -6.265685E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.658406E-01, -4.13577E-01, -6.303038E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01> 
      <8.696041E-01, -4.648588E-01, -6.265685E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <8.957897E-01, -3.997162E-01, -6.307921E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.957897E-01, -3.997162E-01, -6.307921E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01> 
      <8.696041E-01, -4.648588E-01, -6.265685E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <7.972953E-01, -4.505512E-01, -6.238162E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.957897E-01, -3.997162E-01, -6.307921E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01> 
      <7.972953E-01, -4.505512E-01, -6.238162E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <8.087579E-01, -3.824954E-01, -6.274795E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.087579E-01, -3.824954E-01, -6.274795E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <7.972953E-01, -4.505512E-01, -6.238162E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <7.218871E-01, -4.356304E-01, -6.18325E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.087579E-01, -3.824954E-01, -6.274795E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <7.218871E-01, -4.356304E-01, -6.18325E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <7.179952E-01, -3.645365E-01, -6.208702E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.179952E-01, -3.645365E-01, -6.208702E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <7.218871E-01, -4.356304E-01, -6.18325E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <6.548592E-01, -4.223678E-01, -6.109308E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.179952E-01, -3.645365E-01, -6.208702E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <6.548592E-01, -4.223678E-01, -6.109308E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <6.373193E-01, -3.485733E-01, -6.119705E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.373193E-01, -3.485733E-01, -6.119705E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <6.548592E-01, -4.223678E-01, -6.109308E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <6.064161E-01, -4.127824E-01, -6.027594E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.373193E-01, -3.485733E-01, -6.119705E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <6.064161E-01, -4.127824E-01, -6.027594E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <5.790125E-01, -3.370363E-01, -6.021351E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <5.790125E-01, -3.370363E-01, -6.021351E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <6.064161E-01, -4.127824E-01, -6.027594E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <5.839328E-01, -4.083337E-01, -5.950546E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.790125E-01, -3.370363E-01, -6.021351E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <5.839328E-01, -4.083337E-01, -5.950546E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <5.519513E-01, -3.316818E-01, -5.928616E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.519513E-01, -3.316818E-01, -5.928616E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <5.839328E-01, -4.083337E-01, -5.950546E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <5.908324E-01, -4.096989E-01, -5.889896E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.519513E-01, -3.316818E-01, -5.928616E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <5.908324E-01, -4.096989E-01, -5.889896E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <5.602558E-01, -3.333249E-01, -5.855616E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.602558E-01, -3.333249E-01, -5.855616E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <5.908324E-01, -4.096989E-01, -5.889896E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <6.260642E-01, -4.166702E-01, -5.854877E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.602558E-01, -3.333249E-01, -5.855616E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <6.260642E-01, -4.166702E-01, -5.854877E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <6.026613E-01, -3.417156E-01, -5.813466E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.026613E-01, -3.417156E-01, -5.813466E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01> 
      <6.260642E-01, -4.166702E-01, -5.854877E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <6.842647E-01, -4.281861E-01, -5.850819E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.026613E-01, -3.417156E-01, -5.813466E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01> 
      <6.842647E-01, -4.281861E-01, -5.850819E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <6.727123E-01, -3.555765E-01, -5.808582E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.727123E-01, -3.555765E-01, -5.808582E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01> 
      <6.842647E-01, -4.281861E-01, -5.850819E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <7.565733E-01, -4.424936E-01, -5.878342E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.727123E-01, -3.555765E-01, -5.808582E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01> 
      <7.565733E-01, -4.424936E-01, -5.878342E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <7.59744E-01, -3.727972E-01, -5.841709E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.59744E-01, -3.727972E-01, -5.841709E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01> 
      <7.565733E-01, -4.424936E-01, -5.878342E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <8.319814E-01, -4.574145E-01, -5.933254E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.59744E-01, -3.727972E-01, -5.841709E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01> 
      <8.319814E-01, -4.574145E-01, -5.933254E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <8.505067E-01, -3.907562E-01, -5.907802E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.505067E-01, -3.907562E-01, -5.907802E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <8.319814E-01, -4.574145E-01, -5.933254E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <8.990096E-01, -4.706772E-01, -6.007195E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.505067E-01, -3.907562E-01, -5.907802E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <8.990096E-01, -4.706772E-01, -6.007195E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <9.311826E-01, -4.067193E-01, -5.996799E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.311826E-01, -4.067193E-01, -5.996799E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <8.990096E-01, -4.706772E-01, -6.007195E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <9.474525E-01, -4.802625E-01, -6.08891E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.311826E-01, -4.067193E-01, -5.996799E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <9.474525E-01, -4.802625E-01, -6.08891E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <9.894893E-01, -4.182563E-01, -6.095153E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <9.474525E-01, -4.802625E-01, -6.08891E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <8.932226E-01, -5.242746E-01, -6.080184E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <9.093064E-01, -5.274571E-01, -6.135301E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.474525E-01, -4.802625E-01, -6.08891E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <9.093064E-01, -5.274571E-01, -6.135301E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <9.699358E-01, -4.847112E-01, -6.165957E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.699358E-01, -4.847112E-01, -6.165957E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <9.093064E-01, -5.274571E-01, -6.135301E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <9.043707E-01, -5.264804E-01, -6.178689E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.699358E-01, -4.847112E-01, -6.165957E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <9.043707E-01, -5.264804E-01, -6.178689E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <9.630363E-01, -4.83346E-01, -6.226607E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.630363E-01, -4.83346E-01, -6.226607E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <9.043707E-01, -5.264804E-01, -6.178689E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <8.791668E-01, -5.214934E-01, -6.203741E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.630363E-01, -4.83346E-01, -6.226607E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <8.791668E-01, -5.214934E-01, -6.203741E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <9.278046E-01, -4.763747E-01, -6.261627E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.278046E-01, -4.763747E-01, -6.261627E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <8.791668E-01, -5.214934E-01, -6.203741E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <8.37532E-01, -5.132553E-01, -6.206643E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.278046E-01, -4.763747E-01, -6.261627E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <8.37532E-01, -5.132553E-01, -6.206643E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <8.696041E-01, -4.648588E-01, -6.265685E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.696041E-01, -4.648588E-01, -6.265685E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <8.37532E-01, -5.132553E-01, -6.206643E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <7.858046E-01, -5.030201E-01, -6.186954E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.696041E-01, -4.648588E-01, -6.265685E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <7.858046E-01, -5.030201E-01, -6.186954E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <7.972953E-01, -4.505512E-01, -6.238162E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.972953E-01, -4.505512E-01, -6.238162E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <7.858046E-01, -5.030201E-01, -6.186954E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <7.318597E-01, -4.923461E-01, -6.147672E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.972953E-01, -4.505512E-01, -6.238162E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <7.318597E-01, -4.923461E-01, -6.147672E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <7.218871E-01, -4.356304E-01, -6.18325E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.218871E-01, -4.356304E-01, -6.18325E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <7.318597E-01, -4.923461E-01, -6.147672E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <6.8391E-01, -4.828584E-01, -6.094776E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.218871E-01, -4.356304E-01, -6.18325E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <6.8391E-01, -4.828584E-01, -6.094776E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <6.548592E-01, -4.223678E-01, -6.109308E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.548592E-01, -4.223678E-01, -6.109308E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <6.8391E-01, -4.828584E-01, -6.094776E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <6.492552E-01, -4.760014E-01, -6.03632E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.548592E-01, -4.223678E-01, -6.109308E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <6.492552E-01, -4.760014E-01, -6.03632E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <6.064161E-01, -4.127824E-01, -6.027594E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.064161E-01, -4.127824E-01, -6.027594E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <6.492552E-01, -4.760014E-01, -6.03632E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <6.331714E-01, -4.72819E-01, -5.981203E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.064161E-01, -4.127824E-01, -6.027594E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <6.331714E-01, -4.72819E-01, -5.981203E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <5.839328E-01, -4.083337E-01, -5.950546E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.839328E-01, -4.083337E-01, -5.950546E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <6.331714E-01, -4.72819E-01, -5.981203E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <6.381071E-01, -4.737955E-01, -5.937815E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.839328E-01, -4.083337E-01, -5.950546E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <6.381071E-01, -4.737955E-01, -5.937815E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <5.908324E-01, -4.096989E-01, -5.889896E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.908324E-01, -4.096989E-01, -5.889896E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <6.381071E-01, -4.737955E-01, -5.937815E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <6.633109E-01, -4.787826E-01, -5.912763E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <5.908324E-01, -4.096989E-01, -5.889896E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <6.633109E-01, -4.787826E-01, -5.912763E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <6.260642E-01, -4.166702E-01, -5.854877E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.260642E-01, -4.166702E-01, -5.854877E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <6.633109E-01, -4.787826E-01, -5.912763E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <7.049458E-01, -4.870208E-01, -5.909861E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.260642E-01, -4.166702E-01, -5.854877E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <7.049458E-01, -4.870208E-01, -5.909861E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <6.842647E-01, -4.281861E-01, -5.850819E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.842647E-01, -4.281861E-01, -5.850819E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <7.049458E-01, -4.870208E-01, -5.909861E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <7.566733E-01, -4.972559E-01, -5.929549E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.842647E-01, -4.281861E-01, -5.850819E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <7.566733E-01, -4.972559E-01, -5.929549E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <7.565733E-01, -4.424936E-01, -5.878342E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.565733E-01, -4.424936E-01, -5.878342E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <7.566733E-01, -4.972559E-01, -5.929549E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <8.10618E-01, -5.079299E-01, -5.968832E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.565733E-01, -4.424936E-01, -5.878342E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <8.10618E-01, -5.079299E-01, -5.968832E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <8.319814E-01, -4.574145E-01, -5.933254E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.319814E-01, -4.574145E-01, -5.933254E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <8.10618E-01, -5.079299E-01, -5.968832E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <8.585678E-01, -5.174176E-01, -6.021728E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.319814E-01, -4.574145E-01, -5.933254E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <8.585678E-01, -5.174176E-01, -6.021728E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <8.990096E-01, -4.706772E-01, -6.007195E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.990096E-01, -4.706772E-01, -6.007195E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <8.585678E-01, -5.174176E-01, -6.021728E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <8.932226E-01, -5.242746E-01, -6.080184E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.990096E-01, -4.706772E-01, -6.007195E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <8.932226E-01, -5.242746E-01, -6.080184E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <9.474525E-01, -4.802625E-01, -6.08891E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.932226E-01, -5.242746E-01, -6.080184E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <8.311926E-01, -5.467272E-01, -6.069681E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <8.39574E-01, -5.483856E-01, -6.098403E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.932226E-01, -5.242746E-01, -6.080184E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <8.39574E-01, -5.483856E-01, -6.098403E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <9.093064E-01, -5.274571E-01, -6.135301E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.093064E-01, -5.274571E-01, -6.135301E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <8.39574E-01, -5.483856E-01, -6.098403E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <8.370022E-01, -5.478767E-01, -6.121013E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.093064E-01, -5.274571E-01, -6.135301E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <8.370022E-01, -5.478767E-01, -6.121013E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <9.043707E-01, -5.264804E-01, -6.178689E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.043707E-01, -5.264804E-01, -6.178689E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <8.370022E-01, -5.478767E-01, -6.121013E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <8.238682E-01, -5.452778E-01, -6.134067E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <9.043707E-01, -5.264804E-01, -6.178689E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <8.238682E-01, -5.452778E-01, -6.134067E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <8.791668E-01, -5.214934E-01, -6.203741E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.791668E-01, -5.214934E-01, -6.203741E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <8.238682E-01, -5.452778E-01, -6.134067E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <8.021718E-01, -5.409849E-01, -6.13558E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.791668E-01, -5.214934E-01, -6.203741E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <8.021718E-01, -5.409849E-01, -6.13558E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <8.37532E-01, -5.132553E-01, -6.206643E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.37532E-01, -5.132553E-01, -6.206643E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <8.021718E-01, -5.409849E-01, -6.13558E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <7.752162E-01, -5.356513E-01, -6.12532E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.37532E-01, -5.132553E-01, -6.206643E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <7.752162E-01, -5.356513E-01, -6.12532E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <7.858046E-01, -5.030201E-01, -6.186954E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.858046E-01, -5.030201E-01, -6.186954E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <7.752162E-01, -5.356513E-01, -6.12532E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <7.471051E-01, -5.30089E-01, -6.104849E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.858046E-01, -5.030201E-01, -6.186954E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <7.471051E-01, -5.30089E-01, -6.104849E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <7.318597E-01, -4.923461E-01, -6.147672E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.318597E-01, -4.923461E-01, -6.147672E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <7.471051E-01, -5.30089E-01, -6.104849E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <7.221181E-01, -5.251449E-01, -6.077285E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.318597E-01, -4.923461E-01, -6.147672E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <7.221181E-01, -5.251449E-01, -6.077285E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <6.8391E-01, -4.828584E-01, -6.094776E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.8391E-01, -4.828584E-01, -6.094776E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <7.221181E-01, -5.251449E-01, -6.077285E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <7.040592E-01, -5.215716E-01, -6.046823E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <6.8391E-01, -4.828584E-01, -6.094776E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <7.040592E-01, -5.215716E-01, -6.046823E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <6.492552E-01, -4.760014E-01, -6.03632E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.492552E-01, -4.760014E-01, -6.03632E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <7.040592E-01, -5.215716E-01, -6.046823E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <6.956778E-01, -5.199132E-01, -6.018101E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.492552E-01, -4.760014E-01, -6.03632E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <6.956778E-01, -5.199132E-01, -6.018101E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <6.331714E-01, -4.72819E-01, -5.981203E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.331714E-01, -4.72819E-01, -5.981203E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <6.956778E-01, -5.199132E-01, -6.018101E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <6.982498E-01, -5.204222E-01, -5.995491E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.331714E-01, -4.72819E-01, -5.981203E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <6.982498E-01, -5.204222E-01, -5.995491E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <6.381071E-01, -4.737955E-01, -5.937815E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.381071E-01, -4.737955E-01, -5.937815E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <6.982498E-01, -5.204222E-01, -5.995491E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <7.113837E-01, -5.230209E-01, -5.982437E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.381071E-01, -4.737955E-01, -5.937815E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <7.113837E-01, -5.230209E-01, -5.982437E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <6.633109E-01, -4.787826E-01, -5.912763E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.633109E-01, -4.787826E-01, -5.912763E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <7.113837E-01, -5.230209E-01, -5.982437E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <7.3308E-01, -5.273139E-01, -5.980924E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.633109E-01, -4.787826E-01, -5.912763E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <7.3308E-01, -5.273139E-01, -5.980924E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <7.049458E-01, -4.870208E-01, -5.909861E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.049458E-01, -4.870208E-01, -5.909861E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <7.3308E-01, -5.273139E-01, -5.980924E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <7.600356E-01, -5.326475E-01, -5.991184E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.049458E-01, -4.870208E-01, -5.909861E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <7.600356E-01, -5.326475E-01, -5.991184E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <7.566733E-01, -4.972559E-01, -5.929549E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.566733E-01, -4.972559E-01, -5.929549E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <7.600356E-01, -5.326475E-01, -5.991184E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <7.881467E-01, -5.382098E-01, -6.011654E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.566733E-01, -4.972559E-01, -5.929549E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <7.881467E-01, -5.382098E-01, -6.011654E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <8.10618E-01, -5.079299E-01, -5.968832E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.10618E-01, -5.079299E-01, -5.968832E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <7.881467E-01, -5.382098E-01, -6.011654E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <8.131337E-01, -5.431539E-01, -6.039218E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.10618E-01, -5.079299E-01, -5.968832E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <8.131337E-01, -5.431539E-01, -6.039218E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <8.585678E-01, -5.174176E-01, -6.021728E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.585678E-01, -5.174176E-01, -6.021728E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <8.131337E-01, -5.431539E-01, -6.039218E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <8.311926E-01, -5.467272E-01, -6.069681E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <8.585678E-01, -5.174176E-01, -6.021728E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <8.311926E-01, -5.467272E-01, -6.069681E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <8.932226E-01, -5.242746E-01, -6.080184E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.311926E-01, -5.467272E-01, -6.069681E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <8.39574E-01, -5.483856E-01, -6.098403E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.39574E-01, -5.483856E-01, -6.098403E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <8.370022E-01, -5.478767E-01, -6.121013E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.370022E-01, -5.478767E-01, -6.121013E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <8.238682E-01, -5.452778E-01, -6.134067E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.238682E-01, -5.452778E-01, -6.134067E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <8.021718E-01, -5.409849E-01, -6.13558E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <8.021718E-01, -5.409849E-01, -6.13558E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.752162E-01, -5.356513E-01, -6.12532E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.752162E-01, -5.356513E-01, -6.12532E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.471051E-01, -5.30089E-01, -6.104849E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.471051E-01, -5.30089E-01, -6.104849E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.221181E-01, -5.251449E-01, -6.077285E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <7.221181E-01, -5.251449E-01, -6.077285E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.040592E-01, -5.215716E-01, -6.046823E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <7.040592E-01, -5.215716E-01, -6.046823E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <6.956778E-01, -5.199132E-01, -6.018101E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <6.956778E-01, -5.199132E-01, -6.018101E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <6.982498E-01, -5.204222E-01, -5.995491E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <6.982498E-01, -5.204222E-01, -5.995491E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.113837E-01, -5.230209E-01, -5.982437E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.113837E-01, -5.230209E-01, -5.982437E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.3308E-01, -5.273139E-01, -5.980924E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.3308E-01, -5.273139E-01, -5.980924E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.600356E-01, -5.326475E-01, -5.991184E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.600356E-01, -5.326475E-01, -5.991184E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <7.881467E-01, -5.382098E-01, -6.011654E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <7.881467E-01, -5.382098E-01, -6.011654E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <8.131337E-01, -5.431539E-01, -6.039218E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <8.131337E-01, -5.431539E-01, -6.039218E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02> 
      <7.66388E-01, -5.458011E-01, -6.058252E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <8.311926E-01, -5.467272E-01, -6.069681E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
}
}
 
// Sphere
object {
union {
   smooth_triangle {
      <-5.755857E-01, 8.492053E-02, -5.096074E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-5.577575E-01, 8.492053E-02, -5.120422E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.577575E-01, 8.492053E-02, -5.120422E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-5.495867E-01, 8.492053E-02, -5.142313E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.495867E-01, 8.492053E-02, -5.142313E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-5.523179E-01, 8.492053E-02, -5.158414E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.523179E-01, 8.492053E-02, -5.158414E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-5.655362E-01, 8.492052E-02, -5.166273E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.655362E-01, 8.492052E-02, -5.166273E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-5.872277E-01, 8.492053E-02, -5.164694E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.872277E-01, 8.492053E-02, -5.164694E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-6.140906E-01, 8.492053E-02, -5.153918E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.140906E-01, 8.492053E-02, -5.153918E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-6.42036E-01, 8.492053E-02, -5.135584E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.42036E-01, 8.492053E-02, -5.135584E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-6.668085E-01, 8.492053E-02, -5.112485E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.668085E-01, 8.492053E-02, -5.112485E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-6.846367E-01, 8.492054E-02, -5.088137E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.846367E-01, 8.492054E-02, -5.088137E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-6.928074E-01, 8.492054E-02, -5.066246E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.928074E-01, 8.492054E-02, -5.066246E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-6.900762E-01, 8.492054E-02, -5.050145E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900762E-01, 8.492054E-02, -5.050145E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-6.76858E-01, 8.492055E-02, -5.042286E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.76858E-01, 8.492055E-02, -5.042286E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-6.551664E-01, 8.492054E-02, -5.043865E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.551664E-01, 8.492054E-02, -5.043865E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-6.283036E-01, 8.492054E-02, -5.054641E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.283036E-01, 8.492054E-02, -5.054641E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-6.003582E-01, 8.492054E-02, -5.072975E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.003582E-01, 8.492054E-02, -5.072975E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-5.755857E-01, 8.492053E-02, -5.096074E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      <-6.211971E-01, 9.235502E-02, -5.10428E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.755857E-01, 8.492053E-02, -5.096074E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-5.336698E-01, 6.321926E-02, -5.088532E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <-4.994567E-01, 6.321925E-02, -5.135257E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.755857E-01, 8.492053E-02, -5.096074E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-4.994567E-01, 6.321925E-02, -5.135257E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <-5.577575E-01, 8.492053E-02, -5.120422E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.577575E-01, 8.492053E-02, -5.120422E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-4.994567E-01, 6.321925E-02, -5.135257E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <-4.837777E-01, 6.321924E-02, -5.177266E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.577575E-01, 8.492053E-02, -5.120422E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-4.837777E-01, 6.321924E-02, -5.177266E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <-5.495867E-01, 8.492053E-02, -5.142313E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.495867E-01, 8.492053E-02, -5.142313E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-4.837777E-01, 6.321924E-02, -5.177266E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <-4.890195E-01, 6.321923E-02, -5.208163E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.495867E-01, 8.492053E-02, -5.142313E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-4.890195E-01, 6.321923E-02, -5.208163E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <-5.523179E-01, 8.492053E-02, -5.158414E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.523179E-01, 8.492053E-02, -5.158414E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-4.890195E-01, 6.321923E-02, -5.208163E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <-5.14384E-01, 6.321923E-02, -5.223244E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.523179E-01, 8.492053E-02, -5.158414E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-5.14384E-01, 6.321923E-02, -5.223244E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-5.655362E-01, 8.492052E-02, -5.166273E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.655362E-01, 8.492052E-02, -5.166273E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-5.14384E-01, 6.321923E-02, -5.223244E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-5.560101E-01, 6.321929E-02, -5.220215E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.655362E-01, 8.492052E-02, -5.166273E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-5.560101E-01, 6.321929E-02, -5.220215E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-5.872277E-01, 8.492053E-02, -5.164694E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.872277E-01, 8.492053E-02, -5.164694E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-5.560101E-01, 6.321929E-02, -5.220215E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-6.075597E-01, 6.32193E-02, -5.199535E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.872277E-01, 8.492053E-02, -5.164694E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-6.075597E-01, 6.32193E-02, -5.199535E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-6.140906E-01, 8.492053E-02, -5.153918E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.140906E-01, 8.492053E-02, -5.153918E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-6.075597E-01, 6.32193E-02, -5.199535E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-6.61186E-01, 6.321931E-02, -5.164354E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.140906E-01, 8.492053E-02, -5.153918E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-6.61186E-01, 6.321931E-02, -5.164354E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-6.42036E-01, 8.492053E-02, -5.135584E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.42036E-01, 8.492053E-02, -5.135584E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-6.61186E-01, 6.321931E-02, -5.164354E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-7.087243E-01, 6.321932E-02, -5.120027E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.42036E-01, 8.492053E-02, -5.135584E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-7.087243E-01, 6.321932E-02, -5.120027E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-6.668085E-01, 8.492053E-02, -5.112485E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.668085E-01, 8.492053E-02, -5.112485E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.087243E-01, 6.321932E-02, -5.120027E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-7.429374E-01, 6.321932E-02, -5.073302E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.668085E-01, 8.492053E-02, -5.112485E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.429374E-01, 6.321932E-02, -5.073302E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-6.846367E-01, 8.492054E-02, -5.088137E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.846367E-01, 8.492054E-02, -5.088137E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.429374E-01, 6.321932E-02, -5.073302E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-7.586165E-01, 6.321933E-02, -5.031293E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.846367E-01, 8.492054E-02, -5.088137E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.586165E-01, 6.321933E-02, -5.031293E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-6.928074E-01, 8.492054E-02, -5.066246E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.928074E-01, 8.492054E-02, -5.066246E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.586165E-01, 6.321933E-02, -5.031293E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-7.533747E-01, 6.321934E-02, -5.000396E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.928074E-01, 8.492054E-02, -5.066246E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.533747E-01, 6.321934E-02, -5.000396E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-6.900762E-01, 8.492054E-02, -5.050145E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900762E-01, 8.492054E-02, -5.050145E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.533747E-01, 6.321934E-02, -5.000396E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-7.280101E-01, 6.321934E-02, -4.985314E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900762E-01, 8.492054E-02, -5.050145E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.280101E-01, 6.321934E-02, -4.985314E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-6.76858E-01, 8.492055E-02, -5.042286E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.76858E-01, 8.492055E-02, -5.042286E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.280101E-01, 6.321934E-02, -4.985314E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-6.863841E-01, 6.321928E-02, -4.988344E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.76858E-01, 8.492055E-02, -5.042286E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-6.863841E-01, 6.321928E-02, -4.988344E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-6.551664E-01, 8.492054E-02, -5.043865E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.551664E-01, 8.492054E-02, -5.043865E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-6.863841E-01, 6.321928E-02, -4.988344E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-6.348344E-01, 6.321927E-02, -5.009024E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.551664E-01, 8.492054E-02, -5.043865E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-6.348344E-01, 6.321927E-02, -5.009024E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-6.283036E-01, 8.492054E-02, -5.054641E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.283036E-01, 8.492054E-02, -5.054641E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-6.348344E-01, 6.321927E-02, -5.009024E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-5.812079E-01, 6.321926E-02, -5.044206E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.283036E-01, 8.492054E-02, -5.054641E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-5.812079E-01, 6.321926E-02, -5.044206E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <-6.003582E-01, 8.492054E-02, -5.072975E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.003582E-01, 8.492054E-02, -5.072975E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-5.812079E-01, 6.321926E-02, -5.044206E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <-5.336698E-01, 6.321926E-02, -5.088532E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.003582E-01, 8.492054E-02, -5.072975E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-5.336698E-01, 6.321926E-02, -5.088532E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <-5.755857E-01, 8.492053E-02, -5.096074E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.336698E-01, 6.321926E-02, -5.088532E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <-4.988449E-01, 2.900947E-02, -5.082267E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <-4.510191E-01, 2.900946E-02, -5.147583E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.336698E-01, 6.321926E-02, -5.088532E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <-4.510191E-01, 2.900946E-02, -5.147583E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <-4.994567E-01, 6.321925E-02, -5.135257E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.994567E-01, 6.321925E-02, -5.135257E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <-4.510191E-01, 2.900946E-02, -5.147583E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <-4.291016E-01, 2.900945E-02, -5.206305E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.994567E-01, 6.321925E-02, -5.135257E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <-4.291016E-01, 2.900945E-02, -5.206305E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <-4.837777E-01, 6.321924E-02, -5.177266E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.837777E-01, 6.321924E-02, -5.177266E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <-4.291016E-01, 2.900945E-02, -5.206305E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <-4.364289E-01, 2.900945E-02, -5.249496E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.837777E-01, 6.321924E-02, -5.177266E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <-4.364289E-01, 2.900945E-02, -5.249496E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <-4.890195E-01, 6.321923E-02, -5.208163E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.890195E-01, 6.321923E-02, -5.208163E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <-4.364289E-01, 2.900945E-02, -5.249496E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <-4.718856E-01, 2.900944E-02, -5.270578E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.890195E-01, 6.321923E-02, -5.208163E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <-4.718856E-01, 2.900944E-02, -5.270578E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-5.14384E-01, 6.321923E-02, -5.223244E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.14384E-01, 6.321923E-02, -5.223244E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-4.718856E-01, 2.900944E-02, -5.270578E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-5.300733E-01, 2.900945E-02, -5.266343E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.14384E-01, 6.321923E-02, -5.223244E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-5.300733E-01, 2.900945E-02, -5.266343E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-5.560101E-01, 6.321929E-02, -5.220215E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.560101E-01, 6.321929E-02, -5.220215E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-5.300733E-01, 2.900945E-02, -5.266343E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-6.021344E-01, 2.900945E-02, -5.237435E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.560101E-01, 6.321929E-02, -5.220215E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-6.021344E-01, 2.900945E-02, -5.237435E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-6.075597E-01, 6.32193E-02, -5.199535E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.075597E-01, 6.32193E-02, -5.199535E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-6.021344E-01, 2.900945E-02, -5.237435E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-6.770968E-01, 2.900946E-02, -5.188256E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.075597E-01, 6.32193E-02, -5.199535E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-6.770968E-01, 2.900946E-02, -5.188256E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-6.61186E-01, 6.321931E-02, -5.164354E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.61186E-01, 6.321931E-02, -5.164354E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-6.770968E-01, 2.900946E-02, -5.188256E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-7.435493E-01, 2.900947E-02, -5.126292E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.61186E-01, 6.321931E-02, -5.164354E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-7.435493E-01, 2.900947E-02, -5.126292E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-7.087243E-01, 6.321932E-02, -5.120027E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.087243E-01, 6.321932E-02, -5.120027E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-7.435493E-01, 2.900947E-02, -5.126292E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-7.91375E-01, 2.900948E-02, -5.060977E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.087243E-01, 6.321932E-02, -5.120027E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-7.91375E-01, 2.900948E-02, -5.060977E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-7.429374E-01, 6.321932E-02, -5.073302E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.429374E-01, 6.321932E-02, -5.073302E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-7.91375E-01, 2.900948E-02, -5.060977E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-8.132924E-01, 2.900949E-02, -5.002254E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.429374E-01, 6.321932E-02, -5.073302E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-8.132924E-01, 2.900949E-02, -5.002254E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-7.586165E-01, 6.321933E-02, -5.031293E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.586165E-01, 6.321933E-02, -5.031293E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-8.132924E-01, 2.900949E-02, -5.002254E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-8.059652E-01, 2.900949E-02, -4.959064E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.586165E-01, 6.321933E-02, -5.031293E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-8.059652E-01, 2.900949E-02, -4.959064E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      <-7.533747E-01, 6.321934E-02, -5.000396E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.533747E-01, 6.321934E-02, -5.000396E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-8.059652E-01, 2.900949E-02, -4.959064E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      <-7.705086E-01, 2.900949E-02, -4.937981E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.533747E-01, 6.321934E-02, -5.000396E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-7.705086E-01, 2.900949E-02, -4.937981E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-7.280101E-01, 6.321934E-02, -4.985314E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.280101E-01, 6.321934E-02, -4.985314E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-7.705086E-01, 2.900949E-02, -4.937981E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-7.123207E-01, 2.900949E-02, -4.942216E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.280101E-01, 6.321934E-02, -4.985314E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-7.123207E-01, 2.900949E-02, -4.942216E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-6.863841E-01, 6.321928E-02, -4.988344E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.863841E-01, 6.321928E-02, -4.988344E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-7.123207E-01, 2.900949E-02, -4.942216E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-6.402597E-01, 2.900948E-02, -4.971124E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.863841E-01, 6.321928E-02, -4.988344E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-6.402597E-01, 2.900948E-02, -4.971124E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <-6.348344E-01, 6.321927E-02, -5.009024E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.348344E-01, 6.321927E-02, -5.009024E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <-6.402597E-01, 2.900948E-02, -4.971124E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <-5.652974E-01, 2.900947E-02, -5.020303E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.348344E-01, 6.321927E-02, -5.009024E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <-5.652974E-01, 2.900947E-02, -5.020303E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <-5.812079E-01, 6.321926E-02, -5.044206E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.812079E-01, 6.321926E-02, -5.044206E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <-5.652974E-01, 2.900947E-02, -5.020303E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <-4.988449E-01, 2.900947E-02, -5.082267E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.812079E-01, 6.321926E-02, -5.044206E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <-4.988449E-01, 2.900947E-02, -5.082267E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <-5.336698E-01, 6.321926E-02, -5.088532E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.988449E-01, 2.900947E-02, -5.082267E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <-4.73932E-01, -1.493748E-02, -5.077785E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <-4.163683E-01, -1.49375E-02, -5.1564E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.988449E-01, 2.900947E-02, -5.082267E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <-4.163683E-01, -1.49375E-02, -5.1564E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <-4.510191E-01, 2.900946E-02, -5.147583E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.510191E-01, 2.900946E-02, -5.147583E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <-4.163683E-01, -1.49375E-02, -5.1564E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <-3.899882E-01, -1.49375E-02, -5.227079E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.510191E-01, 2.900946E-02, -5.147583E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <-3.899882E-01, -1.49375E-02, -5.227079E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <-4.291016E-01, 2.900945E-02, -5.206305E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.291016E-01, 2.900945E-02, -5.206305E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <-3.899882E-01, -1.49375E-02, -5.227079E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <-3.988073E-01, -1.493751E-02, -5.279064E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.291016E-01, 2.900945E-02, -5.206305E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <-3.988073E-01, -1.493751E-02, -5.279064E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <-4.364289E-01, 2.900945E-02, -5.249496E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.364289E-01, 2.900945E-02, -5.249496E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <-3.988073E-01, -1.493751E-02, -5.279064E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <-4.414835E-01, -1.493751E-02, -5.304439E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.364289E-01, 2.900945E-02, -5.249496E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <-4.414835E-01, -1.493751E-02, -5.304439E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-4.718856E-01, 2.900944E-02, -5.270578E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.718856E-01, 2.900944E-02, -5.270578E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-4.414835E-01, -1.493751E-02, -5.304439E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-5.115191E-01, -1.493751E-02, -5.299342E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.718856E-01, 2.900944E-02, -5.270578E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-5.115191E-01, -1.493751E-02, -5.299342E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-5.300733E-01, 2.900945E-02, -5.266343E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.300733E-01, 2.900945E-02, -5.266343E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-5.115191E-01, -1.493751E-02, -5.299342E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-5.982525E-01, -1.49375E-02, -5.264548E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.300733E-01, 2.900945E-02, -5.266343E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-5.982525E-01, -1.49375E-02, -5.264548E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-6.021344E-01, 2.900945E-02, -5.237435E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.021344E-01, 2.900945E-02, -5.237435E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-5.982525E-01, -1.49375E-02, -5.264548E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-6.884789E-01, -1.493749E-02, -5.205355E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.021344E-01, 2.900945E-02, -5.237435E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-6.884789E-01, -1.493749E-02, -5.205355E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-6.770968E-01, 2.900946E-02, -5.188256E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.770968E-01, 2.900946E-02, -5.188256E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-6.884789E-01, -1.493749E-02, -5.205355E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-7.684624E-01, -1.493748E-02, -5.130774E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.770968E-01, 2.900946E-02, -5.188256E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-7.684624E-01, -1.493748E-02, -5.130774E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-7.435493E-01, 2.900947E-02, -5.126292E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.435493E-01, 2.900947E-02, -5.126292E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-7.684624E-01, -1.493748E-02, -5.130774E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-8.260261E-01, -1.493744E-02, -5.052159E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.435493E-01, 2.900947E-02, -5.126292E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-8.260261E-01, -1.493744E-02, -5.052159E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-7.91375E-01, 2.900948E-02, -5.060977E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.91375E-01, 2.900948E-02, -5.060977E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-8.260261E-01, -1.493744E-02, -5.052159E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-8.52406E-01, -1.493746E-02, -4.98148E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.91375E-01, 2.900948E-02, -5.060977E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-8.52406E-01, -1.493746E-02, -4.98148E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-8.132924E-01, 2.900949E-02, -5.002254E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.132924E-01, 2.900949E-02, -5.002254E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-8.52406E-01, -1.493746E-02, -4.98148E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-8.435869E-01, -1.493746E-02, -4.929495E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.132924E-01, 2.900949E-02, -5.002254E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-8.435869E-01, -1.493746E-02, -4.929495E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-8.059652E-01, 2.900949E-02, -4.959064E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.059652E-01, 2.900949E-02, -4.959064E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01> 
      <-8.435869E-01, -1.493746E-02, -4.929495E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-8.009104E-01, -1.493745E-02, -4.904121E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.059652E-01, 2.900949E-02, -4.959064E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01> 
      <-8.009104E-01, -1.493745E-02, -4.904121E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-7.705086E-01, 2.900949E-02, -4.937981E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.705086E-01, 2.900949E-02, -4.937981E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-8.009104E-01, -1.493745E-02, -4.904121E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-7.308747E-01, -1.493746E-02, -4.909218E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.705086E-01, 2.900949E-02, -4.937981E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-7.308747E-01, -1.493746E-02, -4.909218E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-7.123207E-01, 2.900949E-02, -4.942216E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.123207E-01, 2.900949E-02, -4.942216E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-7.308747E-01, -1.493746E-02, -4.909218E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-6.441416E-01, -1.493746E-02, -4.944011E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.123207E-01, 2.900949E-02, -4.942216E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-6.441416E-01, -1.493746E-02, -4.944011E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <-6.402597E-01, 2.900948E-02, -4.971124E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.402597E-01, 2.900948E-02, -4.971124E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <-6.441416E-01, -1.493746E-02, -4.944011E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <-5.539149E-01, -1.493748E-02, -5.003204E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.402597E-01, 2.900948E-02, -4.971124E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <-5.539149E-01, -1.493748E-02, -5.003204E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <-5.652974E-01, 2.900947E-02, -5.020303E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.652974E-01, 2.900947E-02, -5.020303E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <-5.539149E-01, -1.493748E-02, -5.003204E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <-4.73932E-01, -1.493748E-02, -5.077785E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.652974E-01, 2.900947E-02, -5.020303E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <-4.73932E-01, -1.493748E-02, -5.077785E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <-4.988449E-01, 2.900947E-02, -5.082267E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.73932E-01, -1.493748E-02, -5.077785E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <-4.609497E-01, -6.506126E-02, -5.075449E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <-3.983114E-01, -6.506128E-02, -5.160994E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.73932E-01, -1.493748E-02, -5.077785E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <-3.983114E-01, -6.506128E-02, -5.160994E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <-4.163683E-01, -1.49375E-02, -5.1564E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.163683E-01, -1.49375E-02, -5.1564E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <-3.983114E-01, -6.506128E-02, -5.160994E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <-3.696055E-01, -6.506129E-02, -5.237905E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.163683E-01, -1.49375E-02, -5.1564E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <-3.696055E-01, -6.506129E-02, -5.237905E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <-3.899882E-01, -1.49375E-02, -5.227079E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.899882E-01, -1.49375E-02, -5.227079E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <-3.696055E-01, -6.506129E-02, -5.237905E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <-3.792024E-01, -6.506129E-02, -5.294472E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.899882E-01, -1.49375E-02, -5.227079E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <-3.792024E-01, -6.506129E-02, -5.294472E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <-3.988073E-01, -1.493751E-02, -5.279064E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.988073E-01, -1.493751E-02, -5.279064E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <-3.792024E-01, -6.506129E-02, -5.294472E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <-4.256408E-01, -6.506129E-02, -5.322083E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.988073E-01, -1.493751E-02, -5.279064E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <-4.256408E-01, -6.506129E-02, -5.322083E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-4.414835E-01, -1.493751E-02, -5.304439E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.414835E-01, -1.493751E-02, -5.304439E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-4.256408E-01, -6.506129E-02, -5.322083E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-5.018507E-01, -6.506129E-02, -5.316537E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.414835E-01, -1.493751E-02, -5.304439E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-5.018507E-01, -6.506129E-02, -5.316537E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-5.115191E-01, -1.493751E-02, -5.299342E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.115191E-01, -1.493751E-02, -5.299342E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-5.018507E-01, -6.506129E-02, -5.316537E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-5.962297E-01, -6.506129E-02, -5.278677E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.115191E-01, -1.493751E-02, -5.299342E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-5.962297E-01, -6.506129E-02, -5.278677E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-5.982525E-01, -1.49375E-02, -5.264548E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.982525E-01, -1.49375E-02, -5.264548E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-5.962297E-01, -6.506129E-02, -5.278677E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-6.944099E-01, -6.506127E-02, -5.214266E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.982525E-01, -1.49375E-02, -5.264548E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-6.944099E-01, -6.506127E-02, -5.214266E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-6.884789E-01, -1.493749E-02, -5.205355E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.884789E-01, -1.493749E-02, -5.205355E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-6.944099E-01, -6.506127E-02, -5.214266E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-7.814445E-01, -6.506126E-02, -5.13311E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.884789E-01, -1.493749E-02, -5.205355E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-7.814445E-01, -6.506126E-02, -5.13311E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-7.684624E-01, -1.493748E-02, -5.130774E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.684624E-01, -1.493748E-02, -5.130774E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-7.814445E-01, -6.506126E-02, -5.13311E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-8.440827E-01, -6.506125E-02, -5.047565E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.684624E-01, -1.493748E-02, -5.130774E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-8.440827E-01, -6.506125E-02, -5.047565E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-8.260261E-01, -1.493744E-02, -5.052159E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.260261E-01, -1.493744E-02, -5.052159E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-8.440827E-01, -6.506125E-02, -5.047565E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-8.727885E-01, -6.506124E-02, -4.970654E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.260261E-01, -1.493744E-02, -5.052159E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-8.727885E-01, -6.506124E-02, -4.970654E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-8.52406E-01, -1.493746E-02, -4.98148E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.52406E-01, -1.493746E-02, -4.98148E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-8.727885E-01, -6.506124E-02, -4.970654E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-8.631917E-01, -6.506123E-02, -4.914087E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.52406E-01, -1.493746E-02, -4.98148E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-8.631917E-01, -6.506123E-02, -4.914087E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-8.435869E-01, -1.493746E-02, -4.929495E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.435869E-01, -1.493746E-02, -4.929495E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-8.631917E-01, -6.506123E-02, -4.914087E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-8.167533E-01, -6.506123E-02, -4.886476E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.435869E-01, -1.493746E-02, -4.929495E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-8.167533E-01, -6.506123E-02, -4.886476E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-8.009104E-01, -1.493745E-02, -4.904121E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.009104E-01, -1.493745E-02, -4.904121E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-8.167533E-01, -6.506123E-02, -4.886476E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-7.405433E-01, -6.506123E-02, -4.892022E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.009104E-01, -1.493745E-02, -4.904121E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-7.405433E-01, -6.506123E-02, -4.892022E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-7.308747E-01, -1.493746E-02, -4.909218E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.308747E-01, -1.493746E-02, -4.909218E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-7.405433E-01, -6.506123E-02, -4.892022E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-6.461641E-01, -6.506124E-02, -4.929883E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.308747E-01, -1.493746E-02, -4.909218E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-6.461641E-01, -6.506124E-02, -4.929883E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <-6.441416E-01, -1.493746E-02, -4.944011E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.441416E-01, -1.493746E-02, -4.944011E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <-6.461641E-01, -6.506124E-02, -4.929883E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <-5.479839E-01, -6.506126E-02, -4.994294E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.441416E-01, -1.493746E-02, -4.944011E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <-5.479839E-01, -6.506126E-02, -4.994294E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <-5.539149E-01, -1.493748E-02, -5.003204E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.539149E-01, -1.493748E-02, -5.003204E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <-5.479839E-01, -6.506126E-02, -4.994294E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <-4.609497E-01, -6.506126E-02, -5.075449E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.539149E-01, -1.493748E-02, -5.003204E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <-4.609497E-01, -6.506126E-02, -5.075449E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <-4.73932E-01, -1.493748E-02, -5.077785E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.609497E-01, -6.506126E-02, -5.075449E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <-4.609497E-01, -1.173011E-01, -5.075449E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      <-3.983114E-01, -1.173012E-01, -5.160994E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.609497E-01, -6.506126E-02, -5.075449E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <-3.983114E-01, -1.173012E-01, -5.160994E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <-3.983114E-01, -6.506128E-02, -5.160994E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.983114E-01, -6.506128E-02, -5.160994E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <-3.983114E-01, -1.173012E-01, -5.160994E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <-3.696055E-01, -1.173012E-01, -5.237905E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.983114E-01, -6.506128E-02, -5.160994E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <-3.696055E-01, -1.173012E-01, -5.237905E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <-3.696055E-01, -6.506129E-02, -5.237905E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.696055E-01, -6.506129E-02, -5.237905E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <-3.696055E-01, -1.173012E-01, -5.237905E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <-3.792024E-01, -1.173012E-01, -5.294472E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.696055E-01, -6.506129E-02, -5.237905E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <-3.792024E-01, -1.173012E-01, -5.294472E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <-3.792024E-01, -6.506129E-02, -5.294472E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.792024E-01, -6.506129E-02, -5.294472E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <-3.792024E-01, -1.173012E-01, -5.294472E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <-4.256408E-01, -1.173012E-01, -5.322083E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.792024E-01, -6.506129E-02, -5.294472E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <-4.256408E-01, -1.173012E-01, -5.322083E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-4.256408E-01, -6.506129E-02, -5.322083E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.256408E-01, -6.506129E-02, -5.322083E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-4.256408E-01, -1.173012E-01, -5.322083E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-5.018507E-01, -1.173012E-01, -5.316537E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.256408E-01, -6.506129E-02, -5.322083E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-5.018507E-01, -1.173012E-01, -5.316537E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      <-5.018507E-01, -6.506129E-02, -5.316537E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.018507E-01, -6.506129E-02, -5.316537E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-5.018507E-01, -1.173012E-01, -5.316537E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      <-5.962297E-01, -1.173012E-01, -5.278677E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.018507E-01, -6.506129E-02, -5.316537E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-5.962297E-01, -1.173012E-01, -5.278677E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-5.962297E-01, -6.506129E-02, -5.278677E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.962297E-01, -6.506129E-02, -5.278677E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-5.962297E-01, -1.173012E-01, -5.278677E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-6.944099E-01, -1.173011E-01, -5.214266E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.962297E-01, -6.506129E-02, -5.278677E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-6.944099E-01, -1.173011E-01, -5.214266E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-6.944099E-01, -6.506127E-02, -5.214266E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.944099E-01, -6.506127E-02, -5.214266E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-6.944099E-01, -1.173011E-01, -5.214266E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-7.814445E-01, -1.173011E-01, -5.13311E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.944099E-01, -6.506127E-02, -5.214266E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-7.814445E-01, -1.173011E-01, -5.13311E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-7.814445E-01, -6.506126E-02, -5.13311E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.814445E-01, -6.506126E-02, -5.13311E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-7.814445E-01, -1.173011E-01, -5.13311E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-8.440827E-01, -1.173011E-01, -5.047565E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.814445E-01, -6.506126E-02, -5.13311E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-8.440827E-01, -1.173011E-01, -5.047565E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-8.440827E-01, -6.506125E-02, -5.047565E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.440827E-01, -6.506125E-02, -5.047565E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-8.440827E-01, -1.173011E-01, -5.047565E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-8.727885E-01, -1.173011E-01, -4.970654E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.440827E-01, -6.506125E-02, -5.047565E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-8.727885E-01, -1.173011E-01, -4.970654E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-8.727885E-01, -6.506124E-02, -4.970654E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.727885E-01, -6.506124E-02, -4.970654E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-8.727885E-01, -1.173011E-01, -4.970654E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-8.631917E-01, -1.173011E-01, -4.914087E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.727885E-01, -6.506124E-02, -4.970654E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-8.631917E-01, -1.173011E-01, -4.914087E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-8.631917E-01, -6.506123E-02, -4.914087E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.631917E-01, -6.506123E-02, -4.914087E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-8.631917E-01, -1.173011E-01, -4.914087E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-8.167533E-01, -1.173011E-01, -4.886476E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.631917E-01, -6.506123E-02, -4.914087E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-8.167533E-01, -1.173011E-01, -4.886476E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-8.167533E-01, -6.506123E-02, -4.886476E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.167533E-01, -6.506123E-02, -4.886476E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-8.167533E-01, -1.173011E-01, -4.886476E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-7.405433E-01, -1.173011E-01, -4.892022E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.167533E-01, -6.506123E-02, -4.886476E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-7.405433E-01, -1.173011E-01, -4.892022E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-7.405433E-01, -6.506123E-02, -4.892022E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.405433E-01, -6.506123E-02, -4.892022E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-7.405433E-01, -1.173011E-01, -4.892022E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-6.461641E-01, -1.173011E-01, -4.929883E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.405433E-01, -6.506123E-02, -4.892022E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-6.461641E-01, -1.173011E-01, -4.929883E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <-6.461641E-01, -6.506124E-02, -4.929883E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.461641E-01, -6.506124E-02, -4.929883E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <-6.461641E-01, -1.173011E-01, -4.929883E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <-5.479839E-01, -1.173011E-01, -4.994294E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.461641E-01, -6.506124E-02, -4.929883E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <-5.479839E-01, -1.173011E-01, -4.994294E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <-5.479839E-01, -6.506126E-02, -4.994294E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.479839E-01, -6.506126E-02, -4.994294E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <-5.479839E-01, -1.173011E-01, -4.994294E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <-4.609497E-01, -1.173011E-01, -5.075449E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.479839E-01, -6.506126E-02, -4.994294E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <-4.609497E-01, -1.173011E-01, -5.075449E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      <-4.609497E-01, -6.506126E-02, -5.075449E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.609497E-01, -1.173011E-01, -5.075449E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02> 
      <-4.73932E-01, -1.674249E-01, -5.077785E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <-4.163683E-01, -1.674249E-01, -5.156399E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.609497E-01, -1.173011E-01, -5.075449E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02> 
      <-4.163683E-01, -1.674249E-01, -5.156399E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <-3.983114E-01, -1.173012E-01, -5.160994E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.983114E-01, -1.173012E-01, -5.160994E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <-4.163683E-01, -1.674249E-01, -5.156399E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <-3.899882E-01, -1.674249E-01, -5.227079E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.983114E-01, -1.173012E-01, -5.160994E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <-3.899882E-01, -1.674249E-01, -5.227079E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <-3.696055E-01, -1.173012E-01, -5.237905E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.696055E-01, -1.173012E-01, -5.237905E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <-3.899882E-01, -1.674249E-01, -5.227079E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <-3.988073E-01, -1.674249E-01, -5.279064E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.696055E-01, -1.173012E-01, -5.237905E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <-3.988073E-01, -1.674249E-01, -5.279064E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      <-3.792024E-01, -1.173012E-01, -5.294472E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.792024E-01, -1.173012E-01, -5.294472E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <-3.988073E-01, -1.674249E-01, -5.279064E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      <-4.414837E-01, -1.674249E-01, -5.304438E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.792024E-01, -1.173012E-01, -5.294472E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <-4.414837E-01, -1.674249E-01, -5.304438E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      <-4.256408E-01, -1.173012E-01, -5.322083E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.256408E-01, -1.173012E-01, -5.322083E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-4.414837E-01, -1.674249E-01, -5.304438E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      <-5.115194E-01, -1.674249E-01, -5.299341E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.256408E-01, -1.173012E-01, -5.322083E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-5.115194E-01, -1.674249E-01, -5.299341E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-5.018507E-01, -1.173012E-01, -5.316537E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.018507E-01, -1.173012E-01, -5.316537E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01> 
      <-5.115194E-01, -1.674249E-01, -5.299341E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-5.982525E-01, -1.674249E-01, -5.264548E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.018507E-01, -1.173012E-01, -5.316537E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01> 
      <-5.982525E-01, -1.674249E-01, -5.264548E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-5.962297E-01, -1.173012E-01, -5.278677E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.962297E-01, -1.173012E-01, -5.278677E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-5.982525E-01, -1.674249E-01, -5.264548E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-6.884789E-01, -1.674249E-01, -5.205355E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.962297E-01, -1.173012E-01, -5.278677E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-6.884789E-01, -1.674249E-01, -5.205355E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-6.944099E-01, -1.173011E-01, -5.214266E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.944099E-01, -1.173011E-01, -5.214266E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-6.884789E-01, -1.674249E-01, -5.205355E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-7.684624E-01, -1.674249E-01, -5.130774E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.944099E-01, -1.173011E-01, -5.214266E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-7.684624E-01, -1.674249E-01, -5.130774E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-7.814445E-01, -1.173011E-01, -5.13311E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.814445E-01, -1.173011E-01, -5.13311E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-7.684624E-01, -1.674249E-01, -5.130774E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-8.260258E-01, -1.674249E-01, -5.052159E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.814445E-01, -1.173011E-01, -5.13311E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-8.260258E-01, -1.674249E-01, -5.052159E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-8.440827E-01, -1.173011E-01, -5.047565E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.440827E-01, -1.173011E-01, -5.047565E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-8.260258E-01, -1.674249E-01, -5.052159E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-8.524059E-01, -1.674248E-01, -4.98148E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.440827E-01, -1.173011E-01, -5.047565E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-8.524059E-01, -1.674248E-01, -4.98148E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-8.727885E-01, -1.173011E-01, -4.970654E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.727885E-01, -1.173011E-01, -4.970654E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-8.524059E-01, -1.674248E-01, -4.98148E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-8.435869E-01, -1.674249E-01, -4.929495E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.727885E-01, -1.173011E-01, -4.970654E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-8.435869E-01, -1.674249E-01, -4.929495E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      <-8.631917E-01, -1.173011E-01, -4.914087E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.631917E-01, -1.173011E-01, -4.914087E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-8.435869E-01, -1.674249E-01, -4.929495E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      <-8.009104E-01, -1.674248E-01, -4.904121E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.631917E-01, -1.173011E-01, -4.914087E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-8.009104E-01, -1.674248E-01, -4.904121E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      <-8.167533E-01, -1.173011E-01, -4.886476E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.167533E-01, -1.173011E-01, -4.886476E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-8.009104E-01, -1.674248E-01, -4.904121E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      <-7.308747E-01, -1.674248E-01, -4.909218E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.167533E-01, -1.173011E-01, -4.886476E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-7.308747E-01, -1.674248E-01, -4.909218E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      <-7.405433E-01, -1.173011E-01, -4.892022E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.405433E-01, -1.173011E-01, -4.892022E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-7.308747E-01, -1.674248E-01, -4.909218E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      <-6.441416E-01, -1.674249E-01, -4.944011E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.405433E-01, -1.173011E-01, -4.892022E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-6.441416E-01, -1.674249E-01, -4.944011E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <-6.461641E-01, -1.173011E-01, -4.929883E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.461641E-01, -1.173011E-01, -4.929883E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <-6.441416E-01, -1.674249E-01, -4.944011E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <-5.539149E-01, -1.674249E-01, -5.003204E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.461641E-01, -1.173011E-01, -4.929883E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <-5.539149E-01, -1.674249E-01, -5.003204E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <-5.479839E-01, -1.173011E-01, -4.994294E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.479839E-01, -1.173011E-01, -4.994294E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <-5.539149E-01, -1.674249E-01, -5.003204E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <-4.73932E-01, -1.674249E-01, -5.077785E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.479839E-01, -1.173011E-01, -4.994294E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <-4.73932E-01, -1.674249E-01, -5.077785E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <-4.609497E-01, -1.173011E-01, -5.075449E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.73932E-01, -1.674249E-01, -5.077785E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <-4.988452E-01, -2.113718E-01, -5.082266E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <-4.510191E-01, -2.113718E-01, -5.147583E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.73932E-01, -1.674249E-01, -5.077785E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <-4.510191E-01, -2.113718E-01, -5.147583E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <-4.163683E-01, -1.674249E-01, -5.156399E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.163683E-01, -1.674249E-01, -5.156399E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <-4.510191E-01, -2.113718E-01, -5.147583E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <-4.291016E-01, -2.113719E-01, -5.206305E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.163683E-01, -1.674249E-01, -5.156399E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <-4.291016E-01, -2.113719E-01, -5.206305E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <-3.899882E-01, -1.674249E-01, -5.227079E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.899882E-01, -1.674249E-01, -5.227079E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <-4.291016E-01, -2.113719E-01, -5.206305E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <-4.364289E-01, -2.113719E-01, -5.249496E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.899882E-01, -1.674249E-01, -5.227079E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <-4.364289E-01, -2.113719E-01, -5.249496E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <-3.988073E-01, -1.674249E-01, -5.279064E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.988073E-01, -1.674249E-01, -5.279064E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01> 
      <-4.364289E-01, -2.113719E-01, -5.249496E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <-4.718856E-01, -2.113719E-01, -5.270578E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-3.988073E-01, -1.674249E-01, -5.279064E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01> 
      <-4.718856E-01, -2.113719E-01, -5.270578E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-4.414837E-01, -1.674249E-01, -5.304438E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.414837E-01, -1.674249E-01, -5.304438E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01> 
      <-4.718856E-01, -2.113719E-01, -5.270578E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-5.300735E-01, -2.113719E-01, -5.266343E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.414837E-01, -1.674249E-01, -5.304438E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01> 
      <-5.300735E-01, -2.113719E-01, -5.266343E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-5.115194E-01, -1.674249E-01, -5.299341E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.115194E-01, -1.674249E-01, -5.299341E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-5.300735E-01, -2.113719E-01, -5.266343E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-6.021344E-01, -2.113718E-01, -5.237435E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.115194E-01, -1.674249E-01, -5.299341E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-6.021344E-01, -2.113718E-01, -5.237435E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-5.982525E-01, -1.674249E-01, -5.264548E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.982525E-01, -1.674249E-01, -5.264548E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-6.021344E-01, -2.113718E-01, -5.237435E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-6.770967E-01, -2.113718E-01, -5.188256E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.982525E-01, -1.674249E-01, -5.264548E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-6.770967E-01, -2.113718E-01, -5.188256E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-6.884789E-01, -1.674249E-01, -5.205355E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.884789E-01, -1.674249E-01, -5.205355E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-6.770967E-01, -2.113718E-01, -5.188256E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-7.435493E-01, -2.113718E-01, -5.126292E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.884789E-01, -1.674249E-01, -5.205355E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-7.435493E-01, -2.113718E-01, -5.126292E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-7.684624E-01, -1.674249E-01, -5.130774E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.684624E-01, -1.674249E-01, -5.130774E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-7.435493E-01, -2.113718E-01, -5.126292E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-7.91375E-01, -2.113718E-01, -5.060977E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.684624E-01, -1.674249E-01, -5.130774E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-7.91375E-01, -2.113718E-01, -5.060977E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-8.260258E-01, -1.674249E-01, -5.052159E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.260258E-01, -1.674249E-01, -5.052159E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-7.91375E-01, -2.113718E-01, -5.060977E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-8.132924E-01, -2.113718E-01, -5.002254E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.260258E-01, -1.674249E-01, -5.052159E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-8.132924E-01, -2.113718E-01, -5.002254E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-8.524059E-01, -1.674248E-01, -4.98148E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.524059E-01, -1.674248E-01, -4.98148E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-8.132924E-01, -2.113718E-01, -5.002254E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-8.059652E-01, -2.113718E-01, -4.959064E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.524059E-01, -1.674248E-01, -4.98148E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-8.059652E-01, -2.113718E-01, -4.959064E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-8.435869E-01, -1.674249E-01, -4.929495E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.435869E-01, -1.674249E-01, -4.929495E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01> 
      <-8.059652E-01, -2.113718E-01, -4.959064E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-7.705086E-01, -2.113718E-01, -4.937981E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.435869E-01, -1.674249E-01, -4.929495E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01> 
      <-7.705086E-01, -2.113718E-01, -4.937981E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-8.009104E-01, -1.674248E-01, -4.904121E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.009104E-01, -1.674248E-01, -4.904121E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01> 
      <-7.705086E-01, -2.113718E-01, -4.937981E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-7.123207E-01, -2.113718E-01, -4.942216E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.009104E-01, -1.674248E-01, -4.904121E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01> 
      <-7.123207E-01, -2.113718E-01, -4.942216E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-7.308747E-01, -1.674248E-01, -4.909218E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.308747E-01, -1.674248E-01, -4.909218E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01> 
      <-7.123207E-01, -2.113718E-01, -4.942216E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-6.402598E-01, -2.113718E-01, -4.971124E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.308747E-01, -1.674248E-01, -4.909218E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01> 
      <-6.402598E-01, -2.113718E-01, -4.971124E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <-6.441416E-01, -1.674249E-01, -4.944011E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.441416E-01, -1.674249E-01, -4.944011E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <-6.402598E-01, -2.113718E-01, -4.971124E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <-5.652974E-01, -2.113718E-01, -5.020303E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.441416E-01, -1.674249E-01, -4.944011E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <-5.652974E-01, -2.113718E-01, -5.020303E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <-5.539149E-01, -1.674249E-01, -5.003204E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.539149E-01, -1.674249E-01, -5.003204E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <-5.652974E-01, -2.113718E-01, -5.020303E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <-4.988452E-01, -2.113718E-01, -5.082266E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.539149E-01, -1.674249E-01, -5.003204E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <-4.988452E-01, -2.113718E-01, -5.082266E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <-4.73932E-01, -1.674249E-01, -5.077785E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.988452E-01, -2.113718E-01, -5.082266E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <-5.336698E-01, -2.455816E-01, -5.088532E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <-4.994567E-01, -2.455816E-01, -5.135257E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.988452E-01, -2.113718E-01, -5.082266E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <-4.994567E-01, -2.455816E-01, -5.135257E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <-4.510191E-01, -2.113718E-01, -5.147583E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.510191E-01, -2.113718E-01, -5.147583E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <-4.994567E-01, -2.455816E-01, -5.135257E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <-4.837777E-01, -2.455817E-01, -5.177266E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.510191E-01, -2.113718E-01, -5.147583E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <-4.837777E-01, -2.455817E-01, -5.177266E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <-4.291016E-01, -2.113719E-01, -5.206305E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.291016E-01, -2.113719E-01, -5.206305E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <-4.837777E-01, -2.455817E-01, -5.177266E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <-4.890198E-01, -2.455817E-01, -5.208162E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.291016E-01, -2.113719E-01, -5.206305E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <-4.890198E-01, -2.455817E-01, -5.208162E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <-4.364289E-01, -2.113719E-01, -5.249496E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.364289E-01, -2.113719E-01, -5.249496E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <-4.890198E-01, -2.455817E-01, -5.208162E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <-5.14384E-01, -2.455817E-01, -5.223244E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.364289E-01, -2.113719E-01, -5.249496E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <-5.14384E-01, -2.455817E-01, -5.223244E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-4.718856E-01, -2.113719E-01, -5.270578E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.718856E-01, -2.113719E-01, -5.270578E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-5.14384E-01, -2.455817E-01, -5.223244E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-5.5601E-01, -2.455817E-01, -5.220215E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.718856E-01, -2.113719E-01, -5.270578E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-5.5601E-01, -2.455817E-01, -5.220215E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-5.300735E-01, -2.113719E-01, -5.266343E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.300735E-01, -2.113719E-01, -5.266343E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-5.5601E-01, -2.455817E-01, -5.220215E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-6.075597E-01, -2.455817E-01, -5.199535E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.300735E-01, -2.113719E-01, -5.266343E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-6.075597E-01, -2.455817E-01, -5.199535E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-6.021344E-01, -2.113718E-01, -5.237435E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.021344E-01, -2.113718E-01, -5.237435E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-6.075597E-01, -2.455817E-01, -5.199535E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-6.61186E-01, -2.455816E-01, -5.164354E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.021344E-01, -2.113718E-01, -5.237435E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-6.61186E-01, -2.455816E-01, -5.164354E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-6.770967E-01, -2.113718E-01, -5.188256E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.770967E-01, -2.113718E-01, -5.188256E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-6.61186E-01, -2.455816E-01, -5.164354E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-7.087243E-01, -2.455816E-01, -5.120027E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.770967E-01, -2.113718E-01, -5.188256E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-7.087243E-01, -2.455816E-01, -5.120027E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-7.435493E-01, -2.113718E-01, -5.126292E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.435493E-01, -2.113718E-01, -5.126292E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-7.087243E-01, -2.455816E-01, -5.120027E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-7.429374E-01, -2.455816E-01, -5.073302E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.435493E-01, -2.113718E-01, -5.126292E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-7.429374E-01, -2.455816E-01, -5.073302E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-7.91375E-01, -2.113718E-01, -5.060977E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.91375E-01, -2.113718E-01, -5.060977E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-7.429374E-01, -2.455816E-01, -5.073302E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-7.586164E-01, -2.455816E-01, -5.031293E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.91375E-01, -2.113718E-01, -5.060977E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-7.586164E-01, -2.455816E-01, -5.031293E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-8.132924E-01, -2.113718E-01, -5.002254E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.132924E-01, -2.113718E-01, -5.002254E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-7.586164E-01, -2.455816E-01, -5.031293E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-7.533746E-01, -2.455816E-01, -5.000396E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.132924E-01, -2.113718E-01, -5.002254E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-7.533746E-01, -2.455816E-01, -5.000396E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-8.059652E-01, -2.113718E-01, -4.959064E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.059652E-01, -2.113718E-01, -4.959064E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-7.533746E-01, -2.455816E-01, -5.000396E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-7.280101E-01, -2.455816E-01, -4.985314E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-8.059652E-01, -2.113718E-01, -4.959064E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-7.280101E-01, -2.455816E-01, -4.985314E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-7.705086E-01, -2.113718E-01, -4.937981E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.705086E-01, -2.113718E-01, -4.937981E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-7.280101E-01, -2.455816E-01, -4.985314E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-6.863841E-01, -2.455816E-01, -4.988344E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.705086E-01, -2.113718E-01, -4.937981E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-6.863841E-01, -2.455816E-01, -4.988344E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-7.123207E-01, -2.113718E-01, -4.942216E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.123207E-01, -2.113718E-01, -4.942216E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-6.863841E-01, -2.455816E-01, -4.988344E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-6.348344E-01, -2.455816E-01, -5.009024E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.123207E-01, -2.113718E-01, -4.942216E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-6.348344E-01, -2.455816E-01, -5.009024E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <-6.402598E-01, -2.113718E-01, -4.971124E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.402598E-01, -2.113718E-01, -4.971124E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <-6.348344E-01, -2.455816E-01, -5.009024E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <-5.812079E-01, -2.455816E-01, -5.044206E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.402598E-01, -2.113718E-01, -4.971124E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <-5.812079E-01, -2.455816E-01, -5.044206E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <-5.652974E-01, -2.113718E-01, -5.020303E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.652974E-01, -2.113718E-01, -5.020303E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <-5.812079E-01, -2.455816E-01, -5.044206E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <-5.336698E-01, -2.455816E-01, -5.088532E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.652974E-01, -2.113718E-01, -5.020303E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <-5.336698E-01, -2.455816E-01, -5.088532E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <-4.988452E-01, -2.113718E-01, -5.082266E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.336698E-01, -2.455816E-01, -5.088532E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <-5.755857E-01, -2.672829E-01, -5.096074E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <-5.577575E-01, -2.672829E-01, -5.120422E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.336698E-01, -2.455816E-01, -5.088532E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <-5.577575E-01, -2.672829E-01, -5.120422E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <-4.994567E-01, -2.455816E-01, -5.135257E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.994567E-01, -2.455816E-01, -5.135257E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <-5.577575E-01, -2.672829E-01, -5.120422E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <-5.495868E-01, -2.672829E-01, -5.142313E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.994567E-01, -2.455816E-01, -5.135257E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <-5.495868E-01, -2.672829E-01, -5.142313E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <-4.837777E-01, -2.455817E-01, -5.177266E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.837777E-01, -2.455817E-01, -5.177266E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <-5.495868E-01, -2.672829E-01, -5.142313E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <-5.523179E-01, -2.672829E-01, -5.158414E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.837777E-01, -2.455817E-01, -5.177266E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <-5.523179E-01, -2.672829E-01, -5.158414E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-4.890198E-01, -2.455817E-01, -5.208162E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.890198E-01, -2.455817E-01, -5.208162E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-5.523179E-01, -2.672829E-01, -5.158414E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-5.655362E-01, -2.672829E-01, -5.166273E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-4.890198E-01, -2.455817E-01, -5.208162E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-5.655362E-01, -2.672829E-01, -5.166273E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-5.14384E-01, -2.455817E-01, -5.223244E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.14384E-01, -2.455817E-01, -5.223244E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-5.655362E-01, -2.672829E-01, -5.166273E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-5.872276E-01, -2.672829E-01, -5.164694E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.14384E-01, -2.455817E-01, -5.223244E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-5.872276E-01, -2.672829E-01, -5.164694E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-5.5601E-01, -2.455817E-01, -5.220215E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.5601E-01, -2.455817E-01, -5.220215E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-5.872276E-01, -2.672829E-01, -5.164694E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-6.140906E-01, -2.672829E-01, -5.153918E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.5601E-01, -2.455817E-01, -5.220215E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-6.140906E-01, -2.672829E-01, -5.153918E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-6.075597E-01, -2.455817E-01, -5.199535E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.075597E-01, -2.455817E-01, -5.199535E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-6.140906E-01, -2.672829E-01, -5.153918E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-6.420359E-01, -2.672828E-01, -5.135584E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.075597E-01, -2.455817E-01, -5.199535E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-6.420359E-01, -2.672828E-01, -5.135584E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-6.61186E-01, -2.455816E-01, -5.164354E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.61186E-01, -2.455816E-01, -5.164354E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-6.420359E-01, -2.672828E-01, -5.135584E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-6.668084E-01, -2.672828E-01, -5.112485E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.61186E-01, -2.455816E-01, -5.164354E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-6.668084E-01, -2.672828E-01, -5.112485E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-7.087243E-01, -2.455816E-01, -5.120027E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.087243E-01, -2.455816E-01, -5.120027E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-6.668084E-01, -2.672828E-01, -5.112485E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-6.846366E-01, -2.672828E-01, -5.088137E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.087243E-01, -2.455816E-01, -5.120027E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-6.846366E-01, -2.672828E-01, -5.088137E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-7.429374E-01, -2.455816E-01, -5.073302E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.429374E-01, -2.455816E-01, -5.073302E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-6.846366E-01, -2.672828E-01, -5.088137E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-6.928074E-01, -2.672828E-01, -5.066246E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.429374E-01, -2.455816E-01, -5.073302E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-6.928074E-01, -2.672828E-01, -5.066246E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-7.586164E-01, -2.455816E-01, -5.031293E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.586164E-01, -2.455816E-01, -5.031293E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-6.928074E-01, -2.672828E-01, -5.066246E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-6.900762E-01, -2.672828E-01, -5.050145E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.586164E-01, -2.455816E-01, -5.031293E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-6.900762E-01, -2.672828E-01, -5.050145E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-7.533746E-01, -2.455816E-01, -5.000396E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.533746E-01, -2.455816E-01, -5.000396E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-6.900762E-01, -2.672828E-01, -5.050145E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-6.768579E-01, -2.672828E-01, -5.042286E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.533746E-01, -2.455816E-01, -5.000396E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-6.768579E-01, -2.672828E-01, -5.042286E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-7.280101E-01, -2.455816E-01, -4.985314E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.280101E-01, -2.455816E-01, -4.985314E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-6.768579E-01, -2.672828E-01, -5.042286E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-6.551664E-01, -2.672829E-01, -5.043865E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.280101E-01, -2.455816E-01, -4.985314E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-6.551664E-01, -2.672829E-01, -5.043865E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-6.863841E-01, -2.455816E-01, -4.988344E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.863841E-01, -2.455816E-01, -4.988344E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-6.551664E-01, -2.672829E-01, -5.043865E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-6.283036E-01, -2.672829E-01, -5.054641E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.863841E-01, -2.455816E-01, -4.988344E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-6.283036E-01, -2.672829E-01, -5.054641E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <-6.348344E-01, -2.455816E-01, -5.009024E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.348344E-01, -2.455816E-01, -5.009024E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-6.283036E-01, -2.672829E-01, -5.054641E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <-6.003582E-01, -2.672829E-01, -5.072975E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.348344E-01, -2.455816E-01, -5.009024E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-6.003582E-01, -2.672829E-01, -5.072975E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <-5.812079E-01, -2.455816E-01, -5.044206E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.812079E-01, -2.455816E-01, -5.044206E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <-6.003582E-01, -2.672829E-01, -5.072975E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <-5.755857E-01, -2.672829E-01, -5.096074E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.812079E-01, -2.455816E-01, -5.044206E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <-5.755857E-01, -2.672829E-01, -5.096074E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <-5.336698E-01, -2.455816E-01, -5.088532E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.755857E-01, -2.672829E-01, -5.096074E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.577575E-01, -2.672829E-01, -5.120422E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.577575E-01, -2.672829E-01, -5.120422E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.495868E-01, -2.672829E-01, -5.142313E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.495868E-01, -2.672829E-01, -5.142313E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.523179E-01, -2.672829E-01, -5.158414E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.523179E-01, -2.672829E-01, -5.158414E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.655362E-01, -2.672829E-01, -5.166273E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.655362E-01, -2.672829E-01, -5.166273E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.872276E-01, -2.672829E-01, -5.164694E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-5.872276E-01, -2.672829E-01, -5.164694E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.140906E-01, -2.672829E-01, -5.153918E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.140906E-01, -2.672829E-01, -5.153918E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.420359E-01, -2.672828E-01, -5.135584E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.420359E-01, -2.672828E-01, -5.135584E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.668084E-01, -2.672828E-01, -5.112485E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.668084E-01, -2.672828E-01, -5.112485E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.846366E-01, -2.672828E-01, -5.088137E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.846366E-01, -2.672828E-01, -5.088137E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.928074E-01, -2.672828E-01, -5.066246E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.928074E-01, -2.672828E-01, -5.066246E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.900762E-01, -2.672828E-01, -5.050145E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900762E-01, -2.672828E-01, -5.050145E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.768579E-01, -2.672828E-01, -5.042286E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.768579E-01, -2.672828E-01, -5.042286E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.551664E-01, -2.672829E-01, -5.043865E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.551664E-01, -2.672829E-01, -5.043865E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.283036E-01, -2.672829E-01, -5.054641E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.283036E-01, -2.672829E-01, -5.054641E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-6.003582E-01, -2.672829E-01, -5.072975E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.003582E-01, -2.672829E-01, -5.072975E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02> 
      <-6.211972E-01, -2.747173E-01, -5.10428E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-5.755857E-01, -2.672829E-01, -5.096074E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
}
}
 
#declare Tex1 =
texture {
   pigment {rgbf <5.490196E-01, 5.490196E-01, 5.490196E-01, 0.00E+00>}
   finish {ambient 0.00E+00 diffuse 1.00E+00 brilliance 1.00E+00}
}
 
// Sphere
object {
union {
   smooth_triangle {
      <-7.00446E-01, 4.465356E-02, -5.196788E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-6.940352E-01, 4.412412E-02, -5.200294E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.940352E-01, 4.412412E-02, -5.200294E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-6.888759E-01, 4.369778E-02, -5.203115E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.888759E-01, 4.369778E-02, -5.203115E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-6.857526E-01, 4.343993E-02, -5.204823E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.857526E-01, 4.343993E-02, -5.204823E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-6.851409E-01, 4.338943E-02, -5.205158E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.851409E-01, 4.338943E-02, -5.205158E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-6.871352E-01, 4.355411E-02, -5.204067E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.871352E-01, 4.355411E-02, -5.204067E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-6.914299E-01, 4.390888E-02, -5.201719E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.914299E-01, 4.390888E-02, -5.201719E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-6.973726E-01, 4.43998E-02, -5.19847E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.973726E-01, 4.43998E-02, -5.19847E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-7.040579E-01, 4.495211E-02, -5.194814E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.040579E-01, 4.495211E-02, -5.194814E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.104687E-01, 4.548149E-02, -5.191308E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.104687E-01, 4.548149E-02, -5.191308E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.156281E-01, 4.590787E-02, -5.188487E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.156281E-01, 4.590787E-02, -5.188487E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.187514E-01, 4.616571E-02, -5.186779E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.187514E-01, 4.616571E-02, -5.186779E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.19363E-01, 4.621621E-02, -5.186444E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.19363E-01, 4.621621E-02, -5.186444E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.173688E-01, 4.605153E-02, -5.187535E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.173688E-01, 4.605153E-02, -5.187535E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-7.13074E-01, 4.569677E-02, -5.189883E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.13074E-01, 4.569677E-02, -5.189883E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-7.071313E-01, 4.520581E-02, -5.193133E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.071313E-01, 4.520581E-02, -5.193133E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-7.00446E-01, 4.465356E-02, -5.196788E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      <-7.019215E-01, 4.635311E-02, -5.19502E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.00446E-01, 4.465356E-02, -5.196788E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-6.997509E-01, 3.999123E-02, -5.199975E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <-6.874494E-01, 3.897503E-02, -5.206702E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.00446E-01, 4.465356E-02, -5.196788E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-6.874494E-01, 3.897503E-02, -5.206702E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <-6.940352E-01, 4.412412E-02, -5.200294E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.940352E-01, 4.412412E-02, -5.200294E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-6.874494E-01, 3.897503E-02, -5.206702E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <-6.775478E-01, 3.815709E-02, -5.212116E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.940352E-01, 4.412412E-02, -5.200294E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-6.775478E-01, 3.815709E-02, -5.212116E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <-6.888759E-01, 4.369778E-02, -5.203115E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.888759E-01, 4.369778E-02, -5.203115E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-6.775478E-01, 3.815709E-02, -5.212116E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <-6.715544E-01, 3.766216E-02, -5.215394E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.888759E-01, 4.369778E-02, -5.203115E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-6.715544E-01, 3.766216E-02, -5.215394E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <-6.857526E-01, 4.343993E-02, -5.204823E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.857526E-01, 4.343993E-02, -5.204823E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-6.715544E-01, 3.766216E-02, -5.215394E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <-6.703814E-01, 3.756518E-02, -5.216035E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.857526E-01, 4.343993E-02, -5.204823E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-6.703814E-01, 3.756518E-02, -5.216035E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-6.851409E-01, 4.338943E-02, -5.205158E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.851409E-01, 4.338943E-02, -5.205158E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-6.703814E-01, 3.756518E-02, -5.216035E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-6.742071E-01, 3.788133E-02, -5.213944E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.851409E-01, 4.338943E-02, -5.205158E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-6.742071E-01, 3.788133E-02, -5.213944E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-6.871352E-01, 4.355411E-02, -5.204067E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.871352E-01, 4.355411E-02, -5.204067E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-6.742071E-01, 3.788133E-02, -5.213944E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-6.824492E-01, 3.856223E-02, -5.209437E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.871352E-01, 4.355411E-02, -5.204067E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-6.824492E-01, 3.856223E-02, -5.209437E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-6.914299E-01, 4.390888E-02, -5.201719E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.914299E-01, 4.390888E-02, -5.201719E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-6.824492E-01, 3.856223E-02, -5.209437E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-6.938533E-01, 3.95042E-02, -5.203201E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.914299E-01, 4.390888E-02, -5.201719E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-6.938533E-01, 3.95042E-02, -5.203201E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-6.973726E-01, 4.43998E-02, -5.19847E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.973726E-01, 4.43998E-02, -5.19847E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-6.938533E-01, 3.95042E-02, -5.203201E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-7.066826E-01, 4.05639E-02, -5.196185E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.973726E-01, 4.43998E-02, -5.19847E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-7.066826E-01, 4.05639E-02, -5.196185E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-7.040579E-01, 4.495211E-02, -5.194814E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.040579E-01, 4.495211E-02, -5.194814E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.066826E-01, 4.05639E-02, -5.196185E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-7.189841E-01, 4.158006E-02, -5.189458E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.040579E-01, 4.495211E-02, -5.194814E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.189841E-01, 4.158006E-02, -5.189458E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-7.104687E-01, 4.548149E-02, -5.191308E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.104687E-01, 4.548149E-02, -5.191308E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.189841E-01, 4.158006E-02, -5.189458E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-7.288858E-01, 4.239805E-02, -5.184044E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.104687E-01, 4.548149E-02, -5.191308E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.288858E-01, 4.239805E-02, -5.184044E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-7.156281E-01, 4.590787E-02, -5.188487E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.156281E-01, 4.590787E-02, -5.188487E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.288858E-01, 4.239805E-02, -5.184044E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-7.348791E-01, 4.289297E-02, -5.180767E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.156281E-01, 4.590787E-02, -5.188487E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.348791E-01, 4.289297E-02, -5.180767E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-7.187514E-01, 4.616571E-02, -5.186779E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.187514E-01, 4.616571E-02, -5.186779E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.348791E-01, 4.289297E-02, -5.180767E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-7.360521E-01, 4.298993E-02, -5.180125E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.187514E-01, 4.616571E-02, -5.186779E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.360521E-01, 4.298993E-02, -5.180125E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-7.19363E-01, 4.621621E-02, -5.186444E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.19363E-01, 4.621621E-02, -5.186444E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.360521E-01, 4.298993E-02, -5.180125E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-7.322264E-01, 4.26738E-02, -5.182217E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.19363E-01, 4.621621E-02, -5.186444E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.322264E-01, 4.26738E-02, -5.182217E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-7.173688E-01, 4.605153E-02, -5.187535E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.173688E-01, 4.605153E-02, -5.187535E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-7.322264E-01, 4.26738E-02, -5.182217E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-7.239844E-01, 4.199287E-02, -5.186723E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.173688E-01, 4.605153E-02, -5.187535E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-7.239844E-01, 4.199287E-02, -5.186723E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-7.13074E-01, 4.569677E-02, -5.189883E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.13074E-01, 4.569677E-02, -5.189883E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-7.239844E-01, 4.199287E-02, -5.186723E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-7.125801E-01, 4.105089E-02, -5.19296E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.13074E-01, 4.569677E-02, -5.189883E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-7.125801E-01, 4.105089E-02, -5.19296E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <-7.071313E-01, 4.520581E-02, -5.193133E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.071313E-01, 4.520581E-02, -5.193133E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-7.125801E-01, 4.105089E-02, -5.19296E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <-6.997509E-01, 3.999123E-02, -5.199975E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.071313E-01, 4.520581E-02, -5.193133E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-6.997509E-01, 3.999123E-02, -5.199975E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <-7.00446E-01, 4.465356E-02, -5.196788E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.997509E-01, 3.999123E-02, -5.199975E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <-6.998929E-01, 3.274365E-02, -5.204322E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <-6.826962E-01, 3.132331E-02, -5.213727E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.997509E-01, 3.999123E-02, -5.199975E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <-6.826962E-01, 3.132331E-02, -5.213727E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <-6.874494E-01, 3.897503E-02, -5.206702E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.874494E-01, 3.897503E-02, -5.206702E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <-6.826962E-01, 3.132331E-02, -5.213727E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <-6.688557E-01, 3.017992E-02, -5.221294E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.874494E-01, 3.897503E-02, -5.206702E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <-6.688557E-01, 3.017992E-02, -5.221294E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <-6.775478E-01, 3.815709E-02, -5.212116E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.775478E-01, 3.815709E-02, -5.212116E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <-6.688557E-01, 3.017992E-02, -5.221294E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <-6.604776E-01, 2.948792E-02, -5.225875E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.775478E-01, 3.815709E-02, -5.212116E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <-6.604776E-01, 2.948792E-02, -5.225875E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <-6.715544E-01, 3.766216E-02, -5.215394E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.715544E-01, 3.766216E-02, -5.215394E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <-6.604776E-01, 2.948792E-02, -5.225875E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <-6.588379E-01, 2.935254E-02, -5.226772E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.715544E-01, 3.766216E-02, -5.215394E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <-6.588379E-01, 2.935254E-02, -5.226772E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-6.703814E-01, 3.756518E-02, -5.216035E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.703814E-01, 3.756518E-02, -5.216035E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-6.588379E-01, 2.935254E-02, -5.226772E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-6.641856E-01, 2.979432E-02, -5.223848E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.703814E-01, 3.756518E-02, -5.216035E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-6.641856E-01, 2.979432E-02, -5.223848E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-6.742071E-01, 3.788133E-02, -5.213944E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.742071E-01, 3.788133E-02, -5.213944E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-6.641856E-01, 2.979432E-02, -5.223848E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-6.757076E-01, 3.074605E-02, -5.217548E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.742071E-01, 3.788133E-02, -5.213944E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-6.757076E-01, 3.074605E-02, -5.217548E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-6.824492E-01, 3.856223E-02, -5.209437E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.824492E-01, 3.856223E-02, -5.209437E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-6.757076E-01, 3.074605E-02, -5.217548E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-6.916486E-01, 3.206282E-02, -5.208831E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.824492E-01, 3.856223E-02, -5.209437E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-6.916486E-01, 3.206282E-02, -5.208831E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-6.938533E-01, 3.95042E-02, -5.203201E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.938533E-01, 3.95042E-02, -5.203201E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-6.916486E-01, 3.206282E-02, -5.208831E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-7.095823E-01, 3.354424E-02, -5.199024E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.938533E-01, 3.95042E-02, -5.203201E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-7.095823E-01, 3.354424E-02, -5.199024E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-7.066826E-01, 4.05639E-02, -5.196185E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.066826E-01, 4.05639E-02, -5.196185E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-7.095823E-01, 3.354424E-02, -5.199024E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-7.267791E-01, 3.496459E-02, -5.18962E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.066826E-01, 4.05639E-02, -5.196185E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-7.267791E-01, 3.496459E-02, -5.18962E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-7.189841E-01, 4.158006E-02, -5.189458E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.189841E-01, 4.158006E-02, -5.189458E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-7.267791E-01, 3.496459E-02, -5.18962E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-7.406197E-01, 3.610792E-02, -5.182052E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.189841E-01, 4.158006E-02, -5.189458E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-7.406197E-01, 3.610792E-02, -5.182052E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-7.288858E-01, 4.239805E-02, -5.184044E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.288858E-01, 4.239805E-02, -5.184044E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-7.406197E-01, 3.610792E-02, -5.182052E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-7.489976E-01, 3.679996E-02, -5.177471E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.288858E-01, 4.239805E-02, -5.184044E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-7.489976E-01, 3.679996E-02, -5.177471E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      <-7.348791E-01, 4.289297E-02, -5.180767E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.348791E-01, 4.289297E-02, -5.180767E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-7.489976E-01, 3.679996E-02, -5.177471E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      <-7.506373E-01, 3.693534E-02, -5.176574E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.348791E-01, 4.289297E-02, -5.180767E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-7.506373E-01, 3.693534E-02, -5.176574E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-7.360521E-01, 4.298993E-02, -5.180125E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.360521E-01, 4.298993E-02, -5.180125E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-7.506373E-01, 3.693534E-02, -5.176574E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-7.452894E-01, 3.649353E-02, -5.179498E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.360521E-01, 4.298993E-02, -5.180125E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-7.452894E-01, 3.649353E-02, -5.179498E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-7.322264E-01, 4.26738E-02, -5.182217E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.322264E-01, 4.26738E-02, -5.182217E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-7.452894E-01, 3.649353E-02, -5.179498E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-7.337676E-01, 3.554187E-02, -5.185799E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.322264E-01, 4.26738E-02, -5.182217E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-7.337676E-01, 3.554187E-02, -5.185799E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <-7.239844E-01, 4.199287E-02, -5.186723E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.239844E-01, 4.199287E-02, -5.186723E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <-7.337676E-01, 3.554187E-02, -5.185799E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <-7.178266E-01, 3.422507E-02, -5.194516E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.239844E-01, 4.199287E-02, -5.186723E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <-7.178266E-01, 3.422507E-02, -5.194516E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <-7.125801E-01, 4.105089E-02, -5.19296E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.125801E-01, 4.105089E-02, -5.19296E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <-7.178266E-01, 3.422507E-02, -5.194516E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <-6.998929E-01, 3.274365E-02, -5.204322E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.125801E-01, 4.105089E-02, -5.19296E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <-6.998929E-01, 3.274365E-02, -5.204322E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <-6.997509E-01, 3.999123E-02, -5.199975E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.998929E-01, 3.274365E-02, -5.204322E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <-7.008602E-01, 2.349816E-02, -5.209477E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <-6.801623E-01, 2.178845E-02, -5.220795E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.998929E-01, 3.274365E-02, -5.204322E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <-6.801623E-01, 2.178845E-02, -5.220795E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <-6.826962E-01, 3.132331E-02, -5.213727E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.826962E-01, 3.132331E-02, -5.213727E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <-6.801623E-01, 2.178845E-02, -5.220795E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <-6.635033E-01, 2.041244E-02, -5.229905E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.826962E-01, 3.132331E-02, -5.213727E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <-6.635033E-01, 2.041244E-02, -5.229905E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <-6.688557E-01, 3.017992E-02, -5.221294E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.688557E-01, 3.017992E-02, -5.221294E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <-6.635033E-01, 2.041244E-02, -5.229905E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <-6.534191E-01, 1.957947E-02, -5.235419E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.688557E-01, 3.017992E-02, -5.221294E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <-6.534191E-01, 1.957947E-02, -5.235419E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <-6.604776E-01, 2.948792E-02, -5.225875E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.604776E-01, 2.948792E-02, -5.225875E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <-6.534191E-01, 1.957947E-02, -5.235419E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <-6.514456E-01, 1.941643E-02, -5.236498E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.604776E-01, 2.948792E-02, -5.225875E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <-6.514456E-01, 1.941643E-02, -5.236498E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-6.588379E-01, 2.935254E-02, -5.226772E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.588379E-01, 2.935254E-02, -5.226772E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-6.514456E-01, 1.941643E-02, -5.236498E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-6.578826E-01, 1.994819E-02, -5.232979E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.588379E-01, 2.935254E-02, -5.226772E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-6.578826E-01, 1.994819E-02, -5.232979E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-6.641856E-01, 2.979432E-02, -5.223848E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.641856E-01, 2.979432E-02, -5.223848E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-6.578826E-01, 1.994819E-02, -5.232979E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-6.717501E-01, 2.109373E-02, -5.225396E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.641856E-01, 2.979432E-02, -5.223848E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-6.717501E-01, 2.109373E-02, -5.225396E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-6.757076E-01, 3.074605E-02, -5.217548E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.757076E-01, 3.074605E-02, -5.217548E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-6.717501E-01, 2.109373E-02, -5.225396E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-6.909371E-01, 2.26787E-02, -5.214904E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.757076E-01, 3.074605E-02, -5.217548E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-6.909371E-01, 2.26787E-02, -5.214904E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-6.916486E-01, 3.206282E-02, -5.208831E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.916486E-01, 3.206282E-02, -5.208831E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-6.909371E-01, 2.26787E-02, -5.214904E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-7.125224E-01, 2.446163E-02, -5.2031E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.916486E-01, 3.206282E-02, -5.208831E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-7.125224E-01, 2.446163E-02, -5.2031E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-7.095823E-01, 3.354424E-02, -5.199024E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.095823E-01, 3.354424E-02, -5.199024E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-7.125224E-01, 2.446163E-02, -5.2031E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-7.332205E-01, 2.617139E-02, -5.191782E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.095823E-01, 3.354424E-02, -5.199024E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-7.332205E-01, 2.617139E-02, -5.191782E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-7.267791E-01, 3.496459E-02, -5.18962E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.267791E-01, 3.496459E-02, -5.18962E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-7.332205E-01, 2.617139E-02, -5.191782E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-7.498794E-01, 2.754738E-02, -5.182673E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.267791E-01, 3.496459E-02, -5.18962E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-7.498794E-01, 2.754738E-02, -5.182673E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-7.406197E-01, 3.610792E-02, -5.182052E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.406197E-01, 3.610792E-02, -5.182052E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-7.498794E-01, 2.754738E-02, -5.182673E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-7.599632E-01, 2.838036E-02, -5.177158E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.406197E-01, 3.610792E-02, -5.182052E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-7.599632E-01, 2.838036E-02, -5.177158E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-7.489976E-01, 3.679996E-02, -5.177471E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.489976E-01, 3.679996E-02, -5.177471E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01> 
      <-7.599632E-01, 2.838036E-02, -5.177158E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-7.61937E-01, 2.854335E-02, -5.176079E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.489976E-01, 3.679996E-02, -5.177471E+00>  <-2.679055E-01, 5.994642E-01, 7.542343E-01> 
      <-7.61937E-01, 2.854335E-02, -5.176079E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-7.506373E-01, 3.693534E-02, -5.176574E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.506373E-01, 3.693534E-02, -5.176574E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-7.61937E-01, 2.854335E-02, -5.176079E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-7.555001E-01, 2.80116E-02, -5.179599E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.506373E-01, 3.693534E-02, -5.176574E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-7.555001E-01, 2.80116E-02, -5.179599E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-7.452894E-01, 3.649353E-02, -5.179498E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.452894E-01, 3.649353E-02, -5.179498E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-7.555001E-01, 2.80116E-02, -5.179599E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-7.416326E-01, 2.686606E-02, -5.187182E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.452894E-01, 3.649353E-02, -5.179498E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-7.416326E-01, 2.686606E-02, -5.187182E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <-7.337676E-01, 3.554187E-02, -5.185799E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.337676E-01, 3.554187E-02, -5.185799E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <-7.416326E-01, 2.686606E-02, -5.187182E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <-7.224455E-01, 2.528109E-02, -5.197673E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.337676E-01, 3.554187E-02, -5.185799E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <-7.224455E-01, 2.528109E-02, -5.197673E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <-7.178266E-01, 3.422507E-02, -5.194516E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.178266E-01, 3.422507E-02, -5.194516E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <-7.224455E-01, 2.528109E-02, -5.197673E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <-7.008602E-01, 2.349816E-02, -5.209477E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.178266E-01, 3.422507E-02, -5.194516E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <-7.008602E-01, 2.349816E-02, -5.209477E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <-6.998929E-01, 3.274365E-02, -5.204322E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.008602E-01, 2.349816E-02, -5.209477E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <-7.025743E-01, 1.30036E-02, -5.215023E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <-6.80052E-01, 1.114306E-02, -5.227338E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.008602E-01, 2.349816E-02, -5.209477E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <-6.80052E-01, 1.114306E-02, -5.227338E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <-6.801623E-01, 2.178845E-02, -5.220795E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.801623E-01, 2.178845E-02, -5.220795E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <-6.80052E-01, 1.114306E-02, -5.227338E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <-6.619244E-01, 9.645825E-03, -5.237251E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.801623E-01, 2.178845E-02, -5.220795E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <-6.619244E-01, 9.645825E-03, -5.237251E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <-6.635033E-01, 2.041244E-02, -5.229905E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.635033E-01, 2.041244E-02, -5.229905E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <-6.619244E-01, 9.645825E-03, -5.237251E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <-6.509514E-01, 8.739487E-03, -5.243252E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.635033E-01, 2.041244E-02, -5.229905E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <-6.509514E-01, 8.739487E-03, -5.243252E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <-6.534191E-01, 1.957947E-02, -5.235419E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.534191E-01, 1.957947E-02, -5.235419E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <-6.509514E-01, 8.739487E-03, -5.243252E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <-6.488037E-01, 8.562131E-03, -5.244426E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.534191E-01, 1.957947E-02, -5.235419E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <-6.488037E-01, 8.562131E-03, -5.244426E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-6.514456E-01, 1.941643E-02, -5.236498E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.514456E-01, 1.941643E-02, -5.236498E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-6.488037E-01, 8.562131E-03, -5.244426E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-6.558083E-01, 9.140691E-03, -5.240596E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.514456E-01, 1.941643E-02, -5.236498E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-6.558083E-01, 9.140691E-03, -5.240596E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-6.578826E-01, 1.994819E-02, -5.232979E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.578826E-01, 1.994819E-02, -5.232979E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-6.558083E-01, 9.140691E-03, -5.240596E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-6.708981E-01, 1.038729E-02, -5.232345E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.578826E-01, 1.994819E-02, -5.232979E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-6.708981E-01, 1.038729E-02, -5.232345E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-6.717501E-01, 2.109373E-02, -5.225396E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.717501E-01, 2.109373E-02, -5.225396E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-6.708981E-01, 1.038729E-02, -5.232345E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-6.917765E-01, 1.211182E-02, -5.220928E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.717501E-01, 2.109373E-02, -5.225396E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-6.917765E-01, 1.211182E-02, -5.220928E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-6.909371E-01, 2.26787E-02, -5.214904E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.909371E-01, 2.26787E-02, -5.214904E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-6.917765E-01, 1.211182E-02, -5.220928E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-7.15265E-01, 1.4052E-02, -5.208084E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.909371E-01, 2.26787E-02, -5.214904E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-7.15265E-01, 1.4052E-02, -5.208084E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-7.125224E-01, 2.446163E-02, -5.2031E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.125224E-01, 2.446163E-02, -5.2031E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-7.15265E-01, 1.4052E-02, -5.208084E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-7.377872E-01, 1.591251E-02, -5.195768E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.125224E-01, 2.446163E-02, -5.2031E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-7.377872E-01, 1.591251E-02, -5.195768E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-7.332205E-01, 2.617139E-02, -5.191782E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.332205E-01, 2.617139E-02, -5.191782E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-7.377872E-01, 1.591251E-02, -5.195768E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-7.55915E-01, 1.740977E-02, -5.185855E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.332205E-01, 2.617139E-02, -5.191782E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-7.55915E-01, 1.740977E-02, -5.185855E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-7.498794E-01, 2.754738E-02, -5.182673E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.498794E-01, 2.754738E-02, -5.182673E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-7.55915E-01, 1.740977E-02, -5.185855E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-7.66888E-01, 1.831615E-02, -5.179854E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.498794E-01, 2.754738E-02, -5.182673E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-7.66888E-01, 1.831615E-02, -5.179854E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-7.599632E-01, 2.838036E-02, -5.177158E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.599632E-01, 2.838036E-02, -5.177158E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-7.66888E-01, 1.831615E-02, -5.179854E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-7.690357E-01, 1.849349E-02, -5.17868E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.599632E-01, 2.838036E-02, -5.177158E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-7.690357E-01, 1.849349E-02, -5.17868E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-7.61937E-01, 2.854335E-02, -5.176079E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.61937E-01, 2.854335E-02, -5.176079E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-7.690357E-01, 1.849349E-02, -5.17868E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-7.62031E-01, 1.791492E-02, -5.18251E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.61937E-01, 2.854335E-02, -5.176079E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-7.62031E-01, 1.791492E-02, -5.18251E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-7.555001E-01, 2.80116E-02, -5.179599E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.555001E-01, 2.80116E-02, -5.179599E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-7.62031E-01, 1.791492E-02, -5.18251E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-7.469411E-01, 1.666834E-02, -5.190762E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.555001E-01, 2.80116E-02, -5.179599E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-7.469411E-01, 1.666834E-02, -5.190762E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <-7.416326E-01, 2.686606E-02, -5.187182E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.416326E-01, 2.686606E-02, -5.187182E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <-7.469411E-01, 1.666834E-02, -5.190762E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <-7.260627E-01, 1.494378E-02, -5.202178E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.416326E-01, 2.686606E-02, -5.187182E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <-7.260627E-01, 1.494378E-02, -5.202178E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <-7.224455E-01, 2.528109E-02, -5.197673E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.224455E-01, 2.528109E-02, -5.197673E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <-7.260627E-01, 1.494378E-02, -5.202178E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <-7.025743E-01, 1.30036E-02, -5.215023E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.224455E-01, 2.528109E-02, -5.197673E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <-7.025743E-01, 1.30036E-02, -5.215023E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <-7.008602E-01, 2.349816E-02, -5.209477E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.025743E-01, 1.30036E-02, -5.215023E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <-7.048967E-01, 2.110269E-03, -5.220509E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      <-6.823744E-01, 2.497368E-04, -5.232824E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.025743E-01, 1.30036E-02, -5.215023E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <-6.823744E-01, 2.497368E-04, -5.232824E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <-6.80052E-01, 1.114306E-02, -5.227338E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.80052E-01, 1.114306E-02, -5.227338E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <-6.823744E-01, 2.497368E-04, -5.232824E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <-6.642468E-01, -1.247501E-03, -5.242738E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.80052E-01, 1.114306E-02, -5.227338E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <-6.642468E-01, -1.247501E-03, -5.242738E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <-6.619244E-01, 9.645825E-03, -5.237251E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.619244E-01, 9.645825E-03, -5.237251E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <-6.642468E-01, -1.247501E-03, -5.242738E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <-6.532739E-01, -2.15384E-03, -5.248738E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.619244E-01, 9.645825E-03, -5.237251E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <-6.532739E-01, -2.15384E-03, -5.248738E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <-6.509514E-01, 8.739487E-03, -5.243252E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.509514E-01, 8.739487E-03, -5.243252E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <-6.532739E-01, -2.15384E-03, -5.248738E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <-6.511261E-01, -2.331196E-03, -5.249913E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.509514E-01, 8.739487E-03, -5.243252E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <-6.511261E-01, -2.331196E-03, -5.249913E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-6.488037E-01, 8.562131E-03, -5.244426E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.488037E-01, 8.562131E-03, -5.244426E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-6.511261E-01, -2.331196E-03, -5.249913E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-6.581306E-01, -1.752665E-03, -5.246082E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.488037E-01, 8.562131E-03, -5.244426E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-6.581306E-01, -1.752665E-03, -5.246082E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      <-6.558083E-01, 9.140691E-03, -5.240596E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.558083E-01, 9.140691E-03, -5.240596E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-6.581306E-01, -1.752665E-03, -5.246082E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      <-6.732206E-01, -5.060356E-04, -5.237832E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.558083E-01, 9.140691E-03, -5.240596E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-6.732206E-01, -5.060356E-04, -5.237832E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-6.708981E-01, 1.038729E-02, -5.232345E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.708981E-01, 1.038729E-02, -5.232345E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-6.732206E-01, -5.060356E-04, -5.237832E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-6.940989E-01, 1.218469E-03, -5.226414E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.708981E-01, 1.038729E-02, -5.232345E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-6.940989E-01, 1.218469E-03, -5.226414E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-6.917765E-01, 1.211182E-02, -5.220928E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.917765E-01, 1.211182E-02, -5.220928E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-6.940989E-01, 1.218469E-03, -5.226414E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-7.175874E-01, 3.158677E-03, -5.21357E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.917765E-01, 1.211182E-02, -5.220928E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-7.175874E-01, 3.158677E-03, -5.21357E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-7.15265E-01, 1.4052E-02, -5.208084E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.15265E-01, 1.4052E-02, -5.208084E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-7.175874E-01, 3.158677E-03, -5.21357E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-7.401096E-01, 5.019184E-03, -5.201255E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.15265E-01, 1.4052E-02, -5.208084E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-7.401096E-01, 5.019184E-03, -5.201255E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-7.377872E-01, 1.591251E-02, -5.195768E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.377872E-01, 1.591251E-02, -5.195768E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-7.401096E-01, 5.019184E-03, -5.201255E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-7.582374E-01, 6.516447E-03, -5.191341E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.377872E-01, 1.591251E-02, -5.195768E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-7.582374E-01, 6.516447E-03, -5.191341E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-7.55915E-01, 1.740977E-02, -5.185855E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.55915E-01, 1.740977E-02, -5.185855E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-7.582374E-01, 6.516447E-03, -5.191341E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-7.692105E-01, 7.422822E-03, -5.185341E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.55915E-01, 1.740977E-02, -5.185855E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-7.692105E-01, 7.422822E-03, -5.185341E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-7.66888E-01, 1.831615E-02, -5.179854E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.66888E-01, 1.831615E-02, -5.179854E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-7.692105E-01, 7.422822E-03, -5.185341E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-7.713581E-01, 7.600166E-03, -5.184166E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.66888E-01, 1.831615E-02, -5.179854E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-7.713581E-01, 7.600166E-03, -5.184166E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-7.690357E-01, 1.849349E-02, -5.17868E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.690357E-01, 1.849349E-02, -5.17868E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-7.713581E-01, 7.600166E-03, -5.184166E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-7.643535E-01, 7.021569E-03, -5.187997E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.690357E-01, 1.849349E-02, -5.17868E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-7.643535E-01, 7.021569E-03, -5.187997E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-7.62031E-01, 1.791492E-02, -5.18251E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.62031E-01, 1.791492E-02, -5.18251E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-7.643535E-01, 7.021569E-03, -5.187997E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-7.492636E-01, 5.775011E-03, -5.196248E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.62031E-01, 1.791492E-02, -5.18251E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-7.492636E-01, 5.775011E-03, -5.196248E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <-7.469411E-01, 1.666834E-02, -5.190762E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.469411E-01, 1.666834E-02, -5.190762E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <-7.492636E-01, 5.775011E-03, -5.196248E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <-7.283851E-01, 4.050423E-03, -5.207665E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.469411E-01, 1.666834E-02, -5.190762E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <-7.283851E-01, 4.050423E-03, -5.207665E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <-7.260627E-01, 1.494378E-02, -5.202178E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.260627E-01, 1.494378E-02, -5.202178E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <-7.283851E-01, 4.050423E-03, -5.207665E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <-7.048967E-01, 2.110269E-03, -5.220509E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.260627E-01, 1.494378E-02, -5.202178E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <-7.048967E-01, 2.110269E-03, -5.220509E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      <-7.025743E-01, 1.30036E-02, -5.215023E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.048967E-01, 2.110269E-03, -5.220509E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02> 
      <-7.076393E-01, -8.2993E-03, -5.225492E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <-6.869414E-01, -1.000907E-02, -5.23681E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.048967E-01, 2.110269E-03, -5.220509E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02> 
      <-6.869414E-01, -1.000907E-02, -5.23681E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <-6.823744E-01, 2.497368E-04, -5.232824E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.823744E-01, 2.497368E-04, -5.232824E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <-6.869414E-01, -1.000907E-02, -5.23681E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <-6.702824E-01, -1.138505E-02, -5.24592E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.823744E-01, 2.497368E-04, -5.232824E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <-6.702824E-01, -1.138505E-02, -5.24592E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <-6.642468E-01, -1.247501E-03, -5.242738E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.642468E-01, -1.247501E-03, -5.242738E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <-6.702824E-01, -1.138505E-02, -5.24592E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <-6.601983E-01, -1.221808E-02, -5.251434E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.642468E-01, -1.247501E-03, -5.242738E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <-6.601983E-01, -1.221808E-02, -5.251434E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      <-6.532739E-01, -2.15384E-03, -5.248738E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.532739E-01, -2.15384E-03, -5.248738E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <-6.601983E-01, -1.221808E-02, -5.251434E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      <-6.582247E-01, -1.238102E-02, -5.252514E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.532739E-01, -2.15384E-03, -5.248738E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <-6.582247E-01, -1.238102E-02, -5.252514E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      <-6.511261E-01, -2.331196E-03, -5.249913E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.511261E-01, -2.331196E-03, -5.249913E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-6.582247E-01, -1.238102E-02, -5.252514E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      <-6.646616E-01, -1.18493E-02, -5.248994E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.511261E-01, -2.331196E-03, -5.249913E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-6.646616E-01, -1.18493E-02, -5.248994E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-6.581306E-01, -1.752665E-03, -5.246082E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.581306E-01, -1.752665E-03, -5.246082E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01> 
      <-6.646616E-01, -1.18493E-02, -5.248994E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-6.785291E-01, -1.070379E-02, -5.241411E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.581306E-01, -1.752665E-03, -5.246082E+00>  <-4.16829E-01, -2.112352E-01, -8.841002E-01> 
      <-6.785291E-01, -1.070379E-02, -5.241411E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-6.732206E-01, -5.060356E-04, -5.237832E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.732206E-01, -5.060356E-04, -5.237832E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-6.785291E-01, -1.070379E-02, -5.241411E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-6.977162E-01, -9.118789E-03, -5.230919E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.732206E-01, -5.060356E-04, -5.237832E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-6.977162E-01, -9.118789E-03, -5.230919E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-6.940989E-01, 1.218469E-03, -5.226414E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.940989E-01, 1.218469E-03, -5.226414E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-6.977162E-01, -9.118789E-03, -5.230919E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-7.193015E-01, -7.335886E-03, -5.219115E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.940989E-01, 1.218469E-03, -5.226414E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-7.193015E-01, -7.335886E-03, -5.219115E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-7.175874E-01, 3.158677E-03, -5.21357E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.175874E-01, 3.158677E-03, -5.21357E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-7.193015E-01, -7.335886E-03, -5.219115E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-7.399995E-01, -5.626096E-03, -5.207798E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.175874E-01, 3.158677E-03, -5.21357E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-7.399995E-01, -5.626096E-03, -5.207798E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-7.401096E-01, 5.019184E-03, -5.201255E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.401096E-01, 5.019184E-03, -5.201255E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-7.399995E-01, -5.626096E-03, -5.207798E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-7.566586E-01, -4.250111E-03, -5.198688E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.401096E-01, 5.019184E-03, -5.201255E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-7.566586E-01, -4.250111E-03, -5.198688E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-7.582374E-01, 6.516447E-03, -5.191341E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.582374E-01, 6.516447E-03, -5.191341E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-7.566586E-01, -4.250111E-03, -5.198688E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-7.667422E-01, -3.417155E-03, -5.193174E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.582374E-01, 6.516447E-03, -5.191341E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-7.667422E-01, -3.417155E-03, -5.193174E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      <-7.692105E-01, 7.422822E-03, -5.185341E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.692105E-01, 7.422822E-03, -5.185341E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-7.667422E-01, -3.417155E-03, -5.193174E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      <-7.687161E-01, -3.254134E-03, -5.192094E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.692105E-01, 7.422822E-03, -5.185341E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-7.687161E-01, -3.254134E-03, -5.192094E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      <-7.713581E-01, 7.600166E-03, -5.184166E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.713581E-01, 7.600166E-03, -5.184166E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-7.687161E-01, -3.254134E-03, -5.192094E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      <-7.622792E-01, -3.785885E-03, -5.195614E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.713581E-01, 7.600166E-03, -5.184166E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-7.622792E-01, -3.785885E-03, -5.195614E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      <-7.643535E-01, 7.021569E-03, -5.187997E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.643535E-01, 7.021569E-03, -5.187997E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-7.622792E-01, -3.785885E-03, -5.195614E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      <-7.484117E-01, -4.931401E-03, -5.203197E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.643535E-01, 7.021569E-03, -5.187997E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-7.484117E-01, -4.931401E-03, -5.203197E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <-7.492636E-01, 5.775011E-03, -5.196248E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.492636E-01, 5.775011E-03, -5.196248E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <-7.484117E-01, -4.931401E-03, -5.203197E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <-7.292246E-01, -6.516397E-03, -5.213688E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.492636E-01, 5.775011E-03, -5.196248E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <-7.292246E-01, -6.516397E-03, -5.213688E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <-7.283851E-01, 4.050423E-03, -5.207665E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.283851E-01, 4.050423E-03, -5.207665E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <-7.292246E-01, -6.516397E-03, -5.213688E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <-7.076393E-01, -8.2993E-03, -5.225492E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.283851E-01, 4.050423E-03, -5.207665E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <-7.076393E-01, -8.2993E-03, -5.225492E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <-7.048967E-01, 2.110269E-03, -5.220509E+00>  <9.763157E-01, -2.112352E-01, 4.676887E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.076393E-01, -8.2993E-03, -5.225492E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <-7.105795E-01, -1.738191E-02, -5.229568E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <-6.933827E-01, -1.880227E-02, -5.238973E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.076393E-01, -8.2993E-03, -5.225492E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <-6.933827E-01, -1.880227E-02, -5.238973E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <-6.869414E-01, -1.000907E-02, -5.23681E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.869414E-01, -1.000907E-02, -5.23681E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <-6.933827E-01, -1.880227E-02, -5.238973E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <-6.795421E-01, -1.994557E-02, -5.246541E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.869414E-01, -1.000907E-02, -5.23681E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <-6.795421E-01, -1.994557E-02, -5.246541E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <-6.702824E-01, -1.138505E-02, -5.24592E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.702824E-01, -1.138505E-02, -5.24592E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <-6.795421E-01, -1.994557E-02, -5.246541E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <-6.711641E-01, -2.063766E-02, -5.251122E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.702824E-01, -1.138505E-02, -5.24592E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <-6.711641E-01, -2.063766E-02, -5.251122E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <-6.601983E-01, -1.221808E-02, -5.251434E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.601983E-01, -1.221808E-02, -5.251434E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01> 
      <-6.711641E-01, -2.063766E-02, -5.251122E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <-6.695244E-01, -2.077307E-02, -5.252018E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.601983E-01, -1.221808E-02, -5.251434E+00>  <2.977577E-01, -4.780832E-01, -8.263031E-01> 
      <-6.695244E-01, -2.077307E-02, -5.252018E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-6.582247E-01, -1.238102E-02, -5.252514E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.582247E-01, -1.238102E-02, -5.252514E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01> 
      <-6.695244E-01, -2.077307E-02, -5.252018E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-6.748723E-01, -2.033123E-02, -5.249094E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.582247E-01, -1.238102E-02, -5.252514E+00>  <-4.112037E-02, -4.780833E-01, -8.773514E-01> 
      <-6.748723E-01, -2.033123E-02, -5.249094E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-6.646616E-01, -1.18493E-02, -5.248994E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.646616E-01, -1.18493E-02, -5.248994E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-6.748723E-01, -2.033123E-02, -5.249094E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-6.86394E-01, -1.937955E-02, -5.242794E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.646616E-01, -1.18493E-02, -5.248994E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-6.86394E-01, -1.937955E-02, -5.242794E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-6.785291E-01, -1.070379E-02, -5.241411E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.785291E-01, -1.070379E-02, -5.241411E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-6.86394E-01, -1.937955E-02, -5.242794E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-7.023352E-01, -1.806277E-02, -5.234077E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.785291E-01, -1.070379E-02, -5.241411E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-7.023352E-01, -1.806277E-02, -5.234077E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-6.977162E-01, -9.118789E-03, -5.230919E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.977162E-01, -9.118789E-03, -5.230919E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-7.023352E-01, -1.806277E-02, -5.234077E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-7.202688E-01, -1.658135E-02, -5.224271E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.977162E-01, -9.118789E-03, -5.230919E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-7.202688E-01, -1.658135E-02, -5.224271E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-7.193015E-01, -7.335886E-03, -5.219115E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.193015E-01, -7.335886E-03, -5.219115E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-7.202688E-01, -1.658135E-02, -5.224271E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-7.374656E-01, -1.516102E-02, -5.214866E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.193015E-01, -7.335886E-03, -5.219115E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-7.374656E-01, -1.516102E-02, -5.214866E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-7.399995E-01, -5.626096E-03, -5.207798E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.399995E-01, -5.626096E-03, -5.207798E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-7.374656E-01, -1.516102E-02, -5.214866E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-7.513061E-01, -1.40176E-02, -5.207299E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.399995E-01, -5.626096E-03, -5.207798E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-7.513061E-01, -1.40176E-02, -5.207299E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-7.566586E-01, -4.250111E-03, -5.198688E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.566586E-01, -4.250111E-03, -5.198688E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-7.513061E-01, -1.40176E-02, -5.207299E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-7.596841E-01, -1.332562E-02, -5.202717E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.566586E-01, -4.250111E-03, -5.198688E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-7.596841E-01, -1.332562E-02, -5.202717E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-7.667422E-01, -3.417155E-03, -5.193174E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.667422E-01, -3.417155E-03, -5.193174E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01> 
      <-7.596841E-01, -1.332562E-02, -5.202717E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-7.613238E-01, -1.319021E-02, -5.20182E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.667422E-01, -3.417155E-03, -5.193174E+00>  <-2.977574E-01, -4.780834E-01, 8.263031E-01> 
      <-7.613238E-01, -1.319021E-02, -5.20182E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-7.687161E-01, -3.254134E-03, -5.192094E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.687161E-01, -3.254134E-03, -5.192094E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01> 
      <-7.613238E-01, -1.319021E-02, -5.20182E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-7.55976E-01, -1.363206E-02, -5.204744E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.687161E-01, -3.254134E-03, -5.192094E+00>  <4.112067E-02, -4.780833E-01, 8.773513E-01> 
      <-7.55976E-01, -1.363206E-02, -5.204744E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-7.622792E-01, -3.785885E-03, -5.195614E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.622792E-01, -3.785885E-03, -5.195614E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01> 
      <-7.55976E-01, -1.363206E-02, -5.204744E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-7.444541E-01, -1.458372E-02, -5.211045E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.622792E-01, -3.785885E-03, -5.195614E+00>  <3.737384E-01, -4.780834E-01, 7.948307E-01> 
      <-7.444541E-01, -1.458372E-02, -5.211045E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <-7.484117E-01, -4.931401E-03, -5.203197E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.484117E-01, -4.931401E-03, -5.203197E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <-7.444541E-01, -1.458372E-02, -5.211045E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <-7.285131E-01, -1.590054E-02, -5.219762E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.484117E-01, -4.931401E-03, -5.203197E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <-7.285131E-01, -1.590054E-02, -5.219762E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <-7.292246E-01, -6.516397E-03, -5.213688E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.292246E-01, -6.516397E-03, -5.213688E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <-7.285131E-01, -1.590054E-02, -5.219762E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <-7.105795E-01, -1.738191E-02, -5.229568E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.292246E-01, -6.516397E-03, -5.213688E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <-7.105795E-01, -1.738191E-02, -5.229568E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <-7.076393E-01, -8.2993E-03, -5.225492E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.105795E-01, -1.738191E-02, -5.229568E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <-7.134792E-01, -2.440157E-02, -5.232408E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <-7.011777E-01, -2.541776E-02, -5.239134E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.105795E-01, -1.738191E-02, -5.229568E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <-7.011777E-01, -2.541776E-02, -5.239134E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <-6.933827E-01, -1.880227E-02, -5.238973E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.933827E-01, -1.880227E-02, -5.238973E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <-7.011777E-01, -2.541776E-02, -5.239134E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <-6.91276E-01, -2.623573E-02, -5.244548E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.933827E-01, -1.880227E-02, -5.238973E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <-6.91276E-01, -2.623573E-02, -5.244548E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <-6.795421E-01, -1.994557E-02, -5.246541E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.795421E-01, -1.994557E-02, -5.246541E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <-6.91276E-01, -2.623573E-02, -5.244548E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <-6.852826E-01, -2.673066E-02, -5.247826E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.795421E-01, -1.994557E-02, -5.246541E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <-6.852826E-01, -2.673066E-02, -5.247826E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <-6.711641E-01, -2.063766E-02, -5.251122E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.711641E-01, -2.063766E-02, -5.251122E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <-6.852826E-01, -2.673066E-02, -5.247826E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <-6.841096E-01, -2.682762E-02, -5.248467E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.711641E-01, -2.063766E-02, -5.251122E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <-6.841096E-01, -2.682762E-02, -5.248467E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-6.695244E-01, -2.077307E-02, -5.252018E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.695244E-01, -2.077307E-02, -5.252018E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-6.841096E-01, -2.682762E-02, -5.248467E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-6.879354E-01, -2.65115E-02, -5.246376E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.695244E-01, -2.077307E-02, -5.252018E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-6.879354E-01, -2.65115E-02, -5.246376E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-6.748723E-01, -2.033123E-02, -5.249094E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.748723E-01, -2.033123E-02, -5.249094E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-6.879354E-01, -2.65115E-02, -5.246376E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-6.961774E-01, -2.58306E-02, -5.241869E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.748723E-01, -2.033123E-02, -5.249094E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-6.961774E-01, -2.58306E-02, -5.241869E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-6.86394E-01, -1.937955E-02, -5.242794E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.86394E-01, -1.937955E-02, -5.242794E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-6.961774E-01, -2.58306E-02, -5.241869E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-7.075816E-01, -2.488862E-02, -5.235633E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.86394E-01, -1.937955E-02, -5.242794E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-7.075816E-01, -2.488862E-02, -5.235633E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-7.023352E-01, -1.806277E-02, -5.234077E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.023352E-01, -1.806277E-02, -5.234077E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-7.075816E-01, -2.488862E-02, -5.235633E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-7.204109E-01, -2.382896E-02, -5.228617E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.023352E-01, -1.806277E-02, -5.234077E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-7.204109E-01, -2.382896E-02, -5.228617E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-7.202688E-01, -1.658135E-02, -5.224271E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.202688E-01, -1.658135E-02, -5.224271E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-7.204109E-01, -2.382896E-02, -5.228617E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-7.327123E-01, -2.281276E-02, -5.22189E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.202688E-01, -1.658135E-02, -5.224271E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-7.327123E-01, -2.281276E-02, -5.22189E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-7.374656E-01, -1.516102E-02, -5.214866E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.374656E-01, -1.516102E-02, -5.214866E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-7.327123E-01, -2.281276E-02, -5.22189E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-7.426141E-01, -2.199474E-02, -5.216476E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.374656E-01, -1.516102E-02, -5.214866E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-7.426141E-01, -2.199474E-02, -5.216476E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-7.513061E-01, -1.40176E-02, -5.207299E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.513061E-01, -1.40176E-02, -5.207299E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-7.426141E-01, -2.199474E-02, -5.216476E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-7.486074E-01, -2.149988E-02, -5.213199E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.513061E-01, -1.40176E-02, -5.207299E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-7.486074E-01, -2.149988E-02, -5.213199E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-7.596841E-01, -1.332562E-02, -5.202717E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.596841E-01, -1.332562E-02, -5.202717E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-7.486074E-01, -2.149988E-02, -5.213199E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-7.497804E-01, -2.14029E-02, -5.212557E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.596841E-01, -1.332562E-02, -5.202717E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-7.497804E-01, -2.14029E-02, -5.212557E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-7.613238E-01, -1.319021E-02, -5.20182E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.613238E-01, -1.319021E-02, -5.20182E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-7.497804E-01, -2.14029E-02, -5.212557E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-7.459546E-01, -2.171902E-02, -5.214649E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.613238E-01, -1.319021E-02, -5.20182E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-7.459546E-01, -2.171902E-02, -5.214649E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-7.55976E-01, -1.363206E-02, -5.204744E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.55976E-01, -1.363206E-02, -5.204744E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-7.459546E-01, -2.171902E-02, -5.214649E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-7.377126E-01, -2.239993E-02, -5.219156E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.55976E-01, -1.363206E-02, -5.204744E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-7.377126E-01, -2.239993E-02, -5.219156E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <-7.444541E-01, -1.458372E-02, -5.211045E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.444541E-01, -1.458372E-02, -5.211045E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <-7.377126E-01, -2.239993E-02, -5.219156E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <-7.263084E-01, -2.33419E-02, -5.225392E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.444541E-01, -1.458372E-02, -5.211045E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <-7.263084E-01, -2.33419E-02, -5.225392E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <-7.285131E-01, -1.590054E-02, -5.219762E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.285131E-01, -1.590054E-02, -5.219762E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <-7.263084E-01, -2.33419E-02, -5.225392E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <-7.134792E-01, -2.440157E-02, -5.232408E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.285131E-01, -1.590054E-02, -5.219762E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <-7.134792E-01, -2.440157E-02, -5.232408E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <-7.105795E-01, -1.738191E-02, -5.229568E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.134792E-01, -2.440157E-02, -5.232408E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <-7.161038E-01, -2.878981E-02, -5.233779E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <-7.09693E-01, -2.931919E-02, -5.237285E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.134792E-01, -2.440157E-02, -5.232408E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <-7.09693E-01, -2.931919E-02, -5.237285E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <-7.011777E-01, -2.541776E-02, -5.239134E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.011777E-01, -2.541776E-02, -5.239134E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <-7.09693E-01, -2.931919E-02, -5.237285E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <-7.045336E-01, -2.974554E-02, -5.240106E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.011777E-01, -2.541776E-02, -5.239134E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <-7.045336E-01, -2.974554E-02, -5.240106E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <-6.91276E-01, -2.623573E-02, -5.244548E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.91276E-01, -2.623573E-02, -5.244548E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <-7.045336E-01, -2.974554E-02, -5.240106E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <-7.014104E-01, -3.000341E-02, -5.241814E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.91276E-01, -2.623573E-02, -5.244548E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <-7.014104E-01, -3.000341E-02, -5.241814E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-6.852826E-01, -2.673066E-02, -5.247826E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.852826E-01, -2.673066E-02, -5.247826E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-7.014104E-01, -3.000341E-02, -5.241814E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-7.007987E-01, -3.005391E-02, -5.242148E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.852826E-01, -2.673066E-02, -5.247826E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-7.007987E-01, -3.005391E-02, -5.242148E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-6.841096E-01, -2.682762E-02, -5.248467E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.841096E-01, -2.682762E-02, -5.248467E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-7.007987E-01, -3.005391E-02, -5.242148E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-7.027929E-01, -2.98892E-02, -5.241058E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.841096E-01, -2.682762E-02, -5.248467E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-7.027929E-01, -2.98892E-02, -5.241058E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-6.879354E-01, -2.65115E-02, -5.246376E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.879354E-01, -2.65115E-02, -5.246376E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-7.027929E-01, -2.98892E-02, -5.241058E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-7.070878E-01, -2.953444E-02, -5.238709E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.879354E-01, -2.65115E-02, -5.246376E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-7.070878E-01, -2.953444E-02, -5.238709E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-6.961774E-01, -2.58306E-02, -5.241869E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.961774E-01, -2.58306E-02, -5.241869E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-7.070878E-01, -2.953444E-02, -5.238709E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-7.130305E-01, -2.904351E-02, -5.23546E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-6.961774E-01, -2.58306E-02, -5.241869E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-7.130305E-01, -2.904351E-02, -5.23546E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-7.075816E-01, -2.488862E-02, -5.235633E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.075816E-01, -2.488862E-02, -5.235633E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-7.130305E-01, -2.904351E-02, -5.23546E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-7.197157E-01, -2.849123E-02, -5.231804E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.075816E-01, -2.488862E-02, -5.235633E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-7.197157E-01, -2.849123E-02, -5.231804E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-7.204109E-01, -2.382896E-02, -5.228617E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.204109E-01, -2.382896E-02, -5.228617E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-7.197157E-01, -2.849123E-02, -5.231804E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-7.261265E-01, -2.796185E-02, -5.228298E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.204109E-01, -2.382896E-02, -5.228617E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-7.261265E-01, -2.796185E-02, -5.228298E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-7.327123E-01, -2.281276E-02, -5.22189E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.327123E-01, -2.281276E-02, -5.22189E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-7.261265E-01, -2.796185E-02, -5.228298E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-7.312859E-01, -2.753548E-02, -5.225478E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.327123E-01, -2.281276E-02, -5.22189E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-7.312859E-01, -2.753548E-02, -5.225478E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-7.426141E-01, -2.199474E-02, -5.216476E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.426141E-01, -2.199474E-02, -5.216476E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-7.312859E-01, -2.753548E-02, -5.225478E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-7.344092E-01, -2.72776E-02, -5.223769E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.426141E-01, -2.199474E-02, -5.216476E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-7.344092E-01, -2.72776E-02, -5.223769E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-7.486074E-01, -2.149988E-02, -5.213199E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.486074E-01, -2.149988E-02, -5.213199E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-7.344092E-01, -2.72776E-02, -5.223769E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-7.350208E-01, -2.722713E-02, -5.223435E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.486074E-01, -2.149988E-02, -5.213199E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-7.350208E-01, -2.722713E-02, -5.223435E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-7.497804E-01, -2.14029E-02, -5.212557E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.497804E-01, -2.14029E-02, -5.212557E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-7.350208E-01, -2.722713E-02, -5.223435E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-7.330266E-01, -2.739181E-02, -5.224525E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.497804E-01, -2.14029E-02, -5.212557E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-7.330266E-01, -2.739181E-02, -5.224525E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-7.459546E-01, -2.171902E-02, -5.214649E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.459546E-01, -2.171902E-02, -5.214649E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-7.330266E-01, -2.739181E-02, -5.224525E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-7.287318E-01, -2.77466E-02, -5.226874E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.459546E-01, -2.171902E-02, -5.214649E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-7.287318E-01, -2.77466E-02, -5.226874E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <-7.377126E-01, -2.239993E-02, -5.219156E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.377126E-01, -2.239993E-02, -5.219156E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-7.287318E-01, -2.77466E-02, -5.226874E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <-7.227891E-01, -2.823753E-02, -5.230123E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.377126E-01, -2.239993E-02, -5.219156E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-7.227891E-01, -2.823753E-02, -5.230123E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <-7.263084E-01, -2.33419E-02, -5.225392E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.263084E-01, -2.33419E-02, -5.225392E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <-7.227891E-01, -2.823753E-02, -5.230123E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <-7.161038E-01, -2.878981E-02, -5.233779E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.263084E-01, -2.33419E-02, -5.225392E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <-7.161038E-01, -2.878981E-02, -5.233779E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <-7.134792E-01, -2.440157E-02, -5.232408E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.161038E-01, -2.878981E-02, -5.233779E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.09693E-01, -2.931919E-02, -5.237285E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.09693E-01, -2.931919E-02, -5.237285E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.045336E-01, -2.974554E-02, -5.240106E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.045336E-01, -2.974554E-02, -5.240106E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.014104E-01, -3.000341E-02, -5.241814E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.014104E-01, -3.000341E-02, -5.241814E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.007987E-01, -3.005391E-02, -5.242148E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.007987E-01, -3.005391E-02, -5.242148E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.027929E-01, -2.98892E-02, -5.241058E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.027929E-01, -2.98892E-02, -5.241058E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.070878E-01, -2.953444E-02, -5.238709E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.070878E-01, -2.953444E-02, -5.238709E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.130305E-01, -2.904351E-02, -5.23546E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.130305E-01, -2.904351E-02, -5.23546E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.197157E-01, -2.849123E-02, -5.231804E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.197157E-01, -2.849123E-02, -5.231804E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.261265E-01, -2.796185E-02, -5.228298E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.261265E-01, -2.796185E-02, -5.228298E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.312859E-01, -2.753548E-02, -5.225478E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.312859E-01, -2.753548E-02, -5.225478E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.344092E-01, -2.72776E-02, -5.223769E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.344092E-01, -2.72776E-02, -5.223769E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.350208E-01, -2.722713E-02, -5.223435E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.350208E-01, -2.722713E-02, -5.223435E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.330266E-01, -2.739181E-02, -5.224525E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.330266E-01, -2.739181E-02, -5.224525E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.287318E-01, -2.77466E-02, -5.226874E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.287318E-01, -2.77466E-02, -5.226874E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.227891E-01, -2.823753E-02, -5.230123E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex1}
   }
   smooth_triangle {
      <-7.227891E-01, -2.823753E-02, -5.230123E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02> 
      <-7.182403E-01, -3.01908E-02, -5.233572E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.161038E-01, -2.878981E-02, -5.233779E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex1}
   }
}
}
 
// Sphere
object {
union {
   smooth_triangle {
      <-6.993764E-01, 4.766348E-02, -5.221925E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-6.982592E-01, 4.74253E-02, -5.220362E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.982592E-01, 4.74253E-02, -5.220362E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-6.985524E-01, 4.74878E-02, -5.220876E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.985524E-01, 4.74878E-02, -5.220876E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-7.002112E-01, 4.784146E-02, -5.223392E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.002112E-01, 4.784146E-02, -5.223392E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-7.029836E-01, 4.843251E-02, -5.227524E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.029836E-01, 4.843251E-02, -5.227524E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-7.064469E-01, 4.917089E-02, -5.232645E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.064469E-01, 4.917089E-02, -5.232645E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-7.100742E-01, 4.994421E-02, -5.237974E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.100742E-01, 4.994421E-02, -5.237974E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-7.133135E-01, 5.063481E-02, -5.2427E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.133135E-01, 5.063481E-02, -5.2427E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-7.156711E-01, 5.113742E-02, -5.246105E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.156711E-01, 5.113742E-02, -5.246105E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.167882E-01, 5.13756E-02, -5.247668E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.167882E-01, 5.13756E-02, -5.247668E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.164951E-01, 5.13131E-02, -5.247154E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.164951E-01, 5.13131E-02, -5.247154E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.148362E-01, 5.095944E-02, -5.244638E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.148362E-01, 5.095944E-02, -5.244638E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.120638E-01, 5.036839E-02, -5.240506E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.120638E-01, 5.036839E-02, -5.240506E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.086005E-01, 4.963002E-02, -5.235385E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.086005E-01, 4.963002E-02, -5.235385E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-7.049732E-01, 4.88567E-02, -5.230056E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.049732E-01, 4.88567E-02, -5.230056E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-7.017339E-01, 4.816609E-02, -5.22533E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.017339E-01, 4.816609E-02, -5.22533E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-6.993764E-01, 4.766348E-02, -5.221925E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      <-7.071152E-01, 5.131648E-02, -5.234015E+00>  <1.092285E-01, 9.918703E-01, 6.528634E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.993764E-01, 4.766348E-02, -5.221925E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-6.930813E-01, 4.047415E-02, -5.210815E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <-6.909375E-01, 4.001711E-02, -5.207814E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.993764E-01, 4.766348E-02, -5.221925E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02> 
      <-6.909375E-01, 4.001711E-02, -5.207814E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <-6.982592E-01, 4.74253E-02, -5.220362E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.982592E-01, 4.74253E-02, -5.220362E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-6.909375E-01, 4.001711E-02, -5.207814E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      <-6.915002E-01, 4.013721E-02, -5.208802E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.982592E-01, 4.74253E-02, -5.220362E+00>  <3.147851E-01, 9.368281E-01, -1.525233E-01> 
      <-6.915002E-01, 4.013721E-02, -5.208802E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <-6.985524E-01, 4.74878E-02, -5.220876E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.985524E-01, 4.74878E-02, -5.220876E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-6.915002E-01, 4.013721E-02, -5.208802E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      <-6.946835E-01, 4.081586E-02, -5.213629E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.985524E-01, 4.74878E-02, -5.220876E+00>  <2.324553E-01, 9.368281E-01, -2.613763E-01> 
      <-6.946835E-01, 4.081586E-02, -5.213629E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <-7.002112E-01, 4.784146E-02, -5.223392E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.002112E-01, 4.784146E-02, -5.223392E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-6.946835E-01, 4.081586E-02, -5.213629E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      <-7.000033E-01, 4.195002E-02, -5.221559E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.002112E-01, 4.784146E-02, -5.223392E+00>  <1.147364E-01, 9.368281E-01, -3.30437E-01> 
      <-7.000033E-01, 4.195002E-02, -5.221559E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-7.029836E-01, 4.843251E-02, -5.227524E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.029836E-01, 4.843251E-02, -5.227524E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-7.000033E-01, 4.195002E-02, -5.221559E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      <-7.066497E-01, 4.336688E-02, -5.231385E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.029836E-01, 4.843251E-02, -5.227524E+00>  <-2.04502E-02, 9.368281E-01, -3.491917E-01> 
      <-7.066497E-01, 4.336688E-02, -5.231385E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-7.064469E-01, 4.917089E-02, -5.232645E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.064469E-01, 4.917089E-02, -5.232645E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-7.066497E-01, 4.336688E-02, -5.231385E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      <-7.136111E-01, 4.485102E-02, -5.241611E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.064469E-01, 4.917089E-02, -5.232645E+00>  <-1.525234E-01, 9.368281E-01, -3.147851E-01> 
      <-7.136111E-01, 4.485102E-02, -5.241611E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-7.100742E-01, 4.994421E-02, -5.237974E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.100742E-01, 4.994421E-02, -5.237974E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-7.136111E-01, 4.485102E-02, -5.241611E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      <-7.198266E-01, 4.617613E-02, -5.250682E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.100742E-01, 4.994421E-02, -5.237974E+00>  <-2.613763E-01, 9.368281E-01, -2.324553E-01> 
      <-7.198266E-01, 4.617613E-02, -5.250682E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-7.133135E-01, 5.063481E-02, -5.2427E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.133135E-01, 5.063481E-02, -5.2427E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-7.198266E-01, 4.617613E-02, -5.250682E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      <-7.24351E-01, 4.714073E-02, -5.257215E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.133135E-01, 5.063481E-02, -5.2427E+00>  <-3.30437E-01, 9.368281E-01, -1.147363E-01> 
      <-7.24351E-01, 4.714073E-02, -5.257215E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-7.156711E-01, 5.113742E-02, -5.246105E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.156711E-01, 5.113742E-02, -5.246105E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.24351E-01, 4.714073E-02, -5.257215E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      <-7.264948E-01, 4.759777E-02, -5.260216E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.156711E-01, 5.113742E-02, -5.246105E+00>  <-3.491915E-01, 9.368282E-01, 2.045016E-02> 
      <-7.264948E-01, 4.759777E-02, -5.260216E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-7.167882E-01, 5.13756E-02, -5.247668E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.167882E-01, 5.13756E-02, -5.247668E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.264948E-01, 4.759777E-02, -5.260216E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      <-7.259321E-01, 4.747779E-02, -5.259228E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.167882E-01, 5.13756E-02, -5.247668E+00>  <-3.147849E-01, 9.368281E-01, 1.525235E-01> 
      <-7.259321E-01, 4.747779E-02, -5.259228E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-7.164951E-01, 5.13131E-02, -5.247154E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.164951E-01, 5.13131E-02, -5.247154E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.259321E-01, 4.747779E-02, -5.259228E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      <-7.227488E-01, 4.679914E-02, -5.254401E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.164951E-01, 5.13131E-02, -5.247154E+00>  <-2.324553E-01, 9.368281E-01, 2.613763E-01> 
      <-7.227488E-01, 4.679914E-02, -5.254401E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-7.148362E-01, 5.095944E-02, -5.244638E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.148362E-01, 5.095944E-02, -5.244638E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.227488E-01, 4.679914E-02, -5.254401E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      <-7.174289E-01, 4.566496E-02, -5.246471E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.148362E-01, 5.095944E-02, -5.244638E+00>  <-1.147363E-01, 9.368281E-01, 3.30437E-01> 
      <-7.174289E-01, 4.566496E-02, -5.246471E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-7.120638E-01, 5.036839E-02, -5.240506E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.120638E-01, 5.036839E-02, -5.240506E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.174289E-01, 4.566496E-02, -5.246471E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      <-7.107826E-01, 4.424801E-02, -5.236645E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.120638E-01, 5.036839E-02, -5.240506E+00>  <2.045029E-02, 9.368281E-01, 3.491917E-01> 
      <-7.107826E-01, 4.424801E-02, -5.236645E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-7.086005E-01, 4.963002E-02, -5.235385E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.086005E-01, 4.963002E-02, -5.235385E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-7.107826E-01, 4.424801E-02, -5.236645E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      <-7.038212E-01, 4.276386E-02, -5.226418E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.086005E-01, 4.963002E-02, -5.235385E+00>  <1.525235E-01, 9.368281E-01, 3.14785E-01> 
      <-7.038212E-01, 4.276386E-02, -5.226418E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-7.049732E-01, 4.88567E-02, -5.230056E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.049732E-01, 4.88567E-02, -5.230056E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-7.038212E-01, 4.276386E-02, -5.226418E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      <-6.976057E-01, 4.143875E-02, -5.217348E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.049732E-01, 4.88567E-02, -5.230056E+00>  <2.613764E-01, 9.368281E-01, 2.324553E-01> 
      <-6.976057E-01, 4.143875E-02, -5.217348E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <-7.017339E-01, 4.816609E-02, -5.22533E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.017339E-01, 4.816609E-02, -5.22533E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-6.976057E-01, 4.143875E-02, -5.217348E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      <-6.930813E-01, 4.047415E-02, -5.210815E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.017339E-01, 4.816609E-02, -5.22533E+00>  <3.30437E-01, 9.368281E-01, 1.147363E-01> 
      <-6.930813E-01, 4.047415E-02, -5.210815E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      <-6.993764E-01, 4.766348E-02, -5.221925E+00>  <3.491917E-01, 9.368281E-01, 2.045005E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.930813E-01, 4.047415E-02, -5.210815E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <-6.887406E-01, 3.033136E-02, -5.201585E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <-6.85743E-01, 2.96923E-02, -5.19739E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.930813E-01, 4.047415E-02, -5.210815E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02> 
      <-6.85743E-01, 2.96923E-02, -5.19739E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <-6.909375E-01, 4.001711E-02, -5.207814E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.909375E-01, 4.001711E-02, -5.207814E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <-6.85743E-01, 2.96923E-02, -5.19739E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      <-6.865297E-01, 2.986001E-02, -5.198771E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.909375E-01, 4.001711E-02, -5.207814E+00>  <5.406897E-01, 8.004439E-01, -2.587357E-01> 
      <-6.865297E-01, 2.986001E-02, -5.198771E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <-6.915002E-01, 4.013721E-02, -5.208802E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.915002E-01, 4.013721E-02, -5.208802E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <-6.865297E-01, 2.986001E-02, -5.198771E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      <-6.9098E-01, 3.08088E-02, -5.205517E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.915002E-01, 4.013721E-02, -5.208802E+00>  <4.005183E-01, 8.004439E-01, -4.459536E-01> 
      <-6.9098E-01, 3.08088E-02, -5.205517E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <-6.946835E-01, 4.081586E-02, -5.213629E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.946835E-01, 4.081586E-02, -5.213629E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <-6.9098E-01, 3.08088E-02, -5.205517E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      <-6.984165E-01, 3.239421E-02, -5.216602E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.946835E-01, 4.081586E-02, -5.213629E+00>  <1.993716E-01, 8.004439E-01, -5.652792E-01> 
      <-6.984165E-01, 3.239421E-02, -5.216602E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-7.000033E-01, 4.195002E-02, -5.221559E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.000033E-01, 4.195002E-02, -5.221559E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-6.984165E-01, 3.239421E-02, -5.216602E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      <-7.077075E-01, 3.4375E-02, -5.230338E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.000033E-01, 4.195002E-02, -5.221559E+00>  <-3.212765E-02, 8.004439E-01, -5.98546E-01> 
      <-7.077075E-01, 3.4375E-02, -5.230338E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-7.066497E-01, 4.336688E-02, -5.231385E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.066497E-01, 4.336688E-02, -5.231385E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-7.077075E-01, 3.4375E-02, -5.230338E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      <-7.174383E-01, 3.64496E-02, -5.244634E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.066497E-01, 4.336688E-02, -5.231385E+00>  <-2.587358E-01, 8.004439E-01, -5.406896E-01> 
      <-7.174383E-01, 3.64496E-02, -5.244634E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-7.136111E-01, 4.485102E-02, -5.241611E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.136111E-01, 4.485102E-02, -5.241611E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-7.174383E-01, 3.64496E-02, -5.244634E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      <-7.261267E-01, 3.830191E-02, -5.257313E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.136111E-01, 4.485102E-02, -5.241611E+00>  <-4.459537E-01, 8.004439E-01, -4.005182E-01> 
      <-7.261267E-01, 3.830191E-02, -5.257313E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-7.198266E-01, 4.617613E-02, -5.250682E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.198266E-01, 4.617613E-02, -5.250682E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-7.261267E-01, 3.830191E-02, -5.257313E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      <-7.32451E-01, 3.965022E-02, -5.266445E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.198266E-01, 4.617613E-02, -5.250682E+00>  <-5.652791E-01, 8.004439E-01, -1.993715E-01> 
      <-7.32451E-01, 3.965022E-02, -5.266445E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-7.24351E-01, 4.714073E-02, -5.257215E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.24351E-01, 4.714073E-02, -5.257215E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-7.32451E-01, 3.965022E-02, -5.266445E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      <-7.354486E-01, 4.028929E-02, -5.27064E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.24351E-01, 4.714073E-02, -5.257215E+00>  <-5.98546E-01, 8.004439E-01, 3.212773E-02> 
      <-7.354486E-01, 4.028929E-02, -5.27064E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-7.264948E-01, 4.759777E-02, -5.260216E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.264948E-01, 4.759777E-02, -5.260216E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-7.354486E-01, 4.028929E-02, -5.27064E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      <-7.346619E-01, 4.012153E-02, -5.269259E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.264948E-01, 4.759777E-02, -5.260216E+00>  <-5.406895E-01, 8.004439E-01, 2.587359E-01> 
      <-7.346619E-01, 4.012153E-02, -5.269259E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-7.259321E-01, 4.747779E-02, -5.259228E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.259321E-01, 4.747779E-02, -5.259228E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-7.346619E-01, 4.012153E-02, -5.269259E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      <-7.302117E-01, 3.917274E-02, -5.262513E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.259321E-01, 4.747779E-02, -5.259228E+00>  <-4.005181E-01, 8.004439E-01, 4.459537E-01> 
      <-7.302117E-01, 3.917274E-02, -5.262513E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      <-7.227488E-01, 4.679914E-02, -5.254401E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.227488E-01, 4.679914E-02, -5.254401E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-7.302117E-01, 3.917274E-02, -5.262513E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      <-7.227752E-01, 3.758732E-02, -5.251427E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.227488E-01, 4.679914E-02, -5.254401E+00>  <-1.993714E-01, 8.004439E-01, 5.652791E-01> 
      <-7.227752E-01, 3.758732E-02, -5.251427E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-7.174289E-01, 4.566496E-02, -5.246471E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.174289E-01, 4.566496E-02, -5.246471E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-7.227752E-01, 3.758732E-02, -5.251427E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      <-7.134842E-01, 3.560652E-02, -5.237691E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.174289E-01, 4.566496E-02, -5.246471E+00>  <3.212788E-02, 8.004439E-01, 5.98546E-01> 
      <-7.134842E-01, 3.560652E-02, -5.237691E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-7.107826E-01, 4.424801E-02, -5.236645E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.107826E-01, 4.424801E-02, -5.236645E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-7.134842E-01, 3.560652E-02, -5.237691E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      <-7.037533E-01, 3.3532E-02, -5.223396E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.107826E-01, 4.424801E-02, -5.236645E+00>  <2.587359E-01, 8.004439E-01, 5.406895E-01> 
      <-7.037533E-01, 3.3532E-02, -5.223396E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <-7.038212E-01, 4.276386E-02, -5.226418E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.038212E-01, 4.276386E-02, -5.226418E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <-7.037533E-01, 3.3532E-02, -5.223396E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      <-6.950649E-01, 3.167968E-02, -5.210717E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.038212E-01, 4.276386E-02, -5.226418E+00>  <4.459538E-01, 8.004439E-01, 4.005181E-01> 
      <-6.950649E-01, 3.167968E-02, -5.210717E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <-6.976057E-01, 4.143875E-02, -5.217348E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.976057E-01, 4.143875E-02, -5.217348E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <-6.950649E-01, 3.167968E-02, -5.210717E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      <-6.887406E-01, 3.033136E-02, -5.201585E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.976057E-01, 4.143875E-02, -5.217348E+00>  <5.652791E-01, 8.004439E-01, 1.993715E-01> 
      <-6.887406E-01, 3.033136E-02, -5.201585E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      <-6.930813E-01, 4.047415E-02, -5.210815E+00>  <5.98546E-01, 8.004439E-01, 3.21275E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.887406E-01, 3.033136E-02, -5.201585E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <-6.867055E-01, 1.805646E-02, -5.194981E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <-6.830979E-01, 1.728734E-02, -5.189932E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.887406E-01, 3.033136E-02, -5.201585E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02> 
      <-6.830979E-01, 1.728734E-02, -5.189932E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <-6.85743E-01, 2.96923E-02, -5.19739E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.85743E-01, 2.96923E-02, -5.19739E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <-6.830979E-01, 1.728734E-02, -5.189932E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      <-6.840442E-01, 1.74891E-02, -5.191595E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.85743E-01, 2.96923E-02, -5.19739E+00>  <7.227622E-01, 5.994641E-01, -3.438862E-01> 
      <-6.840442E-01, 1.74891E-02, -5.191595E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <-6.865297E-01, 2.986001E-02, -5.198771E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.865297E-01, 2.986001E-02, -5.198771E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <-6.840442E-01, 1.74891E-02, -5.191595E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      <-6.894004E-01, 1.863107E-02, -5.199715E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.865297E-01, 2.986001E-02, -5.198771E+00>  <5.361456E-01, 5.994642E-01, -5.942984E-01> 
      <-6.894004E-01, 1.863107E-02, -5.199715E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <-6.9098E-01, 3.08088E-02, -5.205517E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.9098E-01, 3.08088E-02, -5.205517E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <-6.894004E-01, 1.863107E-02, -5.199715E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      <-6.983511E-01, 2.053933E-02, -5.213057E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.9098E-01, 3.08088E-02, -5.205517E+00>  <2.679058E-01, 5.994641E-01, -7.542342E-01> 
      <-6.983511E-01, 2.053933E-02, -5.213057E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-6.984165E-01, 3.239421E-02, -5.216602E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.984165E-01, 3.239421E-02, -5.216602E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-6.983511E-01, 2.053933E-02, -5.213057E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      <-7.095339E-01, 2.292338E-02, -5.22959E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.984165E-01, 3.239421E-02, -5.216602E+00>  <-4.112032E-02, 5.994641E-01, -7.993447E-01> 
      <-7.095339E-01, 2.292338E-02, -5.22959E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-7.077075E-01, 3.4375E-02, -5.230338E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.077075E-01, 3.4375E-02, -5.230338E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-7.095339E-01, 2.292338E-02, -5.22959E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      <-7.212457E-01, 2.542028E-02, -5.246796E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.077075E-01, 3.4375E-02, -5.230338E+00>  <-3.438863E-01, 5.994641E-01, -7.22762E-01> 
      <-7.212457E-01, 2.542028E-02, -5.246796E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-7.174383E-01, 3.64496E-02, -5.244634E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.174383E-01, 3.64496E-02, -5.244634E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-7.212457E-01, 2.542028E-02, -5.246796E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      <-7.317036E-01, 2.764974E-02, -5.262057E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.174383E-01, 3.64496E-02, -5.244634E+00>  <-5.942985E-01, 5.994641E-01, -5.361455E-01> 
      <-7.317036E-01, 2.764974E-02, -5.262057E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-7.261267E-01, 3.830191E-02, -5.257313E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.261267E-01, 3.830191E-02, -5.257313E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-7.317036E-01, 2.764974E-02, -5.262057E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      <-7.393156E-01, 2.927257E-02, -5.273049E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.261267E-01, 3.830191E-02, -5.257313E+00>  <-7.542343E-01, 5.994641E-01, -2.679057E-01> 
      <-7.393156E-01, 2.927257E-02, -5.273049E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-7.32451E-01, 3.965022E-02, -5.266445E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.32451E-01, 3.965022E-02, -5.266445E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-7.393156E-01, 2.927257E-02, -5.273049E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      <-7.429231E-01, 3.004168E-02, -5.278098E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.32451E-01, 3.965022E-02, -5.266445E+00>  <-7.993446E-01, 5.994642E-01, 4.112044E-02> 
      <-7.429231E-01, 3.004168E-02, -5.278098E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-7.354486E-01, 4.028929E-02, -5.27064E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.354486E-01, 4.028929E-02, -5.27064E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-7.429231E-01, 3.004168E-02, -5.278098E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      <-7.419769E-01, 2.983989E-02, -5.276435E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.354486E-01, 4.028929E-02, -5.27064E+00>  <-7.22762E-01, 5.994642E-01, 3.438863E-01> 
      <-7.419769E-01, 2.983989E-02, -5.276435E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-7.346619E-01, 4.012153E-02, -5.269259E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.346619E-01, 4.012153E-02, -5.269259E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-7.419769E-01, 2.983989E-02, -5.276435E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      <-7.366207E-01, 2.869797E-02, -5.268315E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.346619E-01, 4.012153E-02, -5.269259E+00>  <-5.361454E-01, 5.994641E-01, 5.942986E-01> 
      <-7.366207E-01, 2.869797E-02, -5.268315E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-7.302117E-01, 3.917274E-02, -5.262513E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.302117E-01, 3.917274E-02, -5.262513E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01> 
      <-7.366207E-01, 2.869797E-02, -5.268315E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      <-7.276699E-01, 2.67897E-02, -5.254973E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.302117E-01, 3.917274E-02, -5.262513E+00>  <-2.679055E-01, 5.994642E-01, 7.542342E-01> 
      <-7.276699E-01, 2.67897E-02, -5.254973E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-7.227752E-01, 3.758732E-02, -5.251427E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.227752E-01, 3.758732E-02, -5.251427E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-7.276699E-01, 2.67897E-02, -5.254973E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      <-7.164871E-01, 2.440559E-02, -5.23844E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.227752E-01, 3.758732E-02, -5.251427E+00>  <4.112069E-02, 5.994641E-01, 7.993447E-01> 
      <-7.164871E-01, 2.440559E-02, -5.23844E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-7.134842E-01, 3.560652E-02, -5.237691E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.134842E-01, 3.560652E-02, -5.237691E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-7.164871E-01, 2.440559E-02, -5.23844E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      <-7.047753E-01, 2.190875E-02, -5.221234E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.134842E-01, 3.560652E-02, -5.237691E+00>  <3.438865E-01, 5.994642E-01, 7.227619E-01> 
      <-7.047753E-01, 2.190875E-02, -5.221234E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <-7.037533E-01, 3.3532E-02, -5.223396E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.037533E-01, 3.3532E-02, -5.223396E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <-7.047753E-01, 2.190875E-02, -5.221234E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      <-6.943174E-01, 1.967928E-02, -5.205973E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.037533E-01, 3.3532E-02, -5.223396E+00>  <5.942986E-01, 5.994642E-01, 5.361454E-01> 
      <-6.943174E-01, 1.967928E-02, -5.205973E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <-6.950649E-01, 3.167968E-02, -5.210717E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.950649E-01, 3.167968E-02, -5.210717E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <-6.943174E-01, 1.967928E-02, -5.205973E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      <-6.867055E-01, 1.805646E-02, -5.194981E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.950649E-01, 3.167968E-02, -5.210717E+00>  <7.542343E-01, 5.994642E-01, 2.679057E-01> 
      <-6.867055E-01, 1.805646E-02, -5.194981E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      <-6.887406E-01, 3.033136E-02, -5.201585E+00>  <7.993446E-01, 5.994642E-01, 4.112009E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.867055E-01, 1.805646E-02, -5.194981E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <-6.871404E-01, 4.643777E-03, -5.19154E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <-6.83215E-01, 3.806897E-03, -5.186046E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.867055E-01, 1.805646E-02, -5.194981E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02> 
      <-6.83215E-01, 3.806897E-03, -5.186046E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <-6.830979E-01, 1.728734E-02, -5.189932E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.830979E-01, 1.728734E-02, -5.189932E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <-6.83215E-01, 3.806897E-03, -5.186046E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      <-6.842449E-01, 4.026538E-03, -5.187855E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.830979E-01, 1.728734E-02, -5.189932E+00>  <8.464205E-01, 3.50134E-01, -4.012213E-01> 
      <-6.842449E-01, 4.026538E-03, -5.187855E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <-6.840442E-01, 1.74891E-02, -5.191595E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.840442E-01, 1.74891E-02, -5.191595E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <-6.842449E-01, 4.026538E-03, -5.187855E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      <-6.900734E-01, 5.269146E-03, -5.196691E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.840442E-01, 1.74891E-02, -5.191595E+00>  <6.284499E-01, 3.50134E-01, -6.945912E-01> 
      <-6.900734E-01, 5.269146E-03, -5.196691E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <-6.894004E-01, 1.863107E-02, -5.199715E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.894004E-01, 1.863107E-02, -5.199715E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <-6.900734E-01, 5.269146E-03, -5.196691E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      <-6.998128E-01, 7.345543E-03, -5.21121E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.894004E-01, 1.863107E-02, -5.199715E+00>  <3.148032E-01, 3.50134E-01, -8.82216E-01> 
      <-6.998128E-01, 7.345543E-03, -5.21121E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-6.983511E-01, 2.053933E-02, -5.213057E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.983511E-01, 2.053933E-02, -5.213057E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-6.998128E-01, 7.345543E-03, -5.21121E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      <-7.119814E-01, 9.939815E-03, -5.2292E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.983511E-01, 2.053933E-02, -5.213057E+00>  <-4.676913E-02, 3.501341E-01, -9.355313E-01> 
      <-7.119814E-01, 9.939815E-03, -5.2292E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-7.095339E-01, 2.292338E-02, -5.22959E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.095339E-01, 2.292338E-02, -5.22959E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-7.119814E-01, 9.939815E-03, -5.2292E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      <-7.247257E-01, 1.265678E-02, -5.247923E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.095339E-01, 2.292338E-02, -5.22959E+00>  <-4.012215E-01, 3.50134E-01, -8.464203E-01> 
      <-7.247257E-01, 1.265678E-02, -5.247923E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-7.212457E-01, 2.542028E-02, -5.246796E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.212457E-01, 2.542028E-02, -5.246796E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-7.247257E-01, 1.265678E-02, -5.247923E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      <-7.361058E-01, 1.508297E-02, -5.264529E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.212457E-01, 2.542028E-02, -5.246796E+00>  <-6.945913E-01, 3.50134E-01, -6.284497E-01> 
      <-7.361058E-01, 1.508297E-02, -5.264529E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-7.317036E-01, 2.764974E-02, -5.262057E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.317036E-01, 2.764974E-02, -5.262057E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-7.361058E-01, 1.508297E-02, -5.264529E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      <-7.443889E-01, 1.684882E-02, -5.27649E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.317036E-01, 2.764974E-02, -5.262057E+00>  <-8.82216E-01, 3.50134E-01, -3.148032E-01> 
      <-7.443889E-01, 1.684882E-02, -5.27649E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-7.393156E-01, 2.927257E-02, -5.273049E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.393156E-01, 2.927257E-02, -5.273049E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-7.443889E-01, 1.684882E-02, -5.27649E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      <-7.483142E-01, 1.768569E-02, -5.281984E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.393156E-01, 2.927257E-02, -5.273049E+00>  <-9.355313E-01, 3.501339E-01, 4.676927E-02> 
      <-7.483142E-01, 1.768569E-02, -5.281984E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-7.429231E-01, 3.004168E-02, -5.278098E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.429231E-01, 3.004168E-02, -5.278098E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-7.483142E-01, 1.768569E-02, -5.281984E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      <-7.472843E-01, 1.746606E-02, -5.280175E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.429231E-01, 3.004168E-02, -5.278098E+00>  <-8.464203E-01, 3.501339E-01, 4.012217E-01> 
      <-7.472843E-01, 1.746606E-02, -5.280175E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-7.419769E-01, 2.983989E-02, -5.276435E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.419769E-01, 2.983989E-02, -5.276435E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-7.472843E-01, 1.746606E-02, -5.280175E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      <-7.414559E-01, 1.622346E-02, -5.271339E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.419769E-01, 2.983989E-02, -5.276435E+00>  <-6.284496E-01, 3.501339E-01, 6.945915E-01> 
      <-7.414559E-01, 1.622346E-02, -5.271339E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-7.366207E-01, 2.869797E-02, -5.268315E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.366207E-01, 2.869797E-02, -5.268315E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-7.414559E-01, 1.622346E-02, -5.271339E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      <-7.317165E-01, 1.414706E-02, -5.25682E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.366207E-01, 2.869797E-02, -5.268315E+00>  <-3.148031E-01, 3.501339E-01, 8.822161E-01> 
      <-7.317165E-01, 1.414706E-02, -5.25682E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-7.276699E-01, 2.67897E-02, -5.254973E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.276699E-01, 2.67897E-02, -5.254973E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-7.317165E-01, 1.414706E-02, -5.25682E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      <-7.195479E-01, 1.155278E-02, -5.23883E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.276699E-01, 2.67897E-02, -5.254973E+00>  <4.676945E-02, 3.501342E-01, 9.355313E-01> 
      <-7.195479E-01, 1.155278E-02, -5.23883E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-7.164871E-01, 2.440559E-02, -5.23844E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.164871E-01, 2.440559E-02, -5.23844E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-7.195479E-01, 1.155278E-02, -5.23883E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      <-7.068036E-01, 8.835828E-03, -5.220107E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.164871E-01, 2.440559E-02, -5.23844E+00>  <4.012218E-01, 3.50134E-01, 8.464202E-01> 
      <-7.068036E-01, 8.835828E-03, -5.220107E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <-7.047753E-01, 2.190875E-02, -5.221234E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.047753E-01, 2.190875E-02, -5.221234E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <-7.068036E-01, 8.835828E-03, -5.220107E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      <-6.954235E-01, 6.409693E-03, -5.203501E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.047753E-01, 2.190875E-02, -5.221234E+00>  <6.945916E-01, 3.50134E-01, 6.284495E-01> 
      <-6.954235E-01, 6.409693E-03, -5.203501E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <-6.943174E-01, 1.967928E-02, -5.205973E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.943174E-01, 1.967928E-02, -5.205973E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <-6.954235E-01, 6.409693E-03, -5.203501E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      <-6.871404E-01, 4.643777E-03, -5.19154E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.943174E-01, 1.967928E-02, -5.205973E+00>  <8.822161E-01, 3.501339E-01, 3.148031E-01> 
      <-6.871404E-01, 4.643777E-03, -5.19154E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      <-6.867055E-01, 1.805646E-02, -5.194981E+00>  <9.355313E-01, 3.50134E-01, 4.676888E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.871404E-01, 4.643777E-03, -5.19154E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <-6.900108E-01, -8.819813E-03, -5.19154E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      <-6.860854E-01, -9.656687E-03, -5.186046E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.871404E-01, 4.643777E-03, -5.19154E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02> 
      <-6.860854E-01, -9.656687E-03, -5.186046E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <-6.83215E-01, 3.806897E-03, -5.186046E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.83215E-01, 3.806897E-03, -5.186046E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <-6.860854E-01, -9.656687E-03, -5.186046E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      <-6.871153E-01, -9.437001E-03, -5.187855E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.83215E-01, 3.806897E-03, -5.186046E+00>  <9.017174E-01, 7.246999E-02, -4.262086E-01> 
      <-6.871153E-01, -9.437001E-03, -5.187855E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <-6.842449E-01, 4.026538E-03, -5.187855E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.842449E-01, 4.026538E-03, -5.187855E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <-6.871153E-01, -9.437001E-03, -5.187855E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      <-6.929438E-01, -8.194386E-03, -5.196691E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.842449E-01, 4.026538E-03, -5.187855E+00>  <6.699753E-01, 7.246993E-02, -7.388377E-01> 
      <-6.929438E-01, -8.194386E-03, -5.196691E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <-6.900734E-01, 5.269146E-03, -5.196691E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900734E-01, 5.269146E-03, -5.196691E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <-6.929438E-01, -8.194386E-03, -5.196691E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      <-7.026832E-01, -6.117989E-03, -5.21121E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900734E-01, 5.269146E-03, -5.196691E+00>  <3.362355E-01, 7.246999E-02, -9.389855E-01> 
      <-7.026832E-01, -6.117989E-03, -5.21121E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-6.998128E-01, 7.345543E-03, -5.21121E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.998128E-01, 7.345543E-03, -5.21121E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-7.026832E-01, -6.117989E-03, -5.21121E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      <-7.148517E-01, -3.523776E-03, -5.2292E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.998128E-01, 7.345543E-03, -5.21121E+00>  <-4.869318E-02, 7.246992E-02, -9.961812E-01> 
      <-7.148517E-01, -3.523776E-03, -5.2292E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      <-7.119814E-01, 9.939815E-03, -5.2292E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.119814E-01, 9.939815E-03, -5.2292E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-7.148517E-01, -3.523776E-03, -5.2292E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      <-7.27596E-01, -8.068157E-04, -5.247923E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.119814E-01, 9.939815E-03, -5.2292E+00>  <-4.262087E-01, 7.246998E-02, -9.017174E-01> 
      <-7.27596E-01, -8.068157E-04, -5.247923E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-7.247257E-01, 1.265678E-02, -5.247923E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.247257E-01, 1.265678E-02, -5.247923E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-7.27596E-01, -8.068157E-04, -5.247923E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      <-7.389762E-01, 1.619385E-03, -5.264529E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.247257E-01, 1.265678E-02, -5.247923E+00>  <-7.388379E-01, 7.246991E-02, -6.699752E-01> 
      <-7.389762E-01, 1.619385E-03, -5.264529E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-7.361058E-01, 1.508297E-02, -5.264529E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.361058E-01, 1.508297E-02, -5.264529E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-7.389762E-01, 1.619385E-03, -5.264529E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      <-7.472593E-01, 3.385293E-03, -5.27649E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.361058E-01, 1.508297E-02, -5.264529E+00>  <-9.389855E-01, 7.246996E-02, -3.362353E-01> 
      <-7.472593E-01, 3.385293E-03, -5.27649E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-7.443889E-01, 1.684882E-02, -5.27649E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.443889E-01, 1.684882E-02, -5.27649E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-7.472593E-01, 3.385293E-03, -5.27649E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      <-7.511846E-01, 4.222153E-03, -5.281984E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.443889E-01, 1.684882E-02, -5.27649E+00>  <-9.961812E-01, 7.246989E-02, 4.869338E-02> 
      <-7.511846E-01, 4.222153E-03, -5.281984E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-7.483142E-01, 1.768569E-02, -5.281984E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.483142E-01, 1.768569E-02, -5.281984E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-7.511846E-01, 4.222153E-03, -5.281984E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      <-7.501547E-01, 4.002525E-03, -5.280175E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.483142E-01, 1.768569E-02, -5.281984E+00>  <-9.017172E-01, 7.246993E-02, 4.26209E-01> 
      <-7.501547E-01, 4.002525E-03, -5.280175E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-7.472843E-01, 1.746606E-02, -5.280175E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.472843E-01, 1.746606E-02, -5.280175E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-7.501547E-01, 4.002525E-03, -5.280175E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      <-7.443262E-01, 2.759925E-03, -5.271339E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.472843E-01, 1.746606E-02, -5.280175E+00>  <-6.699751E-01, 7.246998E-02, 7.388379E-01> 
      <-7.443262E-01, 2.759925E-03, -5.271339E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-7.414559E-01, 1.622346E-02, -5.271339E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.414559E-01, 1.622346E-02, -5.271339E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-7.443262E-01, 2.759925E-03, -5.271339E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      <-7.345868E-01, 6.835276E-04, -5.25682E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.414559E-01, 1.622346E-02, -5.271339E+00>  <-3.362352E-01, 7.246999E-02, 9.389856E-01> 
      <-7.345868E-01, 6.835276E-04, -5.25682E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-7.317165E-01, 1.414706E-02, -5.25682E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.317165E-01, 1.414706E-02, -5.25682E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-7.345868E-01, 6.835276E-04, -5.25682E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      <-7.224182E-01, -1.910751E-03, -5.23883E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.317165E-01, 1.414706E-02, -5.25682E+00>  <4.869354E-02, 7.246994E-02, 9.961812E-01> 
      <-7.224182E-01, -1.910751E-03, -5.23883E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-7.195479E-01, 1.155278E-02, -5.23883E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.195479E-01, 1.155278E-02, -5.23883E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-7.224182E-01, -1.910751E-03, -5.23883E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      <-7.09674E-01, -4.627705E-03, -5.220107E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.195479E-01, 1.155278E-02, -5.23883E+00>  <4.262091E-01, 7.246997E-02, 9.017172E-01> 
      <-7.09674E-01, -4.627705E-03, -5.220107E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <-7.068036E-01, 8.835828E-03, -5.220107E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.068036E-01, 8.835828E-03, -5.220107E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <-7.09674E-01, -4.627705E-03, -5.220107E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      <-6.982939E-01, -7.053898E-03, -5.203501E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.068036E-01, 8.835828E-03, -5.220107E+00>  <7.38838E-01, 7.247002E-02, 6.69975E-01> 
      <-6.982939E-01, -7.053898E-03, -5.203501E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <-6.954235E-01, 6.409693E-03, -5.203501E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.954235E-01, 6.409693E-03, -5.203501E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <-6.982939E-01, -7.053898E-03, -5.203501E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      <-6.900108E-01, -8.819813E-03, -5.19154E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.954235E-01, 6.409693E-03, -5.203501E+00>  <9.389856E-01, 7.247002E-02, 3.362353E-01> 
      <-6.900108E-01, -8.819813E-03, -5.19154E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      <-6.871404E-01, 4.643777E-03, -5.19154E+00>  <9.961812E-01, 7.246994E-02, 4.869282E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900108E-01, -8.819813E-03, -5.19154E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02> 
      <-6.950841E-01, -2.124362E-02, -5.194981E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <-6.914766E-01, -2.201273E-02, -5.189932E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.900108E-01, -8.819813E-03, -5.19154E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02> 
      <-6.914766E-01, -2.201273E-02, -5.189932E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <-6.860854E-01, -9.656687E-03, -5.186046E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.860854E-01, -9.656687E-03, -5.186046E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <-6.914766E-01, -2.201273E-02, -5.189932E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      <-6.924228E-01, -2.181081E-02, -5.191595E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.860854E-01, -9.656687E-03, -5.186046E+00>  <8.841004E-01, -2.112352E-01, -4.168288E-01> 
      <-6.924228E-01, -2.181081E-02, -5.191595E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <-6.871153E-01, -9.437001E-03, -5.187855E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.871153E-01, -9.437001E-03, -5.187855E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <-6.924228E-01, -2.181081E-02, -5.191595E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      <-6.97779E-01, -2.06689E-02, -5.199715E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.871153E-01, -9.437001E-03, -5.187855E+00>  <6.572887E-01, -2.112352E-01, -7.234302E-01> 
      <-6.97779E-01, -2.06689E-02, -5.199715E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      <-6.929438E-01, -8.194386E-03, -5.196691E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.929438E-01, -8.194386E-03, -5.196691E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <-6.97779E-01, -2.06689E-02, -5.199715E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      <-7.067298E-01, -1.876063E-02, -5.213057E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.929438E-01, -8.194386E-03, -5.196691E+00>  <3.304108E-01, -2.112352E-01, -9.198959E-01> 
      <-7.067298E-01, -1.876063E-02, -5.213057E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      <-7.026832E-01, -6.117989E-03, -5.21121E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.026832E-01, -6.117989E-03, -5.21121E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-7.067298E-01, -1.876063E-02, -5.213057E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      <-7.179125E-01, -1.637658E-02, -5.229589E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.026832E-01, -6.117989E-03, -5.21121E+00>  <-4.676918E-02, -2.112352E-01, -9.763157E-01> 
      <-7.179125E-01, -1.637658E-02, -5.229589E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-7.148517E-01, -3.523776E-03, -5.2292E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.148517E-01, -3.523776E-03, -5.2292E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01> 
      <-7.179125E-01, -1.637658E-02, -5.229589E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      <-7.296243E-01, -1.387981E-02, -5.246796E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.148517E-01, -3.523776E-03, -5.2292E+00>  <-4.16829E-01, -2.112352E-01, -8.841003E-01> 
      <-7.296243E-01, -1.387981E-02, -5.246796E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-7.27596E-01, -8.068157E-04, -5.247923E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.27596E-01, -8.068157E-04, -5.247923E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-7.296243E-01, -1.387981E-02, -5.246796E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      <-7.400823E-01, -1.165022E-02, -5.262057E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.27596E-01, -8.068157E-04, -5.247923E+00>  <-7.234303E-01, -2.112351E-01, -6.572887E-01> 
      <-7.400823E-01, -1.165022E-02, -5.262057E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-7.389762E-01, 1.619385E-03, -5.264529E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.389762E-01, 1.619385E-03, -5.264529E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-7.400823E-01, -1.165022E-02, -5.262057E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      <-7.476941E-01, -1.002739E-02, -5.273049E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.389762E-01, 1.619385E-03, -5.264529E+00>  <-9.198959E-01, -2.112351E-01, -3.304107E-01> 
      <-7.476941E-01, -1.002739E-02, -5.273049E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-7.472593E-01, 3.385293E-03, -5.27649E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.472593E-01, 3.385293E-03, -5.27649E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-7.476941E-01, -1.002739E-02, -5.273049E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      <-7.513017E-01, -9.25828E-03, -5.278098E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.472593E-01, 3.385293E-03, -5.27649E+00>  <-9.763157E-01, -2.112351E-01, 4.676933E-02> 
      <-7.513017E-01, -9.25828E-03, -5.278098E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-7.511846E-01, 4.222153E-03, -5.281984E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.511846E-01, 4.222153E-03, -5.281984E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-7.513017E-01, -9.25828E-03, -5.278098E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      <-7.503554E-01, -9.460025E-03, -5.276435E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.511846E-01, 4.222153E-03, -5.281984E+00>  <-8.841002E-01, -2.112351E-01, 4.168292E-01> 
      <-7.503554E-01, -9.460025E-03, -5.276435E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-7.501547E-01, 4.002525E-03, -5.280175E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.501547E-01, 4.002525E-03, -5.280175E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-7.503554E-01, -9.460025E-03, -5.276435E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      <-7.449993E-01, -1.060199E-02, -5.268315E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.501547E-01, 4.002525E-03, -5.280175E+00>  <-6.572886E-01, -2.112351E-01, 7.234304E-01> 
      <-7.449993E-01, -1.060199E-02, -5.268315E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      <-7.443262E-01, 2.759925E-03, -5.271339E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.443262E-01, 2.759925E-03, -5.271339E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-7.449993E-01, -1.060199E-02, -5.268315E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      <-7.360485E-01, -1.251027E-02, -5.254973E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.443262E-01, 2.759925E-03, -5.271339E+00>  <-3.304105E-01, -2.112352E-01, 9.198959E-01> 
      <-7.360485E-01, -1.251027E-02, -5.254973E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      <-7.345868E-01, 6.835276E-04, -5.25682E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.345868E-01, 6.835276E-04, -5.25682E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-7.360485E-01, -1.251027E-02, -5.254973E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      <-7.248657E-01, -1.489432E-02, -5.23844E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.345868E-01, 6.835276E-04, -5.25682E+00>  <4.676951E-02, -2.112351E-01, 9.763157E-01> 
      <-7.248657E-01, -1.489432E-02, -5.23844E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      <-7.224182E-01, -1.910751E-03, -5.23883E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.224182E-01, -1.910751E-03, -5.23883E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-7.248657E-01, -1.489432E-02, -5.23844E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      <-7.13154E-01, -1.739121E-02, -5.221234E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.224182E-01, -1.910751E-03, -5.23883E+00>  <4.168293E-01, -2.112352E-01, 8.841001E-01> 
      <-7.13154E-01, -1.739121E-02, -5.221234E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <-7.09674E-01, -4.627705E-03, -5.220107E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.09674E-01, -4.627705E-03, -5.220107E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <-7.13154E-01, -1.739121E-02, -5.221234E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      <-7.02696E-01, -1.96208E-02, -5.205973E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.09674E-01, -4.627705E-03, -5.220107E+00>  <7.234305E-01, -2.112352E-01, 6.572884E-01> 
      <-7.02696E-01, -1.96208E-02, -5.205973E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <-6.982939E-01, -7.053898E-03, -5.203501E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.982939E-01, -7.053898E-03, -5.203501E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <-7.02696E-01, -1.96208E-02, -5.205973E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      <-6.950841E-01, -2.124362E-02, -5.194981E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.982939E-01, -7.053898E-03, -5.203501E+00>  <9.198959E-01, -2.112352E-01, 3.304106E-01> 
      <-6.950841E-01, -2.124362E-02, -5.194981E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      <-6.900108E-01, -8.819813E-03, -5.19154E+00>  <9.763157E-01, -2.112352E-01, 4.676886E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.950841E-01, -2.124362E-02, -5.194981E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <-7.019486E-01, -3.162116E-02, -5.201585E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <-6.989511E-01, -3.226022E-02, -5.19739E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.950841E-01, -2.124362E-02, -5.194981E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02> 
      <-6.989511E-01, -3.226022E-02, -5.19739E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <-6.914766E-01, -2.201273E-02, -5.189932E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.914766E-01, -2.201273E-02, -5.189932E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <-6.989511E-01, -3.226022E-02, -5.19739E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      <-6.997377E-01, -3.209245E-02, -5.198771E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.914766E-01, -2.201273E-02, -5.189932E+00>  <7.94831E-01, -4.780833E-01, -3.73738E-01> 
      <-6.997377E-01, -3.209245E-02, -5.198771E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <-6.924228E-01, -2.181081E-02, -5.191595E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.924228E-01, -2.181081E-02, -5.191595E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <-6.997377E-01, -3.209245E-02, -5.198771E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      <-7.04188E-01, -3.114367E-02, -5.205517E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.924228E-01, -2.181081E-02, -5.191595E+00>  <5.913048E-01, -4.780832E-01, -6.494575E-01> 
      <-7.04188E-01, -3.114367E-02, -5.205517E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <-6.97779E-01, -2.06689E-02, -5.199715E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.97779E-01, -2.06689E-02, -5.199715E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01> 
      <-7.04188E-01, -3.114367E-02, -5.205517E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      <-7.116244E-01, -2.955825E-02, -5.216602E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.97779E-01, -2.06689E-02, -5.199715E+00>  <2.977577E-01, -4.780833E-01, -8.263031E-01> 
      <-7.116244E-01, -2.955825E-02, -5.216602E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-7.067298E-01, -1.876063E-02, -5.213057E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.067298E-01, -1.876063E-02, -5.213057E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01> 
      <-7.116244E-01, -2.955825E-02, -5.216602E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      <-7.209154E-01, -2.757746E-02, -5.230338E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.067298E-01, -1.876063E-02, -5.213057E+00>  <-4.112037E-02, -4.780833E-01, -8.773513E-01> 
      <-7.209154E-01, -2.757746E-02, -5.230338E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-7.179125E-01, -1.637658E-02, -5.229589E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.179125E-01, -1.637658E-02, -5.229589E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-7.209154E-01, -2.757746E-02, -5.230338E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      <-7.306464E-01, -2.550293E-02, -5.244634E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.179125E-01, -1.637658E-02, -5.229589E+00>  <-3.737381E-01, -4.780833E-01, -7.94831E-01> 
      <-7.306464E-01, -2.550293E-02, -5.244634E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-7.296243E-01, -1.387981E-02, -5.246796E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.296243E-01, -1.387981E-02, -5.246796E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-7.306464E-01, -2.550293E-02, -5.244634E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      <-7.393347E-01, -2.365061E-02, -5.257313E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.296243E-01, -1.387981E-02, -5.246796E+00>  <-6.494576E-01, -4.780833E-01, -5.913047E-01> 
      <-7.393347E-01, -2.365061E-02, -5.257313E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-7.400823E-01, -1.165022E-02, -5.262057E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.400823E-01, -1.165022E-02, -5.262057E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-7.393347E-01, -2.365061E-02, -5.257313E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      <-7.456591E-01, -2.23023E-02, -5.266445E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.400823E-01, -1.165022E-02, -5.262057E+00>  <-8.263031E-01, -4.780833E-01, -2.977576E-01> 
      <-7.456591E-01, -2.23023E-02, -5.266445E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-7.476941E-01, -1.002739E-02, -5.273049E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.476941E-01, -1.002739E-02, -5.273049E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-7.456591E-01, -2.23023E-02, -5.266445E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      <-7.486566E-01, -2.166324E-02, -5.27064E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.476941E-01, -1.002739E-02, -5.273049E+00>  <-8.773514E-01, -4.780832E-01, 4.11205E-02> 
      <-7.486566E-01, -2.166324E-02, -5.27064E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-7.513017E-01, -9.25828E-03, -5.278098E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.513017E-01, -9.25828E-03, -5.278098E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-7.486566E-01, -2.166324E-02, -5.27064E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      <-7.4787E-01, -2.183094E-02, -5.269259E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.513017E-01, -9.25828E-03, -5.278098E+00>  <-7.948309E-01, -4.780833E-01, 3.737383E-01> 
      <-7.4787E-01, -2.183094E-02, -5.269259E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-7.503554E-01, -9.460025E-03, -5.276435E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.503554E-01, -9.460025E-03, -5.276435E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-7.4787E-01, -2.183094E-02, -5.269259E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      <-7.434196E-01, -2.277973E-02, -5.262513E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.503554E-01, -9.460025E-03, -5.276435E+00>  <-5.913045E-01, -4.780833E-01, 6.494578E-01> 
      <-7.434196E-01, -2.277973E-02, -5.262513E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-7.449993E-01, -1.060199E-02, -5.268315E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.449993E-01, -1.060199E-02, -5.268315E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01> 
      <-7.434196E-01, -2.277973E-02, -5.262513E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      <-7.359832E-01, -2.436514E-02, -5.251427E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.449993E-01, -1.060199E-02, -5.268315E+00>  <-2.977574E-01, -4.780833E-01, 8.263031E-01> 
      <-7.359832E-01, -2.436514E-02, -5.251427E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-7.360485E-01, -1.251027E-02, -5.254973E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.360485E-01, -1.251027E-02, -5.254973E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01> 
      <-7.359832E-01, -2.436514E-02, -5.251427E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      <-7.266922E-01, -2.634594E-02, -5.237691E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.360485E-01, -1.251027E-02, -5.254973E+00>  <4.112067E-02, -4.780833E-01, 8.773514E-01> 
      <-7.266922E-01, -2.634594E-02, -5.237691E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-7.248657E-01, -1.489432E-02, -5.23844E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.248657E-01, -1.489432E-02, -5.23844E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01> 
      <-7.266922E-01, -2.634594E-02, -5.237691E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      <-7.169613E-01, -2.842053E-02, -5.223396E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.248657E-01, -1.489432E-02, -5.23844E+00>  <3.737384E-01, -4.780833E-01, 7.948308E-01> 
      <-7.169613E-01, -2.842053E-02, -5.223396E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <-7.13154E-01, -1.739121E-02, -5.221234E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.13154E-01, -1.739121E-02, -5.221234E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <-7.169613E-01, -2.842053E-02, -5.223396E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      <-7.082729E-01, -3.027285E-02, -5.210717E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.13154E-01, -1.739121E-02, -5.221234E+00>  <6.494578E-01, -4.780832E-01, 5.913044E-01> 
      <-7.082729E-01, -3.027285E-02, -5.210717E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <-7.02696E-01, -1.96208E-02, -5.205973E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.02696E-01, -1.96208E-02, -5.205973E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <-7.082729E-01, -3.027285E-02, -5.210717E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      <-7.019486E-01, -3.162116E-02, -5.201585E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.02696E-01, -1.96208E-02, -5.205973E+00>  <8.263032E-01, -4.780833E-01, 2.977574E-01> 
      <-7.019486E-01, -3.162116E-02, -5.201585E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      <-6.950841E-01, -2.124362E-02, -5.194981E+00>  <8.773515E-01, -4.780833E-01, 4.112003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.019486E-01, -3.162116E-02, -5.201585E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <-7.100487E-01, -3.911177E-02, -5.210815E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <-7.079049E-01, -3.956869E-02, -5.207814E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.019486E-01, -3.162116E-02, -5.201585E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02> 
      <-7.079049E-01, -3.956869E-02, -5.207814E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <-6.989511E-01, -3.226022E-02, -5.19739E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.989511E-01, -3.226022E-02, -5.19739E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <-7.079049E-01, -3.956869E-02, -5.207814E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      <-7.084677E-01, -3.944872E-02, -5.208802E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.989511E-01, -3.226022E-02, -5.19739E+00>  <6.409939E-01, -7.063689E-01, -3.00283E-01> 
      <-7.084677E-01, -3.944872E-02, -5.208802E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <-6.997377E-01, -3.209245E-02, -5.198771E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.997377E-01, -3.209245E-02, -5.198771E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <-7.084677E-01, -3.944872E-02, -5.208802E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      <-7.116508E-01, -3.877006E-02, -5.213629E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-6.997377E-01, -3.209245E-02, -5.198771E+00>  <4.772878E-01, -7.063689E-01, -5.227231E-01> 
      <-7.116508E-01, -3.877006E-02, -5.213629E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <-7.04188E-01, -3.114367E-02, -5.205517E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.04188E-01, -3.114367E-02, -5.205517E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <-7.116508E-01, -3.877006E-02, -5.213629E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      <-7.169707E-01, -3.76359E-02, -5.221559E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.04188E-01, -3.114367E-02, -5.205517E+00>  <2.40919E-01, -7.063689E-01, -6.655832E-01> 
      <-7.169707E-01, -3.76359E-02, -5.221559E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-7.116244E-01, -2.955825E-02, -5.216602E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.116244E-01, -2.955825E-02, -5.216602E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-7.169707E-01, -3.76359E-02, -5.221559E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      <-7.23617E-01, -3.621893E-02, -5.231385E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.116244E-01, -2.955825E-02, -5.216602E+00>  <-3.212773E-02, -7.063689E-01, -7.071143E-01> 
      <-7.23617E-01, -3.621893E-02, -5.231385E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-7.209154E-01, -2.757746E-02, -5.230338E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.209154E-01, -2.757746E-02, -5.230338E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-7.23617E-01, -3.621893E-02, -5.231385E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      <-7.305785E-01, -3.473479E-02, -5.241611E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.209154E-01, -2.757746E-02, -5.230338E+00>  <-3.002831E-01, -7.06369E-01, -6.409937E-01> 
      <-7.305785E-01, -3.473479E-02, -5.241611E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-7.306464E-01, -2.550293E-02, -5.244634E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.306464E-01, -2.550293E-02, -5.244634E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-7.305785E-01, -3.473479E-02, -5.241611E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      <-7.367939E-01, -3.340968E-02, -5.250681E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.306464E-01, -2.550293E-02, -5.244634E+00>  <-5.227232E-01, -7.063689E-01, -4.772876E-01> 
      <-7.367939E-01, -3.340968E-02, -5.250681E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-7.393347E-01, -2.365061E-02, -5.257313E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.393347E-01, -2.365061E-02, -5.257313E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-7.367939E-01, -3.340968E-02, -5.250681E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      <-7.413185E-01, -3.244519E-02, -5.257215E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.393347E-01, -2.365061E-02, -5.257313E+00>  <-6.655832E-01, -7.063689E-01, -2.409188E-01> 
      <-7.413185E-01, -3.244519E-02, -5.257215E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-7.456591E-01, -2.23023E-02, -5.266445E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.456591E-01, -2.23023E-02, -5.266445E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-7.413185E-01, -3.244519E-02, -5.257215E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      <-7.434621E-01, -3.198816E-02, -5.260215E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.456591E-01, -2.23023E-02, -5.266445E+00>  <-7.071142E-01, -7.063691E-01, 3.212797E-02> 
      <-7.434621E-01, -3.198816E-02, -5.260215E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-7.486566E-01, -2.166324E-02, -5.27064E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.486566E-01, -2.166324E-02, -5.27064E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-7.434621E-01, -3.198816E-02, -5.260215E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      <-7.428994E-01, -3.210814E-02, -5.259228E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.486566E-01, -2.166324E-02, -5.27064E+00>  <-6.409937E-01, -7.06369E-01, 3.002831E-01> 
      <-7.428994E-01, -3.210814E-02, -5.259228E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-7.4787E-01, -2.183094E-02, -5.269259E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.4787E-01, -2.183094E-02, -5.269259E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-7.428994E-01, -3.210814E-02, -5.259228E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      <-7.397162E-01, -3.278678E-02, -5.254401E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.4787E-01, -2.183094E-02, -5.269259E+00>  <-4.772877E-01, -7.063689E-01, 5.227231E-01> 
      <-7.397162E-01, -3.278678E-02, -5.254401E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-7.434196E-01, -2.277973E-02, -5.262513E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.434196E-01, -2.277973E-02, -5.262513E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-7.397162E-01, -3.278678E-02, -5.254401E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      <-7.343963E-01, -3.392096E-02, -5.246471E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.434196E-01, -2.277973E-02, -5.262513E+00>  <-2.409187E-01, -7.063689E-01, 6.655833E-01> 
      <-7.343963E-01, -3.392096E-02, -5.246471E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-7.359832E-01, -2.436514E-02, -5.251427E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.359832E-01, -2.436514E-02, -5.251427E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-7.343963E-01, -3.392096E-02, -5.246471E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      <-7.2775E-01, -3.533792E-02, -5.236645E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.359832E-01, -2.436514E-02, -5.251427E+00>  <3.212797E-02, -7.063689E-01, 7.071143E-01> 
      <-7.2775E-01, -3.533792E-02, -5.236645E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-7.266922E-01, -2.634594E-02, -5.237691E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.266922E-01, -2.634594E-02, -5.237691E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-7.2775E-01, -3.533792E-02, -5.236645E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      <-7.207886E-01, -3.682206E-02, -5.226418E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.266922E-01, -2.634594E-02, -5.237691E+00>  <3.002833E-01, -7.063689E-01, 6.409937E-01> 
      <-7.207886E-01, -3.682206E-02, -5.226418E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <-7.169613E-01, -2.842053E-02, -5.223396E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.169613E-01, -2.842053E-02, -5.223396E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <-7.207886E-01, -3.682206E-02, -5.226418E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      <-7.145731E-01, -3.814717E-02, -5.217348E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.169613E-01, -2.842053E-02, -5.223396E+00>  <5.227232E-01, -7.063689E-01, 4.772876E-01> 
      <-7.145731E-01, -3.814717E-02, -5.217348E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <-7.082729E-01, -3.027285E-02, -5.210717E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.082729E-01, -3.027285E-02, -5.210717E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <-7.145731E-01, -3.814717E-02, -5.217348E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      <-7.100487E-01, -3.911177E-02, -5.210815E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.082729E-01, -3.027285E-02, -5.210717E+00>  <6.655833E-01, -7.063689E-01, 2.409188E-01> 
      <-7.100487E-01, -3.911177E-02, -5.210815E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      <-7.019486E-01, -3.162116E-02, -5.201585E+00>  <7.071144E-01, -7.063689E-01, 3.212742E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.100487E-01, -3.911177E-02, -5.210815E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <-7.187286E-01, -4.310835E-02, -5.221925E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <-7.176114E-01, -4.334653E-02, -5.220362E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.100487E-01, -3.911177E-02, -5.210815E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02> 
      <-7.176114E-01, -4.334653E-02, -5.220362E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <-7.079049E-01, -3.956869E-02, -5.207814E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.079049E-01, -3.956869E-02, -5.207814E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <-7.176114E-01, -4.334653E-02, -5.220362E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      <-7.179046E-01, -4.328403E-02, -5.220876E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.079049E-01, -3.956869E-02, -5.207814E+00>  <4.350227E-01, -8.773933E-01, -2.023273E-01> 
      <-7.179046E-01, -4.328403E-02, -5.220876E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <-7.084677E-01, -3.944872E-02, -5.208802E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.084677E-01, -3.944872E-02, -5.208802E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <-7.179046E-01, -4.328403E-02, -5.220876E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      <-7.195634E-01, -4.293037E-02, -5.223392E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.084677E-01, -3.944872E-02, -5.208802E+00>  <3.244811E-01, -8.773933E-01, -3.534021E-01> 
      <-7.195634E-01, -4.293037E-02, -5.223392E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-7.116508E-01, -3.877006E-02, -5.213629E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.116508E-01, -3.877006E-02, -5.213629E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-7.195634E-01, -4.293037E-02, -5.223392E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      <-7.223358E-01, -4.233932E-02, -5.227524E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.116508E-01, -3.877006E-02, -5.213629E+00>  <1.645405E-01, -8.773933E-01, -4.506745E-01> 
      <-7.223358E-01, -4.233932E-02, -5.227524E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-7.169707E-01, -3.76359E-02, -5.221559E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.169707E-01, -3.76359E-02, -5.221559E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-7.223358E-01, -4.233932E-02, -5.227524E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      <-7.257991E-01, -4.160095E-02, -5.232645E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.169707E-01, -3.76359E-02, -5.221559E+00>  <-2.045023E-02, -8.773933E-01, -4.793358E-01> 
      <-7.257991E-01, -4.160095E-02, -5.232645E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-7.23617E-01, -3.621893E-02, -5.231385E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.23617E-01, -3.621893E-02, -5.231385E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-7.257991E-01, -4.160095E-02, -5.232645E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      <-7.294264E-01, -4.082762E-02, -5.237974E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.23617E-01, -3.621893E-02, -5.231385E+00>  <-2.023274E-01, -8.773933E-01, -4.350226E-01> 
      <-7.294264E-01, -4.082762E-02, -5.237974E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-7.305785E-01, -3.473479E-02, -5.241611E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.305785E-01, -3.473479E-02, -5.241611E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-7.294264E-01, -4.082762E-02, -5.237974E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      <-7.326657E-01, -4.013702E-02, -5.2427E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.305785E-01, -3.473479E-02, -5.241611E+00>  <-3.534021E-01, -8.773933E-01, -3.244811E-01> 
      <-7.326657E-01, -4.013702E-02, -5.2427E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-7.367939E-01, -3.340968E-02, -5.250681E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.367939E-01, -3.340968E-02, -5.250681E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-7.326657E-01, -4.013702E-02, -5.2427E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      <-7.350232E-01, -3.963441E-02, -5.246104E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.367939E-01, -3.340968E-02, -5.250681E+00>  <-4.506746E-01, -8.773932E-01, -1.645403E-01> 
      <-7.350232E-01, -3.963441E-02, -5.246104E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-7.413185E-01, -3.244519E-02, -5.257215E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.413185E-01, -3.244519E-02, -5.257215E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-7.350232E-01, -3.963441E-02, -5.246104E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      <-7.361404E-01, -3.939622E-02, -5.247668E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.413185E-01, -3.244519E-02, -5.257215E+00>  <-4.793357E-01, -8.773933E-01, 2.045065E-02> 
      <-7.361404E-01, -3.939622E-02, -5.247668E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-7.434621E-01, -3.198816E-02, -5.260215E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.434621E-01, -3.198816E-02, -5.260215E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-7.361404E-01, -3.939622E-02, -5.247668E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      <-7.358473E-01, -3.945873E-02, -5.247154E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.434621E-01, -3.198816E-02, -5.260215E+00>  <-4.350227E-01, -8.773932E-01, 2.023274E-01> 
      <-7.358473E-01, -3.945873E-02, -5.247154E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-7.428994E-01, -3.210814E-02, -5.259228E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.428994E-01, -3.210814E-02, -5.259228E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-7.358473E-01, -3.945873E-02, -5.247154E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      <-7.341884E-01, -3.981239E-02, -5.244638E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.428994E-01, -3.210814E-02, -5.259228E+00>  <-3.244812E-01, -8.773933E-01, 3.53402E-01> 
      <-7.341884E-01, -3.981239E-02, -5.244638E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-7.397162E-01, -3.278678E-02, -5.254401E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.397162E-01, -3.278678E-02, -5.254401E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-7.341884E-01, -3.981239E-02, -5.244638E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      <-7.31416E-01, -4.040344E-02, -5.240506E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.397162E-01, -3.278678E-02, -5.254401E+00>  <-1.645402E-01, -8.773933E-01, 4.506745E-01> 
      <-7.31416E-01, -4.040344E-02, -5.240506E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-7.343963E-01, -3.392096E-02, -5.246471E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.343963E-01, -3.392096E-02, -5.246471E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-7.31416E-01, -4.040344E-02, -5.240506E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      <-7.279527E-01, -4.114182E-02, -5.235385E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.343963E-01, -3.392096E-02, -5.246471E+00>  <2.045036E-02, -8.773933E-01, 4.793358E-01> 
      <-7.279527E-01, -4.114182E-02, -5.235385E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-7.2775E-01, -3.533792E-02, -5.236645E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.2775E-01, -3.533792E-02, -5.236645E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-7.279527E-01, -4.114182E-02, -5.235385E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      <-7.243254E-01, -4.191513E-02, -5.230056E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.2775E-01, -3.533792E-02, -5.236645E+00>  <2.023276E-01, -8.773933E-01, 4.350225E-01> 
      <-7.243254E-01, -4.191513E-02, -5.230056E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <-7.207886E-01, -3.682206E-02, -5.226418E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.207886E-01, -3.682206E-02, -5.226418E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-7.243254E-01, -4.191513E-02, -5.230056E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      <-7.210861E-01, -4.260573E-02, -5.22533E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.207886E-01, -3.682206E-02, -5.226418E+00>  <3.534022E-01, -8.773933E-01, 3.24481E-01> 
      <-7.210861E-01, -4.260573E-02, -5.22533E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <-7.145731E-01, -3.814717E-02, -5.217348E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.145731E-01, -3.814717E-02, -5.217348E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <-7.210861E-01, -4.260573E-02, -5.22533E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      <-7.187286E-01, -4.310835E-02, -5.221925E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.145731E-01, -3.814717E-02, -5.217348E+00>  <4.506745E-01, -8.773933E-01, 1.645403E-01> 
      <-7.187286E-01, -4.310835E-02, -5.221925E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      <-7.100487E-01, -3.911177E-02, -5.210815E+00>  <4.793358E-01, -8.773933E-01, 2.045003E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.187286E-01, -4.310835E-02, -5.221925E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.176114E-01, -4.334653E-02, -5.220362E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.176114E-01, -4.334653E-02, -5.220362E+00>  <1.937156E-01, -9.771176E-01, -8.783823E-02> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.179046E-01, -4.328403E-02, -5.220876E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.179046E-01, -4.328403E-02, -5.220876E+00>  <1.453556E-01, -9.771176E-01, -1.552837E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.195634E-01, -4.293037E-02, -5.223392E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.195634E-01, -4.293037E-02, -5.223392E+00>  <7.486659E-02, -9.771175E-01, -1.990886E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.223358E-01, -4.233932E-02, -5.227524E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.223358E-01, -4.233932E-02, -5.227524E+00>  <-7.020265E-03, -9.771175E-01, -2.125841E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.257991E-01, -4.160095E-02, -5.232645E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.257991E-01, -4.160095E-02, -5.232645E+00>  <-8.783837E-02, -9.771175E-01, -1.937157E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.294264E-01, -4.082762E-02, -5.237974E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.294264E-01, -4.082762E-02, -5.237974E+00>  <-1.552838E-01, -9.771175E-01, -1.453557E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.326657E-01, -4.013702E-02, -5.2427E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.326657E-01, -4.013702E-02, -5.2427E+00>  <-1.990888E-01, -9.771175E-01, -7.486659E-02> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.350232E-01, -3.963441E-02, -5.246104E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.350232E-01, -3.963441E-02, -5.246104E+00>  <-2.125842E-01, -9.771175E-01, 7.020683E-03> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.361404E-01, -3.939622E-02, -5.247668E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.361404E-01, -3.939622E-02, -5.247668E+00>  <-1.937159E-01, -9.771175E-01, 8.783837E-02> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.358473E-01, -3.945873E-02, -5.247154E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.358473E-01, -3.945873E-02, -5.247154E+00>  <-1.453558E-01, -9.771175E-01, 1.552837E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.341884E-01, -3.981239E-02, -5.244638E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.341884E-01, -3.981239E-02, -5.244638E+00>  <-7.486654E-02, -9.771175E-01, 1.990887E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.31416E-01, -4.040344E-02, -5.240506E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.31416E-01, -4.040344E-02, -5.240506E+00>  <7.020305E-03, -9.771175E-01, 2.125841E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.279527E-01, -4.114182E-02, -5.235385E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.279527E-01, -4.114182E-02, -5.235385E+00>  <8.783834E-02, -9.771175E-01, 1.937156E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.243254E-01, -4.191513E-02, -5.230056E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.243254E-01, -4.191513E-02, -5.230056E+00>  <1.552837E-01, -9.771176E-01, 1.453555E-01> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.210861E-01, -4.260573E-02, -5.22533E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02>
      texture {Tex0}
   }
   smooth_triangle {
      <-7.210861E-01, -4.260573E-02, -5.22533E+00>  <1.990886E-01, -9.771176E-01, 7.48665E-02> 
      <-7.272844E-01, -4.32874E-02, -5.234015E+00>  <1.09228E-01, -9.918704E-01, 6.528601E-02>
      <-7.187286E-01, -4.310835E-02, -5.221925E+00>  <2.12584E-01, -9.771176E-01, 7.020171E-03>
      texture {Tex0}
   }
}
}
