#version unofficial MegaPov 0.7;

#include "colors.inc"
#include "feathers.inc"
#include "PhoenixBeak.inc"

/*camera {
  location <0, 3, -20>
  //location <0, 20, -5>
  look_at <0,3,0>
  //angle 32
  }
  
light_source {<0,3,-100> color White}*/  
//light_source {<0, 100, 0> color White}

//background {color White}
//background {color Black}

#declare Claw = sphere_sweep { 
  catmull_rom_spline_sphere_sweep 
  6, 
  <0, -.1, .1>, .1, 
  <0, 0, 0>, .075, 
  <0, .1, -.2>, .05, 
  <0, -.05, -.3>, .025, 
  <0, -.2, -.2>, .01, 
  <0, -.35, .1>, 0  
  sphere_sweep_depth_tolerance 1.0e-3 
  texture {pigment {Orange} finish {ambient .8 diffuse .1 }} 
} 

#declare Toe = union { 
  object {Claw translate z*-.7375} 
  sphere {0, .1375} 
  sphere {0, .125 translate z*-.15} 
  sphere {0, .1125 translate z*-.3} 
  sphere {0, .125 translate z*-.45} 
  sphere {0, .1375 translate z*-.6} 
  rotate x*-10 
} 

#declare Foot = union { 
  cone {<0, -.5, 0>, .1375 <0, .55, 0>, .1875} 
  sphere {<0, -.5, 0>, .1375} 
  object {Toe rotate x*-15 translate <0, -.5, -.225> } 
  object {Toe translate <0, -.5, -.225> rotate y*45} 
  object {Toe translate <0, -.5, -.225> rotate y*-45} 
  object {Toe translate <0, -.5, -.225> rotate y*180}  
}

#declare Tail = union {
  MakeFeather (6, .3, 0, z*180, <0,0,0>, on)
  MakeFeather (5.75, .3, .1, z*185, <0,0,0>, on)
  MakeFeather (5.5, .3, .2, z*190, <0,0,0>, on)
  MakeFeather (5.25, .3, .3, z*195, <0,0,0>, on)
  MakeFeather (5, .3, .4, z*200, <0,0,0>, on)
  MakeFeather (5.75, .3, -.1, z*175, <0,0,0>, on)
  MakeFeather (5.5, .3, -.2, z*170, <0,0,0>, on)
  MakeFeather (5.25, .3, -.3, z*165, <0,0,0>, on)
  MakeFeather (5, .3, -.4, z*160, <0,0,0>, on)
  rotate z*-5
}

#declare EyeHole = merge { 
  sphere {0, .225} 
  cone {0, 0.1125, <0.075, 0, 0>, 0 translate x*.2} 
  cone {0, 0.1125, <-0.075, 0, 0>, 0 translate x*-.2} 
  scale .9 
  texture {pigment {Black} finish {ambient .8 diffuse .1 }}
}  

#declare Eye = sphere {0, .3 
  texture { 
    pigment { 
      wood 
      color_map { 
        [0.0 Black] 
        [0.1 Black] 
        [0.125 Yellow] 
        [0.25 Orange] 
        [0.8 Black] 
        [0.8 White] 
        [1.0 White] 
      } 
    } 
    finish { 
      ambient .8 
      diffuse .1 
      specular .75 
      roughness .01 
      reflection .1 
    } 
  } 
} 

#declare EyeBrow = sphere_sweep { 
  catmull_rom_spline_sphere_sweep 
  5, 
  <-.4, -.15, -0.2>, 0.075, 
  <-.3, -.1, -0.1>, 0.075, 
  <0, 0, 0>, 0.075, 
  <.3, -.1, -0.1>, 0.075, 
  <.4, -.15, -0.2>, 0.075 
  sphere_sweep_depth_tolerance 1.0e-3 
}  

//define points on spline
#declare sp1 = <-1, 1, 0>;
#declare sp2 = <0, 0, 0>;
#declare sp3 = <2, 1, 0>;
#declare sp4 = <3.375, 2.5, 0>;
#declare sp5 = <4.8, 4.815, 0>;
#declare sp6 = <7.5, 5.55, 0>;
#declare sp7 = <8, 5.5, 0>;

#declare WingSupport = sphere_sweep {
  catmull_rom_spline_sphere_sweep
  7,
  sp1, 0.25,
  sp2, 0.25,
  sp3, 0.2,
  sp4, 0.2,
  sp5, 0.1,
  sp6, 0.1,
  sp7, 0.05
  sphere_sweep_depth_tolerance 1.0e-3
  texture {pigment {Red} finish {ambient .6 diffuse .2 } normal {granite scale .1 bump_size 5}}
}

#declare Wing = object {WingSupport translate <0, 2.5, 0>}
#declare FRot = 0;
#declare FLevel = 1;
#declare FLength = 4;
#declare FWidth = .4;
#declare FSym = .5;
#declare Stem = on;

#macro AddFeathers (p1, p2, p3, p4, p5, p6, p7)
  #declare Counter = 2;
  #while (Counter < 6)
    #declare S = 0;
    #while (S < 1)
      #declare h1 = 2*pow(S, 3) - 3*pow(S, 2) + 1;
      #declare h2 = -2*pow(S, 3) + 3*pow(S, 2);
      #declare h3 = pow(S, 3) - 2*pow(S, 2) + S;
      #declare h4 = pow(S, 3) - pow(S, 2);
      #declare r1 = 2*pow(S+1.0e-9, 3) - 3*pow(S+1.0e-9, 2) + 1;
      #declare r2 = -2*pow(S+1.0e-9, 3) + 3*pow(S+1.0e-9, 2);
      #declare r3 = pow(S+1.0e-9, 3) - 2*pow(S+1.0e-9, 2) + S+1.0e-9;
      #declare r4 = pow(S+1.0e-9, 3) - pow(S+1.0e-9, 2);
      #switch (Counter)
        #case (2)
          #local t1 = 0.5*(p3-p1);
          #local t2 = 0.5*(p4-p2);
          #declare Point = h1*p2 + h2*p3 + h3*t1 + h4*t2;
          #declare RotPoint = r1*p2 + r2*p3 + r3*t1 + r4*t2;
          #declare Incr = .15;
        #break
        #case (3)
          #local t1 = 0.5*(p4-p2);
          #local t2 = 0.5*(p5-p3);
          #declare Point = h1*p3 + h2*p4 + h3*t1 + h4*t2;
          #declare RotPoint = r1*p3 + r2*p4 + r3*t1 + r4*t2;
          #declare Incr = .1;
        #break
        #case (4)
          #local t1 = 0.5*(p5-p3);
          #local t2 = 0.5*(p6-p4);
          #declare Point = h1*p4 + h2*p5 + h3*t1 + h4*t2;
          #declare RotPoint = r1*p4 + r2*p5 + r3*t1 + r4*t2;
          #declare Incr = .15;
        #break
        #case (5)
          #local t1 = 0.5*(p6-p4);
          #local t2 = 0.5*(p7-p5);
          #declare Point = h1*p5 + h2*p6 + h3*t1 + h4*t2;
          #declare RotPoint = r1*p5 + r2*p6 + r3*t1 + r4*t2;
          #declare Incr = .1;
          #if (FLevel > 6)
            #declare Incr = .125;
          #end
        #break
      #end
      #declare ZRot = degrees (atan2 ((RotPoint.y - Point.y)/(RotPoint.x - Point.x), 1));
      #if (ZRot < 0)
        #declare ZRot = ZRot + 180;
      #end
      #declare Wing = union {
        object {Wing}
        MakeFeather (FLength, FWidth, FSym, <FRot,-20,ZRot+180>, Point, Stem)
      }
      //MakeFeather (5, .5, 0, <0,ZRot-(90-ZRot),ZRot-(270-ZRot)>, Point)
      //sphere {Point, .1 pigment {Red}}
      //cylinder {0, <0,1,0>, .1 rotate <0, 0, ZRot-(270-ZRot)> translate Point pigment {Red}}
      //#debug concat ("ZRot = ", str(ZRot, 0, 0), "\n")
      #declare S = S + Incr;
    #end
    #declare Counter = Counter + 1;
  #end
#end

//Bottom row of feathers
AddFeathers (<-1, 0, 0>, <0, 1, 0>, <2, 1.75, 0>, <4.75, 5, 0>, <8, 6, 0>, <9, 7.5, 0>, <8, 8, 0> )

//Second row of feathers
#declare FRot = -5;
#declare FLevel = 2;
#declare FLength = 3;
#declare FWidth = .3;
#declare FSym = .5;
AddFeathers (<-1, 2, 0>, <0, 2, 0>, <2, 2.75, 0>, <4.75, 6, 0>, <7, 6.75, 0>, <8, 7.9, 0>, <7, 8.4, 0>)

//Third row of feathers
#declare FLevel = 3;
#declare FLength = 1.5;
#declare FWidth = .35;
#declare FSym = 0;
#declare Stem = off;
AddFeathers (<-1, 1.5, 0>, <0, 1.5, 0>, <2, 2.25, 0>, <4.75, 6.25, 0>, <7, 7, 0>, <8, 7.75, 0>, <7, 8.25, 0>)

//Fourth row of feathers
#declare FLevel = 4;
#declare FLength = .75;
#declare FWidth = .25;
#declare FSym = 0;
AddFeathers (<-1, 1.75, 0>, <0, 1.75, 0>, <2, 2.5, 0>, <4.75, 6.5, 0>, <7, 7.25, 0>, <8, 7.85, 0>, <7, 8.35, 0>)

#declare FLevel = 5;
AddFeathers (<-1, 2, 0>, <0, 2, 0>, <2, 2.75, 0>, <4.75, 6.75, 0>, <7, 7.5, 0>, <8, 7.9, 0>, <7, 8.5, 0>)

#declare FLevel = 6;
AddFeathers (<-1, 2.25, 0>, <0, 2.25, 0>, <2, 3, 0>, <4.75, 7, 0>, <7, 7.75, 0>, <8, 7.95, 0>, <7, 8.6, 0>)

#declare FLevel = 7;
AddFeathers (<-1, 2.5, 0>, <0, 2.5, 0>, <2, 3.25, 0>, <4.75, 7.25, 0>, <7, 8, 0>, <8, 8.15, 0>, <7, 8.65, 0>)

#declare FLevel = 8;
AddFeathers (<-1, 2.75, 0>, <0, 2.75, 0>, <2, 3.5, 0>, <4.75, 7.325, 0>, <7, 8, 0>, <8, 8.175, 0>, <7, 8.675, 0>)




#declare BodyTexture = texture {
  pigment {
    image_map {
      png "flames3.png"
      interpolate 2
    }
  }
  finish {ambient .8 diffuse .1}
  //normal {gradient x scale .1 turbulence .2 bump_size 10}
}

#declare DummyTexture = texture { pigment {Orange} finish {ambient .8 diffuse .1} }//normal {gradient x scale .1 turbulence .2 bump_size 10}}

#declare NeckTexture = texture {
  gradient y
  scale 4
  texture_map {
    [0.0 BodyTexture scale .25]
    [1.0 DummyTexture]
  } 
}


//head 
#declare Phoenix = union { 
  union { 
    difference { 
      difference { 
        union { 
          sphere {0, 1.125 scale <.65, .8, 1> scale .8 translate x*.2 } 
          sphere {0, 1.125 scale <.65, .8, 1> scale .8 translate x*-.2 }
      
          //head feathers      
          #declare _r1 = 0;
          #declare seed1 = seed (143);
          #while (_r1 < 60)
            #local randnum = rand (seed1);
            cylinder {0, <0, 2.5, 0>, .025 rotate <_r1+randnum, 0, 5*randnum> texture {pigment {Gray65} finish {ambient .8 diffuse .1 }}}
            #declare _r1 = _r1 + 4;
          #end
       
          rotate x*30 
        } 
        sphere {0, 1.125 scale <1, .25, 1> scale .8 rotate x*30 translate <0,-.6, -.4> } 
      } 
      object {EyeHole rotate y*90 translate <.775, .15, -.225>}//translate <.745, .36, 0> } 
      texture {pigment {image_map {png "Phoenix_face2.png" once interpolate 2} translate <-.5, -.5, 0> scale 4 rotate y*-90 translate <.785, .05, -.375>} finish {ambient .8 diffuse .1 } normal {granite scale .1 bump_size 5}} 
    } 
    object {Eye rotate <0, 95, 10> translate <.3775, .09, -.2>}//<translate <.3725, .25, 0>} translate <.745, .5025, 0> 
    object {EyeBrow rotate y*90 translate <.765, .3225, -.15> texture {pigment {OrangeRed} finish {ambient .8 diffuse .1 }} normal {granite scale .1 bump_size 5}} 
    rotate y*45 
    translate y*5.15 
  } 
  
  object {LowerBeak texture {pigment {gradient x scale 2 color_map {[0.0 Red] [1.0 OrangeRed]}} finish {ambient .8 diffuse .1 specular 1 roughness .1}} scale <.105, .295, .5> rotate <0, 90, 90> translate <-.95, 5.05, 0> rotate y*-45} 
  
  object {UpperBeak texture {pigment {gradient x scale 2 color_map {[0.0 Red] [1.0 OrangeRed]}} finish {ambient .8 diffuse .1 specular 1 roughness .1}} scale <.175, .25, .5> rotate <0, 90, 25> translate <-1.35, 5.45, 0> rotate y*-45} 

  blob { 
    threshold 0.5 
    
    //neck
    cylinder {0, <0, 2, 0>, .75, 1 translate y*2 texture {pigment {Orange} finish {ambient .8 diffuse .1 }} normal {gradient x turbulence 1 bump_size 2} normal {granite scale .1 bump_size 5}}
    sphere {0, 1.35, 1 scale <1.125, 1.25, 1> scale .9 rotate x*-45 translate <0, 4.75, 0> rotate y*45 texture {pigment {Red} finish {ambient .8 diffuse .1 }} normal {granite scale .1 bump_size 5}}
    sphere {0, .825, -.5 scale .8 translate <0, 4.275, -.625> rotate y*45 texture {pigment {Red} finish {ambient .8 diffuse .1 }}}
    
    //breast
    sphere {0, 3, 1 scale <.5, 1, .5> rotate <-20, 0, 15> translate <.75, 1.5, .15> texture {NeckTexture}}
    sphere {0, 3, 1 scale <.5, 1, .5> rotate <-20, 0, -15> translate <-.75, 1.5, .15> texture {NeckTexture}}
    sphere {0, 3, 1 scale <.5, 1, .5> rotate x*-30 translate <0, 0, .35> texture {pigment {Red} finish {ambient .8 diffuse .1 }} normal {gradient x scale .1 turbulence .2 bump_size 10}}
    
    //legs
    sphere {0, 1.5, 1 scale <.5, 1, .65> rotate x*-10 translate <1, -.5, 0> texture {BodyTexture}}
    sphere {0, 1.5, 1 scale <.5, 1, .65> rotate x*-10 translate <-1, -.5, 0> texture {BodyTexture}}
    sphere {0, 1, 1 scale <.5, 1, .5> translate <1, -1.25, 0> texture {BodyTexture}}
    sphere {0, 1, 1 scale <.5, 1, .5> translate <-1, -1.25, 0> texture {BodyTexture}}
  }
  
  object {Foot rotate y*-15 translate <1, -2, 0> texture {pigment {granite scale .75 color_map {[0.0 Red] [1.0 OrangeRed]}} finish {ambient .8 diffuse .1 }} normal {granite scale .1 bump_size 10}}
  object {Foot rotate y*5 translate <-1, -2.25, 0> texture {pigment {granite scale .75 color_map {[0.0 Red] [1.0 OrangeRed]}} finish {ambient .8 diffuse .1 }} normal {granite scale .1 bump_size 10}}
  object {Wing translate y*-2.5 rotate y*-10 rotate x*-5 translate <1.2, 2.5, 0> }
  object {Wing translate y*-2.5 rotate y*-10 rotate x*-5 scale <-1, 1, 1> translate <-1.2, 2.5, 0> }
  object {Tail rotate x*-30 translate z*1}
  
  rotate y*30
  //rotate x*-45
}

//light_source {
  //<0,3,0>
  //White
  //looks_like {
    //object {Phoenix}
  //}
//}