#version unofficial MegaPov 0.7;

#include "colors.inc"

/*camera {
  location <0, 5, -15>
  look_at <0,5,0>
}
  
light_source { <0, 10, -100> White }
  
background {color White}*/

#macro MakeFeather(_length, _width, _symmetry, _rotate, _translate, _stem)
  #if (_stem = off)
    #declare _adjust = -1 * _length;
  #else
    #declare _adjust = 0;
  #end
  union { prism {
      cubic_spline
      0,
      .01,
      9,
      <(-1*_width) + (_symmetry*_width), .4*_length>,
      <0, .1*(_length + _adjust)>,
      <_width + (_symmetry*_width), .4*_length>,
      <_width + (_symmetry*_width), .8*_length>,
      <0, _length>,
      <(-1*_width) + (_symmetry*_width), .8*_length>,
      <(-1*_width) + (_symmetry*_width), .4*_length>,
      <0, .1*(_length + _adjust)>,
      <_width + (_symmetry*_width), .4*_length>
      rotate x*-90
      normal {
        gradient x
        translate -1*_width
        scale <2*_width, 1, 1>
        normal_map {
          [0.5 gradient y triangle_wave rotate -65 bump_size 1.2 scale _length/60]
          [1.0 gradient y triangle_wave rotate -30 bump_size 1.2 scale _length/60]
        }
        rotate _rotate
        translate _translate
      }
      /*normal {
        bump_map {
          png "Phoenix_bumpmap.png"
          once
          interpolate 4
          bump_size 5
        }
        translate <-.5, 0, -.01>
        scale <_length, _length, 1>
      }*/
      #if (_translate.x = 0)
        pigment {
          gradient y
          triangle_wave
          scale 3
          color_map {
            [0.0 Orange]
            [1.0 OrangeRed]
          }
        }      
      #else
        pigment {
          gradient y
          triangle_wave
          scale 3
          color_map {
            [0.0 Red]
            [1.0 Orange]
          }
        }
      #end
      finish {ambient .8 diffuse .1 specular 1}
      //pigment {color rgb _length/2}
    }
    
    sphere_sweep {
      linear_sphere_sweep,
      2,
      <0,0,0>, _width/10,
      <0, .95*_length, 0>, _width/100
      pigment {
        gradient y
        scale _length
        color_map {
          [0.0 Gray95]
          [0.25 Gray65]
          [1.0 Gray65]          
        }
      }
    }
    rotate _rotate
    translate _translate
  }
#end

//MakeFeather (3, 1, 0, 0, 0, off)

//grass
/*plane {
  z, 0
      pigment {
        image_map {
          tga "Phoenix_bumpmap.tga"
          once
          interpolate 2
          //bump_size 5
        }
        translate x*-.5
        scale 20
      }

}*/