#declare Outline = difference {
  cylinder { <0, 0, 0>, <0, 7, 0>, 1 scale <4, 1, 12> }
  plane { x, 0 }
}

#declare Wings = intersection {
  union {
    difference { // right wing
      cylinder { <-2, 0, 0>, <6, 0, 0>, 1 scale <1, 3, 12> translate <0, 0, -12.5> }
      cylinder { <-2, 0, 0>, <6, 0, 0>, 1 scale <1, 3, 11.5> translate <0, 0, -12.5> }
    }
    difference { // left wing
      cylinder { <-2, 0, 0>, <6, 0, 0>, 1 scale <1, 3, 12> translate <0, 0, 12.5> }
      cylinder { <-2, 0, 0>, <6, 0, 0>, 1 scale <1, 3, 11.5> translate <0, 0, 12.5> }
    }
  } 
  object { Outline }
}

#declare Bird = union {
  object { Wings }
  sphere {  // right eye
    <6.5, 0.55, -0.35>, 0.25 
    texture {
      pigment { color rgb <0, 0, 0> }
      finish { ambient 0.2 diffuse 0.8 phong 1 phong_size 100 }
    }
  }
  sphere {  // left eye
    <6.5, 0.55, 0.35>, 0.25
    texture {
      pigment { color rgb <0, 0, 0>}
      finish { ambient 0.2 diffuse 0.8 phong 1 phong_size 100 }
    }
  }
  blob {
    threshold 0.56
    sphere {  // body
      <0, 0, 0>, 1, 1
      scale <8, 2, 2.5>
    }
    sphere {  // tail
      <0, 0, 0>, 1, 1
      scale <1.5, 0.25, 2.5>
      rotate 15*z
      translate -4.5*x
    }
    sphere {  // head
      <0, 0, 0>, 1, 1
      scale <2, 1, 1>
      rotate -15*z
      translate <4.5, 0.5, 0>
    }
    cylinder {  // beak
      <0, 0, 0>, <2, 0, 0>, 1, 1
      scale <1, 0.375, 0.25>
      rotate <0, 0, -15>
      translate <4.5, 0.5, 0>
    }
    translate 1.5*x
  }
  texture {
    pigment {
      onion
      color_map {
        [0.75 rgb <1, 1, 1>]
        [0.8  rgb <0.3, 0.3, 0.3>]
      }
      scale 16
      translate -5*x
    }
    finish { ambient 0.3 diffuse 0.8 }
    normal { bumps 0.3 scale <1, 0.25, 0.25> }
  }
}
