//  Building Parts, Doors, Windows Etc.  for application on Buildings
//  mainpart.inc
//  August, 1998
//  Robert J Becraft
// 

// Object List:
//  Door1
//  Window1a  single verticle/single horizontal sash
//  Window1   triple verticle/horizontal sashes
//  Barrel
//  BarrelSmall
//  Box1
//  BoxStack
//  Chim1Base  
//    Chim1  - Base w/ square covers
//    Chim1a - Base w/ square covers and square cap
//    Chim1b - Base w/ fancy covers
//  Chim2Base
//    Chim2
//    Chim2a
//  Chim3Base


#declare Door1=union{
      box{<-.081,0,-.5><.081,2.5,.5> texture{T_Wood18 scale .05}}      // door
      box{<-.09,1.7,.4><.09,1.75,.42> texture{Bright_Bronze}}     // door pull
      box{<-.5,0,-.55><.5,.25,.55> texture{pigment{color Wheat}}} // stoop
      box{<-.1,0,-.6><.1,2.6,-.5> texture{pigment{color White}}}  // trim
      box{<-.1,0,.6><.1,2.6,.5> texture{pigment{color White}}}
      box{<-.1,2.5,-.6><.1,2.6,.6> texture{pigment{color White}}}
}

#declare Window1a=union{
      box{<-.1,.5,-.55><.1,2.05,-.5> texture{pigment{color White}}}
      box{<-.1,.5,.55><.1,2.05,.5> texture{pigment{color White}}}

      box{<-.1,2.,-.55><.1,2.05,.55> texture{pigment{color White}}}
      box{<-.1,.45,-.55><.1,.5,.55> texture{pigment{color White}}}

      box{<-.061,.5,-.025><.061,2,.025> texture{pigment{color White}}}    // center verticle
      box{<-.081,1.22,-.5><.081,1.27,.5> texture{pigment{color White}}} // center horizontal

      box{<-.01,.5,-.5><.01,2,.5> texture{pigment{color Black}}
         finish  { F_Glass2 }
         }   // glass
}

#declare Window1=union{
      object{Window1a}
      
      box{<-.051,0.5,-.265><.051,2,-.225> texture{pigment{color White}}}    // left verticle
      box{<-.051,0.5,.265><.051,2,.225> texture{pigment{color White}}}    // right verticle

      box{<-.051,1.6175,-.5><.051,1.6575,.5> texture{pigment{color White}}} // top horizontal
      box{<-.051,0.8425,-.5><.051,0.8825,.5> texture{pigment{color White}}} // bottom horizontal      
}      

#declare Window2a=union{
      box{<-.1,.5,-.30><.1,2.05,-.25> texture{pigment{color White}}}
      box{<-.1,.5,.30><.1,2.05,.25> texture{pigment{color White}}}

      box{<-.1,2.,-.30><.1,2.05,.30> texture{pigment{color White}}}
      box{<-.1,.45,-.30><.1,.5,.30> texture{pigment{color White}}}

      box{<-.061,.5,-.025><.061,2,.025> texture{pigment{color White}}}    // center verticle
      box{<-.081,1.22,-.3><.081,1.27,.3> texture{pigment{color White}}} // center horizontal

      box{<-.01,.5,-.3><.01,2,.3> texture{pigment{color Black}}
         finish  { F_Glass2 }
         }   // glass
}
#declare Window2=union{
      object{Window2a}

      box{<-.051,1.6175,-.3><.051,1.6575,.3> texture{pigment{color White}}} // top horizontal
      box{<-.051,0.8425,-.3><.051,0.8825,.3> texture{pigment{color White}}} // bottom horizontal      
}      


#declare Barrel=union{
   cylinder{<0,-.25,0><0,.25,0>.4 texture{pigment{color Tan}}}
   cone{<0,-.25,0>.4<0,-.5,0>.33 texture{pigment{color Tan}}}
   cone{<0,.25,0>.4<0,.5,0>.33 texture{pigment{color Tan}}}
   cylinder{<0,.47,0><0,.499,0>,.34 texture{pigment{color Brown}}}
   cylinder{<0,-.47,0><0,-.499,0>,.34 texture{pigment{color Brown}}}
   cylinder{<0,-.25,0><0,-.28,0>,.41 texture{pigment{color Brown}}}
   cylinder{<0,.25,0><0,.28,0>,.41 texture{pigment{color Brown}}}
}
#declare BarrelSmall=object{Barrel scale .5}
#declare Basket=difference{
   cone{<0,0,0>,.25 <0,.5,0>,.35 texture{pigment{color Wheat}}}
   cone{<0,.04,0>,.24 <0,.51,0>,.34 texture{pigment{color Wheat}}}
}
#declare Box1=union{
//   box{<-.5,0,-.25><.5,.25,.25> texture{pigment{color Tan}}}

   box{<-.48,.02,-.23><-.47,.23,.23> texture{T_Wood13}}
   box{<.48,.02,-.23><.47,.23,.23> texture{T_Wood13}}            

   #declare C1=-.25;
   #while (C1<=.21) 
     box{<-.5,0,C1><.5,.02,C1+.09> texture{T_Wood13 rotate<0,90,0> scale .5}}   
     box{<-.5,.23,C1><.5,.25,C1+.09> texture{T_Wood13 rotate<0,89,0> scale .5}}
     #declare C1=C1+.1;
   #end
   #declare C1=.03;
   #while (C1<=.18) 
     box{<-.5,C1,-.23><.5,C1+.09,-.251> texture{T_Wood13 rotate<0,-89,0> scale .5}}   
     box{<-.5,C1,.23><.5,C1+.09,.251> texture{T_Wood13 rotate<0,90,0> scale .5}}
     #declare C1=C1+.1;
   #end
         
   box{<-.4,0,-.27><-.35,.27,.27> texture{T_Wood13}}
   box{<.35,0,-.27><.4,.27,.27> texture{T_Wood13}}
}
#declare Box2=union{  // chicken crate-like
//   box{<-.5,0,-.25><.5,.25,.25> texture{pigment{color Tan}}}

   box{<-.48,.02,-.23><-.47,.23,.23> texture{T_Wood8}}
   box{<.48,.02,-.23><.47,.23,.23> texture{T_Wood8}}            

   #declare C1=-.25;
   #while (C1<=.21) 
     box{<-.5,0,C1><.5,.02,C1+.03> texture{T_Wood8 rotate<0,90,0> scale .5}}   
     box{<-.5,.23,C1><.5,.25,C1+.03> texture{T_Wood8 rotate<0,90,0> scale .5}}
     #declare C1=C1+.1;
   #end
   #declare C1=0;
   #while (C1<=.21) 
     box{<-.5,C1,-.23><.5,C1+.03,-.251> texture{T_Wood8 rotate<0,90,0> scale .5}}   
     box{<-.5,C1,.23><.5,C1+.03,.251> texture{T_Wood8 rotate<0,90,0> scale .5}}
     #declare C1=C1+.08;
   #end
         
   box{<-.4,0,-.27><-.35,.27,.27> texture{T_Wood8}}
   box{<.35,0,-.27><.4,.27,.27> texture{T_Wood8}}
}
#declare Wagon_Load1=union{
       #declare C1=-.9;
       #while (C1>=-4)
       
         #declare ROY=rand(RS)*20-10;
          object{Box1 rotate<0,ROY,0> translate<C1,.5,-.35>}
         #declare ROY=rand(RS)*20-10;          
          object{Box1 rotate<0,ROY,0> translate<C1,.8,-.35>}
         #declare ROY=rand(RS)*20-10;          
          object{Box1 rotate<0,ROY,0> translate<C1,1.1,-.35>}          
         #declare ROY=rand(RS)*20-10;          
          object{Box1 rotate<0,ROY,0> translate<C1,.5,.35>}
         #declare ROY=rand(RS)*20-10;          
          object{Box1 rotate<0,ROY,0> translate<C1,.8,.35>}          
         #declare ROY=rand(RS)*20-10;          
          object{Box1 rotate<0,ROY,0> translate<C1,1.1,.35>}          
         #declare ROY=rand(RS)*20-10;          
          object{Box2 rotate<0,90+ROY,0> translate<C1,1.37,0>}          
          
          #declare C1=C1-.95-rand(RS)*.25;
       #end
}
#declare Wagon_Load2=union{
       #declare C1=-.9;
       #while (C1>=-4)
 
         #declare ROY=rand(RS)*10-5;
          object{Box1 rotate<0,ROY,0> translate<C1,.5,-.35>}
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,.8,-.35>}
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,1.1,-.35>}  
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,1.4,-.35>}                   
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,.5,.35>}
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,.8,.35>}          
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,1.1,.35>}          
         #declare ROY=rand(RS)*10-5;          
          object{Box1 rotate<0,ROY,0> translate<C1,1.4,-.35>}           
         #declare ROY=rand(RS)*20-10;          
          object{Box2 rotate<0,90+ROY,0> translate<C1,1.67,0>}          
          
          #declare C1=C1-.95-rand(RS)*.25;
       #end
}
       
#declare BoxStack=union{
   object{Box1}
   object{Box1 rotate<0,10,0> translate<0,.27,0>}
   object{Box1 translate<0,0,-.3>}
   object{Box1 rotate<0,-5,0> translate<0,.54,0>}
}

#declare Chim1Base=union{
  box{<-.5,-3,-.25><.5,1.5,.25>}
  box{<-.53,1,-.28><.53,1.2,.28>}
  box{<-.53,1.3,-.28><.53,1.45,.28>}

  cylinder{<-.3,1.45,0><-.3,2.6,0> .13 texture{pigment{color Tan}}}
  cylinder{<.3,1.45,0><.3,2.6,0> .13 texture{pigment{color Tan}}}
}
#declare Chim1=union{
  object{Chim1Base}
  box{<-.431,1.5,-.2><-.1,2.2,.2> }
  box{<.1,1.5,-.2><.431,2.2,.2> }  
}    
#declare Chim1a=union{
  object{Chim1}

  box{<-.45,2.2,-.25><.45,2.4,.25>}
}
#declare Chim1Sect=union{
  box{<-.15,1.5,-.2><.15,2.2,.2> }
  box{<-.15,1.5,-.2><.15,2.2,.2> rotate<0,45,0>} 
  box{<-.15,1.5,-.2><.15,2.2,.2> rotate<0,-45,0>}
  box{<-.15,1.5,-.2><.15,2.2,.2> rotate<0,90,0>}
}  

#declare Chim1b=union{
  object{Chim1Base}
  
  object{Chim1Sect translate<-.2,0,0>}
  object{Chim1Sect translate<.2,0,0>}

  box{<-.45,2.2,-.25><.45,2.4,.25>}  
}

#declare Chim2Base=union{
  box{<-.75,-3,-.25><.75,1.5,.25>}
  box{<-.753,1,-.28><.753,1.2,.28>}
  box{<-.753,1.3,-.28><.753,1.45,.28>}
                         
  cylinder{<0,1.45,0><0,2.6,0> .13 texture{pigment{color Tan}}}                         
  cylinder{<-.52,1.45,0><-.52,2.6,0> .13 texture{pigment{color Tan}}}
  cylinder{<.52,1.45,0><.52,2.6,0> .13 texture{pigment{color Tan}}}
}
#declare Chim2=union{
  object{Chim2Base}
  box{<-.66,1.5,-.2><-.22,2.2,.2> }
  box{<.22,1.5,-.2><.66,2.2,.2> }  
  box{<-.22,1.5,-.17><.22,2.2,.17>}
}    
#declare Chim2a=union{
  object{Chim2}

  box{<-.67,2.2,-.25><.67,2.4,.25>}
}

#declare Chim3Base=union{
  box{<-.55,-3,-.25><.55,1.5,.25>}
  box{<-.56,1,-.28><.56,1.2,.28>}
  box{<-.56,1.3,-.28><.56,1.45,.28>}
                         
  cylinder{<-.3,1.45,0><-.3,2,0> .13 texture{pigment{color Tan}}}
  cylinder{<.3,1.45,0><.3,2,0> .13 texture{pigment{color Tan}}}
}

