#declare MetalTex=texture
 {
  pigment{P_Chrome2}
  finish{F_MetalA}
 }

#declare ChainTex=texture
 {
  pigment{P_Chrome2}
  finish{F_MetalA}
  normal{leopard 50 scale .004 turbulence .1}
 }

#declare StripeTex=texture
 {
  pigment
   {
    gradient <0,-1,1>
    color_map
     {
      [0.0 color Blue]
      [0.1 color Blue]
      [0.1 color Yellow]
      [0.2 color Yellow]
      [0.2 color Blue]
      [0.3 color Blue]
      [0.3 color Yellow]
      [0.4 color Yellow]
      [0.4 color Blue]
      [1.0 color Blue]
     }
    scale 2
    translate <5.45,0,0>
   }
  normal{bozo .3 scale<.025,.25,.025> turbulence .1}
 }

#declare ClothTex=texture
 {
  pigment{color Wheat}
  normal{bozo .03 scale<.025,.25,.025> turbulence .1}
 }

#declare Horsea=union
 {
  cone{<-.71,1.5,0>.45 <-.1,1.5,0> .36} // Rumpf
  cone{<-.1,1.5,0>,.36 <.71,1.5,0> .4}
  sphere{<-.71/.5,1.5,0> .45 scale<.5,1,1>}
  sphere{<0,0,0> .45 scale<1,.75,.9> translate<.61,1.57,0>}

  cone{<-.7,0,-.2>.051 <-.7,.75,-.2> .0610} //Beine  (Front legs)
  cone{<-.7,0,.2>.051 <-.7,.75,.2> .0610}
  cone{<-.7,.75,-.2>.061 <-.7,1.5,-.2> .20} // scale<1.2,1,.5>}
  cone{<-.7,.75,.2>.061 <-.7,1.5,.2> .20} // scale<1.2,1,.5>}
  sphere{<-.7,.15,-.2>.075 scale<1,1.3,1>}
  sphere{<-.7,.15,.2>.075 scale<1,1.3,1>}

  cone{<-.7,0,-.2>.08 <-.7,.08,-.2> .065 pigment{color Gray10}} //front hooves
  cone{<-.7,0,.2>.08 <-.7,.08,.2>.065 pigment{color Gray10}}
  cone{<.6,0,-.2>.08 <.6,.08,-.2> .065 pigment{color Gray10}} //back hooves
  cone{<.6,0,.2>.08 <.6,.08,.2>.065 pigment{color Gray10}}

  cone{<.6,0,-.2>.051 <.6,.25,-.2> .0610}  // Back Legs
  cone{<.6,0,.2>.051 <.6,.25,.2> .0610}
  sphere{<.6,.15,-.2>.075 scale<1,1.3,1>}
  sphere{<.6,.15,.2>.075 scale<1,1.3,1>}

  cone{<.6,.25,-.2>.051 <.8,.8,-.2> .0710}  // Back Legs
  cone{<.6,.25,.2>.051 <.8,.8,.2> .0710}
  sphere{<.8,.8,-.2>.071}
  sphere{<.8,.8,.2>.071}
  cone{<.8,.80,-.2>.071 <.65,1.,-.2> .10}  // Back Legs
  cone{<.8,.80,.2>.071 <.65,1.,.2> .10}
  sphere{<.65,1.,-.2>.1}
  sphere{<.65,1.,.2>.1}
  cone{<.65,1.,-.2>.1 <.75,1.5,-.15> .25}  // Back Legs
  cone{<.65,1.,.2>.1 <.75,1.5,.15> .25}


  cone{<.9,1.85,0> .03 <1.1,1.6,0> .05} // Tail (Schwanz)
  cone{<1.1,1.63,0>.05 <1.15,.9,0> .08}

  cone{<-.7,1.8,0>.2 <-1.1,2.4,0> .15 scale<1,1.2,1> translate<0,-.5,0>} //Neck (Hals)

//  cylinder{<-1.3,2.3,0> <-1.6,2.3,0> .25} //Kopf
//  cone{<-1.6,2.3,0> .25 <-1.8,2.3,0> 0}
//  cylinder{<-1.6,2.25/.7,0> <-1.85,2.25/.7,0> .2 scale<1,.7,1>}
//  sphere{<-1.85,2.25/.7,0> .2 scale<1,.7,1>}
  union
   {
     intersection{
       sphere{<0,0,0> .23}
       box{<0,-.3,-.3> <.3,.3,.3>}
     }
     difference{
       cone{<0,0,0> .23 <-.5,0,0> .1}
       sphere{<-.08,.1,-.17>,.043 scale <1.8,1,1> } //pigment{color Gray}}  // Eyesockets
       sphere{<-.08,.1,.17>,.043  scale <1.8,1,1> } //pigment{color Gray}}
     }
     sphere{<-.1,.1,-.16> .024  pigment{color Black}} // eyes
     sphere{<-.091,.1,-.16> .02435  pigment{color Wheat}}
     sphere{<-.1,.1,.16> .024 pigment{color Black}}
     sphere{<-.091,.1,.16> .0245 pigment{color Wheat}}

     difference
     {
       sphere{<-.5,0,0> .098}             // tip of nose
       box{<-.52,-.05,-.6> <-.6,-.02,.6>}  // mouth
       sphere{<-.575,.06,-.06> .035 }  //texture{pigment{color Black}}}        // nostrels
       sphere{<-.575,.06,.06> .035  }  //texture{pigment{color Black}}}
       cone{<-.585,.05,-.06>.025<-.43,.045,-.055>.015 texture{pigment{color DarkBrown}}}
       cone{<-.585,.05,.06>.025<-.43,.045,.055>.015 texture{pigment{color DarkBrown}}}
     }

    rotate<0,0,40>

    translate<-1.1,2.4,0>
   }
}

#declare Horse=union{
     object{Horsea}
     union{
       difference{   // Ears (Ohren)
         sphere{<.04,.0571,-.1> .04 rotate<-10,0,0> scale<1,5,1>}
         sphere{<.036,.0571,-.1> .039 rotate<-10,0,0> scale<1,5,1>}
       }
       difference{
         sphere{<.04,.0571,.1> .04 rotate<10,0,0> scale<1,5,1>}
         sphere{<.036,.0571,.1> .039 rotate<10,0,0> scale<1,5,1>}
       }
       translate<-1.15,2.4,0>
     }
}

#declare Horse1=object{Horse
  texture
   {
    pigment
     {
      bozo
      scale .5
      color_map
       {
        [0 color rgb<.7,.6,.4>]
        [.22 color rgb<.6,.5,.3>]
        [.25 color rgb<.5,.4,.2>]
        [.65 color rgb<.5,.4,.1>]
        [.68 color rgb<.6,.5,.3>]
        [1 color rgb<.7,.6,.4>]
       }
      translate<0,1.2,3>
     }
    normal
     {
      bozo .1
//      scale <.01,.03,.01>
      turbulence <1,50,1>
      octaves 9
      lambda 7
     }
    finish
     {
      brilliance .5
      diffuse .4
     }
   }
//  pigment{color Brown}
 }

#declare Horse2=object{Horse
  texture
   {
    pigment
     {
      bozo
      scale .5
      color_map
       {
        [0 color rgb<.9,.8,.6>]
        [.22 color rgb<.8,.7,.5>]
        [.25 color rgb<.7,.6,.4>]
        [.65 color rgb<.7,.6,.3>]
        [.68 color rgb<.8,.7,.5>]
        [1 color rgb<.9,.8,.6>]
       }
      translate<2,0,3>
     }
    normal
     {
      bozo .1
//      scale <.01,.03,.01>
      turbulence <1,50,1>
      octaves 9
      lambda 7
     }
    finish
     {
      brilliance .5
      diffuse .4
     }
   }
//  texture{pigment{color DarkBrown}}
}
#declare Horse3=object{Horse
  texture
   {
    pigment
     {
      bozo
      scale .4
      color_map
       {
        [0 color rgb<.4,.3,.1>]
        [.52 color rgb<.3,.2,0>]
        [.55 color rgb<.2,.1,0>]
        [.65 color rgb<.2,.1,0>]
        [.88 color rgb<.3,.2,0>]
        [1 color rgb<.4,.3,.1>]
       }
      translate<0,1.2,3>
     }
    normal
     {
      bozo .1
//      scale <.01,.03,.01>
      turbulence <1,50,1>
      octaves 9
      lambda 7
     }
    finish
     {
      brilliance .5
      diffuse .4
     }
   }
//  texture{pigment{color Wheat}}
}
#declare Horse4=object{Horse
  texture
   {
    pigment
     {
      bozo
      scale .5
      color_map
       {
        [0 color Gray50]
        [.22 color Gray60]
        [.25 color Gray60]
        [.65 color Gray50]
        [.68 color Gray60]
        [1 color Gray50]
       }
      translate<0,0,3>
     }
    normal
     {
      bozo .1
//      scale <.01,.03,.01>
      turbulence <1,50,1>
      octaves 9
      lambda 7
     }
    finish
     {
      brilliance .5
      diffuse .4
     }
   }
  //texture{pigment{color Gray30}}
}

#declare Head=union
 {
  difference
   {
    union
     {
      sphere{<0,.2,0> .8}
      sphere{<0,-.35,0> .65 scale<1,1,.8>}
//      box{<0,0,0> <-.4,-.4,-.4> rotate<0,-45,0> rotate<10,0,0> translate<0,0,-.25>}
      cone{<0,.3,-.1>0 <0,-.4,-.15>.25 scale<1,1,.4> translate<0,0,-.65>}
      cylinder{<0,0,.2> <0,-1.4,.25> .35}
     }
    sphere{<0,0,0> .4 scale<1,.15,1> translate<0,-.55,-.4> pigment{color Red} scale<1,1,.8>}
    sphere{<.3,0,-.55> .24 }
    sphere{<-.3,0,-.55> .24 }
   }
  sphere{<.3,0,-.55> .152 pigment{color Black}}
  sphere{<-.3,0,-.55> .152 pigment{color Black}}
  pigment{color NewTan}
  scale .3/2
  translate<0,1.8-.15,.02>
 }

#declare Hair=difference
 {
  sphere{<0,.2,0> .9}
  sphere{<0,-.2,-.2> .9}
  normal{bozo .1 scale<.035,.35,.035> turbulence .05}
  normal{bozo .15 scale<.35,.35,.35> turbulence .01}
//  pigment{color rgb<.55,.35,.15>}
  scale .3/2
  translate<0,1.8-.15,.02>
 }

#declare LongHair=union
 {
  difference
   {
    sphere{<0,.2,0> .9}
    sphere{<0,-.2,-.2> .9}
   }
  difference
   {
    cylinder{<0,.2,0> <0,-1,0> .9}
    cylinder{<0,.21,-.2> <0,-1.1,-.2> .9}
   }
  normal{bozo .1 scale<.035,.35,.035> turbulence .05}
  normal{bozo .15 scale<.35,.35,.35> turbulence .01}
//  pigment{color rgb<.55,.35,.15>}
  scale .3/2
  translate<0,1.8-.15,.02>
 }

#declare Beard=union
 {
  cone{<0,0,0> .08 <0,-.3,0> .01}
  normal{bozo .1 scale<.035,.35,.035> turbulence .05}
  normal{bozo .15 scale<.35,.35,.35> turbulence .01}
  pigment{color rgb<.55,.35,.15>}
  scale<1,1,.7>
  rotate<25,0,0>
  translate<0,1.54,-.0>
 }

#declare Helmet1=union{
  intersection{
    difference{
      union{
        sphere{<0,.12,0> .15}
        cylinder{<0,.14,0> <0,.15,0> .17}
       }
      sphere{<0,.12,0> .14}
     }
    box{<-.2,.3,-.2> <.2,.14,.2>}
  }
  translate<0,1.55,.02>
  texture{MetalTex}
 }
#declare HelmetScale=difference{
    cone{<0,0,0>.16 <0,.02,0> .15}
    cone{<0,-.1,0>.158 <0,.021,0> .148}
    box{<-.17,-.1,-.040><.17,.021,-.17>}
}

#declare Helmet4=union{
  intersection{
    difference{
      union{
        sphere{<0,.12,0> .15}
        cylinder{<0,.14,0> <0,.15,0> .16}
       }
      sphere{<0,.12,0> .14}
     }
    box{<-.2,.3,-.2> <.2,.14,.2>}
  }

  object{HelmetScale translate<0,.12,0>}
  object{HelmetScale scale 1.07 translate<0,.095,0>}
  object{HelmetScale scale 1.1 translate<0,.065,0>}
  object{HelmetScale scale 1.13 translate<0,.035,0>}
  object{HelmetScale scale 1.16 translate<0,.015,.02>}

  translate<0,1.55,.02>
  texture{MetalTex}
 }


#declare WizHat=union{
  cone{<0,.41,0> 0 <0,0,0> .16}
  cylinder{<0,0,0> <0,.015,0> .26}
  translate<0,1.69,.02>
 }

#declare Helmet2=union{
  object{Helmet1}
  cone{<.08,1.76,.02> .03 <.15,1.9,.02> .001}
  cone{<-.08,1.76,.02> .03 <-.15,1.9,.02> .001}
  texture{MetalTex}
 }

#declare Helmet3=union
 {
  object{Helmet1}
  cylinder{<0,1.7,.02> <0,1.84,.02> .03}
  cone
   {
    <0,0,0> .015 <0,.16,0> .05
    scale<1,1,2>
    texture{
      pigment{
        gradient y
        color_map
         {
          [0 color rgb<1,1,0>]
          [.15 color rgb<.9,.1,.2>]
         }
        turbulence<.05,-.1,.05>
       }
      normal{bozo .3 scale<.01,.1,.01>}
     }
    translate<0,1.84,.02>
   }
  texture{MetalTex}
 }

#declare Helmet5=union{
  object{Helmet4}
  cylinder{<0,1.7,.02> <0,1.84,.02> .03}
  cone
   {
    <0,0,0> .015 <0,.16,0> .05
    scale<1,1,2>
    texture{
      pigment{
        gradient y
        color_map
         {
          [0 color rgb<1,1,0>]
          [.15 color rgb<.9,.1,.2>]
         }
        turbulence<.05,-.1,.05>
       }
      normal{bozo .3 scale<.01,.1,.01>}
     }
    translate<0,1.84,.02>
   }
  texture{MetalTex}
}

#declare Body=union
 {
  sphere{<0,0,0> .38 scale<1,.05,1>}
  sphere{<0,0,0> .38 scale<1,.25,1> translate<0,.7,0>}
  cone{<0,-.04,0>.38 <0,.7,0> .35}
  sphere{<0,0,0> .45 scale<1.23,.21,.6> translate<0,.7,0>}
  scale<.6,1,.4>
  translate<0,.7,.05>
 }

#declare BodyShe=union
   {
    object{Body}
    intersection
     {
      union
       {
        sphere{<0,0,0> 1.12 scale<.19,.12,.12> translate<.03,1.3,.005>}
        sphere{<0,0,0> 1.12 scale<.19,.12,.12> translate<-.03,1.3,.005>}
       }
      box{<-.17,1.3-.17,-.25> <.17,1.3+.17,.1>}
     }
    texture{ClothTex pigment{color rgb<.1,.4,.0>}}
   }

#declare Legs=union
 {
  cylinder{<-.11,0.05,.05> <-.11,1.2,.05> .09}
  cylinder{<.11,0.05,.05> <.11,1.2,.05> .09}
  sphere{<-.11,.05,-.01> .08 scale<1,.6,1.6> pigment{color DarkBrown}}
  sphere{<.11,.05,-.01> .08 scale<1,.6,1.6> pigment{color DarkBrown}}
 }

#declare LegsL=union
 {
  cylinder{<-.11,.85,.05> <-.11,.85,-.5> .085}
  cylinder{<.11,.85,.05> <.11,.85,-.5> .085}
  sphere{<-.11,.85,-.5> .086}
  sphere{<.11,.85,-.5> .086}
  cylinder{<-.11,.85,-.5> <-.11,.35,-.5> .085}
  cylinder{<.11,.85,-.5> <.11,.35,-.5> .085}
  sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<0,5,0> translate<-.11,.32,-.53> pigment{color DarkBrown}}
  sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<0,-5,0> translate<.11,.32,-.53> pigment{color DarkBrown}}
  translate<0,-.03,0>
 }

#declare Arms=union
 {
//  sphere{<0,0,0> 1 scale<.13,.08,.06> translate<-.24,1.4,.05>}
//  sphere{<0,0,0> 1 scale<.13,.08,.06> translate<.24,1.4,.05>}
  cone{<-.26,1.4,.058> .065 <-.26,1.1,.16> .056}
  sphere{<-.26,1.1,.16> .056}
  cone{<-.26,1.1,.16> .056 <-.26,.77,.06> .05}
//  cylinder{<-.26,1.4,.06> <-.26,.77,.05> .065}
  sphere{<-.26,.75,.05> .07 pigment{color NewTan}}
  
  cone{<.26,1.4,.058> .065 <.26,1.1,.16> .056}
  sphere{<.26,1.1,.16> .056}
  cone{<.26,1.1,.16> .056 <.26,.77,.06> .05}
//  cylinder{<.26,1.4,.06> <.26,.77,.05> .065}

  sphere{<.26,.75,.05> .07 pigment{color NewTan}}
 }
 
#declare ArmsWave=union
 {
//  sphere{<0,0,0> 1 scale<.13,.08,.06> translate<-.24,1.4,.05>}
//  sphere{<0,0,0> 1 scale<.13,.08,.06> translate<.24,1.4,.05>}
  cone{<-.26,1.4,.058> .065 <-.26,1.1,.16> .056}
  sphere{<-.26,1.1,.16> .056}
  cone{<-.26,1.1,.16> .056 <-.26,.77,.06> .05}
//  cylinder{<-.26,1.4,.06> <-.26,.77,.05> .065}
  sphere{<-.26,.75,.05> .07 pigment{color NewTan}}
  
  union{  // rotate arm to wave 
    sphere{<.26,1.4,.058> .07}
    cone{<.26,1.4,.058> .065 <.26,1.1,.16> .056}
    sphere{<.26,1.1,.16> .056}
    cone{<.26,1.1,.16> .056 <.26,.77,.06> .05}
//  cylinder{<.26,1.4,.06> <.26,.77,.05> .065}
    sphere{<.26,.75,.05> .07 pigment{color NewTan}}
   translate<-.26,-1.4,0>
   rotate<0,-90,160>
   translate<.19,1.4,0>
  }
 }
  

#declare ArmsL=union
 {
  cylinder{<-.26,1.4,.06> <-.26,1.05,.05> .065}
  cylinder{<.26,1.4,.06> <.26,1.05,.05> .065}
  sphere{<-.26,1.05,.06> .066}
  sphere{<.26,1.05,.06> .066}
  cylinder{<-.26,1.05,.06> <-.26,1.02,-.4> .065}
  cylinder{<.26,1.05,.06> <.26,1.02,-.4> .065}
  sphere{<-.26,1.02,-.42> .07 pigment{color NewTan}}
  sphere{<.26,1.02,-.42> .07 pigment{color NewTan}}
 }

//------------------------------------
#declare SolStand=union
 {
  object{Legs texture{ChainTex}}
  object{Body texture{StripeTex}}
  object{Arms texture{ChainTex}}
  object{Helmet1}
  object{Head}
  object{Hair}
 }
//------------------------------------

#declare Shield2=union
 {
  intersection
   {
    union
     {
      intersection
       {
        cylinder{<0,0,-.3> <.02,0,-.3> 1}
        box{<-.003,0,0> <.021,-1.1,1.1>}
       }
      intersection
       {
        cylinder{<0,0,.3> <.02,0,.3> 1}
        box{<-.003,0,0> <.021,-1.1,-1.1>}
       }
      scale<1,1.4,.6>
      pigment
       {
        gradient <0,-1,1>
        color_map
         {
          [0.0 color Blue]
          [0.1 color Blue]
          [0.1 color Yellow]
          [0.2 color Yellow]
          [0.2 color Blue]
          [0.3 color Blue]
          [0.3 color Yellow]
          [0.4 color Yellow]
          [0.4 color Blue]
          [1.0 color Blue]
         }
        scale 2.5
        translate <0,1.65,-1>
       }
     }
    box{<0.0001,-1.5,-.7> <.1,.01,.7> pigment{color Brown}}
   }
  difference
   {
    cylinder{<0,0,0> <0,1,0> 1}
    cylinder{<0,-.1,0> <0,1.1,0> .9}
    pigment{color Brown}
    scale<.07,.025,.07>
    translate<-.07,-.3+.05,.156>
   }
  difference
   {
    cylinder{<0,0,0> <0,0,1> 1}
    cylinder{<0.1,-.3,-.01> <0.1,-.3,1.1> .8}
    pigment{color Brown}
    scale<.05,.07,.03>
    translate<-.07+.033,-1.5+1.05+.008,-.33>
   }
  translate<.33,1.5,-.1>
 }

#declare Shield=union
 {
  intersection
   {
    sphere
     {
      <0,0,0> 1
      scale<.08,.6,.4>
      pigment
       {
        gradient <0,-1,1>
        color_map
         {
          [0.0 color Blue]
          [0.1 color Blue]
          [0.1 color Yellow]
          [0.2 color Yellow]
          [0.2 color Blue]
          [0.3 color Blue]
          [0.3 color Yellow]
          [0.4 color Yellow]
          [0.4 color Blue]
          [1.0 color Blue]
         }
        scale 3
        translate <0,2.75,-1>
       }
     }
    box{<0,-1,-1> <1,1,1> pigment{color Brown} scale<.08,.6,.4>}
   }
  intersection
   {
    torus{.09, .015}
    box{<-.1,-.1,-.1> <0,.1,.1>}
    pigment{color Brown}
    translate<0,-.02,0>
   }
  translate<.33,.75,.05>
 }

#declare Sword=union
 {
  union
   {
    box
     {
      <-1,-4,-1> <1,1,1>
     }
    intersection
     {
      box
       {
        <-1,-1,-1> <1,1,1>
        rotate<0,45,0>
        rotate<45,0,0>
        rotate<0,-45,0>
        translate<0,1,0>
       }
      box{<-1,-1,-1> <1,3,1>}
     }
    rotate<0,45,0>
    translate<0,4,0>
    scale<.07,.5,.011>
    scale .35
   }
  cylinder{<-.12,0,0> <.12,0,0> .02}
  sphere{<-.12,0,0> .03}
  sphere{<.12,0,0> .03}
  cylinder{<0,0,0> <0,-.2,0> .03 pigment{color Red}}
  sphere{<0,-.2,0> .04}
  scale .8
  texture{MetalTex}
 }


//------------------------------------
#declare SolSword=union
 {
  object{Legs texture{ChainTex}}
  object{Body texture{StripeTex}}
  object{Helmet1}
  object{Head}
  object{Hair}
  object{Shield2}
  object{Sword translate<-.415,1.7,-.55>}
  cylinder{<0,0,0> <0,1.4-.77,.01> .065 texture{ChainTex} rotate<-70,15,0> translate<-.26,1.4,.06>}
  sphere{<0,1.4-.77+.02,.01> .07 pigment{color NewTan} rotate<-70,15,0> translate<-.26,1.4,.06>}
  cylinder{<.26,1.4,.06> <.26,1.05,.05> .065}
  sphere{<.26,1.05,.06> .066}
  cylinder{<.26,1.05,.06> <.26,1.02,-.4> .065}
  sphere{<.26,1.02,-.42> .07 pigment{color NewTan}}
  texture{ChainTex}
 }
//------------------------------------

#declare Spear=union
 {
  cylinder{<0,0,0> <0,2.2,0> .015 pigment{color Brown}}
  cone{<0,2.2,0> .022 <0,2.4,0> 0 texture{MetalTex}}
 }


//------------------------------------
#declare SolSpear=union
 {
  object{Legs texture{ChainTex}}
  object{Body texture{StripeTex}}
  object{Helmet1}
  object{Head}
  object{Hair}
  object{Shield2}
  object{Spear translate<-.26,0,-.55>}
  cylinder{<0,0,0> <0,1.4-.77,.01> .065 texture{ChainTex} rotate<-90,0,0> translate<-.26,1.4,.06>}
  sphere{<0,1.4-.77+.02,.01> .07 pigment{color NewTan} rotate<-90,0,0> translate<-.26,1.4,.06>}
  cylinder{<.26,1.4,.06> <.26,1.05,.05> .065}
  sphere{<.26,1.05,.06> .066}
  cylinder{<.26,1.05,.06> <.26,1.02,-.4> .065}
  sphere{<.26,1.02,-.42> .07 pigment{color NewTan}}
  texture{ChainTex}
 }
//------------------------------------

#macro MakeMan (CLegs,CBody,CHead,CHair,CBeard,CArms,TunicColor,PantsColor)
  #switch(CLegs)
    #case(1)   object{Legs texture{ClothTex pigment{PantsColor}}} #break
    #case(2)   object{LegsL texture{ClothTex pigment{PantsColor}}} #break
    #else
     #display "No legs of that type"
  #end
  #switch(CBody)
    #case(1)   object{Body texture{ClothTex pigment{TunicColor}}} #break
    #else
     #display "No body of that type"
  #end
  #switch(CHead)
    #case(1)   object{Head} #break
    #else
     #display "No Head of that type"
  #end
  #switch(CHair)
    #case(1)   object{Hair pigment{color Brown}} #break  
    #case(2)   object{Hair pigment{color Tan}} #break    
    #case(3)   object{Hair pigment{color Gray10}} #break    
    #case(4)   object{Hair pigment{color Gray80}} #break    
    #case(5)   object{Hair pigment{color DarkBrown}} #break    
    #else
     #display "No Hair of that type"
  #end        
  #switch(CBeard)
    #case(1)    #break
    #case(2)   object{Beard} #break
    #else
     #display "No Beard of that type"
  #end      
  #switch(CArms)
    #case(1)    object{Arms texture{ClothTex pigment{TunicColor}}}   #break
    #case(2)    object{ArmsWave texture{ClothTex pigment{TunicColor}}} #break
    #else
     #display "No Arms of that type"
  #end
#end // macro MakeMan
            
//------------------------------------
#declare ManNorm=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color rgb<.1,.4,.0>}}}
  object{Head}
  object{Hair}
  object{Arms texture{ClothTex pigment{color rgb<.1,.4,.0>}}}
 }

#declare ManNorm1=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color Wheat}}}
  object{Head}
  object{Hair}
  object{Beard}
  object{Arms texture{ClothTex pigment{color Wheat}}}
 }

#declare ManNorm2=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color Brown}}}
  object{Head}
  object{Hair}
  object{Arms texture{ClothTex pigment{color Brown}}}
 }

#declare ManNorm3=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color ForestGreen}}}
  object{Head}
  object{Hair}
  object{Beard}
  object{Arms texture{ClothTex pigment{color ForestGreen}}}
 }

#declare ManNorm4=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color Yellow}}}
  object{Head}
  object{Hair}
  object{Arms texture{ClothTex pigment{color Yellow}}}
 }                                         
//-----------------------------------------

#declare ManNormWave=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color rgb<.1,.4,.0>}}}
  object{Head}
  object{Hair}
  object{ArmsWave texture{ClothTex pigment{color rgb<.1,.4,.0>}}}
 }

#declare ManNorm1Wave=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color Wheat}}}
  object{Head}
  object{Hair}
  object{Beard}
  object{ArmsWave texture{ClothTex pigment{color Wheat}}}
 }

#declare ManNorm2Wave=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color Brown}}}
  object{Head}
  object{Hair}
  object{ArmsWave texture{ClothTex pigment{color Brown}}}
 }

#declare ManNorm3Wave=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color ForestGreen}}}
  object{Head}
  object{Hair}
  object{Beard}
  object{ArmsWave texture{ClothTex pigment{color ForestGreen}}}
 }

#declare ManNorm4Wave=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  object{Body texture{ClothTex pigment{color Yellow}}}
  object{Head}
  object{Hair}
  object{ArmsWave texture{ClothTex pigment{color Yellow}}}
 }
//-----------------------------------------
#declare WomanNorm=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  cone{<0,.95,.05/.4> .35 <0,.1,.05/.4> .50 scale<.6,1,.4> texture{ClothTex pigment{color rgb<.7,.9,.9>}}}
  object{BodyShe}
  object{Head}
  object{LongHair}
  object{Arms texture{ClothTex pigment{color rgb<.1,.4,.0>}}}
 }

#declare WomanNorm1=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  cone{<0,.95,.05/.4> .35 <0,.1,.05/.4> .50 scale<.6,1,.4> texture{ClothTex pigment{color Wheat}}}
  object{BodyShe texture{pigment{color Wheat}}}
  object{Head}
  object{LongHair}
  object{Arms texture{ClothTex pigment{color Wheat}}}
 }

#declare WomanNorm2=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  cone{<0,.95,.05/.4> .35 <0,.1,.05/.4> .50 scale<.6,1,.4> texture{ClothTex pigment{color Yellow}}}
  object{BodyShe texture{pigment{color Yellow}}}
  object{Head}
  object{LongHair}
  object{Arms texture{ClothTex pigment{color Yellow}}}
 }

#declare WomanNorm3=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  cone{<0,.95,.05/.4> .35 <0,.1,.05/.4> .50 scale<.6,1,.4> texture{ClothTex pigment{color Blue}}}
  object{BodyShe texture{ pigment{color Blue}}}
  object{Head}
  object{LongHair}
  object{Arms texture{ClothTex pigment{color Blue}}}
 }

#declare WomanNorm4=union
 {
  object{Legs texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
  cone{<0,.95,.05/.4> .35 <0,.1,.05/.4> .50 scale<.6,1,.4> texture{ClothTex pigment{color Tan}}}
  object{BodyShe texture{pigment{color Tan}}}
  object{Head}
  object{LongHair}
  object{Arms texture{ClothTex pigment{color Tan}}}
 }
//------------------------------------

#declare Wizard=union
 {
  object{Legs}
  cone{<0,.95,.05/.4> .35 <0,.1,.05/.4> .50 scale<.6,1,.4>}
  object{Body}
  union
   {
    object{Head}
    object{Hair}
    object{Beard}
    object{WizHat pigment{color rgb<.1,.1,.7>}}
    translate<0,0,-.02>
   }
  cylinder{<.26,1.4,.06> <.26,.77,.05> .065}
  sphere{<.26,.75,.05> .07 pigment{color NewTan}}
  cylinder{<0,0,0> <0,.45,.01> .065 rotate<0,0,90> translate<-.26,1.4,.06>}
  sphere{<0,.47,.01> .07 pigment{color NewTan}rotate<0,0,90> translate<-.26,1.4,.06>}

  cylinder{<-.47-.26,0,.04> <-.47-.26,2.2,.04> .015 pigment{color Brown}}
  sphere{<-.47-.26,2.2,.04> .07 texture{finish{F_MetalB} pigment{color rgb<1,.3,.7>}}}
  sphere
   {
    <-.47-.26,2.2,.04> .2
    texture
     {
      pigment
       {
        crackle
        scale .16
        turbulence .25
        color_map
         {
          [0 color rgbf<1,1,0,.5>]
          [0.04 color rgbf<.7,0,.5,.5>]
          [0.2 color rgbf<1,1,1,1>]
          [1 color rgbf<1,1,1,1>]
         }
        translate<0,-.06,0>
       }
      finish{ambient 1}
     }
   }
  texture{ClothTex pigment{color rgb<.1,.1,.7>}}
 }



#declare Saddle=difference{
   union{
     cylinder{<0,0,-.40><0,0,.3>,.4 texture{pigment{color DarkBrown}}}
     cylinder{<0,.30,0><0,.2,0>,.4 rotate<-50,0,0> translate<0,.1,.34> texture{pigment{color DarkBrown}}}
     cylinder{<-.4,0,0><.4,0,0>,.4 texture{pigment{color DarkBrown}}}
     cone{<0,.20,-.25>.04<0,.45,-.45>.06 texture{pigment{color DarkBrown}}}
     sphere{<0,.45,-.45>,.06 texture{pigment{color DarkBrown}}}
   }
   cylinder{<0,0,-.41><0,0,.41>,.37 texture{pigment{color DarkBrown}}}
   box{<-.37,-.42,-.41><.37,0,.41> texture{pigment{color DarkBrown}}}
}

#declare SolRider=union
 {
//  object{Horse1 rotate<0,-90,0>}
  union
   {
    object{Helmet5}
    object{Head}
 //   object{Beard}
    object{Hair}
    object{Body texture{StripeTex}}
    object{ArmsL texture{ChainTex}}
    union
     {
      cylinder{<-.06,.85,.05> <-.45,.7,-.25> .085}
      cylinder{<.06,.85,.05> <.45,.7,-.25> .085}
      sphere{<-.45,.7,-.25> .086}
      sphere{<.45,.7,-.25> .086}
      cylinder{<-.45,.7,-.25> <-.5,.25,-.15> .085}
      cylinder{<.45,.7,-.25> <.5,.25,-.15> .085}
      sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<-15,15,0> translate<-.5,.22,-.15> pigment{color DarkBrown}}
      sphere{<0,0,0> .08 scale<1,.6,1.6> rotate<-15,-15,0> translate<.5,.22,-.15> pigment{color DarkBrown}}
      translate<0,-.03,0>
      texture{ChainTex}
     }
    pigment{color DarkBrown}
    translate<0,1.2,0>
   }
  object{Saddle translate<0,1.55,0>}
  cylinder{<-.16,2.22,-.42> <-.16,2.5,-1.2> .007}  // reins
  cylinder{<.16,2.22,-.42> <.16,2.5,-1.2> .007}
  pigment{color Gray30}
 }


//------------------------------------
#declare SolRider1=union{
    object{SolRider}
    object{Horse1 rotate<0,-90,0>}
}
#declare SolRider2=union{
    object{SolRider}
    object{Beard translate<0,1.2,0>}
    object{Horse2 rotate<0,-90,0>}
}
#declare SolRider3=union{
    object{SolRider}
    object{Horse3 rotate<0,-90,0>}
}
#declare SolRider4=union{
    object{SolRider}
    object{Horse4 rotate<0,-90,0>}
}

#declare SolBlock=union
 {
  #declare SR=seed(125422);
  #declare X=-3;
  #while (X<=3)
    #declare Y=-5;
    #while (Y<5)
      object
       {
        SolSword
        rotate<0,rand(SR)*5,0>
        scale<1-rand(SR)/15,1,1-rand(SR)/15>
        translate<X*1.2+rand(SR)/20,0,Y+rand(SR)/20>
       }
      #declare Y=Y+1;
    #end
    #declare X=X+1;
  #end
 }

#declare SolRideBlock=union
 {
  #declare SR=seed(1252);
  #declare X=-6;
  #while (X<=6)
    #declare Y=-6;
    #while (Y<6)
      #declare RX=rand(SR)*.4-.2;
      #declare RZ=rand(SR)*.5-.25;
      object
       {
        #declare S1=int(rand(SR)*4+1);
        #switch (S1)
          #case (1)
            SolRider1
          #break  
          #case (2)
            SolRider2
          #break
          #case (3)
            SolRider3
          #break
          #case (4)
            SolRider4
          #break
        #end
        rotate<0,rand(SR)*5,0>
        scale<1-rand(SR)/15,1,1-rand(SR)/15>
        translate<X*1.2+rand(SR)/20+RX,0,Y+rand(SR)/20+RZ>
       }
      #declare Y=Y+2.8;
    #end
    #declare X=X+1.45;
  #end
 }


#declare Dummy=union
 {
  cone{<0,0,0> .45 <0,.5,0> .23}
  cylinder{<0,.5,0> <0,1.6,0> .23}
  cone{<0,1.6,0> .1 <0,1.8,0> .15}
  cylinder{<0,1.8,0> <0,1.81,0> .23}
  cone{<0,1.8,0> .15 <0,1.9,0> .01}
  cylinder{<-.9,1.5,0> <.9,1.5,0> .06}
  cylinder{<.9,1.5,0> <.95,1.5,0> .4}
  cylinder{<-.9,1.5,0> <-.9,2.3,0> .02}
  texture{T_Wood35 scale .8}
 }

#declare SolTraining=union
 {
  object{Dummy}
  object{SolSword rotate<0,180,0> translate<0,0,-1.1>}
 }

//#declare WheelRim=difference{
//   cylinder{<0,0,.05><0,0,-.15>1.05}
//   cylinder{<0,0,.1><0,0,-.2> 1.03}
//   texture{pigment{color Gray50}}
//}

//#declare Wheel=union{
//  difference
//   {
//    cylinder{<0,0,0> <0,0,-.1> 1.03}
//    cylinder{<0,0,.01> <0,0,-.11> .95}
//   }
//  cylinder{<0,0,-.1> <0,0,0> .22}
//  cylinder{<0,0,-.11> <0,0,.2> .08}
//  #declare W=0;
//  #while (W<180)
//    cylinder{<-.97,0,-.05> <.97,0,-.05> .04 texture{T_Wood17 rotate<90,0,90> scale .6 } rotate<0,0,W>}
//    #declare W=W+20;
//  #end
//  object{WheelRim}
//  texture{T_Wood17 scale .8}
//}

#declare WagonDriver=union{
    object{LegsL texture{ClothTex pigment{color rgb<.6,.3,.2>}}}
    object{Body texture{ClothTex pigment{color rgb<.1,.4,.0>}}
           normal{granite .5 scale<1,1,1> turbulence .75}
          }
    object{Head}
    object{Hair}
    object{ArmsL texture{ClothTex pigment{color rgb<.1,.4,.0>}}
           normal{granite .5 scale<1,1,1> turbulence .75}
           }
}

#declare WagonDriver2=union{
    object{LegsL texture{ClothTex pigment{color DarkBrown}}} //rgb<.6,.3,.2>}}}
    object{Body texture{ClothTex pigment{color Wheat}}
           normal{granite .5 scale<1,1,1> turbulence .75}    
          }  //rgb<.1,.4,.0>}}}
    object{Head}
    object{Hair}
    object{ArmsL texture{ClothTex pigment{color Wheat}}
           normal{granite .5 scale<1,1,1> turbulence .75}    
          } //rgb<.1,.4,.0>}}}
}

#declare WagonDriver3=union{                                               
    object{LegsL texture{ClothTex pigment{color DarkBrown}}} //rgb<.6,.3,.2>}}}
    object{Body texture{ClothTex pigment{color Blue}}}  //rgb<.1,.4,.0>}}}
    object{Head}
    object{Hair}
    object{ArmsL texture{ClothTex pigment{color Blue}}} //rgb<.1,.4,.0>}}}
}
#declare WagonDriver4=union{
    object{LegsL texture{ClothTex pigment{color DarkBrown}}} //rgb<.6,.3,.2>}}}
    object{Body texture{ClothTex pigment{color Gray10}}}  //rgb<.1,.4,.0>}}}
    object{Head}
    object{Hair}
    object{ArmsL texture{ClothTex pigment{color Gray10}}} //rgb<.1,.4,.0>}}}
}
//#declare Wagon3=union
// {
//  object{Horse4 rotate<0,-90,0> translate<-.7,0,-2>}
//  object{Horse2 rotate<0,-90,0> translate<.7,0,-2>}
//  box{<-1,1,0> <1,2,5>}
//  intersection
//   {
//    cylinder{<0,2,.5> <0,2,4.999> 1}
//    box{<-1,1.9,.45> <1,3.51,5>}
//    texture{normal{bozo .13 scale<.025,.25,.025> turbulence .1} pigment{color rgb<.8,.8,.7>} scale 3}
//   }
//  object{Wheel rotate<0,90,0> translate<-1.05,1,1>}
//  object{Wheel rotate<0,90,0> translate<-1.05,1,4>}
//  object{Wheel rotate<0,-90,0> translate<1.05,1,1>}
//  object{Wheel rotate<0,-90,0> translate<1.05,1,4>}
//  cylinder{<0,1,0.1> <0,2,-2.7> .1}
//  box{<-1,2.2,-2.8> <1,1.9,-2.7>}
//  intersection
//   {
//    cylinder{<-1,1.7,-2.8> <-1,1.7,-2.7> .5}
//    box{<-1,1.75,-2.81> <-1.6,2.2,-2.699>}
//   }
//  intersection
//   {
//    cylinder{<1,1.7,-2.8> <1,1.7,-2.7> .5}
//    box{<1,1.75,-2.81> <1.6,2.2,-2.699>}
//   }
//  cylinder{<-.26,2.32,-.22> <-1,2.2,-2.8> .01 pigment{color Brown}}
//  cylinder{<.26,2.32,-.22> <1,2.2,-2.8> .01 pigment{color Brown}}
//  object{WagonDriver2 translate<0,1.3,.2>}
//  texture{T_Wood17 scale .8}
// }
