//   WOWGeorg.POV
//   August, 2001
//   Robert J Becraft
//
 global_settings {
//                  radiosity{
//                            brightness 3.6      // 3.3 default
//                            count 120            // 100 default 
//                            distance_maximum 30 //0 default
//                            error_bound .34      // .4 default
//                            gray_threshold .6   // .5 default
//                            low_error_factor .8 // .8 default
//                            minimum_reuse .015  // .015 default
//                            nearest_count 6     // 6 default
//                            recursion_limit 1   // 1 default 
//                           }
                  max_trace_level 9          // default POV setting is 5
//                max_intersections 256      // default POV setting is 64... istack_overflows not= 0 increase
                                  }

#include "kolors.inc"    // The include files contain
#include "textures.inc"
#include "glass.inc"
#include "finish.inc"
#include "stones1.inc"     
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"     

#include "../med/brick.inc"
#include "castletext.inc"

#declare DrawBridgeAngle=-9;  // closed=0, open any negative #

//#declare SkyOff=off; // uncomment to turn off sky (daytime)  
#declare nosky=on;  // uncomment to turn off sky (Night Sky)
//#declare Hills=off; // uncomment to turn off hills
//#declare NoWagons=off;
//#declare NoDocks=off;
//#declare NoDragon=off;
//#declare RealHorse=yes; // uncomment to use real horse files
//#declare NoCastle=yes;
//#declare NoBoats=yes;
//#declare NoSoldiers=yes;
//#declare Lighted=yes;   // turn on lanterns (ouch 180Meg/3x render time)

#declare RS=seed(92);
#include "../med/people.inc"
#include "../med/mainpart.inc" 
#include "fantpart.inc"
#include "../med/wagons.inc"
  
#declare SA=0;   // 30 for Cover  (Sailor Image angle)

// starry sky
#ifndef (nosky)
sky_sphere {pigment {granite color_map{
                     [.8 rgb 0] [1 rgb 1] }
                     turbulence 2 scale .08}}
#end

camera {
//  right<1200/600,0,0>    // make 1200x400 panorama
//  angle 70
//  panoramic 
//  location <-135,5,-155> look_at <25,40,20>    // Shanty/Dockyards (Panoramic location) 

//    location <-15,16,-6> look_at <-15,17,55>   // dormer close up
//    location <-45,20,-55> look_at <-25,10,20>  // south wall scaffolding
//    location <-120,5,-140> look_at <25,20,20>    // Shanty/Dockyards
//    location <-70,15,-120> look_at <0,0,-90>            
//    location <-140,-2,-110> look_at <90,0,-10> 

//  location <-50, -5 ,-136> up y right 4/3*x look_at <20,5,30>   // Cover Angle (III)

//  location <-10,5,-165> look_at <-5,10,30> // old angle    
  location <-10,5,-165> look_at <-5,0,30>      // front view, (IIA) (IRTC Entry)               

//  location <-2.5,3,-160> look_at <-5,10,40>  // IRTC II second view  
  
//  location <-40,-5,-120> look_at <5,5,-30>  // boat/castle cover view 
}

#ifndef(Lighted)
  light_source{<-1000,1000,-2000> color White*2} 
#end

// ---------------------------------------------- objects  


#ifndef(NoWagons)
  
  #ifdef(RealHorse)
    #include "horseR.inc"
  #end
  
    union{     
       object{Wagon4 translate<0,-.5,0> texture{pigment{color DarkGreen}}}
       #ifdef(RealHorse)
         object{Wagon2HorseR}
       #else
         object{Wagon2Horse}
       #end
       object{WagonDriver rotate<0,-90,0> translate<0,.3,.2>}       
     rotate<0,-95,0> translate<1.41,1.15,-140>
    }

    union{
       object{Wagon1 translate<0,-.5,0> texture{pigment{color ForestGreen}}}
       object{Wagon_Load1 translate<-.25,0,0>}       
       #ifdef(RealHorse)
         object{Wagon4HorseR}
       #else
         object{Wagon4Horse}  
       #end
       object{WagonDriver2 rotate<0,-90,0> translate<.3,.25,.5>}       
     rotate<0,-85,0>  translate<1.5,1.15,-130>
    }  
      
#end 
#ifndef(NoDragon)
#declare Cindy1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\crend.gif" transmit 0, 1.0} 
               }}
               scale <1.85,2.25,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,.1,0>
               }}
  object{Cindy1 rotate<0,0,0> translate<-3.5,0,-153.2>}                               
       
  #include "dragonI.inc"
  object{Dragon texture{Crackle_in_Crackle2 scale .05}   
              finish{Phong_Glossy}
              normal{granite .65 
              //scale<.05,.05,.05> 
              turbulence .35}
              translate<-4,2.5,-152> }
              
#declare Knight1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\knights\knight1.gif" transmit 0, 1.0} 
               }}
               scale <1.95,2.25,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,.1,0>
               }}
  object{Knight1 rotate<0,180,0> translate<-2.65,0,-145.2>}
#declare Knight2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\knights\knight2.gif" transmit 0, 1.0} 
               }}
               scale <1.95,2.25,1> 
               translate<-.5,0,0> rotate<0,0,0>
               translate<0,.1,0>
               }}
  object{Knight2 rotate<0,0,0> translate<-2.8,0,-145>}  
                    
#end // ifndef(NoDragon)

#ifndef(NoDocks)
  object{Scaffold translate<-27,0,-9>}

  object{Docks translate<-60,-6,-45>}  
  object{Docks translate<60,-6,-45>}
#end

object{Bridge_Ext
       translate<0,0,-124.5>
       //texture{pigment{color White}} 
       texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }

object{Entrance2 translate<0,0,-4>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }
      
object{Entrance1 translate<0,0,-38>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }      
             
//object{GreatHall2 translate<-35,0,30>
//       texture{pigment{color White}} 
//       //texture{T_WhiteBrick scale .12}  
//       normal{granite .5 
//       scale<1,1,1> 
//       turbulence .75}
//      }                                
//object{GreatHall2 translate<35,0,30>
//       texture{pigment{color White}} 
//       //texture{T_WhiteBrick scale .12}  
//       normal{granite .5 
//       scale<1,1,1> 
//       turbulence .75}
//      }      
                
#ifndef(NoCastle)
                
object{GreatHall1 translate<-68,-6,70>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }           
object{GreatHall1 translate<68,-6,70>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }                                    
object{GreatHall1 translate<-68,-6,0>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }           
object{GreatHall1 translate<68,-6,0>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }                                    
object{A_Wall rotate<0,90,0> translate<35,0,0>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }             
object{A_Wall rotate<0,0,0> translate<70,0,35>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }
      
//--- Inner bailey/objects -----------------------------

object{A_Wall rotate<0,90,0> translate<20,20,58>
       //texture{pigment{color White}} 
       texture{T_MixBrick scale .12 translate<0,0,.005>}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }             
object{A_Wall rotate<0,90,0> translate<-20,20,58>
       //texture{pigment{color White}} 
       texture{T_MixBrick scale .12 translate<0,0,.005>}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }
                
//------------------------------------------------------                   
      
//#ifdef(Cnnn)
object{TB3 translate<25,40,100>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }
object{TB3 rotate<0,45,0> translate<-15,30,100>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .75 
       scale<1,1,1> 
       turbulence .75}
      }
      
object{TB1 rotate<0,45,0> translate<35,40,80>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }      
object{TB1 rotate<0,45,0> translate<-35,40,80>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }     
//#end       
      
object{A_Wall rotate<0,90,0> translate<-35,0,0>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }                 
object{A_Wall rotate<0,0,0> translate<-70,0,35>
       texture{pigment{color White}} 
       //texture{T_WhiteBrick scale .12}  
       normal{granite .5 
       scale<1,1,1> 
       turbulence .75}
      }       
#end //ifndef(NoCastle)
 
#ifndef(SkyOff)
                           
//#include "..\med\cloud.inc"       

#declare SkyBlue = rgb <0.15, 0.4, 0.7> ;
#declare P_Clouds =
pigment {
  wrinkles
  turbulence 0.1
  lambda 2.2
  omega 0.707
  color_map {
    [0.60 SkyBlue ]
    [0.80 White ]
    [1.00 Gray90 ]
  }
  scale <0.5, 0.15, 1>
  rotate  z*180
  rotate  y*60
}
sky_sphere {
  pigment {
    gradient y
    pigment_map {
      [0.00 rgb <0.847, 0.749, 0.847> ] // horizon
      [0.05 SkyBlue ]                   // horizon
      [0.15 P_Clouds ]
      [1.00 SkyBlue ]
    }
  }
}

fog {                                                 // White ground fog
  distance 150
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 5
  fog_alt 3
  turbulence 1.0
  turb_depth 3.0
}
#end // ifndef(SkyOff) 
 
//--------------------------------------------------Ground
#declare GH=-11.5;
union{
  object {   //  ground
                height_field { png  "../graphics/castII.png" }
                texture { pigment { color Tan1 } }
                scale < 300, 12, 240 >   translate < -150, GH, -120 >
                rotate<0,0,0> translate<-10,0,55>
                normal{granite .5 scale<1,1,1> turbulence .75}
  }
  object {   //  ground
                height_field { png  "../graphics/castII.png" }
                texture { pigment { color Tan1 } }
                scale < 150, 30, 240 >   translate < -75, GH, -120 >
                rotate<0,180,0> translate<0,0,130>
                normal{granite .5 scale<1,1,1> turbulence .75}
  }  
//**************************
// Now for a watery plain
  plane {
               < 0,.08,0 >, 0
                texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.2  scale < .5, 0.3, 0.3 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 } 
         translate<0,GH+.5,0>
  }  
    
  #ifndef(NoBoats)   
    #include "caravelI.inc"
    #include "../med/people.inc"
    
#declare Sailor1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor1.gif" transmit 0, 1.0} 
               }}
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Sailor2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor2.gif" transmit 0, 1.0} 
               }}
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Sailor3=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor3.gif" transmit 0, 1.0} 
               }}
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Sailor4=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor4.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Sailor5=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor5.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Sailor6=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor6.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}              
#declare Sailor7=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\sailor7.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Captain1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\captain1.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Mate1=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\Mate1.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Mate2=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\mate2.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}
#declare Mate21=union{
               box{<0,0,0><1,1,.005> hollow 
                texture{pigment{image_map { gif "..\graphics\sailors\mate2a.gif" transmit 0, 1.0} 
               }}               
               translate<-.5,-.1,0> rotate<0,0,0>
               scale <1.75,2,1> 
               }}                                                            
                                                   
    union{
      object{CaravelISail rotate<0,180,0> translate<0,0,0>}                                                                        
               
      object{Captain1 rotate<0,SA,0> translate<7,1.75,-3>}
      object{Mate1 rotate<0,SA,0> translate<6,1.75,-3.2>}
      object{Sailor4 rotate<0,SA,0> translate<6.5,1.75,0>}

      object{Sailor4 rotate<0,SA,0> translate<-3.5,0,-3.25>}    
      object{Sailor3 rotate<0,SA,0> translate<-2.7,0,-3>}
      object{Sailor7 rotate<0,SA,0> translate<-1.3,0,-3.26>}
      object{Sailor1 rotate<0,SA,0> translate<.5,0,-3>}
      object{Sailor5 rotate<0,SA,0> translate<1,0,-3>}
      object{Sailor6 rotate<0,SA,0> translate<1.75,0,-3>}
      object{Sailor2 rotate<0,SA,0> translate<2.5,0,-3.25>}

      object{Mate2 rotate<0,SA,0> translate<-6,1,-1>}
     
     translate<-29.5,GH+1.5,-101.25>
    }
    
  union{ // boat wake
    sphere{<0,0,0>.65 scale<3.5,1,1> rotate<0,0,-15> translate<0,-.35,.45>} 
    sphere{<0,0,0>.65 scale<3.5,1,1> rotate<0,0,-15>  translate<0,-.35,-.45>}     
    
    cone{<10,0,0>.25 <50,0,-3> .10 scale <1,.75,1.5>}
    cone{<10,0,0>.25 <50,0,3> .10 scale <1,.75,1.5>}        
    cone{<0,0,0>.35 <40,0,-6> .50 scale <1,.75,1.5>}
    cone{<0,0,0>.35 <40,0,6> .50 scale <1,.75,1.5>}    
    cone{<-1,0,-1>.35 <40,0,-10> .75 scale <1,.5,1.5>}
    cone{<-1,0,1>.35 <40,0,10> .75 scale <1,.5,1.5>}    
    translate<-37,GH+.5,-101.25>
//    texture{pigment{color Red}}
         texture {
                  pigment { color rgbt < 0.0, 0.15, 0.2, .75 > }
                  normal { bumps 0.3  scale < .5, 0.3, 0.3 > }
                  finish { phong 1  reflection 0.25  ambient 0.1  diffuse 0.2 }
                 }     
  }
  
  //Anchored boats...
  union{  
    cylinder{<0,0,0><0,4.05,0>.15}
    cylinder{<0,0,.4><0,4,.4>.15}
    cylinder{<-.15,0,0><.15,3.9,.1>.15}
   texture{T_Wood1 rotate<90,0,0> scale .02}
   translate<-27,GH-1,-120>
  }
  
  union{
      object{CaravelI }    
  
      object{Mate1 rotate<0,SA-220,0> translate<6,1,-1.5>}
      object{Captain1 rotate<0,SA-220,0> translate<5,1,-2>}
      object{Sailor4 rotate<0,SA-220,0> translate<6.5,1,0>}

      object{Sailor4 rotate<0,SA-220,0> translate<3.5,0,1.25>}    
      object{Sailor3 rotate<0,SA-220,0> translate<2.7,0,2>}
      object{Sailor7 rotate<0,SA-220,0> translate<1.3,0,2.26>}
      object{Sailor1 rotate<0,SA-220,0> translate<.5,0,-2>}
      object{Sailor5 rotate<0,SA-220,0> translate<1,0,-2>}
      object{Sailor6 rotate<0,SA-220,0> translate<1.75,0,-2>}
      object{Sailor2 rotate<0,SA-220,0> translate<2.5,0,-1.25>}

      object{Mate2 rotate<0,SA-220,0> translate<-4.5,1.75,-1>}  
    
    rotate<0,220,0>
    translate<-17,GH+1.5,-133>
  }
  object{CaravelI rotate<0,90,0> translate<-30,GH+1.5,-130>}
  
   #end //ifndef(NoBoats)
  
//  object {   //  ground
//                height_field { png  "../graphics/castII.png" }
//                texture { pigment { color Tan1 } }
//                scale < 110, 2, 110 >   translate < -55, GH, -55 >
//                rotate<0,180,0> translate<0,0,-2>
//  }  
//  object {   //  west
//                height_field { png  "../graphics/castII.png" }
//                texture { pigment { color Tan1 } }
//                scale < 90, 4, 90 >   translate < -45, GH, -45 >
//                rotate<0,180,0> translate<-50,0,0>
//  }
//  object {   //  east
//                height_field { png  "../graphics/castII.png" }
//                texture { pigment { color Tan1 } }
//                scale < 90, 4, 90 >   translate < -45, GH, -45 >
//                rotate<0,180,0> translate<50,0,0>
//  }    

#ifndef(Hills)
//***********************
//  Low hills (N)
  object { 
                height_field { png  "../graphics/hills2.png" }
                texture { pigment { color Tan1 } }
                 scale <2400, 10, 2400 >   
                 translate<-1200,0,-1200> // center
                 translate < -100, GH, 2500 >
  }
// Low Hill covering
  object { 
                height_field { png  "../graphics/hills2.png" }
        //        texture { GroundC }
                 scale < 2400, 10.1, 2400 >   
                 translate < -1200, 0, -1200 > // center <0,0,0>
                 translate < -100, GH,2500> // push back in center
  }
  
  
//**************************
//  Distant hills (NW)
  object { 
                height_field { png  "../graphics/hills1.png" }
                texture { pigment { color Tan1 } }
                 scale <1600, 200, 1600 >   
                 translate<-800,0,-800> // center
                 translate < -1600, GH, 2600 >
  }
// Distant Hill covering
  object { 
                height_field { png  "../graphics/hills1.png" }
      //          texture { GroundC }
                 scale < 1600, 200.1, 1600 >   
                 translate<-800,0,-800> // center       
                 translate < -1600, GH, 2600 >
  }                             
//**************************
//  Distant hills (N)
  object { 
                height_field { png  "../graphics/hills2.png" }
                texture { pigment { color Tan1 } }
                 scale <1600, 230, 1600 >   
                 translate<-800,0,-800> // center 
                 translate < 0, GH, 2400 >
  }
// Distant Hill covering
  object { 
                height_field { png  "../graphics/hills2.png" }
        //        texture { GroundC }
                 scale < 1600, 230.1, 1600 >   
                 translate<-800,0,-800> // center 
                 translate < 0, GH, 2400 >
  }
//**************************
//  Distant hills (NE)
  object { 
                height_field { png  "../graphics/hills1.png" }
                texture { pigment { color Tan1 } }
                 scale <1600, 200, 1600 >   
                 translate<-800,0,-800> // center 
                 translate < 1000, GH, 1600 >
  }
// Distant Hill covering
  object { 
                height_field { png  "../graphics/hills1.png" }
       //         texture { GroundC }
                 scale < 1600, 200.1, 1600 >   
                 translate<-800,0,-800> // center 
                 translate < 1000, GH, 1600 >
  }    
//**************************
//  Distant hills (W)
  object { 
                height_field { png  "../graphics/hills1.png" }
                texture { pigment { color Tan1 } }
                 scale <1600, 160, 1600 >   
                 translate<-800,0,-800> // center 
                 translate < -1050, GH, 0 >
  }
// Distant Hill covering
  object { 
                height_field { png  "../graphics/hills1.png" }
       //         texture { GroundC }
                 scale < 1600, 160.1, 1600 >   
                 translate<-800,0,-800> // center 
                 translate < -1050, GH, 0 >
  }
#end // ifndef(Hills)  

 texture{GroundC}
} 
  
 
#ifndef(NoSoldiers)
  #include "../roman/romsold.inc"

#declare MountedColumn=union{

object{SolRiderVexillarius translate<-2,0,1>}

#ifndef(GenMen)
#declare RP=seed(5766);
#declare Count=0;
#while (Count<=2)
   #declare Count2=0;
   #while (Count2<=35)
        #declare ROY=rand(RP)*20-10;  // rotation of soldier
        #declare RX=rand(RP)*.3-.15;   // fudge x
        #declare RZ=rand(RP)*.1-.5;   // fudge z
        #declare RW=int(rand(RP)*40+1);   // for select
        #declare RH=int(rand(RP)*4+1);    // for horse select
        #switch (RW)
           #case (1)
              object{SolRiderA1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (2)
              object{SolRiderA2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (3)
              object{SolRiderA3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (4)
              object{SolRiderA4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (5)
              object{SolRiderA5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (6)
              object{SolRiderA11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (7)
              object{SolRiderA22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (8)
              object{SolRiderA33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (9)
              object{SolRiderA44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (10)
              object{SolRiderA55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (11)
              object{SolRiderB1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (12)
              object{SolRiderB2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (13)
              object{SolRiderB3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (14)
              object{SolRiderB4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (15)
              object{SolRiderB5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (16)
              object{SolRiderB11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (17)
              object{SolRiderB22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (18)
              object{SolRiderB33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (19)
              object{SolRiderB44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (20)
              object{SolRiderB55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (21)
              object{SolRiderC1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (22)
              object{SolRiderC2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (23)
              object{SolRiderC3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (24)
              object{SolRiderC4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (25)
              object{SolRiderC5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (26)
              object{SolRiderC11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (27)
              object{SolRiderC22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (28)
              object{SolRiderC33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (29)
              object{SolRiderC44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (30)
              object{SolRiderC55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (31)
              object{SolRiderD1 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (32)
              object{SolRiderD2 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (33)
              object{SolRiderD3 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (34)
              object{SolRiderD4 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (35)
              object{SolRiderD5 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (36)
              object{SolRiderD11 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (37)
              object{SolRiderD22 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (38)
              object{SolRiderD33 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (39)
              object{SolRiderD44 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (40)
              object{SolRiderD55 rotate<0,ROY,0> translate<RX+Count,0,RZ+Count2>}
           #break
        #end
        #switch (RH)
           #case (1)
              object{Horse1 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (2)
              object{Horse2 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (3)
              object{Horse3 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
           #case (4)
              object{Horse4 rotate<0,ROY-90,0> translate<RX+Count,0,RZ+Count2>}
           #break
        #end           
       #declare Count2=Count2+4.5;
   #end
   #declare Count=Count+1.35;
#end
#end // ifndef(GenMen)
}

object{MountedColumn rotate<0,0,0> translate<0,0,-80>}

#end //ifndef(NoSoldiers)    