// ----
//
// EMAIL: 			thomas_alun@lineone.net
// NAME: 			Alun Thomas
// TOPIC: 			Warfare
// COPYRIGHT: 		I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
// TITLE: 			Outcome
// COUNTRY: 		United Kingdom
// WEBPAGE: 		<none>
// RENDERER USED: 	WinMegaPov 0.5a
// TOOLS USED: 		Windows Povray Editor
// RENDER TIME: 	<time your image took to render>
// HARDWARE USED: 	<Pentium? Sparc? SGI?>
// IMAGE DESCRIPTION:
// 		<anything you want to say about your image>
// DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
// 		<Description of how you created your image, what techniques you used, etc..>
//
// ----

#version unofficial MegaPov 0.5 ;

#include "colors.inc"
#include "macros2.inc"

#declare c = color rgb <.8, .85, 1>; 
#declare s1 = color rgb <1, .8, .6>; 
#declare n = 4;

background {rgb 0.5}

#declare UseFocalBlur=false;

#declare Final=true;

#if (!Final)
	global_settings { ambient_light 3 }
#else
	#declare UseFocalBlur=true;
#end

#macro GetSurfaceTangents( Normal, T1, T2 )

	#if ( (Normal.x = 0) & (Normal.z = 0) )
		#declare T1=x;
		#declare T2=z;
	#else
		#declare T1 = vnormalize( vcross( y, Normal ) );
		#declare T2 = vnormalize( vcross( T1, Normal ) );
	#end
	
#end

#macro GetDownhillVector( Posn, Normal, Downhill )
	#local t1=<0,0,0>;
	#local t2=<0,0,0>;
	#local sweep=0;
	#local sweep_step=1;
	#local best_dir=0;
	#local best_alt=Posn.y;
	
	GetSurfaceTangents( Normal, t1,t2 )
	
	#declare Downhill = vnormalize (vaxis_rotate( Normal, t1, 90 ));	
#end

camera {
	location <0, 0.75, -7>
	look_at <-.5, 0.25, 0>
	angle 30
	#if (UseFocalBlur)
		aperture 0.4
		focal_point <-.5, 0.75, 0>
		blur_samples 256
		variance 1/2048
		confidence 0.9999
	#end
}


#if (Final)
	fog {
		fog_type 2 // =ground_fog
		distance 50
		color rgb <.7,.7,1>
		fog_offset 0
		fog_alt 5
	}
 #end

//
// Lightting
//

#if (Final)

	light_source {
	  <100, 100, -50>
	  color s1*.6
	  area_light <1, 0, 2>, <-2, 2, 1>, 3, 3
	  adaptive 1
	  jitter
	  media_interaction on
	  media_attenuation on
	}
	
	light_source {
	  <0, 100, 0>
	  color c
	  area_light x*200, z*200, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <100, 0, 0>
	  color c
	  area_light y*200, z*200, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <-100, 0, 0>
	  color c
	  area_light y*200, z*200, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <0, 0, 100>
	  color c
	  area_light y*200, x*200, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <0, 0, -100>
	  color c
	  area_light y*200, x*200, n, n
	  adaptive 1
	  jitter
	}
#else
	light_source {
	  <100, 100, -50>
	  color rgb 1
	  area_light <1, 0, 2>, <-2, 2, 1>, 3, 3
	  adaptive 1
	  jitter
	  media_interaction on
	  media_attenuation on
	}
	
	light_source {
	  <-100, 100, 0>
	  color rgb .5
	  shadowless
	}
#end

//
// Floor
//

#declare Floor_o = object {
	difference {	
		plane {
			y, 0
		}
		union {
			#declare n=3;
			#declare m=-1;
			#while (m<n)
				box { -.025-100*x .025+100*x rotate x*45 translate z*m*3}
				box { -.025-100*z .025+100*z rotate z*45 translate x*m*-3}
				#declare m=m+1;
			#end
		}
		bounded_by 	{	plane {	y, 0.001	} }  
		pigment { checker color rgb <0.8,0.8,1>, color rgb 1 scale 3 translate -1*y }
		rotate y*50
	}
}

//
// chesspawn
//

#declare Cutter_box_o = box {
	-.5 .5
	rotate y*45
	scale <.6,1,1>
	rotate x*-15
	translate -z*6.2
	pigment { colour Goldenrod }
}

#declare Cutter_o = 
	object {Cutter_box_o rotate y*-60}
	
#include "ChessPawn.inc"
	
#declare Pawn_o = object {
	difference {
		lathe {
			cubic_spline
			dimension_size(ChessPawn_a,1),
		
			#declare n=0;
			#while (n<dimension_size(ChessPawn_a,1))
				#if (n<(dimension_size(ChessPawn_a,1)-1) )
					ChessPawn_a[n],
				#else
					ChessPawn_a[n]
				#end
				#declare n=n+1;
			#end
			texture {
				pigment { White }
				normal {
					wood ramp_wave
					slope_map {
						[ 0.00 <0,0> ]
						[ 0.40 <0.5,1> ]
						[ 0.80 <1,0> ]
						[ 0.90 <0.1,-1> ]
						[ 1.00 <0,0> ]
					}
					bump_size 0.05
					turbulence 0.1
					rotate x*-75
					translate z*-10
					rotate y*30
				}
			}
		}
		object { Cutter_o }
		scale .1
		rotate y*30
		translate <-0.57,-0.24,0>
		rotate <0,0,-99.15>
		rotate y*-30
		translate -1.5*x		
	}
}

#declare World_o = object {
	union {
		object { Pawn_o }
		object { Floor_o }
	}
}
		
object { World_o }


#declare Blood_t =	texture {
		pigment {color rgbf <.4,0,.025,1>*1.25 }
		normal {
			bumps scale 0.05
		}
		finish {
			phong .4 phong_size 90 diffuse 0
			reflection_min .01
			reflection_max .04
			reflection_falloff 2
			conserve_energy
		}
	}
	
#declare Blood_i = 	interior { 
		ior 1.33
		media {
			scattering { 3, <.4,0,.025>*10 extinction 0 }
			absorption (1-<.4,0,.025>)*10
			method 2
			intervals 1
			samples 1,1
		}
	}
	
#include "Splodge.inc"

#declare ThisSplodge_o = object { 
	Splodge_o 
	scale <.25,.15,.25> 
	translate <-.25,0,1.2>
	bounded_by { box { <-1.25,-0.03,0.15>, <0.8,0.03,2.25> } }
	texture { Blood_t }
	interior { Blood_i }
	hollow on
}

object{ ThisSplodge_o }
		
#declare Source = <0, 0, 0>; 
#declare Norm  = <0, 0, 0>; 
#declare Start_p = vrotate(<-.5,1.5,.2>,y*50); 
#declare End_p = Start_p - 2*y;

#declare Source = trace ( World_o, Start_p, End_p-Start_p, Norm ); 

#if ( (Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0) ) 
 
	#declare t1 = <0,0,0>;
	#declare t2 = <0,0,0>;
	GetSurfaceTangents( Norm, t1,t2 )
	
	#declare n=25;
	#declare m=0;
	#declare posn=array[n]
	#declare step=0.03;
	
	#declare this=Source;
	#declare this_normal=Norm;
	#declare rad_offset=0.05;

	#declare BloodTrickle_o = merge {
		#while (m<n)
			#declare posn[m]=this;
			#declare vc=vcross( y,this_normal );
			#declare this_rad=0.02 + rad_offset + noise3d( posn[m] )*.01;
			
			sphere{ 0
				this_rad
				ascale( this_normal, 0.01/this_rad )
				translate posn[m]
			}
			
			#declare downhill=<0,0,0>;
			GetDownhillVector( this, this_normal, downhill )
		
			#declare this=this+downhill*step;
			#declare this=trace ( World_o, this, -this_normal, this_normal );
			#declare rad_offset = rad_offset*.8; 
			#declare m=m+1;
		#end
		texture { Blood_t }
		interior { Blood_i }
		hollow on
	}
	
	object { BloodTrickle_o }
	
#end


#declare a_p = vrotate(<-.22,0,0>,y*50); 
#declare b_p = vrotate(<-.3,0,0>,y*50); 

cylinder {
	a_p b_p, 0.02
	scale <1,.5,1>
	texture { Blood_t }
	interior { Blood_i }
	hollow on
}
	


