  #include "colors.inc"
  #include "textures.inc"
  #include "woods.inc"
  #include "stoneold.inc"
   #include "metals.inc"
  #declare BESTRAD = off;
    
  global_settings { assumed_gamma 2.2
   //ambient_light 0
   #if(BESTRAD)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 300

      nearest_count 5
      error_bound 0.2
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1
       
      media on 
      adc_bailout 0.01/2
    }   
   #else
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 1

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      //media on
      adc_bailout 0.01/2
    } 
#end}

background {White}


sky_sphere {
  pigment { 
    gradient x    color_map { [0.0 color rgb <1,1,0>] [1.0 color blue 0.2] }
  }
 
}
 
  
  #declare Sort=
  camera {
    location <10, 4, 1>
    look_at <0, 2, 7>
    //angle 45
  }
 
 #declare Brik=
 camera {
    location <1, 2, 2>
    look_at <-3, 2, -7>
    //angle 45
    }
 
 #declare Close=
 camera {
    location <11,4, 2>
    look_at <0, 1, -8>
    angle 50
    }

 #declare Wide=
 camera {
    location <0,10,15>
    look_at <0, 0, 0>
    //angle 100
    }

 #declare TransSide=
 camera {
    location <12,3,-3>
    look_at <0, 1, -7>
    }
 
 #declare Exp=
 camera {
    location <10,3,-1>
    look_at <2, 0, -6>
    angle 70
    }
    
 #declare Top=
 camera {
    location <80,200,80>
    look_at <2, 1, -7>
    }

 #declare Up=
 camera {
    location <10,3,-1>
    look_at <2, 5, -1>
    }
       
  camera
  {Exp} 
  

  light_source { <-90, 8, 0>
      rgb 5*<1,1,1>
    spotlight
    radius 15
    falloff 20
    tightness 14
    point_at <0, 0, 0>
  }
  
  
union
{  
box{
<-8, -0.5, -8>
< 8, 0 ,8>
texture {checker texture{T_Grnt5},texture{T_Grnt7}
         scale 2 }}
box{
<-10, -0.5, -10>
<-8,  0.1,  10>}
box{
<10, -0.5, -10>
<8,  0.1,  10>}
box{
<-10, -0.5, -10>
< 10,  0.1, -8>}
box{
<-10, -0.5, 10>
< 10,  0.1, 8>}
texture {T_Wood9
        rotate y*45
        scale 5}
}



#declare Whitecol=
texture{
pigment {
    granite
    turbulence 0.8
    color_map {
        [0.0 rgb <0.93, 0.71, 0.53>]
        [0.8 rgb <0.98, 0.81, 0.60>]
        [1.0 rgb <0.70, 0.60, 0.23>]
    }scale .5
}finish {phong 0.3 phong_size 50}
normal {wrinkles 0.3
        turbulence 0.5}
}

#declare Blackcol=
texture{
pigment {
    granite
    turbulence 0.8
    color_map {
        [0.0 rgb <0.33, 0.21, 0.03>]
        [0.8 rgb <0.38, 0.31, 0.10>]
        [1.0 rgb <0.10, 0.10, 0.03>]
    }scale .5
}finish {phong 0.3 phong_size 50}
normal {wrinkles 0.3
        turbulence 0.5}
}
           


#declare SortSteel=
texture{
pigment {color rgb <0.10, 0.10, 0.10>}
finish {
    ambient 0.35
    brilliance 2
    diffuse 0.5
    metallic
    specular 0.80
    roughness 10/20
    reflection 0.2
 }}

#declare Metalfarve=
texture{
pigment {color rgb 1.5*<0.30, 0.30, 0.45>}
normal {bump_map{ tga "metalmap.tga"
bump_size 13}
rotate z*45}
finish {
  
    brilliance 5
    diffuse 0.5
    metallic 1
    phong 0.9
    phong_size 15
    reflection 0.2 
 }}

#declare SortFarve=
texture {T_Wood12}    

#declare Tow=
difference  
{lathe
{linear_spline
11,
<0, 0>,   <2.5, 0>, <2, 0.5>, <2, 1>,
<1.5, 2>, <1.5, 7>, <2, 8>,     <2,9>,    <1.5,9>,
<1.5,8>,<0,8>
}
box
{<-3, 8.5, -0.5>
 < 3, 9.5,  0.5>
 }
 
box
{<-3, 8.5, -0.5>
 < 3, 9.5,  0.5>
 rotate 60*y}
 
box
{<-3, 8.5, -0.5>
 < 3, 9.5,  0.5>
 rotate 120*y}
 } 

 
#declare Peasant=
lathe
{linear_spline
10,
<0, 0>,   <2, 0>, <1.5, 0.5>, <1.5, 1>,
<1, 1.5>, <0.5, 4>, <1, 4.5>,   <0.5,5.5>,    <0.5,6>,
<0,6.5>
}

#declare Springer=
lathe
{linear_spline
14,
<0,0>, <2.5,0>, <2.5, 0.5>, <1, 1.5>, <1.5, 2>, <0.7, 2.5>,
<1.2, 7>, <0.5, 8.3>, <1, 8.5>, <0.5, 8.7>, <1, 9.2>, <1, 10>,
<0.5, 10.5>, <0, 10.5>
}

#declare Queen=
union
{lathe
{linear_spline
16,
<0,0>, <2.5,0>, <2.5, 0.5>, <1.5, 1>, <2, 1.3>, <1, 1.7>, <1.5, 2>, <0.7, 2.5>,
<1.2, 7>, <0.5, 9.3>, <1, 9.5>, <0.5, 9.7>, <1, 10.2>, <1, 11>,
<0.5, 11.5>, <0, 11.5>}
difference
{lathe
{linear_spline
5,
<1, 10.5>, <1.3, 10.5>, <1.3, 11.3>, <1, 11.3>, <1, 10.5>}
box
{<-2, 11, -0.3>
 < 2, 11.5,0.3>}
box
{<-2, 11, -0.3>
 < 2, 11.5,0.3>
 rotate y*60}
box
{<-2, 11, -0.3>
 < 2, 11.5,0.3>
 rotate y*120}}
}

#declare King=
union
{object{Queen}
box{
<-0.25, 11, -0.25>
<0.25,  13, 0.25>
}
box{
<-0.75, 12, -0.25>
< 0.75, 12.5 0.25>
}}

 
 #declare Hest0=
 union
 {
 box
 {<-0.5, 1, 0.5>
  <0.5,  2, -2.5>
  }
  box
  {<-0.5, 0, 0>
   <0.5, 1, -1.8>
   rotate x*330
   translate <0, 2, 0.5>}
   }
   
   #declare Hest1=
   difference
   {
   object{Hest0}
   
   cylinder
   {<-1, 1.4, -2.5>
    < 1, 1.4, -2.5>, 0.2
    }
     cylinder
   {<0, 2.2, -3>
    <0, 3, 1>, 0.4
    }
    translate y*-1
    rotate x*340
    scale 1.5
    }
    
#declare Hest=
union
{lathe
{linear_spline
8,
<0, 0>,   <2, 0>, <1.5, 0.5>, <1.5, 1>,
<1, 1.5>, <1.2, 5>, <0.5,6.5>,
<0,6.5>}
object
{Hest1
translate y*6.3}


}

//----------------Background-------------------------------

  merge{
  torus{
  20, 1 
  translate y*-1
  pigment{Gray40}}
  cylinder{
  <0,0,0>
  <0,-1,0>20
  pigment {
    marble
    turbulence 0.7
    color_map { 
        [0.0 rgb <1, 1, 1>]
        [0.7 rgb <0.8, 0.8, 0.8>]
    [0.9 rgb <0.5, 0.5, 0.5>]
    [1.0 rgb <0.2, 0.2, 0.2>] }
    rotate y*70
    scale 3
}
translate y*-0.1}}  
    
  difference{
  box{
  <-61,-30,-61>
  <30,20,61>}
  box{
  <-60, -25, -60>
  <25, 18, 62>}
   box{
  <-50, -25, -60>
  <25, 40, 60>}
  box{
  <-65,-10,-15>
  <-55,15,0>}
  pigment{Black}

  }
  
  union{
  sphere{
  <1.5,5,15>0.6}
  box{            
  <0,-10,0>
  <1,15,15>}
  rotate y*-40
  translate <-61,0,-15>
  pigment {Gray30}
  }
  
  box{
  <-100,-15, -20>
  <-101, 25, 5>
  pigment{rgb <1,1,0.8>}
  finish{ambient 0.7}
  }
  
//-----------------Pieces Box------------------------------
#declare Goldphong=
texture {
    gradient x       
    texture_map {
      [0.0  pigment{Gold} finish{ambient 1}]
      [0.05  pigment{Gold} finish{ambient 0.8}]
      [0.2  pigment{Gold} finish{ambient 0.2}]
      [0.8  pigment{Gold} finish{ambient 0.2}]
      [0.95  pigment{Gold} finish{ambient 0.8}]
      [1.0  pigment{Gold} finish{ambient 1}]}}
         
#declare Box=
difference{
  superellipsoid { <.05, .05>
    scale <3,1.5,2>
    texture {Sandalwood
        rotate y*45
        scale 1}  }
          box{
    <2.8, 3, 1.8>
    <-2.8, 0, -1.8>
        texture {Sandalwood
        rotate y*45
        scale 1}}}
        
#declare Oldpaper=
texture{pigment {rgb <1,0.9,0.8>}}
texture{
      pigment {
        wrinkles 
        turbulence 0.6
        color_map {
          [0.0 color Brown ]
          [0.2 color rgbt <0.6, 0.2, 0.2, .5> ]
          [0.4 color rgbt <.7, .4, .3, .7> ]
          [0.5 color rgbt <1, 1, 1, 1> ]
          [1.0 color rgbt <1, 1, 1, 1> ]
        }
        scale 0.3}}

#declare Lid =
 union{
  box{ <2.5, 0.01, 1>
       <-2.5, -0.06, -1>
    texture{Oldpaper}}
        text {
    ttf "LBLACK.TTF" "Battle Chess" .1, 0
    texture {Goldphong
        rotate z*30
        scale 3
        translate x*0.5}
    scale 0.75
    rotate x*-90
    translate <-2,0,-0.2>
    translate y*-0.07
  }
        text {
    ttf "timrom.ttf" "Robotic Edition" .1, 0
    texture {Goldphong
        rotate z*30
        scale 5
        translate x*2}
    scale 0.5
    rotate x*-90
    translate <-2,0,0.4>
    translate y*-0.07
  }
          text {
    ttf "timrom.ttf" "(c) Lars V. Nielsson 2001" .1, 0
    texture {Goldphong
        rotate z*30
        scale 5
        translate x*2}
    scale 0.23
    rotate x*-90
    translate <-2,0,0.8>
    translate y*-0.07
  }

  superellipsoid { <.1, .1>
    scale <3,.05,2>
    texture {Sandalwood
        rotate y*45
        scale 1}}

    translate z*2
    rotate x*-200
    translate y*1.5
    translate z*-2
  }
  
  #declare Join=
  union{
  cylinder{
  <1,0,0>
  <0.3,0,0>0.1}
  cylinder{
  <-1,0,0>
  <-0.3,0,0>0.1}
  cylinder{
  <1.5,0,0>
  <-1.5,0,0>0.09}
  texture{
  pigment{Gray60}
  finish{metallic
         reflection 0.3
         phong 0.7}}
  scale <0.5,1,1>
  translate <-1,1.45,-2>
  }
  
 #declare Cbox=
  union{
  object{Lid}
  object{Box}
  object{Join}}
//----------------Transformed Peasant----------------------
#declare Ptop1=
intersection{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.5,0><0,6.9,0>2
texture{Whitecol}}}

#declare Ptop2=
difference{
object{Ptop1}
box{
<0.3,1.4,3>
<-0.3,4,-3>
pigment {Gray20}}}

#declare Pbuttom=
difference{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.51,0><0,15,0>3
texture{Whitecol}}}

#declare Pfoot=
intersection{
object {Peasant
texture{Whitecol}}

cone{
<0,-2,0>1<0,2,0>0
rotate z*20
translate <1.3,2,0>}}


#declare Pfeet=
union{
object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-115
translate x*1.2
rotate y*150
scale 0.8}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-115
translate x*1.2
rotate y*30
scale 0.8}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-115
translate x*1.2
rotate y*270
scale 0.8}}

#declare PMount=
union{
box{
<0.3,1.4,0.5>
<-0.3,3,-0.5>}
cylinder{
<0,3,0><0,3,-3>0.2}
cylinder{
<0,3,-2.9><0,3,-4.5>0.3}
texture {Metalfarve}}

#declare TPeasant=
difference{
object{Pbuttom}
object{Pfoot
pigment {Gray20}
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*120
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*240
scale 1.1}}

#declare TransformPeasant=
union{
difference{
object{PMount}
cylinder{
<0,3,-3><0,3,-5>0.25
pigment {Gray20}}}

object{TPeasant
rotate y*30}

object{
Ptop2
translate y*-2
rotate x*90
translate y*3}

object{Pfeet}}

//---------------Nearly Transformed Peasant----------
#declare Ptop1=
intersection{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.5,0><0,6.9,0>2
texture{Whitecol}}}

#declare Ptop2=
difference{
object{Ptop1}
box{
<0.3,1.4,3>
<-0.3,4,-3>
pigment {Gray20}}}

#declare Pbuttom=
difference{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.51,0><0,15,0>3
texture{Whitecol}}}

#declare Pfoot=
intersection{
object {Peasant
texture{Whitecol}}

cone{
<0,-2,0>1<0,2,0>0
rotate z*20
translate <1.3,2,0>}}


#declare Pfeet=
union{
object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-95
translate x*1.2
rotate y*150
scale 0.8}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-95
translate x*1.2
rotate y*30
scale 0.8}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-95
translate x*1.2
rotate y*270
scale 0.8}}

#declare PMount=
union{
box{
<0.3,1.4,0.5>
<-0.3,3,-0.5>}
cylinder{
<0,3,0><0,3,-3>0.2}
cylinder{
<0,3,-2.9><0,3,-3.5>0.3}
texture {Metalfarve}}

#declare TPeasant=
difference{
object{Pbuttom}
object{Pfoot
pigment {Gray20}
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*120
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*240
scale 1.1}}

#declare TransformPeasant2=
union{
difference{
object{PMount}
cylinder{
<0,3,-3><0,3,-5>0.25
pigment {Gray20}}}

object{TPeasant
rotate y*30}

object{
Ptop2
translate y*-2
rotate x*70
translate y*2.8}

object{Pfeet}}

//--------------Half-way tranformed Peasant--------------
#declare Ptop1=
intersection{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.5,0><0,6.9,0>2
texture{Whitecol}}}

#declare Ptop2=
difference{
object{Ptop1}
box{
<0.3,1.4,3>
<-0.3,4,-3>
pigment {Gray20}}}

#declare Pbuttom=
difference{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.51,0><0,15,0>3
texture{Whitecol}}}

#declare Pfoot=
intersection{
object {Peasant
texture{Whitecol}}

cone{
<0,-2,0>1<0,2,0>0
rotate z*20
translate <1.3,2,0>}}


#declare Pfeet=
union{
object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-55
translate x*1.6
rotate y*150
scale 0.9}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-55
translate x*1.6
rotate y*30
scale 0.9}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-55
translate x*1.6
rotate y*270
scale 0.9}}

#declare PMount=
union{
box{
<0.3,1.4,0.5>
<-0.3,3,-0.5>}
cylinder{
<0,3,0><0,3,-1.5>0.2}
cylinder{
<0,3,-1.4><0,3,-2>0.3}
texture {Metalfarve}}

#declare TPeasant=
difference{
object{Pbuttom}
object{Pfoot
pigment {Gray20}
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*120
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*240
scale 1.1}}

#declare TransformPeasant3=
union{
difference{
object{PMount}
cylinder{
<0,3,-1.8><0,3,-5>0.25
pigment {Gray20}}}

object{TPeasant
rotate y*30}

object{
Ptop2
translate y*-2
rotate x*40
translate y*2.5}

object{Pfeet}}

//-----------------First step transforming peasant------
#declare Ptop1=
intersection{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.5,0><0,6.9,0>2
texture{Whitecol}}}

#declare Ptop3=
difference{
object{Ptop1
scale 0.8
translate y*0.3}
box{
<0.05,1.4,3>
<-0.05,4,-3>
pigment {Gray20}}}

#declare Ptop2=
union{
object{Ptop3}
difference{
object{Ptop1}
box{
<0.3,1.4,3>
<-0.3,4,-1>
pigment {Gray20}}}}


#declare Pbuttom=
difference{
object{Peasant
texture{Whitecol}}
cylinder{
<0,1.51,0><0,15,0>3
texture{Whitecol}}}

#declare Pfoot=
intersection{
object {Peasant
texture{Whitecol}}

cone{
<0,-2,0>1<0,2,0>0
rotate z*20
translate <1.3,2,0>}}


#declare Pfeet=
union{
object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-15
translate x*2.1
rotate y*150
scale 0.9}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-15
translate x*2.1
rotate y*30
scale 0.9}

object{Pfoot
texture {Metalfarve}    
translate x*-2
rotate z*-15
translate x*2.1
rotate y*270
scale 0.9}}


#declare TPeasant=
difference{
object{Pbuttom}
object{Pfoot
pigment {Gray20}
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*120
scale 1.1}
object{Pfoot
pigment {Gray20}
rotate y*240
scale 1.1}}

#declare TransformPeasant4=
union{
//object{PMount}

object{TPeasant
rotate y*30}

object{
Ptop2
translate y*-2
rotate x*10
translate y*2.1}

object{Pfeet}}

//-----------------Transformed Tower------------------


#declare Right=
intersection{
object{Tow
hollow on}
sphere{
<0,0,0>2
scale <0.3,1,0.7>
translate <1.5,4.5,0>}
texture{ Whitecol}
translate x*1.8}

#declare Rightarm=
difference{
object{Right}
object{Right
translate x*-0.2
scale <1,1,1.2>}}

#declare Left=
intersection{
object{Tow
hollow on}
sphere{
<0,0,0>2
scale <0.3,1,0.7>
translate <-1.5,4.5,0>}
texture{ Whitecol}
translate x*-1.8}

#declare Leftarm=
difference{
object{Left}
object{Left
translate x*0.2
scale <1,1,1.2>}}

#declare Maintower=
difference{
object{Tow
texture{ Whitecol}}
sphere{
<0,0,0>2
texture{Metalfarve}
scale <0.3,1,0.5>
translate <1.5,4.5,0>}
sphere{
<0,0,0>2
texture{Metalfarve}
scale <0.3,1,0.5>
translate <-1.5,4.5,0>}
}

#declare Mtop=
intersection{
sphere{
<0,0,0>2
scale <0.3,0.3,1>
texture {Metalfarve}}
cone{
<0,0,-2.1>0.6
<0,0,-1.2>0.6
texture{Metalfarve}}
}

#declare Mbut=
union{
cylinder{
<0,0,2.1>
<0,0,1.2>0.6
pigment{Red}}

intersection{
cone{
<0,0,2.5>1
<0,0,1.2>0.6}
box{
<0.1,-1.1,2.5>
<-0.1,1.1,-2.5>}
pigment{Red}} 

intersection{
cone{
<0,0,2.5>1
<0,0,1.2>0.6}
box{
<0.1,-1.1,2.5>
<-0.1,1.1,-2.5>}
pigment{Red}
rotate z*90}}

#declare Misil=
union{
sphere{
<0,0,0>2
scale <0.3,0.3,1>
pigment {White}
}
object{Mtop
scale 1.1}
object{Mbut}
}

#declare Transtower=
union{
object{Leftarm}
object{Rightarm}
object{Maintower}

box{
<3,4,0.5>
<-3,5,-0.5>
texture{Metalfarve}}

object{Misil
translate <1.7,5.5,0>}

object{Misil
translate <1.7,3.5,0>}

object{Misil
translate <-1.7,5.5,0>}

object{Misil
translate <-1.7,3.5,0>}
}

//------------------------Transformed Springer-----------------
#declare Springer=
lathe
{linear_spline
14,
<0,0>, <2.5,0>, <2.5, 0.5>, <1, 1.5>, <1.5, 2>, <0.7, 2.5>,
<1.2, 7>, <0.5, 8.3>, <1, 8.5>, <0.5, 8.7>, <1, 9.2>, <1, 10>,
<0.5, 10.5>, <0, 10.5>
}

#declare Rights=
intersection{
object{Springer
texture{Whitecol}}
sphere{
<0,0,0>4
scale <0.1,0.7,0.2>
texture {Metalfarve}
translate <0.8,4.1,0>}
rotate x*-120
translate <1.4,7,3>}

#declare Rightarms=
difference{
object{Rights}
object{Rights
translate x*-0.1
texture{Metalfarve}}

}

#declare Lefts=
intersection{
object{Springer
texture{Whitecol}}
sphere{
<0,0,0>4
scale <0.1,0.7,0.2>
texture {Metalfarve}
translate <-0.8,4.1,0>}
rotate x*-120
translate <-1.4,7,3>}

#declare Leftarms=
difference{
object{Lefts}
object{Lefts
translate x*0.1
texture{Metalfarve}}

}

#declare Mainspringer=
difference{
object{Springer
texture{Whitecol}}
sphere{
<0,0,0>4
scale <0.1,0.7,0.2>
texture {Metalfarve}
translate <0.9,4.5,0>}
sphere{
<0,0,0>4
scale <0.1,0.7,0.2>
texture {Metalfarve}
translate <-0.9,4.5,0>}}

#declare Barrel=
cylinder{
<0.3,0,0>
<0.3,0,-4>0.2}

#declare Barrel2=
cylinder{
<0.3,0,-0.1>
<0.3,0,-4.1>0.18}

#declare Obarrel=
union{
object{Barrel}
object{Barrel
rotate z*60}
object{Barrel
rotate z*120}
object{Barrel
rotate z*180}
object{Barrel
rotate z*240}
object{Barrel
rotate z*300}
  texture{
pigment {color rgb 4*<0.30, 0.30, 0.45>}
finish {
    ambient 0.25
    brilliance 1
    diffuse 0.5
    metallic
    phong 0.9
    phong_size 30
    reflection 0.2 
 }}}

#declare Ibarrel=
union{
object{Barrel2}
object{Barrel2
rotate z*60}
object{Barrel2
rotate z*120}
object{Barrel2
rotate z*180}
object{Barrel2
rotate z*240}
object{Barrel2
rotate z*300}
pigment{Black}}

#declare Minigun=
union{
superellipsoid
{
  <0.2, 
  0.2>
  texture{
pigment {color rgb <0.30, 0.30, 0.45>}
normal {bump_map{ tga "metalmap.tga"
bump_size 33}
scale 2
rotate z*45}
finish {
    ambient 0.25
    brilliance 3
    diffuse 0.5
    metallic
    phong 0.7
    phong_size 30
    reflection 0.1 
 }}
 scale <0.7,0.7,1>
}
difference{
object{Obarrel}
object{Ibarrel}}
scale <0.5,0.5,1>}

#declare Transspringer=
union{
object{Minigun
rotate y*-7
rotate x*-30
translate <1.5, 5.8, 0>}

object{Minigun
rotate y*7
rotate x*-30
translate <-1.5, 5.8, 0>}

object{Rightarms}
object{Leftarms}
object{Mainspringer}}

#declare Blob=
sphere{
<0,-100,0>0.1
pigment{Black}}
Blob

//----------------------------Transformed Horse----------------------------
 #declare THest0=
 union
 {
 box
 {<-0.5, 1, 0.5>
  <0.5,  2, -2.5>
  }
  box
  {<-0.5, 0, 0>
   <0.5, 1, -1.8>
   rotate x*330
   translate <0, 2, 0.5>}
   }
   
   #declare THest1=
   difference
   {
   object{THest0}
   
   cylinder
   {<-1, 1.4, -2.5>
    < 1, 1.4, -2.5>, 0.2
    }
     cylinder
   {<0, 2.2, -3>
    <0, 3, 1>, 0.4
    }
    translate y*-1
    scale 1.5
    }

#declare Tsplith=
intersection{
object{THest1}
box{
<0,-3,-4>
<3,3,4>}
}

#declare Tsplitv=
intersection{
object{THest1}
box{
<0,-3,-4>
<-3,3,4>}
}
    
#declare THest=
union
{lathe
{linear_spline
8,
<0, 0>,   <2, 0>, <1.5, 0.5>, <1.5, 1>,
<1, 1.5>, <1.2, 5>, <0.5,6.5>,
<0,6.5>}
object
{Tsplith
rotate z*70
translate y*5.8
translate x*-0.25}
object{Tsplitv
rotate z*-70
translate y*5.8
translate x*0.25}}

#declare Mcase=
difference{
box{
<1.7,6.5,-1.5>
<-1.7,9.5,.5>
texture{Metalfarve}}
box{
<1.5, 9.3,-2>
<0.9, 8.7, 2>
pigment {Black}}
box{
<0.7, 9.3,-2>
<0.1, 8.7, 2>
pigment {Black}}
box{
<-0.7, 9.3,-2>
<-0.1, 8.7, 2>
pigment {Black}}
box{
<-1.5, 9.3,-2>
<-0.9, 8.7, 2>
pigment {Black}}
box{
<1.5, 8.5,-2>
<0.9, 7.9, 2>
pigment {Black}}
box{
<0.7, 8.5,-2>
<0.1, 7.9, 2>
pigment {Black}}
box{
<-0.7, 8.5,-2>
<-0.1, 7.9, 2>
pigment {Black}}
box{
<-1.5, 8.5,-2>
<-0.9, 7.9, 2>
pigment {Black}}
box{
<-1.5, 9.3,-2>
<-0.9, 8.7, 2>
pigment {Black}}
box{
<1.5, 7.7,-2>
<0.9, 7.1, 2>
pigment {Black}}
box{
<0.7, 7.7,-2>
<0.1, 7.1, 2>
pigment {Black}}
box{
<-0.7, 7.7,-2>
<-0.1, 7.1, 2>
pigment {Black}}
box{
<-1.5, 7.7,-2>
<-0.9, 7.1, 2>
pigment {Black}}}

#declare Mtop=
intersection{
sphere{
<0,0,0>2
scale <0.3,0.3,1>
texture {Metalfarve}}
cone{
<0,0,-2.1>0.6
<0,0,-1.2>0.6
texture{Metalfarve}}
}

#declare Misil=
union{
sphere{
<0,0,0>2
scale <0.3,0.3,1>
pigment {White}
}
object{Mtop
scale 1.1}
}

#declare Misiletop=
union{
#declare Index1 = -1.2;
#while(Index1 <= 1.5)

   #declare Index2 = 7.4;
   #while(Index2 <= 9.2)

      object{Misil
      scale 0.7
      translate <Index1, Index2, -0.8>}

      #declare Index2 = Index2 + 0.8;
   #end

   #declare Index1 = Index1 + 0.8;
#end
object{Mcase}}

#declare Hlight=
union{
difference{
sphere{
<0,0,0>2}
sphere{
<0,0,0>1.7}
plane{y, 0}
plane{z, 0}
texture{Metalfarve}}

difference{
sphere{
<0,0,0>1.7}
plane{y, 0}
plane{z, 0.5}
texture{pigment {
    brick rgb <1,0.9,0.2>, rgb <1,1,0.7>
  }
  normal {
    brick normal{bumps 0.2}, normal{granite 0.3}
  }
finish {ambient 2}
scale 0.1}}}



#declare Transhest=
union{
object{Misiletop}
object {THest
texture {Whitecol}}
object{Hlight
scale <0.3,0.3,0.8>
translate <-1.1,9.5,-1.5>}
object{Hlight
scale <0.3,0.3,0.8>
translate <1.1,9.5,-1.5>}}

//----------------------------------HQ King-------------------------------
#declare Tking0=
union
{lathe
{linear_spline
16,
<0,0>, <2.5,0>, <2.5, 0.5>, <1.5, 1>, <2, 1.3>, <1, 1.7>, <1.5, 2>, <0.7, 2.5>,
<1.2, 7>, <0.5, 9.3>, <1, 9.5>, <0.5, 9.7>, <1, 10.2>, <1, 11>,
<0.5, 11.5>, <0, 11.5>}
difference
{lathe
{linear_spline
5,
<1, 10.5>, <1.3, 10.5>, <1.3, 11.3>, <1, 11.3>, <1, 10.5>}
box
{<-2, 11, -0.3>
 < 2, 11.5,0.3>}
box
{<-2, 11, -0.3>
 < 2, 11.5,0.3>
 rotate y*60}
box
{<-2, 11, -0.3>
 < 2, 11.5,0.3>
 rotate y*120}}
}

#declare Tking=
union
{object{Tking0}
box{
<-0.25, 11, -0.25>
<0.25,  13, 0.25>
}
box{
<-0.75, 12, -0.25>
< 0.75, 12.5 0.25>
}}

#declare TransKing=
union{
difference{
object{Tking
texture{Whitecol}}
box{
<2,6,-0.6>
<-2,8,-3>
pigment{  image_map {
    tga "target.tga"}
    scale 2
    translate <1.2,-0.6,0>}
finish {ambient 1}
}}

intersection{
object{Tking
texture{Whitecol}}
box{
<2,6,-0.6>
<-2,8,-3>
texture {checker texture{T_Grnt5},texture{T_Grnt7}
         scale 0.5 }}
translate <0,-6,0.6>
rotate x*-90
translate <0,6,-0.6>}

object{
Tow
scale 0.18
translate <0,6,-1.9>
pigment {rgbt <0.3,0.8,0.3,0.7>}
finish {ambient 1.5}}
cone{
<0,10.5,-1.1>0.1
<0,5.9,-2.1>0.6
pigment {rgbf <0.8,1,0.3,0.9>}
finish {ambient 3}}
}

//-------------------------------Electrified Queen------------------
#declare PQueen=
union{
difference{
object{Queen
texture {Whitecol
finish {ambient 0.5}}}
box{
<0.3,6.8,3>
<-0.3,6,-3>
texture{Metalfarve}}
box{
<3,8,0.3>
<-3,7.2,-0.3>
texture{Metalfarve}}
box{
<0.3,9,3>
<-0.3,8.4,-3>
texture{Metalfarve}}
box{
<3,5.8,0.3>
<-3,5,-0.3>
texture{Metalfarve}}}

union{
box{
<0.1,6.8,1>
<-0.1,6,-1>}
box{
<1,8,0.1>
<-1,7.2,-0.1>}
box{
<0.1,9,0.7>
<-0.1,8.4,-0.7>}
box{
<1,5.8,0.1>
<-1,5,-0.1>}
texture{Metalfarve}}

intersection{
difference{
object{Queen
texture {Whitecol
finish {ambient 0.8}}
scale 1.005}
object{Queen
texture {Whitecol}}}
box{
<0.3,6.8,3>
<-0.3,6,-3>}
scale <1,1,1.4>}

intersection{
difference{
object{Queen
texture {Whitecol
finish {ambient 0.8}}
scale 1.005}
object{Queen
texture {Whitecol}}}
box{
<3,8,0.3>
<-3,7.2,-0.3>}
scale <1.4,1,1>}

intersection{
difference{
object{Queen
texture {Whitecol
finish {ambient 0.8}}
scale 1.005}
object{Queen
texture {Whitecol}}}
box{
<0.3,9,3>
<-0.3,8.4,-3>}
scale <1,1,1.4>}

intersection{
difference{
object{Queen
texture {Whitecol
finish {ambient 0.8}}
scale 1.005}
object{Queen
texture {Whitecol}}}
box{
<3,5.8,0.3>
<-3,5,-0.3>}
scale <1.4,1,1>}

union{
cone{
<0,6.4,-1>0.2
<0,6.4,-3>0}
cone{
<0,6.4,1>0.2
<0,6.4,3>0}
cone{
<-1,7.6,0>0.2
<-3,7.6,0>0}
cone{
<1,7.6,0>0.2
<3,7.6,0>0}
cone{
<0,8.7,-1>0.2
<0,8.7,-3>0}
cone{
<0,8.7,1>0.2
<0,8.7,3>0}
cone{
<-1,5.4,0>0.2
<-3,5.4,0>0}
cone{
<1,5.4,0>0.2
<3,5.4,0>0}     
texture{Brushed_Aluminum}                
texture{
  pigment{agate
           agate_turb 0.5
        color_map{
                [0.03 rgb 2]
                [0.05 rgb <0.75,0.85,0.85>]
                [0.1 MediumBlue]
                [0.15 rgbt <0,0,0,1>]}
                scale 3}}
}}


#declare MediaQueen=
difference{
object{Queen
scale <1.3,1.02,1.3>}
object{Queen}
   texture {
      pigment { color rgb 1 transmit 1 }
      finish { ambient 0 }
   }
   interior {
      media {
         emission 3
         intervals 50
      density {
        agate
        density_map {
          [0.2 White]
          [0.2 rgb <0.75,0.85,0.85>]
          [0.6 rgbt <0,0,0,1>]
        }
      }
    } 
  }
  

  hollow
  scale <1.05,1+1/9999,1.05> 
}

//Black Pieces          

object{
Tow
  texture {SortFarve}
  scale 0.3
  translate <-7, 0, 7>} 
  
 object
 {Tow
  texture {Blackcol}
  finish {ambient 0.2}
  scale 0.3
  translate <1, 0, -1>}
  
 object
 {Hest
  texture {SortFarve}
  scale 0.3
  translate <5, 0, 7>} 

 object
 {Hest
  texture {SortFarve}
  scale 0.3
  translate <-5, 0, 7>}
  
 object
 {Springer
  texture {SortFarve}
  scale 0.3
  translate <-3, 0, 7>}  

 object
 {Springer
  texture {SortFarve}
  scale 0.3
  translate < 3, 0, 7>}
  
 object
 {Queen
  texture {SortFarve}
  scale 0.3
  translate < -1, 0, 7>} 
  
 object
 {King
  texture {SortFarve}
  scale 0.3
  translate < 1, 0, 7>} 
    
 object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <-7, 0, 5>}
  
    object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <-5, 0, 5>}
  
   object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <-3, 0, 5>}
  
   object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <-1, 0, 5>}
  
   object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <1, 0, 1>}
  
   object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <3, 0, 5>}
  
   object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <5, 0, 5>}
  
   object
 {Peasant
 texture {SortFarve}
 scale 0.3
 translate <7, 0, 5>}
  
 // White Pieces
 
 object
 {Transtower
  rotate 240*y
  scale 0.3
  translate <-7, 0, -7>} 
  
 object
 {Transtower
 rotate 135*y
  scale 0.3
  translate <7, 0, -7>}
  
 object
 {Transhest
  rotate 150*y
  scale 0.3
  translate <5, 0, -7>} 

 object
 {Transhest
  rotate 225*y
  scale 0.3
  translate <-5, 0, -7>}
  
 object
 {Transspringer
 rotate y*220
  scale 0.3
  translate <-3, 0, -7>}  

 object
 {Transspringer
 rotate y*160
  scale 0.3
  translate < 3, 0, -7>}
  
 object
 {object{PQueen}
  scale 0.3
  translate < -1, 0, -7>}
difference{
object{
Queen 
scale <1.3,1.02,1.3>
  pigment{agate
           agate_turb 1.1
        color_map{
                [0.03 rgb 2]
                [0.05 rgb <0.75,0.85,0.85>]
                [0.1 MediumBlue]
                [0.15 rgbt <0,0,0,1>]}
                scale 3}
  finish {ambient 1}
  scale <1.051,1+2/9999,1.051>
  hollow
  }
  plane{y, 2.5}
  scale 0.3
  translate < -1, 0, -7>}
 object
 {object{MediaQueen}
  scale 0.3
  translate < -1, 0, -7>} 
  
 object
 {TransKing
 rotate y*180
  scale 0.3
  translate < 1, 0, -7>} 
    
object{TransformPeasant
 rotate y*235
 scale 0.3
 translate <-7, 0, -5>}
  
object{TransformPeasant3
 rotate y*225
 scale 0.3
 translate <-3, 0, -5>}
  
object{TransformPeasant2
 rotate y*215
 scale 0.3
 translate <-5, 0, -5>}
  
object{TransformPeasant4
 rotate y*205
 scale 0.3
 translate <-1, 0, -5>}
  
object{TransformPeasant
 rotate y*125
 scale 0.3
 translate <7, 0, -5>}
  
object{TransformPeasant2
 rotate y*135
 scale 0.3
 translate <5, 0, -5>}
  
object{TransformPeasant3
 rotate y*160              
 scale 0.3
 translate <3, 0, -5>}
 

//-------------Peasant Knocked over--------------
 object
 {Peasant
 texture {Whitecol}
  rotate x*-90
 translate y*2
 rotate x*-15
 rotate y*-55
 scale 0.3
 translate <2.4, 0, -1.7>}
 
 object{Cbox
 scale 0.5
 rotate y*-50
 translate <5,0,0>}
