//***************************************************
// Persistence Of Vision raytracer version 3.5 bata
// Astrobio definition type 0.1a010917a include file
// By S.Nishimura
//***************************************************


//**********************************************************************************
// astrobio
#local Life_txt =
union {
prism {
 linear_sweep
 bezier_spline 0,1,68
 <-0.216,1.278><-0.148,1.276><-0.09,1.262><-0.042,1.238>
 <-0.042,1.238><0.006,1.213><0.03,1.181><0.03,1.142>
 <0.03,1.142><0.03,1.111><0.002,1.053><-0.052,0.97>
 <-0.052,0.97><-0.106,0.887><-0.139,0.835><-0.152,0.813>
 <-0.152,0.813><-0.152,0.813><-0.37,0.487><-0.37,0.487>
 <-0.37,0.487><-0.416,0.431><-0.456,0.384><-0.49,0.345>
 <-0.49,0.345><-0.523,0.306><-0.56,0.269><-0.599,0.234>
 <-0.599,0.234><-0.638,0.198><-0.68,0.17><-0.725,0.147>
 <-0.725,0.147><-0.77,0.125><-0.816,0.114><-0.862,0.114>
 <-0.862,0.114><-0.862,0.114><-1.003,0.114><-1.003,0.114>
 <-1.003,0.114><-0.879,0.181><-0.77,0.266><-0.677,0.372>
 <-0.677,0.372><-0.584,0.477><-0.499,0.592><-0.422,0.716>
 <-0.422,0.716><-0.345,0.84><-0.285,0.942><-0.242,1.022>
 <-0.242,1.022><-0.2,1.102><-0.178,1.152><-0.178,1.172>
 <-0.178,1.172><-0.178,1.194><-0.182,1.212><-0.188,1.226>
 <-0.188,1.226><-0.194,1.241><-0.203,1.253><-0.216,1.265>
 <-0.216,1.265><-0.216,1.265><-0.216,1.278><-0.216,1.278>
 }
prism {
 linear_sweep
 bezier_spline 0,1,72
 <0.008,0.862><0.047,0.862><0.1,0.853><0.165,0.836>
 <0.165,0.836><0.231,0.818><0.296,0.795><0.361,0.768>
 <0.361,0.768><0.425,0.74><0.489,0.707><0.551,0.669>
 <0.551,0.669><0.613,0.632><0.68,0.587><0.753,0.535>
 <0.753,0.535><0.826,0.483><0.886,0.431><0.933,0.38>
 <0.933,0.38><0.98,0.329><1.003,0.278><1.003,0.227>
 <1.003,0.227><1.003,0.209><0.999,0.192><0.991,0.176>
 <0.991,0.176><0.983,0.159><0.975,0.151><0.966,0.151>
 <0.966,0.151><0.932,0.151><0.899,0.162><0.867,0.184>
 <0.867,0.184><0.836,0.206><0.801,0.23><0.762,0.255>
 <0.762,0.255><0.724,0.281><0.687,0.3><0.651,0.312>
 <0.651,0.312><0.614,0.324><0.567,0.335><0.508,0.343>
 <0.508,0.343><0.547,0.346><0.58,0.349><0.606,0.352>
 <0.606,0.352><0.631,0.355><0.645,0.36><0.647,0.367>
 <0.647,0.367><0.514,0.48><0.39,0.575><0.277,0.653>
 <0.277,0.653><0.163,0.73><0.05,0.796><-0.064,0.849>
 <-0.064,0.849><-0.055,0.856><-0.045,0.859><-0.034,0.86>
 <-0.034,0.86><-0.024,0.862><-0.009,0.862><0.008,0.862>
 }
prism {
 linear_sweep
 bezier_spline 0,1,140
 <0.054,0.433><0.094,0.433><0.133,0.427><0.169,0.413>
 <0.169,0.413><0.205,0.4><0.224,0.373><0.224,0.333>
 <0.224,0.333><0.224,0.32><0.193,0.304><0.133,0.284>
 <0.133,0.284><0.073,0.264><0.028,0.248><-0.002,0.235>
 <-0.002,0.235><-0.033,0.223><-0.065,0.205><-0.101,0.181>
 <-0.101,0.181><-0.136,0.156><-0.173,0.126><-0.21,0.091>
 <-0.21,0.091><-0.247,0.055><-0.279,0.021><-0.307,-0.012>
 <-0.307,-0.012><-0.334,-0.046><-0.358,-0.083><-0.377,-0.125>
 <-0.377,-0.125><-0.369,-0.13><-0.349,-0.145><-0.319,-0.172>
 <-0.319,-0.172><-0.289,-0.199><-0.262,-0.213><-0.239,-0.215>
 <-0.239,-0.215><-0.218,-0.213><-0.194,-0.195><-0.167,-0.16>
 <-0.167,-0.16><-0.141,-0.126><-0.123,-0.105><-0.114,-0.099>
 <-0.114,-0.099><-0.128,-0.139><-0.139,-0.176><-0.146,-0.21>
 <-0.146,-0.21><-0.153,-0.244><-0.158,-0.285><-0.162,-0.331>
 <-0.162,-0.331><-0.166,-0.378><-0.172,-0.417><-0.181,-0.448>
 <-0.181,-0.448><-0.189,-0.479><-0.211,-0.494><-0.244,-0.494>
 <-0.244,-0.494><-0.262,-0.494><-0.287,-0.459><-0.319,-0.39>
 <-0.319,-0.39><-0.351,-0.32><-0.376,-0.285><-0.393,-0.285>
 <-0.393,-0.285><-0.416,-0.285><-0.436,-0.292><-0.452,-0.307>
 <-0.452,-0.307><-0.468,-0.321><-0.484,-0.343><-0.501,-0.373>
 <-0.501,-0.373><-0.518,-0.403><-0.532,-0.427><-0.544,-0.446>
 <-0.544,-0.446><-0.555,-0.465><-0.568,-0.487><-0.582,-0.511>
 <-0.582,-0.511><-0.597,-0.535><-0.611,-0.556><-0.626,-0.572>
 <-0.626,-0.572><-0.641,-0.589><-0.658,-0.597><-0.678,-0.597>
 <-0.678,-0.597><-0.692,-0.597><-0.702,-0.587><-0.707,-0.566>
 <-0.707,-0.566><-0.713,-0.545><-0.715,-0.522><-0.715,-0.498>
 <-0.715,-0.498><-0.715,-0.427><-0.696,-0.367><-0.657,-0.32>
 <-0.657,-0.32><-0.618,-0.272><-0.574,-0.221><-0.526,-0.167>
 <-0.526,-0.167><-0.479,-0.112><-0.428,-0.045><-0.374,0.034>
 <-0.374,0.034><-0.319,0.114><-0.284,0.164><-0.268,0.184>
 <-0.268,0.184><-0.313,0.193><-0.349,0.202><-0.376,0.21>
 <-0.376,0.21><-0.404,0.219><-0.43,0.23><-0.455,0.244>
 <-0.455,0.244><-0.455,0.244><-0.452,0.257><-0.452,0.257>
 <-0.452,0.257><-0.416,0.27><-0.326,0.303><-0.182,0.355>
 <-0.182,0.355><-0.037,0.407><0.041,0.433><0.054,0.433>
 }
prism {
 linear_sweep
 bezier_spline 0,1,120
 <0.173,-0.524><0.169,-0.55><0.163,-0.614><0.154,-0.714>
 <0.154,-0.714><0.146,-0.815><0.136,-0.897><0.124,-0.96>
 <0.124,-0.96><0.113,-1.023><0.097,-1.083><0.075,-1.138>
 <0.075,-1.138><0.053,-1.194><0.025,-1.24><-0.01,-1.278>
 <-0.01,-1.278><-0.01,-1.251><-0.006,-1.18><0.002,-1.065>
 <0.002,-1.065><0.01,-0.95><0.014,-0.869><0.014,-0.822>
 <0.014,-0.822><0.014,-0.822><0.014,-0.237><0.014,-0.237>
 <0.014,-0.237><0.014,-0.202><0.004,-0.172><-0.014,-0.147>
 <-0.014,-0.147><-0.033,-0.121><-0.056,-0.1><-0.082,-0.085>
 <-0.082,-0.085><-0.082,-0.085><-0.08,-0.073><-0.08,-0.073>
 <-0.08,-0.073><-0.012,-0.034><0.056,-0.005><0.124,0.015>
 <0.124,0.015><0.193,0.034><0.264,0.044><0.337,0.044>
 <0.337,0.044><0.405,0.044><0.469,0.028><0.53,-0.005>
 <0.53,-0.005><0.591,-0.037><0.622,-0.087><0.622,-0.156>
 <0.622,-0.156><0.622,-0.227><0.586,-0.31><0.515,-0.405>
 <0.515,-0.405><0.443,-0.499><0.369,-0.55><0.293,-0.556>
 <0.293,-0.556><0.27,-0.556><0.249,-0.553><0.23,-0.547>
 <0.23,-0.547><0.211,-0.54><0.192,-0.533><0.173,-0.524>
 <0.173,-0.524><0.173,-0.524><0.186,-0.473><0.186,-0.473>
 <0.186,-0.473><0.193,-0.473><0.198,-0.474><0.202,-0.476>
 <0.202,-0.476><0.265,-0.476><0.319,-0.428><0.363,-0.333>
 <0.363,-0.333><0.407,-0.237><0.43,-0.166><0.43,-0.118>
 <0.43,-0.118><0.43,-0.087><0.421,-0.066><0.405,-0.054>
 <0.405,-0.054><0.389,-0.042><0.37,-0.036><0.348,-0.036>
 <0.348,-0.036><0.305,-0.036><0.264,-0.046><0.226,-0.066>
 <0.226,-0.066><0.187,-0.085><0.14,-0.112><0.083,-0.147>
 <0.083,-0.147><0.127,-0.171><0.154,-0.211><0.162,-0.268>
 <0.162,-0.268><0.17,-0.324><0.174,-0.392><0.174,-0.47>
 <0.174,-0.47><0.175,-0.472><0.18,-0.473><0.186,-0.473>
 <0.186,-0.473><0.186,-0.473><0.173,-0.524><0.173,-0.524>
 }
}
coordinate_color(150,0.3,0.9,1,9) 
#local Obj_seg =
object { Life_txt
  pigment { color rgbf <R9,G9,B9,1> }
  finish { ambient 0.1
           diffuse 0.1
           reflection 0.2
           specular 1
           roughness 0.001
           irid { 0.2 thickness 0.1 turbulence 0.8 } }
  interior { ior 1.25 fade_distance 50 fade_power 1 caustics 0.8 }
  rotate 180*y scale < 1,0.6,1 >*4
}
//----------------------------------------------------------------------------------
#include "Normal_surface.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Pr=20+1;
          #local Px=Pr*cos(Se)*cos(Ss); #local Py=Pr*sin(Se); #local Pz=Pr*cos(Se)*sin(Ss); #break
 
 #case(1) #local Pr=1-Se/(6*pi); #local Sc=0.8;
          #local Px= Sc*(2+pow(2.2,Pr)*cos(Ss))*Pr*cos(Se);
          #local Py=-Sc*(pow(2.2,Pr)*sin(Ss)*Pr+15*pow(0.1+Se/(6*pi),0.15)-10);
          #local Pz= Sc*-(2+pow(2.2,Pr)*cos(Ss))*Pr*sin(Se);#break
 #end
#end
//----------------------------------------------------------------------------------
#declare Astrobio_piece = Normal_tri2u(pi*< -1, 1, 1/4 >,pi*< -1/3, 1/3.6, 1/8 >,0)
//object { Astrobio_piece rotate <0,30,90> translate 160*x }
//
#local Astrobio_abd = Surface_tri4m(pi*<-1,1,1/8>,pi*<0,5,1/8>,1)
//**********************************************************************************
#ifndef(T_astrobio) #local T_astrobio = texture { pigment { color rgb <1,0,0> } } #end
#ifndef(I_astrobio) #local I_astrobio = interior { ior 1.0 } #end
//  
#local Astrobio_hed =
union {
 difference { sphere { 0,7.76 } sphere { 0,2.2 translate -7.76*x } }
 sphere { 0,2 texture { T_astrobio } interior { I_astrobio } translate < -4,3, 4 > }
 sphere { 0,2 texture { T_astrobio } interior { I_astrobio } translate < -4,3,-4 > }
}
//**********************************************************************************
#include "Space_line.mcr.inc"
//----------------------------------------------------------------------------------
#macro Line_function(Tp,Vp,Func_type)
 #switch(Func_type)
  #case(1) #local Px=10*Tp; #local Py=12*1/Tp*sin(Tp); #local Pz=0; #break
 #end
 #local Vp=< Px,Py,Pz >;
#end
//----------------------------------------------------------------------------------
#local Astrobio_leg =
merge {
 torus { 12,1 clipped_by { plane { x,0 } } rotate -90*x }
 Cone_line(2,pi*< -1e-12, 4, 1/6 >,pi*< 1/3, 1/2.2, 0 >,1)
 translate 12*y
}
//**********************************************************************************
#declare Astrobio_seg =
union {
 object { Astrobio_abd scale 4 rotate < 90,180,-90 > translate <0,-6,-1> }
 object { Astrobio_hed }
 #local Ei=6; #local Si=0; #while(Si<Ei)
  object { Astrobio_leg rotate (-45+90*Si/Ei)*x }
  object { Astrobio_leg rotate 180*x rotate (-45+90*Si/Ei)*x }
 #local Si=Si+1; #end
}
//**********************************************************************************
//object { Astrobio_obj pigment { color rgb 1 } rotate -90*y translate -25*z }
//**********************************************************************************