// POV-Ray ver 3.5 bata
// Satellite weapon Scene File
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


// CAMERA
camera { location < 0, 0, -200 > 
         look_at 0 
         angle 50 }

// LIGHT
light_source { < 200, 350, -340 > color rgb 1 fade_distance 400 fade_power 1 }
light_source { <   0,   0, -240 > color rgb 1 shadowless }

//**********************************************************************************
coordinate_color( 120, 0.3, 0.5, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
coordinate_color(330,1,0.5,1,1)
coordinate_color(120,1,0.5,1,2)
coordinate_color(360,1,1.0,1,3)
#local T_Gradient =
texture {
 pigment { gradient x
           color_map { [0.00 rgb < R1,G1,B1 > ]
                       [0.33 rgb < R2,G2,B2 > ]                     
                       [0.66 rgb < R3,G3,B3 > ] } }
 finish { ambient 0 diffuse 0 reflection 0.8 }
}
//
coordinate_color(255,0.90,0.90,1,4)
coordinate_color(255,0.91,0.78,1,5)
coordinate_color(255,0.92,0.56,1,6)
#local T_Lightening =
texture {
 pigment { granite 
           turbulence 0.5
           color_map { [0.00 rgbf <1,1,1,0>]
                       [0.10 rgbf <R4, G4, B4, 0.65>]
                       [0.20 rgbf <R4, G4, B4, 0.65>]
                       [0.30 rgbf <R5, G5, B5, 0.85>]
                       [0.45 rgbf <R5, G5, B5, 0.85>]
                       [0.65 rgbf <R6, G6, B6, 0.95>] } }
 finish { ambient 1 }
}
//**********************************************************************************
#local P_Cloud_a =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0, 0.1 color rgb <.85, .85, .85> color rgb <.75, .75, .75> ]
                       [0.1, 0.5 color rgb <.75, .75, .75> color rgbf <1, 1, 1, 1> ]
                       [0.5, 1.0 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1> ] }
 }
#local P_Cloud_b =
 pigment { bozo
           turbulence 0.8
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
                       [0.4, 0.6 color rgbf<.9, .9, .9, .9>   color rgbf<1, 1, 1, 1> ]
                       [0.6, 1.0 color rgbf<1, 1, 1, 1>       color rgbf<1, 1, 1, 1> ] } scale <1, 0.3, 10>
 }
#local P_Cloud_c =
 pigment { bozo
           turbulence 0.6
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
                       [0.4, 0.7 color rgbf<.9, .9, .9, .9>   color rgbf<1, 1, 1, 1> ]
                       [0.7, 1.0 color rgbf<1, 1, 1, 1>       color rgbf<1, 1, 1, 1> ] } scale <1, 0.3, 10>
 }
#local P_Cloud_d =
 pigment { bozo
           turbulence 1.5
           octaves 10
           omega .5
           lambda 2.5
           color_map { [0.0, 0.5 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
                       [0.5, 0.7 color rgbf<.9, .9, .9, .9>   color rgbf<1, 1, 1, 1> ]
                       [0.7, 1.0 color rgbf<1, 1, 1, 1>       color rgbf<1, 1, 1, 1> ] } scale <1, 0.3, 10>
 }
//----------------------------------------------------------------------------------
coordinate_color(120,0.19,0.35,1,1)
sky_sphere { 
  pigment { rgb <R1,G1,B1> }
  pigment { P_Cloud_d }
  pigment { P_Cloud_c }
  pigment { P_Cloud_b }
  pigment { P_Cloud_a }
  rotate 180*y
}
//**********************************************************************************
// weapon
coordinate_color( 90, 0.1, 0.9, 1, 3 )
#local T_satellite =
 texture {
  pigment { hexagon color rgbt < R3, G3, B3, 0.1 >,color rgbt < R3, G3, B3, 0.2 >,color rgbt < R3, G3, B3, 0.3 > }
  finish { metallic reflection 0.3 brilliance 2 specular 0.1 }
}
//----------------------------------------------------------------------------------
#include "Beam_weapon.def.inc"
//----------------------------------------------------------------------------------
union {
 object { Beam_weapon texture { T_satellite } }
 object { Spark_seg rotate -90*y scale <1.5,1,1>*10/150 translate 80*x }
 object { Beam_seg rotate -30*x translate <88, 0,0> }
 object { Beam_seg rotate  30*x translate <88,-1,0> }
 rotate 135*y translate <50,0,50>
}
//**********************************************************************************
// Signature
//#include "Sealpositive.sgn.inc"
#local Ls=< 0, 0, -200 >; #local La=< 0, 0, 0 >; #local Ag=50;
#local Sz=0; #local Lz=-vlength(Ls-La); #local Vx=(1-Sz)*Lz*tan(radians(Ag/2));
#local Tx=Vx+La.x+5; #local Ty=Vx+La.y+6; #local Tz=Sz*Lz+La.z;
#local Rx=degrees(atan2((Ls.y-La.y),sqrt(pow((Ls.x-La.x),2)+pow((Ls.z-La.z),2))));
#local Ry=180+degrees(atan2((Ls.x-La.x),(Ls.z-La.z))); #local Rz=0;
//object { Sealing translate < Tx,Ty*3/4,Tz > rotate < Rx,Ry,Rz > }
//----------------------------------------------------------------------------------