//******************************************************
// Persistence Of Vision raytracer version 3.5 bata
// Beam weapon definition type 0.1a010905a include file
// By S.Nishimura
//******************************************************


//**********************************************************************************
// beam
coordinate_color(150,1.0,0.5,3,1)
#local T_beam  =
texture {
 pigment { gradient z
           color_map { [ 0.0 rgbt < R2, G2, B2,0.8 > ]
                       [ 0.1 rgbt < R1, G1, B1,0.6 > ]
                       [ 0.2 rgbt < R3, G3, B3,0.4 > ]
                       [ 0.5 rgbt < R2, G2, B2,0.2 > ]
                       [ 0.8 rgbt < R1, G1, B1,0.4 > ]
                       [ 0.9 rgbt < R3, G3, B3,0.6 > ]
                       [ 1.0 rgbt < R2, G2, B2,0.8 > ] } rotate -y }
 finish { ambient 0.6 diffuse 0.6 reflection 0 }
}
//----------------------------------------------------------------------------------
#local T_beam_v =
texture {
 pigment { gradient z
           color_map { [ 0.0 rgbt < 1, 1, 1, 1 > ]
                       [ 0.1 rgbt < R1, G1, B1,0.8 > ]
                       [ 0.2 rgbt < R2, G2, B2,0.6 > ]
                       [ 0.5 rgbt < R2, G2, B2,0.4 > ]
                       [ 0.8 rgbt < R2, G2, B2,0.6 > ]
                       [ 0.9 rgbt < R3, G3, B3,0.8 > ]
                       [ 1.0 rgbt < 1, 1, 1, 1 > ] } scale 0.5 }
 finish { ambient 0.6 diffuse 0.6 reflection 0 }
}
//----------------------------------------------------------------------------------
coordinate_color(270,1.0,0.5,3,1)
#local T_beam_y =
texture {
 pigment { gradient z
           color_map { [ 0.0 rgbt < 1, 1, 1, 1 > ]
                       [ 0.1 rgbt < R1, G1, B1,0.8 > ]
                       [ 0.2 rgbt < R2, G2, B2,0.6 > ]
                       [ 0.5 rgbt < R2, G2, B2,0.4 > ]
                       [ 0.8 rgbt < R2, G2, B2,0.6 > ]
                       [ 0.9 rgbt < R3, G3, B3,0.8 > ]
                       [ 1.0 rgbt < 1, 1, 1, 1 > ] } scale 0.5 }
 finish { ambient 0.6 diffuse 0.6 reflection 0 }
}
//----------------------------------------------------------------------------------
#include "Curved_line.mcr.inc"
//----------------------------------------------------------------------------------
#macro Curve_function(Sp,Px0,Pz0,Func_type)
 #switch(Func_type)
 #case(1) #local Px0=30*Sp; #local Pz0=4*sin(3*Sp)+cos(16*Sp); #break
 #case(2) #local Pr=16*cos(Sp/4)+16; #local Px0=Pr*cos(Sp); #local Pz0=Pr*sin(Sp); #break
 #end
#end
//----------------------------------------------------------------------------------
#local Beam_org = union { Curved_line(1,0,1.501*pi,pi/8,cos(0),1) rotate -90*x }
#declare Beam_seg = object { Beam_org texture { T_beam } no_shadow }
#declare Beam_violet = object { Beam_org texture { T_beam_v } no_shadow }
#declare Beam_yellow = object { Beam_org texture { T_beam_y } no_shadow }
//**********************************************************************************
// Spark
coordinate_color( 356, 1.00, 0.45, 1, 1 )
coordinate_color(  16, 1.00, 0.40, 1, 2 )
coordinate_color( 349, 0.31, 0.55, 1, 3 )
#local M_spark =
 media { emission rgb 0.03
             //intervals 10
             //samples on,1
             confidence 0.999
             variance 0.001
             density { spherical
                       color_map { [ 0.0 rgb < 0, 0, 0 > ]
                                   [ 0.4 rgb < R1, G1, B1 > ]
                                   [ 0.6 rgb < R2, G2, B2 > ]
                                   [ 0.8 rgb < R3, G3, B3 > ]
                                   [ 0.9 rgb < R1, G1, B1 > ]
                                   [ 1.0 rgb < 0, 0, 0 > ] } scale 10*2.15 }
 }
//
#local Spark_org = difference { sphere { 0, 30 } cylinder { 0,31*z 31 } }
#declare Spark_seg = object {Spark_org hollow pigment { color rgbt < 1, 1, 1, 1 > } interior { media { M_spark } } scale 5 }
//----------------------------------------------------------------------------------
// weapon
#local Tr1=40; #local Ra1=330; #local Ra2=359; #local Tr2=46; #local Rb1=80; #local Rb2=100;
#local Arm_seg =
union {
 torus { Tr1,2 clipped_by { plane { z, 0 rotate 180*y } } }
 torus { Tr1,2
  clipped_by { plane { z, 0 } rotate -(Ra1+180)*y }
  clipped_by { plane { z, 0 } rotate -(Ra2)*y } }
 sphere { 0,2 translate < Tr1*cos(radians(Ra1)),0,Tr1*sin(radians(Ra1)) > }
 torus { Tr2,2
  clipped_by { plane { z, 0 } rotate -(Rb1+180)*y }
  clipped_by { plane { z, 0 } rotate -(Rb2)*y } }
 sphere { 0,2 translate < Tr2*cos(radians(Rb1)),0,Tr2*sin(radians(Rb1)) > }
 sphere { 0,2 translate < Tr2*cos(radians(Rb2)),0,Tr2*sin(radians(Rb2)) > }
 sphere { 43*z,3 scale <1.5,1,1> }
 scale <1,0.5,1> rotate -90*x
}
//
#local Parabola_seg =
union {
 sphere { 0, 30 clipped_by { plane { z,0 } } }
 torus { 30,1 rotate 90*x }
 scale <1,1,0.5>
}
//
#local Thrust_seg =
difference { 
 union { sphere { 0,6 } cylinder { 0,-15*y,6 open } }
 #local Ei=20; #local Si=0; #while(Si<Ei)
  box { <0,-8,0.5>,<6+0.01,-12.5> rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
}
//
#local Balancer_seg =
union {
 sphere { 8*y,1.1 scale <1,3,1> }
 cylinder { -6*y,24*y,1 }
 sphere { -6*y,1 }
}
//
#declare Beam_weapon =
union {
 object { Arm_seg } torus { 4,2 rotate -90*z translate 40*x }
 sphere { -60*x,6 } cylinder { -60*x,30*x,6 } cone { 30*x,6 34*x,4 } cylinder { 34*x,80*x,4 } sphere { 40*x,4 scale <2,1,1> }
 object { Parabola_seg translate 22*z }
 sphere { 0,10 } sphere { -30*z,3 } cylinder { -30*z, 30*z, 3 } sphere { 30*z, 3 }
 object { Parabola_seg rotate 180*y translate -22*z }
 object { Balancer_seg translate <-40,0,28> }
 object { Spark_seg scale <0.06,0.06,1> rotate <-90,0,0> translate <-40,0,21> }
 object { Thrust_seg translate < -40,0, 21 > }
 sphere { -40*x,15 } sphere { <-40,0,-28>,3 } cylinder { <-40,0,-28>, <-40,0,28>, 3 } sphere { <-40,0,28>, 3 }
 object { Thrust_seg rotate -60*z translate < -40,0,-21 > }
 object { Spark_seg scale <0.06,0.06,1> rotate <-90,0,-60> translate <-40,0,-21> }
 object { Balancer_seg rotate 60*z translate <-40,0,-28> }
}
//**********************************************************************************
//object { Beam_weapon texture { T_satellite } rotate 135*y translate <50,0,50> }
//**********************************************************************************
