
//===================================
//	TABLES, CHAISES
//===================================
#include "classchair2.inc"

#declare Chairs = array[10]
#declare Tables = array[10]

#local St=seed(1342);
#local St1=seed(1234);
#local St2=seed(4321);
#local St3=seed(1432);

#local i=0;
#while(i<10)
	#declare Chairs[i] = Chair(St)
	#declare Tables[i] = #if (rand(St)>.5) Table(St) #else Table2(St) #end
	#local i=i+1;
#end


#declare T_TableCouchee1 = transform {
	translate -z*(rPTable2-rPTable)*100
	rotate (-90+degrees(atan2(rPTable2-rPTable,yTable-eTable)))*x
}

#declare T_ChaiseCouchee1 = transform {
	scale <1,1,-1>
	translate z*(zCh+rCh4+rCh2+yCh3*sin(radians(aCh3)))*100
	rotate -82.5*x
}

#declare T_ChaiseCouchee2 = transform {
	scale <1,1,-1>
	translate z*(rCh4+rCh2+yCh3*sin(radians(aCh3)))*100
	translate x*(xCh/2+rCh4+rCh2)*100
	rotate 90*z
	rotate x*5
	translate <30,0,0>
	rotate z*5.4
	translate -y
}

#declare T_ChaiseCouchee3 = transform {
	scale <1,1,-1>
	translate -z*(rCh2)*100
	rotate 90*x
	translate -yCh3*z*100
	rotate x*46.5
}


//=============
// bureau
//=============
object { Bureau scale 100 rotate y*87
	translate <ClXmax-Elarg+2, CYmin+Ehaut, ClZmax-150>
}

//=====================
// arc pres du bureau
//=====================
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (-410+20*rand(St2))*x rotate 6*y translate <ClXmax-Elarg+150, CYmin, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (-410+20*rand(St2))*x rotate -5*y translate <ClXmax-Elarg+150, CYmin, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (-410+20*rand(St2))*x rotate -21*y translate <ClXmax-Elarg+150, CYmin, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (-500+20*rand(St2))*x rotate -5*y translate <ClXmax-Elarg+150, CYmin, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (-500+20*rand(St2))*x rotate -15*y translate <ClXmax-Elarg+150, CYmin, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (-500+20*rand(St2))*x rotate -26*y translate <ClXmax-Elarg+150, CYmin, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3)) rotate -85*y
	translate (-480+10*rand(St2))*x rotate -42*y translate <ClXmax-Elarg+150, CYmin, ClZmax-110>
}
// couchees
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 transform{T_TableCouchee1} rotate y*(80+20*rand(St3))
	translate (yTable*100-450+20*rand(St2))*x rotate -1*y translate <ClXmax-Elarg+150, CYmin+yTable*100, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 transform{T_TableCouchee1} rotate y*(80+20*rand(St3))
	translate (yTable*100-450+20*rand(St2))*x rotate -12*y translate <ClXmax-Elarg+150, CYmin+yTable*100, ClZmax-100>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 transform{T_TableCouchee1} rotate y*(80+20*rand(St3)) rotate -10*y
	translate (yTable*100-470+20*rand(St2))*x rotate -28*y translate <ClXmax-Elarg+150, CYmin+yTable*100, ClZmax-100>
}
// chaises
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate 85*y translate <ClXmax-60,CYmin,ClZmax-27>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate 146*y translate <ClXmax-230,CYmin,ClZmax-55>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-50,CYmin+Ehaut,ClZmax-130>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-250,CYmin,ClZmax-90>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-590,CYmin,ClZmax-230>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-550,CYmin,ClZmax-330>}


//=====================
// pres de la porte
//=====================
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(70+40*rand(St3))
	translate <ClXmax-Elarg-290, CYmin, CZmax+90>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(70+40*rand(St3))
	translate <ClXmax-Elarg-340, CYmin, CZmax+180>
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(70+40*rand(St3))
	translate <ClXmax-Elarg-540, CYmin, CZmax+110>
}
// chaises
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-50,CYmin,CZmax+60>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-150,CYmin,CZmax+100>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-250,CYmin,CZmax+70>}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 rotate (3965*rand(St2))*y translate <ClXmax-350,CYmin,CZmax+130>}



//=====================
// l'autre camp
//=====================
#declare T_AutreCamp = transform {
	translate <ClXmin,CYmin,CZmax+200>
}

//tables
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (300+20*rand(St2))*x rotate -38*y transform{T_AutreCamp}
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (300+20*rand(St2))*x rotate -23*y transform{T_AutreCamp}
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (300+20*rand(St2))*x rotate -8*y transform{T_AutreCamp}
}
object { Tables[mod(int(rand(St1)*1763),10)] scale 100 rotate y*(80+20*rand(St3))
	translate (300+20*rand(St2))*x rotate 5*y transform{T_AutreCamp}
}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 transform {T_ChaiseCouchee3} rotate -y*(80+20*rand(St3))
	translate (430+20*rand(St2))*x rotate -35*y transform{T_AutreCamp}
}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 transform {T_ChaiseCouchee3} rotate -y*(80+20*rand(St3))
	translate (430+20*rand(St2))*x rotate -28*y transform{T_AutreCamp}
}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 transform {T_ChaiseCouchee3} rotate -y*(80+20*rand(St3))
	translate (430+20*rand(St2))*x rotate -19*y transform{T_AutreCamp}
}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 transform {T_ChaiseCouchee3} rotate -y*(80+20*rand(St3))
	translate (430+20*rand(St2))*x rotate -8*y transform{T_AutreCamp}
}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 transform {T_ChaiseCouchee3} rotate -y*(80+20*rand(St3))
	translate (430+20*rand(St2))*x rotate 1*y transform{T_AutreCamp}
}
object {Chairs[mod(int(rand(St1)*1763),10)] scale 100 transform {T_ChaiseCouchee3} rotate -y*(80+20*rand(St3))
	translate (430+20*rand(St2))*x rotate 9*y transform{T_AutreCamp}
}


