//#version unofficial megapov 0.6;

#ifndef (boulettes_inc_included)
#declare boulettes_inc_included=on;

#declare test_boulettes_inc = off;


#macro BoulettePapier(Rayon, Dep, LongP, LargP, Nb1, Nb2, Lambda, UV)

#local Xfin=Dep.x+LongP;
#local Yfin=Dep.y+LargP;
#local IX=LongP/(Nb1-1);
#local IY=LargP/(Nb2-1);

mesh2 {
vertex_vectors {
	Nb1*Nb2
	#local X=Dep.x;
	#while (X<=Xfin*1.01)
		#local Y=Dep.y;
		#while (Y<=Yfin*1.01)
			,Rayon*vturbulence(Lambda, 1, 1, <X,Y,0>)
			#local Y=Y+IY;
		#end
		#local X=X+IX;
	#end
}
#if (UV)
uv_vectors {
	Nb1*Nb2
	#local X=0;
	#while (X<Nb1)
		#local Y=0;
		#while (Y<Nb2)
			,<X/(Nb1-1), Y/(Nb2-1)>
			#local Y=Y+1;
		#end
		#local X=X+1;
	#end
}
#end
face_indices{
	(Nb1-1)*(Nb2-1)*2
	#local I=0;
	#while(I<(Nb1-1))
		#local J=0;
		#while (J<(Nb2-1))
			,<Nb2*I+J, Nb2*I+J+1, Nb2*(I+1)+J>
			,<Nb2*(I+1)+J+1, Nb2*I+J+1, Nb2*(I+1)+J>
			#local J=J+1;
		#end
		#local I=I+1;
	#end
}
#if (UV)
uv_indices{
	(Nb1-1)*(Nb2-1)*2
	#local I=0;
	#while(I<(Nb1-1))
		#local J=0;
		#while (J<(Nb2-1))
			,<Nb2*I+J, Nb2*I+J+1, Nb2*(I+1)+J>
			,<Nb2*(I+1)+J+1, Nb2*I+J+1, Nb2*(I+1)+J>
			#local J=J+1;
		#end
		#local I=I+1;
	#end
}
#end
}

#end

#declare T_Quadrillage = texture {
	pigment {
		gradient x frequency 57
		pigment_map {
			[0.05 rgb <.6, .4, 1>*.8]
			[0.05 gradient y frequency int(57*21/29.7) color_map {[0.05 rgb <.6, .4, 1>*.8][0.05 rgb 1]}]
		}
	}
}	


#if (test_boulettes_inc)

#declare Rad=on;

camera {
	location <0, 4, -4>
	angle 35
	look_at <0,1,.5>
}

#if (Rad=on)
light_source {<1,1,-1>*10 rgb <1,1,.5>*1 }
background{rgb <.8,.8,1>*.8}
global_settings{
	radiosity{
		count 50
		nearest_count 4
		error_bound .1
		recursion_limit 1
		brightness 1.0

		pretrace_start  .05
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.2
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
}

#else
light_source {<1,1,-1>*100 rgb 1.3 }
#end

//plane { y,0 pigment {checker color rgb 0, color rgb 1 scale .4} }


union {
#local St=seed(1342);
#local i=-5;
#while (i<5)
	#local k=-2;
	#while (k<10)
		box {<-.485, -.1, -.485>, <.485, 0, .485>
			rotate x*(2*rand(St)-1)*.5
			rotate z*(2*rand(St)-1)*.5
			rotate y*(2*rand(St)-1)*.25
			translate <i,0,k>
		}
		#local k=k+1;
	#end
	#local i=i+1;
#end
	texture {
		pigment{rgb<1,.85, .67>*1.2}
		normal{wrinkles scale 3 slope_map{[.4 <0,0>][.4 <0,3>][.43 <1,3>][.43 <1,0>]}}
		finish{phong .8 phong_size 5 brilliance 2}
	}
	texture {pigment{wrinkles color_map{[.3 rgbf 1][1 rgbt <.6, .5, .2, .6>]}}}
}
plane { y,-.01 texture{pigment{rgb .4}normal{granite}}}


#declare Text2 = texture {
	pigment {image_map{png "texte"}rotate z*90}
}	


#declare Boulette = object {
//	BoulettePapier(Rayon, Dep, LongP, LargP, Nb1, Nb2, Lambda, UV)
	BoulettePapier(1, <-1,3,2>, 29.7/4, 21/4, 50, int(50*21/29.7), 2, on)
	uv_mapping
	}

object { Boulette texture {Text2} translate y }
object { Boulette texture {T_Quadrillage} rotate <12, 68, 32> translate y+z-1.5*x }
object { Boulette texture {T_Quadrillage} rotate <82, 14 49> translate y+x+2*z }

#end


#end
