//==========================================
// Classroom furniture
// Copyright(c) Gilles Tran 2001            
// http://www.oyonale.com
// Feel free to use and modify
//==========================================
// Made for Persistence of vision 3.5
//==========================================  
// This file uses radiosity, add +qr to the command line
// Cmd:+qr
//==========================================
// Modified Classroom furniture by Bouf (2001)
// http://tofbouf.free.fr
//==========================================

//#version unofficial megapov 0.6;

#ifndef (classchair_inc_included)
#declare classchair_inc_included=on;

#declare test_classchair_inc = off;

#include "colors.inc"


#default {texture{finish{ambient .2 diffuse .8}}}

// ----------------------------------------
// Chair
// ----------------------------------------
#declare rCh=0.025/2;
#declare rCh2=rCh+0.002;
#declare rCh3=0.01;
#declare rCh4=0.05;
#declare yCh=0.43;
#declare yCh2=0.345;
#declare zCh=0.28;
#declare xCh=0.33;
#declare zCh3=0.07;
#declare yCh1=yCh-rCh4; 
#declare yCh5=yCh-rCh*2; 
#declare yCh3=sqrt(zCh3*zCh3+yCh5*yCh5);
#declare yCh4=yCh3-rCh4;
#declare aCh=degrees(atan2(zCh3,yCh1));
#declare aCh1=2;
#declare aCh2=5;
#declare aCh3=10;
#declare colChair=rgb <1, 0.50297, 0.20703>;
#declare colPChair1=rgb <0.24219, 0.5, 0.45313>*0.5;
#declare colPChair2=rgb <0.5, 0.25781, 0.13672>*0.1;
#declare pigChair1=pigment{
    wood
    turbulence 0.2
    lambda 3
    color_map{
        [0 colChair*0.7]
        [1 colChair]
    }
    rotate y*100 rotate x*20    scale 0.04 scale 0.01*<10,1,1>    
}                             
#declare pigChair2=pigment{
    wood
    turbulence 0.2
    lambda 3
    color_map{
        [0 colChair*0.35]
        [1 colChair*0.7]
    }
    rotate y*100 rotate z*80 scale 0.01 scale 0.8*<1,5,1>  
}    

#declare txtWoodChair=texture{
    pigment{
        pigment_pattern{
            agate agate_turb 0.3 lambda 3 
            color_map{[0.5 White][0.5 Black]}
            rotate x*148
            scale 0.2
        }
        pigment_map{
            [0 pigChair1]
            [1 pigChair2]
        }
    }
}

#declare txtLegChair=texture{
    pigment{
        granite
        color_map{
            [0 colPChair1]
            [0.3 colPChair1]
            [0.4 colPChair2]
            [1 colPChair2]
        }
    }
    finish{metallic brilliance 4 specular 1 roughness 0.005}
    scale 0.02
}

#declare LegChairFront=union{
    cylinder{0,y*0.008,rCh2} // rubber
    torus{rCh,rCh2-rCh translate y*0.008}
    cylinder{0,y*yCh1,rCh} // montant Front
    difference{torus{rCh4,rCh rotate z*90} plane{y,0} plane{z,0 inverse} translate <0,yCh1,rCh4>}
    cylinder{0,z*zCh,rCh translate <0,yCh,rCh4>} // horizontal
    union{ // Back
        difference{torus{rCh4,rCh rotate z*90} plane{y,0 inverse rotate x*aCh3} plane{z,0} translate y*rCh4}
        union{
            cylinder{0,y*yCh2,rCh}
            union{
                cylinder{0,y*0.01,rCh2}
                sphere{0,rCh2 scale <1,0.004/rCh2,1> translate y*0.01}
                translate y*yCh2
            }   
            translate z*rCh4
            rotate x*aCh3
            translate y*rCh4
        }
        rotate -z*aCh2
        translate <0,yCh,rCh4+zCh>
    }
}
#declare LegChairRear=union{
    cylinder{0,y*0.008,rCh2} 
    torus{rCh,rCh2-rCh translate y*0.008}
    cylinder{0,y*yCh4,rCh} 
    difference{torus{rCh4,rCh rotate x*90} plane{y,0} plane{x,0} translate <-rCh4,yCh4,0>}
}              

#declare rChD1=xCh/2-sin(radians(aCh1))*(zCh+2*rCh4)+sin(radians(aCh2))*rCh4;
#declare rChD2=xCh/2-sin(radians(aCh1))*(zCh+2*rCh4)+sin(radians(aCh2))*(rCh4+yCh2);
#declare yChD=yCh2*cos(radians(aCh2));
#declare BackChair=difference{
    cone{0,rChD1,y*yChD,rChD2}
    cone{-y*0.001,rChD1*0.85,y*(yChD+0.001),rChD2*0.85}
    plane{z,0}
    plane{y,yCh2*0.5}
    scale <1,1,0.08/rChD2>
}       
#declare eChS=0.008;
#declare SeatChair=union{
    box{<-xCh/2,-eChS,0>,<xCh/2,0,zCh>}
    difference{cylinder{0,-eChS*y,xCh/2} plane{z,0} scale <1,1,0.05*2/xCh> translate z*zCh}
    difference{
        cylinder{-x*xCh/2,x*xCh/2,rCh4}
        cylinder{-x*1.1*xCh/2,x*1.1*xCh/2,rCh4-eChS}
        plane{z,0 inverse}
        plane{y,0 rotate x*25}
        translate -y*rCh4
    }
    texture{pigment{pigChair1}}
} 

#macro Chair(St)
union{
    union{
        object{LegChairFront rotate -y*aCh1 translate x*xCh/2}
        object{LegChairFront rotate -y*aCh1 translate x*xCh/2 scale <-1,1,1>}
        cylinder{-xCh*x/2,xCh*x/2,rCh3 translate -z*rCh4 rotate x*25 translate z*rCh4+y*yCh1}
        union{
            object{LegChairRear translate x*(xCh/2+rCh4)}
            object{LegChairRear translate x*(xCh/2+rCh4) scale <-1,1,1>}
            union{
                cylinder{-xCh/2*x,x*xCh/2,rCh}
                union{
                    sphere{0,1 translate y scale <1,0.5,1> scale 0.01 translate y*rCh-x*0.6*xCh/2}
                    sphere{0,1 translate y scale <1,0.5,1> scale 0.01 translate y*rCh+x*0.6*xCh/2}
                    texture{pigment{White*0.6}finish{specular 1 roughness 0.001 reflection 0.1}}
                    rotate x*aCh
                }
                translate y*yCh3
            }
            translate -y*yCh3
            rotate -x*aCh
            translate <0,yCh3,zCh+rCh4>
        }                     
        texture{txtLegChair}
    }
    union{         
        object{BackChair
            translate z*rCh4
            rotate x*aCh3
            translate <0,yCh+rCh4,rCh4+zCh>
            texture{txtWoodChair translate rand(St)*5}
        }        
        object{SeatChair
            translate <0,yCh,rCh4>
        }
    }        
}
#end

// ----------------------------------------
// Tables
// ----------------------------------------
// Table 1
// ----------------------------------------
#declare xTable=0.76;
#declare yTable=0.75;
#declare zTable=0.6;
#declare eTable=0.025;
#declare rTable=0.025;
#declare aTable=0.002;
#declare xTable2=xTable-2*rTable;
#declare zTable2=zTable-2*rTable;
#declare rPTable=0.016;
#declare aPTable=0.09;
#declare rPTable2=0.07;
#declare yPTable=yTable-eTable-rPTable-aPTable;
#declare xPTable=xTable-2*rPTable2-2*aPTable;
#declare zPTable=zTable-2*rPTable2;
#declare colTable=rgb <.8, 0.40297, 0.10703>;
#declare colTable2=rgb <1, 0.75297, 0.40703>;
#declare colPTable1=rgb <0.24219, 0.5, 0.45313>*1.2;
#declare colPTable2=rgb <0.5, 0.25781, 0.13672>*0.7;
#declare colPTable3=rgb <0.5, 0.35313, 0.24219>*0.5;
#declare colPTable4=rgb <0.5, 0.25781, 0.13672*.5>;
#declare txtTableWood=texture{
    pigment{
        wood
        turbulence 0.1
        warp{
            black_hole <0, 0, 0>, 4
            falloff 1
            strength 1
            repeat <10, 10, 10>
            turbulence 1
            inverse
        }
        color_map{
            [0 colTable*0.8]
            [1 colTable]
        }
    }
    rotate y*100
    rotate x*-10
    translate <5,1,1>
    scale 0.02
}            
#declare txtTableWood2=texture{
    pigment{
        wood
        turbulence 0.1
        color_map{
            [0 colTable2*0.8]
            [1 colTable2]
        }
    }
    rotate y*100
    rotate x*-10
    translate <20,1,1>
    scale 0.02
}            
#declare txtTableCorner1=texture{
    pigment{colTable*0.1}
    finish{specular 1 roughness 0.01}
}
#declare txtTableCorner2=texture{
    pigment{White*0.8}
    finish{metallic brilliance 3 specular 1 roughness 0.01 reflection 0.2}
}
#declare txtLegTable1=texture{
    pigment{
        granite
        color_map{
            [0 colPTable1]
            [0.39 colPTable1]
            [0.4 colPTable2]
            [1 colPTable2]
        }
    }
    finish{metallic brilliance 5 specular 0.6 roughness 0.005}
    scale 0.04
}
#declare txtLegTable2=texture{
    pigment{
        granite
        color_map{
            [0 colPTable3]
            [0.39 colPTable3]
            [0.4 colPTable4]
            [1 colPTable4]
        }
    }
    finish{ diffuse .8 metallic brilliance 2 specular 0.2 roughness 0.05}
    scale 0.04
}
#declare txtLegTable=texture {
	pigment_pattern {
		bozo
		scale .3
		warp {turbulence .3 lambda 4 octaves 2}
		scale 3/.3
		warp {turbulence .8 lambda 4 octaves 2}
		scale .02
	}
	texture_map{[.70 txtLegTable1][.72 txtLegTable2]}
}


#macro Table(St)
union{
    union{ // top
        box{<0,eTable*0.5,0>,<xTable2,eTable,zTable2> translate <rTable,0,rTable>} // centre
        box{<0,0,0>,<xTable2,eTable*0.5,zTable2> translate <rTable,0,rTable> /*texture{pigment{colTable*0.1}}*/} // centre
        #declare TableBord=union{ // side
            box{0,<aTable,eTable-aTable,1>}
            box{0,<rTable-aTable,eTable,1> translate x*aTable}
            cylinder{0,z,aTable translate <aTable,eTable-aTable,0> texture{txtTableCorner1}}
        }
        #declare TableCorner=difference{ // Corner
            union{
                cylinder{0,y*(eTable-aTable),rTable texture{txtTableCorner2}}
                cylinder{0,y*aTable,rTable-aTable translate y*(eTable-aTable)}
                torus{rTable-aTable,aTable translate y*(eTable-aTable) texture{txtTableCorner1}}
            }
            plane{x,0 inverse}
            plane{z,0 inverse}
        }
        
        union{
            object{TableBord scale <1,1,zTable2>}
            object{TableBord scale <-1,1,zTable2> translate x*(xTable2+2*rTable)}
            translate z*rTable
        }

        union{
            object{TableBord rotate y*90 scale <xTable2,1,-1>}
            object{TableBord rotate y*90 scale <xTable2,1,1> translate z*(zTable2+2*rTable)}
            translate x*rTable
        }
        
        object{TableCorner translate <rTable,0,rTable>}
        object{TableCorner scale <-1,1,1> translate <rTable+xTable2,0,rTable>}
        object{TableCorner scale <1,1,-1> translate <rTable,0,zTable2+rTable>}
        object{TableCorner scale <-1,1,-1> translate <rTable+xTable2,0,zTable2+rTable>}
        translate y*(yTable-eTable)
    }
    union{
        #declare LegTable=union{
            cylinder{0,y*0.006,rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}}}
            cylinder{0,y*yPTable,rPTable}
            difference{           
                torus{aPTable,rPTable rotate x*90}
                plane{y,0}
                plane{x,0 inverse}
                translate <aPTable,yPTable,0>
            }
        }
        object{LegTable translate <rPTable2,0,rPTable2>}
        object{LegTable translate <rPTable2,0,rPTable2> scale <-1,1,1> translate x*xTable}
        object{LegTable translate <rPTable2,0,rPTable2> scale <1,1,-1> translate z*zTable}
        object{LegTable translate <rPTable2,0,rPTable2> scale <-1,1,-1> translate x*xTable+z*zTable}
        cylinder{0,x*xPTable,rPTable*0.9 translate <rPTable2+aPTable,yTable-rPTable-eTable,rPTable2>}
        cylinder{0,x*xPTable,rPTable*0.9 translate <rPTable2+aPTable,yTable-rPTable-eTable,zTable-rPTable2>}
        cylinder{0,z*zPTable,rPTable*0.9 translate <rPTable2,yPTable,rPTable2>}
        cylinder{0,z*zPTable,rPTable*0.9 translate <xTable-rPTable2,yPTable,rPTable2>}
        texture{txtLegTable translate 5*rand(St)}
    }
    texture{txtTableWood rotate y*20*(2*rand(St)-1) translate 5*rand(St)}
}                             
#end
// ----------------------------------------
// Table 2
// ----------------------------------------
#declare aTable=0.01;
#declare rTable=0.028;
#declare eTable=0.028;
#declare xTable2=xTable-2*rTable;
#declare zTable2=zTable-2*rTable;
#declare rPTable=0.016;
#declare aPTable=0.09;
#declare rPTable2=0.07;
#declare yPTable=yTable-eTable-rPTable-aPTable;
#declare xPTable=xTable-2*rPTable2-2*aPTable;
#declare zPTable=zTable-2*rPTable2;
#macro Table2(St)
union{
    union{ // top
        box{<0,eTable*0.5,0>,<xTable2,eTable,zTable2> translate <rTable,0,rTable>} // centre dessus
        box{<0,0,0>,<xTable2,eTable*0.5,zTable2> translate <rTable,0,rTable> /*texture{pigment{colTable*0.1}}*/} // centre dessous
        #declare TableBord=union{ // side
            box{<0,aTable,0>,<aTable,eTable-aTable,1>}
            box{0,<rTable-aTable,eTable,1> translate x*aTable}
            cylinder{0,z,aTable translate <aTable,eTable-aTable,0>}
            cylinder{0,z,aTable translate <aTable,aTable,0>}
        }
        #declare TableCorner=difference{ // Corner
            union{
                cylinder{y*aTable,y*(eTable-aTable),rTable}
                cylinder{0,y*aTable,rTable-aTable translate y*(eTable-aTable)}
                cylinder{0,y*aTable,rTable-aTable}
                torus{rTable-aTable,aTable translate y*(eTable-aTable)}
                torus{rTable-aTable,aTable translate y*aTable}
            }
            plane{x,0 inverse}
            plane{z,0 inverse}
        }
        
        union{
            object{TableBord scale <1,1,zTable2>}
            object{TableBord scale <-1,1,zTable2> translate x*(xTable2+2*rTable)}
            translate z*rTable
        }

        union{
            object{TableBord rotate y*90 scale <xTable2,1,-1>}
            object{TableBord rotate y*90 scale <xTable2,1,1> translate z*(zTable2+2*rTable)}
            translate x*rTable
        }
        
        object{TableCorner translate <rTable,0,rTable>}
        object{TableCorner scale <-1,1,1> translate <rTable+xTable2,0,rTable>}
        object{TableCorner scale <1,1,-1> translate <rTable,0,zTable2+rTable>}
        object{TableCorner scale <-1,1,-1> translate <rTable+xTable2,0,zTable2+rTable>}
        translate y*(yTable-eTable)
    }
    union{
        #declare LegTable=union{
            cylinder{0,y*0.006,rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}}}
            cylinder{0,y*yPTable,rPTable}
            difference{           
                torus{aPTable,rPTable rotate x*90}
                plane{y,0}
                plane{x,0 inverse}
                translate <aPTable,yPTable,0>
            }
        }
        object{LegTable translate <rPTable2,0,rPTable2>}
        object{LegTable translate <rPTable2,0,rPTable2> scale <-1,1,1> translate x*xTable}
        object{LegTable translate <rPTable2,0,rPTable2> scale <1,1,-1> translate z*zTable}
        object{LegTable translate <rPTable2,0,rPTable2> scale <-1,1,-1> translate x*xTable+z*zTable}
        cylinder{0,x*xPTable,rPTable*0.9 translate <rPTable2+aPTable,yTable-rPTable-eTable,rPTable2>}
        cylinder{0,x*xPTable,rPTable*0.9 translate <rPTable2+aPTable,yTable-rPTable-eTable,zTable-rPTable2>}
        cylinder{0,z*zPTable,rPTable*0.9 translate <rPTable2,yPTable,rPTable2>}
        cylinder{0,z*zPTable,rPTable*0.9 translate <xTable-rPTable2,yPTable,rPTable2>}
        texture{txtLegTable translate 5*rand(St)}
    }
    texture{txtTableWood2 rotate y*20*(2*rand(St)-1)  translate 5*rand(St)}
}                             
#end

// ----------------------------------------
// Bureau
// ----------------------------------------
#declare xBureau=1.60;
#declare yBureau=0.80;
#declare zBureau=0.8;
//#declare aTable=0.01;
//#declare rTable=0.028;
//#declare eTable=0.028;
#declare xBureau2=xBureau-2*rTable;
#declare zBureau2=zBureau-2*rTable;
#declare rPTable=0.016;
#declare aPTable=0.09;
#declare rPTable2=0.07;
#declare yPBureau=yBureau-eTable-rPTable-aPTable;
#declare xPBureau=xBureau-2*rPTable2-2*aPTable;
#declare zPBureau=zBureau-2*rPTable2;

#declare Bureau=union{
    union{ // top
        box{<0,eTable*0.5,0>,<xBureau2,eTable,zBureau2> translate <rTable,0,rTable>} // centre dessus
        box{<0,0,0>,<xBureau2,eTable*0.5,zBureau2> translate <rTable,0,rTable> texture{pigment{colTable*0.1}}} // centre dessous
        #declare TableBord=union{ // side
            box{<0,aTable,0>,<aTable,eTable-aTable,1>}
            box{0,<rTable-aTable,eTable,1> translate x*aTable}
            cylinder{0,z,aTable translate <aTable,eTable-aTable,0>}
            cylinder{0,z,aTable translate <aTable,aTable,0>}
        }
        #declare TableCorner=difference{ // Corner
            union{
                cylinder{y*aTable,y*(eTable-aTable),rTable}
                cylinder{0,y*aTable,rTable-aTable translate y*(eTable-aTable)}
                cylinder{0,y*aTable,rTable-aTable}
                torus{rTable-aTable,aTable translate y*(eTable-aTable)}
                torus{rTable-aTable,aTable translate y*aTable}
            }
            plane{x,0 inverse}
            plane{z,0 inverse}
        }
        union{
            object{TableBord scale <1,1,zBureau2>}
            object{TableBord scale <-1,1,zBureau2> translate x*(xBureau2+2*rTable)}
            translate z*rTable
        }

        union{
            object{TableBord rotate y*90 scale <xBureau2,1,-1>}
            object{TableBord rotate y*90 scale <xBureau2,1,1> translate z*(zBureau2+2*rTable)}
            translate x*rTable
        }
        
        object{TableCorner translate <rTable,0,rTable>}
        object{TableCorner scale <-1,1,1> translate <rTable+xBureau2,0,rTable>}
        object{TableCorner scale <1,1,-1> translate <rTable,0,zBureau2+rTable>}
        object{TableCorner scale <-1,1,-1> translate <rTable+xBureau2,0,zBureau2+rTable>}
        translate y*(yBureau-eTable)
    }
	union {
		box {<aPTable+rPTable, .006, rPTable2+rPTable>, <xBureau*.3, yBureau-eTable, 2*rPTable2+rPTable> texture{txtTableWood2 rotate x*90 rotate y*90}}
		box {<aPTable+rPTable, .006, zBureau-(2*rPTable2+rPTable)>, <xBureau*.3, yBureau-eTable, zBureau-(rPTable2+rPTable)> texture{txtTableWood2 rotate x*90 rotate y*90}}
		box {<aPTable+rPTable, .006, 2*rPTable2+rPTable>, <aPTable+rPTable+rPTable2, yBureau-eTable, zBureau-(2*rPTable2+rPTable)> texture{txtTableWood2 rotate z*90}}
		box {<xBureau*.3-rPTable2, .006, rPTable2+rPTable>, <xBureau*.3, yBureau-eTable, zBureau-(rPTable2+rPTable)> texture{txtTableWood2 rotate z*90}}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <aPTable+rPTable+rPTable*1.1, 0, rPTable2+rPTable+rPTable*1.1>}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <xBureau*.3-rPTable*1.1, 0, rPTable2+rPTable+rPTable*1.1>}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <aPTable+rPTable+rPTable*1.1, 0, zBureau-(rPTable2+rPTable)-rPTable*1.1>}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <xBureau*.3-rPTable*1.1, 0, zBureau-(rPTable2+rPTable)-rPTable*1.1>}
	}
	union {
		box {<aPTable+rPTable, .006, rPTable2+rPTable>, <xBureau*.3, yBureau-eTable, 2*rPTable2+rPTable> texture{txtTableWood2 rotate x*90 rotate y*90}}
		box {<aPTable+rPTable, .006, zBureau-(2*rPTable2+rPTable)>, <xBureau*.3, yBureau-eTable, zBureau-(rPTable2+rPTable)> texture{txtTableWood2 rotate x*90 rotate y*90}}
		box {<aPTable+rPTable, .006, 2*rPTable2+rPTable>, <aPTable+rPTable+rPTable2, yBureau-eTable, zBureau-(2*rPTable2+rPTable)> texture{txtTableWood2 rotate z*90}}
		box {<xBureau*.3-rPTable2, .006, rPTable2+rPTable>, <xBureau*.3, yBureau-eTable, zBureau-(rPTable2+rPTable)> texture{txtTableWood2 rotate z*90}}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <aPTable+rPTable+rPTable*1.1, 0, rPTable2+rPTable+rPTable*1.1>}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <xBureau*.3-rPTable*1.1, 0, rPTable2+rPTable+rPTable*1.1>}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <aPTable+rPTable+rPTable*1.1, 0, zBureau-(rPTable2+rPTable)-rPTable*1.1>}
		cylinder { 0, y*.006, rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}} translate <xBureau*.3-rPTable*1.1, 0, zBureau-(rPTable2+rPTable)-rPTable*1.1>}
		scale <-1,1,1>
		translate xBureau*x
	}
    union{
        #declare LegTable=union{
            cylinder{0,y*0.006,rPTable*1.01 texture{pigment{White*0.01} finish{specular 0.2 roughness 0.1}}}
            cylinder{0,y*yPBureau,rPTable}
            difference{           
                torus{aPTable,rPTable rotate x*90}
                plane{y,0}
                plane{x,0 inverse}
                translate <aPTable,yPBureau,0>
            }
        }
        object{LegTable translate <rPTable2,0,rPTable2>}
        object{LegTable translate <rPTable2,0,rPTable2> scale <-1,1,1> translate x*xBureau}
        object{LegTable translate <rPTable2,0,rPTable2> scale <1,1,-1> translate z*zBureau}
        object{LegTable translate <rPTable2,0,rPTable2> scale <-1,1,-1> translate x*xBureau+z*zBureau}
        cylinder{0,x*xPBureau,rPTable*0.9 translate <rPTable2+aPTable,yBureau-rPTable-eTable,rPTable2>}
        cylinder{0,x*xPBureau,rPTable*0.9 translate <rPTable2+aPTable,yBureau-rPTable-eTable,zBureau-rPTable2>}
        cylinder{0,z*zPBureau,rPTable*0.9 translate <rPTable2,yPBureau,rPTable2>}
        cylinder{0,z*zPBureau,rPTable*0.9 translate <xBureau-rPTable2,yPBureau,rPTable2>}
        texture{txtLegTable}
    }
    texture{txtTableWood2}
}                             


#if (test_classchair_inc)

// test scene
// ----------------------------------------
// Scene
// ----------------------------------------
camera
{
  location  <.5, 0.1, -4.0>*100
//  direction 3*z
  right     4/3*x
  up y
  angle 20
  look_at   <0, 0.1,  0.0>*100
}
background{White}
light_source{x*100*100 color White*1.3
//    area_light 15*x,15*z, 10,10 jitter adaptive 1 orient
    rotate z*50
    rotate y*60
}

plane{y,0 texture{pigment{White}}}

#local St=seed(1342);
//object{Table scale 100 rotate y*20 translate z*100}
//object{Bureau scale 100 rotate -y*30 translate -x*30-z*40}
/*
object{Chair(St) scale 100 rotate -y*180
	translate <xBureau*.3*100+25, 0, 25>
	rotate -y*30 translate -x*30-z*40
}
*/
/*
object { Table(St) scale 100
	translate -z*(rPTable2-rPTable)*100
	rotate (-90+degrees(atan2(rPTable2-rPTable,yTable-eTable)))*x
	rotate -y*90
//	translate <-70, 0, 0>
}
*/
object { Chair(St) scale 100
	scale <1,1,-1>
	translate -z*(rCh2)*100
	rotate 90*x
	translate -yCh3*z*100
	rotate x*46.5
	
	rotate y*90
	translate -20*x
}

#end

#end
