//#version unofficial megapov 0.6;

#declare test_estrade_inc = off;

#declare Elong = 350;
#declare Elarg = 180;
#declare Ehaut = 20;
#declare Eep = 2;


#declare StEst=seed(1342);

#macro Planche(dimension)
box {0, dimension}
#end

#declare Ecol = <.8, .7, .5>*1.3;

#declare T_Estrade = texture {
	pigment {
		wood
		translate 10*x-3*y
		scale 6
		warp { turbulence .8 octaves 2 lambda 3}
		scale <1,1,6>
		color_map {
			[.1 color rgb Ecol*.9]
			[.2 color rgb Ecol*.8]
			[.3 color rgb Ecol*1.]
			[.5 color rgb Ecol*.5]
			[.6 color rgb Ecol*.7]
			[.8 color rgb Ecol*1.]
			[.9 color rgb Ecol*.7]
		}
	}
	normal {
		pigment_pattern {
			wood
			translate 10*x-3*y
			scale 6
			warp { turbulence .8 octaves 2 lambda 3}
			scale <1,1,6>
		}
		slope_map {
			#local i=.1;
			#while (i<.9)
				[i <1, 0>]
				[i <1, -3>]
				[i+.02 <0, -3>]
				[i+.02 <0, 3>]
				[i+.05 <1, 3>]
				[i+.05 <1, 0>]
				#local i=i+.2+.2*rand(StEst);
			#end
			
		}
	}
	finish {brilliance .8}
}


#declare Estrade = union {
	// cotes
	object {Planche(<Elong, Ehaut-Eep, Eep>) rotate -x*.5 texture {T_Estrade rotate -z*90 rotate y*90 }}
	object {Planche(<Elarg-Eep, Ehaut-Eep, Eep>) rotate y*90 translate Elarg*z rotate -.5*z texture {T_Estrade}}
	object {Planche(<Elarg-Eep, Ehaut-Eep, Eep>) rotate y*90 translate Elarg*z rotate .5*z texture {T_Estrade translate 3*x}translate (Elong-Eep)*x}
	// dessus
	#declare NbPl = int(Elong/Ehaut);
	#declare PLlarg = Elong/NbPl;
	#local i=0;
	#while (i<NbPl)
		object {Planche(<PLlarg*.95, Eep, Elarg>) rotate x*.02*(1-2*rand(StEst)) texture {T_Estrade translate <(1-2*rand(StEst))*40, 0, (1-2*rand(StEst))*60>} translate <i*PLlarg, Ehaut-Eep, 0> }
		#local i=i+1;
	#end
}


#if (test_estrade_inc)

camera {
	location <20, 60, -100>
	angle 40
	look_at <Elong/2, Ehaut, Elarg/2>
}

light_source { <1,.5,-1>*2000 rgb 1.3 }

object { Estrade }

plane {y, 0 pigment {rgb 1}}

#end
