// figury szachowe i gotowe uklady

#include "woods.inc"

#declare Pionek = difference {
  union {
    sphere { <0, 0, 0>, 1.5 }
    difference {
      sphere { < 0, 1.2, 0>, 1.5 }
      box { <-2, 1.8, -2>, <2, 3, 2> }
    }
    difference {
      cone { <0, 1.8, 0>, 1.2, <0, 2.8, 0>, .8 }
      torus { .9, .3
        translate <0, 2.3, 0>
      }
    }
    cone { <0, 2.8, 0>, .8, <0, 3.1, 0>, .3 }
    sphere { <0, 3.5, 0>, .5 }
  }
  box { <-2, -3, -2>, <2, 0, 2> }
}

#declare Wieza = difference {
  union {
    difference {
      sphere { <0, 0, 0>, 1.5 }
      box { <-2, .7, -2>, <2, 2, 2> }
    }
    cone { <0, .7, 0>, 1.2, <0, 4.2, 0>, .6 }
    cone { <0, .8, 0>, 1.3, <0, 1.3, 0>, 1.2 }
    cone { <0, 1.4, 0>, 1.2, <0, 1.9, 0>, 1.1 }
    cone { <0, 2, 0>, 1.1, <0, 2.5, 0>, 1 }
    cone { <0, 2.6, 0>, 1, <0, 3.1, 0>, .9 }
    cone { <0, 3.2, 0>, .9, <0, 3.7, 0>, .8 }
    difference {
      torus { .5, .5
        translate 4.2*y
      }
      box { <-2, 4.2, -2>, <2, 5, 2> }
    }
  }
  box { <-2, -2, -2>, <2, 0, 2> }
}

#declare Goniec = difference {
  union {
    difference {
      sphere { <0, 0, 0>, 1.5 }
      box { <-2, .8, -2>, <2, 2, 2> }
    }
    difference {
      cylinder { <0, .8, 0>, <0, 1.5, 0>, 1.2 }
      union {
        torus { .9, .3 }
        torus { 1, .3 }
        torus { 1.1, .3 }
        torus {1.2, .3 }
          translate 1.2*y
      }
    }
    cone { <0, 1.5, 0>, 1.3, <0, 4.5, 0>, .7 }
    torus { .5, .3
      translate 4.8*y }
    cylinder { <0 , 4.5, 0>, <0, 5, 0>, .4 }
  }
  box { <-2, -2, -2>, <2, 0, 2> }
}

#declare Kon = difference {
  union {
    difference {
      sphere { <0, 0, 0>, 1.5 }
      box { <-2, .8, -2>, <2, 2, 2> }
    }
    difference {
      cylinder { <0, .8, 0>, <0, 1.3, 0>, 1.2 }
      union {
        torus { .8, .3 }
        torus { .9, .3 }
        torus { 1, .3 }
        torus { 1.1, .3 }
        torus {1.2, .3 }
          translate 1.2*y
      }
    }
    difference {
      box { <-1.3, 1.3, -.5>, <1.3, 3.1, .5> }
      union {
        union {
          torus { .9, .3 }
          torus { .8, .3 }
          torus { 1, .3 }
          torus { 1.1, .3 }
          torus {1.2, .3 }
          torus {1.3, .3 }
            translate 1.2*y
        }
        box { <-2, 0, -.6>, <0, 1, .6>
          rotate 30*z
          translate <.2, 3.1, 0>
        }
      }
    }
    difference {
      box { <-1.3, 3.1, -.5>, <.2, 4.2, .5> }
      box { <-2, 0, -.6>, <0, .5, .6>
        rotate 15*z
        translate 4.2*y
      }
    }
    difference {
      intersection {
        box { <0, 3.1, -.5>, <1.3, 5.2, .5> }
        cylinder { <-1.3, 3.1, -.5>, <-1.3, 3.1, .5>, 2.6 }
      }
      box { <-1, 0, -.1>, <1, 1.5, .1>
        rotate -45*z
        translate 4.9*y
      }
    }
  }
  box { <-2, -2, -2>, <2, 0, 2> }
}

#declare Krol = difference {
  union {
    difference {
      sphere { <0, 0, 0>, 1.5 }
      box { <-2, .8, -2>, <2, 2, 2> }
    }
    difference {
      cylinder { <0, .8, 0>, <0, 1.5, 0>, 1.2 }
      union {
        torus { .9, .3 }
        torus { 1, .3 }
        torus { 1.1, .3 }
        torus {1.2, .3 }
          translate 1.2*y
      }
    }
    difference {
      union{
        cone { <0, 1.6, 0>, 1.25, <0, 2.6, 0>, .95 }
        cone { <0, 1.6, 0>, 1.3, <0, 1.85, 0>, 1.2 }
        cone { <0, 1.9, 0>, 1.2, <0, 2.3, 0>, 1.1 }
        cone { <0, 2.35, 0>, 1.1, <0, 2.6, 0>, 1 }
      }
      union {
        torus { .9, .3 }
        torus { 1, .3 }
        torus { 1.1, .3 }
        torus {1.2, .3 }
          translate 1.3*y
      }
    }
    difference {
      union {
        intersection {
          cone { <0, 2.6, 0>, 1, <0, 5.6, 0>, 1.7 }
          sphere { <0, 4.4, 0>, 1.3 }
        }
        cone { <0, 2.6, 0>, 1, <0, 4.4, 0>, 1.3 }
      }
      union {
        box { <-2, 2.6, -2>, <-.3, 6, -.3> }
        box { <2, 2.6, -2>, <.3, 6, -.3> }
        box { <-2, 2.6, 2>, <-.3, 6, .3> }
        box { <2, 2.6, 2>, <.3, 6, .3> }
        cone { <0, 2.6, 0>, .5, <0, 4.4, 0>, .8 }
        sphere { <0, 4.4, 0>, .8 }
      }
    }
  }
  box { <-2, -2, -2>, <2, 0, 2> }
}

#declare Krolowa = difference {
  union {
    difference {
      sphere { <0, 0, 0>, 1.5 }
      box { <-2, .8, -2>, <2, 2, 2> }
    }
    difference {
      cylinder { <0, .8, 0>, <0, 1.5, 0>, 1.2 }
      union {
        torus { .9, .3 }
        torus { 1, .3 }
        torus { 1.1, .3 }
        torus {1.2, .3 }
          translate 1.2*y
      }
    }
    difference {
      union{
        cone { <0, 1.6, 0>, 1.25, <0, 2.6, 0>, .95 }
        cone { <0, 1.6, 0>, 1.3, <0, 1.85, 0>, 1.2 }
        cone { <0, 1.9, 0>, 1.2, <0, 2.3, 0>, 1.1 }
        cone { <0, 2.35, 0>, 1.1, <0, 2.6, 0>, 1 }
      }
      union {
        torus { .9, .3 }
        torus { 1, .3 }
        torus { 1.1, .3 }
        torus {1.2, .3 }
          translate 1.2*y
      }
    }
    difference {
      cone { <0, 2.6, 0>, .9, <0, 4.9, 0>, 1.3 }
      union {
        cone { <0, 3, 0>, .15, <0, 5, 0>, 1.1 }
        union {
          prism {
            linear_sweep
            linear_spline
            0, 2.5, 4,
            <0, 0>, <-1.5, -3>, <1.5, -3>, <0, 0>
            rotate 30*x
            translate <0, 2.9, -.9>
          }
          prism {
            linear_sweep
            linear_spline
            0, 2.5, 4,
            <0, 0>, <-1.5, -3>, <1.5, -3>, <0, 0>
            rotate 30*x
            translate <0, 2.9, -.9>
            rotate 72*y
          }
          prism {
            linear_sweep
            linear_spline
            0, 2.5, 4,
            <0, 0>, <-1.5, -3>, <1.5, -3>, <0, 0>
            rotate 30*x
            translate <0, 2.9, -.9>
            rotate 144*y
          }
          prism {
            linear_sweep
            linear_spline
            0, 2.5, 4,
            <0, 0>, <-1.5, -3>, <1.5, -3>, <0, 0>
            rotate 30*x
            translate <0, 2.9, -.9>
            rotate 216*y
          }
          prism {
            linear_sweep
            linear_spline
            0, 2.5, 4,
            <0, 0>, <-1.5, -3>, <1.5, -3>, <0, 0>
            rotate 30*x
            translate <0, 2.9, -.9>
            rotate 288*y
          }
        }
      }
    }
  }
  box { <-2, -2, -2>, <2, 0, 2> }
}

#declare Krzyz = union {
  box { <-.15, 5.6, -.1>, <.15, 6.5, .1> }
  box { <-.35, 5.9, -.1>, <.35, 6.2, .1> }
}

#declare Kulki = union {
  sphere { <0, 4.9, 1.2>, .4}
  sphere { <0, 4.9, 1.2>, .4
    rotate 72*y }
  sphere { <0, 4.9, 1.2>, .4
    rotate 144*y }
  sphere { <0, 4.9, 1.2>, .4
    rotate 144*y }
  sphere { <0, 4.9, 1.2>, .4
    rotate 216*y }
  sphere { <0, 4.9, 1.2>, .4
    rotate 288*y }
}

#declare PionekJasny = object { Pionek
  texture { T_Wood1 } }
#declare PionekCiemny = object { Pionek
  texture {T_Wood2 } }

#declare WiezaJasna = object { Wieza
  texture { T_Wood1 } }
#declare WiezaCiemna = object { Wieza
  texture { T_Wood2 } }

#declare GoniecJasny = object { Goniec
  texture { T_Wood1 } }
#declare GoniecCiemny = object { Goniec
  texture { T_Wood2 } }

#declare KonJasny = object { Kon
  texture { T_Wood1 }
  rotate 90*y
}
#declare KonCiemny = object { Kon
  texture { T_Wood2 }
  rotate -90*y
}

#declare KrolJasny = union {
  object { Krol
    texture { T_Wood1 } }
  object { Krzyz
    texture { T_Wood2 } }
}
#declare KrolCiemny = union {
  object { Krol
    texture { T_Wood2 } }
  object { Krzyz
    texture { T_Wood1 } }
}

#declare KrolowaJasna = union {
  object { Krolowa
    texture { T_Wood1 } }
  object { Kulki
    texture { T_Wood2 } }
}
#declare KrolowaCiemna = union {
  object { Krolowa
    texture { T_Wood2 } }
  object { Kulki
    texture { T_Wood1 } }
}

#declare RPJ = union {
  object { PionekJasny }
  object { PionekJasny
    translate 4*x }
  object { PionekJasny
    translate 8*x }
  object { PionekJasny
    translate 12*x }
  object { PionekJasny
    translate 16*x
    translate 8*z }
  object { PionekJasny
    translate 20*x }
  object { PionekJasny
    translate 24*x }
  object { PionekJasny
    translate 28*x }
    translate 4*z
}

#declare RPC = union {
  object { PionekCiemny }
  object { PionekCiemny
    translate 4*x }
  object { PionekCiemny
    translate 8*x }
  object { PionekCiemny
    translate 12*x }
  object { PionekCiemny
    translate 16*x }
  object { PionekCiemny
    translate 20*x }
  object { PionekCiemny
    translate 24*x }
  object { PionekCiemny
    translate 28*x }
    translate 24*z
}


#declare FJ = union {
  object { WiezaJasna }
  object { GoniecJasny
    translate 4*x }
  object { KonJasny
    translate 8*x }
  object { KrolJasny
    translate 12*x }
  object { KrolowaJasna
    translate 16*x }
  object { KonJasny
    translate 20*x }
  object { GoniecJasny
    translate 24*x }
  object { WiezaJasna
    translate 28*x }
}

#declare FC = union {
  object { WiezaCiemna }
  object { GoniecCiemny
    translate 4*x }
  object { KonCiemny
    translate 8*x }
  object { KrolCiemny
    translate 12*x }
  object { KrolowaCiemna
    translate 16*x }
  object { KonCiemny
    translate 20*x }
  object { GoniecCiemny
    translate 24*x }
  object { WiezaCiemna
    translate 28*x }
    translate 28*z
}
