#include "colors.inc"
#include "textures.inc"


#ifndef (IMPORT_CUP)


background { color rgb <0, 0, 0> }

camera {
    location <5, 3, 3>
    look_at <0, 0, 0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color White }//rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color White }//rgb <0.4, 0.25, 0.25> }

#end


#macro tmpM(vv,rr)
    sphere { <0,0,0> rr, 1 scale <5,1,5> translate vv }
#end

#declare theCup=
union {
    torus {
       1, 0.1 translate y*0.1 scale <1,10,1>
    }
    cylinder {<0,0.1,0> <0,0.2,0> 1}
    difference {
        torus {
            1, 0.1
        }
        box {
            <-1.2,-0.2,0> <1.2,0.2,1.2>
        }
        rotate z*90
        scale <2,0.5,0.6>
        translate <0,1.0,-1.05>
    }
    #declare j=0;
    #while (j<3)
    #declare i=0;
    #while (i < 10)
        sphere { <0,0,0> 0.2 scale <1,1,0.1> pigment {color Red} finish {phong 0.5 diffuse 0.5}
            translate <0,0.5+j*0.5,-1.1> rotate y*(36*i+18*j)}
        #declare i=i+1;
    #end
    #declare j=j+1;
    #end
    scale 0.7*<0.8,1,0.8>
    pigment {color White}
    finish {phong 0.5 diffuse 0.5}
}

#declare theCupLying=
union {
object {
    theCup
    rotate y*-117
    rotate x*90
    rotate y*23
    translate <-0.6,0.52,-2.15> 
}
union {
    torus {
       1, 0.1 translate y*0.1 scale <1,10,1>
    }
    cylinder {<0,0.1,0> <0,0.2,0> 1}
    difference {
        torus {
            1, 0.1
        }
        box {
            <-1.2,-0.2,0> <1.2,0.2,1.2>
        }
        rotate z*90
        scale <2,0.5,0.6>
        translate <0,1.0,-1.05>
    }
    #declare j=0;
    #while (j<3)
    #declare i=0;
    #while (i < 10)
        sphere { <0,0,0> 0.2 scale <1,1,0.1> pigment {color Red} finish {phong 0.5 diffuse 0.5}
            translate <0,0.5+j*0.5,-1.1> rotate y*(36*i+18*j)}
        #declare i=i+1;
    #end
    #declare j=j+1;
    #end
    scale 0.7*<0.8,1,0.8>
    rotate y*-119
    pigment {color White}
    finish {phong 0.5 diffuse 0.5}
    rotate x*90
    rotate y*23
    translate <-0.6,0.52,-2.15> 
}
blob {
    threshold 0.5
    tmpM(<0,0,0>,0.3)
    tmpM(<-1,0,0>,0.5)
    tmpM(<2,0,0>,0.5)
    tmpM(<2,0,2>,0.5)
    tmpM(<1,0,-1>,0.3)
    tmpM(<0,0,-2>,0.3)
    /* // a spot
    tmpM(<-1,0,2.5>,0.2)
    tmpM(<-0.6,0,2.8>,0.2)
    */
    translate y*-0.1
    scale <1,0.4,1>*0.4
    pigment {color rgb <0.6,0.3,0.1>*0.8 }
    normal { bumps scale 1 bump_size 0.4}
    finish {diffuse 0.9 phong 0.1}
}
}

#ifndef (IMPORT_CUP)
object {theCupLying}
box {
    -5 5 translate -5*y
    pigment {color Yellow}
}
#end