
#declare ladderSeed=seed(0);

#ifndef (IMPORT_LADDER)
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"


background { color rgb <0, 0, 0> }

camera {
    location <1, 1, -3.5>
    look_at <0, 1, 0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end

// sphere { <0,1,0> 1 pigment {color Blue} }

#declare ladder=
union {   
    #declare i=1;
    #declare lsteps=8;
    #while (i<=lsteps)
        cylinder { <-1,0,0> <1,0,0> 0.1 translate y*i}
        #declare i=i+1;
    #end
    cylinder { <-1,0, 0> <-1,lsteps+1,0> 0.15 }
    cylinder {  <1,0, 0>  <1,lsteps+1,0> 0.15 }
    texture { T_Wood15 rotate z*90 translate x*rand(ladderSeed) }
}

#ifndef (IMPORT_LADDER)
object {ladder scale 0.5}
#end
