#declare mouseSeed=seed(0);

#declare mouseHandEmpty=0;
#declare mouseHandGun=1;
#declare mouseHandFlag=2;
#declare mouseHandHold=3;
#declare mouseHandFork=4;

#declare IMPORT_MOUSEFLAG=1;
#include "mouseflag.pov"

#declare IMPORT_MOUSEGUN=1;
#include "mousegun.pov"

#ifndef(mouseGunHand)
    #declare mouseGunHand=1; // 1-right 0-left
#end 


#ifndef (IMPORT_MOUSE)
#include "colors.inc"

#declare mouseHandTool=mouseHandGun;
#declare mouseHavingGun=yes;

background { color rgb <0, 0, 0> }

camera {
    location <0, 1, -4>
    look_at <0, 1, 0>
    scale 1.5
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end

// sphere { <0,1,0> 1 pigment {color Blue} }

#macro mouseHead()
blob {
    threshold 0.5
    // head
    sphere { <0,2.2,0> 0.5, 1}
    sphere { <0,2.0,-0.2> 0.2, 2}
    sphere { <0,2.0,-0.15> 0.2, 1.3 scale <1,1,1.5> }
    sphere { <0,2.0,-0.25> 0.2, 1 scale <1,1,1.5> }
    sphere { <0,2.0,-0.2> 0.1, 1 scale <1,1,2> }
    
    sphere { <0.1,2.0,-0.1> 0.2, 2}
    sphere { <-0.1,2.0,-0.1> 0.2, 2}

    // bottom connection
    sphere { <0,1.9,0> 0.3, 1 scale <1,1,1> }

    // eye-holes
    sphere { <0.1,2.25,-0.4> 0.3, -1}
    sphere { <-0.1,2.25,-0.4> 0.3, -1}
    texture {mouseTexture}
}
#end

#macro ear()
difference {
blob {
    threshold 0.2
    sphere { <0,0,0> 1 4 scale <0.55,1,0.15> }
    sphere { <0,0,-0.5> 1 strength -15 scale <0.4,1,0.15> }
}           
box {
    <-1,-1,-1> <1,-0.5,1>
}
    scale <0.5,0.4+rand(mouseSeed)*0.3,0.5>*0.7
    texture {mouseTexture}
}
#end

#macro oneEar()
object {
    ear()
    rotate z*35
    rotate x*15
    translate <-0.2,2.4,-0.1>
}
#end

#macro eye()
sphere {                 
    <0.08,2.25,-0.2> 0.07
    pigment {color rgb <0.8,0.2,0.1> }
}
#end
                      

#macro mouseBody()
blob {    
    threshold 0.5
    // body
    //sphere { <0,1.3,-1> 1, -1}
    sphere { <0,1.3,0> 0.7, 1 scale <0.7,0.8,0.5>  }
    sphere { <0,1,0> 1.5, 1 scale <0.7,1,0.5>  }
    sphere { <0,0.7,0> 1.3, 1.0 scale <0.7,0.8,1>  }
    
    sphere { <-1,1.3,0> 1, -1 }
    sphere { <1,1.3,0> 1, -1 }
    
    texture {mouseTexture}
}
#end

#macro mouseLeg()
blob {
    threshold 0.5
    sphere { <0,0,0> 0.5, 1 scale <1,2,1> }
    sphere { <0,0,0> 0.25, 1 scale <1,0.5,2> translate <0,-0.5,-0.25> }
    texture {mouseTexture}
}
#end

#macro mouseArm()
blob {
    threshold 0.5
    cylinder { <0,0,0> <-1,0,0> 0.5, 1}
    sphere { <0,0,0> 0.5, 1 scale <2,1,1> translate x*-0.5 rotate y*-30 translate x*-0.5}
    scale 0.5
    texture {mouseTexture}
}
#end

#declare ps=9;
#declare statistika = array[ps] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like
#declare mouseHeadSeed=seed(0);
#declare forkSeed=seed(0);
#declare mouseColor=seed(0);

#macro mouse(siz)
#declare mouseTexture=
texture {
    normal { bumps scale 0.03 bump_size 1}
    #declare browness=rand(mouseColor)*0.3;
    pigment { color <1.0,1.0-browness,1.0-2*browness> }
    // scale 0.2
}
union {
    union {
        object {mouseHead()}
        object {eye()}
        object {eye() scale <-1,1,1>}
        object {oneEar() translate z*0.1}
        object {oneEar() scale <-1,1,1> translate z*0.1}
        scale 1.2
        translate y*-0.85
        rotate y*makevalue(statistika, 0, 20, mouseHeadSeed)
    }
    object {mouseBody() scale 0.8}
    object {mouseLeg() rotate y*15 translate <-0.1,0.35,0>}
    object {mouseLeg() rotate y*-15 translate <0.1,0.35,0>}
    #switch (mouseHandTool)
    #case (mouseHandGun)
        #declare mouseHavingGun=no; // one gun is enough
        union {
           object {mouseArm() rotate z*10 rotate y*-40 translate <0,1,0> }
           object {mouseArm() rotate z*10 scale <-1,1,1> rotate y*80 translate <0,1,0> }
           object {theGun rotate x*10 scale 0.5 translate <-0.3,1,-0.3>}
           #if (mouseGunHand=0) scale <-1,1,1> #end
        }
        #break
    #case (mouseHandFlag) 
        #declare mouseGunHand=0;
        object { theFlag translate y*0.5 rotate y*-30 rotate z*20 translate <-0.3,1,-0.7>} 
        object {mouseArm() rotate z*30 rotate y*40 translate <0,1,0> }
        object {mouseArm() rotate z*30 rotate y*-80 scale <-1,1,1> translate <0,1,0> }
        #break
    #case (mouseHandHold) 
        object {mouseArm() rotate z*30 rotate y*-60 translate <0,1,0> }
        object {mouseArm() rotate z*30 rotate y*-60 scale <-1,1,1> translate <0,1,0> }
        #break
    #case (mouseHandFork)
        object {theFork scale 0.6
            rotate y*rand(forkSeed)*180
            rotate z*(10+makevalue(statistika,0,30,forkSeed))
            rotate x*(-10+makevalue(statistika,0,10,forkSeed))
            translate <-0.55,1,-0.3> } 
        object {mouseArm() /*rotate z*30*/ rotate y*20 translate <0,1,0> }
        object {mouseArm() rotate z*30 scale <-1,1,1> translate <0,1,0> }
        #break
    #else 
        object {mouseArm() rotate z*30 translate <0,1,0> }
        object {mouseArm() rotate z*30 scale <-1,1,1> translate <0,1,0> }
    #end
    
    #if (mouseHavingGun)
    union {
        object {
            theGun
            scale 0.5
            rotate x*80
            rotate y*70
            rotate z*30
            translate <-0.2,1.1,0.55>
        }
        torus {
            1 0.05
            scale 0.5*<1.2,1,0.95>
            rotate z*-40
            rotate x*16
            translate <0.1,0.83,0.06>
            texture {Cork}
            // pigment {color Gray}
        }
        #if (mouseGunHand=0) scale <-1,1,1> #end
    }
    #end

    translate y*0.2
    
    scale siz/2.3
}
#end

#ifndef (IMPORT_MOUSE)
mouse(2.3)
box {
    -1 1 translate -y
    pigment {color Red}
}
#end
