#include "colors.inc"
#include "textures.inc"


#ifndef (IMPORT_MOUSEGUN)


background { color rgb <0, 0, 0> }

camera {
    location <4, 1, -5>
    look_at <0, 0, 0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end


#declare theGun=
union {
// tube
union {
    difference {
        cylinder { <0,0,0> <0,0,-1.2> 0.1 scale <1,0.8,2> translate y*0.1}
        cylinder { <0,0,-0.7> <0,0,-1.3> 0.1 scale <1,0.8,2> translate y*0.1}
    }
    cylinder { <0,0,0> <0,0,-1.2> 0.1 scale <1,0.8,1.8> }
    torus {1, 0.1 rotate z*90 scale 0.15 translate <0,-0.25,0.5>}
    texture {Chrome_Texture}
}
// stock
blob {
    threshold 0.2
    cylinder { <0,0,0> <0,0,1> 0.3, 1 scale <0.4,0.8,1> }
    sphere { <0,0,0> 0.4, 1 scale <0.4,0.8,2> translate <0,-0.1,1>}
    scale 1.6
    pigment {color rgb <0.6,0.3,0.1>*1.2 }
}
}

#declare rr=0.13;
#declare theFork=
union {
    cylinder { <0,-3,0> <0,2,0> rr }
    difference {
        torus { 1, rr rotate x*90 }
        box { <-1.1-rr,0,-2*rr> <1.1+rr,1.1+rr,2*rr> }
        translate <0,2,0>
    }
    cone { <0,0,0> rr <0,3*rr,0> 0 translate <-1,2,0> }
    cone { <0,0,0> rr <0,3*rr,0> 0 translate <0,2,0> }
    cone { <0,0,0> rr <0,3*rr,0> 0 translate <1,2,0> }
    texture {Gold_Texture}
    translate 3*y
    scale <0.5,0.8,0.5>*0.7
}

#ifndef (IMPORT_MOUSEGUN)
object {theFork}
#end