
#declare borderSeed=seed(3);
#include "colors.inc"
#include "woods.inc"

#ifndef (IMPORT_PICTURE)


background { color rgb <0, 0, 0> }

camera {
    location <1, 0, -3.5>
    look_at <0, 0, 0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end

// sphere { <0,1,0> 1 pigment {color Blue} }

#declare pbwidth=0.08;
#declare pbheight=0.12;
                 
#declare pborder=
difference {
    box { <-1-pbheight,-pbheight,-pbwidth> <1+pbheight,pbheight, pbwidth> }
    cylinder { <-1-pbheight*2,-pbheight, -pbwidth> <1+pbheight*2, -pbheight, -pbwidth> pbwidth*2/3 }
    cylinder { <-1-pbheight*2,+pbheight, -pbwidth> <1+pbheight*2, +pbheight, -pbwidth> pbwidth*2/3 }
    box { <-pbheight*2,0,-pbwidth*1.1> <pbheight*2,pbheight*2, pbwidth*1.1> rotate z*-45 translate x}
    box { <-pbheight*2,0,-pbwidth*1.1> <pbheight*2,pbheight*2, pbwidth*1.1> rotate z*45 translate -x}
    texture {T_Wood17 rotate x*90 rotate z*90 translate y*rand(borderSeed) }
}                 
                 
#declare picture=
union {
union {
    object {pborder translate y*-1}
    object {pborder rotate z*-90 translate x*-1 }
    object {pborder rotate z*180 translate y }
    object {pborder rotate z*90 translate x }
}
box {
    <-1,-1,0> <1,1,0>
    pigment {
        image_map {png "picture.png"}
        scale 2
        translate <-1,-1,0>
    }
}
    scale <1,0.75,1> 
}

#ifndef (IMPORT_PICTURE)
object {picture}
#end
