#version unofficial MegaPov 0.71;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"


#ifndef (IMPORT_SPOON)

background { color rgb <0, 0, 0> }

camera {
    location <3, 2, -5.5>
    //location <6,0,-3>
    look_at <0, 0, -3>
    scale 0.2
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.4, 0.25, 0.25> }

#end

#declare spoonArraySize=16;
#declare spoonArray=array[spoonArraySize]
/* {
    <0,0.0,0.16>,
    <0,0.07,0.23>,
    <0,0.1,0.30>,
    <0,0.1,0.43>,
    <0,0.06,0.63>,
    <0,0.0,0.80>
} 
*/
#declare i=0;
#while (i < spoonArraySize) 
    #declare spoonArray[i] = <0,sin(2/3*pi*i/spoonArraySize)*0.2,0.15+i/spoonArraySize*0.6>;
    #declare i=i+1;
#end


// now the object inside the spoon
#declare Map = color_map { [0.0 rgb 0.0 ] [1.0 rgb 1 ] }

#declare F = function { pigment { bumps /*crackle form <1,0,0>*/ color_map { Map } scale 1/2 }}

#declare isf=
isosurface{ 
      function { x^2+y^2+z^2-F-1 }
      contained_by{ box { -2, 2 } }
      max_gradient 5
      accuracy 1/1000
      scale 2
      pigment { rgb <1.0,0.8,0.4> }
      normal {bumps bump_size 0.3 scale 0.1 }
      finish { phong 0.2 diffuse 0.5 ambient 0.3}
}    

#macro spike(siz)
   cone {
       <0,0,0> siz/4
       <0,siz,0> 0
       pigment {color Black}
       finish {phong 1}
   }    
#end

#declare theBall=
union {
object {isf}
layout {
    object {isf}
    layout_surface
    layout_random_stream seed(0)
    layout_size 1
    layout_count 100
    layout_distance 1
    layout_adjust_normal 1
    layout_overlap_test 100
    "spike"
}
scale 0.04 
}


#declare woodsTexture=
texture {
    T_Wood7
    rotate y*90
}

#declare theWoods=
union {
cylinder {
    <-1,0,0> <1,0,0> 0.15
    texture {woodsTexture}
}
cylinder {
    <-3.3,1,0> <3.3,1,0> 0.15
    texture {woodsTexture}
}
cylinder {
    <-0.8,0,0> <-0.8,1,0> 0.1
    texture {woodsTexture rotate z*90}
}
cylinder {
    <0.8,0,0> <0.8,1,0> 0.1
    texture {woodsTexture rotate z*90}
}
pigment {color White}
scale 0.3
}

#declare tr=1;
#declare halfTorus=difference {
torus {
    tr 0.1
}
box {
    <0,-0.11,-tr-0.11> <tr+0.11,0.11,tr+0.11>
}
}

#declare theSpring=union {
#declare i=0;
#while (i<10)
    object {
        halfTorus
        rotate x*-5
        rotate i*180*y
        translate x*-5
        rotate z*-2*i
    }
    #declare i=i+1;
#end
    translate x*5
    rotate y*-90
    scale 0.2
    texture {Bronze_Texture}
    // pigment {color White}
}

#declare theSpoon=
union {
union {
union {
    difference {
        sphere {<0,0,0>, 0.2}
        sphere {<0,0.1,0>, 0.2}
        cylinder { <0,0.025,0> <0,2,0> 1}
        scale <0.5,0.2,0.8>
    }
    //cylinder { <0,-0.02,0> <0,0.02,0> 0.08 scale <1,1,2> }
    union {
        #declare i=1;
        #while (i < spoonArraySize) 
            sphere {spoonArray[i] 0.015}
            cylinder {spoonArray[i-1], spoonArray[i] 0.015}
            #declare i=i+1;
        #end
        scale <2,0.6,1>
    }
    /*
    blob{
        threshold 0.3
        #declare i=1;
        #while (i < spoonArraySize) 
            cylinder {spoonArray[i-1], spoonArray[i] 0.015, strength 1.0}
            #declare i=i+1;
        #end
        sturm
        scale <2,1,1>
    }
    */
    texture {
        Brushed_Aluminum
        scale 105
    }
    /*
    translate z*-0.2
    scale 2.5
    rotate x*-7
    rotate y*118
    translate <0.4,0.2,-0.3>
    */
    rotate y*180
}
    object {theBall translate y*0.08}

    translate z*0.5
    rotate x*-8
    translate z*-0.5
}
    object {theSpring rotate x*-10
        scale 0.55*<0.2,0.4,0.2> translate <0,0.088,-0.725> }
    object {theWoods scale 0.4 rotate x*-25 translate <0,0.06,-0.67> } 
    translate y*-0.035
}

#ifndef (IMPORT_SPOON)
object {theSpoon}
box {
 -1, <1,0,1>
 pigment {color Red}
}
#end