#version unofficial MegaPov 0.7;

#include "colors.inc"
#include "woods.inc"

// quality
#declare high_quality=yes; // or yes
#declare radiosity_on=yes;
#declare high_quality_radiosity=no;

// objects
#declare show_the_table=yes;
#declare show_the_cat=yes;
#declare show_the_mouses=yes; #declare nMouses=50; //50
#declare show_the_ladder=yes;
#declare show_the_picture=yes;
#declare show_the_catapult=yes;
#declare show_the_todolist=yes;
#declare show_the_shelf=yes;
#declare show_the_cup=yes;
#declare show_the_unit=yes;
#declare show_the_mouse_hole=yes;
#declare show_the_cup_lying=yes;


#if(radiosity_on)
global_settings{ ambient_light 0 

#if(high_quality_radiosity)
  // High Quality - slow rendering
  ini_option "+QR"
  
  radiosity{
    pretrace_start 0.08
    pretrace_end   0.02
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with pretrace_end
                         //   1 : pretrace_end = 0.02
                         //   3 : pretrace_end = 0.08
                         //   use pretrace_start = 0.08
                         // you can go lower than 1, but then you probably will want to set
                         // pretrace_end to 0.01, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#else
  // Medium Quality - works for most scenes
  ini_option "+QR"
  
  radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#end
}
#end



#declare roomHeight=5;
#declare windowSize=1.5;
#declare windowBorder=0.1;

#declare wallTexture=texture {
    pigment {bumps color_map { [0 rgb 0.9] [1 rgb 1 ] } }
    scale 0.1
}

// the room - back
box {
    <-10,-10,5> <10,roomHeight,6>
    texture {wallTexture}
}                        
// the room - left (upperhole)
box {
    <-10,-8,-5> <-9,roomHeight,5>
    texture {wallTexture}
}
// the room - right
box {
    <9,-10,-5> <10,roomHeight,5>
    texture {wallTexture}
}                        
// the room - bottom
box {
    <-10,-10,-5> <9,-9,5>
    texture {
    pigment {
        image_map {png "floor.png"}
        rotate x*90
        scale 3
        translate <-1,-1,0>
    }
    }
}                        
// left-front
box {
    <-10,-10,-6> <-windowSize,roomHeight,-5>
    texture {wallTexture}
}                        
// right-front
box {
    <windowSize,-10,-6> <10,roomHeight,-5>
    texture {wallTexture}
}                        
// top-front
box {
    <-windowSize,windowSize,-6> <windowSize,roomHeight,-5>
    texture {wallTexture}
}                        
// bottom-front
box {
    <-windowSize,-10,-6> <windowSize,-windowSize,-5>
    texture {wallTexture}
}

// window vertical
box {
    <-windowBorder,0,-5.5> <windowBorder,windowSize,-5>
    pigment {color White}
}
// window horizontal
box {
    <-windowSize,-windowBorder,-5.5> <windowSize,windowBorder,-5>
    pigment {color White}
}


light_source { <2, 0.6, -13> colour <1,1,1>
#if (high_quality) 
    area_light <0.25,0,0>, <0,0.25,0>, 5,5 adaptive 1 jitter 
#else 
    // area_light <0.3,0,0>, <0,0.3,0>, 2,2
#end
}
light_source { <0, roomHeight, 0> colour <1,1,1>
#if (high_quality) 
    area_light <0.3,0,0>, <0,0,0.3>, 3,3 jitter
#end
}

camera {
  location <0.5, 2, -4.5>
  look_at <-0.5, -0.7, 0>
}


#declare tableTop = -2.8;

#declare tableMain=union {
    box {
        <-3,tableTop-0.2,-1> <1,tableTop,4.8>
    }
    cylinder {
        <0,-0.2,0> <0,0,0> 5.8/2
        translate <-3,tableTop,3.8/2>
    }
    cylinder {
        <0,-0.2,0> <0,0,0> 5.8/2
        translate <1,tableTop,3.8/2>
    }
}
// table
#declare table=union {
    object {tableMain}
    // borders
    torus {
        5.8/2 0.1
        translate <-3,tableTop-0.1,3.8/2>
    }
    torus {
        5.8/2 0.1
        translate <1,tableTop-0.1,3.8/2>
    }
    cylinder {
        <-3,tableTop-0.1,-1> <1,tableTop-0.1,-1> 0.1
    }
    cylinder {
        <-3,tableTop-0.1,4.8> <1,tableTop-0.1,4.8> 0.1
    }
    // legs (two are enough :)
    cylinder {
        <0,-10,0> <0,tableTop-0.2,0> 0.15
        translate <-4,0,-0.2>
    }
    cylinder {
        <0,-10,0> <0,tableTop-0.2,0> 0.15
        translate <2,0,-0.2>
    }
    pigment {
        image_map {png "wood.png"}
        rotate x*90
        scale 5
    }
}

#declare layoutObject=
difference{
    object {tableMain translate z*-1 scale <0.85,1,0.8> translate z*1}
    box {
        <-0.6,-1,-0.9> <0.6,0,0.6>
        scale 1.5
        rotate y*-20
        translate <-3,tableTop+0.1,1>
    }
    box {
        <-1,-1,-2> <1,1,1>
        rotate y*-14
        translate <-1.2,tableTop,1.0>
    }
    cylinder {
        <0,-2,0> <0,2,0> 1 scale <2,2,1>*0.6
        rotate y*-20
        translate <2.4,tableTop,1.6>
    }
    pigment {color White}
}

#if (show_the_table)
object {table}
#else
object {layoutObject}
#end


#if (show_the_cat)
object {
    #declare IMPORT_SPATCH=1;
    #include "cat.pov"
    scale <0.6,0.5,1>
    translate <-0.5,-0.63,-5>
}
#end


#declare IMPORT_MOUSE=1;
#include "mouse.pov"

#declare layoutPosition=<0,0,0>;
#declare mouseLookAt=<0,3,-3.2>;
                       
#declare mouseToolStream=seed(0);
#declare mouseRotateStream=seed(0);                       
                       
#declare ps=9;
#declare statistika = array[ps] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like
        
#macro layoutMouse(siz)
#alternative (rand(mouseToolStream))
#case (0.7) #declare mouseHavingGun=yes;
#case (0.3) #declare mouseHavingGun=no;
#end

#alternative (rand(mouseToolStream))
#case (0.7) #declare mouseGunHand=1;
#case (0.3) #declare mouseGunHand=0;
#end

#declare mouseHandTool=
#alternative (rand(mouseToolStream))
#case (0.3) mouseHandEmpty;
#case (0.4) mouseHandGun;
#case (0.3) mouseHandFork;
#end

object {
    mouse(siz)
    #declare angl=atan2(mouseLookAt.z-layoutPosition.z, mouseLookAt.x-layoutPosition.x);
    rotate -y*(90+angl*180/pi)
    rotate y*makevalue(statistika, 0, 10, mouseRotateStream)
    //rotate y*(rand(mouseRotateStream)-0.5)*10
} 
#end

#if (show_the_mouses)
layout {
    object {layoutObject}
    // box { <-3,tableTop-0.2,-0.5> <2,tableTop,3> pigment {color White}}
    layout_on_top
    layout_count nMouses
    layout_distance 0.5
    layout_size 0.5
    layout_random_stream seed(1)
    "layoutMouse"
}
#end


#if (show_the_ladder)
#declare IMPORT_LADDER=1;
#include "ladder.pov"
union {
object {ladder scale 0.2 rotate x*20 translate <-2.4,-4,-1.5> }
#declare mouseHavingGun=yes;
object {mouse(0.5) rotate y*180 translate <-2.4,-2.9,-1.15> }
object {mouse(0.5) rotate y*180 translate <-2.4,-3.49,-1.35> }
object {mouse(0.5) rotate y*210 translate <-3.1,tableTop,-0.7> }
translate z*-0.08
}
#end


#if (show_the_picture)
#declare IMPORT_PICTURE=1;
#include "picture.pov"
object {picture scale 2 translate <2,0.5,4.95> }
#end


#if (show_the_todolist)
#declare IMPORT_TODOLIST=1;
#include "todolist.pov"
object {
    todolist
    scale <0.7,0.5,0.5>*0.6
    translate <-5.9,0.9,4.8>
    // translate <2,0.5,4.95>
}
#end


#if (show_the_shelf)
#declare IMPORT_SHELF=1;
#include "shelf.pov"
union {
object {
    shelf
    scale <2,1,2>*0.85
}
#if (show_the_cup)
#ifndef(IMPORT_CUP)
#declare IMPORT_CUP=1;
#include "cup.pov"
#end
object {
    theCup
    scale 0.7
    rotate y*-130
    translate <2,0,-1>
}
#end
    translate <-9.99,-1.4,4.96>
}
#end


#if (show_the_cup_lying)
#ifndef(IMPORT_CUP)
#declare IMPORT_CUP=1;
#include "cup.pov"
#end
object {
    theCupLying
    scale 0.7
    rotate y*-130
    translate <1.3,tableTop,1>
}
#end


#if (show_the_catapult)
#declare mouseHavingGun=no;
#declare IMPORT_SPOON=1;
#include "spoon.pov"
#macro mouseWithARope(siz)
union {
    object {
        #declare mouseHandTool=mouseHandHold;
        mouse(siz)
        translate z*1*siz
    }
    cylinder {
        <0,0,0> <0,0,1*siz> siz/30
        rotate x*25
        translate y*0.4
        pigment { rgb <1.0,0.8,0.4>*0.7 }
        // normal {wood bump_size 0.3 scale 0.1 }
        // finish { phong 0.2 diffuse 0.5 ambient 0.3}
    }
}
#end
union {
    object {
        theSpoon
        scale 2
    }
    // 4 mouses holding the mast
    object {
        mouse(0.5)
        translate <0.4,0,-1.3>
    }
    object {
        mouse(0.5)
        translate <-0.4,0,-1.3>
    }
    object {
        mouse(0.5)
        translate <0.7,0,-1.3>
    }
    object {
        mouse(0.5)
        translate <-0.7,0,-1.3>
    }
    // 4 mouses keeping the ball tight
    #declare zoffset=0.15;
    object {
        mouseWithARope(0.5)
        translate z*zoffset
        rotate y*80
        translate z*-0.15
    }
    object {
        mouseWithARope(0.5)
        translate z*zoffset
        rotate y*-80
        translate z*-0.15
    }
    object {
        mouseWithARope(0.5)
        translate z*zoffset
        rotate y*40
        translate z*-0.15
    }
    object {
        mouseWithARope(0.5)
        translate z*zoffset
        rotate y*-40
        translate z*-0.15
    }
    union {
        object {theBall rotate x*120 scale 2 translate y*0.2}
        object {mouse(0.5) translate z*0.35}
        rotate y*-65
        translate <-0.54,0,-0.7>
    }
    rotate y*-14
    translate <-1.2,tableTop,1.0>
}
object {
    #declare layoutPosition=<-0.55,tableTop,0.4>;
    layoutMouse(0.5)
    translate layoutPosition
}
#end


#if (show_the_unit)
#declare mouseHavingGun=yes;
union {
layout {
    box {<-0.7,-1,-0.7> <0.7,0,0.7> pigment {color White}}
    layout_on_top
    layout_regular <0,0,0> x*0.4 z*0.4
    layout_distance 0.01
    layout_random_stream seed(0)
    layout_size 0.5
    "mouse"
}
#declare mouseHandTool=mouseHandFlag;
    object {
        mouse(0.5)
        translate <0,0,-1>
    }
#declare mouseHandTool=mouseHandEmpty;
    rotate y*-20
    translate <-3,tableTop,1>
}
#end


#if (show_the_mouse_hole)
// the room - left (the hole)
difference {
    box {
        <-10,-9,-5> <-9,-8,5>
    }
    cylinder {
        <-0.6, 0, 0> <0.6, 0, 0> 0.6
        scale <1,1.3,0.6>
        translate <-9.5, -9, 2>
    }                        
    texture {wallTexture}
}
#declare mouseHavingGun=yes;
object {
    mouse(0.5)
    rotate y*-70
    translate <-9,-9,2>
}
object {
    mouse(0.5)
    rotate y*-40
    translate <-8.0,-9,1.7>
}
object {
    mouse(0.5)
    rotate y*-30
    translate <-8.2,-9,1.3>
}
#end

