//A BARREN LANDSCAPE GIVES BLOOM TO LIFE
//DAVID BRIDGE - OCTOBER 2001

#version unofficial MegaPov 0.6;

//SET COMPLEXITY SWITCHES - 0/OFF 1/0N
#declare UseFog=1;
#declare UseComplexPlain=1;
#declare UseComplexTextr=1;
#declare UseFern=1;
#declare UsePlant=0;

camera { location <0, 3, -15> look_at <0, 0, 0> angle 60}

light_source //LIGHT1 - OVER THE PLANT
{ 
   <2.0, 20.0, -10>
  color rgb <1.000, 1.000, 1.000>
}

light_source //LIGHT2 - TO PROVIDE THE SHADOWS
{ 
   <5.0, 3.0, -20.0>
  color rgb <1.000, 1.000, 1.000>
}

// ---------------------------------------

#declare _auto_name_no_1_ = 
   texture  
   {   
      pigment
      {
         color rgb <0.2, 0.2, 0.4>
      }   
      finish
      {
         ambient 0.7
         diffuse 0.0
      }
   }
   texture  
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.85, 0.85, 0.85, 0.0, 0.0> ]
            [ 0.1     rgbft <1.0, 1.0, 0.75, 0.0, 0.0> ]
            [ 0.5     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
         }
         turbulence 0.65
         omega 0.7
         ramp_wave
         scale  <6.0, 1.0, 6.0>
      }   
      finish
      {
         ambient 1.0
         diffuse 0.0
      }
   }
   texture  
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.85, 0.85, 0.85, 0.0, 0.0> ]
            [ 0.1     rgbft <1.0, 1.0, 0.75, 0.0, 0.0> ]
            [ 0.5     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
         }
         turbulence 0.65
         omega 0.7
         ramp_wave
         scale  <6.0, 1.0, 6.0>
         translate -0.15 * y
      }   
      finish
      {
         ambient 0.6
         diffuse 0.0
      }
   }

#declare Shadow_Clouds = 
   material  // Shadow_Clouds
   {   
      texture { _auto_name_no_1_ }
   }

plane //SKY PLAIN
{
  y,100
  material {Shadow_Clouds scale 75}
  hollow
  rotate y*180
  rotate x*5
}

#if(UseFog)
fog //BACKGROUND FOG
{
 fog_type 1
 colour rgbt <0.80, 0.85, 0.70, 0.20>
 distance 50
 turbulence 5
 turb_depth 0.75
}
#end //UseFog

#declare Rocky_Surface = 
texture
{ 
pigment
{
agate
agate_turb 2.0
color_map
{
[ 0.00 rgb <0.40, 0.40, 0.40> ]
[ 0.75 rgb <0.10, 0.20, 0.20> ]
[ 1.00 rgb <0.70, 0.75, 0.75> ]
}
} 
normal
{
agate , 0.5
agate_turb 1.0
} 
finish
{
ambient 0.25
specular 0.200
reflection 0.2
}
}

#if(UseComplexPlain)

#declare R = 750;

isosurface
{
 function { y + noise3d(x*5,  y*10, z*5)*2.5 }
 accuracy 0.001
 contained_by{sphere{0,R}}

texture 
 #if (UseComplexTextr)
 {
    Rocky_Surface
 }
 #else
 {
   pigment{colour rgb 0.6}
 } 
#end //UseComplexTxtr

}

#else //NOT UseComplexPlain

plane
{
  y,0
 texture

#if (UseComplexTextr)
 {
    Rocky_Surface
 }
 #else
 {
   pigment{colour rgb 0.6}
 } 
#end //UseComplexTxtr

hollow

}

#end //UseComplexPlain

#if(UseFern)
#declare Leaf_Txtr = 
texture
{      
         pigment
         {
            agate
            agate_turb 2.0
            color_map
            {
               [ 0.00 rgb <0.00, 0.70, 0.00> ]
               [ 0.50 rgb <0.20, 0.40, 0.00> ]
               [ 0.80 rgb <0.00, 0.50, 0.00> ]
               [ 1.00 rgb <0.00, 0.70, 0.00> ]
            }
         }      
         normal
         {
            agate , 2.0
            agate_turb 2.0
         }      
         finish
         {
            ambient 0.1
            specular 0.25
         }
}

#include "DBs_Fern.inc"

object
{
   DBs_Fern
   texture
   {
      Leaf_Txtr
   }
   scale 0.20
   //rotate x*-20
   translate <2.0, -0.3, -9.5>
}
#end //UseFern

#if(UsePlant)
#include "Autumn_plant.inc"
object
{
   Autumn_weed
   scale 0.01
   scale y*0.25
   translate <2.0, -0.15, -10> 
}
#end //UsePlant