#macro roundBox(w,h,d,r)
union
{
  box
  {
    <-w/2,-h/2+r,-d/2+r>
    <w/2,h/2-r,d/2-r>
  }
  box                                                                              
  {
    <-w/2+r,-h/2,-d/2+r>
    <w/2-r,h/2,d/2-r>
  }
  box
  {
    <-w/2+r,-h/2+r,-d/2>
    <w/2-r,h/2-r,d/2>
  } 
  
  cylinder
  {
    <-w/2+r,0,0>
    <+w/2-r,0,0>
    r
    translate<0,h/2-r,-d/2+r>
  }
  cylinder
  {
    <-w/2+r,0,0>
    <+w/2-r,0,0>
    r
    translate<0,-h/2+r,-d/2+r>
  }
  cylinder
  {
    <-w/2+r,0,0>
    <+w/2-r,0,0>
    r
    translate<0,-h/2+r,d/2-r>
  }
  cylinder
  {
    <-w/2+r,0,0>
    <+w/2-r,0,0>
    r
    translate<0,h/2-r,d/2-r>
  } 
  
  
  cylinder
  {
    <0,-h/2+r,0>
    <0,+h/2-r,0>
    r
    translate<w/2-r,0,d/2-r>
  } 
  
  cylinder
  {
    <0,-h/2+r,0>
    <0,+h/2-r,0>
    r
    translate<-w/2+r,0,d/2-r>
  } 
  
  cylinder
  {
    <0,-h/2+r,0>
    <0,+h/2-r,0>
    r
    translate<-w/2+r,0,-d/2+r>
  } 
  
  cylinder
  {
    <0,-h/2+r,0>
    <0,+h/2-r,0>
    r
    translate<w/2-r,0,-d/2+r>
  } 
  
  cylinder
  {
    <0,0,-d/2+r>
    <0,0,+d/2-r>
    r
    translate<-w/2+r,h/2-r,0>
  } 
  cylinder
  {
    <0,0,-d/2+r>
    <0,0,+d/2-r>
    r
    translate<w/2-r,h/2-r,0>
  } 
  cylinder
  {
    <0,0,-d/2+r>
    <0,0,+d/2-r>
    r
    translate<-w/2+r,-h/2+r,0>
  } 
  cylinder
  {
    <0,0,-d/2+r>
    <0,0,+d/2-r>
    r
    translate<w/2-r,-h/2+r,0>
  }       
  
  sphere{ <w/2 - r, h/2 - r, d/2 - r> , r}
  sphere{ <w/2 - r, -h/2 + r, d/2 - r> , r}
  sphere{ <w/2 - r, -h/2 + r, -d/2 + r> , r}
  sphere{ <w/2 - r, h/2 - r, -d/2 + r> , r}
  sphere{ <-w/2+  r, h/2 - r, d/2 - r> , r}
  sphere{ <-w/2+  r, -h/2 + r, d/2 - r> , r}
  sphere{ <-w/2+  r, -h/2 + r, -d/2 + r> , r}
  sphere{ <-w/2+  r, h/2 - r, -d/2 + r> , r}
  
  
  
}                       
#end

#macro sqrDohNutLWRr(l,w,R,r)
object                       
{

#declare sdnarc =
intersection
{
  torus{R,r}
  box
  {
    <0,-2*r,0> 
    <2*(R+r),2*r,2*(R+r)>
  }
  translate<-R,0,0>
  rotate<-90,0,0>
}

  union
  {
    cylinder
    {
      <l/2+r,w/2-R+r,0>
      <l/2+r,-w/2+R-r,0>
      r
    }    
    
    cylinder
    {
      <-l/2-r,w/2-R+r,0>
      <-l/2-r,-w/2+R-r,0>
      r
    }
    
    cylinder
    {
      <-l/2-r+R,w/2+r,0>
      <l/2+r-R,w/2+r,0>
      r
    }    
    
    cylinder
    {
      <-l/2-r+R,-w/2-r,0>
      <l/2+r-R,-w/2-r,0>
      r
    } 
    
    object
    {
      sdnarc 
      translate<l/2+r,w/2-R+r,0>
    }
    
    object
    {
      sdnarc
      rotate<0,180,0> 
      translate<-l/2-r,w/2-R+r,0>
    } 
    
    object
    {
      sdnarc
      rotate<180,0,0> 
      translate<l/2+r,-w/2+R-r,0>
    }
    
    
    object
    {
      sdnarc
      rotate<180,0,0>
      rotate<0,180,0> 
      translate<-l/2-r,-w/2+R-r,0>
    }
    
    
  }
}
#end

