//The final scene - feather.pov
//Copyrighted by Johnny Yip 2001

#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "smoke.inc"
#include "feather.inc"

#declare Cam_Loc = <3,100,-10>;
#declare Cam_Look = <-3,10,0>;

//Bird eye view
camera {
  location Cam_Loc         //for smoke
  right <320/200,0,0>
  up <0,200/200,0>
  look_at Cam_Look
  aperture 0.01
  blur_samples 20 //30
  focal_point <2.91,99.2,-10.1>
  confidence 0.999
  variance 1/700
}

// Side/ Front for testing mode only
/*camera {
  location <-100,200,-100>         //for smoke
  look_at <0,00,0>
}*/
                                                                                                                              
                                                                                                                              
//-------- REal Light ------------//
light_source { <0,200,10>, 0.5 }     //0.6,0.5,0.5
light_source { <300,1000,200>, 0.5 }

//light_source { <300,600,200>, <0.3,0.3,0.3>}
//light_source { <1000,0,0>, <.9,0.9,.9>}
//light_source { <-50,50,-50>, <.6,0.6,.6>}
//light_source { <-50,100,-50>, <.8,0.8,.8>}

//---------- Smoke objects -------------//
object { FaintSmoke scale 0.5 translate <0,0,-7>}    
object { HeavySmoke scale 0.5 rotate <0,-30,40> translate <-30,-10,-20>}

//Feather
object { Feather scale 0.004 rotate <0,-90,0> translate <2.91,99.6,-10.1>}

//Orient the water texture properly
#declare x_ang = 90-degrees(atan2((abs(Cam_Loc.y) + abs(Cam_Look.y)), (abs(Cam_Loc.z) + abs(Cam_Look.z))));
#declare y_ang = 90-degrees(atan2((abs(Cam_Loc.z) + abs(Cam_Look.z)), (abs(Cam_Loc.x) + abs(Cam_Look.x))));
#declare z_ang = 90-degrees(atan2((abs(Cam_Loc.y) + abs(Cam_Look.y)), (abs(Cam_Loc.x) + abs(Cam_Look.x))));

#declare waterLevel =box { <0.5,0.5,0.1>, <-0.5,-0.5,-0.1>
  pigment {
    image_map {
      tga "water.tga"
      map_type 0
      //interpolate 2
      once
    }
    translate <-0.5,-0.5,0>
  }
  finish { ambient 0.7 diffuse 0}
  rotate <90,0,0>
  scale <320,1,200>

  rotate <-x_ang,-y_ang,-z_ang+3>
  translate Cam_Look + <-8,-103,15>
}

object { waterLevel }

//World Axis
/*sphere { <0,0,0>, 2 pigment { Green }}
cylinder { <0,0,0>, <10,0,0>, 1 pigment { White }}
cylinder { <0,0,0>, <0,10,0>, 1 pigment { White }}
cylinder { <0,0,0>, <0,0,10>, 1 pigment { White }}*/

sky_sphere {
  pigment {
    image_map {
      tga "sky2.tga"
      map_type 0
      interpolate 2
    }
    rotate <50,20,60>   //60,20,60
  }
}

//================================ SCENE DESCRIPTION ENDS HERE ==========================================//