//Hangar.pov file for International Raytrace Contest
// by Chris Holtorf
//email lholtorf@nwlink.com


#version unofficial MegaPov 0.7;  
global_settings { radiosity {} }

#include "colors.inc"
#include "textures.inc"
#include "kolors.inc"

camera
{
  sky      -y
  right    -4/3*x
  location  < 1500, -650, -250>
  look_at   <-320,-200,960>
  rotate   <0,1e-5,0>
}

//Lights
light_source
{
        <-126.584,-1456.53,-204.703>
        color <1,1,.85>
        area_light <10, 1, 10>, <10, 1, 10>, 10, 10
        adaptive 1
        jitter 
} 
light_source
{
        <1120.79,-1112.08,1691.5>
        color <1,1,.85>
        area_light <10, 1, 10>, <10, 1, 10>, 10, 10
        adaptive 1
        jitter 
}
light_source
{
        <-846.755,-1720.84,1387.12>
        color <1,1,.85>
        area_light <10, 1, 10>, <10, 1, 10>, 10, 10
        adaptive 1
        jitter 
}

//Lego Parts setup
#declare QUAL = 2;  // Quality level, 0=BBox, 1=no refr, 2=normal, 3=studlogo

#declare SW = 0.75;  // Width of seam between two bricks

#declare STUDS = 1;  // 1=on 0=off

#declare BUMPS = 1;  // 1=on 0=off

#declare ver = 3.1;

#declare BUMPNORMAL = normal { bumps 0.01 scale 20 }
#declare AMB = 0.4;
#declare DIF = 0.4;


#declare O7071 = sqrt(0.5);

#declare L3Logo = union {
	sphere {<-59,0,-96>,6}
	cylinder {<-59,0,-96>,<59,0,-122>,6 open}
	scale 4.5/128
}  

#ifndef (Color7)
#declare Color7 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.682353,0.682353,0.682353> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color0)
#declare Color0 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.301961,0.301961,0.301961> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color15)
#declare Color15 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <1,1,1> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color23)
#declare Color23 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.298039,0,0.8> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color4)
#declare Color4 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.968627,0.160784,0.054902> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color11)
#declare Color11 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.65098,0.94902,1> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color14)
#declare Color14 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <1,0.905882,0.211765> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color8)
#declare Color8 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.47451,0.47451,0.45098> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color6)
#declare Color6 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.564706,0.337255,0.184314> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color36)
#declare Color36 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.968627,0.160784,0.054902> #if (QUAL > 1) filter 0.975 #end }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.2 }
		#if (ver >= 3.1) #else finish { refraction 1 ior 1.25 } #end
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) #if (QUAL > 1) interior { ior 1.25 } #end } #end
#end

#ifndef (Color46)
#declare Color46 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <1,0.905882,0.211765> #if (QUAL > 1) filter 0.975 #end }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.2 }
		#if (ver >= 3.1) #else finish { refraction 1 ior 1.25 } #end
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) #if (QUAL > 1) interior { ior 1.25 } #end } #end
#end

#ifndef (Color2)
#declare Color2 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.117647,0.627451,0.227451> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color383)
#declare Color383 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.9,0.9,0.9> }
	finish {
		ambient 0.25
		diffuse 0.6
		#if (QUAL > 1)
			brilliance 5
			metallic
			specular 0.80
			roughness 1/100
			reflection 0.65
		#end
	}
	#if (BUMPS & (QUAL>1)) normal { BUMPNORMAL } #end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color39)
#declare Color39 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.682353,0.682353,0.682353> #if (QUAL > 1) filter 0.975 #end }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.2 }
		#if (ver >= 3.1) #else finish { refraction 1 ior 1.25 } #end
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) #if (QUAL > 1) interior { ior 1.25 } #end } #end
#end

#ifndef (Color42)
#declare Color42 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.862745,1,0.0392157> #if (QUAL > 1) filter 0.975 #end }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.2 }
		#if (ver >= 3.1) #else finish { refraction 1 ior 1.25 } #end
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) #if (QUAL > 1) interior { ior 1.25 } #end } #end
#end

#ifndef (Color18)
#declare Color18 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <1,1,0.501961> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color1)
#declare Color1 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.0823529,0.376471,0.976471> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color27)
#declare Color27 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.678431,0.866667,0.313726> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color19)
#declare Color19 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.8,0.666667,0.4> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color40)
#declare Color40 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.47451,0.47451,0.45098> #if (QUAL > 1) filter 0.975 #end }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.2 }
		#if (ver >= 3.1) #else finish { refraction 1 ior 1.25 } #end
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) #if (QUAL > 1) interior { ior 1.25 } #end } #end
#end

#ifndef (Color13)
#declare Color13 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <1,0.654902,0.811765> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color3)
#declare Color3 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0,0.654902,0.627451> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#ifndef (Color22)
#declare Color22 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.6,0.2,0.6> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#declare rect_dot_dat = object {
	mesh {
		triangle { <1,0,1>, <1,0,-1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,0,1>, <1,0,1> }
	}
}

#declare stud_dot_dat = 
#if (QUAL <= 2)
cylinder { <0,0,0>, <0,-4,0>, 6 }
#else
union {
	cylinder { <0,0,0>, <0,-4,0>, 6 }
	object { L3Logo translate <0,-4,0> }
}
#end

#declare _1_dash_4disc_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 1
		clipped_by { box { <0,-1,0>, <2,1,2> } }
	}
#else
	cylinder {
		<0,-0.001,0>, <0,0.001,0>, 1
		clipped_by { box { <0,-1,0>, <2,1,2> } }
	}
#end

#declare _1_dash_4cyli_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open clipped_by { box { <0,-1,0>,<2,2,2> } } }

#declare _606p01_dot_dat = #if (QUAL = 0) box { <-320,-4,-320>, <320,4,320> } #else union {
	mesh {
		triangle { <133,0,320>, <133,0,-320>, <117,0,-320> }
		triangle { <117,0,-320>, <117,0,320>, <133,0,320> }
		triangle { <-117,0,320>, <-117,0,-320>, <-133,0,-320> }
		triangle { <-133,0,-320>, <-133,0,320>, <-117,0,320> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,10,0,0,310> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,256> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,128> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,64> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,-64> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,-128> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,-256> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,10,0,0,-310> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <316,0,320>, <133,0,320>, <133,0,-320> }
		triangle { <133,0,-320>, <316,0,-320>, <316,0,320> }
		triangle { <117,0,320>, <6,0,320>, <6,0,-320> }
		triangle { <6,0,-320>, <117,0,-320>, <117,0,320> }
		triangle { <-316,0,320>, <-133,0,320>, <-133,0,-320> }
		triangle { <-133,0,-320>, <-316,0,-320>, <-316,0,320> }
		triangle { <-117,0,320>, <-6,0,320>, <-6,0,-320> }
		triangle { <-6,0,-320>, <-117,0,-320>, <-117,0,320> }
		triangle { <6,0,300>, <6,0,276>, <-6,0,276> }
		triangle { <-6,0,276>, <-6,0,300>, <6,0,300> }
		triangle { <6,0,236>, <6,0,212>, <-6,0,212> }
		triangle { <-6,0,212>, <-6,0,236>, <6,0,236> }
		triangle { <6,0,172>, <6,0,148>, <-6,0,148> }
		triangle { <-6,0,148>, <-6,0,172>, <6,0,172> }
		triangle { <6,0,108>, <6,0,84>, <-6,0,84> }
		triangle { <-6,0,84>, <-6,0,108>, <6,0,108> }
		triangle { <6,0,44>, <6,0,20>, <-6,0,20> }
		triangle { <-6,0,20>, <-6,0,44>, <6,0,44> }
		triangle { <6,0,-300>, <6,0,-276>, <-6,0,-276> }
		triangle { <-6,0,-276>, <-6,0,-300>, <6,0,-300> }
		triangle { <6,0,-236>, <6,0,-212>, <-6,0,-212> }
		triangle { <-6,0,-212>, <-6,0,-236>, <6,0,-236> }
		triangle { <6,0,-172>, <6,0,-148>, <-6,0,-148> }
		triangle { <-6,0,-148>, <-6,0,-172>, <6,0,-172> }
		triangle { <6,0,-108>, <6,0,-84>, <-6,0,-84> }
		triangle { <-6,0,-84>, <-6,0,-108>, <6,0,-108> }
		triangle { <6,0,-44>, <6,0,-20>, <-6,0,-20> }
		triangle { <-6,0,-20>, <-6,0,-44>, <6,0,-44> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-90> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-110> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-130> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-310> }
	#end
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,316,4,316> }
	mesh {
		triangle { <316,4,316>, <316,4,320>, <-316,4,320> }
		triangle { <-316,4,320>, <-316,4,316>, <316,4,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,4,-316,4,316> }
	mesh {
		triangle { <-316,4,316>, <-320,4,316>, <-320,4,-316> }
		triangle { <-320,4,-316>, <-316,4,-316>, <-316,4,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,-4,-316,4,-316> }
	mesh {
		triangle { <-316,4,-316>, <-316,4,-320>, <316,4,-320> }
		triangle { <316,4,-320>, <316,4,-316>, <-316,4,-316> }
	}
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,-4,316,4,-316> }
	mesh {
		triangle { <316,4,-316>, <320,4,-316>, <320,4,316> }
		triangle { <320,4,316>, <316,4,316>, <316,4,-316> }
		triangle { <316,4,316>, <-316,4,316>, <-316,4,-316> }
		triangle { <-316,4,-316>, <316,4,-316>, <316,4,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,316,0,316> }
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,4,-316,0,316> }
	mesh {
		triangle { <-316,0,316>, <-320,0,316>, <-320,0,-316> }
		triangle { <-320,0,-316>, <-316,0,-316>, <-316,0,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,-4,-316,0,-316> }
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,-4,316,0,-316> }
	mesh {
		triangle { <316,0,-316>, <320,0,-316>, <320,0,316> }
		triangle { <320,0,316>, <316,0,316>, <316,0,-316> }
	}
	object { _1_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,316,0,316> }
	mesh {
		triangle { <316,4,320>, <316,0,320>, <-316,0,320> }
		triangle { <-316,0,320>, <-316,4,320>, <316,4,320> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-4,0,0,0,4,0,0,0,4,-316,0,316> }
	mesh {
		triangle { <-320,4,316>, <-320,0,316>, <-320,0,-316> }
		triangle { <-320,0,-316>, <-320,4,-316>, <-320,4,316> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-4,0,0,0,4,0,0,0,-4,-316,0,-316> }
	mesh {
		triangle { <-316,4,-320>, <-316,0,-320>, <316,0,-320> }
		triangle { <316,0,-320>, <316,4,-320>, <-316,4,-320> }
	}
	object { _1_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,-4,316,0,-316> }
	mesh {
		triangle { <320,4,-316>, <320,0,-316>, <320,0,316> }
		triangle { <320,0,316>, <320,4,316>, <320,4,-316> }
	}
}
#end

#declare _607p01_dot_dat = #if (QUAL = 0) box { <-320,-4,-320>, <320,4,320> } #else union {
	mesh {
		triangle { <133,0,320>, <117,0,320>, <117,0,117> }
		triangle { <117,0,117>, <133,0,133>, <133,0,320> }
		triangle { <-133,0,320>, <-117,0,320>, <-117,0,117> }
		triangle { <-117,0,117>, <-133,0,133>, <-133,0,320> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,10,0,0,310> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,20,0,0,256> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,-100,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,-75,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,-50,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,-25,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,0,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,25,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,50,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,75,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,30,100,0,192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <117,0,162>, <-117,0,162>, <-117,0,117> }
		triangle { <-117,0,117>, <117,0,117>, <117,0,162> }
		triangle { <117,0,222>, <6,0,222>, <6,0,320> }
		triangle { <6,0,320>, <117,0,320>, <117,0,222> }
		triangle { <-117,0,222>, <-6,0,222>, <-6,0,320> }
		triangle { <-6,0,320>, <-117,0,320>, <-117,0,222> }
		triangle { <6,0,300>, <6,0,276>, <-6,0,276> }
		triangle { <-6,0,276>, <-6,0,300>, <6,0,300> }
		triangle { <6,0,236>, <6,0,222>, <-6,0,222> }
		triangle { <-6,0,222>, <-6,0,236>, <6,0,236> }
		triangle { <-108,0,222>, <-117,0,222>, <-117,0,162> }
		triangle { <-117,0,162>, <-108,0,162>, <-108,0,222> }
		triangle { <-83,0,222>, <-92,0,222>, <-92,0,162> }
		triangle { <-92,0,162>, <-83,0,162>, <-83,0,222> }
		triangle { <-58,0,222>, <-67,0,222>, <-67,0,162> }
		triangle { <-67,0,162>, <-58,0,162>, <-58,0,222> }
		triangle { <-33,0,222>, <-42,0,222>, <-42,0,162> }
		triangle { <-42,0,162>, <-33,0,162>, <-33,0,222> }
		triangle { <-8,0,222>, <-17,0,222>, <-17,0,162> }
		triangle { <-17,0,162>, <-8,0,162>, <-8,0,222> }
		triangle { <8,0,222>, <17,0,222>, <17,0,162> }
		triangle { <17,0,162>, <8,0,162>, <8,0,222> }
		triangle { <33,0,222>, <42,0,222>, <42,0,162> }
		triangle { <42,0,162>, <33,0,162>, <33,0,222> }
		triangle { <58,0,222>, <67,0,222>, <67,0,162> }
		triangle { <67,0,162>, <58,0,162>, <58,0,222> }
		triangle { <83,0,222>, <92,0,222>, <92,0,162> }
		triangle { <92,0,162>, <83,0,162>, <83,0,222> }
		triangle { <108,0,222>, <117,0,222>, <117,0,162> }
		triangle { <117,0,162>, <108,0,162>, <108,0,222> }
	}
	mesh {
		triangle { <133,0,-320>, <117,0,-320>, <117,0,-117> }
		triangle { <117,0,-117>, <133,0,-133>, <133,0,-320> }
		triangle { <-133,0,-320>, <-117,0,-320>, <-117,0,-117> }
		triangle { <-117,0,-117>, <-133,0,-133>, <-133,0,-320> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,-10,0,0,-310> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,-20,0,0,-256> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,-100,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,-75,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,-50,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,-25,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,0,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,25,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,50,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,75,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <8,0,0,0,1,0,0,0,-30,100,0,-192> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <117,0,-162>, <-117,0,-162>, <-117,0,-117> }
		triangle { <-117,0,-117>, <117,0,-117>, <117,0,-162> }
		triangle { <117,0,-222>, <6,0,-222>, <6,0,-320> }
		triangle { <6,0,-320>, <117,0,-320>, <117,0,-222> }
		triangle { <-117,0,-222>, <-6,0,-222>, <-6,0,-320> }
		triangle { <-6,0,-320>, <-117,0,-320>, <-117,0,-222> }
		triangle { <6,0,-300>, <6,0,-276>, <-6,0,-276> }
		triangle { <-6,0,-276>, <-6,0,-300>, <6,0,-300> }
		triangle { <6,0,-236>, <6,0,-222>, <-6,0,-222> }
		triangle { <-6,0,-222>, <-6,0,-236>, <6,0,-236> }
		triangle { <-108,0,-222>, <-117,0,-222>, <-117,0,-162> }
		triangle { <-117,0,-162>, <-108,0,-162>, <-108,0,-222> }
		triangle { <-83,0,-222>, <-92,0,-222>, <-92,0,-162> }
		triangle { <-92,0,-162>, <-83,0,-162>, <-83,0,-222> }
		triangle { <-58,0,-222>, <-67,0,-222>, <-67,0,-162> }
		triangle { <-67,0,-162>, <-58,0,-162>, <-58,0,-222> }
		triangle { <-33,0,-222>, <-42,0,-222>, <-42,0,-162> }
		triangle { <-42,0,-162>, <-33,0,-162>, <-33,0,-222> }
		triangle { <-8,0,-222>, <-17,0,-222>, <-17,0,-162> }
		triangle { <-17,0,-162>, <-8,0,-162>, <-8,0,-222> }
		triangle { <8,0,-222>, <17,0,-222>, <17,0,-162> }
		triangle { <17,0,-162>, <8,0,-162>, <8,0,-222> }
		triangle { <33,0,-222>, <42,0,-222>, <42,0,-162> }
		triangle { <42,0,-162>, <33,0,-162>, <33,0,-222> }
		triangle { <58,0,-222>, <67,0,-222>, <67,0,-162> }
		triangle { <67,0,-162>, <58,0,-162>, <58,0,-222> }
		triangle { <83,0,-222>, <92,0,-222>, <92,0,-162> }
		triangle { <92,0,-162>, <83,0,-162>, <83,0,-222> }
		triangle { <108,0,-222>, <117,0,-222>, <117,0,-162> }
		triangle { <117,0,-162>, <108,0,-162>, <108,0,-222> }
	}
	mesh {
		triangle { <320,0,133>, <320,0,117>, <117,0,117> }
		triangle { <117,0,117>, <133,0,133>, <320,0,133> }
		triangle { <320,0,-133>, <320,0,-117>, <117,0,-117> }
		triangle { <117,0,-117>, <133,0,-133>, <320,0,-133> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object { rect_dot_dat matrix <0,0,6,0,1,0,10,0,0,310,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,6,0,1,0,20,0,0,256,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,-100> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,-75> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,-50> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,-25> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,25> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,50> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,75> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,30,0,0,192,0,100> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <162,0,117>, <162,0,-117>, <117,0,-117> }
		triangle { <117,0,-117>, <117,0,117>, <162,0,117> }
		triangle { <222,0,117>, <222,0,6>, <320,0,6> }
		triangle { <320,0,6>, <320,0,117>, <222,0,117> }
		triangle { <222,0,-117>, <222,0,-6>, <320,0,-6> }
		triangle { <320,0,-6>, <320,0,-117>, <222,0,-117> }
		triangle { <300,0,6>, <276,0,6>, <276,0,-6> }
		triangle { <276,0,-6>, <300,0,-6>, <300,0,6> }
		triangle { <236,0,6>, <222,0,6>, <222,0,-6> }
		triangle { <222,0,-6>, <236,0,-6>, <236,0,6> }
		triangle { <222,0,-108>, <222,0,-117>, <162,0,-117> }
		triangle { <162,0,-117>, <162,0,-108>, <222,0,-108> }
		triangle { <222,0,-83>, <222,0,-92>, <162,0,-92> }
		triangle { <162,0,-92>, <162,0,-83>, <222,0,-83> }
		triangle { <222,0,-58>, <222,0,-67>, <162,0,-67> }
		triangle { <162,0,-67>, <162,0,-58>, <222,0,-58> }
		triangle { <222,0,-33>, <222,0,-42>, <162,0,-42> }
		triangle { <162,0,-42>, <162,0,-33>, <222,0,-33> }
		triangle { <222,0,-8>, <222,0,-17>, <162,0,-17> }
		triangle { <162,0,-17>, <162,0,-8>, <222,0,-8> }
		triangle { <222,0,8>, <222,0,17>, <162,0,17> }
		triangle { <162,0,17>, <162,0,8>, <222,0,8> }
		triangle { <222,0,33>, <222,0,42>, <162,0,42> }
		triangle { <162,0,42>, <162,0,33>, <222,0,33> }
		triangle { <222,0,58>, <222,0,67>, <162,0,67> }
		triangle { <162,0,67>, <162,0,58>, <222,0,58> }
		triangle { <222,0,83>, <222,0,92>, <162,0,92> }
		triangle { <162,0,92>, <162,0,83>, <222,0,83> }
		triangle { <222,0,108>, <222,0,117>, <162,0,117> }
		triangle { <162,0,117>, <162,0,108>, <222,0,108> }
	}
	mesh {
		triangle { <-320,0,133>, <-320,0,117>, <-117,0,117> }
		triangle { <-117,0,117>, <-133,0,133>, <-320,0,133> }
		triangle { <-320,0,-133>, <-320,0,-117>, <-117,0,-117> }
		triangle { <-117,0,-117>, <-133,0,-133>, <-320,0,-133> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object { rect_dot_dat matrix <0,0,6,0,1,0,-10,0,0,-310,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,6,0,1,0,-20,0,0,-256,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,-100> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,-75> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,-50> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,-25> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,0> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,25> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,50> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,75> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { rect_dot_dat matrix <0,0,8,0,1,0,-30,0,0,-192,0,100> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <-162,0,117>, <-162,0,-117>, <-117,0,-117> }
		triangle { <-117,0,-117>, <-117,0,117>, <-162,0,117> }
		triangle { <-222,0,117>, <-222,0,6>, <-320,0,6> }
		triangle { <-320,0,6>, <-320,0,117>, <-222,0,117> }
		triangle { <-222,0,-117>, <-222,0,-6>, <-320,0,-6> }
		triangle { <-320,0,-6>, <-320,0,-117>, <-222,0,-117> }
		triangle { <-300,0,6>, <-276,0,6>, <-276,0,-6> }
		triangle { <-276,0,-6>, <-300,0,-6>, <-300,0,6> }
		triangle { <-236,0,6>, <-222,0,6>, <-222,0,-6> }
		triangle { <-222,0,-6>, <-236,0,-6>, <-236,0,6> }
		triangle { <-222,0,-108>, <-222,0,-117>, <-162,0,-117> }
		triangle { <-162,0,-117>, <-162,0,-108>, <-222,0,-108> }
		triangle { <-222,0,-83>, <-222,0,-92>, <-162,0,-92> }
		triangle { <-162,0,-92>, <-162,0,-83>, <-222,0,-83> }
		triangle { <-222,0,-58>, <-222,0,-67>, <-162,0,-67> }
		triangle { <-162,0,-67>, <-162,0,-58>, <-222,0,-58> }
		triangle { <-222,0,-33>, <-222,0,-42>, <-162,0,-42> }
		triangle { <-162,0,-42>, <-162,0,-33>, <-222,0,-33> }
		triangle { <-222,0,-8>, <-222,0,-17>, <-162,0,-17> }
		triangle { <-162,0,-17>, <-162,0,-8>, <-222,0,-8> }
		triangle { <-222,0,8>, <-222,0,17>, <-162,0,17> }
		triangle { <-162,0,17>, <-162,0,8>, <-222,0,8> }
		triangle { <-222,0,33>, <-222,0,42>, <-162,0,42> }
		triangle { <-162,0,42>, <-162,0,33>, <-222,0,33> }
		triangle { <-222,0,58>, <-222,0,67>, <-162,0,67> }
		triangle { <-162,0,67>, <-162,0,58>, <-222,0,58> }
		triangle { <-222,0,83>, <-222,0,92>, <-162,0,92> }
		triangle { <-162,0,92>, <-162,0,83>, <-222,0,83> }
		triangle { <-222,0,108>, <-222,0,117>, <-162,0,117> }
		triangle { <-162,0,117>, <-162,0,108>, <-222,0,108> }
		triangle { <-117,0,117>, <117,0,117>, <117,0,-117> }
		triangle { <117,0,-117>, <-117,0,-117>, <-117,0,117> }
		triangle { <316,0,320>, <133,0,320>, <133,0,133> }
		triangle { <133,0,133>, <316,0,133>, <316,0,320> }
		triangle { <-316,0,320>, <-133,0,320>, <-133,0,133> }
		triangle { <-133,0,133>, <-316,0,133>, <-316,0,320> }
		triangle { <316,0,-320>, <133,0,-320>, <133,0,-133> }
		triangle { <133,0,-133>, <316,0,-133>, <316,0,-320> }
		triangle { <-316,0,-320>, <-133,0,-320>, <-133,0,-133> }
		triangle { <-133,0,-133>, <-316,0,-133>, <-316,0,-320> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-150> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-170> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-190> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-210> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-230> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-250> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-270> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-290> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,310,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,290,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,270,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,250,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,230,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,210,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,190,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,170,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-170,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-190,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-210,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-230,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-250,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-270,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-290,0,-310> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-310,0,-310> }
	#end
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,316,4,316> }
	mesh {
		triangle { <316,4,316>, <316,4,320>, <-316,4,320> }
		triangle { <-316,4,320>, <-316,4,316>, <316,4,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,4,-316,4,316> }
	mesh {
		triangle { <-316,4,316>, <-320,4,316>, <-320,4,-316> }
		triangle { <-320,4,-316>, <-316,4,-316>, <-316,4,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,-4,-316,4,-316> }
	mesh {
		triangle { <-316,4,-316>, <-316,4,-320>, <316,4,-320> }
		triangle { <316,4,-320>, <316,4,-316>, <-316,4,-316> }
	}
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,-4,316,4,-316> }
	mesh {
		triangle { <316,4,-316>, <320,4,-316>, <320,4,316> }
		triangle { <320,4,316>, <316,4,316>, <316,4,-316> }
		triangle { <316,4,316>, <-316,4,316>, <-316,4,-316> }
		triangle { <-316,4,-316>, <316,4,-316>, <316,4,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,316,0,316> }
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,4,-316,0,316> }
	mesh {
		triangle { <-316,0,316>, <-320,0,316>, <-320,0,-316> }
		triangle { <-320,0,-316>, <-316,0,-316>, <-316,0,316> }
	}
	object { _1_dash_4disc_dot_dat matrix <-4,0,0,0,1,0,0,0,-4,-316,0,-316> }
	object { _1_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,-4,316,0,-316> }
	mesh {
		triangle { <316,0,-316>, <320,0,-316>, <320,0,316> }
		triangle { <320,0,316>, <316,0,316>, <316,0,-316> }
	}
	object { _1_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,316,0,316> }
	mesh {
		triangle { <316,4,320>, <316,0,320>, <-316,0,320> }
		triangle { <-316,0,320>, <-316,4,320>, <316,4,320> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-4,0,0,0,4,0,0,0,4,-316,0,316> }
	mesh {
		triangle { <-320,4,316>, <-320,0,316>, <-320,0,-316> }
		triangle { <-320,0,-316>, <-320,4,-316>, <-320,4,316> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-4,0,0,0,4,0,0,0,-4,-316,0,-316> }
	mesh {
		triangle { <-316,4,-320>, <-316,0,-320>, <316,0,-320> }
		triangle { <316,0,-320>, <316,4,-320>, <-316,4,-320> }
	}
	object { _1_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,-4,316,0,-316> }
	mesh {
		triangle { <320,4,-316>, <320,0,-316>, <320,0,316> }
		triangle { <320,0,316>, <320,4,316>, <320,4,-316> }
	}
}
#end

#declare _4_dash_4cyli_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open }

#declare s_slash_971s01_dot_dat = #if (QUAL = 0) box { <-19.5,-9,-11>, <-1.5,28,9> } #else union {
	mesh {
		triangle { <-1.5,28,9>, <-19.5,28,9>, <-19.34,24,9> }
		triangle { <-19.34,24,9>, <-1.5,24,9>, <-1.5,28,9> }
		triangle { <-10,12,9>, <-7.72,12.48,9>, <-1.5,12.48,9> }
		triangle { <-1.5,12.48,9>, <-1.5,12,9>, <-10,12,9> }
		triangle { <-7.72,12.48,9>, <-5.8,13.8,9>, <-1.5,13.8,9> }
		triangle { <-1.5,13.8,9>, <-1.5,12.48,9>, <-7.72,12.48,9> }
		triangle { <-5.8,13.8,9>, <-4.48,15.72,9>, <-1.5,15.72,9> }
		triangle { <-1.5,15.72,9>, <-1.5,13.8,9>, <-5.8,13.8,9> }
		triangle { <-4.48,15.72,9>, <-4,18,9>, <-1.5,18,9> }
		triangle { <-1.5,18,9>, <-1.5,15.72,9>, <-4.48,15.72,9> }
		triangle { <-4,18,9>, <-4.48,20.28,9>, <-1.5,20.28,9> }
		triangle { <-1.5,20.28,9>, <-1.5,18,9>, <-4,18,9> }
		triangle { <-4.48,20.28,9>, <-5.8,22.2,9>, <-1.5,22.2,9> }
		triangle { <-1.5,22.2,9>, <-1.5,20.28,9>, <-4.48,20.28,9> }
		triangle { <-5.8,22.2,9>, <-7.72,23.52,9>, <-1.5,23.52,9> }
		triangle { <-1.5,23.52,9>, <-1.5,22.2,9>, <-5.8,22.2,9> }
		triangle { <-7.72,23.52,9>, <-10,24,9>, <-1.5,24,9> }
		triangle { <-1.5,24,9>, <-1.5,23.52,9>, <-7.72,23.52,9> }
		triangle { <-10,24,9>, <-12.28,23.52,9>, <-19.31,23.52,9> }
		triangle { <-19.31,23.52,9>, <-19.34,24,9>, <-10,24,9> }
		triangle { <-12.28,23.52,9>, <-14.2,22.2,9>, <-19.26,22.2,9> }
		triangle { <-19.26,22.2,9>, <-19.31,23.52,9>, <-12.28,23.52,9> }
		triangle { <-14.2,22.2,9>, <-15.52,20.28,9>, <-19.19,20.28,9> }
		triangle { <-19.19,20.28,9>, <-19.26,22.2,9>, <-14.2,22.2,9> }
		triangle { <-15.52,20.28,9>, <-16,18,9>, <-19.09,18,9> }
		triangle { <-19.09,18,9>, <-19.19,20.28,9>, <-15.52,20.28,9> }
		triangle { <-16,18,9>, <-15.52,15.72,9>, <-19,15.72,9> }
		triangle { <-19,15.72,9>, <-19.09,18,9>, <-16,18,9> }
		triangle { <-15.52,15.72,9>, <-14.2,13.8,9>, <-18.92,13.8,9> }
		triangle { <-18.92,13.8,9>, <-19,15.72,9>, <-15.52,15.72,9> }
		triangle { <-14.2,13.8,9>, <-12.28,12.48,9>, <-18.87,12.48,9> }
		triangle { <-18.87,12.48,9>, <-18.92,13.8,9>, <-14.2,13.8,9> }
		triangle { <-12.28,12.48,9>, <-10,12,9>, <-18.85,12,9> }
		triangle { <-18.85,12,9>, <-18.87,12.48,9>, <-12.28,12.48,9> }
		triangle { <-1.5,12,9>, <-1.5,4.1,9>, <-18.53,4.1,9> }
		triangle { <-18.53,4.1,9>, <-18.85,12,9>, <-1.5,12,9> }
		triangle { <-2,4.1,9>, <-2,4,9>, <-18.53,4,9> }
		triangle { <-18.53,4,9>, <-18.53,4.1,9>, <-2,4.1,9> }
		triangle { <-7.72,3.52,9>, <-10,4,9>, <-2,4,9> }
		triangle { <-2,4,9>, <-2,3.52,9>, <-7.72,3.52,9> }
		triangle { <-5.8,2.2,9>, <-7.72,3.52,9>, <-2,3.52,9> }
		triangle { <-2,3.52,9>, <-2,2.2,9>, <-5.8,2.2,9> }
		triangle { <-4.48,0.28,9>, <-5.8,2.2,9>, <-2,2.2,9> }
		triangle { <-2,2.2,9>, <-2,0.28,9>, <-4.48,0.28,9> }
		triangle { <-4,-2,8.58>, <-4.48,0.28,9>, <-2,0.28,9> }
		triangle { <-2,0.28,9>, <-2,-2,8.58>, <-4,-2,8.58> }
		triangle { <-4.48,-4.28,7.69>, <-4,-2,8.58>, <-2,-2,8.58> }
		triangle { <-2,-2,8.58>, <-2,-4.28,7.69>, <-4.48,-4.28,7.69> }
		triangle { <-5.8,-6.2,6.37>, <-4.48,-4.28,7.69>, <-2,-4.28,7.69> }
		triangle { <-2,-4.28,7.69>, <-2,-6.2,6.37>, <-5.8,-6.2,6.37> }
		triangle { <-7.72,-7.19,5.01>, <-5.8,-6.2,6.37>, <-2,-6.2,6.37> }
		triangle { <-2,-6.2,6.37>, <-2,-7.19,5.01>, <-7.72,-7.19,5.01> }
		triangle { <-10,4,9>, <-12.28,3.52,9>, <-18.51,3.52,9> }
		triangle { <-18.51,3.52,9>, <-18.53,4,9>, <-10,4,9> }
		triangle { <-12.28,3.52,9>, <-14.2,2.2,9>, <-18.45,2.2,9> }
		triangle { <-18.45,2.2,9>, <-18.51,3.52,9>, <-12.28,3.52,9> }
		triangle { <-14.2,2.2,9>, <-15.52,0.28,9>, <-18.38,0.28,9> }
		triangle { <-18.38,0.28,9>, <-18.45,2.2,9>, <-14.2,2.2,9> }
		triangle { <-15.52,0.28,9>, <-16,-2,8.58>, <-18.28,-2,8.58> }
		triangle { <-18.28,-2,8.58>, <-18.38,0.28,9>, <-15.52,0.28,9> }
		triangle { <-16,-2,8.58>, <-15.52,-4.28,7.69>, <-18.19,-4.28,7.69> }
		triangle { <-18.19,-4.28,7.69>, <-18.28,-2,8.58>, <-16,-2,8.58> }
		triangle { <-15.52,-4.28,7.69>, <-14.2,-6.2,6.37>, <-18.11,-6.2,6.37> }
		triangle { <-18.11,-6.2,6.37>, <-18.19,-4.28,7.69>, <-15.52,-4.28,7.69> }
		triangle { <-14.2,-6.2,6.37>, <-12.28,-7.19,5.01>, <-18.07,-7.19,5.01> }
		triangle { <-18.07,-7.19,5.01>, <-18.11,-6.2,6.37>, <-14.2,-6.2,6.37> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,4,0,6,0,-10,18,5> }
	mesh {
		triangle { <-4,-2,5>, <-4.48,0.28,5>, <-4.48,0.28,9> }
		triangle { <-4.48,0.28,9>, <-4,-2,8.58>, <-4,-2,5> }
		triangle { <-4.48,0.28,5>, <-5.8,2.2,5>, <-5.8,2.2,9> }
		triangle { <-5.8,2.2,9>, <-4.48,0.28,9>, <-4.48,0.28,5> }
		triangle { <-5.8,2.2,5>, <-7.72,3.52,5>, <-7.72,3.52,9> }
		triangle { <-7.72,3.52,9>, <-5.8,2.2,9>, <-5.8,2.2,5> }
		triangle { <-7.72,3.52,5>, <-10,4,5>, <-10,4,9> }
		triangle { <-10,4,9>, <-7.72,3.52,9>, <-7.72,3.52,5> }
		triangle { <-10,4,5>, <-12.28,3.52,5>, <-12.28,3.52,9> }
		triangle { <-12.28,3.52,9>, <-10,4,9>, <-10,4,5> }
		triangle { <-12.28,3.52,5>, <-14.2,2.2,5>, <-14.2,2.2,9> }
		triangle { <-14.2,2.2,9>, <-12.28,3.52,9>, <-12.28,3.52,5> }
		triangle { <-14.2,2.2,5>, <-15.52,0.28,5>, <-15.52,0.28,9> }
		triangle { <-15.52,0.28,9>, <-14.2,2.2,9>, <-14.2,2.2,5> }
		triangle { <-15.52,0.28,5>, <-16,-2,5>, <-16,-2,8.58> }
		triangle { <-16,-2,8.58>, <-15.52,0.28,9>, <-15.52,0.28,5> }
		triangle { <-16,-2,5>, <-15.52,-4.28,5>, <-15.52,-4.28,7.69> }
		triangle { <-15.52,-4.28,7.69>, <-16,-2,8.58>, <-16,-2,5> }
		triangle { <-15.52,-4.28,5>, <-14.2,-6.2,5>, <-14.2,-6.2,6.37> }
		triangle { <-14.2,-6.2,6.37>, <-15.52,-4.28,7.69>, <-15.52,-4.28,5> }
		triangle { <-14.2,-6.2,5>, <-12.28,-7.52,5>, <-14.2,-6.2,6.37> }
		triangle { <-12.28,-7.52,5>, <-10,-8,5>, <-10,-8,3.83> }
		triangle { <-10,-8,3.83>, <-12.28,-7.52,4.53>, <-12.28,-7.52,5> }
		triangle { <-10,-8,5>, <-7.72,-7.52,5>, <-7.72,-7.52,4.53> }
		triangle { <-7.72,-7.52,4.53>, <-10,-8,3.83>, <-10,-8,5> }
		triangle { <-7.72,-7.52,5>, <-7.72,-7.52,4.53>, <-5.8,-6.2,5> }
		triangle { <-5.8,-6.2,5>, <-5.8,-6.2,6.37>, <-7.72,-7.52,5> }
		triangle { <-5.8,-6.2,5>, <-4.48,-4.28,5>, <-4.48,-4.28,7.69> }
		triangle { <-4.48,-4.28,7.69>, <-5.8,-6.2,6.37>, <-5.8,-6.2,5> }
		triangle { <-4.48,-4.28,5>, <-4,-2,5>, <-4,-2,8.58> }
		triangle { <-4,-2,8.58>, <-4.48,-4.28,7.69>, <-4.48,-4.28,5> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,3,0,5.72,0,0,0,0,3,-7.72,0,0> }
	mesh {
		triangle { <-4,28,5>, <-16,28,5>, <-16,24,5> }
		triangle { <-16,24,5>, <-4,24,5>, <-4,28,5> }
		triangle { <-10,12,5>, <-7.72,12.48,5>, <-4,12.48,5> }
		triangle { <-4,12.48,5>, <-4,12,5>, <-10,12,5> }
		triangle { <-7.72,12.48,5>, <-5.8,13.8,5>, <-4,13.8,5> }
		triangle { <-4,13.8,5>, <-4,12.48,5>, <-7.72,12.48,5> }
		triangle { <-5.8,13.8,5>, <-4.48,15.72,5>, <-4,15.72,5> }
		triangle { <-4,15.72,5>, <-4,13.8,5>, <-5.8,13.8,5> }
		triangle { <-4.48,15.72,5>, <-4,18,5>, <-4,15.72,5> }
		triangle { <-4,18,5>, <-4.48,20.28,5>, <-4,20.28,5> }
		triangle { <-4.48,20.28,5>, <-5.8,22.2,5>, <-4,22.2,5> }
		triangle { <-4,22.2,5>, <-4,20.28,5>, <-4.48,20.28,5> }
		triangle { <-5.8,22.2,5>, <-7.72,23.52,5>, <-4,23.52,5> }
		triangle { <-4,23.52,5>, <-4,22.2,5>, <-5.8,22.2,5> }
		triangle { <-7.72,23.52,5>, <-10,24,5>, <-4,24,5> }
		triangle { <-4,24,5>, <-4,23.52,5>, <-7.72,23.52,5> }
		triangle { <-10,24,5>, <-12.28,23.52,5>, <-16,23.52,5> }
		triangle { <-16,23.52,5>, <-16,24,5>, <-10,24,5> }
		triangle { <-12.28,23.52,5>, <-14.2,22.2,5>, <-16,22.2,5> }
		triangle { <-16,22.2,5>, <-16,23.52,5>, <-12.28,23.52,5> }
		triangle { <-14.2,22.2,5>, <-15.52,20.28,5>, <-16,20.28,5> }
		triangle { <-16,20.28,5>, <-16,22.2,5>, <-14.2,22.2,5> }
		triangle { <-15.52,20.28,5>, <-16,18,5>, <-16,20.28,5> }
		triangle { <-16,18,5>, <-15.52,15.72,5>, <-16,15.72,5> }
		triangle { <-15.52,15.72,5>, <-14.2,13.8,5>, <-16,13.8,5> }
		triangle { <-16,13.8,5>, <-16,15.72,5>, <-15.52,15.72,5> }
		triangle { <-14.2,13.8,5>, <-12.28,12.48,5>, <-16,12.48,5> }
		triangle { <-16,12.48,5>, <-16,13.8,5>, <-14.2,13.8,5> }
		triangle { <-12.28,12.48,5>, <-10,12,5>, <-16,12,5> }
		triangle { <-16,12,5>, <-16,12.48,5>, <-12.28,12.48,5> }
		triangle { <-4,12,5>, <-4,8,5>, <-16,8,5> }
		triangle { <-16,8,5>, <-16,12,5>, <-4,12,5> }
		triangle { <-16,28,-7>, <-16,28,5>, <-16,24,5> }
		triangle { <-16,24,5>, <-16,24,-7>, <-16,28,-7> }
		triangle { <-16,24,5>, <-16,24,-3>, <-16,8,-3> }
		triangle { <-16,8,-3>, <-16,8,5>, <-16,24,5> }
		triangle { <-4,28,-7>, <-4,28,5>, <-4,24,5> }
		triangle { <-4,24,5>, <-4,24,-7>, <-4,28,-7> }
		triangle { <-4,24,5>, <-4,24,-3>, <-4,8,-3> }
		triangle { <-4,8,-3>, <-4,8,5>, <-4,24,5> }
		triangle { <-16,8,-3>, <-16,8,5>, <-4,8,5> }
		triangle { <-4,8,5>, <-4,8,-3>, <-16,8,-3> }
		triangle { <-16,8,-3>, <-4,8,-3>, <-4,24,-3> }
		triangle { <-4,24,-3>, <-16,24,-3>, <-16,8,-3> }
		triangle { <-4,24,-3>, <-16,24,-3>, <-16,24,-7> }
		triangle { <-16,24,-7>, <-4,24,-7>, <-4,24,-3> }
		triangle { <-4,24,-7>, <-16,24,-7>, <-16,28,-7> }
		triangle { <-16,28,-7>, <-4,28,-7>, <-4,24,-7> }
		triangle { <-16,28,-7>, <-16,28,5>, <-19.5,28,9> }
		triangle { <-19.5,28,9>, <-19.5,28,-11>, <-16,28,-7> }
		triangle { <-16,28,5>, <-4,28,5>, <-1.5,28,9> }
		triangle { <-1.5,28,9>, <-19.5,28,9>, <-16,28,5> }
		triangle { <-4,28,5>, <-4,28,-7>, <-1.5,28,-11> }
		triangle { <-1.5,28,-11>, <-1.5,28,9>, <-4,28,5> }
		triangle { <-4,28,-7>, <-16,28,-7>, <-19.5,28,-11> }
		triangle { <-19.5,28,-11>, <-1.5,28,-11>, <-4,28,-7> }
		triangle { <-5.66,-6,5>, <-4.48,-4.28,5>, <-7.72,-4.28,5> }
		triangle { <-7.72,-4.28,5>, <-7.72,-6,5>, <-5.66,-6,5> }
		triangle { <-4.48,-4.28,5>, <-4,-2,5>, <-7.72,-2,5> }
		triangle { <-7.72,-2,5>, <-7.72,-4.28,5>, <-4.48,-4.28,5> }
		triangle { <-4,-2,5>, <-4.48,0.28,5>, <-7.72,0.28,5> }
		triangle { <-7.72,0.28,5>, <-7.72,-2,5>, <-4,-2,5> }
		triangle { <-4.48,0.28,5>, <-5.8,2.2,5>, <-7.72,2.2,5> }
		triangle { <-7.72,2.2,5>, <-7.72,0.28,5>, <-4.48,0.28,5> }
		triangle { <-5.8,2.2,5>, <-7.72,3.52,5>, <-7.72,2.2,5> }
		triangle { <-14.34,-6,5>, <-14.2,-6.2,5>, <-5.8,-6.2,5> }
		triangle { <-5.8,-6.2,5>, <-5.66,-6,5>, <-14.34,-6,5> }
		triangle { <-14.2,-6.2,5>, <-12.28,-7.52,5>, <-7.72,-7.52,5> }
		triangle { <-7.72,-7.52,5>, <-5.8,-6.2,5>, <-14.2,-6.2,5> }
		triangle { <-12.28,-7.52,5>, <-10,-8,5>, <-7.72,-7.52,5> }
		triangle { <-14.2,2.2,5>, <-14.34,0.28,5>, <-15.52,0.28,5> }
		triangle { <-15.52,0.28,5>, <-14.34,2.2,5>, <-14.2,2.2,5> }
		triangle { <-15.52,0.28,5>, <-16,-2,5>, <-14.34,-2,5> }
		triangle { <-14.34,-2,5>, <-14.34,0.28,5>, <-15.52,0.28,5> }
		triangle { <-16,-2,5>, <-15.52,-4.28,5>, <-14.34,-4.28,5> }
		triangle { <-14.34,-4.28,5>, <-14.34,-2,5>, <-16,-2,5> }
		triangle { <-15.52,-4.28,5>, <-14.34,-6,5>, <-14.34,-4.28,5> }
		triangle { <-14.34,-6,0>, <-7.72,-6,0>, <-7.72,-6,5> }
		triangle { <-7.72,-6,5>, <-14.34,-6,5>, <-14.34,-6,0> }
		triangle { <-14.34,-6,0>, <-14.34,-5.52,-2.28>, <-14.34,-5.52,5> }
		triangle { <-14.34,-5.52,5>, <-14.34,-6,5>, <-14.34,-6,0> }
		triangle { <-14.34,-5.52,-2.28>, <-14.34,-4.2,-4.2>, <-14.34,-4.2,5> }
		triangle { <-14.34,-4.2,5>, <-14.34,-5.52,5>, <-14.34,-5.52,-2.28> }
		triangle { <-14.34,-4.2,-4.2>, <-14.34,-2.28,-5.52>, <-14.34,-2.28,5> }
		triangle { <-14.34,-2.28,5>, <-14.34,-4.2,5>, <-14.34,-4.2,-4.2> }
		triangle { <-14.34,-2.28,-5.52>, <-14.34,0,-6>, <-14.34,0,5> }
		triangle { <-14.34,0,5>, <-14.34,-2.28,5>, <-14.34,-2.28,-5.52> }
		triangle { <-14.34,0,-6>, <-14.34,2,-5.58>, <-14.34,2,5> }
		triangle { <-14.34,2,5>, <-14.34,0,5>, <-14.34,0,-6> }
		triangle { <-7.72,-6,0>, <-7.72,-5.52,-2.28>, <-7.72,-5.52,5> }
		triangle { <-7.72,-5.52,5>, <-7.72,-6,5>, <-7.72,-6,0> }
		triangle { <-7.72,-5.52,-2.28>, <-7.72,-4.2,-4.2>, <-7.72,-4.2,5> }
		triangle { <-7.72,-4.2,5>, <-7.72,-5.52,5>, <-7.72,-5.52,-2.28> }
		triangle { <-7.72,-4.2,-4.2>, <-7.72,-3,-5.03>, <-7.72,-3,5> }
		triangle { <-7.72,-3,5>, <-7.72,-4.2,5>, <-7.72,-4.2,-4.2> }
		triangle { <-7.72,-2.76,1.14>, <-7.72,-3,0>, <-7.72,-3,5> }
		triangle { <-7.72,-3,5>, <-7.72,-2.76,5>, <-7.72,-2.76,1.14> }
		triangle { <-7.72,-2.1,2.1>, <-7.72,-2.76,1.14>, <-7.72,-2.76,5> }
		triangle { <-7.72,-2.76,5>, <-7.72,-2.1,5>, <-7.72,-2.1,2.1> }
		triangle { <-7.72,-1.14,2.76>, <-7.72,-2.1,2.1>, <-7.72,-2.1,5> }
		triangle { <-7.72,-2.1,5>, <-7.72,-1.14,5>, <-7.72,-1.14,2.76> }
		triangle { <-7.72,0,3>, <-7.72,-1.14,2.76>, <-7.72,-1.14,5> }
		triangle { <-7.72,-1.14,5>, <-7.72,0,5>, <-7.72,0,3> }
		triangle { <-7.72,1.14,2.76>, <-7.72,0,3>, <-7.72,0,5> }
		triangle { <-7.72,0,5>, <-7.72,1.14,5>, <-7.72,1.14,2.76> }
		triangle { <-7.72,2.1,2.1>, <-7.72,1.14,2.76>, <-7.72,1.14,5> }
		triangle { <-7.72,1.14,5>, <-7.72,2.1,5>, <-7.72,2.1,2.1> }
		triangle { <-7.72,2.76,1.14>, <-7.72,2.1,2.1>, <-7.72,2.1,5> }
		triangle { <-7.72,2.1,5>, <-7.72,2.76,5>, <-7.72,2.76,1.14> }
		triangle { <-7.72,3,0>, <-7.72,2.76,1.14>, <-7.72,2.76,5> }
		triangle { <-7.72,2.76,5>, <-7.72,3,5>, <-7.72,3,0> }
		triangle { <-7.72,-3,0>, <-7.72,-2.76,-1.14>, <-7.72,-2.76,-5.19> }
		triangle { <-7.72,-2.76,-5.19>, <-7.72,-3,-5.03>, <-7.72,-3,0> }
		triangle { <-7.72,-2.76,-1.14>, <-7.72,-2.1,-2.1>, <-7.72,-2.1,-5.56> }
		triangle { <-7.72,-2.1,-5.56>, <-7.72,-2.76,-5.19>, <-7.72,-2.76,-1.14> }
		triangle { <-7.72,-2.1,-2.1>, <-7.72,-1.14,-2.76>, <-7.72,-1.14,-5.76> }
		triangle { <-7.72,-1.14,-5.76>, <-7.72,-2.1,-5.56>, <-7.72,-2.1,-2.1> }
		triangle { <-7.72,-1.14,-2.76>, <-7.72,0,-3>, <-7.72,0,-6> }
		triangle { <-7.72,0,-6>, <-7.72,-1.14,-5.76>, <-7.72,-1.14,-2.76> }
		triangle { <-7.72,0,-3>, <-7.72,1.14,-2.76>, <-7.72,1.14,-5.76> }
		triangle { <-7.72,1.14,-5.76>, <-7.72,0,-6>, <-7.72,0,-3> }
		triangle { <-7.72,1.14,-2.76>, <-7.72,2.1,-2.1>, <-7.72,2.1,-5.56> }
		triangle { <-7.72,2.1,-5.56>, <-7.72,1.14,-5.76>, <-7.72,1.14,-2.76> }
		triangle { <-7.72,2.1,-2.1>, <-7.72,2.76,-1.14>, <-7.72,2.76,-5.19> }
		triangle { <-7.72,2.76,-5.19>, <-7.72,2.1,-5.56>, <-7.72,2.1,-2.1> }
		triangle { <-7.72,2.76,-1.14>, <-7.72,3,0>, <-7.72,3,-5.03> }
		triangle { <-7.72,3,-5.03>, <-7.72,2.76,-5.19>, <-7.72,2.76,-1.14> }
		triangle { <-7.72,3.52,-4.67>, <-7.72,3.52,9>, <-7.72,3,5> }
		triangle { <-7.72,3,5>, <-7.72,3,-5.03>, <-7.72,3.52,-4.67> }
		triangle { <-7.72,3.52,-4.67>, <-10,4,-4.34>, <-10,4,9> }
		triangle { <-10,4,9>, <-7.72,3.52,9>, <-7.72,3.52,-4.67> }
		triangle { <-10,4,-4.34>, <-12.28,3.52,-4.67>, <-12.28,3.52,9> }
		triangle { <-12.28,3.52,9>, <-10,4,9>, <-10,4,-4.34> }
		triangle { <-12.28,3.52,-4.67>, <-14.2,2.2,-5.54>, <-14.2,2.2,9> }
		triangle { <-14.2,2.2,9>, <-12.28,3.52,9>, <-12.28,3.52,-4.67> }
		triangle { <-14.2,2.2,-5.54>, <-14.34,2,-5.58>, <-14.34,2,9> }
		triangle { <-14.34,2,9>, <-14.2,2.2,9>, <-14.2,2.2,-5.54> }
		triangle { <-14.34,-6,0>, <-14.34,-5.52,-2.28>, <-7.72,-5.52,-2.28> }
		triangle { <-7.72,-5.52,-2.28>, <-7.72,-6,0>, <-14.34,-6,0> }
		triangle { <-14.34,-5.52,-2.28>, <-14.34,-4.2,-4.2>, <-7.72,-4.2,-4.2> }
		triangle { <-7.72,-4.2,-4.2>, <-7.72,-5.52,-2.28>, <-14.34,-5.52,-2.28> }
		triangle { <-14.34,-4.2,-4.2>, <-14.34,-2.28,-5.52>, <-7.72,-2.28,-5.52> }
		triangle { <-7.72,-2.28,-5.52>, <-7.72,-4.2,-4.2>, <-14.34,-4.2,-4.2> }
		triangle { <-14.34,-2.28,-5.52>, <-14.34,0,-6>, <-7.72,0,-6> }
		triangle { <-7.72,0,-6>, <-7.72,-2.28,-5.52>, <-14.34,-2.28,-5.52> }
		triangle { <-14.34,0,-6>, <-14.34,2,-5.58>, <-7.72,2,-5.58> }
		triangle { <-7.72,2,-5.58>, <-7.72,0,-6>, <-14.34,0,-6> }
		triangle { <-7.72,2,-5.58>, <-14.43,2,-5.58>, <-14.2,2.2,-5.54> }
		triangle { <-14.2,2.2,-5.54>, <-7.72,2.2,-5.54>, <-7.72,2,-5.58> }
		triangle { <-7.72,2.2,-5.54>, <-14.2,2.2,-5.54>, <-12.28,3.52,-4.67> }
		triangle { <-12.28,3.52,-4.67>, <-7.72,3.52,-4.67>, <-7.72,2.2,-5.54> }
		triangle { <-7.72,3.52,-4.67>, <-12.28,3.52,-4.67>, <-10,4,-4.34> }
		triangle { <-19.5,28,-11>, <-19.5,28,-6>, <-19.18,20,-6> }
		triangle { <-19.18,20,-6>, <-19.18,20,-11>, <-19.5,28,-11> }
		triangle { <-19.5,28,-6>, <-19.5,28,9>, <-18.36,0,9> }
		triangle { <-18.36,0,9>, <-18.36,0,-6>, <-19.5,28,-6> }
		triangle { <-18.64,6.74,6>, <-18.5,3.42,8.28>, <-18.5,3.42,-8.28> }
		triangle { <-18.5,3.42,-8.28>, <-18.64,6.74,-6>, <-18.64,6.74,6> }
		triangle { <-18.5,3.42,8.28>, <-18.36,0,9>, <-18.36,0,-9> }
		triangle { <-18.36,0,-9>, <-18.5,3.42,-8.28>, <-18.5,3.42,8.28> }
		triangle { <-18.36,0,9>, <-18.23,-3.42,8.28>, <-18.23,-3.42,-8.28> }
		triangle { <-18.23,-3.42,-8.28>, <-18.36,0,-9>, <-18.36,0,9> }
		triangle { <-18.23,-3.42,8.28>, <-18.11,-6.3,6.3>, <-18.11,-6.3,-6.3> }
		triangle { <-18.11,-6.3,-6.3>, <-18.23,-3.42,-8.28>, <-18.23,-3.42,8.28> }
		triangle { <-18.11,-6.3,6.3>, <-18.03,-8.28,3.42>, <-18.03,-8.28,-3.42> }
		triangle { <-18.03,-8.28,-3.42>, <-18.11,-6.3,-6.3>, <-18.11,-6.3,6.3> }
		triangle { <-18.03,-8.28,3.42>, <-18,-9,0>, <-18.03,-8.28,-3.42> }
		triangle { <-1.5,28,-11>, <-1.5,28,-6>, <-1.5,20,-6> }
		triangle { <-1.5,20,-6>, <-1.5,20,-11>, <-1.5,28,-11> }
		triangle { <-1.5,28,-6>, <-1.5,28,9>, <-1.5,10,9> }
		triangle { <-1.5,10,9>, <-1.5,10,-6>, <-1.5,28,-6> }
		triangle { <-1.5,7.7,-6>, <-1.5,9.2,-3.8>, <-1.5,9.2,-6> }
		triangle { <-1.5,9.2,-3.8>, <-1.5,10,0>, <-1.5,10,-6> }
		triangle { <-1.5,10,-6>, <-1.5,9.2,-6>, <-1.5,9.2,-3.8> }
		triangle { <-1.5,10,0>, <-1.5,9.2,3.8>, <-1.5,9.2,9> }
		triangle { <-1.5,9.2,9>, <-1.5,10,9>, <-1.5,10,0> }
		triangle { <-1.5,9.2,3.8>, <-1.5,7,7>, <-1.5,7,9> }
		triangle { <-1.5,7,9>, <-1.5,9.2,9>, <-1.5,9.2,3.8> }
		triangle { <-1.5,7,7>, <-1.5,4.1,9>, <-1.5,7,9> }
		triangle { <-1.5,7.7,-6>, <-1.5,9.2,-3.8>, <-2,9.2,-3.8> }
		triangle { <-2,9.2,-3.8>, <-2,7.7,-6>, <-1.5,7.7,-6> }
		triangle { <-1.5,9.2,-3.8>, <-1.5,10,0>, <-2,10,0> }
		triangle { <-2,10,0>, <-2,9.2,-3.8>, <-1.5,9.2,-3.8> }
		triangle { <-1.5,10,0>, <-1.5,9.2,3.8>, <-2,9.2,3.8> }
		triangle { <-2,9.2,3.8>, <-2,10,0>, <-1.5,10,0> }
		triangle { <-1.5,9.2,3.8>, <-1.5,7,7>, <-2,7,7> }
		triangle { <-2,7,7>, <-2,9.2,3.8>, <-1.5,9.2,3.8> }
		triangle { <-1.5,7,7>, <-1.5,4.1,9>, <-2,4.1,9> }
		triangle { <-2,4.1,9>, <-2,7,7>, <-1.5,7,7> }
		triangle { <-2,3,0>, <-2,10,0>, <-2,9.66,2.59> }
		triangle { <-2,9.66,2.59>, <-2,2.9,0.78>, <-2,3,0> }
		triangle { <-2,2.9,0.78>, <-2,9.66,2.59>, <-2,8.66,5> }
		triangle { <-2,8.66,5>, <-2,2.6,1.5>, <-2,2.9,0.78> }
		triangle { <-2,2.6,1.5>, <-2,8.66,5>, <-2,7.07,7.07> }
		triangle { <-2,7.07,7.07>, <-2,2.12,2.12>, <-2,2.6,1.5> }
		triangle { <-2,2.12,2.12>, <-2,7.07,7.07>, <-2,5,8.66> }
		triangle { <-2,5,8.66>, <-2,1.5,2.6>, <-2,2.12,2.12> }
		triangle { <-2,1.5,2.6>, <-2,5,8.66>, <-2,4.36,9> }
		triangle { <-2,4.36,9>, <-2,1.31,2.7>, <-2,1.5,2.6> }
		triangle { <-2,1.31,2.7>, <-2,4.36,9>, <-2,2.33,9> }
		triangle { <-2,2.33,9>, <-2,0.78,2.9>, <-2,1.31,2.7> }
		triangle { <-2,0.78,2.9>, <-2,2.33,9>, <-2,0,9> }
		triangle { <-2,0,9>, <-2,0,3>, <-2,0.78,2.9> }
		triangle { <-2,0,3>, <-2,0,9>, <-2,-2.33,8.69> }
		triangle { <-2,-2.33,8.69>, <-2,-0.78,2.9>, <-2,0,3> }
		triangle { <-2,-0.78,2.9>, <-2,-2.33,8.69>, <-2,-4.5,7.79> }
		triangle { <-2,-4.5,7.79>, <-2,-1.5,2.6>, <-2,-0.78,2.9> }
		triangle { <-2,-1.5,2.6>, <-2,-4.5,7.79>, <-2,-6.36,6.36> }
		triangle { <-2,-6.36,6.36>, <-2,-2.12,2.12>, <-2,-1.5,2.6> }
		triangle { <-2,-2.12,2.12>, <-2,-6.36,6.36>, <-2,-7.79,4.5> }
		triangle { <-2,-7.79,4.5>, <-2,-2.6,1.5>, <-2,-2.12,2.12> }
		triangle { <-2,-2.6,1.5>, <-2,-7.79,4.5>, <-2,-8.69,2.33> }
		triangle { <-2,-8.69,2.33>, <-2,-2.9,0.78>, <-2,-2.6,1.5> }
		triangle { <-2,-2.9,0.78>, <-2,-8.69,2.33>, <-2,-9,0> }
		triangle { <-2,-9,0>, <-2,-3,0>, <-2,-2.9,0.78> }
		triangle { <-2,-3,0>, <-2,-9,0>, <-2,-8.69,-2.33> }
		triangle { <-2,-8.69,-2.33>, <-2,-2.9,-0.78>, <-2,-3,0> }
		triangle { <-2,-2.9,-0.78>, <-2,-8.69,-2.33>, <-2,-7.79,-4.5> }
		triangle { <-2,-7.79,-4.5>, <-2,-2.6,-1.5>, <-2,-2.9,-0.78> }
		triangle { <-2,-2.6,-1.5>, <-2,-7.79,-4.5>, <-2,-6.36,-6.36> }
		triangle { <-2,-6.36,-6.36>, <-2,-2.12,-2.12>, <-2,-2.6,-1.5> }
		triangle { <-2,-2.12,-2.12>, <-2,-6.36,-6.36>, <-2,-4.5,-7.79> }
		triangle { <-2,-4.5,-7.79>, <-2,-1.5,-2.6>, <-2,-2.12,-2.12> }
		triangle { <-2,-1.5,-2.6>, <-2,-4.5,-7.79>, <-2,-2.33,-8.69> }
		triangle { <-2,-2.33,-8.69>, <-2,-0.78,-2.9>, <-2,-1.5,-2.6> }
		triangle { <-2,-0.78,-2.9>, <-2,-2.33,-8.69>, <-2,0,-9> }
		triangle { <-2,0,-9>, <-2,0,-3>, <-2,-0.78,-2.9> }
		triangle { <-2,0,-3>, <-2,0,-9>, <-2,2.33,-8.69> }
		triangle { <-2,2.33,-8.69>, <-2,0.78,-2.9>, <-2,0,-3> }
		triangle { <-2,0.78,-2.9>, <-2,2.33,-8.69>, <-2,4.5,-7.79> }
		triangle { <-2,4.5,-7.79>, <-2,1.5,-2.6>, <-2,0.78,-2.9> }
		triangle { <-2,1.5,-2.6>, <-2,4.5,-7.79>, <-2,6.36,-6.36> }
		triangle { <-2,6.36,-6.36>, <-2,2.12,-2.12>, <-2,1.5,-2.6> }
		triangle { <-2,2.12,-2.12>, <-2,6.36,-6.36>, <-2,6.71,-6> }
		triangle { <-2,6.71,-6>, <-2,2.24,-2>, <-2,2.12,-2.12> }
		triangle { <-2,2.24,-2>, <-2,6.71,-6>, <-2,8,-6> }
		triangle { <-2,8,-6>, <-2,2.4,-1.8>, <-2,2.24,-2> }
		triangle { <-2,2.4,-1.8>, <-2,8,-6>, <-2,8.66,-5> }
		triangle { <-2,8.66,-5>, <-2,2.6,-1.5>, <-2,2.4,-1.8> }
		triangle { <-2,2.6,-1.5>, <-2,8.66,-5>, <-2,9.66,-2.59> }
		triangle { <-2,9.66,-2.59>, <-2,2.9,-0.78>, <-2,2.6,-1.5> }
		triangle { <-2,2.9,-0.78>, <-2,9.66,-2.59>, <-2,10,0> }
		triangle { <-2,10,0>, <-2,3,0>, <-2,2.9,-0.78> }
		triangle { <-2,3,0>, <-2,10,0>, <-2,28,-1> }
		triangle { <-19.5,28,-11>, <-1.5,28,-11>, <-1.5,20,-11> }
		triangle { <-1.5,20,-11>, <-19.18,20,-11>, <-19.5,28,-11> }
		triangle { <-19.18,20,-11>, <-1.5,20,-11>, <-1.5,20,-6> }
		triangle { <-1.5,20,-6>, <-19.18,20,-6>, <-19.18,20,-11> }
		triangle { <-18.07,-7.19,5.01>, <-18.03,-8.28,3.42>, <-2,-8.28,3.42> }
		triangle { <-2,-8.28,3.42>, <-2,-7.19,5.01>, <-18.07,-7.19,5.01> }
		triangle { <-18.03,-8.28,3.42>, <-18,-9,0>, <-2,-9,0> }
		triangle { <-2,-9,0>, <-2,-8.28,3.42>, <-18.03,-8.28,3.42> }
		triangle { <-18,-9,0>, <-18.03,-8.28,-3.42>, <-2,-8.28,-3.42> }
		triangle { <-2,-8.28,-3.42>, <-2,-9,0>, <-18,-9,0> }
		triangle { <-18.03,-8.28,-3.42>, <-18.11,-6.3,-6.3>, <-2,-6.3,-6.3> }
		triangle { <-2,-6.3,-6.3>, <-2,-8.28,-3.42>, <-18.03,-8.28,-3.42> }
	}
}
#end

#declare _971_dot_dat = #if (QUAL = 0) box { <-19.5,-9,-11>, <-1.5,28,9> } #else union {
	mesh {
		triangle { <-19.18,20,-6>, <-1.5,20,-6>, <-1.5,7.7,-6> }
		triangle { <-1.5,7.7,-6>, <-18.68,7.7,-6>, <-19.18,20,-6> }
		triangle { <-18.64,6.74,-6>, <-2,6.74,-6>, <-1.5,7.7,-6> }
		triangle { <-1.5,7.7,-6>, <-18.68,7.7,-6>, <-18.64,6.74,-6> }
		triangle { <-18.5,3.42,-8.28>, <-18.64,6.74,-6>, <-2,6.74,-6> }
		triangle { <-2,6.74,-6>, <-2,3.42,-8.28>, <-18.5,3.42,-8.28> }
		triangle { <-18.36,0,-9>, <-18.5,3.42,-8.28>, <-2,3.42,-8.28> }
		triangle { <-2,3.42,-8.28>, <-2,0,-9>, <-18.36,0,-9> }
		triangle { <-18.23,-3.42,-8.28>, <-2,-3.42,-8.28>, <-2,0,-9> }
		triangle { <-2,0,-9>, <-18.36,0,-9>, <-18.23,-3.42,-8.28> }
		triangle { <-18.11,-6.3,-6.3>, <-18.23,-3.42,-8.28>, <-2,-3.42,-8.28> }
		triangle { <-2,-3.42,-8.28>, <-2,-6.3,-6.3>, <-18.11,-6.3,-6.3> }
	}
	object { s_slash_971s01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
}
#end

#declare s_slash_972s01_dot_dat = #if (QUAL = 0) box { <1.5,-9,-11>, <19.5,28,9> } #else union {
	mesh {
		triangle { <1.5,28,9>, <19.5,28,9>, <19.34,24,9> }
		triangle { <19.34,24,9>, <1.5,24,9>, <1.5,28,9> }
		triangle { <10,12,9>, <7.72,12.48,9>, <1.5,12.48,9> }
		triangle { <1.5,12.48,9>, <1.5,12,9>, <10,12,9> }
		triangle { <7.72,12.48,9>, <5.8,13.8,9>, <1.5,13.8,9> }
		triangle { <1.5,13.8,9>, <1.5,12.48,9>, <7.72,12.48,9> }
		triangle { <5.8,13.8,9>, <4.48,15.72,9>, <1.5,15.72,9> }
		triangle { <1.5,15.72,9>, <1.5,13.8,9>, <5.8,13.8,9> }
		triangle { <4.48,15.72,9>, <4,18,9>, <1.5,18,9> }
		triangle { <1.5,18,9>, <1.5,15.72,9>, <4.48,15.72,9> }
		triangle { <4,18,9>, <4.48,20.28,9>, <1.5,20.28,9> }
		triangle { <1.5,20.28,9>, <1.5,18,9>, <4,18,9> }
		triangle { <4.48,20.28,9>, <5.8,22.2,9>, <1.5,22.2,9> }
		triangle { <1.5,22.2,9>, <1.5,20.28,9>, <4.48,20.28,9> }
		triangle { <5.8,22.2,9>, <7.72,23.52,9>, <1.5,23.52,9> }
		triangle { <1.5,23.52,9>, <1.5,22.2,9>, <5.8,22.2,9> }
		triangle { <7.72,23.52,9>, <10,24,9>, <1.5,24,9> }
		triangle { <1.5,24,9>, <1.5,23.52,9>, <7.72,23.52,9> }
		triangle { <10,24,9>, <12.28,23.52,9>, <19.31,23.52,9> }
		triangle { <19.31,23.52,9>, <19.34,24,9>, <10,24,9> }
		triangle { <12.28,23.52,9>, <14.2,22.2,9>, <19.26,22.2,9> }
		triangle { <19.26,22.2,9>, <19.31,23.52,9>, <12.28,23.52,9> }
		triangle { <14.2,22.2,9>, <15.52,20.28,9>, <19.19,20.28,9> }
		triangle { <19.19,20.28,9>, <19.26,22.2,9>, <14.2,22.2,9> }
		triangle { <15.52,20.28,9>, <16,18,9>, <19.09,18,9> }
		triangle { <19.09,18,9>, <19.19,20.28,9>, <15.52,20.28,9> }
		triangle { <16,18,9>, <15.52,15.72,9>, <19,15.72,9> }
		triangle { <19,15.72,9>, <19.09,18,9>, <16,18,9> }
		triangle { <15.52,15.72,9>, <14.2,13.8,9>, <18.92,13.8,9> }
		triangle { <18.92,13.8,9>, <19,15.72,9>, <15.52,15.72,9> }
		triangle { <14.2,13.8,9>, <12.28,12.48,9>, <18.87,12.48,9> }
		triangle { <18.87,12.48,9>, <18.92,13.8,9>, <14.2,13.8,9> }
		triangle { <12.28,12.48,9>, <10,12,9>, <18.85,12,9> }
		triangle { <18.85,12,9>, <18.87,12.48,9>, <12.28,12.48,9> }
		triangle { <1.5,12,9>, <1.5,4.1,9>, <18.53,4.1,9> }
		triangle { <18.53,4.1,9>, <18.85,12,9>, <1.5,12,9> }
		triangle { <2,4.1,9>, <2,4,9>, <18.53,4,9> }
		triangle { <18.53,4,9>, <18.53,4.1,9>, <2,4.1,9> }
		triangle { <7.72,3.52,9>, <10,4,9>, <2,4,9> }
		triangle { <2,4,9>, <2,3.52,9>, <7.72,3.52,9> }
		triangle { <5.8,2.2,9>, <7.72,3.52,9>, <2,3.52,9> }
		triangle { <2,3.52,9>, <2,2.2,9>, <5.8,2.2,9> }
		triangle { <4.48,0.28,9>, <5.8,2.2,9>, <2,2.2,9> }
		triangle { <2,2.2,9>, <2,0.28,9>, <4.48,0.28,9> }
		triangle { <4,-2,8.58>, <4.48,0.28,9>, <2,0.28,9> }
		triangle { <2,0.28,9>, <2,-2,8.58>, <4,-2,8.58> }
		triangle { <4.48,-4.28,7.69>, <4,-2,8.58>, <2,-2,8.58> }
		triangle { <2,-2,8.58>, <2,-4.28,7.69>, <4.48,-4.28,7.69> }
		triangle { <5.8,-6.2,6.37>, <4.48,-4.28,7.69>, <2,-4.28,7.69> }
		triangle { <2,-4.28,7.69>, <2,-6.2,6.37>, <5.8,-6.2,6.37> }
		triangle { <7.72,-7.19,5.01>, <5.8,-6.2,6.37>, <2,-6.2,6.37> }
		triangle { <2,-6.2,6.37>, <2,-7.19,5.01>, <7.72,-7.19,5.01> }
		triangle { <10,4,9>, <12.28,3.52,9>, <18.51,3.52,9> }
		triangle { <18.51,3.52,9>, <18.53,4,9>, <10,4,9> }
		triangle { <12.28,3.52,9>, <14.2,2.2,9>, <18.45,2.2,9> }
		triangle { <18.45,2.2,9>, <18.51,3.52,9>, <12.28,3.52,9> }
		triangle { <14.2,2.2,9>, <15.52,0.28,9>, <18.38,0.28,9> }
		triangle { <18.38,0.28,9>, <18.45,2.2,9>, <14.2,2.2,9> }
		triangle { <15.52,0.28,9>, <16,-2,8.58>, <18.28,-2,8.58> }
		triangle { <18.28,-2,8.58>, <18.38,0.28,9>, <15.52,0.28,9> }
		triangle { <16,-2,8.58>, <15.52,-4.28,7.69>, <18.19,-4.28,7.69> }
		triangle { <18.19,-4.28,7.69>, <18.28,-2,8.58>, <16,-2,8.58> }
		triangle { <15.52,-4.28,7.69>, <14.2,-6.2,6.37>, <18.11,-6.2,6.37> }
		triangle { <18.11,-6.2,6.37>, <18.19,-4.28,7.69>, <15.52,-4.28,7.69> }
		triangle { <14.2,-6.2,6.37>, <12.28,-7.19,5.01>, <18.07,-7.19,5.01> }
		triangle { <18.07,-7.19,5.01>, <18.11,-6.2,6.37>, <14.2,-6.2,6.37> }
	}
	object { _4_dash_4cyli_dot_dat matrix <-6,0,0,0,0,4,0,6,0,10,18,5> }
	mesh {
		triangle { <4,-2,5>, <4.48,0.28,5>, <4.48,0.28,9> }
		triangle { <4.48,0.28,9>, <4,-2,8.58>, <4,-2,5> }
		triangle { <4.48,0.28,5>, <5.8,2.2,5>, <5.8,2.2,9> }
		triangle { <5.8,2.2,9>, <4.48,0.28,9>, <4.48,0.28,5> }
		triangle { <5.8,2.2,5>, <7.72,3.52,5>, <7.72,3.52,9> }
		triangle { <7.72,3.52,9>, <5.8,2.2,9>, <5.8,2.2,5> }
		triangle { <7.72,3.52,5>, <10,4,5>, <10,4,9> }
		triangle { <10,4,9>, <7.72,3.52,9>, <7.72,3.52,5> }
		triangle { <10,4,5>, <12.28,3.52,5>, <12.28,3.52,9> }
		triangle { <12.28,3.52,9>, <10,4,9>, <10,4,5> }
		triangle { <12.28,3.52,5>, <14.2,2.2,5>, <14.2,2.2,9> }
		triangle { <14.2,2.2,9>, <12.28,3.52,9>, <12.28,3.52,5> }
		triangle { <14.2,2.2,5>, <15.52,0.28,5>, <15.52,0.28,9> }
		triangle { <15.52,0.28,9>, <14.2,2.2,9>, <14.2,2.2,5> }
		triangle { <15.52,0.28,5>, <16,-2,5>, <16,-2,8.58> }
		triangle { <16,-2,8.58>, <15.52,0.28,9>, <15.52,0.28,5> }
		triangle { <16,-2,5>, <15.52,-4.28,5>, <15.52,-4.28,7.69> }
		triangle { <15.52,-4.28,7.69>, <16,-2,8.58>, <16,-2,5> }
		triangle { <15.52,-4.28,5>, <14.2,-6.2,5>, <14.2,-6.2,6.37> }
		triangle { <14.2,-6.2,6.37>, <15.52,-4.28,7.69>, <15.52,-4.28,5> }
		triangle { <14.2,-6.2,5>, <12.28,-7.52,5>, <14.2,-6.2,6.37> }
		triangle { <12.28,-7.52,5>, <10,-8,5>, <10,-8,3.83> }
		triangle { <10,-8,3.83>, <12.28,-7.52,4.53>, <12.28,-7.52,5> }
		triangle { <10,-8,5>, <7.72,-7.52,5>, <7.72,-7.52,4.53> }
		triangle { <7.72,-7.52,4.53>, <10,-8,3.83>, <10,-8,5> }
		triangle { <7.72,-7.52,5>, <7.72,-7.52,4.53>, <5.8,-6.2,5> }
		triangle { <5.8,-6.2,5>, <5.8,-6.2,6.37>, <7.72,-7.52,5> }
		triangle { <5.8,-6.2,5>, <4.48,-4.28,5>, <4.48,-4.28,7.69> }
		triangle { <4.48,-4.28,7.69>, <5.8,-6.2,6.37>, <5.8,-6.2,5> }
		triangle { <4.48,-4.28,5>, <4,-2,5>, <4,-2,8.58> }
		triangle { <4,-2,8.58>, <4.48,-4.28,7.69>, <4.48,-4.28,5> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,3,0,-5.72,0,0,0,0,3,7.72,0,0> }
	mesh {
		triangle { <4,28,5>, <16,28,5>, <16,24,5> }
		triangle { <16,24,5>, <4,24,5>, <4,28,5> }
		triangle { <10,12,5>, <7.72,12.48,5>, <4,12.48,5> }
		triangle { <4,12.48,5>, <4,12,5>, <10,12,5> }
		triangle { <7.72,12.48,5>, <5.8,13.8,5>, <4,13.8,5> }
		triangle { <4,13.8,5>, <4,12.48,5>, <7.72,12.48,5> }
		triangle { <5.8,13.8,5>, <4.48,15.72,5>, <4,15.72,5> }
		triangle { <4,15.72,5>, <4,13.8,5>, <5.8,13.8,5> }
		triangle { <4.48,15.72,5>, <4,18,5>, <4,15.72,5> }
		triangle { <4,18,5>, <4.48,20.28,5>, <4,20.28,5> }
		triangle { <4.48,20.28,5>, <5.8,22.2,5>, <4,22.2,5> }
		triangle { <4,22.2,5>, <4,20.28,5>, <4.48,20.28,5> }
		triangle { <5.8,22.2,5>, <7.72,23.52,5>, <4,23.52,5> }
		triangle { <4,23.52,5>, <4,22.2,5>, <5.8,22.2,5> }
		triangle { <7.72,23.52,5>, <10,24,5>, <4,24,5> }
		triangle { <4,24,5>, <4,23.52,5>, <7.72,23.52,5> }
		triangle { <10,24,5>, <12.28,23.52,5>, <16,23.52,5> }
		triangle { <16,23.52,5>, <16,24,5>, <10,24,5> }
		triangle { <12.28,23.52,5>, <14.2,22.2,5>, <16,22.2,5> }
		triangle { <16,22.2,5>, <16,23.52,5>, <12.28,23.52,5> }
		triangle { <14.2,22.2,5>, <15.52,20.28,5>, <16,20.28,5> }
		triangle { <16,20.28,5>, <16,22.2,5>, <14.2,22.2,5> }
		triangle { <15.52,20.28,5>, <16,18,5>, <16,20.28,5> }
		triangle { <16,18,5>, <15.52,15.72,5>, <16,15.72,5> }
		triangle { <15.52,15.72,5>, <14.2,13.8,5>, <16,13.8,5> }
		triangle { <16,13.8,5>, <16,15.72,5>, <15.52,15.72,5> }
		triangle { <14.2,13.8,5>, <12.28,12.48,5>, <16,12.48,5> }
		triangle { <16,12.48,5>, <16,13.8,5>, <14.2,13.8,5> }
		triangle { <12.28,12.48,5>, <10,12,5>, <16,12,5> }
		triangle { <16,12,5>, <16,12.48,5>, <12.28,12.48,5> }
		triangle { <4,12,5>, <4,8,5>, <16,8,5> }
		triangle { <16,8,5>, <16,12,5>, <4,12,5> }
		triangle { <16,28,-7>, <16,28,5>, <16,24,5> }
		triangle { <16,24,5>, <16,24,-7>, <16,28,-7> }
		triangle { <16,24,5>, <16,24,-3>, <16,8,-3> }
		triangle { <16,8,-3>, <16,8,5>, <16,24,5> }
		triangle { <4,28,-7>, <4,28,5>, <4,24,5> }
		triangle { <4,24,5>, <4,24,-7>, <4,28,-7> }
		triangle { <4,24,5>, <4,24,-3>, <4,8,-3> }
		triangle { <4,8,-3>, <4,8,5>, <4,24,5> }
		triangle { <16,8,-3>, <16,8,5>, <4,8,5> }
		triangle { <4,8,5>, <4,8,-3>, <16,8,-3> }
		triangle { <16,8,-3>, <4,8,-3>, <4,24,-3> }
		triangle { <4,24,-3>, <16,24,-3>, <16,8,-3> }
		triangle { <4,24,-3>, <16,24,-3>, <16,24,-7> }
		triangle { <16,24,-7>, <4,24,-7>, <4,24,-3> }
		triangle { <4,24,-7>, <16,24,-7>, <16,28,-7> }
		triangle { <16,28,-7>, <4,28,-7>, <4,24,-7> }
		triangle { <16,28,-7>, <16,28,5>, <19.5,28,9> }
		triangle { <19.5,28,9>, <19.5,28,-11>, <16,28,-7> }
		triangle { <16,28,5>, <4,28,5>, <1.5,28,9> }
		triangle { <1.5,28,9>, <19.5,28,9>, <16,28,5> }
		triangle { <4,28,5>, <4,28,-7>, <1.5,28,-11> }
		triangle { <1.5,28,-11>, <1.5,28,9>, <4,28,5> }
		triangle { <4,28,-7>, <16,28,-7>, <19.5,28,-11> }
		triangle { <19.5,28,-11>, <1.5,28,-11>, <4,28,-7> }
		triangle { <5.66,-6,5>, <4.48,-4.28,5>, <7.72,-4.28,5> }
		triangle { <7.72,-4.28,5>, <7.72,-6,5>, <5.66,-6,5> }
		triangle { <4.48,-4.28,5>, <4,-2,5>, <7.72,-2,5> }
		triangle { <7.72,-2,5>, <7.72,-4.28,5>, <4.48,-4.28,5> }
		triangle { <4,-2,5>, <4.48,0.28,5>, <7.72,0.28,5> }
		triangle { <7.72,0.28,5>, <7.72,-2,5>, <4,-2,5> }
		triangle { <4.48,0.28,5>, <5.8,2.2,5>, <7.72,2.2,5> }
		triangle { <7.72,2.2,5>, <7.72,0.28,5>, <4.48,0.28,5> }
		triangle { <5.8,2.2,5>, <7.72,3.52,5>, <7.72,2.2,5> }
		triangle { <14.34,-6,5>, <14.2,-6.2,5>, <5.8,-6.2,5> }
		triangle { <5.8,-6.2,5>, <5.66,-6,5>, <14.34,-6,5> }
		triangle { <14.2,-6.2,5>, <12.28,-7.52,5>, <7.72,-7.52,5> }
		triangle { <7.72,-7.52,5>, <5.8,-6.2,5>, <14.2,-6.2,5> }
		triangle { <12.28,-7.52,5>, <10,-8,5>, <7.72,-7.52,5> }
		triangle { <14.2,2.2,5>, <14.34,0.28,5>, <15.52,0.28,5> }
		triangle { <15.52,0.28,5>, <14.34,2.2,5>, <14.2,2.2,5> }
		triangle { <15.52,0.28,5>, <16,-2,5>, <14.34,-2,5> }
		triangle { <14.34,-2,5>, <14.34,0.28,5>, <15.52,0.28,5> }
		triangle { <16,-2,5>, <15.52,-4.28,5>, <14.34,-4.28,5> }
		triangle { <14.34,-4.28,5>, <14.34,-2,5>, <16,-2,5> }
		triangle { <15.52,-4.28,5>, <14.34,-6,5>, <14.34,-4.28,5> }
		triangle { <14.34,-6,0>, <7.72,-6,0>, <7.72,-6,5> }
		triangle { <7.72,-6,5>, <14.34,-6,5>, <14.34,-6,0> }
		triangle { <14.34,-6,0>, <14.34,-5.52,-2.28>, <14.34,-5.52,5> }
		triangle { <14.34,-5.52,5>, <14.34,-6,5>, <14.34,-6,0> }
		triangle { <14.34,-5.52,-2.28>, <14.34,-4.2,-4.2>, <14.34,-4.2,5> }
		triangle { <14.34,-4.2,5>, <14.34,-5.52,5>, <14.34,-5.52,-2.28> }
		triangle { <14.34,-4.2,-4.2>, <14.34,-2.28,-5.52>, <14.34,-2.28,5> }
		triangle { <14.34,-2.28,5>, <14.34,-4.2,5>, <14.34,-4.2,-4.2> }
		triangle { <14.34,-2.28,-5.52>, <14.34,0,-6>, <14.34,0,5> }
		triangle { <14.34,0,5>, <14.34,-2.28,5>, <14.34,-2.28,-5.52> }
		triangle { <14.34,0,-6>, <14.34,2,-5.58>, <14.34,2,5> }
		triangle { <14.34,2,5>, <14.34,0,5>, <14.34,0,-6> }
		triangle { <7.72,-6,0>, <7.72,-5.52,-2.28>, <7.72,-5.52,5> }
		triangle { <7.72,-5.52,5>, <7.72,-6,5>, <7.72,-6,0> }
		triangle { <7.72,-5.52,-2.28>, <7.72,-4.2,-4.2>, <7.72,-4.2,5> }
		triangle { <7.72,-4.2,5>, <7.72,-5.52,5>, <7.72,-5.52,-2.28> }
		triangle { <7.72,-4.2,-4.2>, <7.72,-3,-5.03>, <7.72,-3,5> }
		triangle { <7.72,-3,5>, <7.72,-4.2,5>, <7.72,-4.2,-4.2> }
		triangle { <7.72,-2.76,1.14>, <7.72,-3,0>, <7.72,-3,5> }
		triangle { <7.72,-3,5>, <7.72,-2.76,5>, <7.72,-2.76,1.14> }
		triangle { <7.72,-2.1,2.1>, <7.72,-2.76,1.14>, <7.72,-2.76,5> }
		triangle { <7.72,-2.76,5>, <7.72,-2.1,5>, <7.72,-2.1,2.1> }
		triangle { <7.72,-1.14,2.76>, <7.72,-2.1,2.1>, <7.72,-2.1,5> }
		triangle { <7.72,-2.1,5>, <7.72,-1.14,5>, <7.72,-1.14,2.76> }
		triangle { <7.72,0,3>, <7.72,-1.14,2.76>, <7.72,-1.14,5> }
		triangle { <7.72,-1.14,5>, <7.72,0,5>, <7.72,0,3> }
		triangle { <7.72,1.14,2.76>, <7.72,0,3>, <7.72,0,5> }
		triangle { <7.72,0,5>, <7.72,1.14,5>, <7.72,1.14,2.76> }
		triangle { <7.72,2.1,2.1>, <7.72,1.14,2.76>, <7.72,1.14,5> }
		triangle { <7.72,1.14,5>, <7.72,2.1,5>, <7.72,2.1,2.1> }
		triangle { <7.72,2.76,1.14>, <7.72,2.1,2.1>, <7.72,2.1,5> }
		triangle { <7.72,2.1,5>, <7.72,2.76,5>, <7.72,2.76,1.14> }
		triangle { <7.72,3,0>, <7.72,2.76,1.14>, <7.72,2.76,5> }
		triangle { <7.72,2.76,5>, <7.72,3,5>, <7.72,3,0> }
		triangle { <7.72,-3,0>, <7.72,-2.76,-1.14>, <7.72,-2.76,-5.19> }
		triangle { <7.72,-2.76,-5.19>, <7.72,-3,-5.03>, <7.72,-3,0> }
		triangle { <7.72,-2.76,-1.14>, <7.72,-2.1,-2.1>, <7.72,-2.1,-5.56> }
		triangle { <7.72,-2.1,-5.56>, <7.72,-2.76,-5.19>, <7.72,-2.76,-1.14> }
		triangle { <7.72,-2.1,-2.1>, <7.72,-1.14,-2.76>, <7.72,-1.14,-5.76> }
		triangle { <7.72,-1.14,-5.76>, <7.72,-2.1,-5.56>, <7.72,-2.1,-2.1> }
		triangle { <7.72,-1.14,-2.76>, <7.72,0,-3>, <7.72,0,-6> }
		triangle { <7.72,0,-6>, <7.72,-1.14,-5.76>, <7.72,-1.14,-2.76> }
		triangle { <7.72,0,-3>, <7.72,1.14,-2.76>, <7.72,1.14,-5.76> }
		triangle { <7.72,1.14,-5.76>, <7.72,0,-6>, <7.72,0,-3> }
		triangle { <7.72,1.14,-2.76>, <7.72,2.1,-2.1>, <7.72,2.1,-5.56> }
		triangle { <7.72,2.1,-5.56>, <7.72,1.14,-5.76>, <7.72,1.14,-2.76> }
		triangle { <7.72,2.1,-2.1>, <7.72,2.76,-1.14>, <7.72,2.76,-5.19> }
		triangle { <7.72,2.76,-5.19>, <7.72,2.1,-5.56>, <7.72,2.1,-2.1> }
		triangle { <7.72,2.76,-1.14>, <7.72,3,0>, <7.72,3,-5.03> }
		triangle { <7.72,3,-5.03>, <7.72,2.76,-5.19>, <7.72,2.76,-1.14> }
		triangle { <7.72,3.52,-4.67>, <7.72,3.52,9>, <7.72,3,5> }
		triangle { <7.72,3,5>, <7.72,3,-5.03>, <7.72,3.52,-4.67> }
		triangle { <7.72,3.52,-4.67>, <10,4,-4.34>, <10,4,9> }
		triangle { <10,4,9>, <7.72,3.52,9>, <7.72,3.52,-4.67> }
		triangle { <10,4,-4.34>, <12.28,3.52,-4.67>, <12.28,3.52,9> }
		triangle { <12.28,3.52,9>, <10,4,9>, <10,4,-4.34> }
		triangle { <12.28,3.52,-4.67>, <14.2,2.2,-5.54>, <14.2,2.2,9> }
		triangle { <14.2,2.2,9>, <12.28,3.52,9>, <12.28,3.52,-4.67> }
		triangle { <14.2,2.2,-5.54>, <14.34,2,-5.58>, <14.34,2,9> }
		triangle { <14.34,2,9>, <14.2,2.2,9>, <14.2,2.2,-5.54> }
		triangle { <14.34,-6,0>, <14.34,-5.52,-2.28>, <7.72,-5.52,-2.28> }
		triangle { <7.72,-5.52,-2.28>, <7.72,-6,0>, <14.34,-6,0> }
		triangle { <14.34,-5.52,-2.28>, <14.34,-4.2,-4.2>, <7.72,-4.2,-4.2> }
		triangle { <7.72,-4.2,-4.2>, <7.72,-5.52,-2.28>, <14.34,-5.52,-2.28> }
		triangle { <14.34,-4.2,-4.2>, <14.34,-2.28,-5.52>, <7.72,-2.28,-5.52> }
		triangle { <7.72,-2.28,-5.52>, <7.72,-4.2,-4.2>, <14.34,-4.2,-4.2> }
		triangle { <14.34,-2.28,-5.52>, <14.34,0,-6>, <7.72,0,-6> }
		triangle { <7.72,0,-6>, <7.72,-2.28,-5.52>, <14.34,-2.28,-5.52> }
		triangle { <14.34,0,-6>, <14.34,2,-5.58>, <7.72,2,-5.58> }
		triangle { <7.72,2,-5.58>, <7.72,0,-6>, <14.34,0,-6> }
		triangle { <7.72,2,-5.58>, <14.43,2,-5.58>, <14.2,2.2,-5.54> }
		triangle { <14.2,2.2,-5.54>, <7.72,2.2,-5.54>, <7.72,2,-5.58> }
		triangle { <7.72,2.2,-5.54>, <14.2,2.2,-5.54>, <12.28,3.52,-4.67> }
		triangle { <12.28,3.52,-4.67>, <7.72,3.52,-4.67>, <7.72,2.2,-5.54> }
		triangle { <7.72,3.52,-4.67>, <12.28,3.52,-4.67>, <10,4,-4.34> }
		triangle { <19.5,28,-11>, <19.5,28,-6>, <19.18,20,-6> }
		triangle { <19.18,20,-6>, <19.18,20,-11>, <19.5,28,-11> }
		triangle { <19.5,28,-6>, <19.5,28,9>, <18.36,0,9> }
		triangle { <18.36,0,9>, <18.36,0,-6>, <19.5,28,-6> }
		triangle { <18.64,6.74,6>, <18.5,3.42,8.28>, <18.5,3.42,-8.28> }
		triangle { <18.5,3.42,-8.28>, <18.64,6.74,-6>, <18.64,6.74,6> }
		triangle { <18.5,3.42,8.28>, <18.36,0,9>, <18.36,0,-9> }
		triangle { <18.36,0,-9>, <18.5,3.42,-8.28>, <18.5,3.42,8.28> }
		triangle { <18.36,0,9>, <18.23,-3.42,8.28>, <18.23,-3.42,-8.28> }
		triangle { <18.23,-3.42,-8.28>, <18.36,0,-9>, <18.36,0,9> }
		triangle { <18.23,-3.42,8.28>, <18.11,-6.3,6.3>, <18.11,-6.3,-6.3> }
		triangle { <18.11,-6.3,-6.3>, <18.23,-3.42,-8.28>, <18.23,-3.42,8.28> }
		triangle { <18.11,-6.3,6.3>, <18.03,-8.28,3.42>, <18.03,-8.28,-3.42> }
		triangle { <18.03,-8.28,-3.42>, <18.11,-6.3,-6.3>, <18.11,-6.3,6.3> }
		triangle { <18.03,-8.28,3.42>, <18,-9,0>, <18.03,-8.28,-3.42> }
		triangle { <1.5,28,-11>, <1.5,28,-6>, <1.5,20,-6> }
		triangle { <1.5,20,-6>, <1.5,20,-11>, <1.5,28,-11> }
		triangle { <1.5,28,-6>, <1.5,28,9>, <1.5,10,9> }
		triangle { <1.5,10,9>, <1.5,10,-6>, <1.5,28,-6> }
		triangle { <1.5,7.7,-6>, <1.5,9.2,-3.8>, <1.5,9.2,-6> }
		triangle { <1.5,9.2,-3.8>, <1.5,10,0>, <1.5,10,-6> }
		triangle { <1.5,10,-6>, <1.5,9.2,-6>, <1.5,9.2,-3.8> }
		triangle { <1.5,10,0>, <1.5,9.2,3.8>, <1.5,9.2,9> }
		triangle { <1.5,9.2,9>, <1.5,10,9>, <1.5,10,0> }
		triangle { <1.5,9.2,3.8>, <1.5,7,7>, <1.5,7,9> }
		triangle { <1.5,7,9>, <1.5,9.2,9>, <1.5,9.2,3.8> }
		triangle { <1.5,7,7>, <1.5,4.1,9>, <1.5,7,9> }
		triangle { <1.5,7.7,-6>, <1.5,9.2,-3.8>, <2,9.2,-3.8> }
		triangle { <2,9.2,-3.8>, <2,7.7,-6>, <1.5,7.7,-6> }
		triangle { <1.5,9.2,-3.8>, <1.5,10,0>, <2,10,0> }
		triangle { <2,10,0>, <2,9.2,-3.8>, <1.5,9.2,-3.8> }
		triangle { <1.5,10,0>, <1.5,9.2,3.8>, <2,9.2,3.8> }
		triangle { <2,9.2,3.8>, <2,10,0>, <1.5,10,0> }
		triangle { <1.5,9.2,3.8>, <1.5,7,7>, <2,7,7> }
		triangle { <2,7,7>, <2,9.2,3.8>, <1.5,9.2,3.8> }
		triangle { <1.5,7,7>, <1.5,4.1,9>, <2,4.1,9> }
		triangle { <2,4.1,9>, <2,7,7>, <1.5,7,7> }
		triangle { <2,3,0>, <2,10,0>, <2,9.66,2.59> }
		triangle { <2,9.66,2.59>, <2,2.9,0.78>, <2,3,0> }
		triangle { <2,2.9,0.78>, <2,9.66,2.59>, <2,8.66,5> }
		triangle { <2,8.66,5>, <2,2.6,1.5>, <2,2.9,0.78> }
		triangle { <2,2.6,1.5>, <2,8.66,5>, <2,7.07,7.07> }
		triangle { <2,7.07,7.07>, <2,2.12,2.12>, <2,2.6,1.5> }
		triangle { <2,2.12,2.12>, <2,7.07,7.07>, <2,5,8.66> }
		triangle { <2,5,8.66>, <2,1.5,2.6>, <2,2.12,2.12> }
		triangle { <2,1.5,2.6>, <2,5,8.66>, <2,4.36,9> }
		triangle { <2,4.36,9>, <2,1.31,2.7>, <2,1.5,2.6> }
		triangle { <2,1.31,2.7>, <2,4.36,9>, <2,2.33,9> }
		triangle { <2,2.33,9>, <2,0.78,2.9>, <2,1.31,2.7> }
		triangle { <2,0.78,2.9>, <2,2.33,9>, <2,0,9> }
		triangle { <2,0,9>, <2,0,3>, <2,0.78,2.9> }
		triangle { <2,0,3>, <2,0,9>, <2,-2.33,8.69> }
		triangle { <2,-2.33,8.69>, <2,-0.78,2.9>, <2,0,3> }
		triangle { <2,-0.78,2.9>, <2,-2.33,8.69>, <2,-4.5,7.79> }
		triangle { <2,-4.5,7.79>, <2,-1.5,2.6>, <2,-0.78,2.9> }
		triangle { <2,-1.5,2.6>, <2,-4.5,7.79>, <2,-6.36,6.36> }
		triangle { <2,-6.36,6.36>, <2,-2.12,2.12>, <2,-1.5,2.6> }
		triangle { <2,-2.12,2.12>, <2,-6.36,6.36>, <2,-7.79,4.5> }
		triangle { <2,-7.79,4.5>, <2,-2.6,1.5>, <2,-2.12,2.12> }
		triangle { <2,-2.6,1.5>, <2,-7.79,4.5>, <2,-8.69,2.33> }
		triangle { <2,-8.69,2.33>, <2,-2.9,0.78>, <2,-2.6,1.5> }
		triangle { <2,-2.9,0.78>, <2,-8.69,2.33>, <2,-9,0> }
		triangle { <2,-9,0>, <2,-3,0>, <2,-2.9,0.78> }
		triangle { <2,-3,0>, <2,-9,0>, <2,-8.69,-2.33> }
		triangle { <2,-8.69,-2.33>, <2,-2.9,-0.78>, <2,-3,0> }
		triangle { <2,-2.9,-0.78>, <2,-8.69,-2.33>, <2,-7.79,-4.5> }
		triangle { <2,-7.79,-4.5>, <2,-2.6,-1.5>, <2,-2.9,-0.78> }
		triangle { <2,-2.6,-1.5>, <2,-7.79,-4.5>, <2,-6.36,-6.36> }
		triangle { <2,-6.36,-6.36>, <2,-2.12,-2.12>, <2,-2.6,-1.5> }
		triangle { <2,-2.12,-2.12>, <2,-6.36,-6.36>, <2,-4.5,-7.79> }
		triangle { <2,-4.5,-7.79>, <2,-1.5,-2.6>, <2,-2.12,-2.12> }
		triangle { <2,-1.5,-2.6>, <2,-4.5,-7.79>, <2,-2.33,-8.69> }
		triangle { <2,-2.33,-8.69>, <2,-0.78,-2.9>, <2,-1.5,-2.6> }
		triangle { <2,-0.78,-2.9>, <2,-2.33,-8.69>, <2,0,-9> }
		triangle { <2,0,-9>, <2,0,-3>, <2,-0.78,-2.9> }
		triangle { <2,0,-3>, <2,0,-9>, <2,2.33,-8.69> }
		triangle { <2,2.33,-8.69>, <2,0.78,-2.9>, <2,0,-3> }
		triangle { <2,0.78,-2.9>, <2,2.33,-8.69>, <2,4.5,-7.79> }
		triangle { <2,4.5,-7.79>, <2,1.5,-2.6>, <2,0.78,-2.9> }
		triangle { <2,1.5,-2.6>, <2,4.5,-7.79>, <2,6.36,-6.36> }
		triangle { <2,6.36,-6.36>, <2,2.12,-2.12>, <2,1.5,-2.6> }
		triangle { <2,2.12,-2.12>, <2,6.36,-6.36>, <2,6.71,-6> }
		triangle { <2,6.71,-6>, <2,2.24,-2>, <2,2.12,-2.12> }
		triangle { <2,2.24,-2>, <2,6.71,-6>, <2,8,-6> }
		triangle { <2,8,-6>, <2,2.4,-1.8>, <2,2.24,-2> }
		triangle { <2,2.4,-1.8>, <2,8,-6>, <2,8.66,-5> }
		triangle { <2,8.66,-5>, <2,2.6,-1.5>, <2,2.4,-1.8> }
		triangle { <2,2.6,-1.5>, <2,8.66,-5>, <2,9.66,-2.59> }
		triangle { <2,9.66,-2.59>, <2,2.9,-0.78>, <2,2.6,-1.5> }
		triangle { <2,2.9,-0.78>, <2,9.66,-2.59>, <2,10,0> }
		triangle { <2,10,0>, <2,3,0>, <2,2.9,-0.78> }
		triangle { <2,3,0>, <2,10,0>, <2,28,-1> }
		triangle { <19.5,28,-11>, <1.5,28,-11>, <1.5,20,-11> }
		triangle { <1.5,20,-11>, <19.18,20,-11>, <19.5,28,-11> }
		triangle { <19.18,20,-11>, <1.5,20,-11>, <1.5,20,-6> }
		triangle { <1.5,20,-6>, <19.18,20,-6>, <19.18,20,-11> }
		triangle { <18.07,-7.19,5.01>, <18.03,-8.28,3.42>, <2,-8.28,3.42> }
		triangle { <2,-8.28,3.42>, <2,-7.19,5.01>, <18.07,-7.19,5.01> }
		triangle { <18.03,-8.28,3.42>, <18,-9,0>, <2,-9,0> }
		triangle { <2,-9,0>, <2,-8.28,3.42>, <18.03,-8.28,3.42> }
		triangle { <18,-9,0>, <18.03,-8.28,-3.42>, <2,-8.28,-3.42> }
		triangle { <2,-8.28,-3.42>, <2,-9,0>, <18,-9,0> }
		triangle { <18.03,-8.28,-3.42>, <18.11,-6.3,-6.3>, <2,-6.3,-6.3> }
		triangle { <2,-6.3,-6.3>, <2,-8.28,-3.42>, <18.03,-8.28,-3.42> }
	}
}
#end

#declare _972_dot_dat = #if (QUAL = 0) box { <1.5,-9,-11>, <19.5,28,9> } #else union {
	mesh {
		triangle { <19.18,20,-6>, <1.5,20,-6>, <1.5,7.7,-6> }
		triangle { <1.5,7.7,-6>, <18.68,7.7,-6>, <19.18,20,-6> }
		triangle { <18.64,6.74,-6>, <2,6.74,-6>, <1.5,7.7,-6> }
		triangle { <1.5,7.7,-6>, <18.68,7.7,-6>, <18.64,6.74,-6> }
		triangle { <18.11,-6.3,-6.3>, <18.23,-3.42,-8.28>, <2,-3.42,-8.28> }
		triangle { <2,-3.42,-8.28>, <2,-6.3,-6.3>, <18.11,-6.3,-6.3> }
		triangle { <18.23,-3.42,-8.28>, <18.36,0,-9>, <2,0,-9> }
		triangle { <2,0,-9>, <2,-3.42,-8.28>, <18.23,-3.42,-8.28> }
		triangle { <18.36,0,-9>, <18.5,3.42,-8.28>, <2,3.42,-8.28> }
		triangle { <2,3.42,-8.28>, <2,0,-9>, <18.36,0,-9> }
		triangle { <18.5,3.42,-8.28>, <18.64,6.74,-6>, <2,6.74,-6> }
		triangle { <2,6.74,-6>, <2,3.42,-8.28>, <18.5,3.42,-8.28> }
	}
	object { s_slash_972s01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// 
}
#end

#declare _3_dash_4cyli_dot_dat = cylinder {
	<0,0,0>, <0,1,0>, 1 open
	clipped_by { plane { <1,0,-1>, O7071 } }
}

#declare _4_dash_4disc_dot_dat = #if (ver >= 3.1)
	disc { <0,0,0>, <0,1,0>, 1 }
#else
	cylinder { <0,-0.001,0>, <0,0.001,0>, 1 }
#end

#declare s_slash_970s01_dot_dat = #if (QUAL = 0) box { <-18,-11,-10>, <18,21,10> } #else union {
	mesh {
		triangle { <-18,0,-10>, <18,0,-10>, <18,0,10> }
		triangle { <18,0,10>, <-18,0,10>, <-18,0,-10> }
		triangle { <-18,0,10>, <-18,6,10>, <18,6,10> }
		triangle { <18,6,10>, <18,0,10>, <-18,0,10> }
		triangle { <18,6,10>, <18,6,6.51>, <18,0,6.51> }
		triangle { <18,0,6.51>, <18,0,10>, <18,6,10> }
		triangle { <18,6,6.51>, <18,5.7,6.3>, <18,0,6.3> }
		triangle { <18,0,6.3>, <18,0,6.51>, <18,6,6.51> }
		triangle { <18,5.7,6.3>, <18,3.72,3.42>, <18,0,3.42> }
		triangle { <18,0,3.42>, <18,0,6.3>, <18,5.7,6.3> }
		triangle { <18,3.72,3.42>, <18,3,0>, <18,0,0> }
		triangle { <18,0,0>, <18,0,3.42>, <18,3.72,3.42> }
		triangle { <18,3,0>, <18,3.72,-3.42>, <18,0,-3.42> }
		triangle { <18,0,-3.42>, <18,0,0>, <18,3,0> }
		triangle { <18,3.72,-3.42>, <18,5.7,-6.3>, <18,0,-6.3> }
		triangle { <18,0,-6.3>, <18,0,-3.42>, <18,3.72,-3.42> }
		triangle { <18,5.7,-6.3>, <18,6,-6.51>, <18,0,-6.51> }
		triangle { <18,0,-6.51>, <18,0,-6.3>, <18,5.7,-6.3> }
		triangle { <18,6,-6.51>, <18,6,-10>, <18,0,-10> }
		triangle { <18,0,-10>, <18,0,-6.51>, <18,6,-6.51> }
		triangle { <-18,6,10>, <-18,6,6.51>, <-18,0,6.51> }
		triangle { <-18,0,6.51>, <-18,0,10>, <-18,6,10> }
		triangle { <-18,6,6.51>, <-18,5.7,6.3>, <-18,0,6.3> }
		triangle { <-18,0,6.3>, <-18,0,6.51>, <-18,6,6.51> }
		triangle { <-18,5.7,6.3>, <-18,3.72,3.42>, <-18,0,3.42> }
		triangle { <-18,0,3.42>, <-18,0,6.3>, <-18,5.7,6.3> }
		triangle { <-18,3.72,3.42>, <-18,3,0>, <-18,0,0> }
		triangle { <-18,0,0>, <-18,0,3.42>, <-18,3.72,3.42> }
		triangle { <-18,3,0>, <-18,3.72,-3.42>, <-18,0,-3.42> }
		triangle { <-18,0,-3.42>, <-18,0,0>, <-18,3,0> }
		triangle { <-18,3.72,-3.42>, <-18,5.7,-6.3>, <-18,0,-6.3> }
		triangle { <-18,0,-6.3>, <-18,0,-3.42>, <-18,3.72,-3.42> }
		triangle { <-18,5.7,-6.3>, <-18,6,-6.51>, <-18,0,-6.51> }
		triangle { <-18,0,-6.51>, <-18,0,-6.3>, <-18,5.7,-6.3> }
		triangle { <-18,6,-6.51>, <-18,6,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-18,0,-6.51>, <-18,6,-6.51> }
		triangle { <-18,6,10>, <-18,6,6.51>, <18,6,6.51> }
		triangle { <18,6,6.51>, <18,6,10>, <-18,6,10> }
		triangle { <-18,6,6.51>, <-18,5.7,6.3>, <18,5.7,6.3> }
		triangle { <18,5.7,6.3>, <18,6,6.51>, <-18,6,6.51> }
		triangle { <-18,5.7,6.3>, <-18,3.72,3.42>, <18,3.72,3.42> }
		triangle { <18,3.72,3.42>, <18,5.7,6.3>, <-18,5.7,6.3> }
		triangle { <-18,3.72,3.42>, <-18,3,0>, <18,3,0> }
		triangle { <18,3,0>, <18,3.72,3.42>, <-18,3.72,3.42> }
		triangle { <-18,3,0>, <-18,3.72,-3.42>, <18,3.72,-3.42> }
		triangle { <18,3.72,-3.42>, <18,3,0>, <-18,3,0> }
		triangle { <-18,3.72,-3.42>, <-18,5.7,-6.3>, <18,5.7,-6.3> }
		triangle { <18,5.7,-6.3>, <18,3.72,-3.42>, <-18,3.72,-3.42> }
		triangle { <-18,5.7,-6.3>, <-18,6,-6.51>, <18,6,-6.51> }
		triangle { <18,6,-6.51>, <18,5.7,-6.3>, <-18,5.7,-6.3> }
		triangle { <-18,6,-10>, <-18,6,-6.51>, <18,6,-6.51> }
		triangle { <18,6,-6.51>, <18,6,-10>, <-18,6,-10> }
		triangle { <14.482,0,-4.482>, <13.464,0,-6>, <13.464,-11,-6> }
		triangle { <13.464,-11,-6>, <14.482,-11,-4.482>, <14.482,0,-4.482> }
		triangle { <13.464,0,-6>, <6.536,0,-6>, <6.536,-11,-6> }
		triangle { <6.536,-11,-6>, <13.464,-11,-6>, <13.464,0,-6> }
		triangle { <6.536,0,-6>, <5.518,0,-4.482>, <5.518,-11,-4.482> }
		triangle { <5.518,-11,-4.482>, <6.536,-11,-6>, <6.536,0,-6> }
		triangle { <5.518,0,-4.482>, <4,0,-3.464>, <4,-11,-3.464> }
		triangle { <4,-11,-3.464>, <5.518,-11,-4.482>, <5.518,0,-4.482> }
		triangle { <4,0,-3.464>, <4,0,3.464>, <4,-11,3.464> }
		triangle { <4,-11,3.464>, <4,-11,-3.464>, <4,0,-3.464> }
		triangle { <4,0,3.464>, <5.518,0,4.482>, <5.518,-11,4.482> }
		triangle { <5.518,-11,4.482>, <4,-11,3.464>, <4,0,3.464> }
		triangle { <5.518,0,4.482>, <6.536,0,6>, <6.536,-11,6> }
		triangle { <6.536,-11,6>, <5.518,-11,4.482>, <5.518,0,4.482> }
		triangle { <6.536,0,6>, <13.464,0,6>, <13.464,-11,6> }
		triangle { <13.464,-11,6>, <6.536,-11,6>, <6.536,0,6> }
		triangle { <13.464,0,6>, <14.482,0,4.482>, <14.482,-11,4.482> }
		triangle { <14.482,-11,4.482>, <13.464,-11,6>, <13.464,0,6> }
		triangle { <14.482,0,4.482>, <16,0,3.464>, <16,-4,3.464> }
		triangle { <16,-4,3.464>, <14.482,-4,4.482>, <14.482,0,4.482> }
		triangle { <14.482,-4,4.482>, <16,-4,3.464>, <14.482,-11,4.482> }
		triangle { <16,0,-3.464>, <16,0,3.464>, <16,-4,3.464> }
		triangle { <16,-4,3.464>, <16,-4,-3.464>, <16,0,-3.464> }
		triangle { <16,-4,-3.464>, <16,-4,3.464>, <14.482,-11,4.482> }
		triangle { <14.482,-11,4.482>, <14.482,-11,-4.482>, <16,-4,-3.464> }
		triangle { <16,0,-3.464>, <14.482,0,-4.482>, <14.482,-4,-4.482> }
		triangle { <14.482,-4,-4.482>, <16,-4,-3.464>, <16,0,-3.464> }
		triangle { <14.482,-4,-4.482>, <16,-4,-3.464>, <14.482,-11,-4.482> }
		triangle { <14,-11,0>, <13.68,-11,1.52>, <14.482,-11,4.482> }
		triangle { <14.482,-11,4.482>, <14.482,-11,0>, <14,-11,0> }
		triangle { <13.68,-11,1.52>, <12.8,-11,2.8>, <14.482,-11,4.482> }
		triangle { <12.8,-11,2.8>, <11.52,-11,3.68>, <13.464,-11,6> }
		triangle { <13.464,-11,6>, <14.482,-11,4.482>, <12.8,-11,2.8> }
		triangle { <11.52,-11,3.68>, <10,-11,4>, <10,-11,6> }
		triangle { <10,-11,6>, <13.464,-11,6>, <11.52,-11,3.68> }
		triangle { <10,-11,4>, <8.48,-11,3.68>, <6.536,-11,6> }
		triangle { <6.536,-11,6>, <10,-11,6>, <10,-11,4> }
		triangle { <8.48,-11,3.68>, <7.2,-11,2.8>, <5.518,-11,4.482> }
		triangle { <5.518,-11,4.482>, <6.536,-11,6>, <8.48,-11,3.68> }
		triangle { <7.2,-11,2.8>, <6.32,-11,1.52>, <4,-11,3.464> }
		triangle { <4,-11,3.464>, <5.518,-11,4.482>, <7.2,-11,2.8> }
		triangle { <6.32,-11,1.52>, <6,-11,0>, <4,-11,0> }
		triangle { <4,-11,0>, <4,-11,3.464>, <6.32,-11,1.52> }
		triangle { <6,-11,0>, <6.32,-11,-1.52>, <4,-11,-3.464> }
		triangle { <4,-11,-3.464>, <4,-11,0>, <6,-11,0> }
		triangle { <6.32,-11,-1.52>, <7.2,-11,-2.8>, <5.518,-11,-4.482> }
		triangle { <5.518,-11,-4.482>, <4,-11,-3.464>, <6.32,-11,-1.52> }
		triangle { <7.2,-11,-2.8>, <8.48,-11,-3.68>, <6.536,-11,-6> }
		triangle { <6.536,-11,-6>, <5.518,-11,-4.482>, <7.2,-11,-2.8> }
		triangle { <8.48,-11,-3.68>, <10,-11,-4>, <10,-11,-6> }
		triangle { <10,-11,-6>, <6.536,-11,-6>, <8.48,-11,-3.68> }
		triangle { <10,-11,-4>, <11.52,-11,-3.68>, <13.464,-11,-6> }
		triangle { <13.464,-11,-6>, <10,-11,-6>, <10,-11,-4> }
		triangle { <11.52,-11,-3.68>, <12.8,-11,-2.8>, <14.482,-11,-4.482> }
		triangle { <14.482,-11,-4.482>, <13.464,-11,-6>, <11.52,-11,-3.68> }
		triangle { <12.8,-11,-2.8>, <13.68,-11,-1.52>, <14.482,-11,-4.482> }
		triangle { <13.68,-11,-1.52>, <14,-11,0>, <14.482,-11,0> }
		triangle { <14.482,-11,0>, <14.482,-11,-4.482>, <13.68,-11,-1.52> }
	}
	object { _3_dash_4cyli_dot_dat matrix <2.84,0,2.84,0,11,0,-2.84,0,2.84,10,-11,0> }
	mesh {
		triangle { <12.84,-11,2.24>, <12.84,-11,-2.84>, <12.84,0,-2.84> }
		triangle { <12.84,0,-2.84>, <12.84,0,2.24>, <12.84,-11,2.24> }
		triangle { <-14.482,0,-4.482>, <-13.464,0,-6>, <-13.464,-11,-6> }
		triangle { <-13.464,-11,-6>, <-14.482,-11,-4.482>, <-14.482,0,-4.482> }
		triangle { <-13.464,0,-6>, <-6.536,0,-6>, <-6.536,-11,-6> }
		triangle { <-6.536,-11,-6>, <-13.464,-11,-6>, <-13.464,0,-6> }
		triangle { <-6.536,0,-6>, <-5.518,0,-4.482>, <-5.518,-11,-4.482> }
		triangle { <-5.518,-11,-4.482>, <-6.536,-11,-6>, <-6.536,0,-6> }
		triangle { <-5.518,0,-4.482>, <-4,0,-3.464>, <-4,-11,-3.464> }
		triangle { <-4,-11,-3.464>, <-5.518,-11,-4.482>, <-5.518,0,-4.482> }
		triangle { <-4,0,-3.464>, <-4,0,3.464>, <-4,-11,3.464> }
		triangle { <-4,-11,3.464>, <-4,-11,-3.464>, <-4,0,-3.464> }
		triangle { <-4,0,3.464>, <-5.518,0,4.482>, <-5.518,-11,4.482> }
		triangle { <-5.518,-11,4.482>, <-4,-11,3.464>, <-4,0,3.464> }
		triangle { <-5.518,0,4.482>, <-6.536,0,6>, <-6.536,-11,6> }
		triangle { <-6.536,-11,6>, <-5.518,-11,4.482>, <-5.518,0,4.482> }
		triangle { <-6.536,0,6>, <-13.464,0,6>, <-13.464,-11,6> }
		triangle { <-13.464,-11,6>, <-6.536,-11,6>, <-6.536,0,6> }
		triangle { <-13.464,0,6>, <-14.482,0,4.482>, <-14.482,-11,4.482> }
		triangle { <-14.482,-11,4.482>, <-13.464,-11,6>, <-13.464,0,6> }
		triangle { <-14.482,0,4.482>, <-16,0,3.464>, <-16,-4,3.464> }
		triangle { <-16,-4,3.464>, <-14.482,-4,4.482>, <-14.482,0,4.482> }
		triangle { <-14.482,-4,4.482>, <-16,-4,3.464>, <-14.482,-11,4.482> }
		triangle { <-16,0,-3.464>, <-16,0,3.464>, <-16,-4,3.464> }
		triangle { <-16,-4,3.464>, <-16,-4,-3.464>, <-16,0,-3.464> }
		triangle { <-16,-4,-3.464>, <-16,-4,3.464>, <-14.482,-11,4.482> }
		triangle { <-14.482,-11,4.482>, <-14.482,-11,-4.482>, <-16,-4,-3.464> }
		triangle { <-16,0,-3.464>, <-14.482,0,-4.482>, <-14.482,-4,-4.482> }
		triangle { <-14.482,-4,-4.482>, <-16,-4,-3.464>, <-16,0,-3.464> }
		triangle { <-14.482,-4,-4.482>, <-14.482,-11,-4.482>, <-16,-4,-3.464> }
		triangle { <-14,-11,0>, <-13.68,-11,1.52>, <-14.482,-11,4.482> }
		triangle { <-14.482,-11,4.482>, <-14.482,-11,0>, <-14,-11,0> }
		triangle { <-13.68,-11,1.52>, <-12.8,-11,2.8>, <-14.482,-11,4.482> }
		triangle { <-12.8,-11,2.8>, <-11.52,-11,3.68>, <-13.464,-11,6> }
		triangle { <-13.464,-11,6>, <-14.482,-11,4.482>, <-12.8,-11,2.8> }
		triangle { <-11.52,-11,3.68>, <-10,-11,4>, <-10,-11,6> }
		triangle { <-10,-11,6>, <-13.464,-11,6>, <-11.52,-11,3.68> }
		triangle { <-10,-11,4>, <-8.48,-11,3.68>, <-6.536,-11,6> }
		triangle { <-6.536,-11,6>, <-10,-11,6>, <-10,-11,4> }
		triangle { <-8.48,-11,3.68>, <-7.2,-11,2.8>, <-5.518,-11,4.482> }
		triangle { <-5.518,-11,4.482>, <-6.536,-11,6>, <-8.48,-11,3.68> }
		triangle { <-7.2,-11,2.8>, <-6.32,-11,1.52>, <-4,-11,3.464> }
		triangle { <-4,-11,3.464>, <-5.518,-11,4.482>, <-7.2,-11,2.8> }
		triangle { <-6.32,-11,1.52>, <-6,-11,0>, <-4,-11,0> }
		triangle { <-4,-11,0>, <-4,-11,3.464>, <-6.32,-11,1.52> }
		triangle { <-6,-11,0>, <-6.32,-11,-1.52>, <-4,-11,-3.464> }
		triangle { <-4,-11,-3.464>, <-4,-11,0>, <-6,-11,0> }
		triangle { <-6.32,-11,-1.52>, <-7.2,-11,-2.8>, <-5.518,-11,-4.482> }
		triangle { <-5.518,-11,-4.482>, <-4,-11,-3.464>, <-6.32,-11,-1.52> }
		triangle { <-7.2,-11,-2.8>, <-8.48,-11,-3.68>, <-6.536,-11,-6> }
		triangle { <-6.536,-11,-6>, <-5.518,-11,-4.482>, <-7.2,-11,-2.8> }
		triangle { <-8.48,-11,-3.68>, <-10,-11,-4>, <-10,-11,-6> }
		triangle { <-10,-11,-6>, <-6.536,-11,-6>, <-8.48,-11,-3.68> }
		triangle { <-10,-11,-4>, <-11.52,-11,-3.68>, <-13.464,-11,-6> }
		triangle { <-13.464,-11,-6>, <-10,-11,-6>, <-10,-11,-4> }
		triangle { <-11.52,-11,-3.68>, <-12.8,-11,-2.8>, <-14.482,-11,-4.482> }
		triangle { <-14.482,-11,-4.482>, <-13.464,-11,-6>, <-11.52,-11,-3.68> }
		triangle { <-12.8,-11,-2.8>, <-13.68,-11,-1.52>, <-14.482,-11,-4.482> }
		triangle { <-13.68,-11,-1.52>, <-14,-11,0>, <-14.482,-11,0> }
		triangle { <-14.482,-11,0>, <-14.482,-11,-4.482>, <-13.68,-11,-1.52> }
	}
	object { _3_dash_4cyli_dot_dat matrix <-2.84,0,2.84,0,11,0,2.84,0,2.84,-10,-11,0> }
	mesh {
		triangle { <-12.84,-11,2.24>, <-12.84,-11,-2.84>, <-12.84,0,-2.84> }
		triangle { <-12.84,0,-2.84>, <-12.84,0,2.24>, <-12.84,-11,2.24> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,9,0,4,0,0,0,0,9,-2,12,0> }
	object { _4_dash_4disc_dot_dat matrix <0,9,0,1,0,0,0,0,9,-2,12,0> }
	object { _4_dash_4disc_dot_dat matrix <0,9,0,1,0,0,0,0,9,2,12,0> }
	object { _4_dash_4cyli_dot_dat matrix <0,3,0,19.84,0,0,0,0,3,-9.92,12,0> }
	object { _4_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,-9.92,12,0> }
	object { _4_dash_4disc_dot_dat matrix <0,3,0,1,0,0,0,0,3,9.92,12,0> }
}
#end

#declare _970_dot_dat = #if (QUAL = 0) box { <-18,-11,-10>, <18,21,10> } #else union {
	mesh {
		triangle { <-18,0,-10>, <-18,6,-10>, <18,6,-10> }
		triangle { <18,6,-10>, <18,0,-10>, <-18,0,-10> }
	}
	object { s_slash_970s01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
}
#end

#declare _2_dash_4cyli_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open clipped_by { box { <-2,-1,0>,<2,2,2> } } }

#declare s_slash_973s01_dot_dat = #if (QUAL = 0) box { <-19,-12,-10>, <19,32,10> } #else union {
	mesh {
		triangle { <-19,32,-10>, <19,32,-10>, <16,32,-6> }
		triangle { <16,32,-6>, <-16,32,-6>, <-19,32,-10> }
		triangle { <19,32,-10>, <19,32,10>, <16,32,6> }
		triangle { <16,32,6>, <16,32,-6>, <19,32,-10> }
		triangle { <19,32,10>, <-19,32,10>, <-16,32,6> }
		triangle { <-16,32,6>, <16,32,6>, <19,32,10> }
		triangle { <-19,32,10>, <-19,32,-10>, <-16,32,-6> }
		triangle { <-16,32,-6>, <-16,32,6>, <-19,32,10> }
		triangle { <-6.536,32,-6>, <-4,32,-3.464>, <-4,32,-6> }
		triangle { <6.536,32,-6>, <4,32,-3.464>, <4,32,-6> }
		triangle { <-6.536,32,6>, <-4,32,3.464>, <-4,32,6> }
		triangle { <6.536,32,6>, <4,32,3.464>, <4,32,6> }
		triangle { <-6.536,32,-6>, <-6.536,3,-6>, <-4,3,-3.464> }
		triangle { <-4,3,-3.464>, <-4,32,-3.464>, <-6.536,32,-6> }
		triangle { <-4,32,-3.464>, <-4,3,-3.464>, <-4,3,-6> }
		triangle { <-4,3,-6>, <-4,32,-6>, <-4,32,-3.464> }
		triangle { <6.536,32,-6>, <6.536,3,-6>, <4,3,-3.464> }
		triangle { <4,3,-3.464>, <4,32,-3.464>, <6.536,32,-6> }
		triangle { <4,32,-3.464>, <4,3,-3.464>, <4,3,-6> }
		triangle { <4,3,-6>, <4,32,-6>, <4,32,-3.464> }
		triangle { <-6.536,32,6>, <-6.536,3,6>, <-4,3,3.464> }
		triangle { <-4,3,3.464>, <-4,32,3.464>, <-6.536,32,6> }
		triangle { <-4,32,3.464>, <-4,3,3.464>, <-4,3,6> }
		triangle { <-4,3,6>, <-4,32,6>, <-4,32,3.464> }
		triangle { <6.536,32,6>, <6.536,3,6>, <4,3,3.464> }
		triangle { <4,3,3.464>, <4,32,3.464>, <6.536,32,6> }
		triangle { <4,32,3.464>, <4,3,3.464>, <4,3,6> }
		triangle { <4,3,6>, <4,32,6>, <4,32,3.464> }
		triangle { <-16,32,-6>, <-16,32,6>, <-16,23.37,6> }
		triangle { <-16,23.37,6>, <-16,23.37,-6>, <-16,32,-6> }
		triangle { <16,32,-6>, <16,32,6>, <16,23.37,6> }
		triangle { <16,23.37,6>, <16,23.37,-6>, <16,32,-6> }
		triangle { <-16,32,-6>, <16,32,-6>, <16,23.37,-6> }
		triangle { <16,23.37,-6>, <-16,23.37,-6>, <-16,32,-6> }
		triangle { <16,32,6>, <-16,32,6>, <-16,23.37,6> }
		triangle { <-16,23.37,6>, <16,23.37,6>, <16,32,6> }
		triangle { <-16,23.37,-6>, <-16,23.37,6>, <-14.408,14.146,6> }
		triangle { <-14.408,14.146,6>, <-14.408,14.146,-6>, <-16,23.37,-6> }
		triangle { <-12.708,4.296,-6>, <-12.708,4.296,6>, <-12.484,3,6> }
		triangle { <-12.484,3,6>, <-12.484,3,-6>, <-12.708,4.296,-6> }
		triangle { <16,23.37,-6>, <16,23.37,6>, <14.408,14.146,6> }
		triangle { <14.408,14.146,6>, <14.408,14.146,-6>, <16,23.37,-6> }
		triangle { <12.708,4.296,-6>, <12.708,4.296,6>, <12.484,3,6> }
		triangle { <12.484,3,6>, <12.484,3,-6>, <12.708,4.296,-6> }
		triangle { <-16,23.37,-6>, <16,23.37,-6>, <12.484,3,-6> }
		triangle { <12.484,3,-6>, <-12.484,3,-6>, <-16,23.37,-6> }
		triangle { <16,23.37,6>, <-16,23.37,6>, <-12.484,3,6> }
		triangle { <-12.484,3,6>, <12.484,3,6>, <16,23.37,6> }
		triangle { <-12.484,3,-6>, <12.484,3,-6>, <12.484,3,6> }
		triangle { <12.484,3,6>, <-12.484,3,6>, <-12.484,3,-6> }
		triangle { <19,32,-10>, <19,32,10>, <19,29,10> }
		triangle { <19,29,10>, <19,29,-10>, <19,32,-10> }
		triangle { <-19,32,10>, <-19,32,-10>, <-19,29,-10> }
		triangle { <-19,29,-10>, <-19,29,10>, <-19,32,10> }
		triangle { <-19,29,-10>, <-19,29,10>, <-16.378,13.806,10> }
		triangle { <-16.378,13.806,10>, <-16.378,13.806,-10>, <-19,29,-10> }
		triangle { <-14.678,3.956,-10>, <-14.678,3.956,10>, <-14.345,2,10> }
		triangle { <-14.345,2,10>, <-14.345,2,-10>, <-14.678,3.956,-10> }
		triangle { <-14.345,2,-10>, <-14.345,2,10>, <-14,0,8> }
		triangle { <-14,0,8>, <-14,0,-8>, <-14.345,2,-10> }
		triangle { <19,29,-10>, <19,29,10>, <16.378,13.806,10> }
		triangle { <16.378,13.806,10>, <16.378,13.806,-10>, <19,29,-10> }
		triangle { <14.678,3.956,-10>, <14.678,3.956,10>, <14.345,2,10> }
		triangle { <14.345,2,10>, <14.345,2,-10>, <14.678,3.956,-10> }
		triangle { <14.345,2,-10>, <14.345,2,10>, <14,0,8> }
		triangle { <14,0,8>, <14,0,-8>, <14.345,2,-10> }
		triangle { <-14,0,-8>, <-12,0,-10>, <-12,0,10> }
		triangle { <-12,0,10>, <-14,0,8>, <-14,0,-8> }
		triangle { <-12,0,-10>, <-12,0,10>, <12,0,10> }
		triangle { <12,0,10>, <12,0,-10>, <-12,0,-10> }
		triangle { <12,0,-10>, <12,0,10>, <14,0,8> }
		triangle { <14,0,8>, <14,0,-8>, <12,0,-10> }
		triangle { <-14.345,2,-10>, <-14,0,-8>, <-12,0,-10> }
		triangle { <14.345,2,-10>, <14,0,-8>, <12,0,-10> }
		triangle { <14.345,2,10>, <14,0,8>, <12,0,10> }
		triangle { <-14.345,2,10>, <-14,0,8>, <-12,0,10> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,-4,0,0,0,6,0,0,0> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,-8,0,0,0,-6,0,-4,0> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,-8,0,0,0,6,0,-4,0> }
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,-12,0> }
	object { _4_dash_4cyli_dot_dat matrix <0.85,4.925,0,1.97,-0.34,0,0,0,5,13.558,9.221,0> }
	mesh {
		triangle { <16.378,13.806,0>, <16.31,13.412,1.9>, <16.31,13.412,10> }
		triangle { <16.31,13.412,10>, <16.378,13.806,10>, <16.378,13.806,0> }
		triangle { <16.31,13.412,1.9>, <16.123,12.329,3.5>, <16.123,12.329,10> }
		triangle { <16.123,12.329,10>, <16.31,13.412,10>, <16.31,13.412,1.9> }
		triangle { <16.123,12.329,3.5>, <15.851,10.753,4.6>, <15.851,10.753,10> }
		triangle { <15.851,10.753,10>, <16.123,12.329,10>, <16.123,12.329,3.5> }
		triangle { <15.851,10.753,4.6>, <15.528,8.881,5>, <15.528,8.881,10> }
		triangle { <15.528,8.881,10>, <15.851,10.753,10>, <15.851,10.753,4.6> }
		triangle { <15.528,8.881,5>, <15.205,7.01,4.6>, <15.205,7.01,10> }
		triangle { <15.205,7.01,10>, <15.528,8.881,10>, <15.528,8.881,5> }
		triangle { <15.205,7.01,4.6>, <14.933,5.434,3.5>, <14.933,5.434,10> }
		triangle { <14.933,5.434,10>, <15.205,7.01,10>, <15.205,7.01,4.6> }
		triangle { <14.933,5.434,3.5>, <14.746,4.35,1.9>, <14.746,4.35,10> }
		triangle { <14.746,4.35,10>, <14.933,5.434,10>, <14.933,5.434,3.5> }
		triangle { <14.746,4.35,1.9>, <14.678,3.956,0>, <14.678,3.956,10> }
		triangle { <14.678,3.956,10>, <14.746,4.35,10>, <14.746,4.35,1.9> }
		triangle { <14.678,3.956,0>, <14.746,4.35,-1.9>, <14.746,4.35,-10> }
		triangle { <14.746,4.35,-10>, <14.678,3.956,-10>, <14.678,3.956,0> }
		triangle { <14.746,4.35,-1.9>, <14.933,5.434,-3.5>, <14.933,5.434,-10> }
		triangle { <14.933,5.434,-10>, <14.746,4.35,-10>, <14.746,4.35,-1.9> }
		triangle { <14.933,5.434,-3.5>, <15.205,7.01,-4.6>, <15.205,7.01,-10> }
		triangle { <15.205,7.01,-10>, <14.933,5.434,-10>, <14.933,5.434,-3.5> }
		triangle { <15.205,7.01,-4.6>, <15.528,8.881,-5>, <15.528,8.881,-10> }
		triangle { <15.528,8.881,-10>, <15.205,7.01,-10>, <15.205,7.01,-4.6> }
		triangle { <15.528,8.881,-5>, <15.851,10.753,-4.6>, <15.851,10.753,-10> }
		triangle { <15.851,10.753,-10>, <15.528,8.881,-10>, <15.528,8.881,-5> }
		triangle { <15.851,10.753,-4.6>, <16.123,12.329,-3.5>, <16.123,12.329,-10> }
		triangle { <16.123,12.329,-10>, <15.851,10.753,-10>, <15.851,10.753,-4.6> }
		triangle { <16.123,12.329,-3.5>, <16.31,13.412,-1.9>, <16.31,13.412,-10> }
		triangle { <16.31,13.412,-10>, <16.123,12.329,-10>, <16.123,12.329,-3.5> }
		triangle { <16.31,13.412,-1.9>, <16.378,13.806,0>, <16.378,13.806,-10> }
		triangle { <16.378,13.806,-10>, <16.31,13.412,-10>, <16.31,13.412,-1.9> }
		triangle { <14.408,14.146,0>, <14.34,13.752,1.9>, <14.34,13.752,6> }
		triangle { <14.34,13.752,6>, <14.408,14.146,6>, <14.408,14.146,0> }
		triangle { <14.34,13.752,1.9>, <14.153,12.669,3.5>, <14.153,12.669,6> }
		triangle { <14.153,12.669,6>, <14.34,13.752,6>, <14.34,13.752,1.9> }
		triangle { <14.153,12.669,3.5>, <13.881,11.093,4.6>, <13.881,11.093,6> }
		triangle { <13.881,11.093,6>, <14.153,12.669,6>, <14.153,12.669,3.5> }
		triangle { <13.881,11.093,4.6>, <13.558,9.221,5>, <13.558,9.221,6> }
		triangle { <13.558,9.221,6>, <13.881,11.093,6>, <13.881,11.093,4.6> }
		triangle { <13.558,9.221,5>, <13.235,7.35,4.6>, <13.235,7.35,6> }
		triangle { <13.235,7.35,6>, <13.558,9.221,6>, <13.558,9.221,5> }
		triangle { <13.235,7.35,4.6>, <12.963,5.774,3.5>, <12.963,5.774,6> }
		triangle { <12.963,5.774,6>, <13.235,7.35,6>, <13.235,7.35,4.6> }
		triangle { <12.963,5.774,3.5>, <12.776,4.69,1.9>, <12.776,4.69,6> }
		triangle { <12.776,4.69,6>, <12.963,5.774,6>, <12.963,5.774,3.5> }
		triangle { <12.776,4.69,1.9>, <12.708,4.296,0>, <12.708,4.296,6> }
		triangle { <12.708,4.296,6>, <12.776,4.69,6>, <12.776,4.69,1.9> }
		triangle { <12.708,4.296,0>, <12.776,4.69,-1.9>, <12.776,4.69,-6> }
		triangle { <12.776,4.69,-6>, <12.708,4.296,-6>, <12.708,4.296,0> }
		triangle { <12.776,4.69,-1.9>, <12.963,5.774,-3.5>, <12.963,5.774,-6> }
		triangle { <12.963,5.774,-6>, <12.776,4.69,-6>, <12.776,4.69,-1.9> }
		triangle { <12.963,5.774,-3.5>, <13.235,7.35,-4.6>, <13.235,7.35,-6> }
		triangle { <13.235,7.35,-6>, <12.963,5.774,-6>, <12.963,5.774,-3.5> }
		triangle { <13.235,7.35,-4.6>, <13.558,9.221,-5>, <13.558,9.221,-6> }
		triangle { <13.558,9.221,-6>, <13.235,7.35,-6>, <13.235,7.35,-4.6> }
		triangle { <13.558,9.221,-5>, <13.881,11.093,-4.6>, <13.881,11.093,-6> }
		triangle { <13.881,11.093,-6>, <13.558,9.221,-6>, <13.558,9.221,-5> }
		triangle { <13.881,11.093,-4.6>, <14.153,12.669,-3.5>, <14.153,12.669,-6> }
		triangle { <14.153,12.669,-6>, <13.881,11.093,-6>, <13.881,11.093,-4.6> }
		triangle { <14.153,12.669,-3.5>, <14.34,13.752,-1.9>, <14.34,13.752,-6> }
		triangle { <14.34,13.752,-6>, <14.153,12.669,-6>, <14.153,12.669,-3.5> }
		triangle { <14.34,13.752,-1.9>, <14.408,14.146,0>, <14.408,14.146,-6> }
		triangle { <14.408,14.146,-6>, <14.34,13.752,-6>, <14.34,13.752,-1.9> }
	}
	object { _4_dash_4cyli_dot_dat matrix <-0.85,4.925,0,-1.97,-0.34,0,0,0,5,-13.558,9.221,0> }
	mesh {
		triangle { <-16.378,13.806,0>, <-16.31,13.412,1.9>, <-16.31,13.412,10> }
		triangle { <-16.31,13.412,10>, <-16.378,13.806,10>, <-16.378,13.806,0> }
		triangle { <-16.31,13.412,1.9>, <-16.123,12.329,3.5>, <-16.123,12.329,10> }
		triangle { <-16.123,12.329,10>, <-16.31,13.412,10>, <-16.31,13.412,1.9> }
		triangle { <-16.123,12.329,3.5>, <-15.851,10.753,4.6>, <-15.851,10.753,10> }
		triangle { <-15.851,10.753,10>, <-16.123,12.329,10>, <-16.123,12.329,3.5> }
		triangle { <-15.851,10.753,4.6>, <-15.528,8.881,5>, <-15.528,8.881,10> }
		triangle { <-15.528,8.881,10>, <-15.851,10.753,10>, <-15.851,10.753,4.6> }
		triangle { <-15.528,8.881,5>, <-15.205,7.01,4.6>, <-15.205,7.01,10> }
		triangle { <-15.205,7.01,10>, <-15.528,8.881,10>, <-15.528,8.881,5> }
		triangle { <-15.205,7.01,4.6>, <-14.933,5.434,3.5>, <-14.933,5.434,10> }
		triangle { <-14.933,5.434,10>, <-15.205,7.01,10>, <-15.205,7.01,4.6> }
		triangle { <-14.933,5.434,3.5>, <-14.746,4.35,1.9>, <-14.746,4.35,10> }
		triangle { <-14.746,4.35,10>, <-14.933,5.434,10>, <-14.933,5.434,3.5> }
		triangle { <-14.746,4.35,1.9>, <-14.678,3.956,0>, <-14.678,3.956,10> }
		triangle { <-14.678,3.956,10>, <-14.746,4.35,10>, <-14.746,4.35,1.9> }
		triangle { <-14.678,3.956,0>, <-14.746,4.35,-1.9>, <-14.746,4.35,-10> }
		triangle { <-14.746,4.35,-10>, <-14.678,3.956,-10>, <-14.678,3.956,0> }
		triangle { <-14.746,4.35,-1.9>, <-14.933,5.434,-3.5>, <-14.933,5.434,-10> }
		triangle { <-14.933,5.434,-10>, <-14.746,4.35,-10>, <-14.746,4.35,-1.9> }
		triangle { <-14.933,5.434,-3.5>, <-15.205,7.01,-4.6>, <-15.205,7.01,-10> }
		triangle { <-15.205,7.01,-10>, <-14.933,5.434,-10>, <-14.933,5.434,-3.5> }
		triangle { <-15.205,7.01,-4.6>, <-15.528,8.881,-5>, <-15.528,8.881,-10> }
		triangle { <-15.528,8.881,-10>, <-15.205,7.01,-10>, <-15.205,7.01,-4.6> }
		triangle { <-15.528,8.881,-5>, <-15.851,10.753,-4.6>, <-15.851,10.753,-10> }
		triangle { <-15.851,10.753,-10>, <-15.528,8.881,-10>, <-15.528,8.881,-5> }
		triangle { <-15.851,10.753,-4.6>, <-16.123,12.329,-3.5>, <-16.123,12.329,-10> }
		triangle { <-16.123,12.329,-10>, <-15.851,10.753,-10>, <-15.851,10.753,-4.6> }
		triangle { <-16.123,12.329,-3.5>, <-16.31,13.412,-1.9>, <-16.31,13.412,-10> }
		triangle { <-16.31,13.412,-10>, <-16.123,12.329,-10>, <-16.123,12.329,-3.5> }
		triangle { <-16.31,13.412,-1.9>, <-16.378,13.806,0>, <-16.378,13.806,-10> }
		triangle { <-16.378,13.806,-10>, <-16.31,13.412,-10>, <-16.31,13.412,-1.9> }
		triangle { <-14.408,14.146,0>, <-14.34,13.752,1.9>, <-14.34,13.752,6> }
		triangle { <-14.34,13.752,6>, <-14.408,14.146,6>, <-14.408,14.146,0> }
		triangle { <-14.34,13.752,1.9>, <-14.153,12.669,3.5>, <-14.153,12.669,6> }
		triangle { <-14.153,12.669,6>, <-14.34,13.752,6>, <-14.34,13.752,1.9> }
		triangle { <-14.153,12.669,3.5>, <-13.881,11.093,4.6>, <-13.881,11.093,6> }
		triangle { <-13.881,11.093,6>, <-14.153,12.669,6>, <-14.153,12.669,3.5> }
		triangle { <-13.881,11.093,4.6>, <-13.558,9.221,5>, <-13.558,9.221,6> }
		triangle { <-13.558,9.221,6>, <-13.881,11.093,6>, <-13.881,11.093,4.6> }
		triangle { <-13.558,9.221,5>, <-13.235,7.35,4.6>, <-13.235,7.35,6> }
		triangle { <-13.235,7.35,6>, <-13.558,9.221,6>, <-13.558,9.221,5> }
		triangle { <-13.235,7.35,4.6>, <-12.963,5.774,3.5>, <-12.963,5.774,6> }
		triangle { <-12.963,5.774,6>, <-13.235,7.35,6>, <-13.235,7.35,4.6> }
		triangle { <-12.963,5.774,3.5>, <-12.776,4.69,1.9>, <-12.776,4.69,6> }
		triangle { <-12.776,4.69,6>, <-12.963,5.774,6>, <-12.963,5.774,3.5> }
		triangle { <-12.776,4.69,1.9>, <-12.708,4.296,0>, <-12.708,4.296,6> }
		triangle { <-12.708,4.296,6>, <-12.776,4.69,6>, <-12.776,4.69,1.9> }
		triangle { <-12.708,4.296,0>, <-12.776,4.69,-1.9>, <-12.776,4.69,-6> }
		triangle { <-12.776,4.69,-6>, <-12.708,4.296,-6>, <-12.708,4.296,0> }
		triangle { <-12.776,4.69,-1.9>, <-12.963,5.774,-3.5>, <-12.963,5.774,-6> }
		triangle { <-12.963,5.774,-6>, <-12.776,4.69,-6>, <-12.776,4.69,-1.9> }
		triangle { <-12.963,5.774,-3.5>, <-13.235,7.35,-4.6>, <-13.235,7.35,-6> }
		triangle { <-13.235,7.35,-6>, <-12.963,5.774,-6>, <-12.963,5.774,-3.5> }
		triangle { <-13.235,7.35,-4.6>, <-13.558,9.221,-5>, <-13.558,9.221,-6> }
		triangle { <-13.558,9.221,-6>, <-13.235,7.35,-6>, <-13.235,7.35,-4.6> }
		triangle { <-13.558,9.221,-5>, <-13.881,11.093,-4.6>, <-13.881,11.093,-6> }
		triangle { <-13.881,11.093,-6>, <-13.558,9.221,-6>, <-13.558,9.221,-5> }
		triangle { <-13.881,11.093,-4.6>, <-14.153,12.669,-3.5>, <-14.153,12.669,-6> }
		triangle { <-14.153,12.669,-6>, <-13.881,11.093,-6>, <-13.881,11.093,-4.6> }
		triangle { <-14.153,12.669,-3.5>, <-14.34,13.752,-1.9>, <-14.34,13.752,-6> }
		triangle { <-14.34,13.752,-6>, <-14.153,12.669,-6>, <-14.153,12.669,-3.5> }
		triangle { <-14.34,13.752,-1.9>, <-14.408,14.146,0>, <-14.408,14.146,-6> }
		triangle { <-14.408,14.146,-6>, <-14.34,13.752,-6>, <-14.34,13.752,-1.9> }
	}
}
#end

#declare _973p52_dot_dat = #if (QUAL = 0) box { <-19,-12,-10>, <19,32,10> } #else union {
	object { s_slash_973s01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
// Plain back
	mesh {
		triangle { <-19,32,10>, <19,32,10>, <19,29,10> }
		triangle { <19,29,10>, <-19,29,10>, <-19,32,10> }
		triangle { <19,29,10>, <-19,29,10>, <-14.345,2,10> }
		triangle { <-14.345,2,10>, <14.345,2,10>, <19,29,10> }
		triangle { <12,0,10>, <-12,0,10>, <-14.345,2,10> }
		triangle { <-14.345,2,10>, <14.345,2,10>, <12,0,10> }
// Decoration
	}
	mesh {
		triangle { <8.5,2,-10>, <12.5,2,-10>, <12.339,3,-10> }
		triangle { <12.339,3,-10>, <8.339,3,-10>, <8.5,2,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <8.339,3,-10>, <12.339,3,-10>, <12.259,3.5,-10> }
		triangle { <12.259,3.5,-10>, <8.259,3.5,-10>, <8.339,3,-10> }
	}
	mesh {
		triangle { <8.259,3.5,-10>, <12.259,3.5,-10>, <12.098,4.5,-10> }
		triangle { <12.098,4.5,-10>, <8.098,4.5,-10>, <8.259,3.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <8.098,4.5,-10>, <12.098,4.5,-10>, <12.018,5,-10> }
		triangle { <12.018,5,-10>, <8.018,5,-10>, <8.098,4.5,-10> }
	}
	mesh {
		triangle { <8.018,5,-10>, <12.018,5,-10>, <11.857,6,-10> }
		triangle { <11.857,6,-10>, <7.857,6,-10>, <8.018,5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <7.857,6,-10>, <11.857,6,-10>, <11.777,6.5,-10> }
		triangle { <11.777,6.5,-10>, <7.777,6.5,-10>, <7.857,6,-10> }
	}
	mesh {
		triangle { <7.777,6.5,-10>, <11.777,6.5,-10>, <11.616,7.5,-10> }
		triangle { <11.616,7.5,-10>, <7.616,7.5,-10>, <7.777,6.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <7.616,7.5,-10>, <11.616,7.5,-10>, <11.536,8,-10> }
		triangle { <11.536,8,-10>, <7.536,8,-10>, <7.616,7.5,-10> }
	}
	mesh {
		triangle { <7.536,8,-10>, <11.536,8,-10>, <11.375,9,-10> }
		triangle { <11.375,9,-10>, <7.375,9,-10>, <7.536,8,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <7.375,9,-10>, <11.375,9,-10>, <11.295,9.5,-10> }
		triangle { <11.295,9.5,-10>, <7.295,9.5,-10>, <7.375,9,-10> }
	}
	mesh {
		triangle { <7.295,9.5,-10>, <11.295,9.5,-10>, <11.134,10.5,-10> }
		triangle { <11.134,10.5,-10>, <7.134,10.5,-10>, <7.295,9.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <7.134,10.5,-10>, <11.134,10.5,-10>, <11.054,11,-10> }
		triangle { <11.054,11,-10>, <7.054,11,-10>, <7.134,10.5,-10> }
	}
	mesh {
		triangle { <7.054,11,-10>, <11.054,11,-10>, <10.893,12,-10> }
		triangle { <10.893,12,-10>, <6.893,12,-10>, <7.054,11,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <6.893,12,-10>, <10.893,12,-10>, <10.813,12.5,-10> }
		triangle { <10.813,12.5,-10>, <6.813,12.5,-10>, <6.893,12,-10> }
	}
	mesh {
		triangle { <10.813,12.5,-10>, <6.813,12.5,-10>, <6.733,13,-10> }
		triangle { <6.733,13,-10>, <10.733,13,-10>, <10.813,12.5,-10> }
		triangle { <6.733,13,-10>, <7.233,13,-10>, <7.233,13.5,-10> }
		triangle { <7.233,13.5,-10>, <6.652,13.5,-10>, <6.733,13,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <7.233,13,-10>, <7.733,13,-10>, <7.733,13.5,-10> }
		triangle { <7.733,13.5,-10>, <7.233,13.5,-10>, <7.233,13,-10> }
	}
	mesh {
		triangle { <7.733,13,-10>, <9.733,13,-10>, <9.733,13.5,-10> }
		triangle { <9.733,13.5,-10>, <7.733,13.5,-10>, <7.733,13,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <9.733,13,-10>, <10.233,13,-10>, <10.233,13.5,-10> }
		triangle { <10.233,13.5,-10>, <9.733,13.5,-10>, <9.733,13,-10> }
	}
	mesh {
		triangle { <10.233,13,-10>, <10.733,13,-10>, <10.652,13.5,-10> }
		triangle { <10.652,13.5,-10>, <10.233,13.5,-10>, <10.233,13,-10> }
		triangle { <10.652,13.5,-10>, <6.652,13.5,-10>, <6.009,17.5,-10> }
		triangle { <6.009,17.5,-10>, <10.009,17.5,-10>, <10.652,13.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <12.5,2,-10>, <14.345,2,-10>, <16.586,15,-10> }
		triangle { <16.586,15,-10>, <10.411,15,-10>, <12.5,2,-10> }
		triangle { <3.5,2,-10>, <8.5,2,-10>, <8.018,5,-10> }
		triangle { <8.018,5,-10>, <3.018,5,-10>, <3.5,2,-10> }
		triangle { <2.5,5,-10>, <8.018,5,-10>, <6.25,16,-10> }
		triangle { <6.25,16,-10>, <2.5,16,-10>, <2.5,5,-10> }
		triangle { <9.288,22,-10>, <9.5,22,-10>, <9.5,26.5,-10> }
		triangle { <9.5,26.5,-10>, <8.563,26.5,-10>, <9.288,22,-10> }
	}
	mesh {
		triangle { <9.5,22,-10>, <10.5,22,-10>, <10.5,26.5,-10> }
		triangle { <10.5,26.5,-10>, <9.5,26.5,-10>, <9.5,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <10.5,22,-10>, <11,22,-10>, <11,26.5,-10> }
		triangle { <11,26.5,-10>, <10.5,26.5,-10>, <10.5,22,-10> }
	}
	mesh {
		triangle { <11,22,-10>, <12,22,-10>, <12,26.5,-10> }
		triangle { <12,26.5,-10>, <11,26.5,-10>, <11,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <12,22,-10>, <12.5,22,-10>, <12.5,26.5,-10> }
		triangle { <12.5,26.5,-10>, <12,26.5,-10>, <12,22,-10> }
	}
	mesh {
		triangle { <12.5,22,-10>, <13.5,22,-10>, <13.5,26.5,-10> }
		triangle { <13.5,26.5,-10>, <12.5,26.5,-10>, <12.5,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <13.5,22,-10>, <14,22,-10>, <14,26.5,-10> }
		triangle { <14,26.5,-10>, <13.5,26.5,-10>, <13.5,22,-10> }
	}
	mesh {
		triangle { <14,22,-10>, <15,22,-10>, <15,26.5,-10> }
		triangle { <15,26.5,-10>, <14,26.5,-10>, <14,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <15,22,-10>, <15.5,22,-10>, <15.5,26.5,-10> }
		triangle { <15.5,26.5,-10>, <15,26.5,-10>, <15,22,-10> }
	}
	mesh {
		triangle { <15.5,22,-10>, <16.5,22,-10>, <16.5,26.5,-10> }
		triangle { <16.5,26.5,-10>, <15.5,26.5,-10>, <15.5,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <16.5,22,-10>, <17.793,22,-10>, <18.569,26.5,-10> }
		triangle { <18.569,26.5,-10>, <16.5,26.5,-10>, <16.5,22,-10> }
		triangle { <8.563,26.5,-10>, <18.569,26.5,-10>, <19,29,-10> }
		triangle { <19,29,-10>, <8.161,29,-10>, <8.563,26.5,-10> }
		triangle { <8.161,29,-10>, <19,29,-10>, <19,30,-10> }
		triangle { <19,30,-10>, <8,30,-10>, <8.161,29,-10> }
		triangle { <2,27,-10>, <4,27,-10>, <4,30,-10> }
		triangle { <4,30,-10>, <2,30,-10>, <2,27,-10> }
		triangle { <9.973,18.5,-10>, <17.19,18.5,-10>, <17.793,22,-10> }
		triangle { <17.793,22,-10>, <9.288,22,-10>, <9.973,18.5,-10> }
		triangle { <10.411,15,-10>, <11,15,-10>, <10.438,18.5,-10> }
		triangle { <10.438,18.5,-10>, <9.973,18.5,-10>, <10.411,15,-10> }
	}
	mesh {
		triangle { <15,15,-10>, <11,15,-10>, <10.438,18.5,-10> }
		triangle { <10.438,18.5,-10>, <14.438,18.5,-10>, <15,15,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <15,15,-10>, <16.585,15,-10>, <17.19,18.5,-10> }
		triangle { <17.19,18.5,-10>, <14.438,18.5,-10>, <15,15,-10> }
	}
	mesh {
		triangle { <6.25,16,-10>, <2,16,-10>, <2,17.5,-10> }
		triangle { <2,17.5,-10>, <6.009,17.5,-10>, <6.25,16,-10> }
		triangle { <10.009,17.5,-10>, <9.509,17.5,-10>, <9.107,20,-10> }
		triangle { <9.107,20,-10>, <9.607,20,-10>, <10.009,17.5,-10> }
		triangle { <2.5,17.5,-10>, <2,17.5,-10>, <2,20,-10> }
		triangle { <2,20,-10>, <2.5,20,-10>, <2.5,17.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <2.5,17.5,-10>, <9.509,17.5,-10>, <8.929,18,-10> }
		triangle { <8.929,18,-10>, <3,18,-10>, <2.5,17.5,-10> }
		triangle { <2.5,17.5,-10>, <3,18,-10>, <3,19.5,-10> }
		triangle { <3,19.5,-10>, <2.5,20,-10>, <2.5,17.5,-10> }
		triangle { <8.688,19.5,-10>, <8.929,18,-10>, <9.509,17.5,-10> }
		triangle { <9.509,17.5,-10>, <9.107,20,-10>, <8.688,19.5,-10> }
	}
	mesh {
		triangle { <8.929,18,-10>, <3,18,-10>, <3,19.5,-10> }
		triangle { <3,19.5,-10>, <8.688,19.5,-10>, <8.929,18,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <3,19.5,-10>, <8.688,19.5,-10>, <9.107,20,-10> }
		triangle { <9.107,20,-10>, <2.5,20,-10>, <3,19.5,-10> }
	}
	mesh {
		triangle { <9.607,20,-10>, <2,20,-10>, <2,20.5,-10> }
		triangle { <2,20.5,-10>, <9.527,20.5,-10>, <9.607,20,-10> }
		triangle { <8.482,27,-10>, <7,27,-10>, <7,30,-10> }
		triangle { <7,30,-10>, <8,30,-10>, <8.482,27,-10> }
		triangle { <7,27,-10>, <5,27,-10>, <5,27.5,-10> }
		triangle { <5,27.5,-10>, <7,27.5,-10>, <7,27,-10> }
		triangle { <5,27,-10>, <4,27,-10>, <4,30,-10> }
		triangle { <4,30,-10>, <5,30,-10>, <5,27,-10> }
		triangle { <7,29.5,-10>, <5,29.5,-10>, <5,30,-10> }
		triangle { <5,30,-10>, <7,30,-10>, <7,29.5,-10> }
		triangle { <5,27.5,-10>, <6,27.5,-10>, <5,28.5,-10> }
		triangle { <6,27.5,-10>, <7,27.5,-10>, <7,28.5,-10> }
		triangle { <5,28.5,-10>, <6,29.5,-10>, <5,29.5,-10> }
		triangle { <7,28.5,-10>, <7,29.5,-10>, <6,29.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <6,28,-10>, <6,27.5,-10>, <7,28.5,-10> }
		triangle { <7,28.5,-10>, <6.5,28.5,-10>, <6,28,-10> }
		triangle { <6.5,28.5,-10>, <7,28.5,-10>, <6,29.5,-10> }
		triangle { <6,29.5,-10>, <6,29,-10>, <6.5,28.5,-10> }
		triangle { <6,29,-10>, <6,29.5,-10>, <5,28.5,-10> }
		triangle { <5,28.5,-10>, <5.5,28.5,-10>, <6,29,-10> }
		triangle { <5.5,28.5,-10>, <5,28.5,-10>, <6,27.5,-10> }
		triangle { <6,27.5,-10>, <6,28,-10>, <5.5,28.5,-10> }
	}
	mesh {
		triangle { <6,28,-10>, <6.5,28.5,-10>, <6,29,-10> }
		triangle { <6,29,-10>, <5.5,28.5,-10>, <6,28,-10> }
		triangle { <2,27,-10>, <1,27,-10>, <1,30,-10> }
		triangle { <1,30,-10>, <2,30,-10>, <2,27,-10> }
		triangle { <-12.5,2,-10>, <-8.5,2,-10>, <-8.339,3,-10> }
		triangle { <-8.339,3,-10>, <-12.339,3,-10>, <-12.5,2,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-12.339,3,-10>, <-8.339,3,-10>, <-8.259,3.5,-10> }
		triangle { <-8.259,3.5,-10>, <-12.259,3.5,-10>, <-12.339,3,-10> }
	}
	mesh {
		triangle { <-12.259,3.5,-10>, <-8.259,3.5,-10>, <-8.098,4.5,-10> }
		triangle { <-8.098,4.5,-10>, <-12.098,4.5,-10>, <-12.259,3.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-12.098,4.5,-10>, <-8.098,4.5,-10>, <-8.018,5,-10> }
		triangle { <-8.018,5,-10>, <-12.018,5,-10>, <-12.098,4.5,-10> }
	}
	mesh {
		triangle { <-12.018,5,-10>, <-8.018,5,-10>, <-7.857,6,-10> }
		triangle { <-7.857,6,-10>, <-11.857,6,-10>, <-12.018,5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-11.857,6,-10>, <-7.857,6,-10>, <-7.777,6.5,-10> }
		triangle { <-7.777,6.5,-10>, <-11.777,6.5,-10>, <-11.857,6,-10> }
	}
	mesh {
		triangle { <-11.777,6.5,-10>, <-7.777,6.5,-10>, <-7.616,7.5,-10> }
		triangle { <-7.616,7.5,-10>, <-11.616,7.5,-10>, <-11.777,6.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-11.616,7.5,-10>, <-7.616,7.5,-10>, <-7.536,8,-10> }
		triangle { <-7.536,8,-10>, <-11.536,8,-10>, <-11.616,7.5,-10> }
	}
	mesh {
		triangle { <-11.536,8,-10>, <-7.536,8,-10>, <-7.375,9,-10> }
		triangle { <-7.375,9,-10>, <-11.375,9,-10>, <-11.536,8,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-11.375,9,-10>, <-7.375,9,-10>, <-7.295,9.5,-10> }
		triangle { <-7.295,9.5,-10>, <-11.295,9.5,-10>, <-11.375,9,-10> }
	}
	mesh {
		triangle { <-11.295,9.5,-10>, <-7.295,9.5,-10>, <-7.134,10.5,-10> }
		triangle { <-7.134,10.5,-10>, <-11.134,10.5,-10>, <-11.295,9.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-11.134,10.5,-10>, <-7.134,10.5,-10>, <-7.054,11,-10> }
		triangle { <-7.054,11,-10>, <-11.054,11,-10>, <-11.134,10.5,-10> }
	}
	mesh {
		triangle { <-11.054,11,-10>, <-7.054,11,-10>, <-6.893,12,-10> }
		triangle { <-6.893,12,-10>, <-10.893,12,-10>, <-11.054,11,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-10.893,12,-10>, <-6.893,12,-10>, <-6.813,12.5,-10> }
		triangle { <-6.813,12.5,-10>, <-10.813,12.5,-10>, <-10.893,12,-10> }
	}
	mesh {
		triangle { <-6.813,12.5,-10>, <-10.813,12.5,-10>, <-10.733,13,-10> }
		triangle { <-10.733,13,-10>, <-6.733,13,-10>, <-6.813,12.5,-10> }
		triangle { <-7.233,13,-10>, <-6.733,13,-10>, <-6.652,13.5,-10> }
		triangle { <-6.652,13.5,-10>, <-7.233,13.5,-10>, <-7.233,13,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-7.733,13,-10>, <-7.233,13,-10>, <-7.233,13.5,-10> }
		triangle { <-7.233,13.5,-10>, <-7.733,13.5,-10>, <-7.733,13,-10> }
	}
	mesh {
		triangle { <-9.733,13,-10>, <-7.733,13,-10>, <-7.733,13.5,-10> }
		triangle { <-7.733,13.5,-10>, <-9.733,13.5,-10>, <-9.733,13,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-10.233,13,-10>, <-9.733,13,-10>, <-9.733,13.5,-10> }
		triangle { <-9.733,13.5,-10>, <-10.233,13.5,-10>, <-10.233,13,-10> }
	}
	mesh {
		triangle { <-10.733,13,-10>, <-10.233,13,-10>, <-10.233,13.5,-10> }
		triangle { <-10.233,13.5,-10>, <-10.652,13.5,-10>, <-10.733,13,-10> }
		triangle { <-6.652,13.5,-10>, <-10.652,13.5,-10>, <-10.009,17.5,-10> }
		triangle { <-10.009,17.5,-10>, <-6.009,17.5,-10>, <-6.652,13.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-14.345,2,-10>, <-12.5,2,-10>, <-10.411,15,-10> }
		triangle { <-10.411,15,-10>, <-16.586,15,-10>, <-14.345,2,-10> }
		triangle { <-8.5,2,-10>, <-3.5,2,-10>, <-3.018,5,-10> }
		triangle { <-3.018,5,-10>, <-8.018,5,-10>, <-8.5,2,-10> }
		triangle { <-8.018,5,-10>, <-2.5,5,-10>, <-2.5,16,-10> }
		triangle { <-2.5,16,-10>, <-6.25,16,-10>, <-8.018,5,-10> }
		triangle { <-9.5,22,-10>, <-9.288,22,-10>, <-8.563,26.5,-10> }
		triangle { <-8.563,26.5,-10>, <-9.5,26.5,-10>, <-9.5,22,-10> }
	}
	mesh {
		triangle { <-10.5,22,-10>, <-9.5,22,-10>, <-9.5,26.5,-10> }
		triangle { <-9.5,26.5,-10>, <-10.5,26.5,-10>, <-10.5,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-11,22,-10>, <-10.5,22,-10>, <-10.5,26.5,-10> }
		triangle { <-10.5,26.5,-10>, <-11,26.5,-10>, <-11,22,-10> }
	}
	mesh {
		triangle { <-12,22,-10>, <-11,22,-10>, <-11,26.5,-10> }
		triangle { <-11,26.5,-10>, <-12,26.5,-10>, <-12,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-12.5,22,-10>, <-12,22,-10>, <-12,26.5,-10> }
		triangle { <-12,26.5,-10>, <-12.5,26.5,-10>, <-12.5,22,-10> }
	}
	mesh {
		triangle { <-13.5,22,-10>, <-12.5,22,-10>, <-12.5,26.5,-10> }
		triangle { <-12.5,26.5,-10>, <-13.5,26.5,-10>, <-13.5,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-14,22,-10>, <-13.5,22,-10>, <-13.5,26.5,-10> }
		triangle { <-13.5,26.5,-10>, <-14,26.5,-10>, <-14,22,-10> }
	}
	mesh {
		triangle { <-15,22,-10>, <-14,22,-10>, <-14,26.5,-10> }
		triangle { <-14,26.5,-10>, <-15,26.5,-10>, <-15,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-15.5,22,-10>, <-15,22,-10>, <-15,26.5,-10> }
		triangle { <-15,26.5,-10>, <-15.5,26.5,-10>, <-15.5,22,-10> }
	}
	mesh {
		triangle { <-16.5,22,-10>, <-15.5,22,-10>, <-15.5,26.5,-10> }
		triangle { <-15.5,26.5,-10>, <-16.5,26.5,-10>, <-16.5,22,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-17.793,22,-10>, <-16.5,22,-10>, <-16.5,26.5,-10> }
		triangle { <-16.5,26.5,-10>, <-18.569,26.5,-10>, <-17.793,22,-10> }
		triangle { <-18.569,26.5,-10>, <-8.563,26.5,-10>, <-8.161,29,-10> }
		triangle { <-8.161,29,-10>, <-19,29,-10>, <-18.569,26.5,-10> }
		triangle { <-19,29,-10>, <-8.161,29,-10>, <-8,30,-10> }
		triangle { <-8,30,-10>, <-19,30,-10>, <-19,29,-10> }
		triangle { <-4,27,-10>, <-2,27,-10>, <-2,30,-10> }
		triangle { <-2,30,-10>, <-4,30,-10>, <-4,27,-10> }
		triangle { <-17.19,18.5,-10>, <-9.973,18.5,-10>, <-9.288,22,-10> }
		triangle { <-9.288,22,-10>, <-17.793,22,-10>, <-17.19,18.5,-10> }
		triangle { <-11,15,-10>, <-10.411,15,-10>, <-9.973,18.5,-10> }
		triangle { <-9.973,18.5,-10>, <-10.438,18.5,-10>, <-11,15,-10> }
	}
	mesh {
		triangle { <-11,15,-10>, <-15,15,-10>, <-14.438,18.5,-10> }
		triangle { <-14.438,18.5,-10>, <-10.438,18.5,-10>, <-11,15,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-16.585,15,-10>, <-15,15,-10>, <-14.438,18.5,-10> }
		triangle { <-14.438,18.5,-10>, <-17.19,18.5,-10>, <-16.585,15,-10> }
	}
	mesh {
		triangle { <-2,16,-10>, <-6.25,16,-10>, <-6.009,17.5,-10> }
		triangle { <-6.009,17.5,-10>, <-2,17.5,-10>, <-2,16,-10> }
		triangle { <-9.509,17.5,-10>, <-10.009,17.5,-10>, <-9.607,20,-10> }
		triangle { <-9.607,20,-10>, <-9.107,20,-10>, <-9.509,17.5,-10> }
		triangle { <-2,17.5,-10>, <-2.5,17.5,-10>, <-2.5,20,-10> }
		triangle { <-2.5,20,-10>, <-2,20,-10>, <-2,17.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-9.509,17.5,-10>, <-2.5,17.5,-10>, <-3,18,-10> }
		triangle { <-3,18,-10>, <-8.929,18,-10>, <-9.509,17.5,-10> }
		triangle { <-3,18,-10>, <-2.5,17.5,-10>, <-2.5,20,-10> }
		triangle { <-2.5,20,-10>, <-3,19.5,-10>, <-3,18,-10> }
		triangle { <-8.929,18,-10>, <-8.688,19.5,-10>, <-9.107,20,-10> }
		triangle { <-9.107,20,-10>, <-9.509,17.5,-10>, <-8.929,18,-10> }
	}
	mesh {
		triangle { <-3,18,-10>, <-8.929,18,-10>, <-8.688,19.5,-10> }
		triangle { <-8.688,19.5,-10>, <-3,19.5,-10>, <-3,18,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-8.688,19.5,-10>, <-3,19.5,-10>, <-2.5,20,-10> }
		triangle { <-2.5,20,-10>, <-9.107,20,-10>, <-8.688,19.5,-10> }
	}
	mesh {
		triangle { <-2,20,-10>, <-9.607,20,-10>, <-9.527,20.5,-10> }
		triangle { <-9.527,20.5,-10>, <-2,20.5,-10>, <-2,20,-10> }
		triangle { <-7,27,-10>, <-8.482,27,-10>, <-8,30,-10> }
		triangle { <-8,30,-10>, <-7,30,-10>, <-7,27,-10> }
		triangle { <-5,27,-10>, <-7,27,-10>, <-7,27.5,-10> }
		triangle { <-7,27.5,-10>, <-5,27.5,-10>, <-5,27,-10> }
		triangle { <-4,27,-10>, <-5,27,-10>, <-5,30,-10> }
		triangle { <-5,30,-10>, <-4,30,-10>, <-4,27,-10> }
		triangle { <-5,29.5,-10>, <-7,29.5,-10>, <-7,30,-10> }
		triangle { <-7,30,-10>, <-5,30,-10>, <-5,29.5,-10> }
		triangle { <-6,27.5,-10>, <-5,27.5,-10>, <-5,28.5,-10> }
		triangle { <-7,27.5,-10>, <-6,27.5,-10>, <-7,28.5,-10> }
		triangle { <-6,29.5,-10>, <-5,28.5,-10>, <-5,29.5,-10> }
		triangle { <-7,29.5,-10>, <-7,28.5,-10>, <-6,29.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-6,27.5,-10>, <-6,28,-10>, <-6.5,28.5,-10> }
		triangle { <-6.5,28.5,-10>, <-7,28.5,-10>, <-6,27.5,-10> }
		triangle { <-7,28.5,-10>, <-6.5,28.5,-10>, <-6,29,-10> }
		triangle { <-6,29,-10>, <-6,29.5,-10>, <-7,28.5,-10> }
		triangle { <-6,29.5,-10>, <-6,29,-10>, <-5.5,28.5,-10> }
		triangle { <-5.5,28.5,-10>, <-5,28.5,-10>, <-6,29.5,-10> }
		triangle { <-5,28.5,-10>, <-5.5,28.5,-10>, <-6,28,-10> }
		triangle { <-6,28,-10>, <-6,27.5,-10>, <-5,28.5,-10> }
	}
	mesh {
		triangle { <-6.5,28.5,-10>, <-6,28,-10>, <-5.5,28.5,-10> }
		triangle { <-5.5,28.5,-10>, <-6,29,-10>, <-6.5,28.5,-10> }
		triangle { <-1,27,-10>, <-2,27,-10>, <-2,30,-10> }
		triangle { <-2,30,-10>, <-1,30,-10>, <-1,27,-10> }
		triangle { <-2.5,6,-10>, <-2,6,-10>, <-2,15,-10> }
		triangle { <-2,15,-10>, <-2.5,15,-10>, <-2.5,6,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-2,6,-10>, <-1,6,-10>, <-1,15,-10> }
		triangle { <-1,15,-10>, <-2,15,-10>, <-2,6,-10> }
	}
	mesh {
		triangle { <-1,6,-10>, <-0.5,6,-10>, <-0.5,15,-10> }
		triangle { <-0.5,15,-10>, <-1,15,-10>, <-1,6,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-0.5,6,-10>, <0.5,6,-10>, <0.5,15,-10> }
		triangle { <0.5,15,-10>, <-0.5,15,-10>, <-0.5,6,-10> }
	}
	mesh {
		triangle { <0.5,6,-10>, <1,6,-10>, <1,15,-10> }
		triangle { <1,15,-10>, <0.5,15,-10>, <0.5,6,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <1,6,-10>, <2,6,-10>, <2,15,-10> }
		triangle { <2,15,-10>, <1,15,-10>, <1,6,-10> }
	}
	mesh {
		triangle { <2,6,-10>, <2.5,6,-10>, <2.5,15,-10> }
		triangle { <2.5,15,-10>, <2,15,-10>, <2,6,-10> }
		triangle { <-3.5,2,-10>, <3.5,2,-10>, <3.018,5,-10> }
		triangle { <3.018,5,-10>, <-3.018,5,-10>, <-3.5,2,-10> }
		triangle { <-2,16,-10>, <2,16,-10>, <2,16.5,-10> }
		triangle { <2,16.5,-10>, <-2,16.5,-10>, <-2,16,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-2,16.5,-10>, <2,16.5,-10>, <1.5,17,-10> }
		triangle { <1.5,17,-10>, <-1.5,17,-10>, <-2,16.5,-10> }
		triangle { <-2,16.5,-10>, <-1.5,17,-10>, <-1.5,20,-10> }
		triangle { <-1.5,20,-10>, <-2,20.5,-10>, <-2,16.5,-10> }
	}
	mesh {
		triangle { <-1.5,17,-10>, <1.5,17,-10>, <1.5,20,-10> }
		triangle { <1.5,20,-10>, <-1.5,20,-10>, <-1.5,17,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <1.5,17,-10>, <2,16.5,-10>, <2,20.5,-10> }
		triangle { <2,20.5,-10>, <1.5,20,-10>, <1.5,17,-10> }
		triangle { <-1.5,20,-10>, <1.5,20,-10>, <2,20.5,-10> }
		triangle { <2,20.5,-10>, <-2,20.5,-10>, <-1.5,20,-10> }
	}
	mesh {
		triangle { <-9.527,20.5,-10>, <9.527,20.5,-10>, <8.482,27,-10> }
		triangle { <8.482,27,-10>, <-8.482,27,-10>, <-9.527,20.5,-10> }
		triangle { <-1,27,-10>, <1,27,-10>, <1,27.5,-10> }
		triangle { <1,27.5,-10>, <-1,27.5,-10>, <-1,27,-10> }
		triangle { <-1,29.5,-10>, <1,29.5,-10>, <1,30,-10> }
		triangle { <1,30,-10>, <-1,30,-10>, <-1,29.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-12,0,-10>, <12,0,-10>, <14.345,2,-10> }
		triangle { <14.345,2,-10>, <-14.345,2,-10>, <-12,0,-10> }
		triangle { <-2.5,5,-10>, <2.5,5,-10>, <2.5,6,-10> }
		triangle { <2.5,6,-10>, <-2.5,6,-10>, <-2.5,5,-10> }
		triangle { <-2.5,15,-10>, <2.5,15,-10>, <2.5,16,-10> }
		triangle { <2.5,16,-10>, <-2.5,16,-10>, <-2.5,15,-10> }
	}
	mesh {
		triangle { <-1,27.5,-10>, <0,27.5,-10>, <-1,28.5,-10> }
		triangle { <0,27.5,-10>, <1,27.5,-10>, <1,28.5,-10> }
		triangle { <-1,28.5,-10>, <0,29.5,-10>, <-1,29.5,-10> }
		triangle { <1,28.5,-10>, <1,29.5,-10>, <0,29.5,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <0,28,-10>, <0,27.5,-10>, <1,28.5,-10> }
		triangle { <1,28.5,-10>, <0.5,28.5,-10>, <0,28,-10> }
		triangle { <0.5,28.5,-10>, <1,28.5,-10>, <0,29.5,-10> }
		triangle { <0,29.5,-10>, <0,29,-10>, <0.5,28.5,-10> }
		triangle { <0,29,-10>, <0,29.5,-10>, <-1,28.5,-10> }
		triangle { <-1,28.5,-10>, <-0.5,28.5,-10>, <0,29,-10> }
		triangle { <-0.5,28.5,-10>, <-1,28.5,-10>, <0,27.5,-10> }
		triangle { <0,27.5,-10>, <0,28,-10>, <-0.5,28.5,-10> }
	}
	mesh {
		triangle { <0,28,-10>, <0.5,28.5,-10>, <0,29,-10> }
		triangle { <0,29,-10>, <-0.5,28.5,-10>, <0,28,-10> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-19,30,-10>, <19,30,-10>, <19,32,-10> }
		triangle { <19,32,-10>, <-19,32,-10>, <-19,30,-10> }
	}
}
#end

#declare _4_dash_8sphe_dot_dat = sphere { <0,0,0>, 1 clipped_by { box { <-1,0,-1>, <2,2,2> } } }

#declare _975_dot_dat = #if (QUAL = 0) box { <-29.532,-7.179,-12.937>, <-11.676,23.426,6.748> } #else union {
	object { _4_dash_8sphe_dot_dat matrix <1.596,0.252,-5.712,-1.596,5.712,-0.252,4.14,1.215,1.215,-22.2,11.424,-0.935> }
	object { _4_dash_8sphe_dot_dat matrix <-1.596,-0.252,5.712,1.596,-5.712,0.252,4.14,1.215,1.215,-19.008,0,-0.431> }
	object { _4_dash_4cyli_dot_dat matrix <-1.596,-0.252,5.712,3.192,-11.424,0.504,4.14,1.215,1.215,-22.2,11.424,-0.935> }
	mesh {
		triangle { <-23.91,15.414,0.925>, <-22.2,15.642,1.153>, <-22.2,23.426,-8.103> }
		triangle { <-22.2,23.426,-8.103>, <-23.511,23.251,-8.278>, <-23.91,15.414,0.925> }
		triangle { <-22.2,15.642,1.153>, <-20.499,15.387,0.898>, <-20.896,23.231,-8.298> }
		triangle { <-20.896,23.231,-8.298>, <-22.2,23.426,-8.103>, <-22.2,15.642,1.153> }
		triangle { <-20.499,15.387,0.898>, <-19.041,14.718,0.229>, <-19.778,22.718,-8.811> }
		triangle { <-19.778,22.718,-8.811>, <-20.896,23.231,-8.298>, <-20.499,15.387,0.898> }
		triangle { <-19.041,14.718,0.229>, <-18.06,13.704,-0.785>, <-19.026,21.94,-9.589> }
		triangle { <-19.026,21.94,-9.589>, <-19.778,22.718,-8.811>, <-19.041,14.718,0.229> }
		triangle { <-18.06,13.704,-0.785>, <-17.741,12.489,-1.994>, <-18.782,21.014,-10.515> }
		triangle { <-18.782,21.014,-10.515>, <-19.026,21.94,-9.589>, <-18.06,13.704,-0.785> }
		triangle { <-17.741,12.489,-1.994>, <-18.105,11.292,-3.197>, <-19.061,20.091,-11.438> }
		triangle { <-19.061,20.091,-11.438>, <-18.782,21.014,-10.515>, <-17.741,12.489,-1.994> }
		triangle { <-18.105,11.292,-3.197>, <-19.054,10.26,-4.229>, <-19.788,19.3,-12.229> }
		triangle { <-19.788,19.3,-12.229>, <-19.061,20.091,-11.438>, <-18.105,11.292,-3.197> }
		triangle { <-19.054,10.26,-4.229>, <-20.49,9.564,-4.925>, <-20.889,18.766,-12.762> }
		triangle { <-20.889,18.766,-12.762>, <-19.788,19.3,-12.229>, <-19.054,10.26,-4.229> }
		triangle { <-20.49,9.564,-4.925>, <-22.2,9.336,-5.153>, <-22.2,18.592,-12.937> }
		triangle { <-22.2,18.592,-12.937>, <-20.889,18.766,-12.762>, <-20.49,9.564,-4.925> }
		triangle { <-22.2,9.336,-5.153>, <-23.901,9.591,-4.898>, <-23.504,18.787,-12.742> }
		triangle { <-23.504,18.787,-12.742>, <-22.2,18.592,-12.937>, <-22.2,9.336,-5.153> }
		triangle { <-23.901,9.591,-4.898>, <-25.359,10.26,-4.229>, <-24.622,19.3,-12.229> }
		triangle { <-24.622,19.3,-12.229>, <-23.504,18.787,-12.742>, <-23.901,9.591,-4.898> }
		triangle { <-25.359,10.26,-4.229>, <-26.34,11.274,-3.215>, <-25.374,20.077,-11.451> }
		triangle { <-25.374,20.077,-11.451>, <-24.622,19.3,-12.229>, <-25.359,10.26,-4.229> }
		triangle { <-26.34,11.274,-3.215>, <-26.659,12.489,-2.006>, <-25.618,21.004,-10.525> }
		triangle { <-25.618,21.004,-10.525>, <-25.374,20.077,-11.451>, <-26.34,11.274,-3.215> }
		triangle { <-26.659,12.489,-2.006>, <-26.295,13.686,-0.803>, <-25.34,21.927,-9.602> }
		triangle { <-25.34,21.927,-9.602>, <-25.618,21.004,-10.525>, <-26.659,12.489,-2.006> }
		triangle { <-26.295,13.686,-0.803>, <-25.346,14.718,0.229>, <-24.612,22.718,-8.811> }
		triangle { <-24.612,22.718,-8.811>, <-25.34,21.927,-9.602>, <-26.295,13.686,-0.803> }
		triangle { <-25.346,14.718,0.229>, <-23.91,15.414,0.925>, <-23.511,23.251,-8.278> }
		triangle { <-23.511,23.251,-8.278>, <-24.612,22.718,-8.811>, <-25.346,14.718,0.229> }
	}
}
#end

#declare _977_dot_dat = #if (QUAL = 0) box { <-9.52,-4,-6>, <16,8,6> } #else union {
	mesh {
		triangle { <2,8,0>, <1.52,8,-2.28>, <1.52,-4,-2.28> }
		triangle { <1.52,-4,-2.28>, <2,-4,0>, <2,8,0> }
		triangle { <1.52,8,-2.28>, <0.2,8,-4.2>, <0.2,-4,-4.2> }
		triangle { <0.2,-4,-4.2>, <1.52,-4,-2.28>, <1.52,8,-2.28> }
		triangle { <0.2,8,-4.2>, <-1.72,8,-5.52>, <-1.72,-4,-5.52> }
		triangle { <-1.72,-4,-5.52>, <0.2,-4,-4.2>, <0.2,8,-4.2> }
		triangle { <-1.72,8,-5.52>, <-4,8,-6>, <-4,-4,-6> }
		triangle { <-4,-4,-6>, <-1.72,-4,-5.52>, <-1.72,8,-5.52> }
		triangle { <-4,8,-6>, <-6.28,5.72,-5.52>, <-6.28,-4,-5.52> }
		triangle { <-6.28,-4,-5.52>, <-4,-4,-6>, <-4,8,-6> }
		triangle { <-6.28,5.72,-5.52>, <-8.2,3.8,-4.2>, <-8.2,-4,-4.2> }
		triangle { <-8.2,-4,-4.2>, <-6.28,-4,-5.52>, <-6.28,5.72,-5.52> }
		triangle { <-8.2,3.8,-4.2>, <-9.52,2.48,-2.28>, <-9.52,-4,-2.28> }
		triangle { <-9.52,-4,-2.28>, <-8.2,-4,-4.2>, <-8.2,3.8,-4.2> }
		triangle { <-9.52,2.48,2.28>, <-8.2,3.8,4.2>, <-8.2,-4,4.2> }
		triangle { <-8.2,-4,4.2>, <-9.52,-4,2.28>, <-9.52,2.48,2.28> }
		triangle { <-8.2,3.8,4.2>, <-6.28,5.72,5.52>, <-6.28,-4,5.52> }
		triangle { <-6.28,-4,5.52>, <-8.2,-4,4.2>, <-8.2,3.8,4.2> }
		triangle { <-6.28,5.72,5.52>, <-4,8,6>, <-4,-4,6> }
		triangle { <-4,-4,6>, <-6.28,-4,5.52>, <-6.28,5.72,5.52> }
		triangle { <-4,8,6>, <-1.72,8,5.52>, <-1.72,-4,5.52> }
		triangle { <-1.72,-4,5.52>, <-4,-4,6>, <-4,8,6> }
		triangle { <-1.72,8,5.52>, <0.2,8,4.2>, <0.2,-4,4.2> }
		triangle { <0.2,-4,4.2>, <-1.72,-4,5.52>, <-1.72,8,5.52> }
		triangle { <0.2,8,4.2>, <1.52,8,2.28>, <1.52,-4,2.28> }
		triangle { <1.52,-4,2.28>, <0.2,-4,4.2>, <0.2,8,4.2> }
		triangle { <1.52,8,2.28>, <2,8,0>, <2,-4,0> }
		triangle { <2,-4,0>, <1.52,-4,2.28>, <1.52,8,2.28> }
// inside
		triangle { <0,8,0>, <-0.32,8,-1.52>, <-0.32,-4,-1.52> }
		triangle { <-0.32,-4,-1.52>, <0,-4,0>, <0,8,0> }
		triangle { <-0.32,8,-1.52>, <-1.2,8,-2.8>, <-1.2,-4,-2.8> }
		triangle { <-1.2,-4,-2.8>, <-0.32,-4,-1.52>, <-0.32,8,-1.52> }
		triangle { <-1.2,8,-2.8>, <-2.48,8,-3.68>, <-2.48,-4,-3.68> }
		triangle { <-2.48,-4,-3.68>, <-1.2,-4,-2.8>, <-1.2,8,-2.8> }
		triangle { <-2.48,8,-3.68>, <-4,8,-4>, <-4,-4,-4> }
		triangle { <-4,-4,-4>, <-2.48,-4,-3.68>, <-2.48,8,-3.68> }
		triangle { <-4,8,-4>, <-5.52,5.72,-3.68>, <-5.52,-4,-3.68> }
		triangle { <-5.52,-4,-3.68>, <-4,-4,-4>, <-4,8,-4> }
		triangle { <-5.52,5.72,-3.68>, <-6.8,3.8,-2.8>, <-6.8,-4,-2.8> }
		triangle { <-6.8,-4,-2.8>, <-5.52,-4,-3.68>, <-5.52,5.72,-3.68> }
		triangle { <-6.8,3.8,-2.8>, <-7.68,2.48,-2.28>, <-7.68,-4,-2.28> }
		triangle { <-7.68,-4,-2.28>, <-6.8,-4,-2.8>, <-6.8,3.8,-2.8> }
		triangle { <-7.68,2.48,2.28>, <-6.8,3.8,2.8>, <-6.8,-4,2.8> }
		triangle { <-6.8,-4,2.8>, <-7.68,-4,2.28>, <-7.68,2.48,2.28> }
		triangle { <-6.8,3.8,2.8>, <-5.52,5.72,3.68>, <-5.52,-4,3.68> }
		triangle { <-5.52,-4,3.68>, <-6.8,-4,2.8>, <-6.8,3.8,2.8> }
		triangle { <-5.52,5.72,3.68>, <-4,8,4>, <-4,-4,4> }
		triangle { <-4,-4,4>, <-5.52,-4,3.68>, <-5.52,5.72,3.68> }
		triangle { <-4,8,4>, <-2.48,8,3.68>, <-2.48,-4,3.68> }
		triangle { <-2.48,-4,3.68>, <-4,-4,4>, <-4,8,4> }
		triangle { <-2.48,8,3.68>, <-1.2,8,2.8>, <-1.2,-4,2.8> }
		triangle { <-1.2,-4,2.8>, <-2.48,-4,3.68>, <-2.48,8,3.68> }
		triangle { <-1.2,8,2.8>, <-0.32,8,1.52>, <-0.32,-4,1.52> }
		triangle { <-0.32,-4,1.52>, <-1.2,-4,2.8>, <-1.2,8,2.8> }
		triangle { <-0.32,8,1.52>, <0,8,0>, <0,-4,0> }
		triangle { <0,-4,0>, <-0.32,-4,1.52>, <-0.32,8,1.52> }
		triangle { <-9.52,-4,-2.28>, <-7.68,-4,-2.28>, <-7.68,2.48,-2.28> }
		triangle { <-7.68,2.48,-2.28>, <-9.52,2.48,-2.28>, <-9.52,-4,-2.28> }
		triangle { <-9.52,-4,2.28>, <-7.68,-4,2.28>, <-7.68,2.48,2.28> }
		triangle { <-7.68,2.48,2.28>, <-9.52,2.48,2.28>, <-9.52,-4,2.28> }
// top
		triangle { <1.52,-4,-2.28>, <2,-4,0>, <0,-4,0> }
		triangle { <0,-4,0>, <-0.32,-4,-1.52>, <1.52,-4,-2.28> }
		triangle { <0.2,-4,-4.2>, <1.52,-4,-2.28>, <-0.32,-4,-1.52> }
		triangle { <-0.32,-4,-1.52>, <-1.2,-4,-2.8>, <0.2,-4,-4.2> }
		triangle { <-1.72,-4,-5.52>, <0.2,-4,-4.2>, <-1.2,-4,-2.8> }
		triangle { <-1.2,-4,-2.8>, <-2.48,-4,-3.68>, <-1.72,-4,-5.52> }
		triangle { <-4,-4,-6>, <-1.72,-4,-5.52>, <-2.48,-4,-3.68> }
		triangle { <-2.48,-4,-3.68>, <-4,-4,-4>, <-4,-4,-6> }
		triangle { <-6.28,-4,-5.52>, <-4,-4,-6>, <-4,-4,-4> }
		triangle { <-4,-4,-4>, <-5.52,-4,-3.68>, <-6.28,-4,-5.52> }
		triangle { <-8.2,-4,-4.2>, <-6.28,-4,-5.52>, <-5.52,-4,-3.68> }
		triangle { <-5.52,-4,-3.68>, <-6.8,-4,-2.8>, <-8.2,-4,-4.2> }
		triangle { <-9.52,-4,-2.28>, <-8.2,-4,-4.2>, <-6.8,-4,-2.8> }
		triangle { <-6.8,-4,-2.8>, <-7.68,-4,-2.28>, <-9.52,-4,-2.28> }
// 4 16 -4.20 12.00 -4.20 -5.52 12.00 -2.28 -2.80 12.00 -2.80 -3.68 12.00 -2.28
		triangle { <-8.2,-4,4.2>, <-9.52,-4,2.28>, <-7.68,-4,2.28> }
		triangle { <-7.68,-4,2.28>, <-6.8,-4,2.8>, <-8.2,-4,4.2> }
		triangle { <-6.28,-4,5.52>, <-8.2,-4,4.2>, <-6.8,-4,2.8> }
		triangle { <-6.8,-4,2.8>, <-5.52,-4,3.68>, <-6.28,-4,5.52> }
		triangle { <-4,-4,6>, <-6.28,-4,5.52>, <-5.52,-4,3.68> }
		triangle { <-5.52,-4,3.68>, <-4,-4,4>, <-4,-4,6> }
		triangle { <-1.72,-4,5.52>, <-4,-4,6>, <-4,-4,4> }
		triangle { <-4,-4,4>, <-2.48,-4,3.68>, <-1.72,-4,5.52> }
		triangle { <0.2,-4,4.2>, <-1.72,-4,5.52>, <-2.48,-4,3.68> }
		triangle { <-2.48,-4,3.68>, <-1.2,-4,2.8>, <0.2,-4,4.2> }
		triangle { <1.52,-4,2.28>, <0.2,-4,4.2>, <-1.2,-4,2.8> }
		triangle { <-1.2,-4,2.8>, <-0.32,-4,1.52>, <1.52,-4,2.28> }
		triangle { <2,-4,0>, <1.52,-4,2.28>, <-0.32,-4,1.52> }
		triangle { <-0.32,-4,1.52>, <0,-4,0>, <2,-4,0> }
// bottom
		triangle { <2,8,0>, <1.52,8,-2.28>, <-0.32,8,-1.52> }
		triangle { <-0.32,8,-1.52>, <0,8,0>, <2,8,0> }
		triangle { <1.52,8,-2.28>, <0.2,8,-4.2>, <-1.2,8,-2.8> }
		triangle { <-1.2,8,-2.8>, <-0.32,8,-1.52>, <1.52,8,-2.28> }
		triangle { <0.2,8,-4.2>, <-1.72,8,-5.52>, <-2.48,8,-3.68> }
		triangle { <-2.48,8,-3.68>, <-1.2,8,-2.8>, <0.2,8,-4.2> }
		triangle { <-1.72,8,-5.52>, <-4,8,-6>, <-4,8,-4> }
		triangle { <-4,8,-4>, <-2.48,8,-3.68>, <-1.72,8,-5.52> }
		triangle { <-4,8,-6>, <-6.28,5.72,-5.52>, <-5.52,5.72,-3.68> }
		triangle { <-5.52,5.72,-3.68>, <-4,8,-4>, <-4,8,-6> }
		triangle { <-6.28,5.72,-5.52>, <-8.2,3.8,-4.2>, <-6.8,3.8,-2.8> }
		triangle { <-6.8,3.8,-2.8>, <-5.52,5.72,-3.68>, <-6.28,5.72,-5.52> }
		triangle { <-8.2,3.8,-4.2>, <-9.52,2.48,-2.28>, <-7.68,2.48,-2.28> }
		triangle { <-7.68,2.48,-2.28>, <-6.8,3.8,-2.8>, <-8.2,3.8,-4.2> }
		triangle { <-9.52,2.48,2.28>, <-8.2,3.8,4.2>, <-6.8,3.8,2.8> }
		triangle { <-6.8,3.8,2.8>, <-7.68,2.48,2.28>, <-9.52,2.48,2.28> }
		triangle { <-8.2,3.8,4.2>, <-6.28,5.72,5.52>, <-5.52,5.72,3.68> }
		triangle { <-5.52,5.72,3.68>, <-6.8,3.8,2.8>, <-8.2,3.8,4.2> }
		triangle { <-6.28,5.72,5.52>, <-4,8,6>, <-4,8,4> }
		triangle { <-4,8,4>, <-5.52,5.72,3.68>, <-6.28,5.72,5.52> }
		triangle { <-4,8,6>, <-1.72,8,5.52>, <-2.48,8,3.68> }
		triangle { <-2.48,8,3.68>, <-4,8,4>, <-4,8,6> }
		triangle { <-1.72,8,5.52>, <0.2,8,4.2>, <-1.2,8,2.8> }
		triangle { <-1.2,8,2.8>, <-2.48,8,3.68>, <-1.72,8,5.52> }
		triangle { <0.2,8,4.2>, <1.52,8,2.28>, <-0.32,8,1.52> }
		triangle { <-0.32,8,1.52>, <-1.2,8,2.8>, <0.2,8,4.2> }
		triangle { <1.52,8,2.28>, <2,8,0>, <0,8,0> }
		triangle { <0,8,0>, <-0.32,8,1.52>, <1.52,8,2.28> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,0,-2.5,16,0,0,0,-2.5,0,0,4,0> }
}
#end

#declare _976_dot_dat = #if (QUAL = 0) box { <11.676,-7.179,-12.937>, <29.532,23.426,6.748> } #else union {
	object { _4_dash_8sphe_dot_dat matrix <-1.596,0.252,-5.712,1.596,5.712,-0.252,-4.14,1.215,1.215,22.2,11.424,-0.935> }
	object { _4_dash_8sphe_dot_dat matrix <1.596,-0.252,5.712,-1.596,-5.712,0.252,-4.14,1.215,1.215,19.008,0,-0.431> }
	object { _4_dash_4cyli_dot_dat matrix <1.596,-0.252,5.712,-3.192,-11.424,0.504,-4.14,1.215,1.215,22.2,11.424,-0.935> }
// 1 16 0 0 0    4.5 0 0  0 4.5 0  0 0 4.5 8-8sphe.dat
	mesh {
		triangle { <23.91,15.414,0.925>, <22.2,15.642,1.153>, <22.2,23.426,-8.103> }
		triangle { <22.2,23.426,-8.103>, <23.511,23.251,-8.278>, <23.91,15.414,0.925> }
		triangle { <22.2,15.642,1.153>, <20.499,15.387,0.898>, <20.896,23.231,-8.298> }
		triangle { <20.896,23.231,-8.298>, <22.2,23.426,-8.103>, <22.2,15.642,1.153> }
		triangle { <20.499,15.387,0.898>, <19.041,14.718,0.229>, <19.778,22.718,-8.811> }
		triangle { <19.778,22.718,-8.811>, <20.896,23.231,-8.298>, <20.499,15.387,0.898> }
		triangle { <19.041,14.718,0.229>, <18.06,13.704,-0.785>, <19.026,21.94,-9.589> }
		triangle { <19.026,21.94,-9.589>, <19.778,22.718,-8.811>, <19.041,14.718,0.229> }
		triangle { <18.06,13.704,-0.785>, <17.741,12.489,-1.994>, <18.782,21.014,-10.515> }
		triangle { <18.782,21.014,-10.515>, <19.026,21.94,-9.589>, <18.06,13.704,-0.785> }
		triangle { <17.741,12.489,-1.994>, <18.105,11.292,-3.197>, <19.061,20.091,-11.438> }
		triangle { <19.061,20.091,-11.438>, <18.782,21.014,-10.515>, <17.741,12.489,-1.994> }
		triangle { <18.105,11.292,-3.197>, <19.054,10.26,-4.229>, <19.788,19.3,-12.229> }
		triangle { <19.788,19.3,-12.229>, <19.061,20.091,-11.438>, <18.105,11.292,-3.197> }
		triangle { <19.054,10.26,-4.229>, <20.49,9.564,-4.925>, <20.889,18.766,-12.762> }
		triangle { <20.889,18.766,-12.762>, <19.788,19.3,-12.229>, <19.054,10.26,-4.229> }
		triangle { <20.49,9.564,-4.925>, <22.2,9.336,-5.153>, <22.2,18.592,-12.937> }
		triangle { <22.2,18.592,-12.937>, <20.889,18.766,-12.762>, <20.49,9.564,-4.925> }
		triangle { <22.2,9.336,-5.153>, <23.901,9.591,-4.898>, <23.504,18.787,-12.742> }
		triangle { <23.504,18.787,-12.742>, <22.2,18.592,-12.937>, <22.2,9.336,-5.153> }
		triangle { <23.901,9.591,-4.898>, <25.359,10.26,-4.229>, <24.622,19.3,-12.229> }
		triangle { <24.622,19.3,-12.229>, <23.504,18.787,-12.742>, <23.901,9.591,-4.898> }
		triangle { <25.359,10.26,-4.229>, <26.34,11.274,-3.215>, <25.374,20.077,-11.451> }
		triangle { <25.374,20.077,-11.451>, <24.622,19.3,-12.229>, <25.359,10.26,-4.229> }
		triangle { <26.34,11.274,-3.215>, <26.659,12.489,-2.006>, <25.618,21.004,-10.525> }
		triangle { <25.618,21.004,-10.525>, <25.374,20.077,-11.451>, <26.34,11.274,-3.215> }
		triangle { <26.659,12.489,-2.006>, <26.295,13.686,-0.803>, <25.34,21.927,-9.602> }
		triangle { <25.34,21.927,-9.602>, <25.618,21.004,-10.525>, <26.659,12.489,-2.006> }
		triangle { <26.295,13.686,-0.803>, <25.346,14.718,0.229>, <24.612,22.718,-8.811> }
		triangle { <24.612,22.718,-8.811>, <25.34,21.927,-9.602>, <26.295,13.686,-0.803> }
		triangle { <25.346,14.718,0.229>, <23.91,15.414,0.925>, <23.511,23.251,-8.278> }
		triangle { <23.511,23.251,-8.278>, <24.612,22.718,-8.811>, <25.346,14.718,0.229> }
	}
}
#end

#declare _4_dash_4ndis_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 2, 1
		clipped_by { box { <-1,-1,-1>, <1,1,1> } }
	}
#else
	difference {
		box { <-1,-0.001,-1>, <1,0.001,1> }
		cylinder { <0,-1,0>, <0,1,0>, 1 }
	}
#end

#declare stud2_dot_dat = difference {
	cylinder { <0,0,0>, <0,-4,0>, 6 }
	cylinder { <0,0.01,0>, <0,-4.01,0>, 4 }
}

#declare ring3_dot_dat = #if (ver >= 3.1)
	disc { <0,0,0>, <0,1,0>, 4, 3 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 4 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 3 }
	}
#end

#declare ring2_dot_dat = #if (ver >= 3.1)
	disc { <0,0,0>, <0,1,0>, 3, 2 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 3 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 2 }
	}
#end

#declare s_slash_3626bs01_dot_dat = #if (QUAL = 0) box { <-13,-4,-11.536>, <13,24,13> } #else union {
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,0,0> }
	object { ring2_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,20,0,0,0,6,0,4,0> }
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,24,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,3,0,0,0,8,0,21,0> }
	mesh {
		triangle { <-3.061,0,7.391>, <-4.415,1.172,10.658>, <-8.157,1.172,8.157> }
		triangle { <-8.157,1.172,8.157>, <-5.657,0,5.657>, <-3.061,0,7.391> }
		triangle { <-5.657,0,5.657>, <-8.157,1.172,8.157>, <-10.658,1.172,4.415> }
		triangle { <-10.658,1.172,4.415>, <-7.391,0,3.061>, <-5.657,0,5.657> }
		triangle { <-7.391,0,3.061>, <-10.658,1.172,4.415>, <-11.536,1.172,0> }
		triangle { <-11.536,1.172,0>, <-8,0,0>, <-7.391,0,3.061> }
		triangle { <-8,0,0>, <-11.536,1.172,0>, <-10.658,1.172,-4.415> }
		triangle { <-10.658,1.172,-4.415>, <-7.391,0,-3.061>, <-8,0,0> }
		triangle { <-7.391,0,-3.061>, <-10.658,1.172,-4.415>, <-8.157,1.172,-8.157> }
		triangle { <-8.157,1.172,-8.157>, <-5.657,0,-5.657>, <-7.391,0,-3.061> }
		triangle { <-5.657,0,-5.657>, <-8.157,1.172,-8.157>, <-4.415,1.172,-10.658> }
		triangle { <-4.415,1.172,-10.658>, <-3.061,0,-7.391>, <-5.657,0,-5.657> }
		triangle { <-3.061,0,-7.391>, <-4.415,1.172,-10.658>, <0,1.172,-11.536> }
		triangle { <0,1.172,-11.536>, <0,0,-8>, <-3.061,0,-7.391> }
		triangle { <0,0,-8>, <0,1.172,-11.536>, <4.415,1.172,-10.658> }
		triangle { <4.415,1.172,-10.658>, <3.061,0,-7.391>, <0,0,-8> }
		triangle { <3.061,0,-7.391>, <4.415,1.172,-10.658>, <8.157,1.172,-8.157> }
		triangle { <8.157,1.172,-8.157>, <5.657,0,-5.657>, <3.061,0,-7.391> }
		triangle { <5.657,0,-5.657>, <8.157,1.172,-8.157>, <10.658,1.172,-4.415> }
		triangle { <10.658,1.172,-4.415>, <7.391,0,-3.061>, <5.657,0,-5.657> }
		triangle { <7.391,0,-3.061>, <10.658,1.172,-4.415>, <11.536,1.172,0> }
		triangle { <11.536,1.172,0>, <8,0,0>, <7.391,0,-3.061> }
		triangle { <8,0,0>, <11.536,1.172,0>, <10.658,1.172,4.415> }
		triangle { <10.658,1.172,4.415>, <7.391,0,3.061>, <8,0,0> }
		triangle { <7.391,0,3.061>, <10.658,1.172,4.415>, <8.157,1.172,8.157> }
		triangle { <8.157,1.172,8.157>, <5.657,0,5.657>, <7.391,0,3.061> }
		triangle { <5.657,0,5.657>, <8.157,1.172,8.157>, <4.415,1.172,10.658> }
		triangle { <4.415,1.172,10.658>, <3.061,0,7.391>, <5.657,0,5.657> }
		triangle { <3.061,0,7.391>, <4.415,1.172,10.658>, <0,1.172,11.536> }
		triangle { <0,1.172,11.536>, <0,0,8>, <3.061,0,7.391> }
		triangle { <0,0,8>, <0,1.172,11.536>, <-4.415,1.172,10.658> }
		triangle { <-4.415,1.172,10.658>, <-3.061,0,7.391>, <0,0,8> }
		triangle { <-4.415,1.172,10.658>, <-4.975,4,12.01>, <-9.192,4,9.192> }
		triangle { <-9.192,4,9.192>, <-8.157,1.172,8.157>, <-4.415,1.172,10.658> }
		triangle { <-8.157,1.172,8.157>, <-9.192,4,9.192>, <-12.01,4,4.975> }
		triangle { <-12.01,4,4.975>, <-10.658,1.172,4.415>, <-8.157,1.172,8.157> }
		triangle { <-10.658,1.172,4.415>, <-12.01,4,4.975>, <-13,4,0> }
		triangle { <-13,4,0>, <-11.536,1.172,0>, <-10.658,1.172,4.415> }
		triangle { <11.536,1.172,0>, <13,4,0>, <12.01,4,4.975> }
		triangle { <12.01,4,4.975>, <10.658,1.172,4.415>, <11.536,1.172,0> }
		triangle { <10.658,1.172,4.415>, <12.01,4,4.975>, <9.192,4,9.192> }
		triangle { <9.192,4,9.192>, <8.157,1.172,8.157>, <10.658,1.172,4.415> }
		triangle { <8.157,1.172,8.157>, <9.192,4,9.192>, <4.975,4,12.01> }
		triangle { <4.975,4,12.01>, <4.415,1.172,10.658>, <8.157,1.172,8.157> }
		triangle { <4.415,1.172,10.658>, <4.975,4,12.01>, <0,4,13> }
		triangle { <0,4,13>, <0,1.172,11.536>, <4.415,1.172,10.658> }
		triangle { <0,1.172,11.536>, <0,4,13>, <-4.975,4,12.01> }
		triangle { <-4.975,4,12.01>, <-4.415,1.172,10.658>, <0,1.172,11.536> }
	}
	object { _2_dash_4cyli_dot_dat matrix <13,0,0,0,13,0,0,0,13,0,4,0> }
	mesh {
		triangle { <-3.061,21,7.391>, <-4.415,19.828,10.658>, <-8.157,19.828,8.157> }
		triangle { <-8.157,19.828,8.157>, <-5.657,21,5.657>, <-3.061,21,7.391> }
		triangle { <-5.657,21,5.657>, <-8.157,19.828,8.157>, <-10.658,19.828,4.415> }
		triangle { <-10.658,19.828,4.415>, <-7.391,21,3.061>, <-5.657,21,5.657> }
		triangle { <-7.391,21,3.061>, <-10.658,19.828,4.415>, <-11.536,19.828,0> }
		triangle { <-11.536,19.828,0>, <-8,21,0>, <-7.391,21,3.061> }
		triangle { <-8,21,0>, <-11.536,19.828,0>, <-10.658,19.828,-4.415> }
		triangle { <-10.658,19.828,-4.415>, <-7.391,21,-3.061>, <-8,21,0> }
		triangle { <-7.391,21,-3.061>, <-10.658,19.828,-4.415>, <-8.157,19.828,-8.157> }
		triangle { <-8.157,19.828,-8.157>, <-5.657,21,-5.657>, <-7.391,21,-3.061> }
		triangle { <-5.657,21,-5.657>, <-8.157,19.828,-8.157>, <-4.415,19.828,-10.658> }
		triangle { <-4.415,19.828,-10.658>, <-3.061,21,-7.391>, <-5.657,21,-5.657> }
		triangle { <-3.061,21,-7.391>, <-4.415,19.828,-10.658>, <0,19.828,-11.536> }
		triangle { <0,19.828,-11.536>, <0,21,-8>, <-3.061,21,-7.391> }
		triangle { <0,21,-8>, <0,19.828,-11.536>, <4.415,19.828,-10.658> }
		triangle { <4.415,19.828,-10.658>, <3.061,21,-7.391>, <0,21,-8> }
		triangle { <3.061,21,-7.391>, <4.415,19.828,-10.658>, <8.157,19.828,-8.157> }
		triangle { <8.157,19.828,-8.157>, <5.657,21,-5.657>, <3.061,21,-7.391> }
		triangle { <5.657,21,-5.657>, <8.157,19.828,-8.157>, <10.658,19.828,-4.415> }
		triangle { <10.658,19.828,-4.415>, <7.391,21,-3.061>, <5.657,21,-5.657> }
		triangle { <7.391,21,-3.061>, <10.658,19.828,-4.415>, <11.536,19.828,0> }
		triangle { <11.536,19.828,0>, <8,21,0>, <7.391,21,-3.061> }
		triangle { <8,21,0>, <11.536,19.828,0>, <10.658,19.828,4.415> }
		triangle { <10.658,19.828,4.415>, <7.391,21,3.061>, <8,21,0> }
		triangle { <7.391,21,3.061>, <10.658,19.828,4.415>, <8.157,19.828,8.157> }
		triangle { <8.157,19.828,8.157>, <5.657,21,5.657>, <7.391,21,3.061> }
		triangle { <5.657,21,5.657>, <8.157,19.828,8.157>, <4.415,19.828,10.658> }
		triangle { <4.415,19.828,10.658>, <3.061,21,7.391>, <5.657,21,5.657> }
		triangle { <3.061,21,7.391>, <4.415,19.828,10.658>, <0,19.828,11.536> }
		triangle { <0,19.828,11.536>, <0,21,8>, <3.061,21,7.391> }
		triangle { <0,21,8>, <0,19.828,11.536>, <-4.415,19.828,10.658> }
		triangle { <-4.415,19.828,10.658>, <-3.061,21,7.391>, <0,21,8> }
		triangle { <-4.415,19.828,10.658>, <-4.975,17,12.01>, <-9.192,17,9.192> }
		triangle { <-9.192,17,9.192>, <-8.157,19.828,8.157>, <-4.415,19.828,10.658> }
		triangle { <-8.157,19.828,8.157>, <-9.192,17,9.192>, <-12.01,17,4.975> }
		triangle { <-12.01,17,4.975>, <-10.658,19.828,4.415>, <-8.157,19.828,8.157> }
		triangle { <-10.658,19.828,4.415>, <-12.01,17,4.975>, <-13,17,0> }
		triangle { <-13,17,0>, <-11.536,19.828,0>, <-10.658,19.828,4.415> }
		triangle { <11.536,19.828,0>, <13,17,0>, <12.01,17,4.975> }
		triangle { <12.01,17,4.975>, <10.658,19.828,4.415>, <11.536,19.828,0> }
		triangle { <10.658,19.828,4.415>, <12.01,17,4.975>, <9.192,17,9.192> }
		triangle { <9.192,17,9.192>, <8.157,19.828,8.157>, <10.658,19.828,4.415> }
		triangle { <8.157,19.828,8.157>, <9.192,17,9.192>, <4.975,17,12.01> }
		triangle { <4.975,17,12.01>, <4.415,19.828,10.658>, <8.157,19.828,8.157> }
		triangle { <4.415,19.828,10.658>, <4.975,17,12.01>, <0,17,13> }
		triangle { <0,17,13>, <0,19.828,11.536>, <4.415,19.828,10.658> }
		triangle { <0,19.828,11.536>, <0,17,13>, <-4.975,17,12.01> }
		triangle { <-4.975,17,12.01>, <-4.415,19.828,10.658>, <0,19.828,11.536> }
		triangle { <0,24,6>, <-2.3,24,5.54>, <-3.06,24,7.39> }
		triangle { <-3.06,24,7.39>, <0,24,8>, <0,24,6> }
		triangle { <-2.3,24,5.54>, <-4.24,24,4.24>, <-5.66,24,5.66> }
		triangle { <-5.66,24,5.66>, <-3.06,24,7.39>, <-2.3,24,5.54> }
		triangle { <-4.24,24,4.24>, <-5.54,24,2.3>, <-7.39,24,3.06> }
		triangle { <-7.39,24,3.06>, <-5.66,24,5.66>, <-4.24,24,4.24> }
		triangle { <-5.54,24,2.3>, <-6,24,0>, <-8,24,0> }
		triangle { <-8,24,0>, <-7.39,24,3.06>, <-5.54,24,2.3> }
		triangle { <-6,24,0>, <-5.54,24,-2.3>, <-7.39,24,-3.06> }
		triangle { <-7.39,24,-3.06>, <-8,24,0>, <-6,24,0> }
		triangle { <-5.54,24,-2.3>, <-4.24,24,-4.24>, <-5.66,24,-5.66> }
		triangle { <-5.66,24,-5.66>, <-7.39,24,-3.06>, <-5.54,24,-2.3> }
		triangle { <-4.24,24,-4.24>, <-2.3,24,-5.54>, <-3.06,24,-7.39> }
		triangle { <-3.06,24,-7.39>, <-5.66,24,-5.66>, <-4.24,24,-4.24> }
		triangle { <-2.3,24,-5.54>, <0,24,-6>, <0,24,-8> }
		triangle { <0,24,-8>, <-3.06,24,-7.39>, <-2.3,24,-5.54> }
		triangle { <0,24,-6>, <2.3,24,-5.54>, <3.06,24,-7.39> }
		triangle { <3.06,24,-7.39>, <0,24,-8>, <0,24,-6> }
		triangle { <2.3,24,-5.54>, <4.24,24,-4.24>, <5.66,24,-5.66> }
		triangle { <5.66,24,-5.66>, <3.06,24,-7.39>, <2.3,24,-5.54> }
		triangle { <4.24,24,-4.24>, <5.54,24,-2.3>, <7.39,24,-3.06> }
		triangle { <7.39,24,-3.06>, <5.66,24,-5.66>, <4.24,24,-4.24> }
		triangle { <5.54,24,-2.3>, <6,24,0>, <8,24,0> }
		triangle { <8,24,0>, <7.39,24,-3.06>, <5.54,24,-2.3> }
		triangle { <6,24,0>, <5.54,24,2.3>, <7.39,24,3.06> }
		triangle { <7.39,24,3.06>, <8,24,0>, <6,24,0> }
		triangle { <5.54,24,2.3>, <4.24,24,4.24>, <5.66,24,5.66> }
		triangle { <5.66,24,5.66>, <7.39,24,3.06>, <5.54,24,2.3> }
		triangle { <4.24,24,4.24>, <2.3,24,5.54>, <3.06,24,7.39> }
		triangle { <3.06,24,7.39>, <5.66,24,5.66>, <4.24,24,4.24> }
		triangle { <2.3,24,5.54>, <0,24,6>, <0,24,8> }
		triangle { <0,24,8>, <3.06,24,7.39>, <2.3,24,5.54> }
		triangle { <1,0,3.87>, <1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <0,0,4>, <1,0,3.87> }
		triangle { <-1,0,3.87>, <-1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <0,0,4>, <-1,0,3.87> }
		triangle { <-3.85,0,-1.07>, <-1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <-3.46,0,-2>, <-3.85,0,-1.07> }
		triangle { <-2.85,0,-2.8>, <0,0,-1.15>, <0,0,0> }
		triangle { <0,0,0>, <-3.46,0,-2>, <-2.85,0,-2.8> }
		triangle { <2.85,0,-2.8>, <0,0,-1.15>, <0,0,0> }
		triangle { <0,0,0>, <3.46,0,-2>, <2.85,0,-2.8> }
		triangle { <3.85,0,-1.07>, <1,0,0.58>, <0,0,0> }
		triangle { <0,0,0>, <3.46,0,-2>, <3.85,0,-1.07> }
		triangle { <1,4,3.87>, <1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <0,4,4>, <1,4,3.87> }
		triangle { <-1,4,3.87>, <-1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <0,4,4>, <-1,4,3.87> }
		triangle { <-3.85,4,-1.07>, <-1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <-3.46,4,-2>, <-3.85,4,-1.07> }
		triangle { <-2.85,4,-2.8>, <0,4,-1.15>, <0,4,0> }
		triangle { <0,4,0>, <-3.46,4,-2>, <-2.85,4,-2.8> }
		triangle { <2.85,4,-2.8>, <0,4,-1.15>, <0,4,0> }
		triangle { <0,4,0>, <3.46,4,-2>, <2.85,4,-2.8> }
		triangle { <3.85,4,-1.07>, <1,4,0.58>, <0,4,0> }
		triangle { <0,4,0>, <3.46,4,-2>, <3.85,4,-1.07> }
		triangle { <1,0,3.87>, <1,0,0.58>, <1,4,0.58> }
		triangle { <1,4,0.58>, <1,4,3.87>, <1,0,3.87> }
		triangle { <-1,0,3.87>, <-1,0,0.58>, <-1,4,0.58> }
		triangle { <-1,4,0.58>, <-1,4,3.87>, <-1,0,3.87> }
		triangle { <-3.85,0,-1.07>, <-1,0,0.58>, <-1,4,0.58> }
		triangle { <-1,4,0.58>, <-3.85,4,-1.07>, <-3.85,0,-1.07> }
		triangle { <-2.85,0,-2.8>, <0,0,-1.15>, <0,4,-1.15> }
		triangle { <0,4,-1.15>, <-2.85,4,-2.8>, <-2.85,0,-2.8> }
		triangle { <2.85,0,-2.8>, <0,0,-1.15>, <0,4,-1.15> }
		triangle { <0,4,-1.15>, <2.85,4,-2.8>, <2.85,0,-2.8> }
		triangle { <3.85,0,-1.07>, <1,0,0.58>, <1,4,0.58> }
		triangle { <1,4,0.58>, <3.85,4,-1.07>, <3.85,0,-1.07> }
		triangle { <4,0,0>, <3.696,0,1.531>, <3.696,4,1.531> }
		triangle { <3.696,4,1.531>, <4,4,0>, <4,0,0> }
		triangle { <3.696,0,1.531>, <2.828,0,2.828>, <2.828,4,2.828> }
		triangle { <2.828,4,2.828>, <3.696,4,1.531>, <3.696,0,1.531> }
		triangle { <2.828,0,2.828>, <1,0,3.87>, <1,4,3.87> }
		triangle { <1,4,3.87>, <2.828,4,2.828>, <2.828,0,2.828> }
		triangle { <-1,0,3.87>, <-2.828,0,2.828>, <-2.828,4,2.828> }
		triangle { <-2.828,4,2.828>, <-1,4,3.87>, <-1,0,3.87> }
		triangle { <-2.828,0,2.828>, <-3.696,0,1.531>, <-3.696,4,1.531> }
		triangle { <-3.696,4,1.531>, <-2.828,4,2.828>, <-2.828,0,2.828> }
		triangle { <-3.696,0,1.531>, <-4,0,0>, <-4,4,0> }
		triangle { <-4,4,0>, <-3.696,4,1.531>, <-3.696,0,1.531> }
		triangle { <-4,0,0>, <-3.85,0,-1.07>, <-3.85,4,-1.07> }
		triangle { <-3.85,4,-1.07>, <-4,4,0>, <-4,0,0> }
		triangle { <-2.85,0,-2.8>, <-1.531,0,-3.696>, <-1.531,4,-3.696> }
		triangle { <-1.531,4,-3.696>, <-2.85,4,-2.8>, <-2.85,0,-2.8> }
		triangle { <-1.531,0,-3.696>, <0,0,-4>, <0,4,-4> }
		triangle { <0,4,-4>, <-1.531,4,-3.696>, <-1.531,0,-3.696> }
		triangle { <0,0,-4>, <1.531,0,-3.696>, <1.531,4,-3.696> }
		triangle { <1.531,4,-3.696>, <0,4,-4>, <0,0,-4> }
		triangle { <1.531,0,-3.696>, <2.85,0,-2.8>, <2.85,4,-2.8> }
		triangle { <2.85,4,-2.8>, <1.531,4,-3.696>, <1.531,0,-3.696> }
		triangle { <3.85,0,-1.07>, <4,0,0>, <4,4,0> }
		triangle { <4,4,0>, <3.85,4,-1.07>, <3.85,0,-1.07> }
	}
}
#end

#declare _3626bp05_dot_dat = #if (QUAL = 0) box { <-13,-4,-13>, <13,24,13> } #else union {
	mesh {
		triangle { <-11.536,1.172,0>, <-13,4,0>, <-12.01,4,-4.975> }
		triangle { <-12.01,4,-4.975>, <-10.658,1.172,-4.415>, <-11.536,1.172,0> }
		triangle { <-10.658,1.172,-4.415>, <-12.01,4,-4.975>, <-9.192,4,-9.192> }
		triangle { <-9.192,4,-9.192>, <-8.157,1.172,-8.157>, <-10.658,1.172,-4.415> }
		triangle { <-8.157,1.172,-8.157>, <-9.192,4,-9.192>, <-4.975,4,-12.01> }
		triangle { <-4.975,4,-12.01>, <-4.415,1.172,-10.658>, <-8.157,1.172,-8.157> }
		triangle { <-4.415,1.172,-10.658>, <-4.975,4,-12.01>, <0,4,-13> }
		triangle { <0,4,-13>, <0,1.172,-11.536>, <-4.415,1.172,-10.658> }
		triangle { <0,1.172,-11.536>, <0,4,-13>, <4.975,4,-12.01> }
		triangle { <4.975,4,-12.01>, <4.415,1.172,-10.658>, <0,1.172,-11.536> }
		triangle { <4.415,1.172,-10.658>, <4.975,4,-12.01>, <9.192,4,-9.192> }
		triangle { <9.192,4,-9.192>, <8.157,1.172,-8.157>, <4.415,1.172,-10.658> }
		triangle { <8.157,1.172,-8.157>, <9.192,4,-9.192>, <12.01,4,-4.975> }
		triangle { <12.01,4,-4.975>, <10.658,1.172,-4.415>, <8.157,1.172,-8.157> }
		triangle { <10.658,1.172,-4.415>, <12.01,4,-4.975>, <13,4,0> }
		triangle { <13,4,0>, <11.536,1.172,0>, <10.658,1.172,-4.415> }
		triangle { <-13,4,0>, <-13,17,0>, <-12.01,17,-4.975> }
		triangle { <-12.01,17,-4.975>, <-12.01,4,-4.975>, <-13,4,0> }
		triangle { <-12.01,4,-4.975>, <-12.01,17,-4.975>, <-9.192,17,-9.192> }
		triangle { <-9.192,17,-9.192>, <-9.192,4,-9.192>, <-12.01,4,-4.975> }
		triangle { <-4.975,4,-12.01>, <-4.975,7.05,-12.01>, <-9.192,7.05,-9.192> }
		triangle { <-9.192,7.05,-9.192>, <-9.192,4,-9.192>, <-4.975,4,-12.01> }
		triangle { <-4.975,8.25,-12.01>, <-4.975,17,-12.01>, <-9.192,17,-9.192> }
		triangle { <-9.192,17,-9.192>, <-9.192,8.25,-9.192>, <-4.975,8.25,-12.01> }
	}
	mesh {
		triangle { <-4.975,7.05,-12.01>, <-4.975,7.8,-12.01>, <-5.6,8.25,-11.593> }
		triangle { <-5.6,8.25,-11.593>, <-6,7.7,-11.326>, <-4.975,7.05,-12.01> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-6,7.05,-11.326>, <-6,8.25,-11.326>, <-9.192,8.25,-9.193> }
		triangle { <-9.192,8.25,-9.193>, <-9.192,7.05,-9.193>, <-6,7.05,-11.326> }
		triangle { <-6,7.7,-11.326>, <-6,8.25,-11.326>, <-5.6,8.25,-11.593> }
		triangle { <-5.6,8.25,-11.593>, <-4.975,8.25,-12.01>, <-4.975,7.8,-12.01> }
		triangle { <-4.975,7.05,-12.01>, <-6,7.05,-11.326>, <-6,7.7,-11.326> }
		triangle { <-4.975,4,-12.01>, <-4.975,6.75,-12.01>, <0,6.75,-13> }
		triangle { <0,6.75,-13>, <0,4,-13>, <-4.975,4,-12.01> }
		triangle { <0,4,-13>, <0,6.75,-13>, <4.975,6.75,-12.01> }
		triangle { <4.975,6.75,-12.01>, <4.975,4,-12.01>, <0,4,-13> }
		triangle { <-4.975,8.25,-12.01>, <-4.975,8.75,-12.01>, <0,8.75,-13> }
		triangle { <0,8.75,-13>, <0,8.25,-13>, <-4.975,8.25,-12.01> }
		triangle { <0,8.25,-13>, <0,8.75,-13>, <4.975,8.75,-12.01> }
		triangle { <4.975,8.75,-12.01>, <4.975,8.25,-12.01>, <0,8.25,-13> }
	}
	mesh {
		triangle { <4.975,7.05,-12.01>, <4.975,7.8,-12.01>, <3.5,7.5,-12.304> }
		triangle { <3.5,7.5,-12.304>, <3.5,6.75,-12.304>, <4.975,7.05,-12.01> }
		triangle { <3.5,6.75,-12.304>, <3.5,7.5,-12.304>, <2.025,7.8,-12.597> }
		triangle { <2.025,7.8,-12.597>, <2.025,7.05,-12.597>, <3.5,6.75,-12.304> }
		triangle { <2.025,7.05,-12.597>, <2.025,7.8,-12.597>, <1.4,8.25,-12.722> }
		triangle { <1.4,8.25,-12.722>, <1,7.7,-12.801>, <2.025,7.05,-12.597> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <0,6.75,-13>, <0,8.25,-13>, <1,8.25,-12.801> }
		triangle { <1,8.25,-12.801>, <1,6.75,-12.801>, <0,6.75,-13> }
		triangle { <1,6.75,-12.801>, <1,7.7,-12.801>, <2.025,7.05,-12.597> }
		triangle { <2.025,7.05,-12.597>, <2.025,6.75,-12.597>, <1,6.75,-12.801> }
		triangle { <2.025,6.75,-12.597>, <2.025,7.05,-12.597>, <3.5,6.75,-12.304> }
		triangle { <3.5,6.75,-12.304>, <4.975,6.75,-12.01>, <4.975,7.05,-12.01> }
		triangle { <1,7.7,-12.801>, <1,8.25,-12.801>, <1.4,8.25,-12.722> }
		triangle { <1.4,8.25,-12.722>, <2.025,8.25,-12.597>, <2.025,7.8,-12.597> }
		triangle { <2.025,7.8,-12.597>, <2.025,8.25,-12.597>, <3.5,8.25,-12.304> }
		triangle { <3.5,8.25,-12.304>, <3.5,7.5,-12.304>, <2.025,7.8,-12.597> }
		triangle { <3.5,7.5,-12.304>, <3.5,8.25,-12.304>, <4.975,8.25,-12.01> }
		triangle { <4.975,8.25,-12.01>, <4.975,7.8,-12.01>, <3.5,7.5,-12.304> }
	}
	mesh {
		triangle { <-4.975,7.05,-12.01>, <-4.975,7.8,-12.01>, <-3.5,7.5,-12.304> }
		triangle { <-3.5,7.5,-12.304>, <-3.5,6.75,-12.304>, <-4.975,7.05,-12.01> }
		triangle { <-3.5,6.75,-12.304>, <-3.5,7.5,-12.304>, <-2.025,7.8,-12.597> }
		triangle { <-2.025,7.8,-12.597>, <-2.025,7.05,-12.597>, <-3.5,6.75,-12.304> }
		triangle { <-2.025,7.05,-12.597>, <-2.025,7.8,-12.597>, <-1.4,8.25,-12.722> }
		triangle { <-1.4,8.25,-12.722>, <-1,7.7,-12.801>, <-2.025,7.05,-12.597> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <0,6.75,-13>, <0,8.25,-13>, <-1,8.25,-12.801> }
		triangle { <-1,8.25,-12.801>, <-1,6.75,-12.801>, <0,6.75,-13> }
		triangle { <-1,6.75,-12.801>, <-1,7.7,-12.801>, <-2.025,7.05,-12.597> }
		triangle { <-2.025,7.05,-12.597>, <-2.025,6.75,-12.597>, <-1,6.75,-12.801> }
		triangle { <-2.025,6.75,-12.597>, <-2.025,7.05,-12.597>, <-3.5,6.75,-12.304> }
		triangle { <-3.5,6.75,-12.304>, <-4.975,6.75,-12.01>, <-4.975,7.05,-12.01> }
		triangle { <-1,7.7,-12.801>, <-1,8.25,-12.801>, <-1.4,8.25,-12.722> }
		triangle { <-1.4,8.25,-12.722>, <-2.025,8.25,-12.597>, <-2.025,7.8,-12.597> }
		triangle { <-2.025,7.8,-12.597>, <-2.025,8.25,-12.597>, <-3.5,8.25,-12.304> }
		triangle { <-3.5,8.25,-12.304>, <-3.5,7.5,-12.304>, <-2.025,7.8,-12.597> }
		triangle { <-3.5,7.5,-12.304>, <-3.5,8.25,-12.304>, <-4.975,8.25,-12.01> }
		triangle { <-4.975,8.25,-12.01>, <-4.975,7.8,-12.01>, <-3.5,7.5,-12.304> }
		triangle { <4.75,8.75,-12.055>, <4.975,8.75,-12.01>, <4.975,11.25,-12.01> }
		triangle { <4.975,11.25,-12.01>, <4.75,11.25,-12.055>, <4.75,8.75,-12.055> }
	}
	object { _4_dash_4disc_dot_dat matrix <1.25,0,0.244,0.244,0,1,0,-1.25,0,3.5,10,-12.304> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4ndis_dot_dat matrix <1.25,0,0.244,0.244,0,1,0,-1.25,0,3.5,10,-12.304> }
	mesh {
		triangle { <0,8.75,-13>, <2.25,8.75,-12.552>, <2.25,11.25,-12.552> }
		triangle { <2.25,11.25,-12.552>, <0,11.25,-13>, <0,8.75,-13> }
		triangle { <0,8.75,-13>, <-2.25,8.75,-12.552>, <-2.25,11.25,-12.552> }
		triangle { <-2.25,11.25,-12.552>, <0,11.25,-13>, <0,8.75,-13> }
	}
	object { _4_dash_4disc_dot_dat matrix <1.25,0,-0.244,-0.244,0,1,0,-1.25,0,-3.5,10,-12.304> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { _4_dash_4ndis_dot_dat matrix <1.25,0,-0.244,-0.244,0,1,0,-1.25,0,-3.5,10,-12.304> }
	mesh {
		triangle { <-4.75,8.75,-12.055>, <-4.975,8.75,-12.01>, <-4.975,11.25,-12.01> }
		triangle { <-4.975,11.25,-12.01>, <-4.75,11.25,-12.055>, <-4.75,8.75,-12.055> }
		triangle { <-4.975,11.25,-12.01>, <-4.975,14.2,-12.01>, <0,14.2,-13> }
		triangle { <0,14.2,-13>, <0,11.25,-13>, <-4.975,11.25,-12.01> }
		triangle { <0,11.25,-13>, <0,14.2,-13>, <4.975,14.2,-12.01> }
		triangle { <4.975,14.2,-12.01>, <4.975,11.25,-12.01>, <0,11.25,-13> }
		triangle { <0,15,-13>, <0,14.2,-13>, <1.75,14.2,-12.652> }
		triangle { <1.75,14.2,-12.652>, <1.75,14.75,-12.652>, <0,15,-13> }
		triangle { <1.75,14.75,-12.652>, <1.75,14.2,-12.652>, <3,14.2,-12.403> }
		triangle { <3,14.2,-12.403>, <3.5,14.5,-12.304>, <3.5,14.2,-12.304> }
		triangle { <3.5,14.2,-12.304>, <4.975,14.2,-12.01>, <4.975,16,-12.01> }
		triangle { <4.975,16,-12.01>, <3.5,16,-12.304>, <3.5,14.2,-12.304> }
		triangle { <3.5,15,-12.304>, <4.975,16,-12.01>, <1.75,16,-12.652> }
		triangle { <1.75,16,-12.652>, <1.75,15.75,-12.652>, <3.5,15,-12.304> }
		triangle { <1.75,15.75,-12.652>, <1.75,16,-12.652>, <0,16,-13> }
	}
	mesh {
		triangle { <0,16,-13>, <0,15,-13>, <1.75,14.75,-12.652> }
		triangle { <1.75,14.75,-12.652>, <1.75,15.75,-12.652>, <0,16,-13> }
		triangle { <1.75,15.75,-12.652>, <1.75,14.75,-12.652>, <3,14.2,-12.403> }
		triangle { <3,14.2,-12.403>, <3.5,15,-12.304>, <1.75,15.75,-12.652> }
		triangle { <3.5,15,-12.304>, <3,14.2,-12.403>, <3.5,14.5,-12.304> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <0,15,-13>, <0,14.2,-13>, <-1.75,14.2,-12.652> }
		triangle { <-1.75,14.2,-12.652>, <-1.75,14.75,-12.652>, <0,15,-13> }
		triangle { <-1.75,14.75,-12.652>, <-1.75,14.2,-12.652>, <-3,14.2,-12.403> }
		triangle { <-3,14.2,-12.403>, <-3.5,14.5,-12.304>, <-3.5,14.2,-12.304> }
		triangle { <-3.5,14.2,-12.304>, <-4.975,14.2,-12.01>, <-4.975,16,-12.01> }
		triangle { <-4.975,16,-12.01>, <-3.5,16,-12.304>, <-3.5,14.2,-12.304> }
		triangle { <-3.5,15,-12.304>, <-4.975,16,-12.01>, <-1.75,16,-12.652> }
		triangle { <-1.75,16,-12.652>, <-1.75,15.75,-12.652>, <-3.5,15,-12.304> }
		triangle { <-1.75,15.75,-12.652>, <-1.75,16,-12.652>, <0,16,-13> }
	}
	mesh {
		triangle { <0,16,-13>, <0,15,-13>, <-1.75,14.75,-12.652> }
		triangle { <-1.75,14.75,-12.652>, <-1.75,15.75,-12.652>, <0,16,-13> }
		triangle { <-1.75,15.75,-12.652>, <-1.75,14.75,-12.652>, <-3,14.2,-12.403> }
		triangle { <-3,14.2,-12.403>, <-3.5,15,-12.304>, <-1.75,15.75,-12.652> }
		triangle { <-3.5,15,-12.304>, <-3,14.2,-12.403>, <-3.5,14.5,-12.304> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <-4.975,16,-12.01>, <-4.975,17,-12.01>, <0,17,-13> }
		triangle { <0,17,-13>, <0,16,-13>, <-4.975,16,-12.01> }
		triangle { <0,16,-13>, <0,17,-13>, <4.975,17,-12.01> }
		triangle { <4.975,17,-12.01>, <4.975,16,-12.01>, <0,16,-13> }
		triangle { <4.975,4,-12.01>, <4.975,7.05,-12.01>, <9.192,7.05,-9.192> }
		triangle { <9.192,7.05,-9.192>, <9.192,4,-9.192>, <4.975,4,-12.01> }
		triangle { <4.975,8.25,-12.01>, <4.975,17,-12.01>, <9.192,17,-9.192> }
		triangle { <9.192,17,-9.192>, <9.192,8.25,-9.192>, <4.975,8.25,-12.01> }
	}
	mesh {
		triangle { <4.975,7.05,-12.01>, <4.975,7.8,-12.01>, <5.6,8.25,-11.593> }
		triangle { <5.6,8.25,-11.593>, <6,7.7,-11.326>, <4.975,7.05,-12.01> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	mesh {
		triangle { <6,7.05,-11.326>, <6,8.25,-11.326>, <9.192,8.25,-9.193> }
		triangle { <9.192,8.25,-9.193>, <9.192,7.05,-9.193>, <6,7.05,-11.326> }
		triangle { <6,7.7,-11.326>, <6,8.25,-11.326>, <5.6,8.25,-11.593> }
		triangle { <5.6,8.25,-11.593>, <4.975,8.25,-12.01>, <4.975,7.8,-12.01> }
		triangle { <4.975,7.05,-12.01>, <6,7.05,-11.326>, <6,7.7,-11.326> }
		triangle { <9.192,4,-9.192>, <9.192,17,-9.192>, <12.01,17,-4.975> }
		triangle { <12.01,17,-4.975>, <12.01,4,-4.975>, <9.192,4,-9.192> }
		triangle { <12.01,4,-4.975>, <12.01,17,-4.975>, <13,17,0> }
		triangle { <13,17,0>, <13,4,0>, <12.01,4,-4.975> }
		triangle { <-11.536,19.828,0>, <-13,17,0>, <-12.01,17,-4.975> }
		triangle { <-12.01,17,-4.975>, <-10.658,19.828,-4.415>, <-11.536,19.828,0> }
		triangle { <-10.658,19.828,-4.415>, <-12.01,17,-4.975>, <-9.192,17,-9.192> }
		triangle { <-9.192,17,-9.192>, <-8.157,19.828,-8.157>, <-10.658,19.828,-4.415> }
		triangle { <-8.157,19.828,-8.157>, <-9.192,17,-9.192>, <-4.975,17,-12.01> }
		triangle { <-4.975,17,-12.01>, <-4.415,19.828,-10.658>, <-8.157,19.828,-8.157> }
		triangle { <-4.415,19.828,-10.658>, <-4.975,17,-12.01>, <0,17,-13> }
		triangle { <0,17,-13>, <0,19.828,-11.536>, <-4.415,19.828,-10.658> }
		triangle { <0,19.828,-11.536>, <0,17,-13>, <4.975,17,-12.01> }
		triangle { <4.975,17,-12.01>, <4.415,19.828,-10.658>, <0,19.828,-11.536> }
		triangle { <4.415,19.828,-10.658>, <4.975,17,-12.01>, <9.192,17,-9.192> }
		triangle { <9.192,17,-9.192>, <8.157,19.828,-8.157>, <4.415,19.828,-10.658> }
		triangle { <8.157,19.828,-8.157>, <9.192,17,-9.192>, <12.01,17,-4.975> }
		triangle { <12.01,17,-4.975>, <10.658,19.828,-4.415>, <8.157,19.828,-8.157> }
		triangle { <10.658,19.828,-4.415>, <12.01,17,-4.975>, <13,17,0> }
		triangle { <13,17,0>, <11.536,19.828,0>, <10.658,19.828,-4.415> }
	}
	object { s_slash_3626bs01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
}
#end

#declare stud4_dot_dat = difference {
	cylinder { <0,0,0>, <0,-4,0>, 8 }
	cylinder { <0,0.01,0>, <0,-4.01,0>, 6 }
}

#declare _2446_dot_dat = #if (QUAL = 0) box { <-16.5,-8,-18.5>, <16.5,26.615,16> } #else union {
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,-4,0> }
	#end
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,-4,0> }
	mesh {
		triangle { <12.01,3,4.975>, <7.391,-4,3.061>, <5.657,-4,5.657> }
		triangle { <5.657,-4,5.657>, <9.192,3,9.192>, <12.01,3,4.975> }
		triangle { <9.192,3,9.192>, <5.657,-4,5.657>, <3.061,-4,7.391> }
		triangle { <3.061,-4,7.391>, <4.975,3,12.01>, <9.192,3,9.192> }
		triangle { <4.975,3,12.01>, <3.061,-4,7.391>, <0,-4,8> }
		triangle { <0,-4,8>, <0,3,13>, <4.975,3,12.01> }
		triangle { <0,3,13>, <0,-4,8>, <-3.061,-4,7.391> }
		triangle { <-3.061,-4,7.391>, <-4.975,3,12.01>, <0,3,13> }
		triangle { <-4.975,3,12.01>, <-3.061,-4,7.391>, <-5.657,-4,5.657> }
		triangle { <-5.657,-4,5.657>, <-9.192,3,9.192>, <-4.975,3,12.01> }
		triangle { <-9.192,3,9.192>, <-5.657,-4,5.657>, <-7.391,-4,3.061> }
		triangle { <-7.391,-4,3.061>, <-12.01,3,4.975>, <-9.192,3,9.192> }
		triangle { <-12.01,3,4.975>, <-7.391,-4,3.061>, <-8,-4,0> }
		triangle { <-8,-4,0>, <-13,3,0>, <-12.01,3,4.975> }
		triangle { <-13,3,0>, <-8,-4,0>, <-7.391,-4,-3.061> }
		triangle { <-7.391,-4,-3.061>, <-12.01,3,-4.975>, <-13,3,0> }
		triangle { <-12.01,3,-4.975>, <-7.391,-4,-3.061>, <-5.657,-4,-5.657> }
		triangle { <-5.657,-4,-5.657>, <-9.192,3,-9.192>, <-12.01,3,-4.975> }
		triangle { <-9.192,3,-9.192>, <-5.657,-4,-5.657>, <-3.061,-4,-7.391> }
		triangle { <-3.061,-4,-7.391>, <-4.975,3,-12.01>, <-9.192,3,-9.192> }
		triangle { <-4.975,3,-12.01>, <-3.061,-4,-7.391>, <0,-4,-8> }
		triangle { <0,-4,-8>, <0,3,-13>, <-4.975,3,-12.01> }
		triangle { <0,3,-13>, <0,-4,-8>, <3.061,-4,-7.391> }
		triangle { <3.061,-4,-7.391>, <4.975,3,-12.01>, <0,3,-13> }
		triangle { <4.975,3,-12.01>, <3.061,-4,-7.391>, <5.657,-4,-5.657> }
		triangle { <5.657,-4,-5.657>, <9.192,3,-9.192>, <4.975,3,-12.01> }
		triangle { <9.192,3,-9.192>, <5.657,-4,-5.657>, <7.391,-4,-3.062> }
		triangle { <7.391,-4,-3.062>, <12.01,3,-4.975>, <9.192,3,-9.192> }
		triangle { <12.01,3,-4.975>, <7.391,-4,-3.062>, <8,-4,0> }
		triangle { <8,-4,0>, <13,3,0>, <12.01,3,-4.975> }
		triangle { <13,3,0>, <8,-4,0>, <7.391,-4,3.061> }
		triangle { <7.391,-4,3.061>, <12.01,3,4.975>, <13,3,0> }
	}
	object { _4_dash_4cyli_dot_dat matrix <13,0,0,0,4,0,0,0,13,0,3,0> }
	object { _2_dash_4cyli_dot_dat matrix <13,0,0,0,15,0,0,0,13,0,7,0> }
	mesh {
		triangle { <0,22,13>, <4.975,22,12.01>, <4.975,22.152,12.01> }
		triangle { <4.975,22,12.01>, <9.192,22,9.192>, <9.192,22.586,9.192> }
		triangle { <9.192,22.586,9.192>, <4.975,22.152,12.01>, <4.975,22,12.01> }
		triangle { <9.192,22,9.192>, <12.01,22,4.975>, <12.01,23.262,4.975> }
		triangle { <12.01,23.262,4.975>, <9.192,22.586,9.192>, <9.192,22,9.192> }
		triangle { <12.01,22,4.975>, <13,22,0>, <13,24,0> }
		triangle { <13,24,0>, <12.01,23.262,4.975>, <12.01,22,4.975> }
		triangle { <-12.01,22,4.975>, <-13,22,0>, <-13,24,0> }
		triangle { <-13,24,0>, <-12.01,23.262,4.975>, <-12.01,22,4.975> }
		triangle { <-9.192,22,9.192>, <-12.01,22,4.975>, <-12.01,23.262,4.975> }
		triangle { <-12.01,23.262,4.975>, <-9.192,22.586,9.192>, <-9.192,22,9.192> }
		triangle { <-4.975,22,12.01>, <-9.192,22,9.192>, <-9.192,22.586,9.192> }
		triangle { <-9.192,22.586,9.192>, <-4.975,22.152,12.01>, <-4.975,22,12.01> }
		triangle { <0,22,13>, <-4.975,22,12.01>, <-4.975,22.152,12.01> }
		triangle { <11.267,7.381,-6.087>, <9.989,7,-8>, <12.01,7,-4.975> }
		triangle { <12.01,7,-4.975>, <12.01,7.381,-4.975>, <11.267,7.381,-6.087> }
		triangle { <11.267,7.381,-6.087>, <12.01,7.381,-4.975>, <12.01,7.722,-4.975> }
		triangle { <12.01,7.722,-4.975>, <12.01,7,-4.795>, <12.112,7,-4.646> }
		triangle { <12.112,7,-4.646>, <12.112,8.464,-4.464>, <12.01,7.722,-4.975> }
		triangle { <12.112,8.464,-4.464>, <12.112,7,-4.646>, <13,7,0> }
		triangle { <13,7,0>, <13,8.464,0>, <12.112,8.464,-4.464> }
		triangle { <12.112,8.464,-4.464>, <12.327,10.087,-3.381>, <13,10.087,0> }
		triangle { <13,10.087,0>, <13,8.464,0>, <12.112,8.464,-4.464> }
		triangle { <12.327,10.087,-3.381>, <12.403,12,-3>, <13,12,0> }
		triangle { <13,12,0>, <13,10.087,0>, <12.327,10.087,-3.381> }
		triangle { <12.403,12,-3>, <12.105,14.823,-4.5>, <13,14.823,0> }
		triangle { <13,14.823,0>, <13,12,0>, <12.403,12,-3> }
		triangle { <-12.403,12,-3>, <-12.105,14.823,-4.5>, <-13,14.823,0> }
		triangle { <-13,14.823,0>, <-13,12,0>, <-12.403,12,-3> }
		triangle { <-12.327,10.087,-3.381>, <-12.403,12,-3>, <-13,12,0> }
		triangle { <-13,12,0>, <-13,10.087,0>, <-12.327,10.087,-3.381> }
		triangle { <-12.112,8.464,-4.464>, <-12.327,10.087,-3.381>, <-13,10.087,0> }
		triangle { <-13,10.087,0>, <-13,8.464,0>, <-12.112,8.464,-4.464> }
		triangle { <-12.112,8.464,-4.464>, <-12.112,7,-4.646>, <-13,7,0> }
		triangle { <-13,7,0>, <-13,8.464,0>, <-12.112,8.464,-4.464> }
		triangle { <-12.01,7.722,-4.975>, <-12.01,7,-4.795>, <-12.112,7,-4.646> }
		triangle { <-12.112,7,-4.646>, <-12.112,8.464,-4.464>, <-12.01,7.722,-4.975> }
		triangle { <-11.267,7.381,-6.087>, <-12.01,7.381,-4.975>, <-12.01,7.722,-4.975> }
		triangle { <-11.267,7.381,-6.087>, <-9.989,7,-8>, <-12.01,7,-4.975> }
		triangle { <-12.01,7,-4.975>, <-12.01,7.381,-4.975>, <-11.267,7.381,-6.087> }
		triangle { <13,15.027,0>, <12.01,15.027,-4.975>, <12.105,14.823,-4.5> }
		triangle { <12.105,14.823,-4.5>, <13,14.823,0>, <13,15.027,0> }
		triangle { <13,15.027,0>, <12.01,15.027,-4.975>, <12.01,24.738,-4.795> }
		triangle { <12.01,24.738,-4.795>, <13,24,0>, <13,15.027,0> }
		triangle { <12.01,15.027,-4.975>, <9.192,16.833,-9.192>, <9.192,25.414,-9.192> }
		triangle { <9.192,25.414,-9.192>, <12.01,24.738,-4.795>, <12.01,15.027,-4.975> }
		triangle { <9.192,16.833,-9.192>, <4.975,18.041,-12.01>, <4.975,25.848,-12.01> }
		triangle { <4.975,25.848,-12.01>, <9.192,25.414,-9.192>, <9.192,16.833,-9.192> }
		triangle { <4.975,18.041,-12.01>, <0,18.465,-13>, <0,26,-13> }
		triangle { <0,26,-13>, <4.975,25.848,-12.01>, <4.975,18.041,-12.01> }
		triangle { <-4.975,18.041,-12.01>, <0,18.465,-13>, <0,26,-13> }
		triangle { <0,26,-13>, <-4.975,25.848,-12.01>, <-4.975,18.041,-12.01> }
		triangle { <-9.192,16.833,-9.192>, <-4.975,18.041,-12.01>, <-4.975,25.848,-12.01> }
		triangle { <-4.975,25.848,-12.01>, <-9.192,25.414,-9.192>, <-9.192,16.833,-9.192> }
		triangle { <-12.01,15.027,-4.975>, <-9.192,16.833,-9.192>, <-9.192,25.414,-9.192> }
		triangle { <-9.192,25.414,-9.192>, <-12.01,24.738,-4.795>, <-12.01,15.027,-4.975> }
		triangle { <-13,15.027,0>, <-12.01,15.027,-4.975>, <-12.01,24.738,-4.795> }
		triangle { <-12.01,24.738,-4.795>, <-13,24,0>, <-13,15.027,0> }
		triangle { <-13,15.027,0>, <-12.01,15.027,-4.975>, <-12.105,14.823,-4.5> }
		triangle { <-12.105,14.823,-4.5>, <-13,14.823,0>, <-13,15.027,0> }
		triangle { <6.123,-6.782,0>, <0,-8,0>, <5.848,-6.782,2.343> }
		triangle { <5.848,-6.782,2.343>, <0,-8,0>, <4.33,-6.782,4.33> }
		triangle { <4.33,-6.782,4.33>, <0,-8,0>, <2.343,-6.782,5.848> }
		triangle { <2.343,-6.782,5.848>, <0,-8,0>, <0,-6.782,6.123> }
		triangle { <0,-6.782,6.123>, <0,-8,0>, <-2.343,-6.782,5.848> }
		triangle { <-2.343,-6.782,5.848>, <0,-8,0>, <-4.33,-6.782,4.33> }
		triangle { <-4.33,-6.782,4.33>, <0,-8,0>, <-5.848,-6.782,2.343> }
		triangle { <-5.848,-6.782,2.343>, <0,-8,0>, <-6.123,-6.782,0> }
		triangle { <11.314,-3.314,0>, <6.123,-6.782,0>, <5.848,-6.782,2.343> }
		triangle { <5.848,-6.782,2.343>, <10.453,-3.314,4.33>, <11.314,-3.314,0> }
		triangle { <10.453,-3.314,4.33>, <5.848,-6.782,2.343>, <4.33,-6.782,4.33> }
		triangle { <4.33,-6.782,4.33>, <8,-3.314,8>, <10.453,-3.314,4.33> }
		triangle { <8,-3.314,8>, <4.33,-6.782,4.33>, <2.343,-6.782,5.848> }
		triangle { <2.343,-6.782,5.848>, <4.33,-3.314,10.453>, <8,-3.314,8> }
		triangle { <4.33,-3.314,10.453>, <2.343,-6.782,5.848>, <0,-6.782,6.123> }
		triangle { <0,-6.782,6.123>, <0,-3.314,11.314>, <4.33,-3.314,10.453> }
		triangle { <0,-3.314,11.314>, <0,-6.782,6.123>, <-2.343,-6.782,5.848> }
		triangle { <-2.343,-6.782,5.848>, <-4.33,-3.314,10.453>, <0,-3.314,11.314> }
		triangle { <-4.33,-3.314,10.453>, <-2.343,-6.782,5.848>, <-4.33,-6.782,4.33> }
		triangle { <-4.33,-6.782,4.33>, <-8,-3.314,8>, <-4.33,-3.314,10.453> }
		triangle { <-8,-3.314,8>, <-4.33,-6.782,4.33>, <-5.848,-6.782,2.343> }
		triangle { <-5.848,-6.782,2.343>, <-10.453,-3.314,4.33>, <-8,-3.314,8> }
		triangle { <-10.453,-3.314,4.33>, <-5.848,-6.782,2.343>, <-6.123,-6.782,0> }
		triangle { <-6.123,-6.782,0>, <-11.314,-3.314,0>, <-10.453,-3.314,4.33> }
		triangle { <11.314,-3.314,0>, <14.5,1.877,0>, <14.5,1.877,2.5> }
		triangle { <11.314,-3.314,0>, <13.657,1.877,5.848>, <14.5,1.877,2.5> }
		triangle { <11.314,-3.314,0>, <13.657,1.877,5.848>, <10.453,-3.314,4.33> }
		triangle { <13.657,1.877,5.848>, <10.453,-3.314,4.33>, <8,-3.314,8> }
		triangle { <8,-3.314,8>, <10.452,1.877,10.452>, <13.657,1.877,5.848> }
		triangle { <10.452,1.877,10.452>, <8,-3.314,8>, <4.33,-3.314,10.453> }
		triangle { <4.33,-3.314,10.453>, <5.848,1.877,13.657>, <10.452,1.877,10.452> }
		triangle { <5.848,1.877,13.657>, <4.33,-3.314,10.453>, <0,-3.314,11.314> }
		triangle { <0,-3.314,11.314>, <0,1.877,14.782>, <5.848,1.877,13.657> }
		triangle { <0,1.877,14.782>, <0,-3.314,11.314>, <-4.33,-3.314,10.453> }
		triangle { <-4.33,-3.314,10.453>, <-5.848,1.877,13.657>, <0,1.877,14.782> }
		triangle { <-5.848,1.877,13.657>, <-4.33,-3.314,10.453>, <-8,-3.314,8> }
		triangle { <-8,-3.314,8>, <-10.452,1.877,10.452>, <-5.848,1.877,13.657> }
		triangle { <-10.452,1.877,10.452>, <-8,-3.314,8>, <-10.453,-3.314,4.33> }
		triangle { <-10.453,-3.314,4.33>, <-13.657,1.877,5.848>, <-10.452,1.877,10.452> }
		triangle { <-11.314,-3.314,0>, <-13.657,1.877,5.848>, <-10.453,-3.314,4.33> }
		triangle { <-11.314,-3.314,0>, <-13.657,1.877,5.848>, <-14.5,1.877,2.5> }
		triangle { <-11.314,-3.314,0>, <-14.5,1.877,0>, <-14.5,1.877,2.5> }
		triangle { <13.657,1.877,5.848>, <15.356,6.278,4.157>, <14.5,1.877,2.5> }
		triangle { <14.782,8,6.123>, <15.356,6.278,4.157>, <15.691,8,4.5> }
		triangle { <14.782,8,6.123>, <13.657,1.877,5.848>, <15.356,6.278,4.157> }
		triangle { <14.782,8,6.123>, <13.657,1.877,5.848>, <10.452,1.877,10.452> }
		triangle { <10.452,1.877,10.452>, <11.314,8,11.314>, <14.782,8,6.123> }
		triangle { <11.314,8,11.314>, <10.452,1.877,10.452>, <5.848,1.877,13.657> }
		triangle { <5.848,1.877,13.657>, <6.123,8,14.782>, <11.314,8,11.314> }
		triangle { <6.123,8,14.782>, <5.848,1.877,13.657>, <0,1.877,14.782> }
		triangle { <0,1.877,14.782>, <0,8,16>, <6.123,8,14.782> }
		triangle { <0,8,16>, <0,1.877,14.782>, <-5.848,1.877,13.657> }
		triangle { <-5.848,1.877,13.657>, <-6.123,8,14.782>, <0,8,16> }
		triangle { <-6.123,8,14.782>, <-5.848,1.877,13.657>, <-10.452,1.877,10.452> }
		triangle { <-10.452,1.877,10.452>, <-11.314,8,11.314>, <-6.123,8,14.782> }
		triangle { <-11.314,8,11.314>, <-10.452,1.877,10.452>, <-13.657,1.877,5.848> }
		triangle { <-13.657,1.877,5.848>, <-14.782,8,6.123>, <-11.314,8,11.314> }
		triangle { <-14.782,8,6.123>, <-13.657,1.877,5.848>, <-15.356,6.278,4.157> }
		triangle { <-14.782,8,6.123>, <-15.356,6.278,4.157>, <-15.691,8,4.5> }
		triangle { <-13.657,1.877,5.848>, <-15.356,6.278,4.157>, <-14.5,1.877,2.5> }
		triangle { <14.119,14.123,5.848>, <16.31,11.182,3.182>, <16.5,12.157,1.722> }
		triangle { <14.119,14.123,5.848>, <16.026,9.722,4.157>, <16.31,11.182,3.182> }
		triangle { <15.282,8,6.123>, <16.026,9.722,4.157>, <15.691,8,4.5> }
		triangle { <15.282,8,6.123>, <14.119,14.123,5.848>, <16.026,9.722,4.157> }
		triangle { <15.282,8,6.123>, <14.119,14.123,5.848>, <10.806,14.123,10.806> }
		triangle { <10.806,14.123,10.806>, <11.314,8,11.314>, <15.282,8,6.123> }
		triangle { <11.314,8,11.314>, <10.806,14.123,10.806>, <5.848,14.123,14.119> }
		triangle { <5.848,14.123,14.119>, <6.123,8,15.282>, <11.314,8,11.314> }
		triangle { <6.123,8,15.282>, <5.848,14.123,14.119>, <0,14.123,15.282> }
		triangle { <0,14.123,15.282>, <0,8,16>, <6.123,8,15.282> }
		triangle { <0,8,16>, <0,14.123,15.282>, <-5.848,14.123,14.119> }
		triangle { <-5.848,14.123,14.119>, <-6.123,8,15.282>, <0,8,16> }
		triangle { <-6.123,8,15.282>, <-5.848,14.123,14.119>, <-10.806,14.123,10.806> }
		triangle { <-10.806,14.123,10.806>, <-11.314,8,11.314>, <-6.123,8,15.282> }
		triangle { <-11.314,8,11.314>, <-10.806,14.123,10.806>, <-14.119,14.123,5.848> }
		triangle { <-14.119,14.123,5.848>, <-15.282,8,6.123>, <-11.314,8,11.314> }
		triangle { <-15.282,8,6.123>, <-14.119,14.123,5.848>, <-16.026,9.722,4.157> }
		triangle { <-15.282,8,6.123>, <-16.026,9.722,4.157>, <-15.691,8,4.5> }
		triangle { <-14.119,14.123,5.848>, <-16.026,9.722,4.157>, <-16.31,11.182,3.182> }
		triangle { <-14.119,14.123,5.848>, <-16.31,11.182,3.182>, <-16.5,12.157,1.722> }
		triangle { <-6.123,-6.782,0>, <0,-8,0>, <-5.848,-6.782,-2.87> }
		triangle { <-5.848,-6.782,-2.87>, <0,-8,0>, <-4.33,-6.782,-5.303> }
		triangle { <-4.33,-6.782,-5.303>, <0,-8,0>, <-2.343,-6.782,-6.929> }
		triangle { <-2.343,-6.782,-6.929>, <0,-8,0>, <0,-6.782,-7.5> }
		triangle { <0,-6.782,-7.5>, <0,-8,0>, <2.343,-6.782,-6.929> }
		triangle { <2.343,-6.782,-6.929>, <0,-8,0>, <4.33,-6.782,-5.303> }
		triangle { <4.33,-6.782,-5.303>, <0,-8,0>, <5.848,-6.782,-2.87> }
		triangle { <5.848,-6.782,-2.87>, <0,-8,0>, <6.123,-6.782,0> }
		triangle { <-11.314,-3.314,0>, <-6.123,-6.782,0>, <-5.848,-6.782,-2.87> }
		triangle { <-5.848,-6.782,-2.87>, <-10.453,-3.314,-4.822>, <-11.314,-3.314,0> }
		triangle { <-10.453,-3.314,-4.822>, <-5.848,-6.782,-2.87>, <-4.33,-6.782,-5.3> }
		triangle { <-4.33,-6.782,-5.3>, <-8,-3.314,-8.91>, <-10.453,-3.314,-4.822> }
		triangle { <-8,-3.314,-8.91>, <-4.33,-6.782,-5.303>, <-2.343,-6.782,-6.929> }
		triangle { <-2.343,-6.782,-6.929>, <-4.33,-3.314,-11.641>, <-8,-3.314,-8.91> }
		triangle { <-4.33,-3.314,-11.641>, <-2.343,-6.782,-6.929>, <0,-6.782,-7.5> }
		triangle { <0,-6.782,-7.5>, <0,-3.314,-12.6>, <-4.33,-3.314,-11.641> }
		triangle { <0,-3.314,-12.6>, <0,-6.782,-7.5>, <2.343,-6.782,-6.929> }
		triangle { <2.343,-6.782,-6.929>, <4.33,-3.314,-11.641>, <0,-3.314,-12.6> }
		triangle { <4.33,-3.314,-11.641>, <2.343,-6.782,-6.929>, <4.33,-6.782,-5.3> }
		triangle { <4.33,-6.782,-5.3>, <8,-3.314,-8.91>, <4.33,-3.314,-11.641> }
		triangle { <8,-3.314,-8.91>, <4.33,-6.782,-5.303>, <5.848,-6.782,-2.87> }
		triangle { <5.848,-6.782,-2.87>, <10.453,-3.314,-4.822>, <8,-3.314,-8.91> }
		triangle { <10.453,-3.314,-4.822>, <5.848,-6.782,-2.87>, <6.123,-6.782,0> }
		triangle { <6.123,-6.782,0>, <11.314,-3.314,0>, <10.453,-3.314,-4.822> }
		triangle { <-11.314,-3.314,0>, <-14.119,1.877,-6.123>, <-14.5,1.877,0> }
		triangle { <-11.314,-3.314,0>, <-14.119,1.877,-6.123>, <-10.453,-3.314,-4.822> }
		triangle { <-14.119,1.877,-6.123>, <-10.453,-3.314,-4.822>, <-8,-3.314,-8.91> }
		triangle { <-8,-3.314,-8.91>, <-10.806,1.877,-11.314>, <-14.119,1.877,-6.123> }
		triangle { <-10.806,1.877,-11.314>, <-8,-3.314,-8.91>, <-4.33,-3.314,-11.641> }
		triangle { <-4.33,-3.314,-11.641>, <-5.848,1.877,-15.282>, <-10.806,1.877,-11.314> }
		triangle { <-5.848,1.877,-15.282>, <-4.33,-3.314,-11.641>, <0,-3.314,-12.6> }
		triangle { <0,-3.314,-12.6>, <0,1.877,-16>, <-5.848,1.877,-15.282> }
		triangle { <0,1.877,-16>, <0,-3.314,-12.6>, <4.33,-3.314,-11.641> }
		triangle { <4.33,-3.314,-11.641>, <5.848,1.877,-15.282>, <0,1.877,-16> }
		triangle { <5.848,1.877,-15.282>, <4.33,-3.314,-11.641>, <8,-3.314,-8.91> }
		triangle { <8,-3.314,-8.91>, <10.806,1.877,-11.314>, <5.848,1.877,-15.282> }
		triangle { <10.806,1.877,-11.314>, <8,-3.314,-8.91>, <10.453,-3.314,-4.822> }
		triangle { <10.453,-3.314,-4.822>, <14.119,1.877,-6.123>, <10.806,1.877,-11.314> }
		triangle { <11.314,-3.314,0>, <14.119,1.877,-6.123>, <10.453,-3.314,-4.822> }
		triangle { <11.314,-3.314,0>, <14.119,1.877,-6.123>, <14.5,1.877,0> }
		triangle { <-14.119,1.877,-6.123>, <-14.5,7,-8>, <-14.5,1.877,2.5> }
		triangle { <-14.119,1.877,-6.123>, <-10.607,7,-12.021>, <-14.5,7,-8> }
		triangle { <-10.806,1.877,-11.314>, <-10.607,7,-12.021>, <-14.119,1.877,-6.123> }
		triangle { <-10.607,7,-12.021>, <-10.806,1.877,-11.314>, <-5.848,1.877,-15.282> }
		triangle { <-5.848,1.877,-15.282>, <-5.74,7,-15.706>, <-10.607,7,-12.021> }
		triangle { <-5.74,7,-15.706>, <-5.848,1.877,-15.282>, <0,1.877,-16> }
		triangle { <0,1.877,-16>, <0,7,-17>, <-5.74,7,-15.706> }
		triangle { <0,7,-17>, <0,1.877,-16>, <5.848,1.877,-15.282> }
		triangle { <5.848,1.877,-15.282>, <5.74,7,-15.706>, <0,7,-17> }
		triangle { <5.74,7,-15.706>, <5.848,1.877,-15.282>, <10.806,1.877,-11.314> }
		triangle { <10.806,1.877,-11.314>, <10.607,7,-12.021>, <5.74,7,-15.706> }
		triangle { <10.806,1.877,-11.314>, <10.607,7,-12.021>, <14.119,1.877,-6.123> }
		triangle { <14.119,1.877,-6.123>, <10.607,7,-12.021>, <14.5,7,-8> }
		triangle { <14.119,1.877,-6.123>, <14.5,7,-8>, <14.5,1.877,2.5> }
		triangle { <9.192,22.586,9.192>, <4.975,22.152,12.01>, <5.74,22.176,11.858> }
		triangle { <5.74,22.176,11.858>, <10.607,22.676,8.607>, <9.192,22.586,9.192> }
		triangle { <12.01,23.262,4.975>, <9.192,22.586,9.192>, <10.607,22.676,8.607> }
		triangle { <10.607,22.676,8.607>, <13.858,23.425,3.74>, <12.01,23.262,4.975> }
		triangle { <13,24,0>, <12.01,23.262,4.975>, <13.858,23.425,3.74> }
		triangle { <13.858,23.425,3.74>, <15,24.308,-2>, <13,24,0> }
		triangle { <12.01,24.738,-4.795>, <13,24,0>, <15,24.308,-2> }
		triangle { <15,24.308,-2>, <13.858,25.191,-7.74>, <12.01,24.738,-4.795> }
		triangle { <9.192,25.414,-9.192>, <12.01,24.738,-4.795>, <13.858,25.191,-7.74> }
		triangle { <13.858,25.191,-7.74>, <10.607,25.939,-12.607>, <9.192,25.414,-9.192> }
		triangle { <4.975,25.848,-12.01>, <9.192,25.414,-9.192>, <10.607,25.939,-12.607> }
		triangle { <10.607,25.939,-12.607>, <5.74,26.44,-15.858>, <4.975,25.848,-12.01> }
		triangle { <0,26,-13>, <4.975,25.848,-12.01>, <5.74,26.44,-15.858> }
		triangle { <5.74,26.44,-15.858>, <0,26.615,-17>, <0,26,-13> }
		triangle { <0,26,-13>, <-4.975,25.848,-12.01>, <-5.74,26.44,-15.858> }
		triangle { <-5.74,26.44,-15.858>, <0,26.615,-17>, <0,26,-13> }
		triangle { <-4.975,25.848,-12.01>, <-9.192,25.414,-9.192>, <-10.607,25.939,-12.607> }
		triangle { <-10.607,25.939,-12.607>, <-5.74,26.44,-15.858>, <-4.975,25.848,-12.01> }
		triangle { <-9.192,25.414,-9.192>, <-12.01,24.738,-4.795>, <-13.858,25.191,-7.74> }
		triangle { <-13.858,25.191,-7.74>, <-10.607,25.939,-12.607>, <-9.192,25.414,-9.192> }
		triangle { <-12.01,24.738,-4.795>, <-13,24,0>, <-15,24.308,-2> }
		triangle { <-15,24.308,-2>, <-13.858,25.191,-7.74>, <-12.01,24.738,-4.795> }
		triangle { <-13,24,0>, <-12.01,23.262,4.975>, <-13.858,23.425,3.74> }
		triangle { <-13.858,23.425,3.74>, <-15,24.308,-2>, <-13,24,0> }
		triangle { <-12.01,23.262,4.975>, <-9.192,22.586,9.192>, <-10.607,22.676,8.607> }
		triangle { <-10.607,22.676,8.607>, <-13.858,23.425,3.74>, <-12.01,23.262,4.975> }
		triangle { <-9.192,22.586,9.192>, <-4.975,22.152,12.01>, <-5.74,22.176,11.858> }
		triangle { <-5.74,22.176,11.858>, <-10.607,22.676,8.607>, <-9.192,22.586,9.192> }
		triangle { <15.244,15.496,-6.071>, <15,24.308,-2>, <16.5,12.157,1.722> }
		triangle { <13.858,25.191,-7.74>, <15.244,15.496,-6.071>, <15,24.308,-2> }
		triangle { <11.667,18.295,-12.603>, <13.858,25.191,-7.74>, <15.244,15.496,-6.071> }
		triangle { <10.607,25.939,-12.607>, <11.667,18.295,-12.603>, <13.858,25.191,-7.74> }
		triangle { <6.314,20.165,-16.968>, <10.607,25.939,-12.607>, <11.667,18.295,-12.603> }
		triangle { <5.74,26.44,-15.858>, <6.314,20.165,-16.968>, <10.607,25.939,-12.607> }
		triangle { <0,20.822,-18.5>, <5.74,26.44,-15.858>, <6.314,20.165,-16.968> }
		triangle { <0,26.615,-17>, <0,20.822,-18.5>, <5.74,26.44,-15.858> }
		triangle { <0,26.615,-17>, <0,20.822,-18.5>, <-5.74,26.44,-15.858> }
		triangle { <0,20.822,-18.5>, <-5.74,26.44,-15.858>, <-6.314,20.165,-16.968> }
		triangle { <-5.74,26.44,-15.858>, <-6.314,20.165,-16.968>, <-10.607,25.939,-12.607> }
		triangle { <-6.314,20.165,-16.968>, <-10.607,25.939,-12.607>, <-11.667,18.295,-12.603> }
		triangle { <-10.607,25.939,-12.607>, <-11.667,18.295,-12.603>, <-13.858,25.191,-7.74> }
		triangle { <-11.667,18.295,-12.603>, <-13.858,25.191,-7.74>, <-15.244,15.496,-6.071> }
		triangle { <-13.858,25.191,-7.74>, <-15.244,15.496,-6.071>, <-15,24.308,-2> }
		triangle { <-15.244,15.496,-6.071>, <-15,24.308,-2>, <-16.5,12.157,1.722> }
		triangle { <-15,24.308,-2>, <-16.5,12.157,1.722>, <-13.858,23.425,3.74> }
		triangle { <-16.5,12.157,1.722>, <-13.858,23.425,3.74>, <-14.119,14.123,5.848> }
		triangle { <-13.858,23.425,3.74>, <-14.119,14.123,5.848>, <-10.607,22.676,8.607> }
		triangle { <-14.119,14.123,5.848>, <-10.607,22.676,8.607>, <-10.806,14.123,10.806> }
		triangle { <-10.607,22.676,8.607>, <-10.806,14.123,10.806>, <-5.74,22.176,11.858> }
		triangle { <-10.806,14.123,10.806>, <-5.74,22.176,11.858>, <-5.848,14.123,14.119> }
		triangle { <-5.74,22.176,11.858>, <-5.848,14.123,14.119>, <0,22,13.2> }
		triangle { <-5.848,14.123,14.119>, <0,22,13.2>, <0,14.123,15.282> }
		triangle { <5.848,14.123,14.119>, <0,22,13.2>, <0,14.123,15.282> }
		triangle { <5.74,22.176,11.858>, <5.848,14.123,14.119>, <0,22,13.2> }
		triangle { <10.806,14.123,10.806>, <5.74,22.176,11.858>, <5.848,14.123,14.119> }
		triangle { <10.607,22.676,8.607>, <10.806,14.123,10.806>, <5.74,22.176,11.858> }
		triangle { <14.119,14.123,5.848>, <10.607,22.676,8.607>, <10.806,14.123,10.806> }
		triangle { <13.858,23.425,3.74>, <14.119,14.123,5.848>, <10.607,22.676,8.607> }
		triangle { <16.5,12.157,1.722>, <13.858,23.425,3.74>, <14.119,14.123,5.848> }
		triangle { <15,24.308,-2>, <16.5,12.157,1.722>, <13.858,23.425,3.74> }
		triangle { <14.5,1.877,2.5>, <15.356,6.278,4.157>, <14.5,6.278,4.157> }
		triangle { <15.356,6.278,4.157>, <14.5,6.278,4.157>, <14.5,8,4.5> }
		triangle { <14.5,8,4.5>, <15.691,8,4.5>, <15.356,6.278,4.157> }
		triangle { <15.691,8,4.5>, <14.5,8,4.5>, <14.5,9.722,4.157> }
		triangle { <14.5,9.722,4.157>, <16.026,9.722,4.157>, <15.691,8,4.5> }
		triangle { <16.026,9.722,4.157>, <14.5,9.722,4.157>, <14.5,11.182,3.182> }
		triangle { <14.5,11.182,3.182>, <16.31,11.182,3.182>, <16.026,9.722,4.157> }
		triangle { <16.31,11.182,3.182>, <14.5,11.182,3.182>, <14.5,12.157,1.722> }
		triangle { <14.5,12.157,1.722>, <16.5,12.157,1.722>, <16.31,11.182,3.182> }
		triangle { <16.5,12.157,1.722>, <14.5,12.157,1.722>, <14.5,14.823,-4.5> }
		triangle { <14.5,14.823,-4.5>, <15.538,14.823,-4.5>, <16.5,12.157,1.722> }
		triangle { <-16.5,12.157,1.722>, <-14.5,12.157,1.722>, <-14.5,14.823,-4.5> }
		triangle { <-14.5,14.823,-4.5>, <-15.538,14.823,-4.5>, <-16.5,12.157,1.722> }
		triangle { <-16.31,11.182,3.182>, <-14.5,11.182,3.182>, <-14.5,12.157,1.722> }
		triangle { <-14.5,12.157,1.722>, <-16.5,12.157,1.722>, <-16.31,11.182,3.182> }
		triangle { <-16.026,9.722,4.157>, <-14.5,9.722,4.157>, <-14.5,11.182,3.182> }
		triangle { <-14.5,11.182,3.182>, <-16.31,11.182,3.182>, <-16.026,9.722,4.157> }
		triangle { <-15.691,8,4.5>, <-14.5,8,4.5>, <-14.5,9.722,4.157> }
		triangle { <-14.5,9.722,4.157>, <-16.026,9.722,4.157>, <-15.691,8,4.5> }
		triangle { <-15.356,6.278,4.157>, <-14.5,6.278,4.157>, <-14.5,8,4.5> }
		triangle { <-14.5,8,4.5>, <-15.691,8,4.5>, <-15.356,6.278,4.157> }
		triangle { <-14.5,1.877,2.5>, <-15.356,6.278,4.157>, <-14.5,6.278,4.157> }
		triangle { <14.5,12,-3>, <14.5,9.5,0>, <14.5,12.157,1.722> }
		triangle { <14.5,12.157,1.722>, <14.5,14.823,-4.5>, <14.5,12,-3> }
		triangle { <14.5,10.087,-3.381>, <14.5,9.5,-1.5>, <14.5,9.5,0> }
		triangle { <14.5,9.5,0>, <14.5,12,-3>, <14.5,10.087,-3.381> }
		triangle { <14.5,8.464,-4.464>, <14.5,6.5,-1.5>, <14.5,9.5,-1.5> }
		triangle { <14.5,9.5,-1.5>, <14.5,10.087,-3.381>, <14.5,8.464,-4.464> }
		triangle { <14.5,7.381,-6.087>, <14.5,6.5,-1.5>, <14.5,8.464,-4.464> }
		triangle { <14.5,7,-8>, <14.5,6.5,-1.5>, <14.5,7.381,-6.087> }
		triangle { <14.5,1.877,2.5>, <14.5,6.5,-1.5>, <14.5,7,-8> }
		triangle { <14.5,1.877,2.5>, <14.5,6.5,1.5>, <14.5,6.5,-1.5> }
		triangle { <14.5,1.877,2.5>, <14.5,6.278,4.157>, <14.5,8,1.5> }
		triangle { <14.5,8,1.5>, <14.5,6.5,1.5>, <14.5,1.877,2.5> }
		triangle { <14.5,8,1.5>, <14.5,6.278,4.157>, <14.5,6.278,4.5> }
		triangle { <14.5,6.278,4.5>, <14.5,9.722,4.157>, <14.5,8,1.5> }
		triangle { <14.5,8,1.5>, <14.5,9.722,4.157>, <14.5,11.182,3.182> }
		triangle { <14.5,11.182,3.182>, <14.5,9.5,1.5>, <14.5,8,1.5> }
		triangle { <14.5,9.5,1.5>, <14.5,11.182,3.182>, <14.5,12.157,1.722> }
		triangle { <14.5,12.157,1.722>, <14.5,9.5,0>, <14.5,9.5,1.5> }
		triangle { <-14.5,9.5,1.5>, <-14.5,11.182,3.182>, <-14.5,12.157,1.722> }
		triangle { <-14.5,12.157,1.722>, <-14.5,9.5,0>, <-14.5,9.5,1.5> }
		triangle { <-14.5,8,1.5>, <-14.5,9.722,4.157>, <-14.5,11.182,3.182> }
		triangle { <-14.5,11.182,3.182>, <-14.5,9.5,1.5>, <-14.5,8,1.5> }
		triangle { <-14.5,8,1.5>, <-14.5,6.278,4.157>, <-14.5,6.278,4.5> }
		triangle { <-14.5,6.278,4.5>, <-14.5,9.722,4.157>, <-14.5,8,1.5> }
		triangle { <-14.5,1.877,2.5>, <-14.5,6.278,4.157>, <-14.5,8,1.5> }
		triangle { <-14.5,8,1.5>, <-14.5,6.5,1.5>, <-14.5,1.877,2.5> }
		triangle { <-14.5,1.877,2.5>, <-14.5,6.5,1.5>, <-14.5,6.5,-1.5> }
		triangle { <-14.5,1.877,2.5>, <-14.5,6.5,-1.5>, <-14.5,7,-8> }
		triangle { <-14.5,7,-8>, <-14.5,6.5,-1.5>, <-14.5,7.381,-6.087> }
		triangle { <-14.5,7.381,-6.087>, <-14.5,6.5,-1.5>, <-14.5,8.464,-4.464> }
		triangle { <-14.5,8.464,-4.464>, <-14.5,6.5,-1.5>, <-14.5,9.5,-1.5> }
		triangle { <-14.5,9.5,-1.5>, <-14.5,10.087,-3.381>, <-14.5,8.464,-4.464> }
		triangle { <-14.5,10.087,-3.381>, <-14.5,9.5,-1.5>, <-14.5,9.5,0> }
		triangle { <-14.5,9.5,0>, <-14.5,12,-3>, <-14.5,10.087,-3.381> }
		triangle { <-14.5,12,-3>, <-14.5,9.5,0>, <-14.5,12.157,1.722> }
		triangle { <-14.5,12.157,1.722>, <-14.5,14.823,-4.5>, <-14.5,12,-3> }
		triangle { <14.5,7,-8>, <14.5,7.381,-6.087>, <11.267,7.381,-6.087> }
		triangle { <11.267,7.381,-6.087>, <9.989,7,-8>, <14.5,7,-8> }
		triangle { <14.5,7.381,-6.087>, <14.5,7.722,-4.975>, <12.01,7.722,-4.975> }
		triangle { <12.01,7.722,-4.975>, <11.267,7.381,-6.087>, <14.5,7.381,-6.087> }
		triangle { <14.5,7.722,-4.975>, <14.5,8.464,-4.464>, <12.112,8.464,-4.464> }
		triangle { <12.112,8.464,-4.464>, <12.01,7.722,-4.975>, <14.5,7.722,-4.975> }
		triangle { <14.5,8.464,-4.464>, <14.5,10.087,-3.381>, <12.327,10.087,-3.381> }
		triangle { <12.327,10.087,-3.381>, <12.112,8.464,-4.464>, <14.5,8.464,-4.464> }
		triangle { <14.5,10.087,-3.381>, <14.5,12,-3>, <12.403,12,-3> }
		triangle { <12.403,12,-3>, <12.327,10.087,-3.381>, <14.5,10.087,-3.381> }
		triangle { <14.5,12,-3>, <14.5,14.823,-4.5>, <12.105,14.823,-4.5> }
		triangle { <12.105,14.823,-4.5>, <12.403,12,-3>, <14.5,12,-3> }
		triangle { <-14.5,7,-8>, <-14.5,7.381,-6.087>, <-11.267,7.381,-6.087> }
		triangle { <-11.267,7.381,-6.087>, <-9.989,7,-8>, <-14.5,7,-8> }
		triangle { <-14.5,7.381,-6.087>, <-14.5,7.722,-4.975>, <-12.01,7.722,-4.975> }
		triangle { <-12.01,7.722,-4.975>, <-11.267,7.381,-6.087>, <-14.5,7.381,-6.087> }
		triangle { <-14.5,7.722,-4.975>, <-14.5,8.464,-4.464>, <-12.112,8.464,-4.464> }
		triangle { <-12.112,8.464,-4.464>, <-12.01,7.722,-4.975>, <-14.5,7.722,-4.975> }
		triangle { <-14.5,8.464,-4.464>, <-14.5,10.087,-3.381>, <-12.327,10.087,-3.381> }
		triangle { <-12.327,10.087,-3.381>, <-12.112,8.464,-4.464>, <-14.5,8.464,-4.464> }
		triangle { <-14.5,10.087,-3.381>, <-14.5,12,-3>, <-12.403,12,-3> }
		triangle { <-12.403,12,-3>, <-12.327,10.087,-3.381>, <-14.5,10.087,-3.381> }
		triangle { <-14.5,12,-3>, <-14.5,14.823,-4.5>, <-12.105,14.823,-4.5> }
		triangle { <-12.105,14.823,-4.5>, <-12.403,12,-3>, <-14.5,12,-3> }
		triangle { <15.538,14.823,-4.5>, <15.244,15.496,-6.071>, <12.01,15.027,-4.975> }
		triangle { <12.01,15.027,-4.975>, <12.105,14.823,-4.5>, <15.538,14.823,-4.5> }
		triangle { <15.244,15.496,-6.071>, <11.667,18.295,-12.603>, <9.192,16.833,-9.192> }
		triangle { <9.192,16.833,-9.192>, <12.01,15.027,-4.975>, <15.244,15.496,-6.071> }
		triangle { <11.667,18.295,-12.603>, <6.314,20.165,-16.968>, <4.975,18.041,-12.01> }
		triangle { <4.975,18.041,-12.01>, <9.192,16.833,-9.192>, <11.667,18.295,-12.603> }
		triangle { <6.314,20.165,-16.968>, <0,20.822,-18.5>, <0,18.465,-13> }
		triangle { <0,18.465,-13>, <4.975,18.041,-12.01>, <6.314,20.165,-16.968> }
		triangle { <-6.314,20.165,-16.968>, <0,20.822,-18.5>, <0,18.465,-13> }
		triangle { <0,18.465,-13>, <-4.975,18.041,-12.01>, <-6.314,20.165,-16.968> }
		triangle { <-11.667,18.295,-12.603>, <-6.314,20.165,-16.968>, <-4.975,18.041,-12.01> }
		triangle { <-4.975,18.041,-12.01>, <-9.192,16.833,-9.192>, <-11.667,18.295,-12.603> }
		triangle { <-15.244,15.496,-6.071>, <-11.667,18.295,-12.603>, <-9.192,16.833,-9.192> }
		triangle { <-9.192,16.833,-9.192>, <-12.01,15.027,-4.975>, <-15.244,15.496,-6.071> }
		triangle { <-15.538,14.823,-4.5>, <-15.244,15.496,-6.071>, <-12.01,15.027,-4.975> }
		triangle { <-12.01,15.027,-4.975>, <-12.105,14.823,-4.5>, <-15.538,14.823,-4.5> }
		triangle { <14.5,7,-8>, <10.607,7,-12.021>, <9.192,7,-9.192> }
		triangle { <9.192,7,-9.192>, <12.01,7,-4.975>, <14.5,7,-8> }
		triangle { <10.607,7,-12.021>, <5.74,7,-15.706>, <4.975,7,-12.01> }
		triangle { <4.975,7,-12.01>, <9.192,7,-9.192>, <10.607,7,-12.021> }
		triangle { <5.74,7,-15.706>, <0,7,-17>, <0,7,-13> }
		triangle { <0,7,-13>, <4.975,7,-12.01>, <5.74,7,-15.706> }
		triangle { <-5.74,7,-15.706>, <0,7,-17>, <0,7,-13> }
		triangle { <0,7,-13>, <-4.975,7,-12.01>, <-5.74,7,-15.706> }
		triangle { <-10.607,7,-12.021>, <-5.74,7,-15.706>, <-4.975,7,-12.01> }
		triangle { <-4.975,7,-12.01>, <-9.192,7,-9.192>, <-10.607,7,-12.021> }
		triangle { <-14.5,7,-8>, <-10.607,7,-12.021>, <-9.192,7,-9.192> }
		triangle { <-9.192,7,-9.192>, <-12.01,7,-4.975>, <-14.5,7,-8> }
	}
	object { _4_dash_4ndis_dot_dat matrix <0,1.5,0,-1,0,0,0,0,1.5,14.5,8,0> }
	object { _4_dash_4ndis_dot_dat matrix <0,-1.5,0,1,0,0,0,0,1.5,-14.5,8,0> }
	object { _4_dash_8sphe_dot_dat matrix <0,1.5,0,-1,0,0,0,0,1.5,14.5,8,0> }
	object { _4_dash_8sphe_dot_dat matrix <0,-1.5,0,1,0,0,0,0,1.5,-14.5,8,0> }
// 
}
#end

#declare _1_dash_8disc_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 1
		clipped_by { plane { <0,0,-1>,0 } plane { <-1,0,1>,0 } }
	}
#else
	cylinder {
		<0,-0.001,0>, <0,0.001,0>, 1
		clipped_by { plane { <0,0,-1>,0 } plane { <-1,0,1>,0 } }
	}
#end

#declare _1_dash_4rin10_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 11, 10
		clipped_by { box { <0,-1,0>, <12,1,12> } }
	}
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 11 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 10 }
		clipped_by { box { <0,-0.01,0>, <12,0.01,12> } }
	}
#end

#declare _1_dash_4cyls2_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open
	clipped_by { plane { <1,0,-1>,-O7071 } plane { <1,1,0>,0 } } }

#declare _1_dash_8cyli_dot_dat = cylinder {
	<0,0,0>, <0,1,0>, 1 open
	clipped_by { box { <O7071,0,0>, <1,1,O7071> } }
}

#declare _2447_dot_dat = #if (QUAL = 0) box { <-17,4,-20>, <17,21,4> } #else union {
	object { _1_dash_4disc_dot_dat matrix <0,-4,0,-1,0,0,0,0,4,-15,8,0> }
	object { _1_dash_8disc_dot_dat matrix <0,0,4,-1,0,0,0,4,0,-15,8,0> }
	mesh {
		triangle { <-15,8,0>, <-15,10.828,2.828>, <-15,11.648,1.641> }
		triangle { <-15,8,0>, <-15,13.505,-3>, <-15,11.648,1.641> }
		triangle { <-15,4,0>, <-15,4,-3>, <-15,13.505,-3> }
		triangle { <-15,13.505,-3>, <-15,12,0>, <-15,4,0> }
	}
	object { _1_dash_4disc_dot_dat matrix <0,-4,0,-1,0,0,0,0,4,15,8,0> }
	object { _1_dash_8disc_dot_dat matrix <0,0,4,-1,0,0,0,4,0,15,8,0> }
	mesh {
		triangle { <15,8,0>, <15,10.828,2.828>, <15,11.648,1.641> }
		triangle { <15,8,0>, <15,13.505,-3>, <15,11.648,1.641> }
		triangle { <15,4,0>, <15,4,-3>, <15,13.505,-3> }
		triangle { <15,13.505,-3>, <15,12,0>, <15,4,0> }
	}
	object { _1_dash_4disc_dot_dat matrix <0,-4,0,-1,0,0,0,0,4,-17,8,0> }
	object { _1_dash_8disc_dot_dat matrix <0,0,4,-1,0,0,0,4,0,-17,8,0> }
	mesh {
		triangle { <-17,8,0>, <-17,10.828,2.828>, <-17,11.648,1.641> }
		triangle { <-17,8,0>, <-17,13.505,-3>, <-17,11.648,1.641> }
		triangle { <-17,4,0>, <-17,4,-3>, <-17,13.505,-3> }
		triangle { <-17,13.505,-3>, <-17,12,0>, <-17,4,0> }
	}
	object { _1_dash_4disc_dot_dat matrix <0,-4,0,-1,0,0,0,0,4,17,8,0> }
	object { _1_dash_8disc_dot_dat matrix <0,0,4,-1,0,0,0,4,0,17,8,0> }
	mesh {
		triangle { <17,8,0>, <17,10.828,2.828>, <17,11.648,1.641> }
		triangle { <17,8,0>, <17,13.505,-3>, <17,11.648,1.641> }
		triangle { <17,4,0>, <17,4,-3>, <17,13.505,-3> }
		triangle { <17,13.505,-3>, <17,12,0>, <17,4,0> }
	}
	object { _1_dash_4rin10_dot_dat matrix <0,0,-1.5,0,1,0,1.5,0,0,0,4,-3> }
	object { _1_dash_4rin10_dot_dat matrix <0,0,-1.54545,0,1,0,1.54545,0,0,0,4,-3> }
	object { _1_dash_4rin10_dot_dat matrix <-1.5,0,0,0,1,0,0,0,-1.5,0,4,-3> }
	object { _1_dash_4rin10_dot_dat matrix <-1.54545,0,0,0,1,0,0,0,-1.54545,0,4,-3> }
	object { _1_dash_4rin10_dot_dat matrix <0,0.6613,-1.5,0,1,0,1.5,0,0,0,13.505,-3> }
	object { _1_dash_4rin10_dot_dat matrix <0,0.681364,-1.54545,0,1,0,1.54545,0,0,0,13.505,-3> }
	object { _1_dash_4rin10_dot_dat matrix <-1.5,0,0,0,1,0,0,0.6613,-1.5,0,13.505,-3> }
	object { _1_dash_4rin10_dot_dat matrix <-1.54545,0,0,0,1,0,0,0.681364,-1.54545,0,13.505,-3> }
	object { _2_dash_4cyli_dot_dat matrix <15,0,0,0,9.505,0,0,0,-15,0,4,-3> }
	object { _1_dash_4cyls2_dot_dat matrix <0,0,15,0,6.613,0,15,0,0,0,13.505,-3> }
	object { _1_dash_4cyls2_dot_dat matrix <0,0,15,0,6.613,0,-15,0,0,0,13.505,-3> }
	object { _2_dash_4cyli_dot_dat matrix <17,0,0,0,9.505,0,0,0,-17,0,4,-3> }
	object { _1_dash_4cyls2_dot_dat matrix <0,0,17,0,7.495,0,17,0,0,0,13.505,-3> }
	object { _1_dash_4cyls2_dot_dat matrix <0,0,17,0,7.495,0,-17,0,0,0,13.505,-3> }
	object { _1_dash_4cyli_dot_dat matrix <0,-4,0,-2,0,0,0,0,4,17,8,0> }
	object { _1_dash_8cyli_dot_dat matrix <0,0,4,-2,0,0,0,4,0,17,8,0> }
	mesh {
		triangle { <17,4,-3>, <17,4,0>, <15,4,0> }
		triangle { <15,4,0>, <15,4,-3>, <17,4,-3> }
		triangle { <-17,4,-3>, <-17,4,0>, <-15,4,0> }
		triangle { <-15,4,0>, <-15,4,-3>, <-17,4,-3> }
		triangle { <17,11.648,1.641>, <17,10.828,2.828>, <15,10.828,2.828> }
		triangle { <15,10.828,2.828>, <15,11.648,1.641>, <17,11.648,1.641> }
		triangle { <17,13.505,-3>, <17,11.648,1.641>, <15,11.648,1.641> }
		triangle { <15,11.648,1.641>, <15,13.505,-3>, <17,13.505,-3> }
		triangle { <-17,13.505,-3>, <-17,11.648,1.641>, <-15,11.648,1.641> }
		triangle { <-15,11.648,1.641>, <-15,13.505,-3>, <-17,13.505,-3> }
		triangle { <-17,11.648,1.641>, <-17,10.828,2.828>, <-15,10.828,2.828> }
		triangle { <-15,10.828,2.828>, <-15,11.648,1.641>, <-17,11.648,1.641> }
	}
	object { _1_dash_8cyli_dot_dat matrix <0,0,4,-2,0,0,0,4,0,-15,8,0> }
	object { _1_dash_4cyli_dot_dat matrix <0,-4,0,-2,0,0,0,0,4,-15,8,0> }
	object { _4_dash_8sphe_dot_dat matrix <0,1.5,0,-1,0,0,0,0,1.5,15,8,0> }
	object { _4_dash_8sphe_dot_dat matrix <0,-1.5,0,1,0,0,0,0,1.5,-15,8,0> }
}
#end

#declare mechfig_dot_dat = union {
	object {
		_971_dot_dat
		matrix <1-SW/18,0,0,0,1-SW/37,0,0,0,1-SW/20,SW/-1.71429,SW/3.89474,SW/-20>
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_972_dot_dat
		matrix <1-SW/18,0,0,0,1-SW/37,0,0,0,1-SW/20,SW/1.71429,SW/3.89474,SW/-20>
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_970_dot_dat
		matrix <1-SW/36,0,0,0,1-SW/32,0,0,0,1-SW/20,0,SW/6.4,0>
		matrix <1,0,0,0,1,0,0,0,1,0,-12,0>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_973p52_dot_dat
		matrix <1-SW/38,0,0,0,1-SW/44,0,0,0,1-SW/20,0,SW/4.4,0>
		matrix <1,0,0,0,1,0,0,0,1,0,-44,0>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_975_dot_dat
		matrix <1-SW/17.856,0,0,0,1-SW/30.605,0,0,0,1-SW/19.685,SW/-0.866628,SW/3.76746,SW/-6.36129>
		matrix <1,0,0,0,1,0,0,0,1,0,-36,0.5>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_977_dot_dat
		matrix <1-SW/25.52,0,0,0,1-SW/12,0,0,0,1-SW/12,SW/7.87654,SW/6,0>
		matrix <0,-0.71,0.71,0,0.71,0.71,-1,0,0,-22.5,-15,-15.28>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_976_dot_dat
		matrix <1-SW/17.856,0,0,0,1-SW/30.605,0,0,0,1-SW/19.685,SW/0.866628,SW/3.76746,SW/-6.36129>
		matrix <1,0,0,0,1,0,0,0,1,0,-36,0.5>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_977_dot_dat
		matrix <1-SW/25.52,0,0,0,1-SW/12,0,0,0,1-SW/12,SW/7.87654,SW/6,0>
		matrix <0,-0.71,0.71,0,0.71,0.71,-1,0,0,22.5,-15.01,-15.3>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3626bp05_dot_dat
		matrix <1-SW/26,0,0,0,1-SW/28,0,0,0,1-SW/26,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,0,-68,0.5>
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	object {
		_2446_dot_dat
		matrix <1-SW/33,0,0,0,1-SW/34.615,0,0,0,1-SW/34.5,0,SW/3.71904,SW/-27.6>
		matrix <1,0,0,0,1,0,0,0,1,0,-69,0>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_2447_dot_dat
		matrix <1-SW/34,0,0,0,1-SW/17,0,0,0,1-SW/24,0,SW/1.36,SW/-3>
		matrix <1,0,0,0,1,0,0,0,1,0,-69,0>
		#if (ver >= 3.1) material #else texture #end { Color46 }
	}
}

#declare _702_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <60,24,60> } #else union {
	mesh {
		triangle { <20,24,60>, <16,24,56>, <-16,24,56> }
		triangle { <-16,24,56>, <-20,24,60>, <20,24,60> }
		triangle { <-20,24,60>, <-16,24,56>, <-16,24,-16> }
		triangle { <-16,24,-16>, <-20,24,-20>, <-20,24,60> }
		triangle { <-20,24,-20>, <-16,24,-16>, <56,24,-16> }
		triangle { <56,24,-16>, <60,24,-20>, <-20,24,-20> }
		triangle { <60,24,-20>, <56,24,-16>, <56,24,16> }
		triangle { <56,24,16>, <60,24,20>, <60,24,-20> }
		triangle { <60,24,20>, <56,24,16>, <16,24,16> }
		triangle { <16,24,16>, <20,24,20>, <60,24,20> }
		triangle { <20,24,20>, <16,24,16>, <16,24,56> }
		triangle { <16,24,56>, <20,24,60>, <20,24,20> }
	}
	object { rect_dot_dat matrix <36,0,0,0,0,-12,0,-10,0,20,14,-16> }
	object { rect_dot_dat matrix <20,0,0,0,0,-12,0,-10,0,36,14,16> }
	object { rect_dot_dat matrix <0,0,-16,-12,0,0,0,-10,0,56,14,0> }
	object { rect_dot_dat matrix <-16,0,0,0,0,12,0,-10,0,0,14,56> }
	object { rect_dot_dat matrix <0,-10,0,-12,0,0,0,0,36,-16,14,20> }
	object { rect_dot_dat matrix <0,-10,0,-12,0,0,0,0,20,16,14,36> }
	object { rect_dot_dat matrix <0,-12,0,0,0,-4,20,0,0,40,12,20> }
	object { rect_dot_dat matrix <0,-12,0,4,0,0,0,0,20,60,12,0> }
	object { rect_dot_dat matrix <0,-12,0,0,0,-4,20,0,0,0,12,60> }
	object { rect_dot_dat matrix <0,-12,0,4,0,0,0,0,20,20,12,40> }
	object { rect_dot_dat matrix <0,-12,0,0,0,-4,40,0,0,20,12,-20> }
	object { rect_dot_dat matrix <0,-12,0,4,0,0,0,0,40,-20,12,20> }
	mesh {
		triangle { <56,4,16>, <-16,4,16>, <-16,4,-16> }
		triangle { <-16,4,-16>, <56,4,-16>, <56,4,16> }
		triangle { <16,4,56>, <16,4,16>, <-16,4,16> }
		triangle { <-16,4,16>, <-16,4,56>, <16,4,56> }
		triangle { <60,0,20>, <-20,0,20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <60,0,-20>, <60,0,20> }
		triangle { <20,0,60>, <20,0,20>, <-20,0,20> }
		triangle { <-20,0,20>, <-20,0,60>, <20,0,60> }
	}
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,3,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
	#end
}
#end

#declare box5_dot_dat = object {
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <-1,1,-1>, <-1,0,-1>, <1,0,-1> }
		triangle { <1,0,-1>, <1,1,-1>, <-1,1,-1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare _3002_dot_dat = #if (QUAL = 0) box { <-30,-4,-20>, <30,24,20> } #else union {
// Brick  2 x  3
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,10,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-10,4,0> }
	#end
	object { box5_dot_dat matrix <26,0,0,0,-20,0,0,0,16,0,24,0> }
	mesh {
		triangle { <30,24,20>, <26,24,16>, <-26,24,16> }
		triangle { <-26,24,16>, <-30,24,20>, <30,24,20> }
		triangle { <-30,24,20>, <-26,24,16>, <-26,24,-16> }
		triangle { <-26,24,-16>, <-30,24,-20>, <-30,24,20> }
		triangle { <-30,24,-20>, <-26,24,-16>, <26,24,-16> }
		triangle { <26,24,-16>, <30,24,-20>, <-30,24,-20> }
		triangle { <30,24,-20>, <26,24,-16>, <26,24,16> }
		triangle { <26,24,16>, <30,24,20>, <30,24,-20> }
	}
	object { box5_dot_dat matrix <30,0,0,0,-24,0,0,0,20,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,20,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-20,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,20,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-20,0,-10> }
	#end
}
#end

#declare _3003_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,24,20> } #else union {
// Brick  2 x  2
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,16,0,24,0> }
	mesh {
		triangle { <20,24,20>, <16,24,16>, <-16,24,16> }
		triangle { <-16,24,16>, <-20,24,20>, <20,24,20> }
		triangle { <-20,24,20>, <-16,24,16>, <-16,24,-16> }
		triangle { <-16,24,-16>, <-20,24,-20>, <-20,24,20> }
		triangle { <-20,24,-20>, <-16,24,-16>, <16,24,-16> }
		triangle { <16,24,-16>, <20,24,-20>, <-20,24,-20> }
		triangle { <20,24,-20>, <16,24,-16>, <16,24,16> }
		triangle { <16,24,16>, <20,24,20>, <20,24,-20> }
	}
	object { box5_dot_dat matrix <20,0,0,0,-24,0,0,0,20,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _3007_dot_dat = #if (QUAL = 0) box { <-80,-4,-20>, <80,24,20> } #else union {
// Brick  2 x  8
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-20,0,0,0,16,0,24,0> }
	mesh {
		triangle { <80,24,20>, <76,24,16>, <-76,24,16> }
		triangle { <-76,24,16>, <-80,24,20>, <80,24,20> }
		triangle { <80,24,-20>, <76,24,-16>, <-76,24,-16> }
		triangle { <-76,24,-16>, <-80,24,-20>, <80,24,-20> }
		triangle { <80,24,20>, <76,24,16>, <76,24,-16> }
		triangle { <76,24,-16>, <80,24,-20>, <80,24,20> }
		triangle { <-80,24,20>, <-76,24,16>, <-76,24,-16> }
		triangle { <-76,24,-16>, <-80,24,-20>, <-80,24,20> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-24,0,0,0,20,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
	#end
}
#end

#declare _3006_dot_dat = #if (QUAL = 0) box { <-100,-4,-20>, <100,24,20> } #else union {
// Brick  2 x 10
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,80,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-80,4,0> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-20,0,0,0,16,0,24,0> }
	mesh {
		triangle { <100,24,20>, <96,24,16>, <-96,24,16> }
		triangle { <-96,24,16>, <-100,24,20>, <100,24,20> }
		triangle { <100,24,-20>, <96,24,-16>, <-96,24,-16> }
		triangle { <-96,24,-16>, <-100,24,-20>, <100,24,-20> }
		triangle { <100,24,20>, <96,24,16>, <96,24,-16> }
		triangle { <96,24,-16>, <100,24,-20>, <100,24,20> }
		triangle { <-100,24,20>, <-96,24,16>, <-96,24,-16> }
		triangle { <-96,24,-16>, <-100,24,-20>, <-100,24,20> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-24,0,0,0,20,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-10> }
	#end
}
#end

#declare stud2a_dot_dat = difference {
	cylinder { <0,0,0>, <0,-4,0>, 6 }
	cylinder { <0,0.01,0>, <0,-4.01,0>, 4 }
}

#declare _2654_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else union {
// Boat  2 x  2 Stud
	#if (STUDS)
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <20,0,0,0,2,0,0,0,20,0,0,0> }
	object { _4_dash_8sphe_dot_dat matrix <20,0,0,0,6,0,0,0,20,0,2,0> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,10,0,10> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,-10,0,10> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,10,0,-10> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,-10,0,-10> }
	object { _2_dash_4cyli_dot_dat matrix <-4.2,0,4.2,0,2.8,0,-4.2,0,-4.2,10,0,10> }
	object { _2_dash_4cyli_dot_dat matrix <4.2,0,4.2,0,2.8,0,4.2,0,-4.2,-10,0,10> }
	object { _2_dash_4cyli_dot_dat matrix <-4.2,0,-4.2,0,2.8,0,-4.2,0,4.2,10,0,-10> }
	object { _2_dash_4cyli_dot_dat matrix <4.2,0,-4.2,0,2.8,0,4.2,0,4.2,-10,0,-10> }
	mesh {
		triangle { <0,0,15.3>, <-5.86,0,14.14>, <-7.65,0,18.48> }
		triangle { <-7.65,0,18.48>, <0,0,20>, <0,0,15.3> }
		triangle { <-5.86,0,14.14>, <-10.82,0,10.82>, <-14.14,0,14.14> }
		triangle { <-14.14,0,14.14>, <-7.65,0,18.48>, <-5.86,0,14.14> }
		triangle { <-10.82,0,10.82>, <-14.14,0,5.86>, <-18.48,0,7.65> }
		triangle { <-18.48,0,7.65>, <-14.14,0,14.14>, <-10.82,0,10.82> }
		triangle { <-14.14,0,5.86>, <-15.3,0,0>, <-20,0,0> }
		triangle { <-20,0,0>, <-18.48,0,7.65>, <-14.14,0,5.86> }
		triangle { <-15.3,0,0>, <-14.14,0,-5.86>, <-18.48,0,-7.65> }
		triangle { <-18.48,0,-7.65>, <-20,0,0>, <-15.3,0,0> }
		triangle { <-14.14,0,-5.86>, <-10.82,0,-10.82>, <-14.14,0,-14.14> }
		triangle { <-14.14,0,-14.14>, <-18.48,0,-7.65>, <-14.14,0,-5.86> }
		triangle { <-10.82,0,-10.82>, <-5.86,0,-14.14>, <-7.65,0,-18.48> }
		triangle { <-7.65,0,-18.48>, <-14.14,0,-14.14>, <-10.82,0,-10.82> }
		triangle { <-5.86,0,-14.14>, <0,0,-15.3>, <0,0,-20> }
		triangle { <0,0,-20>, <-7.65,0,-18.48>, <-5.86,0,-14.14> }
		triangle { <0,0,-15.3>, <5.86,0,-14.14>, <7.65,0,-18.48> }
		triangle { <7.65,0,-18.48>, <0,0,-20>, <0,0,-15.3> }
		triangle { <5.86,0,-14.14>, <10.82,0,-10.82>, <14.14,0,-14.14> }
		triangle { <14.14,0,-14.14>, <7.65,0,-18.48>, <5.86,0,-14.14> }
		triangle { <10.82,0,-10.82>, <14.14,0,-5.86>, <18.48,0,-7.65> }
		triangle { <18.48,0,-7.65>, <14.14,0,-14.14>, <10.82,0,-10.82> }
		triangle { <14.14,0,-5.86>, <15.3,0,0>, <20,0,0> }
		triangle { <20,0,0>, <18.48,0,-7.65>, <14.14,0,-5.86> }
		triangle { <15.3,0,0>, <14.14,0,5.86>, <18.48,0,7.65> }
		triangle { <18.48,0,7.65>, <20,0,0>, <15.3,0,0> }
		triangle { <14.14,0,5.86>, <10.82,0,10.82>, <14.14,0,14.14> }
		triangle { <14.14,0,14.14>, <18.48,0,7.65>, <14.14,0,5.86> }
		triangle { <10.82,0,10.82>, <5.86,0,14.14>, <7.65,0,18.48> }
		triangle { <7.65,0,18.48>, <14.14,0,14.14>, <10.82,0,10.82> }
		triangle { <5.86,0,14.14>, <0,0,15.3>, <0,0,20> }
		triangle { <0,0,20>, <7.65,0,18.48>, <5.86,0,14.14> }
		triangle { <0,0,15.3>, <-5.86,0,14.14>, <-2.3,4,5.54> }
		triangle { <-2.3,4,5.54>, <0,4,6>, <0,0,15.3> }
		triangle { <-5.86,0,14.14>, <-10.82,0,10.82>, <-4.24,4,4.24> }
		triangle { <-4.24,4,4.24>, <-2.3,4,5.54>, <-5.86,0,14.14> }
		triangle { <-10.82,0,10.82>, <-14.14,0,5.86>, <-5.54,4,2.3> }
		triangle { <-5.54,4,2.3>, <-4.24,4,4.24>, <-10.82,0,10.82> }
		triangle { <-14.14,0,5.86>, <-15.3,0,0>, <-6,4,0> }
		triangle { <-6,4,0>, <-5.54,4,2.3>, <-14.14,0,5.86> }
		triangle { <-15.3,0,0>, <-14.14,0,-5.86>, <-5.54,4,-2.3> }
		triangle { <-5.54,4,-2.3>, <-6,4,0>, <-15.3,0,0> }
		triangle { <-14.14,0,-5.86>, <-10.82,0,-10.82>, <-4.24,4,-4.24> }
		triangle { <-4.24,4,-4.24>, <-5.54,4,-2.3>, <-14.14,0,-5.86> }
		triangle { <-10.82,0,-10.82>, <-5.86,0,-14.14>, <-2.3,4,-5.54> }
		triangle { <-2.3,4,-5.54>, <-4.24,4,-4.24>, <-10.82,0,-10.82> }
		triangle { <-5.86,0,-14.14>, <0,0,-15.3>, <0,4,-6> }
		triangle { <0,4,-6>, <-2.3,4,-5.54>, <-5.86,0,-14.14> }
		triangle { <0,0,-15.3>, <5.86,0,-14.14>, <2.3,4,-5.54> }
		triangle { <2.3,4,-5.54>, <0,4,-6>, <0,0,-15.3> }
		triangle { <5.86,0,-14.14>, <10.82,0,-10.82>, <4.24,4,-4.24> }
		triangle { <4.24,4,-4.24>, <2.3,4,-5.54>, <5.86,0,-14.14> }
		triangle { <10.82,0,-10.82>, <14.14,0,-5.86>, <5.54,4,-2.3> }
		triangle { <5.54,4,-2.3>, <4.24,4,-4.24>, <10.82,0,-10.82> }
		triangle { <14.14,0,-5.86>, <15.3,0,0>, <6,4,0> }
		triangle { <6,4,0>, <5.54,4,-2.3>, <14.14,0,-5.86> }
		triangle { <15.3,0,0>, <14.14,0,5.86>, <5.54,4,2.3> }
		triangle { <5.54,4,2.3>, <6,4,0>, <15.3,0,0> }
		triangle { <14.14,0,5.86>, <10.82,0,10.82>, <4.24,4,4.24> }
		triangle { <4.24,4,4.24>, <5.54,4,2.3>, <14.14,0,5.86> }
		triangle { <10.82,0,10.82>, <5.86,0,14.14>, <2.3,4,5.54> }
		triangle { <2.3,4,5.54>, <4.24,4,4.24>, <10.82,0,10.82> }
		triangle { <5.86,0,14.14>, <0,0,15.3>, <0,4,6> }
		triangle { <0,4,6>, <2.3,4,5.54>, <5.86,0,14.14> }
	}
}
#end

#declare stud3_dot_dat = cylinder { <0,0,0>, <0,-4,0>, 4 }

#declare _2_dash_4cyls_dot_dat = cylinder { <0,0,0>, <0,2,0>, 1 open
	clipped_by { plane { <0,0,-1>,0 } plane { <1,1,0>,O7071 } } }

#declare _3660_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,24,10> } #else union {
// Slope Brick 45  2 x  2 Inverted
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,4,0,0,10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,-4,0,0,10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,4,0,0,-10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,-4,0,0,-10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,6,0,0,10,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,-6,0,0,10,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,6,0,0,-10,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,-6,0,0,-10,4,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,6,0,0,0,4,10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,6,0,0,0,4,-10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,-10,0,-20> }
	mesh {
		triangle { <20,24,-10>, <20,4,-30>, <20,0,10> }
		triangle { <20,0,10>, <20,24,10>, <20,24,-10> }
		triangle { <20,24,-10>, <20,4,-30>, <-20,4,-30> }
		triangle { <-20,4,-30>, <-20,24,-10>, <20,24,-10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,-10>, <-20,4,-30>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <-20,24,-10> }
		triangle { <20,0,-30>, <20,4,-30>, <20,0,10> }
		triangle { <20,0,-30>, <20,4,-30>, <-20,4,-30> }
		triangle { <-20,4,-30>, <-20,0,-30>, <20,0,-30> }
		triangle { <-20,0,-30>, <-20,4,-30>, <-20,0,10> }
		triangle { <18,20,-10>, <18,4,-26>, <-18,4,-26> }
		triangle { <-18,4,-26>, <-18,20,-10>, <18,20,-10> }
		triangle { <18,20,-10>, <18,0,-10>, <18,0,-26> }
		triangle { <18,0,-26>, <18,4,-26>, <18,20,-10> }
		triangle { <-18,20,-10>, <-18,0,-10>, <-18,0,-26> }
		triangle { <-18,0,-26>, <-18,4,-26>, <-18,20,-10> }
		triangle { <18,20,-10>, <18,0,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-18,20,-10>, <18,20,-10> }
		triangle { <18,4,-26>, <18,0,-26>, <-18,0,-26> }
		triangle { <-18,0,-26>, <-18,4,-26>, <18,4,-26> }
		triangle { <20,0,10>, <18,0,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <-20,0,10>, <-18,0,-10>, <-18,0,-26> }
		triangle { <-18,0,-26>, <-20,0,-30>, <-20,0,10> }
		triangle { <-20,0,-30>, <-18,0,-26>, <18,0,-26> }
		triangle { <18,0,-26>, <20,0,-30>, <-20,0,-30> }
		triangle { <20,0,-30>, <18,0,-26>, <18,0,-10> }
		triangle { <18,0,-10>, <20,0,10>, <20,0,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-20> }
	#end
}
#end

#declare stud4a_dot_dat = difference {
	cylinder { <0,0,0>, <0,-4,0>, 8 }
	cylinder { <0,0.01,0>, <0,-4.01,0>, 6 }
}

#declare axlehole_dot_dat = object {
	mesh {
		triangle { <6,0,0>, <5.58,0,2>, <5.58,1,2> }
		triangle { <5.58,1,2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,2>, <2,0,2>, <2,1,2> }
		triangle { <2,1,2>, <5.58,1,2>, <5.58,0,2> }
		triangle { <2,0,2>, <2,0,5.58>, <2,1,5.58> }
		triangle { <2,1,5.58>, <2,1,2>, <2,0,2> }
		triangle { <2,0,5.58>, <0,0,6>, <0,1,6> }
		triangle { <0,1,6>, <2,1,5.58>, <2,0,5.58> }
		triangle { <-6,0,0>, <-5.58,0,2>, <-5.58,1,2> }
		triangle { <-5.58,1,2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,2>, <-2,0,2>, <-2,1,2> }
		triangle { <-2,1,2>, <-5.58,1,2>, <-5.58,0,2> }
		triangle { <-2,0,2>, <-2,0,5.58>, <-2,1,5.58> }
		triangle { <-2,1,5.58>, <-2,1,2>, <-2,0,2> }
		triangle { <-2,0,5.58>, <0,0,6>, <0,1,6> }
		triangle { <0,1,6>, <-2,1,5.58>, <-2,0,5.58> }
		triangle { <6,0,0>, <5.58,0,-2>, <5.58,1,-2> }
		triangle { <5.58,1,-2>, <6,1,0>, <6,0,0> }
		triangle { <5.58,0,-2>, <2,0,-2>, <2,1,-2> }
		triangle { <2,1,-2>, <5.58,1,-2>, <5.58,0,-2> }
		triangle { <2,0,-2>, <2,0,-5.58>, <2,1,-5.58> }
		triangle { <2,1,-5.58>, <2,1,-2>, <2,0,-2> }
		triangle { <2,0,-5.58>, <0,0,-6>, <0,1,-6> }
		triangle { <0,1,-6>, <2,1,-5.58>, <2,0,-5.58> }
		triangle { <-6,0,0>, <-5.58,0,-2>, <-5.58,1,-2> }
		triangle { <-5.58,1,-2>, <-6,1,0>, <-6,0,0> }
		triangle { <-5.58,0,-2>, <-2,0,-2>, <-2,1,-2> }
		triangle { <-2,1,-2>, <-5.58,1,-2>, <-5.58,0,-2> }
		triangle { <-2,0,-2>, <-2,0,-5.58>, <-2,1,-5.58> }
		triangle { <-2,1,-5.58>, <-2,1,-2>, <-2,0,-2> }
		triangle { <-2,0,-5.58>, <0,0,-6>, <0,1,-6> }
		triangle { <0,1,-6>, <-2,1,-5.58>, <-2,0,-5.58> }
		triangle { <5.58,0,2>, <5.52,0,2.28>, <2,0,2> }
		triangle { <5.52,0,2.28>, <4.26,0,4.26>, <2,0,2> }
		triangle { <4.26,0,4.26>, <2.28,0,5.52>, <2,0,2> }
		triangle { <2.28,0,5.52>, <2,0,5.58>, <2,0,2> }
		triangle { <-5.58,0,2>, <-5.52,0,2.28>, <-2,0,2> }
		triangle { <-5.52,0,2.28>, <-4.26,0,4.26>, <-2,0,2> }
		triangle { <-4.26,0,4.26>, <-2.28,0,5.52>, <-2,0,2> }
		triangle { <-2.28,0,5.52>, <-2,0,5.58>, <-2,0,2> }
		triangle { <5.58,0,-2>, <5.52,0,-2.28>, <2,0,-2> }
		triangle { <5.52,0,-2.28>, <4.26,0,-4.26>, <2,0,-2> }
		triangle { <4.26,0,-4.26>, <2.28,0,-5.52>, <2,0,-2> }
		triangle { <2.28,0,-5.52>, <2,0,-5.58>, <2,0,-2> }
		triangle { <-5.58,0,-2>, <-5.52,0,-2.28>, <-2,0,-2> }
		triangle { <-5.52,0,-2.28>, <-4.26,0,-4.26>, <-2,0,-2> }
		triangle { <-4.26,0,-4.26>, <-2.28,0,-5.52>, <-2,0,-2> }
		triangle { <-2.28,0,-5.52>, <-2,0,-5.58>, <-2,0,-2> }
		triangle { <5.58,1,2>, <5.52,1,2.28>, <2,1,2> }
		triangle { <5.52,1,2.28>, <4.26,1,4.26>, <2,1,2> }
		triangle { <4.26,1,4.26>, <2.28,1,5.52>, <2,1,2> }
		triangle { <2.28,1,5.52>, <2,1,5.58>, <2,1,2> }
		triangle { <-5.58,1,2>, <-5.52,1,2.28>, <-2,1,2> }
		triangle { <-5.52,1,2.28>, <-4.26,1,4.26>, <-2,1,2> }
		triangle { <-4.26,1,4.26>, <-2.28,1,5.52>, <-2,1,2> }
		triangle { <-2.28,1,5.52>, <-2,1,5.58>, <-2,1,2> }
		triangle { <5.58,1,-2>, <5.52,1,-2.28>, <2,1,-2> }
		triangle { <5.52,1,-2.28>, <4.26,1,-4.26>, <2,1,-2> }
		triangle { <4.26,1,-4.26>, <2.28,1,-5.52>, <2,1,-2> }
		triangle { <2.28,1,-5.52>, <2,1,-5.58>, <2,1,-2> }
		triangle { <-5.58,1,-2>, <-5.52,1,-2.28>, <-2,1,-2> }
		triangle { <-5.52,1,-2.28>, <-4.26,1,-4.26>, <-2,1,-2> }
		triangle { <-4.26,1,-4.26>, <-2.28,1,-5.52>, <-2,1,-2> }
		triangle { <-2.28,1,-5.52>, <-2,1,-5.58>, <-2,1,-2> }
	}
}

#declare box4_dot_dat = object {
	mesh {
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <-1,1,-1>, <-1,0,-1>, <1,0,-1> }
		triangle { <1,0,-1>, <1,1,-1>, <-1,1,-1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare connect_dot_dat = union {
// Connector
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,12,0,0,0,4,0,-12,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,6,0,-12,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,2,0,0,0,8,0,-2,0> }
	mesh {
		triangle { <0,-20,6>, <0,-20,4>, <1.52,-20,3.68> }
		triangle { <1.52,-20,3.68>, <2.28,-20,5.52>, <0,-20,6> }
		triangle { <2.28,-20,5.52>, <1.52,-20,3.68>, <2.8,-20,2.8> }
		triangle { <2.8,-20,2.8>, <4.2,-20,4.2>, <2.28,-20,5.52> }
		triangle { <4.2,-20,4.2>, <2.8,-20,2.8>, <3.68,-20,1.52> }
		triangle { <3.68,-20,1.52>, <5.52,-20,2.28>, <4.2,-20,4.2> }
		triangle { <5.52,-20,2.28>, <3.68,-20,1.52>, <3.79,-20,1> }
		triangle { <3.79,-20,1>, <5.79,-20,1>, <5.52,-20,2.28> }
		triangle { <5.79,-20,1>, <3.79,-20,1>, <3.79,-12,1> }
		triangle { <3.79,-12,1>, <5.79,-12,1>, <5.79,-20,1> }
		triangle { <5.79,-12,1>, <3.79,-12,1>, <4,-12,0> }
		triangle { <4,-12,0>, <6,-12,0>, <5.79,-12,1> }
		triangle { <0,-20,6>, <0,-20,4>, <-1.52,-20,3.68> }
		triangle { <-1.52,-20,3.68>, <-2.28,-20,5.52>, <0,-20,6> }
		triangle { <-2.28,-20,5.52>, <-1.52,-20,3.68>, <-2.8,-20,2.8> }
		triangle { <-2.8,-20,2.8>, <-4.2,-20,4.2>, <-2.28,-20,5.52> }
		triangle { <-4.2,-20,4.2>, <-2.8,-20,2.8>, <-3.68,-20,1.52> }
		triangle { <-3.68,-20,1.52>, <-5.52,-20,2.28>, <-4.2,-20,4.2> }
		triangle { <-5.52,-20,2.28>, <-3.68,-20,1.52>, <-3.79,-20,1> }
		triangle { <-3.79,-20,1>, <-5.79,-20,1>, <-5.52,-20,2.28> }
		triangle { <-5.79,-20,1>, <-3.79,-20,1>, <-3.79,-12,1> }
		triangle { <-3.79,-12,1>, <-5.79,-12,1>, <-5.79,-20,1> }
		triangle { <-5.79,-12,1>, <-3.79,-12,1>, <-4,-12,0> }
		triangle { <-4,-12,0>, <-6,-12,0>, <-5.79,-12,1> }
		triangle { <0,-20,-6>, <0,-20,-4>, <1.52,-20,-3.68> }
		triangle { <1.52,-20,-3.68>, <2.28,-20,-5.52>, <0,-20,-6> }
		triangle { <2.28,-20,-5.52>, <1.52,-20,-3.68>, <2.8,-20,-2.8> }
		triangle { <2.8,-20,-2.8>, <4.2,-20,-4.2>, <2.28,-20,-5.52> }
		triangle { <4.2,-20,-4.2>, <2.8,-20,-2.8>, <3.68,-20,-1.52> }
		triangle { <3.68,-20,-1.52>, <5.52,-20,-2.28>, <4.2,-20,-4.2> }
		triangle { <5.52,-20,-2.28>, <3.68,-20,-1.52>, <3.79,-20,-1> }
		triangle { <3.79,-20,-1>, <5.79,-20,-1>, <5.52,-20,-2.28> }
		triangle { <5.79,-20,-1>, <3.79,-20,-1>, <3.79,-12,-1> }
		triangle { <3.79,-12,-1>, <5.79,-12,-1>, <5.79,-20,-1> }
		triangle { <5.79,-12,-1>, <3.79,-12,-1>, <4,-12,0> }
		triangle { <4,-12,0>, <6,-12,0>, <5.79,-12,-1> }
		triangle { <0,-20,-6>, <0,-20,-4>, <-1.52,-20,-3.68> }
		triangle { <-1.52,-20,-3.68>, <-2.28,-20,-5.52>, <0,-20,-6> }
		triangle { <-2.28,-20,-5.52>, <-1.52,-20,-3.68>, <-2.8,-20,-2.8> }
		triangle { <-2.8,-20,-2.8>, <-4.2,-20,-4.2>, <-2.28,-20,-5.52> }
		triangle { <-4.2,-20,-4.2>, <-2.8,-20,-2.8>, <-3.68,-20,-1.52> }
		triangle { <-3.68,-20,-1.52>, <-5.52,-20,-2.28>, <-4.2,-20,-4.2> }
		triangle { <-5.52,-20,-2.28>, <-3.68,-20,-1.52>, <-3.79,-20,-1> }
		triangle { <-3.79,-20,-1>, <-5.79,-20,-1>, <-5.52,-20,-2.28> }
		triangle { <-5.79,-20,-1>, <-3.79,-20,-1>, <-3.79,-12,-1> }
		triangle { <-3.79,-12,-1>, <-5.79,-12,-1>, <-5.79,-20,-1> }
		triangle { <-5.79,-12,-1>, <-3.79,-12,-1>, <-4,-12,0> }
		triangle { <-4,-12,0>, <-6,-12,0>, <-5.79,-12,-1> }
		triangle { <0,-12,6>, <0,-20,6>, <2.28,-20,5.52> }
		triangle { <2.28,-20,5.52>, <2.28,-12,5.52>, <0,-12,6> }
		triangle { <2.28,-12,5.52>, <2.28,-20,5.52>, <4.2,-20,4.2> }
		triangle { <4.2,-20,4.2>, <4.2,-12,4.2>, <2.28,-12,5.52> }
		triangle { <4.2,-12,4.2>, <4.2,-20,4.2>, <5.52,-20,2.28> }
		triangle { <5.52,-20,2.28>, <5.52,-12,2.28>, <4.2,-12,4.2> }
		triangle { <5.52,-12,2.28>, <5.52,-20,2.28>, <5.79,-20,1> }
		triangle { <5.79,-20,1>, <5.79,-12,1>, <5.52,-12,2.28> }
		triangle { <0,-12,6>, <0,-20,6>, <-2.28,-20,5.52> }
		triangle { <-2.28,-20,5.52>, <-2.28,-12,5.52>, <0,-12,6> }
		triangle { <-2.28,-12,5.52>, <-2.28,-20,5.52>, <-4.2,-20,4.2> }
		triangle { <-4.2,-20,4.2>, <-4.2,-12,4.2>, <-2.28,-12,5.52> }
		triangle { <-4.2,-12,4.2>, <-4.2,-20,4.2>, <-5.52,-20,2.28> }
		triangle { <-5.52,-20,2.28>, <-5.52,-12,2.28>, <-4.2,-12,4.2> }
		triangle { <-5.52,-12,2.28>, <-5.52,-20,2.28>, <-5.79,-20,1> }
		triangle { <-5.79,-20,1>, <-5.79,-12,1>, <-5.52,-12,2.28> }
		triangle { <0,-12,-6>, <0,-20,-6>, <2.28,-20,-5.52> }
		triangle { <2.28,-20,-5.52>, <2.28,-12,-5.52>, <0,-12,-6> }
		triangle { <2.28,-12,-5.52>, <2.28,-20,-5.52>, <4.2,-20,-4.2> }
		triangle { <4.2,-20,-4.2>, <4.2,-12,-4.2>, <2.28,-12,-5.52> }
		triangle { <4.2,-12,-4.2>, <4.2,-20,-4.2>, <5.52,-20,-2.28> }
		triangle { <5.52,-20,-2.28>, <5.52,-12,-2.28>, <4.2,-12,-4.2> }
		triangle { <5.52,-12,-2.28>, <5.52,-20,-2.28>, <5.79,-20,-1> }
		triangle { <5.79,-20,-1>, <5.79,-12,-1>, <5.52,-12,-2.28> }
		triangle { <0,-12,-6>, <0,-20,-6>, <-2.28,-20,-5.52> }
		triangle { <-2.28,-20,-5.52>, <-2.28,-12,-5.52>, <0,-12,-6> }
		triangle { <-2.28,-12,-5.52>, <-2.28,-20,-5.52>, <-4.2,-20,-4.2> }
		triangle { <-4.2,-20,-4.2>, <-4.2,-12,-4.2>, <-2.28,-12,-5.52> }
		triangle { <-4.2,-12,-4.2>, <-4.2,-20,-4.2>, <-5.52,-20,-2.28> }
		triangle { <-5.52,-20,-2.28>, <-5.52,-12,-2.28>, <-4.2,-12,-4.2> }
		triangle { <-5.52,-12,-2.28>, <-5.52,-20,-2.28>, <-5.79,-20,-1> }
		triangle { <-5.79,-20,-1>, <-5.79,-12,-1>, <-5.52,-12,-2.28> }
		triangle { <0,-12,4>, <0,-20,4>, <1.52,-20,3.68> }
		triangle { <1.52,-20,3.68>, <1.52,-12,3.68>, <0,-12,4> }
		triangle { <1.52,-12,3.68>, <1.52,-20,3.68>, <2.8,-20,2.8> }
		triangle { <2.8,-20,2.8>, <2.8,-12,2.8>, <1.52,-12,3.68> }
		triangle { <2.8,-12,2.8>, <2.8,-20,2.8>, <3.68,-20,1.52> }
		triangle { <3.68,-20,1.52>, <3.68,-12,1.52>, <2.8,-12,2.8> }
		triangle { <3.68,-12,1.52>, <3.68,-20,1.52>, <3.79,-20,1> }
		triangle { <3.79,-20,1>, <3.79,-12,1>, <3.68,-12,1.52> }
		triangle { <0,-12,4>, <0,-20,4>, <-1.52,-20,3.68> }
		triangle { <-1.52,-20,3.68>, <-1.52,-12,3.68>, <0,-12,4> }
		triangle { <-1.52,-12,3.68>, <-1.52,-20,3.68>, <-2.8,-20,2.8> }
		triangle { <-2.8,-20,2.8>, <-2.8,-12,2.8>, <-1.52,-12,3.68> }
		triangle { <-2.8,-12,2.8>, <-2.8,-20,2.8>, <-3.68,-20,1.52> }
		triangle { <-3.68,-20,1.52>, <-3.68,-12,1.52>, <-2.8,-12,2.8> }
		triangle { <-3.68,-12,1.52>, <-3.68,-20,1.52>, <-3.79,-20,1> }
		triangle { <-3.79,-20,1>, <-3.79,-12,1>, <-3.68,-12,1.52> }
		triangle { <0,-12,-4>, <0,-20,-4>, <1.52,-20,-3.68> }
		triangle { <1.52,-20,-3.68>, <1.52,-12,-3.68>, <0,-12,-4> }
		triangle { <1.52,-12,-3.68>, <1.52,-20,-3.68>, <2.8,-20,-2.8> }
		triangle { <2.8,-20,-2.8>, <2.8,-12,-2.8>, <1.52,-12,-3.68> }
		triangle { <2.8,-12,-2.8>, <2.8,-20,-2.8>, <3.68,-20,-1.52> }
		triangle { <3.68,-20,-1.52>, <3.68,-12,-1.52>, <2.8,-12,-2.8> }
		triangle { <3.68,-12,-1.52>, <3.68,-20,-1.52>, <3.79,-20,-1> }
		triangle { <3.79,-20,-1>, <3.79,-12,-1>, <3.68,-12,-1.52> }
		triangle { <0,-12,-4>, <0,-20,-4>, <-1.52,-20,-3.68> }
		triangle { <-1.52,-20,-3.68>, <-1.52,-12,-3.68>, <0,-12,-4> }
		triangle { <-1.52,-12,-3.68>, <-1.52,-20,-3.68>, <-2.8,-20,-2.8> }
		triangle { <-2.8,-20,-2.8>, <-2.8,-12,-2.8>, <-1.52,-12,-3.68> }
		triangle { <-2.8,-12,-2.8>, <-2.8,-20,-2.8>, <-3.68,-20,-1.52> }
		triangle { <-3.68,-20,-1.52>, <-3.68,-12,-1.52>, <-2.8,-12,-2.8> }
		triangle { <-3.68,-12,-1.52>, <-3.68,-20,-1.52>, <-3.79,-20,-1> }
		triangle { <-3.79,-20,-1>, <-3.79,-12,-1>, <-3.68,-12,-1.52> }
		triangle { <0,-2,6>, <-2.3,-2,5.54>, <-3.06,-2,7.36> }
		triangle { <-3.06,-2,7.36>, <0,-2,8>, <0,-2,6> }
		triangle { <-2.3,-2,5.54>, <-4.24,-2,4.24>, <-5.6,-2,5.6> }
		triangle { <-5.6,-2,5.6>, <-3.06,-2,7.36>, <-2.3,-2,5.54> }
		triangle { <-4.24,-2,4.24>, <-5.54,-2,2.3>, <-7.36,-2,3.06> }
		triangle { <-7.36,-2,3.06>, <-5.6,-2,5.6>, <-4.24,-2,4.24> }
		triangle { <-5.54,-2,2.3>, <-6,-2,0>, <-8,-2,0> }
		triangle { <-8,-2,0>, <-7.36,-2,3.06>, <-5.54,-2,2.3> }
		triangle { <-6,-2,0>, <-5.54,-2,-2.3>, <-7.36,-2,-3.06> }
		triangle { <-7.36,-2,-3.06>, <-8,-2,0>, <-6,-2,0> }
		triangle { <-5.54,-2,-2.3>, <-4.24,-2,-4.24>, <-5.6,-2,-5.6> }
		triangle { <-5.6,-2,-5.6>, <-7.36,-2,-3.06>, <-5.54,-2,-2.3> }
		triangle { <-4.24,-2,-4.24>, <-2.3,-2,-5.54>, <-3.06,-2,-7.36> }
		triangle { <-3.06,-2,-7.36>, <-5.6,-2,-5.6>, <-4.24,-2,-4.24> }
		triangle { <-2.3,-2,-5.54>, <0,-2,-6>, <0,-2,-8> }
		triangle { <0,-2,-8>, <-3.06,-2,-7.36>, <-2.3,-2,-5.54> }
		triangle { <0,-2,-6>, <2.3,-2,-5.54>, <3.06,-2,-7.36> }
		triangle { <3.06,-2,-7.36>, <0,-2,-8>, <0,-2,-6> }
		triangle { <2.3,-2,-5.54>, <4.24,-2,-4.24>, <5.6,-2,-5.6> }
		triangle { <5.6,-2,-5.6>, <3.06,-2,-7.36>, <2.3,-2,-5.54> }
		triangle { <4.24,-2,-4.24>, <5.54,-2,-2.3>, <7.36,-2,-3.06> }
		triangle { <7.36,-2,-3.06>, <5.6,-2,-5.6>, <4.24,-2,-4.24> }
		triangle { <5.54,-2,-2.3>, <6,-2,0>, <8,-2,0> }
		triangle { <8,-2,0>, <7.36,-2,-3.06>, <5.54,-2,-2.3> }
		triangle { <6,-2,0>, <5.54,-2,2.3>, <7.36,-2,3.06> }
		triangle { <7.36,-2,3.06>, <8,-2,0>, <6,-2,0> }
		triangle { <5.54,-2,2.3>, <4.24,-2,4.24>, <5.6,-2,5.6> }
		triangle { <5.6,-2,5.6>, <7.36,-2,3.06>, <5.54,-2,2.3> }
		triangle { <4.24,-2,4.24>, <2.3,-2,5.54>, <3.06,-2,7.36> }
		triangle { <3.06,-2,7.36>, <5.6,-2,5.6>, <4.24,-2,4.24> }
		triangle { <2.3,-2,5.54>, <0,-2,6>, <0,-2,8> }
		triangle { <0,-2,8>, <3.06,-2,7.36>, <2.3,-2,5.54> }
	}
}

#declare _6232_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <40,24,20> } #else union {
// Brick  2 x  2 with Pin and Axlehole
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,0> }
	#end
	object { axlehole_dot_dat matrix <1,0,0,0,20,0,0,0,1,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,0,4,0> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,1,0,0,0,8,0,4,0> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	mesh {
		triangle { <20,24,20>, <16,24,16>, <-16,24,16> }
		triangle { <-16,24,16>, <-20,24,20>, <20,24,20> }
		triangle { <-20,24,20>, <-16,24,16>, <-16,24,-16> }
		triangle { <-16,24,-16>, <-20,24,-20>, <-20,24,20> }
		triangle { <-20,24,-20>, <-16,24,-16>, <16,24,-16> }
		triangle { <16,24,-16>, <20,24,-20>, <-20,24,-20> }
		triangle { <20,24,-20>, <16,24,-16>, <16,24,16> }
		triangle { <16,24,16>, <20,24,20>, <20,24,-20> }
	}
	object { box4_dot_dat matrix <16,0,0,0,20,0,0,0,16,0,4,0> }
	mesh {
		triangle { <16,4,16>, <8,4,8>, <-8,4,8> }
		triangle { <-8,4,8>, <-16,4,16>, <16,4,16> }
		triangle { <-16,4,16>, <-8,4,8>, <-8,4,-8> }
		triangle { <-8,4,-8>, <-16,4,-16>, <-16,4,16> }
		triangle { <-16,4,-16>, <-8,4,-8>, <8,4,-8> }
		triangle { <8,4,-8>, <16,4,-16>, <-16,4,-16> }
		triangle { <16,4,-16>, <8,4,-8>, <6,4,8> }
		triangle { <6,4,8>, <16,4,16>, <16,4,-16> }
	}
	object { box4_dot_dat matrix <20,0,0,0,24,0,0,0,20,0,0,0> }
	mesh {
		triangle { <20,0,20>, <6,0,6>, <-6,0,6> }
		triangle { <-6,0,6>, <-20,0,20>, <20,0,20> }
		triangle { <-20,0,20>, <-6,0,6>, <-6,0,-6> }
		triangle { <-6,0,-6>, <-20,0,-20>, <-20,0,20> }
		triangle { <-20,0,-20>, <-6,0,-6>, <6,0,-6> }
		triangle { <6,0,-6>, <20,0,-20>, <-20,0,-20> }
		triangle { <20,0,-20>, <6,0,-6>, <6,0,6> }
		triangle { <6,0,6>, <20,0,20>, <20,0,-20> }
	}
	object { connect_dot_dat matrix <0,1,0,-1,0,0,0,0,1,20,10,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _4477_dot_dat = #if (QUAL = 0) box { <-100,-4,-10>, <100,8,10> } #else union {
// Plate  1 x 10
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,0> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <100,8,10>, <96,8,6>, <-96,8,6> }
		triangle { <-96,8,6>, <-100,8,10>, <100,8,10> }
		triangle { <-100,8,10>, <-96,8,6>, <-96,8,-6> }
		triangle { <-96,8,-6>, <-100,8,-10>, <-100,8,10> }
		triangle { <-100,8,-10>, <-96,8,-6>, <96,8,-6> }
		triangle { <96,8,-6>, <100,8,-10>, <-100,8,-10> }
		triangle { <100,8,-10>, <96,8,-6>, <96,8,6> }
		triangle { <96,8,6>, <100,8,10>, <100,8,-10> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-8,0,0,0,10,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,0> }
	#end
}
#end

#declare _3035_dot_dat = #if (QUAL = 0) box { <-80,-4,-40>, <80,8,40> } #else union {
// Plate  4 x  8
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-20> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-4,0,0,0,36,0,8,0> }
	mesh {
		triangle { <80,8,40>, <76,8,36>, <-76,8,36> }
		triangle { <-76,8,36>, <-80,8,40>, <80,8,40> }
		triangle { <80,8,-40>, <76,8,-36>, <-76,8,-36> }
		triangle { <-76,8,-36>, <-80,8,-40>, <80,8,-40> }
		triangle { <80,8,40>, <76,8,36>, <76,8,-36> }
		triangle { <76,8,-36>, <80,8,-40>, <80,8,40> }
		triangle { <-80,8,40>, <-76,8,36>, <-76,8,-36> }
		triangle { <-76,8,-36>, <-80,8,-40>, <-80,8,40> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-8,0,0,0,40,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-30> }
	#end
}
#end

#declare _3710_dot_dat = #if (QUAL = 0) box { <-40,-4,-10>, <40,8,10> } #else union {
// Plate  1 x  4
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <40,8,10>, <36,8,6>, <-36,8,6> }
		triangle { <-36,8,6>, <-40,8,10>, <40,8,10> }
		triangle { <-40,8,10>, <-36,8,6>, <-36,8,-6> }
		triangle { <-36,8,-6>, <-40,8,-10>, <-40,8,10> }
		triangle { <-40,8,-10>, <-36,8,-6>, <36,8,-6> }
		triangle { <36,8,-6>, <40,8,-10>, <-40,8,-10> }
		triangle { <40,8,-10>, <36,8,-6>, <36,8,6> }
		triangle { <36,8,6>, <40,8,10>, <40,8,-10> }
	}
	object { box5_dot_dat matrix <40,0,0,0,-8,0,0,0,10,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
	#end
}
#end

#declare _2540_dot_dat = #if (QUAL = 0) box { <-20,-4,-26>, <20,8,10> } #else union {
// Plate  1 x  2 with Handle
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <-20,8,10>, <-16,8,6>, <-16,8,-6> }
		triangle { <-16,8,-6>, <-20,8,-10>, <-20,8,10> }
		triangle { <-20,8,-10>, <-16,8,-6>, <16,8,-6> }
		triangle { <16,8,-6>, <20,8,-10>, <-20,8,-10> }
		triangle { <20,8,-10>, <16,8,-6>, <16,8,6> }
		triangle { <16,8,6>, <20,8,10>, <20,8,-10> }
		triangle { <20,8,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <20,8,10> }
		triangle { <20,8,10>, <20,0,10>, <20,0,-10> }
		triangle { <20,0,-10>, <20,8,-10>, <20,8,10> }
		triangle { <-20,8,10>, <-20,0,10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <-20,8,10> }
		triangle { <12,8,-10>, <12,0,-10>, <20,0,-10> }
		triangle { <20,0,-10>, <20,8,-10>, <12,8,-10> }
		triangle { <-12,8,-10>, <-12,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <-12,8,-10> }
		triangle { <6,8,-10>, <6,0,-10>, <-6,0,-10> }
		triangle { <-6,0,-10>, <-6,8,-10>, <6,8,-10> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
	}
	object { _4_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,20,2,-20> }
	object { _4_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,-20,2,-20> }
	object { _4_dash_4disc_dot_dat matrix <0,6,0,1,0,0,0,0,6,12,2,-20> }
	object { _4_dash_4disc_dot_dat matrix <0,6,0,1,0,0,0,0,6,6,2,-20> }
	object { _4_dash_4disc_dot_dat matrix <0,6,0,1,0,0,0,0,6,-6,2,-20> }
	object { _4_dash_4disc_dot_dat matrix <0,6,0,1,0,0,0,0,6,-12,2,-20> }
	mesh {
		triangle { <12,8,-10>, <12,0,-10>, <12,0,-20> }
		triangle { <12,0,-20>, <12,8,-20>, <12,8,-10> }
		triangle { <6,8,-10>, <6,0,-10>, <6,0,-20> }
		triangle { <6,0,-20>, <6,8,-20>, <6,8,-10> }
		triangle { <-6,8,-10>, <-6,0,-10>, <-6,0,-20> }
		triangle { <-6,0,-20>, <-6,8,-20>, <-6,8,-10> }
		triangle { <-12,8,-10>, <-12,0,-10>, <-12,0,-20> }
		triangle { <-12,0,-20>, <-12,8,-20>, <-12,8,-10> }
		triangle { <12,8,-10>, <12,8,-20>, <6,8,-20> }
		triangle { <6,8,-20>, <6,8,-10>, <12,8,-10> }
	}
	object { _2_dash_4cyli_dot_dat matrix <0,6,0,-6,0,0,0,0,-6,12,2,-20> }
	object { _1_dash_8cyli_dot_dat matrix <0,-6,0,-6,0,0,0,0,6,12,2,-20> }
	mesh {
		triangle { <12,-2.24,-15.76>, <12,0,-14.39>, <6,0,-14.39> }
		triangle { <6,0,-14.39>, <6,-2.24,-15.76>, <12,-2.24,-15.76> }
		triangle { <12,0,-14.39>, <12,0,-10>, <6,0,-10> }
		triangle { <6,0,-10>, <6,0,-14.39>, <12,0,-14.39> }
		triangle { <-12,8,-10>, <-12,8,-20>, <-6,8,-20> }
		triangle { <-6,8,-20>, <-6,8,-10>, <-12,8,-10> }
	}
	object { _2_dash_4cyli_dot_dat matrix <0,6,0,6,0,0,0,0,-6,-12,2,-20> }
	object { _1_dash_8cyli_dot_dat matrix <0,-6,0,6,0,0,0,0,6,-12,2,-20> }
	mesh {
		triangle { <-12,-2.24,-15.76>, <-12,0,-14.39>, <-6,0,-14.39> }
		triangle { <-6,0,-14.39>, <-6,-2.24,-15.76>, <-12,-2.24,-15.76> }
		triangle { <-12,0,-14.39>, <-12,0,-10>, <-6,0,-10> }
		triangle { <-6,0,-10>, <-6,0,-14.39>, <-12,0,-14.39> }
	}
	object { _4_dash_4cyli_dot_dat matrix <0,4,0,-40,0,0,0,0,4,20,2,-20> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
}
#end

#declare _3747_dot_dat = #if (QUAL = 0) box { <-20,-4,-50>, <20,24,10> } #else union {
// Slope Brick 33  3 x  2 Inverted
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,4,0,0,10,13,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,-4,0,0,10,13,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,4,0,0,-10,13,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,-4,0,0,-10,13,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,6,0,0,10,12,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,-6,0,0,10,12,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,6,0,0,-10,12,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,-6,0,0,-10,12,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,4,0,0,10,3,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,-4,0,0,10,3,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,4,0,0,-10,3,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,-4,0,0,-10,3,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,6,0,0,10,2,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,-6,0,0,10,2,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,6,0,0,-10,2,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,-6,0,0,-10,2,-40> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,13,0,0,0,4,10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,13,0,0,0,4,-10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,12,0,0,0,6,10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,12,0,0,0,6,-10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,3,0,0,0,4,10,0,-40> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,3,0,0,0,4,-10,0,-40> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,2,0,0,0,6,10,0,-40> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,2,0,0,0,6,-10,0,-40> }
	mesh {
		triangle { <20,24,-10>, <20,4,-50>, <20,0,10> }
		triangle { <20,0,10>, <20,24,10>, <20,24,-10> }
		triangle { <20,24,-10>, <20,4,-50>, <-20,4,-50> }
		triangle { <-20,4,-50>, <-20,24,-10>, <20,24,-10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,-10>, <-20,4,-50>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <-20,24,-10> }
		triangle { <20,0,-50>, <20,4,-50>, <20,0,10> }
		triangle { <20,0,-50>, <20,4,-50>, <-20,4,-50> }
		triangle { <-20,4,-50>, <-20,0,-50>, <20,0,-50> }
		triangle { <-20,0,-50>, <-20,4,-50>, <-20,0,10> }
		triangle { <18,20,-10>, <18,2,-46>, <-18,2,-46> }
		triangle { <-18,2,-46>, <-18,20,-10>, <18,20,-10> }
		triangle { <18,20,-10>, <18,0,-10>, <18,0,-46> }
		triangle { <18,0,-46>, <18,2,-46>, <18,20,-10> }
		triangle { <-18,20,-10>, <-18,0,-10>, <-18,0,-46> }
		triangle { <-18,0,-46>, <-18,2,-46>, <-18,20,-10> }
		triangle { <18,20,-10>, <18,0,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-18,20,-10>, <18,20,-10> }
		triangle { <18,2,-46>, <18,0,-46>, <-18,0,-46> }
		triangle { <-18,0,-46>, <-18,2,-46>, <18,2,-46> }
		triangle { <20,0,10>, <18,0,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <-20,0,10>, <-18,0,-10>, <-18,0,-46> }
		triangle { <-18,0,-46>, <-20,0,-50>, <-20,0,10> }
		triangle { <-20,0,-50>, <-18,0,-46>, <18,0,-46> }
		triangle { <18,0,-46>, <20,0,-50>, <-20,0,-50> }
		triangle { <20,0,-50>, <18,0,-46>, <18,0,-10> }
		triangle { <18,0,-10>, <20,0,10>, <20,0,-50> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-20> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-40> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-20> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-40> }
	#end
}
#end

#declare peghole_dot_dat = union {
	cylinder { <0,0,0>, <0,2,0>, 8 open }
	#if (ver >= 3.1)
		disc { <0,2,0>, <0,1,0>, 8, 6 }
	#else
		difference {
			cylinder { <0,1.999,0>, <0,2.001,0>, 8 }
			cylinder { <0,1,0>, <0,3,0>, 6 }
		}
	#end
}

#declare _3062b_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else union {
// Brick  1 x  1 Round
	object { peghole_dot_dat matrix <1,0,0,0,2.5,0,0,0,1,0,19,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,20,0,0,0,6,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <10,0,0,0,19,0,0,0,10,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,0,0> }
	#if (STUDS)
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	mesh {
		triangle { <0,19,8>, <-3.06,19,7.39>, <-3.83,19,9.24> }
		triangle { <-3.83,19,9.24>, <0,19,10>, <0,19,8> }
		triangle { <0,4,4>, <-1.53,4,3.7>, <-2.3,4,5.54> }
		triangle { <-2.3,4,5.54>, <0,4,6>, <0,4,4> }
		triangle { <0,0,6>, <-2.3,0,5.54>, <-3.83,0,9.24> }
		triangle { <-3.83,0,9.24>, <0,0,10>, <0,0,6> }
		triangle { <-3.06,19,7.39>, <-5.66,19,5.66>, <-7.07,19,7.07> }
		triangle { <-7.07,19,7.07>, <-3.83,19,9.24>, <-3.06,19,7.39> }
		triangle { <-1.53,4,3.7>, <-2.83,4,2.83>, <-4.24,4,4.24> }
		triangle { <-4.24,4,4.24>, <-2.3,4,5.54>, <-1.53,4,3.7> }
		triangle { <-2.3,0,5.54>, <-4.24,0,4.24>, <-7.07,0,7.07> }
		triangle { <-7.07,0,7.07>, <-3.83,0,9.24>, <-2.3,0,5.54> }
		triangle { <-5.66,19,5.66>, <-7.39,19,3.06>, <-9.24,19,3.83> }
		triangle { <-9.24,19,3.83>, <-7.07,19,7.07>, <-5.66,19,5.66> }
		triangle { <-2.83,4,2.83>, <-3.7,4,1.53>, <-5.54,4,2.3> }
		triangle { <-5.54,4,2.3>, <-4.24,4,4.24>, <-2.83,4,2.83> }
		triangle { <-4.24,0,4.24>, <-5.54,0,2.3>, <-9.24,0,3.83> }
		triangle { <-9.24,0,3.83>, <-7.07,0,7.07>, <-4.24,0,4.24> }
		triangle { <-7.39,19,3.06>, <-8,19,0>, <-10,19,0> }
		triangle { <-10,19,0>, <-9.24,19,3.83>, <-7.39,19,3.06> }
		triangle { <-3.7,4,1.53>, <-4,4,0>, <-6,4,0> }
		triangle { <-6,4,0>, <-5.54,4,2.3>, <-3.7,4,1.53> }
		triangle { <-5.54,0,2.3>, <-6,0,0>, <-10,0,0> }
		triangle { <-10,0,0>, <-9.24,0,3.83>, <-5.54,0,2.3> }
		triangle { <-8,19,0>, <-7.39,19,-3.06>, <-9.24,19,-3.83> }
		triangle { <-9.24,19,-3.83>, <-10,19,0>, <-8,19,0> }
		triangle { <-4,4,0>, <-3.7,4,-1.53>, <-5.54,4,-2.3> }
		triangle { <-5.54,4,-2.3>, <-6,4,0>, <-4,4,0> }
		triangle { <-6,0,0>, <-5.54,0,-2.3>, <-9.24,0,-3.83> }
		triangle { <-9.24,0,-3.83>, <-10,0,0>, <-6,0,0> }
		triangle { <-7.39,19,-3.06>, <-5.66,19,-5.66>, <-7.07,19,-7.07> }
		triangle { <-7.07,19,-7.07>, <-9.24,19,-3.83>, <-7.39,19,-3.06> }
		triangle { <-3.7,4,-1.53>, <-2.83,4,-2.83>, <-4.24,4,-4.24> }
		triangle { <-4.24,4,-4.24>, <-5.54,4,-2.3>, <-3.7,4,-1.53> }
		triangle { <-5.54,0,-2.3>, <-4.24,0,-4.24>, <-7.07,0,-7.07> }
		triangle { <-7.07,0,-7.07>, <-9.24,0,-3.83>, <-5.54,0,-2.3> }
		triangle { <-5.66,19,-5.66>, <-3.06,19,-7.39>, <-3.83,19,-9.24> }
		triangle { <-3.83,19,-9.24>, <-7.07,19,-7.07>, <-5.66,19,-5.66> }
		triangle { <-2.83,4,-2.83>, <-1.53,4,-3.7>, <-2.3,4,-5.54> }
		triangle { <-2.3,4,-5.54>, <-4.24,4,-4.24>, <-2.83,4,-2.83> }
		triangle { <-4.24,0,-4.24>, <-2.3,0,-5.54>, <-3.83,0,-9.24> }
		triangle { <-3.83,0,-9.24>, <-7.07,0,-7.07>, <-4.24,0,-4.24> }
		triangle { <-3.06,19,-7.39>, <0,19,-8>, <0,19,-10> }
		triangle { <0,19,-10>, <-3.83,19,-9.24>, <-3.06,19,-7.39> }
		triangle { <-1.53,4,-3.7>, <0,4,-4>, <0,4,-6> }
		triangle { <0,4,-6>, <-2.3,4,-5.54>, <-1.53,4,-3.7> }
		triangle { <-2.3,0,-5.54>, <0,0,-6>, <0,0,-10> }
		triangle { <0,0,-10>, <-3.83,0,-9.24>, <-2.3,0,-5.54> }
		triangle { <0,19,-8>, <3.06,19,-7.39>, <3.83,19,-9.24> }
		triangle { <3.83,19,-9.24>, <0,19,-10>, <0,19,-8> }
		triangle { <0,4,-4>, <1.53,4,-3.7>, <2.3,4,-5.54> }
		triangle { <2.3,4,-5.54>, <0,4,-6>, <0,4,-4> }
		triangle { <0,0,-6>, <2.3,0,-5.54>, <3.83,0,-9.24> }
		triangle { <3.83,0,-9.24>, <0,0,-10>, <0,0,-6> }
		triangle { <3.06,19,-7.39>, <5.66,19,-5.66>, <7.07,19,-7.07> }
		triangle { <7.07,19,-7.07>, <3.83,19,-9.24>, <3.06,19,-7.39> }
		triangle { <1.53,4,-3.7>, <2.83,4,-2.83>, <4.24,4,-4.24> }
		triangle { <4.24,4,-4.24>, <2.3,4,-5.54>, <1.53,4,-3.7> }
		triangle { <2.3,0,-5.54>, <4.24,0,-4.24>, <7.07,0,-7.07> }
		triangle { <7.07,0,-7.07>, <3.83,0,-9.24>, <2.3,0,-5.54> }
		triangle { <5.66,19,-5.66>, <7.39,19,-3.06>, <9.24,19,-3.83> }
		triangle { <9.24,19,-3.83>, <7.07,19,-7.07>, <5.66,19,-5.66> }
		triangle { <2.83,4,-2.83>, <3.7,4,-1.53>, <5.54,4,-2.3> }
		triangle { <5.54,4,-2.3>, <4.24,4,-4.24>, <2.83,4,-2.83> }
		triangle { <4.24,0,-4.24>, <5.54,0,-2.3>, <9.24,0,-3.83> }
		triangle { <9.24,0,-3.83>, <7.07,0,-7.07>, <4.24,0,-4.24> }
		triangle { <7.39,19,-3.06>, <8,19,0>, <10,19,0> }
		triangle { <10,19,0>, <9.24,19,-3.83>, <7.39,19,-3.06> }
		triangle { <3.7,4,-1.53>, <4,4,0>, <6,4,0> }
		triangle { <6,4,0>, <5.54,4,-2.3>, <3.7,4,-1.53> }
		triangle { <5.54,0,-2.3>, <6,0,0>, <10,0,0> }
		triangle { <10,0,0>, <9.24,0,-3.83>, <5.54,0,-2.3> }
		triangle { <8,19,0>, <7.39,19,3.06>, <9.24,19,3.83> }
		triangle { <9.24,19,3.83>, <10,19,0>, <8,19,0> }
		triangle { <4,4,0>, <3.7,4,1.53>, <5.54,4,2.3> }
		triangle { <5.54,4,2.3>, <6,4,0>, <4,4,0> }
		triangle { <6,0,0>, <5.54,0,2.3>, <9.24,0,3.83> }
		triangle { <9.24,0,3.83>, <10,0,0>, <6,0,0> }
		triangle { <7.39,19,3.06>, <5.66,19,5.66>, <7.07,19,7.07> }
		triangle { <7.07,19,7.07>, <9.24,19,3.83>, <7.39,19,3.06> }
		triangle { <3.7,4,1.53>, <2.83,4,2.83>, <4.24,4,4.24> }
		triangle { <4.24,4,4.24>, <5.54,4,2.3>, <3.7,4,1.53> }
		triangle { <5.54,0,2.3>, <4.24,0,4.24>, <7.07,0,7.07> }
		triangle { <7.07,0,7.07>, <9.24,0,3.83>, <5.54,0,2.3> }
		triangle { <5.66,19,5.66>, <3.06,19,7.39>, <3.83,19,9.24> }
		triangle { <3.83,19,9.24>, <7.07,19,7.07>, <5.66,19,5.66> }
		triangle { <2.83,4,2.83>, <1.53,4,3.7>, <2.3,4,5.54> }
		triangle { <2.3,4,5.54>, <4.24,4,4.24>, <2.83,4,2.83> }
		triangle { <4.24,0,4.24>, <2.3,0,5.54>, <3.83,0,9.24> }
		triangle { <3.83,0,9.24>, <7.07,0,7.07>, <4.24,0,4.24> }
		triangle { <3.06,19,7.39>, <0,19,8>, <0,19,10> }
		triangle { <0,19,10>, <3.83,19,9.24>, <3.06,19,7.39> }
		triangle { <1.53,4,3.7>, <0,4,4>, <0,4,6> }
		triangle { <0,4,6>, <2.3,4,5.54>, <1.53,4,3.7> }
		triangle { <2.3,0,5.54>, <0,0,6>, <0,0,10> }
		triangle { <0,0,10>, <3.83,0,9.24>, <2.3,0,5.54> }
	}
}
#end

#declare _3001_dot_dat = #if (QUAL = 0) box { <-40,-4,-20>, <40,24,20> } #else union {
// Brick  2 x  4
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-20,0,0,0,16,0,24,0> }
	mesh {
		triangle { <40,24,20>, <36,24,16>, <-36,24,16> }
		triangle { <-36,24,16>, <-40,24,20>, <40,24,20> }
		triangle { <-40,24,20>, <-36,24,16>, <-36,24,-16> }
		triangle { <-36,24,-16>, <-40,24,-20>, <-40,24,20> }
		triangle { <-40,24,-20>, <-36,24,-16>, <36,24,-16> }
		triangle { <36,24,-16>, <40,24,-20>, <-40,24,-20> }
		triangle { <40,24,-20>, <36,24,-16>, <36,24,16> }
		triangle { <36,24,16>, <40,24,20>, <40,24,-20> }
	}
	object { box5_dot_dat matrix <40,0,0,0,-24,0,0,0,20,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
	#end
}
#end

#declare ring4_dot_dat = #if (ver >= 3.1)
	disc { <0,0,0>, <0,1,0>, 5, 4 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 5 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 4 }
	}
#end

#declare ring1_dot_dat = #if (ver >= 3.1)
	disc { <0,0,0>, <0,1,0>, 2, 1 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 2 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 1 }
	}
#end

#declare ring10_dot_dat = #if (ver >= 3.1)
	disc { <0,0,0>, <0,1,0>, 11, 10 }
#else
	difference {
		cylinder { <0,-0.001,0>, <0,0.001,0>, 11 }
		cylinder { <0,-0.002,0>, <0,0.002,0>, 10 }
	}
#end

#declare _6248_dot_dat = #if (QUAL = 0) box { <-22,-22,-13>, <22,22,10> } #else union {
// Wheel Freestyle
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,0,0,-9> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,0,0,10> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,16,0,6,0,0,0,-8> }
	object { _4_dash_4cyli_dot_dat matrix <10,0,0,0,0,17,0,10,0,0,0,-7> }
	object { _4_dash_4cyli_dot_dat matrix <16,0,0,0,0,14,0,16,0,0,0,-7> }
	object { _4_dash_4cyli_dot_dat matrix <19,0,0,0,0,12,0,19,0,0,0,-6> }
	object { _4_dash_4cyli_dot_dat matrix <22,0,0,0,0,2,0,22,0,0,0,-9> }
	object { _4_dash_4cyli_dot_dat matrix <22,0,0,0,0,2,0,22,0,0,0,7> }
	object { ring4_dot_dat matrix <2,0,0,0,0,1,0,2,0,0,0,10> }
	object { ring1_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,0,-9> }
	object { ring1_dot_dat matrix <11,0,0,0,0,1,0,11,0,0,0,-9> }
	object { ring1_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,0,-7> }
	object { ring10_dot_dat matrix <1.9,0,0,0,0,1,0,1.9,0,0,0,9> }
	object { ring10_dot_dat matrix <2,0,0,0,0,1,0,2,0,0,0,9> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,0,1,0,1,0,10,10,-9> }
		object { stud_dot_dat matrix <1,0,0,0,0,1,0,1,0,-10,10,-9> }
		object { stud_dot_dat matrix <1,0,0,0,0,1,0,1,0,10,-10,-9> }
		object { stud_dot_dat matrix <1,0,0,0,0,1,0,1,0,-10,-10,-9> }
	#end
	mesh {
		triangle { <16,0,7>, <14.78,-6.12,7>, <17.55,-7.27,9> }
		triangle { <17.55,-7.27,9>, <19,0,9>, <16,0,7> }
		triangle { <22,0,7>, <20.33,-8.42,7>, <17.55,-7.27,6> }
		triangle { <17.55,-7.27,6>, <19,0,6>, <22,0,7> }
		triangle { <22,0,-7>, <20.33,-8.42,-7>, <17.55,-7.27,-6> }
		triangle { <17.55,-7.27,-6>, <19,0,-6>, <22,0,-7> }
		triangle { <14.78,-6.12,7>, <11.31,-11.31,7>, <13.44,-13.44,9> }
		triangle { <13.44,-13.44,9>, <17.55,-7.27,9>, <14.78,-6.12,7> }
		triangle { <20.33,-8.42,7>, <15.56,-15.56,7>, <13.44,-13.44,6> }
		triangle { <13.44,-13.44,6>, <17.55,-7.27,6>, <20.33,-8.42,7> }
		triangle { <20.33,-8.42,-7>, <15.56,-15.56,-7>, <13.44,-13.44,-6> }
		triangle { <13.44,-13.44,-6>, <17.55,-7.27,-6>, <20.33,-8.42,-7> }
		triangle { <11.31,-11.31,7>, <6.12,-14.78,7>, <7.27,-17.55,9> }
		triangle { <7.27,-17.55,9>, <13.44,-13.44,9>, <11.31,-11.31,7> }
		triangle { <15.56,-15.56,7>, <8.42,-20.33,7>, <7.27,-17.55,6> }
		triangle { <7.27,-17.55,6>, <13.44,-13.44,6>, <15.56,-15.56,7> }
		triangle { <15.56,-15.56,-7>, <8.42,-20.33,-7>, <7.27,-17.55,-6> }
		triangle { <7.27,-17.55,-6>, <13.44,-13.44,-6>, <15.56,-15.56,-7> }
		triangle { <6.12,-14.78,7>, <0,-16,7>, <0,-19,9> }
		triangle { <0,-19,9>, <7.27,-17.55,9>, <6.12,-14.78,7> }
		triangle { <8.42,-20.33,7>, <0,-22,7>, <0,-19,6> }
		triangle { <0,-19,6>, <7.27,-17.55,6>, <8.42,-20.33,7> }
		triangle { <8.42,-20.33,-7>, <0,-22,-7>, <0,-19,-6> }
		triangle { <0,-19,-6>, <7.27,-17.55,-6>, <8.42,-20.33,-7> }
		triangle { <0,-16,7>, <-6.12,-14.78,7>, <-7.27,-17.55,9> }
		triangle { <-7.27,-17.55,9>, <0,-19,9>, <0,-16,7> }
		triangle { <0,-22,7>, <-8.42,-20.33,7>, <-7.27,-17.55,6> }
		triangle { <-7.27,-17.55,6>, <0,-19,6>, <0,-22,7> }
		triangle { <0,-22,-7>, <-8.42,-20.33,-7>, <-7.27,-17.55,-6> }
		triangle { <-7.27,-17.55,-6>, <0,-19,-6>, <0,-22,-7> }
		triangle { <-6.12,-14.78,7>, <-11.31,-11.31,7>, <-13.44,-13.44,9> }
		triangle { <-13.44,-13.44,9>, <-7.27,-17.55,9>, <-6.12,-14.78,7> }
		triangle { <-8.42,-20.33,7>, <-15.56,-15.56,7>, <-13.44,-13.44,6> }
		triangle { <-13.44,-13.44,6>, <-7.27,-17.55,6>, <-8.42,-20.33,7> }
		triangle { <-8.42,-20.33,-7>, <-15.56,-15.56,-7>, <-13.44,-13.44,-6> }
		triangle { <-13.44,-13.44,-6>, <-7.27,-17.55,-6>, <-8.42,-20.33,-7> }
		triangle { <-11.31,-11.31,7>, <-14.78,-6.12,7>, <-17.55,-7.27,9> }
		triangle { <-17.55,-7.27,9>, <-13.44,-13.44,9>, <-11.31,-11.31,7> }
		triangle { <-15.56,-15.56,7>, <-20.33,-8.42,7>, <-17.55,-7.27,6> }
		triangle { <-17.55,-7.27,6>, <-13.44,-13.44,6>, <-15.56,-15.56,7> }
		triangle { <-15.56,-15.56,-7>, <-20.33,-8.42,-7>, <-17.55,-7.27,-6> }
		triangle { <-17.55,-7.27,-6>, <-13.44,-13.44,-6>, <-15.56,-15.56,-7> }
		triangle { <-14.78,-6.12,7>, <-16,0,7>, <-19,0,9> }
		triangle { <-19,0,9>, <-17.55,-7.27,9>, <-14.78,-6.12,7> }
		triangle { <-20.33,-8.42,7>, <-22,0,7>, <-19,0,6> }
		triangle { <-19,0,6>, <-17.55,-7.27,6>, <-20.33,-8.42,7> }
		triangle { <-20.33,-8.42,-7>, <-22,0,-7>, <-19,0,-6> }
		triangle { <-19,0,-6>, <-17.55,-7.27,-6>, <-20.33,-8.42,-7> }
		triangle { <-16,0,7>, <-14.78,6.12,7>, <-17.55,7.27,9> }
		triangle { <-17.55,7.27,9>, <-19,0,9>, <-16,0,7> }
		triangle { <-22,0,7>, <-20.33,8.42,7>, <-17.55,7.27,6> }
		triangle { <-17.55,7.27,6>, <-19,0,6>, <-22,0,7> }
		triangle { <-22,0,-7>, <-20.33,8.42,-7>, <-17.55,7.27,-6> }
		triangle { <-17.55,7.27,-6>, <-19,0,-6>, <-22,0,-7> }
		triangle { <-14.78,6.12,7>, <-11.31,11.31,7>, <-13.44,13.44,9> }
		triangle { <-13.44,13.44,9>, <-17.55,7.27,9>, <-14.78,6.12,7> }
		triangle { <-20.33,8.42,7>, <-15.56,15.56,7>, <-13.44,13.44,6> }
		triangle { <-13.44,13.44,6>, <-17.55,7.27,6>, <-20.33,8.42,7> }
		triangle { <-20.33,8.42,-7>, <-15.56,15.56,-7>, <-13.44,13.44,-6> }
		triangle { <-13.44,13.44,-6>, <-17.55,7.27,-6>, <-20.33,8.42,-7> }
		triangle { <-11.31,11.31,7>, <-6.12,14.78,7>, <-7.27,17.55,9> }
		triangle { <-7.27,17.55,9>, <-13.44,13.44,9>, <-11.31,11.31,7> }
		triangle { <-15.56,15.56,7>, <-8.42,20.33,7>, <-7.27,17.55,6> }
		triangle { <-7.27,17.55,6>, <-13.44,13.44,6>, <-15.56,15.56,7> }
		triangle { <-15.56,15.56,-7>, <-8.42,20.33,-7>, <-7.27,17.55,-6> }
		triangle { <-7.27,17.55,-6>, <-13.44,13.44,-6>, <-15.56,15.56,-7> }
		triangle { <-6.12,14.78,7>, <0,16,7>, <0,19,9> }
		triangle { <0,19,9>, <-7.27,17.55,9>, <-6.12,14.78,7> }
		triangle { <-8.42,20.33,7>, <0,22,7>, <0,19,6> }
		triangle { <0,19,6>, <-7.27,17.55,6>, <-8.42,20.33,7> }
		triangle { <-8.42,20.33,-7>, <0,22,-7>, <0,19,-6> }
		triangle { <0,19,-6>, <-7.27,17.55,-6>, <-8.42,20.33,-7> }
		triangle { <0,16,7>, <6.12,14.78,7>, <7.27,17.55,9> }
		triangle { <7.27,17.55,9>, <0,19,9>, <0,16,7> }
		triangle { <0,22,7>, <8.42,20.33,7>, <7.27,17.55,6> }
		triangle { <7.27,17.55,6>, <0,19,6>, <0,22,7> }
		triangle { <0,22,-7>, <8.42,20.33,-7>, <7.27,17.55,-6> }
		triangle { <7.27,17.55,-6>, <0,19,-6>, <0,22,-7> }
		triangle { <6.12,14.78,7>, <11.31,11.31,7>, <13.44,13.44,9> }
		triangle { <13.44,13.44,9>, <7.27,17.55,9>, <6.12,14.78,7> }
		triangle { <8.42,20.33,7>, <15.56,15.56,7>, <13.44,13.44,6> }
		triangle { <13.44,13.44,6>, <7.27,17.55,6>, <8.42,20.33,7> }
		triangle { <8.42,20.33,-7>, <15.56,15.56,-7>, <13.44,13.44,-6> }
		triangle { <13.44,13.44,-6>, <7.27,17.55,-6>, <8.42,20.33,-7> }
		triangle { <11.31,11.31,7>, <14.78,6.12,7>, <17.55,7.27,9> }
		triangle { <17.55,7.27,9>, <13.44,13.44,9>, <11.31,11.31,7> }
		triangle { <15.56,15.56,7>, <20.33,8.42,7>, <17.55,7.27,6> }
		triangle { <17.55,7.27,6>, <13.44,13.44,6>, <15.56,15.56,7> }
		triangle { <15.56,15.56,-7>, <20.33,8.42,-7>, <17.55,7.27,-6> }
		triangle { <17.55,7.27,-6>, <13.44,13.44,-6>, <15.56,15.56,-7> }
		triangle { <14.78,6.12,7>, <16,0,7>, <19,0,9> }
		triangle { <19,0,9>, <17.55,7.27,9>, <14.78,6.12,7> }
		triangle { <20.33,8.42,7>, <22,0,7>, <19,0,6> }
		triangle { <19,0,6>, <17.55,7.27,6>, <20.33,8.42,7> }
		triangle { <20.33,8.42,-7>, <22,0,-7>, <19,0,-6> }
		triangle { <19,0,-6>, <17.55,7.27,-6>, <20.33,8.42,-7> }
	}
}
#end

#declare _4287_dot_dat = #if (QUAL = 0) box { <-10,-4,-50>, <10,24,10> } #else union {
// Slope Brick 33  3 x  1 Inverted
	object { box5_dot_dat matrix <6,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-6> }
		triangle { <-6,24,-6>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,-10>, <-6,24,-6>, <6,24,-6> }
		triangle { <6,24,-6>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <6,24,-6>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-10> }
	}
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,4,0,0,0,13,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,-4,0,0,0,13,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,6,0,0,0,12,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,-6,0,0,0,12,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,4,0,0,0,3,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,2,0,-4,0,0,0,3,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,6,0,0,0,2,-40> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,3,0,-6,0,0,0,2,-40> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,13,0,0,0,4,0,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,12,0,0,0,6,0,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,3,0,0,0,4,0,0,-40> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,2,0,0,0,6,0,0,-40> }
	mesh {
		triangle { <10,24,-10>, <10,4,-50>, <10,0,10> }
		triangle { <10,0,10>, <10,24,10>, <10,24,-10> }
		triangle { <10,24,-10>, <10,4,-50>, <-10,4,-50> }
		triangle { <-10,4,-50>, <-10,24,-10>, <10,24,-10> }
		triangle { <10,24,10>, <10,0,10>, <-10,0,10> }
		triangle { <-10,0,10>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,-10>, <-10,4,-50>, <-10,0,10> }
		triangle { <-10,0,10>, <-10,24,10>, <-10,24,-10> }
		triangle { <10,0,-50>, <10,4,-50>, <10,0,10> }
		triangle { <10,0,-50>, <10,4,-50>, <-10,4,-50> }
		triangle { <-10,4,-50>, <-10,0,-50>, <10,0,-50> }
		triangle { <-10,0,-50>, <-10,4,-50>, <-10,0,10> }
		triangle { <8,20,-10>, <8,2,-46>, <-8,2,-46> }
		triangle { <-8,2,-46>, <-8,20,-10>, <8,20,-10> }
		triangle { <8,20,-10>, <8,0,-10>, <8,0,-46> }
		triangle { <8,0,-46>, <8,2,-46>, <8,20,-10> }
		triangle { <-8,20,-10>, <-8,0,-10>, <-8,0,-46> }
		triangle { <-8,0,-46>, <-8,2,-46>, <-8,20,-10> }
		triangle { <8,20,-10>, <8,0,-10>, <-8,0,-10> }
		triangle { <-8,0,-10>, <-8,20,-10>, <8,20,-10> }
		triangle { <8,2,-46>, <8,0,-46>, <-8,0,-46> }
		triangle { <-8,0,-46>, <-8,2,-46>, <8,2,-46> }
		triangle { <10,0,10>, <8,0,-10>, <-8,0,-10> }
		triangle { <-8,0,-10>, <-10,0,10>, <10,0,10> }
		triangle { <-10,0,10>, <-8,0,-10>, <-8,0,-46> }
		triangle { <-8,0,-46>, <-10,0,-50>, <-10,0,10> }
		triangle { <-10,0,-50>, <-8,0,-46>, <8,0,-46> }
		triangle { <8,0,-46>, <10,0,-50>, <-10,0,-50> }
		triangle { <10,0,-50>, <8,0,-46>, <8,0,-10> }
		triangle { <8,0,-10>, <10,0,10>, <10,0,-50> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,-20> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,-40> }
	#end
}
#end

#declare _3020_dot_dat = #if (QUAL = 0) box { <-40,-4,-20>, <40,8,20> } #else union {
// Plate  2 x  4
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <40,8,20>, <36,8,16>, <-36,8,16> }
		triangle { <-36,8,16>, <-40,8,20>, <40,8,20> }
		triangle { <40,8,-20>, <36,8,-16>, <-36,8,-16> }
		triangle { <-36,8,-16>, <-40,8,-20>, <40,8,-20> }
		triangle { <40,8,20>, <36,8,16>, <36,8,-16> }
		triangle { <36,8,-16>, <40,8,-20>, <40,8,20> }
		triangle { <-40,8,20>, <-36,8,16>, <-36,8,-16> }
		triangle { <-36,8,-16>, <-40,8,-20>, <-40,8,20> }
	}
	object { box5_dot_dat matrix <40,0,0,0,-8,0,0,0,20,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
	#end
}
#end

#declare _3795_dot_dat = #if (QUAL = 0) box { <-60,-4,-20>, <60,8,20> } #else union {
// Plate  2 x  6
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
	#end
	object { box5_dot_dat matrix <56,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <60,8,20>, <56,8,16>, <-56,8,16> }
		triangle { <-56,8,16>, <-60,8,20>, <60,8,20> }
		triangle { <60,8,-20>, <56,8,-16>, <-56,8,-16> }
		triangle { <-56,8,-16>, <-60,8,-20>, <60,8,-20> }
		triangle { <60,8,20>, <56,8,16>, <56,8,-16> }
		triangle { <56,8,-16>, <60,8,-20>, <60,8,20> }
		triangle { <-60,8,20>, <-56,8,16>, <-56,8,-16> }
		triangle { <-56,8,-16>, <-60,8,-20>, <-60,8,20> }
	}
	object { box5_dot_dat matrix <60,0,0,0,-8,0,0,0,20,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
	#end
}
#end

#declare _3023_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,8,10> } #else union {
// Plate  1 x  2
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <-20,8,10>, <-16,8,6>, <-16,8,-6> }
		triangle { <-16,8,-6>, <-20,8,-10>, <-20,8,10> }
		triangle { <-20,8,-10>, <-16,8,-6>, <16,8,-6> }
		triangle { <16,8,-6>, <20,8,-10>, <-20,8,-10> }
		triangle { <20,8,-10>, <16,8,-6>, <16,8,6> }
		triangle { <16,8,6>, <20,8,10>, <20,8,-10> }
	}
	object { box5_dot_dat matrix <20,0,0,0,-8,0,0,0,10,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
}
#end

#declare _3010_dot_dat = #if (QUAL = 0) box { <-40,-4,-10>, <40,24,10> } #else union {
// Brick  1 x  4
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <40,24,10>, <36,24,6>, <-36,24,6> }
		triangle { <-36,24,6>, <-40,24,10>, <40,24,10> }
		triangle { <-40,24,10>, <-36,24,6>, <-36,24,-6> }
		triangle { <-36,24,-6>, <-40,24,-10>, <-40,24,10> }
		triangle { <-40,24,-10>, <-36,24,-6>, <36,24,-6> }
		triangle { <36,24,-6>, <40,24,-10>, <-40,24,-10> }
		triangle { <40,24,-10>, <36,24,-6>, <36,24,6> }
		triangle { <36,24,6>, <40,24,10>, <40,24,-10> }
	}
	object { box5_dot_dat matrix <40,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
	#end
}
#end

#declare _2346_dot_dat = #if (QUAL = 0) box { <-35,-35,-20>, <35,35,10> } #else object {
// Tyre Medium
	mesh {
		triangle { <0,20,10>, <0,20,-10>, <3.1287,19.7538,-10> }
		triangle { <3.1287,19.7538,-10>, <3.1287,19.7538,10>, <0,20,10> }
		triangle { <3.1287,19.7538,10>, <3.1287,19.7538,-10>, <6.1803,19.0211,-10> }
		triangle { <6.1803,19.0211,-10>, <6.1803,19.0211,10>, <3.1287,19.7538,10> }
		triangle { <0,25,-20>, <0,20,-10>, <3.1287,19.7538,-10> }
		triangle { <3.1287,19.7538,-10>, <3.9109,24.6922,-20>, <0,25,-20> }
		triangle { <3.9109,24.6922,-20>, <3.1287,19.7538,-10>, <6.1803,19.0211,-10> }
		triangle { <6.1803,19.0211,-10>, <7.7254,23.7764,-20>, <3.9109,24.6922,-20> }
		triangle { <0,25,-20>, <0,30,-20>, <4.693,29.6307,-20> }
		triangle { <4.693,29.6307,-20>, <3.9109,24.6922,-20>, <0,25,-20> }
		triangle { <3.9109,24.6922,-20>, <5.4752,34.5691,-20>, <10.8156,33.287,-20> }
		triangle { <10.8156,33.287,-20>, <7.7254,23.7764,-20>, <3.9109,24.6922,-20> }
		triangle { <0,20,10>, <0,35,10>, <5.4752,34.5691,10> }
		triangle { <5.4752,34.5691,10>, <3.1287,19.7538,10>, <0,20,10> }
		triangle { <3.1287,19.7538,10>, <4.693,29.6307,10>, <9.2705,28.5317,10> }
		triangle { <9.2705,28.5317,10>, <6.1803,19.0211,10>, <3.1287,19.7538,10> }
		triangle { <0,35,-5>, <0,35,10>, <5.4752,34.5691,10> }
		triangle { <5.4752,34.5691,10>, <5.4752,34.5691,-5>, <0,35,-5> }
		triangle { <5.4752,34.5691,-5>, <5.4752,34.5691,-20>, <10.8156,33.287,-20> }
		triangle { <10.8156,33.287,-20>, <10.8156,33.287,-5>, <5.4752,34.5691,-5> }
		triangle { <0,30,-5>, <0,30,-20>, <4.693,29.6307,-20> }
		triangle { <4.693,29.6307,-20>, <4.693,29.6307,-5>, <0,30,-5> }
		triangle { <4.693,29.6307,-5>, <4.693,29.6307,10>, <9.2705,28.5317,10> }
		triangle { <9.2705,28.5317,10>, <9.2705,28.5317,-5>, <4.693,29.6307,-5> }
		triangle { <0,30,-5>, <0,35,-5>, <5.4752,34.5691,-5> }
		triangle { <5.4752,34.5691,-5>, <4.693,29.6307,-5>, <0,30,-5> }
		triangle { <4.693,29.6307,-5>, <5.4752,34.5691,-5>, <10.8156,33.287,-5> }
		triangle { <10.8156,33.287,-5>, <9.2705,28.5317,-5>, <4.693,29.6307,-5> }
		triangle { <0,30,10>, <0,35,10>, <0,35,-20> }
		triangle { <0,35,-20>, <0,30,-20>, <0,30,10> }
		triangle { <4.693,29.6307,10>, <5.4752,34.5691,10>, <5.4752,34.5691,-20> }
		triangle { <5.4752,34.5691,-20>, <4.693,29.6307,-20>, <4.693,29.6307,10> }
		triangle { <6.1803,19.0211,10>, <6.1803,19.0211,-10>, <9.0798,17.8201,-10> }
		triangle { <9.0798,17.8201,-10>, <9.0798,17.8201,10>, <6.1803,19.0211,10> }
		triangle { <9.0798,17.8201,10>, <9.0798,17.8201,-10>, <11.7557,16.1803,-10> }
		triangle { <11.7557,16.1803,-10>, <11.7557,16.1803,10>, <9.0798,17.8201,10> }
		triangle { <7.7254,23.7764,-20>, <6.1803,19.0211,-10>, <9.0798,17.8201,-10> }
		triangle { <9.0798,17.8201,-10>, <11.3498,22.2752,-20>, <7.7254,23.7764,-20> }
		triangle { <11.3498,22.2752,-20>, <9.0798,17.8201,-10>, <11.7557,16.1803,-10> }
		triangle { <11.7557,16.1803,-10>, <14.6946,20.2254,-20>, <11.3498,22.2752,-20> }
		triangle { <7.7254,23.7764,-20>, <9.2705,28.5317,-20>, <13.6197,26.7302,-20> }
		triangle { <13.6197,26.7302,-20>, <11.3498,22.2752,-20>, <7.7254,23.7764,-20> }
		triangle { <11.3498,22.2752,-20>, <15.8897,31.1852,-20>, <20.5725,28.3156,-20> }
		triangle { <20.5725,28.3156,-20>, <14.6946,20.2254,-20>, <11.3498,22.2752,-20> }
		triangle { <6.1803,19.0211,10>, <10.8156,33.287,10>, <15.8897,31.1852,10> }
		triangle { <15.8897,31.1852,10>, <9.0798,17.8201,10>, <6.1803,19.0211,10> }
		triangle { <9.0798,17.8201,10>, <13.6197,26.7302,10>, <17.6336,24.2705,10> }
		triangle { <17.6336,24.2705,10>, <11.7557,16.1803,10>, <9.0798,17.8201,10> }
		triangle { <10.8156,33.287,-5>, <10.8156,33.287,10>, <15.8897,31.1852,10> }
		triangle { <15.8897,31.1852,10>, <15.8897,31.1852,-5>, <10.8156,33.287,-5> }
		triangle { <15.8897,31.1852,-5>, <15.8897,31.1852,-20>, <20.5725,28.3156,-20> }
		triangle { <20.5725,28.3156,-20>, <20.5725,28.3156,-5>, <15.8897,31.1852,-5> }
		triangle { <9.2705,28.5317,-5>, <9.2705,28.5317,-20>, <13.6197,26.7302,-20> }
		triangle { <13.6197,26.7302,-20>, <13.6197,26.7302,-5>, <9.2705,28.5317,-5> }
		triangle { <13.6197,26.7302,-5>, <13.6197,26.7302,10>, <17.6336,24.2705,10> }
		triangle { <17.6336,24.2705,10>, <17.6336,24.2705,-5>, <13.6197,26.7302,-5> }
		triangle { <9.2705,28.5317,-5>, <10.8156,33.287,-5>, <15.8897,31.1852,-5> }
		triangle { <15.8897,31.1852,-5>, <13.6197,26.7302,-5>, <9.2705,28.5317,-5> }
		triangle { <13.6197,26.7302,-5>, <15.8897,31.1852,-5>, <20.5725,28.3156,-5> }
		triangle { <20.5725,28.3156,-5>, <17.6336,24.2705,-5>, <13.6197,26.7302,-5> }
		triangle { <9.2705,28.5317,10>, <10.8156,33.287,10>, <10.8156,33.287,-20> }
		triangle { <10.8156,33.287,-20>, <9.2705,28.5317,-20>, <9.2705,28.5317,10> }
		triangle { <13.6197,26.7302,10>, <15.8897,31.1852,10>, <15.8897,31.1852,-20> }
		triangle { <15.8897,31.1852,-20>, <13.6197,26.7302,-20>, <13.6197,26.7302,10> }
		triangle { <11.7557,16.1803,10>, <11.7557,16.1803,-10>, <14.1421,14.1421,-10> }
		triangle { <14.1421,14.1421,-10>, <14.1421,14.1421,10>, <11.7557,16.1803,10> }
		triangle { <14.1421,14.1421,10>, <14.1421,14.1421,-10>, <16.1803,11.7557,-10> }
		triangle { <16.1803,11.7557,-10>, <16.1803,11.7557,10>, <14.1421,14.1421,10> }
		triangle { <14.6946,20.2254,-20>, <11.7557,16.1803,-10>, <14.1421,14.1421,-10> }
		triangle { <14.1421,14.1421,-10>, <17.6777,17.6777,-20>, <14.6946,20.2254,-20> }
		triangle { <17.6777,17.6777,-20>, <14.1421,14.1421,-10>, <16.1803,11.7557,-10> }
		triangle { <16.1803,11.7557,-10>, <20.2254,14.6946,-20>, <17.6777,17.6777,-20> }
		triangle { <14.6946,20.2254,-20>, <17.6336,24.2705,-20>, <21.2132,21.2132,-20> }
		triangle { <21.2132,21.2132,-20>, <17.6777,17.6777,-20>, <14.6946,20.2254,-20> }
		triangle { <17.6777,17.6777,-20>, <24.7487,24.7487,-20>, <28.3156,20.5725,-20> }
		triangle { <28.3156,20.5725,-20>, <20.2254,14.6946,-20>, <17.6777,17.6777,-20> }
		triangle { <11.7557,16.1803,10>, <20.5725,28.3156,10>, <24.7487,24.7487,10> }
		triangle { <24.7487,24.7487,10>, <14.1421,14.1421,10>, <11.7557,16.1803,10> }
		triangle { <14.1421,14.1421,10>, <21.2132,21.2132,10>, <24.2705,17.6336,10> }
		triangle { <24.2705,17.6336,10>, <16.1803,11.7557,10>, <14.1421,14.1421,10> }
		triangle { <20.5725,28.3156,-5>, <20.5725,28.3156,10>, <24.7487,24.7487,10> }
		triangle { <24.7487,24.7487,10>, <24.7487,24.7487,-5>, <20.5725,28.3156,-5> }
		triangle { <24.7487,24.7487,-5>, <24.7487,24.7487,-20>, <28.3156,20.5725,-20> }
		triangle { <28.3156,20.5725,-20>, <28.3156,20.5725,-5>, <24.7487,24.7487,-5> }
		triangle { <17.6336,24.2705,-5>, <17.6336,24.2705,-20>, <21.2132,21.2132,-20> }
		triangle { <21.2132,21.2132,-20>, <21.2132,21.2132,-5>, <17.6336,24.2705,-5> }
		triangle { <21.2132,21.2132,-5>, <21.2132,21.2132,10>, <24.2705,17.6336,10> }
		triangle { <24.2705,17.6336,10>, <24.2705,17.6336,-5>, <21.2132,21.2132,-5> }
		triangle { <17.6336,24.2705,-5>, <20.5725,28.3156,-5>, <24.7487,24.7487,-5> }
		triangle { <24.7487,24.7487,-5>, <21.2132,21.2132,-5>, <17.6336,24.2705,-5> }
		triangle { <21.2132,21.2132,-5>, <24.7487,24.7487,-5>, <28.3156,20.5725,-5> }
		triangle { <28.3156,20.5725,-5>, <24.2705,17.6336,-5>, <21.2132,21.2132,-5> }
		triangle { <17.6336,24.2705,10>, <20.5725,28.3156,10>, <20.5725,28.3156,-20> }
		triangle { <20.5725,28.3156,-20>, <17.6336,24.2705,-20>, <17.6336,24.2705,10> }
		triangle { <21.2132,21.2132,10>, <24.7487,24.7487,10>, <24.7487,24.7487,-20> }
		triangle { <24.7487,24.7487,-20>, <21.2132,21.2132,-20>, <21.2132,21.2132,10> }
		triangle { <16.1803,11.7557,10>, <16.1803,11.7557,-10>, <17.8201,9.0798,-10> }
		triangle { <17.8201,9.0798,-10>, <17.8201,9.0798,10>, <16.1803,11.7557,10> }
		triangle { <17.8201,9.0798,10>, <17.8201,9.0798,-10>, <19.0211,6.1803,-10> }
		triangle { <19.0211,6.1803,-10>, <19.0211,6.1803,10>, <17.8201,9.0798,10> }
		triangle { <20.2254,14.6946,-20>, <16.1803,11.7557,-10>, <17.8201,9.0798,-10> }
		triangle { <17.8201,9.0798,-10>, <22.2752,11.3498,-20>, <20.2254,14.6946,-20> }
		triangle { <22.2752,11.3498,-20>, <17.8201,9.0798,-10>, <19.0211,6.1803,-10> }
		triangle { <19.0211,6.1803,-10>, <23.7764,7.7254,-20>, <22.2752,11.3498,-20> }
		triangle { <20.2254,14.6946,-20>, <24.2705,17.6336,-20>, <26.7302,13.6197,-20> }
		triangle { <26.7302,13.6197,-20>, <22.2752,11.3498,-20>, <20.2254,14.6946,-20> }
		triangle { <22.2752,11.3498,-20>, <31.1852,15.8897,-20>, <33.287,10.8156,-20> }
		triangle { <33.287,10.8156,-20>, <23.7764,7.7254,-20>, <22.2752,11.3498,-20> }
		triangle { <16.1803,11.7557,10>, <28.3156,20.5725,10>, <31.1852,15.8897,10> }
		triangle { <31.1852,15.8897,10>, <17.8201,9.0798,10>, <16.1803,11.7557,10> }
		triangle { <17.8201,9.0798,10>, <26.7302,13.6197,10>, <28.5317,9.2705,10> }
		triangle { <28.5317,9.2705,10>, <19.0211,6.1803,10>, <17.8201,9.0798,10> }
		triangle { <28.3156,20.5725,-5>, <28.3156,20.5725,10>, <31.1852,15.8897,10> }
		triangle { <31.1852,15.8897,10>, <31.1852,15.8897,-5>, <28.3156,20.5725,-5> }
		triangle { <31.1852,15.8897,-5>, <31.1852,15.8897,-20>, <33.287,10.8156,-20> }
		triangle { <33.287,10.8156,-20>, <33.287,10.8156,-5>, <31.1852,15.8897,-5> }
		triangle { <24.2705,17.6336,-5>, <24.2705,17.6336,-20>, <26.7302,13.6197,-20> }
		triangle { <26.7302,13.6197,-20>, <26.7302,13.6197,-5>, <24.2705,17.6336,-5> }
		triangle { <26.7302,13.6197,-5>, <26.7302,13.6197,10>, <28.5317,9.2705,10> }
		triangle { <28.5317,9.2705,10>, <28.5317,9.2705,-5>, <26.7302,13.6197,-5> }
		triangle { <24.2705,17.6336,-5>, <28.3156,20.5725,-5>, <31.1852,15.8897,-5> }
		triangle { <31.1852,15.8897,-5>, <26.7302,13.6197,-5>, <24.2705,17.6336,-5> }
		triangle { <26.7302,13.6197,-5>, <31.1852,15.8897,-5>, <33.287,10.8156,-5> }
		triangle { <33.287,10.8156,-5>, <28.5317,9.2705,-5>, <26.7302,13.6197,-5> }
		triangle { <24.2705,17.6336,10>, <28.3156,20.5725,10>, <28.3156,20.5725,-20> }
		triangle { <28.3156,20.5725,-20>, <24.2705,17.6336,-20>, <24.2705,17.6336,10> }
		triangle { <26.7302,13.6197,10>, <31.1852,15.8897,10>, <31.1852,15.8897,-20> }
		triangle { <31.1852,15.8897,-20>, <26.7302,13.6197,-20>, <26.7302,13.6197,10> }
		triangle { <19.0211,6.1803,10>, <19.0211,6.1803,-10>, <19.7538,3.1287,-10> }
		triangle { <19.7538,3.1287,-10>, <19.7538,3.1287,10>, <19.0211,6.1803,10> }
		triangle { <19.7538,3.1287,10>, <19.7538,3.1287,-10>, <20,0,-10> }
		triangle { <20,0,-10>, <20,0,10>, <19.7538,3.1287,10> }
		triangle { <23.7764,7.7254,-20>, <19.0211,6.1803,-10>, <19.7538,3.1287,-10> }
		triangle { <19.7538,3.1287,-10>, <24.6922,3.9109,-20>, <23.7764,7.7254,-20> }
		triangle { <24.6922,3.9109,-20>, <19.7538,3.1287,-10>, <20,0,-10> }
		triangle { <20,0,-10>, <25,0,-20>, <24.6922,3.9109,-20> }
		triangle { <23.7764,7.7254,-20>, <28.5317,9.2705,-20>, <29.6307,4.693,-20> }
		triangle { <29.6307,4.693,-20>, <24.6922,3.9109,-20>, <23.7764,7.7254,-20> }
		triangle { <24.6922,3.9109,-20>, <34.5691,5.4752,-20>, <35,0,-20> }
		triangle { <35,0,-20>, <25,0,-20>, <24.6922,3.9109,-20> }
		triangle { <19.0211,6.1803,10>, <33.287,10.8156,10>, <34.5691,5.4752,10> }
		triangle { <34.5691,5.4752,10>, <19.7538,3.1287,10>, <19.0211,6.1803,10> }
		triangle { <19.7538,3.1287,10>, <29.6307,4.693,10>, <30,0,10> }
		triangle { <30,0,10>, <20,0,10>, <19.7538,3.1287,10> }
		triangle { <33.287,10.8156,-5>, <33.287,10.8156,10>, <34.5691,5.4752,10> }
		triangle { <34.5691,5.4752,10>, <34.5691,5.4752,-5>, <33.287,10.8156,-5> }
		triangle { <34.5691,5.4752,-5>, <34.5691,5.4752,-20>, <35,0,-20> }
		triangle { <35,0,-20>, <35,0,-5>, <34.5691,5.4752,-5> }
		triangle { <28.5317,9.2705,-5>, <28.5317,9.2705,-20>, <29.6307,4.693,-20> }
		triangle { <29.6307,4.693,-20>, <29.6307,4.693,-5>, <28.5317,9.2705,-5> }
		triangle { <29.6307,4.693,-5>, <29.6307,4.693,10>, <30,0,10> }
		triangle { <30,0,10>, <30,0,-5>, <29.6307,4.693,-5> }
		triangle { <28.5317,9.2705,-5>, <33.287,10.8156,-5>, <34.5691,5.4752,-5> }
		triangle { <34.5691,5.4752,-5>, <29.6307,4.693,-5>, <28.5317,9.2705,-5> }
		triangle { <29.6307,4.693,-5>, <34.5691,5.4752,-5>, <35,0,-5> }
		triangle { <35,0,-5>, <30,0,-5>, <29.6307,4.693,-5> }
		triangle { <28.5317,9.2705,10>, <33.287,10.8156,10>, <33.287,10.8156,-20> }
		triangle { <33.287,10.8156,-20>, <28.5317,9.2705,-20>, <28.5317,9.2705,10> }
		triangle { <29.6307,4.693,10>, <34.5691,5.4752,10>, <34.5691,5.4752,-20> }
		triangle { <34.5691,5.4752,-20>, <29.6307,4.693,-20>, <29.6307,4.693,10> }
		triangle { <20,0,10>, <20,0,-10>, <19.7538,-3.1287,-10> }
		triangle { <19.7538,-3.1287,-10>, <19.7538,-3.1287,10>, <20,0,10> }
		triangle { <19.7538,-3.1287,10>, <19.7538,-3.1287,-10>, <19.0211,-6.1803,-10> }
		triangle { <19.0211,-6.1803,-10>, <19.0211,-6.1803,10>, <19.7538,-3.1287,10> }
		triangle { <25,0,-20>, <20,0,-10>, <19.7538,-3.1287,-10> }
		triangle { <19.7538,-3.1287,-10>, <24.6922,-3.9109,-20>, <25,0,-20> }
		triangle { <24.6922,-3.9109,-20>, <19.7538,-3.1287,-10>, <19.0211,-6.1803,-10> }
		triangle { <19.0211,-6.1803,-10>, <23.7764,-7.7254,-20>, <24.6922,-3.9109,-20> }
		triangle { <25,0,-20>, <30,0,-20>, <29.6307,-4.693,-20> }
		triangle { <29.6307,-4.693,-20>, <24.6922,-3.9109,-20>, <25,0,-20> }
		triangle { <24.6922,-3.9109,-20>, <34.5691,-5.4752,-20>, <33.287,-10.8156,-20> }
		triangle { <33.287,-10.8156,-20>, <23.7764,-7.7254,-20>, <24.6922,-3.9109,-20> }
		triangle { <20,0,10>, <35,0,10>, <34.5691,-5.4752,10> }
		triangle { <34.5691,-5.4752,10>, <19.7538,-3.1287,10>, <20,0,10> }
		triangle { <19.7538,-3.1287,10>, <29.6307,-4.693,10>, <28.5317,-9.2705,10> }
		triangle { <28.5317,-9.2705,10>, <19.0211,-6.1803,10>, <19.7538,-3.1287,10> }
		triangle { <35,0,-5>, <35,0,10>, <34.5691,-5.4752,10> }
		triangle { <34.5691,-5.4752,10>, <34.5691,-5.4752,-5>, <35,0,-5> }
		triangle { <34.5691,-5.4752,-5>, <34.5691,-5.4752,-20>, <33.287,-10.8156,-20> }
		triangle { <33.287,-10.8156,-20>, <33.287,-10.8156,-5>, <34.5691,-5.4752,-5> }
		triangle { <30,0,-5>, <30,0,-20>, <29.6307,-4.693,-20> }
		triangle { <29.6307,-4.693,-20>, <29.6307,-4.693,-5>, <30,0,-5> }
		triangle { <29.6307,-4.693,-5>, <29.6307,-4.693,10>, <28.5317,-9.2705,10> }
		triangle { <28.5317,-9.2705,10>, <28.5317,-9.2705,-5>, <29.6307,-4.693,-5> }
		triangle { <30,0,-5>, <35,0,-5>, <34.5691,-5.4752,-5> }
		triangle { <34.5691,-5.4752,-5>, <29.6307,-4.693,-5>, <30,0,-5> }
		triangle { <29.6307,-4.693,-5>, <34.5691,-5.4752,-5>, <33.287,-10.8156,-5> }
		triangle { <33.287,-10.8156,-5>, <28.5317,-9.2705,-5>, <29.6307,-4.693,-5> }
		triangle { <30,0,10>, <35,0,10>, <35,0,-20> }
		triangle { <35,0,-20>, <30,0,-20>, <30,0,10> }
		triangle { <29.6307,-4.693,10>, <34.5691,-5.4752,10>, <34.5691,-5.4752,-20> }
		triangle { <34.5691,-5.4752,-20>, <29.6307,-4.693,-20>, <29.6307,-4.693,10> }
		triangle { <19.0211,-6.1803,10>, <19.0211,-6.1803,-10>, <17.8201,-9.0798,-10> }
		triangle { <17.8201,-9.0798,-10>, <17.8201,-9.0798,10>, <19.0211,-6.1803,10> }
		triangle { <17.8201,-9.0798,10>, <17.8201,-9.0798,-10>, <16.1803,-11.7557,-10> }
		triangle { <16.1803,-11.7557,-10>, <16.1803,-11.7557,10>, <17.8201,-9.0798,10> }
		triangle { <23.7764,-7.7254,-20>, <19.0211,-6.1803,-10>, <17.8201,-9.0798,-10> }
		triangle { <17.8201,-9.0798,-10>, <22.2752,-11.3498,-20>, <23.7764,-7.7254,-20> }
		triangle { <22.2752,-11.3498,-20>, <17.8201,-9.0798,-10>, <16.1803,-11.7557,-10> }
		triangle { <16.1803,-11.7557,-10>, <20.2254,-14.6946,-20>, <22.2752,-11.3498,-20> }
		triangle { <23.7764,-7.7254,-20>, <28.5317,-9.2705,-20>, <26.7302,-13.6197,-20> }
		triangle { <26.7302,-13.6197,-20>, <22.2752,-11.3498,-20>, <23.7764,-7.7254,-20> }
		triangle { <22.2752,-11.3498,-20>, <31.1852,-15.8897,-20>, <28.3156,-20.5725,-20> }
		triangle { <28.3156,-20.5725,-20>, <20.2254,-14.6946,-20>, <22.2752,-11.3498,-20> }
		triangle { <19.0211,-6.1803,10>, <33.287,-10.8156,10>, <31.1852,-15.8897,10> }
		triangle { <31.1852,-15.8897,10>, <17.8201,-9.0798,10>, <19.0211,-6.1803,10> }
		triangle { <17.8201,-9.0798,10>, <26.7302,-13.6197,10>, <24.2705,-17.6336,10> }
		triangle { <24.2705,-17.6336,10>, <16.1803,-11.7557,10>, <17.8201,-9.0798,10> }
		triangle { <33.287,-10.8156,-5>, <33.287,-10.8156,10>, <31.1852,-15.8897,10> }
		triangle { <31.1852,-15.8897,10>, <31.1852,-15.8897,-5>, <33.287,-10.8156,-5> }
		triangle { <31.1852,-15.8897,-5>, <31.1852,-15.8897,-20>, <28.3156,-20.5725,-20> }
		triangle { <28.3156,-20.5725,-20>, <28.3156,-20.5725,-5>, <31.1852,-15.8897,-5> }
		triangle { <28.5317,-9.2705,-5>, <28.5317,-9.2705,-20>, <26.7302,-13.6197,-20> }
		triangle { <26.7302,-13.6197,-20>, <26.7302,-13.6197,-5>, <28.5317,-9.2705,-5> }
		triangle { <26.7302,-13.6197,-5>, <26.7302,-13.6197,10>, <24.2705,-17.6336,10> }
		triangle { <24.2705,-17.6336,10>, <24.2705,-17.6336,-5>, <26.7302,-13.6197,-5> }
		triangle { <28.5317,-9.2705,-5>, <33.287,-10.8156,-5>, <31.1852,-15.8897,-5> }
		triangle { <31.1852,-15.8897,-5>, <26.7302,-13.6197,-5>, <28.5317,-9.2705,-5> }
		triangle { <26.7302,-13.6197,-5>, <31.1852,-15.8897,-5>, <28.3156,-20.5725,-5> }
		triangle { <28.3156,-20.5725,-5>, <24.2705,-17.6336,-5>, <26.7302,-13.6197,-5> }
		triangle { <28.5317,-9.2705,10>, <33.287,-10.8156,10>, <33.287,-10.8156,-20> }
		triangle { <33.287,-10.8156,-20>, <28.5317,-9.2705,-20>, <28.5317,-9.2705,10> }
		triangle { <26.7302,-13.6197,10>, <31.1852,-15.8897,10>, <31.1852,-15.8897,-20> }
		triangle { <31.1852,-15.8897,-20>, <26.7302,-13.6197,-20>, <26.7302,-13.6197,10> }
		triangle { <16.1803,-11.7557,10>, <16.1803,-11.7557,-10>, <14.1421,-14.1421,-10> }
		triangle { <14.1421,-14.1421,-10>, <14.1421,-14.1421,10>, <16.1803,-11.7557,10> }
		triangle { <14.1421,-14.1421,10>, <14.1421,-14.1421,-10>, <11.7557,-16.1803,-10> }
		triangle { <11.7557,-16.1803,-10>, <11.7557,-16.1803,10>, <14.1421,-14.1421,10> }
		triangle { <20.2254,-14.6946,-20>, <16.1803,-11.7557,-10>, <14.1421,-14.1421,-10> }
		triangle { <14.1421,-14.1421,-10>, <17.6777,-17.6777,-20>, <20.2254,-14.6946,-20> }
		triangle { <17.6777,-17.6777,-20>, <14.1421,-14.1421,-10>, <11.7557,-16.1803,-10> }
		triangle { <11.7557,-16.1803,-10>, <14.6946,-20.2254,-20>, <17.6777,-17.6777,-20> }
		triangle { <20.2254,-14.6946,-20>, <24.2705,-17.6336,-20>, <21.2132,-21.2132,-20> }
		triangle { <21.2132,-21.2132,-20>, <17.6777,-17.6777,-20>, <20.2254,-14.6946,-20> }
		triangle { <17.6777,-17.6777,-20>, <24.7487,-24.7487,-20>, <20.5725,-28.3156,-20> }
		triangle { <20.5725,-28.3156,-20>, <14.6946,-20.2254,-20>, <17.6777,-17.6777,-20> }
		triangle { <16.1803,-11.7557,10>, <28.3156,-20.5725,10>, <24.7487,-24.7487,10> }
		triangle { <24.7487,-24.7487,10>, <14.1421,-14.1421,10>, <16.1803,-11.7557,10> }
		triangle { <14.1421,-14.1421,10>, <21.2132,-21.2132,10>, <17.6336,-24.2705,10> }
		triangle { <17.6336,-24.2705,10>, <11.7557,-16.1803,10>, <14.1421,-14.1421,10> }
		triangle { <28.3156,-20.5725,-5>, <28.3156,-20.5725,10>, <24.7487,-24.7487,10> }
		triangle { <24.7487,-24.7487,10>, <24.7487,-24.7487,-5>, <28.3156,-20.5725,-5> }
		triangle { <24.7487,-24.7487,-5>, <24.7487,-24.7487,-20>, <20.5725,-28.3156,-20> }
		triangle { <20.5725,-28.3156,-20>, <20.5725,-28.3156,-5>, <24.7487,-24.7487,-5> }
		triangle { <24.2705,-17.6336,-5>, <24.2705,-17.6336,-20>, <21.2132,-21.2132,-20> }
		triangle { <21.2132,-21.2132,-20>, <21.2132,-21.2132,-5>, <24.2705,-17.6336,-5> }
		triangle { <21.2132,-21.2132,-5>, <21.2132,-21.2132,10>, <17.6336,-24.2705,10> }
		triangle { <17.6336,-24.2705,10>, <17.6336,-24.2705,-5>, <21.2132,-21.2132,-5> }
		triangle { <24.2705,-17.6336,-5>, <28.3156,-20.5725,-5>, <24.7487,-24.7487,-5> }
		triangle { <24.7487,-24.7487,-5>, <21.2132,-21.2132,-5>, <24.2705,-17.6336,-5> }
		triangle { <21.2132,-21.2132,-5>, <24.7487,-24.7487,-5>, <20.5725,-28.3156,-5> }
		triangle { <20.5725,-28.3156,-5>, <17.6336,-24.2705,-5>, <21.2132,-21.2132,-5> }
		triangle { <24.2705,-17.6336,10>, <28.3156,-20.5725,10>, <28.3156,-20.5725,-20> }
		triangle { <28.3156,-20.5725,-20>, <24.2705,-17.6336,-20>, <24.2705,-17.6336,10> }
		triangle { <21.2132,-21.2132,10>, <24.7487,-24.7487,10>, <24.7487,-24.7487,-20> }
		triangle { <24.7487,-24.7487,-20>, <21.2132,-21.2132,-20>, <21.2132,-21.2132,10> }
		triangle { <11.7557,-16.1803,10>, <11.7557,-16.1803,-10>, <9.0798,-17.8201,-10> }
		triangle { <9.0798,-17.8201,-10>, <9.0798,-17.8201,10>, <11.7557,-16.1803,10> }
		triangle { <9.0798,-17.8201,10>, <9.0798,-17.8201,-10>, <6.1803,-19.0211,-10> }
		triangle { <6.1803,-19.0211,-10>, <6.1803,-19.0211,10>, <9.0798,-17.8201,10> }
		triangle { <14.6946,-20.2254,-20>, <11.7557,-16.1803,-10>, <9.0798,-17.8201,-10> }
		triangle { <9.0798,-17.8201,-10>, <11.3498,-22.2752,-20>, <14.6946,-20.2254,-20> }
		triangle { <11.3498,-22.2752,-20>, <9.0798,-17.8201,-10>, <6.1803,-19.0211,-10> }
		triangle { <6.1803,-19.0211,-10>, <7.7254,-23.7764,-20>, <11.3498,-22.2752,-20> }
		triangle { <14.6946,-20.2254,-20>, <17.6336,-24.2705,-20>, <13.6197,-26.7302,-20> }
		triangle { <13.6197,-26.7302,-20>, <11.3498,-22.2752,-20>, <14.6946,-20.2254,-20> }
		triangle { <11.3498,-22.2752,-20>, <15.8897,-31.1852,-20>, <10.8156,-33.287,-20> }
		triangle { <10.8156,-33.287,-20>, <7.7254,-23.7764,-20>, <11.3498,-22.2752,-20> }
		triangle { <11.7557,-16.1803,10>, <20.5725,-28.3156,10>, <15.8897,-31.1852,10> }
		triangle { <15.8897,-31.1852,10>, <9.0798,-17.8201,10>, <11.7557,-16.1803,10> }
		triangle { <9.0798,-17.8201,10>, <13.6197,-26.7302,10>, <9.2705,-28.5317,10> }
		triangle { <9.2705,-28.5317,10>, <6.1803,-19.0211,10>, <9.0798,-17.8201,10> }
		triangle { <20.5725,-28.3156,-5>, <20.5725,-28.3156,10>, <15.8897,-31.1852,10> }
		triangle { <15.8897,-31.1852,10>, <15.8897,-31.1852,-5>, <20.5725,-28.3156,-5> }
		triangle { <15.8897,-31.1852,-5>, <15.8897,-31.1852,-20>, <10.8156,-33.287,-20> }
		triangle { <10.8156,-33.287,-20>, <10.8156,-33.287,-5>, <15.8897,-31.1852,-5> }
		triangle { <17.6336,-24.2705,-5>, <17.6336,-24.2705,-20>, <13.6197,-26.7302,-20> }
		triangle { <13.6197,-26.7302,-20>, <13.6197,-26.7302,-5>, <17.6336,-24.2705,-5> }
		triangle { <13.6197,-26.7302,-5>, <13.6197,-26.7302,10>, <9.2705,-28.5317,10> }
		triangle { <9.2705,-28.5317,10>, <9.2705,-28.5317,-5>, <13.6197,-26.7302,-5> }
		triangle { <17.6336,-24.2705,-5>, <20.5725,-28.3156,-5>, <15.8897,-31.1852,-5> }
		triangle { <15.8897,-31.1852,-5>, <13.6197,-26.7302,-5>, <17.6336,-24.2705,-5> }
		triangle { <13.6197,-26.7302,-5>, <15.8897,-31.1852,-5>, <10.8156,-33.287,-5> }
		triangle { <10.8156,-33.287,-5>, <9.2705,-28.5317,-5>, <13.6197,-26.7302,-5> }
		triangle { <17.6336,-24.2705,10>, <20.5725,-28.3156,10>, <20.5725,-28.3156,-20> }
		triangle { <20.5725,-28.3156,-20>, <17.6336,-24.2705,-20>, <17.6336,-24.2705,10> }
		triangle { <13.6197,-26.7302,10>, <15.8897,-31.1852,10>, <15.8897,-31.1852,-20> }
		triangle { <15.8897,-31.1852,-20>, <13.6197,-26.7302,-20>, <13.6197,-26.7302,10> }
		triangle { <6.1803,-19.0211,10>, <6.1803,-19.0211,-10>, <3.1287,-19.7538,-10> }
		triangle { <3.1287,-19.7538,-10>, <3.1287,-19.7538,10>, <6.1803,-19.0211,10> }
		triangle { <3.1287,-19.7538,10>, <3.1287,-19.7538,-10>, <0,-20,-10> }
		triangle { <0,-20,-10>, <0,-20,10>, <3.1287,-19.7538,10> }
		triangle { <7.7254,-23.7764,-20>, <6.1803,-19.0211,-10>, <3.1287,-19.7538,-10> }
		triangle { <3.1287,-19.7538,-10>, <3.9109,-24.6922,-20>, <7.7254,-23.7764,-20> }
		triangle { <3.9109,-24.6922,-20>, <3.1287,-19.7538,-10>, <0,-20,-10> }
		triangle { <0,-20,-10>, <0,-25,-20>, <3.9109,-24.6922,-20> }
		triangle { <7.7254,-23.7764,-20>, <9.2705,-28.5317,-20>, <4.693,-29.6307,-20> }
		triangle { <4.693,-29.6307,-20>, <3.9109,-24.6922,-20>, <7.7254,-23.7764,-20> }
		triangle { <3.9109,-24.6922,-20>, <5.4752,-34.5691,-20>, <0,-35,-20> }
		triangle { <0,-35,-20>, <0,-25,-20>, <3.9109,-24.6922,-20> }
		triangle { <6.1803,-19.0211,10>, <10.8156,-33.287,10>, <5.4752,-34.5691,10> }
		triangle { <5.4752,-34.5691,10>, <3.1287,-19.7538,10>, <6.1803,-19.0211,10> }
		triangle { <3.1287,-19.7538,10>, <4.693,-29.6307,10>, <0,-30,10> }
		triangle { <0,-30,10>, <0,-20,10>, <3.1287,-19.7538,10> }
		triangle { <10.8156,-33.287,-5>, <10.8156,-33.287,10>, <5.4752,-34.5691,10> }
		triangle { <5.4752,-34.5691,10>, <5.4752,-34.5691,-5>, <10.8156,-33.287,-5> }
		triangle { <5.4752,-34.5691,-5>, <5.4752,-34.5691,-20>, <0,-35,-20> }
		triangle { <0,-35,-20>, <0,-35,-5>, <5.4752,-34.5691,-5> }
		triangle { <9.2705,-28.5317,-5>, <9.2705,-28.5317,-20>, <4.693,-29.6307,-20> }
		triangle { <4.693,-29.6307,-20>, <4.693,-29.6307,-5>, <9.2705,-28.5317,-5> }
		triangle { <4.693,-29.6307,-5>, <4.693,-29.6307,10>, <0,-30,10> }
		triangle { <0,-30,10>, <0,-30,-5>, <4.693,-29.6307,-5> }
		triangle { <9.2705,-28.5317,-5>, <10.8156,-33.287,-5>, <5.4752,-34.5691,-5> }
		triangle { <5.4752,-34.5691,-5>, <4.693,-29.6307,-5>, <9.2705,-28.5317,-5> }
		triangle { <4.693,-29.6307,-5>, <5.4752,-34.5691,-5>, <0,-35,-5> }
		triangle { <0,-35,-5>, <0,-30,-5>, <4.693,-29.6307,-5> }
		triangle { <9.2705,-28.5317,10>, <10.8156,-33.287,10>, <10.8156,-33.287,-20> }
		triangle { <10.8156,-33.287,-20>, <9.2705,-28.5317,-20>, <9.2705,-28.5317,10> }
		triangle { <4.693,-29.6307,10>, <5.4752,-34.5691,10>, <5.4752,-34.5691,-20> }
		triangle { <5.4752,-34.5691,-20>, <4.693,-29.6307,-20>, <4.693,-29.6307,10> }
		triangle { <0,-20,10>, <0,-20,-10>, <-3.1287,-19.7538,-10> }
		triangle { <-3.1287,-19.7538,-10>, <-3.1287,-19.7538,10>, <0,-20,10> }
		triangle { <-3.1287,-19.7538,10>, <-3.1287,-19.7538,-10>, <-6.1803,-19.0211,-10> }
		triangle { <-6.1803,-19.0211,-10>, <-6.1803,-19.0211,10>, <-3.1287,-19.7538,10> }
		triangle { <0,-25,-20>, <0,-20,-10>, <-3.1287,-19.7538,-10> }
		triangle { <-3.1287,-19.7538,-10>, <-3.9109,-24.6922,-20>, <0,-25,-20> }
		triangle { <-3.9109,-24.6922,-20>, <-3.1287,-19.7538,-10>, <-6.1803,-19.0211,-10> }
		triangle { <-6.1803,-19.0211,-10>, <-7.7254,-23.7764,-20>, <-3.9109,-24.6922,-20> }
		triangle { <0,-25,-20>, <0,-30,-20>, <-4.693,-29.6307,-20> }
		triangle { <-4.693,-29.6307,-20>, <-3.9109,-24.6922,-20>, <0,-25,-20> }
		triangle { <-3.9109,-24.6922,-20>, <-5.4752,-34.5691,-20>, <-10.8156,-33.287,-20> }
		triangle { <-10.8156,-33.287,-20>, <-7.7254,-23.7764,-20>, <-3.9109,-24.6922,-20> }
		triangle { <0,-20,10>, <0,-35,10>, <-5.4752,-34.5691,10> }
		triangle { <-5.4752,-34.5691,10>, <-3.1287,-19.7538,10>, <0,-20,10> }
		triangle { <-3.1287,-19.7538,10>, <-4.693,-29.6307,10>, <-9.2705,-28.5317,10> }
		triangle { <-9.2705,-28.5317,10>, <-6.1803,-19.0211,10>, <-3.1287,-19.7538,10> }
		triangle { <0,-35,-5>, <0,-35,10>, <-5.4752,-34.5691,10> }
		triangle { <-5.4752,-34.5691,10>, <-5.4752,-34.5691,-5>, <0,-35,-5> }
		triangle { <-5.4752,-34.5691,-5>, <-5.4752,-34.5691,-20>, <-10.8156,-33.287,-20> }
		triangle { <-10.8156,-33.287,-20>, <-10.8156,-33.287,-5>, <-5.4752,-34.5691,-5> }
		triangle { <0,-30,-5>, <0,-30,-20>, <-4.693,-29.6307,-20> }
		triangle { <-4.693,-29.6307,-20>, <-4.693,-29.6307,-5>, <0,-30,-5> }
		triangle { <-4.693,-29.6307,-5>, <-4.693,-29.6307,10>, <-9.2705,-28.5317,10> }
		triangle { <-9.2705,-28.5317,10>, <-9.2705,-28.5317,-5>, <-4.693,-29.6307,-5> }
		triangle { <0,-30,-5>, <0,-35,-5>, <-5.4752,-34.5691,-5> }
		triangle { <-5.4752,-34.5691,-5>, <-4.693,-29.6307,-5>, <0,-30,-5> }
		triangle { <-4.693,-29.6307,-5>, <-5.4752,-34.5691,-5>, <-10.8156,-33.287,-5> }
		triangle { <-10.8156,-33.287,-5>, <-9.2705,-28.5317,-5>, <-4.693,-29.6307,-5> }
		triangle { <0,-30,10>, <0,-35,10>, <0,-35,-20> }
		triangle { <0,-35,-20>, <0,-30,-20>, <0,-30,10> }
		triangle { <-4.693,-29.6307,10>, <-5.4752,-34.5691,10>, <-5.4752,-34.5691,-20> }
		triangle { <-5.4752,-34.5691,-20>, <-4.693,-29.6307,-20>, <-4.693,-29.6307,10> }
		triangle { <-6.1803,-19.0211,10>, <-6.1803,-19.0211,-10>, <-9.0798,-17.8201,-10> }
		triangle { <-9.0798,-17.8201,-10>, <-9.0798,-17.8201,10>, <-6.1803,-19.0211,10> }
		triangle { <-9.0798,-17.8201,10>, <-9.0798,-17.8201,-10>, <-11.7557,-16.1803,-10> }
		triangle { <-11.7557,-16.1803,-10>, <-11.7557,-16.1803,10>, <-9.0798,-17.8201,10> }
		triangle { <-7.7254,-23.7764,-20>, <-6.1803,-19.0211,-10>, <-9.0798,-17.8201,-10> }
		triangle { <-9.0798,-17.8201,-10>, <-11.3498,-22.2752,-20>, <-7.7254,-23.7764,-20> }
		triangle { <-11.3498,-22.2752,-20>, <-9.0798,-17.8201,-10>, <-11.7557,-16.1803,-10> }
		triangle { <-11.7557,-16.1803,-10>, <-14.6946,-20.2254,-20>, <-11.3498,-22.2752,-20> }
		triangle { <-7.7254,-23.7764,-20>, <-9.2705,-28.5317,-20>, <-13.6197,-26.7302,-20> }
		triangle { <-13.6197,-26.7302,-20>, <-11.3498,-22.2752,-20>, <-7.7254,-23.7764,-20> }
		triangle { <-11.3498,-22.2752,-20>, <-15.8897,-31.1852,-20>, <-20.5725,-28.3156,-20> }
		triangle { <-20.5725,-28.3156,-20>, <-14.6946,-20.2254,-20>, <-11.3498,-22.2752,-20> }
		triangle { <-6.1803,-19.0211,10>, <-10.8156,-33.287,10>, <-15.8897,-31.1852,10> }
		triangle { <-15.8897,-31.1852,10>, <-9.0798,-17.8201,10>, <-6.1803,-19.0211,10> }
		triangle { <-9.0798,-17.8201,10>, <-13.6197,-26.7302,10>, <-17.6336,-24.2705,10> }
		triangle { <-17.6336,-24.2705,10>, <-11.7557,-16.1803,10>, <-9.0798,-17.8201,10> }
		triangle { <-10.8156,-33.287,-5>, <-10.8156,-33.287,10>, <-15.8897,-31.1852,10> }
		triangle { <-15.8897,-31.1852,10>, <-15.8897,-31.1852,-5>, <-10.8156,-33.287,-5> }
		triangle { <-15.8897,-31.1852,-5>, <-15.8897,-31.1852,-20>, <-20.5725,-28.3156,-20> }
		triangle { <-20.5725,-28.3156,-20>, <-20.5725,-28.3156,-5>, <-15.8897,-31.1852,-5> }
		triangle { <-9.2705,-28.5317,-5>, <-9.2705,-28.5317,-20>, <-13.6197,-26.7302,-20> }
		triangle { <-13.6197,-26.7302,-20>, <-13.6197,-26.7302,-5>, <-9.2705,-28.5317,-5> }
		triangle { <-13.6197,-26.7302,-5>, <-13.6197,-26.7302,10>, <-17.6336,-24.2705,10> }
		triangle { <-17.6336,-24.2705,10>, <-17.6336,-24.2705,-5>, <-13.6197,-26.7302,-5> }
		triangle { <-9.2705,-28.5317,-5>, <-10.8156,-33.287,-5>, <-15.8897,-31.1852,-5> }
		triangle { <-15.8897,-31.1852,-5>, <-13.6197,-26.7302,-5>, <-9.2705,-28.5317,-5> }
		triangle { <-13.6197,-26.7302,-5>, <-15.8897,-31.1852,-5>, <-20.5725,-28.3156,-5> }
		triangle { <-20.5725,-28.3156,-5>, <-17.6336,-24.2705,-5>, <-13.6197,-26.7302,-5> }
		triangle { <-9.2705,-28.5317,10>, <-10.8156,-33.287,10>, <-10.8156,-33.287,-20> }
		triangle { <-10.8156,-33.287,-20>, <-9.2705,-28.5317,-20>, <-9.2705,-28.5317,10> }
		triangle { <-13.6197,-26.7302,10>, <-15.8897,-31.1852,10>, <-15.8897,-31.1852,-20> }
		triangle { <-15.8897,-31.1852,-20>, <-13.6197,-26.7302,-20>, <-13.6197,-26.7302,10> }
		triangle { <-11.7557,-16.1803,10>, <-11.7557,-16.1803,-10>, <-14.1421,-14.1421,-10> }
		triangle { <-14.1421,-14.1421,-10>, <-14.1421,-14.1421,10>, <-11.7557,-16.1803,10> }
		triangle { <-14.1421,-14.1421,10>, <-14.1421,-14.1421,-10>, <-16.1803,-11.7557,-10> }
		triangle { <-16.1803,-11.7557,-10>, <-16.1803,-11.7557,10>, <-14.1421,-14.1421,10> }
		triangle { <-14.6946,-20.2254,-20>, <-11.7557,-16.1803,-10>, <-14.1421,-14.1421,-10> }
		triangle { <-14.1421,-14.1421,-10>, <-17.6777,-17.6777,-20>, <-14.6946,-20.2254,-20> }
		triangle { <-17.6777,-17.6777,-20>, <-14.1421,-14.1421,-10>, <-16.1803,-11.7557,-10> }
		triangle { <-16.1803,-11.7557,-10>, <-20.2254,-14.6946,-20>, <-17.6777,-17.6777,-20> }
		triangle { <-14.6946,-20.2254,-20>, <-17.6336,-24.2705,-20>, <-21.2132,-21.2132,-20> }
		triangle { <-21.2132,-21.2132,-20>, <-17.6777,-17.6777,-20>, <-14.6946,-20.2254,-20> }
		triangle { <-17.6777,-17.6777,-20>, <-24.7487,-24.7487,-20>, <-28.3156,-20.5725,-20> }
		triangle { <-28.3156,-20.5725,-20>, <-20.2254,-14.6946,-20>, <-17.6777,-17.6777,-20> }
		triangle { <-11.7557,-16.1803,10>, <-20.5725,-28.3156,10>, <-24.7487,-24.7487,10> }
		triangle { <-24.7487,-24.7487,10>, <-14.1421,-14.1421,10>, <-11.7557,-16.1803,10> }
		triangle { <-14.1421,-14.1421,10>, <-21.2132,-21.2132,10>, <-24.2705,-17.6336,10> }
		triangle { <-24.2705,-17.6336,10>, <-16.1803,-11.7557,10>, <-14.1421,-14.1421,10> }
		triangle { <-20.5725,-28.3156,-5>, <-20.5725,-28.3156,10>, <-24.7487,-24.7487,10> }
		triangle { <-24.7487,-24.7487,10>, <-24.7487,-24.7487,-5>, <-20.5725,-28.3156,-5> }
		triangle { <-24.7487,-24.7487,-5>, <-24.7487,-24.7487,-20>, <-28.3156,-20.5725,-20> }
		triangle { <-28.3156,-20.5725,-20>, <-28.3156,-20.5725,-5>, <-24.7487,-24.7487,-5> }
		triangle { <-17.6336,-24.2705,-5>, <-17.6336,-24.2705,-20>, <-21.2132,-21.2132,-20> }
		triangle { <-21.2132,-21.2132,-20>, <-21.2132,-21.2132,-5>, <-17.6336,-24.2705,-5> }
		triangle { <-21.2132,-21.2132,-5>, <-21.2132,-21.2132,10>, <-24.2705,-17.6336,10> }
		triangle { <-24.2705,-17.6336,10>, <-24.2705,-17.6336,-5>, <-21.2132,-21.2132,-5> }
		triangle { <-17.6336,-24.2705,-5>, <-20.5725,-28.3156,-5>, <-24.7487,-24.7487,-5> }
		triangle { <-24.7487,-24.7487,-5>, <-21.2132,-21.2132,-5>, <-17.6336,-24.2705,-5> }
		triangle { <-21.2132,-21.2132,-5>, <-24.7487,-24.7487,-5>, <-28.3156,-20.5725,-5> }
		triangle { <-28.3156,-20.5725,-5>, <-24.2705,-17.6336,-5>, <-21.2132,-21.2132,-5> }
		triangle { <-17.6336,-24.2705,10>, <-20.5725,-28.3156,10>, <-20.5725,-28.3156,-20> }
		triangle { <-20.5725,-28.3156,-20>, <-17.6336,-24.2705,-20>, <-17.6336,-24.2705,10> }
		triangle { <-21.2132,-21.2132,10>, <-24.7487,-24.7487,10>, <-24.7487,-24.7487,-20> }
		triangle { <-24.7487,-24.7487,-20>, <-21.2132,-21.2132,-20>, <-21.2132,-21.2132,10> }
		triangle { <-16.1803,-11.7557,10>, <-16.1803,-11.7557,-10>, <-17.8201,-9.0798,-10> }
		triangle { <-17.8201,-9.0798,-10>, <-17.8201,-9.0798,10>, <-16.1803,-11.7557,10> }
		triangle { <-17.8201,-9.0798,10>, <-17.8201,-9.0798,-10>, <-19.0211,-6.1803,-10> }
		triangle { <-19.0211,-6.1803,-10>, <-19.0211,-6.1803,10>, <-17.8201,-9.0798,10> }
		triangle { <-20.2254,-14.6946,-20>, <-16.1803,-11.7557,-10>, <-17.8201,-9.0798,-10> }
		triangle { <-17.8201,-9.0798,-10>, <-22.2752,-11.3498,-20>, <-20.2254,-14.6946,-20> }
		triangle { <-22.2752,-11.3498,-20>, <-17.8201,-9.0798,-10>, <-19.0211,-6.1803,-10> }
		triangle { <-19.0211,-6.1803,-10>, <-23.7764,-7.7254,-20>, <-22.2752,-11.3498,-20> }
		triangle { <-20.2254,-14.6946,-20>, <-24.2705,-17.6336,-20>, <-26.7302,-13.6197,-20> }
		triangle { <-26.7302,-13.6197,-20>, <-22.2752,-11.3498,-20>, <-20.2254,-14.6946,-20> }
		triangle { <-22.2752,-11.3498,-20>, <-31.1852,-15.8897,-20>, <-33.287,-10.8156,-20> }
		triangle { <-33.287,-10.8156,-20>, <-23.7764,-7.7254,-20>, <-22.2752,-11.3498,-20> }
		triangle { <-16.1803,-11.7557,10>, <-28.3156,-20.5725,10>, <-31.1852,-15.8897,10> }
		triangle { <-31.1852,-15.8897,10>, <-17.8201,-9.0798,10>, <-16.1803,-11.7557,10> }
		triangle { <-17.8201,-9.0798,10>, <-26.7302,-13.6197,10>, <-28.5317,-9.2705,10> }
		triangle { <-28.5317,-9.2705,10>, <-19.0211,-6.1803,10>, <-17.8201,-9.0798,10> }
		triangle { <-28.3156,-20.5725,-5>, <-28.3156,-20.5725,10>, <-31.1852,-15.8897,10> }
		triangle { <-31.1852,-15.8897,10>, <-31.1852,-15.8897,-5>, <-28.3156,-20.5725,-5> }
		triangle { <-31.1852,-15.8897,-5>, <-31.1852,-15.8897,-20>, <-33.287,-10.8156,-20> }
		triangle { <-33.287,-10.8156,-20>, <-33.287,-10.8156,-5>, <-31.1852,-15.8897,-5> }
		triangle { <-24.2705,-17.6336,-5>, <-24.2705,-17.6336,-20>, <-26.7302,-13.6197,-20> }
		triangle { <-26.7302,-13.6197,-20>, <-26.7302,-13.6197,-5>, <-24.2705,-17.6336,-5> }
		triangle { <-26.7302,-13.6197,-5>, <-26.7302,-13.6197,10>, <-28.5317,-9.2705,10> }
		triangle { <-28.5317,-9.2705,10>, <-28.5317,-9.2705,-5>, <-26.7302,-13.6197,-5> }
		triangle { <-24.2705,-17.6336,-5>, <-28.3156,-20.5725,-5>, <-31.1852,-15.8897,-5> }
		triangle { <-31.1852,-15.8897,-5>, <-26.7302,-13.6197,-5>, <-24.2705,-17.6336,-5> }
		triangle { <-26.7302,-13.6197,-5>, <-31.1852,-15.8897,-5>, <-33.287,-10.8156,-5> }
		triangle { <-33.287,-10.8156,-5>, <-28.5317,-9.2705,-5>, <-26.7302,-13.6197,-5> }
		triangle { <-24.2705,-17.6336,10>, <-28.3156,-20.5725,10>, <-28.3156,-20.5725,-20> }
		triangle { <-28.3156,-20.5725,-20>, <-24.2705,-17.6336,-20>, <-24.2705,-17.6336,10> }
		triangle { <-26.7302,-13.6197,10>, <-31.1852,-15.8897,10>, <-31.1852,-15.8897,-20> }
		triangle { <-31.1852,-15.8897,-20>, <-26.7302,-13.6197,-20>, <-26.7302,-13.6197,10> }
		triangle { <-19.0211,-6.1803,10>, <-19.0211,-6.1803,-10>, <-19.7538,-3.1287,-10> }
		triangle { <-19.7538,-3.1287,-10>, <-19.7538,-3.1287,10>, <-19.0211,-6.1803,10> }
		triangle { <-19.7538,-3.1287,10>, <-19.7538,-3.1287,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <-19.7538,-3.1287,10> }
		triangle { <-23.7764,-7.7254,-20>, <-19.0211,-6.1803,-10>, <-19.7538,-3.1287,-10> }
		triangle { <-19.7538,-3.1287,-10>, <-24.6922,-3.9109,-20>, <-23.7764,-7.7254,-20> }
		triangle { <-24.6922,-3.9109,-20>, <-19.7538,-3.1287,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-25,0,-20>, <-24.6922,-3.9109,-20> }
		triangle { <-23.7764,-7.7254,-20>, <-28.5317,-9.2705,-20>, <-29.6307,-4.693,-20> }
		triangle { <-29.6307,-4.693,-20>, <-24.6922,-3.9109,-20>, <-23.7764,-7.7254,-20> }
		triangle { <-24.6922,-3.9109,-20>, <-34.5691,-5.4752,-20>, <-35,0,-20> }
		triangle { <-35,0,-20>, <-25,0,-20>, <-24.6922,-3.9109,-20> }
		triangle { <-19.0211,-6.1803,10>, <-33.287,-10.8156,10>, <-34.5691,-5.4752,10> }
		triangle { <-34.5691,-5.4752,10>, <-19.7538,-3.1287,10>, <-19.0211,-6.1803,10> }
		triangle { <-19.7538,-3.1287,10>, <-29.6307,-4.693,10>, <-30,0,10> }
		triangle { <-30,0,10>, <-20,0,10>, <-19.7538,-3.1287,10> }
		triangle { <-33.287,-10.8156,-5>, <-33.287,-10.8156,10>, <-34.5691,-5.4752,10> }
		triangle { <-34.5691,-5.4752,10>, <-34.5691,-5.4752,-5>, <-33.287,-10.8156,-5> }
		triangle { <-34.5691,-5.4752,-5>, <-34.5691,-5.4752,-20>, <-35,0,-20> }
		triangle { <-35,0,-20>, <-35,0,-5>, <-34.5691,-5.4752,-5> }
		triangle { <-28.5317,-9.2705,-5>, <-28.5317,-9.2705,-20>, <-29.6307,-4.693,-20> }
		triangle { <-29.6307,-4.693,-20>, <-29.6307,-4.693,-5>, <-28.5317,-9.2705,-5> }
		triangle { <-29.6307,-4.693,-5>, <-29.6307,-4.693,10>, <-30,0,10> }
		triangle { <-30,0,10>, <-30,0,-5>, <-29.6307,-4.693,-5> }
		triangle { <-28.5317,-9.2705,-5>, <-33.287,-10.8156,-5>, <-34.5691,-5.4752,-5> }
		triangle { <-34.5691,-5.4752,-5>, <-29.6307,-4.693,-5>, <-28.5317,-9.2705,-5> }
		triangle { <-29.6307,-4.693,-5>, <-34.5691,-5.4752,-5>, <-35,0,-5> }
		triangle { <-35,0,-5>, <-30,0,-5>, <-29.6307,-4.693,-5> }
		triangle { <-28.5317,-9.2705,10>, <-33.287,-10.8156,10>, <-33.287,-10.8156,-20> }
		triangle { <-33.287,-10.8156,-20>, <-28.5317,-9.2705,-20>, <-28.5317,-9.2705,10> }
		triangle { <-29.6307,-4.693,10>, <-34.5691,-5.4752,10>, <-34.5691,-5.4752,-20> }
		triangle { <-34.5691,-5.4752,-20>, <-29.6307,-4.693,-20>, <-29.6307,-4.693,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-19.7538,3.1287,-10> }
		triangle { <-19.7538,3.1287,-10>, <-19.7538,3.1287,10>, <-20,0,10> }
		triangle { <-19.7538,3.1287,10>, <-19.7538,3.1287,-10>, <-19.0211,6.1803,-10> }
		triangle { <-19.0211,6.1803,-10>, <-19.0211,6.1803,10>, <-19.7538,3.1287,10> }
		triangle { <-25,0,-20>, <-20,0,-10>, <-19.7538,3.1287,-10> }
		triangle { <-19.7538,3.1287,-10>, <-24.6922,3.9109,-20>, <-25,0,-20> }
		triangle { <-24.6922,3.9109,-20>, <-19.7538,3.1287,-10>, <-19.0211,6.1803,-10> }
		triangle { <-19.0211,6.1803,-10>, <-23.7764,7.7254,-20>, <-24.6922,3.9109,-20> }
		triangle { <-25,0,-20>, <-30,0,-20>, <-29.6307,4.693,-20> }
		triangle { <-29.6307,4.693,-20>, <-24.6922,3.9109,-20>, <-25,0,-20> }
		triangle { <-24.6922,3.9109,-20>, <-34.5691,5.4752,-20>, <-33.287,10.8156,-20> }
		triangle { <-33.287,10.8156,-20>, <-23.7764,7.7254,-20>, <-24.6922,3.9109,-20> }
		triangle { <-20,0,10>, <-35,0,10>, <-34.5691,5.4752,10> }
		triangle { <-34.5691,5.4752,10>, <-19.7538,3.1287,10>, <-20,0,10> }
		triangle { <-19.7538,3.1287,10>, <-29.6307,4.693,10>, <-28.5317,9.2705,10> }
		triangle { <-28.5317,9.2705,10>, <-19.0211,6.1803,10>, <-19.7538,3.1287,10> }
		triangle { <-35,0,-5>, <-35,0,10>, <-34.5691,5.4752,10> }
		triangle { <-34.5691,5.4752,10>, <-34.5691,5.4752,-5>, <-35,0,-5> }
		triangle { <-34.5691,5.4752,-5>, <-34.5691,5.4752,-20>, <-33.287,10.8156,-20> }
		triangle { <-33.287,10.8156,-20>, <-33.287,10.8156,-5>, <-34.5691,5.4752,-5> }
		triangle { <-30,0,-5>, <-30,0,-20>, <-29.6307,4.693,-20> }
		triangle { <-29.6307,4.693,-20>, <-29.6307,4.693,-5>, <-30,0,-5> }
		triangle { <-29.6307,4.693,-5>, <-29.6307,4.693,10>, <-28.5317,9.2705,10> }
		triangle { <-28.5317,9.2705,10>, <-28.5317,9.2705,-5>, <-29.6307,4.693,-5> }
		triangle { <-30,0,-5>, <-35,0,-5>, <-34.5691,5.4752,-5> }
		triangle { <-34.5691,5.4752,-5>, <-29.6307,4.693,-5>, <-30,0,-5> }
		triangle { <-29.6307,4.693,-5>, <-34.5691,5.4752,-5>, <-33.287,10.8156,-5> }
		triangle { <-33.287,10.8156,-5>, <-28.5317,9.2705,-5>, <-29.6307,4.693,-5> }
		triangle { <-30,0,10>, <-35,0,10>, <-35,0,-20> }
		triangle { <-35,0,-20>, <-30,0,-20>, <-30,0,10> }
		triangle { <-29.6307,4.693,10>, <-34.5691,5.4752,10>, <-34.5691,5.4752,-20> }
		triangle { <-34.5691,5.4752,-20>, <-29.6307,4.693,-20>, <-29.6307,4.693,10> }
		triangle { <-19.0211,6.1803,10>, <-19.0211,6.1803,-10>, <-17.8201,9.0798,-10> }
		triangle { <-17.8201,9.0798,-10>, <-17.8201,9.0798,10>, <-19.0211,6.1803,10> }
		triangle { <-17.8201,9.0798,10>, <-17.8201,9.0798,-10>, <-16.1803,11.7557,-10> }
		triangle { <-16.1803,11.7557,-10>, <-16.1803,11.7557,10>, <-17.8201,9.0798,10> }
		triangle { <-23.7764,7.7254,-20>, <-19.0211,6.1803,-10>, <-17.8201,9.0798,-10> }
		triangle { <-17.8201,9.0798,-10>, <-22.2752,11.3498,-20>, <-23.7764,7.7254,-20> }
		triangle { <-22.2752,11.3498,-20>, <-17.8201,9.0798,-10>, <-16.1803,11.7557,-10> }
		triangle { <-16.1803,11.7557,-10>, <-20.2254,14.6946,-20>, <-22.2752,11.3498,-20> }
		triangle { <-23.7764,7.7254,-20>, <-28.5317,9.2705,-20>, <-26.7302,13.6197,-20> }
		triangle { <-26.7302,13.6197,-20>, <-22.2752,11.3498,-20>, <-23.7764,7.7254,-20> }
		triangle { <-22.2752,11.3498,-20>, <-31.1852,15.8897,-20>, <-28.3156,20.5725,-20> }
		triangle { <-28.3156,20.5725,-20>, <-20.2254,14.6946,-20>, <-22.2752,11.3498,-20> }
		triangle { <-19.0211,6.1803,10>, <-33.287,10.8156,10>, <-31.1852,15.8897,10> }
		triangle { <-31.1852,15.8897,10>, <-17.8201,9.0798,10>, <-19.0211,6.1803,10> }
		triangle { <-17.8201,9.0798,10>, <-26.7302,13.6197,10>, <-24.2705,17.6336,10> }
		triangle { <-24.2705,17.6336,10>, <-16.1803,11.7557,10>, <-17.8201,9.0798,10> }
		triangle { <-33.287,10.8156,-5>, <-33.287,10.8156,10>, <-31.1852,15.8897,10> }
		triangle { <-31.1852,15.8897,10>, <-31.1852,15.8897,-5>, <-33.287,10.8156,-5> }
		triangle { <-31.1852,15.8897,-5>, <-31.1852,15.8897,-20>, <-28.3156,20.5725,-20> }
		triangle { <-28.3156,20.5725,-20>, <-28.3156,20.5725,-5>, <-31.1852,15.8897,-5> }
		triangle { <-28.5317,9.2705,-5>, <-28.5317,9.2705,-20>, <-26.7302,13.6197,-20> }
		triangle { <-26.7302,13.6197,-20>, <-26.7302,13.6197,-5>, <-28.5317,9.2705,-5> }
		triangle { <-26.7302,13.6197,-5>, <-26.7302,13.6197,10>, <-24.2705,17.6336,10> }
		triangle { <-24.2705,17.6336,10>, <-24.2705,17.6336,-5>, <-26.7302,13.6197,-5> }
		triangle { <-28.5317,9.2705,-5>, <-33.287,10.8156,-5>, <-31.1852,15.8897,-5> }
		triangle { <-31.1852,15.8897,-5>, <-26.7302,13.6197,-5>, <-28.5317,9.2705,-5> }
		triangle { <-26.7302,13.6197,-5>, <-31.1852,15.8897,-5>, <-28.3156,20.5725,-5> }
		triangle { <-28.3156,20.5725,-5>, <-24.2705,17.6336,-5>, <-26.7302,13.6197,-5> }
		triangle { <-28.5317,9.2705,10>, <-33.287,10.8156,10>, <-33.287,10.8156,-20> }
		triangle { <-33.287,10.8156,-20>, <-28.5317,9.2705,-20>, <-28.5317,9.2705,10> }
		triangle { <-26.7302,13.6197,10>, <-31.1852,15.8897,10>, <-31.1852,15.8897,-20> }
		triangle { <-31.1852,15.8897,-20>, <-26.7302,13.6197,-20>, <-26.7302,13.6197,10> }
		triangle { <-16.1803,11.7557,10>, <-16.1803,11.7557,-10>, <-14.1421,14.1421,-10> }
		triangle { <-14.1421,14.1421,-10>, <-14.1421,14.1421,10>, <-16.1803,11.7557,10> }
		triangle { <-14.1421,14.1421,10>, <-14.1421,14.1421,-10>, <-11.7557,16.1803,-10> }
		triangle { <-11.7557,16.1803,-10>, <-11.7557,16.1803,10>, <-14.1421,14.1421,10> }
		triangle { <-20.2254,14.6946,-20>, <-16.1803,11.7557,-10>, <-14.1421,14.1421,-10> }
		triangle { <-14.1421,14.1421,-10>, <-17.6777,17.6777,-20>, <-20.2254,14.6946,-20> }
		triangle { <-17.6777,17.6777,-20>, <-14.1421,14.1421,-10>, <-11.7557,16.1803,-10> }
		triangle { <-11.7557,16.1803,-10>, <-14.6946,20.2254,-20>, <-17.6777,17.6777,-20> }
		triangle { <-20.2254,14.6946,-20>, <-24.2705,17.6336,-20>, <-21.2132,21.2132,-20> }
		triangle { <-21.2132,21.2132,-20>, <-17.6777,17.6777,-20>, <-20.2254,14.6946,-20> }
		triangle { <-17.6777,17.6777,-20>, <-24.7487,24.7487,-20>, <-20.5725,28.3156,-20> }
		triangle { <-20.5725,28.3156,-20>, <-14.6946,20.2254,-20>, <-17.6777,17.6777,-20> }
		triangle { <-16.1803,11.7557,10>, <-28.3156,20.5725,10>, <-24.7487,24.7487,10> }
		triangle { <-24.7487,24.7487,10>, <-14.1421,14.1421,10>, <-16.1803,11.7557,10> }
		triangle { <-14.1421,14.1421,10>, <-21.2132,21.2132,10>, <-17.6336,24.2705,10> }
		triangle { <-17.6336,24.2705,10>, <-11.7557,16.1803,10>, <-14.1421,14.1421,10> }
		triangle { <-28.3156,20.5725,-5>, <-28.3156,20.5725,10>, <-24.7487,24.7487,10> }
		triangle { <-24.7487,24.7487,10>, <-24.7487,24.7487,-5>, <-28.3156,20.5725,-5> }
		triangle { <-24.7487,24.7487,-5>, <-24.7487,24.7487,-20>, <-20.5725,28.3156,-20> }
		triangle { <-20.5725,28.3156,-20>, <-20.5725,28.3156,-5>, <-24.7487,24.7487,-5> }
		triangle { <-24.2705,17.6336,-5>, <-24.2705,17.6336,-20>, <-21.2132,21.2132,-20> }
		triangle { <-21.2132,21.2132,-20>, <-21.2132,21.2132,-5>, <-24.2705,17.6336,-5> }
		triangle { <-21.2132,21.2132,-5>, <-21.2132,21.2132,10>, <-17.6336,24.2705,10> }
		triangle { <-17.6336,24.2705,10>, <-17.6336,24.2705,-5>, <-21.2132,21.2132,-5> }
		triangle { <-24.2705,17.6336,-5>, <-28.3156,20.5725,-5>, <-24.7487,24.7487,-5> }
		triangle { <-24.7487,24.7487,-5>, <-21.2132,21.2132,-5>, <-24.2705,17.6336,-5> }
		triangle { <-21.2132,21.2132,-5>, <-24.7487,24.7487,-5>, <-20.5725,28.3156,-5> }
		triangle { <-20.5725,28.3156,-5>, <-17.6336,24.2705,-5>, <-21.2132,21.2132,-5> }
		triangle { <-24.2705,17.6336,10>, <-28.3156,20.5725,10>, <-28.3156,20.5725,-20> }
		triangle { <-28.3156,20.5725,-20>, <-24.2705,17.6336,-20>, <-24.2705,17.6336,10> }
		triangle { <-21.2132,21.2132,10>, <-24.7487,24.7487,10>, <-24.7487,24.7487,-20> }
		triangle { <-24.7487,24.7487,-20>, <-21.2132,21.2132,-20>, <-21.2132,21.2132,10> }
		triangle { <-11.7557,16.1803,10>, <-11.7557,16.1803,-10>, <-9.0798,17.8201,-10> }
		triangle { <-9.0798,17.8201,-10>, <-9.0798,17.8201,10>, <-11.7557,16.1803,10> }
		triangle { <-9.0798,17.8201,10>, <-9.0798,17.8201,-10>, <-6.1803,19.0211,-10> }
		triangle { <-6.1803,19.0211,-10>, <-6.1803,19.0211,10>, <-9.0798,17.8201,10> }
		triangle { <-14.6946,20.2254,-20>, <-11.7557,16.1803,-10>, <-9.0798,17.8201,-10> }
		triangle { <-9.0798,17.8201,-10>, <-11.3498,22.2752,-20>, <-14.6946,20.2254,-20> }
		triangle { <-11.3498,22.2752,-20>, <-9.0798,17.8201,-10>, <-6.1803,19.0211,-10> }
		triangle { <-6.1803,19.0211,-10>, <-7.7254,23.7764,-20>, <-11.3498,22.2752,-20> }
		triangle { <-14.6946,20.2254,-20>, <-17.6336,24.2705,-20>, <-13.6197,26.7302,-20> }
		triangle { <-13.6197,26.7302,-20>, <-11.3498,22.2752,-20>, <-14.6946,20.2254,-20> }
		triangle { <-11.3498,22.2752,-20>, <-15.8897,31.1852,-20>, <-10.8156,33.287,-20> }
		triangle { <-10.8156,33.287,-20>, <-7.7254,23.7764,-20>, <-11.3498,22.2752,-20> }
		triangle { <-11.7557,16.1803,10>, <-20.5725,28.3156,10>, <-15.8897,31.1852,10> }
		triangle { <-15.8897,31.1852,10>, <-9.0798,17.8201,10>, <-11.7557,16.1803,10> }
		triangle { <-9.0798,17.8201,10>, <-13.6197,26.7302,10>, <-9.2705,28.5317,10> }
		triangle { <-9.2705,28.5317,10>, <-6.1803,19.0211,10>, <-9.0798,17.8201,10> }
		triangle { <-20.5725,28.3156,-5>, <-20.5725,28.3156,10>, <-15.8897,31.1852,10> }
		triangle { <-15.8897,31.1852,10>, <-15.8897,31.1852,-5>, <-20.5725,28.3156,-5> }
		triangle { <-15.8897,31.1852,-5>, <-15.8897,31.1852,-20>, <-10.8156,33.287,-20> }
		triangle { <-10.8156,33.287,-20>, <-10.8156,33.287,-5>, <-15.8897,31.1852,-5> }
		triangle { <-17.6336,24.2705,-5>, <-17.6336,24.2705,-20>, <-13.6197,26.7302,-20> }
		triangle { <-13.6197,26.7302,-20>, <-13.6197,26.7302,-5>, <-17.6336,24.2705,-5> }
		triangle { <-13.6197,26.7302,-5>, <-13.6197,26.7302,10>, <-9.2705,28.5317,10> }
		triangle { <-9.2705,28.5317,10>, <-9.2705,28.5317,-5>, <-13.6197,26.7302,-5> }
		triangle { <-17.6336,24.2705,-5>, <-20.5725,28.3156,-5>, <-15.8897,31.1852,-5> }
		triangle { <-15.8897,31.1852,-5>, <-13.6197,26.7302,-5>, <-17.6336,24.2705,-5> }
		triangle { <-13.6197,26.7302,-5>, <-15.8897,31.1852,-5>, <-10.8156,33.287,-5> }
		triangle { <-10.8156,33.287,-5>, <-9.2705,28.5317,-5>, <-13.6197,26.7302,-5> }
		triangle { <-17.6336,24.2705,10>, <-20.5725,28.3156,10>, <-20.5725,28.3156,-20> }
		triangle { <-20.5725,28.3156,-20>, <-17.6336,24.2705,-20>, <-17.6336,24.2705,10> }
		triangle { <-13.6197,26.7302,10>, <-15.8897,31.1852,10>, <-15.8897,31.1852,-20> }
		triangle { <-15.8897,31.1852,-20>, <-13.6197,26.7302,-20>, <-13.6197,26.7302,10> }
		triangle { <-6.1803,19.0211,10>, <-6.1803,19.0211,-10>, <-3.1287,19.7538,-10> }
		triangle { <-3.1287,19.7538,-10>, <-3.1287,19.7538,10>, <-6.1803,19.0211,10> }
		triangle { <-3.1287,19.7538,10>, <-3.1287,19.7538,-10>, <0,20,-10> }
		triangle { <0,20,-10>, <0,20,10>, <-3.1287,19.7538,10> }
		triangle { <-7.7254,23.7764,-20>, <-6.1803,19.0211,-10>, <-3.1287,19.7538,-10> }
		triangle { <-3.1287,19.7538,-10>, <-3.9109,24.6922,-20>, <-7.7254,23.7764,-20> }
		triangle { <-3.9109,24.6922,-20>, <-3.1287,19.7538,-10>, <0,20,-10> }
		triangle { <0,20,-10>, <0,25,-20>, <-3.9109,24.6922,-20> }
		triangle { <-7.7254,23.7764,-20>, <-9.2705,28.5317,-20>, <-4.693,29.6307,-20> }
		triangle { <-4.693,29.6307,-20>, <-3.9109,24.6922,-20>, <-7.7254,23.7764,-20> }
		triangle { <-3.9109,24.6922,-20>, <-5.4752,34.5691,-20>, <0,35,-20> }
		triangle { <0,35,-20>, <0,25,-20>, <-3.9109,24.6922,-20> }
		triangle { <-6.1803,19.0211,10>, <-10.8156,33.287,10>, <-5.4752,34.5691,10> }
		triangle { <-5.4752,34.5691,10>, <-3.1287,19.7538,10>, <-6.1803,19.0211,10> }
		triangle { <-3.1287,19.7538,10>, <-4.693,29.6307,10>, <0,30,10> }
		triangle { <0,30,10>, <0,20,10>, <-3.1287,19.7538,10> }
		triangle { <-10.8156,33.287,-5>, <-10.8156,33.287,10>, <-5.4752,34.5691,10> }
		triangle { <-5.4752,34.5691,10>, <-5.4752,34.5691,-5>, <-10.8156,33.287,-5> }
		triangle { <-5.4752,34.5691,-5>, <-5.4752,34.5691,-20>, <0,35,-20> }
		triangle { <0,35,-20>, <0,35,-5>, <-5.4752,34.5691,-5> }
		triangle { <-9.2705,28.5317,-5>, <-9.2705,28.5317,-20>, <-4.693,29.6307,-20> }
		triangle { <-4.693,29.6307,-20>, <-4.693,29.6307,-5>, <-9.2705,28.5317,-5> }
		triangle { <-4.693,29.6307,-5>, <-4.693,29.6307,10>, <0,30,10> }
		triangle { <0,30,10>, <0,30,-5>, <-4.693,29.6307,-5> }
		triangle { <-9.2705,28.5317,-5>, <-10.8156,33.287,-5>, <-5.4752,34.5691,-5> }
		triangle { <-5.4752,34.5691,-5>, <-4.693,29.6307,-5>, <-9.2705,28.5317,-5> }
		triangle { <-4.693,29.6307,-5>, <-5.4752,34.5691,-5>, <0,35,-5> }
		triangle { <0,35,-5>, <0,30,-5>, <-4.693,29.6307,-5> }
		triangle { <-9.2705,28.5317,10>, <-10.8156,33.287,10>, <-10.8156,33.287,-20> }
		triangle { <-10.8156,33.287,-20>, <-9.2705,28.5317,-20>, <-9.2705,28.5317,10> }
		triangle { <-4.693,29.6307,10>, <-5.4752,34.5691,10>, <-5.4752,34.5691,-20> }
		triangle { <-5.4752,34.5691,-20>, <-4.693,29.6307,-20>, <-4.693,29.6307,10> }
	}
}
#end

#declare _3665_dot_dat = #if (QUAL = 0) box { <-10,-4,-30>, <10,24,10> } #else union {
// Slope Brick 45  2 x  1 Inverted
	object { box5_dot_dat matrix <6,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-6> }
		triangle { <-6,24,-6>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,-10>, <-6,24,-6>, <6,24,-6> }
		triangle { <6,24,-6>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <6,24,-6>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-10> }
	}
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,4,0,0,0,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,-4,0,0,0,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,6,0,0,0,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,-6,0,0,0,4,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,6,0,0,0,4,0,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,0,0,-20> }
	mesh {
		triangle { <10,24,-10>, <10,4,-30>, <10,0,10> }
		triangle { <10,0,10>, <10,24,10>, <10,24,-10> }
		triangle { <10,24,-10>, <10,4,-30>, <-10,4,-30> }
		triangle { <-10,4,-30>, <-10,24,-10>, <10,24,-10> }
		triangle { <10,24,10>, <10,0,10>, <-10,0,10> }
		triangle { <-10,0,10>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,-10>, <-10,4,-30>, <-10,0,10> }
		triangle { <-10,0,10>, <-10,24,10>, <-10,24,-10> }
		triangle { <10,0,-30>, <10,4,-30>, <10,0,10> }
		triangle { <10,0,-30>, <10,4,-30>, <-10,4,-30> }
		triangle { <-10,4,-30>, <-10,0,-30>, <10,0,-30> }
		triangle { <-10,0,-30>, <-10,4,-30>, <-10,0,10> }
		triangle { <8,20,-10>, <8,4,-26>, <-8,4,-26> }
		triangle { <-8,4,-26>, <-8,20,-10>, <8,20,-10> }
		triangle { <8,20,-10>, <8,0,-10>, <8,0,-26> }
		triangle { <8,0,-26>, <8,4,-26>, <8,20,-10> }
		triangle { <-8,20,-10>, <-8,0,-10>, <-8,0,-26> }
		triangle { <-8,0,-26>, <-8,4,-26>, <-8,20,-10> }
		triangle { <8,20,-10>, <8,0,-10>, <-8,0,-10> }
		triangle { <-8,0,-10>, <-8,20,-10>, <8,20,-10> }
		triangle { <8,4,-26>, <8,0,-26>, <-8,0,-26> }
		triangle { <-8,0,-26>, <-8,4,-26>, <8,4,-26> }
		triangle { <10,0,10>, <8,0,-10>, <-8,0,-10> }
		triangle { <-8,0,-10>, <-10,0,10>, <10,0,10> }
		triangle { <-10,0,10>, <-8,0,-10>, <-8,0,-26> }
		triangle { <-8,0,-26>, <-10,0,-30>, <-10,0,10> }
		triangle { <-10,0,-30>, <-8,0,-26>, <8,0,-26> }
		triangle { <8,0,-26>, <10,0,-30>, <-10,0,-30> }
		triangle { <10,0,-30>, <8,0,-26>, <8,0,-10> }
		triangle { <8,0,-10>, <10,0,10>, <10,0,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,-20> }
	#end
}
#end

#declare _2436_dot_dat = #if (QUAL = 0) box { <-40,-4,-18>, <40,20,10> } #else union {
// Bracket  1 x  2 -  1 x  4
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,2,10,8,-8> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,2,-10,8,-8> }
	mesh {
		triangle { <20,8,10>, <20,8,-10>, <16,8,-10> }
		triangle { <16,8,-10>, <16,8,6>, <20,8,10> }
		triangle { <-20,8,10>, <-20,8,-10>, <-16,8,-10> }
		triangle { <-16,8,-10>, <-16,8,6>, <-20,8,10> }
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <16,4,6>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,4,6>, <16,4,6> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <16,8,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,8,6>, <16,8,6> }
		triangle { <12,8,-6>, <12,4,-6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,8,-6>, <12,8,-6> }
		triangle { <-12,8,-6>, <-12,4,-6>, <-8,4,-6> }
		triangle { <-8,4,-6>, <-8,8,-6>, <-12,8,-6> }
		triangle { <16,8,6>, <16,4,6>, <16,4,-10> }
		triangle { <16,4,-10>, <16,8,-10>, <16,8,6> }
		triangle { <-16,8,6>, <-16,4,6>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,8,-10>, <-16,8,6> }
		triangle { <12,8,-6>, <12,4,-6>, <12,4,-10> }
		triangle { <12,4,-10>, <12,8,-10>, <12,8,-6> }
		triangle { <-12,8,-6>, <-12,4,-6>, <-12,4,-10> }
		triangle { <-12,4,-10>, <-12,8,-10>, <-12,8,-6> }
		triangle { <8,8,-6>, <8,4,-6>, <8,4,-10> }
		triangle { <8,4,-10>, <8,8,-10>, <8,8,-6> }
		triangle { <-8,8,-6>, <-8,4,-6>, <-8,4,-10> }
		triangle { <-8,4,-10>, <-8,8,-10>, <-8,8,-6> }
		triangle { <20,8,10>, <20,0,10>, <20,0,-10> }
		triangle { <20,0,-10>, <20,8,-10>, <20,8,10> }
		triangle { <20,8,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <20,8,10> }
		triangle { <-20,8,10>, <-20,0,10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <-20,8,10> }
		triangle { <40,20,-10>, <40,20,-14>, <-40,20,-14> }
		triangle { <-40,20,-14>, <-40,20,-10>, <40,20,-10> }
		triangle { <40,0,-10>, <40,0,-14>, <-40,0,-14> }
		triangle { <-40,0,-14>, <-40,0,-10>, <40,0,-10> }
		triangle { <40,20,-10>, <40,0,-10>, <40,0,-14> }
		triangle { <40,0,-14>, <40,20,-14>, <40,20,-10> }
		triangle { <40,20,-10>, <40,0,-10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,20,-10>, <40,20,-10> }
		triangle { <40,20,-14>, <40,0,-14>, <-40,0,-14> }
		triangle { <-40,0,-14>, <-40,20,-14>, <40,20,-14> }
		triangle { <-40,20,-10>, <-40,0,-10>, <-40,0,-14> }
		triangle { <-40,0,-14>, <-40,20,-14>, <-40,20,-10> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,0,1,0,1,0,30,10,-14> }
		object { stud2_dot_dat matrix <1,0,0,0,0,1,0,1,0,10,10,-14> }
		object { stud2_dot_dat matrix <1,0,0,0,0,1,0,1,0,-10,10,-14> }
		object { stud2_dot_dat matrix <1,0,0,0,0,1,0,1,0,-30,10,-14> }
	#end
}
#end

#declare _3832_dot_dat = #if (QUAL = 0) box { <-100,-4,-20>, <100,8,20> } #else union {
// Plate  2 x 10
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,0> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <100,8,20>, <96,8,16>, <-96,8,16> }
		triangle { <-96,8,16>, <-100,8,20>, <100,8,20> }
		triangle { <100,8,-20>, <96,8,-16>, <-96,8,-16> }
		triangle { <-96,8,-16>, <-100,8,-20>, <100,8,-20> }
		triangle { <100,8,20>, <96,8,16>, <96,8,-16> }
		triangle { <96,8,-16>, <100,8,-20>, <100,8,20> }
		triangle { <-100,8,20>, <-96,8,16>, <-96,8,-16> }
		triangle { <-96,8,-16>, <-100,8,-20>, <-100,8,20> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-8,0,0,0,20,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-10> }
	#end
}
#end

#declare _3033_dot_dat = #if (QUAL = 0) box { <-100,-4,-60>, <100,8,60> } #else union {
// Plate  6 x 10
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,-40> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-4,0,0,0,56,0,8,0> }
	mesh {
		triangle { <100,8,60>, <96,8,56>, <-96,8,56> }
		triangle { <-96,8,56>, <-100,8,60>, <100,8,60> }
		triangle { <100,8,-60>, <96,8,-56>, <-96,8,-56> }
		triangle { <-96,8,-56>, <-100,8,-60>, <100,8,-60> }
		triangle { <100,8,60>, <96,8,56>, <96,8,-56> }
		triangle { <96,8,-56>, <100,8,-60>, <100,8,60> }
		triangle { <-100,8,60>, <-96,8,56>, <-96,8,-56> }
		triangle { <-96,8,-56>, <-100,8,-60>, <-100,8,60> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-8,0,0,0,60,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-50> }
	#end
}
#end

#declare _3030_dot_dat = #if (QUAL = 0) box { <-100,-4,-40>, <100,8,40> } #else union {
// Plate  4 x 10
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,80,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-80,4,-20> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-4,0,0,0,36,0,8,0> }
	mesh {
		triangle { <100,8,40>, <96,8,36>, <-96,8,36> }
		triangle { <-96,8,36>, <-100,8,40>, <100,8,40> }
		triangle { <100,8,-40>, <96,8,-36>, <-96,8,-36> }
		triangle { <-96,8,-36>, <-100,8,-40>, <100,8,-40> }
		triangle { <100,8,40>, <96,8,36>, <96,8,-36> }
		triangle { <96,8,-36>, <100,8,-40>, <100,8,40> }
		triangle { <-100,8,40>, <-96,8,36>, <-96,8,-36> }
		triangle { <-96,8,-36>, <-100,8,-40>, <-100,8,40> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-8,0,0,0,40,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-30> }
	#end
}
#end

#declare _6111_dot_dat = #if (QUAL = 0) box { <-100,-4,-10>, <100,24,10> } #else union {
// Brick  1 x 10
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,80,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-80,4,0> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <100,24,10>, <96,24,6>, <-96,24,6> }
		triangle { <-96,24,6>, <-100,24,10>, <100,24,10> }
		triangle { <-100,24,10>, <-96,24,6>, <-96,24,-6> }
		triangle { <-96,24,-6>, <-100,24,-10>, <-100,24,10> }
		triangle { <-100,24,-10>, <-96,24,-6>, <96,24,-6> }
		triangle { <96,24,-6>, <100,24,-10>, <-100,24,-10> }
		triangle { <100,24,-10>, <96,24,-6>, <96,24,6> }
		triangle { <96,24,6>, <100,24,10>, <100,24,-10> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,0> }
	#end
}
#end

#declare _3008_dot_dat = #if (QUAL = 0) box { <-80,-4,-10>, <80,24,10> } #else union {
// Brick  1 x  8
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <80,24,10>, <76,24,6>, <-76,24,6> }
		triangle { <-76,24,6>, <-80,24,10>, <80,24,10> }
		triangle { <-80,24,10>, <-76,24,6>, <-76,24,-6> }
		triangle { <-76,24,-6>, <-80,24,-10>, <-80,24,10> }
		triangle { <-80,24,-10>, <-76,24,-6>, <76,24,-6> }
		triangle { <76,24,-6>, <80,24,-10>, <-80,24,-10> }
		triangle { <80,24,-10>, <76,24,-6>, <76,24,6> }
		triangle { <76,24,6>, <80,24,10>, <80,24,-10> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
	#end
}
#end

#declare _3829a_dot_dat = #if (QUAL = 0) box { <-20,-29.52,-10>, <20,8,10> } #else union {
// ~Car Steering Wheel Stand
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <-20,8,10>, <-16,8,6>, <-16,8,-6> }
		triangle { <-16,8,-6>, <-20,8,-10>, <-20,8,10> }
		triangle { <-20,8,-10>, <-16,8,-6>, <16,8,-6> }
		triangle { <16,8,-6>, <20,8,-10>, <-20,8,-10> }
		triangle { <20,8,-10>, <16,8,-6>, <16,8,6> }
		triangle { <16,8,6>, <20,8,10>, <20,8,-10> }
		triangle { <20,8,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <20,8,10> }
		triangle { <20,8,-10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <20,8,-10> }
		triangle { <20,8,10>, <20,0,10>, <20,0,-10> }
		triangle { <20,0,-10>, <20,8,-10>, <20,8,10> }
		triangle { <-20,8,10>, <-20,0,10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <-20,8,10> }
		triangle { <20,0,10>, <10,0,-6>, <-10,0,-6> }
		triangle { <-10,0,-6>, <-20,0,10>, <20,0,10> }
		triangle { <20,0,10>, <20,0,-10>, <10,0,-10> }
		triangle { <10,0,-10>, <10,0,-6>, <20,0,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-10,0,-10> }
		triangle { <-10,0,-10>, <-10,0,-6>, <-20,0,10> }
		triangle { <10,0,-10>, <10,-24,-10>, <-10,-24,-10> }
		triangle { <-10,-24,-10>, <-10,0,-10>, <10,0,-10> }
		triangle { <10,0,-10>, <10,-24,-10>, <10,-24,-6> }
		triangle { <10,-24,-6>, <10,0,-6>, <10,0,-10> }
		triangle { <-10,0,-10>, <-10,-24,-10>, <-10,-24,-6> }
		triangle { <-10,-24,-6>, <-10,0,-6>, <-10,0,-10> }
		triangle { <10,0,-6>, <10,-24,-6>, <6,-24,-6> }
		triangle { <6,-24,-6>, <6,0,-6>, <10,0,-6> }
		triangle { <-10,0,-6>, <-10,-24,-6>, <-6,-24,-6> }
		triangle { <-6,-24,-6>, <-6,0,-6>, <-10,0,-6> }
		triangle { <6,0,-6>, <6,-24,-6>, <6,-21.12,-3.84> }
		triangle { <6,-21.12,-3.84>, <6,0,-3.84>, <6,0,-6> }
		triangle { <-6,0,-6>, <-6,-24,-6>, <-6,-21.12,-3.84> }
		triangle { <-6,-21.12,-3.84>, <-6,0,-3.84>, <-6,0,-6> }
		triangle { <6,0,-3.84>, <6,-21.12,-3.84>, <2,-17.92,-1.44> }
		triangle { <2,-17.92,-1.44>, <2,0,-1.44>, <6,0,-3.84> }
		triangle { <-6,0,-3.84>, <-6,-21.12,-3.84>, <-2,-17.92,-1.44> }
		triangle { <-2,-17.92,-1.44>, <-2,0,-1.44>, <-6,0,-3.84> }
		triangle { <2,0,-1.44>, <2,-17.92,-1.44>, <-2,-17.92,-1.44> }
		triangle { <-2,-17.92,-1.44>, <-2,0,-1.44>, <2,0,-1.44> }
		triangle { <10,-24,-6>, <10,-24,-10>, <-10,-24,-10> }
		triangle { <-10,-24,-10>, <-10,-24,-6>, <10,-24,-6> }
		triangle { <6,-21.12,-3.84>, <6,-24,-6>, <-6,-24,-6> }
		triangle { <-6,-24,-6>, <-6,-21.12,-3.84>, <6,-21.12,-3.84> }
		triangle { <2,-17.92,-1.44>, <6,-21.12,-3.84>, <-6,-21.12,-3.84> }
		triangle { <-6,-21.12,-3.84>, <-2,-17.92,-1.44>, <2,-17.92,-1.44> }
		triangle { <4,-24,-6>, <4,-24.32,-6.24>, <4,-24,-6.48> }
		triangle { <-4,-24,-6>, <-4,-24.32,-6.24>, <-4,-24,-6.48> }
		triangle { <4,-24,-6.48>, <4,-24.32,-6.24>, <2,-25.92,-7.44> }
		triangle { <2,-25.92,-7.44>, <2,-24,-10>, <4,-24,-6.48> }
		triangle { <-4,-24,-6.48>, <-4,-24.32,-6.24>, <-2,-25.92,-7.44> }
		triangle { <-2,-25.92,-7.44>, <-2,-24,-10>, <-4,-24,-6.48> }
		triangle { <2,-24,-10>, <2,-25.92,-7.44>, <-2,-25.92,-7.44> }
		triangle { <-2,-25.92,-7.44>, <-2,-24,-10>, <2,-24,-10> }
		triangle { <2,-23.12,2.16>, <4,-24.72,0.96>, <4,-21.12,-3.84> }
		triangle { <4,-21.12,-3.84>, <2,-19.52,-2.64>, <2,-23.12,2.16> }
		triangle { <4,-24.72,0.96>, <4,-27.92,-1.44>, <4,-24.32,-6.24> }
		triangle { <4,-24.32,-6.24>, <4,-21.12,-3.84>, <4,-24.72,0.96> }
		triangle { <4,-27.92,-1.44>, <2,-29.52,-2.64>, <2,-25.92,-7.44> }
		triangle { <2,-25.92,-7.44>, <4,-24.32,-6.24>, <4,-27.92,-1.44> }
		triangle { <2,-29.52,-2.64>, <-2,-29.52,-2.64>, <-2,-25.92,-7.44> }
		triangle { <-2,-25.92,-7.44>, <2,-25.92,-7.44>, <2,-29.52,-2.64> }
		triangle { <-2,-29.52,-2.64>, <-4,-27.92,-1.44>, <-4,-24.32,-6.24> }
		triangle { <-4,-24.32,-6.24>, <-2,-25.92,-7.44>, <-2,-29.52,-2.64> }
		triangle { <-4,-27.92,-1.44>, <-4,-24.72,0.96>, <-4,-21.12,-3.84> }
		triangle { <-4,-21.12,-3.84>, <-4,-24.32,-6.24>, <-4,-27.92,-1.44> }
		triangle { <-4,-24.72,0.96>, <-2,-23.12,2.16>, <-2,-19.52,-2.64> }
		triangle { <-2,-19.52,-2.64>, <-4,-21.12,-3.84>, <-4,-24.72,0.96> }
		triangle { <-2,-23.12,2.16>, <2,-23.12,2.16>, <2,-19.52,-2.64> }
		triangle { <2,-19.52,-2.64>, <-2,-19.52,-2.64>, <-2,-23.12,2.16> }
		triangle { <2,-29.52,-2.64>, <4,-27.92,-1.44>, <-4,-27.92,-1.44> }
		triangle { <-4,-27.92,-1.44>, <-2,-29.52,-2.64>, <2,-29.52,-2.64> }
		triangle { <4,-27.92,-1.44>, <4,-24.72,0.96>, <-4,-24.72,0.96> }
		triangle { <-4,-24.72,0.96>, <-4,-27.92,-1.44>, <4,-27.92,-1.44> }
		triangle { <4,-24.72,0.96>, <2,-23.12,2.16>, <-2,-23.12,2.16> }
		triangle { <-2,-23.12,2.16>, <-4,-24.72,0.96>, <4,-24.72,0.96> }
	}
}
#end

#declare _3829b_dot_dat = #if (QUAL = 0) box { <-14,-2,-14>, <14,6,14> } #else object {
// ~Car Steering Wheel
	mesh {
		triangle { <-11.7956,0,1.5529>, <-5.7956,0,1.5529>, <-5.7956,6,1.5529> }
		triangle { <-5.7956,6,1.5529>, <-11.7956,2,1.5529>, <-11.7956,0,1.5529> }
		triangle { <-11.7956,0,-1.5529>, <-5.7956,0,-1.5529>, <-5.7956,6,-1.5529> }
		triangle { <-5.7956,6,-1.5529>, <-11.7956,2,-1.5529>, <-11.7956,0,-1.5529> }
		triangle { <-11.7956,0,1.5529>, <-5.7956,0,1.5529>, <-6,0,0> }
		triangle { <-6,0,0>, <-12,0,0>, <-11.7956,0,1.5529> }
		triangle { <-11.7956,0,-1.5529>, <-5.7956,0,-1.5529>, <-6,0,0> }
		triangle { <-6,0,0>, <-12,0,0>, <-11.7956,0,-1.5529> }
		triangle { <-11.7956,2,1.5529>, <-5.7956,6,1.5529>, <-6,6,0> }
		triangle { <-6,6,0>, <-12,2,0>, <-11.7956,2,1.5529> }
		triangle { <-11.7956,2,-1.5529>, <-5.7956,6,-1.5529>, <-6,6,0> }
		triangle { <-6,6,0>, <-12,2,0>, <-11.7956,2,-1.5529> }
		triangle { <-4,0,0>, <-3.8637,0,-1.0353>, <-3.8637,6,-1.0353> }
		triangle { <-3.8637,6,-1.0353>, <-4,6,0>, <-4,0,0> }
		triangle { <-6,0,0>, <-5.7956,0,-1.5529>, <-5.7956,6,-1.5529> }
		triangle { <-5.7956,6,-1.5529>, <-6,6,0>, <-6,0,0> }
		triangle { <-4,0,0>, <-3.8637,0,-1.0353>, <-5.7956,0,-1.5529> }
		triangle { <-5.7956,0,-1.5529>, <-6,0,0>, <-4,0,0> }
		triangle { <-4,6,0>, <-3.8637,6,-1.0353>, <-5.7956,6,-1.5529> }
		triangle { <-5.7956,6,-1.5529>, <-6,6,0>, <-4,6,0> }
		triangle { <-12,-2,0>, <-11.5911,-2,-3.1058>, <-11.5911,2,-3.1058> }
		triangle { <-11.5911,2,-3.1058>, <-12,2,0>, <-12,-2,0> }
		triangle { <-14,-2,0>, <-13.523,-2,-3.6235>, <-13.523,2,-3.6235> }
		triangle { <-13.523,2,-3.6235>, <-14,2,0>, <-14,-2,0> }
		triangle { <-12,-2,0>, <-11.5911,-2,-3.1058>, <-13.523,-2,-3.6235> }
		triangle { <-13.523,-2,-3.6235>, <-14,-2,0>, <-12,-2,0> }
		triangle { <-12,2,0>, <-11.5911,2,-3.1058>, <-13.523,2,-3.6235> }
		triangle { <-13.523,2,-3.6235>, <-14,2,0>, <-12,2,0> }
		triangle { <-3.8637,0,-1.0353>, <-3.4641,0,-2>, <-3.4641,6,-2> }
		triangle { <-3.4641,6,-2>, <-3.8637,6,-1.0353>, <-3.8637,0,-1.0353> }
		triangle { <-5.7956,0,-1.5529>, <-5.1962,0,-3>, <-5.1962,6,-3> }
		triangle { <-5.1962,6,-3>, <-5.7956,6,-1.5529>, <-5.7956,0,-1.5529> }
		triangle { <-3.8637,0,-1.0353>, <-3.4641,0,-2>, <-5.1962,0,-3> }
		triangle { <-5.1962,0,-3>, <-5.7956,0,-1.5529>, <-3.8637,0,-1.0353> }
		triangle { <-3.8637,6,-1.0353>, <-3.4641,6,-2>, <-5.1962,6,-3> }
		triangle { <-5.1962,6,-3>, <-5.7956,6,-1.5529>, <-3.8637,6,-1.0353> }
		triangle { <-11.5911,-2,-3.1058>, <-10.3923,-2,-6>, <-10.3923,2,-6> }
		triangle { <-10.3923,2,-6>, <-11.5911,2,-3.1058>, <-11.5911,-2,-3.1058> }
		triangle { <-13.523,-2,-3.6235>, <-12.1244,-2,-7>, <-12.1244,2,-7> }
		triangle { <-12.1244,2,-7>, <-13.523,2,-3.6235>, <-13.523,-2,-3.6235> }
		triangle { <-11.5911,-2,-3.1058>, <-10.3923,-2,-6>, <-12.1244,-2,-7> }
		triangle { <-12.1244,-2,-7>, <-13.523,-2,-3.6235>, <-11.5911,-2,-3.1058> }
		triangle { <-11.5911,2,-3.1058>, <-10.3923,2,-6>, <-12.1244,2,-7> }
		triangle { <-12.1244,2,-7>, <-13.523,2,-3.6235>, <-11.5911,2,-3.1058> }
		triangle { <-3.4641,0,-2>, <-2.8284,0,-2.8284>, <-2.8284,6,-2.8284> }
		triangle { <-2.8284,6,-2.8284>, <-3.4641,6,-2>, <-3.4641,0,-2> }
		triangle { <-5.1962,0,-3>, <-4.2426,0,-4.2426>, <-4.2426,6,-4.2426> }
		triangle { <-4.2426,6,-4.2426>, <-5.1962,6,-3>, <-5.1962,0,-3> }
		triangle { <-3.4641,0,-2>, <-2.8284,0,-2.8284>, <-4.2426,0,-4.2426> }
		triangle { <-4.2426,0,-4.2426>, <-5.1962,0,-3>, <-3.4641,0,-2> }
		triangle { <-3.4641,6,-2>, <-2.8284,6,-2.8284>, <-4.2426,6,-4.2426> }
		triangle { <-4.2426,6,-4.2426>, <-5.1962,6,-3>, <-3.4641,6,-2> }
		triangle { <-10.3923,-2,-6>, <-8.4853,-2,-8.4853>, <-8.4853,2,-8.4853> }
		triangle { <-8.4853,2,-8.4853>, <-10.3923,2,-6>, <-10.3923,-2,-6> }
		triangle { <-12.1244,-2,-7>, <-9.8995,-2,-9.8995>, <-9.8995,2,-9.8995> }
		triangle { <-9.8995,2,-9.8995>, <-12.1244,2,-7>, <-12.1244,-2,-7> }
		triangle { <-10.3923,-2,-6>, <-8.4853,-2,-8.4853>, <-9.8995,-2,-9.8995> }
		triangle { <-9.8995,-2,-9.8995>, <-12.1244,-2,-7>, <-10.3923,-2,-6> }
		triangle { <-10.3923,2,-6>, <-8.4853,2,-8.4853>, <-9.8995,2,-9.8995> }
		triangle { <-9.8995,2,-9.8995>, <-12.1244,2,-7>, <-10.3923,2,-6> }
		triangle { <-2.8284,0,-2.8284>, <-2,0,-3.4641>, <-2,6,-3.4641> }
		triangle { <-2,6,-3.4641>, <-2.8284,6,-2.8284>, <-2.8284,0,-2.8284> }
		triangle { <-4.2426,0,-4.2426>, <-3,0,-5.1962>, <-3,6,-5.1962> }
		triangle { <-3,6,-5.1962>, <-4.2426,6,-4.2426>, <-4.2426,0,-4.2426> }
		triangle { <-2.8284,0,-2.8284>, <-2,0,-3.4641>, <-3,0,-5.1962> }
		triangle { <-3,0,-5.1962>, <-4.2426,0,-4.2426>, <-2.8284,0,-2.8284> }
		triangle { <-2.8284,6,-2.8284>, <-2,6,-3.4641>, <-3,6,-5.1962> }
		triangle { <-3,6,-5.1962>, <-4.2426,6,-4.2426>, <-2.8284,6,-2.8284> }
		triangle { <-8.4853,-2,-8.4853>, <-6,-2,-10.3923>, <-6,2,-10.3923> }
		triangle { <-6,2,-10.3923>, <-8.4853,2,-8.4853>, <-8.4853,-2,-8.4853> }
		triangle { <-9.8995,-2,-9.8995>, <-7,-2,-12.1244>, <-7,2,-12.1244> }
		triangle { <-7,2,-12.1244>, <-9.8995,2,-9.8995>, <-9.8995,-2,-9.8995> }
		triangle { <-8.4853,-2,-8.4853>, <-6,-2,-10.3923>, <-7,-2,-12.1244> }
		triangle { <-7,-2,-12.1244>, <-9.8995,-2,-9.8995>, <-8.4853,-2,-8.4853> }
		triangle { <-8.4853,2,-8.4853>, <-6,2,-10.3923>, <-7,2,-12.1244> }
		triangle { <-7,2,-12.1244>, <-9.8995,2,-9.8995>, <-8.4853,2,-8.4853> }
		triangle { <-2,0,-3.4641>, <-1.0353,0,-3.8637>, <-1.0353,6,-3.8637> }
		triangle { <-1.0353,6,-3.8637>, <-2,6,-3.4641>, <-2,0,-3.4641> }
		triangle { <-3,0,-5.1962>, <-1.5529,0,-5.7956>, <-1.5529,6,-5.7956> }
		triangle { <-1.5529,6,-5.7956>, <-3,6,-5.1962>, <-3,0,-5.1962> }
		triangle { <-2,0,-3.4641>, <-1.0353,0,-3.8637>, <-1.5529,0,-5.7956> }
		triangle { <-1.5529,0,-5.7956>, <-3,0,-5.1962>, <-2,0,-3.4641> }
		triangle { <-2,6,-3.4641>, <-1.0353,6,-3.8637>, <-1.5529,6,-5.7956> }
		triangle { <-1.5529,6,-5.7956>, <-3,6,-5.1962>, <-2,6,-3.4641> }
		triangle { <-6,-2,-10.3923>, <-3.1058,-2,-11.5911>, <-3.1058,2,-11.5911> }
		triangle { <-3.1058,2,-11.5911>, <-6,2,-10.3923>, <-6,-2,-10.3923> }
		triangle { <-7,-2,-12.1244>, <-3.6235,-2,-13.523>, <-3.6235,2,-13.523> }
		triangle { <-3.6235,2,-13.523>, <-7,2,-12.1244>, <-7,-2,-12.1244> }
		triangle { <-6,-2,-10.3923>, <-3.1058,-2,-11.5911>, <-3.6235,-2,-13.523> }
		triangle { <-3.6235,-2,-13.523>, <-7,-2,-12.1244>, <-6,-2,-10.3923> }
		triangle { <-6,2,-10.3923>, <-3.1058,2,-11.5911>, <-3.6235,2,-13.523> }
		triangle { <-3.6235,2,-13.523>, <-7,2,-12.1244>, <-6,2,-10.3923> }
		triangle { <-1.0353,0,-3.8637>, <0,0,-4>, <0,6,-4> }
		triangle { <0,6,-4>, <-1.0353,6,-3.8637>, <-1.0353,0,-3.8637> }
		triangle { <-1.5529,0,-5.7956>, <0,0,-6>, <0,6,-6> }
		triangle { <0,6,-6>, <-1.5529,6,-5.7956>, <-1.5529,0,-5.7956> }
		triangle { <-1.0353,0,-3.8637>, <0,0,-4>, <0,0,-6> }
		triangle { <0,0,-6>, <-1.5529,0,-5.7956>, <-1.0353,0,-3.8637> }
		triangle { <-1.0353,6,-3.8637>, <0,6,-4>, <0,6,-6> }
		triangle { <0,6,-6>, <-1.5529,6,-5.7956>, <-1.0353,6,-3.8637> }
		triangle { <-3.1058,-2,-11.5911>, <0,-2,-12>, <0,2,-12> }
		triangle { <0,2,-12>, <-3.1058,2,-11.5911>, <-3.1058,-2,-11.5911> }
		triangle { <-3.6235,-2,-13.523>, <0,-2,-14>, <0,2,-14> }
		triangle { <0,2,-14>, <-3.6235,2,-13.523>, <-3.6235,-2,-13.523> }
		triangle { <-3.1058,-2,-11.5911>, <0,-2,-12>, <0,-2,-14> }
		triangle { <0,-2,-14>, <-3.6235,-2,-13.523>, <-3.1058,-2,-11.5911> }
		triangle { <-3.1058,2,-11.5911>, <0,2,-12>, <0,2,-14> }
		triangle { <0,2,-14>, <-3.6235,2,-13.523>, <-3.1058,2,-11.5911> }
		triangle { <0,0,-4>, <1.0353,0,-3.8637>, <1.0353,6,-3.8637> }
		triangle { <1.0353,6,-3.8637>, <0,6,-4>, <0,0,-4> }
		triangle { <0,0,-6>, <1.5529,0,-5.7956>, <1.5529,6,-5.7956> }
		triangle { <1.5529,6,-5.7956>, <0,6,-6>, <0,0,-6> }
		triangle { <0,0,-4>, <1.0353,0,-3.8637>, <1.5529,0,-5.7956> }
		triangle { <1.5529,0,-5.7956>, <0,0,-6>, <0,0,-4> }
		triangle { <0,6,-4>, <1.0353,6,-3.8637>, <1.5529,6,-5.7956> }
		triangle { <1.5529,6,-5.7956>, <0,6,-6>, <0,6,-4> }
		triangle { <0,-2,-12>, <3.1058,-2,-11.5911>, <3.1058,2,-11.5911> }
		triangle { <3.1058,2,-11.5911>, <0,2,-12>, <0,-2,-12> }
		triangle { <0,-2,-14>, <3.6235,-2,-13.523>, <3.6235,2,-13.523> }
		triangle { <3.6235,2,-13.523>, <0,2,-14>, <0,-2,-14> }
		triangle { <0,-2,-12>, <3.1058,-2,-11.5911>, <3.6235,-2,-13.523> }
		triangle { <3.6235,-2,-13.523>, <0,-2,-14>, <0,-2,-12> }
		triangle { <0,2,-12>, <3.1058,2,-11.5911>, <3.6235,2,-13.523> }
		triangle { <3.6235,2,-13.523>, <0,2,-14>, <0,2,-12> }
		triangle { <1.0353,0,-3.8637>, <2,0,-3.4641>, <2,6,-3.4641> }
		triangle { <2,6,-3.4641>, <1.0353,6,-3.8637>, <1.0353,0,-3.8637> }
		triangle { <1.5529,0,-5.7956>, <3,0,-5.1962>, <3,6,-5.1962> }
		triangle { <3,6,-5.1962>, <1.5529,6,-5.7956>, <1.5529,0,-5.7956> }
		triangle { <1.0353,0,-3.8637>, <2,0,-3.4641>, <3,0,-5.1962> }
		triangle { <3,0,-5.1962>, <1.5529,0,-5.7956>, <1.0353,0,-3.8637> }
		triangle { <1.0353,6,-3.8637>, <2,6,-3.4641>, <3,6,-5.1962> }
		triangle { <3,6,-5.1962>, <1.5529,6,-5.7956>, <1.0353,6,-3.8637> }
		triangle { <3.1058,-2,-11.5911>, <6,-2,-10.3923>, <6,2,-10.3923> }
		triangle { <6,2,-10.3923>, <3.1058,2,-11.5911>, <3.1058,-2,-11.5911> }
		triangle { <3.6235,-2,-13.523>, <7,-2,-12.1244>, <7,2,-12.1244> }
		triangle { <7,2,-12.1244>, <3.6235,2,-13.523>, <3.6235,-2,-13.523> }
		triangle { <3.1058,-2,-11.5911>, <6,-2,-10.3923>, <7,-2,-12.1244> }
		triangle { <7,-2,-12.1244>, <3.6235,-2,-13.523>, <3.1058,-2,-11.5911> }
		triangle { <3.1058,2,-11.5911>, <6,2,-10.3923>, <7,2,-12.1244> }
		triangle { <7,2,-12.1244>, <3.6235,2,-13.523>, <3.1058,2,-11.5911> }
		triangle { <4.5529,0,-10.9917>, <1.5529,0,-5.7956>, <1.5529,6,-5.7956> }
		triangle { <1.5529,6,-5.7956>, <4.5529,2,-10.9917>, <4.5529,0,-10.9917> }
		triangle { <7.2426,0,-9.4388>, <4.2426,0,-4.2426>, <4.2426,6,-4.2426> }
		triangle { <4.2426,6,-4.2426>, <7.2426,2,-9.4388>, <7.2426,0,-9.4388> }
		triangle { <4.5529,0,-10.9917>, <1.5529,0,-5.7956>, <3,0,-5.1962> }
		triangle { <3,0,-5.1962>, <6,0,-10.3923>, <4.5529,0,-10.9917> }
		triangle { <7.2426,0,-9.4388>, <4.2426,0,-4.2426>, <3,0,-5.1962> }
		triangle { <3,0,-5.1962>, <6,0,-10.3923>, <7.2426,0,-9.4388> }
		triangle { <4.5529,2,-10.9917>, <1.5529,6,-5.7956>, <3,6,-5.1962> }
		triangle { <3,6,-5.1962>, <6,2,-10.3923>, <4.5529,2,-10.9917> }
		triangle { <7.2426,2,-9.4388>, <4.2426,6,-4.2426>, <3,6,-5.1962> }
		triangle { <3,6,-5.1962>, <6,2,-10.3923>, <7.2426,2,-9.4388> }
		triangle { <2,0,-3.4641>, <2.8284,0,-2.8284>, <2.8284,6,-2.8284> }
		triangle { <2.8284,6,-2.8284>, <2,6,-3.4641>, <2,0,-3.4641> }
		triangle { <3,0,-5.1962>, <4.2426,0,-4.2426>, <4.2426,6,-4.2426> }
		triangle { <4.2426,6,-4.2426>, <3,6,-5.1962>, <3,0,-5.1962> }
		triangle { <2,0,-3.4641>, <2.8284,0,-2.8284>, <4.2426,0,-4.2426> }
		triangle { <4.2426,0,-4.2426>, <3,0,-5.1962>, <2,0,-3.4641> }
		triangle { <2,6,-3.4641>, <2.8284,6,-2.8284>, <4.2426,6,-4.2426> }
		triangle { <4.2426,6,-4.2426>, <3,6,-5.1962>, <2,6,-3.4641> }
		triangle { <6,-2,-10.3923>, <8.4853,-2,-8.4853>, <8.4853,2,-8.4853> }
		triangle { <8.4853,2,-8.4853>, <6,2,-10.3923>, <6,-2,-10.3923> }
		triangle { <7,-2,-12.1244>, <9.8995,-2,-9.8995>, <9.8995,2,-9.8995> }
		triangle { <9.8995,2,-9.8995>, <7,2,-12.1244>, <7,-2,-12.1244> }
		triangle { <6,-2,-10.3923>, <8.4853,-2,-8.4853>, <9.8995,-2,-9.8995> }
		triangle { <9.8995,-2,-9.8995>, <7,-2,-12.1244>, <6,-2,-10.3923> }
		triangle { <6,2,-10.3923>, <8.4853,2,-8.4853>, <9.8995,2,-9.8995> }
		triangle { <9.8995,2,-9.8995>, <7,2,-12.1244>, <6,2,-10.3923> }
		triangle { <2.8284,0,-2.8284>, <3.4641,0,-2>, <3.4641,6,-2> }
		triangle { <3.4641,6,-2>, <2.8284,6,-2.8284>, <2.8284,0,-2.8284> }
		triangle { <4.2426,0,-4.2426>, <5.1962,0,-3>, <5.1962,6,-3> }
		triangle { <5.1962,6,-3>, <4.2426,6,-4.2426>, <4.2426,0,-4.2426> }
		triangle { <2.8284,0,-2.8284>, <3.4641,0,-2>, <5.1962,0,-3> }
		triangle { <5.1962,0,-3>, <4.2426,0,-4.2426>, <2.8284,0,-2.8284> }
		triangle { <2.8284,6,-2.8284>, <3.4641,6,-2>, <5.1962,6,-3> }
		triangle { <5.1962,6,-3>, <4.2426,6,-4.2426>, <2.8284,6,-2.8284> }
		triangle { <8.4853,-2,-8.4853>, <10.3923,-2,-6>, <10.3923,2,-6> }
		triangle { <10.3923,2,-6>, <8.4853,2,-8.4853>, <8.4853,-2,-8.4853> }
		triangle { <9.8995,-2,-9.8995>, <12.1244,-2,-7>, <12.1244,2,-7> }
		triangle { <12.1244,2,-7>, <9.8995,2,-9.8995>, <9.8995,-2,-9.8995> }
		triangle { <8.4853,-2,-8.4853>, <10.3923,-2,-6>, <12.1244,-2,-7> }
		triangle { <12.1244,-2,-7>, <9.8995,-2,-9.8995>, <8.4853,-2,-8.4853> }
		triangle { <8.4853,2,-8.4853>, <10.3923,2,-6>, <12.1244,2,-7> }
		triangle { <12.1244,2,-7>, <9.8995,2,-9.8995>, <8.4853,2,-8.4853> }
		triangle { <3.4641,0,-2>, <3.8637,0,-1.0353>, <3.8637,6,-1.0353> }
		triangle { <3.8637,6,-1.0353>, <3.4641,6,-2>, <3.4641,0,-2> }
		triangle { <5.1962,0,-3>, <5.7956,0,-1.5529>, <5.7956,6,-1.5529> }
		triangle { <5.7956,6,-1.5529>, <5.1962,6,-3>, <5.1962,0,-3> }
		triangle { <3.4641,0,-2>, <3.8637,0,-1.0353>, <5.7956,0,-1.5529> }
		triangle { <5.7956,0,-1.5529>, <5.1962,0,-3>, <3.4641,0,-2> }
		triangle { <3.4641,6,-2>, <3.8637,6,-1.0353>, <5.7956,6,-1.5529> }
		triangle { <5.7956,6,-1.5529>, <5.1962,6,-3>, <3.4641,6,-2> }
		triangle { <10.3923,-2,-6>, <11.5911,-2,-3.1058>, <11.5911,2,-3.1058> }
		triangle { <11.5911,2,-3.1058>, <10.3923,2,-6>, <10.3923,-2,-6> }
		triangle { <12.1244,-2,-7>, <13.523,-2,-3.6235>, <13.523,2,-3.6235> }
		triangle { <13.523,2,-3.6235>, <12.1244,2,-7>, <12.1244,-2,-7> }
		triangle { <10.3923,-2,-6>, <11.5911,-2,-3.1058>, <13.523,-2,-3.6235> }
		triangle { <13.523,-2,-3.6235>, <12.1244,-2,-7>, <10.3923,-2,-6> }
		triangle { <10.3923,2,-6>, <11.5911,2,-3.1058>, <13.523,2,-3.6235> }
		triangle { <13.523,2,-3.6235>, <12.1244,2,-7>, <10.3923,2,-6> }
		triangle { <3.8637,0,-1.0353>, <4,0,0>, <4,6,0> }
		triangle { <4,6,0>, <3.8637,6,-1.0353>, <3.8637,0,-1.0353> }
		triangle { <5.7956,0,-1.5529>, <6,0,0>, <6,6,0> }
		triangle { <6,6,0>, <5.7956,6,-1.5529>, <5.7956,0,-1.5529> }
		triangle { <3.8637,0,-1.0353>, <4,0,0>, <6,0,0> }
		triangle { <6,0,0>, <5.7956,0,-1.5529>, <3.8637,0,-1.0353> }
		triangle { <3.8637,6,-1.0353>, <4,6,0>, <6,6,0> }
		triangle { <6,6,0>, <5.7956,6,-1.5529>, <3.8637,6,-1.0353> }
		triangle { <11.5911,-2,-3.1058>, <12,-2,0>, <12,2,0> }
		triangle { <12,2,0>, <11.5911,2,-3.1058>, <11.5911,-2,-3.1058> }
		triangle { <13.523,-2,-3.6235>, <14,-2,0>, <14,2,0> }
		triangle { <14,2,0>, <13.523,2,-3.6235>, <13.523,-2,-3.6235> }
		triangle { <11.5911,-2,-3.1058>, <12,-2,0>, <14,-2,0> }
		triangle { <14,-2,0>, <13.523,-2,-3.6235>, <11.5911,-2,-3.1058> }
		triangle { <11.5911,2,-3.1058>, <12,2,0>, <14,2,0> }
		triangle { <14,2,0>, <13.523,2,-3.6235>, <11.5911,2,-3.1058> }
		triangle { <4,0,0>, <3.8637,0,1.0353>, <3.8637,6,1.0353> }
		triangle { <3.8637,6,1.0353>, <4,6,0>, <4,0,0> }
		triangle { <6,0,0>, <5.7956,0,1.5529>, <5.7956,6,1.5529> }
		triangle { <5.7956,6,1.5529>, <6,6,0>, <6,0,0> }
		triangle { <4,0,0>, <3.8637,0,1.0353>, <5.7956,0,1.5529> }
		triangle { <5.7956,0,1.5529>, <6,0,0>, <4,0,0> }
		triangle { <4,6,0>, <3.8637,6,1.0353>, <5.7956,6,1.5529> }
		triangle { <5.7956,6,1.5529>, <6,6,0>, <4,6,0> }
		triangle { <12,-2,0>, <11.5911,-2,3.1058>, <11.5911,2,3.1058> }
		triangle { <11.5911,2,3.1058>, <12,2,0>, <12,-2,0> }
		triangle { <14,-2,0>, <13.523,-2,3.6235>, <13.523,2,3.6235> }
		triangle { <13.523,2,3.6235>, <14,2,0>, <14,-2,0> }
		triangle { <12,-2,0>, <11.5911,-2,3.1058>, <13.523,-2,3.6235> }
		triangle { <13.523,-2,3.6235>, <14,-2,0>, <12,-2,0> }
		triangle { <12,2,0>, <11.5911,2,3.1058>, <13.523,2,3.6235> }
		triangle { <13.523,2,3.6235>, <14,2,0>, <12,2,0> }
		triangle { <3.8637,0,1.0353>, <3.4641,0,2>, <3.4641,6,2> }
		triangle { <3.4641,6,2>, <3.8637,6,1.0353>, <3.8637,0,1.0353> }
		triangle { <5.7956,0,1.5529>, <5.1962,0,3>, <5.1962,6,3> }
		triangle { <5.1962,6,3>, <5.7956,6,1.5529>, <5.7956,0,1.5529> }
		triangle { <3.8637,0,1.0353>, <3.4641,0,2>, <5.1962,0,3> }
		triangle { <5.1962,0,3>, <5.7956,0,1.5529>, <3.8637,0,1.0353> }
		triangle { <3.8637,6,1.0353>, <3.4641,6,2>, <5.1962,6,3> }
		triangle { <5.1962,6,3>, <5.7956,6,1.5529>, <3.8637,6,1.0353> }
		triangle { <11.5911,-2,3.1058>, <10.3923,-2,6>, <10.3923,2,6> }
		triangle { <10.3923,2,6>, <11.5911,2,3.1058>, <11.5911,-2,3.1058> }
		triangle { <13.523,-2,3.6235>, <12.1244,-2,7>, <12.1244,2,7> }
		triangle { <12.1244,2,7>, <13.523,2,3.6235>, <13.523,-2,3.6235> }
		triangle { <11.5911,-2,3.1058>, <10.3923,-2,6>, <12.1244,-2,7> }
		triangle { <12.1244,-2,7>, <13.523,-2,3.6235>, <11.5911,-2,3.1058> }
		triangle { <11.5911,2,3.1058>, <10.3923,2,6>, <12.1244,2,7> }
		triangle { <12.1244,2,7>, <13.523,2,3.6235>, <11.5911,2,3.1058> }
		triangle { <3.4641,0,2>, <2.8284,0,2.8284>, <2.8284,6,2.8284> }
		triangle { <2.8284,6,2.8284>, <3.4641,6,2>, <3.4641,0,2> }
		triangle { <5.1962,0,3>, <4.2426,0,4.2426>, <4.2426,6,4.2426> }
		triangle { <4.2426,6,4.2426>, <5.1962,6,3>, <5.1962,0,3> }
		triangle { <3.4641,0,2>, <2.8284,0,2.8284>, <4.2426,0,4.2426> }
		triangle { <4.2426,0,4.2426>, <5.1962,0,3>, <3.4641,0,2> }
		triangle { <3.4641,6,2>, <2.8284,6,2.8284>, <4.2426,6,4.2426> }
		triangle { <4.2426,6,4.2426>, <5.1962,6,3>, <3.4641,6,2> }
		triangle { <10.3923,-2,6>, <8.4853,-2,8.4853>, <8.4853,2,8.4853> }
		triangle { <8.4853,2,8.4853>, <10.3923,2,6>, <10.3923,-2,6> }
		triangle { <12.1244,-2,7>, <9.8995,-2,9.8995>, <9.8995,2,9.8995> }
		triangle { <9.8995,2,9.8995>, <12.1244,2,7>, <12.1244,-2,7> }
		triangle { <10.3923,-2,6>, <8.4853,-2,8.4853>, <9.8995,-2,9.8995> }
		triangle { <9.8995,-2,9.8995>, <12.1244,-2,7>, <10.3923,-2,6> }
		triangle { <10.3923,2,6>, <8.4853,2,8.4853>, <9.8995,2,9.8995> }
		triangle { <9.8995,2,9.8995>, <12.1244,2,7>, <10.3923,2,6> }
		triangle { <2.8284,0,2.8284>, <2,0,3.4641>, <2,6,3.4641> }
		triangle { <2,6,3.4641>, <2.8284,6,2.8284>, <2.8284,0,2.8284> }
		triangle { <4.2426,0,4.2426>, <3,0,5.1962>, <3,6,5.1962> }
		triangle { <3,6,5.1962>, <4.2426,6,4.2426>, <4.2426,0,4.2426> }
		triangle { <2.8284,0,2.8284>, <2,0,3.4641>, <3,0,5.1962> }
		triangle { <3,0,5.1962>, <4.2426,0,4.2426>, <2.8284,0,2.8284> }
		triangle { <2.8284,6,2.8284>, <2,6,3.4641>, <3,6,5.1962> }
		triangle { <3,6,5.1962>, <4.2426,6,4.2426>, <2.8284,6,2.8284> }
		triangle { <8.4853,-2,8.4853>, <6,-2,10.3923>, <6,2,10.3923> }
		triangle { <6,2,10.3923>, <8.4853,2,8.4853>, <8.4853,-2,8.4853> }
		triangle { <9.8995,-2,9.8995>, <7,-2,12.1244>, <7,2,12.1244> }
		triangle { <7,2,12.1244>, <9.8995,2,9.8995>, <9.8995,-2,9.8995> }
		triangle { <8.4853,-2,8.4853>, <6,-2,10.3923>, <7,-2,12.1244> }
		triangle { <7,-2,12.1244>, <9.8995,-2,9.8995>, <8.4853,-2,8.4853> }
		triangle { <8.4853,2,8.4853>, <6,2,10.3923>, <7,2,12.1244> }
		triangle { <7,2,12.1244>, <9.8995,2,9.8995>, <8.4853,2,8.4853> }
		triangle { <7.2426,0,9.4388>, <4.2426,0,4.2426>, <4.2426,6,4.2426> }
		triangle { <4.2426,6,4.2426>, <7.2426,2,9.4388>, <7.2426,0,9.4388> }
		triangle { <4.5529,0,10.9917>, <1.5529,0,5.7956>, <1.5529,6,5.7956> }
		triangle { <1.5529,6,5.7956>, <4.5529,2,10.9917>, <4.5529,0,10.9917> }
		triangle { <7.2426,0,9.4388>, <4.2426,0,4.2426>, <3,0,5.1962> }
		triangle { <3,0,5.1962>, <6,0,10.3923>, <7.2426,0,9.4388> }
		triangle { <4.5529,0,10.9917>, <1.5529,0,5.7956>, <3,0,5.1962> }
		triangle { <3,0,5.1962>, <6,0,10.3923>, <4.5529,0,10.9917> }
		triangle { <7.2426,2,9.4388>, <4.2426,6,4.2426>, <3,6,5.1962> }
		triangle { <3,6,5.1962>, <6,2,10.3923>, <7.2426,2,9.4388> }
		triangle { <4.5529,2,10.9917>, <1.5529,6,5.7956>, <3,6,5.1962> }
		triangle { <3,6,5.1962>, <6,2,10.3923>, <4.5529,2,10.9917> }
		triangle { <2,0,3.4641>, <1.0353,0,3.8637>, <1.0353,6,3.8637> }
		triangle { <1.0353,6,3.8637>, <2,6,3.4641>, <2,0,3.4641> }
		triangle { <3,0,5.1962>, <1.5529,0,5.7956>, <1.5529,6,5.7956> }
		triangle { <1.5529,6,5.7956>, <3,6,5.1962>, <3,0,5.1962> }
		triangle { <2,0,3.4641>, <1.0353,0,3.8637>, <1.5529,0,5.7956> }
		triangle { <1.5529,0,5.7956>, <3,0,5.1962>, <2,0,3.4641> }
		triangle { <2,6,3.4641>, <1.0353,6,3.8637>, <1.5529,6,5.7956> }
		triangle { <1.5529,6,5.7956>, <3,6,5.1962>, <2,6,3.4641> }
		triangle { <6,-2,10.3923>, <3.1058,-2,11.5911>, <3.1058,2,11.5911> }
		triangle { <3.1058,2,11.5911>, <6,2,10.3923>, <6,-2,10.3923> }
		triangle { <7,-2,12.1244>, <3.6235,-2,13.523>, <3.6235,2,13.523> }
		triangle { <3.6235,2,13.523>, <7,2,12.1244>, <7,-2,12.1244> }
		triangle { <6,-2,10.3923>, <3.1058,-2,11.5911>, <3.6235,-2,13.523> }
		triangle { <3.6235,-2,13.523>, <7,-2,12.1244>, <6,-2,10.3923> }
		triangle { <6,2,10.3923>, <3.1058,2,11.5911>, <3.6235,2,13.523> }
		triangle { <3.6235,2,13.523>, <7,2,12.1244>, <6,2,10.3923> }
		triangle { <1.0353,0,3.8637>, <0,0,4>, <0,6,4> }
		triangle { <0,6,4>, <1.0353,6,3.8637>, <1.0353,0,3.8637> }
		triangle { <1.5529,0,5.7956>, <0,0,6>, <0,6,6> }
		triangle { <0,6,6>, <1.5529,6,5.7956>, <1.5529,0,5.7956> }
		triangle { <1.0353,0,3.8637>, <0,0,4>, <0,0,6> }
		triangle { <0,0,6>, <1.5529,0,5.7956>, <1.0353,0,3.8637> }
		triangle { <1.0353,6,3.8637>, <0,6,4>, <0,6,6> }
		triangle { <0,6,6>, <1.5529,6,5.7956>, <1.0353,6,3.8637> }
		triangle { <3.1058,-2,11.5911>, <0,-2,12>, <0,2,12> }
		triangle { <0,2,12>, <3.1058,2,11.5911>, <3.1058,-2,11.5911> }
		triangle { <3.6235,-2,13.523>, <0,-2,14>, <0,2,14> }
		triangle { <0,2,14>, <3.6235,2,13.523>, <3.6235,-2,13.523> }
		triangle { <3.1058,-2,11.5911>, <0,-2,12>, <0,-2,14> }
		triangle { <0,-2,14>, <3.6235,-2,13.523>, <3.1058,-2,11.5911> }
		triangle { <3.1058,2,11.5911>, <0,2,12>, <0,2,14> }
		triangle { <0,2,14>, <3.6235,2,13.523>, <3.1058,2,11.5911> }
		triangle { <0,0,4>, <-1.0353,0,3.8637>, <-1.0353,6,3.8637> }
		triangle { <-1.0353,6,3.8637>, <0,6,4>, <0,0,4> }
		triangle { <0,0,6>, <-1.5529,0,5.7956>, <-1.5529,6,5.7956> }
		triangle { <-1.5529,6,5.7956>, <0,6,6>, <0,0,6> }
		triangle { <0,0,4>, <-1.0353,0,3.8637>, <-1.5529,0,5.7956> }
		triangle { <-1.5529,0,5.7956>, <0,0,6>, <0,0,4> }
		triangle { <0,6,4>, <-1.0353,6,3.8637>, <-1.5529,6,5.7956> }
		triangle { <-1.5529,6,5.7956>, <0,6,6>, <0,6,4> }
		triangle { <0,-2,12>, <-3.1058,-2,11.5911>, <-3.1058,2,11.5911> }
		triangle { <-3.1058,2,11.5911>, <0,2,12>, <0,-2,12> }
		triangle { <0,-2,14>, <-3.6235,-2,13.523>, <-3.6235,2,13.523> }
		triangle { <-3.6235,2,13.523>, <0,2,14>, <0,-2,14> }
		triangle { <0,-2,12>, <-3.1058,-2,11.5911>, <-3.6235,-2,13.523> }
		triangle { <-3.6235,-2,13.523>, <0,-2,14>, <0,-2,12> }
		triangle { <0,2,12>, <-3.1058,2,11.5911>, <-3.6235,2,13.523> }
		triangle { <-3.6235,2,13.523>, <0,2,14>, <0,2,12> }
		triangle { <-1.0353,0,3.8637>, <-2,0,3.4641>, <-2,6,3.4641> }
		triangle { <-2,6,3.4641>, <-1.0353,6,3.8637>, <-1.0353,0,3.8637> }
		triangle { <-1.5529,0,5.7956>, <-3,0,5.1962>, <-3,6,5.1962> }
		triangle { <-3,6,5.1962>, <-1.5529,6,5.7956>, <-1.5529,0,5.7956> }
		triangle { <-1.0353,0,3.8637>, <-2,0,3.4641>, <-3,0,5.1962> }
		triangle { <-3,0,5.1962>, <-1.5529,0,5.7956>, <-1.0353,0,3.8637> }
		triangle { <-1.0353,6,3.8637>, <-2,6,3.4641>, <-3,6,5.1962> }
		triangle { <-3,6,5.1962>, <-1.5529,6,5.7956>, <-1.0353,6,3.8637> }
		triangle { <-3.1058,-2,11.5911>, <-6,-2,10.3923>, <-6,2,10.3923> }
		triangle { <-6,2,10.3923>, <-3.1058,2,11.5911>, <-3.1058,-2,11.5911> }
		triangle { <-3.6235,-2,13.523>, <-7,-2,12.1244>, <-7,2,12.1244> }
		triangle { <-7,2,12.1244>, <-3.6235,2,13.523>, <-3.6235,-2,13.523> }
		triangle { <-3.1058,-2,11.5911>, <-6,-2,10.3923>, <-7,-2,12.1244> }
		triangle { <-7,-2,12.1244>, <-3.6235,-2,13.523>, <-3.1058,-2,11.5911> }
		triangle { <-3.1058,2,11.5911>, <-6,2,10.3923>, <-7,2,12.1244> }
		triangle { <-7,2,12.1244>, <-3.6235,2,13.523>, <-3.1058,2,11.5911> }
		triangle { <-2,0,3.4641>, <-2.8284,0,2.8284>, <-2.8284,6,2.8284> }
		triangle { <-2.8284,6,2.8284>, <-2,6,3.4641>, <-2,0,3.4641> }
		triangle { <-3,0,5.1962>, <-4.2426,0,4.2426>, <-4.2426,6,4.2426> }
		triangle { <-4.2426,6,4.2426>, <-3,6,5.1962>, <-3,0,5.1962> }
		triangle { <-2,0,3.4641>, <-2.8284,0,2.8284>, <-4.2426,0,4.2426> }
		triangle { <-4.2426,0,4.2426>, <-3,0,5.1962>, <-2,0,3.4641> }
		triangle { <-2,6,3.4641>, <-2.8284,6,2.8284>, <-4.2426,6,4.2426> }
		triangle { <-4.2426,6,4.2426>, <-3,6,5.1962>, <-2,6,3.4641> }
		triangle { <-6,-2,10.3923>, <-8.4853,-2,8.4853>, <-8.4853,2,8.4853> }
		triangle { <-8.4853,2,8.4853>, <-6,2,10.3923>, <-6,-2,10.3923> }
		triangle { <-7,-2,12.1244>, <-9.8995,-2,9.8995>, <-9.8995,2,9.8995> }
		triangle { <-9.8995,2,9.8995>, <-7,2,12.1244>, <-7,-2,12.1244> }
		triangle { <-6,-2,10.3923>, <-8.4853,-2,8.4853>, <-9.8995,-2,9.8995> }
		triangle { <-9.8995,-2,9.8995>, <-7,-2,12.1244>, <-6,-2,10.3923> }
		triangle { <-6,2,10.3923>, <-8.4853,2,8.4853>, <-9.8995,2,9.8995> }
		triangle { <-9.8995,2,9.8995>, <-7,2,12.1244>, <-6,2,10.3923> }
		triangle { <-2.8284,0,2.8284>, <-3.4641,0,2>, <-3.4641,6,2> }
		triangle { <-3.4641,6,2>, <-2.8284,6,2.8284>, <-2.8284,0,2.8284> }
		triangle { <-4.2426,0,4.2426>, <-5.1962,0,3>, <-5.1962,6,3> }
		triangle { <-5.1962,6,3>, <-4.2426,6,4.2426>, <-4.2426,0,4.2426> }
		triangle { <-2.8284,0,2.8284>, <-3.4641,0,2>, <-5.1962,0,3> }
		triangle { <-5.1962,0,3>, <-4.2426,0,4.2426>, <-2.8284,0,2.8284> }
		triangle { <-2.8284,6,2.8284>, <-3.4641,6,2>, <-5.1962,6,3> }
		triangle { <-5.1962,6,3>, <-4.2426,6,4.2426>, <-2.8284,6,2.8284> }
		triangle { <-8.4853,-2,8.4853>, <-10.3923,-2,6>, <-10.3923,2,6> }
		triangle { <-10.3923,2,6>, <-8.4853,2,8.4853>, <-8.4853,-2,8.4853> }
		triangle { <-9.8995,-2,9.8995>, <-12.1244,-2,7>, <-12.1244,2,7> }
		triangle { <-12.1244,2,7>, <-9.8995,2,9.8995>, <-9.8995,-2,9.8995> }
		triangle { <-8.4853,-2,8.4853>, <-10.3923,-2,6>, <-12.1244,-2,7> }
		triangle { <-12.1244,-2,7>, <-9.8995,-2,9.8995>, <-8.4853,-2,8.4853> }
		triangle { <-8.4853,2,8.4853>, <-10.3923,2,6>, <-12.1244,2,7> }
		triangle { <-12.1244,2,7>, <-9.8995,2,9.8995>, <-8.4853,2,8.4853> }
		triangle { <-3.4641,0,2>, <-3.8637,0,1.0353>, <-3.8637,6,1.0353> }
		triangle { <-3.8637,6,1.0353>, <-3.4641,6,2>, <-3.4641,0,2> }
		triangle { <-5.1962,0,3>, <-5.7956,0,1.5529>, <-5.7956,6,1.5529> }
		triangle { <-5.7956,6,1.5529>, <-5.1962,6,3>, <-5.1962,0,3> }
		triangle { <-3.4641,0,2>, <-3.8637,0,1.0353>, <-5.7956,0,1.5529> }
		triangle { <-5.7956,0,1.5529>, <-5.1962,0,3>, <-3.4641,0,2> }
		triangle { <-3.4641,6,2>, <-3.8637,6,1.0353>, <-5.7956,6,1.5529> }
		triangle { <-5.7956,6,1.5529>, <-5.1962,6,3>, <-3.4641,6,2> }
		triangle { <-10.3923,-2,6>, <-11.5911,-2,3.1058>, <-11.5911,2,3.1058> }
		triangle { <-11.5911,2,3.1058>, <-10.3923,2,6>, <-10.3923,-2,6> }
		triangle { <-12.1244,-2,7>, <-13.523,-2,3.6235>, <-13.523,2,3.6235> }
		triangle { <-13.523,2,3.6235>, <-12.1244,2,7>, <-12.1244,-2,7> }
		triangle { <-10.3923,-2,6>, <-11.5911,-2,3.1058>, <-13.523,-2,3.6235> }
		triangle { <-13.523,-2,3.6235>, <-12.1244,-2,7>, <-10.3923,-2,6> }
		triangle { <-10.3923,2,6>, <-11.5911,2,3.1058>, <-13.523,2,3.6235> }
		triangle { <-13.523,2,3.6235>, <-12.1244,2,7>, <-10.3923,2,6> }
		triangle { <-3.8637,0,1.0353>, <-4,0,0>, <-4,6,0> }
		triangle { <-4,6,0>, <-3.8637,6,1.0353>, <-3.8637,0,1.0353> }
		triangle { <-5.7956,0,1.5529>, <-6,0,0>, <-6,6,0> }
		triangle { <-6,6,0>, <-5.7956,6,1.5529>, <-5.7956,0,1.5529> }
		triangle { <-3.8637,0,1.0353>, <-4,0,0>, <-6,0,0> }
		triangle { <-6,0,0>, <-5.7956,0,1.5529>, <-3.8637,0,1.0353> }
		triangle { <-3.8637,6,1.0353>, <-4,6,0>, <-6,6,0> }
		triangle { <-6,6,0>, <-5.7956,6,1.5529>, <-3.8637,6,1.0353> }
		triangle { <-11.5911,-2,3.1058>, <-12,-2,0>, <-12,2,0> }
		triangle { <-12,2,0>, <-11.5911,2,3.1058>, <-11.5911,-2,3.1058> }
		triangle { <-13.523,-2,3.6235>, <-14,-2,0>, <-14,2,0> }
		triangle { <-14,2,0>, <-13.523,2,3.6235>, <-13.523,-2,3.6235> }
		triangle { <-11.5911,-2,3.1058>, <-12,-2,0>, <-14,-2,0> }
		triangle { <-14,-2,0>, <-13.523,-2,3.6235>, <-11.5911,-2,3.1058> }
		triangle { <-11.5911,2,3.1058>, <-12,2,0>, <-14,2,0> }
		triangle { <-14,2,0>, <-13.523,2,3.6235>, <-11.5911,2,3.1058> }
	}
}
#end

#declare _3829_dot_dat = #if (QUAL = 0) box { <-20,-38.72,-13.44>, <20,8,10> } #else union {
// Car Steering Wheel
	object { _3829a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { _3829b_dot_dat matrix <0,-0.8,-0.6,0,0.6,-0.8,1,0,0,0,-26.32,-0.24> #if (ver >= 3.1) material #else texture #end { Color0 } }
}
#end

#declare _4070_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else union {
// Brick  1 x  1 with Headlight
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-6> }
		triangle { <-6,24,-6>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,-10>, <-6,24,-6>, <6,24,-6> }
		triangle { <6,24,-6>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <6,24,-6>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-10> }
	}
	object { rect_dot_dat matrix <10,0,0,0,1,0,0,0,2,0,20,-8> }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,2,0,20,-4> }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,2,0,16,8> }
	object { rect_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,4> }
	object { rect_dot_dat matrix <10,0,0,0,1,0,0,0,8,0,0,2> }
	object { _4_dash_4ndis_dot_dat matrix <4,0,0,0,0,1,0,4,0,0,10,-2> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,-4,0,4,0,0,10,-2> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,0,1,0,6,0,0,10,-6> }
	mesh {
		triangle { <10,24,10>, <6,16,10>, <-6,16,10> }
		triangle { <-6,16,10>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,16,10>, <-6,4,10> }
		triangle { <-6,4,10>, <-10,0,10>, <-10,24,10> }
		triangle { <-10,0,10>, <-6,4,10>, <6,4,10> }
		triangle { <6,4,10>, <10,0,10>, <-10,0,10> }
		triangle { <10,0,10>, <6,4,10>, <6,16,10> }
		triangle { <6,16,10>, <10,24,10>, <10,0,10> }
		triangle { <6,24,6>, <6,16,6>, <-6,16,6> }
		triangle { <-6,16,6>, <-6,24,6>, <6,24,6> }
		triangle { <6,20,-2>, <4,14,-2>, <-4,14,-2> }
		triangle { <-4,14,-2>, <-6,20,-2>, <6,20,-2> }
		triangle { <-6,20,-2>, <-4,14,-2>, <-4,6,-2> }
		triangle { <-4,6,-2>, <-6,4,-2>, <-6,20,-2> }
		triangle { <-6,4,-2>, <-4,6,-2>, <4,6,-2> }
		triangle { <4,6,-2>, <6,4,-2>, <-6,4,-2> }
		triangle { <6,4,-2>, <4,6,-2>, <4,14,-2> }
		triangle { <4,14,-2>, <6,20,-2>, <6,4,-2> }
		triangle { <10,20,-6>, <6,16,-6>, <-6,16,-6> }
		triangle { <-6,16,-6>, <-10,20,-6>, <10,20,-6> }
		triangle { <-10,20,-6>, <-6,16,-6>, <-6,4,-6> }
		triangle { <-6,4,-6>, <-10,0,-6>, <-10,20,-6> }
		triangle { <-10,0,-6>, <-6,4,-6>, <6,4,-6> }
		triangle { <6,4,-6>, <10,0,-6>, <-10,0,-6> }
		triangle { <10,0,-6>, <6,4,-6>, <6,16,-6> }
		triangle { <6,16,-6>, <10,20,-6>, <10,0,-6> }
		triangle { <6,24,-6>, <6,20,-6>, <-6,20,-6> }
		triangle { <-6,20,-6>, <-6,24,-6>, <6,24,-6> }
		triangle { <10,24,-10>, <10,20,-10>, <-10,20,-10> }
		triangle { <-10,20,-10>, <-10,24,-10>, <10,24,-10> }
		triangle { <10,24,10>, <10,20,-6>, <10,20,-10> }
		triangle { <10,20,-10>, <10,24,-10>, <10,24,10> }
		triangle { <10,24,10>, <10,0,10>, <10,0,-6> }
		triangle { <10,0,-6>, <10,20,-6>, <10,24,10> }
		triangle { <6,24,6>, <6,20,6>, <6,20,-6> }
		triangle { <6,20,-6>, <6,24,-6>, <6,24,6> }
		triangle { <6,20,10>, <6,4,10>, <6,4,-2> }
		triangle { <6,4,-2>, <6,20,-2>, <6,20,10> }
		triangle { <-6,24,6>, <-6,20,6>, <-6,20,-6> }
		triangle { <-6,20,-6>, <-6,24,-6>, <-6,24,6> }
		triangle { <-6,20,10>, <-6,4,10>, <-6,4,-2> }
		triangle { <-6,4,-2>, <-6,20,-2>, <-6,20,10> }
		triangle { <-10,24,10>, <-10,20,-6>, <-10,20,-10> }
		triangle { <-10,20,-10>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,10>, <-10,0,10>, <-10,0,-6> }
		triangle { <-10,0,-6>, <-10,20,-6>, <-10,24,10> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,0,1,0,1,0,0,10,-6> }
	#end
}
#end

#declare _3070_dot_dat = #if (QUAL = 0) box { <-10,0,-10>, <10,8,10> } #else union {
// Tile  1 x  1
	object { box5_dot_dat matrix <6,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <10,8,10>, <6,8,6>, <-6,8,6> }
		triangle { <-6,8,6>, <-10,8,10>, <10,8,10> }
		triangle { <-10,8,10>, <-6,8,6>, <-6,8,-6> }
		triangle { <-6,8,-6>, <-10,8,-10>, <-10,8,10> }
		triangle { <-10,8,-10>, <-6,8,-6>, <6,8,-6> }
		triangle { <6,8,-6>, <10,8,-10>, <-10,8,-10> }
		triangle { <10,8,-10>, <6,8,-6>, <6,8,6> }
		triangle { <6,8,6>, <10,8,10>, <10,8,-10> }
	}
	object { box5_dot_dat matrix <10,0,0,0,-8,0,0,0,10,0,8,0> }
}
#end

#declare _2_dash_4ndis_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 2, 1
		clipped_by { box { <-1,-1,0>, <1,1,1> } }
	}
#else
	difference {
		box { <-1,-0.001,0>, <1,0.001,1> }
		cylinder { <0,-1,0>, <0,1,0>, 1 }
	}
#end

#declare _2555_dot_dat = #if (QUAL = 0) box { <-10,-10,-10>, <10,8,10> } #else union {
// Tile  1 x  1 with Clip
	object { _3070_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { _2_dash_4ndis_dot_dat matrix <4,0,0,0,0,1,0,4,0,0,-6,4> }
	object { _2_dash_4ndis_dot_dat matrix <4,0,0,0,0,1,0,4,0,0,-6,-4> }
	object { _2_dash_4cyli_dot_dat matrix <4,0,0,0,0,-8,0,4,0,0,-6,4> }
	mesh {
		triangle { <10,0,4>, <4,-2,4>, <-4,-2,4> }
		triangle { <-4,-2,4>, <-10,0,4>, <10,0,4> }
		triangle { <10,0,-4>, <4,-2,-4>, <-4,-2,-4> }
		triangle { <-4,-2,-4>, <-10,0,-4>, <10,0,-4> }
		triangle { <10,0,4>, <8,-10,4>, <4,-10,4> }
		triangle { <4,-10,4>, <4,-2,4>, <10,0,4> }
		triangle { <10,0,-4>, <8,-10,-4>, <4,-10,-4> }
		triangle { <4,-10,-4>, <4,-2,-4>, <10,0,-4> }
		triangle { <-10,0,4>, <-8,-10,4>, <-4,-10,4> }
		triangle { <-4,-10,4>, <-4,-2,4>, <-10,0,4> }
		triangle { <-10,0,-4>, <-8,-10,-4>, <-4,-10,-4> }
		triangle { <-4,-10,-4>, <-4,-2,-4>, <-10,0,-4> }
		triangle { <4,-6,4>, <4,-10,4>, <4,-10,-4> }
		triangle { <4,-10,-4>, <4,-6,-4>, <4,-6,4> }
		triangle { <-4,-6,4>, <-4,-10,4>, <-4,-10,-4> }
		triangle { <-4,-10,-4>, <-4,-6,-4>, <-4,-6,4> }
		triangle { <4,-10,4>, <8,-10,4>, <8,-10,-4> }
		triangle { <8,-10,-4>, <4,-10,-4>, <4,-10,4> }
		triangle { <-4,-10,4>, <-8,-10,4>, <-8,-10,-4> }
		triangle { <-8,-10,-4>, <-4,-10,-4>, <-4,-10,4> }
		triangle { <8,-10,4>, <10,0,4>, <10,0,-4> }
		triangle { <10,0,-4>, <8,-10,-4>, <8,-10,4> }
		triangle { <-8,-10,4>, <-10,0,4>, <-10,0,-4> }
		triangle { <-10,0,-4>, <-8,-10,-4>, <-8,-10,4> }
	}
}
#end

#declare _8_dash_8sphe_dot_dat = sphere { <0,0,0>, 1 }

#declare _2569_dot_dat = #if (QUAL = 0) box { <-8,-184,-8>, <8,8,8> } #else union {
// Antenna Whip 8H
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { _8_dash_8sphe_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,-180,0> }
	object { _4_dash_4cyli_dot_dat matrix <2,0,0,0,156,0,0,0,2,0,-180,0> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,0,-24,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,24,0,0,0,4,0,-24,0> }
	object { _4_dash_4disc_dot_dat matrix <8,0,0,0,1,0,0,0,8,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,4,0,0,0,8,0,0,0> }
	object { _4_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,0> }
}
#end

#declare _30136_dot_dat = #if (QUAL = 0) box { <-20.001,-4,-14.142>, <20.001,24,14.142> } #else union {
// Brick  1 x  2 Log
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
	object { rect_dot_dat matrix <0,12,0,1,0,0,0,0,7.071,20,12,0> }
	object { rect_dot_dat matrix <0,12,0,1,0,0,0,0,7.071,-20,12,0> }
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,7.071,0,24,0,-10.001,0,7.071,-10,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,-7.071,0,24,0,-10.001,0,-7.071,-10,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,7.071,0,24,0,-10.001,0,7.071,10,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,-7.071,0,24,0,-10.001,0,-7.071,10,0,0> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,10,0,0> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,-10,0,0> }
	mesh {
		triangle { <-4,0,6>, <0,0,7.071>, <-4.587,0,9.239> }
		triangle { <-4.587,0,9.239>, <-10,0,10>, <-4,0,6> }
		triangle { <-4,0,6>, <-16,0,6>, <-10,0,10> }
		triangle { <-16,0,6>, <-10,0,10>, <-15.413,0,9.239> }
		triangle { <-15.413,0,9.239>, <-20,0,7.071>, <-16,0,6> }
		triangle { <-4,24,6>, <0,24,7.071>, <-4.587,24,9.239> }
		triangle { <-4.587,24,9.239>, <-10,24,10>, <-4,24,6> }
		triangle { <-4,24,6>, <-16,24,6>, <-10,24,10> }
		triangle { <-16,24,6>, <-10,24,10>, <-15.413,24,9.239> }
		triangle { <-15.413,24,9.239>, <-20,24,7.071>, <-16,24,6> }
		triangle { <-4,0,-6>, <0,0,-7.071>, <-4.587,0,-9.239> }
		triangle { <-4.587,0,-9.239>, <-10,0,-10>, <-4,0,-6> }
		triangle { <-4,0,-6>, <-16,0,-6>, <-10,0,-10> }
		triangle { <-16,0,-6>, <-10,0,-10>, <-15.413,0,-9.239> }
		triangle { <-15.413,0,-9.239>, <-20,0,-7.071>, <-16,0,-6> }
		triangle { <-4,24,-6>, <0,24,-7.071>, <-4.587,24,-9.239> }
		triangle { <-4.587,24,-9.239>, <-10,24,-10>, <-4,24,-6> }
		triangle { <-4,24,-6>, <-16,24,-6>, <-10,24,-10> }
		triangle { <-16,24,-6>, <-10,24,-10>, <-15.413,24,-9.239> }
		triangle { <-15.413,24,-9.239>, <-20,24,-7.071>, <-16,24,-6> }
		triangle { <16,0,6>, <20,0,7.071>, <15.413,0,9.239> }
		triangle { <15.413,0,9.239>, <10,0,10>, <16,0,6> }
		triangle { <16,0,6>, <4,0,6>, <10,0,10> }
		triangle { <4,0,6>, <10,0,10>, <4.587,0,9.239> }
		triangle { <4.587,0,9.239>, <0,0,7.071>, <4,0,6> }
		triangle { <16,24,6>, <20,24,7.071>, <15.413,24,9.239> }
		triangle { <15.413,24,9.239>, <10,24,10>, <16,24,6> }
		triangle { <16,24,6>, <4,24,6>, <10,24,10> }
		triangle { <4,24,6>, <10,24,10>, <4.587,24,9.239> }
		triangle { <4.587,24,9.239>, <0,24,7.071>, <4,24,6> }
		triangle { <16,0,-6>, <20,0,-7.071>, <15.413,0,-9.239> }
		triangle { <15.413,0,-9.239>, <10,0,-10>, <16,0,-6> }
		triangle { <16,0,-6>, <4,0,-6>, <10,0,-10> }
		triangle { <4,0,-6>, <10,0,-10>, <4.587,0,-9.239> }
		triangle { <4.587,0,-9.239>, <0,0,-7.071>, <4,0,-6> }
		triangle { <16,24,-6>, <20,24,-7.071>, <15.413,24,-9.239> }
		triangle { <15.413,24,-9.239>, <10,24,-10>, <16,24,-6> }
		triangle { <16,24,-6>, <4,24,-6>, <10,24,-10> }
		triangle { <4,24,-6>, <10,24,-10>, <4.587,24,-9.239> }
		triangle { <4.587,24,-9.239>, <0,24,-7.071>, <4,24,-6> }
		triangle { <20,0,7.071>, <20,0,-7.071>, <16,0,-6> }
		triangle { <16,0,-6>, <16,0,6>, <20,0,7.071> }
		triangle { <20,24,7.071>, <20,24,-7.071>, <16,24,-6> }
		triangle { <16,24,-6>, <16,24,6>, <20,24,7.071> }
		triangle { <-20,0,7.071>, <-20,0,-7.071>, <-16,0,-6> }
		triangle { <-16,0,-6>, <-16,0,6>, <-20,0,7.071> }
		triangle { <-20,24,7.071>, <-20,24,-7.071>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-16,24,6>, <-20,24,7.071> }
		triangle { <0,0,7.071>, <0,0,-7.071>, <4,0,-6> }
		triangle { <4,0,-6>, <4,0,6>, <0,0,7.071> }
		triangle { <0,0,7.071>, <0,0,-7.071>, <-4,0,-6> }
		triangle { <-4,0,-6>, <-4,0,6>, <0,0,7.071> }
		triangle { <0,24,7.071>, <6,24,6>, <-6,24,6> }
		triangle { <0,24,-7.071>, <6,24,-6>, <-6,24,-6> }
		triangle { <-3.5,23,-6>, <0,23,-2.5>, <0,4,-2.5> }
		triangle { <0,4,-2.5>, <-3.5,4,-6>, <-3.5,23,-6> }
		triangle { <3.5,23,-6>, <0,23,-2.5>, <0,4,-2.5> }
		triangle { <0,4,-2.5>, <3.5,4,-6>, <3.5,23,-6> }
		triangle { <-3.5,23,-6>, <3.5,23,-6>, <0,23,-2.5> }
		triangle { <-3.5,4,-6>, <-5,4,-4>, <-5,23,-4> }
		triangle { <-5,23,-4>, <-3.5,23,-6>, <-3.5,4,-6> }
		triangle { <-5,4,-4>, <-6.5,4,-6>, <-6.5,23,-6> }
		triangle { <-6.5,23,-6>, <-5,23,-4>, <-5,4,-4> }
		triangle { <-6.5,23,-6>, <-3.5,23,-6>, <-5,23,-4> }
		triangle { <3.5,4,-6>, <5,4,-4>, <5,23,-4> }
		triangle { <5,23,-4>, <3.5,23,-6>, <3.5,4,-6> }
		triangle { <5,4,-4>, <6.5,4,-6>, <6.5,23,-6> }
		triangle { <6.5,23,-6>, <5,23,-4>, <5,4,-4> }
		triangle { <6.5,23,-6>, <3.5,23,-6>, <5,23,-4> }
		triangle { <-3.5,23,6>, <0,23,2.5>, <0,4,2.5> }
		triangle { <0,4,2.5>, <-3.5,4,6>, <-3.5,23,6> }
		triangle { <3.5,23,6>, <0,23,2.5>, <0,4,2.5> }
		triangle { <0,4,2.5>, <3.5,4,6>, <3.5,23,6> }
		triangle { <-3.5,23,6>, <3.5,23,6>, <0,23,2.5> }
		triangle { <-3.5,4,6>, <-5,4,4>, <-5,23,4> }
		triangle { <-5,23,4>, <-3.5,23,6>, <-3.5,4,6> }
		triangle { <-5,4,4>, <-6.5,4,6>, <-6.5,23,6> }
		triangle { <-6.5,23,6>, <-5,23,4>, <-5,4,4> }
		triangle { <-6.5,23,6>, <-3.5,23,6>, <-5,23,4> }
		triangle { <3.5,4,6>, <5,4,4>, <5,23,4> }
		triangle { <5,23,4>, <3.5,23,6>, <3.5,4,6> }
		triangle { <5,4,4>, <6.5,4,6>, <6.5,23,6> }
		triangle { <6.5,23,6>, <5,23,4>, <5,4,4> }
		triangle { <6.5,23,6>, <3.5,23,6>, <5,23,4> }
	}
}
#end

#declare _3684_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,72,10> } #else union {
// Slope Brick 75  2 x  2 x  3
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,36,0,0,0,6,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,29,0,0,21,-6,0,11,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,36,0,0,0,8,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,29,0,0,28,-8,0,11,-10> }
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-8,0,0,0,1,0,40,-10> }
	#end
	mesh {
		triangle { <20,72,10>, <16,72,6>, <-16,72,6> }
		triangle { <-16,72,6>, <-20,72,10>, <20,72,10> }
		triangle { <-20,72,10>, <-16,72,6>, <-16,72,-26> }
		triangle { <-16,72,-26>, <-20,72,-30>, <-20,72,10> }
		triangle { <-20,72,-30>, <-16,72,-26>, <16,72,-26> }
		triangle { <16,72,-26>, <20,72,-30>, <-20,72,-30> }
		triangle { <20,72,-30>, <16,72,-26>, <16,72,6> }
		triangle { <16,72,6>, <20,72,10>, <20,72,-30> }
		triangle { <16,4,6>, <-16,4,6>, <-16,72,6> }
		triangle { <-16,72,6>, <16,72,6>, <16,4,6> }
		triangle { <-16,4,6>, <-16,4,-8>, <-16,72,-8> }
		triangle { <-16,72,-8>, <-16,72,6>, <-16,4,6> }
		triangle { <-16,4,-8>, <-16,67,-26>, <-16,72,-26> }
		triangle { <-16,72,-26>, <-16,72,-8>, <-16,4,-8> }
		triangle { <-16,67,-26>, <16,67,-26>, <16,72,-26> }
		triangle { <16,72,-26>, <-16,72,-26>, <-16,67,-26> }
		triangle { <16,67,-26>, <16,4,-8>, <16,72,-8> }
		triangle { <16,72,-8>, <16,72,-26>, <16,67,-26> }
		triangle { <16,4,-8>, <16,4,6>, <16,72,6> }
		triangle { <16,72,6>, <16,72,-8>, <16,4,-8> }
		triangle { <16,67,-26>, <16,4,-8>, <-16,4,-8> }
		triangle { <-16,4,-8>, <-16,67,-26>, <16,67,-26> }
		triangle { <16,4,6>, <16,4,-8>, <-16,4,-8> }
		triangle { <-16,4,-8>, <-16,4,6>, <16,4,6> }
		triangle { <20,72,-30>, <20,0,-10>, <20,0,10> }
		triangle { <20,0,10>, <20,72,10>, <20,72,-30> }
		triangle { <20,72,-30>, <20,68,-30>, <-20,68,-30> }
		triangle { <-20,68,-30>, <-20,72,-30>, <20,72,-30> }
		triangle { <20,72,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,72,10>, <20,72,10> }
		triangle { <-20,72,-30>, <-20,0,-10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,72,10>, <-20,72,-30> }
		triangle { <20,72,-30>, <20,68,-30>, <20,0,-10> }
		triangle { <-20,72,-30>, <-20,68,-30>, <-20,0,-10> }
		triangle { <20,0,-10>, <20,68,-30>, <-20,68,-30> }
		triangle { <-20,68,-30>, <-20,0,-10>, <20,0,-10> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
}
#end

#declare _3069_dot_dat = #if (QUAL = 0) box { <-20,0,-10>, <20,8,10> } #else union {
// Tile  1 x  2
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <-20,8,10>, <-16,8,6>, <-16,8,-6> }
		triangle { <-16,8,-6>, <-20,8,-10>, <-20,8,10> }
		triangle { <-20,8,-10>, <-16,8,-6>, <16,8,-6> }
		triangle { <16,8,-6>, <20,8,-10>, <-20,8,-10> }
		triangle { <20,8,-10>, <16,8,-6>, <16,8,6> }
		triangle { <16,8,6>, <20,8,10>, <20,8,-10> }
	}
	object { box5_dot_dat matrix <20,0,0,0,-8,0,0,0,10,0,8,0> }
}
#end

#declare _6636_dot_dat = #if (QUAL = 0) box { <-60,0,-10>, <60,8,10> } #else union {
// Tile  1 x  6
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
	#end
	object { box5_dot_dat matrix <56,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <60,8,10>, <56,8,6>, <-56,8,6> }
		triangle { <-56,8,6>, <-60,8,10>, <60,8,10> }
		triangle { <-60,8,10>, <-56,8,6>, <-56,8,-6> }
		triangle { <-56,8,-6>, <-60,8,-10>, <-60,8,10> }
		triangle { <-60,8,-10>, <-56,8,-6>, <56,8,-6> }
		triangle { <56,8,-6>, <60,8,-10>, <-60,8,-10> }
		triangle { <60,8,-10>, <56,8,-6>, <56,8,6> }
		triangle { <56,8,6>, <60,8,10>, <60,8,-10> }
	}
	object { box5_dot_dat matrix <60,0,0,0,-8,0,0,0,10,0,8,0> }
}
#end

#declare _2431_dot_dat = #if (QUAL = 0) box { <-40,0,-10>, <40,8,10> } #else union {
// Tile  1 x  4
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <40,8,10>, <36,8,6>, <-36,8,6> }
		triangle { <-36,8,6>, <-40,8,10>, <40,8,10> }
		triangle { <-40,8,10>, <-36,8,6>, <-36,8,-6> }
		triangle { <-36,8,-6>, <-40,8,-10>, <-40,8,10> }
		triangle { <-40,8,-10>, <-36,8,-6>, <36,8,-6> }
		triangle { <36,8,-6>, <40,8,-10>, <-40,8,-10> }
		triangle { <40,8,-10>, <36,8,-6>, <36,8,6> }
		triangle { <36,8,6>, <40,8,10>, <40,8,-10> }
	}
	object { box5_dot_dat matrix <40,0,0,0,-8,0,0,0,10,0,8,0> }
}
#end

#declare _3666_dot_dat = #if (QUAL = 0) box { <-60,-4,-10>, <60,8,10> } #else union {
// Plate  1 x  6
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
	#end
	object { box5_dot_dat matrix <56,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <60,8,10>, <56,8,6>, <-56,8,6> }
		triangle { <-56,8,6>, <-60,8,10>, <60,8,10> }
		triangle { <-60,8,10>, <-56,8,6>, <-56,8,-6> }
		triangle { <-56,8,-6>, <-60,8,-10>, <-60,8,10> }
		triangle { <-60,8,-10>, <-56,8,-6>, <56,8,-6> }
		triangle { <56,8,-6>, <60,8,-10>, <-60,8,-10> }
		triangle { <60,8,-10>, <56,8,-6>, <56,8,6> }
		triangle { <56,8,6>, <60,8,10>, <60,8,-10> }
	}
	object { box5_dot_dat matrix <60,0,0,0,-8,0,0,0,10,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
	#end
}
#end

#declare _4175_dot_dat = #if (QUAL = 0) box { <-20,-4,-18>, <20,48,10> } #else union {
// Plate  1 x  2 with Ladder
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,2,10,8,-8> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,2,-10,8,-8> }
	mesh {
		triangle { <20,8,10>, <20,8,-10>, <16,8,-10> }
		triangle { <16,8,-10>, <16,8,6>, <20,8,10> }
		triangle { <-20,8,10>, <-20,8,-10>, <-16,8,-10> }
		triangle { <-16,8,-10>, <-16,8,6>, <-20,8,10> }
		triangle { <20,8,10>, <16,8,6>, <-16,8,6> }
		triangle { <-16,8,6>, <-20,8,10>, <20,8,10> }
		triangle { <16,4,6>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,4,6>, <16,4,6> }
		triangle { <16,8,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,8,6>, <16,8,6> }
		triangle { <12,8,-6>, <12,4,-6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,8,-6>, <12,8,-6> }
		triangle { <-12,8,-6>, <-12,4,-6>, <-8,4,-6> }
		triangle { <-8,4,-6>, <-8,8,-6>, <-12,8,-6> }
		triangle { <16,8,6>, <16,4,6>, <16,4,-10> }
		triangle { <16,4,-10>, <16,8,-10>, <16,8,6> }
		triangle { <-16,8,6>, <-16,4,6>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,8,-10>, <-16,8,6> }
		triangle { <12,8,-6>, <12,4,-6>, <12,4,-10> }
		triangle { <12,4,-10>, <12,8,-10>, <12,8,-6> }
		triangle { <-12,8,-6>, <-12,4,-6>, <-12,4,-10> }
		triangle { <-12,4,-10>, <-12,8,-10>, <-12,8,-6> }
		triangle { <8,8,-6>, <8,4,-6>, <8,4,-10> }
		triangle { <8,4,-10>, <8,8,-10>, <8,8,-6> }
		triangle { <-8,8,-6>, <-8,4,-6>, <-8,4,-10> }
		triangle { <-8,4,-10>, <-8,8,-10>, <-8,8,-6> }
		triangle { <16,4,-12>, <16,4,-14>, <-16,4,-14> }
		triangle { <-16,4,-14>, <-16,4,-12>, <16,4,-12> }
		triangle { <16,12,-12>, <16,12,-14>, <-16,12,-14> }
		triangle { <-16,12,-14>, <-16,12,-12>, <16,12,-12> }
		triangle { <16,16,-10>, <16,16,-14>, <-16,16,-14> }
		triangle { <-16,16,-14>, <-16,16,-10>, <16,16,-10> }
		triangle { <16,24,-10>, <16,24,-14>, <-16,24,-14> }
		triangle { <-16,24,-14>, <-16,24,-10>, <16,24,-10> }
		triangle { <16,28,-10>, <16,28,-14>, <-16,28,-14> }
		triangle { <-16,28,-14>, <-16,28,-10>, <16,28,-10> }
		triangle { <16,36,-10>, <16,36,-14>, <-16,36,-14> }
		triangle { <-16,36,-14>, <-16,36,-10>, <16,36,-10> }
		triangle { <16,40,-10>, <16,40,-14>, <-16,40,-14> }
		triangle { <-16,40,-14>, <-16,40,-10>, <16,40,-10> }
		triangle { <20,4,-14>, <20,4,-18>, <-20,4,-18> }
		triangle { <-20,4,-18>, <-20,4,-14>, <20,4,-14> }
		triangle { <20,12,-14>, <20,12,-18>, <-20,12,-18> }
		triangle { <-20,12,-18>, <-20,12,-14>, <20,12,-14> }
		triangle { <20,16,-14>, <20,16,-18>, <-20,16,-18> }
		triangle { <-20,16,-18>, <-20,16,-14>, <20,16,-14> }
		triangle { <20,24,-14>, <20,24,-18>, <-20,24,-18> }
		triangle { <-20,24,-18>, <-20,24,-14>, <20,24,-14> }
		triangle { <20,28,-14>, <20,28,-18>, <-20,28,-18> }
		triangle { <-20,28,-18>, <-20,28,-14>, <20,28,-14> }
		triangle { <20,36,-14>, <20,36,-18>, <-20,36,-18> }
		triangle { <-20,36,-18>, <-20,36,-14>, <20,36,-14> }
		triangle { <20,40,-14>, <20,40,-18>, <-20,40,-18> }
		triangle { <-20,40,-18>, <-20,40,-14>, <20,40,-14> }
		triangle { <20,48,-10>, <20,48,-14>, <16,48,-14> }
		triangle { <16,48,-14>, <16,48,-10>, <20,48,-10> }
		triangle { <-20,48,-10>, <-20,48,-14>, <-16,48,-14> }
		triangle { <-16,48,-14>, <-16,48,-10>, <-20,48,-10> }
		triangle { <20,48,-10>, <20,48,-14>, <20,0,-14> }
		triangle { <20,0,-14>, <20,0,-10>, <20,48,-10> }
		triangle { <-20,48,-10>, <-20,48,-14>, <-20,0,-14> }
		triangle { <-20,0,-14>, <-20,0,-10>, <-20,48,-10> }
		triangle { <20,48,-10>, <16,48,-10>, <16,8,-10> }
		triangle { <16,8,-10>, <20,8,-10>, <20,48,-10> }
		triangle { <-20,48,-10>, <-16,48,-10>, <-16,8,-10> }
		triangle { <-16,8,-10>, <-20,8,-10>, <-20,48,-10> }
		triangle { <20,12,-14>, <16,12,-14>, <16,4,-14> }
		triangle { <16,4,-14>, <20,4,-14>, <20,12,-14> }
		triangle { <-20,12,-14>, <-16,12,-14>, <-16,4,-14> }
		triangle { <-16,4,-14>, <-20,4,-14>, <-20,12,-14> }
		triangle { <20,24,-14>, <16,24,-14>, <16,16,-14> }
		triangle { <16,16,-14>, <20,16,-14>, <20,24,-14> }
		triangle { <-20,24,-14>, <-16,24,-14>, <-16,16,-14> }
		triangle { <-16,16,-14>, <-20,16,-14>, <-20,24,-14> }
		triangle { <20,36,-14>, <16,36,-14>, <16,28,-14> }
		triangle { <16,28,-14>, <20,28,-14>, <20,36,-14> }
		triangle { <-20,36,-14>, <-16,36,-14>, <-16,28,-14> }
		triangle { <-16,28,-14>, <-20,28,-14>, <-20,36,-14> }
		triangle { <20,48,-14>, <16,48,-14>, <16,40,-14> }
		triangle { <16,40,-14>, <20,40,-14>, <20,48,-14> }
		triangle { <-20,48,-14>, <-16,48,-14>, <-16,40,-14> }
		triangle { <-16,40,-14>, <-20,40,-14>, <-20,48,-14> }
		triangle { <16,24,-10>, <16,24,-14>, <16,16,-14> }
		triangle { <16,16,-14>, <16,16,-10>, <16,24,-10> }
		triangle { <-16,24,-10>, <-16,24,-14>, <-16,16,-14> }
		triangle { <-16,16,-14>, <-16,16,-10>, <-16,24,-10> }
		triangle { <16,36,-10>, <16,36,-14>, <16,28,-14> }
		triangle { <16,28,-14>, <16,28,-10>, <16,36,-10> }
		triangle { <-16,36,-10>, <-16,36,-14>, <-16,28,-14> }
		triangle { <-16,28,-14>, <-16,28,-10>, <-16,36,-10> }
		triangle { <16,48,-10>, <16,48,-14>, <16,40,-14> }
		triangle { <16,40,-14>, <16,40,-10>, <16,48,-10> }
		triangle { <-16,48,-10>, <-16,48,-14>, <-16,40,-14> }
		triangle { <-16,40,-14>, <-16,40,-10>, <-16,48,-10> }
		triangle { <20,0,-14>, <20,0,-18>, <20,4,-18> }
		triangle { <20,4,-18>, <20,4,-14>, <20,0,-14> }
		triangle { <-20,0,-14>, <-20,0,-18>, <-20,4,-18> }
		triangle { <-20,4,-18>, <-20,4,-14>, <-20,0,-14> }
		triangle { <20,12,-14>, <20,12,-18>, <20,16,-18> }
		triangle { <20,16,-18>, <20,16,-14>, <20,12,-14> }
		triangle { <-20,12,-14>, <-20,12,-18>, <-20,16,-18> }
		triangle { <-20,16,-18>, <-20,16,-14>, <-20,12,-14> }
		triangle { <20,24,-14>, <20,24,-18>, <20,28,-18> }
		triangle { <20,28,-18>, <20,28,-14>, <20,24,-14> }
		triangle { <-20,24,-14>, <-20,24,-18>, <-20,28,-18> }
		triangle { <-20,28,-18>, <-20,28,-14>, <-20,24,-14> }
		triangle { <20,36,-14>, <20,36,-18>, <20,40,-18> }
		triangle { <20,40,-18>, <20,40,-14>, <20,36,-14> }
		triangle { <-20,36,-14>, <-20,36,-18>, <-20,40,-18> }
		triangle { <-20,40,-18>, <-20,40,-14>, <-20,36,-14> }
		triangle { <20,0,-18>, <-20,0,-18>, <-20,4,-18> }
		triangle { <-20,4,-18>, <20,4,-18>, <20,0,-18> }
		triangle { <20,12,-18>, <-20,12,-18>, <-20,16,-18> }
		triangle { <-20,16,-18>, <20,16,-18>, <20,12,-18> }
		triangle { <20,24,-18>, <-20,24,-18>, <-20,28,-18> }
		triangle { <-20,28,-18>, <20,28,-18>, <20,24,-18> }
		triangle { <20,36,-18>, <-20,36,-18>, <-20,40,-18> }
		triangle { <-20,40,-18>, <20,40,-18>, <20,36,-18> }
		triangle { <16,4,-10>, <-16,4,-10>, <-16,16,-10> }
		triangle { <-16,16,-10>, <16,16,-10>, <16,4,-10> }
		triangle { <16,24,-10>, <-16,24,-10>, <-16,28,-10> }
		triangle { <-16,28,-10>, <16,28,-10>, <16,24,-10> }
		triangle { <16,36,-10>, <-16,36,-10>, <-16,40,-10> }
		triangle { <-16,40,-10>, <16,40,-10>, <16,36,-10> }
		triangle { <16,4,-12>, <16,12,-12>, <-16,12,-12> }
		triangle { <-16,12,-12>, <-16,4,-12>, <16,4,-12> }
		triangle { <20,8,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <20,8,10> }
		triangle { <20,0,10>, <20,0,-18>, <-20,0,-18> }
		triangle { <-20,0,-18>, <-20,0,10>, <20,0,10> }
		triangle { <20,0,10>, <20,8,10>, <20,8,-10> }
		triangle { <20,8,-10>, <20,0,-10>, <20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <-20,8,-10> }
		triangle { <-20,8,-10>, <-20,0,-10>, <-20,0,10> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
}
#end

#declare box_dot_dat = box { <-1,-1,-1>, <1,1,1> }

#declare _30137_dot_dat = #if (QUAL = 0) box { <-40.001,-4,-14.142>, <40.001,24,14.142> } #else union {
// Brick  1 x  4 Log
	object { box5_dot_dat matrix <36,0,0,0,-20,0,0,0,6,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
	#end
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,-20,0,0> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,20,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,7.071,0,24,0,-10.001,0,7.071,-30,0,0> }
	mesh {
		triangle { <-24,0,6>, <-20,0,7.071>, <-24.587,0,9.239> }
		triangle { <-24.587,0,9.239>, <-30,0,10>, <-24,0,6> }
		triangle { <-24,0,6>, <-36,0,6>, <-30,0,10> }
		triangle { <-36,0,6>, <-30,0,10>, <-35.413,0,9.239> }
		triangle { <-35.413,0,9.239>, <-40,0,7.071>, <-36,0,6> }
		triangle { <-24,24,6>, <-20,24,7.071>, <-24.587,24,9.239> }
		triangle { <-24.587,24,9.239>, <-30,24,10>, <-24,24,6> }
		triangle { <-24,24,6>, <-36,24,6>, <-30,24,10> }
		triangle { <-36,24,6>, <-30,24,10>, <-35.413,24,9.239> }
		triangle { <-35.413,24,9.239>, <-40,24,7.071>, <-36,24,6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,-7.071,0,24,0,-10.001,0,-7.071,-30,0,0> }
	mesh {
		triangle { <-24,0,-6>, <-20,0,-7.071>, <-24.587,0,-9.239> }
		triangle { <-24.587,0,-9.239>, <-30,0,-10>, <-24,0,-6> }
		triangle { <-24,0,-6>, <-36,0,-6>, <-30,0,-10> }
		triangle { <-36,0,-6>, <-30,0,-10>, <-35.413,0,-9.239> }
		triangle { <-35.413,0,-9.239>, <-40,0,-7.071>, <-36,0,-6> }
		triangle { <-24,24,-6>, <-20,24,-7.071>, <-24.587,24,-9.239> }
		triangle { <-24.587,24,-9.239>, <-30,24,-10>, <-24,24,-6> }
		triangle { <-24,24,-6>, <-36,24,-6>, <-30,24,-10> }
		triangle { <-36,24,-6>, <-30,24,-10>, <-35.413,24,-9.239> }
		triangle { <-35.413,24,-9.239>, <-40,24,-7.071>, <-36,24,-6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,7.071,0,24,0,-10.001,0,7.071,-10,0,0> }
	mesh {
		triangle { <-4,0,6>, <0,0,7.071>, <-4.587,0,9.239> }
		triangle { <-4.587,0,9.239>, <-10,0,10>, <-4,0,6> }
		triangle { <-4,0,6>, <-16,0,6>, <-10,0,10> }
		triangle { <-16,0,6>, <-10,0,10>, <-15.413,0,9.239> }
		triangle { <-15.413,0,9.239>, <-20,0,7.071>, <-16,0,6> }
		triangle { <-4,24,6>, <0,24,7.071>, <-4.587,24,9.239> }
		triangle { <-4.587,24,9.239>, <-10,24,10>, <-4,24,6> }
		triangle { <-4,24,6>, <-16,24,6>, <-10,24,10> }
		triangle { <-16,24,6>, <-10,24,10>, <-15.413,24,9.239> }
		triangle { <-15.413,24,9.239>, <-20,24,7.071>, <-16,24,6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,-7.071,0,24,0,-10.001,0,-7.071,-10,0,0> }
	mesh {
		triangle { <-4,0,-6>, <0,0,-7.071>, <-4.587,0,-9.239> }
		triangle { <-4.587,0,-9.239>, <-10,0,-10>, <-4,0,-6> }
		triangle { <-4,0,-6>, <-16,0,-6>, <-10,0,-10> }
		triangle { <-16,0,-6>, <-10,0,-10>, <-15.413,0,-9.239> }
		triangle { <-15.413,0,-9.239>, <-20,0,-7.071>, <-16,0,-6> }
		triangle { <-4,24,-6>, <0,24,-7.071>, <-4.587,24,-9.239> }
		triangle { <-4.587,24,-9.239>, <-10,24,-10>, <-4,24,-6> }
		triangle { <-4,24,-6>, <-16,24,-6>, <-10,24,-10> }
		triangle { <-16,24,-6>, <-10,24,-10>, <-15.413,24,-9.239> }
		triangle { <-15.413,24,-9.239>, <-20,24,-7.071>, <-16,24,-6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,7.071,0,24,0,-10.001,0,7.071,10,0,0> }
	mesh {
		triangle { <16,0,6>, <20,0,7.071>, <15.413,0,9.239> }
		triangle { <15.413,0,9.239>, <10,0,10>, <16,0,6> }
		triangle { <16,0,6>, <4,0,6>, <10,0,10> }
		triangle { <4,0,6>, <10,0,10>, <4.587,0,9.239> }
		triangle { <4.587,0,9.239>, <0,0,7.071>, <4,0,6> }
		triangle { <16,24,6>, <20,24,7.071>, <15.413,24,9.239> }
		triangle { <15.413,24,9.239>, <10,24,10>, <16,24,6> }
		triangle { <16,24,6>, <4,24,6>, <10,24,10> }
		triangle { <4,24,6>, <10,24,10>, <4.587,24,9.239> }
		triangle { <4.587,24,9.239>, <0,24,7.071>, <4,24,6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,-7.071,0,24,0,-10.001,0,-7.071,10,0,0> }
	mesh {
		triangle { <16,0,-6>, <20,0,-7.071>, <15.413,0,-9.239> }
		triangle { <15.413,0,-9.239>, <10,0,-10>, <16,0,-6> }
		triangle { <16,0,-6>, <4,0,-6>, <10,0,-10> }
		triangle { <4,0,-6>, <10,0,-10>, <4.587,0,-9.239> }
		triangle { <4.587,0,-9.239>, <0,0,-7.071>, <4,0,-6> }
		triangle { <16,24,-6>, <20,24,-7.071>, <15.413,24,-9.239> }
		triangle { <15.413,24,-9.239>, <10,24,-10>, <16,24,-6> }
		triangle { <16,24,-6>, <4,24,-6>, <10,24,-10> }
		triangle { <4,24,-6>, <10,24,-10>, <4.587,24,-9.239> }
		triangle { <4.587,24,-9.239>, <0,24,-7.071>, <4,24,-6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,7.071,0,24,0,-10.001,0,7.071,30,0,0> }
	mesh {
		triangle { <36,0,6>, <40,0,7.071>, <35.413,0,9.239> }
		triangle { <35.413,0,9.239>, <30,0,10>, <36,0,6> }
		triangle { <36,0,6>, <24,0,6>, <30,0,10> }
		triangle { <24,0,6>, <30,0,10>, <24.587,0,9.239> }
		triangle { <24.587,0,9.239>, <20,0,7.071>, <24,0,6> }
		triangle { <36,24,6>, <40,24,7.071>, <35.413,24,9.239> }
		triangle { <35.413,24,9.239>, <30,24,10>, <36,24,6> }
		triangle { <36,24,6>, <24,24,6>, <30,24,10> }
		triangle { <24,24,6>, <30,24,10>, <24.587,24,9.239> }
		triangle { <24.587,24,9.239>, <20,24,7.071>, <24,24,6> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10.001,0,-7.071,0,24,0,-10.001,0,-7.071,30,0,0> }
	mesh {
		triangle { <36,0,-6>, <40,0,-7.071>, <35.413,0,-9.239> }
		triangle { <35.413,0,-9.239>, <30,0,-10>, <36,0,-6> }
		triangle { <36,0,-6>, <24,0,-6>, <30,0,-10> }
		triangle { <24,0,-6>, <30,0,-10>, <24.587,0,-9.239> }
		triangle { <24.587,0,-9.239>, <20,0,-7.071>, <24,0,-6> }
		triangle { <36,24,-6>, <40,24,-7.071>, <35.413,24,-9.239> }
		triangle { <35.413,24,-9.239>, <30,24,-10>, <36,24,-6> }
		triangle { <36,24,-6>, <24,24,-6>, <30,24,-10> }
		triangle { <24,24,-6>, <30,24,-10>, <24.587,24,-9.239> }
		triangle { <24.587,24,-9.239>, <20,24,-7.071>, <24,24,-6> }
	}
	object { rect_dot_dat matrix <0,12,0,1,0,0,0,0,-7.071,-40,12,0> }
	mesh {
		triangle { <-40,0,-7.071>, <-40,0,7.071>, <-36,0,6> }
		triangle { <-36,0,6>, <-36,0,-6>, <-40,0,-7.071> }
		triangle { <-40,24,-7.071>, <-40,24,7.071>, <-36,24,6> }
		triangle { <-36,24,6>, <-36,24,-6>, <-40,24,-7.071> }
		triangle { <-20,0,7.071>, <-20,0,-7.071>, <-24,0,-6> }
		triangle { <-24,0,-6>, <-24,0,6>, <-20,0,7.071> }
		triangle { <-20,0,-7.071>, <-20,0,7.071>, <-16,0,6> }
		triangle { <-16,0,6>, <-16,0,-6>, <-20,0,-7.071> }
		triangle { <-20,24,7.071>, <-14,24,6>, <-26,24,6> }
		triangle { <-20,24,-7.071>, <-14,24,-6>, <-26,24,-6> }
		triangle { <0,0,7.071>, <0,0,-7.071>, <-4,0,-6> }
		triangle { <-4,0,-6>, <-4,0,6>, <0,0,7.071> }
		triangle { <0,0,-7.071>, <0,0,7.071>, <4,0,6> }
		triangle { <4,0,6>, <4,0,-6>, <0,0,-7.071> }
		triangle { <0,24,7.071>, <6,24,6>, <-6,24,6> }
		triangle { <0,24,-7.071>, <6,24,-6>, <-6,24,-6> }
		triangle { <20,0,7.071>, <20,0,-7.071>, <16,0,-6> }
		triangle { <16,0,-6>, <16,0,6>, <20,0,7.071> }
		triangle { <20,0,-7.071>, <20,0,7.071>, <24,0,6> }
		triangle { <24,0,6>, <24,0,-6>, <20,0,-7.071> }
		triangle { <20,24,7.071>, <26,24,6>, <14,24,6> }
		triangle { <20,24,-7.071>, <26,24,-6>, <14,24,-6> }
	}
	object { rect_dot_dat matrix <0,12,0,1,0,0,0,0,7.071,40,12,0> }
	mesh {
		triangle { <40,0,7.071>, <40,0,-7.071>, <36,0,-6> }
		triangle { <36,0,-6>, <36,0,6>, <40,0,7.071> }
		triangle { <40,24,7.071>, <40,24,-7.071>, <36,24,-6> }
		triangle { <36,24,-6>, <36,24,6>, <40,24,7.071> }
		triangle { <-23.5,23,-6>, <-20,23,-2.5>, <-20,4,-2.5> }
		triangle { <-20,4,-2.5>, <-23.5,4,-6>, <-23.5,23,-6> }
		triangle { <-16.5,23,-6>, <-20,23,-2.5>, <-20,4,-2.5> }
		triangle { <-20,4,-2.5>, <-16.5,4,-6>, <-16.5,23,-6> }
		triangle { <-23.5,23,-6>, <-16.5,23,-6>, <-20,23,-2.5> }
		triangle { <-23.5,4,-6>, <-25,4,-4>, <-25,23,-4> }
		triangle { <-25,23,-4>, <-23.5,23,-6>, <-23.5,4,-6> }
		triangle { <-25,4,-4>, <-26.5,4,-6>, <-26.5,23,-6> }
		triangle { <-26.5,23,-6>, <-25,23,-4>, <-25,4,-4> }
		triangle { <-26.5,23,-6>, <-23.5,23,-6>, <-25,23,-4> }
		triangle { <-16.5,4,-6>, <-15,4,-4>, <-15,23,-4> }
		triangle { <-15,23,-4>, <-16.5,23,-6>, <-16.5,4,-6> }
		triangle { <-15,4,-4>, <-13.5,4,-6>, <-13.5,23,-6> }
		triangle { <-13.5,23,-6>, <-15,23,-4>, <-15,4,-4> }
		triangle { <-13.5,23,-6>, <-16.5,23,-6>, <-15,23,-4> }
		triangle { <-23.5,23,6>, <-20,23,2.5>, <-20,4,2.5> }
		triangle { <-20,4,2.5>, <-23.5,4,6>, <-23.5,23,6> }
		triangle { <-16.5,23,6>, <-20,23,2.5>, <-20,4,2.5> }
		triangle { <-20,4,2.5>, <-16.5,4,6>, <-16.5,23,6> }
		triangle { <-23.5,23,6>, <-16.5,23,6>, <-20,23,2.5> }
		triangle { <-23.5,4,6>, <-25,4,4>, <-25,23,4> }
		triangle { <-25,23,4>, <-23.5,23,6>, <-23.5,4,6> }
		triangle { <-25,4,4>, <-26.5,4,6>, <-26.5,23,6> }
		triangle { <-26.5,23,6>, <-25,23,4>, <-25,4,4> }
		triangle { <-26.5,23,6>, <-23.5,23,6>, <-25,23,4> }
		triangle { <-16.5,4,6>, <-15,4,4>, <-15,23,4> }
		triangle { <-15,23,4>, <-16.5,23,6>, <-16.5,4,6> }
		triangle { <-15,4,4>, <-13.5,4,6>, <-13.5,23,6> }
		triangle { <-13.5,23,6>, <-15,23,4>, <-15,4,4> }
		triangle { <-13.5,23,6>, <-16.5,23,6>, <-15,23,4> }
		triangle { <-3.5,23,-6>, <0,23,-2.5>, <0,4,-2.5> }
		triangle { <0,4,-2.5>, <-3.5,4,-6>, <-3.5,23,-6> }
		triangle { <3.5,23,-6>, <0,23,-2.5>, <0,4,-2.5> }
		triangle { <0,4,-2.5>, <3.5,4,-6>, <3.5,23,-6> }
		triangle { <-3.5,23,-6>, <3.5,23,-6>, <0,23,-2.5> }
		triangle { <-3.5,4,-6>, <-5,4,-4>, <-5,23,-4> }
		triangle { <-5,23,-4>, <-3.5,23,-6>, <-3.5,4,-6> }
		triangle { <-5,4,-4>, <-6.5,4,-6>, <-6.5,23,-6> }
		triangle { <-6.5,23,-6>, <-5,23,-4>, <-5,4,-4> }
		triangle { <-6.5,23,-6>, <-3.5,23,-6>, <-5,23,-4> }
		triangle { <3.5,4,-6>, <5,4,-4>, <5,23,-4> }
		triangle { <5,23,-4>, <3.5,23,-6>, <3.5,4,-6> }
		triangle { <5,4,-4>, <6.5,4,-6>, <6.5,23,-6> }
		triangle { <6.5,23,-6>, <5,23,-4>, <5,4,-4> }
		triangle { <6.5,23,-6>, <3.5,23,-6>, <5,23,-4> }
		triangle { <-3.5,23,6>, <0,23,2.5>, <0,4,2.5> }
		triangle { <0,4,2.5>, <-3.5,4,6>, <-3.5,23,6> }
		triangle { <3.5,23,6>, <0,23,2.5>, <0,4,2.5> }
		triangle { <0,4,2.5>, <3.5,4,6>, <3.5,23,6> }
		triangle { <-3.5,23,6>, <3.5,23,6>, <0,23,2.5> }
		triangle { <-3.5,4,6>, <-5,4,4>, <-5,23,4> }
		triangle { <-5,23,4>, <-3.5,23,6>, <-3.5,4,6> }
		triangle { <-5,4,4>, <-6.5,4,6>, <-6.5,23,6> }
		triangle { <-6.5,23,6>, <-5,23,4>, <-5,4,4> }
		triangle { <-6.5,23,6>, <-3.5,23,6>, <-5,23,4> }
		triangle { <3.5,4,6>, <5,4,4>, <5,23,4> }
		triangle { <5,23,4>, <3.5,23,6>, <3.5,4,6> }
		triangle { <5,4,4>, <6.5,4,6>, <6.5,23,6> }
		triangle { <6.5,23,6>, <5,23,4>, <5,4,4> }
		triangle { <6.5,23,6>, <3.5,23,6>, <5,23,4> }
		triangle { <16.5,23,-6>, <20,23,-2.5>, <20,4,-2.5> }
		triangle { <20,4,-2.5>, <16.5,4,-6>, <16.5,23,-6> }
		triangle { <23.5,23,-6>, <20,23,-2.5>, <20,4,-2.5> }
		triangle { <20,4,-2.5>, <23.5,4,-6>, <23.5,23,-6> }
		triangle { <16.5,23,-6>, <23.5,23,-6>, <20,23,-2.5> }
		triangle { <16.5,4,-6>, <15,4,-4>, <15,23,-4> }
		triangle { <15,23,-4>, <16.5,23,-6>, <16.5,4,-6> }
		triangle { <15,4,-4>, <13.5,4,-6>, <13.5,23,-6> }
		triangle { <13.5,23,-6>, <15,23,-4>, <15,4,-4> }
		triangle { <13.5,23,-6>, <16.5,23,-6>, <15,23,-4> }
		triangle { <23.5,4,-6>, <25,4,-4>, <25,23,-4> }
		triangle { <25,23,-4>, <23.5,23,-6>, <23.5,4,-6> }
		triangle { <25,4,-4>, <26.5,4,-6>, <26.5,23,-6> }
		triangle { <26.5,23,-6>, <25,23,-4>, <25,4,-4> }
		triangle { <26.5,23,-6>, <23.5,23,-6>, <25,23,-4> }
		triangle { <16.5,23,6>, <20,23,2.5>, <20,4,2.5> }
		triangle { <20,4,2.5>, <16.5,4,6>, <16.5,23,6> }
		triangle { <23.5,23,6>, <20,23,2.5>, <20,4,2.5> }
		triangle { <20,4,2.5>, <23.5,4,6>, <23.5,23,6> }
		triangle { <16.5,23,6>, <23.5,23,6>, <20,23,2.5> }
		triangle { <16.5,4,6>, <15,4,4>, <15,23,4> }
		triangle { <15,23,4>, <16.5,23,6>, <16.5,4,6> }
		triangle { <15,4,4>, <13.5,4,6>, <13.5,23,6> }
		triangle { <13.5,23,6>, <15,23,4>, <15,4,4> }
		triangle { <13.5,23,6>, <16.5,23,6>, <15,23,4> }
		triangle { <23.5,4,6>, <25,4,4>, <25,23,4> }
		triangle { <25,23,4>, <23.5,23,6>, <23.5,4,6> }
		triangle { <25,4,4>, <26.5,4,6>, <26.5,23,6> }
		triangle { <26.5,23,6>, <25,23,4>, <25,4,4> }
		triangle { <26.5,23,6>, <23.5,23,6>, <25,23,4> }
	}
	object { box_dot_dat matrix <1,0,0,0,7,0,0,0,3,0,11,0> }
}
#end

#declare _3004_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else union {
// Brick  1 x  2
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { box5_dot_dat matrix <20,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
}
#end

#declare _2653_dot_dat = #if (QUAL = 0) box { <-40,-4,-10>, <40,24,10> } #else union {
// Brick  1 x  4 with Groove
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,20,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,20,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,6,0,24,0> }
	mesh {
		triangle { <40,24,10>, <36,24,6>, <-36,24,6> }
		triangle { <-36,24,6>, <-40,24,10>, <40,24,10> }
		triangle { <-40,24,10>, <-36,24,6>, <-36,24,-6> }
		triangle { <-36,24,-6>, <-40,24,-10>, <-40,24,10> }
		triangle { <-40,24,-10>, <-36,24,-6>, <36,24,-6> }
		triangle { <36,24,-6>, <40,24,-10>, <-40,24,-10> }
		triangle { <40,24,-10>, <36,24,-6>, <36,24,6> }
		triangle { <36,24,6>, <40,24,10>, <40,24,-10> }
	}
	object { box5_dot_dat matrix <1,0,0,0,0,-4,0,4,0,20,12,6> }
	object { box5_dot_dat matrix <1,0,0,0,0,-4,0,4,0,0,12,6> }
	object { box5_dot_dat matrix <1,0,0,0,0,-4,0,4,0,-20,12,6> }
	mesh {
		triangle { <36,16,6>, <36,16,0>, <-36,16,0> }
		triangle { <-36,16,0>, <-36,16,6>, <36,16,6> }
		triangle { <40,16,0>, <40,16,-10>, <-40,16,-10> }
		triangle { <-40,16,-10>, <-40,16,0>, <40,16,0> }
		triangle { <36,8,6>, <36,8,0>, <-36,8,0> }
		triangle { <-36,8,0>, <-36,8,6>, <36,8,6> }
		triangle { <40,8,0>, <40,8,-10>, <-40,8,-10> }
		triangle { <-40,8,-10>, <-40,8,0>, <40,8,0> }
		triangle { <40,24,10>, <40,0,10>, <-40,0,10> }
		triangle { <-40,0,10>, <-40,24,10>, <40,24,10> }
		triangle { <36,16,6>, <36,8,6>, <-36,8,6> }
		triangle { <-36,8,6>, <-36,16,6>, <36,16,6> }
		triangle { <40,16,0>, <40,8,0>, <36,8,0> }
		triangle { <36,8,0>, <36,16,0>, <40,16,0> }
		triangle { <-40,16,0>, <-40,8,0>, <-36,8,0> }
		triangle { <-36,8,0>, <-36,16,0>, <-40,16,0> }
		triangle { <40,24,-10>, <40,16,-10>, <-40,16,-10> }
		triangle { <-40,16,-10>, <-40,24,-10>, <40,24,-10> }
		triangle { <40,8,-10>, <40,0,-10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,8,-10>, <40,8,-10> }
		triangle { <40,24,-10>, <40,16,-10>, <40,16,0> }
		triangle { <40,16,0>, <40,24,10>, <40,24,-10> }
		triangle { <40,24,10>, <40,16,0>, <40,8,0> }
		triangle { <40,8,0>, <40,0,10>, <40,24,10> }
		triangle { <40,0,10>, <40,8,0>, <40,8,-10> }
		triangle { <40,8,-10>, <40,0,-10>, <40,0,10> }
		triangle { <36,16,6>, <36,16,0>, <36,8,0> }
		triangle { <36,8,0>, <36,8,6>, <36,16,6> }
		triangle { <-36,16,6>, <-36,16,0>, <-36,8,0> }
		triangle { <-36,8,0>, <-36,8,6>, <-36,16,6> }
		triangle { <-40,24,-10>, <-40,16,-10>, <-40,16,0> }
		triangle { <-40,16,0>, <-40,24,10>, <-40,24,-10> }
		triangle { <-40,24,10>, <-40,16,0>, <-40,8,0> }
		triangle { <-40,8,0>, <-40,0,10>, <-40,24,10> }
		triangle { <-40,0,10>, <-40,8,0>, <-40,8,-10> }
		triangle { <-40,8,-10>, <-40,0,-10>, <-40,0,10> }
		triangle { <40,0,10>, <38,0,8>, <-38,0,8> }
		triangle { <-38,0,8>, <-40,0,10>, <40,0,10> }
		triangle { <-40,0,10>, <-38,0,8>, <-38,0,-8> }
		triangle { <-38,0,-8>, <-40,0,-10>, <-40,0,10> }
		triangle { <-40,0,-10>, <-38,0,-8>, <38,0,-8> }
		triangle { <38,0,-8>, <40,0,-10>, <-40,0,-10> }
		triangle { <40,0,-10>, <38,0,-8>, <38,0,8> }
		triangle { <38,0,8>, <40,0,10>, <40,0,-10> }
	}
	object { box5_dot_dat matrix <38,0,0,0,4,0,0,0,8,0,0,0> }
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,30,4,0> }
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,10,4,0> }
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,-10,4,0> }
		object { stud2_dot_dat matrix <1,0,0,0,2,0,0,0,1,-30,4,0> }
	#end
}
#end

#declare _1_dash_4cyls_dot_dat = cylinder { <0,0,0>, <0,1,0>, 1 open
	clipped_by { plane { <-1,0,-1>,-O7071 } plane { <1,1,0>,O7071 } } }

#declare _3039p23_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,24,10> } #else union {
// Slope Brick 45  2 x  2 with computer screen front
	mesh {
		triangle { <-20,20,-30>, <-19.3,19.29,-29.29>, <-19.2,0.64,-10.64> }
		triangle { <-19.2,0.64,-10.64>, <-20,0,-10>, <-20,20,-30> }
		triangle { <-20,0,-10>, <-19.2,0.64,-10.64>, <19.3,0.71,-10.71> }
		triangle { <19.3,0.71,-10.71>, <20,0,-10>, <-20,0,-10> }
		triangle { <20,0,-10>, <19.3,0.71,-10.71>, <19.3,19.29,-29.29> }
		triangle { <19.3,19.29,-29.29>, <20,20,-30>, <20,0,-10> }
		triangle { <-20,20,-30>, <-19.3,19.29,-29.29>, <19.3,19.29,-29.29> }
		triangle { <19.3,19.29,-29.29>, <20,20,-30>, <-20,20,-30> }
	}
	mesh {
		triangle { <4,1.57,-11.57>, <4.7,2.07,-12.07>, <4.8,18.43,-28.43> }
		triangle { <4.8,18.43,-28.43>, <4.1,18.86,-28.86>, <4,1.57,-11.57> }
		triangle { <-17.1,1.64,-11.64>, <4,1.57,-11.57>, <4.1,18.86,-28.86> }
		triangle { <4.1,18.86,-28.86>, <-17.7,18.93,-28.93>, <-17.1,1.64,-11.64> }
		triangle { <-17.7,18.93,-28.93>, <-18.4,18.5,-28.5>, <-18.3,2.21,-12.21> }
		triangle { <-18.3,2.21,-12.21>, <-17.1,1.64,-11.64>, <-17.7,18.93,-28.93> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <12,14.36,-24.36>, <16,14.36,-24.36>, <16,17.21,-27.21> }
		triangle { <16,17.21,-27.21>, <12,17.21,-27.21>, <12,14.36,-24.36> }
		#if (ver >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <12,8.64,-18.64>, <16,8.64,-18.64>, <16,11.5,-21.5> }
		triangle { <16,11.5,-21.5>, <12,11.5,-21.5>, <12,8.64,-18.64> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <12,2.93,-12.93>, <16,2.93,-12.93>, <16,5.79,-15.79> }
		triangle { <16,5.79,-15.79>, <12,5.79,-15.79>, <12,2.93,-12.93> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-19.2,0.64,-10.64>, <-18.3,2.21,-12.21>, <-18.4,18.5,-28.5> }
		triangle { <-18.4,18.5,-28.5>, <-19.3,19.29,-29.29>, <-19.2,0.64,-10.64> }
		triangle { <-19.2,0.64,-10.64>, <-17.1,1.64,-11.64>, <-18.3,2.21,-12.21> }
		triangle { <-19.2,0.64,-10.64>, <19.3,0.71,-10.71>, <4,1.57,-11.57> }
		triangle { <4,1.57,-11.57>, <-17.1,1.64,-11.64>, <-19.2,0.64,-10.64> }
		triangle { <-19.3,19.29,-29.29>, <-18.4,18.5,-28.5>, <-17.7,18.93,-28.93> }
		triangle { <-19.3,19.29,-29.29>, <-17.7,18.93,-28.93>, <4.1,18.86,-28.86> }
		triangle { <4.1,18.86,-28.86>, <19.3,19.29,-29.29>, <-19.3,19.29,-29.29> }
		triangle { <19.3,0.71,-10.71>, <4,1.57,-11.57>, <4.7,2.07,-12.07> }
		triangle { <19.3,19.29,-29.29>, <4.1,18.86,-28.86>, <4.8,18.43,-28.43> }
		triangle { <4.7,2.07,-12.07>, <12,2.93,-12.93>, <12,17.21,-27.21> }
		triangle { <12,17.21,-27.21>, <4.8,18.43,-28.43>, <4.7,2.07,-12.07> }
		triangle { <19.3,19.29,-29.29>, <16,17.21,-27.21>, <16,2.93,-12.93> }
		triangle { <16,2.93,-12.93>, <19.3,0.71,-10.71>, <19.3,19.29,-29.29> }
		triangle { <4.7,2.07,-12.07>, <12,2.93,-12.93>, <16,2.93,-12.93> }
		triangle { <16,2.93,-12.93>, <19.3,0.71,-10.71>, <4.7,2.07,-12.07> }
		triangle { <4.8,18.43,-28.43>, <12,17.21,-27.21>, <16,17.21,-27.21> }
		triangle { <16,17.21,-27.21>, <19.3,19.29,-29.29>, <4.8,18.43,-28.43> }
		triangle { <12,5.79,-15.79>, <16,5.79,-15.79>, <16,8.64,-18.64> }
		triangle { <16,8.64,-18.64>, <12,8.64,-18.64>, <12,5.79,-15.79> }
		triangle { <12,11.5,-21.5>, <16,11.5,-21.5>, <16,14.36,-24.36> }
		triangle { <16,14.36,-24.36>, <12,14.36,-24.36>, <12,11.5,-21.5> }
		triangle { <12,11.5,-21.5>, <16,11.5,-21.5>, <16,14.36,-24.36> }
		triangle { <16,14.36,-24.36>, <12,14.36,-24.36>, <12,11.5,-21.5> }
// 3039-4t Slope Brick 45  2 x  2 without sloped front
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,0,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,0,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,0,20,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,0,12,-10> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-26> }
		triangle { <-16,24,-26>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,24,-30>, <-16,24,-26>, <16,24,-26> }
		triangle { <16,24,-26>, <20,24,-30>, <-20,24,-30> }
		triangle { <20,24,-30>, <16,24,-26>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-30> }
		triangle { <16,4,6>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,4,6>, <16,4,6> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <16,24,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,24,6>, <16,24,6> }
		triangle { <16,24,-26>, <16,20,-26>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <16,24,-26> }
		triangle { <20,24,-30>, <20,20,-30>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <20,24,-30> }
		triangle { <20,24,10>, <20,0,10>, <20,20,-30> }
		triangle { <20,20,-30>, <20,24,-30>, <20,24,10> }
		triangle { <20,0,10>, <20,0,-10>, <20,20,-30> }
		triangle { <16,24,6>, <16,4,6>, <16,20,-26> }
		triangle { <16,20,-26>, <16,24,-26>, <16,24,6> }
		triangle { <16,4,6>, <16,4,-10>, <16,20,-26> }
		triangle { <-16,24,6>, <-16,4,6>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <-16,24,6> }
		triangle { <-16,4,6>, <-16,4,-10>, <-16,20,-26> }
		triangle { <-20,24,10>, <-20,0,10>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-20,20,-30> }
		triangle { <16,20,-26>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,20,-26>, <16,20,-26> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
// /3039-4t Slope Brick 45  2 x  2 without sloped front
	#end
}
#end

#declare _3039p34_dot_dat = #if (QUAL = 0) box { <-20,-4,-30.0004>, <20,24,10> } #else union {
// Slope Brick 45  2 x  2 with Computer Panel Pattern (needs work)
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,16,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color2 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,16,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,12,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color2 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,12,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,8,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color2 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,8,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,4,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,4,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,16,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,16,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,12,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,12,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,8,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,8,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,4,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,4,17.5003,-27.5003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <1,13.2146,-23.2146>, <3,14.286,-24.286>, <17,14.286,-24.286> }
		triangle { <17,14.286,-24.286>, <19,13.2146,-23.2146>, <1,13.2146,-23.2146> }
		triangle { <19,13.2146,-23.2146>, <17,14.286,-24.286>, <17,18.2146,-28.2146> }
		triangle { <17,18.2146,-28.2146>, <19,19.2861,-29.2861>, <19,13.2146,-23.2146> }
		triangle { <19,19.2861,-29.2861>, <17,18.2146,-28.2146>, <3,18.2146,-28.2146> }
		triangle { <3,18.2146,-28.2146>, <1,19.2861,-29.2861>, <19,19.2861,-29.2861> }
		triangle { <1,19.2861,-29.2861>, <3,18.2146,-28.2146>, <3,14.286,-24.286> }
		triangle { <3,14.286,-24.286>, <1,13.2146,-23.2146>, <1,19.2861,-29.2861> }
		triangle { <3,15.7146,-25.7146>, <17,15.7146,-25.7146>, <17,16.786,-26.786> }
		triangle { <17,16.786,-26.786>, <3,16.786,-26.786>, <3,15.7146,-25.7146> }
		triangle { <5,14.286,-24.286>, <7,14.286,-24.286>, <7,18.2146,-28.2146> }
		triangle { <7,18.2146,-28.2146>, <5,18.2146,-28.2146>, <5,14.286,-24.286> }
		triangle { <9,14.286,-24.286>, <11,14.286,-24.286>, <11,18.2146,-28.2146> }
		triangle { <11,18.2146,-28.2146>, <9,18.2146,-28.2146>, <9,14.286,-24.286> }
		triangle { <13,14.286,-24.286>, <15,14.286,-24.286>, <15,18.2146,-28.2146> }
		triangle { <15,18.2146,-28.2146>, <13,18.2146,-28.2146>, <13,14.286,-24.286> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <1,11.7859,-21.7859>, <19,11.7859,-21.7859>, <19,13.2146,-23.2146> }
		triangle { <19,13.2146,-23.2146>, <1,13.2146,-23.2146>, <1,11.7859,-21.7859> }
	}
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,-16,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,-16,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1.5,0,0,1,1,0,0,1.07145,-1.07145,-12,15.0003,-25.0003> }
	object { _4_dash_4ndis_dot_dat matrix <1.5,0,0,1,1,0,0,1.07145,-1.07145,-12,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,-8,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color4 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,-8,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	object { _4_dash_4disc_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,-4,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color2 } }
	object { _4_dash_4ndis_dot_dat matrix <1,0,0,1,1,0,0,0.7143,-0.7143,-4,15.0003,-25.0003> #if (ver >= 3.1) material #else texture #end { Color15 } }
	mesh {
		triangle { <-19,12.5002,-22.5002>, <-17,14.286,-24.286>, <-15,14.286,-24.286> }
		triangle { <-15,14.286,-24.286>, <-13.5,13.9288,-23.9289>, <-19,12.5002,-22.5002> }
		triangle { <-19,12.5002,-22.5002>, <-13.5,13.9288,-23.9289>, <-10.5,13.9288,-23.9289> }
		triangle { <-10.5,13.9288,-23.9289>, <-1,12.5003,-22.5003>, <-19,12.5002,-22.5002> }
		triangle { <-1,12.5003,-22.5003>, <-10.5,13.9288,-23.9289>, <-9,14.286,-24.286> }
		triangle { <-9,14.286,-24.286>, <-7,14.286,-24.286>, <-1,12.5003,-22.5003> }
		triangle { <-1,12.5003,-22.5003>, <-7,14.286,-24.286>, <-3,14.286,-24.286> }
		triangle { <-1,12.5003,-22.5003>, <-3,14.286,-24.286>, <-3,15.7146,-25.7146> }
		triangle { <-3,15.7146,-25.7146>, <-1,17.1432,-27.1432>, <-1,12.5003,-22.5003> }
		triangle { <-1,17.1432,-27.1432>, <-3,15.7146,-25.7146>, <-9,15.7146,-25.7146> }
		triangle { <-9,15.7146,-25.7146>, <-10.5,16.0717,-26.0717>, <-1,17.1432,-27.1432> }
		triangle { <-1,17.1432,-27.1432>, <-10.5,16.0717,-26.0717>, <-13.5,16.0717,-26.0717> }
		triangle { <-13.5,16.0717,-26.0717>, <-19,17.1432,-27.1432>, <-1,17.1432,-27.1432> }
		triangle { <-19,17.1432,-27.1432>, <-13.5,16.0717,-26.0717>, <-15,15.7146,-25.7146> }
		triangle { <-15,15.7146,-25.7146>, <-17,15.7146,-25.7146>, <-19,17.1432,-27.1432> }
		triangle { <-19,17.1432,-27.1432>, <-17,15.7146,-25.7146>, <-17,14.286,-24.286> }
		triangle { <-17,14.286,-24.286>, <-19,12.5002,-22.5002>, <-19,17.1432,-27.1432> }
		triangle { <-15,14.286,-24.286>, <-13.5,13.9288,-23.9289>, <-13.5,16.0717,-26.0717> }
		triangle { <-13.5,16.0717,-26.0717>, <-15,15.7146,-25.7146>, <-15,14.286,-24.286> }
		triangle { <-10.5,13.9288,-23.9289>, <-9,14.286,-24.286>, <-9,15.7146,-25.7146> }
		triangle { <-9,15.7146,-25.7146>, <-10.5,16.0717,-26.0717>, <-10.5,13.9288,-23.9289> }
		triangle { <-7,14.286,-24.286>, <-5,14.286,-24.286>, <-5,15.7146,-25.7146> }
		triangle { <-5,15.7146,-25.7146>, <-7,15.7146,-25.7146>, <-7,14.286,-24.286> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-20,0,-10>, <-19,0.7143,-10.7143>, <19,0.7143,-10.7143> }
		triangle { <19,0.7143,-10.7143>, <20,0,-10>, <-20,0,-10> }
		triangle { <20,0,-10>, <19,0.7143,-10.7143>, <19,19.2861,-29.2861> }
		triangle { <19,19.2861,-29.2861>, <20,20.0004,-30.0004>, <20,0,-10> }
		triangle { <20,20.0004,-30.0004>, <19,19.2861,-29.2861>, <-19,19.2861,-29.2861> }
		triangle { <-19,19.2861,-29.2861>, <-20,20.0004,-30.0004>, <20,20.0004,-30.0004> }
		triangle { <-20,20.0004,-30.0004>, <-19,19.2861,-29.2861>, <-19,0.7143,-10.7143> }
		triangle { <-19,0.7143,-10.7143>, <-20,0,-10>, <-20,20.0004,-30.0004> }
		triangle { <-1,0.7143,-10.7143>, <1,0.7143,-10.7143>, <1,19.2861,-29.2861> }
		triangle { <1,19.2861,-29.2861>, <-1,19.2861,-29.2861>, <-1,0.7143,-10.7143> }
	}
	mesh {
		triangle { <-19,0.7143,-10.7143>, <-17,2.1429,-12.1429>, <-3,2.1429,-12.1429> }
		triangle { <-3,2.1429,-12.1429>, <-1,0.7143,-10.7143>, <-19,0.7143,-10.7143> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-17,2.1429,-12.1429>, <-13.5,2.1429,-12.1429>, <-13.5,4.64295,-14.6429> }
		triangle { <-13.5,4.64295,-14.6429>, <-17,4.64295,-14.643>, <-17,2.1429,-12.1429> }
		triangle { <-11.75,2.1429,-12.1429>, <-8.25,2.1429,-12.1429>, <-8.25,4.64295,-14.643> }
		triangle { <-8.25,4.64295,-14.643>, <-11.75,4.64295,-14.6429>, <-11.75,2.1429,-12.1429> }
		triangle { <-6.5,2.1429,-12.1429>, <-3,2.1429,-12.1429>, <-3,4.64295,-14.643> }
		triangle { <-3,4.64295,-14.643>, <-6.5,4.64295,-14.643>, <-6.5,2.1429,-12.1429> }
		#if (ver >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <-17,5.89297,-15.893>, <-13.5,5.89298,-15.893>, <-13.5,8.39302,-18.393> }
		triangle { <-13.5,8.39302,-18.393>, <-17,8.39302,-18.393>, <-17,5.89297,-15.893> }
		triangle { <-11.75,5.89297,-15.893>, <-8.25,5.89297,-15.893>, <-8.25,8.39303,-18.393> }
		triangle { <-8.25,8.39303,-18.393>, <-11.75,8.39302,-18.393>, <-11.75,5.89297,-15.893> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <-6.5,5.89297,-15.893>, <-3,5.89298,-15.893>, <-3,8.39303,-18.393> }
		triangle { <-3,8.39303,-18.393>, <-6.5,8.39303,-18.393>, <-6.5,5.89297,-15.893> }
		triangle { <-17.25,9.82163,-19.8216>, <-13.75,9.82163,-19.8216>, <-13.75,12.3217,-22.3217> }
		triangle { <-13.75,12.3217,-22.3217>, <-17.25,12.3217,-22.3217>, <-17.25,9.82163,-19.8216> }
		#if (ver >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <-11.75,9.64305,-19.643>, <-8.25,9.64305,-19.643>, <-8.25,12.1431,-22.1431> }
		triangle { <-8.25,12.1431,-22.1431>, <-11.75,12.1431,-22.1431>, <-11.75,9.64305,-19.643> }
		triangle { <-6.5,9.64305,-19.643>, <-3,9.64305,-19.643>, <-3,12.1431,-22.1431> }
		triangle { <-3,12.1431,-22.1431>, <-6.5,12.1431,-22.1431>, <-6.5,9.64305,-19.643> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <-19,0.7143,-10.7143>, <-17,2.1429,-12.1429>, <-17,8.39302,-18.393> }
		triangle { <-17,8.39302,-18.393>, <-19,12.5002,-22.5002>, <-19,0.7143,-10.7143> }
		triangle { <-17,8.39302,-18.393>, <-17.25,9.82163,-19.8216>, <-19,12.5002,-22.5002> }
		triangle { <-17.25,9.82163,-19.8216>, <-17.25,12.3217,-22.3217>, <-19,12.5002,-22.5002> }
		triangle { <-19,12.5002,-22.5002>, <-17.25,12.3217,-22.3217>, <-13.75,12.3217,-22.3217> }
		triangle { <-13.75,12.3217,-22.3217>, <-1,12.5002,-22.5002>, <-19,12.5002,-22.5002> }
		triangle { <-1,12.5002,-22.5002>, <-13.75,12.3217,-22.3217>, <-11.75,12.1431,-22.1431> }
		triangle { <-11.75,12.1431,-22.1431>, <-3,12.1431,-22.1431>, <-1,12.5002,-22.5002> }
		triangle { <-1,12.5002,-22.5002>, <-3,12.1431,-22.1431>, <-3,2.1429,-12.1429> }
		triangle { <-3,2.1429,-12.1429>, <-1,0.7143,-10.7143>, <-1,12.5002,-22.5002> }
		triangle { <-13.5,2.1429,-12.1429>, <-11.75,2.1429,-12.1429>, <-11.75,12.1431,-22.1431> }
		triangle { <-11.75,12.1431,-22.1431>, <-13.75,12.3217,-22.3217>, <-13.5,2.1429,-12.1429> }
		triangle { <-8.25,2.1429,-12.1429>, <-6.5,2.1429,-12.1429>, <-6.5,12.1431,-22.1431> }
		triangle { <-6.5,12.1431,-22.1431>, <-8.25,12.1431,-22.1431>, <-8.25,2.1429,-12.1429> }
		triangle { <-17,4.64295,-14.643>, <-3,4.64295,-14.643>, <-3,5.89298,-15.893> }
		triangle { <-3,5.89298,-15.893>, <-17,5.89297,-15.893>, <-17,4.64295,-14.643> }
		triangle { <-17,4.64295,-14.643>, <-3,4.64295,-14.643>, <-3,5.89298,-15.893> }
		triangle { <-3,5.89298,-15.893>, <-17,5.89297,-15.893>, <-17,4.64295,-14.643> }
		triangle { <-17,8.39302,-18.393>, <-13.5,8.39302,-18.393>, <-13.75,9.82163,-19.8216> }
		triangle { <-13.75,9.82163,-19.8216>, <-17.25,9.82163,-19.8216>, <-17,8.39302,-18.393> }
		triangle { <-11.75,8.39302,-18.393>, <-3,8.39303,-18.393>, <-3,9.64305,-19.643> }
		triangle { <-3,9.64305,-19.643>, <-11.75,9.64305,-19.643>, <-11.75,8.39302,-18.393> }
		triangle { <-19,19.2861,-29.2861>, <-17,18.5718,-28.5718>, <-17,17.1432,-27.1432> }
		triangle { <-17,17.1432,-27.1432>, <-19,17.1432,-27.1432>, <-19,19.2861,-29.2861> }
		triangle { <-19,19.2861,-29.2861>, <-17,18.5718,-28.5718>, <-3,18.5718,-28.5718> }
		triangle { <-3,18.5718,-28.5718>, <-1,19.2861,-29.2861>, <-19,19.2861,-29.2861> }
		triangle { <-1,19.2861,-29.2861>, <-3,18.5718,-28.5718>, <-3,17.1432,-27.1432> }
		triangle { <-3,17.1432,-27.1432>, <-1,17.1432,-27.1432>, <-1,19.2861,-29.2861> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <-17,17.1432,-27.1432>, <-3,17.1432,-27.1432>, <-3,18.5718,-28.5718> }
		triangle { <-3,18.5718,-28.5718>, <-17,18.5718,-28.5718>, <-17,17.1432,-27.1432> }
	}
	mesh {
		triangle { <1,0.7143,-10.7143>, <19,0.7143,-10.7143>, <17.5,2.1429,-12.1429> }
		triangle { <17.5,2.1429,-12.1429>, <3,2.1429,-12.1429>, <1,0.7143,-10.7143> }
		triangle { <1,0.7143,-10.7143>, <3,2.1429,-12.1429>, <3,10.0002,-20.0002> }
		triangle { <3,10.0002,-20.0002>, <1,11.7859,-21.7859>, <1,0.7143,-10.7143> }
		triangle { <1,11.7859,-21.7859>, <3,10.0002,-20.0002>, <14,10.0002,-20.0002> }
		triangle { <14,10.0002,-20.0002>, <15.5,10.3573,-20.3573>, <1,11.7859,-21.7859> }
		triangle { <1,11.7859,-21.7859>, <15.5,10.3573,-20.3573>, <17.5,10.3573,-20.3573> }
		triangle { <17.5,10.3573,-20.3573>, <19,11.7859,-21.7859>, <1,11.7859,-21.7859> }
		triangle { <19,11.7859,-21.7859>, <17.5,10.3573,-20.3573>, <17.5,2.1429,-12.1429> }
		triangle { <17.5,2.1429,-12.1429>, <19,0.7143,-10.7143>, <19,11.7859,-21.7859> }
		triangle { <14,2.1429,-12.1429>, <15.5,2.1429,-12.1429>, <15.5,10.3573,-20.3573> }
		triangle { <15.5,10.3573,-20.3573>, <14,10.0002,-20.0002>, <14,2.1429,-12.1429> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	mesh {
		triangle { <15.5,2.1429,-12.1429>, <17.5,2.1429,-12.1429>, <17.5,10.3573,-20.3573> }
		triangle { <17.5,10.3573,-20.3573>, <15.5,10.3573,-20.3573>, <15.5,2.1429,-12.1429> }
	}
	mesh {
		triangle { <3,2.1429,-12.1429>, <8,2.50005,-12.5>, <9,2.50005,-12.5> }
		triangle { <9,2.50005,-12.5>, <14,2.1429,-12.1429>, <3,2.1429,-12.1429> }
		triangle { <14,2.1429,-12.1429>, <13.5,5.7144,-15.7144>, <13.5,6.4287,-16.4287> }
		triangle { <13.5,6.4287,-16.4287>, <14,10.0002,-20.0002>, <14,2.1429,-12.1429> }
		triangle { <14,10.0002,-20.0002>, <9,9.64305,-19.643>, <8,9.64305,-19.643> }
		triangle { <8,9.64305,-19.643>, <3,10.0002,-20.0002>, <14,10.0002,-20.0002> }
		triangle { <3,10.0002,-20.0002>, <3.5,6.4287,-16.4287>, <3.5,5.7144,-15.7144> }
		triangle { <3.5,5.7144,-15.7144>, <3,2.1429,-12.1429>, <3,10.0002,-20.0002> }
		triangle { <3,2.1429,-12.1429>, <3.5,5.7144,-15.7144>, <8,5.7144,-15.7144> }
		triangle { <8,5.7144,-15.7144>, <8,2.50005,-12.5>, <3,2.1429,-12.1429> }
		triangle { <14,2.1429,-12.1429>, <9,2.50005,-12.5>, <9,5.7144,-15.7144> }
		triangle { <9,5.7144,-15.7144>, <13.5,5.7144,-15.7144>, <14,2.1429,-12.1429> }
		triangle { <14,10.0002,-20.0002>, <13.5,6.4287,-16.4287>, <9,6.4287,-16.4287> }
		triangle { <9,6.4287,-16.4287>, <9,9.64305,-19.643>, <14,10.0002,-20.0002> }
		triangle { <3,10.0002,-20.0002>, <8,9.64305,-19.643>, <8,6.4287,-16.4287> }
		triangle { <8,6.4287,-16.4287>, <3.5,6.4287,-16.4287>, <3,10.0002,-20.0002> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <3.5,5.7144,-15.7144>, <13.5,5.7144,-15.7144>, <13.5,6.4287,-16.4287> }
		triangle { <13.5,6.4287,-16.4287>, <3.5,6.4287,-16.4287>, <3.5,5.7144,-15.7144> }
		triangle { <9,2.50005,-12.5>, <9,9.64305,-19.643>, <8,9.64305,-19.643> }
		triangle { <8,9.64305,-19.643>, <8,2.50005,-12.5>, <9,2.50005,-12.5> }
// 3039-4t Slope Brick 45  2 x  2 without sloped front
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,0,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,0,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,0,20,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,0,12,-10> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-26> }
		triangle { <-16,24,-26>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,24,-30>, <-16,24,-26>, <16,24,-26> }
		triangle { <16,24,-26>, <20,24,-30>, <-20,24,-30> }
		triangle { <20,24,-30>, <16,24,-26>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-30> }
		triangle { <16,4,6>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,4,6>, <16,4,6> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <16,24,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,24,6>, <16,24,6> }
		triangle { <16,24,-26>, <16,20,-26>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <16,24,-26> }
		triangle { <20,24,-30>, <20,20,-30>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <20,24,-30> }
		triangle { <20,24,10>, <20,0,10>, <20,20,-30> }
		triangle { <20,20,-30>, <20,24,-30>, <20,24,10> }
		triangle { <20,0,10>, <20,0,-10>, <20,20,-30> }
		triangle { <16,24,6>, <16,4,6>, <16,20,-26> }
		triangle { <16,20,-26>, <16,24,-26>, <16,24,6> }
		triangle { <16,4,6>, <16,4,-10>, <16,20,-26> }
		triangle { <-16,24,6>, <-16,4,6>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <-16,24,6> }
		triangle { <-16,4,6>, <-16,4,-10>, <-16,20,-26> }
		triangle { <-20,24,10>, <-20,0,10>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-20,20,-30> }
		triangle { <16,20,-26>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,20,-26>, <16,20,-26> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
// /3039-4t Slope Brick 45  2 x  2 without sloped front
	#end
}
#end

#declare _2420_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <30,8,30> } #else #if (STUDS) union #else object #end {
// Plate  2 x  2 Corner
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,10,4,0> }
	#end
	mesh {
		triangle { <10,8,30>, <6,8,26>, <-6,8,26> }
		triangle { <-6,8,26>, <-10,8,30>, <10,8,30> }
		triangle { <-10,8,30>, <-6,8,26>, <-6,8,-6> }
		triangle { <-6,8,-6>, <-10,8,-10>, <-10,8,30> }
		triangle { <-10,8,-10>, <-6,8,-6>, <26,8,-6> }
		triangle { <26,8,-6>, <30,8,-10>, <-10,8,-10> }
		triangle { <30,8,-10>, <26,8,-6>, <26,8,6> }
		triangle { <26,8,6>, <30,8,10>, <30,8,-10> }
		triangle { <30,8,10>, <26,8,6>, <6,8,6> }
		triangle { <6,8,6>, <10,8,10>, <30,8,10> }
		triangle { <10,8,10>, <6,8,6>, <6,8,26> }
		triangle { <6,8,26>, <10,8,30>, <10,8,10> }
		triangle { <26,4,6>, <-6,4,6>, <-6,4,-6> }
		triangle { <-6,4,-6>, <26,4,-6>, <26,4,6> }
		triangle { <6,4,26>, <6,4,6>, <-6,4,6> }
		triangle { <-6,4,6>, <-6,4,26>, <6,4,26> }
		triangle { <30,0,10>, <-10,0,10>, <-10,0,-10> }
		triangle { <-10,0,-10>, <30,0,-10>, <30,0,10> }
		triangle { <10,0,30>, <10,0,10>, <-10,0,10> }
		triangle { <-10,0,10>, <-10,0,30>, <10,0,30> }
		triangle { <10,8,30>, <-10,8,30>, <-10,0,30> }
		triangle { <-10,0,30>, <10,0,30>, <10,8,30> }
		triangle { <-10,8,30>, <-10,8,-10>, <-10,0,-10> }
		triangle { <-10,0,-10>, <-10,0,30>, <-10,8,30> }
		triangle { <-10,8,-10>, <30,8,-10>, <30,0,-10> }
		triangle { <30,0,-10>, <-10,0,-10>, <-10,8,-10> }
		triangle { <30,8,-10>, <30,8,10>, <30,0,10> }
		triangle { <30,0,10>, <30,0,-10>, <30,8,-10> }
		triangle { <30,8,10>, <10,8,10>, <10,0,10> }
		triangle { <10,0,10>, <30,0,10>, <30,8,10> }
		triangle { <10,8,10>, <10,8,30>, <10,0,30> }
		triangle { <10,0,30>, <10,0,10>, <10,8,10> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,20,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,20> }
	#end
}
#end

#declare _3460_dot_dat = #if (QUAL = 0) box { <-80,-4,-10>, <80,8,10> } #else union {
// Plate  1 x  8
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <80,8,10>, <76,8,6>, <-76,8,6> }
		triangle { <-76,8,6>, <-80,8,10>, <80,8,10> }
		triangle { <-80,8,10>, <-76,8,6>, <-76,8,-6> }
		triangle { <-76,8,-6>, <-80,8,-10>, <-80,8,10> }
		triangle { <-80,8,-10>, <-76,8,-6>, <76,8,-6> }
		triangle { <76,8,-6>, <80,8,-10>, <-80,8,-10> }
		triangle { <80,8,-10>, <76,8,-6>, <76,8,6> }
		triangle { <76,8,6>, <80,8,10>, <80,8,-10> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-8,0,0,0,10,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
	#end
}
#end

#declare _2730_dot_dat = #if (QUAL = 0) box { <-100,-4,-10>, <100,24,10> } #else union {
// Technic Brick  1 x 10 with Holes
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,80,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,60,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,40,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,20,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,0,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-20,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-40,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-60,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-80,18,0> }
	#end
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,80,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,80,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,60,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,60,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,40,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,40,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,20,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,20,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,0,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,0,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-20,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-20,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-40,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-40,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-60,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-60,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-80,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-80,10,-10> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,70,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,50,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,30,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,10,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-10,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-30,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-50,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-70,4,0> }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,6,92,4,0> }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,6,-92,4,0> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,80,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,60,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,40,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,20,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,0,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-20,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-40,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-60,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-80,10,6> }
	mesh {
		triangle { <88,10,6>, <88,4,6>, <88,4,-6> }
		triangle { <88,4,-6>, <88,10,-6>, <88,10,6> }
		triangle { <72,10,6>, <72,4,6>, <72,4,-6> }
		triangle { <72,4,-6>, <72,10,-6>, <72,10,6> }
		triangle { <68,10,6>, <68,4,6>, <68,4,-6> }
		triangle { <68,4,-6>, <68,10,-6>, <68,10,6> }
		triangle { <52,10,6>, <52,4,6>, <52,4,-6> }
		triangle { <52,4,-6>, <52,10,-6>, <52,10,6> }
		triangle { <48,10,6>, <48,4,6>, <48,4,-6> }
		triangle { <48,4,-6>, <48,10,-6>, <48,10,6> }
		triangle { <32,10,6>, <32,4,6>, <32,4,-6> }
		triangle { <32,4,-6>, <32,10,-6>, <32,10,6> }
		triangle { <28,10,6>, <28,4,6>, <28,4,-6> }
		triangle { <28,4,-6>, <28,10,-6>, <28,10,6> }
		triangle { <12,10,6>, <12,4,6>, <12,4,-6> }
		triangle { <12,4,-6>, <12,10,-6>, <12,10,6> }
		triangle { <8,10,6>, <8,4,6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,10,-6>, <8,10,6> }
		triangle { <-8,10,6>, <-8,4,6>, <-8,4,-6> }
		triangle { <-8,4,-6>, <-8,10,-6>, <-8,10,6> }
		triangle { <-12,10,6>, <-12,4,6>, <-12,4,-6> }
		triangle { <-12,4,-6>, <-12,10,-6>, <-12,10,6> }
		triangle { <-28,10,6>, <-28,4,6>, <-28,4,-6> }
		triangle { <-28,4,-6>, <-28,10,-6>, <-28,10,6> }
		triangle { <-32,10,6>, <-32,4,6>, <-32,4,-6> }
		triangle { <-32,4,-6>, <-32,10,-6>, <-32,10,6> }
		triangle { <-48,10,6>, <-48,4,6>, <-48,4,-6> }
		triangle { <-48,4,-6>, <-48,10,-6>, <-48,10,6> }
		triangle { <-52,10,6>, <-52,4,6>, <-52,4,-6> }
		triangle { <-52,4,-6>, <-52,10,-6>, <-52,10,6> }
		triangle { <-68,10,6>, <-68,4,6>, <-68,4,-6> }
		triangle { <-68,4,-6>, <-68,10,-6>, <-68,10,6> }
		triangle { <-72,10,6>, <-72,4,6>, <-72,4,-6> }
		triangle { <-72,4,-6>, <-72,10,-6>, <-72,10,6> }
		triangle { <-88,10,6>, <-88,4,6>, <-88,4,-6> }
		triangle { <-88,4,-6>, <-88,10,-6>, <-88,10,6> }
		triangle { <96,24,6>, <96,4,6>, <96,4,-6> }
		triangle { <96,4,-6>, <96,24,-6>, <96,24,6> }
		triangle { <-96,24,6>, <-96,4,6>, <-96,4,-6> }
		triangle { <-96,4,-6>, <-96,24,-6>, <-96,24,6> }
	}
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,-6> }
	mesh {
		triangle { <72,18,6>, <72,4,6>, <68,4,6> }
		triangle { <68,4,6>, <68,18,6>, <72,18,6> }
		triangle { <72,18,-6>, <72,4,-6>, <68,4,-6> }
		triangle { <68,4,-6>, <68,18,-6>, <72,18,-6> }
		triangle { <52,18,6>, <52,4,6>, <48,4,6> }
		triangle { <48,4,6>, <48,18,6>, <52,18,6> }
		triangle { <52,18,-6>, <52,4,-6>, <48,4,-6> }
		triangle { <48,4,-6>, <48,18,-6>, <52,18,-6> }
		triangle { <32,18,6>, <32,4,6>, <28,4,6> }
		triangle { <28,4,6>, <28,18,6>, <32,18,6> }
		triangle { <32,18,-6>, <32,4,-6>, <28,4,-6> }
		triangle { <28,4,-6>, <28,18,-6>, <32,18,-6> }
		triangle { <12,18,6>, <12,4,6>, <8,4,6> }
		triangle { <8,4,6>, <8,18,6>, <12,18,6> }
		triangle { <12,18,-6>, <12,4,-6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,18,-6>, <12,18,-6> }
		triangle { <-8,18,6>, <-8,4,6>, <-12,4,6> }
		triangle { <-12,4,6>, <-12,18,6>, <-8,18,6> }
		triangle { <-8,18,-6>, <-8,4,-6>, <-12,4,-6> }
		triangle { <-12,4,-6>, <-12,18,-6>, <-8,18,-6> }
		triangle { <-28,18,6>, <-28,4,6>, <-32,4,6> }
		triangle { <-32,4,6>, <-32,18,6>, <-28,18,6> }
		triangle { <-28,18,-6>, <-28,4,-6>, <-32,4,-6> }
		triangle { <-32,4,-6>, <-32,18,-6>, <-28,18,-6> }
		triangle { <-48,18,6>, <-48,4,6>, <-52,4,6> }
		triangle { <-52,4,6>, <-52,18,6>, <-48,18,6> }
		triangle { <-48,18,-6>, <-48,4,-6>, <-52,4,-6> }
		triangle { <-52,4,-6>, <-52,18,-6>, <-48,18,-6> }
		triangle { <-68,18,6>, <-68,4,6>, <-72,4,6> }
		triangle { <-72,4,6>, <-72,18,6>, <-68,18,6> }
		triangle { <-68,18,-6>, <-68,4,-6>, <-72,4,-6> }
		triangle { <-72,4,-6>, <-72,18,-6>, <-68,18,-6> }
		triangle { <96,24,6>, <96,4,6>, <88,4,6> }
		triangle { <88,4,6>, <88,18,6>, <96,24,6> }
		triangle { <96,24,-6>, <96,4,-6>, <88,4,-6> }
		triangle { <88,4,-6>, <88,18,-6>, <96,24,-6> }
		triangle { <-88,18,6>, <-88,4,6>, <-96,4,6> }
		triangle { <-96,4,6>, <-96,24,6>, <-88,18,6> }
		triangle { <-88,18,-6>, <-88,4,-6>, <-96,4,-6> }
		triangle { <-96,4,-6>, <-96,24,-6>, <-88,18,-6> }
		triangle { <96,24,6>, <88,18,6>, <-88,18,6> }
		triangle { <-88,18,6>, <-96,24,6>, <96,24,6> }
		triangle { <96,24,-6>, <88,18,-6>, <-88,18,-6> }
		triangle { <-88,18,-6>, <-96,24,-6>, <96,24,-6> }
		triangle { <100,24,10>, <96,24,6>, <-96,24,6> }
		triangle { <-96,24,6>, <-100,24,10>, <100,24,10> }
		triangle { <100,24,-10>, <96,24,-6>, <-96,24,-6> }
		triangle { <-96,24,-6>, <-100,24,-10>, <100,24,-10> }
		triangle { <100,24,10>, <96,24,6>, <96,24,-6> }
		triangle { <96,24,-6>, <100,24,-10>, <100,24,10> }
		triangle { <-100,24,10>, <-96,24,6>, <-96,24,-6> }
		triangle { <-96,24,-6>, <-100,24,-10>, <-100,24,10> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,80,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,60,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,40,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,20,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,0,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-20,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-40,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-60,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-80,10,8> }
	mesh {
		triangle { <100,24,10>, <100,0,10>, <100,0,-10> }
		triangle { <100,0,-10>, <100,24,-10>, <100,24,10> }
		triangle { <-100,24,10>, <-100,0,10>, <-100,0,-10> }
		triangle { <-100,0,-10>, <-100,24,-10>, <-100,24,10> }
		triangle { <100,0,10>, <100,0,-10>, <-100,0,-10> }
		triangle { <-100,0,-10>, <-100,0,10>, <100,0,10> }
	}
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,-10> }
	mesh {
		triangle { <72,18,10>, <72,2,10>, <68,2,10> }
		triangle { <68,2,10>, <68,18,10>, <72,18,10> }
		triangle { <72,18,-10>, <72,2,-10>, <68,2,-10> }
		triangle { <68,2,-10>, <68,18,-10>, <72,18,-10> }
		triangle { <52,18,10>, <52,2,10>, <48,2,10> }
		triangle { <48,2,10>, <48,18,10>, <52,18,10> }
		triangle { <52,18,-10>, <52,2,-10>, <48,2,-10> }
		triangle { <48,2,-10>, <48,18,-10>, <52,18,-10> }
		triangle { <32,18,10>, <32,2,10>, <28,2,10> }
		triangle { <28,2,10>, <28,18,10>, <32,18,10> }
		triangle { <32,18,-10>, <32,2,-10>, <28,2,-10> }
		triangle { <28,2,-10>, <28,18,-10>, <32,18,-10> }
		triangle { <12,18,10>, <12,2,10>, <8,2,10> }
		triangle { <8,2,10>, <8,18,10>, <12,18,10> }
		triangle { <12,18,-10>, <12,2,-10>, <8,2,-10> }
		triangle { <8,2,-10>, <8,18,-10>, <12,18,-10> }
		triangle { <-8,18,10>, <-8,2,10>, <-12,2,10> }
		triangle { <-12,2,10>, <-12,18,10>, <-8,18,10> }
		triangle { <-8,18,-10>, <-8,2,-10>, <-12,2,-10> }
		triangle { <-12,2,-10>, <-12,18,-10>, <-8,18,-10> }
		triangle { <-28,18,10>, <-28,2,10>, <-32,2,10> }
		triangle { <-32,2,10>, <-32,18,10>, <-28,18,10> }
		triangle { <-28,18,-10>, <-28,2,-10>, <-32,2,-10> }
		triangle { <-32,2,-10>, <-32,18,-10>, <-28,18,-10> }
		triangle { <-48,18,10>, <-48,2,10>, <-52,2,10> }
		triangle { <-52,2,10>, <-52,18,10>, <-48,18,10> }
		triangle { <-48,18,-10>, <-48,2,-10>, <-52,2,-10> }
		triangle { <-52,2,-10>, <-52,18,-10>, <-48,18,-10> }
		triangle { <-68,18,10>, <-68,2,10>, <-72,2,10> }
		triangle { <-72,2,10>, <-72,18,10>, <-68,18,10> }
		triangle { <-68,18,-10>, <-68,2,-10>, <-72,2,-10> }
		triangle { <-72,2,-10>, <-72,18,-10>, <-68,18,-10> }
		triangle { <100,24,10>, <88,18,10>, <-88,18,10> }
		triangle { <-88,18,10>, <-100,24,10>, <100,24,10> }
		triangle { <100,24,-10>, <88,18,-10>, <-88,18,-10> }
		triangle { <-88,18,-10>, <-100,24,-10>, <100,24,-10> }
		triangle { <100,0,10>, <88,2,10>, <-88,2,10> }
		triangle { <-88,2,10>, <-100,0,10>, <100,0,10> }
		triangle { <100,0,-10>, <88,2,-10>, <-88,2,-10> }
		triangle { <-88,2,-10>, <-100,0,-10>, <100,0,-10> }
		triangle { <100,24,10>, <88,18,10>, <88,2,10> }
		triangle { <88,2,10>, <100,0,10>, <100,24,10> }
		triangle { <100,24,-10>, <88,18,-10>, <88,2,-10> }
		triangle { <88,2,-10>, <100,0,-10>, <100,24,-10> }
		triangle { <-100,24,10>, <-88,18,10>, <-88,2,10> }
		triangle { <-88,2,10>, <-100,0,10>, <-100,24,10> }
		triangle { <-100,24,-10>, <-88,18,-10>, <-88,2,-10> }
		triangle { <-88,2,-10>, <-100,0,-10>, <-100,24,-10> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,0> }
	#end
}
#end

#declare box4_dash_1_dot_dat = object {
// Box, 4 faces drawn, 1 edge left out
	mesh {
		triangle { <1,1,1>, <1,1,-1>, <-1,1,-1> }
		triangle { <-1,1,-1>, <-1,1,1>, <1,1,1> }
		triangle { <1,1,1>, <1,0,1>, <-1,0,1> }
		triangle { <-1,0,1>, <-1,1,1>, <1,1,1> }
		triangle { <-1,1,1>, <-1,0,1>, <-1,0,-1> }
		triangle { <-1,0,-1>, <-1,1,-1>, <-1,1,1> }
		triangle { <1,1,-1>, <1,0,-1>, <1,0,1> }
		triangle { <1,0,1>, <1,1,1>, <1,1,-1> }
	}
}

#declare _3004p05_dot_dat = #if (QUAL = 0) box { <-20,-4,-10>, <20,24,10> } #else union {
// Brick  1 x  2 with Yellow Grille Pattern
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { box4_dash_1_dot_dat matrix <20,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
	#end
	mesh {
		triangle { <-20,0,-10>, <20,0,-10>, <20,2.75,-10> }
		triangle { <20,2.75,-10>, <-20,2.75,-10>, <-20,0,-10> }
		triangle { <-20,21.25,-10>, <-20,2.75,-10>, <-16.25,2.75,-10> }
		triangle { <-16.25,2.75,-10>, <-16.25,21.25,-10>, <-20,21.25,-10> }
	}
	mesh {
		triangle { <-16.25,21.25,-10>, <-16.25,2.75,-10>, <-13.75,2.75,-10> }
		triangle { <-13.75,2.75,-10>, <-13.75,21.25,-10>, <-16.25,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-13.75,21.25,-10>, <-13.75,2.75,-10>, <-11.25,2.75,-10> }
		triangle { <-11.25,2.75,-10>, <-11.25,21.25,-10>, <-13.75,21.25,-10> }
	}
	mesh {
		triangle { <-11.25,21.25,-10>, <-11.25,2.75,-10>, <-8.75,2.75,-10> }
		triangle { <-8.75,2.75,-10>, <-8.75,21.25,-10>, <-11.25,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-8.75,21.25,-10>, <-8.75,2.75,-10>, <-6.25,2.75,-10> }
		triangle { <-6.25,2.75,-10>, <-6.25,21.25,-10>, <-8.75,21.25,-10> }
	}
	mesh {
		triangle { <-6.25,21.25,-10>, <-6.25,2.75,-10>, <-3.75,2.75,-10> }
		triangle { <-3.75,2.75,-10>, <-3.75,21.25,-10>, <-6.25,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-3.75,21.25,-10>, <-3.75,2.75,-10>, <-1.25,2.75,-10> }
		triangle { <-1.25,2.75,-10>, <-1.25,21.25,-10>, <-3.75,21.25,-10> }
	}
	mesh {
		triangle { <-1.25,21.25,-10>, <-1.25,2.75,-10>, <1.25,2.75,-10> }
		triangle { <1.25,2.75,-10>, <1.25,21.25,-10>, <-1.25,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <1.25,21.25,-10>, <1.25,2.75,-10>, <3.75,2.75,-10> }
		triangle { <3.75,2.75,-10>, <3.75,21.25,-10>, <1.25,21.25,-10> }
	}
	mesh {
		triangle { <3.75,21.25,-10>, <3.75,2.75,-10>, <6.25,2.75,-10> }
		triangle { <6.25,2.75,-10>, <6.25,21.25,-10>, <3.75,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <6.25,21.25,-10>, <6.25,2.75,-10>, <8.75,2.75,-10> }
		triangle { <8.75,2.75,-10>, <8.75,21.25,-10>, <6.25,21.25,-10> }
	}
	mesh {
		triangle { <8.75,21.25,-10>, <8.75,2.75,-10>, <11.25,2.75,-10> }
		triangle { <11.25,2.75,-10>, <11.25,21.25,-10>, <8.75,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <11.25,21.25,-10>, <11.25,2.75,-10>, <13.75,2.75,-10> }
		triangle { <13.75,2.75,-10>, <13.75,21.25,-10>, <11.25,21.25,-10> }
	}
	mesh {
		triangle { <13.75,21.25,-10>, <13.75,2.75,-10>, <16.25,2.75,-10> }
		triangle { <16.25,2.75,-10>, <16.25,21.25,-10>, <13.75,21.25,-10> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <16.25,21.25,-10>, <16.25,2.75,-10>, <20,2.75,-10> }
		triangle { <20,2.75,-10>, <20,21.25,-10>, <16.25,21.25,-10> }
		triangle { <-20,21.25,-10>, <20,21.25,-10>, <20,24,-10> }
		triangle { <20,24,-10>, <-20,24,-10>, <-20,21.25,-10> }
	}
}
#end

#declare _2_dash_4disc_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 1
		clipped_by { box { <-2,-1,0>, <2,1,2> } }
	}
#else
	cylinder {
		<0,-0.001,0>, <0,0.001,0>, 1
		clipped_by { box { <-2,-1,0>, <2,1,2> } }
	}
#end

#declare _2412_dot_dat = #if (QUAL = 0) box { <-20,0,-10>, <20,8,10> } #else union {
// Tile  1 x  2 Grille
	object { _2_dash_4disc_dot_dat matrix <0,0,1,0,1,0,1,0,0,3,8,0> }
	object { _2_dash_4disc_dot_dat matrix <0,0,1,0,1,0,-1,0,0,-3,8,0> }
	object { _2_dash_4cyli_dot_dat matrix <0,0,1,0,4,0,1,0,0,3,4,0> }
	object { _2_dash_4cyli_dot_dat matrix <0,0,1,0,4,0,-1,0,0,-3,4,0> }
	mesh {
		triangle { <3,8,1>, <3,8,-1>, <-3,8,-1> }
		triangle { <-3,8,-1>, <-3,8,1>, <3,8,1> }
		triangle { <3,8,1>, <3,4,1>, <-3,4,1> }
		triangle { <-3,4,1>, <-3,8,1>, <3,8,1> }
		triangle { <3,8,-1>, <3,4,-1>, <-3,4,-1> }
		triangle { <-3,4,-1>, <-3,8,-1>, <3,8,-1> }
		triangle { <20,8,10>, <-20,8,10>, <-20,8,6> }
		triangle { <-20,8,6>, <20,8,6>, <20,8,10> }
		triangle { <20,8,-10>, <-20,8,-10>, <-20,8,-6> }
		triangle { <-20,8,-6>, <20,8,-6>, <20,8,-10> }
		triangle { <20,8,6>, <16,8,6>, <16,8,-6> }
		triangle { <16,8,-6>, <20,8,-6>, <20,8,6> }
		triangle { <-20,8,6>, <-16,8,6>, <-16,8,-6> }
		triangle { <-16,8,-6>, <-20,8,-6>, <-20,8,6> }
		triangle { <20,8,10>, <20,4,10>, <20,4,-10> }
		triangle { <20,4,-10>, <20,8,-10>, <20,8,10> }
		triangle { <-20,8,10>, <-20,4,10>, <-20,4,-10> }
		triangle { <-20,4,-10>, <-20,8,-10>, <-20,8,10> }
		triangle { <16,8,6>, <16,4,6>, <16,4,-6> }
		triangle { <16,4,-6>, <16,8,-6>, <16,8,6> }
		triangle { <-16,8,6>, <-16,4,6>, <-16,4,-6> }
		triangle { <-16,4,-6>, <-16,8,-6>, <-16,8,6> }
		triangle { <20,4,10>, <20,0,10>, <20,0,6> }
		triangle { <20,0,6>, <20,4,6>, <20,4,10> }
		triangle { <-20,4,10>, <-20,0,10>, <-20,0,6> }
		triangle { <-20,0,6>, <-20,4,6>, <-20,4,10> }
		triangle { <20,4,2>, <20,0,2>, <20,0,-2> }
		triangle { <20,0,-2>, <20,4,-2>, <20,4,2> }
		triangle { <-20,4,2>, <-20,0,2>, <-20,0,-2> }
		triangle { <-20,0,-2>, <-20,4,-2>, <-20,4,2> }
		triangle { <20,4,-6>, <20,0,-6>, <20,0,-10> }
		triangle { <20,0,-10>, <20,4,-10>, <20,4,-6> }
		triangle { <-20,4,-6>, <-20,0,-6>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,4,-10>, <-20,4,-6> }
		triangle { <20,4,6>, <16,4,6>, <16,4,-6> }
		triangle { <16,4,-6>, <20,4,-6>, <20,4,6> }
		triangle { <-20,4,6>, <-16,4,6>, <-16,4,-6> }
		triangle { <-16,4,-6>, <-20,4,-6>, <-20,4,6> }
		triangle { <16,4,2>, <-16,4,2>, <-16,4,-2> }
		triangle { <-16,4,-2>, <16,4,-2>, <16,4,2> }
		triangle { <20,8,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,8,10>, <20,8,10> }
		triangle { <20,8,6>, <20,0,6>, <-20,0,6> }
		triangle { <-20,0,6>, <-20,8,6>, <20,8,6> }
		triangle { <20,4,2>, <20,0,2>, <-20,0,2> }
		triangle { <-20,0,2>, <-20,4,2>, <20,4,2> }
		triangle { <20,4,-2>, <20,0,-2>, <-20,0,-2> }
		triangle { <-20,0,-2>, <-20,4,-2>, <20,4,-2> }
		triangle { <20,8,-6>, <20,0,-6>, <-20,0,-6> }
		triangle { <-20,0,-6>, <-20,8,-6>, <20,8,-6> }
		triangle { <20,8,-10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,8,-10>, <20,8,-10> }
		triangle { <20,0,10>, <-20,0,10>, <-20,0,6> }
		triangle { <-20,0,6>, <20,0,6>, <20,0,10> }
		triangle { <20,0,2>, <-20,0,2>, <-20,0,-2> }
		triangle { <-20,0,-2>, <20,0,-2>, <20,0,2> }
		triangle { <20,0,-6>, <-20,0,-6>, <-20,0,-10> }
		triangle { <-20,0,-10>, <20,0,-10>, <20,0,-6> }
	}
}
#end

#declare _3308_dot_dat = #if (QUAL = 0) box { <-80,-4,-10>, <80,48.11,10> } #else union {
// Arch  1 x  8 x  2
	object { box5_dot_dat matrix <6,0,0,0,-44,0,0,0,6,70,48,0> }
	object { box5_dot_dat matrix <6,0,0,0,-44,0,0,0,6,-70,48,0> }
	mesh {
		triangle { <80,48,10>, <76,48,6>, <64,48,6> }
		triangle { <64,48,6>, <60,48,10>, <80,48,10> }
		triangle { <60,48,10>, <64,48,6>, <64,48,-6> }
		triangle { <64,48,-6>, <60,48,-10>, <60,48,10> }
		triangle { <60,48,-10>, <64,48,-6>, <76,48,-6> }
		triangle { <76,48,-6>, <80,48,-10>, <60,48,-10> }
		triangle { <80,48,-10>, <76,48,-6>, <76,48,6> }
		triangle { <76,48,6>, <80,48,10>, <80,48,-10> }
		triangle { <-80,48,10>, <-76,48,6>, <-64,48,6> }
		triangle { <-64,48,6>, <-60,48,10>, <-80,48,10> }
		triangle { <-60,48,10>, <-64,48,6>, <-64,48,-6> }
		triangle { <-64,48,-6>, <-60,48,-10>, <-60,48,10> }
		triangle { <-60,48,-10>, <-64,48,-6>, <-76,48,-6> }
		triangle { <-76,48,-6>, <-80,48,-10>, <-60,48,-10> }
		triangle { <-80,48,-10>, <-76,48,-6>, <-76,48,6> }
		triangle { <-76,48,6>, <-80,48,10>, <-80,48,-10> }
	}
	object { rect_dot_dat matrix <60,0,0,0,1,0,0,0,6,0,4,0> }
	mesh {
		triangle { <60,8,10>, <60.02,48.11,10>, <54.02,36.87,10> }
		triangle { <60,8,6>, <60.02,48.11,6>, <54.02,36.87,6> }
		triangle { <60,8,-6>, <60.02,48.11,-6>, <54.02,36.87,-6> }
		triangle { <60,8,-10>, <60.02,48.11,-10>, <54.02,36.87,-10> }
		triangle { <60,8,10>, <54.02,36.87,10>, <45.94,27.03,10> }
		triangle { <60,8,6>, <54.02,36.87,6>, <45.94,27.03,6> }
		triangle { <60,8,-6>, <54.02,36.87,-6>, <45.94,27.03,-6> }
		triangle { <60,8,-10>, <54.02,36.87,-10>, <45.94,27.03,-10> }
		triangle { <60,8,10>, <45.94,27.03,10>, <36.1,18.95,10> }
		triangle { <60,8,6>, <45.94,27.03,6>, <36.1,18.95,6> }
		triangle { <60,8,-6>, <45.94,27.03,-6>, <36.1,18.95,-6> }
		triangle { <60,8,-10>, <45.94,27.03,-10>, <36.1,18.95,-10> }
		triangle { <60,8,10>, <36.1,18.95,10>, <24.86,12.95,10> }
		triangle { <60,8,6>, <36.1,18.95,6>, <24.86,12.95,6> }
		triangle { <60,8,-6>, <36.1,18.95,-6>, <24.86,12.95,-6> }
		triangle { <60,8,-10>, <36.1,18.95,-10>, <24.86,12.95,-10> }
		triangle { <60,8,10>, <24.86,12.95,10>, <12.68,9.25,10> }
		triangle { <60,8,6>, <24.86,12.95,6>, <12.68,9.25,6> }
		triangle { <60,8,-6>, <24.86,12.95,-6>, <12.68,9.25,-6> }
		triangle { <60,8,-10>, <24.86,12.95,-10>, <12.68,9.25,-10> }
		triangle { <60,8,10>, <12.68,9.25,10>, <0,8,10> }
		triangle { <60,8,6>, <12.68,9.25,6>, <0,8,6> }
		triangle { <60,8,-6>, <12.68,9.25,-6>, <0,8,-6> }
		triangle { <60,8,-10>, <12.68,9.25,-10>, <0,8,-10> }
		triangle { <-60,8,10>, <0,8,10>, <-12.68,9.25,10> }
		triangle { <-60,8,6>, <0,8,6>, <-12.68,9.25,6> }
		triangle { <-60,8,-6>, <0,8,-6>, <-12.68,9.25,-6> }
		triangle { <-60,8,-10>, <0,8,-10>, <-12.68,9.25,-10> }
		triangle { <-60,8,10>, <-12.68,9.25,10>, <-24.86,12.95,10> }
		triangle { <-60,8,6>, <-12.68,9.25,6>, <-24.86,12.95,6> }
		triangle { <-60,8,-6>, <-12.68,9.25,-6>, <-24.86,12.95,-6> }
		triangle { <-60,8,-10>, <-12.68,9.25,-10>, <-24.86,12.95,-10> }
		triangle { <-60,8,10>, <-24.86,12.95,10>, <-36.1,18.95,10> }
		triangle { <-60,8,6>, <-24.86,12.95,6>, <-36.1,18.95,6> }
		triangle { <-60,8,-6>, <-24.86,12.95,-6>, <-36.1,18.95,-6> }
		triangle { <-60,8,-10>, <-24.86,12.95,-10>, <-36.1,18.95,-10> }
		triangle { <-60,8,10>, <-36.1,18.95,10>, <-45.94,27.03,10> }
		triangle { <-60,8,6>, <-36.1,18.95,6>, <-45.94,27.03,6> }
		triangle { <-60,8,-6>, <-36.1,18.95,-6>, <-45.94,27.03,-6> }
		triangle { <-60,8,-10>, <-36.1,18.95,-10>, <-45.94,27.03,-10> }
		triangle { <-60,8,10>, <-45.94,27.03,10>, <-54.02,36.87,10> }
		triangle { <-60,8,6>, <-45.94,27.03,6>, <-54.02,36.87,6> }
		triangle { <-60,8,-6>, <-45.94,27.03,-6>, <-54.02,36.87,-6> }
		triangle { <-60,8,-10>, <-45.94,27.03,-10>, <-54.02,36.87,-10> }
		triangle { <-60,8,10>, <-54.02,36.87,10>, <-60.02,48.11,10> }
		triangle { <-60,8,6>, <-54.02,36.87,6>, <-60.02,48.11,6> }
		triangle { <-60,8,-6>, <-54.02,36.87,-6>, <-60.02,48.11,-6> }
		triangle { <-60,8,-10>, <-54.02,36.87,-10>, <-60.02,48.11,-10> }
		triangle { <60.02,48.11,10>, <54.02,36.87,10>, <54.02,36.87,6> }
		triangle { <54.02,36.87,6>, <60.02,48.11,6>, <60.02,48.11,10> }
		triangle { <60.02,48.11,-10>, <54.02,36.87,-10>, <54.02,36.87,-6> }
		triangle { <54.02,36.87,-6>, <60.02,48.11,-6>, <60.02,48.11,-10> }
		triangle { <54.02,36.87,10>, <45.94,27.03,10>, <45.94,27.03,6> }
		triangle { <45.94,27.03,6>, <54.02,36.87,6>, <54.02,36.87,10> }
		triangle { <54.02,36.87,-10>, <45.94,27.03,-10>, <45.94,27.03,-6> }
		triangle { <45.94,27.03,-6>, <54.02,36.87,-6>, <54.02,36.87,-10> }
		triangle { <45.94,27.03,10>, <36.1,18.95,10>, <36.1,18.95,6> }
		triangle { <36.1,18.95,6>, <45.94,27.03,6>, <45.94,27.03,10> }
		triangle { <45.94,27.03,-10>, <36.1,18.95,-10>, <36.1,18.95,-6> }
		triangle { <36.1,18.95,-6>, <45.94,27.03,-6>, <45.94,27.03,-10> }
		triangle { <36.1,18.95,10>, <24.86,12.95,10>, <24.86,12.95,6> }
		triangle { <24.86,12.95,6>, <36.1,18.95,6>, <36.1,18.95,10> }
		triangle { <36.1,18.95,-10>, <24.86,12.95,-10>, <24.86,12.95,-6> }
		triangle { <24.86,12.95,-6>, <36.1,18.95,-6>, <36.1,18.95,-10> }
		triangle { <24.86,12.95,10>, <12.68,9.25,10>, <12.68,9.25,6> }
		triangle { <12.68,9.25,6>, <24.86,12.95,6>, <24.86,12.95,10> }
		triangle { <24.86,12.95,-10>, <12.68,9.25,-10>, <12.68,9.25,-6> }
		triangle { <12.68,9.25,-6>, <24.86,12.95,-6>, <24.86,12.95,-10> }
		triangle { <12.68,9.25,10>, <0,8,10>, <0,8,6> }
		triangle { <0,8,6>, <12.68,9.25,6>, <12.68,9.25,10> }
		triangle { <12.68,9.25,-10>, <0,8,-10>, <0,8,-6> }
		triangle { <0,8,-6>, <12.68,9.25,-6>, <12.68,9.25,-10> }
		triangle { <0,8,10>, <-12.68,9.25,10>, <-12.68,9.25,6> }
		triangle { <-12.68,9.25,6>, <0,8,6>, <0,8,10> }
		triangle { <0,8,-10>, <-12.68,9.25,-10>, <-12.68,9.25,-6> }
		triangle { <-12.68,9.25,-6>, <0,8,-6>, <0,8,-10> }
		triangle { <-12.68,9.25,10>, <-24.86,12.95,10>, <-24.86,12.95,6> }
		triangle { <-24.86,12.95,6>, <-12.68,9.25,6>, <-12.68,9.25,10> }
		triangle { <-12.68,9.25,-10>, <-24.86,12.95,-10>, <-24.86,12.95,-6> }
		triangle { <-24.86,12.95,-6>, <-12.68,9.25,-6>, <-12.68,9.25,-10> }
		triangle { <-24.86,12.95,10>, <-36.1,18.95,10>, <-36.1,18.95,6> }
		triangle { <-36.1,18.95,6>, <-24.86,12.95,6>, <-24.86,12.95,10> }
		triangle { <-24.86,12.95,-10>, <-36.1,18.95,-10>, <-36.1,18.95,-6> }
		triangle { <-36.1,18.95,-6>, <-24.86,12.95,-6>, <-24.86,12.95,-10> }
		triangle { <-36.1,18.95,10>, <-45.94,27.03,10>, <-45.94,27.03,6> }
		triangle { <-45.94,27.03,6>, <-36.1,18.95,6>, <-36.1,18.95,10> }
		triangle { <-36.1,18.95,-10>, <-45.94,27.03,-10>, <-45.94,27.03,-6> }
		triangle { <-45.94,27.03,-6>, <-36.1,18.95,-6>, <-36.1,18.95,-10> }
		triangle { <-45.94,27.03,10>, <-54.02,36.87,10>, <-54.02,36.87,6> }
		triangle { <-54.02,36.87,6>, <-45.94,27.03,6>, <-45.94,27.03,10> }
		triangle { <-45.94,27.03,-10>, <-54.02,36.87,-10>, <-54.02,36.87,-6> }
		triangle { <-54.02,36.87,-6>, <-45.94,27.03,-6>, <-45.94,27.03,-10> }
		triangle { <-54.02,36.87,10>, <-60.02,48.11,10>, <-60.02,48.11,6> }
		triangle { <-60.02,48.11,6>, <-54.02,36.87,6>, <-54.02,36.87,10> }
		triangle { <-54.02,36.87,-10>, <-60.02,48.11,-10>, <-60.02,48.11,-6> }
		triangle { <-60.02,48.11,-6>, <-54.02,36.87,-6>, <-54.02,36.87,-10> }
		triangle { <-60,48,6>, <-60,4,6>, <-60,4,-6> }
		triangle { <-60,4,-6>, <-60,48,-6>, <-60,48,6> }
		triangle { <60,48,6>, <60,4,6>, <60,4,-6> }
		triangle { <60,4,-6>, <60,48,-6>, <60,48,6> }
		triangle { <60,8,6>, <60,4,6>, <-60,4,6> }
		triangle { <-60,4,6>, <-60,8,6>, <60,8,6> }
		triangle { <60,8,-6>, <60,4,-6>, <-60,4,-6> }
		triangle { <-60,4,-6>, <-60,8,-6>, <60,8,-6> }
		triangle { <-80,0,10>, <-60,8,10>, <-60,48,10> }
		triangle { <-60,48,10>, <-80,48,10>, <-80,0,10> }
		triangle { <80,0,10>, <60,8,10>, <60,48,10> }
		triangle { <60,48,10>, <80,48,10>, <80,0,10> }
		triangle { <-80,0,-10>, <-60,8,-10>, <-60,48,-10> }
		triangle { <-60,48,-10>, <-80,48,-10>, <-80,0,-10> }
		triangle { <80,0,-10>, <60,8,-10>, <60,48,-10> }
		triangle { <60,48,-10>, <80,48,-10>, <80,0,-10> }
		triangle { <80,0,10>, <60,8,10>, <-60,8,10> }
		triangle { <-60,8,10>, <-80,0,10>, <80,0,10> }
		triangle { <80,0,-10>, <60,8,-10>, <-60,8,-10> }
		triangle { <-60,8,-10>, <-80,0,-10>, <80,0,-10> }
		triangle { <-80,0,10>, <-80,48,10>, <-80,48,-10> }
		triangle { <-80,48,-10>, <-80,0,-10>, <-80,0,10> }
		triangle { <80,0,10>, <80,48,10>, <80,48,-10> }
		triangle { <80,48,-10>, <80,0,-10>, <80,0,10> }
		triangle { <-80,0,10>, <80,0,10>, <80,0,-10> }
		triangle { <80,0,-10>, <-80,0,-10>, <-80,0,10> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
	#end
}
#end

#declare _3005_dot_dat = #if (QUAL = 0) box { <-10,-4,-10>, <10,24,10> } #else union {
// Brick  1 x  1
	object { box5_dot_dat matrix <6,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-6> }
		triangle { <-6,24,-6>, <-10,24,-10>, <-10,24,10> }
		triangle { <-10,24,-10>, <-6,24,-6>, <6,24,-6> }
		triangle { <6,24,-6>, <10,24,-10>, <-10,24,-10> }
		triangle { <10,24,-10>, <6,24,-6>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-10> }
	}
	object { box5_dot_dat matrix <10,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
}
#end

#declare _3036_dot_dat = #if (QUAL = 0) box { <-80,-4,-60>, <80,8,60> } #else union {
// Plate  6 x  8
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-40> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-40> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-4,0,0,0,56,0,8,0> }
	mesh {
		triangle { <80,8,60>, <76,8,56>, <-76,8,56> }
		triangle { <-76,8,56>, <-80,8,60>, <80,8,60> }
		triangle { <80,8,-60>, <76,8,-56>, <-76,8,-56> }
		triangle { <-76,8,-56>, <-80,8,-60>, <80,8,-60> }
		triangle { <80,8,60>, <76,8,56>, <76,8,-56> }
		triangle { <76,8,-56>, <80,8,-60>, <80,8,60> }
		triangle { <-80,8,60>, <-76,8,56>, <-76,8,-56> }
		triangle { <-76,8,-56>, <-80,8,-60>, <-80,8,60> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-8,0,0,0,60,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-50> }
	#end
}
#end

#declare _1_dash_4ndis_dot_dat = #if (ver >= 3.1)
	disc {
		<0,0,0>, <0,1,0>, 2, 1
		clipped_by { box { <0,-1,0>, <1,1,1> } }
	}
#else
	difference {
		box { <0,-0.001,0>, <1,0.001,1> }
		cylinder { <0,-1,0>, <0,1,0>, 1 }
	}
#end

#declare _3823_dot_dat = #if (QUAL = 0) box { <-40,-4,-30>, <40,48,10> } #else union {
// Windscreen  2 x  4 x  2
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,30,44,-10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-30,44,-10> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,44,-20> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,44,-20> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,44,-20> }
	#end
	mesh {
		triangle { <30,48,10>, <30,44,10>, <30,44,6> }
		triangle { <30,44,6>, <30,48,6>, <30,48,10> }
		triangle { <30,48,6>, <30,44,6>, <36,44,6> }
		triangle { <36,44,6>, <36,48,6>, <30,48,6> }
		triangle { <36,48,6>, <36,44,6>, <36,44,-20> }
		triangle { <36,44,-20>, <36,48,-20>, <36,48,6> }
		triangle { <30,48,-26>, <30,44,-26>, <-30,44,-26> }
		triangle { <-30,44,-26>, <-30,48,-26>, <30,48,-26> }
		triangle { <-36,48,-20>, <-36,44,-20>, <-36,44,6> }
		triangle { <-36,44,6>, <-36,48,6>, <-36,48,-20> }
		triangle { <-36,48,6>, <-36,44,6>, <-30,44,6> }
		triangle { <-30,44,6>, <-30,48,6>, <-36,48,6> }
		triangle { <-30,48,6>, <-30,44,6>, <-30,44,10> }
		triangle { <-30,44,10>, <-30,48,10>, <-30,48,6> }
		triangle { <-20,48,0>, <-20,44,0>, <-24,44,0> }
		triangle { <-24,44,0>, <-24,48,0>, <-20,48,0> }
		triangle { <-24,48,0>, <-24,44,0>, <-24,44,-14> }
		triangle { <-24,44,-14>, <-24,48,-14>, <-24,48,0> }
		triangle { <-24,48,-14>, <-24,44,-14>, <24,44,-14> }
		triangle { <24,44,-14>, <24,48,-14>, <-24,48,-14> }
		triangle { <24,48,-14>, <24,44,-14>, <24,44,0> }
		triangle { <24,44,0>, <24,48,0>, <24,48,-14> }
		triangle { <24,48,0>, <24,44,0>, <20,44,0> }
		triangle { <20,44,0>, <20,48,0>, <24,48,0> }
	}
	object { _1_dash_4cyli_dot_dat matrix <10,0,0,0,4,0,0,0,-10,20,40,10> }
	object { _1_dash_4cyli_dot_dat matrix <-10,0,0,0,4,0,0,0,-10,-20,40,10> }
	object { _1_dash_4cyli_dot_dat matrix <10,0,0,0,8,0,0,0,-10,30,40,-20> }
	object { _1_dash_4cyli_dot_dat matrix <-10,0,0,0,8,0,0,0,-10,-30,40,-20> }
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,-6,30,44,-20> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,4,0,0,0,-6,-30,44,-20> }
	mesh {
		triangle { <40,48,10>, <30,48,10>, <30,40,10> }
		triangle { <30,40,10>, <40,40,10>, <40,48,10> }
		triangle { <20,48,0>, <20,48,-10>, <20,40,-10> }
		triangle { <20,40,-10>, <20,40,0>, <20,48,0> }
		triangle { <20,48,-10>, <-20,48,-10>, <-20,40,-10> }
		triangle { <-20,40,-10>, <20,40,-10>, <20,48,-10> }
		triangle { <-20,48,-10>, <-20,48,0>, <-20,40,0> }
		triangle { <-20,40,0>, <-20,40,-10>, <-20,48,-10> }
		triangle { <-30,48,10>, <-40,48,10>, <-40,40,10> }
		triangle { <-40,40,10>, <-30,40,10>, <-30,48,10> }
		triangle { <-40,48,10>, <-40,48,-20>, <-40,40,-20> }
		triangle { <-40,40,-20>, <-40,40,10>, <-40,48,10> }
		triangle { <-30,48,-30>, <30,48,-30>, <30,40,-30> }
		triangle { <30,40,-30>, <-30,40,-30>, <-30,48,-30> }
		triangle { <40,48,-20>, <40,48,10>, <40,40,10> }
		triangle { <40,40,10>, <40,40,-20>, <40,48,-20> }
	}
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,36,-18,0,0,-6,30,4,-2> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,36,-18,0,0,-6,-30,4,-2> }
	object { _1_dash_4cyli_dot_dat matrix <10,0,0,0,40,-20,0,0,-10,30,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <-10,0,0,0,40,-20,0,0,-10,-30,0,0> }
	mesh {
		triangle { <40,40,10>, <36,40,10>, <36,4,10> }
		triangle { <36,4,10>, <40,0,10>, <40,40,10> }
		triangle { <36,40,10>, <36,40,-20>, <36,4,-2> }
		triangle { <36,4,-2>, <36,4,10>, <36,40,10> }
		triangle { <30,40,-26>, <-30,40,-26>, <-30,4,-8> }
		triangle { <-30,4,-8>, <30,4,-8>, <30,40,-26> }
		triangle { <-36,40,-20>, <-36,40,10>, <-36,4,10> }
		triangle { <-36,4,10>, <-36,4,-2>, <-36,40,-20> }
		triangle { <-36,40,10>, <-40,40,10>, <-40,0,10> }
		triangle { <-40,0,10>, <-36,4,10>, <-36,40,10> }
		triangle { <-40,40,10>, <-40,40,-20>, <-40,0,0> }
		triangle { <-40,0,0>, <-40,0,10>, <-40,40,10> }
		triangle { <-30,40,-30>, <30,40,-30>, <30,0,-10> }
		triangle { <30,0,-10>, <-30,0,-10>, <-30,40,-30> }
		triangle { <40,40,-20>, <40,40,10>, <40,0,10> }
		triangle { <40,0,10>, <40,0,0>, <40,40,-20> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-10,0,0,0,4,0,0,0,10,30,0,0> }
	object { _1_dash_4cyli_dot_dat matrix <10,0,0,0,4,0,0,0,10,-30,0,0> }
	mesh {
		triangle { <36,4,10>, <30,4,10>, <30,0,10> }
		triangle { <30,0,10>, <40,0,10>, <36,4,10> }
		triangle { <20,4,0>, <20,4,-8>, <20,0,-6> }
		triangle { <20,0,-6>, <20,0,0>, <20,4,0> }
		triangle { <-36,4,10>, <-30,4,10>, <-30,0,10> }
		triangle { <-30,0,10>, <-40,0,10>, <-36,4,10> }
		triangle { <-20,4,0>, <-20,4,-8>, <-20,0,-6> }
		triangle { <-20,0,-6>, <-20,0,0>, <-20,4,0> }
		triangle { <20,4,-8>, <20,0,-6>, <-20,0,-6> }
		triangle { <-20,0,-6>, <-20,4,-8>, <20,4,-8> }
		triangle { <-36,48,-20>, <-35.54,48,-22.3>, <-39.24,48,-23.83> }
		triangle { <-39.24,48,-23.83>, <-40,48,-20>, <-36,48,-20> }
		triangle { <-35.54,48,-22.3>, <-34.24,48,-24.24>, <-37.07,48,-27.07> }
		triangle { <-37.07,48,-27.07>, <-39.24,48,-23.83>, <-35.54,48,-22.3> }
		triangle { <-34.24,48,-24.24>, <-32.3,48,-25.54>, <-33.83,48,-29.24> }
		triangle { <-33.83,48,-29.24>, <-37.07,48,-27.07>, <-34.24,48,-24.24> }
		triangle { <-32.3,48,-25.54>, <-30,48,-26>, <-30,48,-30> }
		triangle { <-30,48,-30>, <-33.83,48,-29.24>, <-32.3,48,-25.54> }
		triangle { <30,48,-26>, <32.3,48,-25.54>, <33.83,48,-29.24> }
		triangle { <33.83,48,-29.24>, <30,48,-30>, <30,48,-26> }
		triangle { <32.3,48,-25.54>, <34.24,48,-24.24>, <37.07,48,-27.07> }
		triangle { <37.07,48,-27.07>, <33.83,48,-29.24>, <32.3,48,-25.54> }
		triangle { <34.24,48,-24.24>, <35.54,48,-22.3>, <39.24,48,-23.83> }
		triangle { <39.24,48,-23.83>, <37.07,48,-27.07>, <34.24,48,-24.24> }
		triangle { <35.54,48,-22.3>, <36,48,-20>, <40,48,-20> }
		triangle { <40,48,-20>, <39.24,48,-23.83>, <35.54,48,-22.3> }
		triangle { <30,48,10>, <30,48,6>, <36,48,6> }
		triangle { <36,48,6>, <40,48,10>, <30,48,10> }
		triangle { <-30,48,10>, <-30,48,6>, <-36,48,6> }
		triangle { <-36,48,6>, <-40,48,10>, <-30,48,10> }
		triangle { <40,48,10>, <36,48,6>, <36,48,-20> }
		triangle { <36,48,-20>, <40,48,-20>, <40,48,10> }
		triangle { <-40,48,10>, <-36,48,6>, <-36,48,-20> }
		triangle { <-36,48,-20>, <-40,48,-20>, <-40,48,10> }
		triangle { <30,48,-30>, <30,48,-26>, <-30,48,-26> }
		triangle { <-30,48,-26>, <-30,48,-30>, <30,48,-30> }
		triangle { <20,48,0>, <24,48,0>, <24,48,-14> }
		triangle { <24,48,-14>, <20,48,-10>, <20,48,0> }
		triangle { <-20,48,0>, <-24,48,0>, <-24,48,-14> }
		triangle { <-24,48,-14>, <-20,48,-10>, <-20,48,0> }
		triangle { <20,48,-10>, <24,48,-14>, <-24,48,-14> }
		triangle { <-24,48,-14>, <-20,48,-10>, <20,48,-10> }
	}
	object { _1_dash_4ndis_dot_dat matrix <10,0,0,0,1,0,0,0,-10,20,44,10> }
	object { _1_dash_4ndis_dot_dat matrix <-10,0,0,0,1,0,0,0,-10,-20,44,10> }
	object { _1_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,-6,30,44,-20> }
	object { _1_dash_4disc_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-30,44,-20> }
	mesh {
		triangle { <36,44,6>, <30,44,6>, <30,44,0> }
		triangle { <30,44,0>, <36,44,0>, <36,44,6> }
		triangle { <-36,44,6>, <-30,44,6>, <-30,44,0> }
		triangle { <-30,44,0>, <-36,44,0>, <-36,44,6> }
		triangle { <36,44,0>, <24,44,0>, <24,44,-14> }
		triangle { <24,44,-14>, <36,44,-14>, <36,44,0> }
		triangle { <-36,44,0>, <-24,44,0>, <-24,44,-14> }
		triangle { <-24,44,-14>, <-36,44,-14>, <-36,44,0> }
		triangle { <36,44,-14>, <-36,44,-14>, <-36,44,-20> }
		triangle { <-36,44,-20>, <36,44,-20>, <36,44,-14> }
		triangle { <30,44,-20>, <-30,44,-20>, <-30,44,-26> }
		triangle { <-30,44,-26>, <30,44,-26>, <30,44,-20> }
	}
	object { _1_dash_4ndis_dot_dat matrix <10,0,0,0,1,0,0,0,-10,20,40,10> }
	object { _1_dash_4ndis_dot_dat matrix <-10,0,0,0,1,0,0,0,-10,-20,40,10> }
	object { _1_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,-6,30,40,-20> }
	object { _1_dash_4disc_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-30,40,-20> }
	mesh {
		triangle { <36,40,10>, <30,40,10>, <30,40,0> }
		triangle { <30,40,0>, <36,40,0>, <36,40,10> }
		triangle { <-36,40,10>, <-30,40,10>, <-30,40,0> }
		triangle { <-30,40,0>, <-36,40,0>, <-36,40,10> }
		triangle { <36,40,0>, <20,40,0>, <20,40,-10> }
		triangle { <20,40,-10>, <36,40,-10>, <36,40,0> }
		triangle { <-36,40,0>, <-20,40,0>, <-20,40,-10> }
		triangle { <-20,40,-10>, <-36,40,-10>, <-36,40,0> }
		triangle { <36,40,-10>, <-36,40,-10>, <-36,40,-20> }
		triangle { <-36,40,-20>, <36,40,-20>, <36,40,-10> }
		triangle { <30,40,-20>, <-30,40,-20>, <-30,40,-26> }
		triangle { <-30,40,-26>, <30,40,-26>, <30,40,-20> }
	}
	object { _1_dash_4disc_dot_dat matrix <-10,0,0,0,1,0,0,0,10,30,4,0> }
	object { _1_dash_4disc_dot_dat matrix <10,0,0,0,1,0,0,0,10,-30,4,0> }
	object { _1_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,-6,30,4,-2> }
	object { _1_dash_4disc_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-30,4,-2> }
	mesh {
		triangle { <36,4,10>, <30,4,10>, <30,4,0> }
		triangle { <30,4,0>, <36,4,0>, <36,4,10> }
		triangle { <-36,4,10>, <-30,4,10>, <-30,4,0> }
		triangle { <-30,4,0>, <-36,4,0>, <-36,4,10> }
		triangle { <36,4,0>, <20,4,0>, <20,4,-2> }
		triangle { <20,4,-2>, <36,4,-2>, <36,4,0> }
		triangle { <-36,4,0>, <-20,4,0>, <-20,4,-2> }
		triangle { <-20,4,-2>, <-36,4,-2>, <-36,4,0> }
		triangle { <30,4,-2>, <20,4,-2>, <20,4,-8> }
		triangle { <20,4,-8>, <30,4,-8>, <30,4,-2> }
		triangle { <-30,4,-2>, <-20,4,-2>, <-20,4,-8> }
		triangle { <-20,4,-8>, <-30,4,-8>, <-30,4,-2> }
	}
	object { _1_dash_4disc_dot_dat matrix <-10,0,0,0,1,0,0,0,10,30,0,0> }
	object { _1_dash_4disc_dot_dat matrix <10,0,0,0,1,0,0,0,10,-30,0,0> }
	object { _1_dash_4disc_dot_dat matrix <10,0,0,0,1,0,0,0,-10,30,0,0> }
	object { _1_dash_4disc_dot_dat matrix <-10,0,0,0,1,0,0,0,-10,-30,0,0> }
	mesh {
		triangle { <40,0,10>, <30,0,10>, <30,0,0> }
		triangle { <30,0,0>, <40,0,0>, <40,0,10> }
		triangle { <-40,0,10>, <-30,0,10>, <-30,0,0> }
		triangle { <-30,0,0>, <-40,0,0>, <-40,0,10> }
		triangle { <30,0,0>, <20,0,0>, <20,0,-10> }
		triangle { <20,0,-10>, <30,0,-10>, <30,0,0> }
		triangle { <-30,0,0>, <-20,0,0>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-30,0,-10>, <-30,0,0> }
		triangle { <20,0,-6>, <-20,0,-6>, <-20,0,-10> }
		triangle { <-20,0,-10>, <20,0,-10>, <20,0,-6> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
	#end
}
#end

#declare _4865_dot_dat = #if (QUAL = 0) box { <-20,0,-10>, <20,24,10> } #else union {
// Panel  1 x  2 x  1
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
		triangle { <20,16,6>, <20,16,-10>, <-20,16,-10> }
		triangle { <-20,16,-10>, <-20,16,6>, <20,16,6> }
		triangle { <20,0,10>, <20,0,6>, <-20,0,6> }
		triangle { <-20,0,6>, <-20,0,10>, <20,0,10> }
		triangle { <-20,24,10>, <-20,24,-10>, <-20,16,-10> }
		triangle { <-20,16,-10>, <-20,16,6>, <-20,24,10> }
		triangle { <-20,24,-10>, <20,24,-10>, <20,16,-10> }
		triangle { <20,16,-10>, <-20,16,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <20,24,10>, <20,16,6> }
		triangle { <20,16,6>, <20,16,-10>, <20,24,-10> }
		triangle { <20,24,10>, <-20,24,10>, <-20,0,10> }
		triangle { <-20,0,10>, <20,0,10>, <20,24,10> }
		triangle { <-20,24,10>, <-20,16,6>, <-20,0,6> }
		triangle { <-20,0,6>, <-20,0,10>, <-20,24,10> }
		triangle { <-20,16,6>, <20,16,6>, <20,0,6> }
		triangle { <20,0,6>, <-20,0,6>, <-20,16,6> }
		triangle { <20,16,6>, <20,24,10>, <20,0,10> }
		triangle { <20,0,10>, <20,0,6>, <20,16,6> }
	}
}
#end

#declare _3678_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,48,10> } #else #if (STUDS) union #else object #end {
// Slope Brick 65  2 x  2 x  2
	mesh {
		triangle { <20,48,10>, <16,48,6>, <-16,48,6> }
		triangle { <-16,48,6>, <-20,48,10>, <20,48,10> }
		triangle { <-20,48,10>, <-16,48,6>, <-16,48,-26> }
		triangle { <-16,48,-26>, <-20,48,-30>, <-20,48,10> }
		triangle { <-20,48,-30>, <-16,48,-26>, <16,48,-26> }
		triangle { <16,48,-26>, <20,48,-30>, <-20,48,-30> }
		triangle { <20,48,-30>, <16,48,-26>, <16,48,6> }
		triangle { <16,48,6>, <20,48,10>, <20,48,-30> }
		triangle { <16,4,6>, <16,4,-8>, <-16,4,-8> }
		triangle { <-16,4,-8>, <-16,4,6>, <16,4,6> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,48,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,48,10>, <20,48,10> }
		triangle { <16,48,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,48,6>, <16,48,6> }
		triangle { <16,48,-26>, <16,44,-26>, <-16,44,-26> }
		triangle { <-16,44,-26>, <-16,48,-26>, <16,48,-26> }
		triangle { <20,48,-30>, <20,44,-30>, <-20,44,-30> }
		triangle { <-20,44,-30>, <-20,48,-30>, <20,48,-30> }
		triangle { <20,48,10>, <20,0,10>, <20,44,-30> }
		triangle { <20,44,-30>, <20,48,-30>, <20,48,10> }
		triangle { <20,0,10>, <20,0,-10>, <20,44,-30> }
		triangle { <16,48,6>, <16,4,6>, <16,44,-26> }
		triangle { <16,44,-26>, <16,48,-26>, <16,48,6> }
		triangle { <16,4,6>, <16,4,-8>, <16,44,-26> }
		triangle { <-16,48,6>, <-16,4,6>, <-16,44,-26> }
		triangle { <-16,44,-26>, <-16,48,-26>, <-16,48,6> }
		triangle { <-16,4,6>, <-16,4,-8>, <-16,44,-26> }
		triangle { <-20,48,10>, <-20,0,10>, <-20,44,-30> }
		triangle { <-20,44,-30>, <-20,48,-30>, <-20,48,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-20,44,-30> }
		triangle { <16,44,-26>, <16,4,-8>, <-16,4,-8> }
		triangle { <-16,4,-8>, <-16,44,-26>, <16,44,-26> }
		triangle { <20,44,-30>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,44,-30>, <20,44,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
	#end
}
#end

#declare _3623_dot_dat = #if (QUAL = 0) box { <-30,-4,-10>, <30,8,10> } #else union {
// Plate  1 x  3
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,10,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-10,4,0> }
	#end
	object { box5_dot_dat matrix <26,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <30,8,10>, <26,8,6>, <-26,8,6> }
		triangle { <-26,8,6>, <-30,8,10>, <30,8,10> }
		triangle { <-30,8,10>, <-26,8,6>, <-26,8,-6> }
		triangle { <-26,8,-6>, <-30,8,-10>, <-30,8,10> }
		triangle { <-30,8,-10>, <-26,8,-6>, <26,8,-6> }
		triangle { <26,8,-6>, <30,8,-10>, <-30,8,-10> }
		triangle { <30,8,-10>, <26,8,-6>, <26,8,6> }
		triangle { <26,8,6>, <30,8,10>, <30,8,-10> }
	}
	object { box5_dot_dat matrix <30,0,0,0,-8,0,0,0,10,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,20,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-20,0,0> }
	#end
}
#end

#declare _3660p01_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,24,10> } #else union {
// Slope Brick 45  2 x  2 Inverted with Computer Screen Pattern
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
	}
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,4,0,0,10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,-4,0,0,10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,4,0,0,-10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,4,0,-4,0,0,-10,6,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,6,0,0,10,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,-6,0,0,10,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,6,0,0,-10,4,-20> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-6,0,6,0,-6,0,0,-10,4,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,6,0,0,0,4,10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,6,0,0,0,4,-10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,10,0,-20> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,-10,0,-20> }
	mesh {
		triangle { <20,24,-10>, <20,4,-30>, <20,0,10> }
		triangle { <20,0,10>, <20,24,10>, <20,24,-10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,-10>, <-20,4,-30>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <-20,24,-10> }
		triangle { <20,0,-30>, <20,4,-30>, <20,0,10> }
		triangle { <20,0,-30>, <20,4,-30>, <-20,4,-30> }
		triangle { <-20,4,-30>, <-20,0,-30>, <20,0,-30> }
		triangle { <-20,0,-30>, <-20,4,-30>, <-20,0,10> }
		triangle { <18,20,-10>, <18,4,-26>, <-18,4,-26> }
		triangle { <-18,4,-26>, <-18,20,-10>, <18,20,-10> }
		triangle { <18,20,-10>, <18,0,-10>, <18,0,-26> }
		triangle { <18,0,-26>, <18,4,-26>, <18,20,-10> }
		triangle { <-18,20,-10>, <-18,0,-10>, <-18,0,-26> }
		triangle { <-18,0,-26>, <-18,4,-26>, <-18,20,-10> }
		triangle { <18,20,-10>, <18,0,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-18,20,-10>, <18,20,-10> }
		triangle { <18,4,-26>, <18,0,-26>, <-18,0,-26> }
		triangle { <-18,0,-26>, <-18,4,-26>, <18,4,-26> }
		triangle { <20,0,10>, <18,0,-10>, <-18,0,-10> }
		triangle { <-18,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <-20,0,10>, <-18,0,-10>, <-18,0,-26> }
		triangle { <-18,0,-26>, <-20,0,-30>, <-20,0,10> }
		triangle { <-20,0,-30>, <-18,0,-26>, <18,0,-26> }
		triangle { <18,0,-26>, <20,0,-30>, <-20,0,-30> }
		triangle { <20,0,-30>, <18,0,-26>, <18,0,-10> }
		triangle { <18,0,-10>, <20,0,10>, <20,0,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-20> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-20> }
	#end
	mesh {
		triangle { <-20,4,-30>, <-19.3,4.71,-29.29>, <-19.2,23.36,-10.64> }
		triangle { <-19.2,23.36,-10.64>, <-20,24,-10>, <-20,4,-30> }
		triangle { <-20,24,-10>, <-19.2,23.36,-10.64>, <19.3,23.29,-10.71> }
		triangle { <19.3,23.29,-10.71>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <19.3,23.29,-10.71>, <19.3,4.71,-29.29> }
		triangle { <19.3,4.71,-29.29>, <20,4,-30>, <20,24,-10> }
		triangle { <-20,4,-30>, <-19.3,4.71,-29.29>, <19.3,4.71,-29.29> }
		triangle { <19.3,4.71,-29.29>, <20,4,-30>, <-20,4,-30> }
	}
	mesh {
		triangle { <4,22.43,-11.57>, <4.7,21.93,-12.07>, <4.8,5.57,-28.43> }
		triangle { <4.8,5.57,-28.43>, <4.1,5.14,-28.86>, <4,22.43,-11.57> }
		triangle { <-17.1,22.36,-11.64>, <4,22.43,-11.57>, <4.1,5.14,-28.86> }
		triangle { <4.1,5.14,-28.86>, <-17.7,5.07,-28.93>, <-17.1,22.36,-11.64> }
		triangle { <-17.7,5.07,-28.93>, <-18.4,5.5,-28.5>, <-18.3,21.79,-12.21> }
		triangle { <-18.3,21.79,-12.21>, <-17.1,22.36,-11.64>, <-17.7,5.07,-28.93> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <12,9.64,-24.36>, <16,9.64,-24.36>, <16,6.79,-27.21> }
		triangle { <16,6.79,-27.21>, <12,6.79,-27.21>, <12,9.64,-24.36> }
		#if (ver >= 3.1) material #else texture #end { Color4 }
	}
	mesh {
		triangle { <12,15.36,-18.64>, <16,15.36,-18.64>, <16,12.5,-21.5> }
		triangle { <16,12.5,-21.5>, <12,12.5,-21.5>, <12,15.36,-18.64> }
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	mesh {
		triangle { <12,21.07,-12.93>, <16,21.07,-12.93>, <16,18.21,-15.79> }
		triangle { <16,18.21,-15.79>, <12,18.21,-15.79>, <12,21.07,-12.93> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <-19.2,23.36,-10.64>, <-18.3,21.79,-12.21>, <-18.4,5.5,-28.5> }
		triangle { <-18.4,5.5,-28.5>, <-19.3,4.71,-29.29>, <-19.2,23.36,-10.64> }
		triangle { <-19.2,23.36,-10.64>, <-17.1,22.36,-11.64>, <-18.3,21.79,-12.21> }
		triangle { <-19.2,23.36,-10.64>, <19.3,23.29,-10.71>, <4,22.43,-11.57> }
		triangle { <4,22.43,-11.57>, <-17.1,22.36,-11.64>, <-19.2,23.36,-10.64> }
		triangle { <-19.3,4.71,-29.29>, <-18.4,5.5,-28.5>, <-17.7,5.07,-28.93> }
		triangle { <-19.3,4.71,-29.29>, <-17.7,5.07,-28.93>, <4.1,5.14,-28.86> }
		triangle { <4.1,5.14,-28.86>, <19.3,4.71,-29.29>, <-19.3,4.71,-29.29> }
		triangle { <19.3,23.29,-10.71>, <4,22.43,-11.57>, <4.7,21.93,-12.07> }
		triangle { <19.3,4.71,-29.29>, <4.1,5.14,-28.86>, <4.8,5.57,-28.43> }
		triangle { <4.7,21.93,-12.07>, <12,21.07,-12.93>, <12,6.79,-27.21> }
		triangle { <12,6.79,-27.21>, <4.8,5.57,-28.43>, <4.7,21.93,-12.07> }
		triangle { <19.3,4.71,-29.29>, <16,6.79,-27.21>, <16,21.07,-12.93> }
		triangle { <16,21.07,-12.93>, <19.3,23.29,-10.71>, <19.3,4.71,-29.29> }
		triangle { <4.7,21.93,-12.07>, <12,21.07,-12.93>, <16,21.07,-12.93> }
		triangle { <16,21.07,-12.93>, <19.3,23.29,-10.71>, <4.7,21.93,-12.07> }
		triangle { <4.8,5.57,-28.43>, <12,6.79,-27.21>, <16,6.79,-27.21> }
		triangle { <16,6.79,-27.21>, <19.3,4.71,-29.29>, <4.8,5.57,-28.43> }
		triangle { <12,18.21,-15.79>, <16,18.21,-15.79>, <16,15.36,-18.64> }
		triangle { <16,15.36,-18.64>, <12,15.36,-18.64>, <12,18.21,-15.79> }
		triangle { <12,12.5,-21.5>, <16,12.5,-21.5>, <16,9.64,-24.36> }
		triangle { <16,9.64,-24.36>, <12,9.64,-24.36>, <12,12.5,-21.5> }
		triangle { <12,12.5,-21.5>, <16,12.5,-21.5>, <16,9.64,-24.36> }
		triangle { <16,9.64,-24.36>, <12,9.64,-24.36>, <12,12.5,-21.5> }
		#if (ver >= 3.1) material #else texture #end { Color15 }
	}
}
#end

#declare _6179_dot_dat = #if (QUAL = 0) box { <-40,-4,-40>, <40,8,40> } #else union {
// Tile  4 x  4 with Studs on Edge
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-20> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-20> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,36,0,8,0> }
	mesh {
		triangle { <40,8,40>, <36,8,36>, <-36,8,36> }
		triangle { <-36,8,36>, <-40,8,40>, <40,8,40> }
		triangle { <-40,8,40>, <-36,8,36>, <-36,8,-36> }
		triangle { <-36,8,-36>, <-40,8,-40>, <-40,8,40> }
		triangle { <-40,8,-40>, <-36,8,-36>, <36,8,-36> }
		triangle { <36,8,-36>, <40,8,-40>, <-40,8,-40> }
		triangle { <40,8,-40>, <36,8,-36>, <36,8,36> }
		triangle { <36,8,36>, <40,8,40>, <40,8,-40> }
	}
	object { box5_dot_dat matrix <40,0,0,0,-8,0,0,0,40,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
	#end
}
#end

#declare _3068_dot_dat = #if (QUAL = 0) box { <-20,0,-20>, <20,8,20> } #else union {
// Tile  2 x  2
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <20,8,20>, <16,8,16>, <-16,8,16> }
		triangle { <-16,8,16>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,-20>, <16,8,-16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <20,8,-20> }
		triangle { <20,8,20>, <16,8,16>, <16,8,-16> }
		triangle { <16,8,-16>, <20,8,-20>, <20,8,20> }
		triangle { <-20,8,20>, <-16,8,16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <-20,8,20> }
	}
	object { box5_dot_dat matrix <20,0,0,0,-8,0,0,0,20,0,8,0> }
}
#end

#declare _3680_dot_dat = #if (QUAL = 0) box { <-20,0,-20>, <20,8,20> } #else union {
// Turntable  2 x  2 Plate Base
	object { peghole_dot_dat matrix <1,0,0,0,2,0,0,0,1,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,2,0,0,0,6,0,6,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,2,0,0,0,4,0,4,0> }
	mesh {
		triangle { <0,6,4>, <-1.53,6,3.7>, <-2.3,6,5.54> }
		triangle { <-2.3,6,5.54>, <0,6,6>, <0,6,4> }
		triangle { <0,4,4>, <-1.53,4,3.7>, <-3.06,4,7.39> }
		triangle { <-3.06,4,7.39>, <0,4,8>, <0,4,4> }
		triangle { <-1.53,6,3.7>, <-2.83,6,2.83>, <-4.24,6,4.24> }
		triangle { <-4.24,6,4.24>, <-2.3,6,5.54>, <-1.53,6,3.7> }
		triangle { <-1.53,4,3.7>, <-2.83,4,2.83>, <-5.66,4,5.66> }
		triangle { <-5.66,4,5.66>, <-3.06,4,7.39>, <-1.53,4,3.7> }
		triangle { <-2.83,6,2.83>, <-3.7,6,1.53>, <-5.54,6,2.3> }
		triangle { <-5.54,6,2.3>, <-4.24,6,4.24>, <-2.83,6,2.83> }
		triangle { <-2.83,4,2.83>, <-3.7,4,1.53>, <-7.39,4,3.06> }
		triangle { <-7.39,4,3.06>, <-5.66,4,5.66>, <-2.83,4,2.83> }
		triangle { <-3.7,6,1.53>, <-4,6,0>, <-6,6,0> }
		triangle { <-6,6,0>, <-5.54,6,2.3>, <-3.7,6,1.53> }
		triangle { <-3.7,4,1.53>, <-4,4,0>, <-8,4,0> }
		triangle { <-8,4,0>, <-7.39,4,3.06>, <-3.7,4,1.53> }
		triangle { <-4,6,0>, <-3.7,6,-1.53>, <-5.54,6,-2.3> }
		triangle { <-5.54,6,-2.3>, <-6,6,0>, <-4,6,0> }
		triangle { <-4,4,0>, <-3.7,4,-1.53>, <-7.39,4,-3.06> }
		triangle { <-7.39,4,-3.06>, <-8,4,0>, <-4,4,0> }
		triangle { <-3.7,6,-1.53>, <-2.83,6,-2.83>, <-4.24,6,-4.24> }
		triangle { <-4.24,6,-4.24>, <-5.54,6,-2.3>, <-3.7,6,-1.53> }
		triangle { <-3.7,4,-1.53>, <-2.83,4,-2.83>, <-5.66,4,-5.66> }
		triangle { <-5.66,4,-5.66>, <-7.39,4,-3.06>, <-3.7,4,-1.53> }
		triangle { <-2.83,6,-2.83>, <-1.53,6,-3.7>, <-2.3,6,-5.54> }
		triangle { <-2.3,6,-5.54>, <-4.24,6,-4.24>, <-2.83,6,-2.83> }
		triangle { <-2.83,4,-2.83>, <-1.53,4,-3.7>, <-3.06,4,-7.39> }
		triangle { <-3.06,4,-7.39>, <-5.66,4,-5.66>, <-2.83,4,-2.83> }
		triangle { <-1.53,6,-3.7>, <0,6,-4>, <0,6,-6> }
		triangle { <0,6,-6>, <-2.3,6,-5.54>, <-1.53,6,-3.7> }
		triangle { <-1.53,4,-3.7>, <0,4,-4>, <0,4,-8> }
		triangle { <0,4,-8>, <-3.06,4,-7.39>, <-1.53,4,-3.7> }
		triangle { <0,6,-4>, <1.53,6,-3.7>, <2.3,6,-5.54> }
		triangle { <2.3,6,-5.54>, <0,6,-6>, <0,6,-4> }
		triangle { <0,4,-4>, <1.53,4,-3.7>, <3.06,4,-7.39> }
		triangle { <3.06,4,-7.39>, <0,4,-8>, <0,4,-4> }
		triangle { <1.53,6,-3.7>, <2.83,6,-2.83>, <4.24,6,-4.24> }
		triangle { <4.24,6,-4.24>, <2.3,6,-5.54>, <1.53,6,-3.7> }
		triangle { <1.53,4,-3.7>, <2.83,4,-2.83>, <5.66,4,-5.66> }
		triangle { <5.66,4,-5.66>, <3.06,4,-7.39>, <1.53,4,-3.7> }
		triangle { <2.83,6,-2.83>, <3.7,6,-1.53>, <5.54,6,-2.3> }
		triangle { <5.54,6,-2.3>, <4.24,6,-4.24>, <2.83,6,-2.83> }
		triangle { <2.83,4,-2.83>, <3.7,4,-1.53>, <7.39,4,-3.06> }
		triangle { <7.39,4,-3.06>, <5.66,4,-5.66>, <2.83,4,-2.83> }
		triangle { <3.7,6,-1.53>, <4,6,0>, <6,6,0> }
		triangle { <6,6,0>, <5.54,6,-2.3>, <3.7,6,-1.53> }
		triangle { <3.7,4,-1.53>, <4,4,0>, <8,4,0> }
		triangle { <8,4,0>, <7.39,4,-3.06>, <3.7,4,-1.53> }
		triangle { <4,6,0>, <3.7,6,1.53>, <5.54,6,2.3> }
		triangle { <5.54,6,2.3>, <6,6,0>, <4,6,0> }
		triangle { <4,4,0>, <3.7,4,1.53>, <7.39,4,3.06> }
		triangle { <7.39,4,3.06>, <8,4,0>, <4,4,0> }
		triangle { <3.7,6,1.53>, <2.83,6,2.83>, <4.24,6,4.24> }
		triangle { <4.24,6,4.24>, <5.54,6,2.3>, <3.7,6,1.53> }
		triangle { <3.7,4,1.53>, <2.83,4,2.83>, <5.66,4,5.66> }
		triangle { <5.66,4,5.66>, <7.39,4,3.06>, <3.7,4,1.53> }
		triangle { <2.83,6,2.83>, <1.53,6,3.7>, <2.3,6,5.54> }
		triangle { <2.3,6,5.54>, <4.24,6,4.24>, <2.83,6,2.83> }
		triangle { <2.83,4,2.83>, <1.53,4,3.7>, <3.06,4,7.39> }
		triangle { <3.06,4,7.39>, <5.66,4,5.66>, <2.83,4,2.83> }
		triangle { <1.53,6,3.7>, <0,6,4>, <0,6,6> }
		triangle { <0,6,6>, <2.3,6,5.54>, <1.53,6,3.7> }
		triangle { <1.53,4,3.7>, <0,4,4>, <0,4,8> }
		triangle { <0,4,8>, <3.06,4,7.39>, <1.53,4,3.7> }
	}
	object { box_dot_dat matrix <2,0,0,0,1.5,0,0,0,4,0,5.5,12> }
	object { box_dot_dat matrix <2,0,0,0,1.5,0,0,0,4,0,5.5,-12> }
	object { box_dot_dat matrix <4,0,0,0,1.5,0,0,0,2,12,5.5,0> }
	object { box_dot_dat matrix <4,0,0,0,1.5,0,0,0,2,-12,5.5,0> }
	object { _4_dash_4cyli_dot_dat matrix <16,0,0,0,4,0,0,0,16,0,0,0> }
	object { _4_dash_4ndis_dot_dat matrix <16,0,0,0,1,0,0,0,16,0,4,0> }
	mesh {
		triangle { <20,8,20>, <16,8,16>, <16,8,-16> }
		triangle { <16,8,-16>, <20,8,-20>, <20,8,20> }
		triangle { <-20,8,20>, <-16,8,16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <-20,8,20> }
		triangle { <20,8,20>, <16,8,16>, <-16,8,16> }
		triangle { <-16,8,16>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,-20>, <16,8,-16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <20,8,-20> }
		triangle { <16,8,16>, <16,4,16>, <16,4,-16> }
		triangle { <16,4,-16>, <16,8,-16>, <16,8,16> }
		triangle { <16,8,16>, <16,4,16>, <-16,4,16> }
		triangle { <-16,4,16>, <-16,8,16>, <16,8,16> }
		triangle { <16,8,-16>, <16,4,-16>, <-16,4,-16> }
		triangle { <-16,4,-16>, <-16,8,-16>, <16,8,-16> }
		triangle { <-16,8,16>, <-16,4,16>, <-16,4,-16> }
		triangle { <-16,4,-16>, <-16,8,-16>, <-16,8,16> }
		triangle { <20,8,20>, <20,0,20>, <20,0,-20> }
		triangle { <20,0,-20>, <20,8,-20>, <20,8,20> }
		triangle { <20,8,20>, <20,0,20>, <-20,0,20> }
		triangle { <-20,0,20>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,-20>, <20,0,-20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,8,-20>, <20,8,-20> }
		triangle { <-20,8,20>, <-20,0,20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,8,-20>, <-20,8,20> }
	}
	object { _4_dash_4ndis_dot_dat matrix <16,0,0,0,1,0,0,0,16,0,0,0> }
	mesh {
		triangle { <20,0,20>, <16,0,16>, <16,0,-16> }
		triangle { <16,0,-16>, <20,0,-20>, <20,0,20> }
		triangle { <-20,0,20>, <-16,0,16>, <-16,0,-16> }
		triangle { <-16,0,-16>, <-20,0,-20>, <-20,0,20> }
		triangle { <20,0,20>, <16,0,16>, <-16,0,16> }
		triangle { <-16,0,16>, <-20,0,20>, <20,0,20> }
		triangle { <20,0,-20>, <16,0,-16>, <-16,0,-16> }
		triangle { <-16,0,-16>, <-20,0,-20>, <20,0,-20> }
	}
}
#end

#declare connect2_dot_dat = union {
// Connector 2
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,12,0,0,0,4,0,-12,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,12,0,0,0,6,0,-12,0> }
	mesh {
		triangle { <0,-20,6>, <0,-20,4>, <1.52,-20,3.68> }
		triangle { <1.52,-20,3.68>, <2.28,-20,5.52>, <0,-20,6> }
		triangle { <2.28,-20,5.52>, <1.52,-20,3.68>, <2.84,-20,2.84> }
		triangle { <2.84,-20,2.84>, <4.26,-20,4.26>, <2.28,-20,5.52> }
		triangle { <4.26,-20,4.26>, <2.84,-20,2.84>, <3.68,-20,1.52> }
		triangle { <3.68,-20,1.52>, <5.52,-20,2.28>, <4.26,-20,4.26> }
		triangle { <5.52,-20,2.28>, <3.68,-20,1.52>, <3.79,-20,1> }
		triangle { <3.79,-20,1>, <5.79,-20,1>, <5.52,-20,2.28> }
		triangle { <5.79,-20,1>, <3.79,-20,1>, <3.79,-12,1> }
		triangle { <3.79,-12,1>, <5.79,-12,1>, <5.79,-20,1> }
		triangle { <5.79,-12,1>, <3.79,-12,1>, <4,-12,0> }
		triangle { <4,-12,0>, <6,-12,0>, <5.79,-12,1> }
		triangle { <0,-20,6>, <0,-20,4>, <-1.52,-20,3.68> }
		triangle { <-1.52,-20,3.68>, <-2.28,-20,5.52>, <0,-20,6> }
		triangle { <-2.28,-20,5.52>, <-1.52,-20,3.68>, <-2.84,-20,2.84> }
		triangle { <-2.84,-20,2.84>, <-4.26,-20,4.26>, <-2.28,-20,5.52> }
		triangle { <-4.26,-20,4.26>, <-2.84,-20,2.84>, <-3.68,-20,1.52> }
		triangle { <-3.68,-20,1.52>, <-5.52,-20,2.28>, <-4.26,-20,4.26> }
		triangle { <-5.52,-20,2.28>, <-3.68,-20,1.52>, <-3.79,-20,1> }
		triangle { <-3.79,-20,1>, <-5.79,-20,1>, <-5.52,-20,2.28> }
		triangle { <-5.79,-20,1>, <-3.79,-20,1>, <-3.79,-12,1> }
		triangle { <-3.79,-12,1>, <-5.79,-12,1>, <-5.79,-20,1> }
		triangle { <-5.79,-12,1>, <-3.79,-12,1>, <-4,-12,0> }
		triangle { <-4,-12,0>, <-6,-12,0>, <-5.79,-12,1> }
		triangle { <0,-20,-6>, <0,-20,-4>, <1.52,-20,-3.68> }
		triangle { <1.52,-20,-3.68>, <2.28,-20,-5.52>, <0,-20,-6> }
		triangle { <2.28,-20,-5.52>, <1.52,-20,-3.68>, <2.84,-20,-2.84> }
		triangle { <2.84,-20,-2.84>, <4.26,-20,-4.26>, <2.28,-20,-5.52> }
		triangle { <4.26,-20,-4.26>, <2.84,-20,-2.84>, <3.68,-20,-1.52> }
		triangle { <3.68,-20,-1.52>, <5.52,-20,-2.28>, <4.26,-20,-4.26> }
		triangle { <5.52,-20,-2.28>, <3.68,-20,-1.52>, <3.79,-20,-1> }
		triangle { <3.79,-20,-1>, <5.79,-20,-1>, <5.52,-20,-2.28> }
		triangle { <5.79,-20,-1>, <3.79,-20,-1>, <3.79,-12,-1> }
		triangle { <3.79,-12,-1>, <5.79,-12,-1>, <5.79,-20,-1> }
		triangle { <5.79,-12,-1>, <3.79,-12,-1>, <4,-12,0> }
		triangle { <4,-12,0>, <6,-12,0>, <5.79,-12,-1> }
		triangle { <0,-20,-6>, <0,-20,-4>, <-1.52,-20,-3.68> }
		triangle { <-1.52,-20,-3.68>, <-2.28,-20,-5.52>, <0,-20,-6> }
		triangle { <-2.28,-20,-5.52>, <-1.52,-20,-3.68>, <-2.84,-20,-2.84> }
		triangle { <-2.84,-20,-2.84>, <-4.26,-20,-4.26>, <-2.28,-20,-5.52> }
		triangle { <-4.26,-20,-4.26>, <-2.84,-20,-2.84>, <-3.68,-20,-1.52> }
		triangle { <-3.68,-20,-1.52>, <-5.52,-20,-2.28>, <-4.26,-20,-4.26> }
		triangle { <-5.52,-20,-2.28>, <-3.68,-20,-1.52>, <-3.79,-20,-1> }
		triangle { <-3.79,-20,-1>, <-5.79,-20,-1>, <-5.52,-20,-2.28> }
		triangle { <-5.79,-20,-1>, <-3.79,-20,-1>, <-3.79,-12,-1> }
		triangle { <-3.79,-12,-1>, <-5.79,-12,-1>, <-5.79,-20,-1> }
		triangle { <-5.79,-12,-1>, <-3.79,-12,-1>, <-4,-12,0> }
		triangle { <-4,-12,0>, <-6,-12,0>, <-5.79,-12,-1> }
		triangle { <0,-12,6>, <0,-20,6>, <2.28,-20,5.52> }
		triangle { <2.28,-20,5.52>, <2.28,-12,5.52>, <0,-12,6> }
		triangle { <2.28,-12,5.52>, <2.28,-20,5.52>, <4.26,-20,4.26> }
		triangle { <4.26,-20,4.26>, <4.26,-12,4.26>, <2.28,-12,5.52> }
		triangle { <4.26,-12,4.26>, <4.26,-20,4.26>, <5.52,-20,2.28> }
		triangle { <5.52,-20,2.28>, <5.52,-12,2.28>, <4.26,-12,4.26> }
		triangle { <5.52,-12,2.28>, <5.52,-20,2.28>, <5.79,-20,1> }
		triangle { <5.79,-20,1>, <5.79,-12,1>, <5.52,-12,2.28> }
		triangle { <0,-12,6>, <0,-20,6>, <-2.28,-20,5.52> }
		triangle { <-2.28,-20,5.52>, <-2.28,-12,5.52>, <0,-12,6> }
		triangle { <-2.28,-12,5.52>, <-2.28,-20,5.52>, <-4.26,-20,4.26> }
		triangle { <-4.26,-20,4.26>, <-4.26,-12,4.26>, <-2.28,-12,5.52> }
		triangle { <-4.26,-12,4.26>, <-4.26,-20,4.26>, <-5.52,-20,2.28> }
		triangle { <-5.52,-20,2.28>, <-5.52,-12,2.28>, <-4.26,-12,4.26> }
		triangle { <-5.52,-12,2.28>, <-5.52,-20,2.28>, <-5.79,-20,1> }
		triangle { <-5.79,-20,1>, <-5.79,-12,1>, <-5.52,-12,2.28> }
		triangle { <0,-12,-6>, <0,-20,-6>, <2.28,-20,-5.52> }
		triangle { <2.28,-20,-5.52>, <2.28,-12,-5.52>, <0,-12,-6> }
		triangle { <2.28,-12,-5.52>, <2.28,-20,-5.52>, <4.26,-20,-4.26> }
		triangle { <4.26,-20,-4.26>, <4.26,-12,-4.26>, <2.28,-12,-5.52> }
		triangle { <4.26,-12,-4.26>, <4.26,-20,-4.26>, <5.52,-20,-2.28> }
		triangle { <5.52,-20,-2.28>, <5.52,-12,-2.28>, <4.26,-12,-4.26> }
		triangle { <5.52,-12,-2.28>, <5.52,-20,-2.28>, <5.79,-20,-1> }
		triangle { <5.79,-20,-1>, <5.79,-12,-1>, <5.52,-12,-2.28> }
		triangle { <0,-12,-6>, <0,-20,-6>, <-2.28,-20,-5.52> }
		triangle { <-2.28,-20,-5.52>, <-2.28,-12,-5.52>, <0,-12,-6> }
		triangle { <-2.28,-12,-5.52>, <-2.28,-20,-5.52>, <-4.26,-20,-4.26> }
		triangle { <-4.26,-20,-4.26>, <-4.26,-12,-4.26>, <-2.28,-12,-5.52> }
		triangle { <-4.26,-12,-4.26>, <-4.26,-20,-4.26>, <-5.52,-20,-2.28> }
		triangle { <-5.52,-20,-2.28>, <-5.52,-12,-2.28>, <-4.26,-12,-4.26> }
		triangle { <-5.52,-12,-2.28>, <-5.52,-20,-2.28>, <-5.79,-20,-1> }
		triangle { <-5.79,-20,-1>, <-5.79,-12,-1>, <-5.52,-12,-2.28> }
		triangle { <0,-12,4>, <0,-20,4>, <1.52,-20,3.68> }
		triangle { <1.52,-20,3.68>, <1.52,-12,3.68>, <0,-12,4> }
		triangle { <1.52,-12,3.68>, <1.52,-20,3.68>, <2.84,-20,2.84> }
		triangle { <2.84,-20,2.84>, <2.84,-12,2.84>, <1.52,-12,3.68> }
		triangle { <2.84,-12,2.84>, <2.84,-20,2.84>, <3.68,-20,1.52> }
		triangle { <3.68,-20,1.52>, <3.68,-12,1.52>, <2.84,-12,2.84> }
		triangle { <3.68,-12,1.52>, <3.68,-20,1.52>, <3.79,-20,1> }
		triangle { <3.79,-20,1>, <3.79,-12,1>, <3.68,-12,1.52> }
		triangle { <0,-12,4>, <0,-20,4>, <-1.52,-20,3.68> }
		triangle { <-1.52,-20,3.68>, <-1.52,-12,3.68>, <0,-12,4> }
		triangle { <-1.52,-12,3.68>, <-1.52,-20,3.68>, <-2.84,-20,2.84> }
		triangle { <-2.84,-20,2.84>, <-2.84,-12,2.84>, <-1.52,-12,3.68> }
		triangle { <-2.84,-12,2.84>, <-2.84,-20,2.84>, <-3.68,-20,1.52> }
		triangle { <-3.68,-20,1.52>, <-3.68,-12,1.52>, <-2.84,-12,2.84> }
		triangle { <-3.68,-12,1.52>, <-3.68,-20,1.52>, <-3.79,-20,1> }
		triangle { <-3.79,-20,1>, <-3.79,-12,1>, <-3.68,-12,1.52> }
		triangle { <0,-12,-4>, <0,-20,-4>, <1.52,-20,-3.68> }
		triangle { <1.52,-20,-3.68>, <1.52,-12,-3.68>, <0,-12,-4> }
		triangle { <1.52,-12,-3.68>, <1.52,-20,-3.68>, <2.84,-20,-2.84> }
		triangle { <2.84,-20,-2.84>, <2.84,-12,-2.84>, <1.52,-12,-3.68> }
		triangle { <2.84,-12,-2.84>, <2.84,-20,-2.84>, <3.68,-20,-1.52> }
		triangle { <3.68,-20,-1.52>, <3.68,-12,-1.52>, <2.84,-12,-2.84> }
		triangle { <3.68,-12,-1.52>, <3.68,-20,-1.52>, <3.79,-20,-1> }
		triangle { <3.79,-20,-1>, <3.79,-12,-1>, <3.68,-12,-1.52> }
		triangle { <0,-12,-4>, <0,-20,-4>, <-1.52,-20,-3.68> }
		triangle { <-1.52,-20,-3.68>, <-1.52,-12,-3.68>, <0,-12,-4> }
		triangle { <-1.52,-12,-3.68>, <-1.52,-20,-3.68>, <-2.84,-20,-2.84> }
		triangle { <-2.84,-20,-2.84>, <-2.84,-12,-2.84>, <-1.52,-12,-3.68> }
		triangle { <-2.84,-12,-2.84>, <-2.84,-20,-2.84>, <-3.68,-20,-1.52> }
		triangle { <-3.68,-20,-1.52>, <-3.68,-12,-1.52>, <-2.84,-12,-2.84> }
		triangle { <-3.68,-12,-1.52>, <-3.68,-20,-1.52>, <-3.79,-20,-1> }
		triangle { <-3.79,-20,-1>, <-3.79,-12,-1>, <-3.68,-12,-1.52> }
	}
}

#declare _3679_dot_dat = #if (QUAL = 0) box { <-16,-4,-16>, <16,8,16> } #else union {
// Turntable  2 x  2 Plate Top
	object { connect2_dot_dat matrix <0.67,0,0,0,-0.2,0,0,0,0.67,0,4,0> }
	object { _4_dash_4disc_dot_dat matrix <16,0,0,0,1,0,0,0,16,0,0,0> }
	object { _4_dash_4disc_dot_dat matrix <16,0,0,0,1,0,0,0,16,0,4,0> }
	object { _4_dash_4cyli_dot_dat matrix <16,0,0,0,4,0,0,0,16,0,0,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _4315_dot_dat = #if (QUAL = 0) box { <-40,-4,-18>, <40,8,10> } #else union {
// Hinge Plate  1 x  4 with Car Roof Holder
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <40,8,10>, <36,8,6>, <-36,8,6> }
		triangle { <-36,8,6>, <-40,8,10>, <40,8,10> }
		triangle { <-40,8,10>, <-36,8,6>, <-36,8,-6> }
		triangle { <-36,8,-6>, <-40,8,-10>, <-40,8,10> }
		triangle { <-40,8,-10>, <-36,8,-6>, <36,8,-6> }
		triangle { <36,8,-6>, <40,8,-10>, <-40,8,-10> }
		triangle { <40,8,-10>, <36,8,-6>, <36,8,6> }
		triangle { <36,8,6>, <40,8,10>, <40,8,-10> }
		triangle { <40,0,10>, <-40,0,10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <40,0,-10>, <40,0,10> }
		triangle { <40,0,10>, <40,8,10>, <-40,8,10> }
		triangle { <-40,8,10>, <-40,0,10>, <40,0,10> }
		triangle { <-40,0,10>, <-40,8,10>, <-40,8,-10> }
		triangle { <-40,8,-10>, <-40,0,-10>, <-40,0,10> }
		triangle { <-40,0,-10>, <-40,8,-10>, <40,8,-10> }
		triangle { <40,8,-10>, <40,0,-10>, <-40,0,-10> }
		triangle { <40,0,-10>, <40,8,-10>, <40,8,10> }
		triangle { <40,8,10>, <40,0,10>, <40,0,-10> }
		triangle { <40,0,-10>, <40,0,-14>, <40,8,-14> }
		triangle { <40,8,-14>, <40,8,-10>, <40,0,-10> }
		triangle { <36,0,-10>, <36,0,-14>, <36,8,-14> }
		triangle { <36,8,-14>, <36,8,-10>, <36,0,-10> }
		triangle { <22,0,-10>, <22,0,-14>, <22,8,-14> }
		triangle { <22,8,-14>, <22,8,-10>, <22,0,-10> }
		triangle { <18,0,-10>, <18,0,-14>, <18,8,-14> }
		triangle { <18,8,-14>, <18,8,-10>, <18,0,-10> }
		triangle { <2,0,-10>, <2,0,-14>, <2,8,-14> }
		triangle { <2,8,-14>, <2,8,-10>, <2,0,-10> }
		triangle { <-2,0,-10>, <-2,0,-14>, <-2,8,-14> }
		triangle { <-2,8,-14>, <-2,8,-10>, <-2,0,-10> }
		triangle { <-18,0,-10>, <-18,0,-14>, <-18,8,-14> }
		triangle { <-18,8,-14>, <-18,8,-10>, <-18,0,-10> }
		triangle { <-22,0,-10>, <-22,0,-14>, <-22,8,-14> }
		triangle { <-22,8,-14>, <-22,8,-10>, <-22,0,-10> }
		triangle { <-36,0,-10>, <-36,0,-14>, <-36,8,-14> }
		triangle { <-36,8,-14>, <-36,8,-10>, <-36,0,-10> }
		triangle { <-40,0,-10>, <-40,0,-14>, <-40,8,-14> }
		triangle { <-40,8,-14>, <-40,8,-10>, <-40,0,-10> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,40,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,36,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,22,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,18,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,2,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,-2,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,-18,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,-22,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,-36,4,-14> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,-4,-40,4,-14> }
	mesh {
		triangle { <40,8,-10>, <40,8,-14>, <36,8,-14> }
		triangle { <36,8,-14>, <36,8,-10>, <40,8,-10> }
		triangle { <40,0,-14>, <40,0,-10>, <36,0,-10> }
		triangle { <36,0,-10>, <36,0,-14>, <40,0,-14> }
		triangle { <22,8,-10>, <22,8,-14>, <18,8,-14> }
		triangle { <18,8,-14>, <18,8,-10>, <22,8,-10> }
		triangle { <22,0,-14>, <22,0,-10>, <18,0,-10> }
		triangle { <18,0,-10>, <18,0,-14>, <22,0,-14> }
		triangle { <2,8,-10>, <2,8,-14>, <-2,8,-14> }
		triangle { <-2,8,-14>, <-2,8,-10>, <2,8,-10> }
		triangle { <2,0,-14>, <2,0,-10>, <-2,0,-10> }
		triangle { <-2,0,-10>, <-2,0,-14>, <2,0,-14> }
		triangle { <-18,8,-10>, <-18,8,-14>, <-22,8,-14> }
		triangle { <-22,8,-14>, <-22,8,-10>, <-18,8,-10> }
		triangle { <-18,0,-14>, <-18,0,-10>, <-22,0,-10> }
		triangle { <-22,0,-10>, <-22,0,-14>, <-18,0,-14> }
		triangle { <-36,8,-10>, <-36,8,-14>, <-40,8,-14> }
		triangle { <-40,8,-14>, <-40,8,-10>, <-36,8,-10> }
		triangle { <-36,0,-14>, <-36,0,-10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,0,-14>, <-36,0,-14> }
	}
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-4,0,0,0,0,-4,40,4,-14> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-4,0,0,0,0,-4,22,4,-14> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-4,0,0,0,0,-4,2,4,-14> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-4,0,0,0,0,-4,-18,4,-14> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-4,0,0,0,0,-4,-36,4,-14> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
	#end
}
#end

#declare _4032_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else union {
// Plate  2 x  2 Round
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { axlehole_dot_dat matrix <1,0,0,0,4,0,0,0,1,0,0,0> }
	mesh {
		triangle { <20,8,0>, <18.48,8,7.65>, <16,8,11.36> }
		triangle { <16,8,11.36>, <16,8,0>, <20,8,0> }
		triangle { <0,8,20>, <7.65,8,18.48>, <11.36,8,16> }
		triangle { <11.36,8,16>, <0,8,16>, <0,8,20> }
		triangle { <-20,8,0>, <-18.48,8,7.65>, <-16,8,11.36> }
		triangle { <-16,8,11.36>, <-16,8,0>, <-20,8,0> }
		triangle { <0,8,20>, <-7.65,8,18.48>, <-11.36,8,16> }
		triangle { <-11.36,8,16>, <0,8,16>, <0,8,20> }
		triangle { <20,8,0>, <18.48,8,-7.65>, <16,8,-11.36> }
		triangle { <16,8,-11.36>, <16,8,0>, <20,8,0> }
		triangle { <0,8,-20>, <7.65,8,-18.48>, <11.36,8,-16> }
		triangle { <11.36,8,-16>, <0,8,-16>, <0,8,-20> }
		triangle { <-20,8,0>, <-18.48,8,-7.65>, <-16,8,-11.36> }
		triangle { <-16,8,-11.36>, <-16,8,0>, <-20,8,0> }
		triangle { <0,8,-20>, <-7.65,8,-18.48>, <-11.36,8,-16> }
		triangle { <-11.36,8,-16>, <0,8,-16>, <0,8,-20> }
		triangle { <20,8,0>, <20,4,0>, <18.48,4,7.65> }
		triangle { <18.48,4,7.65>, <18.48,8,7.65>, <20,8,0> }
		triangle { <0,8,20>, <0,4,20>, <7.65,4,18.48> }
		triangle { <7.65,4,18.48>, <7.65,8,18.48>, <0,8,20> }
		triangle { <18.48,8,7.65>, <18.48,4,7.65>, <16,4,11.36> }
		triangle { <16,4,11.36>, <16,8,11.36>, <18.48,8,7.65> }
		triangle { <7.65,8,18.48>, <7.65,4,18.48>, <11.36,4,16> }
		triangle { <11.36,4,16>, <11.36,8,16>, <7.65,8,18.48> }
		triangle { <16,8,11.36>, <16,4,11.36>, <16,4,0> }
		triangle { <16,4,0>, <16,8,0>, <16,8,11.36> }
		triangle { <11.36,8,16>, <11.36,4,16>, <0,4,16> }
		triangle { <0,4,16>, <0,8,16>, <11.36,8,16> }
		triangle { <-20,8,0>, <-20,4,0>, <-18.48,4,7.65> }
		triangle { <-18.48,4,7.65>, <-18.48,8,7.65>, <-20,8,0> }
		triangle { <0,8,20>, <0,4,20>, <-7.65,4,18.48> }
		triangle { <-7.65,4,18.48>, <-7.65,8,18.48>, <0,8,20> }
		triangle { <-18.48,8,7.65>, <-18.48,4,7.65>, <-16,4,11.36> }
		triangle { <-16,4,11.36>, <-16,8,11.36>, <-18.48,8,7.65> }
		triangle { <-7.65,8,18.48>, <-7.65,4,18.48>, <-11.36,4,16> }
		triangle { <-11.36,4,16>, <-11.36,8,16>, <-7.65,8,18.48> }
		triangle { <-16,8,11.36>, <-16,4,11.36>, <-16,4,0> }
		triangle { <-16,4,0>, <-16,8,0>, <-16,8,11.36> }
		triangle { <-11.36,8,16>, <-11.36,4,16>, <0,4,16> }
		triangle { <0,4,16>, <0,8,16>, <-11.36,8,16> }
		triangle { <20,8,0>, <20,4,0>, <18.48,4,-7.65> }
		triangle { <18.48,4,-7.65>, <18.48,8,-7.65>, <20,8,0> }
		triangle { <0,8,-20>, <0,4,-20>, <7.65,4,-18.48> }
		triangle { <7.65,4,-18.48>, <7.65,8,-18.48>, <0,8,-20> }
		triangle { <18.48,8,-7.65>, <18.48,4,-7.65>, <16,4,-11.36> }
		triangle { <16,4,-11.36>, <16,8,-11.36>, <18.48,8,-7.65> }
		triangle { <7.65,8,-18.48>, <7.65,4,-18.48>, <11.36,4,-16> }
		triangle { <11.36,4,-16>, <11.36,8,-16>, <7.65,8,-18.48> }
		triangle { <16,8,-11.36>, <16,4,-11.36>, <16,4,0> }
		triangle { <16,4,0>, <16,8,0>, <16,8,-11.36> }
		triangle { <11.36,8,-16>, <11.36,4,-16>, <0,4,-16> }
		triangle { <0,4,-16>, <0,8,-16>, <11.36,8,-16> }
		triangle { <-20,8,0>, <-20,4,0>, <-18.48,4,-7.65> }
		triangle { <-18.48,4,-7.65>, <-18.48,8,-7.65>, <-20,8,0> }
		triangle { <0,8,-20>, <0,4,-20>, <-7.65,4,-18.48> }
		triangle { <-7.65,4,-18.48>, <-7.65,8,-18.48>, <0,8,-20> }
		triangle { <-18.48,8,-7.65>, <-18.48,4,-7.65>, <-16,4,-11.36> }
		triangle { <-16,4,-11.36>, <-16,8,-11.36>, <-18.48,8,-7.65> }
		triangle { <-7.65,8,-18.48>, <-7.65,4,-18.48>, <-11.36,4,-16> }
		triangle { <-11.36,4,-16>, <-11.36,8,-16>, <-7.65,8,-18.48> }
		triangle { <-16,8,-11.36>, <-16,4,-11.36>, <-16,4,0> }
		triangle { <-16,4,0>, <-16,8,0>, <-16,8,-11.36> }
		triangle { <-11.36,8,-16>, <-11.36,4,-16>, <0,4,-16> }
		triangle { <0,4,-16>, <0,8,-16>, <-11.36,8,-16> }
	}
	object { _4_dash_4cyli_dot_dat matrix <20,0,0,0,4,0,0,0,20,0,0,0> }
	mesh {
		triangle { <8,4,0>, <16,4,0>, <16,4,11.36> }
		triangle { <16,4,11.36>, <5.65,4,5.65>, <8,4,0> }
		triangle { <16,4,11.36>, <14.14,4,14.14>, <11.36,4,16> }
		triangle { <11.36,4,16>, <5.65,4,5.65>, <16,4,11.36> }
		triangle { <0,4,8>, <0,4,16>, <11.36,4,16> }
		triangle { <11.36,4,16>, <5.65,4,5.65>, <0,4,8> }
		triangle { <-8,4,0>, <-16,4,0>, <-16,4,11.36> }
		triangle { <-16,4,11.36>, <-5.65,4,5.65>, <-8,4,0> }
		triangle { <-16,4,11.36>, <-14.14,4,14.14>, <-11.36,4,16> }
		triangle { <-11.36,4,16>, <-5.65,4,5.65>, <-16,4,11.36> }
		triangle { <0,4,8>, <0,4,16>, <-11.36,4,16> }
		triangle { <-11.36,4,16>, <-5.65,4,5.65>, <0,4,8> }
		triangle { <8,4,0>, <16,4,0>, <16,4,-11.36> }
		triangle { <16,4,-11.36>, <5.65,4,-5.65>, <8,4,0> }
		triangle { <16,4,-11.36>, <14.14,4,-14.14>, <11.36,4,-16> }
		triangle { <11.36,4,-16>, <5.65,4,-5.65>, <16,4,-11.36> }
		triangle { <0,4,-8>, <0,4,-16>, <11.36,4,-16> }
		triangle { <11.36,4,-16>, <5.65,4,-5.65>, <0,4,-8> }
		triangle { <-8,4,0>, <-16,4,0>, <-16,4,-11.36> }
		triangle { <-16,4,-11.36>, <-5.65,4,-5.65>, <-8,4,0> }
		triangle { <-16,4,-11.36>, <-14.14,4,-14.14>, <-11.36,4,-16> }
		triangle { <-11.36,4,-16>, <-5.65,4,-5.65>, <-16,4,-11.36> }
		triangle { <0,4,-8>, <0,4,-16>, <-11.36,4,-16> }
		triangle { <-11.36,4,-16>, <-5.65,4,-5.65>, <0,4,-8> }
		triangle { <0,0,6>, <-2.3,0,5.54>, <-7.65,0,18.48> }
		triangle { <-7.65,0,18.48>, <0,0,20>, <0,0,6> }
		triangle { <-2.3,0,5.54>, <-4.24,0,4.24>, <-14.14,0,14.14> }
		triangle { <-14.14,0,14.14>, <-7.65,0,18.48>, <-2.3,0,5.54> }
		triangle { <-4.24,0,4.24>, <-5.54,0,2.3>, <-18.48,0,7.65> }
		triangle { <-18.48,0,7.65>, <-14.14,0,14.14>, <-4.24,0,4.24> }
		triangle { <-5.54,0,2.3>, <-6,0,0>, <-20,0,0> }
		triangle { <-20,0,0>, <-18.48,0,7.65>, <-5.54,0,2.3> }
		triangle { <-6,0,0>, <-5.54,0,-2.3>, <-18.48,0,-7.65> }
		triangle { <-18.48,0,-7.65>, <-20,0,0>, <-6,0,0> }
		triangle { <-5.54,0,-2.3>, <-4.24,0,-4.24>, <-14.14,0,-14.14> }
		triangle { <-14.14,0,-14.14>, <-18.48,0,-7.65>, <-5.54,0,-2.3> }
		triangle { <-4.24,0,-4.24>, <-2.3,0,-5.54>, <-7.65,0,-18.48> }
		triangle { <-7.65,0,-18.48>, <-14.14,0,-14.14>, <-4.24,0,-4.24> }
		triangle { <-2.3,0,-5.54>, <0,0,-6>, <0,0,-20> }
		triangle { <0,0,-20>, <-7.65,0,-18.48>, <-2.3,0,-5.54> }
		triangle { <0,0,-6>, <2.3,0,-5.54>, <7.65,0,-18.48> }
		triangle { <7.65,0,-18.48>, <0,0,-20>, <0,0,-6> }
		triangle { <2.3,0,-5.54>, <4.24,0,-4.24>, <14.14,0,-14.14> }
		triangle { <14.14,0,-14.14>, <7.65,0,-18.48>, <2.3,0,-5.54> }
		triangle { <4.24,0,-4.24>, <5.54,0,-2.3>, <18.48,0,-7.65> }
		triangle { <18.48,0,-7.65>, <14.14,0,-14.14>, <4.24,0,-4.24> }
		triangle { <5.54,0,-2.3>, <6,0,0>, <20,0,0> }
		triangle { <20,0,0>, <18.48,0,-7.65>, <5.54,0,-2.3> }
		triangle { <6,0,0>, <5.54,0,2.3>, <18.48,0,7.65> }
		triangle { <18.48,0,7.65>, <20,0,0>, <6,0,0> }
		triangle { <5.54,0,2.3>, <4.24,0,4.24>, <14.14,0,14.14> }
		triangle { <14.14,0,14.14>, <18.48,0,7.65>, <5.54,0,2.3> }
		triangle { <4.24,0,4.24>, <2.3,0,5.54>, <7.65,0,18.48> }
		triangle { <7.65,0,18.48>, <14.14,0,14.14>, <4.24,0,4.24> }
		triangle { <2.3,0,5.54>, <0,0,6>, <0,0,20> }
		triangle { <0,0,20>, <7.65,0,18.48>, <2.3,0,5.54> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _4162_dot_dat = #if (QUAL = 0) box { <-80,0,-10>, <80,8,10> } #else union {
// Tile  1 x  8
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <80,8,10>, <76,8,6>, <-76,8,6> }
		triangle { <-76,8,6>, <-80,8,10>, <80,8,10> }
		triangle { <-80,8,10>, <-76,8,6>, <-76,8,-6> }
		triangle { <-76,8,-6>, <-80,8,-10>, <-80,8,10> }
		triangle { <-80,8,-10>, <-76,8,-6>, <76,8,-6> }
		triangle { <76,8,-6>, <80,8,-10>, <-80,8,-10> }
		triangle { <80,8,-10>, <76,8,-6>, <76,8,6> }
		triangle { <76,8,6>, <80,8,10>, <80,8,-10> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-8,0,0,0,10,0,8,0> }
}
#end

#declare _3022_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,8,20> } #else union {
// Plate  2 x  2
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <20,8,20>, <16,8,16>, <-16,8,16> }
		triangle { <-16,8,16>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,-20>, <16,8,-16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <20,8,-20> }
		triangle { <20,8,20>, <16,8,16>, <16,8,-16> }
		triangle { <16,8,-16>, <20,8,-20>, <20,8,20> }
		triangle { <-20,8,20>, <-16,8,16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <-20,8,20> }
	}
	object { box5_dot_dat matrix <20,0,0,0,-8,0,0,0,20,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _6212_dot_dat = #if (QUAL = 0) box { <-100,-4,-40>, <100,24,40> } #else union {
// Brick  4 x 10
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,80,4,20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,60,4,22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,20,4,22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,-20,4,22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,-60,4,22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-80,4,20> }
	#end
	object { box5_dot_dat matrix <14,0,0,0,20,0,0,0,2,82,4,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
	#end
	object { box5_dot_dat matrix <12,0,0,0,20,0,0,0,2,40,4,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
	#end
	object { box5_dot_dat matrix <12,0,0,0,20,0,0,0,2,0,4,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <12,0,0,0,20,0,0,0,2,-40,4,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <14,0,0,0,20,0,0,0,2,-82,4,0> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,80,4,-20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,60,4,-22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,-20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,20,4,-22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,-20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,-20,4,-22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,-20> }
	#end
	object { box5_dot_dat matrix <2,0,0,0,20,0,0,0,14,-60,4,-22> }
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-80,4,-20> }
	#end
	object { box5_dot_dat matrix <96,0,0,0,-20,0,0,0,36,0,24,0> }
	mesh {
		triangle { <100,24,40>, <96,24,36>, <-96,24,36> }
		triangle { <-96,24,36>, <-100,24,40>, <100,24,40> }
		triangle { <100,24,-40>, <96,24,-36>, <-96,24,-36> }
		triangle { <-96,24,-36>, <-100,24,-40>, <100,24,-40> }
		triangle { <100,24,40>, <96,24,36>, <96,24,-36> }
		triangle { <96,24,-36>, <100,24,-40>, <100,24,40> }
		triangle { <-100,24,40>, <-96,24,36>, <-96,24,-36> }
		triangle { <-96,24,-36>, <-100,24,-40>, <-100,24,40> }
	}
	object { box5_dot_dat matrix <100,0,0,0,-24,0,0,0,40,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,-30> }
	#end
}
#end

#declare _2444_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,20,20> } #else union {
// Plate  2 x  2 with Hole
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-10,4,0> }
	#end
	object { peghole_dot_dat matrix <0,1,0,-1,0,0,0,0,1,20,10,0> }
	object { _2_dash_4ndis_dot_dat matrix <0,0,8,1,0,0,0,-8,0,20,10,0> }
	object { _2_dash_4ndis_dot_dat matrix <0,0,6,1,0,0,0,-6,0,2,10,0> }
	object { _4_dash_4cyli_dot_dat matrix <0,6,0,-16,0,0,0,0,6,18,10,0> }
	object { _2_dash_4cyli_dot_dat matrix <0,0,10,-18,0,0,0,10,0,20,10,0> }
	mesh {
		triangle { <20,8,10>, <16,8,10>, <16,8,16> }
		triangle { <16,8,16>, <20,8,20>, <20,8,10> }
		triangle { <20,8,20>, <16,8,16>, <-16,8,16> }
		triangle { <-16,8,16>, <-20,8,20>, <20,8,20> }
		triangle { <-20,8,20>, <-16,8,16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <-20,8,20> }
		triangle { <-20,8,-20>, <-16,8,-16>, <16,8,-16> }
		triangle { <16,8,-16>, <20,8,-20>, <-20,8,-20> }
		triangle { <20,8,-20>, <16,8,-16>, <16,8,-10> }
		triangle { <16,8,-10>, <20,8,-10>, <20,8,-20> }
		triangle { <16,4,16>, <16,4,10>, <2,4,10> }
		triangle { <2,4,10>, <-16,4,16>, <16,4,16> }
		triangle { <16,4,-16>, <16,4,-10>, <2,4,-10> }
		triangle { <2,4,-10>, <-16,4,-16>, <16,4,-16> }
		triangle { <-16,4,16>, <2,4,10>, <2,4,-10> }
		triangle { <2,4,-10>, <-16,4,-16>, <-16,4,16> }
		triangle { <20,0,20>, <-20,0,20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <20,0,-20>, <20,0,20> }
		triangle { <20,10,10>, <20,10,8>, <20,8,8> }
		triangle { <20,8,8>, <20,8,10>, <20,10,10> }
		triangle { <20,10,-10>, <20,10,-8>, <20,8,-8> }
		triangle { <20,8,-8>, <20,8,-10>, <20,10,-10> }
		triangle { <20,8,20>, <20,0,20>, <20,2,8> }
		triangle { <20,2,8>, <20,8,8>, <20,8,20> }
		triangle { <20,8,-20>, <20,0,-20>, <20,2,-8> }
		triangle { <20,2,-8>, <20,8,-8>, <20,8,-20> }
		triangle { <20,0,20>, <20,2,8>, <20,2,-8> }
		triangle { <20,2,-8>, <20,0,-20>, <20,0,20> }
		triangle { <16,8,16>, <16,4,16>, <16,4,10> }
		triangle { <16,4,10>, <16,8,10>, <16,8,16> }
		triangle { <16,8,-16>, <16,4,-16>, <16,4,-10> }
		triangle { <16,4,-10>, <16,8,-10>, <16,8,-16> }
		triangle { <2,10,10>, <2,4,10>, <2,4,6> }
		triangle { <2,4,6>, <2,10,6>, <2,10,10> }
		triangle { <2,10,-10>, <2,4,-10>, <2,4,-6> }
		triangle { <2,4,-6>, <2,10,-6>, <2,10,-10> }
		triangle { <-16,8,16>, <-16,4,16>, <-16,4,-16> }
		triangle { <-16,4,-16>, <-16,8,-16>, <-16,8,16> }
		triangle { <-20,8,20>, <-20,0,20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,8,-20>, <-20,8,20> }
		triangle { <20,8,20>, <20,0,20>, <-20,0,20> }
		triangle { <-20,0,20>, <-20,8,20>, <20,8,20> }
		triangle { <16,8,16>, <16,4,16>, <-16,4,16> }
		triangle { <-16,4,16>, <-16,8,16>, <16,8,16> }
		triangle { <20,10,10>, <20,8,10>, <16,8,10> }
		triangle { <16,8,10>, <2,10,10>, <20,10,10> }
		triangle { <16,8,10>, <16,4,10>, <2,4,10> }
		triangle { <2,4,10>, <2,10,10>, <16,8,10> }
		triangle { <20,10,-10>, <20,8,-10>, <16,8,-10> }
		triangle { <16,8,-10>, <2,10,-10>, <20,10,-10> }
		triangle { <16,8,-10>, <16,4,-10>, <2,4,-10> }
		triangle { <2,4,-10>, <2,10,-10>, <16,8,-10> }
		triangle { <16,8,-16>, <16,4,-16>, <-16,4,-16> }
		triangle { <-16,4,-16>, <-16,8,-16>, <16,8,-16> }
		triangle { <20,8,-20>, <20,0,-20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-20,8,-20>, <20,8,-20> }
		triangle { <20,10,-8>, <20,13.06,-7.39>, <20,13.83,-9.24> }
		triangle { <20,13.83,-9.24>, <20,10,-10>, <20,10,-8> }
		triangle { <2,10,-6>, <2,12.3,-5.54>, <2,13.83,-9.24> }
		triangle { <2,13.83,-9.24>, <2,10,-10>, <2,10,-6> }
		triangle { <20,13.06,-7.39>, <20,15.66,-5.66>, <20,17.07,-7.07> }
		triangle { <20,17.07,-7.07>, <20,13.83,-9.24>, <20,13.06,-7.39> }
		triangle { <2,12.3,-5.54>, <2,14.24,-4.24>, <2,17.07,-7.07> }
		triangle { <2,17.07,-7.07>, <2,13.83,-9.24>, <2,12.3,-5.54> }
		triangle { <20,15.66,-5.66>, <20,17.39,-3.06>, <20,19.24,-3.83> }
		triangle { <20,19.24,-3.83>, <20,17.07,-7.07>, <20,15.66,-5.66> }
		triangle { <2,14.24,-4.24>, <2,15.54,-2.3>, <2,19.24,-3.83> }
		triangle { <2,19.24,-3.83>, <2,17.07,-7.07>, <2,14.24,-4.24> }
		triangle { <20,17.39,-3.06>, <20,18,0>, <20,20,0> }
		triangle { <20,20,0>, <20,19.24,-3.83>, <20,17.39,-3.06> }
		triangle { <2,15.54,-2.3>, <2,16,0>, <2,20,0> }
		triangle { <2,20,0>, <2,19.24,-3.83>, <2,15.54,-2.3> }
		triangle { <20,18,0>, <20,17.39,3.06>, <20,19.24,3.83> }
		triangle { <20,19.24,3.83>, <20,20,0>, <20,18,0> }
		triangle { <2,16,0>, <2,15.54,2.3>, <2,19.24,3.83> }
		triangle { <2,19.24,3.83>, <2,20,0>, <2,16,0> }
		triangle { <20,17.39,3.06>, <20,15.66,5.66>, <20,17.07,7.07> }
		triangle { <20,17.07,7.07>, <20,19.24,3.83>, <20,17.39,3.06> }
		triangle { <2,15.54,2.3>, <2,14.24,4.24>, <2,17.07,7.07> }
		triangle { <2,17.07,7.07>, <2,19.24,3.83>, <2,15.54,2.3> }
		triangle { <20,15.66,5.66>, <20,13.06,7.39>, <20,13.83,9.24> }
		triangle { <20,13.83,9.24>, <20,17.07,7.07>, <20,15.66,5.66> }
		triangle { <2,14.24,4.24>, <2,12.3,5.54>, <2,13.83,9.24> }
		triangle { <2,13.83,9.24>, <2,17.07,7.07>, <2,14.24,4.24> }
		triangle { <20,13.06,7.39>, <20,10,8>, <20,10,10> }
		triangle { <20,10,10>, <20,13.83,9.24>, <20,13.06,7.39> }
		triangle { <2,12.3,5.54>, <2,10,6>, <2,10,10> }
		triangle { <2,10,10>, <2,13.83,9.24>, <2,12.3,5.54> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _3039_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,24,10> } #else union {
// Slope Brick 45  2 x  2
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,0,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,0,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,0,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,0,12,-10> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-26> }
		triangle { <-16,24,-26>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,24,-30>, <-16,24,-26>, <16,24,-26> }
		triangle { <16,24,-26>, <20,24,-30>, <-20,24,-30> }
		triangle { <20,24,-30>, <16,24,-26>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-30> }
		triangle { <16,4,6>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,4,6>, <16,4,6> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <16,24,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,24,6>, <16,24,6> }
		triangle { <16,24,-26>, <16,20,-26>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <16,24,-26> }
		triangle { <20,24,-30>, <20,20,-30>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <20,24,-30> }
		triangle { <20,24,10>, <20,0,10>, <20,20,-30> }
		triangle { <20,20,-30>, <20,24,-30>, <20,24,10> }
		triangle { <20,0,10>, <20,0,-10>, <20,20,-30> }
		triangle { <16,24,6>, <16,4,6>, <16,20,-26> }
		triangle { <16,20,-26>, <16,24,-26>, <16,24,6> }
		triangle { <16,4,6>, <16,4,-10>, <16,20,-26> }
		triangle { <-16,24,6>, <-16,4,6>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <-16,24,6> }
		triangle { <-16,4,6>, <-16,4,-10>, <-16,20,-26> }
		triangle { <-20,24,10>, <-20,0,10>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-20,20,-30> }
		triangle { <16,20,-26>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,20,-26>, <16,20,-26> }
		triangle { <20,20,-30>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,20,-30>, <20,20,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
	#end
}
#end

#declare _3039p05_dot_dat = #if (QUAL = 0) box { <-20,-4,-30>, <20,24,10> } #else union {
// Slope Brick 45  2 x  2 with Black Grille Pattern
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,0,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,0,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,0,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,0,12,-10> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-26> }
		triangle { <-16,24,-26>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,24,-30>, <-16,24,-26>, <16,24,-26> }
		triangle { <16,24,-26>, <20,24,-30>, <-20,24,-30> }
		triangle { <20,24,-30>, <16,24,-26>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-30> }
		triangle { <16,4,6>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,4,6>, <16,4,6> }
		triangle { <20,0,10>, <20,0,-10>, <-20,0,-10> }
		triangle { <-20,0,-10>, <-20,0,10>, <20,0,10> }
		triangle { <20,24,10>, <20,0,10>, <-20,0,10> }
		triangle { <-20,0,10>, <-20,24,10>, <20,24,10> }
		triangle { <16,24,6>, <16,4,6>, <-16,4,6> }
		triangle { <-16,4,6>, <-16,24,6>, <16,24,6> }
		triangle { <16,24,-26>, <16,20,-26>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <16,24,-26> }
		triangle { <20,24,-30>, <20,20,-30>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <20,24,-30> }
		triangle { <20,24,10>, <20,0,10>, <20,20,-30> }
		triangle { <20,20,-30>, <20,24,-30>, <20,24,10> }
		triangle { <20,0,10>, <20,0,-10>, <20,20,-30> }
		triangle { <16,24,6>, <16,4,6>, <16,20,-26> }
		triangle { <16,20,-26>, <16,24,-26>, <16,24,6> }
		triangle { <16,4,6>, <16,4,-10>, <16,20,-26> }
		triangle { <-16,24,6>, <-16,4,6>, <-16,20,-26> }
		triangle { <-16,20,-26>, <-16,24,-26>, <-16,24,6> }
		triangle { <-16,4,6>, <-16,4,-10>, <-16,20,-26> }
		triangle { <-20,24,10>, <-20,0,10>, <-20,20,-30> }
		triangle { <-20,20,-30>, <-20,24,-30>, <-20,24,10> }
		triangle { <-20,0,10>, <-20,0,-10>, <-20,20,-30> }
		triangle { <16,20,-26>, <16,4,-10>, <-16,4,-10> }
		triangle { <-16,4,-10>, <-16,20,-26>, <16,20,-26> }
// 4 16 20 20 -30 20 0 -10 -20 0 -10 -20 20 -30
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
	#end
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,-15,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,-10,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,-5,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,0,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,5,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,10,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,1,1,0,0,8,-8,15,10,-20> #if (ver >= 3.1) material #else texture #end { Color0 } }
	mesh {
		triangle { <20,20,-30>, <16,18,-28>, <-16,18,-28> }
		triangle { <-16,18,-28>, <-20,20,-30>, <20,20,-30> }
		triangle { <-20,20,-30>, <-16,18,-28>, <-16,2,-12> }
		triangle { <-16,2,-12>, <-20,0,-10>, <-20,20,-30> }
		triangle { <-20,0,-10>, <-16,2,-12>, <16,2,-12> }
		triangle { <16,2,-12>, <20,0,-10>, <-20,0,-10> }
		triangle { <20,0,-10>, <16,2,-12>, <16,18,-28> }
		triangle { <16,18,-28>, <20,20,-30>, <20,0,-10> }
		triangle { <14,18,-28>, <14,2,-12>, <11,2,-12> }
		triangle { <11,2,-12>, <11,18,-28>, <14,18,-28> }
		triangle { <9,18,-28>, <9,2,-12>, <6,2,-12> }
		triangle { <6,2,-12>, <6,18,-28>, <9,18,-28> }
		triangle { <4,18,-28>, <4,2,-12>, <1,2,-12> }
		triangle { <1,2,-12>, <1,18,-28>, <4,18,-28> }
		triangle { <-1,18,-28>, <-1,2,-12>, <-4,2,-12> }
		triangle { <-4,2,-12>, <-4,18,-28>, <-1,18,-28> }
		triangle { <-6,18,-28>, <-6,2,-12>, <-9,2,-12> }
		triangle { <-9,2,-12>, <-9,18,-28>, <-6,18,-28> }
		triangle { <-11,18,-28>, <-11,2,-12>, <-14,2,-12> }
		triangle { <-14,2,-12>, <-14,18,-28>, <-11,18,-28> }
	}
}
#end

#declare _3038_dot_dat = #if (QUAL = 0) box { <-30,-4,-30>, <30,24,10> } #else union {
// Slope Brick 45  2 x  3
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,10,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,10,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,10,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,10,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,10,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,10,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,10,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,10,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,10,12,-10> }
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-10,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,-10,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,-10,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,-10,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,-10,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,-10,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,-10,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,-10,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,-10,12,-10> }
	mesh {
		triangle { <30,24,10>, <26,24,6>, <-26,24,6> }
		triangle { <-26,24,6>, <-30,24,10>, <30,24,10> }
		triangle { <-30,24,10>, <-26,24,6>, <-26,24,-26> }
		triangle { <-26,24,-26>, <-30,24,-30>, <-30,24,10> }
		triangle { <-30,24,-30>, <-26,24,-26>, <26,24,-26> }
		triangle { <26,24,-26>, <30,24,-30>, <-30,24,-30> }
		triangle { <30,24,-30>, <26,24,-26>, <26,24,6> }
		triangle { <26,24,6>, <30,24,10>, <30,24,-30> }
		triangle { <26,4,6>, <26,4,-10>, <-26,4,-10> }
		triangle { <-26,4,-10>, <-26,4,6>, <26,4,6> }
		triangle { <30,0,10>, <30,0,-10>, <-30,0,-10> }
		triangle { <-30,0,-10>, <-30,0,10>, <30,0,10> }
		triangle { <30,24,10>, <30,0,10>, <-30,0,10> }
		triangle { <-30,0,10>, <-30,24,10>, <30,24,10> }
		triangle { <26,24,6>, <26,4,6>, <-26,4,6> }
		triangle { <-26,4,6>, <-26,24,6>, <26,24,6> }
		triangle { <26,24,-26>, <26,20,-26>, <-26,20,-26> }
		triangle { <-26,20,-26>, <-26,24,-26>, <26,24,-26> }
		triangle { <30,24,-30>, <30,20,-30>, <-30,20,-30> }
		triangle { <-30,20,-30>, <-30,24,-30>, <30,24,-30> }
		triangle { <30,24,10>, <30,0,10>, <30,20,-30> }
		triangle { <30,20,-30>, <30,24,-30>, <30,24,10> }
		triangle { <30,0,10>, <30,0,-10>, <30,20,-30> }
		triangle { <26,24,6>, <26,4,6>, <26,20,-26> }
		triangle { <26,20,-26>, <26,24,-26>, <26,24,6> }
		triangle { <26,4,6>, <26,4,-10>, <26,20,-26> }
		triangle { <-26,24,6>, <-26,4,6>, <-26,20,-26> }
		triangle { <-26,20,-26>, <-26,24,-26>, <-26,24,6> }
		triangle { <-26,4,6>, <-26,4,-10>, <-26,20,-26> }
		triangle { <-30,24,10>, <-30,0,10>, <-30,20,-30> }
		triangle { <-30,20,-30>, <-30,24,-30>, <-30,24,10> }
		triangle { <-30,0,10>, <-30,0,-10>, <-30,20,-30> }
		triangle { <26,20,-26>, <26,4,-10>, <-26,4,-10> }
		triangle { <-26,4,-10>, <-26,20,-26>, <26,20,-26> }
		triangle { <30,20,-30>, <30,0,-10>, <-30,0,-10> }
		triangle { <-30,0,-10>, <-30,20,-30>, <30,20,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-20,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,20,0,0> }
	#end
}
#end

#declare _3037_dot_dat = #if (QUAL = 0) box { <-40,-4,-30>, <40,24,10> } #else union {
// Slope Brick 45  2 x  4
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,20,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,20,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,20,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,20,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,20,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,20,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,20,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,20,12,-10> }
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,-20,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,-20,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,-20,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,-20,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,-20,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,-20,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,-20,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,-20,12,-10> }
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,6,0,0,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-6,0,-6,0,-6,0,0,0,10,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,16,0,0,0,6,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <6,0,0,0,10,0,0,0,-6,0,10,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,8,0,0,0,12,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-8,0,-8,0,-8,0,0,0,12,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,16,0,0,0,8,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,8,0,0,0,-8,0,12,-10> }
	mesh {
		triangle { <40,24,10>, <36,24,6>, <-36,24,6> }
		triangle { <-36,24,6>, <-40,24,10>, <40,24,10> }
		triangle { <-40,24,10>, <-36,24,6>, <-36,24,-26> }
		triangle { <-36,24,-26>, <-40,24,-30>, <-40,24,10> }
		triangle { <-40,24,-30>, <-36,24,-26>, <36,24,-26> }
		triangle { <36,24,-26>, <40,24,-30>, <-40,24,-30> }
		triangle { <40,24,-30>, <36,24,-26>, <36,24,6> }
		triangle { <36,24,6>, <40,24,10>, <40,24,-30> }
		triangle { <36,4,6>, <36,4,-10>, <-36,4,-10> }
		triangle { <-36,4,-10>, <-36,4,6>, <36,4,6> }
		triangle { <40,0,10>, <40,0,-10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,0,10>, <40,0,10> }
		triangle { <40,24,10>, <40,0,10>, <-40,0,10> }
		triangle { <-40,0,10>, <-40,24,10>, <40,24,10> }
		triangle { <36,24,6>, <36,4,6>, <-36,4,6> }
		triangle { <-36,4,6>, <-36,24,6>, <36,24,6> }
		triangle { <36,24,-26>, <36,20,-26>, <-36,20,-26> }
		triangle { <-36,20,-26>, <-36,24,-26>, <36,24,-26> }
		triangle { <40,24,-30>, <40,20,-30>, <-40,20,-30> }
		triangle { <-40,20,-30>, <-40,24,-30>, <40,24,-30> }
		triangle { <40,24,10>, <40,0,10>, <40,20,-30> }
		triangle { <40,20,-30>, <40,24,-30>, <40,24,10> }
		triangle { <40,0,10>, <40,0,-10>, <40,20,-30> }
		triangle { <36,24,6>, <36,4,6>, <36,20,-26> }
		triangle { <36,20,-26>, <36,24,-26>, <36,24,6> }
		triangle { <36,4,6>, <36,4,-10>, <36,20,-26> }
		triangle { <-36,24,6>, <-36,4,6>, <-36,20,-26> }
		triangle { <-36,20,-26>, <-36,24,-26>, <-36,24,6> }
		triangle { <-36,4,6>, <-36,4,-10>, <-36,20,-26> }
		triangle { <-40,24,10>, <-40,0,10>, <-40,20,-30> }
		triangle { <-40,20,-30>, <-40,24,-30>, <-40,24,10> }
		triangle { <-40,0,10>, <-40,0,-10>, <-40,20,-30> }
		triangle { <36,20,-26>, <36,4,-10>, <-36,4,-10> }
		triangle { <-36,4,-10>, <-36,20,-26>, <36,20,-26> }
		triangle { <40,20,-30>, <40,0,-10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,20,-30>, <40,20,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
	#end
}
#end

#declare stud3a_dot_dat = cylinder { <0,0,0>, <0,-4,0>, 4 }

#declare _3040_dot_dat = #if (QUAL = 0) box { <-10,-4,-30>, <10,24,10> } #else union {
// Slope Brick 45  2 x  1
	#if (STUDS)
		object { stud3a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,-10> }
	#end
	object { _1_dash_4cyls_dot_dat matrix <0,0,-4,0,-4,0,4,0,0,0,8,-10> }
	object { _1_dash_4cyls_dot_dat matrix <0,0,-4,0,-4,0,-4,0,0,0,8,-10> }
	object { _2_dash_4cyli_dot_dat matrix <4,0,0,0,16,0,0,0,4,0,4,-10> }
	object { _2_dash_4cyli_dot_dat matrix <4,0,0,0,12,0,0,0,-4,0,8,-10> }
	mesh {
		triangle { <10,24,10>, <6,24,6>, <-6,24,6> }
		triangle { <-6,24,6>, <-10,24,10>, <10,24,10> }
		triangle { <-10,24,10>, <-6,24,6>, <-6,24,-26> }
		triangle { <-6,24,-26>, <-10,24,-30>, <-10,24,10> }
		triangle { <-10,24,-30>, <-6,24,-26>, <6,24,-26> }
		triangle { <6,24,-26>, <10,24,-30>, <-10,24,-30> }
		triangle { <10,24,-30>, <6,24,-26>, <6,24,6> }
		triangle { <6,24,6>, <10,24,10>, <10,24,-30> }
		triangle { <6,4,6>, <6,4,-10>, <-6,4,-10> }
		triangle { <-6,4,-10>, <-6,4,6>, <6,4,6> }
		triangle { <10,0,10>, <10,0,-10>, <-10,0,-10> }
		triangle { <-10,0,-10>, <-10,0,10>, <10,0,10> }
		triangle { <10,24,10>, <10,0,10>, <-10,0,10> }
		triangle { <-10,0,10>, <-10,24,10>, <10,24,10> }
		triangle { <6,24,6>, <6,4,6>, <-6,4,6> }
		triangle { <-6,4,6>, <-6,24,6>, <6,24,6> }
		triangle { <6,24,-26>, <6,20,-26>, <-6,20,-26> }
		triangle { <-6,20,-26>, <-6,24,-26>, <6,24,-26> }
		triangle { <10,24,-30>, <10,20,-30>, <-10,20,-30> }
		triangle { <-10,20,-30>, <-10,24,-30>, <10,24,-30> }
		triangle { <10,24,10>, <10,0,10>, <10,20,-30> }
		triangle { <10,20,-30>, <10,24,-30>, <10,24,10> }
		triangle { <10,0,10>, <10,0,-10>, <10,20,-30> }
		triangle { <6,24,6>, <6,4,6>, <6,20,-26> }
		triangle { <6,20,-26>, <6,24,-26>, <6,24,6> }
		triangle { <6,4,6>, <6,4,-10>, <6,20,-26> }
		triangle { <-6,24,6>, <-6,4,6>, <-6,20,-26> }
		triangle { <-6,20,-26>, <-6,24,-26>, <-6,24,6> }
		triangle { <-6,4,6>, <-6,4,-10>, <-6,20,-26> }
		triangle { <-10,24,10>, <-10,0,10>, <-10,20,-30> }
		triangle { <-10,20,-30>, <-10,24,-30>, <-10,24,10> }
		triangle { <-10,0,10>, <-10,0,-10>, <-10,20,-30> }
		triangle { <6,20,-26>, <6,4,-10>, <-6,4,-10> }
		triangle { <-6,4,-10>, <-6,20,-26>, <6,20,-26> }
		triangle { <10,20,-30>, <10,0,-10>, <-10,0,-10> }
		triangle { <-10,0,-10>, <-10,20,-30>, <10,20,-30> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
}
#end

#declare _4274_dot_dat = #if (QUAL = 0) box { <-20,-8,-8>, <4,8,8> } #else union {
// Technic Pin 1/2
	object { connect_dot_dat matrix <0,0,1,1,0,0,0,1,0,0,0,0> }
	#if (STUDS)
		object { stud2a_dot_dat matrix <0,0,1,-1,0,0,0,1,0,0,0,0> }
	#end
	mesh {
		triangle { <0,0,6>, <0,-2.3,5.54>, <0,-3.06,7.39> }
		triangle { <0,-3.06,7.39>, <0,0,8>, <0,0,6> }
		triangle { <0,-2.3,5.54>, <0,-4.24,4.24>, <0,-5.66,5.66> }
		triangle { <0,-5.66,5.66>, <0,-3.06,7.39>, <0,-2.3,5.54> }
		triangle { <0,-4.24,4.24>, <0,-5.54,2.3>, <0,-7.39,3.06> }
		triangle { <0,-7.39,3.06>, <0,-5.66,5.66>, <0,-4.24,4.24> }
		triangle { <0,-5.54,2.3>, <0,-6,0>, <0,-8,0> }
		triangle { <0,-8,0>, <0,-7.39,3.06>, <0,-5.54,2.3> }
		triangle { <0,-6,0>, <0,-5.54,-2.3>, <0,-7.39,-3.06> }
		triangle { <0,-7.39,-3.06>, <0,-8,0>, <0,-6,0> }
		triangle { <0,-5.54,-2.3>, <0,-4.24,-4.24>, <0,-5.66,-5.66> }
		triangle { <0,-5.66,-5.66>, <0,-7.39,-3.06>, <0,-5.54,-2.3> }
		triangle { <0,-4.24,-4.24>, <0,-2.3,-5.54>, <0,-3.06,-7.39> }
		triangle { <0,-3.06,-7.39>, <0,-5.66,-5.66>, <0,-4.24,-4.24> }
		triangle { <0,-2.3,-5.54>, <0,0,-6>, <0,0,-8> }
		triangle { <0,0,-8>, <0,-3.06,-7.39>, <0,-2.3,-5.54> }
		triangle { <0,0,-6>, <0,2.3,-5.54>, <0,3.06,-7.39> }
		triangle { <0,3.06,-7.39>, <0,0,-8>, <0,0,-6> }
		triangle { <0,2.3,-5.54>, <0,4.24,-4.24>, <0,5.66,-5.66> }
		triangle { <0,5.66,-5.66>, <0,3.06,-7.39>, <0,2.3,-5.54> }
		triangle { <0,4.24,-4.24>, <0,5.54,-2.3>, <0,7.39,-3.06> }
		triangle { <0,7.39,-3.06>, <0,5.66,-5.66>, <0,4.24,-4.24> }
		triangle { <0,5.54,-2.3>, <0,6,0>, <0,8,0> }
		triangle { <0,8,0>, <0,7.39,-3.06>, <0,5.54,-2.3> }
		triangle { <0,6,0>, <0,5.54,2.3>, <0,7.39,3.06> }
		triangle { <0,7.39,3.06>, <0,8,0>, <0,6,0> }
		triangle { <0,5.54,2.3>, <0,4.24,4.24>, <0,5.66,5.66> }
		triangle { <0,5.66,5.66>, <0,7.39,3.06>, <0,5.54,2.3> }
		triangle { <0,4.24,4.24>, <0,2.3,5.54>, <0,3.06,7.39> }
		triangle { <0,3.06,7.39>, <0,5.66,5.66>, <0,4.24,4.24> }
		triangle { <0,2.3,5.54>, <0,0,6>, <0,0,8> }
		triangle { <0,0,8>, <0,3.06,7.39>, <0,2.3,5.54> }
	}
}
#end

#declare _2431p52_dot_dat = #if (QUAL = 0) box { <-40,0,-10>, <40,8,10> } #else union {
// Tile  1 x  4 with Danger Stripes Black Pattern
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
	#end
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,6,0,8,0> }
	mesh {
		triangle { <40,8,10>, <36,8,6>, <-36,8,6> }
		triangle { <-36,8,6>, <-40,8,10>, <40,8,10> }
		triangle { <-40,8,10>, <-36,8,6>, <-36,8,-6> }
		triangle { <-36,8,-6>, <-40,8,-10>, <-40,8,10> }
		triangle { <-40,8,-10>, <-36,8,-6>, <36,8,-6> }
		triangle { <36,8,-6>, <40,8,-10>, <-40,8,-10> }
		triangle { <40,8,-10>, <36,8,-6>, <36,8,6> }
		triangle { <36,8,6>, <40,8,10>, <40,8,-10> }
	}
	object { box4_dot_dat matrix <40,0,0,0,-8,0,0,0,10,0,8,0> }
	mesh {
		triangle { <40,0,-10>, <35,0,-10>, <40,0,-5> }
		triangle { <-40,0,-10>, <-35,0,-10>, <-40,0,-5> }
		triangle { <40,0,10>, <35,0,10>, <40,0,5> }
		triangle { <-40,0,10>, <-35,0,10>, <-40,0,5> }
		triangle { <25,0,-10>, <15,0,-10>, <35,0,10> }
		triangle { <35,0,10>, <40,0,5>, <25,0,-10> }
		triangle { <5,0,-10>, <-5,0,-10>, <15,0,10> }
		triangle { <15,0,10>, <25,0,10>, <5,0,-10> }
		triangle { <-15,0,-10>, <-25,0,-10>, <-5,0,10> }
		triangle { <-5,0,10>, <5,0,10>, <-15,0,-10> }
		triangle { <-35,0,-10>, <-40,0,-5>, <-25,0,10> }
		triangle { <-25,0,10>, <-15,0,10>, <-35,0,-10> }
	}
	mesh {
		triangle { <35,0,-10>, <25,0,-10>, <40,0,5> }
		triangle { <40,0,5>, <40,0,-5>, <35,0,-10> }
		triangle { <15,0,-10>, <5,0,-10>, <25,0,10> }
		triangle { <25,0,10>, <35,0,10>, <15,0,-10> }
		triangle { <-5,0,-10>, <-15,0,-10>, <5,0,10> }
		triangle { <5,0,10>, <15,0,10>, <-5,0,-10> }
		triangle { <-25,0,-10>, <-35,0,-10>, <-15,0,10> }
		triangle { <-15,0,10>, <-5,0,10>, <-25,0,-10> }
		triangle { <-40,0,-5>, <-40,0,5>, <-35,0,10> }
		triangle { <-35,0,10>, <-25,0,10>, <-40,0,-5> }
// 
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
}
#end

#declare _4150_dot_dat = #if (QUAL = 0) box { <-20,0,-20>, <20,8,20> } #else union {
// Tile  2 x  2 Round
	mesh {
		triangle { <4,8,6>, <6,8,4>, <-4,8,-6> }
		triangle { <-4,8,-6>, <-6,8,-4>, <4,8,6> }
		triangle { <-4,8,6>, <-6,8,4>, <4,8,-6> }
		triangle { <4,8,-6>, <6,8,-4>, <-4,8,6> }
		triangle { <0,8,2>, <4,8,6>, <4,4,6> }
		triangle { <4,4,6>, <0,4,2>, <0,8,2> }
		triangle { <4,8,6>, <6,8,4>, <6,4,4> }
		triangle { <6,4,4>, <4,4,6>, <4,8,6> }
		triangle { <6,8,4>, <2,8,0>, <2,4,0> }
		triangle { <2,4,0>, <6,4,4>, <6,8,4> }
		triangle { <0,8,2>, <-4,8,6>, <-4,4,6> }
		triangle { <-4,4,6>, <0,4,2>, <0,8,2> }
		triangle { <-4,8,6>, <-6,8,4>, <-6,4,4> }
		triangle { <-6,4,4>, <-4,4,6>, <-4,8,6> }
		triangle { <-6,8,4>, <-2,8,0>, <-2,4,0> }
		triangle { <-2,4,0>, <-6,4,4>, <-6,8,4> }
		triangle { <0,8,-2>, <4,8,-6>, <4,4,-6> }
		triangle { <4,4,-6>, <0,4,-2>, <0,8,-2> }
		triangle { <4,8,-6>, <6,8,-4>, <6,4,-4> }
		triangle { <6,4,-4>, <4,4,-6>, <4,8,-6> }
		triangle { <6,8,-4>, <2,8,0>, <2,4,0> }
		triangle { <2,4,0>, <6,4,-4>, <6,8,-4> }
		triangle { <0,8,-2>, <-4,8,-6>, <-4,4,-6> }
		triangle { <-4,4,-6>, <0,4,-2>, <0,8,-2> }
		triangle { <-4,8,-6>, <-6,8,-4>, <-6,4,-4> }
		triangle { <-6,4,-4>, <-4,4,-6>, <-4,8,-6> }
		triangle { <-6,8,-4>, <-2,8,0>, <-2,4,0> }
		triangle { <-2,4,0>, <-6,4,-4>, <-6,8,-4> }
		triangle { <20,8,0>, <18.48,8,7.65>, <16,8,11.36> }
		triangle { <16,8,11.36>, <16,8,0>, <20,8,0> }
		triangle { <0,8,20>, <7.65,8,18.48>, <11.36,8,16> }
		triangle { <11.36,8,16>, <0,8,16>, <0,8,20> }
		triangle { <-20,8,0>, <-18.48,8,7.65>, <-16,8,11.36> }
		triangle { <-16,8,11.36>, <-16,8,0>, <-20,8,0> }
		triangle { <0,8,20>, <-7.65,8,18.48>, <-11.36,8,16> }
		triangle { <-11.36,8,16>, <0,8,16>, <0,8,20> }
		triangle { <20,8,0>, <18.48,8,-7.65>, <16,8,-11.36> }
		triangle { <16,8,-11.36>, <16,8,0>, <20,8,0> }
		triangle { <0,8,-20>, <7.65,8,-18.48>, <11.36,8,-16> }
		triangle { <11.36,8,-16>, <0,8,-16>, <0,8,-20> }
		triangle { <-20,8,0>, <-18.48,8,-7.65>, <-16,8,-11.36> }
		triangle { <-16,8,-11.36>, <-16,8,0>, <-20,8,0> }
		triangle { <0,8,-20>, <-7.65,8,-18.48>, <-11.36,8,-16> }
		triangle { <-11.36,8,-16>, <0,8,-16>, <0,8,-20> }
		triangle { <20,8,0>, <20,4,0>, <18.48,4,7.65> }
		triangle { <18.48,4,7.65>, <18.48,8,7.65>, <20,8,0> }
		triangle { <0,8,20>, <0,4,20>, <7.65,4,18.48> }
		triangle { <7.65,4,18.48>, <7.65,8,18.48>, <0,8,20> }
		triangle { <18.48,8,7.65>, <18.48,4,7.65>, <16,4,11.36> }
		triangle { <16,4,11.36>, <16,8,11.36>, <18.48,8,7.65> }
		triangle { <7.65,8,18.48>, <7.65,4,18.48>, <11.36,4,16> }
		triangle { <11.36,4,16>, <11.36,8,16>, <7.65,8,18.48> }
		triangle { <16,8,11.36>, <16,4,11.36>, <16,4,0> }
		triangle { <16,4,0>, <16,8,0>, <16,8,11.36> }
		triangle { <11.36,8,16>, <11.36,4,16>, <0,4,16> }
		triangle { <0,4,16>, <0,8,16>, <11.36,8,16> }
		triangle { <-20,8,0>, <-20,4,0>, <-18.48,4,7.65> }
		triangle { <-18.48,4,7.65>, <-18.48,8,7.65>, <-20,8,0> }
		triangle { <0,8,20>, <0,4,20>, <-7.65,4,18.48> }
		triangle { <-7.65,4,18.48>, <-7.65,8,18.48>, <0,8,20> }
		triangle { <-18.48,8,7.65>, <-18.48,4,7.65>, <-16,4,11.36> }
		triangle { <-16,4,11.36>, <-16,8,11.36>, <-18.48,8,7.65> }
		triangle { <-7.65,8,18.48>, <-7.65,4,18.48>, <-11.36,4,16> }
		triangle { <-11.36,4,16>, <-11.36,8,16>, <-7.65,8,18.48> }
		triangle { <-16,8,11.36>, <-16,4,11.36>, <-16,4,0> }
		triangle { <-16,4,0>, <-16,8,0>, <-16,8,11.36> }
		triangle { <-11.36,8,16>, <-11.36,4,16>, <0,4,16> }
		triangle { <0,4,16>, <0,8,16>, <-11.36,8,16> }
		triangle { <20,8,0>, <20,4,0>, <18.48,4,-7.65> }
		triangle { <18.48,4,-7.65>, <18.48,8,-7.65>, <20,8,0> }
		triangle { <0,8,-20>, <0,4,-20>, <7.65,4,-18.48> }
		triangle { <7.65,4,-18.48>, <7.65,8,-18.48>, <0,8,-20> }
		triangle { <18.48,8,-7.65>, <18.48,4,-7.65>, <16,4,-11.36> }
		triangle { <16,4,-11.36>, <16,8,-11.36>, <18.48,8,-7.65> }
		triangle { <7.65,8,-18.48>, <7.65,4,-18.48>, <11.36,4,-16> }
		triangle { <11.36,4,-16>, <11.36,8,-16>, <7.65,8,-18.48> }
		triangle { <16,8,-11.36>, <16,4,-11.36>, <16,4,0> }
		triangle { <16,4,0>, <16,8,0>, <16,8,-11.36> }
		triangle { <11.36,8,-16>, <11.36,4,-16>, <0,4,-16> }
		triangle { <0,4,-16>, <0,8,-16>, <11.36,8,-16> }
		triangle { <-20,8,0>, <-20,4,0>, <-18.48,4,-7.65> }
		triangle { <-18.48,4,-7.65>, <-18.48,8,-7.65>, <-20,8,0> }
		triangle { <0,8,-20>, <0,4,-20>, <-7.65,4,-18.48> }
		triangle { <-7.65,4,-18.48>, <-7.65,8,-18.48>, <0,8,-20> }
		triangle { <-18.48,8,-7.65>, <-18.48,4,-7.65>, <-16,4,-11.36> }
		triangle { <-16,4,-11.36>, <-16,8,-11.36>, <-18.48,8,-7.65> }
		triangle { <-7.65,8,-18.48>, <-7.65,4,-18.48>, <-11.36,4,-16> }
		triangle { <-11.36,4,-16>, <-11.36,8,-16>, <-7.65,8,-18.48> }
		triangle { <-16,8,-11.36>, <-16,4,-11.36>, <-16,4,0> }
		triangle { <-16,4,0>, <-16,8,0>, <-16,8,-11.36> }
		triangle { <-11.36,8,-16>, <-11.36,4,-16>, <0,4,-16> }
		triangle { <0,4,-16>, <0,8,-16>, <-11.36,8,-16> }
	}
	object { _4_dash_4cyli_dot_dat matrix <20,0,0,0,4,0,0,0,20,0,0,0> }
	object { _4_dash_4disc_dot_dat matrix <20,0,0,0,1,0,0,0,20,0,4,0> }
	object { _4_dash_4disc_dot_dat matrix <20,0,0,0,1,0,0,0,20,0,0,0> }
}
#end

#declare _3_dash_4disc_dot_dat = object {
	mesh {
		triangle { <0,0,0>, <1,0,0>, <0.9239,0,0.3827> }
		triangle { <0,0,0>, <0.9239,0,0.3827>, <0.7071,0,0.7071> }
		triangle { <0,0,0>, <0.7071,0,0.7071>, <0.3827,0,0.9239> }
		triangle { <0,0,0>, <0.3827,0,0.9239>, <0,0,1> }
		triangle { <0,0,0>, <0,0,1>, <-0.3827,0,0.9239> }
		triangle { <0,0,0>, <-0.3827,0,0.9239>, <-0.7071,0,0.7071> }
		triangle { <0,0,0>, <-0.7071,0,0.7071>, <-0.9239,0,0.3827> }
		triangle { <0,0,0>, <-0.9239,0,0.3827>, <-1,0,0> }
		triangle { <0,0,0>, <-1,0,0>, <-0.9239,0,-0.3827> }
		triangle { <0,0,0>, <-0.9239,0,-0.3827>, <-0.7071,0,-0.7071> }
		triangle { <0,0,0>, <-0.7071,0,-0.7071>, <-0.3827,0,-0.9239> }
		triangle { <0,0,0>, <-0.3827,0,-0.9239>, <0,0,-1> }
	}
}

#declare _4285_dot_dat = #if (QUAL = 0) box { <-60,-4,-60>, <60,16,60> } #else union {
// Space Radar Dish  6 x  6 Webbed
	mesh {
		triangle { <60,10,0>, <58.8,10,11.7>, <58.8,16,11.7> }
		triangle { <58.8,16,11.7>, <60,16,0>, <60,10,0> }
		triangle { <58.8,10,11.7>, <55.44,10,22.98>, <55.44,16,22.98> }
		triangle { <55.44,16,22.98>, <58.8,16,11.7>, <58.8,10,11.7> }
		triangle { <55.44,10,22.98>, <49.8,10,33.36>, <49.8,16,33.36> }
		triangle { <49.8,16,33.36>, <55.44,16,22.98>, <55.44,10,22.98> }
		triangle { <49.8,10,33.36>, <42.42,10,42.42>, <42.42,16,42.42> }
		triangle { <42.42,16,42.42>, <49.8,16,33.36>, <49.8,10,33.36> }
		triangle { <42.42,10,42.42>, <33.36,10,49.8>, <33.36,16,49.8> }
		triangle { <33.36,16,49.8>, <42.42,16,42.42>, <42.42,10,42.42> }
		triangle { <33.36,10,49.8>, <22.98,10,55.44>, <22.98,16,55.44> }
		triangle { <22.98,16,55.44>, <33.36,16,49.8>, <33.36,10,49.8> }
		triangle { <22.98,10,55.44>, <11.7,10,58.8>, <11.7,16,58.8> }
		triangle { <11.7,16,58.8>, <22.98,16,55.44>, <22.98,10,55.44> }
		triangle { <11.7,10,58.8>, <0,10,60>, <0,16,60> }
		triangle { <0,16,60>, <11.7,16,58.8>, <11.7,10,58.8> }
		triangle { <-60,10,0>, <-58.8,10,11.7>, <-58.8,16,11.7> }
		triangle { <-58.8,16,11.7>, <-60,16,0>, <-60,10,0> }
		triangle { <-58.8,10,11.7>, <-55.44,10,22.98>, <-55.44,16,22.98> }
		triangle { <-55.44,16,22.98>, <-58.8,16,11.7>, <-58.8,10,11.7> }
		triangle { <-55.44,10,22.98>, <-49.8,10,33.36>, <-49.8,16,33.36> }
		triangle { <-49.8,16,33.36>, <-55.44,16,22.98>, <-55.44,10,22.98> }
		triangle { <-49.8,10,33.36>, <-42.42,10,42.42>, <-42.42,16,42.42> }
		triangle { <-42.42,16,42.42>, <-49.8,16,33.36>, <-49.8,10,33.36> }
		triangle { <-42.42,10,42.42>, <-33.36,10,49.8>, <-33.36,16,49.8> }
		triangle { <-33.36,16,49.8>, <-42.42,16,42.42>, <-42.42,10,42.42> }
		triangle { <-33.36,10,49.8>, <-22.98,10,55.44>, <-22.98,16,55.44> }
		triangle { <-22.98,16,55.44>, <-33.36,16,49.8>, <-33.36,10,49.8> }
		triangle { <-22.98,10,55.44>, <-11.7,10,58.8>, <-11.7,16,58.8> }
		triangle { <-11.7,16,58.8>, <-22.98,16,55.44>, <-22.98,10,55.44> }
		triangle { <-11.7,10,58.8>, <0,10,60>, <0,16,60> }
		triangle { <0,16,60>, <-11.7,16,58.8>, <-11.7,10,58.8> }
		triangle { <-60,10,0>, <-58.8,10,-11.7>, <-58.8,16,-11.7> }
		triangle { <-58.8,16,-11.7>, <-60,16,0>, <-60,10,0> }
		triangle { <-58.8,10,-11.7>, <-55.44,10,-22.98>, <-55.44,16,-22.98> }
		triangle { <-55.44,16,-22.98>, <-58.8,16,-11.7>, <-58.8,10,-11.7> }
		triangle { <-55.44,10,-22.98>, <-49.8,10,-33.36>, <-49.8,16,-33.36> }
		triangle { <-49.8,16,-33.36>, <-55.44,16,-22.98>, <-55.44,10,-22.98> }
		triangle { <-49.8,10,-33.36>, <-42.42,10,-42.42>, <-42.42,16,-42.42> }
		triangle { <-42.42,16,-42.42>, <-49.8,16,-33.36>, <-49.8,10,-33.36> }
		triangle { <-42.42,10,-42.42>, <-33.36,10,-49.8>, <-33.36,16,-49.8> }
		triangle { <-33.36,16,-49.8>, <-42.42,16,-42.42>, <-42.42,10,-42.42> }
		triangle { <-33.36,10,-49.8>, <-22.98,10,-55.44>, <-22.98,16,-55.44> }
		triangle { <-22.98,16,-55.44>, <-33.36,16,-49.8>, <-33.36,10,-49.8> }
		triangle { <-22.98,10,-55.44>, <-11.7,10,-58.8>, <-11.7,16,-58.8> }
		triangle { <-11.7,16,-58.8>, <-22.98,16,-55.44>, <-22.98,10,-55.44> }
		triangle { <-11.7,10,-58.8>, <0,10,-60>, <0,16,-60> }
		triangle { <0,16,-60>, <-11.7,16,-58.8>, <-11.7,10,-58.8> }
		triangle { <60,10,0>, <58.8,10,-11.7>, <58.8,16,-11.7> }
		triangle { <58.8,16,-11.7>, <60,16,0>, <60,10,0> }
		triangle { <58.8,10,-11.7>, <55.44,10,-22.98>, <55.44,16,-22.98> }
		triangle { <55.44,16,-22.98>, <58.8,16,-11.7>, <58.8,10,-11.7> }
		triangle { <55.44,10,-22.98>, <49.8,10,-33.36>, <49.8,16,-33.36> }
		triangle { <49.8,16,-33.36>, <55.44,16,-22.98>, <55.44,10,-22.98> }
		triangle { <49.8,10,-33.36>, <42.42,10,-42.42>, <42.42,16,-42.42> }
		triangle { <42.42,16,-42.42>, <49.8,16,-33.36>, <49.8,10,-33.36> }
		triangle { <42.42,10,-42.42>, <33.36,10,-49.8>, <33.36,16,-49.8> }
		triangle { <33.36,16,-49.8>, <42.42,16,-42.42>, <42.42,10,-42.42> }
		triangle { <33.36,10,-49.8>, <22.98,10,-55.44>, <22.98,16,-55.44> }
		triangle { <22.98,16,-55.44>, <33.36,16,-49.8>, <33.36,10,-49.8> }
		triangle { <22.98,10,-55.44>, <11.7,10,-58.8>, <11.7,16,-58.8> }
		triangle { <11.7,16,-58.8>, <22.98,16,-55.44>, <22.98,10,-55.44> }
		triangle { <11.7,10,-58.8>, <0,10,-60>, <0,16,-60> }
		triangle { <0,16,-60>, <11.7,16,-58.8>, <11.7,10,-58.8> }
// Inlined: 1 16  0 10.75 0  57 0 0  0 5.25 0  0 0 57  3232cyed.dat
		triangle { <57,10.75,0>, <55.86,10.75,11.115>, <55.86,16,11.115> }
		triangle { <55.86,16,11.115>, <57,16,0>, <57,10.75,0> }
		triangle { <55.86,10.75,11.115>, <52.668,10.75,21.831>, <52.668,16,21.831> }
		triangle { <52.668,16,21.831>, <55.86,16,11.115>, <55.86,10.75,11.115> }
		triangle { <52.668,10.75,21.831>, <47.31,10.75,31.692>, <47.31,16,31.692> }
		triangle { <47.31,16,31.692>, <52.668,16,21.831>, <52.668,10.75,21.831> }
		triangle { <47.31,10.75,31.692>, <40.299,10.75,40.299>, <40.299,16,40.299> }
		triangle { <40.299,16,40.299>, <47.31,16,31.692>, <47.31,10.75,31.692> }
		triangle { <40.299,10.75,40.299>, <31.692,10.75,47.31>, <31.692,16,47.31> }
		triangle { <31.692,16,47.31>, <40.299,16,40.299>, <40.299,10.75,40.299> }
		triangle { <31.692,10.75,47.31>, <21.831,10.75,52.668>, <21.831,16,52.668> }
		triangle { <21.831,16,52.668>, <31.692,16,47.31>, <31.692,10.75,47.31> }
		triangle { <21.831,10.75,52.668>, <11.115,10.75,55.86>, <11.115,16,55.86> }
		triangle { <11.115,16,55.86>, <21.831,16,52.668>, <21.831,10.75,52.668> }
		triangle { <11.115,10.75,55.86>, <0,10.75,57>, <0,16,57> }
		triangle { <0,16,57>, <11.115,16,55.86>, <11.115,10.75,55.86> }
		triangle { <-57,10.75,0>, <-55.86,10.75,11.115>, <-55.86,16,11.115> }
		triangle { <-55.86,16,11.115>, <-57,16,0>, <-57,10.75,0> }
		triangle { <-55.86,10.75,11.115>, <-52.668,10.75,21.831>, <-52.668,16,21.831> }
		triangle { <-52.668,16,21.831>, <-55.86,16,11.115>, <-55.86,10.75,11.115> }
		triangle { <-52.668,10.75,21.831>, <-47.31,10.75,31.692>, <-47.31,16,31.692> }
		triangle { <-47.31,16,31.692>, <-52.668,16,21.831>, <-52.668,10.75,21.831> }
		triangle { <-47.31,10.75,31.692>, <-40.299,10.75,40.299>, <-40.299,16,40.299> }
		triangle { <-40.299,16,40.299>, <-47.31,16,31.692>, <-47.31,10.75,31.692> }
		triangle { <-40.299,10.75,40.299>, <-31.692,10.75,47.31>, <-31.692,16,47.31> }
		triangle { <-31.692,16,47.31>, <-40.299,16,40.299>, <-40.299,10.75,40.299> }
		triangle { <-31.692,10.75,47.31>, <-21.831,10.75,52.668>, <-21.831,16,52.668> }
		triangle { <-21.831,16,52.668>, <-31.692,16,47.31>, <-31.692,10.75,47.31> }
		triangle { <-21.831,10.75,52.668>, <-11.115,10.75,55.86>, <-11.115,16,55.86> }
		triangle { <-11.115,16,55.86>, <-21.831,16,52.668>, <-21.831,10.75,52.668> }
		triangle { <-11.115,10.75,55.86>, <0,10.75,57>, <0,16,57> }
		triangle { <0,16,57>, <-11.115,16,55.86>, <-11.115,10.75,55.86> }
		triangle { <-57,10.75,0>, <-55.86,10.75,-11.115>, <-55.86,16,-11.115> }
		triangle { <-55.86,16,-11.115>, <-57,16,0>, <-57,10.75,0> }
		triangle { <-55.86,10.75,-11.115>, <-52.668,10.75,-21.831>, <-52.668,16,-21.831> }
		triangle { <-52.668,16,-21.831>, <-55.86,16,-11.115>, <-55.86,10.75,-11.115> }
		triangle { <-52.668,10.75,-21.831>, <-47.31,10.75,-31.692>, <-47.31,16,-31.692> }
		triangle { <-47.31,16,-31.692>, <-52.668,16,-21.831>, <-52.668,10.75,-21.831> }
		triangle { <-47.31,10.75,-31.692>, <-40.299,10.75,-40.299>, <-40.299,16,-40.299> }
		triangle { <-40.299,16,-40.299>, <-47.31,16,-31.692>, <-47.31,10.75,-31.692> }
		triangle { <-40.299,10.75,-40.299>, <-31.692,10.75,-47.31>, <-31.692,16,-47.31> }
		triangle { <-31.692,16,-47.31>, <-40.299,16,-40.299>, <-40.299,10.75,-40.299> }
		triangle { <-31.692,10.75,-47.31>, <-21.831,10.75,-52.668>, <-21.831,16,-52.668> }
		triangle { <-21.831,16,-52.668>, <-31.692,16,-47.31>, <-31.692,10.75,-47.31> }
		triangle { <-21.831,10.75,-52.668>, <-11.115,10.75,-55.86>, <-11.115,16,-55.86> }
		triangle { <-11.115,16,-55.86>, <-21.831,16,-52.668>, <-21.831,10.75,-52.668> }
		triangle { <-11.115,10.75,-55.86>, <0,10.75,-57>, <0,16,-57> }
		triangle { <0,16,-57>, <-11.115,16,-55.86>, <-11.115,10.75,-55.86> }
		triangle { <57,10.75,0>, <55.86,10.75,-11.115>, <55.86,16,-11.115> }
		triangle { <55.86,16,-11.115>, <57,16,0>, <57,10.75,0> }
		triangle { <55.86,10.75,-11.115>, <52.668,10.75,-21.831>, <52.668,16,-21.831> }
		triangle { <52.668,16,-21.831>, <55.86,16,-11.115>, <55.86,10.75,-11.115> }
		triangle { <52.668,10.75,-21.831>, <47.31,10.75,-31.692>, <47.31,16,-31.692> }
		triangle { <47.31,16,-31.692>, <52.668,16,-21.831>, <52.668,10.75,-21.831> }
		triangle { <47.31,10.75,-31.692>, <40.299,10.75,-40.299>, <40.299,16,-40.299> }
		triangle { <40.299,16,-40.299>, <47.31,16,-31.692>, <47.31,10.75,-31.692> }
		triangle { <40.299,10.75,-40.299>, <31.692,10.75,-47.31>, <31.692,16,-47.31> }
		triangle { <31.692,16,-47.31>, <40.299,16,-40.299>, <40.299,10.75,-40.299> }
		triangle { <31.692,10.75,-47.31>, <21.831,10.75,-52.668>, <21.831,16,-52.668> }
		triangle { <21.831,16,-52.668>, <31.692,16,-47.31>, <31.692,10.75,-47.31> }
		triangle { <21.831,10.75,-52.668>, <11.115,10.75,-55.86>, <11.115,16,-55.86> }
		triangle { <11.115,16,-55.86>, <21.831,16,-52.668>, <21.831,10.75,-52.668> }
		triangle { <11.115,10.75,-55.86>, <0,10.75,-57>, <0,16,-57> }
		triangle { <0,16,-57>, <11.115,16,-55.86>, <11.115,10.75,-55.86> }
	}
	object { ring1_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	object { ring2_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	object { ring3_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <24,0,0,0,6,0,0,0,24,0,2,0> }
// Inlined: 1 16  0 0 0  1 0 0  0 1 0  0 0 1 1-8web.dat
	mesh {
		triangle { <60,16,0>, <58.63,16,-12.73>, <55.7,16,-12.09> }
		triangle { <55.7,16,-12.09>, <57,16,0>, <60,16,0> }
		triangle { <58.63,16,-12.73>, <55.7,16,-12.09>, <52.66,16,-21.81> }
		triangle { <52.66,16,-21.81>, <55.43,16,-22.96>, <58.63,16,-12.73> }
		triangle { <58.63,16,12.73>, <55.7,16,12.09>, <52.66,16,21.81> }
		triangle { <52.66,16,21.81>, <55.43,16,22.96>, <58.63,16,12.73> }
		triangle { <60,16,0>, <58.63,16,12.73>, <55.7,16,12.09> }
		triangle { <55.7,16,12.09>, <57,16,0>, <60,16,0> }
		triangle { <23.5,0,4>, <23.5,0,-4>, <35.78,2,-4> }
		triangle { <35.78,2,-4>, <35.78,2,4>, <23.5,0,4> }
		triangle { <23.5,2,4>, <23.5,2,-4>, <35.78,4,-4> }
		triangle { <35.78,4,-4>, <35.78,4,4>, <23.5,2,4> }
		triangle { <23.5,0,-4>, <35.78,2,-4>, <35.78,4,-4> }
		triangle { <35.78,4,-4>, <23.5,2,-4>, <23.5,0,-4> }
		triangle { <23.5,0,4>, <35.78,2,4>, <35.78,4,4> }
		triangle { <35.78,4,4>, <23.5,2,4>, <23.5,0,4> }
		triangle { <41.8,3.5,-4>, <53.85,7.5,-4>, <54.85,9.9,-4> }
		triangle { <54.85,9.9,-4>, <41.8,5.5,-4>, <41.8,3.5,-4> }
		triangle { <41.8,3.5,4>, <53.85,7.5,4>, <54.85,9.9,4> }
		triangle { <54.85,9.9,4>, <41.8,5.5,4>, <41.8,3.5,4> }
		triangle { <41.8,3.5,4>, <41.8,3.5,-4>, <53.85,7.5,-4> }
		triangle { <53.85,7.5,-4>, <53.85,7.5,4>, <41.8,3.5,4> }
		triangle { <41.8,5.5,4>, <41.8,5.5,-4>, <54.85,9.9,-4> }
		triangle { <54.85,9.9,-4>, <54.85,9.9,4>, <41.8,5.5,4> }
		triangle { <57,10.75,0>, <55,9.9,0>, <53.94,9.9,-10.73> }
		triangle { <53.94,9.9,-10.73>, <55.9,10.75,-11.12>, <57,10.75,0> }
		triangle { <57,10.75,0>, <55,9.9,0>, <53.94,9.9,10.73> }
		triangle { <53.94,9.9,10.73>, <55.9,10.75,11.12>, <57,10.75,0> }
		triangle { <55.9,10.75,11.12>, <53.94,9.9,10.73>, <50.81,9.9,21.05> }
		triangle { <50.81,9.9,21.05>, <52.66,10.75,21.81>, <55.9,10.75,11.12> }
		triangle { <35.78,2,4>, <35.78,2,-4>, <41.8,3.5,-4> }
		triangle { <41.8,3.5,-4>, <41.8,3.5,4>, <35.78,2,4> }
		triangle { <35.18,2,-7.64>, <33.26,2,-13.78>, <38.8,3.5,-16.07> }
		triangle { <38.8,3.5,-16.07>, <41,3.5,-8.91>, <35.18,2,-7.64> }
		triangle { <35.18,4,-7.64>, <33.26,4,-13.78>, <38.8,5.5,-16.07> }
		triangle { <38.8,5.5,-16.07>, <41,5.5,-8.91>, <35.18,4,-7.64> }
		triangle { <35.18,2,-7.64>, <33.26,2,-13.78>, <33.26,4,-13.78> }
		triangle { <33.26,4,-13.78>, <35.18,4,-7.64>, <35.18,2,-7.64> }
		triangle { <38.8,3.5,-16.07>, <41,3.5,-8.91>, <41,5.5,-8.91> }
		triangle { <41,5.5,-8.91>, <38.8,5.5,-16.07>, <38.8,3.5,-16.07> }
		triangle { <35.78,2,-4>, <35.18,2,-7.64>, <41,3.5,-8.91> }
		triangle { <41,3.5,-8.91>, <41.8,3.5,-4>, <35.78,2,-4> }
		triangle { <35.78,4,-4>, <35.18,4,-7.64>, <41,5.5,-8.91> }
		triangle { <41,5.5,-8.91>, <41.8,5.5,-4>, <35.78,4,-4> }
		triangle { <35.78,2,-4>, <35.18,2,-7.64>, <35.18,4,-7.64> }
		triangle { <35.18,4,-7.64>, <35.78,4,-4>, <35.78,2,-4> }
		triangle { <41,3.5,-8.91>, <41.8,3.5,-4>, <41.8,5.5,-4> }
		triangle { <41.8,5.5,-4>, <41,5.5,-8.91>, <41,3.5,-8.91> }
		triangle { <35.78,2,4>, <35.18,2,7.64>, <41,3.5,8.91> }
		triangle { <41,3.5,8.91>, <41.8,3.5,4>, <35.78,2,4> }
		triangle { <35.78,4,4>, <35.18,4,7.64>, <41,5.5,8.91> }
		triangle { <41,5.5,8.91>, <41.8,5.5,4>, <35.78,4,4> }
		triangle { <35.78,2,4>, <35.18,2,7.64>, <35.18,4,7.64> }
		triangle { <35.18,4,7.64>, <35.78,4,4>, <35.78,2,4> }
		triangle { <41,3.5,8.91>, <41.8,3.5,4>, <41.8,5.5,4> }
		triangle { <41.8,5.5,4>, <41,5.5,8.91>, <41,3.5,8.91> }
		triangle { <35.18,2,7.64>, <33.26,2,13.78>, <38.8,3.5,16.07> }
		triangle { <38.8,3.5,16.07>, <41,3.5,8.91>, <35.18,2,7.64> }
		triangle { <35.18,4,7.64>, <33.26,4,13.78>, <38.8,5.5,16.07> }
		triangle { <38.8,5.5,16.07>, <41,5.5,8.91>, <35.18,4,7.64> }
		triangle { <35.18,2,7.64>, <33.26,2,13.78>, <33.26,4,13.78> }
		triangle { <33.26,4,13.78>, <35.18,4,7.64>, <35.18,2,7.64> }
		triangle { <38.8,3.5,16.07>, <41,3.5,8.91>, <41,5.5,8.91> }
		triangle { <41,5.5,8.91>, <38.8,5.5,16.07>, <38.8,3.5,16.07> }
		triangle { <35.78,4,4>, <35.78,4,-4>, <41.8,5.5,-4> }
		triangle { <41.8,5.5,-4>, <41.8,5.5,4>, <35.78,4,4> }
		triangle { <53.85,7.5,-4>, <53.85,7.5,4>, <60,10,0> }
		triangle { <53.85,7.5,-4>, <60,10,0>, <58.85,10,-12.73> }
		triangle { <58.85,10,-12.73>, <52.77,7.5,-11.46>, <53.85,7.5,-4> }
		triangle { <53.85,7.5,4>, <60,10,0>, <58.85,10,12.73> }
		triangle { <58.85,10,12.73>, <52.77,7.5,11.46>, <53.85,7.5,4> }
		triangle { <52.77,7.5,11.46>, <49.89,7.5,20.66>, <55.43,10,22.96> }
		triangle { <55.43,10,22.96>, <58.85,10,12.73>, <52.77,7.5,11.46> }
		triangle { <52.77,7.5,-11.46>, <49.89,7.5,-20.66>, <55.43,10,-22.96> }
		triangle { <55.43,10,-22.96>, <58.85,10,-12.73>, <52.77,7.5,-11.46> }
// Inlined: 1 16  0 0 0  0.707 0 -0.707 0 1 0  0.707 0 0.707 1-8web.dat
		triangle { <42.42,16,42.42>, <50.45,16,32.45>, <47.93,16,30.83> }
		triangle { <47.93,16,30.83>, <40.3,16,40.3>, <42.42,16,42.42> }
		triangle { <50.45,16,32.45>, <47.93,16,30.83>, <52.65,16,21.81> }
		triangle { <52.65,16,21.81>, <55.42,16,22.96>, <50.45,16,32.45> }
		triangle { <32.45,16,50.45>, <30.83,16,47.93>, <21.81,16,52.65> }
		triangle { <21.81,16,52.65>, <22.96,16,55.42>, <32.45,16,50.45> }
		triangle { <42.42,16,42.42>, <32.45,16,50.45>, <30.83,16,47.93> }
		triangle { <30.83,16,47.93>, <40.3,16,40.3>, <42.42,16,42.42> }
		triangle { <13.786,0,19.44>, <19.44,0,13.786>, <28.12,2,22.47> }
		triangle { <28.12,2,22.47>, <22.47,2,28.12>, <13.786,0,19.44> }
		triangle { <13.786,2,19.44>, <19.44,2,13.786>, <28.12,4,22.47> }
		triangle { <28.12,4,22.47>, <22.47,4,28.12>, <13.786,2,19.44> }
		triangle { <19.44,0,13.786>, <28.12,2,22.47>, <28.12,4,22.47> }
		triangle { <28.12,4,22.47>, <19.44,2,13.786>, <19.44,0,13.786> }
		triangle { <13.786,0,19.44>, <22.47,2,28.12>, <22.47,4,28.12> }
		triangle { <22.47,4,28.12>, <13.786,2,19.44>, <13.786,0,19.44> }
		triangle { <32.38,3.5,26.725>, <40.9,7.5,35.24>, <41.61,9.9,35.95> }
		triangle { <41.61,9.9,35.95>, <32.38,5.5,26.725>, <32.38,3.5,26.725> }
		triangle { <26.725,3.5,32.38>, <35.24,7.5,40.9>, <35.95,9.9,41.61> }
		triangle { <35.95,9.9,41.61>, <26.725,5.5,32.38>, <26.725,3.5,32.38> }
		triangle { <26.725,3.5,32.38>, <32.38,3.5,26.725>, <40.9,7.5,35.24> }
		triangle { <40.9,7.5,35.24>, <35.24,7.5,40.9>, <26.725,3.5,32.38> }
		triangle { <26.725,5.5,32.38>, <32.38,5.5,26.725>, <41.61,9.9,35.95> }
		triangle { <41.61,9.9,35.95>, <35.95,9.9,41.61>, <26.725,5.5,32.38> }
		triangle { <40.3,10.75,40.3>, <38.885,9.9,38.885>, <45.72,9.9,30.55> }
		triangle { <45.72,9.9,30.55>, <47.38,10.75,31.66>, <40.3,10.75,40.3> }
		triangle { <40.3,10.75,40.3>, <38.885,9.9,38.885>, <30.55,9.9,45.72> }
		triangle { <30.55,9.9,45.72>, <31.66,10.75,47.38>, <40.3,10.75,40.3> }
		triangle { <31.66,10.75,47.38>, <30.55,9.9,45.72>, <21.04,9.9,50.805> }
		triangle { <21.04,9.9,50.805>, <21.81,10.75,52.65>, <31.66,10.75,47.38> }
		triangle { <22.47,2,28.12>, <28.12,2,22.47>, <32.38,3.5,26.725> }
		triangle { <32.38,3.5,26.725>, <26.725,3.5,32.38>, <22.47,2,28.12> }
		triangle { <30.274,2,19.47>, <33.26,2,13.77>, <38.79,3.5,16.07> }
		triangle { <38.79,3.5,16.07>, <35.286,3.5,22.69>, <30.274,2,19.47> }
		triangle { <30.274,4,19.47>, <33.26,4,13.77>, <38.79,5.5,16.07> }
		triangle { <38.79,5.5,16.07>, <35.286,5.5,22.69>, <30.274,4,19.47> }
		triangle { <30.274,2,19.47>, <33.26,2,13.77>, <33.26,4,13.77> }
		triangle { <33.26,4,13.77>, <30.274,4,19.47>, <30.274,2,19.47> }
		triangle { <38.79,3.5,16.07>, <35.286,3.5,22.69>, <35.286,5.5,22.69> }
		triangle { <35.286,5.5,22.69>, <38.79,5.5,16.07>, <38.79,3.5,16.07> }
		triangle { <28.12,2,22.47>, <30.274,2,19.47>, <35.286,3.5,22.69> }
		triangle { <35.286,3.5,22.69>, <32.38,3.5,26.725>, <28.12,2,22.47> }
		triangle { <28.12,4,22.47>, <30.274,4,19.47>, <35.286,5.5,22.69> }
		triangle { <35.286,5.5,22.69>, <32.38,5.5,26.725>, <28.12,4,22.47> }
		triangle { <28.12,2,22.47>, <30.274,2,19.47>, <30.274,4,19.47> }
		triangle { <30.274,4,19.47>, <28.12,4,22.47>, <28.12,2,22.47> }
		triangle { <35.286,3.5,22.69>, <32.38,3.5,26.725>, <32.38,5.5,26.725> }
		triangle { <32.38,5.5,26.725>, <35.286,5.5,22.69>, <35.286,3.5,22.69> }
		triangle { <22.47,2,28.12>, <19.47,2,30.274>, <22.69,3.5,35.286> }
		triangle { <22.69,3.5,35.286>, <26.725,3.5,32.38>, <22.47,2,28.12> }
		triangle { <22.47,4,28.12>, <19.47,4,30.274>, <22.69,5.5,35.286> }
		triangle { <22.69,5.5,35.286>, <26.725,5.5,32.38>, <22.47,4,28.12> }
		triangle { <22.47,2,28.12>, <19.47,2,30.274>, <19.47,4,30.274> }
		triangle { <19.47,4,30.274>, <22.47,4,28.12>, <22.47,2,28.12> }
		triangle { <22.69,3.5,35.286>, <26.725,3.5,32.38>, <26.725,5.5,32.38> }
		triangle { <26.725,5.5,32.38>, <22.69,5.5,35.286>, <22.69,3.5,35.286> }
		triangle { <19.47,2,30.274>, <13.77,2,33.26>, <16.07,3.5,38.79> }
		triangle { <16.07,3.5,38.79>, <22.69,3.5,35.286>, <19.47,2,30.274> }
		triangle { <19.47,4,30.274>, <13.77,4,33.26>, <16.07,5.5,38.79> }
		triangle { <16.07,5.5,38.79>, <22.69,5.5,35.286>, <19.47,4,30.274> }
		triangle { <19.47,2,30.274>, <13.77,2,33.26>, <13.77,4,33.26> }
		triangle { <13.77,4,33.26>, <19.47,4,30.274>, <19.47,2,30.274> }
		triangle { <16.07,3.5,38.79>, <22.69,3.5,35.286>, <22.69,5.5,35.286> }
		triangle { <22.69,5.5,35.286>, <16.07,5.5,38.79>, <16.07,3.5,38.79> }
		triangle { <22.47,4,28.12>, <28.12,4,22.47>, <32.38,5.5,26.725> }
		triangle { <32.38,5.5,26.725>, <26.725,5.5,32.38>, <22.47,4,28.12> }
		triangle { <40.9,7.5,35.24>, <35.24,7.5,40.9>, <42.42,10,42.42> }
		triangle { <40.9,7.5,35.24>, <42.42,10,42.42>, <50.61,10,32.61> }
		triangle { <50.61,10,32.61>, <45.41,7.5,29.21>, <40.9,7.5,35.24> }
		triangle { <35.24,7.5,40.9>, <42.42,10,42.42>, <32.61,10,50.61> }
		triangle { <32.61,10,50.61>, <29.21,7.5,45.41>, <35.24,7.5,40.9> }
		triangle { <29.21,7.5,45.41>, <20.67,7.5,49.88>, <22.96,10,55.42> }
		triangle { <22.96,10,55.42>, <32.61,10,50.61>, <29.21,7.5,45.41> }
		triangle { <45.41,7.5,29.21>, <49.88,7.5,20.67>, <55.42,10,22.96> }
		triangle { <55.42,10,22.96>, <50.61,10,32.61>, <45.41,7.5,29.21> }
// Inlined: 1 16  0 0 0  0 0 -1  0 1 0  1 0 0 1-8web.dat
		triangle { <0,16,60>, <12.73,16,58.63>, <12.09,16,55.7> }
		triangle { <12.09,16,55.7>, <0,16,57>, <0,16,60> }
		triangle { <12.73,16,58.63>, <12.09,16,55.7>, <21.81,16,52.66> }
		triangle { <21.81,16,52.66>, <22.96,16,55.43>, <12.73,16,58.63> }
		triangle { <-12.73,16,58.63>, <-12.09,16,55.7>, <-21.81,16,52.66> }
		triangle { <-21.81,16,52.66>, <-22.96,16,55.43>, <-12.73,16,58.63> }
		triangle { <0,16,60>, <-12.73,16,58.63>, <-12.09,16,55.7> }
		triangle { <-12.09,16,55.7>, <0,16,57>, <0,16,60> }
		triangle { <-4,0,23.5>, <4,0,23.5>, <4,2,35.78> }
		triangle { <4,2,35.78>, <-4,2,35.78>, <-4,0,23.5> }
		triangle { <-4,2,23.5>, <4,2,23.5>, <4,4,35.78> }
		triangle { <4,4,35.78>, <-4,4,35.78>, <-4,2,23.5> }
		triangle { <4,0,23.5>, <4,2,35.78>, <4,4,35.78> }
		triangle { <4,4,35.78>, <4,2,23.5>, <4,0,23.5> }
		triangle { <-4,0,23.5>, <-4,2,35.78>, <-4,4,35.78> }
		triangle { <-4,4,35.78>, <-4,2,23.5>, <-4,0,23.5> }
		triangle { <4,3.5,41.8>, <4,7.5,53.85>, <4,9.9,54.85> }
		triangle { <4,9.9,54.85>, <4,5.5,41.8>, <4,3.5,41.8> }
		triangle { <-4,3.5,41.8>, <-4,7.5,53.85>, <-4,9.9,54.85> }
		triangle { <-4,9.9,54.85>, <-4,5.5,41.8>, <-4,3.5,41.8> }
		triangle { <-4,3.5,41.8>, <4,3.5,41.8>, <4,7.5,53.85> }
		triangle { <4,7.5,53.85>, <-4,7.5,53.85>, <-4,3.5,41.8> }
		triangle { <-4,5.5,41.8>, <4,5.5,41.8>, <4,9.9,54.85> }
		triangle { <4,9.9,54.85>, <-4,9.9,54.85>, <-4,5.5,41.8> }
		triangle { <0,10.75,57>, <0,9.9,55>, <10.73,9.9,53.94> }
		triangle { <10.73,9.9,53.94>, <11.12,10.75,55.9>, <0,10.75,57> }
		triangle { <0,10.75,57>, <0,9.9,55>, <-10.73,9.9,53.94> }
		triangle { <-10.73,9.9,53.94>, <-11.12,10.75,55.9>, <0,10.75,57> }
		triangle { <-11.12,10.75,55.9>, <-10.73,9.9,53.94>, <-21.05,9.9,50.81> }
		triangle { <-21.05,9.9,50.81>, <-21.81,10.75,52.66>, <-11.12,10.75,55.9> }
		triangle { <-4,2,35.78>, <4,2,35.78>, <4,3.5,41.8> }
		triangle { <4,3.5,41.8>, <-4,3.5,41.8>, <-4,2,35.78> }
		triangle { <7.64,2,35.18>, <13.78,2,33.26>, <16.07,3.5,38.8> }
		triangle { <16.07,3.5,38.8>, <8.91,3.5,41>, <7.64,2,35.18> }
		triangle { <7.64,4,35.18>, <13.78,4,33.26>, <16.07,5.5,38.8> }
		triangle { <16.07,5.5,38.8>, <8.91,5.5,41>, <7.64,4,35.18> }
		triangle { <7.64,2,35.18>, <13.78,2,33.26>, <13.78,4,33.26> }
		triangle { <13.78,4,33.26>, <7.64,4,35.18>, <7.64,2,35.18> }
		triangle { <16.07,3.5,38.8>, <8.91,3.5,41>, <8.91,5.5,41> }
		triangle { <8.91,5.5,41>, <16.07,5.5,38.8>, <16.07,3.5,38.8> }
		triangle { <4,2,35.78>, <7.64,2,35.18>, <8.91,3.5,41> }
		triangle { <8.91,3.5,41>, <4,3.5,41.8>, <4,2,35.78> }
		triangle { <4,4,35.78>, <7.64,4,35.18>, <8.91,5.5,41> }
		triangle { <8.91,5.5,41>, <4,5.5,41.8>, <4,4,35.78> }
		triangle { <4,2,35.78>, <7.64,2,35.18>, <7.64,4,35.18> }
		triangle { <7.64,4,35.18>, <4,4,35.78>, <4,2,35.78> }
		triangle { <8.91,3.5,41>, <4,3.5,41.8>, <4,5.5,41.8> }
		triangle { <4,5.5,41.8>, <8.91,5.5,41>, <8.91,3.5,41> }
		triangle { <-4,2,35.78>, <-7.64,2,35.18>, <-8.91,3.5,41> }
		triangle { <-8.91,3.5,41>, <-4,3.5,41.8>, <-4,2,35.78> }
		triangle { <-4,4,35.78>, <-7.64,4,35.18>, <-8.91,5.5,41> }
		triangle { <-8.91,5.5,41>, <-4,5.5,41.8>, <-4,4,35.78> }
		triangle { <-4,2,35.78>, <-7.64,2,35.18>, <-7.64,4,35.18> }
		triangle { <-7.64,4,35.18>, <-4,4,35.78>, <-4,2,35.78> }
		triangle { <-8.91,3.5,41>, <-4,3.5,41.8>, <-4,5.5,41.8> }
		triangle { <-4,5.5,41.8>, <-8.91,5.5,41>, <-8.91,3.5,41> }
		triangle { <-7.64,2,35.18>, <-13.78,2,33.26>, <-16.07,3.5,38.8> }
		triangle { <-16.07,3.5,38.8>, <-8.91,3.5,41>, <-7.64,2,35.18> }
		triangle { <-7.64,4,35.18>, <-13.78,4,33.26>, <-16.07,5.5,38.8> }
		triangle { <-16.07,5.5,38.8>, <-8.91,5.5,41>, <-7.64,4,35.18> }
		triangle { <-7.64,2,35.18>, <-13.78,2,33.26>, <-13.78,4,33.26> }
		triangle { <-13.78,4,33.26>, <-7.64,4,35.18>, <-7.64,2,35.18> }
		triangle { <-16.07,3.5,38.8>, <-8.91,3.5,41>, <-8.91,5.5,41> }
		triangle { <-8.91,5.5,41>, <-16.07,5.5,38.8>, <-16.07,3.5,38.8> }
		triangle { <-4,4,35.78>, <4,4,35.78>, <4,5.5,41.8> }
		triangle { <4,5.5,41.8>, <-4,5.5,41.8>, <-4,4,35.78> }
		triangle { <4,7.5,53.85>, <-4,7.5,53.85>, <0,10,60> }
		triangle { <4,7.5,53.85>, <0,10,60>, <12.73,10,58.85> }
		triangle { <12.73,10,58.85>, <11.46,7.5,52.77>, <4,7.5,53.85> }
		triangle { <-4,7.5,53.85>, <0,10,60>, <-12.73,10,58.85> }
		triangle { <-12.73,10,58.85>, <-11.46,7.5,52.77>, <-4,7.5,53.85> }
		triangle { <-11.46,7.5,52.77>, <-20.66,7.5,49.89>, <-22.96,10,55.43> }
		triangle { <-22.96,10,55.43>, <-12.73,10,58.85>, <-11.46,7.5,52.77> }
		triangle { <11.46,7.5,52.77>, <20.66,7.5,49.89>, <22.96,10,55.43> }
		triangle { <22.96,10,55.43>, <12.73,10,58.85>, <11.46,7.5,52.77> }
// Inlined: 1 16  0 0 0  -0.707 0 -0.707 0 1 0  0.707 0 -0.707 1-8web.dat
		triangle { <-42.42,16,42.42>, <-32.45,16,50.45>, <-30.83,16,47.93> }
		triangle { <-30.83,16,47.93>, <-40.3,16,40.3>, <-42.42,16,42.42> }
		triangle { <-32.45,16,50.45>, <-30.83,16,47.93>, <-21.81,16,52.65> }
		triangle { <-21.81,16,52.65>, <-22.96,16,55.42>, <-32.45,16,50.45> }
		triangle { <-50.45,16,32.45>, <-47.93,16,30.83>, <-52.65,16,21.81> }
		triangle { <-52.65,16,21.81>, <-55.42,16,22.96>, <-50.45,16,32.45> }
		triangle { <-42.42,16,42.42>, <-50.45,16,32.45>, <-47.93,16,30.83> }
		triangle { <-47.93,16,30.83>, <-40.3,16,40.3>, <-42.42,16,42.42> }
		triangle { <-19.44,0,13.786>, <-13.786,0,19.44>, <-22.47,2,28.12> }
		triangle { <-22.47,2,28.12>, <-28.12,2,22.47>, <-19.44,0,13.786> }
		triangle { <-19.44,2,13.786>, <-13.786,2,19.44>, <-22.47,4,28.12> }
		triangle { <-22.47,4,28.12>, <-28.12,4,22.47>, <-19.44,2,13.786> }
		triangle { <-13.786,0,19.44>, <-22.47,2,28.12>, <-22.47,4,28.12> }
		triangle { <-22.47,4,28.12>, <-13.786,2,19.44>, <-13.786,0,19.44> }
		triangle { <-19.44,0,13.786>, <-28.12,2,22.47>, <-28.12,4,22.47> }
		triangle { <-28.12,4,22.47>, <-19.44,2,13.786>, <-19.44,0,13.786> }
		triangle { <-26.725,3.5,32.38>, <-35.24,7.5,40.9>, <-35.95,9.9,41.61> }
		triangle { <-35.95,9.9,41.61>, <-26.725,5.5,32.38>, <-26.725,3.5,32.38> }
		triangle { <-32.38,3.5,26.725>, <-40.9,7.5,35.24>, <-41.61,9.9,35.95> }
		triangle { <-41.61,9.9,35.95>, <-32.38,5.5,26.725>, <-32.38,3.5,26.725> }
		triangle { <-32.38,3.5,26.725>, <-26.725,3.5,32.38>, <-35.24,7.5,40.9> }
		triangle { <-35.24,7.5,40.9>, <-40.9,7.5,35.24>, <-32.38,3.5,26.725> }
		triangle { <-32.38,5.5,26.725>, <-26.725,5.5,32.38>, <-35.95,9.9,41.61> }
		triangle { <-35.95,9.9,41.61>, <-41.61,9.9,35.95>, <-32.38,5.5,26.725> }
		triangle { <-40.3,10.75,40.3>, <-38.885,9.9,38.885>, <-30.55,9.9,45.72> }
		triangle { <-30.55,9.9,45.72>, <-31.66,10.75,47.38>, <-40.3,10.75,40.3> }
		triangle { <-40.3,10.75,40.3>, <-38.885,9.9,38.885>, <-45.72,9.9,30.55> }
		triangle { <-45.72,9.9,30.55>, <-47.38,10.75,31.66>, <-40.3,10.75,40.3> }
		triangle { <-47.38,10.75,31.66>, <-45.72,9.9,30.55>, <-50.805,9.9,21.04> }
		triangle { <-50.805,9.9,21.04>, <-52.65,10.75,21.81>, <-47.38,10.75,31.66> }
		triangle { <-28.12,2,22.47>, <-22.47,2,28.12>, <-26.725,3.5,32.38> }
		triangle { <-26.725,3.5,32.38>, <-32.38,3.5,26.725>, <-28.12,2,22.47> }
		triangle { <-19.47,2,30.274>, <-13.77,2,33.26>, <-16.07,3.5,38.79> }
		triangle { <-16.07,3.5,38.79>, <-22.69,3.5,35.286>, <-19.47,2,30.274> }
		triangle { <-19.47,4,30.274>, <-13.77,4,33.26>, <-16.07,5.5,38.79> }
		triangle { <-16.07,5.5,38.79>, <-22.69,5.5,35.286>, <-19.47,4,30.274> }
		triangle { <-19.47,2,30.274>, <-13.77,2,33.26>, <-13.77,4,33.26> }
		triangle { <-13.77,4,33.26>, <-19.47,4,30.274>, <-19.47,2,30.274> }
		triangle { <-16.07,3.5,38.79>, <-22.69,3.5,35.286>, <-22.69,5.5,35.286> }
		triangle { <-22.69,5.5,35.286>, <-16.07,5.5,38.79>, <-16.07,3.5,38.79> }
		triangle { <-22.47,2,28.12>, <-19.47,2,30.274>, <-22.69,3.5,35.286> }
		triangle { <-22.69,3.5,35.286>, <-26.725,3.5,32.38>, <-22.47,2,28.12> }
		triangle { <-22.47,4,28.12>, <-19.47,4,30.274>, <-22.69,5.5,35.286> }
		triangle { <-22.69,5.5,35.286>, <-26.725,5.5,32.38>, <-22.47,4,28.12> }
		triangle { <-22.47,2,28.12>, <-19.47,2,30.274>, <-19.47,4,30.274> }
		triangle { <-19.47,4,30.274>, <-22.47,4,28.12>, <-22.47,2,28.12> }
		triangle { <-22.69,3.5,35.286>, <-26.725,3.5,32.38>, <-26.725,5.5,32.38> }
		triangle { <-26.725,5.5,32.38>, <-22.69,5.5,35.286>, <-22.69,3.5,35.286> }
		triangle { <-28.12,2,22.47>, <-30.274,2,19.47>, <-35.286,3.5,22.69> }
		triangle { <-35.286,3.5,22.69>, <-32.38,3.5,26.725>, <-28.12,2,22.47> }
		triangle { <-28.12,4,22.47>, <-30.274,4,19.47>, <-35.286,5.5,22.69> }
		triangle { <-35.286,5.5,22.69>, <-32.38,5.5,26.725>, <-28.12,4,22.47> }
		triangle { <-28.12,2,22.47>, <-30.274,2,19.47>, <-30.274,4,19.47> }
		triangle { <-30.274,4,19.47>, <-28.12,4,22.47>, <-28.12,2,22.47> }
		triangle { <-35.286,3.5,22.69>, <-32.38,3.5,26.725>, <-32.38,5.5,26.725> }
		triangle { <-32.38,5.5,26.725>, <-35.286,5.5,22.69>, <-35.286,3.5,22.69> }
		triangle { <-30.274,2,19.47>, <-33.26,2,13.77>, <-38.79,3.5,16.07> }
		triangle { <-38.79,3.5,16.07>, <-35.286,3.5,22.69>, <-30.274,2,19.47> }
		triangle { <-30.274,4,19.47>, <-33.26,4,13.77>, <-38.79,5.5,16.07> }
		triangle { <-38.79,5.5,16.07>, <-35.286,5.5,22.69>, <-30.274,4,19.47> }
		triangle { <-30.274,2,19.47>, <-33.26,2,13.77>, <-33.26,4,13.77> }
		triangle { <-33.26,4,13.77>, <-30.274,4,19.47>, <-30.274,2,19.47> }
		triangle { <-38.79,3.5,16.07>, <-35.286,3.5,22.69>, <-35.286,5.5,22.69> }
		triangle { <-35.286,5.5,22.69>, <-38.79,5.5,16.07>, <-38.79,3.5,16.07> }
		triangle { <-28.12,4,22.47>, <-22.47,4,28.12>, <-26.725,5.5,32.38> }
		triangle { <-26.725,5.5,32.38>, <-32.38,5.5,26.725>, <-28.12,4,22.47> }
		triangle { <-35.24,7.5,40.9>, <-40.9,7.5,35.24>, <-42.42,10,42.42> }
		triangle { <-35.24,7.5,40.9>, <-42.42,10,42.42>, <-32.61,10,50.61> }
		triangle { <-32.61,10,50.61>, <-29.21,7.5,45.41>, <-35.24,7.5,40.9> }
		triangle { <-40.9,7.5,35.24>, <-42.42,10,42.42>, <-50.61,10,32.61> }
		triangle { <-50.61,10,32.61>, <-45.41,7.5,29.21>, <-40.9,7.5,35.24> }
		triangle { <-45.41,7.5,29.21>, <-49.88,7.5,20.67>, <-55.42,10,22.96> }
		triangle { <-55.42,10,22.96>, <-50.61,10,32.61>, <-45.41,7.5,29.21> }
		triangle { <-29.21,7.5,45.41>, <-20.67,7.5,49.88>, <-22.96,10,55.42> }
		triangle { <-22.96,10,55.42>, <-32.61,10,50.61>, <-29.21,7.5,45.41> }
// Inlined: 1 16  0 0 0  -1 0 0  0 1 0  0 0 -1 1-8web.dat
		triangle { <-60,16,0>, <-58.63,16,12.73>, <-55.7,16,12.09> }
		triangle { <-55.7,16,12.09>, <-57,16,0>, <-60,16,0> }
		triangle { <-58.63,16,12.73>, <-55.7,16,12.09>, <-52.66,16,21.81> }
		triangle { <-52.66,16,21.81>, <-55.43,16,22.96>, <-58.63,16,12.73> }
		triangle { <-58.63,16,-12.73>, <-55.7,16,-12.09>, <-52.66,16,-21.81> }
		triangle { <-52.66,16,-21.81>, <-55.43,16,-22.96>, <-58.63,16,-12.73> }
		triangle { <-60,16,0>, <-58.63,16,-12.73>, <-55.7,16,-12.09> }
		triangle { <-55.7,16,-12.09>, <-57,16,0>, <-60,16,0> }
		triangle { <-23.5,0,-4>, <-23.5,0,4>, <-35.78,2,4> }
		triangle { <-35.78,2,4>, <-35.78,2,-4>, <-23.5,0,-4> }
		triangle { <-23.5,2,-4>, <-23.5,2,4>, <-35.78,4,4> }
		triangle { <-35.78,4,4>, <-35.78,4,-4>, <-23.5,2,-4> }
		triangle { <-23.5,0,4>, <-35.78,2,4>, <-35.78,4,4> }
		triangle { <-35.78,4,4>, <-23.5,2,4>, <-23.5,0,4> }
		triangle { <-23.5,0,-4>, <-35.78,2,-4>, <-35.78,4,-4> }
		triangle { <-35.78,4,-4>, <-23.5,2,-4>, <-23.5,0,-4> }
		triangle { <-41.8,3.5,4>, <-53.85,7.5,4>, <-54.85,9.9,4> }
		triangle { <-54.85,9.9,4>, <-41.8,5.5,4>, <-41.8,3.5,4> }
		triangle { <-41.8,3.5,-4>, <-53.85,7.5,-4>, <-54.85,9.9,-4> }
		triangle { <-54.85,9.9,-4>, <-41.8,5.5,-4>, <-41.8,3.5,-4> }
		triangle { <-41.8,3.5,-4>, <-41.8,3.5,4>, <-53.85,7.5,4> }
		triangle { <-53.85,7.5,4>, <-53.85,7.5,-4>, <-41.8,3.5,-4> }
		triangle { <-41.8,5.5,-4>, <-41.8,5.5,4>, <-54.85,9.9,4> }
		triangle { <-54.85,9.9,4>, <-54.85,9.9,-4>, <-41.8,5.5,-4> }
		triangle { <-57,10.75,0>, <-55,9.9,0>, <-53.94,9.9,10.73> }
		triangle { <-53.94,9.9,10.73>, <-55.9,10.75,11.12>, <-57,10.75,0> }
		triangle { <-57,10.75,0>, <-55,9.9,0>, <-53.94,9.9,-10.73> }
		triangle { <-53.94,9.9,-10.73>, <-55.9,10.75,-11.12>, <-57,10.75,0> }
		triangle { <-55.9,10.75,-11.12>, <-53.94,9.9,-10.73>, <-50.81,9.9,-21.05> }
		triangle { <-50.81,9.9,-21.05>, <-52.66,10.75,-21.81>, <-55.9,10.75,-11.12> }
		triangle { <-35.78,2,-4>, <-35.78,2,4>, <-41.8,3.5,4> }
		triangle { <-41.8,3.5,4>, <-41.8,3.5,-4>, <-35.78,2,-4> }
		triangle { <-35.18,2,7.64>, <-33.26,2,13.78>, <-38.8,3.5,16.07> }
		triangle { <-38.8,3.5,16.07>, <-41,3.5,8.91>, <-35.18,2,7.64> }
		triangle { <-35.18,4,7.64>, <-33.26,4,13.78>, <-38.8,5.5,16.07> }
		triangle { <-38.8,5.5,16.07>, <-41,5.5,8.91>, <-35.18,4,7.64> }
		triangle { <-35.18,2,7.64>, <-33.26,2,13.78>, <-33.26,4,13.78> }
		triangle { <-33.26,4,13.78>, <-35.18,4,7.64>, <-35.18,2,7.64> }
		triangle { <-38.8,3.5,16.07>, <-41,3.5,8.91>, <-41,5.5,8.91> }
		triangle { <-41,5.5,8.91>, <-38.8,5.5,16.07>, <-38.8,3.5,16.07> }
		triangle { <-35.78,2,4>, <-35.18,2,7.64>, <-41,3.5,8.91> }
		triangle { <-41,3.5,8.91>, <-41.8,3.5,4>, <-35.78,2,4> }
		triangle { <-35.78,4,4>, <-35.18,4,7.64>, <-41,5.5,8.91> }
		triangle { <-41,5.5,8.91>, <-41.8,5.5,4>, <-35.78,4,4> }
		triangle { <-35.78,2,4>, <-35.18,2,7.64>, <-35.18,4,7.64> }
		triangle { <-35.18,4,7.64>, <-35.78,4,4>, <-35.78,2,4> }
		triangle { <-41,3.5,8.91>, <-41.8,3.5,4>, <-41.8,5.5,4> }
		triangle { <-41.8,5.5,4>, <-41,5.5,8.91>, <-41,3.5,8.91> }
		triangle { <-35.78,2,-4>, <-35.18,2,-7.64>, <-41,3.5,-8.91> }
		triangle { <-41,3.5,-8.91>, <-41.8,3.5,-4>, <-35.78,2,-4> }
		triangle { <-35.78,4,-4>, <-35.18,4,-7.64>, <-41,5.5,-8.91> }
		triangle { <-41,5.5,-8.91>, <-41.8,5.5,-4>, <-35.78,4,-4> }
		triangle { <-35.78,2,-4>, <-35.18,2,-7.64>, <-35.18,4,-7.64> }
		triangle { <-35.18,4,-7.64>, <-35.78,4,-4>, <-35.78,2,-4> }
		triangle { <-41,3.5,-8.91>, <-41.8,3.5,-4>, <-41.8,5.5,-4> }
		triangle { <-41.8,5.5,-4>, <-41,5.5,-8.91>, <-41,3.5,-8.91> }
		triangle { <-35.18,2,-7.64>, <-33.26,2,-13.78>, <-38.8,3.5,-16.07> }
		triangle { <-38.8,3.5,-16.07>, <-41,3.5,-8.91>, <-35.18,2,-7.64> }
		triangle { <-35.18,4,-7.64>, <-33.26,4,-13.78>, <-38.8,5.5,-16.07> }
		triangle { <-38.8,5.5,-16.07>, <-41,5.5,-8.91>, <-35.18,4,-7.64> }
		triangle { <-35.18,2,-7.64>, <-33.26,2,-13.78>, <-33.26,4,-13.78> }
		triangle { <-33.26,4,-13.78>, <-35.18,4,-7.64>, <-35.18,2,-7.64> }
		triangle { <-38.8,3.5,-16.07>, <-41,3.5,-8.91>, <-41,5.5,-8.91> }
		triangle { <-41,5.5,-8.91>, <-38.8,5.5,-16.07>, <-38.8,3.5,-16.07> }
		triangle { <-35.78,4,-4>, <-35.78,4,4>, <-41.8,5.5,4> }
		triangle { <-41.8,5.5,4>, <-41.8,5.5,-4>, <-35.78,4,-4> }
		triangle { <-53.85,7.5,4>, <-53.85,7.5,-4>, <-60,10,0> }
		triangle { <-53.85,7.5,4>, <-60,10,0>, <-58.85,10,12.73> }
		triangle { <-58.85,10,12.73>, <-52.77,7.5,11.46>, <-53.85,7.5,4> }
		triangle { <-53.85,7.5,-4>, <-60,10,0>, <-58.85,10,-12.73> }
		triangle { <-58.85,10,-12.73>, <-52.77,7.5,-11.46>, <-53.85,7.5,-4> }
		triangle { <-52.77,7.5,-11.46>, <-49.89,7.5,-20.66>, <-55.43,10,-22.96> }
		triangle { <-55.43,10,-22.96>, <-58.85,10,-12.73>, <-52.77,7.5,-11.46> }
		triangle { <-52.77,7.5,11.46>, <-49.89,7.5,20.66>, <-55.43,10,22.96> }
		triangle { <-55.43,10,22.96>, <-58.85,10,12.73>, <-52.77,7.5,11.46> }
// Inlined: 1 16  0 0 0  -0.707 0 0.707 0 1 0  -0.707 0 -0.707 1-8web.dat
		triangle { <-42.42,16,-42.42>, <-50.45,16,-32.45>, <-47.93,16,-30.83> }
		triangle { <-47.93,16,-30.83>, <-40.3,16,-40.3>, <-42.42,16,-42.42> }
		triangle { <-50.45,16,-32.45>, <-47.93,16,-30.83>, <-52.65,16,-21.81> }
		triangle { <-52.65,16,-21.81>, <-55.42,16,-22.96>, <-50.45,16,-32.45> }
		triangle { <-32.45,16,-50.45>, <-30.83,16,-47.93>, <-21.81,16,-52.65> }
		triangle { <-21.81,16,-52.65>, <-22.96,16,-55.42>, <-32.45,16,-50.45> }
		triangle { <-42.42,16,-42.42>, <-32.45,16,-50.45>, <-30.83,16,-47.93> }
		triangle { <-30.83,16,-47.93>, <-40.3,16,-40.3>, <-42.42,16,-42.42> }
		triangle { <-13.786,0,-19.44>, <-19.44,0,-13.786>, <-28.12,2,-22.47> }
		triangle { <-28.12,2,-22.47>, <-22.47,2,-28.12>, <-13.786,0,-19.44> }
		triangle { <-13.786,2,-19.44>, <-19.44,2,-13.786>, <-28.12,4,-22.47> }
		triangle { <-28.12,4,-22.47>, <-22.47,4,-28.12>, <-13.786,2,-19.44> }
		triangle { <-19.44,0,-13.786>, <-28.12,2,-22.47>, <-28.12,4,-22.47> }
		triangle { <-28.12,4,-22.47>, <-19.44,2,-13.786>, <-19.44,0,-13.786> }
		triangle { <-13.786,0,-19.44>, <-22.47,2,-28.12>, <-22.47,4,-28.12> }
		triangle { <-22.47,4,-28.12>, <-13.786,2,-19.44>, <-13.786,0,-19.44> }
		triangle { <-32.38,3.5,-26.725>, <-40.9,7.5,-35.24>, <-41.61,9.9,-35.95> }
		triangle { <-41.61,9.9,-35.95>, <-32.38,5.5,-26.725>, <-32.38,3.5,-26.725> }
		triangle { <-26.725,3.5,-32.38>, <-35.24,7.5,-40.9>, <-35.95,9.9,-41.61> }
		triangle { <-35.95,9.9,-41.61>, <-26.725,5.5,-32.38>, <-26.725,3.5,-32.38> }
		triangle { <-26.725,3.5,-32.38>, <-32.38,3.5,-26.725>, <-40.9,7.5,-35.24> }
		triangle { <-40.9,7.5,-35.24>, <-35.24,7.5,-40.9>, <-26.725,3.5,-32.38> }
		triangle { <-26.725,5.5,-32.38>, <-32.38,5.5,-26.725>, <-41.61,9.9,-35.95> }
		triangle { <-41.61,9.9,-35.95>, <-35.95,9.9,-41.61>, <-26.725,5.5,-32.38> }
		triangle { <-40.3,10.75,-40.3>, <-38.885,9.9,-38.885>, <-45.72,9.9,-30.55> }
		triangle { <-45.72,9.9,-30.55>, <-47.38,10.75,-31.66>, <-40.3,10.75,-40.3> }
		triangle { <-40.3,10.75,-40.3>, <-38.885,9.9,-38.885>, <-30.55,9.9,-45.72> }
		triangle { <-30.55,9.9,-45.72>, <-31.66,10.75,-47.38>, <-40.3,10.75,-40.3> }
		triangle { <-31.66,10.75,-47.38>, <-30.55,9.9,-45.72>, <-21.04,9.9,-50.805> }
		triangle { <-21.04,9.9,-50.805>, <-21.81,10.75,-52.65>, <-31.66,10.75,-47.38> }
		triangle { <-22.47,2,-28.12>, <-28.12,2,-22.47>, <-32.38,3.5,-26.725> }
		triangle { <-32.38,3.5,-26.725>, <-26.725,3.5,-32.38>, <-22.47,2,-28.12> }
		triangle { <-30.274,2,-19.47>, <-33.26,2,-13.77>, <-38.79,3.5,-16.07> }
		triangle { <-38.79,3.5,-16.07>, <-35.286,3.5,-22.69>, <-30.274,2,-19.47> }
		triangle { <-30.274,4,-19.47>, <-33.26,4,-13.77>, <-38.79,5.5,-16.07> }
		triangle { <-38.79,5.5,-16.07>, <-35.286,5.5,-22.69>, <-30.274,4,-19.47> }
		triangle { <-30.274,2,-19.47>, <-33.26,2,-13.77>, <-33.26,4,-13.77> }
		triangle { <-33.26,4,-13.77>, <-30.274,4,-19.47>, <-30.274,2,-19.47> }
		triangle { <-38.79,3.5,-16.07>, <-35.286,3.5,-22.69>, <-35.286,5.5,-22.69> }
		triangle { <-35.286,5.5,-22.69>, <-38.79,5.5,-16.07>, <-38.79,3.5,-16.07> }
		triangle { <-28.12,2,-22.47>, <-30.274,2,-19.47>, <-35.286,3.5,-22.69> }
		triangle { <-35.286,3.5,-22.69>, <-32.38,3.5,-26.725>, <-28.12,2,-22.47> }
		triangle { <-28.12,4,-22.47>, <-30.274,4,-19.47>, <-35.286,5.5,-22.69> }
		triangle { <-35.286,5.5,-22.69>, <-32.38,5.5,-26.725>, <-28.12,4,-22.47> }
		triangle { <-28.12,2,-22.47>, <-30.274,2,-19.47>, <-30.274,4,-19.47> }
		triangle { <-30.274,4,-19.47>, <-28.12,4,-22.47>, <-28.12,2,-22.47> }
		triangle { <-35.286,3.5,-22.69>, <-32.38,3.5,-26.725>, <-32.38,5.5,-26.725> }
		triangle { <-32.38,5.5,-26.725>, <-35.286,5.5,-22.69>, <-35.286,3.5,-22.69> }
		triangle { <-22.47,2,-28.12>, <-19.47,2,-30.274>, <-22.69,3.5,-35.286> }
		triangle { <-22.69,3.5,-35.286>, <-26.725,3.5,-32.38>, <-22.47,2,-28.12> }
		triangle { <-22.47,4,-28.12>, <-19.47,4,-30.274>, <-22.69,5.5,-35.286> }
		triangle { <-22.69,5.5,-35.286>, <-26.725,5.5,-32.38>, <-22.47,4,-28.12> }
		triangle { <-22.47,2,-28.12>, <-19.47,2,-30.274>, <-19.47,4,-30.274> }
		triangle { <-19.47,4,-30.274>, <-22.47,4,-28.12>, <-22.47,2,-28.12> }
		triangle { <-22.69,3.5,-35.286>, <-26.725,3.5,-32.38>, <-26.725,5.5,-32.38> }
		triangle { <-26.725,5.5,-32.38>, <-22.69,5.5,-35.286>, <-22.69,3.5,-35.286> }
		triangle { <-19.47,2,-30.274>, <-13.77,2,-33.26>, <-16.07,3.5,-38.79> }
		triangle { <-16.07,3.5,-38.79>, <-22.69,3.5,-35.286>, <-19.47,2,-30.274> }
		triangle { <-19.47,4,-30.274>, <-13.77,4,-33.26>, <-16.07,5.5,-38.79> }
		triangle { <-16.07,5.5,-38.79>, <-22.69,5.5,-35.286>, <-19.47,4,-30.274> }
		triangle { <-19.47,2,-30.274>, <-13.77,2,-33.26>, <-13.77,4,-33.26> }
		triangle { <-13.77,4,-33.26>, <-19.47,4,-30.274>, <-19.47,2,-30.274> }
		triangle { <-16.07,3.5,-38.79>, <-22.69,3.5,-35.286>, <-22.69,5.5,-35.286> }
		triangle { <-22.69,5.5,-35.286>, <-16.07,5.5,-38.79>, <-16.07,3.5,-38.79> }
		triangle { <-22.47,4,-28.12>, <-28.12,4,-22.47>, <-32.38,5.5,-26.725> }
		triangle { <-32.38,5.5,-26.725>, <-26.725,5.5,-32.38>, <-22.47,4,-28.12> }
		triangle { <-40.9,7.5,-35.24>, <-35.24,7.5,-40.9>, <-42.42,10,-42.42> }
		triangle { <-40.9,7.5,-35.24>, <-42.42,10,-42.42>, <-50.61,10,-32.61> }
		triangle { <-50.61,10,-32.61>, <-45.41,7.5,-29.21>, <-40.9,7.5,-35.24> }
		triangle { <-35.24,7.5,-40.9>, <-42.42,10,-42.42>, <-32.61,10,-50.61> }
		triangle { <-32.61,10,-50.61>, <-29.21,7.5,-45.41>, <-35.24,7.5,-40.9> }
		triangle { <-29.21,7.5,-45.41>, <-20.67,7.5,-49.88>, <-22.96,10,-55.42> }
		triangle { <-22.96,10,-55.42>, <-32.61,10,-50.61>, <-29.21,7.5,-45.41> }
		triangle { <-45.41,7.5,-29.21>, <-49.88,7.5,-20.67>, <-55.42,10,-22.96> }
		triangle { <-55.42,10,-22.96>, <-50.61,10,-32.61>, <-45.41,7.5,-29.21> }
// Inlined: 1 16  0 0 0  0 0 1  0 1 0  -1 0 0 1-8web.dat
		triangle { <0,16,-60>, <-12.73,16,-58.63>, <-12.09,16,-55.7> }
		triangle { <-12.09,16,-55.7>, <0,16,-57>, <0,16,-60> }
		triangle { <-12.73,16,-58.63>, <-12.09,16,-55.7>, <-21.81,16,-52.66> }
		triangle { <-21.81,16,-52.66>, <-22.96,16,-55.43>, <-12.73,16,-58.63> }
		triangle { <12.73,16,-58.63>, <12.09,16,-55.7>, <21.81,16,-52.66> }
		triangle { <21.81,16,-52.66>, <22.96,16,-55.43>, <12.73,16,-58.63> }
		triangle { <0,16,-60>, <12.73,16,-58.63>, <12.09,16,-55.7> }
		triangle { <12.09,16,-55.7>, <0,16,-57>, <0,16,-60> }
		triangle { <4,0,-23.5>, <-4,0,-23.5>, <-4,2,-35.78> }
		triangle { <-4,2,-35.78>, <4,2,-35.78>, <4,0,-23.5> }
		triangle { <4,2,-23.5>, <-4,2,-23.5>, <-4,4,-35.78> }
		triangle { <-4,4,-35.78>, <4,4,-35.78>, <4,2,-23.5> }
		triangle { <-4,0,-23.5>, <-4,2,-35.78>, <-4,4,-35.78> }
		triangle { <-4,4,-35.78>, <-4,2,-23.5>, <-4,0,-23.5> }
		triangle { <4,0,-23.5>, <4,2,-35.78>, <4,4,-35.78> }
		triangle { <4,4,-35.78>, <4,2,-23.5>, <4,0,-23.5> }
		triangle { <-4,3.5,-41.8>, <-4,7.5,-53.85>, <-4,9.9,-54.85> }
		triangle { <-4,9.9,-54.85>, <-4,5.5,-41.8>, <-4,3.5,-41.8> }
		triangle { <4,3.5,-41.8>, <4,7.5,-53.85>, <4,9.9,-54.85> }
		triangle { <4,9.9,-54.85>, <4,5.5,-41.8>, <4,3.5,-41.8> }
		triangle { <4,3.5,-41.8>, <-4,3.5,-41.8>, <-4,7.5,-53.85> }
		triangle { <-4,7.5,-53.85>, <4,7.5,-53.85>, <4,3.5,-41.8> }
		triangle { <4,5.5,-41.8>, <-4,5.5,-41.8>, <-4,9.9,-54.85> }
		triangle { <-4,9.9,-54.85>, <4,9.9,-54.85>, <4,5.5,-41.8> }
		triangle { <0,10.75,-57>, <0,9.9,-55>, <-10.73,9.9,-53.94> }
		triangle { <-10.73,9.9,-53.94>, <-11.12,10.75,-55.9>, <0,10.75,-57> }
		triangle { <0,10.75,-57>, <0,9.9,-55>, <10.73,9.9,-53.94> }
		triangle { <10.73,9.9,-53.94>, <11.12,10.75,-55.9>, <0,10.75,-57> }
		triangle { <11.12,10.75,-55.9>, <10.73,9.9,-53.94>, <21.05,9.9,-50.81> }
		triangle { <21.05,9.9,-50.81>, <21.81,10.75,-52.66>, <11.12,10.75,-55.9> }
		triangle { <4,2,-35.78>, <-4,2,-35.78>, <-4,3.5,-41.8> }
		triangle { <-4,3.5,-41.8>, <4,3.5,-41.8>, <4,2,-35.78> }
		triangle { <-7.64,2,-35.18>, <-13.78,2,-33.26>, <-16.07,3.5,-38.8> }
		triangle { <-16.07,3.5,-38.8>, <-8.91,3.5,-41>, <-7.64,2,-35.18> }
		triangle { <-7.64,4,-35.18>, <-13.78,4,-33.26>, <-16.07,5.5,-38.8> }
		triangle { <-16.07,5.5,-38.8>, <-8.91,5.5,-41>, <-7.64,4,-35.18> }
		triangle { <-7.64,2,-35.18>, <-13.78,2,-33.26>, <-13.78,4,-33.26> }
		triangle { <-13.78,4,-33.26>, <-7.64,4,-35.18>, <-7.64,2,-35.18> }
		triangle { <-16.07,3.5,-38.8>, <-8.91,3.5,-41>, <-8.91,5.5,-41> }
		triangle { <-8.91,5.5,-41>, <-16.07,5.5,-38.8>, <-16.07,3.5,-38.8> }
		triangle { <-4,2,-35.78>, <-7.64,2,-35.18>, <-8.91,3.5,-41> }
		triangle { <-8.91,3.5,-41>, <-4,3.5,-41.8>, <-4,2,-35.78> }
		triangle { <-4,4,-35.78>, <-7.64,4,-35.18>, <-8.91,5.5,-41> }
		triangle { <-8.91,5.5,-41>, <-4,5.5,-41.8>, <-4,4,-35.78> }
		triangle { <-4,2,-35.78>, <-7.64,2,-35.18>, <-7.64,4,-35.18> }
		triangle { <-7.64,4,-35.18>, <-4,4,-35.78>, <-4,2,-35.78> }
		triangle { <-8.91,3.5,-41>, <-4,3.5,-41.8>, <-4,5.5,-41.8> }
		triangle { <-4,5.5,-41.8>, <-8.91,5.5,-41>, <-8.91,3.5,-41> }
		triangle { <4,2,-35.78>, <7.64,2,-35.18>, <8.91,3.5,-41> }
		triangle { <8.91,3.5,-41>, <4,3.5,-41.8>, <4,2,-35.78> }
		triangle { <4,4,-35.78>, <7.64,4,-35.18>, <8.91,5.5,-41> }
		triangle { <8.91,5.5,-41>, <4,5.5,-41.8>, <4,4,-35.78> }
		triangle { <4,2,-35.78>, <7.64,2,-35.18>, <7.64,4,-35.18> }
		triangle { <7.64,4,-35.18>, <4,4,-35.78>, <4,2,-35.78> }
		triangle { <8.91,3.5,-41>, <4,3.5,-41.8>, <4,5.5,-41.8> }
		triangle { <4,5.5,-41.8>, <8.91,5.5,-41>, <8.91,3.5,-41> }
		triangle { <7.64,2,-35.18>, <13.78,2,-33.26>, <16.07,3.5,-38.8> }
		triangle { <16.07,3.5,-38.8>, <8.91,3.5,-41>, <7.64,2,-35.18> }
		triangle { <7.64,4,-35.18>, <13.78,4,-33.26>, <16.07,5.5,-38.8> }
		triangle { <16.07,5.5,-38.8>, <8.91,5.5,-41>, <7.64,4,-35.18> }
		triangle { <7.64,2,-35.18>, <13.78,2,-33.26>, <13.78,4,-33.26> }
		triangle { <13.78,4,-33.26>, <7.64,4,-35.18>, <7.64,2,-35.18> }
		triangle { <16.07,3.5,-38.8>, <8.91,3.5,-41>, <8.91,5.5,-41> }
		triangle { <8.91,5.5,-41>, <16.07,5.5,-38.8>, <16.07,3.5,-38.8> }
		triangle { <4,4,-35.78>, <-4,4,-35.78>, <-4,5.5,-41.8> }
		triangle { <-4,5.5,-41.8>, <4,5.5,-41.8>, <4,4,-35.78> }
		triangle { <-4,7.5,-53.85>, <4,7.5,-53.85>, <0,10,-60> }
		triangle { <-4,7.5,-53.85>, <0,10,-60>, <-12.73,10,-58.85> }
		triangle { <-12.73,10,-58.85>, <-11.46,7.5,-52.77>, <-4,7.5,-53.85> }
		triangle { <4,7.5,-53.85>, <0,10,-60>, <12.73,10,-58.85> }
		triangle { <12.73,10,-58.85>, <11.46,7.5,-52.77>, <4,7.5,-53.85> }
		triangle { <11.46,7.5,-52.77>, <20.66,7.5,-49.89>, <22.96,10,-55.43> }
		triangle { <22.96,10,-55.43>, <12.73,10,-58.85>, <11.46,7.5,-52.77> }
		triangle { <-11.46,7.5,-52.77>, <-20.66,7.5,-49.89>, <-22.96,10,-55.43> }
		triangle { <-22.96,10,-55.43>, <-12.73,10,-58.85>, <-11.46,7.5,-52.77> }
// Inlined: 1 16  0 0 0  0.707 0 0.707 0 1 0  -0.707 0 0.707 1-8web.dat
		triangle { <42.42,16,-42.42>, <32.45,16,-50.45>, <30.83,16,-47.93> }
		triangle { <30.83,16,-47.93>, <40.3,16,-40.3>, <42.42,16,-42.42> }
		triangle { <32.45,16,-50.45>, <30.83,16,-47.93>, <21.81,16,-52.65> }
		triangle { <21.81,16,-52.65>, <22.96,16,-55.42>, <32.45,16,-50.45> }
		triangle { <50.45,16,-32.45>, <47.93,16,-30.83>, <52.65,16,-21.81> }
		triangle { <52.65,16,-21.81>, <55.42,16,-22.96>, <50.45,16,-32.45> }
		triangle { <42.42,16,-42.42>, <50.45,16,-32.45>, <47.93,16,-30.83> }
		triangle { <47.93,16,-30.83>, <40.3,16,-40.3>, <42.42,16,-42.42> }
		triangle { <19.44,0,-13.786>, <13.786,0,-19.44>, <22.47,2,-28.12> }
		triangle { <22.47,2,-28.12>, <28.12,2,-22.47>, <19.44,0,-13.786> }
		triangle { <19.44,2,-13.786>, <13.786,2,-19.44>, <22.47,4,-28.12> }
		triangle { <22.47,4,-28.12>, <28.12,4,-22.47>, <19.44,2,-13.786> }
		triangle { <13.786,0,-19.44>, <22.47,2,-28.12>, <22.47,4,-28.12> }
		triangle { <22.47,4,-28.12>, <13.786,2,-19.44>, <13.786,0,-19.44> }
		triangle { <19.44,0,-13.786>, <28.12,2,-22.47>, <28.12,4,-22.47> }
		triangle { <28.12,4,-22.47>, <19.44,2,-13.786>, <19.44,0,-13.786> }
		triangle { <26.725,3.5,-32.38>, <35.24,7.5,-40.9>, <35.95,9.9,-41.61> }
		triangle { <35.95,9.9,-41.61>, <26.725,5.5,-32.38>, <26.725,3.5,-32.38> }
		triangle { <32.38,3.5,-26.725>, <40.9,7.5,-35.24>, <41.61,9.9,-35.95> }
		triangle { <41.61,9.9,-35.95>, <32.38,5.5,-26.725>, <32.38,3.5,-26.725> }
		triangle { <32.38,3.5,-26.725>, <26.725,3.5,-32.38>, <35.24,7.5,-40.9> }
		triangle { <35.24,7.5,-40.9>, <40.9,7.5,-35.24>, <32.38,3.5,-26.725> }
		triangle { <32.38,5.5,-26.725>, <26.725,5.5,-32.38>, <35.95,9.9,-41.61> }
		triangle { <35.95,9.9,-41.61>, <41.61,9.9,-35.95>, <32.38,5.5,-26.725> }
		triangle { <40.3,10.75,-40.3>, <38.885,9.9,-38.885>, <30.55,9.9,-45.72> }
		triangle { <30.55,9.9,-45.72>, <31.66,10.75,-47.38>, <40.3,10.75,-40.3> }
		triangle { <40.3,10.75,-40.3>, <38.885,9.9,-38.885>, <45.72,9.9,-30.55> }
		triangle { <45.72,9.9,-30.55>, <47.38,10.75,-31.66>, <40.3,10.75,-40.3> }
		triangle { <47.38,10.75,-31.66>, <45.72,9.9,-30.55>, <50.805,9.9,-21.04> }
		triangle { <50.805,9.9,-21.04>, <52.65,10.75,-21.81>, <47.38,10.75,-31.66> }
		triangle { <28.12,2,-22.47>, <22.47,2,-28.12>, <26.725,3.5,-32.38> }
		triangle { <26.725,3.5,-32.38>, <32.38,3.5,-26.725>, <28.12,2,-22.47> }
		triangle { <19.47,2,-30.274>, <13.77,2,-33.26>, <16.07,3.5,-38.79> }
		triangle { <16.07,3.5,-38.79>, <22.69,3.5,-35.286>, <19.47,2,-30.274> }
		triangle { <19.47,4,-30.274>, <13.77,4,-33.26>, <16.07,5.5,-38.79> }
		triangle { <16.07,5.5,-38.79>, <22.69,5.5,-35.286>, <19.47,4,-30.274> }
		triangle { <19.47,2,-30.274>, <13.77,2,-33.26>, <13.77,4,-33.26> }
		triangle { <13.77,4,-33.26>, <19.47,4,-30.274>, <19.47,2,-30.274> }
		triangle { <16.07,3.5,-38.79>, <22.69,3.5,-35.286>, <22.69,5.5,-35.286> }
		triangle { <22.69,5.5,-35.286>, <16.07,5.5,-38.79>, <16.07,3.5,-38.79> }
		triangle { <22.47,2,-28.12>, <19.47,2,-30.274>, <22.69,3.5,-35.286> }
		triangle { <22.69,3.5,-35.286>, <26.725,3.5,-32.38>, <22.47,2,-28.12> }
		triangle { <22.47,4,-28.12>, <19.47,4,-30.274>, <22.69,5.5,-35.286> }
		triangle { <22.69,5.5,-35.286>, <26.725,5.5,-32.38>, <22.47,4,-28.12> }
		triangle { <22.47,2,-28.12>, <19.47,2,-30.274>, <19.47,4,-30.274> }
		triangle { <19.47,4,-30.274>, <22.47,4,-28.12>, <22.47,2,-28.12> }
		triangle { <22.69,3.5,-35.286>, <26.725,3.5,-32.38>, <26.725,5.5,-32.38> }
		triangle { <26.725,5.5,-32.38>, <22.69,5.5,-35.286>, <22.69,3.5,-35.286> }
		triangle { <28.12,2,-22.47>, <30.274,2,-19.47>, <35.286,3.5,-22.69> }
		triangle { <35.286,3.5,-22.69>, <32.38,3.5,-26.725>, <28.12,2,-22.47> }
		triangle { <28.12,4,-22.47>, <30.274,4,-19.47>, <35.286,5.5,-22.69> }
		triangle { <35.286,5.5,-22.69>, <32.38,5.5,-26.725>, <28.12,4,-22.47> }
		triangle { <28.12,2,-22.47>, <30.274,2,-19.47>, <30.274,4,-19.47> }
		triangle { <30.274,4,-19.47>, <28.12,4,-22.47>, <28.12,2,-22.47> }
		triangle { <35.286,3.5,-22.69>, <32.38,3.5,-26.725>, <32.38,5.5,-26.725> }
		triangle { <32.38,5.5,-26.725>, <35.286,5.5,-22.69>, <35.286,3.5,-22.69> }
		triangle { <30.274,2,-19.47>, <33.26,2,-13.77>, <38.79,3.5,-16.07> }
		triangle { <38.79,3.5,-16.07>, <35.286,3.5,-22.69>, <30.274,2,-19.47> }
		triangle { <30.274,4,-19.47>, <33.26,4,-13.77>, <38.79,5.5,-16.07> }
		triangle { <38.79,5.5,-16.07>, <35.286,5.5,-22.69>, <30.274,4,-19.47> }
		triangle { <30.274,2,-19.47>, <33.26,2,-13.77>, <33.26,4,-13.77> }
		triangle { <33.26,4,-13.77>, <30.274,4,-19.47>, <30.274,2,-19.47> }
		triangle { <38.79,3.5,-16.07>, <35.286,3.5,-22.69>, <35.286,5.5,-22.69> }
		triangle { <35.286,5.5,-22.69>, <38.79,5.5,-16.07>, <38.79,3.5,-16.07> }
		triangle { <28.12,4,-22.47>, <22.47,4,-28.12>, <26.725,5.5,-32.38> }
		triangle { <26.725,5.5,-32.38>, <32.38,5.5,-26.725>, <28.12,4,-22.47> }
		triangle { <35.24,7.5,-40.9>, <40.9,7.5,-35.24>, <42.42,10,-42.42> }
		triangle { <35.24,7.5,-40.9>, <42.42,10,-42.42>, <32.61,10,-50.61> }
		triangle { <32.61,10,-50.61>, <29.21,7.5,-45.41>, <35.24,7.5,-40.9> }
		triangle { <40.9,7.5,-35.24>, <42.42,10,-42.42>, <50.61,10,-32.61> }
		triangle { <50.61,10,-32.61>, <45.41,7.5,-29.21>, <40.9,7.5,-35.24> }
		triangle { <45.41,7.5,-29.21>, <49.88,7.5,-20.67>, <55.42,10,-22.96> }
		triangle { <55.42,10,-22.96>, <50.61,10,-32.61>, <45.41,7.5,-29.21> }
		triangle { <29.21,7.5,-45.41>, <20.67,7.5,-49.88>, <22.96,10,-55.42> }
		triangle { <22.96,10,-55.42>, <32.61,10,-50.61>, <29.21,7.5,-45.41> }
	}
	object { ring1_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,0> }
	object { ring2_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,0> }
	object { ring3_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,4,0> }
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
// under
	#end
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,4,0,0,0,6,-10,4,10> }
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,-6,10,4,-10> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,4,0,0,0,-6,-10,4,-10> }
	object { _1_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,10,8,10> }
	object { _1_dash_4ndis_dot_dat matrix <-6,0,0,0,1,0,0,0,6,-10,8,10> }
	object { _1_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,-6,10,8,-10> }
	object { _1_dash_4ndis_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-10,8,-10> }
	mesh {
		triangle { <-10,4,-16>, <10,4,-16>, <10,8,-16> }
		triangle { <10,8,-16>, <-10,8,-16>, <-10,4,-16> }
		triangle { <-16,4,-10>, <-16,4,10>, <-16,8,10> }
		triangle { <-16,8,10>, <-16,8,-10>, <-16,4,-10> }
		triangle { <-10,4,16>, <10,4,16>, <10,8,16> }
		triangle { <10,8,16>, <-10,8,16>, <-10,4,16> }
		triangle { <16,4,-10>, <16,4,10>, <16,8,10> }
		triangle { <16,8,10>, <16,8,-10>, <16,4,-10> }
		triangle { <24,8,0>, <16,8,-16>, <16,8,16> }
		triangle { <-24,8,0>, <-16,8,-16>, <-16,8,16> }
		triangle { <0,8,24>, <-16,8,16>, <16,8,16> }
		triangle { <0,8,-24>, <-16,8,-16>, <16,8,-16> }
		triangle { <24,8,0>, <22.174,8,9.185>, <16.97,8,16.97> }
		triangle { <16.97,8,16.97>, <16,8,16>, <24,8,0> }
		triangle { <24,8,0>, <22.174,8,-9.185>, <16.97,8,-16.97> }
		triangle { <16.97,8,-16.97>, <16,8,-16>, <24,8,0> }
		triangle { <-24,8,0>, <-22.174,8,9.185>, <-16.97,8,16.97> }
		triangle { <-16.97,8,16.97>, <-16,8,16>, <-24,8,0> }
		triangle { <-24,8,0>, <-22.174,8,-9.185>, <-16.97,8,-16.97> }
		triangle { <-16.97,8,-16.97>, <-16,8,-16>, <-24,8,0> }
		triangle { <0,8,24>, <9.185,8,22.174>, <16.97,8,16.97> }
		triangle { <16.97,8,16.97>, <16,8,16>, <0,8,24> }
		triangle { <0,8,24>, <-9.185,8,22.174>, <-16.97,8,16.97> }
		triangle { <-16.97,8,16.97>, <-16,8,16>, <0,8,24> }
		triangle { <0,8,-24>, <9.185,8,-22.174>, <16.97,8,-16.97> }
		triangle { <16.97,8,-16.97>, <16,8,-16>, <0,8,-24> }
		triangle { <0,8,-24>, <-9.185,8,-22.174>, <-16.97,8,-16.97> }
		triangle { <-16.97,8,-16.97>, <-16,8,-16>, <0,8,-24> }
// 4 x 3-4studs...
	}
	object { _3_dash_4cyli_dot_dat matrix <1.414,0,1.414,0,4,0,-1.414,0,1.414,14.586,4,0> }
	object { _3_dash_4cyli_dot_dat matrix <-1.414,0,-1.414,0,4,0,-1.414,0,1.414,0,4,-14.586> }
	object { _3_dash_4cyli_dot_dat matrix <-1.414,0,-1.414,0,4,0,1.414,0,-1.414,-14.586,4,0> }
	object { _3_dash_4cyli_dot_dat matrix <1.414,0,1.414,0,4,0,1.414,0,-1.414,0,4,14.586> }
	object { _3_dash_4disc_dot_dat matrix <1.414,0,1.414,0,1,0,-1.414,0,1.414,14.586,8,0> }
	object { _3_dash_4disc_dot_dat matrix <-1.414,0,-1.414,0,1,0,-1.414,0,1.414,0,8,-14.586> }
	object { _3_dash_4disc_dot_dat matrix <-1.414,0,-1.414,0,1,0,1.414,0,-1.414,-14.586,8,0> }
	object { _3_dash_4disc_dot_dat matrix <1.414,0,1.414,0,1,0,1.414,0,-1.414,0,8,14.586> }
	mesh {
		triangle { <14.586,8,0>, <16,8,-1.414>, <16,8,1.414> }
		triangle { <-14.586,8,0>, <-16,8,-1.414>, <-16,8,1.414> }
		triangle { <0,8,-14.586>, <-1.414,8,-16>, <1.414,8,-16> }
		triangle { <0,8,14.586>, <-1.414,8,16>, <1.414,8,16> }
	}
}
#end

#declare _2_dash_8sphe_dot_dat = sphere { <0,0,0>, 1 clipped_by { box { <-1,0,0>, <2,2,2> } } }

#declare _4623_dot_dat = #if (QUAL = 0) box { <-20,-16,-26>, <20,8,10> } #else union {
// Plate  1 x  2 with Arm
	object { _3023_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,0,-16,-22> }
	object { _2_dash_8sphe_dot_dat matrix <4,0,0,0,4,0,0,0,-4,0,4,-22> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,-12,0,4,0,0,4,-10> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,20,0,0,0,4,0,-16,-22> }
}
#end

#declare _3068p07_dot_dat = #if (QUAL = 0) box { <-20,0,-20>, <20,8,20> } #else union {
// Tile  2 x  2 with Black Grille Pattern
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <20,8,20>, <16,8,16>, <-16,8,16> }
		triangle { <-16,8,16>, <-20,8,20>, <20,8,20> }
		triangle { <20,8,-20>, <16,8,-16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <20,8,-20> }
		triangle { <20,8,20>, <16,8,16>, <16,8,-16> }
		triangle { <16,8,-16>, <20,8,-20>, <20,8,20> }
		triangle { <-20,8,20>, <-16,8,16>, <-16,8,-16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <-20,8,20> }
	}
	object { box4_dot_dat matrix <20,0,0,0,-8,0,0,0,20,0,8,0> }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,-15,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,-10,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,-5,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,0,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,5,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,10,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { rect_dot_dat matrix <1,0,0,0,1,0,0,0,17,15,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	mesh {
		triangle { <20,0,20>, <16,0,17>, <-16,0,17> }
		triangle { <-16,0,17>, <-20,0,20>, <20,0,20> }
		triangle { <-20,0,20>, <-16,0,17>, <-16,0,-17> }
		triangle { <-16,0,-17>, <-20,0,-20>, <-20,0,20> }
		triangle { <-20,0,-20>, <-16,0,-17>, <16,0,-17> }
		triangle { <16,0,-17>, <20,0,-20>, <-20,0,-20> }
		triangle { <20,0,-20>, <16,0,-17>, <16,0,17> }
		triangle { <16,0,17>, <20,0,20>, <20,0,-20> }
		triangle { <14,0,17>, <14,0,-17>, <11,0,-17> }
		triangle { <11,0,-17>, <11,0,17>, <14,0,17> }
		triangle { <9,0,17>, <9,0,-17>, <6,0,-17> }
		triangle { <6,0,-17>, <6,0,17>, <9,0,17> }
		triangle { <4,0,17>, <4,0,-17>, <1,0,-17> }
		triangle { <1,0,-17>, <1,0,17>, <4,0,17> }
		triangle { <-1,0,17>, <-1,0,-17>, <-4,0,-17> }
		triangle { <-4,0,-17>, <-4,0,17>, <-1,0,17> }
		triangle { <-6,0,17>, <-6,0,-17>, <-9,0,-17> }
		triangle { <-9,0,-17>, <-9,0,17>, <-6,0,17> }
		triangle { <-11,0,17>, <-11,0,-17>, <-14,0,-17> }
		triangle { <-14,0,-17>, <-14,0,17>, <-11,0,17> }
	}
}
#end

#declare _2440p69_dot_dat = #if (QUAL = 0) box { <-60,-7,-30>, <60,15.6,30> } #else union {
// Hinge  6 x  3 Radar/Blade/Spoiler/Panel w/ Yellow Radar Pattern
	mesh {
		triangle { <-60,0,-20>, <60,0,-20>, <60,0,20> }
		triangle { <60,0,20>, <-60,0,20>, <-60,0,-20> }
		triangle { <-60,0,-20>, <-60,-3,-30>, <60,-3,-30> }
		triangle { <60,-3,-30>, <60,0,-20>, <-60,0,-20> }
		triangle { <-60,0,20>, <-60,-3,30>, <60,-3,30> }
		triangle { <60,-3,30>, <60,0,20>, <-60,0,20> }
		triangle { <-60,0,-20>, <-60,-3,-30>, <-60,-3,30> }
		triangle { <-60,-3,30>, <-60,0,20>, <-60,0,-20> }
		triangle { <60,0,20>, <60,-3,30>, <60,-3,-30> }
		triangle { <60,-3,-30>, <60,0,-20>, <60,0,20> }
		triangle { <-58.75,0,16>, <-53.75,5,16>, <-1,5,16> }
		triangle { <-1,5,16>, <-1,0,16>, <-58.75,0,16> }
		triangle { <53.75,5,16>, <58.75,0,16>, <1,0,16> }
		triangle { <1,0,16>, <1,5,16>, <53.75,5,16> }
		triangle { <-1,0,16>, <1,0,16>, <1,0,14> }
		triangle { <1,0,14>, <-1,0,14>, <-1,0,16> }
		triangle { <-1,0,16>, <-1,0,14>, <-1,5,14> }
		triangle { <-1,5,14>, <-1,5,16>, <-1,0,16> }
		triangle { <-1,0,14>, <1,0,14>, <1,5,14> }
		triangle { <1,5,14>, <-1,5,14>, <-1,0,14> }
		triangle { <1,0,14>, <1,0,16>, <1,5,16> }
		triangle { <1,5,16>, <1,5,14>, <1,0,14> }
		triangle { <-1,5,16>, <-1,5,14>, <1,5,14> }
		triangle { <1,5,14>, <1,5,16>, <-1,5,16> }
		triangle { <1,6,16>, <0.92,5.62,16>, <13.5,5,16> }
		triangle { <0.92,5.62,16>, <0.71,5.29,16>, <13.5,5,16> }
		triangle { <0.71,5.29,16>, <0.38,5.08,16>, <13.5,5,16> }
		triangle { <0.38,5.08,16>, <0,5,16>, <13.5,5,16> }
		triangle { <0,5,16>, <-0.38,5.08,16>, <-13.5,5,16> }
		triangle { <-0.38,5.08,16>, <-0.71,5.29,16>, <-13.5,5,16> }
		triangle { <-0.71,5.29,16>, <-0.92,5.62,16>, <-13.5,5,16> }
		triangle { <-0.92,5.62,16>, <-1,6,16>, <-13.5,5,16> }
		triangle { <2.87,12.87,16>, <3.68,11.52,16>, <13.5,5,16> }
		triangle { <3.68,11.52,16>, <4,10,16>, <13.5,5,16> }
		triangle { <4,10,16>, <3.68,8.48,16>, <13.5,5,16> }
		triangle { <3.68,8.48,16>, <2.8,7.2,16>, <13.5,5,16> }
		triangle { <2.8,7.2,16>, <1,6,16>, <13.5,5,16> }
		triangle { <-1,6,16>, <-2.8,7.2,16>, <-13.5,5,16> }
		triangle { <-2.8,7.2,16>, <-3.68,8.48,16>, <-13.5,5,16> }
		triangle { <-3.68,8.48,16>, <-4,10,16>, <-13.5,5,16> }
		triangle { <-4,10,16>, <-3.68,11.52,16>, <-13.5,5,16> }
		triangle { <-3.68,11.52,16>, <-2.87,12.87,16>, <-13.5,5,16> }
		triangle { <2.87,12.87,16>, <2.52,13.39,16>, <13.5,5,16> }
		triangle { <2.52,13.39,16>, <2.4,14,16>, <13.5,5,16> }
		triangle { <2.4,14,16>, <2.52,14.61,16>, <13.5,5,16> }
		triangle { <2.52,14.61,16>, <2.87,15.13,16>, <13.5,5,16> }
		triangle { <2.87,15.13,16>, <3.39,15.48,16>, <13.5,5,16> }
		triangle { <3.39,15.48,16>, <4,15.6,16>, <13.5,5,16> }
		triangle { <4,15.6,16>, <4.61,15.48,16>, <13.5,5,16> }
		triangle { <4.61,15.48,16>, <5.13,15.13,16>, <13.5,5,16> }
		triangle { <-5.13,15.13,16>, <-4.61,15.48,16>, <-13.5,5,16> }
		triangle { <-4.61,15.48,16>, <-4,15.6,16>, <-13.5,5,16> }
		triangle { <-4,15.6,16>, <-3.39,15.48,16>, <-13.5,5,16> }
		triangle { <-3.39,15.48,16>, <-2.87,15.13,16>, <-13.5,5,16> }
		triangle { <-2.87,15.13,16>, <-2.52,14.61,16>, <-13.5,5,16> }
		triangle { <-2.52,14.61,16>, <-2.4,14,16>, <-13.5,5,16> }
		triangle { <-2.4,14,16>, <-2.52,13.39,16>, <-13.5,5,16> }
		triangle { <-2.52,13.39,16>, <-2.87,12.87,16>, <-13.5,5,16> }
		triangle { <58.75,0,20>, <-58.75,0,20>, <-53.75,5,20> }
		triangle { <-53.75,5,20>, <53.75,5,20>, <58.75,0,20> }
		triangle { <-1,6,20>, <-0.92,5.62,20>, <-13.5,5,20> }
		triangle { <-0.92,5.62,20>, <-0.71,5.29,20>, <-13.5,5,20> }
		triangle { <-0.71,5.29,20>, <-0.38,5.08,20>, <-13.5,5,20> }
		triangle { <-0.38,5.08,20>, <0,5,20>, <-13.5,5,20> }
		triangle { <0,5,20>, <0.38,5.08,20>, <13.5,5,20> }
		triangle { <0.38,5.08,20>, <0.71,5.29,20>, <13.5,5,20> }
		triangle { <0.71,5.29,20>, <0.92,5.62,20>, <13.5,5,20> }
		triangle { <0.92,5.62,20>, <1,6,20>, <13.5,5,20> }
		triangle { <-2.87,12.87,20>, <-3.68,11.52,20>, <-13.5,5,20> }
		triangle { <-3.68,11.52,20>, <-4,10,20>, <-13.5,5,20> }
		triangle { <-4,10,20>, <-3.68,8.48,20>, <-13.5,5,20> }
		triangle { <-3.68,8.48,20>, <-2.8,7.2,20>, <-13.5,5,20> }
		triangle { <-2.8,7.2,20>, <-1,6,20>, <-13.5,5,20> }
		triangle { <1,6,20>, <2.8,7.2,20>, <13.5,5,20> }
		triangle { <2.8,7.2,20>, <3.68,8.48,20>, <13.5,5,20> }
		triangle { <3.68,8.48,20>, <4,10,20>, <13.5,5,20> }
		triangle { <4,10,20>, <3.68,11.52,20>, <13.5,5,20> }
		triangle { <3.68,11.52,20>, <2.87,12.87,20>, <13.5,5,20> }
		triangle { <-2.87,12.87,20>, <-2.52,13.39,20>, <-13.5,5,20> }
		triangle { <-2.52,13.39,20>, <-2.4,14,20>, <-13.5,5,20> }
		triangle { <-2.4,14,20>, <-2.52,14.61,20>, <-13.5,5,20> }
		triangle { <-2.52,14.61,20>, <-2.87,15.13,20>, <-13.5,5,20> }
		triangle { <-2.87,15.13,20>, <-3.39,15.48,20>, <-13.5,5,20> }
		triangle { <-3.39,15.48,20>, <-4,15.6,20>, <-13.5,5,20> }
		triangle { <-4,15.6,20>, <-4.61,15.48,20>, <-13.5,5,20> }
		triangle { <-4.61,15.48,20>, <-5.13,15.13,20>, <-13.5,5,20> }
		triangle { <5.13,15.13,20>, <4.61,15.48,20>, <13.5,5,20> }
		triangle { <4.61,15.48,20>, <4,15.6,20>, <13.5,5,20> }
		triangle { <4,15.6,20>, <3.39,15.48,20>, <13.5,5,20> }
		triangle { <3.39,15.48,20>, <2.87,15.13,20>, <13.5,5,20> }
		triangle { <2.87,15.13,20>, <2.52,14.61,20>, <13.5,5,20> }
		triangle { <2.52,14.61,20>, <2.4,14,20>, <13.5,5,20> }
		triangle { <2.4,14,20>, <2.52,13.39,20>, <13.5,5,20> }
		triangle { <2.52,13.39,20>, <2.87,12.87,20>, <13.5,5,20> }
		triangle { <1,6,16>, <0.92,5.62,16>, <0.92,5.62,20> }
		triangle { <0.92,5.62,20>, <1,6,20>, <1,6,16> }
		triangle { <0.92,5.62,16>, <0.71,5.29,16>, <0.71,5.29,20> }
		triangle { <0.71,5.29,20>, <0.92,5.62,20>, <0.92,5.62,16> }
		triangle { <0.71,5.29,16>, <0.38,5.08,16>, <0.38,5.08,20> }
		triangle { <0.38,5.08,20>, <0.71,5.29,20>, <0.71,5.29,16> }
		triangle { <0.38,5.08,16>, <0,5,16>, <0,5,20> }
		triangle { <0,5,20>, <0.38,5.08,20>, <0.38,5.08,16> }
		triangle { <-1,6,16>, <-0.92,5.62,16>, <-0.92,5.62,20> }
		triangle { <-0.92,5.62,20>, <-1,6,20>, <-1,6,16> }
		triangle { <-0.92,5.62,16>, <-0.71,5.29,16>, <-0.71,5.29,20> }
		triangle { <-0.71,5.29,20>, <-0.92,5.62,20>, <-0.92,5.62,16> }
		triangle { <-0.71,5.29,16>, <-0.38,5.08,16>, <-0.38,5.08,20> }
		triangle { <-0.38,5.08,20>, <-0.71,5.29,20>, <-0.71,5.29,16> }
		triangle { <-0.38,5.08,16>, <0,5,16>, <0,5,20> }
		triangle { <0,5,20>, <-0.38,5.08,20>, <-0.38,5.08,16> }
		triangle { <2.87,12.87,16>, <3.68,11.52,16>, <3.68,11.52,20> }
		triangle { <3.68,11.52,20>, <2.87,12.87,20>, <2.87,12.87,16> }
		triangle { <3.68,11.52,16>, <4,10,16>, <4,10,20> }
		triangle { <4,10,20>, <3.68,11.52,20>, <3.68,11.52,16> }
		triangle { <4,10,16>, <3.68,8.48,16>, <3.68,8.48,20> }
		triangle { <3.68,8.48,20>, <4,10,20>, <4,10,16> }
		triangle { <3.68,8.48,16>, <2.8,7.2,16>, <2.8,7.2,20> }
		triangle { <2.8,7.2,20>, <3.68,8.48,20>, <3.68,8.48,16> }
		triangle { <2.8,7.2,16>, <1,6,16>, <1,6,20> }
		triangle { <1,6,20>, <2.8,7.2,20>, <2.8,7.2,16> }
		triangle { <-2.87,12.87,16>, <-3.68,11.52,16>, <-3.68,11.52,20> }
		triangle { <-3.68,11.52,20>, <-2.87,12.87,20>, <-2.87,12.87,16> }
		triangle { <-3.68,11.52,16>, <-4,10,16>, <-4,10,20> }
		triangle { <-4,10,20>, <-3.68,11.52,20>, <-3.68,11.52,16> }
		triangle { <-4,10,16>, <-3.68,8.48,16>, <-3.68,8.48,20> }
		triangle { <-3.68,8.48,20>, <-4,10,20>, <-4,10,16> }
		triangle { <-3.68,8.48,16>, <-2.8,7.2,16>, <-2.8,7.2,20> }
		triangle { <-2.8,7.2,20>, <-3.68,8.48,20>, <-3.68,8.48,16> }
		triangle { <-2.8,7.2,16>, <-1,6,16>, <-1,6,20> }
		triangle { <-1,6,20>, <-2.8,7.2,20>, <-2.8,7.2,16> }
		triangle { <2.87,12.87,16>, <2.52,13.39,16>, <2.52,13.39,20> }
		triangle { <2.52,13.39,20>, <2.87,12.87,20>, <2.87,12.87,16> }
		triangle { <2.52,13.39,16>, <2.4,14,16>, <2.4,14,20> }
		triangle { <2.4,14,20>, <2.52,13.39,20>, <2.52,13.39,16> }
		triangle { <2.4,14,16>, <2.52,14.61,16>, <2.52,14.61,20> }
		triangle { <2.52,14.61,20>, <2.4,14,20>, <2.4,14,16> }
		triangle { <2.52,14.61,16>, <2.87,15.13,16>, <2.87,15.13,20> }
		triangle { <2.87,15.13,20>, <2.52,14.61,20>, <2.52,14.61,16> }
		triangle { <2.87,15.13,16>, <3.39,15.48,16>, <3.39,15.48,20> }
		triangle { <3.39,15.48,20>, <2.87,15.13,20>, <2.87,15.13,16> }
		triangle { <3.39,15.48,16>, <4,15.6,16>, <4,15.6,20> }
		triangle { <4,15.6,20>, <3.39,15.48,20>, <3.39,15.48,16> }
		triangle { <4,15.6,16>, <4.61,15.48,16>, <4.61,15.48,20> }
		triangle { <4.61,15.48,20>, <4,15.6,20>, <4,15.6,16> }
		triangle { <4.61,15.48,16>, <5.13,15.13,16>, <5.13,15.13,20> }
		triangle { <5.13,15.13,20>, <4.61,15.48,20>, <4.61,15.48,16> }
		triangle { <-2.87,12.87,16>, <-2.52,13.39,16>, <-2.52,13.39,20> }
		triangle { <-2.52,13.39,20>, <-2.87,12.87,20>, <-2.87,12.87,16> }
		triangle { <-2.52,13.39,16>, <-2.4,14,16>, <-2.4,14,20> }
		triangle { <-2.4,14,20>, <-2.52,13.39,20>, <-2.52,13.39,16> }
		triangle { <-2.4,14,16>, <-2.52,14.61,16>, <-2.52,14.61,20> }
		triangle { <-2.52,14.61,20>, <-2.4,14,20>, <-2.4,14,16> }
		triangle { <-2.52,14.61,16>, <-2.87,15.13,16>, <-2.87,15.13,20> }
		triangle { <-2.87,15.13,20>, <-2.52,14.61,20>, <-2.52,14.61,16> }
		triangle { <-2.87,15.13,16>, <-3.39,15.48,16>, <-3.39,15.48,20> }
		triangle { <-3.39,15.48,20>, <-2.87,15.13,20>, <-2.87,15.13,16> }
		triangle { <-3.39,15.48,16>, <-4,15.6,16>, <-4,15.6,20> }
		triangle { <-4,15.6,20>, <-3.39,15.48,20>, <-3.39,15.48,16> }
		triangle { <-4,15.6,16>, <-4.61,15.48,16>, <-4.61,15.48,20> }
		triangle { <-4.61,15.48,20>, <-4,15.6,20>, <-4,15.6,16> }
		triangle { <-4.61,15.48,16>, <-5.13,15.13,16>, <-5.13,15.13,20> }
		triangle { <-5.13,15.13,20>, <-4.61,15.48,20>, <-4.61,15.48,16> }
		triangle { <-58.75,0,16>, <-53.75,5,16>, <-53.75,5,20> }
		triangle { <-53.75,5,20>, <-58.75,0,20>, <-58.75,0,16> }
		triangle { <58.75,0,16>, <53.75,5,16>, <53.75,5,20> }
		triangle { <53.75,5,20>, <58.75,0,20>, <58.75,0,16> }
		triangle { <-53.75,5,16>, <-13.5,5,16>, <-13.5,5,20> }
		triangle { <-13.5,5,20>, <-53.75,5,20>, <-53.75,5,16> }
		triangle { <53.75,5,16>, <13.5,5,16>, <13.5,5,20> }
		triangle { <13.5,5,20>, <53.75,5,20>, <53.75,5,16> }
		triangle { <-13.5,5,16>, <-5.13,15.13,16>, <-5.13,15.13,20> }
		triangle { <-5.13,15.13,20>, <-13.5,5,20>, <-13.5,5,16> }
		triangle { <13.5,5,16>, <5.13,15.13,16>, <5.13,15.13,20> }
		triangle { <5.13,15.13,20>, <13.5,5,20>, <13.5,5,16> }
		triangle { <58.75,0,-16>, <53.75,5,-16>, <1,5,-16> }
		triangle { <1,5,-16>, <1,0,-16>, <58.75,0,-16> }
		triangle { <-53.75,5,-16>, <-58.75,0,-16>, <-1,0,-16> }
		triangle { <-1,0,-16>, <-1,5,-16>, <-53.75,5,-16> }
		triangle { <1,0,-16>, <-1,0,-16>, <-1,0,-14> }
		triangle { <-1,0,-14>, <1,0,-14>, <1,0,-16> }
		triangle { <1,0,-16>, <1,0,-14>, <1,5,-14> }
		triangle { <1,5,-14>, <1,5,-16>, <1,0,-16> }
		triangle { <1,0,-14>, <-1,0,-14>, <-1,5,-14> }
		triangle { <-1,5,-14>, <1,5,-14>, <1,0,-14> }
		triangle { <-1,0,-14>, <-1,0,-16>, <-1,5,-16> }
		triangle { <-1,5,-16>, <-1,5,-14>, <-1,0,-14> }
		triangle { <1,5,-16>, <1,5,-14>, <-1,5,-14> }
		triangle { <-1,5,-14>, <-1,5,-16>, <1,5,-16> }
		triangle { <-1,6,-16>, <-0.92,5.62,-16>, <-13.5,5,-16> }
		triangle { <-0.92,5.62,-16>, <-0.71,5.29,-16>, <-13.5,5,-16> }
		triangle { <-0.71,5.29,-16>, <-0.38,5.08,-16>, <-13.5,5,-16> }
		triangle { <-0.38,5.08,-16>, <0,5,-16>, <-13.5,5,-16> }
		triangle { <0,5,-16>, <0.38,5.08,-16>, <13.5,5,-16> }
		triangle { <0.38,5.08,-16>, <0.71,5.29,-16>, <13.5,5,-16> }
		triangle { <0.71,5.29,-16>, <0.92,5.62,-16>, <13.5,5,-16> }
		triangle { <0.92,5.62,-16>, <1,6,-16>, <13.5,5,-16> }
		triangle { <-2.87,12.87,-16>, <-3.68,11.52,-16>, <-13.5,5,-16> }
		triangle { <-3.68,11.52,-16>, <-4,10,-16>, <-13.5,5,-16> }
		triangle { <-4,10,-16>, <-3.68,8.48,-16>, <-13.5,5,-16> }
		triangle { <-3.68,8.48,-16>, <-2.8,7.2,-16>, <-13.5,5,-16> }
		triangle { <-2.8,7.2,-16>, <-1,6,-16>, <-13.5,5,-16> }
		triangle { <1,6,-16>, <2.8,7.2,-16>, <13.5,5,-16> }
		triangle { <2.8,7.2,-16>, <3.68,8.48,-16>, <13.5,5,-16> }
		triangle { <3.68,8.48,-16>, <4,10,-16>, <13.5,5,-16> }
		triangle { <4,10,-16>, <3.68,11.52,-16>, <13.5,5,-16> }
		triangle { <3.68,11.52,-16>, <2.87,12.87,-16>, <13.5,5,-16> }
		triangle { <-2.87,12.87,-16>, <-2.52,13.39,-16>, <-13.5,5,-16> }
		triangle { <-2.52,13.39,-16>, <-2.4,14,-16>, <-13.5,5,-16> }
		triangle { <-2.4,14,-16>, <-2.52,14.61,-16>, <-13.5,5,-16> }
		triangle { <-2.52,14.61,-16>, <-2.87,15.13,-16>, <-13.5,5,-16> }
		triangle { <-2.87,15.13,-16>, <-3.39,15.48,-16>, <-13.5,5,-16> }
		triangle { <-3.39,15.48,-16>, <-4,15.6,-16>, <-13.5,5,-16> }
		triangle { <-4,15.6,-16>, <-4.61,15.48,-16>, <-13.5,5,-16> }
		triangle { <-4.61,15.48,-16>, <-5.13,15.13,-16>, <-13.5,5,-16> }
		triangle { <5.13,15.13,-16>, <4.61,15.48,-16>, <13.5,5,-16> }
		triangle { <4.61,15.48,-16>, <4,15.6,-16>, <13.5,5,-16> }
		triangle { <4,15.6,-16>, <3.39,15.48,-16>, <13.5,5,-16> }
		triangle { <3.39,15.48,-16>, <2.87,15.13,-16>, <13.5,5,-16> }
		triangle { <2.87,15.13,-16>, <2.52,14.61,-16>, <13.5,5,-16> }
		triangle { <2.52,14.61,-16>, <2.4,14,-16>, <13.5,5,-16> }
		triangle { <2.4,14,-16>, <2.52,13.39,-16>, <13.5,5,-16> }
		triangle { <2.52,13.39,-16>, <2.87,12.87,-16>, <13.5,5,-16> }
		triangle { <-58.75,0,-20>, <58.75,0,-20>, <53.75,5,-20> }
		triangle { <53.75,5,-20>, <-53.75,5,-20>, <-58.75,0,-20> }
		triangle { <1,6,-20>, <0.92,5.62,-20>, <13.5,5,-20> }
		triangle { <0.92,5.62,-20>, <0.71,5.29,-20>, <13.5,5,-20> }
		triangle { <0.71,5.29,-20>, <0.38,5.08,-20>, <13.5,5,-20> }
		triangle { <0.38,5.08,-20>, <0,5,-20>, <13.5,5,-20> }
		triangle { <0,5,-20>, <-0.38,5.08,-20>, <-13.5,5,-20> }
		triangle { <-0.38,5.08,-20>, <-0.71,5.29,-20>, <-13.5,5,-20> }
		triangle { <-0.71,5.29,-20>, <-0.92,5.62,-20>, <-13.5,5,-20> }
		triangle { <-0.92,5.62,-20>, <-1,6,-20>, <-13.5,5,-20> }
		triangle { <2.87,12.87,-20>, <3.68,11.52,-20>, <13.5,5,-20> }
		triangle { <3.68,11.52,-20>, <4,10,-20>, <13.5,5,-20> }
		triangle { <4,10,-20>, <3.68,8.48,-20>, <13.5,5,-20> }
		triangle { <3.68,8.48,-20>, <2.8,7.2,-20>, <13.5,5,-20> }
		triangle { <2.8,7.2,-20>, <1,6,-20>, <13.5,5,-20> }
		triangle { <-1,6,-20>, <-2.8,7.2,-20>, <-13.5,5,-20> }
		triangle { <-2.8,7.2,-20>, <-3.68,8.48,-20>, <-13.5,5,-20> }
		triangle { <-3.68,8.48,-20>, <-4,10,-20>, <-13.5,5,-20> }
		triangle { <-4,10,-20>, <-3.68,11.52,-20>, <-13.5,5,-20> }
		triangle { <-3.68,11.52,-20>, <-2.87,12.87,-20>, <-13.5,5,-20> }
		triangle { <2.87,12.87,-20>, <2.52,13.39,-20>, <13.5,5,-20> }
		triangle { <2.52,13.39,-20>, <2.4,14,-20>, <13.5,5,-20> }
		triangle { <2.4,14,-20>, <2.52,14.61,-20>, <13.5,5,-20> }
		triangle { <2.52,14.61,-20>, <2.87,15.13,-20>, <13.5,5,-20> }
		triangle { <2.87,15.13,-20>, <3.39,15.48,-20>, <13.5,5,-20> }
		triangle { <3.39,15.48,-20>, <4,15.6,-20>, <13.5,5,-20> }
		triangle { <4,15.6,-20>, <4.61,15.48,-20>, <13.5,5,-20> }
		triangle { <4.61,15.48,-20>, <5.13,15.13,-20>, <13.5,5,-20> }
		triangle { <-5.13,15.13,-20>, <-4.61,15.48,-20>, <-13.5,5,-20> }
		triangle { <-4.61,15.48,-20>, <-4,15.6,-20>, <-13.5,5,-20> }
		triangle { <-4,15.6,-20>, <-3.39,15.48,-20>, <-13.5,5,-20> }
		triangle { <-3.39,15.48,-20>, <-2.87,15.13,-20>, <-13.5,5,-20> }
		triangle { <-2.87,15.13,-20>, <-2.52,14.61,-20>, <-13.5,5,-20> }
		triangle { <-2.52,14.61,-20>, <-2.4,14,-20>, <-13.5,5,-20> }
		triangle { <-2.4,14,-20>, <-2.52,13.39,-20>, <-13.5,5,-20> }
		triangle { <-2.52,13.39,-20>, <-2.87,12.87,-20>, <-13.5,5,-20> }
		triangle { <-1,6,-16>, <-0.92,5.62,-16>, <-0.92,5.62,-20> }
		triangle { <-0.92,5.62,-20>, <-1,6,-20>, <-1,6,-16> }
		triangle { <-0.92,5.62,-16>, <-0.71,5.29,-16>, <-0.71,5.29,-20> }
		triangle { <-0.71,5.29,-20>, <-0.92,5.62,-20>, <-0.92,5.62,-16> }
		triangle { <-0.71,5.29,-16>, <-0.38,5.08,-16>, <-0.38,5.08,-20> }
		triangle { <-0.38,5.08,-20>, <-0.71,5.29,-20>, <-0.71,5.29,-16> }
		triangle { <-0.38,5.08,-16>, <0,5,-16>, <0,5,-20> }
		triangle { <0,5,-20>, <-0.38,5.08,-20>, <-0.38,5.08,-16> }
		triangle { <1,6,-16>, <0.92,5.62,-16>, <0.92,5.62,-20> }
		triangle { <0.92,5.62,-20>, <1,6,-20>, <1,6,-16> }
		triangle { <0.92,5.62,-16>, <0.71,5.29,-16>, <0.71,5.29,-20> }
		triangle { <0.71,5.29,-20>, <0.92,5.62,-20>, <0.92,5.62,-16> }
		triangle { <0.71,5.29,-16>, <0.38,5.08,-16>, <0.38,5.08,-20> }
		triangle { <0.38,5.08,-20>, <0.71,5.29,-20>, <0.71,5.29,-16> }
		triangle { <0.38,5.08,-16>, <0,5,-16>, <0,5,-20> }
		triangle { <0,5,-20>, <0.38,5.08,-20>, <0.38,5.08,-16> }
		triangle { <-2.87,12.87,-16>, <-3.68,11.52,-16>, <-3.68,11.52,-20> }
		triangle { <-3.68,11.52,-20>, <-2.87,12.87,-20>, <-2.87,12.87,-16> }
		triangle { <-3.68,11.52,-16>, <-4,10,-16>, <-4,10,-20> }
		triangle { <-4,10,-20>, <-3.68,11.52,-20>, <-3.68,11.52,-16> }
		triangle { <-4,10,-16>, <-3.68,8.48,-16>, <-3.68,8.48,-20> }
		triangle { <-3.68,8.48,-20>, <-4,10,-20>, <-4,10,-16> }
		triangle { <-3.68,8.48,-16>, <-2.8,7.2,-16>, <-2.8,7.2,-20> }
		triangle { <-2.8,7.2,-20>, <-3.68,8.48,-20>, <-3.68,8.48,-16> }
		triangle { <-2.8,7.2,-16>, <-1,6,-16>, <-1,6,-20> }
		triangle { <-1,6,-20>, <-2.8,7.2,-20>, <-2.8,7.2,-16> }
		triangle { <2.87,12.87,-16>, <3.68,11.52,-16>, <3.68,11.52,-20> }
		triangle { <3.68,11.52,-20>, <2.87,12.87,-20>, <2.87,12.87,-16> }
		triangle { <3.68,11.52,-16>, <4,10,-16>, <4,10,-20> }
		triangle { <4,10,-20>, <3.68,11.52,-20>, <3.68,11.52,-16> }
		triangle { <4,10,-16>, <3.68,8.48,-16>, <3.68,8.48,-20> }
		triangle { <3.68,8.48,-20>, <4,10,-20>, <4,10,-16> }
		triangle { <3.68,8.48,-16>, <2.8,7.2,-16>, <2.8,7.2,-20> }
		triangle { <2.8,7.2,-20>, <3.68,8.48,-20>, <3.68,8.48,-16> }
		triangle { <2.8,7.2,-16>, <1,6,-16>, <1,6,-20> }
		triangle { <1,6,-20>, <2.8,7.2,-20>, <2.8,7.2,-16> }
		triangle { <-2.87,12.87,-16>, <-2.52,13.39,-16>, <-2.52,13.39,-20> }
		triangle { <-2.52,13.39,-20>, <-2.87,12.87,-20>, <-2.87,12.87,-16> }
		triangle { <-2.52,13.39,-16>, <-2.4,14,-16>, <-2.4,14,-20> }
		triangle { <-2.4,14,-20>, <-2.52,13.39,-20>, <-2.52,13.39,-16> }
		triangle { <-2.4,14,-16>, <-2.52,14.61,-16>, <-2.52,14.61,-20> }
		triangle { <-2.52,14.61,-20>, <-2.4,14,-20>, <-2.4,14,-16> }
		triangle { <-2.52,14.61,-16>, <-2.87,15.13,-16>, <-2.87,15.13,-20> }
		triangle { <-2.87,15.13,-20>, <-2.52,14.61,-20>, <-2.52,14.61,-16> }
		triangle { <-2.87,15.13,-16>, <-3.39,15.48,-16>, <-3.39,15.48,-20> }
		triangle { <-3.39,15.48,-20>, <-2.87,15.13,-20>, <-2.87,15.13,-16> }
		triangle { <-3.39,15.48,-16>, <-4,15.6,-16>, <-4,15.6,-20> }
		triangle { <-4,15.6,-20>, <-3.39,15.48,-20>, <-3.39,15.48,-16> }
		triangle { <-4,15.6,-16>, <-4.61,15.48,-16>, <-4.61,15.48,-20> }
		triangle { <-4.61,15.48,-20>, <-4,15.6,-20>, <-4,15.6,-16> }
		triangle { <-4.61,15.48,-16>, <-5.13,15.13,-16>, <-5.13,15.13,-20> }
		triangle { <-5.13,15.13,-20>, <-4.61,15.48,-20>, <-4.61,15.48,-16> }
		triangle { <2.87,12.87,-16>, <2.52,13.39,-16>, <2.52,13.39,-20> }
		triangle { <2.52,13.39,-20>, <2.87,12.87,-20>, <2.87,12.87,-16> }
		triangle { <2.52,13.39,-16>, <2.4,14,-16>, <2.4,14,-20> }
		triangle { <2.4,14,-20>, <2.52,13.39,-20>, <2.52,13.39,-16> }
		triangle { <2.4,14,-16>, <2.52,14.61,-16>, <2.52,14.61,-20> }
		triangle { <2.52,14.61,-20>, <2.4,14,-20>, <2.4,14,-16> }
		triangle { <2.52,14.61,-16>, <2.87,15.13,-16>, <2.87,15.13,-20> }
		triangle { <2.87,15.13,-20>, <2.52,14.61,-20>, <2.52,14.61,-16> }
		triangle { <2.87,15.13,-16>, <3.39,15.48,-16>, <3.39,15.48,-20> }
		triangle { <3.39,15.48,-20>, <2.87,15.13,-20>, <2.87,15.13,-16> }
		triangle { <3.39,15.48,-16>, <4,15.6,-16>, <4,15.6,-20> }
		triangle { <4,15.6,-20>, <3.39,15.48,-20>, <3.39,15.48,-16> }
		triangle { <4,15.6,-16>, <4.61,15.48,-16>, <4.61,15.48,-20> }
		triangle { <4.61,15.48,-20>, <4,15.6,-20>, <4,15.6,-16> }
		triangle { <4.61,15.48,-16>, <5.13,15.13,-16>, <5.13,15.13,-20> }
		triangle { <5.13,15.13,-20>, <4.61,15.48,-20>, <4.61,15.48,-16> }
		triangle { <58.75,0,-16>, <53.75,5,-16>, <53.75,5,-20> }
		triangle { <53.75,5,-20>, <58.75,0,-20>, <58.75,0,-16> }
		triangle { <-58.75,0,-16>, <-53.75,5,-16>, <-53.75,5,-20> }
		triangle { <-53.75,5,-20>, <-58.75,0,-20>, <-58.75,0,-16> }
		triangle { <53.75,5,-16>, <13.5,5,-16>, <13.5,5,-20> }
		triangle { <13.5,5,-20>, <53.75,5,-20>, <53.75,5,-16> }
		triangle { <-53.75,5,-16>, <-13.5,5,-16>, <-13.5,5,-20> }
		triangle { <-13.5,5,-20>, <-53.75,5,-20>, <-53.75,5,-16> }
		triangle { <13.5,5,-16>, <5.13,15.13,-16>, <5.13,15.13,-20> }
		triangle { <5.13,15.13,-20>, <13.5,5,-20>, <13.5,5,-16> }
		triangle { <-13.5,5,-16>, <-5.13,15.13,-16>, <-5.13,15.13,-20> }
		triangle { <-5.13,15.13,-20>, <-13.5,5,-20>, <-13.5,5,-16> }
		triangle { <-18.75,0,-2>, <18.75,0,-2>, <2.5,11,-2> }
		triangle { <2.5,11,-2>, <-2.5,11,-2>, <-18.75,0,-2> }
		triangle { <-18.75,0,-2>, <-2.5,11,-2>, <-5,15.6,-2> }
		triangle { <-5,15.6,-2>, <-12.5,13.75,-2>, <-18.75,0,-2> }
		triangle { <18.75,0,-2>, <2.5,11,-2>, <5,15.6,-2> }
		triangle { <5,15.6,-2>, <12.5,13.75,-2>, <18.75,0,-2> }
		triangle { <-18.75,0,2>, <18.75,0,2>, <2.5,11,2> }
		triangle { <2.5,11,2>, <-2.5,11,2>, <-18.75,0,2> }
		triangle { <-18.75,0,2>, <-2.5,11,2>, <-5,15.6,2> }
		triangle { <-5,15.6,2>, <-12.5,13.75,2>, <-18.75,0,2> }
		triangle { <18.75,0,2>, <2.5,11,2>, <5,15.6,2> }
		triangle { <5,15.6,2>, <12.5,13.75,2>, <18.75,0,2> }
		triangle { <-18.75,0,-2>, <-12.5,13.75,-2>, <-12.5,13.75,2> }
		triangle { <-12.5,13.75,2>, <-18.75,0,2>, <-18.75,0,-2> }
		triangle { <18.75,0,-2>, <12.5,13.75,-2>, <12.5,13.75,2> }
		triangle { <12.5,13.75,2>, <18.75,0,2>, <18.75,0,-2> }
		triangle { <-12.5,13.75,-2>, <-5,15.6,-2>, <-5,15.6,2> }
		triangle { <-5,15.6,2>, <-12.5,13.75,2>, <-12.5,13.75,-2> }
		triangle { <12.5,13.75,-2>, <5,15.6,-2>, <5,15.6,2> }
		triangle { <5,15.6,2>, <12.5,13.75,2>, <12.5,13.75,-2> }
		triangle { <-5,15.6,-2>, <-2.5,11,-2>, <-2.5,11,2> }
		triangle { <-2.5,11,2>, <-5,15.6,2>, <-5,15.6,-2> }
		triangle { <5,15.6,-2>, <2.5,11,-2>, <2.5,11,2> }
		triangle { <2.5,11,2>, <5,15.6,2>, <5,15.6,-2> }
		triangle { <-2.5,11,-2>, <2.5,11,-2>, <2.5,11,2> }
		triangle { <2.5,11,2>, <-2.5,11,2>, <-2.5,11,-2> }
	}
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,1,0,0,0,1,40,4,0> }
	#end
	mesh {
		triangle { <-60,-3,-16>, <-60,-4.5,-17>, <60,-4.5,-17> }
		triangle { <60,-4.5,-17>, <60,-3,-16>, <-60,-3,-16> }
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	mesh {
		triangle { <-60,-7,-30>, <-60,-3,-30>, <60,-3,-30> }
		triangle { <60,-3,-30>, <60,-7,-30>, <-60,-7,-30> }
		triangle { <60,-3,-16>, <60,-4.5,-17>, <60,-7,-30> }
		triangle { <60,-7,-30>, <60,-3,-30>, <60,-3,-16> }
		triangle { <-60,-3,-30>, <-60,-7,-30>, <-60,-4.5,-17> }
		triangle { <-60,-4.5,-17>, <-60,-3,-16>, <-60,-3,-30> }
	}
	mesh {
		triangle { <60,-3,16>, <60,-4.5,17>, <-60,-4.5,17> }
		triangle { <-60,-4.5,17>, <-60,-3,16>, <60,-3,16> }
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	mesh {
		triangle { <60,-7,30>, <60,-3,30>, <-60,-3,30> }
		triangle { <-60,-3,30>, <-60,-7,30>, <60,-7,30> }
		triangle { <-60,-3,16>, <-60,-4.5,17>, <-60,-7,30> }
		triangle { <-60,-7,30>, <-60,-3,30>, <-60,-3,16> }
		triangle { <60,-3,30>, <60,-7,30>, <60,-4.5,17> }
		triangle { <60,-4.5,17>, <60,-3,16>, <60,-3,30> }
// pattern
	}
	mesh {
		triangle { <22.875,-4.5,-17>, <22.249,-4.5,-17>, <21.614,-4.654,-17.8> }
		triangle { <21.614,-4.654,-17.8>, <22.258,-4.654,-17.8>, <22.875,-4.5,-17> }
		triangle { <22.258,-4.654,-17.8>, <21.614,-4.654,-17.8>, <21.278,-4.731,-18.2> }
		triangle { <21.278,-4.731,-18.2>, <21.932,-4.731,-18.2>, <22.258,-4.654,-17.8> }
		triangle { <21.932,-4.731,-18.2>, <21.278,-4.731,-18.2>, <19.45,-5.104,-20.142> }
		triangle { <19.45,-5.104,-20.142>, <19.798,-5.173,-20.501>, <21.932,-4.731,-18.2> }
		triangle { <19.798,-5.173,-20.501>, <19.45,-5.104,-20.142>, <17.045,-5.503,-22.214> }
		triangle { <17.045,-5.503,-22.214>, <17.35,-5.579,-22.611>, <19.798,-5.173,-20.501> }
		triangle { <17.35,-5.579,-22.611>, <17.045,-5.503,-22.214>, <14.421,-5.846,-24.001> }
		triangle { <14.421,-5.846,-24.001>, <14.679,-5.929,-24.429>, <17.35,-5.579,-22.611> }
		triangle { <14.679,-5.929,-24.429>, <14.421,-5.846,-24.001>, <12.2,-6.077,-25.202> }
		triangle { <12.2,-6.077,-25.202>, <12.2,-6.184,-25.757>, <14.679,-5.929,-24.429> }
		triangle { <12.2,-6.184,-25.757>, <12.2,-6.077,-25.202>, <11.8,-6.114,-25.392> }
		triangle { <11.8,-6.114,-25.392>, <11.8,-6.22,-25.942>, <12.2,-6.184,-25.757> }
		triangle { <11.8,-6.22,-25.942>, <11.8,-6.114,-25.392>, <9.116,-6.322,-26.475> }
		triangle { <9.116,-6.322,-26.475>, <9.279,-6.413,-26.947>, <11.8,-6.22,-25.942> }
		triangle { <9.279,-6.413,-26.947>, <9.116,-6.322,-26.475>, <6.06,-6.488,-27.336> }
		triangle { <6.06,-6.488,-27.336>, <6.169,-6.582,-27.824>, <9.279,-6.413,-26.947> }
		triangle { <6.169,-6.582,-27.824>, <6.06,-6.488,-27.336>, <2.927,-6.586,-27.847> }
		triangle { <2.927,-6.586,-27.847>, <2.979,-6.682,-28.344>, <6.169,-6.582,-27.824> }
		triangle { <2.979,-6.682,-28.344>, <2.927,-6.586,-27.847>, <0,-6.615,-28> }
		triangle { <0,-6.615,-28>, <0,-6.712,-28.5>, <2.979,-6.682,-28.344> }
		triangle { <-22.875,-4.5,-17>, <-22.249,-4.5,-17>, <-21.614,-4.654,-17.8> }
		triangle { <-21.614,-4.654,-17.8>, <-22.258,-4.654,-17.8>, <-22.875,-4.5,-17> }
		triangle { <-22.258,-4.654,-17.8>, <-21.614,-4.654,-17.8>, <-21.278,-4.731,-18.2> }
		triangle { <-21.278,-4.731,-18.2>, <-21.932,-4.731,-18.2>, <-22.258,-4.654,-17.8> }
		triangle { <-21.932,-4.731,-18.2>, <-21.278,-4.731,-18.2>, <-19.45,-5.104,-20.142> }
		triangle { <-19.45,-5.104,-20.142>, <-19.798,-5.173,-20.501>, <-21.932,-4.731,-18.2> }
		triangle { <-19.798,-5.173,-20.501>, <-19.45,-5.104,-20.142>, <-17.045,-5.503,-22.214> }
		triangle { <-17.045,-5.503,-22.214>, <-17.35,-5.579,-22.611>, <-19.798,-5.173,-20.501> }
		triangle { <-17.35,-5.579,-22.611>, <-17.045,-5.503,-22.214>, <-14.421,-5.846,-24.001> }
		triangle { <-14.421,-5.846,-24.001>, <-14.679,-5.929,-24.429>, <-17.35,-5.579,-22.611> }
		triangle { <-14.679,-5.929,-24.429>, <-14.421,-5.846,-24.001>, <-12.2,-6.077,-25.202> }
		triangle { <-12.2,-6.077,-25.202>, <-12.2,-6.184,-25.757>, <-14.679,-5.929,-24.429> }
		triangle { <-12.2,-6.184,-25.757>, <-12.2,-6.077,-25.202>, <-11.8,-6.114,-25.392> }
		triangle { <-11.8,-6.114,-25.392>, <-11.8,-6.22,-25.942>, <-12.2,-6.184,-25.757> }
		triangle { <-11.8,-6.22,-25.942>, <-11.8,-6.114,-25.392>, <-9.116,-6.322,-26.475> }
		triangle { <-9.116,-6.322,-26.475>, <-9.279,-6.413,-26.947>, <-11.8,-6.22,-25.942> }
		triangle { <-9.279,-6.413,-26.947>, <-9.116,-6.322,-26.475>, <-6.06,-6.488,-27.336> }
		triangle { <-6.06,-6.488,-27.336>, <-6.169,-6.582,-27.824>, <-9.279,-6.413,-26.947> }
		triangle { <-6.169,-6.582,-27.824>, <-6.06,-6.488,-27.336>, <-2.927,-6.586,-27.847> }
		triangle { <-2.927,-6.586,-27.847>, <-2.979,-6.682,-28.344>, <-6.169,-6.582,-27.824> }
		triangle { <-2.979,-6.682,-28.344>, <-2.927,-6.586,-27.847>, <0,-6.615,-28> }
		triangle { <0,-6.615,-28>, <0,-6.712,-28.5>, <-2.979,-6.682,-28.344> }
		triangle { <-22.875,-4.5,17>, <-22.249,-4.5,17>, <-21.614,-4.654,17.8> }
		triangle { <-21.614,-4.654,17.8>, <-22.258,-4.654,17.8>, <-22.875,-4.5,17> }
		triangle { <-22.258,-4.654,17.8>, <-21.614,-4.654,17.8>, <-21.278,-4.731,18.2> }
		triangle { <-21.278,-4.731,18.2>, <-21.932,-4.731,18.2>, <-22.258,-4.654,17.8> }
		triangle { <-21.932,-4.731,18.2>, <-21.278,-4.731,18.2>, <-19.45,-5.104,20.142> }
		triangle { <-19.45,-5.104,20.142>, <-19.798,-5.173,20.501>, <-21.932,-4.731,18.2> }
		triangle { <-19.798,-5.173,20.501>, <-19.45,-5.104,20.142>, <-17.045,-5.503,22.214> }
		triangle { <-17.045,-5.503,22.214>, <-17.35,-5.579,22.611>, <-19.798,-5.173,20.501> }
		triangle { <-17.35,-5.579,22.611>, <-17.045,-5.503,22.214>, <-14.421,-5.846,24.001> }
		triangle { <-14.421,-5.846,24.001>, <-14.679,-5.929,24.429>, <-17.35,-5.579,22.611> }
		triangle { <-14.679,-5.929,24.429>, <-14.421,-5.846,24.001>, <-12.2,-6.077,25.202> }
		triangle { <-12.2,-6.077,25.202>, <-12.2,-6.184,25.757>, <-14.679,-5.929,24.429> }
		triangle { <-12.2,-6.184,25.757>, <-12.2,-6.077,25.202>, <-11.8,-6.114,25.392> }
		triangle { <-11.8,-6.114,25.392>, <-11.8,-6.22,25.942>, <-12.2,-6.184,25.757> }
		triangle { <-11.8,-6.22,25.942>, <-11.8,-6.114,25.392>, <-9.116,-6.322,26.475> }
		triangle { <-9.116,-6.322,26.475>, <-9.279,-6.413,26.947>, <-11.8,-6.22,25.942> }
		triangle { <-9.279,-6.413,26.947>, <-9.116,-6.322,26.475>, <-6.06,-6.488,27.336> }
		triangle { <-6.06,-6.488,27.336>, <-6.169,-6.582,27.824>, <-9.279,-6.413,26.947> }
		triangle { <-6.169,-6.582,27.824>, <-6.06,-6.488,27.336>, <-2.927,-6.586,27.847> }
		triangle { <-2.927,-6.586,27.847>, <-2.979,-6.682,28.344>, <-6.169,-6.582,27.824> }
		triangle { <-2.979,-6.682,28.344>, <-2.927,-6.586,27.847>, <0,-6.615,28> }
		triangle { <0,-6.615,28>, <0,-6.712,28.5>, <-2.979,-6.682,28.344> }
		triangle { <22.875,-4.5,17>, <22.249,-4.5,17>, <21.614,-4.654,17.8> }
		triangle { <21.614,-4.654,17.8>, <22.258,-4.654,17.8>, <22.875,-4.5,17> }
		triangle { <22.258,-4.654,17.8>, <21.614,-4.654,17.8>, <21.278,-4.731,18.2> }
		triangle { <21.278,-4.731,18.2>, <21.932,-4.731,18.2>, <22.258,-4.654,17.8> }
		triangle { <21.932,-4.731,18.2>, <21.278,-4.731,18.2>, <19.45,-5.104,20.142> }
		triangle { <19.45,-5.104,20.142>, <19.798,-5.173,20.501>, <21.932,-4.731,18.2> }
		triangle { <19.798,-5.173,20.501>, <19.45,-5.104,20.142>, <17.045,-5.503,22.214> }
		triangle { <17.045,-5.503,22.214>, <17.35,-5.579,22.611>, <19.798,-5.173,20.501> }
		triangle { <17.35,-5.579,22.611>, <17.045,-5.503,22.214>, <14.421,-5.846,24.001> }
		triangle { <14.421,-5.846,24.001>, <14.679,-5.929,24.429>, <17.35,-5.579,22.611> }
		triangle { <14.679,-5.929,24.429>, <14.421,-5.846,24.001>, <12.2,-6.077,25.202> }
		triangle { <12.2,-6.077,25.202>, <12.2,-6.184,25.757>, <14.679,-5.929,24.429> }
		triangle { <12.2,-6.184,25.757>, <12.2,-6.077,25.202>, <11.8,-6.114,25.392> }
		triangle { <11.8,-6.114,25.392>, <11.8,-6.22,25.942>, <12.2,-6.184,25.757> }
		triangle { <11.8,-6.22,25.942>, <11.8,-6.114,25.392>, <9.116,-6.322,26.475> }
		triangle { <9.116,-6.322,26.475>, <9.279,-6.413,26.947>, <11.8,-6.22,25.942> }
		triangle { <9.279,-6.413,26.947>, <9.116,-6.322,26.475>, <6.06,-6.488,27.336> }
		triangle { <6.06,-6.488,27.336>, <6.169,-6.582,27.824>, <9.279,-6.413,26.947> }
		triangle { <6.169,-6.582,27.824>, <6.06,-6.488,27.336>, <2.927,-6.586,27.847> }
		triangle { <2.927,-6.586,27.847>, <2.979,-6.682,28.344>, <6.169,-6.582,27.824> }
		triangle { <2.979,-6.682,28.344>, <2.927,-6.586,27.847>, <0,-6.615,28> }
		triangle { <0,-6.615,28>, <0,-6.712,28.5>, <2.979,-6.682,28.344> }
		triangle { <13.5,-3,5>, <10.5,-3,5>, <10.5,-3,0> }
		triangle { <10.5,-3,0>, <13.5,-3,0>, <13.5,-3,5> }
		triangle { <5.5,-3,5>, <2.5,-3,5>, <2.5,-3,0> }
		triangle { <2.5,-3,0>, <5.5,-3,0>, <5.5,-3,5> }
		triangle { <23.58,-3,16>, <22.98,-3,16>, <23.52,-3,15.2> }
		triangle { <23.52,-3,15.2>, <24.11,-3,15.2>, <23.58,-3,16> }
		triangle { <24.11,-3,15.2>, <23.52,-3,15.2>, <23.77,-3,14.8> }
		triangle { <23.77,-3,14.8>, <24.36,-3,14.8>, <24.11,-3,15.2> }
		triangle { <24.36,-3,14.8>, <23.77,-3,14.8>, <25.17,-3,12.27> }
		triangle { <25.17,-3,12.27>, <25.62,-3,12.49>, <24.36,-3,14.8> }
		triangle { <25.62,-3,12.49>, <25.17,-3,12.27>, <26.08,-3,10.2> }
		triangle { <26.08,-3,10.2>, <26.61,-3,10.2>, <25.62,-3,12.49> }
		triangle { <26.61,-3,10.2>, <26.08,-3,10.2>, <26.23,-3,9.8> }
		triangle { <26.23,-3,9.8>, <26.76,-3,9.8>, <26.61,-3,10.2> }
		triangle { <26.76,-3,9.8>, <26.23,-3,9.8>, <27.05,-3,7.25> }
		triangle { <27.05,-3,7.25>, <27.53,-3,7.38>, <26.76,-3,9.8> }
		triangle { <27.53,-3,7.38>, <27.05,-3,7.25>, <27.57,-3,4.86> }
		triangle { <27.57,-3,4.86>, <28.07,-3,4.95>, <27.53,-3,7.38> }
		triangle { <28.07,-3,4.95>, <27.57,-3,4.86>, <27.89,-3,2.44> }
		triangle { <27.89,-3,2.44>, <28.39,-3,2.48>, <28.07,-3,4.95> }
		triangle { <28.39,-3,2.48>, <27.89,-3,2.44>, <28,-3,0.2> }
		triangle { <28,-3,0.2>, <28.5,-3,0.2>, <28.39,-3,2.48> }
		triangle { <28.5,-3,0.2>, <28,-3,0.2>, <28,-3,0> }
		triangle { <28,-3,0>, <28.5,-3,0>, <28.5,-3,0.2> }
		triangle { <-13.5,-3,-5>, <-10.5,-3,-5>, <-10.5,-3,0> }
		triangle { <-10.5,-3,0>, <-13.5,-3,0>, <-13.5,-3,-5> }
		triangle { <-5.5,-3,-5>, <-2.5,-3,-5>, <-2.5,-3,0> }
		triangle { <-2.5,-3,0>, <-5.5,-3,0>, <-5.5,-3,-5> }
		triangle { <-23.58,-3,-16>, <-22.98,-3,-16>, <-23.52,-3,-15.2> }
		triangle { <-23.52,-3,-15.2>, <-24.11,-3,-15.2>, <-23.58,-3,-16> }
		triangle { <-24.11,-3,-15.2>, <-23.52,-3,-15.2>, <-23.77,-3,-14.8> }
		triangle { <-23.77,-3,-14.8>, <-24.36,-3,-14.8>, <-24.11,-3,-15.2> }
		triangle { <-24.36,-3,-14.8>, <-23.77,-3,-14.8>, <-25.17,-3,-12.27> }
		triangle { <-25.17,-3,-12.27>, <-25.62,-3,-12.49>, <-24.36,-3,-14.8> }
		triangle { <-25.62,-3,-12.49>, <-25.17,-3,-12.27>, <-26.08,-3,-10.2> }
		triangle { <-26.08,-3,-10.2>, <-26.61,-3,-10.2>, <-25.62,-3,-12.49> }
		triangle { <-26.61,-3,-10.2>, <-26.08,-3,-10.2>, <-26.23,-3,-9.8> }
		triangle { <-26.23,-3,-9.8>, <-26.76,-3,-9.8>, <-26.61,-3,-10.2> }
		triangle { <-26.76,-3,-9.8>, <-26.23,-3,-9.8>, <-27.05,-3,-7.25> }
		triangle { <-27.05,-3,-7.25>, <-27.53,-3,-7.38>, <-26.76,-3,-9.8> }
		triangle { <-27.53,-3,-7.38>, <-27.05,-3,-7.25>, <-27.57,-3,-4.86> }
		triangle { <-27.57,-3,-4.86>, <-28.07,-3,-4.95>, <-27.53,-3,-7.38> }
		triangle { <-28.07,-3,-4.95>, <-27.57,-3,-4.86>, <-27.89,-3,-2.44> }
		triangle { <-27.89,-3,-2.44>, <-28.39,-3,-2.48>, <-28.07,-3,-4.95> }
		triangle { <-28.39,-3,-2.48>, <-27.89,-3,-2.44>, <-28,-3,-0.2> }
		triangle { <-28,-3,-0.2>, <-28.5,-3,-0.2>, <-28.39,-3,-2.48> }
		triangle { <-28.5,-3,-0.2>, <-28,-3,-0.2>, <-28,-3,0> }
		triangle { <-28,-3,0>, <-28.5,-3,0>, <-28.5,-3,-0.2> }
		triangle { <-13.5,-3,5>, <-10.5,-3,5>, <-10.5,-3,0> }
		triangle { <-10.5,-3,0>, <-13.5,-3,0>, <-13.5,-3,5> }
		triangle { <-5.5,-3,5>, <-2.5,-3,5>, <-2.5,-3,0> }
		triangle { <-2.5,-3,0>, <-5.5,-3,0>, <-5.5,-3,5> }
		triangle { <-23.58,-3,16>, <-22.98,-3,16>, <-23.52,-3,15.2> }
		triangle { <-23.52,-3,15.2>, <-24.11,-3,15.2>, <-23.58,-3,16> }
		triangle { <-24.11,-3,15.2>, <-23.52,-3,15.2>, <-23.77,-3,14.8> }
		triangle { <-23.77,-3,14.8>, <-24.36,-3,14.8>, <-24.11,-3,15.2> }
		triangle { <-24.36,-3,14.8>, <-23.77,-3,14.8>, <-25.17,-3,12.27> }
		triangle { <-25.17,-3,12.27>, <-25.62,-3,12.49>, <-24.36,-3,14.8> }
		triangle { <-25.62,-3,12.49>, <-25.17,-3,12.27>, <-26.08,-3,10.2> }
		triangle { <-26.08,-3,10.2>, <-26.61,-3,10.2>, <-25.62,-3,12.49> }
		triangle { <-26.61,-3,10.2>, <-26.08,-3,10.2>, <-26.23,-3,9.8> }
		triangle { <-26.23,-3,9.8>, <-26.76,-3,9.8>, <-26.61,-3,10.2> }
		triangle { <-26.76,-3,9.8>, <-26.23,-3,9.8>, <-27.05,-3,7.25> }
		triangle { <-27.05,-3,7.25>, <-27.53,-3,7.38>, <-26.76,-3,9.8> }
		triangle { <-27.53,-3,7.38>, <-27.05,-3,7.25>, <-27.57,-3,4.86> }
		triangle { <-27.57,-3,4.86>, <-28.07,-3,4.95>, <-27.53,-3,7.38> }
		triangle { <-28.07,-3,4.95>, <-27.57,-3,4.86>, <-27.89,-3,2.44> }
		triangle { <-27.89,-3,2.44>, <-28.39,-3,2.48>, <-28.07,-3,4.95> }
		triangle { <-28.39,-3,2.48>, <-27.89,-3,2.44>, <-28,-3,0.2> }
		triangle { <-28,-3,0.2>, <-28.5,-3,0.2>, <-28.39,-3,2.48> }
		triangle { <-28.5,-3,0.2>, <-28,-3,0.2>, <-28,-3,0> }
		triangle { <-28,-3,0>, <-28.5,-3,0>, <-28.5,-3,0.2> }
		triangle { <13.5,-3,-5>, <10.5,-3,-5>, <10.5,-3,0> }
		triangle { <10.5,-3,0>, <13.5,-3,0>, <13.5,-3,-5> }
		triangle { <5.5,-3,-5>, <2.5,-3,-5>, <2.5,-3,0> }
		triangle { <2.5,-3,0>, <5.5,-3,0>, <5.5,-3,-5> }
		triangle { <23.58,-3,-16>, <22.98,-3,-16>, <23.52,-3,-15.2> }
		triangle { <23.52,-3,-15.2>, <24.11,-3,-15.2>, <23.58,-3,-16> }
		triangle { <24.11,-3,-15.2>, <23.52,-3,-15.2>, <23.77,-3,-14.8> }
		triangle { <23.77,-3,-14.8>, <24.36,-3,-14.8>, <24.11,-3,-15.2> }
		triangle { <24.36,-3,-14.8>, <23.77,-3,-14.8>, <25.17,-3,-12.27> }
		triangle { <25.17,-3,-12.27>, <25.62,-3,-12.49>, <24.36,-3,-14.8> }
		triangle { <25.62,-3,-12.49>, <25.17,-3,-12.27>, <26.08,-3,-10.2> }
		triangle { <26.08,-3,-10.2>, <26.61,-3,-10.2>, <25.62,-3,-12.49> }
		triangle { <26.61,-3,-10.2>, <26.08,-3,-10.2>, <26.23,-3,-9.8> }
		triangle { <26.23,-3,-9.8>, <26.76,-3,-9.8>, <26.61,-3,-10.2> }
		triangle { <26.76,-3,-9.8>, <26.23,-3,-9.8>, <27.05,-3,-7.25> }
		triangle { <27.05,-3,-7.25>, <27.53,-3,-7.38>, <26.76,-3,-9.8> }
		triangle { <27.53,-3,-7.38>, <27.05,-3,-7.25>, <27.57,-3,-4.86> }
		triangle { <27.57,-3,-4.86>, <28.07,-3,-4.95>, <27.53,-3,-7.38> }
		triangle { <28.07,-3,-4.95>, <27.57,-3,-4.86>, <27.89,-3,-2.44> }
		triangle { <27.89,-3,-2.44>, <28.39,-3,-2.48>, <28.07,-3,-4.95> }
		triangle { <28.39,-3,-2.48>, <27.89,-3,-2.44>, <28,-3,-0.2> }
		triangle { <28,-3,-0.2>, <28.5,-3,-0.2>, <28.39,-3,-2.48> }
		triangle { <28.5,-3,-0.2>, <28,-3,-0.2>, <28,-3,0> }
		triangle { <28,-3,0>, <28.5,-3,0>, <28.5,-3,-0.2> }
		#if (ver >= 3.1) material #else texture #end { Color14 }
	}
	mesh {
		triangle { <59.2,-3,-15.2>, <24.11,-3,-15.2>, <24.36,-3,-14.8> }
		triangle { <24.36,-3,-14.8>, <59.2,-3,-14.8>, <59.2,-3,-15.2> }
		triangle { <23.52,-3,-15.2>, <0,-3,-15.2>, <0,-3,-14.8> }
		triangle { <0,-3,-14.8>, <23.77,-3,-14.8>, <23.52,-3,-15.2> }
		triangle { <59.2,-3,-10.2>, <26.61,-3,-10.2>, <26.76,-3,-9.8> }
		triangle { <26.76,-3,-9.8>, <59.2,-3,-9.8>, <59.2,-3,-10.2> }
		triangle { <26.08,-3,-10.2>, <0,-3,-10.2>, <0,-3,-9.8> }
		triangle { <0,-3,-9.8>, <26.23,-3,-9.8>, <26.08,-3,-10.2> }
		triangle { <59.2,-3,-0.2>, <28.5,-3,-0.2>, <28.5,-3,0> }
		triangle { <28.5,-3,0>, <59.2,-3,0>, <59.2,-3,-0.2> }
		triangle { <28,-3,-0.2>, <13.5,-3,-0.2>, <13.5,-3,0> }
		triangle { <13.5,-3,0>, <28,-3,0>, <28,-3,-0.2> }
		triangle { <10.5,-3,-0.2>, <5.5,-3,-0.2>, <5.5,-3,0> }
		triangle { <5.5,-3,0>, <10.5,-3,0>, <10.5,-3,-0.2> }
		triangle { <2.5,-3,-0.2>, <0,-3,-0.2>, <0,-3,0> }
		triangle { <0,-3,0>, <2.5,-3,0>, <2.5,-3,-0.2> }
		triangle { <59.2,-3,-14.8>, <58.8,-3,-14.8>, <58.8,-3,-10.2> }
		triangle { <58.8,-3,-10.2>, <59.2,-3,-10.2>, <59.2,-3,-14.8> }
		triangle { <36.2,-3,-14.8>, <35.8,-3,-14.8>, <35.8,-3,-10.2> }
		triangle { <35.8,-3,-10.2>, <36.2,-3,-10.2>, <36.2,-3,-14.8> }
		triangle { <12.2,-3,-14.8>, <11.8,-3,-14.8>, <11.8,-3,-10.2> }
		triangle { <11.8,-3,-10.2>, <12.2,-3,-10.2>, <12.2,-3,-14.8> }
		triangle { <59.2,-3,-9.8>, <58.8,-3,-9.8>, <58.8,-3,-0.2> }
		triangle { <58.8,-3,-0.2>, <59.2,-3,-0.2>, <59.2,-3,-9.8> }
		triangle { <36.2,-3,-9.8>, <35.8,-3,-9.8>, <35.8,-3,-0.2> }
		triangle { <35.8,-3,-0.2>, <36.2,-3,-0.2>, <36.2,-3,-9.8> }
		triangle { <12.2,-3,-9.8>, <11.8,-3,-9.8>, <11.8,-3,-5> }
		triangle { <11.8,-3,-5>, <12.2,-3,-5>, <12.2,-3,-9.8> }
		triangle { <-59.2,-3,15.2>, <-24.11,-3,15.2>, <-24.36,-3,14.8> }
		triangle { <-24.36,-3,14.8>, <-59.2,-3,14.8>, <-59.2,-3,15.2> }
		triangle { <-23.52,-3,15.2>, <0,-3,15.2>, <0,-3,14.8> }
		triangle { <0,-3,14.8>, <-23.77,-3,14.8>, <-23.52,-3,15.2> }
		triangle { <-59.2,-3,10.2>, <-26.61,-3,10.2>, <-26.76,-3,9.8> }
		triangle { <-26.76,-3,9.8>, <-59.2,-3,9.8>, <-59.2,-3,10.2> }
		triangle { <-26.08,-3,10.2>, <0,-3,10.2>, <0,-3,9.8> }
		triangle { <0,-3,9.8>, <-26.23,-3,9.8>, <-26.08,-3,10.2> }
		triangle { <-59.2,-3,0.2>, <-28.5,-3,0.2>, <-28.5,-3,0> }
		triangle { <-28.5,-3,0>, <-59.2,-3,0>, <-59.2,-3,0.2> }
		triangle { <-28,-3,0.2>, <-13.5,-3,0.2>, <-13.5,-3,0> }
		triangle { <-13.5,-3,0>, <-28,-3,0>, <-28,-3,0.2> }
		triangle { <-10.5,-3,0.2>, <-5.5,-3,0.2>, <-5.5,-3,0> }
		triangle { <-5.5,-3,0>, <-10.5,-3,0>, <-10.5,-3,0.2> }
		triangle { <-2.5,-3,0.2>, <0,-3,0.2>, <0,-3,0> }
		triangle { <0,-3,0>, <-2.5,-3,0>, <-2.5,-3,0.2> }
		triangle { <-59.2,-3,14.8>, <-58.8,-3,14.8>, <-58.8,-3,10.2> }
		triangle { <-58.8,-3,10.2>, <-59.2,-3,10.2>, <-59.2,-3,14.8> }
		triangle { <-36.2,-3,14.8>, <-35.8,-3,14.8>, <-35.8,-3,10.2> }
		triangle { <-35.8,-3,10.2>, <-36.2,-3,10.2>, <-36.2,-3,14.8> }
		triangle { <-12.2,-3,14.8>, <-11.8,-3,14.8>, <-11.8,-3,10.2> }
		triangle { <-11.8,-3,10.2>, <-12.2,-3,10.2>, <-12.2,-3,14.8> }
		triangle { <-59.2,-3,9.8>, <-58.8,-3,9.8>, <-58.8,-3,0.2> }
		triangle { <-58.8,-3,0.2>, <-59.2,-3,0.2>, <-59.2,-3,9.8> }
		triangle { <-36.2,-3,9.8>, <-35.8,-3,9.8>, <-35.8,-3,0.2> }
		triangle { <-35.8,-3,0.2>, <-36.2,-3,0.2>, <-36.2,-3,9.8> }
		triangle { <-12.2,-3,9.8>, <-11.8,-3,9.8>, <-11.8,-3,5> }
		triangle { <-11.8,-3,5>, <-12.2,-3,5>, <-12.2,-3,9.8> }
		triangle { <-59.2,-3,-15.2>, <-24.11,-3,-15.2>, <-24.36,-3,-14.8> }
		triangle { <-24.36,-3,-14.8>, <-59.2,-3,-14.8>, <-59.2,-3,-15.2> }
		triangle { <-23.52,-3,-15.2>, <0,-3,-15.2>, <0,-3,-14.8> }
		triangle { <0,-3,-14.8>, <-23.77,-3,-14.8>, <-23.52,-3,-15.2> }
		triangle { <-59.2,-3,-10.2>, <-26.61,-3,-10.2>, <-26.76,-3,-9.8> }
		triangle { <-26.76,-3,-9.8>, <-59.2,-3,-9.8>, <-59.2,-3,-10.2> }
		triangle { <-26.08,-3,-10.2>, <0,-3,-10.2>, <0,-3,-9.8> }
		triangle { <0,-3,-9.8>, <-26.23,-3,-9.8>, <-26.08,-3,-10.2> }
		triangle { <-59.2,-3,-0.2>, <-28.5,-3,-0.2>, <-28.5,-3,0> }
		triangle { <-28.5,-3,0>, <-59.2,-3,0>, <-59.2,-3,-0.2> }
		triangle { <-28,-3,-0.2>, <-13.5,-3,-0.2>, <-13.5,-3,0> }
		triangle { <-13.5,-3,0>, <-28,-3,0>, <-28,-3,-0.2> }
		triangle { <-10.5,-3,-0.2>, <-5.5,-3,-0.2>, <-5.5,-3,0> }
		triangle { <-5.5,-3,0>, <-10.5,-3,0>, <-10.5,-3,-0.2> }
		triangle { <-2.5,-3,-0.2>, <0,-3,-0.2>, <0,-3,0> }
		triangle { <0,-3,0>, <-2.5,-3,0>, <-2.5,-3,-0.2> }
		triangle { <-59.2,-3,-14.8>, <-58.8,-3,-14.8>, <-58.8,-3,-10.2> }
		triangle { <-58.8,-3,-10.2>, <-59.2,-3,-10.2>, <-59.2,-3,-14.8> }
		triangle { <-36.2,-3,-14.8>, <-35.8,-3,-14.8>, <-35.8,-3,-10.2> }
		triangle { <-35.8,-3,-10.2>, <-36.2,-3,-10.2>, <-36.2,-3,-14.8> }
		triangle { <-12.2,-3,-14.8>, <-11.8,-3,-14.8>, <-11.8,-3,-10.2> }
		triangle { <-11.8,-3,-10.2>, <-12.2,-3,-10.2>, <-12.2,-3,-14.8> }
		triangle { <-59.2,-3,-9.8>, <-58.8,-3,-9.8>, <-58.8,-3,-0.2> }
		triangle { <-58.8,-3,-0.2>, <-59.2,-3,-0.2>, <-59.2,-3,-9.8> }
		triangle { <-36.2,-3,-9.8>, <-35.8,-3,-9.8>, <-35.8,-3,-0.2> }
		triangle { <-35.8,-3,-0.2>, <-36.2,-3,-0.2>, <-36.2,-3,-9.8> }
		triangle { <-12.2,-3,-9.8>, <-11.8,-3,-9.8>, <-11.8,-3,-5> }
		triangle { <-11.8,-3,-5>, <-12.2,-3,-5>, <-12.2,-3,-9.8> }
		triangle { <59.2,-3,15.2>, <24.11,-3,15.2>, <24.36,-3,14.8> }
		triangle { <24.36,-3,14.8>, <59.2,-3,14.8>, <59.2,-3,15.2> }
		triangle { <23.52,-3,15.2>, <0,-3,15.2>, <0,-3,14.8> }
		triangle { <0,-3,14.8>, <23.77,-3,14.8>, <23.52,-3,15.2> }
		triangle { <59.2,-3,10.2>, <26.61,-3,10.2>, <26.76,-3,9.8> }
		triangle { <26.76,-3,9.8>, <59.2,-3,9.8>, <59.2,-3,10.2> }
		triangle { <26.08,-3,10.2>, <0,-3,10.2>, <0,-3,9.8> }
		triangle { <0,-3,9.8>, <26.23,-3,9.8>, <26.08,-3,10.2> }
		triangle { <59.2,-3,0.2>, <28.5,-3,0.2>, <28.5,-3,0> }
		triangle { <28.5,-3,0>, <59.2,-3,0>, <59.2,-3,0.2> }
		triangle { <28,-3,0.2>, <13.5,-3,0.2>, <13.5,-3,0> }
		triangle { <13.5,-3,0>, <28,-3,0>, <28,-3,0.2> }
		triangle { <10.5,-3,0.2>, <5.5,-3,0.2>, <5.5,-3,0> }
		triangle { <5.5,-3,0>, <10.5,-3,0>, <10.5,-3,0.2> }
		triangle { <2.5,-3,0.2>, <0,-3,0.2>, <0,-3,0> }
		triangle { <0,-3,0>, <2.5,-3,0>, <2.5,-3,0.2> }
		triangle { <59.2,-3,14.8>, <58.8,-3,14.8>, <58.8,-3,10.2> }
		triangle { <58.8,-3,10.2>, <59.2,-3,10.2>, <59.2,-3,14.8> }
		triangle { <36.2,-3,14.8>, <35.8,-3,14.8>, <35.8,-3,10.2> }
		triangle { <35.8,-3,10.2>, <36.2,-3,10.2>, <36.2,-3,14.8> }
		triangle { <12.2,-3,14.8>, <11.8,-3,14.8>, <11.8,-3,10.2> }
		triangle { <11.8,-3,10.2>, <12.2,-3,10.2>, <12.2,-3,14.8> }
		triangle { <59.2,-3,9.8>, <58.8,-3,9.8>, <58.8,-3,0.2> }
		triangle { <58.8,-3,0.2>, <59.2,-3,0.2>, <59.2,-3,9.8> }
		triangle { <36.2,-3,9.8>, <35.8,-3,9.8>, <35.8,-3,0.2> }
		triangle { <35.8,-3,0.2>, <36.2,-3,0.2>, <36.2,-3,9.8> }
		triangle { <12.2,-3,9.8>, <11.8,-3,9.8>, <11.8,-3,5> }
		triangle { <11.8,-3,5>, <12.2,-3,5>, <12.2,-3,9.8> }
		triangle { <-59.2,-6.846,29.2>, <-59.2,-6.769,28.8>, <59.2,-6.769,28.8> }
		triangle { <59.2,-6.769,28.8>, <59.2,-6.846,29.2>, <-59.2,-6.846,29.2> }
		triangle { <-59.2,-4.731,18.2>, <-59.2,-4.654,17.8>, <59.2,-4.654,17.8> }
		triangle { <59.2,-4.654,17.8>, <59.2,-4.731,18.2>, <-59.2,-4.731,18.2> }
		triangle { <-59.2,-6.769,28.8>, <-59.2,-4.731,18.2>, <-58.8,-4.731,18.2> }
		triangle { <-58.8,-4.731,18.2>, <-58.8,-6.769,28.8>, <-59.2,-6.769,28.8> }
		triangle { <59.2,-6.769,28.8>, <59.2,-4.731,18.2>, <58.8,-4.731,18.2> }
		triangle { <58.8,-4.731,18.2>, <58.8,-6.769,28.8>, <59.2,-6.769,28.8> }
		triangle { <-36.2,-6.769,28.8>, <-36.2,-4.731,18.2>, <-35.8,-4.731,18.2> }
		triangle { <-35.8,-4.731,18.2>, <-35.8,-6.769,28.8>, <-36.2,-6.769,28.8> }
		triangle { <36.2,-6.769,28.8>, <36.2,-4.731,18.2>, <35.8,-4.731,18.2> }
		triangle { <35.8,-4.731,18.2>, <35.8,-6.769,28.8>, <36.2,-6.769,28.8> }
		triangle { <-11.8,-6.769,28.8>, <-12.2,-6.769,28.8>, <-12.2,-6.184,25.757> }
		triangle { <-12.2,-6.184,25.757>, <-11.8,-6.22,25.942>, <-11.8,-6.769,28.8> }
		triangle { <11.8,-6.769,28.8>, <12.2,-6.769,28.8>, <12.2,-6.22,25.942> }
		triangle { <12.2,-6.22,25.942>, <11.8,-6.413,26.947>, <11.8,-6.769,28.8> }
		triangle { <-11.8,-6.114,25.392>, <-12.2,-6.077,25.202>, <-12.2,-4.731,18.2> }
		triangle { <-12.2,-4.731,18.2>, <-11.8,-4.731,18.2>, <-11.8,-6.114,25.392> }
		triangle { <11.8,-6.322,26.475>, <12.2,-6.114,25.392>, <12.2,-4.731,18.2> }
		triangle { <12.2,-4.731,18.2>, <11.8,-4.731,18.2>, <11.8,-6.322,26.475> }
		triangle { <59.2,-6.846,-29.2>, <59.2,-6.769,-28.8>, <-59.2,-6.769,-28.8> }
		triangle { <-59.2,-6.769,-28.8>, <-59.2,-6.846,-29.2>, <59.2,-6.846,-29.2> }
		triangle { <59.2,-4.731,-18.2>, <59.2,-4.654,-17.8>, <-59.2,-4.654,-17.8> }
		triangle { <-59.2,-4.654,-17.8>, <-59.2,-4.731,-18.2>, <59.2,-4.731,-18.2> }
		triangle { <59.2,-6.769,-28.8>, <59.2,-4.731,-18.2>, <58.8,-4.731,-18.2> }
		triangle { <58.8,-4.731,-18.2>, <58.8,-6.769,-28.8>, <59.2,-6.769,-28.8> }
		triangle { <-59.2,-6.769,-28.8>, <-59.2,-4.731,-18.2>, <-58.8,-4.731,-18.2> }
		triangle { <-58.8,-4.731,-18.2>, <-58.8,-6.769,-28.8>, <-59.2,-6.769,-28.8> }
		triangle { <36.2,-6.769,-28.8>, <36.2,-4.731,-18.2>, <35.8,-4.731,-18.2> }
		triangle { <35.8,-4.731,-18.2>, <35.8,-6.769,-28.8>, <36.2,-6.769,-28.8> }
		triangle { <-36.2,-6.769,-28.8>, <-36.2,-4.731,-18.2>, <-35.8,-4.731,-18.2> }
		triangle { <-35.8,-4.731,-18.2>, <-35.8,-6.769,-28.8>, <-36.2,-6.769,-28.8> }
		triangle { <11.8,-6.769,-28.8>, <12.2,-6.769,-28.8>, <12.2,-6.184,-25.757> }
		triangle { <12.2,-6.184,-25.757>, <11.8,-6.22,-25.942>, <11.8,-6.769,-28.8> }
		triangle { <-11.8,-6.769,-28.8>, <-12.2,-6.769,-28.8>, <-12.2,-6.22,-25.942> }
		triangle { <-12.2,-6.22,-25.942>, <-11.8,-6.413,-26.947>, <-11.8,-6.769,-28.8> }
		triangle { <11.8,-6.114,-25.392>, <12.2,-6.077,-25.202>, <12.2,-4.731,-18.2> }
		triangle { <12.2,-4.731,-18.2>, <11.8,-4.731,-18.2>, <11.8,-6.114,-25.392> }
		triangle { <-11.8,-6.322,-26.475>, <-12.2,-6.114,-25.392>, <-12.2,-4.731,-18.2> }
		triangle { <-12.2,-4.731,-18.2>, <-11.8,-4.731,-18.2>, <-11.8,-6.322,-26.475> }
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	mesh {
		triangle { <60,-6.846,-29.2>, <60,-4.654,-17.8>, <59.2,-4.654,-17.8> }
		triangle { <59.2,-4.654,-17.8>, <59.2,-6.846,-29.2>, <60,-6.846,-29.2> }
		triangle { <-60,-6.846,-29.2>, <-60,-4.654,-17.8>, <-59.2,-4.654,-17.8> }
		triangle { <-59.2,-4.654,-17.8>, <-59.2,-6.846,-29.2>, <-60,-6.846,-29.2> }
		triangle { <60,-7,-30>, <60,-6.846,-29.2>, <-60,-6.846,-29.2> }
		triangle { <-60,-6.846,-29.2>, <-60,-7,-30>, <60,-7,-30> }
		triangle { <60,-4.654,-17.8>, <22.258,-4.654,-17.8>, <22.875,-4.5,-17> }
		triangle { <22.875,-4.5,-17>, <60,-4.5,-17>, <60,-4.654,-17.8> }
		triangle { <-60,-4.654,-17.8>, <-22.258,-4.654,-17.8>, <-22.875,-4.5,-17> }
		triangle { <-22.875,-4.5,-17>, <-60,-4.5,-17>, <-60,-4.654,-17.8> }
		triangle { <21.614,-4.654,-17.8>, <-21.614,-4.654,-17.8>, <-22.249,-4.5,-17> }
		triangle { <-22.249,-4.5,-17>, <22.249,-4.5,-17>, <21.614,-4.654,-17.8> }
		triangle { <36.2,-6.769,-28.8>, <58.8,-6.769,-28.8>, <58.8,-4.731,-18.2> }
		triangle { <58.8,-4.731,-18.2>, <36.2,-4.731,-18.2>, <36.2,-6.769,-28.8> }
		triangle { <-36.2,-6.769,-28.8>, <-58.8,-6.769,-28.8>, <-58.8,-4.731,-18.2> }
		triangle { <-58.8,-4.731,-18.2>, <-36.2,-4.731,-18.2>, <-36.2,-6.769,-28.8> }
		triangle { <11.8,-6.769,-28.8>, <11.8,-6.22,-25.942>, <9.279,-6.413,-26.947> }
		triangle { <11.8,-6.769,-28.8>, <9.279,-6.413,-26.947>, <6.169,-6.582,-27.824> }
		triangle { <11.8,-6.769,-28.8>, <6.169,-6.582,-27.824>, <2.979,-6.682,-28.344> }
		triangle { <11.8,-6.769,-28.8>, <2.979,-6.682,-28.344>, <0,-6.712,-28.5> }
		triangle { <11.8,-6.769,-28.8>, <-11.8,-6.769,-28.8>, <0,-6.712,-28.5> }
		triangle { <-11.8,-6.769,-28.8>, <-11.8,-6.22,-25.942>, <-9.279,-6.413,-26.947> }
		triangle { <-11.8,-6.769,-28.8>, <-9.279,-6.413,-26.947>, <-6.169,-6.582,-27.824> }
		triangle { <-11.8,-6.769,-28.8>, <-6.169,-6.582,-27.824>, <-2.979,-6.682,-28.344> }
		triangle { <-11.8,-6.769,-28.8>, <-2.979,-6.682,-28.344>, <0,-6.712,-28.5> }
		triangle { <11.8,-4.731,-18.2>, <11.8,-6.114,-25.392>, <9.116,-6.322,-26.475> }
		triangle { <11.8,-4.731,-18.2>, <9.116,-6.322,-26.475>, <6.06,-6.488,-27.336> }
		triangle { <11.8,-4.731,-18.2>, <6.06,-6.488,-27.336>, <2.927,-6.586,-27.847> }
		triangle { <11.8,-4.731,-18.2>, <2.927,-6.586,-27.847>, <0,-6.615,-28> }
		triangle { <11.8,-4.731,-18.2>, <-11.8,-4.731,-18.2>, <0,-6.615,-28> }
		triangle { <-11.8,-4.731,-18.2>, <-11.8,-6.114,-25.392>, <-9.116,-6.322,-26.475> }
		triangle { <-11.8,-4.731,-18.2>, <-9.116,-6.322,-26.475>, <-6.06,-6.488,-27.336> }
		triangle { <-11.8,-4.731,-18.2>, <-6.06,-6.488,-27.336>, <-2.927,-6.586,-27.847> }
		triangle { <-11.8,-4.731,-18.2>, <-2.927,-6.586,-27.847>, <0,-6.615,-28> }
		triangle { <12.2,-4.731,-18.2>, <21.278,-4.731,-18.2>, <19.45,-5.104,-20.142> }
		triangle { <12.2,-4.731,-18.2>, <19.45,-5.104,-20.142>, <17.045,-5.503,-22.214> }
		triangle { <12.2,-4.731,-18.2>, <17.045,-5.503,-22.214>, <14.421,-5.846,-24.001> }
		triangle { <12.2,-4.731,-18.2>, <14.421,-5.846,-24.001>, <12.2,-6.077,-25.202> }
		triangle { <-12.2,-4.731,-18.2>, <-21.278,-4.731,-18.2>, <-19.45,-5.104,-20.142> }
		triangle { <-12.2,-4.731,-18.2>, <-19.45,-5.104,-20.142>, <-17.045,-5.503,-22.214> }
		triangle { <-12.2,-4.731,-18.2>, <-17.045,-5.503,-22.214>, <-14.421,-5.846,-24.001> }
		triangle { <-12.2,-4.731,-18.2>, <-14.421,-5.846,-24.001>, <-12.2,-6.077,-25.202> }
		triangle { <35.8,-6.769,-28.8>, <21.932,-4.731,-18.2>, <19.798,-5.173,-20.501> }
		triangle { <35.8,-6.769,-28.8>, <19.798,-5.173,-20.501>, <17.35,-5.579,-22.611> }
		triangle { <35.8,-6.769,-28.8>, <17.35,-5.579,-22.611>, <14.679,-5.929,-24.429> }
		triangle { <35.8,-6.769,-28.8>, <14.679,-5.929,-24.429>, <12.2,-6.184,-25.757> }
		triangle { <-35.8,-6.769,-28.8>, <-21.932,-4.731,-18.2>, <-19.798,-5.173,-20.501> }
		triangle { <-35.8,-6.769,-28.8>, <-19.798,-5.173,-20.501>, <-17.35,-5.579,-22.611> }
		triangle { <-35.8,-6.769,-28.8>, <-17.35,-5.579,-22.611>, <-14.679,-5.929,-24.429> }
		triangle { <-35.8,-6.769,-28.8>, <-14.679,-5.929,-24.429>, <-12.2,-6.184,-25.757> }
		triangle { <35.8,-6.769,-28.8>, <35.8,-4.731,-18.2>, <19.798,-4.731,-18.2> }
		triangle { <-35.8,-6.769,-28.8>, <-35.8,-4.731,-18.2>, <-19.798,-4.731,-18.2> }
		triangle { <35.8,-6.769,-28.8>, <12.2,-6.769,-28.8>, <12.2,-6.077,-25.202> }
		triangle { <-35.8,-6.769,-28.8>, <-12.2,-6.769,-28.8>, <-12.2,-6.077,-25.202> }
// sidetop
		triangle { <-60,-6.846,29.2>, <-60,-4.654,17.8>, <-59.2,-4.654,17.8> }
		triangle { <-59.2,-4.654,17.8>, <-59.2,-6.846,29.2>, <-60,-6.846,29.2> }
		triangle { <60,-6.846,29.2>, <60,-4.654,17.8>, <59.2,-4.654,17.8> }
		triangle { <59.2,-4.654,17.8>, <59.2,-6.846,29.2>, <60,-6.846,29.2> }
		triangle { <-60,-7,30>, <-60,-6.846,29.2>, <60,-6.846,29.2> }
		triangle { <60,-6.846,29.2>, <60,-7,30>, <-60,-7,30> }
		triangle { <-60,-4.654,17.8>, <-22.258,-4.654,17.8>, <-22.875,-4.5,17> }
		triangle { <-22.875,-4.5,17>, <-60,-4.5,17>, <-60,-4.654,17.8> }
		triangle { <60,-4.654,17.8>, <22.258,-4.654,17.8>, <22.875,-4.5,17> }
		triangle { <22.875,-4.5,17>, <60,-4.5,17>, <60,-4.654,17.8> }
		triangle { <-21.614,-4.654,17.8>, <21.614,-4.654,17.8>, <22.249,-4.5,17> }
		triangle { <22.249,-4.5,17>, <-22.249,-4.5,17>, <-21.614,-4.654,17.8> }
		triangle { <-36.2,-6.769,28.8>, <-58.8,-6.769,28.8>, <-58.8,-4.731,18.2> }
		triangle { <-58.8,-4.731,18.2>, <-36.2,-4.731,18.2>, <-36.2,-6.769,28.8> }
		triangle { <36.2,-6.769,28.8>, <58.8,-6.769,28.8>, <58.8,-4.731,18.2> }
		triangle { <58.8,-4.731,18.2>, <36.2,-4.731,18.2>, <36.2,-6.769,28.8> }
		triangle { <-11.8,-6.769,28.8>, <-11.8,-6.22,25.942>, <-9.279,-6.413,26.947> }
		triangle { <-11.8,-6.769,28.8>, <-9.279,-6.413,26.947>, <-6.169,-6.582,27.824> }
		triangle { <-11.8,-6.769,28.8>, <-6.169,-6.582,27.824>, <-2.979,-6.682,28.344> }
		triangle { <-11.8,-6.769,28.8>, <-2.979,-6.682,28.344>, <0,-6.712,28.5> }
		triangle { <-11.8,-6.769,28.8>, <11.8,-6.769,28.8>, <0,-6.712,28.5> }
		triangle { <11.8,-6.769,28.8>, <11.8,-6.22,25.942>, <9.279,-6.413,26.947> }
		triangle { <11.8,-6.769,28.8>, <9.279,-6.413,26.947>, <6.169,-6.582,27.824> }
		triangle { <11.8,-6.769,28.8>, <6.169,-6.582,27.824>, <2.979,-6.682,28.344> }
		triangle { <11.8,-6.769,28.8>, <2.979,-6.682,28.344>, <0,-6.712,28.5> }
		triangle { <-11.8,-4.731,18.2>, <-11.8,-6.114,25.392>, <-9.116,-6.322,26.475> }
		triangle { <-11.8,-4.731,18.2>, <-9.116,-6.322,26.475>, <-6.06,-6.488,27.336> }
		triangle { <-11.8,-4.731,18.2>, <-6.06,-6.488,27.336>, <-2.927,-6.586,27.847> }
		triangle { <-11.8,-4.731,18.2>, <-2.927,-6.586,27.847>, <0,-6.615,28> }
		triangle { <-11.8,-4.731,18.2>, <11.8,-4.731,18.2>, <0,-6.615,28> }
		triangle { <11.8,-4.731,18.2>, <11.8,-6.114,25.392>, <9.116,-6.322,26.475> }
		triangle { <11.8,-4.731,18.2>, <9.116,-6.322,26.475>, <6.06,-6.488,27.336> }
		triangle { <11.8,-4.731,18.2>, <6.06,-6.488,27.336>, <2.927,-6.586,27.847> }
		triangle { <11.8,-4.731,18.2>, <2.927,-6.586,27.847>, <0,-6.615,28> }
		triangle { <-12.2,-4.731,18.2>, <-21.278,-4.731,18.2>, <-19.45,-5.104,20.142> }
		triangle { <-12.2,-4.731,18.2>, <-19.45,-5.104,20.142>, <-17.045,-5.503,22.214> }
		triangle { <-12.2,-4.731,18.2>, <-17.045,-5.503,22.214>, <-14.421,-5.846,24.001> }
		triangle { <-12.2,-4.731,18.2>, <-14.421,-5.846,24.001>, <-12.2,-6.077,25.202> }
		triangle { <12.2,-4.731,18.2>, <21.278,-4.731,18.2>, <19.45,-5.104,20.142> }
		triangle { <12.2,-4.731,18.2>, <19.45,-5.104,20.142>, <17.045,-5.503,22.214> }
		triangle { <12.2,-4.731,18.2>, <17.045,-5.503,22.214>, <14.421,-5.846,24.001> }
		triangle { <12.2,-4.731,18.2>, <14.421,-5.846,24.001>, <12.2,-6.077,25.202> }
		triangle { <-35.8,-6.769,28.8>, <-21.932,-4.731,18.2>, <-19.798,-5.173,20.501> }
		triangle { <-35.8,-6.769,28.8>, <-19.798,-5.173,20.501>, <-17.35,-5.579,22.611> }
		triangle { <-35.8,-6.769,28.8>, <-17.35,-5.579,22.611>, <-14.679,-5.929,24.429> }
		triangle { <-35.8,-6.769,28.8>, <-14.679,-5.929,24.429>, <-12.2,-6.184,25.757> }
		triangle { <35.8,-6.769,28.8>, <21.932,-4.731,18.2>, <19.798,-5.173,20.501> }
		triangle { <35.8,-6.769,28.8>, <19.798,-5.173,20.501>, <17.35,-5.579,22.611> }
		triangle { <35.8,-6.769,28.8>, <17.35,-5.579,22.611>, <14.679,-5.929,24.429> }
		triangle { <35.8,-6.769,28.8>, <14.679,-5.929,24.429>, <12.2,-6.184,25.757> }
		triangle { <-35.8,-6.769,28.8>, <-35.8,-4.731,18.2>, <-19.798,-4.731,18.2> }
		triangle { <35.8,-6.769,28.8>, <35.8,-4.731,18.2>, <19.798,-4.731,18.2> }
		triangle { <-35.8,-6.769,28.8>, <-12.2,-6.769,28.8>, <-12.2,-6.077,25.202> }
		triangle { <35.8,-6.769,28.8>, <12.2,-6.769,28.8>, <12.2,-6.077,25.202> }
		triangle { <60,-3,16>, <23.58,-3,16>, <24.11,-3,15.2> }
		triangle { <24.11,-3,15.2>, <60,-3,15.2>, <60,-3,16> }
		triangle { <22.98,-3,16>, <0,-3,16>, <0,-3,15.2> }
		triangle { <0,-3,15.2>, <23.52,-3,15.2>, <22.98,-3,16> }
		triangle { <60,-3,15.2>, <59.2,-3,15.2>, <59.2,-3,0> }
		triangle { <59.2,-3,0>, <60,-3,0>, <60,-3,15.2> }
		triangle { <58.8,-3,14.8>, <36.2,-3,14.8>, <36.2,-3,10.2> }
		triangle { <36.2,-3,10.2>, <58.8,-3,10.2>, <58.8,-3,14.8> }
		triangle { <58.8,-3,9.8>, <36.2,-3,9.8>, <36.2,-3,0.2> }
		triangle { <36.2,-3,0.2>, <58.8,-3,0.2>, <58.8,-3,9.8> }
		triangle { <11.8,-3,14.8>, <0,-3,14.8>, <0,-3,10.2> }
		triangle { <0,-3,10.2>, <11.8,-3,10.2>, <11.8,-3,14.8> }
		triangle { <11.8,-3,9.8>, <0,-3,9.8>, <0,-3,5> }
		triangle { <0,-3,5>, <11.8,-3,5>, <11.8,-3,9.8> }
		triangle { <10.5,-3,5>, <5.5,-3,5>, <5.5,-3,0.2> }
		triangle { <5.5,-3,0.2>, <10.5,-3,0.2>, <10.5,-3,5> }
		triangle { <2.5,-3,5>, <0,-3,5>, <0,-3,0.2> }
		triangle { <0,-3,0.2>, <2.5,-3,0.2>, <2.5,-3,5> }
		triangle { <24.36,-3,14.8>, <25.62,-3,12.49>, <35.8,-3,14.8> }
		triangle { <25.62,-3,12.49>, <26.61,-3,10.2>, <35.8,-3,10.2> }
		triangle { <35.8,-3,10.2>, <35.8,-3,14.8>, <25.62,-3,12.49> }
		triangle { <26.76,-3,9.8>, <27.53,-3,7.38>, <35.8,-3,9.8> }
		triangle { <27.53,-3,7.38>, <28.07,-3,4.95>, <35.8,-3,9.8> }
		triangle { <28.07,-3,4.95>, <28.39,-3,2.48>, <35.8,-3,9.8> }
		triangle { <28.39,-3,2.48>, <28.5,-3,0.2>, <35.8,-3,0.2> }
		triangle { <35.8,-3,0.2>, <35.8,-3,9.8>, <28.39,-3,2.48> }
		triangle { <23.77,-3,14.8>, <25.17,-3,12.27>, <12.2,-3,14.8> }
		triangle { <25.17,-3,12.27>, <26.08,-3,10.2>, <12.2,-3,10.2> }
		triangle { <12.2,-3,10.2>, <12.2,-3,14.8>, <25.17,-3,12.27> }
		triangle { <26.23,-3,9.8>, <27.05,-3,7.25>, <13.5,-3,5> }
		triangle { <27.05,-3,7.25>, <27.57,-3,4.86>, <13.5,-3,5> }
		triangle { <27.57,-3,4.86>, <27.89,-3,2.44>, <13.5,-3,5> }
		triangle { <27.89,-3,2.44>, <28,-3,0.2>, <13.5,-3,5> }
		triangle { <26.23,-3,9.8>, <12.2,-3,9.8>, <12.2,-3,5> }
		triangle { <12.2,-3,5>, <13.5,-3,5>, <26.23,-3,9.8> }
		triangle { <28,-3,0.2>, <13.5,-3,5>, <13.5,-3,0.2> }
		triangle { <-60,-3,-16>, <-23.58,-3,-16>, <-24.11,-3,-15.2> }
		triangle { <-24.11,-3,-15.2>, <-60,-3,-15.2>, <-60,-3,-16> }
		triangle { <-22.98,-3,-16>, <0,-3,-16>, <0,-3,-15.2> }
		triangle { <0,-3,-15.2>, <-23.52,-3,-15.2>, <-22.98,-3,-16> }
		triangle { <-60,-3,-15.2>, <-59.2,-3,-15.2>, <-59.2,-3,0> }
		triangle { <-59.2,-3,0>, <-60,-3,0>, <-60,-3,-15.2> }
		triangle { <-58.8,-3,-14.8>, <-36.2,-3,-14.8>, <-36.2,-3,-10.2> }
		triangle { <-36.2,-3,-10.2>, <-58.8,-3,-10.2>, <-58.8,-3,-14.8> }
		triangle { <-58.8,-3,-9.8>, <-36.2,-3,-9.8>, <-36.2,-3,-0.2> }
		triangle { <-36.2,-3,-0.2>, <-58.8,-3,-0.2>, <-58.8,-3,-9.8> }
		triangle { <-11.8,-3,-14.8>, <0,-3,-14.8>, <0,-3,-10.2> }
		triangle { <0,-3,-10.2>, <-11.8,-3,-10.2>, <-11.8,-3,-14.8> }
		triangle { <-11.8,-3,-9.8>, <0,-3,-9.8>, <0,-3,-5> }
		triangle { <0,-3,-5>, <-11.8,-3,-5>, <-11.8,-3,-9.8> }
		triangle { <-10.5,-3,-5>, <-5.5,-3,-5>, <-5.5,-3,-0.2> }
		triangle { <-5.5,-3,-0.2>, <-10.5,-3,-0.2>, <-10.5,-3,-5> }
		triangle { <-2.5,-3,-5>, <0,-3,-5>, <0,-3,-0.2> }
		triangle { <0,-3,-0.2>, <-2.5,-3,-0.2>, <-2.5,-3,-5> }
		triangle { <-24.36,-3,-14.8>, <-25.62,-3,-12.49>, <-35.8,-3,-14.8> }
		triangle { <-25.62,-3,-12.49>, <-26.61,-3,-10.2>, <-35.8,-3,-10.2> }
		triangle { <-35.8,-3,-10.2>, <-35.8,-3,-14.8>, <-25.62,-3,-12.49> }
		triangle { <-26.76,-3,-9.8>, <-27.53,-3,-7.38>, <-35.8,-3,-9.8> }
		triangle { <-27.53,-3,-7.38>, <-28.07,-3,-4.95>, <-35.8,-3,-9.8> }
		triangle { <-28.07,-3,-4.95>, <-28.39,-3,-2.48>, <-35.8,-3,-9.8> }
		triangle { <-28.39,-3,-2.48>, <-28.5,-3,-0.2>, <-35.8,-3,-0.2> }
		triangle { <-35.8,-3,-0.2>, <-35.8,-3,-9.8>, <-28.39,-3,-2.48> }
		triangle { <-23.77,-3,-14.8>, <-25.17,-3,-12.27>, <-12.2,-3,-14.8> }
		triangle { <-25.17,-3,-12.27>, <-26.08,-3,-10.2>, <-12.2,-3,-10.2> }
		triangle { <-12.2,-3,-10.2>, <-12.2,-3,-14.8>, <-25.17,-3,-12.27> }
		triangle { <-26.23,-3,-9.8>, <-27.05,-3,-7.25>, <-13.5,-3,-5> }
		triangle { <-27.05,-3,-7.25>, <-27.57,-3,-4.86>, <-13.5,-3,-5> }
		triangle { <-27.57,-3,-4.86>, <-27.89,-3,-2.44>, <-13.5,-3,-5> }
		triangle { <-27.89,-3,-2.44>, <-28,-3,-0.2>, <-13.5,-3,-5> }
		triangle { <-26.23,-3,-9.8>, <-12.2,-3,-9.8>, <-12.2,-3,-5> }
		triangle { <-12.2,-3,-5>, <-13.5,-3,-5>, <-26.23,-3,-9.8> }
		triangle { <-28,-3,-0.2>, <-13.5,-3,-5>, <-13.5,-3,-0.2> }
		triangle { <-60,-3,16>, <-23.58,-3,16>, <-24.11,-3,15.2> }
		triangle { <-24.11,-3,15.2>, <-60,-3,15.2>, <-60,-3,16> }
		triangle { <-22.98,-3,16>, <0,-3,16>, <0,-3,15.2> }
		triangle { <0,-3,15.2>, <-23.52,-3,15.2>, <-22.98,-3,16> }
		triangle { <-60,-3,15.2>, <-59.2,-3,15.2>, <-59.2,-3,0> }
		triangle { <-59.2,-3,0>, <-60,-3,0>, <-60,-3,15.2> }
		triangle { <-58.8,-3,14.8>, <-36.2,-3,14.8>, <-36.2,-3,10.2> }
		triangle { <-36.2,-3,10.2>, <-58.8,-3,10.2>, <-58.8,-3,14.8> }
		triangle { <-58.8,-3,9.8>, <-36.2,-3,9.8>, <-36.2,-3,0.2> }
		triangle { <-36.2,-3,0.2>, <-58.8,-3,0.2>, <-58.8,-3,9.8> }
		triangle { <-11.8,-3,14.8>, <0,-3,14.8>, <0,-3,10.2> }
		triangle { <0,-3,10.2>, <-11.8,-3,10.2>, <-11.8,-3,14.8> }
		triangle { <-11.8,-3,9.8>, <0,-3,9.8>, <0,-3,5> }
		triangle { <0,-3,5>, <-11.8,-3,5>, <-11.8,-3,9.8> }
		triangle { <-10.5,-3,5>, <-5.5,-3,5>, <-5.5,-3,0.2> }
		triangle { <-5.5,-3,0.2>, <-10.5,-3,0.2>, <-10.5,-3,5> }
		triangle { <-2.5,-3,5>, <0,-3,5>, <0,-3,0.2> }
		triangle { <0,-3,0.2>, <-2.5,-3,0.2>, <-2.5,-3,5> }
		triangle { <-24.36,-3,14.8>, <-25.62,-3,12.49>, <-35.8,-3,14.8> }
		triangle { <-25.62,-3,12.49>, <-26.61,-3,10.2>, <-35.8,-3,10.2> }
		triangle { <-35.8,-3,10.2>, <-35.8,-3,14.8>, <-25.62,-3,12.49> }
		triangle { <-26.76,-3,9.8>, <-27.53,-3,7.38>, <-35.8,-3,9.8> }
		triangle { <-27.53,-3,7.38>, <-28.07,-3,4.95>, <-35.8,-3,9.8> }
		triangle { <-28.07,-3,4.95>, <-28.39,-3,2.48>, <-35.8,-3,9.8> }
		triangle { <-28.39,-3,2.48>, <-28.5,-3,0.2>, <-35.8,-3,0.2> }
		triangle { <-35.8,-3,0.2>, <-35.8,-3,9.8>, <-28.39,-3,2.48> }
		triangle { <-23.77,-3,14.8>, <-25.17,-3,12.27>, <-12.2,-3,14.8> }
		triangle { <-25.17,-3,12.27>, <-26.08,-3,10.2>, <-12.2,-3,10.2> }
		triangle { <-12.2,-3,10.2>, <-12.2,-3,14.8>, <-25.17,-3,12.27> }
		triangle { <-26.23,-3,9.8>, <-27.05,-3,7.25>, <-13.5,-3,5> }
		triangle { <-27.05,-3,7.25>, <-27.57,-3,4.86>, <-13.5,-3,5> }
		triangle { <-27.57,-3,4.86>, <-27.89,-3,2.44>, <-13.5,-3,5> }
		triangle { <-27.89,-3,2.44>, <-28,-3,0.2>, <-13.5,-3,5> }
		triangle { <-26.23,-3,9.8>, <-12.2,-3,9.8>, <-12.2,-3,5> }
		triangle { <-12.2,-3,5>, <-13.5,-3,5>, <-26.23,-3,9.8> }
		triangle { <-28,-3,0.2>, <-13.5,-3,5>, <-13.5,-3,0.2> }
		triangle { <60,-3,-16>, <23.58,-3,-16>, <24.11,-3,-15.2> }
		triangle { <24.11,-3,-15.2>, <60,-3,-15.2>, <60,-3,-16> }
		triangle { <22.98,-3,-16>, <0,-3,-16>, <0,-3,-15.2> }
		triangle { <0,-3,-15.2>, <23.52,-3,-15.2>, <22.98,-3,-16> }
		triangle { <60,-3,-15.2>, <59.2,-3,-15.2>, <59.2,-3,0> }
		triangle { <59.2,-3,0>, <60,-3,0>, <60,-3,-15.2> }
		triangle { <58.8,-3,-14.8>, <36.2,-3,-14.8>, <36.2,-3,-10.2> }
		triangle { <36.2,-3,-10.2>, <58.8,-3,-10.2>, <58.8,-3,-14.8> }
		triangle { <58.8,-3,-9.8>, <36.2,-3,-9.8>, <36.2,-3,-0.2> }
		triangle { <36.2,-3,-0.2>, <58.8,-3,-0.2>, <58.8,-3,-9.8> }
		triangle { <11.8,-3,-14.8>, <0,-3,-14.8>, <0,-3,-10.2> }
		triangle { <0,-3,-10.2>, <11.8,-3,-10.2>, <11.8,-3,-14.8> }
		triangle { <11.8,-3,-9.8>, <0,-3,-9.8>, <0,-3,-5> }
		triangle { <0,-3,-5>, <11.8,-3,-5>, <11.8,-3,-9.8> }
		triangle { <10.5,-3,-5>, <5.5,-3,-5>, <5.5,-3,-0.2> }
		triangle { <5.5,-3,-0.2>, <10.5,-3,-0.2>, <10.5,-3,-5> }
		triangle { <2.5,-3,-5>, <0,-3,-5>, <0,-3,-0.2> }
		triangle { <0,-3,-0.2>, <2.5,-3,-0.2>, <2.5,-3,-5> }
		triangle { <24.36,-3,-14.8>, <25.62,-3,-12.49>, <35.8,-3,-14.8> }
		triangle { <25.62,-3,-12.49>, <26.61,-3,-10.2>, <35.8,-3,-10.2> }
		triangle { <35.8,-3,-10.2>, <35.8,-3,-14.8>, <25.62,-3,-12.49> }
		triangle { <26.76,-3,-9.8>, <27.53,-3,-7.38>, <35.8,-3,-9.8> }
		triangle { <27.53,-3,-7.38>, <28.07,-3,-4.95>, <35.8,-3,-9.8> }
		triangle { <28.07,-3,-4.95>, <28.39,-3,-2.48>, <35.8,-3,-9.8> }
		triangle { <28.39,-3,-2.48>, <28.5,-3,-0.2>, <35.8,-3,-0.2> }
		triangle { <35.8,-3,-0.2>, <35.8,-3,-9.8>, <28.39,-3,-2.48> }
		triangle { <23.77,-3,-14.8>, <25.17,-3,-12.27>, <12.2,-3,-14.8> }
		triangle { <25.17,-3,-12.27>, <26.08,-3,-10.2>, <12.2,-3,-10.2> }
		triangle { <12.2,-3,-10.2>, <12.2,-3,-14.8>, <25.17,-3,-12.27> }
		triangle { <26.23,-3,-9.8>, <27.05,-3,-7.25>, <13.5,-3,-5> }
		triangle { <27.05,-3,-7.25>, <27.57,-3,-4.86>, <13.5,-3,-5> }
		triangle { <27.57,-3,-4.86>, <27.89,-3,-2.44>, <13.5,-3,-5> }
		triangle { <27.89,-3,-2.44>, <28,-3,-0.2>, <13.5,-3,-5> }
		triangle { <26.23,-3,-9.8>, <12.2,-3,-9.8>, <12.2,-3,-5> }
		triangle { <12.2,-3,-5>, <13.5,-3,-5>, <26.23,-3,-9.8> }
		triangle { <28,-3,-0.2>, <13.5,-3,-5>, <13.5,-3,-0.2> }
// 
	}
}
#end

#declare _6039_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,40,20> } #else union {
// Cone  2 x  2 x  1 & 2/3 Octagonal
	mesh {
		triangle { <8.28,40,20>, <12.28,40,16>, <-12.28,40,16> }
		triangle { <-12.28,40,16>, <-8.28,40,20>, <8.28,40,20> }
		triangle { <12.28,40,16>, <12.28,36,16>, <-12.28,36,16> }
		triangle { <-12.28,36,16>, <-12.28,40,16>, <12.28,40,16> }
		triangle { <20,40,8.28>, <20,32,8.28>, <16,36,12.28> }
		triangle { <16,36,12.28>, <16,40,12.28>, <20,40,8.28> }
		triangle { <16,36,12.28>, <20,32,8.28>, <8.28,32,20> }
		triangle { <8.28,32,20>, <12.28,36,16>, <16,36,12.28> }
		triangle { <12.28,40,16>, <12.28,36,16>, <8.28,32,20> }
		triangle { <8.28,32,20>, <8.28,40,20>, <12.28,40,16> }
		triangle { <8.28,40,20>, <8.28,32,20>, <-8.28,32,20> }
		triangle { <-8.28,32,20>, <-8.28,40,20>, <8.28,40,20> }
		triangle { <16,36,6.6>, <16,36,12.28>, <12.28,36,16> }
		triangle { <12.28,36,16>, <6.6,36,16>, <16,36,6.6> }
		triangle { <-20,40,8.28>, <-16,40,12.28>, <-16,40,-12.28> }
		triangle { <-16,40,-12.28>, <-20,40,-8.28>, <-20,40,8.28> }
		triangle { <-16,40,12.28>, <-16,36,12.28>, <-16,36,-12.28> }
		triangle { <-16,36,-12.28>, <-16,40,-12.28>, <-16,40,12.28> }
		triangle { <-8.28,40,20>, <-8.28,32,20>, <-12.28,36,16> }
		triangle { <-12.28,36,16>, <-12.28,40,16>, <-8.28,40,20> }
		triangle { <-12.28,36,16>, <-8.28,32,20>, <-20,32,8.28> }
		triangle { <-20,32,8.28>, <-16,36,12.28>, <-12.28,36,16> }
		triangle { <-16,40,12.28>, <-16,36,12.28>, <-20,32,8.28> }
		triangle { <-20,32,8.28>, <-20,40,8.28>, <-16,40,12.28> }
		triangle { <-20,40,8.28>, <-20,32,8.28>, <-20,32,-8.28> }
		triangle { <-20,32,-8.28>, <-20,40,-8.28>, <-20,40,8.28> }
		triangle { <-6.6,36,16>, <-12.28,36,16>, <-16,36,12.28> }
		triangle { <-16,36,12.28>, <-16,36,6.6>, <-6.6,36,16> }
		triangle { <-8.28,40,-20>, <-12.28,40,-16>, <12.28,40,-16> }
		triangle { <12.28,40,-16>, <8.28,40,-20>, <-8.28,40,-20> }
		triangle { <-12.28,40,-16>, <-12.28,36,-16>, <12.28,36,-16> }
		triangle { <12.28,36,-16>, <12.28,40,-16>, <-12.28,40,-16> }
		triangle { <-20,40,-8.28>, <-20,32,-8.28>, <-16,36,-12.28> }
		triangle { <-16,36,-12.28>, <-16,40,-12.28>, <-20,40,-8.28> }
		triangle { <-16,36,-12.28>, <-20,32,-8.28>, <-8.28,32,-20> }
		triangle { <-8.28,32,-20>, <-12.28,36,-16>, <-16,36,-12.28> }
		triangle { <-12.28,40,-16>, <-12.28,36,-16>, <-8.28,32,-20> }
		triangle { <-8.28,32,-20>, <-8.28,40,-20>, <-12.28,40,-16> }
		triangle { <-8.28,40,-20>, <-8.28,32,-20>, <8.28,32,-20> }
		triangle { <8.28,32,-20>, <8.28,40,-20>, <-8.28,40,-20> }
		triangle { <-16,36,-6.6>, <-16,36,-12.28>, <-12.28,36,-16> }
		triangle { <-12.28,36,-16>, <-6.6,36,-16>, <-16,36,-6.6> }
		triangle { <20,40,-8.28>, <16,40,-12.28>, <16,40,12.28> }
		triangle { <16,40,12.28>, <20,40,8.28>, <20,40,-8.28> }
		triangle { <16,40,-12.28>, <16,36,-12.28>, <16,36,12.28> }
		triangle { <16,36,12.28>, <16,40,12.28>, <16,40,-12.28> }
		triangle { <8.28,40,-20>, <8.28,32,-20>, <12.28,36,-16> }
		triangle { <12.28,36,-16>, <12.28,40,-16>, <8.28,40,-20> }
		triangle { <12.28,36,-16>, <8.28,32,-20>, <20,32,-8.28> }
		triangle { <20,32,-8.28>, <16,36,-12.28>, <12.28,36,-16> }
		triangle { <16,40,-12.28>, <16,36,-12.28>, <20,32,-8.28> }
		triangle { <20,32,-8.28>, <20,40,-8.28>, <16,40,-12.28> }
		triangle { <20,40,-8.28>, <20,32,-8.28>, <20,32,8.28> }
		triangle { <20,32,8.28>, <20,40,8.28>, <20,40,-8.28> }
		triangle { <6.6,36,-16>, <12.28,36,-16>, <16,36,-12.28> }
		triangle { <16,36,-12.28>, <16,36,-6.6>, <6.6,36,-16> }
		triangle { <10,0,4.14>, <20,32,8.28>, <20,32,-8.28> }
		triangle { <20,32,-8.28>, <10,0,-4.14>, <10,0,4.14> }
		triangle { <10,0,-4.14>, <20,32,-8.28>, <8.28,32,-20> }
		triangle { <8.28,32,-20>, <4.14,0,-10>, <10,0,-4.14> }
		triangle { <4.14,0,-10>, <8.28,32,-20>, <-8.28,32,-20> }
		triangle { <-8.28,32,-20>, <-4.14,0,-10>, <4.14,0,-10> }
		triangle { <-4.14,0,-10>, <-8.28,32,-20>, <-20,32,-8.28> }
		triangle { <-20,32,-8.28>, <-10,0,-4.14>, <-4.14,0,-10> }
		triangle { <-10,0,-4.14>, <-20,32,-8.28>, <-20,32,8.28> }
		triangle { <-20,32,8.28>, <-10,0,4.14>, <-10,0,-4.14> }
		triangle { <-10,0,4.14>, <-20,32,8.28>, <-8.28,32,20> }
		triangle { <-8.28,32,20>, <-4.14,0,10>, <-10,0,4.14> }
		triangle { <-4.14,0,10>, <-8.28,32,20>, <8.28,32,20> }
		triangle { <8.28,32,20>, <4.14,0,10>, <-4.14,0,10> }
		triangle { <4.14,0,10>, <8.28,32,20>, <20,32,8.28> }
		triangle { <20,32,8.28>, <10,0,4.14>, <4.14,0,10> }
	}
	#if (STUDS)
		object { stud2a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	#end
	object { _4_dash_4ndis_dot_dat matrix <6,0,0,0,1,0,0,0,6,0,0,0> }
	mesh {
		triangle { <10,0,4.14>, <10,0,-4.14>, <6,0,-6> }
		triangle { <6,0,-6>, <6,0,6>, <10,0,4.14> }
		triangle { <10,0,-4.14>, <4.14,0,-10>, <6,0,-6> }
		triangle { <4.14,0,-10>, <-4.14,0,-10>, <-6,0,-6> }
		triangle { <-6,0,-6>, <6,0,-6>, <4.14,0,-10> }
		triangle { <-4.14,0,-10>, <-10,0,-4.14>, <-6,0,-6> }
		triangle { <-10,0,-4.14>, <-10,0,4.14>, <-6,0,6> }
		triangle { <-6,0,6>, <-6,0,-6>, <-10,0,-4.14> }
		triangle { <-10,0,4.14>, <-4.14,0,10>, <-6,0,6> }
		triangle { <-4.14,0,10>, <4.14,0,10>, <6,0,6> }
		triangle { <6,0,6>, <-6,0,6>, <-4.14,0,10> }
		triangle { <4.14,0,10>, <10,0,4.14>, <6,0,6> }
	}
	object { ring2_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,16,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,16,0,0,0,4,0,0,0> }
	object { axlehole_dot_dat matrix <1,0,0,0,16,0,0,0,1,0,16,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,8,0,0,0,6,0,32,0> }
	object { ring3_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,40,0> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,30,0,0,0,8,0,10,0> }
	mesh {
		triangle { <16,36,6.6>, <16,28,6.6>, <16,28,-6.6> }
		triangle { <16,28,-6.6>, <16,36,-6.6>, <16,36,6.6> }
		triangle { <16,36,-6.6>, <16,28,-6.6>, <6.6,28,-16> }
		triangle { <6.6,28,-16>, <6.6,36,-16>, <16,36,-6.6> }
		triangle { <6.6,36,-16>, <6.6,28,-16>, <-6.6,28,-16> }
		triangle { <-6.6,28,-16>, <-6.6,36,-16>, <6.6,36,-16> }
		triangle { <-6.6,36,-16>, <-6.6,28,-16>, <-16,28,-6.6> }
		triangle { <-16,28,-6.6>, <-16,36,-6.6>, <-6.6,36,-16> }
		triangle { <-16,36,-6.6>, <-16,28,-6.6>, <-16,28,6.6> }
		triangle { <-16,28,6.6>, <-16,36,6.6>, <-16,36,-6.6> }
		triangle { <-16,36,6.6>, <-16,28,6.6>, <-6.6,28,16> }
		triangle { <-6.6,28,16>, <-6.6,36,16>, <-16,36,6.6> }
		triangle { <-6.6,36,16>, <-6.6,28,16>, <6.6,28,16> }
		triangle { <6.6,28,16>, <6.6,36,16>, <-6.6,36,16> }
		triangle { <6.6,36,16>, <6.6,28,16>, <16,28,6.6> }
		triangle { <16,28,6.6>, <16,36,6.6>, <6.6,36,16> }
		triangle { <16,28,6.6>, <9.125,10,3.778>, <9.125,10,-3.778> }
		triangle { <9.125,10,-3.778>, <16,28,-6.6>, <16,28,6.6> }
		triangle { <16,28,-6.6>, <9.125,10,-3.778>, <3.778,10,-9.125> }
		triangle { <3.778,10,-9.125>, <6.6,28,-16>, <16,28,-6.6> }
		triangle { <6.6,28,-16>, <3.778,10,-9.125>, <-3.778,10,-9.125> }
		triangle { <-3.778,10,-9.125>, <-6.6,28,-16>, <6.6,28,-16> }
		triangle { <-6.6,28,-16>, <-3.778,10,-9.125>, <-9.125,10,-3.778> }
		triangle { <-9.125,10,-3.778>, <-16,28,-6.6>, <-6.6,28,-16> }
		triangle { <-16,28,-6.6>, <-9.125,10,-3.778>, <-9.125,10,3.778> }
		triangle { <-9.125,10,3.778>, <-16,28,6.6>, <-16,28,-6.6> }
		triangle { <-16,28,6.6>, <-9.125,10,3.778>, <-3.778,10,9.125> }
		triangle { <-3.778,10,9.125>, <-6.6,28,16>, <-16,28,6.6> }
		triangle { <-6.6,28,16>, <-3.778,10,9.125>, <3.778,10,9.125> }
		triangle { <3.778,10,9.125>, <6.6,28,16>, <-6.6,28,16> }
		triangle { <6.6,28,16>, <3.778,10,9.125>, <9.125,10,3.778> }
		triangle { <9.125,10,3.778>, <16,28,6.6>, <6.6,28,16> }
	}
	object { ring4_dot_dat matrix <2,0,0,0,1,0,0,0,2,0,10,0> }
}
#end

#declare _2432_dot_dat = #if (QUAL = 0) box { <-20,0,-10>, <20,32,10> } #else union {
// Tile  1 x  2 with Handle
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,28,0> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,6,0,32,0> }
	mesh {
		triangle { <20,32,10>, <16,32,6>, <-16,32,6> }
		triangle { <-16,32,6>, <-20,32,10>, <20,32,10> }
		triangle { <-20,32,10>, <-16,32,6>, <-16,32,-6> }
		triangle { <-16,32,-6>, <-20,32,-10>, <-20,32,10> }
		triangle { <-20,32,-10>, <-16,32,-6>, <16,32,-6> }
		triangle { <16,32,-6>, <20,32,-10>, <-20,32,-10> }
		triangle { <20,32,-10>, <16,32,-6>, <16,32,6> }
		triangle { <16,32,6>, <20,32,10>, <20,32,-10> }
	}
	object { _2_dash_4disc_dot_dat matrix <0,0,4,1,0,0,0,-4,0,20,4,6> }
	object { _2_dash_4disc_dot_dat matrix <0,0,4,1,0,0,0,-4,0,-20,4,6> }
	object { _2_dash_4cyli_dot_dat matrix <0,0,4,-40,0,0,0,-4,0,20,4,6> }
	object { _2_dash_4cyli_dot_dat matrix <0,0,4,-32,0,0,0,4,0,16,4,6> }
	mesh {
		triangle { <16,24,10>, <-16,24,10>, <-16,24,-10> }
		triangle { <-16,24,-10>, <16,24,-10>, <16,24,10> }
		triangle { <20,32,10>, <20,24,10>, <20,24,-10> }
		triangle { <20,24,-10>, <20,32,-10>, <20,32,10> }
		triangle { <-20,32,10>, <-20,24,10>, <-20,24,-10> }
		triangle { <-20,24,-10>, <-20,32,-10>, <-20,32,10> }
		triangle { <20,24,10>, <20,4,10>, <20,4,2> }
		triangle { <20,4,2>, <20,24,-10>, <20,24,10> }
		triangle { <-20,24,10>, <-20,4,10>, <-20,4,2> }
		triangle { <-20,4,2>, <-20,24,-10>, <-20,24,10> }
		triangle { <16,24,10>, <16,4,10>, <16,4,2> }
		triangle { <16,4,2>, <16,24,-10>, <16,24,10> }
		triangle { <-16,24,10>, <-16,4,10>, <-16,4,2> }
		triangle { <-16,4,2>, <-16,24,-10>, <-16,24,10> }
		triangle { <20,32,10>, <20,24,10>, <-20,24,10> }
		triangle { <-20,24,10>, <-20,32,10>, <20,32,10> }
		triangle { <20,32,-10>, <20,24,-10>, <-20,24,-10> }
		triangle { <-20,24,-10>, <-20,32,-10>, <20,32,-10> }
		triangle { <20,24,10>, <20,4,10>, <16,4,10> }
		triangle { <16,4,10>, <16,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-20,4,10>, <-16,4,10> }
		triangle { <-16,4,10>, <-16,24,10>, <-20,24,10> }
		triangle { <20,24,-10>, <20,4,2>, <16,4,2> }
		triangle { <16,4,2>, <16,24,-10>, <20,24,-10> }
		triangle { <-20,24,-10>, <-20,4,2>, <-16,4,2> }
		triangle { <-16,4,2>, <-16,24,-10>, <-20,24,-10> }
	}
}
#end

#declare _298_dot_dat = #if (QUAL = 0) box { <-8,-5.58,-8>, <8,8,8> } #else union {
// Lever Small Base
	mesh {
		triangle { <0,8,-8>, <3.062,8,-7.391>, <2.296,8,-5.543> }
		triangle { <2.296,8,-5.543>, <0,8,-6>, <0,8,-8> }
		triangle { <3.062,8,-7.391>, <5.657,8,-5.657>, <4.243,8,-4.243> }
		triangle { <4.243,8,-4.243>, <2.296,8,-5.543>, <3.062,8,-7.391> }
		triangle { <5.657,8,-5.657>, <7.391,8,-3.062>, <5.543,8,-2.296> }
		triangle { <5.543,8,-2.296>, <4.243,8,-4.243>, <5.657,8,-5.657> }
		triangle { <7.391,8,-3.062>, <8,8,0>, <6,8,0> }
		triangle { <6,8,0>, <5.543,8,-2.296>, <7.391,8,-3.062> }
	}
	object { _1_dash_4cyli_dot_dat matrix <8,0,0,0,6,0,0,0,-8,0,2,0> }
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,6,0,0,0,-6,0,2,0> }
	mesh {
		triangle { <0,0,-7.58>, <2,0,-7.16>, <2,0,-5> }
		triangle { <2,0,-5>, <0,0,-5>, <0,0,-7.58> }
		triangle { <0,0,-5>, <2,0,-5>, <2,2,-5> }
		triangle { <2,2,-5>, <0,2,-5>, <0,0,-5> }
		triangle { <2,2,-7.58>, <2,-1.04,-6.94>, <2,2,0> }
		triangle { <2,-1.04,-6.94>, <2,-3.36,-5.36>, <2,2,0> }
		triangle { <2,-3.36,-5.36>, <2,-4.94,-3.04>, <2,2,0> }
		triangle { <2,-4.94,-3.04>, <2,-5.58,0>, <2,2,0> }
		triangle { <0,2,-8>, <2,2,-7.58>, <2,0,-7.16> }
		triangle { <2,0,-7.16>, <0,0,-7.58>, <0,2,-8> }
		triangle { <2,-5.58,0>, <3.04,-5.36,0>, <3.04,-4.72,-3.04> }
		triangle { <3.04,-4.72,-3.04>, <2,-4.94,-3.04>, <2,-5.58,0> }
		triangle { <3.04,-5.36,0>, <5.68,-3.68,0>, <5.2,-3.2,-3.04> }
		triangle { <5.2,-3.2,-3.04>, <3.04,-4.72,-3.04>, <3.04,-5.36,0> }
		triangle { <5.68,-3.68,0>, <7.36,-1.04,0>, <6.72,-1.04,-3.04> }
		triangle { <6.72,-1.04,-3.04>, <5.2,-3.2,-3.04>, <5.68,-3.68,0> }
		triangle { <7.36,-1.04,0>, <8,2,0>, <7.36,2,-3.04> }
		triangle { <7.36,2,-3.04>, <6.72,-1.04,-3.04>, <7.36,-1.04,0> }
		triangle { <2,-4.94,-3.04>, <3.04,-4.72,-3.04>, <3.04,-3.2,-5.2> }
		triangle { <3.04,-3.2,-5.2>, <2,-3.36,-5.36>, <2,-4.94,-3.04> }
		triangle { <3.04,-4.72,-3.04>, <3.04,-3.2,-5.2>, <5.2,-3.2,-3.04> }
		triangle { <5.2,-3.2,-3.04>, <3.04,-3.2,-5.2>, <5.2,-1.04,-5.2> }
		triangle { <5.2,-3.2,-3.04>, <5.2,-1.04,-5.2>, <6.72,-1.04,-3.04> }
		triangle { <7.36,2,-3.04>, <6.72,-1.04,-3.04>, <5.2,-1.04,-5.2> }
		triangle { <5.2,-1.04,-5.2>, <5.68,2,-5.68>, <7.36,2,-3.04> }
		triangle { <2,-3.36,-5.36>, <3.04,-3.2,-5.2>, <3.04,-1.04,-6.72> }
		triangle { <3.04,-1.04,-6.72>, <2,-1.04,-6.94>, <2,-3.36,-5.36> }
		triangle { <3.04,-3.2,-5.2>, <3.04,-1.04,-6.72>, <5.2,-1.04,-5.2> }
		triangle { <5.68,2,-5.68>, <5.2,-1.04,-5.2>, <3.04,-1.04,-6.72> }
		triangle { <3.04,-1.04,-6.72>, <3.04,2,-7.36>, <5.68,2,-5.68> }
		triangle { <2,-1.04,-6.94>, <3.04,-1.04,-6.72>, <3.04,2,-7.36> }
		triangle { <3.04,2,-7.36>, <2,2,-7.58>, <2,-1.04,-6.94> }
		triangle { <-8,8,0>, <-7.391,8,-3.062>, <-5.543,8,-2.296> }
		triangle { <-5.543,8,-2.296>, <-6,8,0>, <-8,8,0> }
		triangle { <-7.391,8,-3.062>, <-5.657,8,-5.657>, <-4.243,8,-4.243> }
		triangle { <-4.243,8,-4.243>, <-5.543,8,-2.296>, <-7.391,8,-3.062> }
		triangle { <-5.657,8,-5.657>, <-3.062,8,-7.391>, <-2.296,8,-5.543> }
		triangle { <-2.296,8,-5.543>, <-4.243,8,-4.243>, <-5.657,8,-5.657> }
		triangle { <-3.062,8,-7.391>, <0,8,-8>, <0,8,-6> }
		triangle { <0,8,-6>, <-2.296,8,-5.543>, <-3.062,8,-7.391> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-8,0,0,0,6,0,0,0,-8,0,2,0> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,6,0,0,0,-6,0,2,0> }
	mesh {
		triangle { <0,0,-7.58>, <-2,0,-7.16>, <-2,0,-5> }
		triangle { <-2,0,-5>, <0,0,-5>, <0,0,-7.58> }
		triangle { <0,0,-5>, <-2,0,-5>, <-2,2,-5> }
		triangle { <-2,2,-5>, <0,2,-5>, <0,0,-5> }
		triangle { <-2,2,-7.58>, <-2,-1.04,-6.94>, <-2,2,0> }
		triangle { <-2,-1.04,-6.94>, <-2,-3.36,-5.36>, <-2,2,0> }
		triangle { <-2,-3.36,-5.36>, <-2,-4.94,-3.04>, <-2,2,0> }
		triangle { <-2,-4.94,-3.04>, <-2,-5.58,0>, <-2,2,0> }
		triangle { <0,2,-8>, <-2,2,-7.58>, <-2,0,-7.16> }
		triangle { <-2,0,-7.16>, <0,0,-7.58>, <0,2,-8> }
		triangle { <-2,-5.58,0>, <-3.04,-5.36,0>, <-3.04,-4.72,-3.04> }
		triangle { <-3.04,-4.72,-3.04>, <-2,-4.94,-3.04>, <-2,-5.58,0> }
		triangle { <-3.04,-5.36,0>, <-5.68,-3.68,0>, <-5.2,-3.2,-3.04> }
		triangle { <-5.2,-3.2,-3.04>, <-3.04,-4.72,-3.04>, <-3.04,-5.36,0> }
		triangle { <-5.68,-3.68,0>, <-7.36,-1.04,0>, <-6.72,-1.04,-3.04> }
		triangle { <-6.72,-1.04,-3.04>, <-5.2,-3.2,-3.04>, <-5.68,-3.68,0> }
		triangle { <-7.36,-1.04,0>, <-8,2,0>, <-7.36,2,-3.04> }
		triangle { <-7.36,2,-3.04>, <-6.72,-1.04,-3.04>, <-7.36,-1.04,0> }
		triangle { <-2,-4.94,-3.04>, <-3.04,-4.72,-3.04>, <-3.04,-3.2,-5.2> }
		triangle { <-3.04,-3.2,-5.2>, <-2,-3.36,-5.36>, <-2,-4.94,-3.04> }
		triangle { <-3.04,-4.72,-3.04>, <-3.04,-3.2,-5.2>, <-5.2,-3.2,-3.04> }
		triangle { <-5.2,-3.2,-3.04>, <-3.04,-3.2,-5.2>, <-5.2,-1.04,-5.2> }
		triangle { <-5.2,-3.2,-3.04>, <-5.2,-1.04,-5.2>, <-6.72,-1.04,-3.04> }
		triangle { <-7.36,2,-3.04>, <-6.72,-1.04,-3.04>, <-5.2,-1.04,-5.2> }
		triangle { <-5.2,-1.04,-5.2>, <-5.68,2,-5.68>, <-7.36,2,-3.04> }
		triangle { <-2,-3.36,-5.36>, <-3.04,-3.2,-5.2>, <-3.04,-1.04,-6.72> }
		triangle { <-3.04,-1.04,-6.72>, <-2,-1.04,-6.94>, <-2,-3.36,-5.36> }
		triangle { <-3.04,-3.2,-5.2>, <-3.04,-1.04,-6.72>, <-5.2,-1.04,-5.2> }
		triangle { <-5.68,2,-5.68>, <-5.2,-1.04,-5.2>, <-3.04,-1.04,-6.72> }
		triangle { <-3.04,-1.04,-6.72>, <-3.04,2,-7.36>, <-5.68,2,-5.68> }
		triangle { <-2,-1.04,-6.94>, <-3.04,-1.04,-6.72>, <-3.04,2,-7.36> }
		triangle { <-3.04,2,-7.36>, <-2,2,-7.58>, <-2,-1.04,-6.94> }
		triangle { <8,8,0>, <7.391,8,3.062>, <5.543,8,2.296> }
		triangle { <5.543,8,2.296>, <6,8,0>, <8,8,0> }
		triangle { <7.391,8,3.062>, <5.657,8,5.657>, <4.243,8,4.243> }
		triangle { <4.243,8,4.243>, <5.543,8,2.296>, <7.391,8,3.062> }
		triangle { <5.657,8,5.657>, <3.062,8,7.391>, <2.296,8,5.543> }
		triangle { <2.296,8,5.543>, <4.243,8,4.243>, <5.657,8,5.657> }
		triangle { <3.062,8,7.391>, <0,8,8>, <0,8,6> }
		triangle { <0,8,6>, <2.296,8,5.543>, <3.062,8,7.391> }
	}
	object { _1_dash_4cyli_dot_dat matrix <8,0,0,0,6,0,0,0,8,0,2,0> }
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,6,0,0,0,6,0,2,0> }
	mesh {
		triangle { <0,0,7.58>, <2,0,7.16>, <2,0,5> }
		triangle { <2,0,5>, <0,0,5>, <0,0,7.58> }
		triangle { <0,0,5>, <2,0,5>, <2,2,5> }
		triangle { <2,2,5>, <0,2,5>, <0,0,5> }
		triangle { <2,2,7.58>, <2,-1.04,6.94>, <2,2,0> }
		triangle { <2,-1.04,6.94>, <2,-3.36,5.36>, <2,2,0> }
		triangle { <2,-3.36,5.36>, <2,-4.94,3.04>, <2,2,0> }
		triangle { <2,-4.94,3.04>, <2,-5.58,0>, <2,2,0> }
		triangle { <0,2,8>, <2,2,7.58>, <2,0,7.16> }
		triangle { <2,0,7.16>, <0,0,7.58>, <0,2,8> }
		triangle { <2,-5.58,0>, <3.04,-5.36,0>, <3.04,-4.72,3.04> }
		triangle { <3.04,-4.72,3.04>, <2,-4.94,3.04>, <2,-5.58,0> }
		triangle { <3.04,-5.36,0>, <5.68,-3.68,0>, <5.2,-3.2,3.04> }
		triangle { <5.2,-3.2,3.04>, <3.04,-4.72,3.04>, <3.04,-5.36,0> }
		triangle { <5.68,-3.68,0>, <7.36,-1.04,0>, <6.72,-1.04,3.04> }
		triangle { <6.72,-1.04,3.04>, <5.2,-3.2,3.04>, <5.68,-3.68,0> }
		triangle { <7.36,-1.04,0>, <8,2,0>, <7.36,2,3.04> }
		triangle { <7.36,2,3.04>, <6.72,-1.04,3.04>, <7.36,-1.04,0> }
		triangle { <2,-4.94,3.04>, <3.04,-4.72,3.04>, <3.04,-3.2,5.2> }
		triangle { <3.04,-3.2,5.2>, <2,-3.36,5.36>, <2,-4.94,3.04> }
		triangle { <3.04,-4.72,3.04>, <3.04,-3.2,5.2>, <5.2,-3.2,3.04> }
		triangle { <5.2,-3.2,3.04>, <3.04,-3.2,5.2>, <5.2,-1.04,5.2> }
		triangle { <5.2,-3.2,3.04>, <5.2,-1.04,5.2>, <6.72,-1.04,3.04> }
		triangle { <7.36,2,3.04>, <6.72,-1.04,3.04>, <5.2,-1.04,5.2> }
		triangle { <5.2,-1.04,5.2>, <5.68,2,5.68>, <7.36,2,3.04> }
		triangle { <2,-3.36,5.36>, <3.04,-3.2,5.2>, <3.04,-1.04,6.72> }
		triangle { <3.04,-1.04,6.72>, <2,-1.04,6.94>, <2,-3.36,5.36> }
		triangle { <3.04,-3.2,5.2>, <3.04,-1.04,6.72>, <5.2,-1.04,5.2> }
		triangle { <5.68,2,5.68>, <5.2,-1.04,5.2>, <3.04,-1.04,6.72> }
		triangle { <3.04,-1.04,6.72>, <3.04,2,7.36>, <5.68,2,5.68> }
		triangle { <2,-1.04,6.94>, <3.04,-1.04,6.72>, <3.04,2,7.36> }
		triangle { <3.04,2,7.36>, <2,2,7.58>, <2,-1.04,6.94> }
		triangle { <0,8,8>, <-3.062,8,7.391>, <-2.296,8,5.543> }
		triangle { <-2.296,8,5.543>, <0,8,6>, <0,8,8> }
		triangle { <-3.062,8,7.391>, <-5.657,8,5.657>, <-4.243,8,4.243> }
		triangle { <-4.243,8,4.243>, <-2.296,8,5.543>, <-3.062,8,7.391> }
		triangle { <-5.657,8,5.657>, <-7.391,8,3.062>, <-5.543,8,2.296> }
		triangle { <-5.543,8,2.296>, <-4.243,8,4.243>, <-5.657,8,5.657> }
		triangle { <-7.391,8,3.062>, <-8,8,0>, <-6,8,0> }
		triangle { <-6,8,0>, <-5.543,8,2.296>, <-7.391,8,3.062> }
	}
	object { _1_dash_4cyli_dot_dat matrix <-8,0,0,0,6,0,0,0,8,0,2,0> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,6,0,0,0,6,0,2,0> }
	mesh {
		triangle { <0,0,7.58>, <-2,0,7.16>, <-2,0,5> }
		triangle { <-2,0,5>, <0,0,5>, <0,0,7.58> }
		triangle { <0,0,5>, <-2,0,5>, <-2,2,5> }
		triangle { <-2,2,5>, <0,2,5>, <0,0,5> }
		triangle { <-2,2,7.58>, <-2,-1.04,6.94>, <-2,2,0> }
		triangle { <-2,-1.04,6.94>, <-2,-3.36,5.36>, <-2,2,0> }
		triangle { <-2,-3.36,5.36>, <-2,-4.94,3.04>, <-2,2,0> }
		triangle { <-2,-4.94,3.04>, <-2,-5.58,0>, <-2,2,0> }
		triangle { <0,2,8>, <-2,2,7.58>, <-2,0,7.16> }
		triangle { <-2,0,7.16>, <0,0,7.58>, <0,2,8> }
		triangle { <-2,-5.58,0>, <-3.04,-5.36,0>, <-3.04,-4.72,3.04> }
		triangle { <-3.04,-4.72,3.04>, <-2,-4.94,3.04>, <-2,-5.58,0> }
		triangle { <-3.04,-5.36,0>, <-5.68,-3.68,0>, <-5.2,-3.2,3.04> }
		triangle { <-5.2,-3.2,3.04>, <-3.04,-4.72,3.04>, <-3.04,-5.36,0> }
		triangle { <-5.68,-3.68,0>, <-7.36,-1.04,0>, <-6.72,-1.04,3.04> }
		triangle { <-6.72,-1.04,3.04>, <-5.2,-3.2,3.04>, <-5.68,-3.68,0> }
		triangle { <-7.36,-1.04,0>, <-8,2,0>, <-7.36,2,3.04> }
		triangle { <-7.36,2,3.04>, <-6.72,-1.04,3.04>, <-7.36,-1.04,0> }
		triangle { <-2,-4.94,3.04>, <-3.04,-4.72,3.04>, <-3.04,-3.2,5.2> }
		triangle { <-3.04,-3.2,5.2>, <-2,-3.36,5.36>, <-2,-4.94,3.04> }
		triangle { <-3.04,-4.72,3.04>, <-3.04,-3.2,5.2>, <-5.2,-3.2,3.04> }
		triangle { <-5.2,-3.2,3.04>, <-3.04,-3.2,5.2>, <-5.2,-1.04,5.2> }
		triangle { <-5.2,-3.2,3.04>, <-5.2,-1.04,5.2>, <-6.72,-1.04,3.04> }
		triangle { <-7.36,2,3.04>, <-6.72,-1.04,3.04>, <-5.2,-1.04,5.2> }
		triangle { <-5.2,-1.04,5.2>, <-5.68,2,5.68>, <-7.36,2,3.04> }
		triangle { <-2,-3.36,5.36>, <-3.04,-3.2,5.2>, <-3.04,-1.04,6.72> }
		triangle { <-3.04,-1.04,6.72>, <-2,-1.04,6.94>, <-2,-3.36,5.36> }
		triangle { <-3.04,-3.2,5.2>, <-3.04,-1.04,6.72>, <-5.2,-1.04,5.2> }
		triangle { <-5.68,2,5.68>, <-5.2,-1.04,5.2>, <-3.04,-1.04,6.72> }
		triangle { <-3.04,-1.04,6.72>, <-3.04,2,7.36>, <-5.68,2,5.68> }
		triangle { <-2,-1.04,6.94>, <-3.04,-1.04,6.72>, <-3.04,2,7.36> }
		triangle { <-3.04,2,7.36>, <-2,2,7.58>, <-2,-1.04,6.94> }
// 
	}
}
#end

#declare _4593_dot_dat = #if (QUAL = 0) box { <-4,-38,-4>, <4,4,4> } #else union {
// Lever Small
	object { _4_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,2,0,0> }
	object { _4_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,-2,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <0,4,0,-4,0,0,0,0,4,2,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <2,0,0,0,-26,0,0,0,2,0,-4,0> }
	object { _8_dash_8sphe_dot_dat matrix <4,0,0,0,4,0,0,0,4,0,-34,0> }
}
#end

#declare _3961_dot_dat = #if (QUAL = 0) box { <-80,-4,-80>, <80,24,80> } #else union {
// Space Radar Dish  8 x  8
	mesh {
		triangle { <16,4,10>, <16,4,-10>, <16,8,-10> }
		triangle { <16,8,-10>, <16,8,10>, <16,4,10> }
		triangle { <-16,4,10>, <-16,4,-10>, <-16,8,-10> }
		triangle { <-16,8,-10>, <-16,8,10>, <-16,4,10> }
		triangle { <10,4,16>, <-10,4,16>, <-10,8,16> }
		triangle { <-10,8,16>, <10,8,16>, <10,4,16> }
		triangle { <10,4,-16>, <-10,4,-16>, <-10,8,-16> }
		triangle { <-10,8,-16>, <10,8,-16>, <10,4,-16> }
	}
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,10,4,10> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,4,0,0,0,6,-10,4,10> }
	object { _1_dash_4cyli_dot_dat matrix <-6,0,0,0,4,0,0,0,-6,-10,4,-10> }
	object { _1_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,-6,10,4,-10> }
	object { _1_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,6,10,4,10> }
	object { _1_dash_4disc_dot_dat matrix <-6,0,0,0,1,0,0,0,6,-10,4,10> }
	object { _1_dash_4disc_dot_dat matrix <-6,0,0,0,1,0,0,0,-6,-10,4,-10> }
	object { _1_dash_4disc_dot_dat matrix <6,0,0,0,1,0,0,0,-6,10,4,-10> }
	mesh {
		triangle { <23,8,0>, <22.651,8,3.994>, <16,8,3.994> }
		triangle { <16,8,3.994>, <16,8,0>, <23,8,0> }
		triangle { <22.651,8,3.994>, <21.613,8,7.866>, <16,8,7.866> }
		triangle { <16,8,7.866>, <16,8,3.994>, <22.651,8,3.994> }
		triangle { <21.613,8,7.866>, <19.919,8,11.5>, <16,8,10> }
		triangle { <16,8,10>, <16,8,7.866>, <21.613,8,7.866> }
		triangle { <19.919,8,11.5>, <17.619,8,14.784>, <15.196,8,13> }
		triangle { <15.196,8,13>, <16,8,10>, <19.919,8,11.5> }
		triangle { <17.619,8,14.784>, <14.784,8,17.619>, <13,8,15.196> }
		triangle { <13,8,15.196>, <15.196,8,13>, <17.619,8,14.784> }
		triangle { <14.784,8,17.619>, <11.5,8,19.919>, <10,8,16> }
		triangle { <10,8,16>, <13,8,15.196>, <14.784,8,17.619> }
		triangle { <11.5,8,19.919>, <7.866,8,21.613>, <7.866,8,16> }
		triangle { <7.866,8,16>, <10,8,16>, <11.5,8,19.919> }
		triangle { <7.866,8,21.613>, <3.994,8,22.651>, <3.994,8,16> }
		triangle { <3.994,8,16>, <7.866,8,16>, <7.866,8,21.613> }
		triangle { <3.994,8,22.651>, <0,8,23>, <0,8,16> }
		triangle { <0,8,16>, <3.994,8,16>, <3.994,8,22.651> }
		triangle { <-23,8,0>, <-22.651,8,3.994>, <-16,8,3.994> }
		triangle { <-16,8,3.994>, <-16,8,0>, <-23,8,0> }
		triangle { <-22.651,8,3.994>, <-21.613,8,7.866>, <-16,8,7.866> }
		triangle { <-16,8,7.866>, <-16,8,3.994>, <-22.651,8,3.994> }
		triangle { <-21.613,8,7.866>, <-19.919,8,11.5>, <-16,8,10> }
		triangle { <-16,8,10>, <-16,8,7.866>, <-21.613,8,7.866> }
		triangle { <-19.919,8,11.5>, <-17.619,8,14.784>, <-15.196,8,13> }
		triangle { <-15.196,8,13>, <-16,8,10>, <-19.919,8,11.5> }
		triangle { <-17.619,8,14.784>, <-14.784,8,17.619>, <-13,8,15.196> }
		triangle { <-13,8,15.196>, <-15.196,8,13>, <-17.619,8,14.784> }
		triangle { <-14.784,8,17.619>, <-11.5,8,19.919>, <-10,8,16> }
		triangle { <-10,8,16>, <-13,8,15.196>, <-14.784,8,17.619> }
		triangle { <-11.5,8,19.919>, <-7.866,8,21.613>, <-7.866,8,16> }
		triangle { <-7.866,8,16>, <-10,8,16>, <-11.5,8,19.919> }
		triangle { <-7.866,8,21.613>, <-3.994,8,22.651>, <-3.994,8,16> }
		triangle { <-3.994,8,16>, <-7.866,8,16>, <-7.866,8,21.613> }
		triangle { <-3.994,8,22.651>, <0,8,23>, <0,8,16> }
		triangle { <0,8,16>, <-3.994,8,16>, <-3.994,8,22.651> }
		triangle { <-23,8,0>, <-22.651,8,-3.994>, <-16,8,-3.994> }
		triangle { <-16,8,-3.994>, <-16,8,0>, <-23,8,0> }
		triangle { <-22.651,8,-3.994>, <-21.613,8,-7.866>, <-16,8,-7.866> }
		triangle { <-16,8,-7.866>, <-16,8,-3.994>, <-22.651,8,-3.994> }
		triangle { <-21.613,8,-7.866>, <-19.919,8,-11.5>, <-16,8,-10> }
		triangle { <-16,8,-10>, <-16,8,-7.866>, <-21.613,8,-7.866> }
		triangle { <-19.919,8,-11.5>, <-17.619,8,-14.784>, <-15.196,8,-13> }
		triangle { <-15.196,8,-13>, <-16,8,-10>, <-19.919,8,-11.5> }
		triangle { <-17.619,8,-14.784>, <-14.784,8,-17.619>, <-13,8,-15.196> }
		triangle { <-13,8,-15.196>, <-15.196,8,-13>, <-17.619,8,-14.784> }
		triangle { <-14.784,8,-17.619>, <-11.5,8,-19.919>, <-10,8,-16> }
		triangle { <-10,8,-16>, <-13,8,-15.196>, <-14.784,8,-17.619> }
		triangle { <-11.5,8,-19.919>, <-7.866,8,-21.613>, <-7.866,8,-16> }
		triangle { <-7.866,8,-16>, <-10,8,-16>, <-11.5,8,-19.919> }
		triangle { <-7.866,8,-21.613>, <-3.994,8,-22.651>, <-3.994,8,-16> }
		triangle { <-3.994,8,-16>, <-7.866,8,-16>, <-7.866,8,-21.613> }
		triangle { <-3.994,8,-22.651>, <0,8,-23>, <0,8,-16> }
		triangle { <0,8,-16>, <-3.994,8,-16>, <-3.994,8,-22.651> }
		triangle { <23,8,0>, <22.651,8,-3.994>, <16,8,-3.994> }
		triangle { <16,8,-3.994>, <16,8,0>, <23,8,0> }
		triangle { <22.651,8,-3.994>, <21.613,8,-7.866>, <16,8,-7.866> }
		triangle { <16,8,-7.866>, <16,8,-3.994>, <22.651,8,-3.994> }
		triangle { <21.613,8,-7.866>, <19.919,8,-11.5>, <16,8,-10> }
		triangle { <16,8,-10>, <16,8,-7.866>, <21.613,8,-7.866> }
		triangle { <19.919,8,-11.5>, <17.619,8,-14.784>, <15.196,8,-13> }
		triangle { <15.196,8,-13>, <16,8,-10>, <19.919,8,-11.5> }
		triangle { <17.619,8,-14.784>, <14.784,8,-17.619>, <13,8,-15.196> }
		triangle { <13,8,-15.196>, <15.196,8,-13>, <17.619,8,-14.784> }
		triangle { <14.784,8,-17.619>, <11.5,8,-19.919>, <10,8,-16> }
		triangle { <10,8,-16>, <13,8,-15.196>, <14.784,8,-17.619> }
		triangle { <11.5,8,-19.919>, <7.866,8,-21.613>, <7.866,8,-16> }
		triangle { <7.866,8,-16>, <10,8,-16>, <11.5,8,-19.919> }
		triangle { <7.866,8,-21.613>, <3.994,8,-22.651>, <3.994,8,-16> }
		triangle { <3.994,8,-16>, <7.866,8,-16>, <7.866,8,-21.613> }
		triangle { <3.994,8,-22.651>, <0,8,-23>, <0,8,-16> }
		triangle { <0,8,-16>, <3.994,8,-16>, <3.994,8,-22.651> }
	}
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,1,0,0,0,8,0,4,0> }
	mesh {
		triangle { <10,4,16>, <-10,4,16>, <-10,4,8> }
		triangle { <-10,4,8>, <10,4,8>, <10,4,16> }
		triangle { <10,4,-16>, <-10,4,-16>, <-10,4,-8> }
		triangle { <-10,4,-8>, <10,4,-8>, <10,4,-16> }
		triangle { <16,4,10>, <16,4,-10>, <8,4,-10> }
		triangle { <8,4,-10>, <8,4,10>, <16,4,10> }
		triangle { <-16,4,10>, <-16,4,-10>, <-8,4,-10> }
		triangle { <-8,4,-10>, <-8,4,10>, <-16,4,10> }
		triangle { <0,0,20>, <3.473,0,19.696>, <0,0,6> }
		triangle { <3.473,0,19.696>, <6.84,0,18.794>, <3,0,5.196> }
		triangle { <3,0,5.196>, <0,0,6>, <3.473,0,19.696> }
		triangle { <6.84,0,18.794>, <10,0,17.32>, <3,0,5.196> }
		triangle { <10,0,17.32>, <12.856,0,15.321>, <3,0,5.196> }
		triangle { <12.856,0,15.321>, <15.321,0,12.856>, <5.196,0,3> }
		triangle { <5.196,0,3>, <3,0,5.196>, <12.856,0,15.321> }
		triangle { <15.321,0,12.865>, <17.32,0,10>, <5.196,0,3> }
		triangle { <17.32,0,10>, <18.794,0,6.84>, <5.196,0,3> }
		triangle { <18.794,0,6.84>, <19.696,0,3.473>, <6,0,0> }
		triangle { <6,0,0>, <5.196,0,3>, <18.794,0,6.84> }
		triangle { <19.696,0,3.473>, <20,0,0>, <6,0,0> }
		triangle { <0,0,20>, <-3.473,0,19.696>, <0,0,6> }
		triangle { <-3.473,0,19.696>, <-6.84,0,18.794>, <-3,0,5.196> }
		triangle { <-3,0,5.196>, <0,0,6>, <-3.473,0,19.696> }
		triangle { <-6.84,0,18.794>, <-10,0,17.32>, <-3,0,5.196> }
		triangle { <-10,0,17.32>, <-12.856,0,15.321>, <-3,0,5.196> }
		triangle { <-12.856,0,15.321>, <-15.321,0,12.856>, <-5.196,0,3> }
		triangle { <-5.196,0,3>, <-3,0,5.196>, <-12.856,0,15.321> }
		triangle { <-15.321,0,12.865>, <-17.32,0,10>, <-5.196,0,3> }
		triangle { <-17.32,0,10>, <-18.794,0,6.84>, <-5.196,0,3> }
		triangle { <-18.794,0,6.84>, <-19.696,0,3.473>, <-6,0,0> }
		triangle { <-6,0,0>, <-5.196,0,3>, <-18.794,0,6.84> }
		triangle { <-19.696,0,3.473>, <-20,0,0>, <-6,0,0> }
		triangle { <0,0,-20>, <-3.473,0,-19.696>, <0,0,-6> }
		triangle { <-3.473,0,-19.696>, <-6.84,0,-18.794>, <-3,0,-5.196> }
		triangle { <-3,0,-5.196>, <0,0,-6>, <-3.473,0,-19.696> }
		triangle { <-6.84,0,-18.794>, <-10,0,-17.32>, <-3,0,-5.196> }
		triangle { <-10,0,-17.32>, <-12.856,0,-15.321>, <-3,0,-5.196> }
		triangle { <-12.856,0,-15.321>, <-15.321,0,-12.856>, <-5.196,0,-3> }
		triangle { <-5.196,0,-3>, <-3,0,-5.196>, <-12.856,0,-15.321> }
		triangle { <-15.321,0,-12.865>, <-17.32,0,-10>, <-5.196,0,-3> }
		triangle { <-17.32,0,-10>, <-18.794,0,-6.84>, <-5.196,0,-3> }
		triangle { <-18.794,0,-6.84>, <-19.696,0,-3.473>, <-6,0,0> }
		triangle { <-6,0,0>, <-5.196,0,-3>, <-18.794,0,-6.84> }
		triangle { <-19.696,0,-3.473>, <-20,0,0>, <-6,0,0> }
		triangle { <0,0,-20>, <3.473,0,-19.696>, <0,0,-6> }
		triangle { <3.473,0,-19.696>, <6.84,0,-18.794>, <3,0,-5.196> }
		triangle { <3,0,-5.196>, <0,0,-6>, <3.473,0,-19.696> }
		triangle { <6.84,0,-18.794>, <10,0,-17.32>, <3,0,-5.196> }
		triangle { <10,0,-17.32>, <12.856,0,-15.321>, <3,0,-5.196> }
		triangle { <12.856,0,-15.321>, <15.321,0,-12.856>, <5.196,0,-3> }
		triangle { <5.196,0,-3>, <3,0,-5.196>, <12.856,0,-15.321> }
		triangle { <15.321,0,-12.865>, <17.32,0,-10>, <5.196,0,-3> }
		triangle { <17.32,0,-10>, <18.794,0,-6.84>, <5.196,0,-3> }
		triangle { <18.794,0,-6.84>, <19.696,0,-3.473>, <6,0,0> }
		triangle { <6,0,0>, <5.196,0,-3>, <18.794,0,-6.84> }
		triangle { <19.696,0,-3.473>, <20,0,0>, <6,0,0> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,4,0,0,0,6,0,0,0> }
	mesh {
		triangle { <0,24,76.5>, <13.284,24,75.338>, <13.892,24,78.785> }
		triangle { <13.892,24,78.785>, <0,24,80>, <0,24,76.5> }
		triangle { <13.284,24,75.338>, <26.265,24,71.886>, <27.362,24,75.175> }
		triangle { <27.362,24,75.175>, <13.892,24,78.785>, <13.284,24,75.338> }
		triangle { <26.265,24,71.886>, <38.25,24,66.251>, <40,24,69.282> }
		triangle { <40,24,69.282>, <27.362,24,75.175>, <26.265,24,71.886> }
		triangle { <38.25,24,66.251>, <49.173,24,58.602>, <51.423,24,61.284> }
		triangle { <51.423,24,61.284>, <40,24,69.282>, <38.25,24,66.251> }
		triangle { <49.173,24,58.602>, <58.602,24,49.173>, <61.284,24,51.423> }
		triangle { <61.284,24,51.423>, <51.423,24,61.284>, <49.173,24,58.602> }
		triangle { <58.602,24,49.173>, <66.251,24,38.25>, <69.282,24,40> }
		triangle { <69.282,24,40>, <61.284,24,51.423>, <58.602,24,49.173> }
		triangle { <66.251,24,38.25>, <71.886,24,26.265>, <75.175,24,27.362> }
		triangle { <75.175,24,27.362>, <69.282,24,40>, <66.251,24,38.25> }
		triangle { <71.886,24,26.265>, <75.338,24,13.284>, <78.785,24,13.892> }
		triangle { <78.785,24,13.892>, <75.175,24,27.362>, <71.886,24,26.265> }
		triangle { <75.338,24,13.284>, <76.5,24,0>, <80,24,0> }
		triangle { <80,24,0>, <78.785,24,13.892>, <75.338,24,13.284> }
		triangle { <0,24,76.5>, <-13.284,24,75.338>, <-13.892,24,78.785> }
		triangle { <-13.892,24,78.785>, <0,24,80>, <0,24,76.5> }
		triangle { <-13.284,24,75.338>, <-26.265,24,71.886>, <-27.362,24,75.175> }
		triangle { <-27.362,24,75.175>, <-13.892,24,78.785>, <-13.284,24,75.338> }
		triangle { <-26.265,24,71.886>, <-38.25,24,66.251>, <-40,24,69.282> }
		triangle { <-40,24,69.282>, <-27.362,24,75.175>, <-26.265,24,71.886> }
		triangle { <-38.25,24,66.251>, <-49.173,24,58.602>, <-51.423,24,61.284> }
		triangle { <-51.423,24,61.284>, <-40,24,69.282>, <-38.25,24,66.251> }
		triangle { <-49.173,24,58.602>, <-58.602,24,49.173>, <-61.284,24,51.423> }
		triangle { <-61.284,24,51.423>, <-51.423,24,61.284>, <-49.173,24,58.602> }
		triangle { <-58.602,24,49.173>, <-66.251,24,38.25>, <-69.282,24,40> }
		triangle { <-69.282,24,40>, <-61.284,24,51.423>, <-58.602,24,49.173> }
		triangle { <-66.251,24,38.25>, <-71.886,24,26.265>, <-75.175,24,27.362> }
		triangle { <-75.175,24,27.362>, <-69.282,24,40>, <-66.251,24,38.25> }
		triangle { <-71.886,24,26.265>, <-75.338,24,13.284>, <-78.785,24,13.892> }
		triangle { <-78.785,24,13.892>, <-75.175,24,27.362>, <-71.886,24,26.265> }
		triangle { <-75.338,24,13.284>, <-76.5,24,0>, <-80,24,0> }
		triangle { <-80,24,0>, <-78.785,24,13.892>, <-75.338,24,13.284> }
		triangle { <0,24,-76.5>, <-13.284,24,-75.338>, <-13.892,24,-78.785> }
		triangle { <-13.892,24,-78.785>, <0,24,-80>, <0,24,-76.5> }
		triangle { <-13.284,24,-75.338>, <-26.265,24,-71.886>, <-27.362,24,-75.175> }
		triangle { <-27.362,24,-75.175>, <-13.892,24,-78.785>, <-13.284,24,-75.338> }
		triangle { <-26.265,24,-71.886>, <-38.25,24,-66.251>, <-40,24,-69.282> }
		triangle { <-40,24,-69.282>, <-27.362,24,-75.175>, <-26.265,24,-71.886> }
		triangle { <-38.25,24,-66.251>, <-49.173,24,-58.602>, <-51.423,24,-61.284> }
		triangle { <-51.423,24,-61.284>, <-40,24,-69.282>, <-38.25,24,-66.251> }
		triangle { <-49.173,24,-58.602>, <-58.602,24,-49.173>, <-61.284,24,-51.423> }
		triangle { <-61.284,24,-51.423>, <-51.423,24,-61.284>, <-49.173,24,-58.602> }
		triangle { <-58.602,24,-49.173>, <-66.251,24,-38.25>, <-69.282,24,-40> }
		triangle { <-69.282,24,-40>, <-61.284,24,-51.423>, <-58.602,24,-49.173> }
		triangle { <-66.251,24,-38.25>, <-71.886,24,-26.265>, <-75.175,24,-27.362> }
		triangle { <-75.175,24,-27.362>, <-69.282,24,-40>, <-66.251,24,-38.25> }
		triangle { <-71.886,24,-26.265>, <-75.338,24,-13.284>, <-78.785,24,-13.892> }
		triangle { <-78.785,24,-13.892>, <-75.175,24,-27.362>, <-71.886,24,-26.265> }
		triangle { <-75.338,24,-13.284>, <-76.5,24,0>, <-80,24,0> }
		triangle { <-80,24,0>, <-78.785,24,-13.892>, <-75.338,24,-13.284> }
		triangle { <0,24,-76.5>, <13.284,24,-75.338>, <13.892,24,-78.785> }
		triangle { <13.892,24,-78.785>, <0,24,-80>, <0,24,-76.5> }
		triangle { <13.284,24,-75.338>, <26.265,24,-71.886>, <27.362,24,-75.175> }
		triangle { <27.362,24,-75.175>, <13.892,24,-78.785>, <13.284,24,-75.338> }
		triangle { <26.265,24,-71.886>, <38.25,24,-66.251>, <40,24,-69.282> }
		triangle { <40,24,-69.282>, <27.362,24,-75.175>, <26.265,24,-71.886> }
		triangle { <38.25,24,-66.251>, <49.173,24,-58.602>, <51.423,24,-61.284> }
		triangle { <51.423,24,-61.284>, <40,24,-69.282>, <38.25,24,-66.251> }
		triangle { <49.173,24,-58.602>, <58.602,24,-49.173>, <61.284,24,-51.423> }
		triangle { <61.284,24,-51.423>, <51.423,24,-61.284>, <49.173,24,-58.602> }
		triangle { <58.602,24,-49.173>, <66.251,24,-38.25>, <69.282,24,-40> }
		triangle { <69.282,24,-40>, <61.284,24,-51.423>, <58.602,24,-49.173> }
		triangle { <66.251,24,-38.25>, <71.886,24,-26.265>, <75.175,24,-27.362> }
		triangle { <75.175,24,-27.362>, <69.282,24,-40>, <66.251,24,-38.25> }
		triangle { <71.886,24,-26.265>, <75.338,24,-13.284>, <78.785,24,-13.892> }
		triangle { <78.785,24,-13.892>, <75.175,24,-27.362>, <71.886,24,-26.265> }
		triangle { <75.338,24,-13.284>, <76.5,24,0>, <80,24,0> }
		triangle { <80,24,0>, <78.785,24,-13.892>, <75.338,24,-13.284> }
		triangle { <0,24,76.5>, <0,20,76.5>, <13.284,20,75.338> }
		triangle { <13.284,20,75.338>, <13.284,24,75.338>, <0,24,76.5> }
		triangle { <13.284,24,75.338>, <13.284,20,75.338>, <26.265,20,71.886> }
		triangle { <26.265,20,71.886>, <26.265,24,71.886>, <13.284,24,75.338> }
		triangle { <26.265,24,71.886>, <26.265,20,71.886>, <38.25,20,66.251> }
		triangle { <38.25,20,66.251>, <38.25,24,66.251>, <26.265,24,71.886> }
		triangle { <38.25,24,66.251>, <38.25,20,66.251>, <49.173,20,58.602> }
		triangle { <49.173,20,58.602>, <49.173,24,58.602>, <38.25,24,66.251> }
		triangle { <49.173,24,58.602>, <49.173,20,58.602>, <58.602,20,49.173> }
		triangle { <58.602,20,49.173>, <58.602,24,49.173>, <49.173,24,58.602> }
		triangle { <58.602,24,49.173>, <58.602,20,49.173>, <66.251,20,38.25> }
		triangle { <66.251,20,38.25>, <66.251,24,38.25>, <58.602,24,49.173> }
		triangle { <66.251,24,38.25>, <66.251,20,38.25>, <71.886,20,26.265> }
		triangle { <71.886,20,26.265>, <71.886,24,26.265>, <66.251,24,38.25> }
		triangle { <71.886,24,26.265>, <71.886,20,26.265>, <75.338,20,13.284> }
		triangle { <75.338,20,13.284>, <75.338,24,13.284>, <71.886,24,26.265> }
		triangle { <75.338,24,13.284>, <75.338,20,13.284>, <76.5,20,0> }
		triangle { <76.5,20,0>, <76.5,24,0>, <75.338,24,13.284> }
		triangle { <0,24,76.5>, <0,20,76.5>, <-13.284,20,75.338> }
		triangle { <-13.284,20,75.338>, <-13.284,24,75.338>, <0,24,76.5> }
		triangle { <-13.284,24,75.338>, <-13.284,20,75.338>, <-26.265,20,71.886> }
		triangle { <-26.265,20,71.886>, <-26.265,24,71.886>, <-13.284,24,75.338> }
		triangle { <-26.265,24,71.886>, <-26.265,20,71.886>, <-38.25,20,66.251> }
		triangle { <-38.25,20,66.251>, <-38.25,24,66.251>, <-26.265,24,71.886> }
		triangle { <-38.25,24,66.251>, <-38.25,20,66.251>, <-49.173,20,58.602> }
		triangle { <-49.173,20,58.602>, <-49.173,24,58.602>, <-38.25,24,66.251> }
		triangle { <-49.173,24,58.602>, <-49.173,20,58.602>, <-58.602,20,49.173> }
		triangle { <-58.602,20,49.173>, <-58.602,24,49.173>, <-49.173,24,58.602> }
		triangle { <-58.602,24,49.173>, <-58.602,20,49.173>, <-66.251,20,38.25> }
		triangle { <-66.251,20,38.25>, <-66.251,24,38.25>, <-58.602,24,49.173> }
		triangle { <-66.251,24,38.25>, <-66.251,20,38.25>, <-71.886,20,26.265> }
		triangle { <-71.886,20,26.265>, <-71.886,24,26.265>, <-66.251,24,38.25> }
		triangle { <-71.886,24,26.265>, <-71.886,20,26.265>, <-75.338,20,13.284> }
		triangle { <-75.338,20,13.284>, <-75.338,24,13.284>, <-71.886,24,26.265> }
		triangle { <-75.338,24,13.284>, <-75.338,20,13.284>, <-76.5,20,0> }
		triangle { <-76.5,20,0>, <-76.5,24,0>, <-75.338,24,13.284> }
		triangle { <0,24,-76.5>, <0,20,-76.5>, <-13.284,20,-75.338> }
		triangle { <-13.284,20,-75.338>, <-13.284,24,-75.338>, <0,24,-76.5> }
		triangle { <-13.284,24,-75.338>, <-13.284,20,-75.338>, <-26.265,20,-71.886> }
		triangle { <-26.265,20,-71.886>, <-26.265,24,-71.886>, <-13.284,24,-75.338> }
		triangle { <-26.265,24,-71.886>, <-26.265,20,-71.886>, <-38.25,20,-66.251> }
		triangle { <-38.25,20,-66.251>, <-38.25,24,-66.251>, <-26.265,24,-71.886> }
		triangle { <-38.25,24,-66.251>, <-38.25,20,-66.251>, <-49.173,20,-58.602> }
		triangle { <-49.173,20,-58.602>, <-49.173,24,-58.602>, <-38.25,24,-66.251> }
		triangle { <-49.173,24,-58.602>, <-49.173,20,-58.602>, <-58.602,20,-49.173> }
		triangle { <-58.602,20,-49.173>, <-58.602,24,-49.173>, <-49.173,24,-58.602> }
		triangle { <-58.602,24,-49.173>, <-58.602,20,-49.173>, <-66.251,20,-38.25> }
		triangle { <-66.251,20,-38.25>, <-66.251,24,-38.25>, <-58.602,24,-49.173> }
		triangle { <-66.251,24,-38.25>, <-66.251,20,-38.25>, <-71.886,20,-26.265> }
		triangle { <-71.886,20,-26.265>, <-71.886,24,-26.265>, <-66.251,24,-38.25> }
		triangle { <-71.886,24,-26.265>, <-71.886,20,-26.265>, <-75.338,20,-13.284> }
		triangle { <-75.338,20,-13.284>, <-75.338,24,-13.284>, <-71.886,24,-26.265> }
		triangle { <-75.338,24,-13.284>, <-75.338,20,-13.284>, <-76.5,20,0> }
		triangle { <-76.5,20,0>, <-76.5,24,0>, <-75.338,24,-13.284> }
		triangle { <0,24,-76.5>, <0,20,-76.5>, <13.284,20,-75.338> }
		triangle { <13.284,20,-75.338>, <13.284,24,-75.338>, <0,24,-76.5> }
		triangle { <13.284,24,-75.338>, <13.284,20,-75.338>, <26.265,20,-71.886> }
		triangle { <26.265,20,-71.886>, <26.265,24,-71.886>, <13.284,24,-75.338> }
		triangle { <26.265,24,-71.886>, <26.265,20,-71.886>, <38.25,20,-66.251> }
		triangle { <38.25,20,-66.251>, <38.25,24,-66.251>, <26.265,24,-71.886> }
		triangle { <38.25,24,-66.251>, <38.25,20,-66.251>, <49.173,20,-58.602> }
		triangle { <49.173,20,-58.602>, <49.173,24,-58.602>, <38.25,24,-66.251> }
		triangle { <49.173,24,-58.602>, <49.173,20,-58.602>, <58.602,20,-49.173> }
		triangle { <58.602,20,-49.173>, <58.602,24,-49.173>, <49.173,24,-58.602> }
		triangle { <58.602,24,-49.173>, <58.602,20,-49.173>, <66.251,20,-38.25> }
		triangle { <66.251,20,-38.25>, <66.251,24,-38.25>, <58.602,24,-49.173> }
		triangle { <66.251,24,-38.25>, <66.251,20,-38.25>, <71.886,20,-26.265> }
		triangle { <71.886,20,-26.265>, <71.886,24,-26.265>, <66.251,24,-38.25> }
		triangle { <71.886,24,-26.265>, <71.886,20,-26.265>, <75.338,20,-13.284> }
		triangle { <75.338,20,-13.284>, <75.338,24,-13.284>, <71.886,24,-26.265> }
		triangle { <75.338,24,-13.284>, <75.338,20,-13.284>, <76.5,20,0> }
		triangle { <76.5,20,0>, <76.5,24,0>, <75.338,24,-13.284> }
		triangle { <0,4,23>, <0,8,23>, <3.994,8,22.651> }
		triangle { <3.994,8,22.651>, <3.994,4,22.651>, <0,4,23> }
		triangle { <3.994,4,22.651>, <3.994,8,22.651>, <7.866,8,21.613> }
		triangle { <7.866,8,21.613>, <7.866,4,21.613>, <3.994,4,22.651> }
		triangle { <7.866,4,21.613>, <7.866,8,21.613>, <11.5,8,19.919> }
		triangle { <11.5,8,19.919>, <11.5,4,19.919>, <7.866,4,21.613> }
		triangle { <11.5,4,19.919>, <11.5,8,19.919>, <14.784,8,17.619> }
		triangle { <14.784,8,17.619>, <14.784,4,17.619>, <11.5,4,19.919> }
		triangle { <14.784,4,17.619>, <14.784,8,17.619>, <17.619,8,14.784> }
		triangle { <17.619,8,14.784>, <17.619,4,14.784>, <14.784,4,17.619> }
		triangle { <17.619,4,14.784>, <17.619,8,14.784>, <19.919,8,11.5> }
		triangle { <19.919,8,11.5>, <19.919,4,11.5>, <17.619,4,14.784> }
		triangle { <19.919,4,11.5>, <19.919,8,11.5>, <21.613,8,7.866> }
		triangle { <21.613,8,7.866>, <21.613,4,7.866>, <19.919,4,11.5> }
		triangle { <21.613,4,7.866>, <21.613,8,7.866>, <22.651,8,3.994> }
		triangle { <22.651,8,3.994>, <22.651,4,3.994>, <21.613,4,7.866> }
		triangle { <22.651,4,3.994>, <22.651,8,3.994>, <23,8,0> }
		triangle { <23,8,0>, <23,4,0>, <22.651,4,3.994> }
		triangle { <0,4,23>, <0,8,23>, <-3.994,8,22.651> }
		triangle { <-3.994,8,22.651>, <-3.994,4,22.651>, <0,4,23> }
		triangle { <-3.994,4,22.651>, <-3.994,8,22.651>, <-7.866,8,21.613> }
		triangle { <-7.866,8,21.613>, <-7.866,4,21.613>, <-3.994,4,22.651> }
		triangle { <-7.866,4,21.613>, <-7.866,8,21.613>, <-11.5,8,19.919> }
		triangle { <-11.5,8,19.919>, <-11.5,4,19.919>, <-7.866,4,21.613> }
		triangle { <-11.5,4,19.919>, <-11.5,8,19.919>, <-14.784,8,17.619> }
		triangle { <-14.784,8,17.619>, <-14.784,4,17.619>, <-11.5,4,19.919> }
		triangle { <-14.784,4,17.619>, <-14.784,8,17.619>, <-17.619,8,14.784> }
		triangle { <-17.619,8,14.784>, <-17.619,4,14.784>, <-14.784,4,17.619> }
		triangle { <-17.619,4,14.784>, <-17.619,8,14.784>, <-19.919,8,11.5> }
		triangle { <-19.919,8,11.5>, <-19.919,4,11.5>, <-17.619,4,14.784> }
		triangle { <-19.919,4,11.5>, <-19.919,8,11.5>, <-21.613,8,7.866> }
		triangle { <-21.613,8,7.866>, <-21.613,4,7.866>, <-19.919,4,11.5> }
		triangle { <-21.613,4,7.866>, <-21.613,8,7.866>, <-22.651,8,3.994> }
		triangle { <-22.651,8,3.994>, <-22.651,4,3.994>, <-21.613,4,7.866> }
		triangle { <-22.651,4,3.994>, <-22.651,8,3.994>, <-23,8,0> }
		triangle { <-23,8,0>, <-23,4,0>, <-22.651,4,3.994> }
		triangle { <0,4,-23>, <0,8,-23>, <-3.994,8,-22.651> }
		triangle { <-3.994,8,-22.651>, <-3.994,4,-22.651>, <0,4,-23> }
		triangle { <-3.994,4,-22.651>, <-3.994,8,-22.651>, <-7.866,8,-21.613> }
		triangle { <-7.866,8,-21.613>, <-7.866,4,-21.613>, <-3.994,4,-22.651> }
		triangle { <-7.866,4,-21.613>, <-7.866,8,-21.613>, <-11.5,8,-19.919> }
		triangle { <-11.5,8,-19.919>, <-11.5,4,-19.919>, <-7.866,4,-21.613> }
		triangle { <-11.5,4,-19.919>, <-11.5,8,-19.919>, <-14.784,8,-17.619> }
		triangle { <-14.784,8,-17.619>, <-14.784,4,-17.619>, <-11.5,4,-19.919> }
		triangle { <-14.784,4,-17.619>, <-14.784,8,-17.619>, <-17.619,8,-14.784> }
		triangle { <-17.619,8,-14.784>, <-17.619,4,-14.784>, <-14.784,4,-17.619> }
		triangle { <-17.619,4,-14.784>, <-17.619,8,-14.784>, <-19.919,8,-11.5> }
		triangle { <-19.919,8,-11.5>, <-19.919,4,-11.5>, <-17.619,4,-14.784> }
		triangle { <-19.919,4,-11.5>, <-19.919,8,-11.5>, <-21.613,8,-7.866> }
		triangle { <-21.613,8,-7.866>, <-21.613,4,-7.866>, <-19.919,4,-11.5> }
		triangle { <-21.613,4,-7.866>, <-21.613,8,-7.866>, <-22.651,8,-3.994> }
		triangle { <-22.651,8,-3.994>, <-22.651,4,-3.994>, <-21.613,4,-7.866> }
		triangle { <-22.651,4,-3.994>, <-22.651,8,-3.994>, <-23,8,0> }
		triangle { <-23,8,0>, <-23,4,0>, <-22.651,4,-3.994> }
		triangle { <0,4,-23>, <0,8,-23>, <3.994,8,-22.651> }
		triangle { <3.994,8,-22.651>, <3.994,4,-22.651>, <0,4,-23> }
		triangle { <3.994,4,-22.651>, <3.994,8,-22.651>, <7.866,8,-21.613> }
		triangle { <7.866,8,-21.613>, <7.866,4,-21.613>, <3.994,4,-22.651> }
		triangle { <7.866,4,-21.613>, <7.866,8,-21.613>, <11.5,8,-19.919> }
		triangle { <11.5,8,-19.919>, <11.5,4,-19.919>, <7.866,4,-21.613> }
		triangle { <11.5,4,-19.919>, <11.5,8,-19.919>, <14.784,8,-17.619> }
		triangle { <14.784,8,-17.619>, <14.784,4,-17.619>, <11.5,4,-19.919> }
		triangle { <14.784,4,-17.619>, <14.784,8,-17.619>, <17.619,8,-14.784> }
		triangle { <17.619,8,-14.784>, <17.619,4,-14.784>, <14.784,4,-17.619> }
		triangle { <17.619,4,-14.784>, <17.619,8,-14.784>, <19.919,8,-11.5> }
		triangle { <19.919,8,-11.5>, <19.919,4,-11.5>, <17.619,4,-14.784> }
		triangle { <19.919,4,-11.5>, <19.919,8,-11.5>, <21.613,8,-7.866> }
		triangle { <21.613,8,-7.866>, <21.613,4,-7.866>, <19.919,4,-11.5> }
		triangle { <21.613,4,-7.866>, <21.613,8,-7.866>, <22.651,8,-3.994> }
		triangle { <22.651,8,-3.994>, <22.651,4,-3.994>, <21.613,4,-7.866> }
		triangle { <22.651,4,-3.994>, <22.651,8,-3.994>, <23,8,0> }
		triangle { <23,8,0>, <23,4,0>, <22.651,4,-3.994> }
		triangle { <0,16,80>, <0,24,80>, <13.892,24,78.785> }
		triangle { <13.892,24,78.785>, <13.892,16,78.785>, <0,16,80> }
		triangle { <13.892,16,78.785>, <13.892,24,78.785>, <27.362,24,75.175> }
		triangle { <27.362,24,75.175>, <27.362,16,75.175>, <13.892,16,78.785> }
		triangle { <27.362,16,75.175>, <27.362,24,75.175>, <40,24,69.282> }
		triangle { <40,24,69.282>, <40,16,69.282>, <27.362,16,75.175> }
		triangle { <40,16,69.282>, <40,24,69.282>, <51.423,24,61.283> }
		triangle { <51.423,24,61.283>, <51.423,16,61.283>, <40,16,69.282> }
		triangle { <51.423,16,61.283>, <51.423,24,61.283>, <61.283,24,51.423> }
		triangle { <61.283,24,51.423>, <61.283,16,51.423>, <51.423,16,61.283> }
		triangle { <61.283,16,51.423>, <61.283,24,51.423>, <69.282,24,40> }
		triangle { <69.282,24,40>, <69.282,16,40>, <61.283,16,51.423> }
		triangle { <69.282,16,40>, <69.282,24,40>, <75.175,24,27.362> }
		triangle { <75.175,24,27.362>, <75.175,16,27.362>, <69.282,16,40> }
		triangle { <75.175,16,27.362>, <75.175,24,27.362>, <78.785,24,13.892> }
		triangle { <78.785,24,13.892>, <78.785,16,13.892>, <75.175,16,27.362> }
		triangle { <78.785,16,13.892>, <78.785,24,13.892>, <80,24,0> }
		triangle { <80,24,0>, <80,16,0>, <78.785,16,13.892> }
		triangle { <0,16,80>, <0,24,80>, <-13.892,24,78.785> }
		triangle { <-13.892,24,78.785>, <-13.892,16,78.785>, <0,16,80> }
		triangle { <-13.892,16,78.785>, <-13.892,24,78.785>, <-27.362,24,75.175> }
		triangle { <-27.362,24,75.175>, <-27.362,16,75.175>, <-13.892,16,78.785> }
		triangle { <-27.362,16,75.175>, <-27.362,24,75.175>, <-40,24,69.282> }
		triangle { <-40,24,69.282>, <-40,16,69.282>, <-27.362,16,75.175> }
		triangle { <-40,16,69.282>, <-40,24,69.282>, <-51.423,24,61.283> }
		triangle { <-51.423,24,61.283>, <-51.423,16,61.283>, <-40,16,69.282> }
		triangle { <-51.423,16,61.283>, <-51.423,24,61.283>, <-61.283,24,51.423> }
		triangle { <-61.283,24,51.423>, <-61.283,16,51.423>, <-51.423,16,61.283> }
		triangle { <-61.283,16,51.423>, <-61.283,24,51.423>, <-69.282,24,40> }
		triangle { <-69.282,24,40>, <-69.282,16,40>, <-61.283,16,51.423> }
		triangle { <-69.282,16,40>, <-69.282,24,40>, <-75.175,24,27.362> }
		triangle { <-75.175,24,27.362>, <-75.175,16,27.362>, <-69.282,16,40> }
		triangle { <-75.175,16,27.362>, <-75.175,24,27.362>, <-78.785,24,13.892> }
		triangle { <-78.785,24,13.892>, <-78.785,16,13.892>, <-75.175,16,27.362> }
		triangle { <-78.785,16,13.892>, <-78.785,24,13.892>, <-80,24,0> }
		triangle { <-80,24,0>, <-80,16,0>, <-78.785,16,13.892> }
		triangle { <0,16,-80>, <0,24,-80>, <-13.892,24,-78.785> }
		triangle { <-13.892,24,-78.785>, <-13.892,16,-78.785>, <0,16,-80> }
		triangle { <-13.892,16,-78.785>, <-13.892,24,-78.785>, <-27.362,24,-75.175> }
		triangle { <-27.362,24,-75.175>, <-27.362,16,-75.175>, <-13.892,16,-78.785> }
		triangle { <-27.362,16,-75.175>, <-27.362,24,-75.175>, <-40,24,-69.282> }
		triangle { <-40,24,-69.282>, <-40,16,-69.282>, <-27.362,16,-75.175> }
		triangle { <-40,16,-69.282>, <-40,24,-69.282>, <-51.423,24,-61.283> }
		triangle { <-51.423,24,-61.283>, <-51.423,16,-61.283>, <-40,16,-69.282> }
		triangle { <-51.423,16,-61.283>, <-51.423,24,-61.283>, <-61.283,24,-51.423> }
		triangle { <-61.283,24,-51.423>, <-61.283,16,-51.423>, <-51.423,16,-61.283> }
		triangle { <-61.283,16,-51.423>, <-61.283,24,-51.423>, <-69.282,24,-40> }
		triangle { <-69.282,24,-40>, <-69.282,16,-40>, <-61.283,16,-51.423> }
		triangle { <-69.282,16,-40>, <-69.282,24,-40>, <-75.175,24,-27.362> }
		triangle { <-75.175,24,-27.362>, <-75.175,16,-27.362>, <-69.282,16,-40> }
		triangle { <-75.175,16,-27.362>, <-75.175,24,-27.362>, <-78.785,24,-13.892> }
		triangle { <-78.785,24,-13.892>, <-78.785,16,-13.892>, <-75.175,16,-27.362> }
		triangle { <-78.785,16,-13.892>, <-78.785,24,-13.892>, <-80,24,0> }
		triangle { <-80,24,0>, <-80,16,0>, <-78.785,16,-13.892> }
		triangle { <0,16,-80>, <0,24,-80>, <13.892,24,-78.785> }
		triangle { <13.892,24,-78.785>, <13.892,16,-78.785>, <0,16,-80> }
		triangle { <13.892,16,-78.785>, <13.892,24,-78.785>, <27.362,24,-75.175> }
		triangle { <27.362,24,-75.175>, <27.362,16,-75.175>, <13.892,16,-78.785> }
		triangle { <27.362,16,-75.175>, <27.362,24,-75.175>, <40,24,-69.282> }
		triangle { <40,24,-69.282>, <40,16,-69.282>, <27.362,16,-75.175> }
		triangle { <40,16,-69.282>, <40,24,-69.282>, <51.423,24,-61.283> }
		triangle { <51.423,24,-61.283>, <51.423,16,-61.283>, <40,16,-69.282> }
		triangle { <51.423,16,-61.283>, <51.423,24,-61.283>, <61.283,24,-51.423> }
		triangle { <61.283,24,-51.423>, <61.283,16,-51.423>, <51.423,16,-61.283> }
		triangle { <61.283,16,-51.423>, <61.283,24,-51.423>, <69.282,24,-40> }
		triangle { <69.282,24,-40>, <69.282,16,-40>, <61.283,16,-51.423> }
		triangle { <69.282,16,-40>, <69.282,24,-40>, <75.175,24,-27.362> }
		triangle { <75.175,24,-27.362>, <75.175,16,-27.362>, <69.282,16,-40> }
		triangle { <75.175,16,-27.362>, <75.175,24,-27.362>, <78.785,24,-13.892> }
		triangle { <78.785,24,-13.892>, <78.785,16,-13.892>, <75.175,16,-27.362> }
		triangle { <78.785,16,-13.892>, <78.785,24,-13.892>, <80,24,0> }
		triangle { <80,24,0>, <80,16,0>, <78.785,16,-13.892> }
		triangle { <0,4,23>, <3.994,4,22.651>, <6.946,7,39.392> }
		triangle { <6.946,7,39.392>, <0,7,40>, <0,4,23> }
		triangle { <3.994,4,22.651>, <7.866,4,21.613>, <13.681,7,37.588> }
		triangle { <13.681,7,37.588>, <6.946,7,39.392>, <3.994,4,22.651> }
		triangle { <7.866,4,21.613>, <11.5,4,19.919>, <20,7,34.641> }
		triangle { <20,7,34.641>, <13.681,7,37.588>, <7.866,4,21.613> }
		triangle { <11.5,4,19.919>, <14.784,4,17.619>, <25.711,7,30.642> }
		triangle { <25.711,7,30.642>, <20,7,34.641>, <11.5,4,19.919> }
		triangle { <14.784,4,17.619>, <17.619,4,14.784>, <30.642,7,25.711> }
		triangle { <30.642,7,25.711>, <25.711,7,30.642>, <14.784,4,17.619> }
		triangle { <17.619,4,14.784>, <19.919,4,11.5>, <34.641,7,20> }
		triangle { <34.641,7,20>, <30.642,7,25.711>, <17.619,4,14.784> }
		triangle { <19.919,4,11.5>, <21.613,4,7.866>, <37.588,7,13.681> }
		triangle { <37.588,7,13.681>, <34.641,7,20>, <19.919,4,11.5> }
		triangle { <21.613,4,7.866>, <22.651,4,3.994>, <39.392,7,6.946> }
		triangle { <39.392,7,6.946>, <37.588,7,13.681>, <21.613,4,7.866> }
		triangle { <22.651,4,3.994>, <23,4,0>, <40,7,0> }
		triangle { <40,7,0>, <39.392,7,6.946>, <22.651,4,3.994> }
		triangle { <0,4,23>, <-3.994,4,22.651>, <-6.946,7,39.392> }
		triangle { <-6.946,7,39.392>, <0,7,40>, <0,4,23> }
		triangle { <-3.994,4,22.651>, <-7.866,4,21.613>, <-13.681,7,37.588> }
		triangle { <-13.681,7,37.588>, <-6.946,7,39.392>, <-3.994,4,22.651> }
		triangle { <-7.866,4,21.613>, <-11.5,4,19.919>, <-20,7,34.641> }
		triangle { <-20,7,34.641>, <-13.681,7,37.588>, <-7.866,4,21.613> }
		triangle { <-11.5,4,19.919>, <-14.784,4,17.619>, <-25.711,7,30.642> }
		triangle { <-25.711,7,30.642>, <-20,7,34.641>, <-11.5,4,19.919> }
		triangle { <-14.784,4,17.619>, <-17.619,4,14.784>, <-30.642,7,25.711> }
		triangle { <-30.642,7,25.711>, <-25.711,7,30.642>, <-14.784,4,17.619> }
		triangle { <-17.619,4,14.784>, <-19.919,4,11.5>, <-34.641,7,20> }
		triangle { <-34.641,7,20>, <-30.642,7,25.711>, <-17.619,4,14.784> }
		triangle { <-19.919,4,11.5>, <-21.613,4,7.866>, <-37.588,7,13.681> }
		triangle { <-37.588,7,13.681>, <-34.641,7,20>, <-19.919,4,11.5> }
		triangle { <-21.613,4,7.866>, <-22.651,4,3.994>, <-39.392,7,6.946> }
		triangle { <-39.392,7,6.946>, <-37.588,7,13.681>, <-21.613,4,7.866> }
		triangle { <-22.651,4,3.994>, <-23,4,0>, <-40,7,0> }
		triangle { <-40,7,0>, <-39.392,7,6.946>, <-22.651,4,3.994> }
		triangle { <0,4,-23>, <-3.994,4,-22.651>, <-6.946,7,-39.392> }
		triangle { <-6.946,7,-39.392>, <0,7,-40>, <0,4,-23> }
		triangle { <-3.994,4,-22.651>, <-7.866,4,-21.613>, <-13.681,7,-37.588> }
		triangle { <-13.681,7,-37.588>, <-6.946,7,-39.392>, <-3.994,4,-22.651> }
		triangle { <-7.866,4,-21.613>, <-11.5,4,-19.919>, <-20,7,-34.641> }
		triangle { <-20,7,-34.641>, <-13.681,7,-37.588>, <-7.866,4,-21.613> }
		triangle { <-11.5,4,-19.919>, <-14.784,4,-17.619>, <-25.711,7,-30.642> }
		triangle { <-25.711,7,-30.642>, <-20,7,-34.641>, <-11.5,4,-19.919> }
		triangle { <-14.784,4,-17.619>, <-17.619,4,-14.784>, <-30.642,7,-25.711> }
		triangle { <-30.642,7,-25.711>, <-25.711,7,-30.642>, <-14.784,4,-17.619> }
		triangle { <-17.619,4,-14.784>, <-19.919,4,-11.5>, <-34.641,7,-20> }
		triangle { <-34.641,7,-20>, <-30.642,7,-25.711>, <-17.619,4,-14.784> }
		triangle { <-19.919,4,-11.5>, <-21.613,4,-7.866>, <-37.588,7,-13.681> }
		triangle { <-37.588,7,-13.681>, <-34.641,7,-20>, <-19.919,4,-11.5> }
		triangle { <-21.613,4,-7.866>, <-22.651,4,-3.994>, <-39.392,7,-6.946> }
		triangle { <-39.392,7,-6.946>, <-37.588,7,-13.681>, <-21.613,4,-7.866> }
		triangle { <-22.651,4,-3.994>, <-23,4,0>, <-40,7,0> }
		triangle { <-40,7,0>, <-39.392,7,-6.946>, <-22.651,4,-3.994> }
		triangle { <0,4,-23>, <3.994,4,-22.651>, <6.946,7,-39.392> }
		triangle { <6.946,7,-39.392>, <0,7,-40>, <0,4,-23> }
		triangle { <3.994,4,-22.651>, <7.866,4,-21.613>, <13.681,7,-37.588> }
		triangle { <13.681,7,-37.588>, <6.946,7,-39.392>, <3.994,4,-22.651> }
		triangle { <7.866,4,-21.613>, <11.5,4,-19.919>, <20,7,-34.641> }
		triangle { <20,7,-34.641>, <13.681,7,-37.588>, <7.866,4,-21.613> }
		triangle { <11.5,4,-19.919>, <14.784,4,-17.619>, <25.711,7,-30.642> }
		triangle { <25.711,7,-30.642>, <20,7,-34.641>, <11.5,4,-19.919> }
		triangle { <14.784,4,-17.619>, <17.619,4,-14.784>, <30.642,7,-25.711> }
		triangle { <30.642,7,-25.711>, <25.711,7,-30.642>, <14.784,4,-17.619> }
		triangle { <17.619,4,-14.784>, <19.919,4,-11.5>, <34.641,7,-20> }
		triangle { <34.641,7,-20>, <30.642,7,-25.711>, <17.619,4,-14.784> }
		triangle { <19.919,4,-11.5>, <21.613,4,-7.866>, <37.588,7,-13.681> }
		triangle { <37.588,7,-13.681>, <34.641,7,-20>, <19.919,4,-11.5> }
		triangle { <21.613,4,-7.866>, <22.651,4,-3.994>, <39.392,7,-6.946> }
		triangle { <39.392,7,-6.946>, <37.588,7,-13.681>, <21.613,4,-7.866> }
		triangle { <22.651,4,-3.994>, <23,4,0>, <40,7,0> }
		triangle { <40,7,0>, <39.392,7,-6.946>, <22.651,4,-3.994> }
		triangle { <0,20,76.5>, <13.284,20,75.338>, <10.419,13,59.088> }
		triangle { <10.419,13,59.088>, <0,13,60>, <0,20,76.5> }
		triangle { <13.284,20,75.338>, <26.265,20,71.886>, <20.521,13,56.382> }
		triangle { <20.521,13,56.382>, <10.419,13,59.088>, <13.284,20,75.338> }
		triangle { <26.265,20,71.886>, <38.25,20,66.251>, <30,13,51.962> }
		triangle { <30,13,51.962>, <20.521,13,56.382>, <26.265,20,71.886> }
		triangle { <38.25,20,66.251>, <49.173,20,58.602>, <38.567,13,45.963> }
		triangle { <38.567,13,45.963>, <30,13,51.962>, <38.25,20,66.251> }
		triangle { <49.173,20,58.602>, <58.602,20,49.173>, <45.963,13,38.567> }
		triangle { <45.963,13,38.567>, <38.567,13,45.963>, <49.173,20,58.602> }
		triangle { <58.602,20,49.173>, <66.251,20,38.25>, <51.962,13,30> }
		triangle { <51.962,13,30>, <45.963,13,38.567>, <58.602,20,49.173> }
		triangle { <66.251,20,38.25>, <71.886,20,26.265>, <56.832,13,20.521> }
		triangle { <56.832,13,20.521>, <51.962,13,30>, <66.251,20,38.25> }
		triangle { <71.886,20,26.265>, <75.338,20,13.284>, <59.088,13,10.419> }
		triangle { <59.088,13,10.419>, <56.832,13,20.521>, <71.886,20,26.265> }
		triangle { <75.338,20,13.284>, <76.5,20,0>, <60,13,0> }
		triangle { <60,13,0>, <59.088,13,10.419>, <75.338,20,13.284> }
		triangle { <0,20,76.5>, <-13.284,20,75.338>, <-10.419,13,59.088> }
		triangle { <-10.419,13,59.088>, <0,13,60>, <0,20,76.5> }
		triangle { <-13.284,20,75.338>, <-26.265,20,71.886>, <-20.521,13,56.382> }
		triangle { <-20.521,13,56.382>, <-10.419,13,59.088>, <-13.284,20,75.338> }
		triangle { <-26.265,20,71.886>, <-38.25,20,66.251>, <-30,13,51.962> }
		triangle { <-30,13,51.962>, <-20.521,13,56.382>, <-26.265,20,71.886> }
		triangle { <-38.25,20,66.251>, <-49.173,20,58.602>, <-38.567,13,45.963> }
		triangle { <-38.567,13,45.963>, <-30,13,51.962>, <-38.25,20,66.251> }
		triangle { <-49.173,20,58.602>, <-58.602,20,49.173>, <-45.963,13,38.567> }
		triangle { <-45.963,13,38.567>, <-38.567,13,45.963>, <-49.173,20,58.602> }
		triangle { <-58.602,20,49.173>, <-66.251,20,38.25>, <-51.962,13,30> }
		triangle { <-51.962,13,30>, <-45.963,13,38.567>, <-58.602,20,49.173> }
		triangle { <-66.251,20,38.25>, <-71.886,20,26.265>, <-56.832,13,20.521> }
		triangle { <-56.832,13,20.521>, <-51.962,13,30>, <-66.251,20,38.25> }
		triangle { <-71.886,20,26.265>, <-75.338,20,13.284>, <-59.088,13,10.419> }
		triangle { <-59.088,13,10.419>, <-56.832,13,20.521>, <-71.886,20,26.265> }
		triangle { <-75.338,20,13.284>, <-76.5,20,0>, <-60,13,0> }
		triangle { <-60,13,0>, <-59.088,13,10.419>, <-75.338,20,13.284> }
		triangle { <0,20,-76.5>, <-13.284,20,-75.338>, <-10.419,13,-59.088> }
		triangle { <-10.419,13,-59.088>, <0,13,-60>, <0,20,-76.5> }
		triangle { <-13.284,20,-75.338>, <-26.265,20,-71.886>, <-20.521,13,-56.382> }
		triangle { <-20.521,13,-56.382>, <-10.419,13,-59.088>, <-13.284,20,-75.338> }
		triangle { <-26.265,20,-71.886>, <-38.25,20,-66.251>, <-30,13,-51.962> }
		triangle { <-30,13,-51.962>, <-20.521,13,-56.382>, <-26.265,20,-71.886> }
		triangle { <-38.25,20,-66.251>, <-49.173,20,-58.602>, <-38.567,13,-45.963> }
		triangle { <-38.567,13,-45.963>, <-30,13,-51.962>, <-38.25,20,-66.251> }
		triangle { <-49.173,20,-58.602>, <-58.602,20,-49.173>, <-45.963,13,-38.567> }
		triangle { <-45.963,13,-38.567>, <-38.567,13,-45.963>, <-49.173,20,-58.602> }
		triangle { <-58.602,20,-49.173>, <-66.251,20,-38.25>, <-51.962,13,-30> }
		triangle { <-51.962,13,-30>, <-45.963,13,-38.567>, <-58.602,20,-49.173> }
		triangle { <-66.251,20,-38.25>, <-71.886,20,-26.265>, <-56.832,13,-20.521> }
		triangle { <-56.832,13,-20.521>, <-51.962,13,-30>, <-66.251,20,-38.25> }
		triangle { <-71.886,20,-26.265>, <-75.338,20,-13.284>, <-59.088,13,-10.419> }
		triangle { <-59.088,13,-10.419>, <-56.832,13,-20.521>, <-71.886,20,-26.265> }
		triangle { <-75.338,20,-13.284>, <-76.5,20,0>, <-60,13,0> }
		triangle { <-60,13,0>, <-59.088,13,-10.419>, <-75.338,20,-13.284> }
		triangle { <0,20,-76.5>, <13.284,20,-75.338>, <10.419,13,-59.088> }
		triangle { <10.419,13,-59.088>, <0,13,-60>, <0,20,-76.5> }
		triangle { <13.284,20,-75.338>, <26.265,20,-71.886>, <20.521,13,-56.382> }
		triangle { <20.521,13,-56.382>, <10.419,13,-59.088>, <13.284,20,-75.338> }
		triangle { <26.265,20,-71.886>, <38.25,20,-66.251>, <30,13,-51.962> }
		triangle { <30,13,-51.962>, <20.521,13,-56.382>, <26.265,20,-71.886> }
		triangle { <38.25,20,-66.251>, <49.173,20,-58.602>, <38.567,13,-45.963> }
		triangle { <38.567,13,-45.963>, <30,13,-51.962>, <38.25,20,-66.251> }
		triangle { <49.173,20,-58.602>, <58.602,20,-49.173>, <45.963,13,-38.567> }
		triangle { <45.963,13,-38.567>, <38.567,13,-45.963>, <49.173,20,-58.602> }
		triangle { <58.602,20,-49.173>, <66.251,20,-38.25>, <51.962,13,-30> }
		triangle { <51.962,13,-30>, <45.963,13,-38.567>, <58.602,20,-49.173> }
		triangle { <66.251,20,-38.25>, <71.886,20,-26.265>, <56.832,13,-20.521> }
		triangle { <56.832,13,-20.521>, <51.962,13,-30>, <66.251,20,-38.25> }
		triangle { <71.886,20,-26.265>, <75.338,20,-13.284>, <59.088,13,-10.419> }
		triangle { <59.088,13,-10.419>, <56.832,13,-20.521>, <71.886,20,-26.265> }
		triangle { <75.338,20,-13.284>, <76.5,20,0>, <60,13,0> }
		triangle { <60,13,0>, <59.088,13,-10.419>, <75.338,20,-13.284> }
		triangle { <10.419,13,59.088>, <0,13,60>, <0,7,40> }
		triangle { <0,7,40>, <6.946,7,39.392>, <10.419,13,59.088> }
		triangle { <20.521,13,56.382>, <10.419,13,59.088>, <6.946,7,39.392> }
		triangle { <6.946,7,39.392>, <13.681,7,37.588>, <20.521,13,56.382> }
		triangle { <30,13,51.962>, <20.521,13,56.382>, <13.681,7,37.588> }
		triangle { <13.681,7,37.588>, <20,7,34.641>, <30,13,51.962> }
		triangle { <38.567,13,45.963>, <30,13,51.962>, <20,7,34.641> }
		triangle { <20,7,34.641>, <25.711,7,30.642>, <38.567,13,45.963> }
		triangle { <45.963,13,38.567>, <38.567,13,45.963>, <25.711,7,30.642> }
		triangle { <25.711,7,30.642>, <30.642,7,25.711>, <45.963,13,38.567> }
		triangle { <51.962,13,30>, <45.963,13,38.567>, <30.642,7,25.711> }
		triangle { <30.642,7,25.711>, <34.641,7,20>, <51.962,13,30> }
		triangle { <56.832,13,20.521>, <51.962,13,30>, <34.641,7,20> }
		triangle { <34.641,7,20>, <37.588,7,13.681>, <56.832,13,20.521> }
		triangle { <59.088,13,10.419>, <56.832,13,20.521>, <37.588,7,13.681> }
		triangle { <37.588,7,13.681>, <39.392,7,6.946>, <59.088,13,10.419> }
		triangle { <60,13,0>, <59.088,13,10.419>, <39.392,7,6.946> }
		triangle { <39.392,7,6.946>, <40,7,0>, <60,13,0> }
		triangle { <-10.419,13,59.088>, <0,13,60>, <0,7,40> }
		triangle { <0,7,40>, <-6.946,7,39.392>, <-10.419,13,59.088> }
		triangle { <-20.521,13,56.382>, <-10.419,13,59.088>, <-6.946,7,39.392> }
		triangle { <-6.946,7,39.392>, <-13.681,7,37.588>, <-20.521,13,56.382> }
		triangle { <-30,13,51.962>, <-20.521,13,56.382>, <-13.681,7,37.588> }
		triangle { <-13.681,7,37.588>, <-20,7,34.641>, <-30,13,51.962> }
		triangle { <-38.567,13,45.963>, <-30,13,51.962>, <-20,7,34.641> }
		triangle { <-20,7,34.641>, <-25.711,7,30.642>, <-38.567,13,45.963> }
		triangle { <-45.963,13,38.567>, <-38.567,13,45.963>, <-25.711,7,30.642> }
		triangle { <-25.711,7,30.642>, <-30.642,7,25.711>, <-45.963,13,38.567> }
		triangle { <-51.962,13,30>, <-45.963,13,38.567>, <-30.642,7,25.711> }
		triangle { <-30.642,7,25.711>, <-34.641,7,20>, <-51.962,13,30> }
		triangle { <-56.832,13,20.521>, <-51.962,13,30>, <-34.641,7,20> }
		triangle { <-34.641,7,20>, <-37.588,7,13.681>, <-56.832,13,20.521> }
		triangle { <-59.088,13,10.419>, <-56.832,13,20.521>, <-37.588,7,13.681> }
		triangle { <-37.588,7,13.681>, <-39.392,7,6.946>, <-59.088,13,10.419> }
		triangle { <-60,13,0>, <-59.088,13,10.419>, <-39.392,7,6.946> }
		triangle { <-39.392,7,6.946>, <-40,7,0>, <-60,13,0> }
		triangle { <-10.419,13,-59.088>, <0,13,-60>, <0,7,-40> }
		triangle { <0,7,-40>, <-6.946,7,-39.392>, <-10.419,13,-59.088> }
		triangle { <-20.521,13,-56.382>, <-10.419,13,-59.088>, <-6.946,7,-39.392> }
		triangle { <-6.946,7,-39.392>, <-13.681,7,-37.588>, <-20.521,13,-56.382> }
		triangle { <-30,13,-51.962>, <-20.521,13,-56.382>, <-13.681,7,-37.588> }
		triangle { <-13.681,7,-37.588>, <-20,7,-34.641>, <-30,13,-51.962> }
		triangle { <-38.567,13,-45.963>, <-30,13,-51.962>, <-20,7,-34.641> }
		triangle { <-20,7,-34.641>, <-25.711,7,-30.642>, <-38.567,13,-45.963> }
		triangle { <-45.963,13,-38.567>, <-38.567,13,-45.963>, <-25.711,7,-30.642> }
		triangle { <-25.711,7,-30.642>, <-30.642,7,-25.711>, <-45.963,13,-38.567> }
		triangle { <-51.962,13,-30>, <-45.963,13,-38.567>, <-30.642,7,-25.711> }
		triangle { <-30.642,7,-25.711>, <-34.641,7,-20>, <-51.962,13,-30> }
		triangle { <-56.832,13,-20.521>, <-51.962,13,-30>, <-34.641,7,-20> }
		triangle { <-34.641,7,-20>, <-37.588,7,-13.681>, <-56.832,13,-20.521> }
		triangle { <-59.088,13,-10.419>, <-56.832,13,-20.521>, <-37.588,7,-13.681> }
		triangle { <-37.588,7,-13.681>, <-39.392,7,-6.946>, <-59.088,13,-10.419> }
		triangle { <-60,13,0>, <-59.088,13,-10.419>, <-39.392,7,-6.946> }
		triangle { <-39.392,7,-6.946>, <-40,7,0>, <-60,13,0> }
		triangle { <10.419,13,-59.088>, <0,13,-60>, <0,7,-40> }
		triangle { <0,7,-40>, <6.946,7,-39.392>, <10.419,13,-59.088> }
		triangle { <20.521,13,-56.382>, <10.419,13,-59.088>, <6.946,7,-39.392> }
		triangle { <6.946,7,-39.392>, <13.681,7,-37.588>, <20.521,13,-56.382> }
		triangle { <30,13,-51.962>, <20.521,13,-56.382>, <13.681,7,-37.588> }
		triangle { <13.681,7,-37.588>, <20,7,-34.641>, <30,13,-51.962> }
		triangle { <38.567,13,-45.963>, <30,13,-51.962>, <20,7,-34.641> }
		triangle { <20,7,-34.641>, <25.711,7,-30.642>, <38.567,13,-45.963> }
		triangle { <45.963,13,-38.567>, <38.567,13,-45.963>, <25.711,7,-30.642> }
		triangle { <25.711,7,-30.642>, <30.642,7,-25.711>, <45.963,13,-38.567> }
		triangle { <51.962,13,-30>, <45.963,13,-38.567>, <30.642,7,-25.711> }
		triangle { <30.642,7,-25.711>, <34.641,7,-20>, <51.962,13,-30> }
		triangle { <56.832,13,-20.521>, <51.962,13,-30>, <34.641,7,-20> }
		triangle { <34.641,7,-20>, <37.588,7,-13.681>, <56.832,13,-20.521> }
		triangle { <59.088,13,-10.419>, <56.832,13,-20.521>, <37.588,7,-13.681> }
		triangle { <37.588,7,-13.681>, <39.392,7,-6.946>, <59.088,13,-10.419> }
		triangle { <60,13,0>, <59.088,13,-10.419>, <39.392,7,-6.946> }
		triangle { <39.392,7,-6.946>, <40,7,0>, <60,13,0> }
		triangle { <0,0,20>, <3.473,0,19.696>, <6.946,3,39.392> }
		triangle { <6.946,3,39.392>, <0,3,40>, <0,0,20> }
		triangle { <3.473,0,19.696>, <6.84,0,18.794>, <13.681,3,37.588> }
		triangle { <13.681,3,37.588>, <6.946,3,39.392>, <3.473,0,19.696> }
		triangle { <6.84,0,18.794>, <10,0,17.32>, <20,3,34.641> }
		triangle { <20,3,34.641>, <13.681,3,37.588>, <6.84,0,18.794> }
		triangle { <10,0,17.32>, <12.856,0,15.321>, <25.711,3,30.642> }
		triangle { <25.711,3,30.642>, <20,3,34.641>, <10,0,17.32> }
		triangle { <12.856,0,15.321>, <15.321,0,12.856>, <30.642,3,25.711> }
		triangle { <30.642,3,25.711>, <25.711,3,30.642>, <12.856,0,15.321> }
		triangle { <15.321,0,12.865>, <17.32,0,10>, <34.641,3,20> }
		triangle { <34.641,3,20>, <30.642,3,25.711>, <15.321,0,12.865> }
		triangle { <17.32,0,10>, <18.794,0,6.84>, <37.588,3,13.681> }
		triangle { <37.588,3,13.681>, <34.641,3,20>, <17.32,0,10> }
		triangle { <18.794,0,6.84>, <19.696,0,3.473>, <39.392,3,6.946> }
		triangle { <39.392,3,6.946>, <37.588,3,13.681>, <18.794,0,6.84> }
		triangle { <19.696,0,3.473>, <20,0,0>, <40,3,0> }
		triangle { <40,3,0>, <39.392,3,6.946>, <19.696,0,3.473> }
		triangle { <0,0,20>, <-3.473,0,19.696>, <-6.946,3,39.392> }
		triangle { <-6.946,3,39.392>, <0,3,40>, <0,0,20> }
		triangle { <-3.473,0,19.696>, <-6.84,0,18.794>, <-13.681,3,37.588> }
		triangle { <-13.681,3,37.588>, <-6.946,3,39.392>, <-3.473,0,19.696> }
		triangle { <-6.84,0,18.794>, <-10,0,17.32>, <-20,3,34.641> }
		triangle { <-20,3,34.641>, <-13.681,3,37.588>, <-6.84,0,18.794> }
		triangle { <-10,0,17.32>, <-12.856,0,15.321>, <-25.711,3,30.642> }
		triangle { <-25.711,3,30.642>, <-20,3,34.641>, <-10,0,17.32> }
		triangle { <-12.856,0,15.321>, <-15.321,0,12.856>, <-30.642,3,25.711> }
		triangle { <-30.642,3,25.711>, <-25.711,3,30.642>, <-12.856,0,15.321> }
		triangle { <-15.321,0,12.865>, <-17.32,0,10>, <-34.641,3,20> }
		triangle { <-34.641,3,20>, <-30.642,3,25.711>, <-15.321,0,12.865> }
		triangle { <-17.32,0,10>, <-18.794,0,6.84>, <-37.588,3,13.681> }
		triangle { <-37.588,3,13.681>, <-34.641,3,20>, <-17.32,0,10> }
		triangle { <-18.794,0,6.84>, <-19.696,0,3.473>, <-39.392,3,6.946> }
		triangle { <-39.392,3,6.946>, <-37.588,3,13.681>, <-18.794,0,6.84> }
		triangle { <-19.696,0,3.473>, <-20,0,0>, <-40,3,0> }
		triangle { <-40,3,0>, <-39.392,3,6.946>, <-19.696,0,3.473> }
		triangle { <0,0,-20>, <-3.473,0,-19.696>, <-6.946,3,-39.392> }
		triangle { <-6.946,3,-39.392>, <0,3,-40>, <0,0,-20> }
		triangle { <-3.473,0,-19.696>, <-6.84,0,-18.794>, <-13.681,3,-37.588> }
		triangle { <-13.681,3,-37.588>, <-6.946,3,-39.392>, <-3.473,0,-19.696> }
		triangle { <-6.84,0,-18.794>, <-10,0,-17.32>, <-20,3,-34.641> }
		triangle { <-20,3,-34.641>, <-13.681,3,-37.588>, <-6.84,0,-18.794> }
		triangle { <-10,0,-17.32>, <-12.856,0,-15.321>, <-25.711,3,-30.642> }
		triangle { <-25.711,3,-30.642>, <-20,3,-34.641>, <-10,0,-17.32> }
		triangle { <-12.856,0,-15.321>, <-15.321,0,-12.856>, <-30.642,3,-25.711> }
		triangle { <-30.642,3,-25.711>, <-25.711,3,-30.642>, <-12.856,0,-15.321> }
		triangle { <-15.321,0,-12.865>, <-17.32,0,-10>, <-34.641,3,-20> }
		triangle { <-34.641,3,-20>, <-30.642,3,-25.711>, <-15.321,0,-12.865> }
		triangle { <-17.32,0,-10>, <-18.794,0,-6.84>, <-37.588,3,-13.681> }
		triangle { <-37.588,3,-13.681>, <-34.641,3,-20>, <-17.32,0,-10> }
		triangle { <-18.794,0,-6.84>, <-19.696,0,-3.473>, <-39.392,3,-6.946> }
		triangle { <-39.392,3,-6.946>, <-37.588,3,-13.681>, <-18.794,0,-6.84> }
		triangle { <-19.696,0,-3.473>, <-20,0,0>, <-40,3,0> }
		triangle { <-40,3,0>, <-39.392,3,-6.946>, <-19.696,0,-3.473> }
		triangle { <0,0,-20>, <3.473,0,-19.696>, <6.946,3,-39.392> }
		triangle { <6.946,3,-39.392>, <0,3,-40>, <0,0,-20> }
		triangle { <3.473,0,-19.696>, <6.84,0,-18.794>, <13.681,3,-37.588> }
		triangle { <13.681,3,-37.588>, <6.946,3,-39.392>, <3.473,0,-19.696> }
		triangle { <6.84,0,-18.794>, <10,0,-17.32>, <20,3,-34.641> }
		triangle { <20,3,-34.641>, <13.681,3,-37.588>, <6.84,0,-18.794> }
		triangle { <10,0,-17.32>, <12.856,0,-15.321>, <25.711,3,-30.642> }
		triangle { <25.711,3,-30.642>, <20,3,-34.641>, <10,0,-17.32> }
		triangle { <12.856,0,-15.321>, <15.321,0,-12.856>, <30.642,3,-25.711> }
		triangle { <30.642,3,-25.711>, <25.711,3,-30.642>, <12.856,0,-15.321> }
		triangle { <15.321,0,-12.865>, <17.32,0,-10>, <34.641,3,-20> }
		triangle { <34.641,3,-20>, <30.642,3,-25.711>, <15.321,0,-12.865> }
		triangle { <17.32,0,-10>, <18.794,0,-6.84>, <37.588,3,-13.681> }
		triangle { <37.588,3,-13.681>, <34.641,3,-20>, <17.32,0,-10> }
		triangle { <18.794,0,-6.84>, <19.696,0,-3.473>, <39.392,3,-6.946> }
		triangle { <39.392,3,-6.946>, <37.588,3,-13.681>, <18.794,0,-6.84> }
		triangle { <19.696,0,-3.473>, <20,0,0>, <40,3,0> }
		triangle { <40,3,0>, <39.392,3,-6.946>, <19.696,0,-3.473> }
		triangle { <10.419,9,59.088>, <0,9,60>, <0,3,40> }
		triangle { <0,3,40>, <6.946,3,39.392>, <10.419,9,59.088> }
		triangle { <20.521,9,56.382>, <10.419,9,59.088>, <6.946,3,39.392> }
		triangle { <6.946,3,39.392>, <13.681,3,37.588>, <20.521,9,56.382> }
		triangle { <30,9,51.962>, <20.521,9,56.382>, <13.681,3,37.588> }
		triangle { <13.681,3,37.588>, <20,3,34.641>, <30,9,51.962> }
		triangle { <38.567,9,45.963>, <30,9,51.962>, <20,3,34.641> }
		triangle { <20,3,34.641>, <25.711,3,30.642>, <38.567,9,45.963> }
		triangle { <45.963,9,38.567>, <38.567,9,45.963>, <25.711,3,30.642> }
		triangle { <25.711,3,30.642>, <30.642,3,25.711>, <45.963,9,38.567> }
		triangle { <51.962,9,30>, <45.963,9,38.567>, <30.642,3,25.711> }
		triangle { <30.642,3,25.711>, <34.641,3,20>, <51.962,9,30> }
		triangle { <56.832,9,20.521>, <51.962,9,30>, <34.641,3,20> }
		triangle { <34.641,3,20>, <37.588,3,13.681>, <56.832,9,20.521> }
		triangle { <59.088,9,10.419>, <56.832,9,20.521>, <37.588,3,13.681> }
		triangle { <37.588,3,13.681>, <39.392,3,6.946>, <59.088,9,10.419> }
		triangle { <60,9,0>, <59.088,9,10.419>, <39.392,3,6.946> }
		triangle { <39.392,3,6.946>, <40,3,0>, <60,9,0> }
		triangle { <-10.419,9,59.088>, <0,9,60>, <0,3,40> }
		triangle { <0,3,40>, <-6.946,3,39.392>, <-10.419,9,59.088> }
		triangle { <-20.521,9,56.382>, <-10.419,9,59.088>, <-6.946,3,39.392> }
		triangle { <-6.946,3,39.392>, <-13.681,3,37.588>, <-20.521,9,56.382> }
		triangle { <-30,9,51.962>, <-20.521,9,56.382>, <-13.681,3,37.588> }
		triangle { <-13.681,3,37.588>, <-20,3,34.641>, <-30,9,51.962> }
		triangle { <-38.567,9,45.963>, <-30,9,51.962>, <-20,3,34.641> }
		triangle { <-20,3,34.641>, <-25.711,3,30.642>, <-38.567,9,45.963> }
		triangle { <-45.963,9,38.567>, <-38.567,9,45.963>, <-25.711,3,30.642> }
		triangle { <-25.711,3,30.642>, <-30.642,3,25.711>, <-45.963,9,38.567> }
		triangle { <-51.962,9,30>, <-45.963,9,38.567>, <-30.642,3,25.711> }
		triangle { <-30.642,3,25.711>, <-34.641,3,20>, <-51.962,9,30> }
		triangle { <-56.832,9,20.521>, <-51.962,9,30>, <-34.641,3,20> }
		triangle { <-34.641,3,20>, <-37.588,3,13.681>, <-56.832,9,20.521> }
		triangle { <-59.088,9,10.419>, <-56.832,9,20.521>, <-37.588,3,13.681> }
		triangle { <-37.588,3,13.681>, <-39.392,3,6.946>, <-59.088,9,10.419> }
		triangle { <-60,9,0>, <-59.088,9,10.419>, <-39.392,3,6.946> }
		triangle { <-39.392,3,6.946>, <-40,3,0>, <-60,9,0> }
		triangle { <-10.419,9,-59.088>, <0,9,-60>, <0,3,-40> }
		triangle { <0,3,-40>, <-6.946,3,-39.392>, <-10.419,9,-59.088> }
		triangle { <-20.521,9,-56.382>, <-10.419,9,-59.088>, <-6.946,3,-39.392> }
		triangle { <-6.946,3,-39.392>, <-13.681,3,-37.588>, <-20.521,9,-56.382> }
		triangle { <-30,9,-51.962>, <-20.521,9,-56.382>, <-13.681,3,-37.588> }
		triangle { <-13.681,3,-37.588>, <-20,3,-34.641>, <-30,9,-51.962> }
		triangle { <-38.567,9,-45.963>, <-30,9,-51.962>, <-20,3,-34.641> }
		triangle { <-20,3,-34.641>, <-25.711,3,-30.642>, <-38.567,9,-45.963> }
		triangle { <-45.963,9,-38.567>, <-38.567,9,-45.963>, <-25.711,3,-30.642> }
		triangle { <-25.711,3,-30.642>, <-30.642,3,-25.711>, <-45.963,9,-38.567> }
		triangle { <-51.962,9,-30>, <-45.963,9,-38.567>, <-30.642,3,-25.711> }
		triangle { <-30.642,3,-25.711>, <-34.641,3,-20>, <-51.962,9,-30> }
		triangle { <-56.832,9,-20.521>, <-51.962,9,-30>, <-34.641,3,-20> }
		triangle { <-34.641,3,-20>, <-37.588,3,-13.681>, <-56.832,9,-20.521> }
		triangle { <-59.088,9,-10.419>, <-56.832,9,-20.521>, <-37.588,3,-13.681> }
		triangle { <-37.588,3,-13.681>, <-39.392,3,-6.946>, <-59.088,9,-10.419> }
		triangle { <-60,9,0>, <-59.088,9,-10.419>, <-39.392,3,-6.946> }
		triangle { <-39.392,3,-6.946>, <-40,3,0>, <-60,9,0> }
		triangle { <10.419,9,-59.088>, <0,9,-60>, <0,3,-40> }
		triangle { <0,3,-40>, <6.946,3,-39.392>, <10.419,9,-59.088> }
		triangle { <20.521,9,-56.382>, <10.419,9,-59.088>, <6.946,3,-39.392> }
		triangle { <6.946,3,-39.392>, <13.681,3,-37.588>, <20.521,9,-56.382> }
		triangle { <30,9,-51.962>, <20.521,9,-56.382>, <13.681,3,-37.588> }
		triangle { <13.681,3,-37.588>, <20,3,-34.641>, <30,9,-51.962> }
		triangle { <38.567,9,-45.963>, <30,9,-51.962>, <20,3,-34.641> }
		triangle { <20,3,-34.641>, <25.711,3,-30.642>, <38.567,9,-45.963> }
		triangle { <45.963,9,-38.567>, <38.567,9,-45.963>, <25.711,3,-30.642> }
		triangle { <25.711,3,-30.642>, <30.642,3,-25.711>, <45.963,9,-38.567> }
		triangle { <51.962,9,-30>, <45.963,9,-38.567>, <30.642,3,-25.711> }
		triangle { <30.642,3,-25.711>, <34.641,3,-20>, <51.962,9,-30> }
		triangle { <56.832,9,-20.521>, <51.962,9,-30>, <34.641,3,-20> }
		triangle { <34.641,3,-20>, <37.588,3,-13.681>, <56.832,9,-20.521> }
		triangle { <59.088,9,-10.419>, <56.832,9,-20.521>, <37.588,3,-13.681> }
		triangle { <37.588,3,-13.681>, <39.392,3,-6.946>, <59.088,9,-10.419> }
		triangle { <60,9,0>, <59.088,9,-10.419>, <39.392,3,-6.946> }
		triangle { <39.392,3,-6.946>, <40,3,0>, <60,9,0> }
		triangle { <0,16,80>, <13.892,16,78.785>, <10.419,9,59.088> }
		triangle { <10.419,9,59.088>, <0,9,60>, <0,16,80> }
		triangle { <13.892,16,78.785>, <27.362,16,75.175>, <20.521,9,56.382> }
		triangle { <20.521,9,56.382>, <10.419,9,59.088>, <13.892,16,78.785> }
		triangle { <27.362,16,75.175>, <40,16,69.282>, <30,9,51.962> }
		triangle { <30,9,51.962>, <20.521,9,56.382>, <27.362,16,75.175> }
		triangle { <40,16,69.282>, <51.423,16,61.284>, <38.567,9,45.963> }
		triangle { <38.567,9,45.963>, <30,9,51.962>, <40,16,69.282> }
		triangle { <51.423,16,61.284>, <61.284,16,51.423>, <45.963,9,38.567> }
		triangle { <45.963,9,38.567>, <38.567,9,45.963>, <51.423,16,61.284> }
		triangle { <61.284,16,51.423>, <69.282,16,40>, <51.962,9,30> }
		triangle { <51.962,9,30>, <45.963,9,38.567>, <61.284,16,51.423> }
		triangle { <69.282,16,40>, <75.175,16,27.362>, <56.832,9,20.521> }
		triangle { <56.832,9,20.521>, <51.962,9,30>, <69.282,16,40> }
		triangle { <75.175,16,27.362>, <78.785,16,13.892>, <59.088,9,10.419> }
		triangle { <59.088,9,10.419>, <56.832,9,20.521>, <75.175,16,27.362> }
		triangle { <78.785,16,13.892>, <80,16,0>, <60,9,0> }
		triangle { <60,9,0>, <59.088,9,10.419>, <78.785,16,13.892> }
		triangle { <0,16,80>, <-13.892,16,78.785>, <-10.419,9,59.088> }
		triangle { <-10.419,9,59.088>, <0,9,60>, <0,16,80> }
		triangle { <-13.892,16,78.785>, <-27.362,16,75.175>, <-20.521,9,56.382> }
		triangle { <-20.521,9,56.382>, <-10.419,9,59.088>, <-13.892,16,78.785> }
		triangle { <-27.362,16,75.175>, <-40,16,69.282>, <-30,9,51.962> }
		triangle { <-30,9,51.962>, <-20.521,9,56.382>, <-27.362,16,75.175> }
		triangle { <-40,16,69.282>, <-51.423,16,61.284>, <-38.567,9,45.963> }
		triangle { <-38.567,9,45.963>, <-30,9,51.962>, <-40,16,69.282> }
		triangle { <-51.423,16,61.284>, <-61.284,16,51.423>, <-45.963,9,38.567> }
		triangle { <-45.963,9,38.567>, <-38.567,9,45.963>, <-51.423,16,61.284> }
		triangle { <-61.284,16,51.423>, <-69.282,16,40>, <-51.962,9,30> }
		triangle { <-51.962,9,30>, <-45.963,9,38.567>, <-61.284,16,51.423> }
		triangle { <-69.282,16,40>, <-75.175,16,27.362>, <-56.832,9,20.521> }
		triangle { <-56.832,9,20.521>, <-51.962,9,30>, <-69.282,16,40> }
		triangle { <-75.175,16,27.362>, <-78.785,16,13.892>, <-59.088,9,10.419> }
		triangle { <-59.088,9,10.419>, <-56.832,9,20.521>, <-75.175,16,27.362> }
		triangle { <-78.785,16,13.892>, <-80,16,0>, <-60,9,0> }
		triangle { <-60,9,0>, <-59.088,9,10.419>, <-78.785,16,13.892> }
		triangle { <0,16,-80>, <-13.892,16,-78.785>, <-10.419,9,-59.088> }
		triangle { <-10.419,9,-59.088>, <0,9,-60>, <0,16,-80> }
		triangle { <-13.892,16,-78.785>, <-27.362,16,-75.175>, <-20.521,9,-56.382> }
		triangle { <-20.521,9,-56.382>, <-10.419,9,-59.088>, <-13.892,16,-78.785> }
		triangle { <-27.362,16,-75.175>, <-40,16,-69.282>, <-30,9,-51.962> }
		triangle { <-30,9,-51.962>, <-20.521,9,-56.382>, <-27.362,16,-75.175> }
		triangle { <-40,16,-69.282>, <-51.423,16,-61.284>, <-38.567,9,-45.963> }
		triangle { <-38.567,9,-45.963>, <-30,9,-51.962>, <-40,16,-69.282> }
		triangle { <-51.423,16,-61.284>, <-61.284,16,-51.423>, <-45.963,9,-38.567> }
		triangle { <-45.963,9,-38.567>, <-38.567,9,-45.963>, <-51.423,16,-61.284> }
		triangle { <-61.284,16,-51.423>, <-69.282,16,-40>, <-51.962,9,-30> }
		triangle { <-51.962,9,-30>, <-45.963,9,-38.567>, <-61.284,16,-51.423> }
		triangle { <-69.282,16,-40>, <-75.175,16,-27.362>, <-56.832,9,-20.521> }
		triangle { <-56.832,9,-20.521>, <-51.962,9,-30>, <-69.282,16,-40> }
		triangle { <-75.175,16,-27.362>, <-78.785,16,-13.892>, <-59.088,9,-10.419> }
		triangle { <-59.088,9,-10.419>, <-56.832,9,-20.521>, <-75.175,16,-27.362> }
		triangle { <-78.785,16,-13.892>, <-80,16,0>, <-60,9,0> }
		triangle { <-60,9,0>, <-59.088,9,-10.419>, <-78.785,16,-13.892> }
		triangle { <0,16,-80>, <13.892,16,-78.785>, <10.419,9,-59.088> }
		triangle { <10.419,9,-59.088>, <0,9,-60>, <0,16,-80> }
		triangle { <13.892,16,-78.785>, <27.362,16,-75.175>, <20.521,9,-56.382> }
		triangle { <20.521,9,-56.382>, <10.419,9,-59.088>, <13.892,16,-78.785> }
		triangle { <27.362,16,-75.175>, <40,16,-69.282>, <30,9,-51.962> }
		triangle { <30,9,-51.962>, <20.521,9,-56.382>, <27.362,16,-75.175> }
		triangle { <40,16,-69.282>, <51.423,16,-61.284>, <38.567,9,-45.963> }
		triangle { <38.567,9,-45.963>, <30,9,-51.962>, <40,16,-69.282> }
		triangle { <51.423,16,-61.284>, <61.284,16,-51.423>, <45.963,9,-38.567> }
		triangle { <45.963,9,-38.567>, <38.567,9,-45.963>, <51.423,16,-61.284> }
		triangle { <61.284,16,-51.423>, <69.282,16,-40>, <51.962,9,-30> }
		triangle { <51.962,9,-30>, <45.963,9,-38.567>, <61.284,16,-51.423> }
		triangle { <69.282,16,-40>, <75.175,16,-27.362>, <56.832,9,-20.521> }
		triangle { <56.832,9,-20.521>, <51.962,9,-30>, <69.282,16,-40> }
		triangle { <75.175,16,-27.362>, <78.785,16,-13.892>, <59.088,9,-10.419> }
		triangle { <59.088,9,-10.419>, <56.832,9,-20.521>, <75.175,16,-27.362> }
		triangle { <78.785,16,-13.892>, <80,16,0>, <60,9,0> }
		triangle { <60,9,0>, <59.088,9,-10.419>, <78.785,16,-13.892> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
	#end
}
#end

#declare _3048_dot_dat = #if (QUAL = 0) box { <-20,0,-10>, <20,24,10> } #else union {
// Slope Brick 45  1 x  2 Triple
	#if (STUDS)
		object { stud3a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,20,0> }
	#end
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,-4,0,4,0,0,0,18,0> }
	object { _2_dash_4cyls_dot_dat matrix <0,0,-4,0,-4,0,-4,0,0,0,18,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,2,0,0,0,4,0,18,0> }
	mesh {
		triangle { <20,24,10>, <16,24,6>, <-16,24,6> }
		triangle { <-16,24,6>, <-20,24,10>, <20,24,10> }
		triangle { <-20,24,10>, <-16,24,6>, <-16,24,-6> }
		triangle { <-16,24,-6>, <-20,24,-10>, <-20,24,10> }
		triangle { <-20,24,-10>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,24,-6>, <20,24,-10>, <-20,24,-10> }
		triangle { <20,24,-10>, <16,24,-6>, <16,24,6> }
		triangle { <16,24,6>, <20,24,10>, <20,24,-10> }
		triangle { <20,24,10>, <20,20,10>, <20,20,-10> }
		triangle { <20,20,-10>, <20,24,-10>, <20,24,10> }
		triangle { <16,24,6>, <16,20,6>, <16,20,-6> }
		triangle { <16,20,-6>, <16,24,-6>, <16,24,6> }
		triangle { <-16,24,6>, <-16,20,6>, <-16,20,-6> }
		triangle { <-16,20,-6>, <-16,24,-6>, <-16,24,6> }
		triangle { <-20,24,10>, <-20,20,10>, <-20,20,-10> }
		triangle { <-20,20,-10>, <-20,24,-10>, <-20,24,10> }
		triangle { <20,24,10>, <20,20,10>, <-20,20,10> }
		triangle { <-20,20,10>, <-20,24,10>, <20,24,10> }
		triangle { <20,20,10>, <0,0,10>, <-20,20,10> }
		triangle { <16,24,6>, <16,20,6>, <-16,20,6> }
		triangle { <-16,20,6>, <-16,24,6>, <16,24,6> }
		triangle { <16,20,6>, <4,8,6>, <-4,8,6> }
		triangle { <-4,8,6>, <-16,20,6>, <16,20,6> }
		triangle { <16,24,-6>, <16,20,-6>, <-16,20,-6> }
		triangle { <-16,20,-6>, <-16,24,-6>, <16,24,-6> }
		triangle { <16,20,-6>, <4,8,6>, <-4,8,6> }
		triangle { <-4,8,6>, <-16,20,-6>, <16,20,-6> }
		triangle { <20,24,-10>, <20,20,-10>, <-20,20,-10> }
		triangle { <-20,20,-10>, <-20,24,-10>, <20,24,-10> }
		triangle { <20,20,-10>, <0,0,10>, <-20,20,-10> }
		triangle { <16,20,6>, <4,8,6>, <16,20,-6> }
		triangle { <-16,20,6>, <-4,8,6>, <-16,20,-6> }
		triangle { <20,20,10>, <0,0,10>, <20,20,-10> }
		triangle { <-20,20,10>, <0,0,10>, <-20,20,-10> }
	}
}
#end

#declare _3940_dot_dat = #if (QUAL = 0) box { <-20,-4,-20>, <20,48,20> } #else union {
// Space Stand  2 x  2 x  2
	#if (STUDS)
		object { stud4a_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,44,0> }
	#end
	object { axlehole_dot_dat matrix <1,0,0,0,16,0,0,0,1,0,28,0> }
	mesh {
		triangle { <20,48,0>, <18.48,48,7.65>, <16,48,11.36> }
		triangle { <16,48,11.36>, <16,48,0>, <20,48,0> }
		triangle { <0,48,20>, <7.65,48,18.48>, <11.36,48,16> }
		triangle { <11.36,48,16>, <0,48,16>, <0,48,20> }
		triangle { <-20,48,0>, <-18.48,48,7.65>, <-16,48,11.36> }
		triangle { <-16,48,11.36>, <-16,48,0>, <-20,48,0> }
		triangle { <0,48,20>, <-7.65,48,18.48>, <-11.36,48,16> }
		triangle { <-11.36,48,16>, <0,48,16>, <0,48,20> }
		triangle { <20,48,0>, <18.48,48,-7.65>, <16,48,-11.36> }
		triangle { <16,48,-11.36>, <16,48,0>, <20,48,0> }
		triangle { <0,48,-20>, <7.65,48,-18.48>, <11.36,48,-16> }
		triangle { <11.36,48,-16>, <0,48,-16>, <0,48,-20> }
		triangle { <-20,48,0>, <-18.48,48,-7.65>, <-16,48,-11.36> }
		triangle { <-16,48,-11.36>, <-16,48,0>, <-20,48,0> }
		triangle { <0,48,-20>, <-7.65,48,-18.48>, <-11.36,48,-16> }
		triangle { <-11.36,48,-16>, <0,48,-16>, <0,48,-20> }
		triangle { <20,48,0>, <20,44,0>, <18.48,44,7.65> }
		triangle { <18.48,44,7.65>, <18.48,48,7.65>, <20,48,0> }
		triangle { <0,48,20>, <0,44,20>, <7.65,44,18.48> }
		triangle { <7.65,44,18.48>, <7.65,48,18.48>, <0,48,20> }
		triangle { <18.48,48,7.65>, <18.48,44,7.65>, <16,44,11.36> }
		triangle { <16,44,11.36>, <16,48,11.36>, <18.48,48,7.65> }
		triangle { <7.65,48,18.48>, <7.65,44,18.48>, <11.36,44,16> }
		triangle { <11.36,44,16>, <11.36,48,16>, <7.65,48,18.48> }
		triangle { <16,48,11.36>, <16,44,11.36>, <16,44,0> }
		triangle { <16,44,0>, <16,48,0>, <16,48,11.36> }
		triangle { <11.36,48,16>, <11.36,44,16>, <0,44,16> }
		triangle { <0,44,16>, <0,48,16>, <11.36,48,16> }
		triangle { <-20,48,0>, <-20,44,0>, <-18.48,44,7.65> }
		triangle { <-18.48,44,7.65>, <-18.48,48,7.65>, <-20,48,0> }
		triangle { <0,48,20>, <0,44,20>, <-7.65,44,18.48> }
		triangle { <-7.65,44,18.48>, <-7.65,48,18.48>, <0,48,20> }
		triangle { <-18.48,48,7.65>, <-18.48,44,7.65>, <-16,44,11.36> }
		triangle { <-16,44,11.36>, <-16,48,11.36>, <-18.48,48,7.65> }
		triangle { <-7.65,48,18.48>, <-7.65,44,18.48>, <-11.36,44,16> }
		triangle { <-11.36,44,16>, <-11.36,48,16>, <-7.65,48,18.48> }
		triangle { <-16,48,11.36>, <-16,44,11.36>, <-16,44,0> }
		triangle { <-16,44,0>, <-16,48,0>, <-16,48,11.36> }
		triangle { <-11.36,48,16>, <-11.36,44,16>, <0,44,16> }
		triangle { <0,44,16>, <0,48,16>, <-11.36,48,16> }
		triangle { <20,48,0>, <20,44,0>, <18.48,44,-7.65> }
		triangle { <18.48,44,-7.65>, <18.48,48,-7.65>, <20,48,0> }
		triangle { <0,48,-20>, <0,44,-20>, <7.65,44,-18.48> }
		triangle { <7.65,44,-18.48>, <7.65,48,-18.48>, <0,48,-20> }
		triangle { <18.48,48,-7.65>, <18.48,44,-7.65>, <16,44,-11.36> }
		triangle { <16,44,-11.36>, <16,48,-11.36>, <18.48,48,-7.65> }
		triangle { <7.65,48,-18.48>, <7.65,44,-18.48>, <11.36,44,-16> }
		triangle { <11.36,44,-16>, <11.36,48,-16>, <7.65,48,-18.48> }
		triangle { <16,48,-11.36>, <16,44,-11.36>, <16,44,0> }
		triangle { <16,44,0>, <16,48,0>, <16,48,-11.36> }
		triangle { <11.36,48,-16>, <11.36,44,-16>, <0,44,-16> }
		triangle { <0,44,-16>, <0,48,-16>, <11.36,48,-16> }
		triangle { <-20,48,0>, <-20,44,0>, <-18.48,44,-7.65> }
		triangle { <-18.48,44,-7.65>, <-18.48,48,-7.65>, <-20,48,0> }
		triangle { <0,48,-20>, <0,44,-20>, <-7.65,44,-18.48> }
		triangle { <-7.65,44,-18.48>, <-7.65,48,-18.48>, <0,48,-20> }
		triangle { <-18.48,48,-7.65>, <-18.48,44,-7.65>, <-16,44,-11.36> }
		triangle { <-16,44,-11.36>, <-16,48,-11.36>, <-18.48,48,-7.65> }
		triangle { <-7.65,48,-18.48>, <-7.65,44,-18.48>, <-11.36,44,-16> }
		triangle { <-11.36,44,-16>, <-11.36,48,-16>, <-7.65,48,-18.48> }
		triangle { <-16,48,-11.36>, <-16,44,-11.36>, <-16,44,0> }
		triangle { <-16,44,0>, <-16,48,0>, <-16,48,-11.36> }
		triangle { <-11.36,48,-16>, <-11.36,44,-16>, <0,44,-16> }
		triangle { <0,44,-16>, <0,48,-16>, <-11.36,48,-16> }
	}
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,28,0,0,0,4,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,22,0,0,0,6,0,2,0> }
	object { _4_dash_4cyli_dot_dat matrix <10,0,0,0,16,0,0,0,10,0,24,0> }
	object { _4_dash_4cyli_dot_dat matrix <20,0,0,0,2,0,0,0,20,0,0,0> }
	object { _4_dash_4cyli_dot_dat matrix <20,0,0,0,4,0,0,0,20,0,40,0> }
	mesh {
		triangle { <8,44,0>, <16,44,0>, <16,44,11.36> }
		triangle { <16,44,11.36>, <5.65,44,5.65>, <8,44,0> }
		triangle { <16,44,11.36>, <14.14,44,14.14>, <11.36,44,16> }
		triangle { <11.36,44,16>, <5.65,44,5.65>, <16,44,11.36> }
		triangle { <0,44,8>, <0,44,16>, <11.36,44,16> }
		triangle { <11.36,44,16>, <5.65,44,5.65>, <0,44,8> }
		triangle { <-8,44,0>, <-16,44,0>, <-16,44,11.36> }
		triangle { <-16,44,11.36>, <-5.65,44,5.65>, <-8,44,0> }
		triangle { <-16,44,11.36>, <-14.14,44,14.14>, <-11.36,44,16> }
		triangle { <-11.36,44,16>, <-5.65,44,5.65>, <-16,44,11.36> }
		triangle { <0,44,8>, <0,44,16>, <-11.36,44,16> }
		triangle { <-11.36,44,16>, <-5.65,44,5.65>, <0,44,8> }
		triangle { <8,44,0>, <16,44,0>, <16,44,-11.36> }
		triangle { <16,44,-11.36>, <5.65,44,-5.65>, <8,44,0> }
		triangle { <16,44,-11.36>, <14.14,44,-14.14>, <11.36,44,-16> }
		triangle { <11.36,44,-16>, <5.65,44,-5.65>, <16,44,-11.36> }
		triangle { <0,44,-8>, <0,44,-16>, <11.36,44,-16> }
		triangle { <11.36,44,-16>, <5.65,44,-5.65>, <0,44,-8> }
		triangle { <-8,44,0>, <-16,44,0>, <-16,44,-11.36> }
		triangle { <-16,44,-11.36>, <-5.65,44,-5.65>, <-8,44,0> }
		triangle { <-16,44,-11.36>, <-14.14,44,-14.14>, <-11.36,44,-16> }
		triangle { <-11.36,44,-16>, <-5.65,44,-5.65>, <-16,44,-11.36> }
		triangle { <0,44,-8>, <0,44,-16>, <-11.36,44,-16> }
		triangle { <-11.36,44,-16>, <-5.65,44,-5.65>, <0,44,-8> }
		triangle { <0,0,4>, <-1.53,0,3.7>, <-7.65,0,18.48> }
		triangle { <-7.65,0,18.48>, <0,0,20>, <0,0,4> }
		triangle { <0,2,6>, <-2.3,2,5.54>, <-7.65,2,18.48> }
		triangle { <-7.65,2,18.48>, <0,2,20>, <0,2,6> }
		triangle { <0,24,6>, <-2.3,24,5.54>, <-3.83,24,9.24> }
		triangle { <-3.83,24,9.24>, <0,24,10>, <0,24,6> }
		triangle { <0,40,10>, <-3.83,40,9.24>, <-7.65,40,18.48> }
		triangle { <-7.65,40,18.48>, <0,40,20>, <0,40,10> }
		triangle { <-1.53,0,3.7>, <-2.83,0,2.83>, <-14.14,0,14.14> }
		triangle { <-14.14,0,14.14>, <-7.65,0,18.48>, <-1.53,0,3.7> }
		triangle { <-2.3,2,5.54>, <-4.24,2,4.24>, <-14.14,2,14.14> }
		triangle { <-14.14,2,14.14>, <-7.65,2,18.48>, <-2.3,2,5.54> }
		triangle { <-2.3,24,5.54>, <-4.24,24,4.24>, <-7.07,24,7.07> }
		triangle { <-7.07,24,7.07>, <-3.83,24,9.24>, <-2.3,24,5.54> }
		triangle { <-3.83,40,9.24>, <-7.07,40,7.07>, <-14.14,40,14.14> }
		triangle { <-14.14,40,14.14>, <-7.65,40,18.48>, <-3.83,40,9.24> }
		triangle { <-2.83,0,2.83>, <-3.7,0,1.53>, <-18.48,0,7.65> }
		triangle { <-18.48,0,7.65>, <-14.14,0,14.14>, <-2.83,0,2.83> }
		triangle { <-4.24,2,4.24>, <-5.54,2,2.3>, <-18.48,2,7.65> }
		triangle { <-18.48,2,7.65>, <-14.14,2,14.14>, <-4.24,2,4.24> }
		triangle { <-4.24,24,4.24>, <-5.54,24,2.3>, <-9.24,24,3.83> }
		triangle { <-9.24,24,3.83>, <-7.07,24,7.07>, <-4.24,24,4.24> }
		triangle { <-7.07,40,7.07>, <-9.24,40,3.83>, <-18.48,40,7.65> }
		triangle { <-18.48,40,7.65>, <-14.14,40,14.14>, <-7.07,40,7.07> }
		triangle { <-3.7,0,1.53>, <-4,0,0>, <-20,0,0> }
		triangle { <-20,0,0>, <-18.48,0,7.65>, <-3.7,0,1.53> }
		triangle { <-5.54,2,2.3>, <-6,2,0>, <-20,2,0> }
		triangle { <-20,2,0>, <-18.48,2,7.65>, <-5.54,2,2.3> }
		triangle { <-5.54,24,2.3>, <-6,24,0>, <-10,24,0> }
		triangle { <-10,24,0>, <-9.24,24,3.83>, <-5.54,24,2.3> }
		triangle { <-9.24,40,3.83>, <-10,40,0>, <-20,40,0> }
		triangle { <-20,40,0>, <-18.48,40,7.65>, <-9.24,40,3.83> }
		triangle { <-4,0,0>, <-3.7,0,-1.53>, <-18.48,0,-7.65> }
		triangle { <-18.48,0,-7.65>, <-20,0,0>, <-4,0,0> }
		triangle { <-6,2,0>, <-5.54,2,-2.3>, <-18.48,2,-7.65> }
		triangle { <-18.48,2,-7.65>, <-20,2,0>, <-6,2,0> }
		triangle { <-6,24,0>, <-5.54,24,-2.3>, <-9.24,24,-3.83> }
		triangle { <-9.24,24,-3.83>, <-10,24,0>, <-6,24,0> }
		triangle { <-10,40,0>, <-9.24,40,-3.83>, <-18.48,40,-7.65> }
		triangle { <-18.48,40,-7.65>, <-20,40,0>, <-10,40,0> }
		triangle { <-3.7,0,-1.53>, <-2.83,0,-2.83>, <-14.14,0,-14.14> }
		triangle { <-14.14,0,-14.14>, <-18.48,0,-7.65>, <-3.7,0,-1.53> }
		triangle { <-5.54,2,-2.3>, <-4.24,2,-4.24>, <-14.14,2,-14.14> }
		triangle { <-14.14,2,-14.14>, <-18.48,2,-7.65>, <-5.54,2,-2.3> }
		triangle { <-5.54,24,-2.3>, <-4.24,24,-4.24>, <-7.07,24,-7.07> }
		triangle { <-7.07,24,-7.07>, <-9.24,24,-3.83>, <-5.54,24,-2.3> }
		triangle { <-9.24,40,-3.83>, <-7.07,40,-7.07>, <-14.14,40,-14.14> }
		triangle { <-14.14,40,-14.14>, <-18.48,40,-7.65>, <-9.24,40,-3.83> }
		triangle { <-2.83,0,-2.83>, <-1.53,0,-3.7>, <-7.65,0,-18.48> }
		triangle { <-7.65,0,-18.48>, <-14.14,0,-14.14>, <-2.83,0,-2.83> }
		triangle { <-4.24,2,-4.24>, <-2.3,2,-5.54>, <-7.65,2,-18.48> }
		triangle { <-7.65,2,-18.48>, <-14.14,2,-14.14>, <-4.24,2,-4.24> }
		triangle { <-4.24,24,-4.24>, <-2.3,24,-5.54>, <-3.83,24,-9.24> }
		triangle { <-3.83,24,-9.24>, <-7.07,24,-7.07>, <-4.24,24,-4.24> }
		triangle { <-7.07,40,-7.07>, <-3.83,40,-9.24>, <-7.65,40,-18.48> }
		triangle { <-7.65,40,-18.48>, <-14.14,40,-14.14>, <-7.07,40,-7.07> }
		triangle { <-1.53,0,-3.7>, <0,0,-4>, <0,0,-20> }
		triangle { <0,0,-20>, <-7.65,0,-18.48>, <-1.53,0,-3.7> }
		triangle { <-2.3,2,-5.54>, <0,2,-6>, <0,2,-20> }
		triangle { <0,2,-20>, <-7.65,2,-18.48>, <-2.3,2,-5.54> }
		triangle { <-2.3,24,-5.54>, <0,24,-6>, <0,24,-10> }
		triangle { <0,24,-10>, <-3.83,24,-9.24>, <-2.3,24,-5.54> }
		triangle { <-3.83,40,-9.24>, <0,40,-10>, <0,40,-20> }
		triangle { <0,40,-20>, <-7.65,40,-18.48>, <-3.83,40,-9.24> }
		triangle { <0,0,-4>, <1.53,0,-3.7>, <7.65,0,-18.48> }
		triangle { <7.65,0,-18.48>, <0,0,-20>, <0,0,-4> }
		triangle { <0,2,-6>, <2.3,2,-5.54>, <7.65,2,-18.48> }
		triangle { <7.65,2,-18.48>, <0,2,-20>, <0,2,-6> }
		triangle { <0,24,-6>, <2.3,24,-5.54>, <3.83,24,-9.24> }
		triangle { <3.83,24,-9.24>, <0,24,-10>, <0,24,-6> }
		triangle { <0,40,-10>, <3.83,40,-9.24>, <7.65,40,-18.48> }
		triangle { <7.65,40,-18.48>, <0,40,-20>, <0,40,-10> }
		triangle { <1.53,0,-3.7>, <2.83,0,-2.83>, <14.14,0,-14.14> }
		triangle { <14.14,0,-14.14>, <7.65,0,-18.48>, <1.53,0,-3.7> }
		triangle { <2.3,2,-5.54>, <4.24,2,-4.24>, <14.14,2,-14.14> }
		triangle { <14.14,2,-14.14>, <7.65,2,-18.48>, <2.3,2,-5.54> }
		triangle { <2.3,24,-5.54>, <4.24,24,-4.24>, <7.07,24,-7.07> }
		triangle { <7.07,24,-7.07>, <3.83,24,-9.24>, <2.3,24,-5.54> }
		triangle { <3.83,40,-9.24>, <7.07,40,-7.07>, <14.14,40,-14.14> }
		triangle { <14.14,40,-14.14>, <7.65,40,-18.48>, <3.83,40,-9.24> }
		triangle { <2.83,0,-2.83>, <3.7,0,-1.53>, <18.48,0,-7.65> }
		triangle { <18.48,0,-7.65>, <14.14,0,-14.14>, <2.83,0,-2.83> }
		triangle { <4.24,2,-4.24>, <5.54,2,-2.3>, <18.48,2,-7.65> }
		triangle { <18.48,2,-7.65>, <14.14,2,-14.14>, <4.24,2,-4.24> }
		triangle { <4.24,24,-4.24>, <5.54,24,-2.3>, <9.24,24,-3.83> }
		triangle { <9.24,24,-3.83>, <7.07,24,-7.07>, <4.24,24,-4.24> }
		triangle { <7.07,40,-7.07>, <9.24,40,-3.83>, <18.48,40,-7.65> }
		triangle { <18.48,40,-7.65>, <14.14,40,-14.14>, <7.07,40,-7.07> }
		triangle { <3.7,0,-1.53>, <4,0,0>, <20,0,0> }
		triangle { <20,0,0>, <18.48,0,-7.65>, <3.7,0,-1.53> }
		triangle { <5.54,2,-2.3>, <6,2,0>, <20,2,0> }
		triangle { <20,2,0>, <18.48,2,-7.65>, <5.54,2,-2.3> }
		triangle { <5.54,24,-2.3>, <6,24,0>, <10,24,0> }
		triangle { <10,24,0>, <9.24,24,-3.83>, <5.54,24,-2.3> }
		triangle { <9.24,40,-3.83>, <10,40,0>, <20,40,0> }
		triangle { <20,40,0>, <18.48,40,-7.65>, <9.24,40,-3.83> }
		triangle { <4,0,0>, <3.7,0,1.53>, <18.48,0,7.65> }
		triangle { <18.48,0,7.65>, <20,0,0>, <4,0,0> }
		triangle { <6,2,0>, <5.54,2,2.3>, <18.48,2,7.65> }
		triangle { <18.48,2,7.65>, <20,2,0>, <6,2,0> }
		triangle { <6,24,0>, <5.54,24,2.3>, <9.24,24,3.83> }
		triangle { <9.24,24,3.83>, <10,24,0>, <6,24,0> }
		triangle { <10,40,0>, <9.24,40,3.83>, <18.48,40,7.65> }
		triangle { <18.48,40,7.65>, <20,40,0>, <10,40,0> }
		triangle { <3.7,0,1.53>, <2.83,0,2.83>, <14.14,0,14.14> }
		triangle { <14.14,0,14.14>, <18.48,0,7.65>, <3.7,0,1.53> }
		triangle { <5.54,2,2.3>, <4.24,2,4.24>, <14.14,2,14.14> }
		triangle { <14.14,2,14.14>, <18.48,2,7.65>, <5.54,2,2.3> }
		triangle { <5.54,24,2.3>, <4.24,24,4.24>, <7.07,24,7.07> }
		triangle { <7.07,24,7.07>, <9.24,24,3.83>, <5.54,24,2.3> }
		triangle { <9.24,40,3.83>, <7.07,40,7.07>, <14.14,40,14.14> }
		triangle { <14.14,40,14.14>, <18.48,40,7.65>, <9.24,40,3.83> }
		triangle { <2.83,0,2.83>, <1.53,0,3.7>, <7.65,0,18.48> }
		triangle { <7.65,0,18.48>, <14.14,0,14.14>, <2.83,0,2.83> }
		triangle { <4.24,2,4.24>, <2.3,2,5.54>, <7.65,2,18.48> }
		triangle { <7.65,2,18.48>, <14.14,2,14.14>, <4.24,2,4.24> }
		triangle { <4.24,24,4.24>, <2.3,24,5.54>, <3.83,24,9.24> }
		triangle { <3.83,24,9.24>, <7.07,24,7.07>, <4.24,24,4.24> }
		triangle { <7.07,40,7.07>, <3.83,40,9.24>, <7.65,40,18.48> }
		triangle { <7.65,40,18.48>, <14.14,40,14.14>, <7.07,40,7.07> }
		triangle { <1.53,0,3.7>, <0,0,4>, <0,0,20> }
		triangle { <0,0,20>, <7.65,0,18.48>, <1.53,0,3.7> }
		triangle { <2.3,2,5.54>, <0,2,6>, <0,2,20> }
		triangle { <0,2,20>, <7.65,2,18.48>, <2.3,2,5.54> }
		triangle { <2.3,24,5.54>, <0,24,6>, <0,24,10> }
		triangle { <0,24,10>, <3.83,24,9.24>, <2.3,24,5.54> }
		triangle { <3.83,40,9.24>, <0,40,10>, <0,40,20> }
		triangle { <0,40,20>, <7.65,40,18.48>, <3.83,40,9.24> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
	#end
}
#end

#declare _2873_dot_dat = #if (QUAL = 0) box { <-40,0,-20>, <40,8,28> } #else union {
// Hinge Train Gate  2 x  4
	object { box5_dot_dat matrix <36,0,0,0,-4,0,0,0,16,0,8,0> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,36,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,22,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,18,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,2,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,-2,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,-18,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,-22,4,24> }
	object { _2_dash_4disc_dot_dat matrix <0,4,0,1,0,0,0,0,4,-36,4,24> }
	mesh {
		triangle { <36,8,20>, <36,8,24>, <36,0,24> }
		triangle { <36,0,24>, <36,0,20>, <36,8,20> }
		triangle { <22,8,20>, <22,8,24>, <22,0,24> }
		triangle { <22,0,24>, <22,0,20>, <22,8,20> }
		triangle { <18,8,20>, <18,8,24>, <18,0,24> }
		triangle { <18,0,24>, <18,0,20>, <18,8,20> }
		triangle { <2,8,20>, <2,8,24>, <2,0,24> }
		triangle { <2,0,24>, <2,0,20>, <2,8,20> }
		triangle { <-2,8,20>, <-2,8,24>, <-2,0,24> }
		triangle { <-2,0,24>, <-2,0,20>, <-2,8,20> }
		triangle { <-18,8,20>, <-18,8,24>, <-18,0,24> }
		triangle { <-18,0,24>, <-18,0,20>, <-18,8,20> }
		triangle { <-22,8,20>, <-22,8,24>, <-22,0,24> }
		triangle { <-22,0,24>, <-22,0,20>, <-22,8,20> }
		triangle { <-36,8,20>, <-36,8,24>, <-36,0,24> }
		triangle { <-36,0,24>, <-36,0,20>, <-36,8,20> }
	}
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-14,0,0,0,0,4,36,4,24> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-16,0,0,0,0,4,18,4,24> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-16,0,0,0,0,4,-2,4,24> }
	object { _2_dash_4cyli_dot_dat matrix <0,4,0,-14,0,0,0,0,4,-22,4,24> }
	mesh {
		triangle { <36,8,20>, <36,8,24>, <22,8,24> }
		triangle { <22,8,24>, <22,8,20>, <36,8,20> }
		triangle { <36,0,24>, <36,0,20>, <22,0,20> }
		triangle { <22,0,20>, <22,0,24>, <36,0,24> }
		triangle { <18,8,20>, <18,8,24>, <2,8,24> }
		triangle { <2,8,24>, <2,8,20>, <18,8,20> }
		triangle { <18,0,24>, <18,0,20>, <2,0,20> }
		triangle { <2,0,20>, <2,0,24>, <18,0,24> }
		triangle { <-18,8,20>, <-18,8,24>, <-2,8,24> }
		triangle { <-2,8,24>, <-2,8,20>, <-18,8,20> }
		triangle { <-18,0,24>, <-18,0,20>, <-2,0,20> }
		triangle { <-2,0,20>, <-2,0,24>, <-18,0,24> }
		triangle { <-36,8,20>, <-36,8,24>, <-22,8,24> }
		triangle { <-22,8,24>, <-22,8,20>, <-36,8,20> }
		triangle { <-36,0,24>, <-36,0,20>, <-22,0,20> }
		triangle { <-22,0,20>, <-22,0,24>, <-36,0,24> }
		triangle { <40,8,20>, <40,8,16>, <-40,8,16> }
		triangle { <-40,8,16>, <-40,8,20>, <40,8,20> }
		triangle { <40,8,-20>, <40,8,-16>, <-40,8,-16> }
		triangle { <-40,8,-16>, <-40,8,-20>, <40,8,-20> }
		triangle { <40,8,16>, <36,8,16>, <36,8,-16> }
		triangle { <36,8,-16>, <40,8,-16>, <40,8,16> }
		triangle { <-40,8,16>, <-36,8,16>, <-36,8,-16> }
		triangle { <-36,8,-16>, <-40,8,-16>, <-40,8,16> }
		triangle { <40,0,20>, <40,0,-20>, <-40,0,-20> }
		triangle { <-40,0,-20>, <-40,0,20>, <40,0,20> }
		triangle { <40,8,20>, <40,0,20>, <36,0,20> }
		triangle { <36,0,20>, <36,8,20>, <40,8,20> }
		triangle { <22,8,20>, <22,0,20>, <18,0,20> }
		triangle { <18,0,20>, <18,8,20>, <22,8,20> }
		triangle { <2,8,20>, <2,0,20>, <-2,0,20> }
		triangle { <-2,0,20>, <-2,8,20>, <2,8,20> }
		triangle { <-18,8,20>, <-18,0,20>, <-22,0,20> }
		triangle { <-22,0,20>, <-22,8,20>, <-18,8,20> }
		triangle { <-36,8,20>, <-36,0,20>, <-40,0,20> }
		triangle { <-40,0,20>, <-40,8,20>, <-36,8,20> }
		triangle { <-40,8,20>, <-40,0,20>, <-40,0,-20> }
		triangle { <-40,0,-20>, <-40,8,-20>, <-40,8,20> }
		triangle { <-40,8,-20>, <-40,0,-20>, <40,0,-20> }
		triangle { <40,0,-20>, <40,8,-20>, <-40,8,-20> }
		triangle { <40,8,-20>, <40,0,-20>, <40,0,20> }
		triangle { <40,0,20>, <40,8,20>, <40,8,-20> }
	}
}
#end

#ifndef (Color326)
#declare Color326 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.766667,0.24902,0.119608> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#declare s_slash_3846s01_dot_dat = #if (QUAL = 0) box { <-20,-14,-10>, <20,32.37,14> } #else union {
// ~Minifig Shield without Decorated Surface
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,0,22,0,4,0,0,0,-8> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,0,1,0,4,0,0,0,14> }
	object { _4_dash_4disc_dot_dat matrix <4,0,0,0,1,0,0,0,4,0,18,0> }
	object { _4_dash_4cyli_dot_dat matrix <4,0,0,0,18,0,0,0,4,0,0,0> }
	object { rect_dot_dat matrix <20,0,0,0,1,0,0,0,1,0,-14,-9> }
	mesh {
		triangle { <0,32.37,-10>, <8.76,24.57,-10>, <8.76,24.57,-8> }
		triangle { <8.76,24.57,-8>, <0,32.37,-8>, <0,32.37,-10> }
		triangle { <8.76,24.57,-10>, <14.93,15.68,-10>, <14.93,15.68,-8> }
		triangle { <14.93,15.68,-8>, <8.76,24.57,-8>, <8.76,24.57,-10> }
		triangle { <14.93,15.68,-10>, <18.72,6.03,-10>, <18.72,6.03,-8> }
		triangle { <18.72,6.03,-8>, <14.93,15.68,-8>, <14.93,15.68,-10> }
		triangle { <18.72,6.03,-10>, <20,-4,-10>, <20,-4,-8> }
		triangle { <20,-4,-8>, <18.72,6.03,-8>, <18.72,6.03,-10> }
		triangle { <20,-4,-10>, <20,-14,-10>, <20,-14,-8> }
		triangle { <20,-14,-8>, <20,-4,-8>, <20,-4,-10> }
		triangle { <0,32.37,-10>, <-8.76,24.57,-10>, <-8.76,24.57,-8> }
		triangle { <-8.76,24.57,-8>, <0,32.37,-8>, <0,32.37,-10> }
		triangle { <-8.76,24.57,-10>, <-14.93,15.68,-10>, <-14.93,15.68,-8> }
		triangle { <-14.93,15.68,-8>, <-8.76,24.57,-8>, <-8.76,24.57,-10> }
		triangle { <-14.93,15.68,-10>, <-18.72,6.03,-10>, <-18.72,6.03,-8> }
		triangle { <-18.72,6.03,-8>, <-14.93,15.68,-8>, <-14.93,15.68,-10> }
		triangle { <-18.72,6.03,-10>, <-20,-4,-10>, <-20,-4,-8> }
		triangle { <-20,-4,-8>, <-18.72,6.03,-8>, <-18.72,6.03,-10> }
		triangle { <-20,-4,-10>, <-20,-14,-10>, <-20,-14,-8> }
		triangle { <-20,-14,-8>, <-20,-4,-8>, <-20,-4,-10> }
		triangle { <0,32.37,-8>, <8.76,24.57,-8>, <-8.76,24.57,-8> }
		triangle { <8.76,24.57,-8>, <14.93,15.68,-8>, <-14.93,15.68,-8> }
		triangle { <-14.93,15.68,-8>, <-8.76,24.57,-8>, <8.76,24.57,-8> }
		triangle { <14.93,15.68,-8>, <18.72,6.03,-8>, <-18.72,6.03,-8> }
		triangle { <-18.72,6.03,-8>, <-14.93,15.68,-8>, <14.93,15.68,-8> }
		triangle { <18.72,6.03,-8>, <20,-4,-8>, <-20,-4,-8> }
		triangle { <-20,-4,-8>, <-18.72,6.03,-8>, <18.72,6.03,-8> }
		triangle { <20,-4,-8>, <20,-14,-8>, <-20,-14,-8> }
		triangle { <-20,-14,-8>, <-20,-4,-8>, <20,-4,-8> }
	}
}
#end

#declare s_slash_3846p44a_dot_dat = #if (QUAL = 0) box { <-11,-8,-10>, <11,22,-10> } #else object {
// ~Wolfpack Pattern - Wolf Head
	mesh {
		triangle { <-4,-3,-10>, <4,-3,-10>, <3.5,4,-10> }
		triangle { <3.5,4,-10>, <-3.5,4,-10>, <-4,-3,-10> }
		triangle { <-3.5,4,-10>, <3.5,4,-10>, <2.5,5,-10> }
		triangle { <2.5,5,-10>, <-2.5,5,-10>, <-3.5,4,-10> }
		triangle { <-2.5,5,-10>, <2.5,5,-10>, <2.5,7,-10> }
		triangle { <2.5,7,-10>, <-2.5,7,-10>, <-2.5,5,-10> }
		triangle { <-2.5,7,-10>, <2.5,7,-10>, <3,8,-10> }
		triangle { <3,8,-10>, <-3,8,-10>, <-2.5,7,-10> }
		triangle { <-3,8,-10>, <3,8,-10>, <2,15,-10> }
		triangle { <2,15,-10>, <-2,15,-10>, <-3,8,-10> }
		triangle { <6,-2,-10>, <4,-3,-10>, <10,-8,-10> }
		triangle { <10,-8,-10>, <9,-6,-10>, <6,-2,-10> }
		triangle { <9,-6,-10>, <10,-8,-10>, <10,-3,-10> }
		triangle { <10,-3,-10>, <7,1,-10>, <9,-6,-10> }
		triangle { <7,1,-10>, <10,-3,-10>, <8,2,-10> }
		triangle { <3.5,4,-10>, <4,-3,-10>, <6,-2,-10> }
		triangle { <6,-2,-10>, <7,1,-10>, <3.5,4,-10> }
		triangle { <3.5,4,-10>, <7,1,-10>, <8,2,-10> }
		triangle { <8,2,-10>, <4,5,-10>, <3.5,4,-10> }
		triangle { <4,5,-10>, <8,2,-10>, <11,6,-10> }
		triangle { <11,6,-10>, <9,6.5,-10>, <4,5,-10> }
		triangle { <4,5,-10>, <9,6.5,-10>, <4,7,-10> }
		triangle { <4,7,-10>, <9,6.5,-10>, <10.5,8,-10> }
		triangle { <10.5,8,-10>, <8,8,-10>, <4,7,-10> }
		triangle { <4,7,-10>, <8,8,-10>, <7.5,9,-10> }
		triangle { <7.5,9,-10>, <3,8,-10>, <4,7,-10> }
		triangle { <8,8,-10>, <9,9,-10>, <7.5,9,-10> }
		triangle { <3,8,-10>, <7.5,9,-10>, <8,10,-10> }
		triangle { <8,10,-10>, <4.5,13,-10>, <3,8,-10> }
		triangle { <3,8,-10>, <4.5,13,-10>, <3.5,16,-10> }
		triangle { <3.5,16,-10>, <2,15,-10>, <3,8,-10> }
		triangle { <2,15,-10>, <3.5,16,-10>, <2,18,-10> }
		triangle { <2,18,-10>, <1,17,-10>, <2,15,-10> }
		triangle { <1,17,-10>, <2,18,-10>, <0,19,-10> }
		triangle { <0,19,-10>, <0,17.5,-10>, <1,17,-10> }
		triangle { <2,22,-10>, <1.5,19,-10>, <3,18.5,-10> }
		triangle { <-6,-2,-10>, <-4,-3,-10>, <-10,-8,-10> }
		triangle { <-10,-8,-10>, <-9,-6,-10>, <-6,-2,-10> }
		triangle { <-9,-6,-10>, <-10,-8,-10>, <-10,-3,-10> }
		triangle { <-10,-3,-10>, <-7,1,-10>, <-9,-6,-10> }
		triangle { <-7,1,-10>, <-10,-3,-10>, <-8,2,-10> }
		triangle { <-3.5,4,-10>, <-4,-3,-10>, <-6,-2,-10> }
		triangle { <-6,-2,-10>, <-7,1,-10>, <-3.5,4,-10> }
		triangle { <-3.5,4,-10>, <-7,1,-10>, <-8,2,-10> }
		triangle { <-8,2,-10>, <-4,5,-10>, <-3.5,4,-10> }
		triangle { <-4,5,-10>, <-8,2,-10>, <-11,6,-10> }
		triangle { <-11,6,-10>, <-9,6.5,-10>, <-4,5,-10> }
		triangle { <-4,5,-10>, <-9,6.5,-10>, <-4,7,-10> }
		triangle { <-4,7,-10>, <-9,6.5,-10>, <-10.5,8,-10> }
		triangle { <-10.5,8,-10>, <-8,8,-10>, <-4,7,-10> }
		triangle { <-4,7,-10>, <-8,8,-10>, <-7.5,9,-10> }
		triangle { <-7.5,9,-10>, <-3,8,-10>, <-4,7,-10> }
		triangle { <-8,8,-10>, <-9,9,-10>, <-7.5,9,-10> }
		triangle { <-3,8,-10>, <-7.5,9,-10>, <-8,10,-10> }
		triangle { <-8,10,-10>, <-4.5,13,-10>, <-3,8,-10> }
		triangle { <-3,8,-10>, <-4.5,13,-10>, <-3.5,16,-10> }
		triangle { <-3.5,16,-10>, <-2,15,-10>, <-3,8,-10> }
		triangle { <-2,15,-10>, <-3.5,16,-10>, <-2,18,-10> }
		triangle { <-2,18,-10>, <-1,17,-10>, <-2,15,-10> }
		triangle { <-1,17,-10>, <-2,18,-10>, <0,19,-10> }
		triangle { <0,19,-10>, <0,17.5,-10>, <-1,17,-10> }
		triangle { <-2,22,-10>, <-1.5,19,-10>, <-3,18.5,-10> }
	}
}
#end

#declare s_slash_3846p44b_dot_dat = #if (QUAL = 0) box { <-11,-8,-10>, <11,22,-10> } #else object {
// ~Wolfpack Pattern - Background
	mesh {
		triangle { <-1,17,-10>, <-2,15,-10>, <2,15,-10> }
		triangle { <2,15,-10>, <1,17,-10>, <-1,17,-10> }
		triangle { <-1,17,-10>, <1,17,-10>, <0,17.5,-10> }
		triangle { <-1.5,19,-10>, <1.5,19,-10>, <2,22,-10> }
		triangle { <2,22,-10>, <-2,22,-10>, <-1.5,19,-10> }
		triangle { <-4,-3,-10>, <-10,-8,-10>, <10,-8,-10> }
		triangle { <10,-8,-10>, <4,-3,-10>, <-4,-3,-10> }
		triangle { <10,-8,-10>, <11,-8,-10>, <11,-3,-10> }
		triangle { <11,-3,-10>, <10,-3,-10>, <10,-8,-10> }
		triangle { <10,-3,-10>, <11,-3,-10>, <11,6,-10> }
		triangle { <11,6,-10>, <8,2,-10>, <10,-3,-10> }
		triangle { <11,6,-10>, <11,8,-10>, <10.5,8,-10> }
		triangle { <10.5,8,-10>, <9,6.5,-10>, <11,6,-10> }
		triangle { <8,8,-10>, <11,8,-10>, <9,9,-10> }
		triangle { <7.5,9,-10>, <9,9,-10>, <8,10,-10> }
		triangle { <8,10,-10>, <6.5,15,-10>, <4.5,13,-10> }
		triangle { <8,10,-10>, <9,9,-10>, <11,8,-10> }
		triangle { <11,8,-10>, <6.5,15,-10>, <8,10,-10> }
		triangle { <4.5,13,-10>, <6.5,15,-10>, <3.5,16,-10> }
		triangle { <3.5,16,-10>, <6.5,15,-10>, <3,18.5,-10> }
		triangle { <3,18.5,-10>, <6.5,15,-10>, <2,22,-10> }
		triangle { <3.5,16,-10>, <3,18.5,-10>, <2,18,-10> }
		triangle { <2,18,-10>, <3,18.5,-10>, <1.5,19,-10> }
		triangle { <1.5,19,-10>, <0,19,-10>, <2,18,-10> }
		triangle { <7,1,-10>, <6,-2,-10>, <9,-6,-10> }
		triangle { <2.5,5,-10>, <3.5,4,-10>, <4,5,-10> }
		triangle { <4,5,-10>, <4,7,-10>, <2.5,5,-10> }
		triangle { <4,7,-10>, <3,8,-10>, <2.5,7,-10> }
		triangle { <2.5,7,-10>, <2.5,5,-10>, <4,7,-10> }
		triangle { <-10,-8,-10>, <-11,-8,-10>, <-11,-3,-10> }
		triangle { <-11,-3,-10>, <-10,-3,-10>, <-10,-8,-10> }
		triangle { <-10,-3,-10>, <-11,-3,-10>, <-11,6,-10> }
		triangle { <-11,6,-10>, <-8,2,-10>, <-10,-3,-10> }
		triangle { <-11,6,-10>, <-11,8,-10>, <-10.5,8,-10> }
		triangle { <-10.5,8,-10>, <-9,6.5,-10>, <-11,6,-10> }
		triangle { <-8,8,-10>, <-11,8,-10>, <-9,9,-10> }
		triangle { <-7.5,9,-10>, <-9,9,-10>, <-8,10,-10> }
		triangle { <-8,10,-10>, <-6.5,15,-10>, <-4.5,13,-10> }
		triangle { <-8,10,-10>, <-9,9,-10>, <-11,8,-10> }
		triangle { <-11,8,-10>, <-6.5,15,-10>, <-8,10,-10> }
		triangle { <-4.5,13,-10>, <-6.5,15,-10>, <-3.5,16,-10> }
		triangle { <-3.5,16,-10>, <-6.5,15,-10>, <-3,18,-10> }
		triangle { <-3,18,-10>, <-6.5,15,-10>, <-2,22,-10> }
		triangle { <-3.5,16,-10>, <-3,18.5,-10>, <-2,18,-10> }
		triangle { <-2,18,-10>, <-3,18.5,-10>, <-1.5,19,-10> }
		triangle { <-1.5,19,-10>, <0,19,-10>, <-2,18,-10> }
		triangle { <-7,1,-10>, <-6,-2,-10>, <-9,-6,-10> }
		triangle { <-2.5,5,-10>, <-3.5,4,-10>, <-4,5,-10> }
		triangle { <-4,5,-10>, <-4,7,-10>, <-2.5,5,-10> }
		triangle { <-4,7,-10>, <-3,8,-10>, <-2.5,7,-10> }
		triangle { <-2.5,7,-10>, <-2.5,5,-10>, <-4,7,-10> }
	}
}
#end

#declare s_slash_3846p44c_dot_dat = #if (QUAL = 0) box { <-20,-14,-10>, <20,32.37,-10> } #else object {
// ~Minifig Shield with Wolfpack Pattern - Border
	mesh {
		triangle { <-17,-11,-10>, <-20,-14,-10>, <20,-14,-10> }
		triangle { <20,-14,-10>, <17,-11,-10>, <-17,-11,-10> }
		triangle { <17,-11,-10>, <20,-14,-10>, <20,-4,-10> }
		triangle { <20,-4,-10>, <17,-4,-10>, <17,-11,-10> }
		triangle { <17,-4,-10>, <20,-4,-10>, <18.72,6.03,-10> }
		triangle { <18.72,6.03,-10>, <15,7,-10>, <17,-4,-10> }
		triangle { <15,7,-10>, <18.72,6.03,-10>, <14.93,15.68,-10> }
		triangle { <14.93,15.68,-10>, <12,14,-10>, <15,7,-10> }
		triangle { <12,14,-10>, <14.93,15.68,-10>, <8.76,24.57,-10> }
		triangle { <8.76,24.57,-10>, <7,21,-10>, <12,14,-10> }
		triangle { <7,21,-10>, <8.76,24.57,-10>, <0,32.37,-10> }
		triangle { <0,32.37,-10>, <0,27,-10>, <7,21,-10> }
		triangle { <-17,-11,-10>, <-20,-14,-10>, <-20,-4,-10> }
		triangle { <-20,-4,-10>, <-17,-4,-10>, <-17,-11,-10> }
		triangle { <-17,-4,-10>, <-20,-4,-10>, <-18.72,6.03,-10> }
		triangle { <-18.72,6.03,-10>, <-15,7,-10>, <-17,-4,-10> }
		triangle { <-15,7,-10>, <-18.72,6.03,-10>, <-14.93,15.68,-10> }
		triangle { <-14.93,15.68,-10>, <-12,14,-10>, <-15,7,-10> }
		triangle { <-12,14,-10>, <-14.93,15.68,-10>, <-8.76,24.57,-10> }
		triangle { <-8.76,24.57,-10>, <-7,21,-10>, <-12,14,-10> }
		triangle { <-7,21,-10>, <-8.76,24.57,-10>, <0,32.37,-10> }
		triangle { <0,32.37,-10>, <0,27,-10>, <-7,21,-10> }
	}
}
#end

#declare _3846p44_dot_dat = #if (QUAL = 0) box { <-20,-14,-10>, <20,32.37,14> } #else union {
// Minifig Shield Triangular with Wolfpack Pattern
	object { s_slash_3846s01_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { s_slash_3846p44a_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (ver >= 3.1) material #else texture #end { Color383 } }
	object { s_slash_3846p44b_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (ver >= 3.1) material #else texture #end { Color0 } }
	object { s_slash_3846p44c_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> #if (ver >= 3.1) material #else texture #end { Color326 } }
	mesh {
		triangle { <-11,-8,-10>, <-17,-11,-10>, <17,-11,-10> }
		triangle { <17,-11,-10>, <11,-8,-10>, <-11,-8,-10> }
		triangle { <11,-8,-10>, <17,-11,-10>, <17,-4,-10> }
		triangle { <11,-8,-10>, <17,-4,-10>, <15,7,-10> }
		triangle { <15,7,-10>, <11,8,-10>, <11,-8,-10> }
		triangle { <11,8,-10>, <15,7,-10>, <12,14,-10> }
		triangle { <11,8,-10>, <12,14,-10>, <7,21,-10> }
		triangle { <7,21,-10>, <6.5,15,-10>, <11,8,-10> }
		triangle { <6.5,15,-10>, <7,21,-10>, <0,27,-10> }
		triangle { <0,27,-10>, <2,22,-10>, <6.5,15,-10> }
		triangle { <-11,-8,-10>, <-17,-11,-10>, <-17,-4,-10> }
		triangle { <-11,-8,-10>, <-17,-4,-10>, <-15,7,-10> }
		triangle { <-15,7,-10>, <-11,8,-10>, <-11,-8,-10> }
		triangle { <-11,8,-10>, <-15,7,-10>, <-12,14,-10> }
		triangle { <-11,8,-10>, <-12,14,-10>, <-7,21,-10> }
		triangle { <-7,21,-10>, <-6.5,15,-10>, <-11,8,-10> }
		triangle { <-6.5,15,-10>, <-7,21,-10>, <0,27,-10> }
		triangle { <0,27,-10>, <-2,22,-10>, <-6.5,15,-10> }
		triangle { <-2,22,-10>, <2,22,-10>, <0,27,-10> }
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
}
#end

#declare mobilehq_dot_dat = union {
// Mobile HQ Truck (a little juniorized)
	object {
		_3006_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,-50,176,110>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-70,200,28>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-30,200,28>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-70,200,228>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-30,200,228>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-70,200,308>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-30,200,308>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-70,200,388>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2654_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-30,200,388>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3660_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <0,0,-1,0,1,0,1,0,0,-60,176,430>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3660_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <0,0,1,0,1,0,-1,0,0,-40,176,430>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3006_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,-50,176,310>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-90,176,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,176,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-90,176,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,176,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-90,176,310>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,176,310>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-90,176,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6232_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,SW/6,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,176,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_4477_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,168,80>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3035_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/80,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-50,168,350>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3035_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/80,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-50,168,190>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3710_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,168,100>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2540_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/36,0,SW/6,SW/-4.5>
		matrix <-1,0,0,0,1,0,0,0,-1,-70,168,440>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2540_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/36,0,SW/6,SW/-4.5>
		matrix <-1,0,0,0,1,0,0,0,-1,-30,168,440>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3003_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-48,152,50>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <1,0,0,0,1,0,0,0,1,-70,152,20>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <1,0,0,0,1,0,0,0,1,-30,152,20>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-20,152,40>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-80,152,40>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}

	object {
		_3001_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,150>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3001_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3001_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,310>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3001_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3660_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,-30,144,440>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3660_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,-70,144,440>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,30>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,30>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,230>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,230>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,310>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,310>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,390>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_6248_dot_dat
		matrix <1-SW/44,0,0,0,1-SW/44,0,0,0,1-SW/23,0,0,SW/-15.3333>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,390>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,1,0,1,0,-1,0,0,-20,144,110>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,-1,0,1,0,1,0,0,-80,144,110>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,1,0,1,0,-1,0,0,-20,144,190>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,-1,0,1,0,1,0,0,-80,144,190>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,1,0,1,0,-1,0,0,-20,144,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,-1,0,1,0,1,0,0,-80,144,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,1,0,1,0,-1,0,0,-20,144,350>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3747_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,-1,0,1,0,1,0,0,-80,144,350>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4287_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,1,0,1,0,-1,0,0,-20,144,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4287_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/60,0,SW/2.8,SW/-3>
		matrix <0,0,-1,0,1,0,1,0,0,-80,144,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3020_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,30>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3795_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,-10>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,60>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3010_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,144,80>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}

	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,30>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,30>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,230>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,230>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,310>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,310>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,-1,0,1,0,1,0,0,-120,186,390>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_2346_dot_dat
		matrix <1-SW/70,0,0,0,1-SW/70,0,0,0,1-SW/30,0,0,SW/-6>
		matrix <0,0,1,0,1,0,-1,0,0,20,186,390>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3665_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,40,144,80>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3665_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-140,144,80>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2436_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/24,0,0,0,1-SW/28,0,SW/3,SW/-7>
		matrix <1,0,0,0,1,0,0,0,1,-90,136,-20>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2436_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/24,0,0,0,1-SW/28,0,SW/3,SW/-7>
		matrix <1,0,0,0,1,0,0,0,1,-10,136,-20>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3020_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,136,450>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3832_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,136,410>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3033_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/120,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,136,130>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3033_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/120,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,136,330>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3030_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/80,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,136,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,30,136,-20>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,136,-20>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3030_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/80,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,136,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3665_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,40,144,-20>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3665_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,-140,144,-20>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_4477_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,168,-20>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_3832_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,0,1,0,-1,0,-50,156,-42>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3665_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,0,112,418.39>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3665_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,-100,112,418.39>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3010_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,112,10>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3010_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,-140,112,10>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6111_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,112,60>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3008_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,112,-20>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3829_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/46.72,0,0,0,1-SW/23.44,0,SW/-3.04167,SW/-13.6279>
		matrix <1,0,0,0,1,0,0,0,1,6,128,0>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}

	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,40,112,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-140,112,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,-120,112,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <-1,0,0,0,1,0,0,0,-1,20,112,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,-1,0,1,0,40,122,434>
		#if (ver >= 3.1) material #else texture #end { Color36 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,-1,0,1,0,-140,122,434>
		#if (ver >= 3.1) material #else texture #end { Color36 }
	}
	object {
		_2555_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/18,0,0,0,1-SW/20,0,SW/-18,0>
		matrix <1,0,0,0,0,-1,0,1,0,-120,122,435>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2555_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/18,0,0,0,1-SW/20,0,SW/-18,0>
		matrix <1,0,0,0,0,-1,0,1,0,20,122,435>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_2569_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/192,0,0,0,1-SW/16,0,SW/-2.18182,0>
		matrix <1,0,0,0,1,0,0,0,1,20,136,440>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2569_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/192,0,0,0,1-SW/16,0,SW/-2.18182,0>
		matrix <1,0,0,0,1,0,0,0,1,-120,136,440>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,320>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,340>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,360>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,380>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,400>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,320>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,340>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,360>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,380>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,400>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,280>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,260>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,240>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,220>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,200>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,180>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,160>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,112,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,160>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,180>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,200>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,220>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,240>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,260>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,280>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_30136_dot_dat
		matrix <1-SW/40.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,112,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,30,64,100>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-10,64,100>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-50,64,100>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-90,64,100>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-130,64,100>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3069_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,1,0,-1,0,-130,146,-50>
		#if (ver >= 3.1) material #else texture #end { Color46 }
	}
	object {
		_6636_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,1,0,-1,0,-50,146,-50>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3069_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,1,0,-1,0,30,146,-50>
		#if (ver >= 3.1) material #else texture #end { Color46 }
	}
	object {
		_2431_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,1,0,-1,0,-110,166,-50>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3069_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,1,0,-1,0,-50,166,-50>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2431_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,0,1,0,-1,0,10,166,-50>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3666_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,104,-20>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3666_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,96,-20>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}

	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <0,0,1,0,1,0,-1,0,0,20,40,410>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <0,0,-1,0,1,0,1,0,0,-120,40,410>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <0,0,1,0,1,0,-1,0,0,20,40,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <0,0,-1,0,1,0,1,0,0,-120,40,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <0,0,1,0,1,0,-1,0,0,20,40,330>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3684_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/76,0,0,0,1-SW/40,0,SW/2.23529,SW/-4>
		matrix <0,0,-1,0,1,0,1,0,0,-120,40,330>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_4175_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/28,0,SW/2.36364,SW/-7>
		matrix <1,0,0,0,1,0,0,0,1,-50,88,-20>
		#if (ver >= 3.1) material #else texture #end { Color383 }
	}
	object {
		_4175_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/28,0,SW/2.36364,SW/-7>
		matrix <1,0,0,0,1,0,0,0,1,-90,88,-20>
		#if (ver >= 3.1) material #else texture #end { Color383 }
	}
	object {
		_4175_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/28,0,SW/2.36364,SW/-7>
		matrix <1,0,0,0,1,0,0,0,1,-10,88,-20>
		#if (ver >= 3.1) material #else texture #end { Color383 }
	}

	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,88,280>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_30137_dot_dat
		matrix <1-SW/80.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,40,88,150>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_30137_dot_dat
		matrix <1-SW/80.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,88,150>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_30137_dot_dat
		matrix <1-SW/80.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,40,88,230>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_30137_dot_dat
		matrix <1-SW/80.002,0,0,0,1-SW/28,0,0,0,1-SW/28.284,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,88,230>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,88,280>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,88,300>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_4070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,88,300>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3004_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,88,-20>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3004_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,88,-20>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_2653_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,88,30>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_2653_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,88,30>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_3008_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,88,60>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}

	object {
		_3039p23_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <0,0,1,0,1,0,-1,0,0,-120,88,250>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3039p23_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <0,0,1,0,1,0,-1,0,0,-120,88,170>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3039p34_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40.0004,0,SW/2.8,SW/-3.99996>
		matrix <0,0,1,0,1,0,-1,0,0,-120,88,210>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3039p23_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <0,0,-1,0,1,0,1,0,0,20,88,170>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3039p23_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <0,0,-1,0,1,0,1,0,0,20,88,250>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3039p34_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40.0004,0,SW/2.8,SW/-3.99996>
		matrix <0,0,-1,0,1,0,1,0,0,20,88,210>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}

	object {
		_2420_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,SW/4,SW/6,SW/4>
		matrix <1,0,0,0,1,0,0,0,1,0,32,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2420_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,SW/4,SW/6,SW/4>
		matrix <0,0,1,0,1,0,-1,0,0,-100,32,420>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3710_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,20,32,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3710_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-120,32,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3460_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,32,320>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-120,88,300>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,20,88,300>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}

	object {
		_2730_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,40,64,210>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2730_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,64,210>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6111_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,64,60>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3004p05_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,64,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3004p05_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,64,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2412_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,1,-1,0,0,0,-1,0,54,98,290>
		#if (ver >= 3.1) material #else texture #end { Color383 }
	}
	object {
		_2412_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,1,1,0,0,0,1,0,-154,98,290>
		#if (ver >= 3.1) material #else texture #end { Color383 }
	}

	object {
		_3308_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/52.11,0,0,0,1-SW/20,0,SW/2.36273,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,40,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3005_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,40,40,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3005_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-140,40,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3005_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,40,40,180>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3005_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,40,40,240>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3005_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-140,40,240>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3005_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-140,40,180>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3036_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/120,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,24,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6111_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,40,60>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3823_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-110,40,0>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_3823_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,10,40,0>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,-1,0,1,0,1,0,0,40,40,30>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,1,0,1,0,-1,0,0,-140,40,30>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,40,270>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,40,150>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,40,150>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,40,210>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,-1,0,1,0,1,0,0,-140,40,210>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_4865_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,40,270>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}
	object {
		_3678_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-50,40,0>
		#if (ver >= 3.1) material #else texture #end { Color39 }
	}

	object {
		_3623_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,1,0,0,0,1,0,50,74,150>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3666_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,1,0,0,0,1,0,50,74,238>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3623_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,-1,0,0,0,-1,0,-150,74,150>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3666_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,-1,0,0,0,-1,0,-150,74,238>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3678_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,30,16,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3678_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-130,16,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3678_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-90,16,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3678_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-50,16,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3678_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-10,16,120>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3660p01_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-90,16,300>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3660p01_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-50,16,300>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3660p01_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-10,16,300>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_3004_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,30,16,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3004_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,16,300>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3460_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-140,32,210>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3460_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,32,210>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3460_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-140,24,210>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3460_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,24,210>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6179_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/80,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-110,32,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6179_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/80,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-30,32,30>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,30,32,50>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3680_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,30,32,10>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3679_dot_dat
		matrix <1-SW/32,0,0,0,1-SW/12,0,0,0,1-SW/32,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,30,32,10>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_4315_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/28,0,SW/6,SW/-7>
		matrix <0,0,-1,0,1,0,1,0,0,-140,16,250>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4315_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/28,0,SW/6,SW/-7>
		matrix <0,0,1,0,1,0,-1,0,0,40,16,250>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4315_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/28,0,SW/6,SW/-7>
		matrix <0,0,1,0,1,0,-1,0,0,40,16,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4315_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/28,0,SW/6,SW/-7>
		matrix <0,0,-1,0,1,0,1,0,0,-140,16,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4032_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,30,24,10>
		#if (ver >= 3.1) material #else texture #end { Color383 }
	}
	object {
		_4162_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-70,16,320>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-90,16,410>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,16,410>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,16,410>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,16,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-90,16,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4162_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,16,340>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3022_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,16,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3710_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,-1,0,1,0,1,0,0,-120,16,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3710_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,-1,0,1,0,1,0,0,20,16,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,30,16,0>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_3006_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-8,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_6212_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/28,0,0,0,1-SW/80,0,SW/2.8,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-8,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2444_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/40,0,SW/3,0>
		matrix <0,0,-1,0,1,0,1,0,0,30,8,-10>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3039_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,30,0,20>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3039p05_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-50,-8,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,30,0,-10>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3062b_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/20,0,SW/2.8,0>
		matrix <1,0,0,0,0,-1,0,1,0,30,20,-30>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3038_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,20,-8,280>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3037_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-8,280>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3038_dot_dat
		matrix <1-SW/60,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <-1,0,0,0,1,0,0,0,-1,-120,-8,280>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-120,-8,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-20,-8,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-80,-8,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,20,-8,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,0,8,130>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,40,8,130>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-100,8,130>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3023_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/20,0,SW/6,0>
		matrix <0,0,1,0,1,0,-1,0,0,-140,8,130>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_4274_dot_dat
		matrix <1-SW/24,0,0,0,1-SW/16,0,0,0,1-SW/16,SW/-3,0,0>
		matrix <0,0,-1,0,1,0,1,0,0,30,20,-56>
		#if (ver >= 3.1) material #else texture #end { Color0 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-140,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,-100,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,0,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3040_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/28,0,0,0,1-SW/40,0,SW/2.8,SW/-4>
		matrix <1,0,0,0,1,0,0,0,1,40,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2431p52_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,-1,0,1,0,1,0,0,20,8,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2431p52_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0,0,-1,0,1,0,1,0,0,-120,8,390>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3022_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,8,370>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4150_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,8,450>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_4285_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/20,0,0,0,1-SW/120,0,SW/3.33333,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,0,370>
		#if (ver >= 3.1) material #else texture #end { Color2 }
	}
	object {
		_4623_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/36,0,SW/-6,SW/-4.5>
		matrix <1,0,0,0,1,0,0,0,1,-50,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-140,-24,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-100,-24,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,0,-24,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,40,-24,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,20,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-20,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-80,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3070_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-120,-16,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3832_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-16,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3832_dot_dat
		matrix <1-SW/200,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-16,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2431_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,10,-16,200>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2431_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-110,-16,200>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2412_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-16,200>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,30,-16,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,-16,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-16,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-90,-16,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,-16,270>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_3680_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-24,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3679_dot_dat
		matrix <1-SW/32,0,0,0,1-SW/12,0,0,0,1-SW/32,0,SW/6,0>
		matrix <0.707107,0,-0.707107,0,1,0,0.707107,0,0.707107,-50,-24,230>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3068p07_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,-24,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068p07_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-90,-24,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,30,-24,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,-24,230>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-130,-24,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-90,-24,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-24,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,-24,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_3068_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/40,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,30,-24,170>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_2412_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/8,0,0,0,1-SW/20,0,SW/2,0>
		matrix <1,0,0,0,1,0,0,0,1,-50,-24,140>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}

	object {
		_4032_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/12,0,0,0,1-SW/40,0,SW/6,0>
		matrix <0.707107,0,-0.707107,0,1,0,0.707107,0,0.707107,-50,-32,230>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2440p69_dot_dat
		matrix <1-SW/120,0,0,0,1-SW/22.6,0,0,0,1-SW/60,0,SW/5.25581,0>
		matrix <0.965926,0,0.258819,-0.258819,0,0.965926,0,-1,0,-48,-40,109>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_6039_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/44,0,0,0,1-SW/40,0,SW/2.44444,0>
		matrix <0.707107,0,-0.707107,0,1,0,0.707107,0,0.707107,-50,-72,230>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2555_dot_dat
		matrix <1-SW/20,0,0,0,1-SW/18,0,0,0,1-SW/20,0,SW/-18,0>
		matrix <0.707107,0,0.707107,0,1,0,-0.707107,0,0.707107,-50,-80,230>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_2432_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/32,0,0,0,1-SW/20,0,SW/2,0>
		matrix <-0.707107,0,0.707107,-0.612372,-0.5,-0.612372,0.353553,-0.866025,0.353553,-49,-78,231>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_298_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/13.58,0,0,0,1-SW/16,0,SW/11.2231,0>
		matrix <1,0,0,0,1,0,0,0,1,0,24,440>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_298_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/13.58,0,0,0,1-SW/16,0,SW/11.2231,0>
		matrix <1,0,0,0,1,0,0,0,1,-100,24,440>
		#if (ver >= 3.1) material #else texture #end { Color6 }
	}
	object {
		_4593_dot_dat
		matrix <1-SW/8,0,0,0,1-SW/42,0,0,0,1-SW/8,0,SW/-2.47059,0>
		matrix <1,0,0,0,1,0,0,0,1,0,24,440>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_4593_dot_dat
		matrix <1-SW/8,0,0,0,1-SW/42,0,0,0,1-SW/8,0,SW/-2.47059,0>
		matrix <1,0,0,0,1,0,0,0,1,-100,24,440>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_298_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/13.58,0,0,0,1-SW/16,0,SW/11.2231,0>
		matrix <1,0,0,0,1,0,0,0,1,-22,8,440>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_298_dot_dat
		matrix <1-SW/16,0,0,0,1-SW/13.58,0,0,0,1-SW/16,0,SW/11.2231,0>
		matrix <1,0,0,0,1,0,0,0,1,-78,8,440>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_3961_dot_dat
		matrix <1-SW/160,0,0,0,1-SW/28,0,0,0,1-SW/160,0,SW/2.8,0>
		matrix <0.707107,0,-0.707107,-0.612372,-0.5,-0.612372,-0.353553,0.866025,-0.353553,-65,-102,215>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3048_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/24,0,0,0,1-SW/20,0,SW/2,0>
		matrix <0.707107,0,-0.707107,-0.612372,-0.5,-0.612372,-0.353553,0.866025,-0.353553,-47,-99,233>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}

	object {
		_3940_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/52,0,0,0,1-SW/40,0,SW/2.36364,0>
		matrix <0.707107,0,-0.707107,-0.612372,-0.5,-0.612372,-0.353553,0.866025,-0.353553,-70,-106,210>
		#if (ver >= 3.1) material #else texture #end { Color7 }
	}
	object {
		_2873_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/48,0,SW/2,SW/12>
		matrix <0,0,1,1,0,0,0,1,0,50,-4,170>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2873_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/48,0,SW/2,SW/12>
		matrix <0,0,1,0.965926,0.258819,0,-0.258819,0.965926,0,57,-4,250>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2873_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/48,0,SW/2,SW/12>
		matrix <0,0,-1,-1,0,0,0,1,0,-150,-4,170>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_2873_dot_dat
		matrix <1-SW/80,0,0,0,1-SW/8,0,0,0,1-SW/48,0,SW/2,SW/12>
		matrix <0,0,-1,-1,0,0,0,1,0,-150,-4,250>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
	object {
		_3846p44_dot_dat
		matrix <1-SW/40,0,0,0,1-SW/46.37,0,0,0,1-SW/24,0,SW/5.04845,SW/12>
		matrix <1,0,0,0,1,0,0,0,1,-49,145,-42>
		#if (ver >= 3.1) material #else texture #end { Color8 }
	}
}

#ifndef (Color0x02333333)
#declare Color0x02333333 = #if (ver >= 3.1) material { #end texture {
	pigment { rgb <0.2,0.2,0.2> }
	finish { ambient AMB diffuse DIF }
	#if (QUAL > 1)
		finish { phong 0.5 phong_size 40 reflection 0.08 }
		#if (BUMPS) normal { BUMPNORMAL } #end
	#end
} #if (ver >= 3.1) } #end
#end

#declare _32018_dot_dat = #if (QUAL = 0) box { <-140,-4,-10>, <140,24,10> } #else union {
// Technic Brick  1 x 14 with Holes
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,120,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,100,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,80,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,60,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,40,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,20,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,0,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-20,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-40,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-60,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-80,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-100,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-120,18,0> }
	#end
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,120,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,120,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,100,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,100,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,80,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,80,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,60,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,60,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,40,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,40,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,20,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,20,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,0,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,0,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-20,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-20,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-40,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-40,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-60,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-60,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-80,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-80,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-100,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-100,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-120,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-120,10,-10> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,110,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,90,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,70,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,50,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,30,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,10,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-10,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-30,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-50,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-70,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-90,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-110,4,0> }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,6,132,4,0> }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,6,-132,4,0> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,120,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,100,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,80,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,60,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,40,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,20,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,0,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-20,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-40,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-60,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-80,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-100,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-120,10,6> }
	mesh {
		triangle { <128,10,6>, <128,4,6>, <128,4,-6> }
		triangle { <128,4,-6>, <128,10,-6>, <128,10,6> }
		triangle { <112,10,6>, <112,4,6>, <112,4,-6> }
		triangle { <112,4,-6>, <112,10,-6>, <112,10,6> }
		triangle { <108,10,6>, <108,4,6>, <108,4,-6> }
		triangle { <108,4,-6>, <108,10,-6>, <108,10,6> }
		triangle { <92,10,6>, <92,4,6>, <92,4,-6> }
		triangle { <92,4,-6>, <92,10,-6>, <92,10,6> }
		triangle { <88,10,6>, <88,4,6>, <88,4,-6> }
		triangle { <88,4,-6>, <88,10,-6>, <88,10,6> }
		triangle { <72,10,6>, <72,4,6>, <72,4,-6> }
		triangle { <72,4,-6>, <72,10,-6>, <72,10,6> }
		triangle { <68,10,6>, <68,4,6>, <68,4,-6> }
		triangle { <68,4,-6>, <68,10,-6>, <68,10,6> }
		triangle { <52,10,6>, <52,4,6>, <52,4,-6> }
		triangle { <52,4,-6>, <52,10,-6>, <52,10,6> }
		triangle { <48,10,6>, <48,4,6>, <48,4,-6> }
		triangle { <48,4,-6>, <48,10,-6>, <48,10,6> }
		triangle { <32,10,6>, <32,4,6>, <32,4,-6> }
		triangle { <32,4,-6>, <32,10,-6>, <32,10,6> }
		triangle { <28,10,6>, <28,4,6>, <28,4,-6> }
		triangle { <28,4,-6>, <28,10,-6>, <28,10,6> }
		triangle { <12,10,6>, <12,4,6>, <12,4,-6> }
		triangle { <12,4,-6>, <12,10,-6>, <12,10,6> }
		triangle { <8,10,6>, <8,4,6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,10,-6>, <8,10,6> }
		triangle { <-8,10,6>, <-8,4,6>, <-8,4,-6> }
		triangle { <-8,4,-6>, <-8,10,-6>, <-8,10,6> }
		triangle { <-12,10,6>, <-12,4,6>, <-12,4,-6> }
		triangle { <-12,4,-6>, <-12,10,-6>, <-12,10,6> }
		triangle { <-28,10,6>, <-28,4,6>, <-28,4,-6> }
		triangle { <-28,4,-6>, <-28,10,-6>, <-28,10,6> }
		triangle { <-32,10,6>, <-32,4,6>, <-32,4,-6> }
		triangle { <-32,4,-6>, <-32,10,-6>, <-32,10,6> }
		triangle { <-48,10,6>, <-48,4,6>, <-48,4,-6> }
		triangle { <-48,4,-6>, <-48,10,-6>, <-48,10,6> }
		triangle { <-52,10,6>, <-52,4,6>, <-52,4,-6> }
		triangle { <-52,4,-6>, <-52,10,-6>, <-52,10,6> }
		triangle { <-68,10,6>, <-68,4,6>, <-68,4,-6> }
		triangle { <-68,4,-6>, <-68,10,-6>, <-68,10,6> }
		triangle { <-72,10,6>, <-72,4,6>, <-72,4,-6> }
		triangle { <-72,4,-6>, <-72,10,-6>, <-72,10,6> }
		triangle { <-88,10,6>, <-88,4,6>, <-88,4,-6> }
		triangle { <-88,4,-6>, <-88,10,-6>, <-88,10,6> }
		triangle { <-92,10,6>, <-92,4,6>, <-92,4,-6> }
		triangle { <-92,4,-6>, <-92,10,-6>, <-92,10,6> }
		triangle { <-108,10,6>, <-108,4,6>, <-108,4,-6> }
		triangle { <-108,4,-6>, <-108,10,-6>, <-108,10,6> }
		triangle { <-112,10,6>, <-112,4,6>, <-112,4,-6> }
		triangle { <-112,4,-6>, <-112,10,-6>, <-112,10,6> }
		triangle { <-128,10,6>, <-128,4,6>, <-128,4,-6> }
		triangle { <-128,4,-6>, <-128,10,-6>, <-128,10,6> }
		triangle { <136,24,6>, <136,4,6>, <136,4,-6> }
		triangle { <136,4,-6>, <136,24,-6>, <136,24,6> }
		triangle { <-136,24,6>, <-136,4,6>, <-136,4,-6> }
		triangle { <-136,4,-6>, <-136,24,-6>, <-136,24,6> }
	}
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,120,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,120,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,100,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,100,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-100,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-100,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-120,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-120,10,-6> }
	mesh {
		triangle { <112,18,6>, <112,4,6>, <108,4,6> }
		triangle { <108,4,6>, <108,18,6>, <112,18,6> }
		triangle { <112,18,-6>, <112,4,-6>, <108,4,-6> }
		triangle { <108,4,-6>, <108,18,-6>, <112,18,-6> }
		triangle { <92,18,6>, <92,4,6>, <88,4,6> }
		triangle { <88,4,6>, <88,18,6>, <92,18,6> }
		triangle { <92,18,-6>, <92,4,-6>, <88,4,-6> }
		triangle { <88,4,-6>, <88,18,-6>, <92,18,-6> }
		triangle { <72,18,6>, <72,4,6>, <68,4,6> }
		triangle { <68,4,6>, <68,18,6>, <72,18,6> }
		triangle { <72,18,-6>, <72,4,-6>, <68,4,-6> }
		triangle { <68,4,-6>, <68,18,-6>, <72,18,-6> }
		triangle { <52,18,6>, <52,4,6>, <48,4,6> }
		triangle { <48,4,6>, <48,18,6>, <52,18,6> }
		triangle { <52,18,-6>, <52,4,-6>, <48,4,-6> }
		triangle { <48,4,-6>, <48,18,-6>, <52,18,-6> }
		triangle { <32,18,6>, <32,4,6>, <28,4,6> }
		triangle { <28,4,6>, <28,18,6>, <32,18,6> }
		triangle { <32,18,-6>, <32,4,-6>, <28,4,-6> }
		triangle { <28,4,-6>, <28,18,-6>, <32,18,-6> }
		triangle { <12,18,6>, <12,4,6>, <8,4,6> }
		triangle { <8,4,6>, <8,18,6>, <12,18,6> }
		triangle { <12,18,-6>, <12,4,-6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,18,-6>, <12,18,-6> }
		triangle { <-8,18,6>, <-8,4,6>, <-12,4,6> }
		triangle { <-12,4,6>, <-12,18,6>, <-8,18,6> }
		triangle { <-8,18,-6>, <-8,4,-6>, <-12,4,-6> }
		triangle { <-12,4,-6>, <-12,18,-6>, <-8,18,-6> }
		triangle { <-28,18,6>, <-28,4,6>, <-32,4,6> }
		triangle { <-32,4,6>, <-32,18,6>, <-28,18,6> }
		triangle { <-28,18,-6>, <-28,4,-6>, <-32,4,-6> }
		triangle { <-32,4,-6>, <-32,18,-6>, <-28,18,-6> }
		triangle { <-48,18,6>, <-48,4,6>, <-52,4,6> }
		triangle { <-52,4,6>, <-52,18,6>, <-48,18,6> }
		triangle { <-48,18,-6>, <-48,4,-6>, <-52,4,-6> }
		triangle { <-52,4,-6>, <-52,18,-6>, <-48,18,-6> }
		triangle { <-68,18,6>, <-68,4,6>, <-72,4,6> }
		triangle { <-72,4,6>, <-72,18,6>, <-68,18,6> }
		triangle { <-68,18,-6>, <-68,4,-6>, <-72,4,-6> }
		triangle { <-72,4,-6>, <-72,18,-6>, <-68,18,-6> }
		triangle { <-88,18,6>, <-88,4,6>, <-92,4,6> }
		triangle { <-92,4,6>, <-92,18,6>, <-88,18,6> }
		triangle { <-88,18,-6>, <-88,4,-6>, <-92,4,-6> }
		triangle { <-92,4,-6>, <-92,18,-6>, <-88,18,-6> }
		triangle { <-108,18,6>, <-108,4,6>, <-112,4,6> }
		triangle { <-112,4,6>, <-112,18,6>, <-108,18,6> }
		triangle { <-108,18,-6>, <-108,4,-6>, <-112,4,-6> }
		triangle { <-112,4,-6>, <-112,18,-6>, <-108,18,-6> }
		triangle { <136,24,6>, <136,4,6>, <128,4,6> }
		triangle { <128,4,6>, <128,18,6>, <136,24,6> }
		triangle { <136,24,-6>, <136,4,-6>, <128,4,-6> }
		triangle { <128,4,-6>, <128,18,-6>, <136,24,-6> }
		triangle { <-128,18,6>, <-128,4,6>, <-136,4,6> }
		triangle { <-136,4,6>, <-136,24,6>, <-128,18,6> }
		triangle { <-128,18,-6>, <-128,4,-6>, <-136,4,-6> }
		triangle { <-136,4,-6>, <-136,24,-6>, <-128,18,-6> }
		triangle { <136,24,6>, <128,18,6>, <-128,18,6> }
		triangle { <-128,18,6>, <-136,24,6>, <136,24,6> }
		triangle { <136,24,-6>, <128,18,-6>, <-128,18,-6> }
		triangle { <-128,18,-6>, <-136,24,-6>, <136,24,-6> }
		triangle { <140,24,10>, <136,24,6>, <-136,24,6> }
		triangle { <-136,24,6>, <-140,24,10>, <140,24,10> }
		triangle { <140,24,-10>, <136,24,-6>, <-136,24,-6> }
		triangle { <-136,24,-6>, <-140,24,-10>, <140,24,-10> }
		triangle { <140,24,10>, <136,24,6>, <136,24,-6> }
		triangle { <136,24,-6>, <140,24,-10>, <140,24,10> }
		triangle { <-140,24,10>, <-136,24,6>, <-136,24,-6> }
		triangle { <-136,24,-6>, <-140,24,-10>, <-140,24,10> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,120,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,100,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,80,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,60,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,40,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,20,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,0,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-20,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-40,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-60,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-80,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-100,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-120,10,8> }
	mesh {
		triangle { <140,24,10>, <140,0,10>, <140,0,-10> }
		triangle { <140,0,-10>, <140,24,-10>, <140,24,10> }
		triangle { <-140,24,10>, <-140,0,10>, <-140,0,-10> }
		triangle { <-140,0,-10>, <-140,24,-10>, <-140,24,10> }
		triangle { <140,0,10>, <140,0,-10>, <-140,0,-10> }
		triangle { <-140,0,-10>, <-140,0,10>, <140,0,10> }
	}
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,120,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,120,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,100,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,100,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,80,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,60,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,40,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-40,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-60,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-80,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-100,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-100,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-120,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-120,10,-10> }
	mesh {
		triangle { <112,18,10>, <112,2,10>, <108,2,10> }
		triangle { <108,2,10>, <108,18,10>, <112,18,10> }
		triangle { <112,18,-10>, <112,2,-10>, <108,2,-10> }
		triangle { <108,2,-10>, <108,18,-10>, <112,18,-10> }
		triangle { <92,18,10>, <92,2,10>, <88,2,10> }
		triangle { <88,2,10>, <88,18,10>, <92,18,10> }
		triangle { <92,18,-10>, <92,2,-10>, <88,2,-10> }
		triangle { <88,2,-10>, <88,18,-10>, <92,18,-10> }
		triangle { <72,18,10>, <72,2,10>, <68,2,10> }
		triangle { <68,2,10>, <68,18,10>, <72,18,10> }
		triangle { <72,18,-10>, <72,2,-10>, <68,2,-10> }
		triangle { <68,2,-10>, <68,18,-10>, <72,18,-10> }
		triangle { <52,18,10>, <52,2,10>, <48,2,10> }
		triangle { <48,2,10>, <48,18,10>, <52,18,10> }
		triangle { <52,18,-10>, <52,2,-10>, <48,2,-10> }
		triangle { <48,2,-10>, <48,18,-10>, <52,18,-10> }
		triangle { <32,18,10>, <32,2,10>, <28,2,10> }
		triangle { <28,2,10>, <28,18,10>, <32,18,10> }
		triangle { <32,18,-10>, <32,2,-10>, <28,2,-10> }
		triangle { <28,2,-10>, <28,18,-10>, <32,18,-10> }
		triangle { <12,18,10>, <12,2,10>, <8,2,10> }
		triangle { <8,2,10>, <8,18,10>, <12,18,10> }
		triangle { <12,18,-10>, <12,2,-10>, <8,2,-10> }
		triangle { <8,2,-10>, <8,18,-10>, <12,18,-10> }
		triangle { <-8,18,10>, <-8,2,10>, <-12,2,10> }
		triangle { <-12,2,10>, <-12,18,10>, <-8,18,10> }
		triangle { <-8,18,-10>, <-8,2,-10>, <-12,2,-10> }
		triangle { <-12,2,-10>, <-12,18,-10>, <-8,18,-10> }
		triangle { <-28,18,10>, <-28,2,10>, <-32,2,10> }
		triangle { <-32,2,10>, <-32,18,10>, <-28,18,10> }
		triangle { <-28,18,-10>, <-28,2,-10>, <-32,2,-10> }
		triangle { <-32,2,-10>, <-32,18,-10>, <-28,18,-10> }
		triangle { <-48,18,10>, <-48,2,10>, <-52,2,10> }
		triangle { <-52,2,10>, <-52,18,10>, <-48,18,10> }
		triangle { <-48,18,-10>, <-48,2,-10>, <-52,2,-10> }
		triangle { <-52,2,-10>, <-52,18,-10>, <-48,18,-10> }
		triangle { <-68,18,10>, <-68,2,10>, <-72,2,10> }
		triangle { <-72,2,10>, <-72,18,10>, <-68,18,10> }
		triangle { <-68,18,-10>, <-68,2,-10>, <-72,2,-10> }
		triangle { <-72,2,-10>, <-72,18,-10>, <-68,18,-10> }
		triangle { <-88,18,10>, <-88,2,10>, <-92,2,10> }
		triangle { <-92,2,10>, <-92,18,10>, <-88,18,10> }
		triangle { <-88,18,-10>, <-88,2,-10>, <-92,2,-10> }
		triangle { <-92,2,-10>, <-92,18,-10>, <-88,18,-10> }
		triangle { <-108,18,10>, <-108,2,10>, <-112,2,10> }
		triangle { <-112,2,10>, <-112,18,10>, <-108,18,10> }
		triangle { <-108,18,-10>, <-108,2,-10>, <-112,2,-10> }
		triangle { <-112,2,-10>, <-112,18,-10>, <-108,18,-10> }
		triangle { <140,24,10>, <128,18,10>, <-128,18,10> }
		triangle { <-128,18,10>, <-140,24,10>, <140,24,10> }
		triangle { <140,24,-10>, <128,18,-10>, <-128,18,-10> }
		triangle { <-128,18,-10>, <-140,24,-10>, <140,24,-10> }
		triangle { <140,0,10>, <128,2,10>, <-128,2,10> }
		triangle { <-128,2,10>, <-140,0,10>, <140,0,10> }
		triangle { <140,0,-10>, <128,2,-10>, <-128,2,-10> }
		triangle { <-128,2,-10>, <-140,0,-10>, <140,0,-10> }
		triangle { <140,24,10>, <128,18,10>, <128,2,10> }
		triangle { <128,2,10>, <140,0,10>, <140,24,10> }
		triangle { <140,24,-10>, <128,18,-10>, <128,2,-10> }
		triangle { <128,2,-10>, <140,0,-10>, <140,24,-10> }
		triangle { <-140,24,10>, <-128,18,10>, <-128,2,10> }
		triangle { <-128,2,10>, <-140,0,10>, <-140,24,10> }
		triangle { <-140,24,-10>, <-128,18,-10>, <-128,2,-10> }
		triangle { <-128,2,-10>, <-140,0,-10>, <-140,24,-10> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,130,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,110,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-110,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-130,0,0> }
	#end
}
#end

#declare tri3_dot_dat = object {
	mesh {
		triangle { <1,1,0>, <0,1,1>, <0,0,1> }
		triangle { <0,0,1>, <1,0,0>, <1,1,0> }
		triangle { <0,1,1>, <0,1,0>, <0,0,0> }
		triangle { <0,0,0>, <0,0,1>, <0,1,1> }
		triangle { <0,1,0>, <1,1,0>, <1,0,0> }
		triangle { <1,0,0>, <0,0,0>, <0,1,0> }
	}
}

#declare _4151_dot_dat = #if (QUAL = 0) box { <-80,-4,-80>, <80,8,80> } #else union {
// Plate  8 x  8 with Grille
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,60> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,60> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,40> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,40> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,20> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,20> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,-20> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,-20> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,-40> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,-40> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,70,4,-60> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-70,4,-60> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,-70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,-70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,-70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,-70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,-70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,-70> }
		object { stud3_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,-70> }
	#end
	object { box5_dot_dat matrix <16,0,0,0,-4,0,0,0,16,0,8,0> }
	object { box4_dot_dat matrix <64,0,0,0,-4,0,0,0,64,0,8,0> }
	object { box4_dot_dat matrix <76,0,0,0,-4,0,0,0,76,0,8,0> }
	object { box4_dot_dat matrix <80,0,0,0,-8,0,0,0,80,0,8,0> }
	mesh {
		triangle { <16,8,16>, <20,8,20>, <-20,8,20> }
		triangle { <-20,8,20>, <-16,8,16>, <16,8,16> }
		triangle { <-16,8,16>, <-20,8,20>, <-20,8,-20> }
		triangle { <-20,8,-20>, <-16,8,-16>, <-16,8,16> }
		triangle { <-16,8,-16>, <-20,8,-20>, <20,8,-20> }
		triangle { <20,8,-20>, <16,8,-16>, <-16,8,-16> }
		triangle { <16,8,-16>, <20,8,-20>, <20,8,20> }
		triangle { <20,8,20>, <16,8,16>, <16,8,-16> }
		triangle { <60,8,60>, <64,8,64>, <-64,8,64> }
		triangle { <-64,8,64>, <-60,8,60>, <60,8,60> }
		triangle { <-60,8,60>, <-64,8,64>, <-64,8,-64> }
		triangle { <-64,8,-64>, <-60,8,-60>, <-60,8,60> }
		triangle { <-60,8,-60>, <-64,8,-64>, <64,8,-64> }
		triangle { <64,8,-64>, <60,8,-60>, <-60,8,-60> }
		triangle { <60,8,-60>, <64,8,-64>, <64,8,64> }
		triangle { <64,8,64>, <60,8,60>, <60,8,-60> }
		triangle { <76,8,76>, <80,8,80>, <-80,8,80> }
		triangle { <-80,8,80>, <-76,8,76>, <76,8,76> }
		triangle { <-76,8,76>, <-80,8,80>, <-80,8,-80> }
		triangle { <-80,8,-80>, <-76,8,-76>, <-76,8,76> }
		triangle { <-76,8,-76>, <-80,8,-80>, <80,8,-80> }
		triangle { <80,8,-80>, <76,8,-76>, <-76,8,-76> }
		triangle { <76,8,-76>, <80,8,-80>, <80,8,80> }
		triangle { <80,8,80>, <76,8,76>, <76,8,-76> }
		triangle { <64,4,64>, <76,4,76>, <-76,4,76> }
		triangle { <-76,4,76>, <-64,4,64>, <64,4,64> }
		triangle { <-64,4,64>, <-76,4,76>, <-76,4,-76> }
		triangle { <-76,4,-76>, <-64,4,-64>, <-64,4,64> }
		triangle { <-64,4,-64>, <-76,4,-76>, <76,4,-76> }
		triangle { <76,4,-76>, <64,4,-64>, <-64,4,-64> }
		triangle { <64,4,-64>, <76,4,-76>, <76,4,76> }
		triangle { <76,4,76>, <64,4,64>, <64,4,-64> }
		triangle { <60,0,60>, <80,0,80>, <-80,0,80> }
		triangle { <-80,0,80>, <-60,0,60>, <60,0,60> }
		triangle { <-60,0,60>, <-80,0,80>, <-80,0,-80> }
		triangle { <-80,0,-80>, <-60,0,-60>, <-60,0,60> }
		triangle { <-60,0,-60>, <-80,0,-80>, <80,0,-80> }
		triangle { <80,0,-80>, <60,0,-60>, <-60,0,-60> }
		triangle { <60,0,-60>, <80,0,-80>, <80,0,80> }
		triangle { <80,0,80>, <60,0,60>, <60,0,-60> }
		triangle { <20,0,20>, <-20,0,20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <20,0,-20>, <20,0,20> }
		triangle { <20,8,20>, <20,8,12>, <20,0,12> }
		triangle { <20,0,12>, <20,0,20>, <20,8,20> }
		triangle { <20,8,12>, <28,8,20>, <28,0,20> }
		triangle { <28,0,20>, <20,0,12>, <20,8,12> }
		triangle { <28,8,20>, <20,8,28>, <20,0,28> }
		triangle { <20,0,28>, <28,0,20>, <28,8,20> }
		triangle { <20,8,28>, <12,8,20>, <12,0,20> }
		triangle { <12,0,20>, <20,0,28>, <20,8,28> }
		triangle { <12,8,20>, <20,8,20>, <20,0,20> }
		triangle { <20,0,20>, <12,0,20>, <12,8,20> }
		triangle { <-20,8,20>, <-20,8,12>, <-20,0,12> }
		triangle { <-20,0,12>, <-20,0,20>, <-20,8,20> }
		triangle { <-20,8,12>, <-28,8,20>, <-28,0,20> }
		triangle { <-28,0,20>, <-20,0,12>, <-20,8,12> }
		triangle { <-28,8,20>, <-20,8,28>, <-20,0,28> }
		triangle { <-20,0,28>, <-28,0,20>, <-28,8,20> }
		triangle { <-20,8,28>, <-12,8,20>, <-12,0,20> }
		triangle { <-12,0,20>, <-20,0,28>, <-20,8,28> }
		triangle { <-12,8,20>, <-20,8,20>, <-20,0,20> }
		triangle { <-20,0,20>, <-12,0,20>, <-12,8,20> }
		triangle { <20,8,-20>, <20,8,-12>, <20,0,-12> }
		triangle { <20,0,-12>, <20,0,-20>, <20,8,-20> }
		triangle { <20,8,-12>, <28,8,-20>, <28,0,-20> }
		triangle { <28,0,-20>, <20,0,-12>, <20,8,-12> }
		triangle { <28,8,-20>, <20,8,-28>, <20,0,-28> }
		triangle { <20,0,-28>, <28,0,-20>, <28,8,-20> }
		triangle { <20,8,-28>, <12,8,-20>, <12,0,-20> }
		triangle { <12,0,-20>, <20,0,-28>, <20,8,-28> }
		triangle { <12,8,-20>, <20,8,-20>, <20,0,-20> }
		triangle { <20,0,-20>, <12,0,-20>, <12,8,-20> }
		triangle { <-20,8,-20>, <-20,8,-12>, <-20,0,-12> }
		triangle { <-20,0,-12>, <-20,0,-20>, <-20,8,-20> }
		triangle { <-20,8,-12>, <-28,8,-20>, <-28,0,-20> }
		triangle { <-28,0,-20>, <-20,0,-12>, <-20,8,-12> }
		triangle { <-28,8,-20>, <-20,8,-28>, <-20,0,-28> }
		triangle { <-20,0,-28>, <-28,0,-20>, <-28,8,-20> }
		triangle { <-20,8,-28>, <-12,8,-20>, <-12,0,-20> }
		triangle { <-12,0,-20>, <-20,0,-28>, <-20,8,-28> }
		triangle { <-12,8,-20>, <-20,8,-20>, <-20,0,-20> }
		triangle { <-20,0,-20>, <-12,0,-20>, <-12,8,-20> }
	}
	object { tri3_dot_dat matrix <-8,0,0,0,8,0,0,0,-8,60,0,60> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,-8,0,8,40,0,52> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,-8,0,8,20,0,52> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,-8,0,8,0,0,52> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,-8,0,8,-20,0,52> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,-8,0,8,-40,0,52> }
	object { tri3_dot_dat matrix <8,0,0,0,8,0,0,0,-8,-60,0,60> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,50,0,50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,30,0,50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,10,0,50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-10,0,50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-30,0,50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-50,0,50> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,8,0,-8,52,0,40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,40,0,40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,20,0,40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,0,0,40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-20,0,40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-40,0,40> }
	object { tri3_dot_dat matrix <-8,0,8,0,8,0,-8,0,-8,-52,0,40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,50,0,30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,30,0,30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,10,0,30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-10,0,30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-30,0,30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-50,0,30> }
	object { tri3_dot_dat matrix <8,0,-8,0,8,0,-8,0,-8,0,0,28> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,8,0,-8,52,0,20> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,40,0,20> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-40,0,20> }
	object { tri3_dot_dat matrix <-8,0,8,0,8,0,-8,0,-8,-52,0,20> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,50,0,10> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,30,0,10> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-30,0,10> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-50,0,10> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,8,0,-8,52,0,0> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,40,0,0> }
	object { tri3_dot_dat matrix <-8,0,8,0,8,0,-8,0,-8,28,0,0> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,8,0,-8,-28,0,0> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-40,0,0> }
	object { tri3_dot_dat matrix <-8,0,8,0,8,0,-8,0,-8,-52,0,0> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,50,0,-10> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,30,0,-10> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-30,0,-10> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-50,0,-10> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,8,0,-8,52,0,-20> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,40,0,-20> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-40,0,-20> }
	object { tri3_dot_dat matrix <-8,0,8,0,8,0,-8,0,-8,-52,0,-20> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,-8,0,8,0,0,-28> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,50,0,-30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,30,0,-30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,10,0,-30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-10,0,-30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-30,0,-30> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-50,0,-30> }
	object { tri3_dot_dat matrix <8,0,8,0,8,0,8,0,-8,52,0,-40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,40,0,-40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,20,0,-40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,0,0,-40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-20,0,-40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-40,0,-40> }
	object { tri3_dot_dat matrix <-8,0,8,0,8,0,-8,0,-8,-52,0,-40> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,50,0,-50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,30,0,-50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,10,0,-50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-10,0,-50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-30,0,-50> }
	object { box4_dot_dat matrix <4,0,4,0,8,0,4,0,-4,-50,0,-50> }
	object { tri3_dot_dat matrix <-8,0,0,0,8,0,0,0,8,60,0,-60> }
	object { tri3_dot_dat matrix <8,0,-8,0,8,0,-8,0,-8,40,0,-52> }
	object { tri3_dot_dat matrix <8,0,-8,0,8,0,-8,0,-8,20,0,-52> }
	object { tri3_dot_dat matrix <8,0,-8,0,8,0,-8,0,-8,0,0,-52> }
	object { tri3_dot_dat matrix <8,0,-8,0,8,0,-8,0,-8,-20,0,-52> }
	object { tri3_dot_dat matrix <8,0,-8,0,8,0,-8,0,-8,-40,0,-52> }
	object { tri3_dot_dat matrix <8,0,0,0,8,0,0,0,8,-60,0,-60> }
	mesh {
		triangle { <60,8,52>, <52,8,60>, <48,8,60> }
		triangle { <48,8,60>, <60,8,48>, <60,8,52> }
		triangle { <60,8,32>, <32,8,60>, <28,8,60> }
		triangle { <28,8,60>, <60,8,28>, <60,8,32> }
		triangle { <60,8,12>, <12,8,60>, <8,8,60> }
		triangle { <8,8,60>, <60,8,8>, <60,8,12> }
		triangle { <60,8,-8>, <-8,8,60>, <-12,8,60> }
		triangle { <-12,8,60>, <60,8,-12>, <60,8,-8> }
		triangle { <60,8,-28>, <20,8,12>, <20,8,8> }
		triangle { <20,8,8>, <60,8,-32>, <60,8,-28> }
		triangle { <-28,8,60>, <12,8,20>, <8,8,20> }
		triangle { <8,8,20>, <-32,8,60>, <-28,8,60> }
		triangle { <60,8,-48>, <20,8,-8>, <20,8,-12> }
		triangle { <20,8,-12>, <60,8,-52>, <60,8,-48> }
		triangle { <-48,8,60>, <-8,8,20>, <-12,8,20> }
		triangle { <-12,8,20>, <-52,8,60>, <-48,8,60> }
		triangle { <48,8,-60>, <8,8,-20>, <12,8,-20> }
		triangle { <12,8,-20>, <52,8,-60>, <48,8,-60> }
		triangle { <-60,8,48>, <-20,8,8>, <-20,8,12> }
		triangle { <-20,8,12>, <-60,8,52>, <-60,8,48> }
		triangle { <28,8,-60>, <-12,8,-20>, <-8,8,-20> }
		triangle { <-8,8,-20>, <32,8,-60>, <28,8,-60> }
		triangle { <-60,8,28>, <-20,8,-12>, <-20,8,-8> }
		triangle { <-20,8,-8>, <-60,8,32>, <-60,8,28> }
		triangle { <-60,8,8>, <8,8,-60>, <12,8,-60> }
		triangle { <12,8,-60>, <-60,8,12>, <-60,8,8> }
		triangle { <-60,8,-12>, <-12,8,-60>, <-8,8,-60> }
		triangle { <-8,8,-60>, <-60,8,-8>, <-60,8,-12> }
		triangle { <-60,8,-32>, <-32,8,-60>, <-28,8,-60> }
		triangle { <-28,8,-60>, <-60,8,-28>, <-60,8,-32> }
		triangle { <-60,8,-52>, <-52,8,-60>, <-48,8,-60> }
		triangle { <-48,8,-60>, <-60,8,-48>, <-60,8,-52> }
		triangle { <60,8,-52>, <52,8,-60>, <48,8,-60> }
		triangle { <48,8,-60>, <60,8,-48>, <60,8,-52> }
		triangle { <60,8,-32>, <32,8,-60>, <28,8,-60> }
		triangle { <28,8,-60>, <60,8,-28>, <60,8,-32> }
		triangle { <60,8,-12>, <12,8,-60>, <8,8,-60> }
		triangle { <8,8,-60>, <60,8,-8>, <60,8,-12> }
		triangle { <60,8,8>, <-8,8,-60>, <-12,8,-60> }
		triangle { <-12,8,-60>, <60,8,12>, <60,8,8> }
		triangle { <60,8,28>, <20,8,-12>, <20,8,-8> }
		triangle { <20,8,-8>, <60,8,32>, <60,8,28> }
		triangle { <-28,8,-60>, <12,8,-20>, <8,8,-20> }
		triangle { <8,8,-20>, <-32,8,-60>, <-28,8,-60> }
		triangle { <60,8,48>, <20,8,8>, <20,8,12> }
		triangle { <20,8,12>, <60,8,52>, <60,8,48> }
		triangle { <-48,8,-60>, <-8,8,-20>, <-12,8,-20> }
		triangle { <-12,8,-20>, <-52,8,-60>, <-48,8,-60> }
		triangle { <48,8,60>, <8,8,20>, <12,8,20> }
		triangle { <12,8,20>, <52,8,60>, <48,8,60> }
		triangle { <-60,8,-48>, <-20,8,-8>, <-20,8,-12> }
		triangle { <-20,8,-12>, <-60,8,-52>, <-60,8,-48> }
		triangle { <28,8,60>, <-12,8,20>, <-8,8,20> }
		triangle { <-8,8,20>, <32,8,60>, <28,8,60> }
		triangle { <-60,8,-28>, <-20,8,12>, <-20,8,8> }
		triangle { <-20,8,8>, <-60,8,-32>, <-60,8,-28> }
		triangle { <-60,8,-8>, <8,8,60>, <12,8,60> }
		triangle { <12,8,60>, <-60,8,-12>, <-60,8,-8> }
		triangle { <-60,8,12>, <-12,8,60>, <-8,8,60> }
		triangle { <-8,8,60>, <-60,8,8>, <-60,8,12> }
		triangle { <-60,8,32>, <-32,8,60>, <-28,8,60> }
		triangle { <-28,8,60>, <-60,8,28>, <-60,8,32> }
		triangle { <-60,8,52>, <-52,8,60>, <-48,8,60> }
		triangle { <-48,8,60>, <-60,8,48>, <-60,8,52> }
		triangle { <60,0,52>, <52,0,60>, <48,0,60> }
		triangle { <48,0,60>, <60,0,48>, <60,0,52> }
		triangle { <60,0,32>, <32,0,60>, <28,0,60> }
		triangle { <28,0,60>, <60,0,28>, <60,0,32> }
		triangle { <60,0,12>, <12,0,60>, <8,0,60> }
		triangle { <8,0,60>, <60,0,8>, <60,0,12> }
		triangle { <60,0,-8>, <-8,0,60>, <-12,0,60> }
		triangle { <-12,0,60>, <60,0,-12>, <60,0,-8> }
		triangle { <60,0,-28>, <20,0,12>, <20,0,8> }
		triangle { <20,0,8>, <60,0,-32>, <60,0,-28> }
		triangle { <-28,0,60>, <12,0,20>, <8,0,20> }
		triangle { <8,0,20>, <-32,0,60>, <-28,0,60> }
		triangle { <60,0,-48>, <20,0,-8>, <20,0,-12> }
		triangle { <20,0,-12>, <60,0,-52>, <60,0,-48> }
		triangle { <-48,0,60>, <-8,0,20>, <-12,0,20> }
		triangle { <-12,0,20>, <-52,0,60>, <-48,0,60> }
		triangle { <48,0,-60>, <8,0,-20>, <12,0,-20> }
		triangle { <12,0,-20>, <52,0,-60>, <48,0,-60> }
		triangle { <-60,0,48>, <-20,0,8>, <-20,0,12> }
		triangle { <-20,0,12>, <-60,0,52>, <-60,0,48> }
		triangle { <28,0,-60>, <-12,0,-20>, <-8,0,-20> }
		triangle { <-8,0,-20>, <32,0,-60>, <28,0,-60> }
		triangle { <-60,0,28>, <-20,0,-12>, <-20,0,-8> }
		triangle { <-20,0,-8>, <-60,0,32>, <-60,0,28> }
		triangle { <-60,0,8>, <8,0,-60>, <12,0,-60> }
		triangle { <12,0,-60>, <-60,0,12>, <-60,0,8> }
		triangle { <-60,0,-12>, <-12,0,-60>, <-8,0,-60> }
		triangle { <-8,0,-60>, <-60,0,-8>, <-60,0,-12> }
		triangle { <-60,0,-32>, <-32,0,-60>, <-28,0,-60> }
		triangle { <-28,0,-60>, <-60,0,-28>, <-60,0,-32> }
		triangle { <-60,0,-52>, <-52,0,-60>, <-48,0,-60> }
		triangle { <-48,0,-60>, <-60,0,-48>, <-60,0,-52> }
		triangle { <60,0,-52>, <52,0,-60>, <48,0,-60> }
		triangle { <48,0,-60>, <60,0,-48>, <60,0,-52> }
		triangle { <60,0,-32>, <32,0,-60>, <28,0,-60> }
		triangle { <28,0,-60>, <60,0,-28>, <60,0,-32> }
		triangle { <60,0,-12>, <12,0,-60>, <8,0,-60> }
		triangle { <8,0,-60>, <60,0,-8>, <60,0,-12> }
		triangle { <60,0,8>, <-8,0,-60>, <-12,0,-60> }
		triangle { <-12,0,-60>, <60,0,12>, <60,0,8> }
		triangle { <60,0,28>, <20,0,-12>, <20,0,-8> }
		triangle { <20,0,-8>, <60,0,32>, <60,0,28> }
		triangle { <-28,0,-60>, <12,0,-20>, <8,0,-20> }
		triangle { <8,0,-20>, <-32,0,-60>, <-28,0,-60> }
		triangle { <60,0,48>, <20,0,8>, <20,0,12> }
		triangle { <20,0,12>, <60,0,52>, <60,0,48> }
		triangle { <-48,0,-60>, <-8,0,-20>, <-12,0,-20> }
		triangle { <-12,0,-20>, <-52,0,-60>, <-48,0,-60> }
		triangle { <48,0,60>, <8,0,20>, <12,0,20> }
		triangle { <12,0,20>, <52,0,60>, <48,0,60> }
		triangle { <-60,0,-48>, <-20,0,-8>, <-20,0,-12> }
		triangle { <-20,0,-12>, <-60,0,-52>, <-60,0,-48> }
		triangle { <28,0,60>, <-12,0,20>, <-8,0,20> }
		triangle { <-8,0,20>, <32,0,60>, <28,0,60> }
		triangle { <-60,0,-28>, <-20,0,12>, <-20,0,8> }
		triangle { <-20,0,8>, <-60,0,-32>, <-60,0,-28> }
		triangle { <-60,0,-8>, <8,0,60>, <12,0,60> }
		triangle { <12,0,60>, <-60,0,-12>, <-60,0,-8> }
		triangle { <-60,0,12>, <-12,0,60>, <-8,0,60> }
		triangle { <-8,0,60>, <-60,0,8>, <-60,0,12> }
		triangle { <-60,0,32>, <-32,0,60>, <-28,0,60> }
		triangle { <-28,0,60>, <-60,0,28>, <-60,0,32> }
		triangle { <-60,0,52>, <-52,0,60>, <-48,0,60> }
		triangle { <-48,0,60>, <-60,0,48>, <-60,0,52> }
	}
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-30> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-50> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-70> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-70> }
	#end
}
#end

#declare _4459_dot_dat = #if (QUAL = 0) box { <-20,-8,-8>, <20,8,8> } #else union {
// Technic Pin with Friction
	object { connect_dot_dat matrix <0,0,1,1,0,0,0,1,0,0,0,0> }
	object { connect_dot_dat matrix <0,0,1,-1,0,0,0,1,0,0,0,0> }
}
#end

#declare _3701_dot_dat = #if (QUAL = 0) box { <-40,-4,-10>, <40,24,10> } #else union {
// Technic Brick  1 x  4 with Holes
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,20,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,0,18,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-1.5,0,0,0,1,-20,18,0> }
	#end
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,20,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,20,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,0,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,0,10,-10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,-1,0,1,0,-20,10,10> }
	object { peghole_dot_dat matrix <1,0,0,0,0,1,0,1,0,-20,10,-10> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,10,4,0> }
	object { rect_dot_dat matrix <2,0,0,0,1,0,0,0,6,-10,4,0> }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,6,32,4,0> }
	object { rect_dot_dat matrix <4,0,0,0,1,0,0,0,6,-32,4,0> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,20,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,0,10,6> }
	object { _2_dash_4cyli_dot_dat matrix <8,0,0,0,0,-12,0,8,0,-20,10,6> }
	mesh {
		triangle { <28,10,6>, <28,4,6>, <28,4,-6> }
		triangle { <28,4,-6>, <28,10,-6>, <28,10,6> }
		triangle { <12,10,6>, <12,4,6>, <12,4,-6> }
		triangle { <12,4,-6>, <12,10,-6>, <12,10,6> }
		triangle { <8,10,6>, <8,4,6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,10,-6>, <8,10,6> }
		triangle { <-8,10,6>, <-8,4,6>, <-8,4,-6> }
		triangle { <-8,4,-6>, <-8,10,-6>, <-8,10,6> }
		triangle { <-12,10,6>, <-12,4,6>, <-12,4,-6> }
		triangle { <-12,4,-6>, <-12,10,-6>, <-12,10,6> }
		triangle { <-28,10,6>, <-28,4,6>, <-28,4,-6> }
		triangle { <-28,4,-6>, <-28,10,-6>, <-28,10,6> }
		triangle { <36,24,6>, <36,4,6>, <36,4,-6> }
		triangle { <36,4,-6>, <36,24,-6>, <36,24,6> }
		triangle { <-36,24,6>, <-36,4,7>, <-36,4,-6> }
		triangle { <-36,4,-6>, <-36,24,-6>, <-36,24,6> }
	}
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,-6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,6> }
	object { _2_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,-6> }
	mesh {
		triangle { <12,18,6>, <12,4,6>, <8,4,6> }
		triangle { <8,4,6>, <8,18,6>, <12,18,6> }
		triangle { <12,18,-6>, <12,4,-6>, <8,4,-6> }
		triangle { <8,4,-6>, <8,18,-6>, <12,18,-6> }
		triangle { <-8,18,6>, <-8,4,6>, <-12,4,6> }
		triangle { <-12,4,6>, <-12,18,6>, <-8,18,6> }
		triangle { <-8,18,-6>, <-8,4,-6>, <-12,4,-6> }
		triangle { <-12,4,-6>, <-12,18,-6>, <-8,18,-6> }
		triangle { <36,24,6>, <36,4,6>, <28,4,6> }
		triangle { <28,4,6>, <28,18,6>, <36,24,6> }
		triangle { <36,24,-6>, <36,4,-6>, <28,4,-6> }
		triangle { <28,4,-6>, <28,18,-6>, <36,24,-6> }
		triangle { <-28,18,6>, <-28,4,6>, <-36,4,6> }
		triangle { <-36,4,6>, <-36,24,6>, <-28,18,6> }
		triangle { <-28,18,-6>, <-28,4,-6>, <-36,4,-6> }
		triangle { <-36,4,-6>, <-36,24,-6>, <-28,18,-6> }
		triangle { <36,24,6>, <28,18,6>, <-28,18,6> }
		triangle { <-28,18,6>, <-36,24,6>, <36,24,6> }
		triangle { <36,24,-6>, <28,18,-6>, <-28,18,-6> }
		triangle { <-28,18,-6>, <-36,24,-6>, <36,24,-6> }
		triangle { <40,24,10>, <36,24,6>, <-36,24,6> }
		triangle { <-36,24,6>, <-40,24,10>, <40,24,10> }
		triangle { <40,24,-10>, <36,24,-6>, <-36,24,-6> }
		triangle { <-36,24,-6>, <-40,24,-10>, <40,24,-10> }
		triangle { <40,24,10>, <36,24,6>, <36,24,-6> }
		triangle { <36,24,-6>, <40,24,-10>, <40,24,10> }
		triangle { <-40,24,10>, <-36,24,6>, <-36,24,-6> }
		triangle { <-36,24,-6>, <-40,24,-10>, <-40,24,10> }
	}
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,20,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,0,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,-16,0,6,0,-20,10,8> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,-2,0,8,0,20,10,10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,2,0,8,0,20,10,-10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,-2,0,8,0,0,10,10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,2,0,8,0,0,10,-10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,-2,0,8,0,-20,10,10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,2,0,8,0,-20,10,-10> }
	mesh {
		triangle { <40,24,10>, <40,0,10>, <40,0,-10> }
		triangle { <40,0,-10>, <40,24,-10>, <40,24,10> }
		triangle { <-40,24,10>, <-40,0,10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,24,-10>, <-40,24,10> }
		triangle { <40,0,10>, <40,0,-10>, <-40,0,-10> }
		triangle { <-40,0,-10>, <-40,0,10>, <40,0,10> }
	}
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,20,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,10,-10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,10> }
	object { _4_dash_4ndis_dot_dat matrix <8,0,0,0,0,1,0,8,0,-20,10,-10> }
	mesh {
		triangle { <12,18,10>, <12,2,10>, <8,2,10> }
		triangle { <8,2,10>, <8,18,10>, <12,18,10> }
		triangle { <12,18,-10>, <12,2,-10>, <8,2,-10> }
		triangle { <8,2,-10>, <8,18,-10>, <12,18,-10> }
		triangle { <-8,18,10>, <-8,2,10>, <-12,2,10> }
		triangle { <-12,2,10>, <-12,18,10>, <-8,18,10> }
		triangle { <-8,18,-10>, <-8,2,-10>, <-12,2,-10> }
		triangle { <-12,2,-10>, <-12,18,-10>, <-8,18,-10> }
		triangle { <40,24,10>, <28,18,10>, <-28,18,10> }
		triangle { <-28,18,10>, <-40,24,10>, <40,24,10> }
		triangle { <40,24,-10>, <28,18,-10>, <-28,18,-10> }
		triangle { <-28,18,-10>, <-40,24,-10>, <40,24,-10> }
		triangle { <40,0,10>, <28,2,10>, <-28,2,10> }
		triangle { <-28,2,10>, <-40,0,10>, <40,0,10> }
		triangle { <40,0,-10>, <28,2,-10>, <-28,2,-10> }
		triangle { <-28,2,-10>, <-40,0,-10>, <40,0,-10> }
		triangle { <40,24,10>, <28,18,10>, <28,2,10> }
		triangle { <28,2,10>, <40,0,10>, <40,24,10> }
		triangle { <40,24,-10>, <28,18,-10>, <28,2,-10> }
		triangle { <28,2,-10>, <40,0,-10>, <40,24,-10> }
		triangle { <-40,24,10>, <-28,18,10>, <-28,2,10> }
		triangle { <-28,2,10>, <-40,0,10>, <-40,24,10> }
		triangle { <-40,24,-10>, <-28,18,-10>, <-28,2,-10> }
		triangle { <-28,2,-10>, <-40,0,-10>, <-40,24,-10> }
	}
	#if (STUDS)
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud2_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
	#end
}
#end

#declare _3009_dot_dat = #if (QUAL = 0) box { <-60,-4,-10>, <60,24,10> } #else union {
// Brick  1 x  6
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
	#end
	object { box5_dot_dat matrix <56,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <60,24,10>, <56,24,6>, <-56,24,6> }
		triangle { <-56,24,6>, <-60,24,10>, <60,24,10> }
		triangle { <-60,24,10>, <-56,24,6>, <-56,24,-6> }
		triangle { <-56,24,-6>, <-60,24,-10>, <-60,24,10> }
		triangle { <-60,24,-10>, <-56,24,-6>, <56,24,-6> }
		triangle { <56,24,-6>, <60,24,-10>, <-60,24,-10> }
		triangle { <60,24,-10>, <56,24,-6>, <56,24,6> }
		triangle { <56,24,6>, <60,24,10>, <60,24,-10> }
	}
	object { box5_dot_dat matrix <60,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
	#end
}
#end

#declare _3034_dot_dat = #if (QUAL = 0) box { <-80,-4,-20>, <80,8,20> } #else union {
// Plate  2 x  8
	#if (STUDS)
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,60,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,0,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-20,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-40,4,0> }
		object { stud4_dot_dat matrix <1,0,0,0,-1,0,0,0,1,-60,4,0> }
	#end
	object { box5_dot_dat matrix <76,0,0,0,-4,0,0,0,16,0,8,0> }
	mesh {
		triangle { <80,8,20>, <76,8,16>, <-76,8,16> }
		triangle { <-76,8,16>, <-80,8,20>, <80,8,20> }
		triangle { <80,8,-20>, <76,8,-16>, <-76,8,-16> }
		triangle { <-76,8,-16>, <-80,8,-20>, <80,8,-20> }
		triangle { <80,8,20>, <76,8,16>, <76,8,-16> }
		triangle { <76,8,-16>, <80,8,-20>, <80,8,20> }
		triangle { <-80,8,20>, <-76,8,16>, <-76,8,-16> }
		triangle { <-76,8,-16>, <-80,8,-20>, <-80,8,20> }
	}
	object { box5_dot_dat matrix <80,0,0,0,-8,0,0,0,20,0,8,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,-10> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,-10> }
	#end
}
#end

#declare _2465_dot_dat = #if (QUAL = 0) box { <-160,-4,-10>, <160,24,10> } #else union {
// Brick  1 x 16
	#if (STUDS)
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,140,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,120,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,100,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,80,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,0,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-20,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-40,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-60,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-80,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-100,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-120,4,0> }
		object { stud3_dot_dat matrix <1,0,0,0,-5,0,0,0,1,-140,4,0> }
	#end
	object { box5_dot_dat matrix <156,0,0,0,-20,0,0,0,6,0,24,0> }
	mesh {
		triangle { <160,24,10>, <156,24,6>, <-156,24,6> }
		triangle { <-156,24,6>, <-160,24,10>, <160,24,10> }
		triangle { <-160,24,10>, <-156,24,6>, <-156,24,-6> }
		triangle { <-156,24,-6>, <-160,24,-10>, <-160,24,10> }
		triangle { <-160,24,-10>, <-156,24,-6>, <156,24,-6> }
		triangle { <156,24,-6>, <160,24,-10>, <-160,24,-10> }
		triangle { <160,24,-10>, <156,24,-6>, <156,24,6> }
		triangle { <156,24,6>, <160,24,10>, <160,24,-10> }
	}
	object { box5_dot_dat matrix <160,0,0,0,-24,0,0,0,10,0,24,0> }
	#if (STUDS)
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,150,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,130,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,110,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,90,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-10,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-30,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-50,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-70,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-90,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-110,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-130,0,0> }
		object { stud_dot_dat matrix <1,0,0,0,1,0,0,0,1,-150,0,0> }
	#end
}
#end

#declare s_slash_32007s2_dot_dat = #if (QUAL = 0) box { <-3.66,10.9,-25>, <3.66,25,-12> } #else object {
// ~Technic Tread Hub Subpart
	mesh {
		triangle { <0,24,-25>, <0,25,-25>, <-3.66,24.3,-25> }
		triangle { <-3.66,24.3,-25>, <-3.14,23.4,-25>, <0,24,-25> }
		triangle { <3.14,23.4,-25>, <3.66,24.3,-25>, <0,25,-25> }
		triangle { <0,25,-25>, <0,24,-25>, <3.14,23.4,-25> }
		triangle { <1.19,20,-18.9>, <0,24,-25>, <0,17.2,-14> }
		triangle { <0,17.2,-14>, <1.01,17,-14>, <1.19,20,-18.9> }
		triangle { <1.19,20,-18.9>, <0,24,-25>, <3.14,23.4,-25> }
		triangle { <0,16.2,-14>, <0,17.2,-14>, <-1.01,17,-14> }
		triangle { <-1.01,17,-14>, <-0.952,16,-14>, <0,16.2,-14> }
		triangle { <0.952,16,-14>, <1.01,17,-14>, <0,17.2,-14> }
		triangle { <0,17.2,-14>, <0,16.2,-14>, <0.952,16,-14> }

		triangle { <0,11,-12>, <0.646,10.9,-12>, <0.952,16,-14> }
		triangle { <0.952,16,-14>, <0,16.2,-14>, <0,11,-12> }
// 4 16 3.66 24.3 -25 3.66 24.3 -12 0 25 -12 0 25 -25
		triangle { <1.19,20,-18.9>, <3.66,24.3,-12>, <3.66,24.3,-25> }
		triangle { <3.66,24.3,-25>, <3.14,23.4,-25>, <1.19,20,-18.9> }
		triangle { <1.19,20,-18.9>, <3.66,24.3,-12>, <1.19,20,-12> }
		triangle { <1.19,20,-18.9>, <1.19,20,-12>, <1.01,17,-14> }
		triangle { <1.01,17,-14>, <0.952,16,-14>, <0.646,10.9,-12> }
		triangle { <0.646,10.9,-12>, <1.19,20,-12>, <1.01,17,-14> }
		triangle { <-3.14,23.4,-25>, <0,24,-25>, <-1.19,20,-18.9> }
		triangle { <-1.19,20,-18.9>, <-1.01,17,-14>, <0,17.2,-14> }
		triangle { <0,17.2,-14>, <0,24,-25>, <-1.19,20,-18.9> }
		triangle { <0,11,-12>, <0,16.2,-14>, <-0.952,16,-14> }
		triangle { <-0.952,16,-14>, <-0.646,10.9,-12>, <0,11,-12> }
// 4 16 0 25 -25 0 25 -12 -3.66 24.3 -12 -3.66 24.3 -25
		triangle { <-1.19,20,-18.9>, <-3.66,24.3,-25>, <-3.66,24.3,-12> }
		triangle { <-3.66,24.3,-12>, <-1.19,20,-12>, <-1.19,20,-18.9> }
		triangle { <-1.19,20,-18.9>, <-3.66,24.3,-25>, <-3.14,23.4,-25> }
		triangle { <-1.01,17,-14>, <-1.19,20,-12>, <-0.646,10.9,-12> }
		triangle { <-0.646,10.9,-12>, <-0.952,16,-14>, <-1.01,17,-14> }
		triangle { <-1.01,17,-14>, <-1.19,20,-12>, <-1.19,20,-18.9> }
// 2 24 0 25 -25 -3.66 24.3 -25
	}
}
#end

#declare _32007_dot_dat = #if (QUAL = 0) box { <-28.994,-30,-25>, <28.994,30,25> } #else union {
// Technic Tread Sprocket Wheel
	object { _4_dash_4cyli_dot_dat matrix <13,0,0,0,0,20,0,13,0,0,0,-10> }
	object { _4_dash_4cyli_dot_dat matrix <25,0,0,0,0,13,0,25,0,0,0,-25> }
	object { _4_dash_4cyli_dot_dat matrix <11,0,0,0,0,10,0,11,0,0,0,-12> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,0,8,0,9,0,0,0,-10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,1,0,8,0,0,0,-10> }
	object { _4_dash_4cyli_dot_dat matrix <6,0,0,0,0,18,0,6,0,0,0,-9> }
	object { _2_dash_4cyli_dot_dat matrix <-1.5,0,0,0,0,15,0,-1.5,0,0,-28.5,-25> }
	object { _2_dash_4cyli_dot_dat matrix <-1.21,-0.882,0,0,0,15,0.882,-1.21,0,16.8,-23.1,-25> }
	object { _2_dash_4cyli_dot_dat matrix <-0.464,-1.43,0,0,0,15,1.43,-0.464,0,27.1,-8.81,-25> }
	object { _2_dash_4cyli_dot_dat matrix <0.464,-1.43,0,0,0,15,1.43,0.463,0,27.1,8.81,-25> }
	object { _2_dash_4cyli_dot_dat matrix <1.21,-0.882,0,0,0,15,0.882,1.21,0,16.8,23.1,-25> }
	object { _2_dash_4cyli_dot_dat matrix <1.5,0,0,0,0,15,0,1.5,0,0,28.5,-25> }
	object { _2_dash_4cyli_dot_dat matrix <1.21,0.882,0,0,0,15,-0.882,1.21,0,-16.8,23.1,-25> }
	object { _2_dash_4cyli_dot_dat matrix <0.464,1.43,0,0,0,15,-1.43,0.464,0,-27.1,8.81,-25> }
	object { _2_dash_4cyli_dot_dat matrix <-0.464,1.43,0,0,0,15,-1.43,-0.463,0,-27.1,-8.81,-25> }
	object { _2_dash_4cyli_dot_dat matrix <-1.21,0.882,0,0,0,15,-0.882,-1.21,0,-16.8,-23.1,-25> }
	object { _4_dash_4cyli_dot_dat matrix <25,0,0,0,0,-13,0,-25,0,0,0,25> }
	object { _4_dash_4cyli_dot_dat matrix <11,0,0,0,0,-10,0,-11,0,0,0,12> }
	object { _4_dash_4cyli_dot_dat matrix <9,0,0,0,0,-8,0,-9,0,0,0,10> }
	object { _4_dash_4cyli_dot_dat matrix <8,0,0,0,0,-1,0,-8,0,0,0,10> }
	object { _2_dash_4cyli_dot_dat matrix <1.5,0,0,0,0,-15,0,-1.5,0,0,-28.5,25> }
	object { _2_dash_4cyli_dot_dat matrix <1.21,0.882,0,0,0,-15,0.882,-1.21,0,16.8,-23.1,25> }
	object { _2_dash_4cyli_dot_dat matrix <0.464,1.43,0,0,0,-15,1.43,-0.463,0,27.1,-8.81,25> }
	object { _2_dash_4cyli_dot_dat matrix <-0.464,1.43,0,0,0,-15,1.43,0.464,0,27.1,8.81,25> }
	object { _2_dash_4cyli_dot_dat matrix <-1.21,0.882,0,0,0,-15,0.882,1.21,0,16.8,23.1,25> }
	object { _2_dash_4cyli_dot_dat matrix <-1.5,0,0,0,0,-15,0,1.5,0,0,28.5,25> }
	object { _2_dash_4cyli_dot_dat matrix <-1.21,-0.882,0,0,0,-15,-0.882,1.21,0,-16.8,23.1,25> }
	object { _2_dash_4cyli_dot_dat matrix <-0.464,-1.43,0,0,0,-15,-1.43,0.463,0,-27.1,8.81,25> }
	object { _2_dash_4cyli_dot_dat matrix <0.464,-1.43,0,0,0,-15,-1.43,-0.464,0,-27.1,-8.81,25> }
	object { _2_dash_4cyli_dot_dat matrix <1.21,-0.882,0,0,0,-15,-0.882,-1.21,0,-16.8,-23.1,25> }
	object { s_slash_32007s2_dot_dat matrix <-1,0,0,0,1,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <-0.707107,0.707107,0,0.707107,0.707107,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0,1,0,1,0,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0.707107,0.707107,0,0.707107,-0.707107,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <1,0,0,0,1,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0.707107,0.707107,0,-0.707107,0.707107,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0.707107,-0.707107,0,0.707107,0.707107,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0,-1,0,1,0,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <-0.707107,-0.707107,0,0.707107,-0.707107,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <-1,0,0,0,-1,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <-0.707107,0.707107,0,-0.707107,-0.707107,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0,1,0,-1,0,0,0,0,1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <1,0,0,0,-1,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0.707107,-0.707107,0,-0.707107,-0.707107,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <0,-1,0,-1,0,0,0,0,-1,0,0,0> }
	object { s_slash_32007s2_dot_dat matrix <-0.707107,-0.707107,0,-0.707107,0.707107,0,0,0,-1,0,0,0> }
	mesh {
		triangle { <-21.8,-15.9,10>, <-25.2,-9.76,10>, <-25.2,-9.76,25> }
		triangle { <-25.2,-9.76,25>, <-21.8,-15.9,25>, <-21.8,-15.9,10> }
		triangle { <-21.8,-15.9,25>, <-17.1,-20.9,25>, <-17.1,-20.9,10> }
		triangle { <-17.1,-20.9,10>, <-21.8,-15.9,10>, <-21.8,-15.9,25> }
		triangle { <-27,0,10>, <-26.1,6.9,10>, <-26.1,6.9,25> }
		triangle { <-26.1,6.9,25>, <-27,0,25>, <-27,0,10> }
		triangle { <-27,0,25>, <-26.1,-6.9,25>, <-26.1,-6.9,10> }
		triangle { <-26.1,-6.9,10>, <-27,0,10>, <-27,0,25> }
		triangle { <-21.8,15.9,10>, <-17.1,20.9,10>, <-17.1,20.9,25> }
		triangle { <-17.1,20.9,25>, <-21.8,15.9,25>, <-21.8,15.9,10> }
		triangle { <-21.8,15.9,25>, <-25.2,9.76,25>, <-25.2,9.76,10> }
		triangle { <-25.2,9.76,10>, <-21.8,15.9,10>, <-21.8,15.9,25> }
		triangle { <-8.34,25.7,10>, <-1.5,27,10>, <-1.5,27,25> }
		triangle { <-1.5,27,25>, <-8.34,25.7,25>, <-8.34,25.7,10> }
		triangle { <-8.34,25.7,25>, <-14.6,22.7,25>, <-14.6,22.7,10> }
		triangle { <-14.6,22.7,10>, <-8.34,25.7,10>, <-8.34,25.7,25> }
		triangle { <8.34,25.7,10>, <14.6,22.7,10>, <14.6,22.7,25> }
		triangle { <14.6,22.7,25>, <8.34,25.7,25>, <8.34,25.7,10> }
		triangle { <8.34,25.7,25>, <1.5,27,25>, <1.5,27,10> }
		triangle { <1.5,27,10>, <8.34,25.7,10>, <8.34,25.7,25> }
		triangle { <21.8,15.9,10>, <25.2,9.76,10>, <25.2,9.76,25> }
		triangle { <25.2,9.76,25>, <21.8,15.9,25>, <21.8,15.9,10> }
		triangle { <21.8,15.9,25>, <17.1,20.9,25>, <17.1,20.9,10> }
		triangle { <17.1,20.9,10>, <21.8,15.9,10>, <21.8,15.9,25> }
		triangle { <27,0,10>, <26.1,-6.9,10>, <26.1,-6.9,25> }
		triangle { <26.1,-6.9,25>, <27,0,25>, <27,0,10> }
		triangle { <27,0,25>, <26.1,6.9,25>, <26.1,6.9,10> }
		triangle { <26.1,6.9,10>, <27,0,10>, <27,0,25> }
		triangle { <21.8,-15.9,10>, <17.1,-20.9,10>, <17.1,-20.9,25> }
		triangle { <17.1,-20.9,25>, <21.8,-15.9,25>, <21.8,-15.9,10> }
		triangle { <21.8,-15.9,25>, <25.2,-9.76,25>, <25.2,-9.76,10> }
		triangle { <25.2,-9.76,10>, <21.8,-15.9,10>, <21.8,-15.9,25> }
		triangle { <8.34,-25.7,10>, <1.5,-27,10>, <1.5,-27,25> }
		triangle { <1.5,-27,25>, <8.34,-25.7,25>, <8.34,-25.7,10> }
		triangle { <8.34,-25.7,25>, <14.6,-22.7,25>, <14.6,-22.7,10> }
		triangle { <14.6,-22.7,10>, <8.34,-25.7,10>, <8.34,-25.7,25> }
		triangle { <-8.34,-25.7,-10>, <-1.5,-27,-10>, <-1.5,-27,-25> }
		triangle { <-1.5,-27,-25>, <-8.34,-25.7,-25>, <-8.34,-25.7,-10> }
		triangle { <-8.34,-25.7,-25>, <-14.6,-22.7,-25>, <-14.6,-22.7,-10> }
		triangle { <-14.6,-22.7,-10>, <-8.34,-25.7,-10>, <-8.34,-25.7,-25> }
		triangle { <-21.8,-15.9,-10>, <-17.1,-20.9,-10>, <-17.1,-20.9,-25> }
		triangle { <-17.1,-20.9,-25>, <-21.8,-15.9,-25>, <-21.8,-15.9,-10> }
		triangle { <-21.8,-15.9,-25>, <-25.2,-9.76,-25>, <-25.2,-9.76,-10> }
		triangle { <-25.2,-9.76,-10>, <-21.8,-15.9,-10>, <-21.8,-15.9,-25> }
		triangle { <-27,0,-10>, <-26.1,-6.9,-10>, <-26.1,-6.9,-25> }
		triangle { <-26.1,-6.9,-25>, <-27,0,-25>, <-27,0,-10> }
		triangle { <-27,0,-25>, <-26.1,6.9,-25>, <-26.1,6.9,-10> }
		triangle { <-26.1,6.9,-10>, <-27,0,-10>, <-27,0,-25> }
		triangle { <-21.8,15.9,-10>, <-25.2,9.76,-10>, <-25.2,9.76,-25> }
		triangle { <-25.2,9.76,-25>, <-21.8,15.9,-25>, <-21.8,15.9,-10> }
		triangle { <-21.8,15.9,-25>, <-17.1,20.9,-25>, <-17.1,20.9,-10> }
		triangle { <-17.1,20.9,-10>, <-21.8,15.9,-10>, <-21.8,15.9,-25> }
		triangle { <-8.34,25.7,-10>, <-14.6,22.7,-10>, <-14.6,22.7,-25> }
		triangle { <-14.6,22.7,-25>, <-8.34,25.7,-25>, <-8.34,25.7,-10> }
		triangle { <-8.34,25.7,-25>, <-1.5,27,-25>, <-1.5,27,-10> }
		triangle { <-1.5,27,-10>, <-8.34,25.7,-10>, <-8.34,25.7,-25> }
		triangle { <8.34,25.7,-10>, <1.5,27,-10>, <1.5,27,-25> }
		triangle { <1.5,27,-25>, <8.34,25.7,-25>, <8.34,25.7,-10> }
		triangle { <8.34,25.7,-25>, <14.6,22.7,-25>, <14.6,22.7,-10> }
		triangle { <14.6,22.7,-10>, <8.34,25.7,-10>, <8.34,25.7,-25> }
		triangle { <21.8,15.9,-10>, <17.1,20.9,-10>, <17.1,20.9,-25> }
		triangle { <17.1,20.9,-25>, <21.8,15.9,-25>, <21.8,15.9,-10> }
		triangle { <21.8,15.9,-25>, <25.2,9.76,-25>, <25.2,9.76,-10> }
		triangle { <25.2,9.76,-10>, <21.8,15.9,-10>, <21.8,15.9,-25> }
		triangle { <27,0,-10>, <26.1,6.9,-10>, <26.1,6.9,-25> }
		triangle { <26.1,6.9,-25>, <27,0,-25>, <27,0,-10> }
		triangle { <27,0,-25>, <26.1,-6.9,-25>, <26.1,-6.9,-10> }
		triangle { <26.1,-6.9,-10>, <27,0,-10>, <27,0,-25> }
		triangle { <21.8,-15.9,-10>, <25.2,-9.76,-10>, <25.2,-9.76,-25> }
		triangle { <25.2,-9.76,-25>, <21.8,-15.9,-25>, <21.8,-15.9,-10> }
		triangle { <21.8,-15.9,-25>, <17.1,-20.9,-25>, <17.1,-20.9,-10> }
		triangle { <17.1,-20.9,-10>, <21.8,-15.9,-10>, <21.8,-15.9,-25> }
		triangle { <8.34,-25.7,-10>, <14.6,-22.7,-10>, <14.6,-22.7,-25> }
		triangle { <14.6,-22.7,-25>, <8.34,-25.7,-25>, <8.34,-25.7,-10> }
		triangle { <8.34,-25.7,-25>, <1.5,-27,-25>, <1.5,-27,-10> }
		triangle { <1.5,-27,-10>, <8.34,-25.7,-10>, <8.34,-25.7,-25> }
		triangle { <17.1,-20.9,-10>, <26.1,-6.9,-10>, <25.2,-9.76,-10> }
		triangle { <25.2,-9.76,-10>, <21.8,-15.9,-10>, <17.1,-20.9,-10> }
		triangle { <1.5,-27,-10>, <25.2,9.76,-10>, <26.1,-6.9,-10> }
		triangle { <26.1,-6.9,-10>, <17.1,-20.9,-10>, <1.5,-27,-10> }
		triangle { <1.5,-27,-10>, <9.19,-9.19,-10>, <12,-4.97,-10> }
		triangle { <12,-4.97,-10>, <25.2,9.76,-10>, <1.5,-27,-10> }
		triangle { <12,-4.97,-10>, <25.2,9.76,-10>, <13,0,-10> }
		triangle { <0,13,-10>, <4.97,12,-10>, <14.6,22.7,-10> }
		triangle { <14.6,22.7,-10>, <4.97,12,-10>, <9.19,9.19,-10> }
		triangle { <15.5,23.9,-10>, <16.5,24.5,-10>, <9.19,9.19,-10> }
		triangle { <9.19,9.19,-10>, <14.6,22.7,-10>, <15.5,23.9,-10> }
		triangle { <15.5,23.9,-10>, <16.5,24.5,-10>, <16,24.3,-10> }
		triangle { <-9.19,9.19,-10>, <-4.97,12,-10>, <-26.1,6.9,-10> }
		triangle { <-26.1,6.9,-10>, <-17.1,20.9,-10>, <14.6,22.7,-10> }
		triangle { <14.6,22.7,-10>, <-4.97,12,-10>, <-26.1,6.9,-10> }
		triangle { <-17.1,20.9,-10>, <-14.6,22.7,-10>, <-8.34,25.7,-10> }
		triangle { <-8.34,25.7,-10>, <14.6,22.7,-10>, <-17.1,20.9,-10> }
		triangle { <17.1,20.9,-10>, <9.19,9.19,-10>, <17.1,24.5,-10> }
		triangle { <17.1,24.5,-10>, <17.6,24.3,-10>, <17.1,20.9,-10> }
		triangle { <25.2,9.76,-10>, <12,4.97,-10>, <9.19,9.19,-10> }
		triangle { <9.19,9.19,-10>, <17.1,20.9,-10>, <25.2,9.76,-10> }
		triangle { <25.2,9.76,-10>, <12,4.97,-10>, <13,0,-10> }
		triangle { <9.19,-9.19,-10>, <4.97,-12,-10>, <1.5,-27,-10> }
		triangle { <1.5,-27,-10>, <4.97,-12,-10>, <0,-13,-10> }
		triangle { <1.5,-28.5,-10>, <0,-30,-10>, <0,-13,-10> }
		triangle { <0,-13,-10>, <1.5,-27,-10>, <1.5,-28.5,-10> }
		triangle { <1.5,-28.5,-10>, <1.39,-29.1,-10>, <0.574,-29.9,-10> }
		triangle { <0.574,-29.9,-10>, <0,-30,-10>, <1.5,-28.5,-10> }
		triangle { <-12,-4.97,-10>, <-26.1,-6.9,-10>, <-26.1,6.9,-10> }
		triangle { <-26.1,6.9,-10>, <-13,0,-10>, <-12,-4.97,-10> }
		triangle { <-26.1,6.9,-10>, <-13,0,-10>, <-12,4.97,-10> }
		triangle { <-26.1,6.9,-10>, <-12,4.97,-10>, <-9.19,9.19,-10> }
		triangle { <27.6,-7.38,-10>, <28.6,-8.69,-10>, <25.2,-9.76,-10> }
		triangle { <25.2,-9.76,-10>, <26.1,-6.9,-10>, <27.6,-7.38,-10> }
		triangle { <28.1,-7.67,-10>, <28.4,-8.13,-10>, <28.6,-8.69,-10> }
		triangle { <28.6,-8.69,-10>, <27.6,-7.38,-10>, <28.1,-7.67,-10> }
		triangle { <1.39,-29.1,-10>, <0.574,-29.9,-10>, <1.06,-29.6,-10> }
		triangle { <-28.6,8.69,-10>, <-27.6,7.38,-10>, <-28.1,7.67,-10> }
		triangle { <-28.1,7.67,-10>, <-28.4,8.13,-10>, <-28.6,8.69,-10> }
		triangle { <-25.2,9.76,-10>, <-26.1,6.9,-10>, <-27.6,7.38,-10> }
		triangle { <-27.6,7.38,-10>, <-28.6,8.69,-10>, <-25.2,9.76,-10> }
		triangle { <-25.2,9.76,-10>, <-21.8,15.9,-10>, <-17.1,20.9,-10> }
		triangle { <-17.1,20.9,-10>, <-26.1,6.9,-10>, <-25.2,9.76,-10> }
		triangle { <25.2,-9.76,-10>, <28.5,-9.27,-10>, <28.2,-9.78,-10> }
		triangle { <28.2,-9.78,-10>, <27.8,-10.1,-10>, <25.2,-9.76,-10> }
		triangle { <25.2,-9.76,-10>, <28.5,-9.27,-10>, <28.6,-8.69,-10> }
		triangle { <-28.5,-9.27,-10>, <-27.2,-10.3,-10>, <-27.8,-10.1,-10> }
		triangle { <-27.8,-10.1,-10>, <-28.2,-9.78,-10>, <-28.5,-9.27,-10> }
		triangle { <-28.6,-8.69,-10>, <-26.6,-10.2,-10>, <-27.2,-10.3,-10> }
		triangle { <-27.2,-10.3,-10>, <-28.5,-9.27,-10>, <-28.6,-8.69,-10> }
		triangle { <-26.1,-6.9,-10>, <-12,-4.97,-10>, <-26.6,-10.2,-10> }
		triangle { <-26.6,-10.2,-10>, <-28.6,-8.69,-10>, <-26.1,-6.9,-10> }
		triangle { <-25.2,9.76,-10>, <-28.5,9.27,-10>, <-28.2,9.78,-10> }
		triangle { <-28.2,9.78,-10>, <-27.8,10.1,-10>, <-25.2,9.76,-10> }
		triangle { <-25.2,9.76,-10>, <-28.5,9.27,-10>, <-28.6,8.69,-10> }
		triangle { <17.6,-24.3,-10>, <18.2,-22.7,-10>, <18.2,-23.3,-