// Persistence of Vision Ray Tracer Scene Description File
// File: lvictory.pov
// Vers: 3.1
// Desc: Red Baron's Last Victories
// Date: Sep-Oct 2001
// Auth: J. F. Tuduri

#version unofficial MegaPov 0.6;  // version number may be different 

 
global_settings {max_trace_level 10}


#include "colors.inc"
#include "textures.inc"
#include "sopwith.inc"
#include "skies.inc"

//Variables de Control (Settings)
#local CamNo = 3;  
#local Iluminacion =2; //0: point, 1: point2 , 2:area
#local Ejes = 0;

#local Nubes=0;
#local Terreno = 1;
#local Fog=1;

#local RedBaronEst = 2; //0: punto, 1: simple, 2: full
#local RotRedBaron=<-20,-5,10>;//
#local URedBaron=<10,0,8>;

#local Sopwith1 = 1; //0: punto, 1: full
#local RotSopwith1 = <25,0,-7>;
#local USopwith1 = <-18,-3,-5>;


//Camara
#switch (CamNo)
        #case (1)
               camera {location  <3.0 , 3.0 ,-15.0>
                       look_at   <0.0 , 5.0 , 0.0>
                       }
        #break
        #case (2)
               camera {location <0,100,0>
                       look_at <0.0,0,0.01>
                       }
        #break
        #case (3)
               camera {location <26,5,1>
                       look_at <0,0,4>
                       rotate x*(-5)
                       }
        #break
        #else
        
#end


//Luces
#switch (Iluminacion)
        #case (0)
                light_source {0*x rgb 1 translate <-400, 50000, -0>}
                light_source {0*x rgb 1 translate <400, 400, 20> shadowless}
        #break
        #case (1)
                light_source {0*x rgb 1 translate <-5000,40000,-10000>}
                light_source {0*x rgb .5 translate <-50,50,100> shadowless}
                light_source {0*x rgb .5 translate <50,50,-100> shadowless}
                light_source {0*x rgb .5 translate <10,5,-10> shadowless}
        #break
        #case (2)
                light_source
                {
                 0*x
                 color rgb 1.0 
                 area_light
                 <100, 0, 0> <0, 0, 100>
                 40, 40                
                 adaptive 0          // 0,1,2,3... 
                 jitter              // adds random softening of light
                 translate <-5000, 40000, -10000>   // <x y z> position of light
                }
                light_source {0*x rgb .5 translate <-50,50,100> shadowless}
                light_source {0*x rgb .5 translate <50,50,-100> shadowless}
                light_source {0*x rgb .5 translate <10,5,-10> shadowless}
        #break
#end       

//Ejes
#if (Ejes=1)       
        cylinder {<0,0,0>,<0,10,0>,.03 pigment {Red}}
        cylinder {<-10,0,0>,<10,0,0>,.03 pigment {Green}}
        cylinder {<0,0,-10>,<0,0,10>,.03 pigment {Blue}}
#end

//Ambiente (Nubes, tierra, etc)

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}


#if (Fog=1)
fog
{
  fog_type 1
  distance 50000
  color rgb <.5,.5,1>
} 
#end

#if (Nubes=1) 
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1000.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  pigment {
           bozo
           scale 1500
           turbulence .6
           color_map {
                      [.2 rgb 1]
                      [.3 rgb .8]
                      [.35 rgbf <.7,.7,.7,.9>]
                      [.7 rgbt <0,0,0,1>]
                      [1 rgbt <0,0,0,1>]
                      }
           translate <1000,0,(-500)>
          } 
  no_shadow
} 
#end


//Piso
#local Text_1=texture{pigment {bozo
	                 turbulence 2
	                 scale 2000
	                 color_map{[0 Gold*1.5]
	                           [.3 Gold*1.3]
	                           [.6 Gold*1.1]
	                           [.8 rgb<.4,.6,.2>]
	                           [.9 Gold*1.1]}
       }                }

#local Text_Grad = texture{pigment {gradient y
	                 turbulence .05
	                 scale 2.65
	                 translate y*(-1)
	                 color_map{[0 rgb<0.1372,0.5568,0.1372>]
	                           [.4 rgb <0.15,0.468,0.152>]
	                           [.6 rgb <0.4,0.468,0.1572>]
	                           [1 rgb <0.8,0.49804,0.1961>]}
                }} 
#local Text_Forest = texture{
                     pigment {bozo
                         scale 1
                         rotate y*72
                         turbulence 4
                         color_map{
                                [0 rgb<0.0372,0.4068,0.0372>]
                                [.3 rgb<0.0572,0.4568,0.0772>]
                                [.4 rgb<0.1372,0.5568,0.1372>]
                                [1 rgb<0.1372,0.5568,0.1372>]
                         }
                  }
                    normal {bozo
                            scale 1
                            rotate y*72
                            turbulence 4
                            normal_map{
                                [0 granite 3 scale .4 turbulence 4]
                                [.3 granite 3 scale .4 turbulence 4]
                                [.4 dents .5]
                                [1 dents .5]
                            }
                } 
                }

#if (Terreno=1)
#declare MM = function{"ridgedmf" <1, 3, 5, 1, 1>}
isosurface{
	function{y-1*MM(x*.2,y*.2,z*.2)/1 +MM(x*.1,y*.01,z*.1)}
	contained_by{box <-150 ,-1, -150>,<150 ,5, 150>}  //70
	accuracy .005  max_gradient 1.5  threshold .4
	texture{pigment {gradient y
	                 turbulence .05
	                 scale 2.65
	                 translate y*(-1)
	                 color_map{[0 rgb<0.1372,0.5568,0.1372>]
	                           [.4 rgb <0.15,0.468,0.152>]
	                           [.6 rgb <0.4,0.468,0.1572>]
	                           [1 rgb <0.8,0.49804,0.1961>]}
                }} 
                   
        /*texture {gradient y
                 turbulence .05
                 scale 2.65
                 translate y*(-1)
                 texture_map{
                            [0 Text_Forest]
                            [.4 Text_Forest]
                            [.7 pigment {rgb <0.4,0.468,0.1572>}]
                            [1 Text_1]
                            }
                } */
                
	scale <3,2,3>
	scale 500
	translate <-18000,-6000,4500> //-40000
	
}
#end

//Objetos (Aviones)

#declare fokker =
        union{
              cone {<0,1.5,0>,.6,<6,1.3,0>,.1}
              sphere {<0,1.5,0>,.6}

              box {<0,0,3.5>,<1,.1,-3.5> translate <0,2.9,0>}
              box {<0,0,3.5>,<1,.1,-3.5> translate <0,1.8,0>} 
              box {<0,0,3.5>,<1,.1,-3.5> translate <0,1,0>}
              
              box{<0,0,-.01>,<.7,.8,.01> translate <5.8,1.3,0>}
              pigment {Red}
              }
             
#switch (RedBaronEst)
        #case(0)
                sphere {<0,0,0>,1 pigment {Red} translate URedBaron}
        #break
        #case(1)              
                object {fokker translate y*(-1.5)rotate RotRedBaron translate URedBaron}              
        #break
        #case(2)
                #include "FokkerDR.inc"
                object {RedBaron rotate RotRedBaron translate URedBaron}
        #break                
#end
        
#ifdef(Sopwith1)    
#switch (Sopwith1)
        #case (0)
                sphere{<0,0,0>,1 pigment {Green} translate USopwith1}
        #break
        #case (1)
                object {Sopwith rotate RotSopwith1 translate USopwith1}
        #break
#end   
#end 