// Desc: Red Baron's Last Victories
// Date: Sep-Oct 2001
// Auth: J. F. Tuduri
// Sopwith Camel
#version 3.1;

#include "colors.inc"

#declare textSop = texture {
                            pigment {rgb <.25,.4,.07>}
                            finish {phong .8 phong_size 40}
                            //normal {bumps .3}
                            normal {bumps scale .2}
                           }
#declare normalAlas = normal {
                              gradient x
                              rotate y*90
                              scale .5
                              slope_map {
                                         [0   <.3, 0>]
                                         [0.1 <0, 0>]
                                         [0.9 <0,0>]
                                         [1   <.3,0>]
                                        }
                             }
#declare textAlas = texture {
                             pigment {rgb <.25,.4,.07>}
                             finish {phong .8 phong_size 40}
                             normal {normalAlas}
                             }
                       

#declare textSSucio = texture{
                              pigment{
                                      bozo
                                      turbulence 2
                                      scale <5,.6,.6>
                                      color_map{
                                        [0 rgb 0 transmit 1]
                                        [.5 rgb 0 transmit 1]
                                        [.6 rgb 0 filter .9]
                                        [.8 rgb 0 transmit 1]
                                        }
                                      }
                             }                                                       

#declare textSTrompa = texture {
                                pigment {rgb .8}
                                normal {bumps scale .2}
                                finish {metallic phong .7 phong_size 20}
                                }

#declare textSSoportes = texture {
                                 pigment {wood
                                          scale <.1,.1,2>
                                          turbulence .3
                                          rotate x*90
                                          color_map{
                                                    [.3 rgb <.3,.1,0>]
                                                    [.6 rgb <.6,.32,.05>]
                                                    [.9 rgb <.6,.2,.1>]
                                                    }
                                         }
                                 finish {phong .4 phong_size 10}
                                }

#declare HeliceMovS =
pigment {
  radial
  frequency 1
  rotate x*90
  scale 1.25
  color_map {
    [ 0.0   rgb .2 transmit .2]
    [ 0.092  rgb .4 transmit .99]
    //[ 0.5  rgb 0 transmit 1]
    //[ 0.5  rgb 0 transmit 1]
    [ 0.92  rgb .4 transmit .99]
    [ 1.0  rgb .2 transmit .2]
  }
}


// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}


#declare Sopwith=union{
//Ala superior
difference{
      union {
        box {<0,.1001,4.0>,<1.3,0,-4.0>
                texture{textAlas}
                texture{pigment{
                        image_map
                                {
                                png "brit.png" // the file to read (iff/gif/tga/png/sys)
                                map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                once}
                       translate <-.5,-.5,0>
                       rotate x*90
                       scale 1.2
                       translate <.65,0,-3.3>
                       }
                normal{normalAlas}
               }
               texture{pigment{
                        image_map
                                {
                                png "brit.png" // the file to read (iff/gif/tga/png/sys)
                                map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                once}
                       translate <-.5,-.5,0>
                       rotate x*90
                       scale 1.2
                       translate <.65,0,3.3>
                       }
                normal{normalAlas}
             }
               }
        box {<0,.05,4.0>,<1.3,0,-4.0>}
        
        cylinder {<.65,0,0>,<.65,.1,0>,.65 translate z*4}
        torus {.65,.05 translate <.65,.05,4>}
        
        cylinder {<.65,0,0>,<.65,.1,0>,.65 translate z*(-4)}
        torus {.65,.05 translate <.65,.05,-4>}

        cylinder {<0,0,4>,<0,0,-4>,.05 translate <0,.05,0>}
        cylinder {<0,0,4>,<0,0,-4>,.05 translate <1.3,.05,0>}
        
        
        
        translate y*2.45
            }

        cylinder {<0,0,0>,<0,.3,0>,.3 translate <1.3,2.4,0>}
        texture{textAlas}
        texture{textSSucio}
        
        }

//Alas inferiores
//izquierda
union { 
        box {<0,.05,0>,<1.3,-.0001,-4> texture{textAlas}
                texture{pigment{
                        image_map
                                {
                                png "brit.png" // the file to read (iff/gif/tga/png/sys)
                                map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                once}
                       translate <-.5,-.5,0>
                       rotate x*90
                       scale 1.2
                       translate <.65,0,-3.2>
                       }
                normal{normalAlas}
               }
               }
        
        box {<0,.1,0>,<1.3,0.05,-4>}
        cylinder {<.65,0,0>,<.65,.1,0>,.65 translate z*(-4)}
        torus {.65,.05 translate <.65,.05,-4>}

        cylinder {<0,0,0>,<0,0,-4>,.05 translate <0,.05,0>}
        cylinder {<0,0,0>,<0,0,-4>,.05 translate <1.3,.05,0>}
        
        texture{textAlas}
        texture{textSSucio}
        rotate x*5
        translate <.6,1,-.3>
        }

//derecha
union { 
        box {<0,.05,0>,<1.3,-.0001,-4> texture{textAlas}
                texture{pigment{
                        image_map
                                {
                                png "brit.png" // the file to read (iff/gif/tga/png/sys)
                                map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                once}
                       translate <-.5,-.5,0>
                       rotate x*90
                       scale 1.2
                       translate <.65,0,-3.2>
                       }
                normal{normalAlas}
               }
               }
        
        box {<0,.1,0>,<1.3,.05,-4>}
        cylinder {<.65,0,0>,<.65,.1,0>,.65 translate z*(-4)}
        torus {.65,.05 translate <.65,.05,-4>}

        cylinder {<0,0,0>,<0,0,-4>,.05 translate <0,.05,0>}
        cylinder {<0,0,0>,<0,0,-4>,.05 translate <1.3,.05,0>}
        texture{textAlas}
        texture{textSSucio}
        rotate x*5
        translate <.6,1,-.3>
        scale <1,1,-1>
        
        }        
        
//Soportes 
#local Sseed =seed(26);
union{
        cylinder {<0,0,0>,<0,1.36,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate z*30 translate <.8,1.35,-3.8>}
        cylinder {<0,0,0>,<0,1.36,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate z*30 translate <1.7,1.35,-3.8>}
        cylinder {<0,0,0>,<0,1.36,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate z*30 translate <.8,1.35,3.8>}
        cylinder {<0,0,0>,<0,1.36,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate z*30 translate <1.7,1.35,3.8>}
        
        } 
union{
        cylinder {<0,0,0>,<0,1.15,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate x*30 translate <.3,1.5,.3>}
        cylinder {<0,0,0>,<0,1.15,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate x*30 translate <1.2,1.5,.3>}
        cylinder {<0,0,0>,<0,1.15,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate x*(-30) translate <.3,1.5,-.3>}
        cylinder {<0,0,0>,<0,1.15,0>,.04 texture {textSSoportes translate x*(rand(Sseed)*20)}rotate x*(-30) translate <1.2,1.5,-.3>}
        
}

//trompa
union{
difference{
union{
        torus {.4,.1 rotate z*90 translate <-.3,1.3,0>}        
        cylinder {<-.3,1.3,0>,<.1,1.3,0>,.5}
     }
        cylinder {<-.4,1.3,0>,<-.05,1.3,0>,.4}
      
     
     }
        cylinder {<-.45,1.3,0>,<-.05,1.3,0>,.1}
        cylinder {<-.45,1.3,0>,<-.5,1.3,0>,.05}
        torus {.05,.05 rotate z*90 translate <-.45,1.3,0>}
#local Cc=0;
#while (Cc<50)
        cylinder {<0,0,0>,<0,0,.4>,.01 rotate <10,10,5> 
                  rotate x*(360/50*Cc) translate <-.425,1.3,0>}
        #local Cc=Cc+1;
#end
      texture{textSTrompa}
      }

//Helice    
/*
disc {<0,0,0>,x,1.2 texture {pigment { HeliceMovS rotate y*90}}
                    texture {pigment { HeliceMovS rotate y*90 scale <1,1,-1>}}
                    rotate x*37
                    translate <-.425,1.3,0>
                    }
                */

//Fuselaje

difference{     
union{
        cone {<.1,1.3,0>,.5,<2.6,1.3,0>,.4}
        sphere {<0,0,0>,.2 scale <6,1.3,2.3> rotate z*(-3)translate <1.3,1.55,0>}
        cone {<2.6,1.3,0>,.4,<3.5,1.3,0>,.3}
        cone {<3.5,1.3,0>,.3,<4.5,1.3,0>,.22}
        sphere{<0,0,0>,.22 scale <3,1,1> translate <4.5,1.3,0>}
        }
      cylinder {<0,0,0>,<0,1,0>,.3 scale <1.3,1,1> translate <1.5,1,0>}
      
      texture{textSop}
      //texture{textSSucio}
      texture{pigment{
                        image_map
                                {
                                png "brit.png" // the file to read (iff/gif/tga/png/sys)
                                map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                once}
                       translate <-.5,-.5,0>
                       scale .6
                       translate <2.8,1.3,0>
                       }
             }
      
      }
//Armas
union{
        cylinder {<0,0,0>,<1.2,0,0>,.08 pigment {leopard
                                                 scale .01
                                                 color_map{
                                                           [0 rgb .3]
                                                           [.1 rgb .3]
                                                           [.15 Clear]
                                                           [1 Clear]
                                                        }
                                                } 
                                        }
        cylinder {<-.1,.02,0>,<1.2,.02,0>,.03 pigment {rgb .1}}
        rotate z*(-3) translate <-.1,1.85,.2> }

union{
        cylinder {<0,0,0>,<1.2,0,0>,.08 pigment {leopard
                                                 scale .01
                                                 color_map{
                                                           [0 rgb .3]
                                                           [.1 rgb .3]
                                                           [.15 Clear]
                                                           [1 Clear]
                                                        }
                                                } 
                                        }
        cylinder {<-.1,.02,0>,<1.2,.02,0>,.03 pigment {rgb .1}}
        rotate z*(-3) translate <-.1,1.85,-.2> }
        
//Alerones Cola
union{
difference{
        box {<0,0,0>,<1,.05,-.8>}
        box{<0,-.01,0>,<1.2,.06,-.6> rotate y*30 translate <.6,0,.6>}
        }
        cylinder {<0,0,0>,<0,.05,0>,.4 scale <1.25,1,.5> translate <.5,0,-.8>}
        torus {.4,.025 scale <1.25,1,.5> translate <.5,.025,-.8>} 
        cylinder {<0,.025,0>,<0,.025,-.8>,.025}
        cylinder {<0,.025,-.35>,<0,.025,-.8>,.025 translate x*1}              
        translate <4.4,1.45,0>
        texture{textAlas scale .6}
        }
union{
difference{
        box {<0,0,0>,<1,.05,-.8>}
        box{<0,-.01,0>,<1.2,.06,-.6> rotate y*30 translate <.6,0,.6>}
        }
        cylinder {<0,0,0>,<0,.05,0>,.4 scale <1.25,1,.5> translate <.5,0,-.8>}
        torus {.4,.025 scale <1.17,1,.5> translate <.5,.025,-.8>} 
        cylinder {<0,.025,0>,<0,.025,-.8>,.025}
        cylinder {<0,.025,-.35>,<0,.025,-.8>,.025 translate x*1}              
        translate <4.4,1.45,0>
        texture{textSop}
        scale <1,1,-1>
        }

//Timon        
difference{
        union{
                torus {.45,.025 rotate x*90}
                cylinder {<0,0,-.025>,<0,0,.025>,.45}
             }
        box{<-1,-.5,.03>,<0,.5,-.03>}      
        pigment {gradient x
                 scale .46
                 translate x*.02
                 color_map{[0 rgb<.1,.1,1>]
                           [.33 rgb<.1,.1,1>]
                           [.33 White]
                           [.66 White]
                           [.66 rgb <.9,.05,.05>]
                           [1 rgb <.9,.05,.05>]
                           }
                 }
        texture{textSSucio}  
        translate <4.85,1.65,0>
        }

difference{
           union{
                cylinder {<0,0,-.025>,<0,0,.025>,.22 }
                torus{.22,.025 rotate x*90}
                }
           box{<.5,.3,.03>,<0,-.3,-.03>}
           scale <2.3,1.36,1> translate <4.85,1.8,0>
           texture{textSop}
           texture{textSSucio}
                }        

//Ruedas y soportes
union{
        
union{
        torus{.44,.06 rotate x*90 pigment {Black}}
        cone {<0,0,-.04>,.42,<0,0,-.15>,0 texture{textSop}texture{textSSucio}}
      translate <0.0,0,-.7>
      }
union{
      torus{.44,.06 rotate x*90 pigment {Black}}
      cone {<0,0,.04>,.42,<0,0,.15>,0 texture{textSop}texture{textSSucio}}
      translate <0.0,0,.7>
      }

union{
cylinder {<0,0,-.7>,<0,0,.7>,.05}
cylinder {<0,0,0>,<0,1.4,0>,.04 rotate <20,0,30> translate <0,0,-.6>}
cylinder {<0,0,0>,<0,1.4,0>,.04 rotate <-20,0,30> translate <0,0,.6>}
cylinder {<0,0,0>,<0,1.4,0>,.04 rotate <20,0,-30> translate <0,0,-.6>}
cylinder {<0,0,0>,<0,1.4,0>,.04 rotate <-20,0,-30> translate <0,0,.6>}            
        texture{textSop}
        texture{textSSucio}
        }
translate x*.8
        }

union{
        cylinder {<0,0,0>,<0,1,0>,.25 scale <.7,1,1> translate <1.6,.75,0> }
        sphere {<0,0,0>,.25 scale <.7,.5,1> translate <1.6,1.75,0>} 
        sphere {<0,0,0>,.15 translate <1.6,1.95,0>}
        cylinder {<0,0,0>,<-.5,0,0>,.07 rotate <0,10,15> translate <1.6,1.75,-.2>}
        cylinder {<0,0,0>,<-.5,0,0>,.07 rotate <0,-10,15> translate <1.6,1.75,.2>}        
     texture{  pigment {bozo
                        scale .05
                        turbulence .2
                        color_map
                        {[.4 Brown*.2]
                         [.7 Brown*.5]
                         [1 Brown]
                         }
                         }
        normal {bumps 1 scale .1 turbulence .3}}
     }

}