//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 4 lights, 14 materials and 152 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 10/31/2001    (31.10.2001)
//



/* // Scene Comment

This scene was created with Moray V3.3 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.000,      -1.500,      32.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.78369,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         13.79797    // Vertical       7.761
  look_at   <      0.000,      -0.383,      17.000>
  // Focal blur settings
  focal_point  <0.000, -0.383, 17.000> // Always Lookat
  aperture     0.15
  blur_samples 27
  confidence   0.935
  variance     0.007667
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera01
  location  <     15.934,     -21.429,       3.269>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36502,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         44.69825    // Vertical      33.524
  look_at   <      1.075,       0.291,       7.768>
}

*/

//
// *******  L I G H T S *******
//

#declare Light1 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  5.0
  fade_power 1.0
  translate  -10.0*y
  rotate 45.0*z
  translate  20.0*z
}

#declare Light2 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  5.0
  fade_power 1.0
  translate  -10.0*y
  rotate -135.0*z
  translate  20.0*z
}

#declare Light3 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  5.0
  fade_power 1.0
  translate  -10.0*y
  rotate -45.0*z
  translate  20.0*z
}

#declare Light4 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  5.0
  fade_power 1.0
  translate  -10.0*y
  rotate 135.0*z
  translate  20.0*z
}


//
// ********  MATERIALS  *******
//

#include "js_nuke.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cube007 = object {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 1.1, 0.15>
    rotate -45.0*z
  }
}
#declare Cube010 = object {
  object { // Cube010 -> Cube007
    Cube007
    rotate -90.0*z
  }
}
#declare CSG003 = union {
  object { Cube007 }
  object { // Cube008 -> Cube007
    Cube007
    rotate 30.0*z
  }
  object { // Cube009 -> Cube007
    Cube007
    rotate -30.0*z
  }
  object { Cube010 }
  object { // Cube011 -> Cube010
    Cube010
    rotate -30.0*z
  }
  object { // Cube012 -> Cube010
    Cube010
    rotate 30.0*z
  }
}
#declare CSG009 = intersection {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.0001, 1.0001, 0.5>
    translate  -0.25*z
  }
  object { CSG003 }
  material {
    GreyTexture
  }
  translate  2.625*z
}
#declare CSG010 = object {
  object { // CSG010 -> CSG009
    CSG009
    translate  -0.5*z
  }
}
#declare CSG011 = object {
  object { // CSG011 -> CSG010
    CSG010
    translate  -0.4*z
  }
}
#declare CSG012 = object {
  object { // CSG012 -> CSG011
    CSG011
    translate  -0.4*z
  }
}
#declare CSG028 = difference {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    translate  <1.0, 0.0, -0.3>
  }
}
#declare CSG029 = intersection {
  object { CSG028 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
  }
  translate  -1.0*x
  rotate -45.0*z
}
#declare CSG005 = difference {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    translate  <1.0, 0.0, -0.3>
  }
}
#declare CSG006 = intersection {
  object { CSG005 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
  }
  translate  -1.0*x
  rotate -45.0*z
}
#declare CSG019 = object {
  object { // CSG019 -> CSG006
    CSG006
    rotate -90.0*z
  }
}
#declare CSG022 = object {
  object { // CSG022 -> CSG019
    CSG019
    rotate -90.0*z
  }
}
#declare CSG025 = object {
  object { // CSG025 -> CSG022
    CSG022
    rotate -90.0*z
  }
}
#declare BreakRings06 = union {
  object { CSG029 }
  object { // CSG030 -> CSG006
    CSG006
    rotate -30.0*z
  }
  object { // CSG031 -> CSG006
    CSG006
    rotate 30.0*z
  }
  object { // CSG032 -> CSG006
    CSG006
    rotate -90.0*z
  }
  object { // CSG033 -> CSG019
    CSG019
    rotate -30.0*z
  }
  object { // CSG034 -> CSG019
    CSG019
    rotate 30.0*z
  }
  object { // CSG035 -> CSG019
    CSG019
    rotate -90.0*z
  }
  object { // CSG036 -> CSG022
    CSG022
    rotate -30.0*z
  }
  object { // CSG037 -> CSG022
    CSG022
    rotate 30.0*z
  }
  object { // CSG038 -> CSG022
    CSG022
    rotate -90.0*z
  }
  object { // CSG039 -> CSG025
    CSG025
    rotate -30.0*z
  }
  object { // CSG040 -> CSG025
    CSG025
    rotate 30.0*z
  }
  material {
    BrownTexture
  }
  translate  0.825*z
}
#declare BreakRings07 = object {
  object { // BreakRings07 -> BreakRings06
    BreakRings06
    translate  0.5*z
  }
}
#declare CSG004 = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 1.1, 0.15>
    rotate -45.0*z
  }
  object { // Cube014 -> Cube007
    Cube007
    rotate 30.0*z
  }
  object { // Cube015 -> Cube007
    Cube007
    rotate -30.0*z
  }
  object { // Cube016 -> Cube007
    Cube007
    rotate -90.0*z
  }
  object { // Cube017 -> Cube010
    Cube010
    rotate -30.0*z
  }
  object { // Cube018 -> Cube010
    Cube010
    rotate 30.0*z
  }
}
#declare CSG014 = intersection {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <1.0001, 1.0001, 0.5>
    translate  -0.25*z
  }
  object { CSG004 }
  material {
    GreyTexture
  }
  translate  3.625*z
}
#declare CSG015 = object {
  object { // CSG015 -> CSG014
    CSG014
    translate  -0.5*z
  }
}
#declare CSG016 = object {
  object { // CSG016 -> CSG015
    CSG015
    translate  -0.4*z
  }
}
#declare CSG017 = object {
  object { // CSG017 -> CSG016
    CSG016
    translate  -0.4*z
  }
}
#declare BreakRings01 = union {
  object { CSG006 }
  object { // CSG007 -> CSG006
    CSG006
    rotate -30.0*z
  }
  object { // CSG008 -> CSG006
    CSG006
    rotate 30.0*z
  }
  object { CSG019 }
  object { // CSG020 -> CSG019
    CSG019
    rotate -30.0*z
  }
  object { // CSG021 -> CSG019
    CSG019
    rotate 30.0*z
  }
  object { CSG022 }
  object { // CSG023 -> CSG022
    CSG022
    rotate -30.0*z
  }
  object { // CSG024 -> CSG022
    CSG022
    rotate 30.0*z
  }
  object { CSG025 }
  object { // CSG026 -> CSG025
    CSG025
    rotate -30.0*z
  }
  object { // CSG027 -> CSG025
    CSG025
    rotate 30.0*z
  }
  material {
    BrownTexture
  }
  translate  3.625*z
}
#declare BreakRings02 = object {
  object { // BreakRings02 -> BreakRings01
    BreakRings01
    translate  -0.5*z
  }
}
#declare BreakRings03 = object {
  object { // BreakRings03 -> BreakRings02
    BreakRings02
    translate  -0.4*z
  }
}
#declare BreakRings04 = object {
  object { // BreakRings04 -> BreakRings03
    BreakRings03
    translate  -0.4*z
  }
}




//
// ********  OBJECTS  *******
//

#declare spray_strength    = 9.500;
#declare spray_location    = <0.000, 0.250, 0.000>;
#declare spray_direction   = <0.000, 0.000, 1.000>;
#declare spray_loop        = true;
#declare particle_count    = 875.000;
#declare particle_life     = 1.000;
#declare particle_size     = 0.500;
#declare particle_stretch  = 1.000;
#declare particle_dist     = 1.000;
#declare particle_sep      = 0.010;
#declare particle_evporate = 0.000;
#declare nozzle_spin       = -5.000;
#declare nozzle_angle      = 30.000;
#declare nozzle_width      = 1.000;
#declare use_blob          = false;
#declare spray_gravity     = 8.000;
#declare spray_sky         = <0.000, 0.000, 1.000>;
#declare wind              = <0.000, 0.000, 0.000>;
#declare ground_plane      = false;
#declare spray_turb        = 0.500;
#declare scale_turb        = 0.000;
#declare vel_turb          = 0.000;
#declare angle_turb        = 0.000;
#declare spin_turb         = 0.000;
#declare wind_turb         = 0.000;
#declare seed_turb         = 0;
#declare time_scale        = 1.000;
#declare flow_rate         = 1.000;
#declare spray_hollow      = true;
#declare spray_material    = SmokeTexuture_1
#include "spray.inc"


#declare CSG047 = difference {
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel007 = intersection {
  object { CSG047 }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <-0.0, -163.0, 15.0>
  translate  <-1.238801, -0.498585, 9.062731>
}
#declare CSG048 = difference {
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel008 = intersection {
  object { CSG048 }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <154.380341, -156.924454, -101.686432>
  translate  <-0.867446, -0.98411, 9.237776>
}
#declare CSG049 = difference {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel009 = intersection {
  object { CSG049 }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <342.246948, -227.936813, -144.088211>
  translate  <-0.552357, -1.427382, 9.141199>
}
#declare CSG050 = difference {
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel010 = intersection {
  object { CSG050 }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <349.217468, -266.698151, -41.759964>
  translate  <0.396478, -1.474401, 8.990299>
}
#declare CSG051 = difference {
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel011 = intersection {
  object { CSG051 }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <351.965912, -170.575516, -53.489861>
  translate  <0.914124, -0.992152, 8.869578>
}
#declare CSG052 = difference {
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel012 = intersection {
  object { CSG052 }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <276.356293, -167.448807, -2.641672>
  translate  <1.352998, -0.424368, 8.929938>
}
#declare CSG053 = difference {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel013 = intersection {
  object { CSG053 }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <10.584437, -136.316071, 27.229914>
  translate  <1.161694, 0.370843, 8.839398>
}
#declare CSG054 = difference {
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel014 = intersection {
  object { CSG054 }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <10.584437, -136.316071, 102.524803>
  translate  <-1.043929, 0.528388, 8.839398>
}
union { // LoosePanels
  object { BreakPanel007 }
  object { BreakPanel008 }
  object { BreakPanel009 }
  object { BreakPanel010 }
  object { BreakPanel011 }
  object { BreakPanel012 }
  object { BreakPanel013 }
  object { BreakPanel014 }
  material {
    BrownTexture
  }
}


#declare CSG041 = difference {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel001 = intersection {
  object { CSG041 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <0.0, -15.0, 15.0>
  translate  <-1.009241, -0.269173, 9.624268>
}
#declare CSG042 = difference {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel002 = intersection {
  object { CSG042 }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <0.0, -5.0, 45.0>
  translate  <-0.720464, -0.719702, 9.624268>
}
#declare CSG043 = difference {
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel003 = intersection {
  object { CSG043 }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <0.0, -8.0, 75.0>
  translate  <-0.266357, -0.991642, 9.624268>
}
#declare CSG044 = difference {
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel004 = intersection {
  object { CSG044 }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <0.0, -3.0, -225.0>
  translate  <0.716659, -0.716834, 9.624268>
}
#declare CSG045 = difference {
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel005 = intersection {
  object { CSG045 }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <0.0, -15.0, -255.0>
  translate  <0.270708, -1.010075, 9.624268>
}
#declare CSG046 = difference {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <1.01, 1.01, 0.5>
    rotate -0.0*x
    translate  <1.005, 0.0, -0.25>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.6>
    rotate -0.0*x
    translate  <1.0, 0.0, -0.3>
  }
}
#declare BreakPanel006 = intersection {
  object { CSG046 }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.225, 0.225, 0.15>
    rotate -0.0*x
  }
  rotate <0.0, -45.0, -195.0>
  translate  <1.07443, -0.288376, 9.624268>
}
union { // FallingPanels
  object { BreakPanel001 }
  object { BreakPanel002 }
  object { BreakPanel003 }
  object { BreakPanel004 }
  object { BreakPanel005 }
  object { BreakPanel006 }
  material {
    BrownTexture
  }
}


union { // Lights
  object { Light1 }
  object { Light2 }
  object { Light3 }
  object { Light4 }
}


#declare RndCube003 = merge {
  sphere { <0.2000, 0.0750, 0.0750>, 0.0500 }
  sphere { <0.2000, -0.0750, 0.0750>, 0.0500 }
  sphere { <-0.2000, -0.0750, 0.0750>, 0.0500 }
  sphere { <-0.2000, 0.0750, 0.0750>, 0.0500 }
  sphere { <0.2000, 0.0750, -0.0750>, 0.0500 }
  sphere { <0.2000, -0.0750, -0.0750>, 0.0500 }
  sphere { <-0.2000, -0.0750, -0.0750>, 0.0500 }
  sphere { <-0.2000, 0.0750, -0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, 0.0750>, <-0.2000, 0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, -0.0750, 0.0750>, <-0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, -0.0750, -0.0750>, <-0.2000, -0.0750, -0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, -0.0750>, <-0.2000, 0.0750, -0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, -0.0750>, <0.2000, 0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, -0.0750, -0.0750>, <0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <-0.2000, -0.0750, -0.0750>, <-0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <-0.2000, 0.0750, -0.0750>, <-0.2000, 0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, 0.0750>, <0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, -0.0750>, <0.2000, -0.0750, -0.0750>, 0.0500 }
  cylinder { <-0.2000, 0.0750, -0.0750>, <-0.2000, -0.0750, -0.0750>, 0.0500 }
  cylinder { <-0.2000, 0.0750, 0.0750>, <-0.2000, -0.0750, 0.0750>, 0.0500 }
  box { <-0.2000, -0.0750, -0.1250> <0.2000, 0.0750, 0.1250> }
  box { <-0.2000, -0.1250, -0.0750> <0.2000, 0.1250, 0.0750> }
  box { <-0.2500, -0.0750, -0.0750> <0.2500, 0.0750, 0.0750> }
}
#declare Group001 = union {
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.5>
    rotate 90.0*x
    translate  0.05*z
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.05
    translate  <0.0, -0.5, 0.05>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <-0.0, -90.0, -0.0>
    translate  <0.0, -0.5, 0.05>
  }
  translate  <-0.1, -0.075, 0.0>
}
#declare Group002 = union {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    rotate 90.0*x
    translate  0.05*z
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.05
    translate  <0.0, -0.75, 0.05>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale 0.05
    translate  -0.75*y
  }
  translate  <0.1, -0.075, 0.0>
}
#declare Group005 = union {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    translate  1.0*y
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 0.01
    translate  <0.0, 1.0, 0.01>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate -90.0*x
    translate  0.01*z
  }
  translate  <-0.02, 0.1, 0.0>
}
#declare Group007 = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    translate  1.125*y
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale 0.01
    translate  <0.0, 1.125, 0.01>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.125>
    rotate -90.0*x
    translate  0.01*z
  }
  translate  <0.02, 0.1, 0.0>
}
union { // ControlBox2
  object { RndCube003 }
  object { Group001 }
  object { Group002 }
  object { Group005 }
  object { Group007 }
  material {
    GreyTexture
  }
  translate  <-3.355931, -0.25, 0.0>
}


#declare RndCube002 = merge {
  sphere { <0.0750, 0.2000, 0.0750>, 0.0500 }
  sphere { <0.0750, -0.2000, 0.0750>, 0.0500 }
  sphere { <-0.0750, -0.2000, 0.0750>, 0.0500 }
  sphere { <-0.0750, 0.2000, 0.0750>, 0.0500 }
  sphere { <0.0750, 0.2000, -0.0750>, 0.0500 }
  sphere { <0.0750, -0.2000, -0.0750>, 0.0500 }
  sphere { <-0.0750, -0.2000, -0.0750>, 0.0500 }
  sphere { <-0.0750, 0.2000, -0.0750>, 0.0500 }
  cylinder { <0.0750, 0.2000, 0.0750>, <-0.0750, 0.2000, 0.0750>, 0.0500 }
  cylinder { <0.0750, -0.2000, 0.0750>, <-0.0750, -0.2000, 0.0750>, 0.0500 }
  cylinder { <0.0750, -0.2000, -0.0750>, <-0.0750, -0.2000, -0.0750>, 0.0500 }
  cylinder { <0.0750, 0.2000, -0.0750>, <-0.0750, 0.2000, -0.0750>, 0.0500 }
  cylinder { <0.0750, 0.2000, -0.0750>, <0.0750, 0.2000, 0.0750>, 0.0500 }
  cylinder { <0.0750, -0.2000, -0.0750>, <0.0750, -0.2000, 0.0750>, 0.0500 }
  cylinder { <-0.0750, -0.2000, -0.0750>, <-0.0750, -0.2000, 0.0750>, 0.0500 }
  cylinder { <-0.0750, 0.2000, -0.0750>, <-0.0750, 0.2000, 0.0750>, 0.0500 }
  cylinder { <0.0750, 0.2000, 0.0750>, <0.0750, -0.2000, 0.0750>, 0.0500 }
  cylinder { <0.0750, 0.2000, -0.0750>, <0.0750, -0.2000, -0.0750>, 0.0500 }
  cylinder { <-0.0750, 0.2000, -0.0750>, <-0.0750, -0.2000, -0.0750>, 0.0500 }
  cylinder { <-0.0750, 0.2000, 0.0750>, <-0.0750, -0.2000, 0.0750>, 0.0500 }
  box { <-0.0750, -0.2000, -0.1250> <0.0750, 0.2000, 0.1250> }
  box { <-0.0750, -0.2500, -0.0750> <0.0750, 0.2500, 0.0750> }
  box { <-0.1250, -0.2000, -0.0750> <0.1250, 0.2000, 0.0750> }
}
union { // ControlBox1
  object { RndCube002 }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate 90.0*y
    translate  <0.1, 0.075, 0.05>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate 90.0*y
    translate  <0.1, -0.075, 0.05>
  }
  material {
    GreyTexture
  }
  translate  <3.125, -1.0, 0.0>
}


#declare RndCube001 = merge {
  sphere { <0.2000, 0.0750, 0.0750>, 0.0500 }
  sphere { <0.2000, -0.0750, 0.0750>, 0.0500 }
  sphere { <-0.2000, -0.0750, 0.0750>, 0.0500 }
  sphere { <-0.2000, 0.0750, 0.0750>, 0.0500 }
  sphere { <0.2000, 0.0750, -0.0750>, 0.0500 }
  sphere { <0.2000, -0.0750, -0.0750>, 0.0500 }
  sphere { <-0.2000, -0.0750, -0.0750>, 0.0500 }
  sphere { <-0.2000, 0.0750, -0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, 0.0750>, <-0.2000, 0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, -0.0750, 0.0750>, <-0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, -0.0750, -0.0750>, <-0.2000, -0.0750, -0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, -0.0750>, <-0.2000, 0.0750, -0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, -0.0750>, <0.2000, 0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, -0.0750, -0.0750>, <0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <-0.2000, -0.0750, -0.0750>, <-0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <-0.2000, 0.0750, -0.0750>, <-0.2000, 0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, 0.0750>, <0.2000, -0.0750, 0.0750>, 0.0500 }
  cylinder { <0.2000, 0.0750, -0.0750>, <0.2000, -0.0750, -0.0750>, 0.0500 }
  cylinder { <-0.2000, 0.0750, -0.0750>, <-0.2000, -0.0750, -0.0750>, 0.0500 }
  cylinder { <-0.2000, 0.0750, 0.0750>, <-0.2000, -0.0750, 0.0750>, 0.0500 }
  box { <-0.2000, -0.0750, -0.1250> <0.2000, 0.0750, 0.1250> }
  box { <-0.2000, -0.1250, -0.0750> <0.2000, 0.1250, 0.0750> }
  box { <-0.2500, -0.0750, -0.0750> <0.2500, 0.0750, 0.0750> }
}
#declare Group003 = union {
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    translate  -1.0*y
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.01
    translate  <0.0, -1.0, 0.01>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate 90.0*x
    translate  0.01*z
  }
  translate  <-0.15, -0.1, 0.0>
}
#declare Group004 = union {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale 0.01
    translate  -1.125*y
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.01
    translate  <0.0, -1.125, 0.01>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.125>
    rotate 90.0*x
    translate  0.01*z
  }
  translate  <-0.1, -0.1, 0.0>
}
#declare Group006 = union {
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 0.5>
    rotate 90.0*x
    translate  0.025*z
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.025
    translate  <0.0, -0.5, 0.025>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 1.0>
    rotate 90.0*y
    translate  <0.0, -0.5, 0.025>
  }
  translate  <0.1, -0.1, 0.0>
}
union { // ControlBox
  object { RndCube001 }
  object { Group003 }
  object { Group004 }
  object { Group006 }
  material {
    GreyTexture
  }
  translate  <3.625, 0.5, 0.0>
}


union { // TarGroup
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 2.0, 0.00001>
    translate  <-3.5, 2.0, 0.0>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.25, 0.00001>
    translate  <4.0, 0.75, 0.0>
  }
  material {
    TarTexture
  }
}


union { // Bunker
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 1.5, 0.00001>
    translate  0.00001*z
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <3.5, 2.0, 0.00002>
    translate  1.5*y
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.0, 0.00001>
    translate  <0.0, -0.25, 0.00001>
  }
  material {
    BunkerTexture_1
  }
}


#declare MissileNose = union {
  cone { // Cone002
    <0,0,0>, 1.0, <0,0,1>, 0.8
    scale <1.0, 1.0, 1.25>
  }
  cone { // Cone003
    <0,0,0>, 0.8, <0,0,1>, 0.5
    scale <1.0, 1.0, 1.125>
    translate  1.25*z
  }
  cone { // Cone004
    <0,0,0>, 0.5, <0,0,1>, 0.1
    scale <1.0, 1.0, 0.625>
    translate  2.375*z
  }
  material {
    NoseTexture
  }
  translate  10.0*z
}
#declare CSG001 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.1, 0.1>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.1, 0.1>
    rotate 45.0*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.1, 0.1>
    rotate -45.0*z
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.1, 0.1>
    rotate -90.0*z
  }
  translate  0.05*z
}
#declare CSG002 = intersection {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0001, 1.0001, 0.1>
  }
  object { CSG001 }
  material {
    BrassTexture
  }
  translate  1.85*z
}
#declare MissileSegment01 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      WhiteTexture
    }
    translate  1.0*z
  }
  object { CSG002 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      BrassTexture
    }
    scale <1.0001, 1.0001, 0.05>
    translate  1.75*z
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackTexture
    }
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      BrassTexture
    }
    scale <1.0001, 1.0001, 0.05>
    translate  0.25*z
  }
  translate  8.0*z
}
#declare MissileSegment03 = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackTexture
    }
    scale <1.0, 1.0, 3.0>
  }
  object { CSG009 }
  object { CSG010 }
  object { CSG011 }
  object { CSG012 }
  object { // CSG013 -> CSG012
    CSG012
    translate  -0.5*z
  }
  object { BreakRings06 }
  object { BreakRings07 }
  object { // BreakRings08 -> BreakRings07
    BreakRings07
    translate  0.4*z
  }
  translate  4.5*z
}
#declare MissileSegment05 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackTexture
    }
    scale <1.0, 1.0, 4.0>
  }
  object { CSG014 }
  object { CSG015 }
  object { CSG016 }
  object { CSG017 }
  object { // CSG018 -> CSG017
    CSG017
    translate  -0.5*z
  }
  object { BreakRings01 }
  object { BreakRings02 }
  object { BreakRings03 }
  object { BreakRings04 }
  object { // BreakRings05 -> BreakRings04
    BreakRings04
    translate  -0.5*z
  }
}
union { // Missile
  object { MissileNose }
  object { MissileSegment01 }
  cylinder { // MissileSegment02
    <0,0,1>, <0,0,0>, 1 
    material {
      StripeTexture
    }
    scale <1.0, 1.0, 0.5>
    translate  7.5*z
  }
  object { MissileSegment03 }
  cylinder { // MissileSegment04
    <0,0,1>, <0,0,0>, 1 
    material {
      StripeTexture
    }
    scale <1.0, 1.0, 0.5>
    translate  4.0*z
  }
  object { MissileSegment05 }
  translate  3.0*z
}


plane { // Plane001
  z,0
  material {
    GroundTexture_1
  }
}


#declare spray_strength    = 9.500;
#declare spray_location    = <0.000, 0.250, 0.000>;
#declare spray_direction   = <0.000, 0.000, 1.000>;
#declare spray_loop        = true;
#declare particle_count    = 875.000;
#declare particle_life     = 1.000;
#declare particle_size     = 0.500;
#declare particle_stretch  = 1.000;
#declare particle_dist     = 1.000;
#declare particle_sep      = 0.010;
#declare particle_evporate = 0.000;
#declare nozzle_spin       = 5.000;
#declare nozzle_angle      = 30.000;
#declare nozzle_width      = 1.000;
#declare use_blob          = false;
#declare spray_gravity     = 8.000;
#declare spray_sky         = <0.000, 0.000, 1.000>;
#declare wind              = <0.000, 0.000, 0.000>;
#declare ground_plane      = false;
#declare spray_turb        = 0.500;
#declare scale_turb        = 0.000;
#declare vel_turb          = 0.000;
#declare angle_turb        = 0.000;
#declare spin_turb         = 0.000;
#declare wind_turb         = 0.000;
#declare seed_turb         = 0;
#declare time_scale        = 1.000;
#declare flow_rate         = 1.000;
#declare spray_hollow      = true;
#declare spray_material    = SmokeTexuture
#include "spray.inc"


