#declare Unit = 1;
#declare Flat_Edge_Ratio = Unit*30;

#declare Side_Length = Unit;
#declare Edge_Length = Unit/Flat_Edge_Ratio;
#declare Height = Edge_Length;
#declare Flat_Length = Side_Length - Edge_Length;


//#declare Escala = 2; //Bowl
#declare Escala = 6;  //mdrnwrfr
//#declare Escala = 6;


#declare Four_Thirds = 4/3*Unit*1.025*Escala;
#declare Two_Thirds = 2/3*Unit*1.025*Escala;

#declare T1 = texture
{
        pigment
         {radial sine_wave
          turbulence 0.2
          color_map
           {
                [0.000 0.700 color rgb <1.00, 1.00, 1.00>
                             color rgb <1.00, 1.00, 1.00>]
                [0.700 0.995 color rgb <1.00, 1.00, 1.00>
                             color rgb <0.60, 0.30, 0.20>]
                [0.995 1.000 color rgb <0.60, 0.30, 0.20>
                             color rgb <1.00, 1.00, 1.00>]
           }
           frequency 70
           translate z*-Unit
        }
        normal { crackle scale 0.1 }
        finish { specular 1 }

}

#declare T2 = texture
{
        pigment
         {radial sine_wave
          turbulence 0.2
          color_map
           {
                [0.000 0.900 color rgb <0.94, 0.90, 0.80>
                             color rgb <0.90, 0.80, 0.60>]
                [0.900 0.995 color rgb <0.90, 0.80, 0.60>
                             color rgb <0.40, 0.20, 0.10>]
                [0.995 1.000 color rgb <0.40, 0.20, 0.10>
                             color rgb <1.00, 1.00, 1.00>]
           }
           frequency 70
           translate z*-Unit
        }
        normal { crackle scale 0.1 }
        finish { reflection 0.2 phong 1 phong_size 100 }

}

#declare Angle1 = 15;

#declare Base = difference
{
        union
        {
                cylinder { y*-Edge_Length y*Edge_Length Flat_Length }
                torus { Flat_Length Edge_Length }
        }
        union
        {
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate <-4/3*Unit, 0, -2/3*Unit> }
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate < 4/3*Unit, 0, -2/3*Unit> }
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate <        0, 0, -4/3*Unit> }
        }
}
      
#declare Left_Edge = difference
{
        intersection
        {
                torus { Flat_Length+Edge_Length Edge_Length }
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Flat_Length translate <4/3*Unit, 0, 2/3*Unit> }
        }
        cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate <4/3*Unit, 0, -2/3*Unit> }
} 

#declare Right_Edge = difference
{
        intersection
        {
                torus { Flat_Length+Edge_Length Edge_Length }
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Flat_Length translate <-4/3*Unit, 0, 2/3*Unit> }
        }
        cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate <-4/3*Unit, 0, -2/3*Unit> }
} 

#declare Bottom_Edge = difference
{
        intersection
        {
                torus { Flat_Length+Edge_Length Edge_Length }
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Flat_Length translate <0, 0, 4/3*Unit> }
        }
        union
        {
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate <-4/3*Unit, 0, 2/3*Unit> }
                cylinder { y*-(Edge_Length+0.1) y*(Edge_Length+0.1) Side_Length translate < 4/3*Unit, 0, 2/3*Unit> }
        }
} 

#declare Scales_Tile = union
{
        object { Base }
        object {   Left_Edge translate <-4/3*Unit, 0, -2/3*Unit> }
        object {  Right_Edge translate < 4/3*Unit, 0, -2/3*Unit> }
        object { Bottom_Edge translate <        0, 0, -4/3*Unit> }
        sphere { 0 Edge_Length translate x* Flat_Length rotate y*-Angle1 }
        sphere { 0 Edge_Length translate x*-Flat_Length rotate y* Angle1 }
        sphere { 0 Edge_Length translate x* Flat_Length rotate y*-Angle1 translate <-((4/3*Unit)-Edge_Length/1.085), 0, -((2/3*Unit)-Edge_Length/2.63)> }
        sphere { 0 Edge_Length translate x*-Flat_Length rotate y* Angle1 translate < ((4/3*Unit)-Edge_Length/1.085), 0, -((2/3*Unit)-Edge_Length/2.63)> }
        texture { T1 }
        translate y*-Edge_Length
        scale 1*Escala
}

/*
camera
{
        //location <-.91, 5, 0.26>
        //look_at <-.91, 0, 0.26> //z*Flat_Length
        //angle 2
        
        //location <-.35, 5, -0.45>
        //look_at <-.35, 0, -0.45> //z*Flat_Length
        //angle 2
        
        //location <0, 5, .3>
        //look_at <0, 0, .31> 
        //angle 60
        
        location <0, 15, -15>
        look_at <0, 0, 0> 
        angle 40
        
}

light_source { <-5, 0, -20> color rgb 1 }
light_source { <-25, 0, -2> color rgb 1 }
light_source { <0, 30, 0> color rgb 1 }

background { rgb 1 }
*/

