#include "modified metals.inc"

global_settings
{
        radiosity
        {

            pretrace_start 0.08
            pretrace_end   0.01
            count 500
            
            nearest_count 10
            error_bound 0.02
            recursion_limit 1
            
            low_error_factor 0.2
            gray_threshold 0.0
            minimum_reuse 0.015
            brightness 1
            
            adc_bailout 0.01/2
            
            //always_sample off
            save_file "mdrnwrfr.rdy"
        }        
}

#declare Nx  = -6.5;
#declare Px  =  4.5;
#declare Ny  = -0.5;
#declare Py  =  0.5;
#declare Nz  = -0.5;
#declare Pz  =  2.0;
#declare Rd  =  0.5;
#declare D1  = 0.07;
#declare Dx  =   Rd;
#declare Sl  =  1.5;

#declare Yellow_Plastic = material
{
        texture
        {
                pigment { color <1, 1, 0> }
                finish
                {
                        //ambient 0.2
                        specular 1
                        phong 1
                        phong_size 100
                        reflection 0.1
                }
        }
}

#declare Gray_Plastic = material
{
        texture
        {
                pigment { color rgb 0.3 }
                finish
                {
                        //ambient 0.2
                        specular 1
                        reflection 0.1
                }
                normal { bumps scale 0.001 }
        }
}

#declare Jag_Edge = merge
{
        cylinder { x*-D1, x*D1, Rd+D1 }
        torus { Rd+D1, D1 rotate z*90 }
        cylinder { <0, Py, Nz+(3*Rd/1.8)>, <0, Py+D1, Nz+(3*Rd/1.8)>, D1 }
        sphere { <0, Py+D1, Nz+(3*Rd/1.8)> D1 }
        cylinder { <0, Py+D1, Nz+Rd>, <0, Py+D1, Nz+(3*Rd/1.8)>, D1 } 
        box { <-D1, Py, Nz+Rd> <D1, Py+D1, Nz+(3*Rd/1.8)> }
}

#declare Jag = merge
{
        object { Jag_Edge translate z*Nz }
        object { Jag_Edge rotate y*180 translate z*Pz }
        box { <-D1, Ny-D1, Nz> <D1, Ny+D1, Pz> }
        cylinder { <0, Ny-D1, Nz>, <0, Ny-D1, Pz>, D1 }
}

#declare Jag2 = merge
{
        object { Jag_Edge translate z*Nz*1.9 }
        object { Jag_Edge rotate y*180 translate z*Pz }
        box { <-D1, Ny-D1, Nz*1.9> <D1, Ny+D1, Pz> }
        cylinder { <0, Ny-D1, Nz*1.9>, <0, Ny-D1, Pz>, D1 }
}

#declare Jag3 = merge
{
        object { Jag_Edge translate z*Nz*2.9 }
        object { Jag_Edge rotate y*180 translate z*Pz }
        box { <-D1, Ny-D1, Nz*2.9> <D1, Ny+D1, Pz> }
        cylinder { <0, Ny-D1, Nz*2.9>, <0, Ny-D1, Pz>, D1 }
}

#declare Jag4 = merge
{
        object { Jag_Edge translate z*Nz*3.5 }
        object { Jag_Edge rotate y*180 translate z*Pz }
        box { <-D1, Ny-D1, Nz*3.5> <D1, Ny+D1, Pz> }
        cylinder { <0, Ny-D1, Nz*3.5>, <0, Ny-D1, Pz>, D1 }
}

#declare Jag5 = merge
{
        object { Jag_Edge translate z*Nz*3.8 }
        object { Jag_Edge rotate y*180 translate z*Pz }
        box { <-D1, Ny-D1, Nz*3.8> <D1, Ny+D1, Pz> }
        cylinder { <0, Ny-D1, Nz*3.8>, <0, Ny-D1, Pz>, D1 }
}

#declare Slope = difference
{
        merge
        {
                difference
                {
                        cylinder { y*Ny, y*Py, Sl+Rd }
                        cylinder { y*(Ny-D1), y*(Py+D1), Sl }
                }
                torus { Sl, Rd }
        }
        merge
        {
                plane { x, 0 }
                plane { z, 0 rotate y*-53 }
        }
}

#declare Body = difference
{
        merge
        {
                box { <Nx, Ny, Nz> <Px, Py, Pz> }
                cylinder { <Nx, 0, Nz>, <Px, 0, Nz>, Rd }
                cylinder { <Nx, 0, 2.0>, <Px, 0, 2.0>, Rd }
                cylinder { <Nx, 0, -.5>, <Nx, 0, 2.0>, Rd }
                sphere { <Nx, 0, Nz> Rd }
                sphere { <Nx, 0, Pz> Rd }
                difference { merge { torus { Pz Rd } cylinder { y*Ny y*Py Pz } } plane { -x, 0 } translate x*Px }
                object { Jag translate x*-Dx*12 }
                object { Jag translate x*-Dx*11 }
                object { Jag translate x*-Dx*10 }
                object { Jag translate x*-Dx*09 }
                object { Jag translate x*-Dx*08 }
                object { Jag translate x*-Dx*07 }
                object { Jag translate x*-Dx*06 }
                object { Jag translate x*-Dx*05 }
                object { Jag translate x*-Dx*04 }
                object { Jag translate x*-Dx*03 }
                object { Jag translate x*-Dx*02 }
                object { Jag translate x*-Dx*01 }
                object { Jag translate x*-Dx*00 }
                object { Jag translate x*Dx }
                object { Jag translate x*Dx*02 }
                object { Jag translate x*Dx*03 }
                object { Jag translate x*Dx*04 }
                object { Jag2 translate x*Dx*05 }
                object { Jag3 translate x*Dx*06 }
                object { Jag4 translate x*Dx*07 }
                object { Jag5 translate x*Dx*08 }
                object { Slope /*pigment { color <1, 0, 0> }*/ translate <1.7, 0, -1*(Sl+Rd)> }
        }
        merge
        {
                //plane { x, 0 }
                box { <Nx-(Rd+D1), -D1, Nz> <Px+Rd, D1, Pz> }
                box { <Nx+Rd, 0, Nz+(Rd*2)> <Px+Rd, D1+Rd, Pz-(Rd*2)> }
                box { <Nx+Rd, D1*4, Nz+Rd> <Px+Rd, (D1*4)+Rd, Pz-Rd> }
        }
}  

#declare Lock_Wheel = difference
{
        merge
        {
                cylinder { 0, y*Rd, (Pz-Nz)-(2*(Rd+D1)) }
                #declare Count = 0;
                #while (Count < 40)
                        box { <-D1/2, 0, 0> <D1/2, Rd+D1, (Pz-Nz)-((4*Rd)+(3*D1))/2> rotate y*9*Count } 
                        #declare Count = Count + 1;
                #end
        }
        cylinder { y*Rd/2, y*Rd*2, Rd }
}

#declare Wedge = merge
{
        cylinder { z*-(Rd-(D1*4)) z*(Rd-(D1*4)) D1 }
        sphere { z*-(Rd-(D1*4)) D1 }
        sphere { z*(Rd-(D1*4)) D1 }
        scale <1, 2, 1>
        translate y*(Rd+D1)
}
#declare Screw = difference
{
        merge
        {
                cylinder { y*Rd/2 y*Rd Rd-D1}
                torus { Rd-(D1*2) D1 translate y*Rd }
                cylinder { y*Rd y*(Rd+D1) Rd-(D1*2) }
        }
        merge
        {
                object { Wedge }
                object { Wedge rotate y*90 }
        }
}        

#declare Rear_Jag1 = merge
{
        box { <-D1, Py, -Pz+(0.2+D1)> <D1, (Py+D1), Pz-(0.2+D1)> }
        cylinder { <0, (Py+D1), -Pz+(0.2+D1)> <0, (Py+D1), Pz-(0.2+D1)> D1 }
        cylinder { <0, Py, -Pz+(0.2+D1)> <0, Py+D1, -Pz+(0.2+D1)> D1 }
        cylinder { <0, Py, Pz-(0.2+D1)> <0, Py+D1, Pz-(0.2+D1)> D1 }
        sphere { <0, Py+D1, -Pz+(0.2+D1)> D1 } 
        sphere { <0, Py+D1, Pz-(0.2+D1)> D1 } 
}

#declare Rear_Jag2 = merge
{
        box { <-D1, Py, -Pz+(0.4+D1)> <D1, (Py+D1), Pz-(0.4+D1)> }
        cylinder { <0, (Py+D1), -Pz+(0.4+D1)> <0, (Py+D1), Pz-(0.4+D1)> D1 }
        cylinder { <0, Py, -Pz+(0.4+D1)> <0, Py+D1, -Pz+(0.4+D1)> D1 }
        cylinder { <0, Py, Pz-(0.4+D1)> <0, Py+D1, Pz-(0.4+D1)> D1 }
        sphere { <0, Py+D1, -Pz+(0.4+D1)> D1 } 
        sphere { <0, Py+D1, Pz-(0.4+D1)> D1 } 
}

#declare Rear_Jag3 = merge
{
        box { <-D1, Py, -Pz+(0.8+D1)> <D1, (Py+D1), Pz-(0.8+D1)> }
        cylinder { <0, (Py+D1), -Pz+(0.8+D1)> <0, (Py+D1), Pz-(0.8+D1)> D1 }
        cylinder { <0, Py, -Pz+(0.8+D1)> <0, Py+D1, -Pz+(0.8+D1)> D1 }
        cylinder { <0, Py, Pz-(0.8+D1)> <0, Py+D1, Pz-(0.8+D1)> D1 }
        sphere { <0, Py+D1, -Pz+(0.8+D1)> D1 } 
        sphere { <0, Py+D1, Pz-(0.8+D1)> D1 } 
}

#declare Rear = difference
{
        merge
        {
                torus { Pz Rd }
                cylinder { y*Ny y*Py Pz }
                object { Rear_Jag1 translate x*Rd }
                object { Rear_Jag1 rotate z*180 translate x*Rd }
                object { Rear_Jag2 translate x*Rd*2 }
                object { Rear_Jag2 rotate z*180 translate x*Rd*2 }
                object { Rear_Jag3 translate x*Rd*3 }
                object { Rear_Jag3 rotate z*180 translate x*Rd*3 }
        }
        plane { x, 0 }
}

#declare Edge = prism
{
  linear_sweep -5, 5, 4,
  <0, -Rd/2>, <-D1/4, 0>, <D1/4, 0>, <0, -Rd/2>
  rotate z*90
  texture { T_Chrome_4C }
}

#declare Blade = difference
{
        merge
        {
                object { Edge }
                box { <-5, -D1/4, 0> <5, D1/4, Pz> texture { T_Chrome_2A } }
        }
        merge
        {
                plane { x, 0 rotate y*30 translate x*-4.85 }
                cylinder { -z z*3 D1/8 rotate y*30 translate <-3.85, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <-2.85, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <-1.85, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <-0.85, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <0, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <0.85, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <1.85, D1/4, 0> }
                cylinder { -z z*3 D1/8 rotate y*30 translate <2.85, D1/4, 0> }
        }
}

background { rgb 1 }

camera
{
        //location <3.5, 20, -20>
        //look_at <0, 0, 0>
        //angle 40
        
        //location <0, 20, 1>
        //look_at <0, 0, 1>
        //angle 15
        
        location <3.5, 20, -20>
        look_at <0, 0, 0>
        angle 42
}
/*
light_source
{
        //<0, 100, 0>
        <-15, 20, -5>
        color rgb 1
        //area_light <1, 0, 0> <0, 0, 1> 4, 4 circular orient adaptive 1 jitter
        //spotlight radius 16 falloff 20 point_at x*-2
        //photons
        //{
        //        reflection on
       //         refraction on
        //}
} */


union
{ 
        object { Body material { Yellow_Plastic } }
        object { Rear material { Gray_Plastic } translate x*Px }
        object { Lock_Wheel material { Gray_Plastic } scale 0.5 translate <-Rd, (Rd/2)+D1, .75*Rd*2> }
        object { Screw texture { T_Chrome_3C } scale 0.5 translate <-Rd, (Rd/2)+D1, .75*Rd*2> } 
        object { Blade translate x*-Rd*10 }
        //rotate x*180
        translate <0, Rd+(D1*3), 1>
} 

box
{
    0, 1 
    pigment { image_map { jpeg "aa ticket.jpg" }}
    translate -.5
    rotate x*90
    scale <20, D1, 8>
    translate <0, D1, -2.2>
    rotate y*-30
    finish
    {
        //specular 1
        diffuse 1
        reflection 0.03
    }
    //normal { bozo scale 1 turbulence 2 }
}

box
{
    0, 1 
    pigment { image_map { jpeg "wtc 8.jpg" }}
    translate -.5
    rotate x*90
    scale <5, D1/8, 8>
    rotate y*-10
    translate <-8, D1/8, 4>
    finish
    {
        //specular 1
        diffuse 1
        reflection 0.03
    }
    //normal { bozo scale 1 turbulence 2 }
}

box
{
    0, 1 scale <Rd, D1, 8>
    translate <-10.4, D1+0.01, -6.2>
    rotate y*-30
    pigment { color rgb 0.8 }
}

    

//object { Blade translate y }

plane { y, 0 pigment { color rgb <0.95, 0.95, 1> } }