#include "ship_parts.inc"
#include "SCcamo.inc"

#declare R_Stars = seed(648);
#declare R = seed(348);

light_source {
   <-10, 200, -100>
   colour White
}

camera {
   location <0, 0, 0>
   look_at <0, 0, 1>
}

// Begin AlienCarrier

#declare AlienCarrierHull = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.002027, -1.529642, -0.006338>, <-0.002027, -1.529645, -0.005223>, <-0.001115, -1.529649, -0.004311>, <0.000000, -1.529649, -0.004311>, 
      <-1.000000, -1.412387, -0.014746>, <-1.000000, -1.414291, 0.535251>, <-0.550000, -1.415849, 0.985248>, <0.000000, -1.415849, 0.985248>, 
      <-1.000000, -1.554940, -0.006667>, <-1.000000, -1.556845, 0.543330>, <-0.550000, -1.558403, 0.993327>, <0.000000, -1.558403, 0.993327>, 
      <-1.000000, -0.776671, -0.004862>, <-1.000000, -0.601779, 0.544883>, <-0.550000, -0.598938, 1.006787>, <0.000000, -0.596879, 1.006055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -1.529649, -0.004311>, <0.001115, -1.529649, -0.004311>, <0.002027, -1.529645, -0.005223>, <0.002027, -1.529642, -0.006338>, 
      <0.000000, -1.415849, 0.985248>, <0.550000, -1.415849, 0.985248>, <1.000000, -1.414291, 0.535251>, <1.000000, -1.412387, -0.014746>, 
      <0.000000, -1.558403, 0.993327>, <0.550000, -1.558403, 0.993327>, <1.000000, -1.556845, 0.543330>, <1.000000, -1.554940, -0.006667>, 
      <0.000000, -0.596879, 1.006055>, <0.550000, -0.598938, 1.006787>, <1.000000, -0.601779, 0.544883>, <1.000000, -0.776671, -0.004862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.002027, -1.529642, -0.006338>, <0.002027, -1.529638, -0.007453>, <0.001115, -1.529634, -0.008383>, <0.000000, -1.529634, -0.008383>, 
      <1.000000, -1.412387, -0.014746>, <1.000000, -1.410482, -0.564742>, <1.167313, -1.408892, -1.024535>, <0.000000, -1.408892, -1.024535>, 
      <1.000000, -1.554940, -0.006667>, <1.000000, -1.553036, -0.556664>, <1.167313, -1.551445, -1.016455>, <0.000000, -1.551445, -1.016455>, 
      <1.000000, -0.776671, -0.004862>, <1.000000, -0.951550, -0.554601>, <1.167313, -0.949960, -1.014392>, <0.000000, -0.952002, -1.013684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -1.529634, -0.008383>, <-0.001115, -1.529634, -0.008383>, <-0.002027, -1.529638, -0.007453>, <-0.002027, -1.529642, -0.006338>, 
      <0.000000, -1.408892, -1.024535>, <-1.167313, -1.408892, -1.024535>, <-1.000000, -1.410482, -0.564742>, <-1.000000, -1.412387, -0.014746>, 
      <0.000000, -1.551445, -1.016455>, <-1.167313, -1.551445, -1.016455>, <-1.000000, -1.553036, -0.556664>, <-1.000000, -1.554940, -0.006667>, 
      <0.000000, -0.952002, -1.013684>, <-1.167313, -0.949960, -1.014392>, <-1.000000, -0.951550, -0.554601>, <-1.000000, -0.776671, -0.004862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-1.000000, -0.776671, -0.004862>, <-1.000000, -0.601779, 0.544883>, <-0.550000, -0.598938, 1.006787>, <0.000000, -0.596879, 1.006055>, 
      <-1.000000, 0.001611, -0.003051>, <-1.000000, 0.353286, 0.546436>, <-0.550000, 0.360528, 1.020248>, <0.000000, 0.360528, 1.020248>, 
      <-1.186499, 0.148029, -0.000810>, <-1.372998, 0.146124, 0.549187>, <-0.550000, -0.451151, 1.743960>, <0.000000, -0.451151, 1.743960>, 
      <-1.093249, 0.279763, -0.001112>, <-1.186499, 0.277859, 0.549716>, <-0.550000, -0.021557, 1.372101>, <0.000000, -0.019539, 1.371273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.596879, 1.006055>, <0.550000, -0.598938, 1.006787>, <1.000000, -0.601779, 0.544883>, <1.000000, -0.776671, -0.004862>, 
      <0.000000, 0.360528, 1.020248>, <0.550000, 0.360528, 1.020248>, <1.000000, 0.353286, 0.546436>, <1.000000, 0.001611, -0.003051>, 
      <0.000000, -0.451151, 1.743960>, <0.550000, -0.451151, 1.743960>, <1.372998, 0.146124, 0.549187>, <1.186499, 0.148029, -0.000810>, 
      <0.000000, -0.019539, 1.371273>, <0.550000, -0.021557, 1.372101>, <1.186499, 0.277859, 0.549716>, <1.093249, 0.279763, -0.001112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <1.000000, -0.776671, -0.004862>, <1.000000, -0.951550, -0.554601>, <1.167313, -0.949960, -1.014392>, <0.000000, -0.952002, -1.013684>, 
      <1.000000, 0.001611, -0.003051>, <1.000000, -0.350064, -0.552538>, <1.167313, -0.348474, -1.012328>, <0.000000, -0.348474, -1.012328>, 
      <1.186499, 0.148029, -0.000810>, <1.000000, 0.149933, -0.550807>, <1.167313, 0.151523, -1.010596>, <0.000000, 0.151523, -1.010596>, 
      <1.093249, 0.279763, -0.001112>, <1.000000, 0.281669, -0.550278>, <1.167313, 0.283259, -1.010066>, <0.000000, 0.281219, -1.010899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.952002, -1.013684>, <-1.167313, -0.949960, -1.014392>, <-1.000000, -0.951550, -0.554601>, <-1.000000, -0.776671, -0.004862>, 
      <0.000000, -0.348474, -1.012328>, <-1.167313, -0.348474, -1.012328>, <-1.000000, -0.350064, -0.552538>, <-1.000000, 0.001611, -0.003051>, 
      <0.000000, 0.151523, -1.010596>, <-1.167313, 0.151523, -1.010596>, <-1.000000, 0.149933, -0.550807>, <-1.186499, 0.148029, -0.000810>, 
      <0.000000, 0.281219, -1.010899>, <-1.167313, 0.283259, -1.010066>, <-1.000000, 0.281669, -0.550278>, <-1.093249, 0.279763, -0.001112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-1.093249, 0.279763, -0.001112>, <-1.186499, 0.277859, 0.549716>, <-0.550000, -0.021557, 1.372101>, <0.000000, -0.019539, 1.371273>, 
      <-1.000000, 0.411500, 0.000248>, <-1.000000, 0.409595, 0.550245>, <-0.550000, 0.408037, 1.000242>, <0.000000, 0.408037, 1.000242>, 
      <-0.502589, 2.985504, 0.004998>, <-0.502589, 2.984815, 0.191042>, <-0.276424, 2.984251, 0.343259>, <0.000000, 2.984251, 0.343259>, 
      <-0.197771, 0.282483, 0.001197>, <-0.197771, 0.282107, 0.109970>, <-0.108774, 0.281798, 0.198966>, <0.000000, 0.281798, 0.198966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.019539, 1.371273>, <0.550000, -0.021557, 1.372101>, <1.186499, 0.277859, 0.549716>, <1.093249, 0.279763, -0.001112>, 
      <0.000000, 0.408037, 1.000242>, <0.550000, 0.408037, 1.000242>, <1.000000, 0.409595, 0.550245>, <1.000000, 0.411500, 0.000248>, 
      <0.000000, 2.984251, 0.343259>, <0.276424, 2.984251, 0.343259>, <0.502589, 2.984815, 0.191042>, <0.502589, 2.985504, 0.004998>, 
      <0.000000, 0.281798, 0.198966>, <0.108774, 0.281798, 0.198966>, <0.197771, 0.282107, 0.109970>, <0.197771, 0.282483, 0.001197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <1.093249, 0.279763, -0.001112>, <1.000000, 0.281669, -0.550278>, <1.167313, 0.283259, -1.010066>, <0.000000, 0.281219, -1.010899>, 
      <1.000000, 0.411500, 0.000248>, <1.000000, 0.413404, -0.549749>, <1.167313, 0.414994, -1.009535>, <0.000000, 0.414994, -1.009535>, 
      <0.502589, 2.985504, 0.004998>, <0.502589, 2.986193, -0.181045>, <0.276424, 2.986756, -0.333262>, <0.000000, 2.986756, -0.333262>, 
      <0.197771, 0.282483, 0.001197>, <0.197771, 0.282860, -0.107576>, <0.108774, 0.283168, -0.196573>, <0.000000, 0.283168, -0.196573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, 0.281219, -1.010899>, <-1.167313, 0.283259, -1.010066>, <-1.000000, 0.281669, -0.550278>, <-1.093249, 0.279763, -0.001112>, 
      <0.000000, 0.414994, -1.009535>, <-1.167313, 0.414994, -1.009535>, <-1.000000, 0.413404, -0.549749>, <-1.000000, 0.411500, 0.000248>, 
      <0.000000, 2.986756, -0.333262>, <-0.276424, 2.986756, -0.333262>, <-0.502589, 2.986193, -0.181045>, <-0.502589, 2.985504, 0.004998>, 
      <0.000000, 0.283168, -0.196573>, <-0.108774, 0.283168, -0.196573>, <-0.197771, 0.282860, -0.107576>, <-0.197771, 0.282483, 0.001197>
    }
  }
  rotate x*-90
}

#macro CarrierFangs (times, opening)
   #local counter = 0;
   #while (counter<times)
      object { Fang
         scale <3.333333, 6, 3.333333>
         rotate x*opening
         translate <0, 9, -28.4>
         rotate z*(360/times)*counter
      }
      #local counter = counter+1;
   #end
#end

#declare FighterBay = union {
  cylinder { <0, 0, -1.5>, <0, 0, 1.25>, 1
    open
    hollow
  }
  difference {
    union {
      difference {
        sphere { <0, 0, 2.25>, 1.414214
          hollow
        }
        cylinder { <0, 0, 0.8>, <0, 0, 1.5>, 0.999 }
      }
      box { <2, 1.0, 0>, <-2, 3.75, 5>
        hollow
      }
    }    
    cylinder { <0, 0, 2.25>, <0, 2, 2.25>, 0.999 }
  }
  texture { Organic }
}

#macro AlienCarrier (rotation, translation, fangs)
  union {
    object { AlienCarrierHull
      scale 20
    }
    AlienEngine (5, 5, 3.5,<0, 7.07068, 30.2>, 0.2)
    AlienEngine (5, 5, 3.5,<0, -7.07068, 30.2>, 0.2)
    AlienEngine (5, 5, 3.5,<7.07068, 0, 30.2>, 0.2)
    AlienEngine (5, 5, 3.5,<-7.07068, 0, 30.2>, 0.2)
    CarrierFangs (12, fangs)
    object { FighterBay }
    object { AlienTurret
      rotate x*-20
      scale 3
      translate <0, 18.6, -15>
    }
    object { AlienTurret
      rotate x*-20
      scale 2
      translate <-6, 18.4, -13>
    }
    object { AlienTurret
      rotate x*-20
      scale 2
      translate <6, 18.4, -13>
    }
    object { AlienTurret
      rotate y*180
      scale 3
      translate <0, 19.4, 15>
    }
    object { AlienTurret
      rotate y*180
      scale 2
      translate <-6, 19.2, 13>
    }
    object { AlienTurret
      rotate y*180
      scale 2
      translate <6, 19.2, 13>
    }
    object { AlienTurret
      rotate <0, 0, 180>
      scale 2
      translate <0, -20, -6>
    }
    object { AlienTurret
      rotate <0, 180, 180>
      scale 2
      translate <0, -20, 6>
    }
    object { AlienTurret
      rotate <0, 90, 180>
      scale 2
      translate <6, -20, 0>
    }
    object { AlienTurret
      rotate <0, -90, 180>
      scale 2
      translate <-6, -20, 0>
    }
    object { AlienTurret
      rotate z*-90
      rotate y*20
      scale 2
      translate <18.6, 3, -13>
    }
    object { AlienTurret
      rotate z*-90
      rotate y*20
      scale 2
      translate <18.6, -3, -13>
    }
    object { AlienTurret
      rotate z*90
      rotate y*-20
      scale 2
      translate <-18.6, 3, -13>
    }
    object { AlienTurret
      rotate z*90
      rotate y*-20
      scale 2
      translate <-18.6, -3, -13>
    }
    object { AlienTurret
      rotate <0, 180, -90>
      scale 2
      translate <20, 3, 13>
    }
    object { AlienTurret
      rotate <0, 180, -90>
      scale 2
      translate <20, -3, 13>
    }
    object { AlienTurret
      rotate <0, 180, 90>
      scale 2
      translate <-20, 3, 13>
    }
    object { AlienTurret
      rotate<0, 180, 90>
      scale 2
      translate <-20, -3, 13>
    }
    texture { Organic scale 3 }
    rotate rotation
    translate translation
  }
#end

// End AlienCarrier

// Begin HumanFighter

#declare Body = union {
   difference {
      sphere { <0.00, 0.00, 0.00>, 1.00
         scale <1.50, 1.00, 7.0>
      }
      box { <-1.50, -1.00, -7.01>, <1.50, 1.00, -4.0> }
      sphere { <0.00, 0.00, 0.00>, 1.00
         scale<1.50 * sin( acos( -4/7 ) ), 1.00 * sin( acos( -4/7 ) ), 1.00>
         translate <0.00, 0.00, -4.00>
      } 
   }
   HumanEngine ( 1.50 * sin( acos( -4/7 ) ), 1.00 * sin( acos( -4/7 ) ), 1.00, <0.00, 0.00, -4.00>, x*180, 1.25 )
   sphere { <0.00, 0.00, 0.00>, 1.00
      scale <0.50, 0.40, 2.00>
      translate <0.00, 0.50, 4.00>
      texture { CPGlass }
   }
}

#declare Gun = union {
   cylinder { <-6.75, 0.00, -4.00>, <-6.75, 0.00, 0.00>, 0.30 }
   sphere { <-6.75, 0.00, 0.00>, 0.30 }
   difference {
      union {
         cylinder { <-6.75, 0.00, 0.00>, <-6.75, 0.00, 1.50>, 0.15 }
         cylinder { <-6.75, 0.00, 1.25>, <-6.75, 0.00, 1.50>, 0.20 }
      }
      cylinder { <-6.75, 0.00, -0.01>, <-6.75, 0.00, 1.51>, 0.10 }
      pigment { colour Gray75 }
      finish { Metal }
   }
   HumanEngine ( 0.30, 0.30, 0.50, <-6.75, 0.00, -4.00>, x*180, 2.00 )
}

#declare Wing = union {
   difference {
      box { <-6.50, -0.15, -3.00>, <0.00, 0.15, 3.00> }
      cylinder { <0.00, -0.16, 0.00>, <0.00, 0.16, 0.00>, 1.00
         scale <5.50, 1.00, 5.00>
         translate <-6.50, 0.00, 4.00>
      }
   }
   intersection {
      torus { 1.00, 0.05
         scale <5.50, 3.00, 5.00>
         translate <-6.50, 0.00, 4.00>
      }
      box { <-6.50, -0.15, -1.00>, <-1.00, 0.15, 3.50> }
   }
   cylinder { <-6.50, 0.00, -3.00>, <0.00, 0.00, -3.00>, 0.15 }
   object { Gun }
}

#declare HumanFighter = union {
   object { Body }
   object { Wing }
   object { Wing rotate z*180 }
   texture { Camouflage scale 1.50 }
}

// End HumanFighter

// Begin AlienFigher

#declare AlienFighterHull = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.747790, -4.523549, 0.015826>, <0.746187, -4.520350, 1.427399>, <2.770604, -4.520350, 1.299176>, <2.770604, -4.523549, -0.048287>, 
      <-4.027591, -2.556063, -0.039738>, <-4.027591, -2.554740, 1.959991>, <2.741528, -2.455842, 1.959991>, <2.741528, -2.457165, -0.039740>, 
      <2.999116, 6.994215, -0.011703>, <2.993462, 6.990692, -0.015325>, <2.741528, -0.542364, 1.450575>, <2.730322, -0.538004, -0.017324>, 
      <0.487796, 2.524135, -0.016142>, <0.482168, 2.514306, 0.242407>, <2.117007, 3.508441, 0.712681>, <2.114205, 3.507877, -0.021196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <2.770604, -4.523549, -0.048287>, <2.770604, -4.526749, -1.395750>, <0.749392, -4.526749, -1.395747>, <0.747790, -4.523549, 0.015826>, 
      <2.741528, -2.457165, -0.039740>, <2.741528, -2.458487, -2.039470>, <-4.027591, -2.557386, -2.039467>, <-4.027591, -2.556063, -0.039738>, 
      <2.730322, -0.538004, -0.017324>, <2.719117, -0.533644, -1.485222>, <3.004770, 6.997738, -0.008082>, <2.999116, 6.994215, -0.011703>, 
      <2.114205, 3.507877, -0.021196>, <2.111404, 3.507313, -0.755072>, <0.493424, 2.533964, -0.274692>, <0.487796, 2.524135, -0.016142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.487796, 2.524135, -0.016142>, <0.482168, 2.514306, 0.242407>, <2.117007, 3.508441, 0.712681>, <2.114205, 3.507877, -0.021196>, 
      <-2.023524, -1.945945, -0.020581>, <-2.029127, -1.962080, 0.500140>, <1.492485, 7.559246, -0.025213>, <1.498088, 7.553758, -0.025067>, 
      <-1.501287, 7.543185, -0.033298>, <-1.497887, 7.548672, -0.033445>, <1.969239, -1.963530, 0.499852>, <1.974838, -1.945919, -0.021388>, 
      <-2.116565, 3.501068, -0.024349>, <-2.109470, 3.501330, 0.708625>, <-0.514583, 2.520090, 0.242520>, <-0.508995, 2.530657, -0.016502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <2.114205, 3.507877, -0.021196>, <2.111404, 3.507313, -0.755072>, <0.493424, 2.533964, -0.274692>, <0.487796, 2.524135, -0.016142>, 
      <1.498088, 7.553758, -0.025067>, <1.503691, 7.548270, -0.024921>, <-2.017921, -1.929811, -0.541301>, <-2.023524, -1.945945, -0.020581>, 
      <1.974838, -1.945919, -0.021388>, <1.980437, -1.928307, -0.542628>, <-1.504687, 7.537697, -0.033150>, <-1.501287, 7.543185, -0.033298>, 
      <-0.508995, 2.530657, -0.016502>, <-0.503406, 2.541224, -0.275523>, <-2.123660, 3.500807, -0.757323>, <-2.116565, 3.501068, -0.024349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-2.116565, 3.501068, -0.024349>, <-2.109470, 3.501330, 0.708625>, <-0.514583, 2.520090, 0.242520>, <-0.508995, 2.530657, -0.016502>, 
      <-2.731843, -0.541048, -0.015400>, <-2.721054, -0.546013, 1.450694>, <-2.998406, 7.003710, -0.014813>, <-2.992828, 7.007233, -0.011616>, 
      <-2.724815, -2.467441, -0.030036>, <-2.724812, -2.466118, 1.969693>, <3.945694, -2.467425, 1.969693>, <3.945690, -2.468747, -0.030038>, 
      <-2.752393, -4.512120, -0.050426>, <-2.752390, -4.500121, 1.292342>, <-0.734384, -4.501441, 1.420566>, <-0.732785, -4.513440, 0.013685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.508995, 2.530657, -0.016502>, <-0.503406, 2.541224, -0.275523>, <-2.123660, 3.500807, -0.757323>, <-2.116565, 3.501068, -0.024349>, 
      <-2.992828, 7.007233, -0.011616>, <-2.987250, 7.010756, -0.008418>, <-2.742633, -0.536083, -1.481495>, <-2.731843, -0.541048, -0.015400>, 
      <3.945690, -2.468747, -0.030038>, <3.945686, -2.470070, -2.029768>, <-2.724819, -2.468764, -2.029765>, <-2.724815, -2.467441, -0.030036>, 
      <-0.732785, -4.513440, 0.013685>, <-0.731186, -4.525440, -1.393197>, <-2.752397, -4.524119, -1.393194>, <-2.752393, -4.512120, -0.050426>
    }
  }
  rotate x*-90
}

#declare AFCockpit = sphere { <0, 0, 0>, 1
    texture {
      gradient z
      texture_map {
        [ 0.0 Organic ]
        [ 0.2 Organic ]
        [ 0.85 CPGlass ]
        [ 1.0 CPGlass ]
      }
    }
    translate <0, -.05, -2.75>
    scale <1.1, .26, 1.1>
}

#declare AlienFighter = union {
  object { AlienFighterHull
    no_shadow
  }
  object { AFCockpit }
  object { HAlienGun
    scale 0.75
    translate <1.5, -.05, -3.5>
  }
  object { HAlienGun
    scale 0.75
    translate <-1.5, -.05, -3.5>
  }
  object { VAlienGun
    translate <0, 0.85, -1.5>
  }
  object { VAlienGun
    rotate <180, 180, 0>
    translate <0, -0.95, -1.5>
  }
  AlienEngine (1,1,1,<1.7, -.05, 4.5>, 1)
  AlienEngine (1,1,1,<-1.7, -.05, 4.5>, 1)
  texture { Organic }
}

// End AlienFighter

// Begin Laser Media
#macro LaserMedia ( size, rotation )
   interior {
      media {
         emission 1
         intervals 30
         density {
            wood
            turbulence 0.5
            density_map {
               [0.00 colour rgb <0.0, 0.0, 0.0> ]
               [0.15 colour rgb <0.8, 0.2, 0.0> ]
               [0.30 colour rgb <1.5, 0.5, 0.0> ]
               [0.40 colour rgb <2.0, 1.5, 1.0> ]
               [0.60 colour rgb <2.0, 1.5, 1.0> ]
               [0.70 colour rgb <1.5, 0.5, 0.0> ]
               [0.85 colour rgb <0.8, 0.2, 0.0> ]
               [1.00 colour rgb <0.0, 0.0, 0.0> ]
            }
            scale size*2
            translate y*size
            rotate z*rotation.z
         }
      }
   }
#end
// End Laser Media

// Begin Explosion
#declare Explosion = sphere { <0, 0, 0>, 1
  hollow
  pigment { colour rgbt <1,1,1,1> }
  interior {
    media {
      emission 1
      intervals 50
      density {
        spherical
        density_map {
          [0.00 colour Black]
          [0.10 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.90 colour Orange*0.50 ]
                  [0.95 colour Orange ]
                  [1.00 colour Yellow]
                }
                scale .6
                turbulence 1.0
                phase clock
          ]
          [0.30 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*0.50]
                  [0.90 colour Orange]
                  [0.95 colour Yellow]
                  [1.00 colour Yellow*2.00]
                }
                scale .5
                turbulence 1.0
                phase clock
          ]
          [0.40 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange]
                  [0.90 colour Orange*2.00]
                  [0.95 colour Yellow*2.00]
                  [1.00 colour Yellow*4.00]
                }
                scale .4
                turbulence 1.0
                phase clock
          ]
          [0.50 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*2.00]
                  [0.90 colour Orange*4.00]
                  [0.95 colour Yellow*4.00]
                  [1.00 colour White*4.00]
                }
                scale .4
                turbulence 1.0
                phase clock
          ]
          [1.00 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*2.00]
                  [0.90 colour Orange*4.00]
                  [0.95 colour Yellow*4.00]
                  [1.00 colour White*4.00]
                }
                scale .4
                turbulence 1.0
                phase clock
          ]
        }
        scale 1.80 
        turbulence 0.2
      }
      density {
         spherical
         turbulence 0.2
         colour_map {
            [ 0.00 colour rgb <0.00, 0.00, 0.00> ]
            [ 0.15 colour rgb <0.35, 0.35, 0.35> ]
            [ 0.50 colour rgb <1.00, 1.00, 1.00> ]
            [ 1.00 colour rgb <1.00, 1.00, 1.00> ]
         }
         scale 2.00
      }
    }
  }
  scale 2.00
}
// End Explosion

// Begin Destroyed Fighter
#declare Scorching = texture {
   pigment {
      bozo
      turbulence 0.4
      colour_map {
         [ 0.00 colour rgbt <0.00, 0.00, 0.00, 0.00> ]
         [ 0.05 colour rgbt <0.35, 0.28, 0.22, 0.00> ]
         [ 0.10 colour rgbt <0.59, 0.41, 0.31, 0.10> ]
         [ 0.15 colour rgbt <0.86, 0.58, 0.44, 0.30> ]
         [ 0.25 colour rgbt <0.86, 0.58, 0.44, 1.00> ]
         [ 0.30 colour rgbt <1.00, 1.00, 1.00, 1.00> ]
         [ 1.00 colour rgbt <1.00, 1.00, 1.00, 1.00> ]
      }
   }
}

#declare Ftr_Explosion = sphere { <0, 0, 0>, 7
  hollow
  pigment { colour rgbt <1,1,1,1> }
  interior {
    media {
      emission 1
      intervals 50
      density {
        spherical
        density_map {
          [0.00 colour Black]
          [0.10 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.90 colour Orange*.25*0.5]
                  [0.95 colour Orange*.5*0.5]
                  [1.00 colour Yellow*.5*0.5]
                }
                scale .6
                turbulence 1.0
                phase clock
          ]
          [0.30 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*.25*0.5]
                  [0.90 colour Orange*.5*0.5]
                  [0.95 colour Yellow*.5*0.5]
                  [1.00 colour Yellow*0.5]
                }
                scale .5
                turbulence 1.0
                phase clock
          ]
          [0.40 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*.5*0.5]
                  [0.90 colour Orange*0.5]
                  [0.95 colour Yellow*0.5]
                  [1.00 colour Yellow*2*0.5]
                }
                scale .4
                turbulence 1.0
                phase clock
          ]
          [0.50 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*0.5]
                  [0.90 colour Orange*2*0.5]
                  [0.95 colour Yellow*2*0.5]
                  [1.00 colour White*2*0.5]
                }
                scale .4
                turbulence 1.0
                phase clock
          ]
          [1.00 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*0.5]
                  [0.90 colour Orange*2*0.5]
                  [0.95 colour Yellow*2*0.5]
                  [1.00 colour White*2*0.5]
                }
                scale .4
                turbulence 1.0
                phase clock
          ]
        }
        scale 6.5
        turbulence 0.2
      }
    }
  }
}

#declare Gun_Debris = union {
   cylinder { <-6.75, 0.00, -4.00>, <-6.75, 0.00, 0.00>, 0.30 }
   sphere { <-6.75, 0.00, 0.00>, 0.30 }
   difference {
      union {
         cylinder { <-6.75, 0.00, 0.00>, <-6.75, 0.00, 1.50>, 0.15 }
         cylinder { <-6.75, 0.00, 1.25>, <-6.75, 0.00, 1.50>, 0.20 }
      }
      cylinder { <-6.75, 0.00, -0.01>, <-6.75, 0.00, 1.51>, 0.10 }
      pigment { colour Gray75 }
      finish { Metal }
   }
}

#declare Wing_Debris = union {
   difference {
      box { <-6.50, -0.15, -3.00>, <0.00, 0.15, 3.00> }
      cylinder { <0.00, -0.16, 0.00>, <0.00, 0.16, 0.00>, 1.00
         scale <5.50, 1.00, 5.00>
         translate <-6.50, 0.00, 4.00>
      }
   }
   intersection {
      torus { 1.00, 0.05
         scale <5.50, 3.00, 5.00>
         translate <-6.50, 0.00, 4.00>
      }
      box { <-6.50, -0.15, -1.00>, <-1.00, 0.15, 3.50> }
   }
   cylinder { <-6.50, 0.00, -3.00>, <0.00, 0.00, -3.00>, 0.15 }
   object { Gun_Debris }
}

#declare Fighter_Debris = union {
   difference {
      object { Wing_Debris }
      box { <-1.50, -0.50, -4.00>, <0.00, 0.50, 4.00> }
      #declare i = 0;
      #while ( i < 10 )
         box { <0.00+(rand(R)-0.5)*2.0, -0.50, -4.00+(rand(R)-0.5)*2.0>, <2.00+(rand(R)-0.5)*2.0, 0.50, 1.00+(rand(R)-0.5)*2.0>
            rotate y*( rand(R)*320 + 20 )
         }
         #declare i = i + 1;
      #end 
      rotate z*180
      rotate y*-70
      rotate x*-45
      translate <-0.75, 0.75, 0.75>
      texture { Camouflage scale 1.50 }
      texture { Scorching
         scale 1.50
         translate <1.55, 3.49, 1.37>
      }
   }
   
   difference {
      object { Wing_Debris }
      box { <-2.50, -0.50, -4.00>, <0.00, 0.50, 4.00> }
      #declare i = 0;
      #while ( i < 10 )
         box { <0.00+(rand(R)-0.5)*2.0, -0.50, -4.00+(rand(R)-0.5)*2.0>, <2.00+(rand(R)-0.5)*2.0, 0.50, 1.00+(rand(R)-0.5)*2.0>
            rotate y*( rand(R)*320 + 20 )
         }
         #declare i = i + 1;
      #end 
      rotate y*-103
      rotate x*-20
      translate <-1.0, -1.0, 0.75>
      texture { Camouflage scale 1.50 }
      texture { Scorching
         scale 1.50
         translate <1.75, 3.87, 1.08>
      }
   }
   
   #declare i = 0;
   #while ( i < 5 )
      #declare x1 = rand(R)*0.50+0.25;
      #declare x2 = rand(R)*0.50+0.25;
      union {
         box { <-x1, 0.01, -0.05>, <x2, 0.02, 0.05> }
         box { <-x1, -0.01, -0.02>, <x2, 0.01, 0.02> }
         box { <-x1, -0.02, -0.05>, <x2, -0.01, 0.05> }
         scale 4+rand(R)
         rotate <rand(R)*360, rand(R)*360 rand(R)*360>
         translate <( rand(R)-0.5 )*5 - 1.5, ( rand(R)-0.5 )*5, ( rand(R)-0.5 )*5>
         texture { Camouflage scale 0.75 }
         texture { Scorching }
      }
      #declare i = i + 1;
   #end
      
   difference {
      sphere { <0.00, 0.00, 0.00>, 1.00
         scale <1.50, 1.00, 7.0>
      }      
      sphere { <0.00, 0.00, 0.00>, 1.00
         scale <1.30, 0.20, 6.80>
         pigment { colour Gray75 }
         finish { Metal }
      }
      box { <-1.51, -1.01, -7.01>, <1.51, 1.01, 5.00> }
      rotate <0, -120, 20>
      translate <0.5, 0.5, 1.00>
      texture { Camouflage scale 1.50 }
      texture { Scorching
         scale 1.50
         translate <4.38, 4.76, 4.27>
      }
   }
}         

#declare Destroyed_Fighter = union {
   object { Ftr_Explosion }
   object { Fighter_Debris }
}
// End Destroyed Fighter

// Begin Green_Glow
#declare Green_Glow = interior {
  media {
    emission 1
    intervals 30
    density {
      spherical
      turbulence 1
      colour_map {
        [0.00 colour rgb <0.4, 0.8, 0.4>*2]
        [0.20 colour rgb <0.1, 0.4, 0.1>*2]
        [0.70 colour rgb <0, 0, 0>]
        [1.00 colour rgb <0, 0, 0>]
      }
      translate <3.5, 0, 0>
    }
  }
}
// End Green_Glow

// Begin Plasma_Shot
#macro Plasma_Shot (xscale, yscale, zscale, translation1, rotation1, translation2)
  union {
    light_source {
      <.25, 0, 0>
      colour rgb <0.5, 1.0, 0.5>
      fade_distance 1*((xscale+yscale+zscale)/3)
      fade_power 3
    }
    merge {
      cone { <0, 0, 0>, 1, <4, 0, 0>, 0.25 }
      sphere { <0, 0, 0>, 1 }
      hollow
      pigment { colour rgbt <1,1,1,1> }
      interior { Green_Glow }
      rotate y*-90
      scale <xscale, yscale, zscale>
    }
    translate translation1
    rotate rotation1
    translate translation2
  }
#end
// End Plasma_Shot

// Carrier
AlienCarrier ( <-10, 30, 0>, <-30, -30, 125>, 25 )

// Fighter being launched. (AF1)
object { AlienFighter
   scale 1.5
   translate <0, 0, -40>
   rotate <-10, 30, 0>
   translate <-30, -30, 125>
}

// Fighter firing on carrier, near camera (HF1)
object { HumanFighter
   rotate <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi, 25>
   translate <5, -7, 25>
}

union {
   cylinder { <-6.75, 0.00, 1.50>, <-6.75, 0.00, 500>, 0.20 
      hollow
      pigment { colour rgbt <1,1,1,1> }
      LaserMedia( 0.20, <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi - 90, 25> )
   }
   light_source {
      <-6.75, 0.00, 1.75>
      colour rgb <1.5, 0.5, 0.0>
      fade_distance 1.0
      fade_power 3.0
   }
   rotate <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi, 25>
   translate <5, -7, 25>
}

object { Explosion
   rotate <189.3, 20.3, 239.2> 
   translate vrotate(<-6.75, 0.00, 80.0>, <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi, 25>) + <5, -7, 25>
}

union {
   cylinder { <6.75, 0.00, 1.50>, <6.75, 0.00, 500>, 0.20
      hollow
      pigment { colour rgbt <1,1,1,1> }
      LaserMedia( 0.20, <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi - 90, 25> )
   }
   light_source {
      <6.75, 0.00, 1.75>
      colour rgb <1.5, 0.5, 0.0>
      fade_distance 1.0
      fade_power 3.0
   }
   rotate <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi, 25>
   translate <5, -7, 25>
}

object { Explosion
   rotate <024.3, 310.7, 211.7>
   translate vrotate(<6.75, 0.00, 85.0>, <atan2(23,100)*180/pi - 15, -atan2(35,100)*180/pi, 25>) + <5, -7, 25>
}
                                       
// end of shots
 
// Fighter firing on carrier, far away (HF2)
object { HumanFighter
   rotate <atan2(30,25)*180/pi - 15, -atan2(45,25)*180/pi - 180, 0>
   translate <-75, 0, 150>
}

cylinder { <-6.75, 0.00, 1.50>, <-6.75, 0.00, 60>, 0.20
   rotate <atan2(30,25)*180/pi - 15, -atan2(45,25)*180/pi - 180, 0>
   translate <-75, 0, 150>
   hollow
   pigment { colour rgbt <1,1,1,1> }
   LaserMedia( 0.20, <atan2(30,25)*180/pi - 15, -atan2(45,25)*180/pi - 180 - 90, 0> )
}

cylinder { <6.75, 0.00, 1.50>, <6.75, 0.00, 60>, 0.20
   rotate <atan2(30,25)*180/pi - 15, -atan2(45,25)*180/pi - 180, 0>
   translate <-75, 0, 150>
   hollow
   pigment { colour rgbt <1,1,1,1> }
   LaserMedia( 0.20, <atan2(30,25)*180/pi - 15, -atan2(45,25)*180/pi - 180 - 90, 0> )
}                                       
// end of shots

// Fighter firing on HF2 (AF2)
object { AlienFighter
   rotate <-atan2(15, 50)*180/pi - 0, -atan2(50, 50)*180/pi - 190, 0>
   translate <-25, 15, 100>
}

#declare i = -1;
#while ( i > -170 )
   Plasma_Shot( 0.40*0.75*1.50, 0.40*0.50*0.75*1.50, 0.40*0.75*1.50, <1.5, -0.5, -3.5>*1.5 + z*i,
      <-atan2(15, 50)*180/pi - 0 - (i+1)/15, -atan2(50, 50)*180/pi - 190 + (i+1)/15, 0>, <-25, 15, 100> )
   Plasma_Shot( 0.40*0.75*1.50, 0.40*0.50*0.75*1.50, 0.40*0.75*1.50, <-1.5, -0.5, -3.5>*1.5 + z*i,
      <-atan2(15, 50)*180/pi - 0 - (i+1)/15, -atan2(50, 50)*180/pi - 190 + (i+1)/15, 0>, <-25, 15, 100> )
   Plasma_Shot( 0.40*1.50, 0.40*0.50*1.50, 0.40*1.50, <0, 0.85, -1.5>*1.5 + z*(i-7.5),
      <-atan2(15, 50)*180/pi - 0 - (i+1)/15, -atan2(50, 50)*180/pi - 190 + (i+1)/15, 0>, <-25, 15, 100> )
   Plasma_Shot( 0.40*1.50, 0.40*0.50*1.50, 0.40*1.50, <0, -0.95, -1.5>*1.5 + z*(i-7.5),
      <-atan2(15, 50)*180/pi - 0 - (i+1)/15, -atan2(50, 50)*180/pi - 190 + (i+1)/15, 0>, <-25, 15, 100> )
   #declare i = i - 15;
#end
// end of shots

// Destroyed Fighter
object { Destroyed_Fighter
   translate <5.00, 5.00, 35.0>
}
// end of Destroyed Fighter

// Fighter firing on Destroyed Fighter (AF3)
object { AlienFighter
   scale 1.5
   rotate <-atan2(15, 40) * 180/pi + 1, -atan2(25, 40) * 180/pi, 0>
   translate <-20.0, 20.0, 75.0>
}

#declare i = -15;
#while ( i > -81 )
   Plasma_Shot( 0.40*0.75*1.50, 0.40*0.50*0.75*1.50, 0.40*0.75*1.50, <1.5, -0.5, -3.5>*1.5 + z*i,
      <-atan2(15, 40) * 180/pi + 1, -atan2(25, 40) * 180/pi, 0>, <-20, 20.0, 75.0> )
   Plasma_Shot( 0.40*0.75*1.50, 0.40*0.50*0.75*1.50, 0.40*0.75*1.50, <-1.5, -0.5, -3.5>*1.5 + z*i,
      <-atan2(15, 40) * 180/pi + 1, -atan2(25, 40) * 180/pi, 0>, <-20, 20.0, 75.0> )
   Plasma_Shot( 0.40*1.50, 0.40*0.50*1.50, 0.40*1.50, <0, 0.85, -1.5>*1.5 + z*(i-7.5),
      <-atan2(15, 40) * 180/pi + 1, -atan2(25, 40) * 180/pi, 0>, <-20, 20.0, 75.0> )
   Plasma_Shot( 0.40*1.50, 0.40*0.50*1.50, 0.40*1.50, <0, -0.95, -1.5>*1.5 + z*(i-7.5),
      <-atan2(15, 40) * 180/pi + 1, -atan2(25, 40) * 180/pi, 0>, <-20, 20.0, 75.0> )
   #declare i = i - 15;
#end
// end of shots

// Fighters in formation, upper left corner.
union {
   object { HumanFighter }
   object { HumanFighter
      translate <11.0, 0.00, -12.0>
   }
   object { HumanFighter
      translate <-11.0, 0.00, -12.0>
   }
   rotate z*-40
   rotate <35, -240, 0>
   translate <-75.0, 60.0, 175>
}
// end of fighters

// Nebula in upper right
sphere { <0, 0, 0>, 1
   scale <8.00, 3.00, 2.25>
   rotate z*-30
   rotate x*-30
   rotate y*10
   translate <8.75, 6.75, 20>
   hollow
   no_shadow
   pigment { colour rgbt <1, 1, 1, 1> }
   interior {
      media {
         emission 1
         intervals 30
         density {
            average
            density_map {
               [
                  bozo
                  turbulence 1.0
                  colour_map {
                     [ 0.00 colour rgb <1.0, 0.7, 0.7>*0.5 ]
                     [ 0.10 colour rgb <1.0, 0.5, 0.5>*0.5 ]
                     [ 0.20 colour rgb <0.8, 0.2, 0.2>*0.5 ]
                     [ 0.40 colour rgb <0.5, 0.0, 0.0>*0.5 ]
                     [ 0.80 colour rgb <0.0, 0.0, 0.0> ]
                     [ 1.00 colour rgb <0.0, 0.0, 0.0> ]
                  }
                  rotate <17.8, 302, 211>
                  scale 4
               ]
               [
                  bozo
                  turbulence 1.0
                  colour_map {
                     [ 0.00 colour rgb <0.7, 0.7, 1.0>*0.5 ]
                     [ 0.10 colour rgb <0.5, 0.5, 1.0>*0.5 ]
                     [ 0.20 colour rgb <0.2, 0.2, 0.8>*0.5 ]
                     [ 0.40 colour rgb <0.0, 0.0, 0.5>*0.5 ]
                     [ 0.80 colour rgb <0.0, 0.0, 0.0> ]
                     [ 1.00 colour rgb <0.0, 0.0, 0.0> ]
                  }
                  rotate <188, 44.8, 38.5>
                  scale 4
               ]
            }
         }
         density {
            spherical
            turbulence 0.1
            colour_map {
               [ 0.00 colour rgb <0.00, 0.00, 0.00> ]
               [ 0.15 colour rgb <0.35, 0.35, 0.35> ]
               [ 0.50 colour rgb <1.00, 1.00, 1.00> ]
               [ 1.00 colour rgb <1.00, 1.00, 1.00> ]
            }
            scale <8.00, 3.00, 2.25>
            rotate z*-30
            rotate x*-30
            rotate y*10
            translate <8.75, 6.75, 20>
         }         
      }
   }
}

// this to block stars behind the nebula
cylinder { <0.00, 0.00, 0.00>, <0.00, 0.00, 0.01>, 1.00
   scale <7.50, 2.50, 2.00>
   rotate z*-26
   translate <11.5, 8.18, 25>
   pigment { colour Black }
   finish { ambient 1 }
}

// end of nebula

// Bright_Stars
#declare i = 0;
#while ( i < 40 )
   Bright_Star ( <1700*( rand(R_Stars)-0.5 ), 1300*( rand(R_Stars)-0.5 ), 1200 + 200*rand(R_Stars)>, rand(R_Stars)*60, rand(R_Stars) )
   #declare i = i + 1;
#end

Stars( )